# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AzureFunctionEventSubscriptionDestinationResponse',
    'BoolEqualsAdvancedFilterResponse',
    'ConnectionStateResponse',
    'DeadLetterWithResourceIdentityResponse',
    'DeliveryWithResourceIdentityResponse',
    'DynamicDeliveryAttributeMappingResponse',
    'EventChannelDestinationResponse',
    'EventChannelFilterResponse',
    'EventChannelSourceResponse',
    'EventHubEventSubscriptionDestinationResponse',
    'EventSubscriptionFilterResponse',
    'EventSubscriptionIdentityResponse',
    'ExtendedLocationResponse',
    'HybridConnectionEventSubscriptionDestinationResponse',
    'IdentityInfoResponse',
    'InboundIpRuleResponse',
    'IsNotNullAdvancedFilterResponse',
    'IsNullOrUndefinedAdvancedFilterResponse',
    'JsonFieldResponse',
    'JsonFieldWithDefaultResponse',
    'JsonInputSchemaMappingResponse',
    'NumberGreaterThanAdvancedFilterResponse',
    'NumberGreaterThanOrEqualsAdvancedFilterResponse',
    'NumberInAdvancedFilterResponse',
    'NumberInRangeAdvancedFilterResponse',
    'NumberLessThanAdvancedFilterResponse',
    'NumberLessThanOrEqualsAdvancedFilterResponse',
    'NumberNotInAdvancedFilterResponse',
    'NumberNotInRangeAdvancedFilterResponse',
    'PrivateEndpointConnectionResponse',
    'PrivateEndpointResponse',
    'ResourceSkuResponse',
    'RetryPolicyResponse',
    'ServiceBusQueueEventSubscriptionDestinationResponse',
    'ServiceBusTopicEventSubscriptionDestinationResponse',
    'StaticDeliveryAttributeMappingResponse',
    'StorageBlobDeadLetterDestinationResponse',
    'StorageQueueEventSubscriptionDestinationResponse',
    'StringBeginsWithAdvancedFilterResponse',
    'StringContainsAdvancedFilterResponse',
    'StringEndsWithAdvancedFilterResponse',
    'StringInAdvancedFilterResponse',
    'StringNotBeginsWithAdvancedFilterResponse',
    'StringNotContainsAdvancedFilterResponse',
    'StringNotEndsWithAdvancedFilterResponse',
    'StringNotInAdvancedFilterResponse',
    'SystemDataResponse',
    'UserIdentityPropertiesResponse',
    'WebHookEventSubscriptionDestinationResponse',
]

@pulumi.output_type
class AzureFunctionEventSubscriptionDestinationResponse(dict):
    """
    Information about the azure function destination for an event subscription.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointType":
            suggest = "endpoint_type"
        elif key == "deliveryAttributeMappings":
            suggest = "delivery_attribute_mappings"
        elif key == "maxEventsPerBatch":
            suggest = "max_events_per_batch"
        elif key == "preferredBatchSizeInKilobytes":
            suggest = "preferred_batch_size_in_kilobytes"
        elif key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureFunctionEventSubscriptionDestinationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureFunctionEventSubscriptionDestinationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureFunctionEventSubscriptionDestinationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_type: str,
                 delivery_attribute_mappings: Optional[Sequence[Any]] = None,
                 max_events_per_batch: Optional[int] = None,
                 preferred_batch_size_in_kilobytes: Optional[int] = None,
                 resource_id: Optional[str] = None):
        """
        Information about the azure function destination for an event subscription.
        :param str endpoint_type: Type of the endpoint for the event subscription destination.
               Expected value is 'AzureFunction'.
        :param Sequence[Union['DynamicDeliveryAttributeMappingResponse', 'StaticDeliveryAttributeMappingResponse']] delivery_attribute_mappings: Delivery attribute details.
        :param int max_events_per_batch: Maximum number of events per batch.
        :param int preferred_batch_size_in_kilobytes: Preferred batch size in Kilobytes.
        :param str resource_id: The Azure Resource Id that represents the endpoint of the Azure Function destination of an event subscription.
        """
        pulumi.set(__self__, "endpoint_type", 'AzureFunction')
        if delivery_attribute_mappings is not None:
            pulumi.set(__self__, "delivery_attribute_mappings", delivery_attribute_mappings)
        if max_events_per_batch is None:
            max_events_per_batch = 1
        if max_events_per_batch is not None:
            pulumi.set(__self__, "max_events_per_batch", max_events_per_batch)
        if preferred_batch_size_in_kilobytes is None:
            preferred_batch_size_in_kilobytes = 64
        if preferred_batch_size_in_kilobytes is not None:
            pulumi.set(__self__, "preferred_batch_size_in_kilobytes", preferred_batch_size_in_kilobytes)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> str:
        """
        Type of the endpoint for the event subscription destination.
        Expected value is 'AzureFunction'.
        """
        return pulumi.get(self, "endpoint_type")

    @property
    @pulumi.getter(name="deliveryAttributeMappings")
    def delivery_attribute_mappings(self) -> Optional[Sequence[Any]]:
        """
        Delivery attribute details.
        """
        return pulumi.get(self, "delivery_attribute_mappings")

    @property
    @pulumi.getter(name="maxEventsPerBatch")
    def max_events_per_batch(self) -> Optional[int]:
        """
        Maximum number of events per batch.
        """
        return pulumi.get(self, "max_events_per_batch")

    @property
    @pulumi.getter(name="preferredBatchSizeInKilobytes")
    def preferred_batch_size_in_kilobytes(self) -> Optional[int]:
        """
        Preferred batch size in Kilobytes.
        """
        return pulumi.get(self, "preferred_batch_size_in_kilobytes")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        The Azure Resource Id that represents the endpoint of the Azure Function destination of an event subscription.
        """
        return pulumi.get(self, "resource_id")


@pulumi.output_type
class BoolEqualsAdvancedFilterResponse(dict):
    """
    BoolEquals Advanced Filter.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "operatorType":
            suggest = "operator_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BoolEqualsAdvancedFilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BoolEqualsAdvancedFilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BoolEqualsAdvancedFilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operator_type: str,
                 key: Optional[str] = None,
                 value: Optional[bool] = None):
        """
        BoolEquals Advanced Filter.
        :param str operator_type: The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
               Expected value is 'BoolEquals'.
        :param str key: The field/property in the event based on which you want to filter.
        :param bool value: The boolean filter value.
        """
        pulumi.set(__self__, "operator_type", 'BoolEquals')
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="operatorType")
    def operator_type(self) -> str:
        """
        The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
        Expected value is 'BoolEquals'.
        """
        return pulumi.get(self, "operator_type")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The field/property in the event based on which you want to filter.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[bool]:
        """
        The boolean filter value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ConnectionStateResponse(dict):
    """
    ConnectionState information.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionsRequired":
            suggest = "actions_required"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionStateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionStateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionStateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 actions_required: Optional[str] = None,
                 description: Optional[str] = None,
                 status: Optional[str] = None):
        """
        ConnectionState information.
        :param str actions_required: Actions required (if any).
        :param str description: Description of the connection state.
        :param str status: Status of the connection.
        """
        if actions_required is not None:
            pulumi.set(__self__, "actions_required", actions_required)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="actionsRequired")
    def actions_required(self) -> Optional[str]:
        """
        Actions required (if any).
        """
        return pulumi.get(self, "actions_required")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of the connection state.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Status of the connection.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class DeadLetterWithResourceIdentityResponse(dict):
    """
    Information about the deadletter destination with resource identity.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deadLetterDestination":
            suggest = "dead_letter_destination"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeadLetterWithResourceIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeadLetterWithResourceIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeadLetterWithResourceIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dead_letter_destination: Optional['outputs.StorageBlobDeadLetterDestinationResponse'] = None,
                 identity: Optional['outputs.EventSubscriptionIdentityResponse'] = None):
        """
        Information about the deadletter destination with resource identity.
        :param 'StorageBlobDeadLetterDestinationResponse' dead_letter_destination: Information about the destination where events have to be delivered for the event subscription.
               Uses the managed identity setup on the parent resource (namely, topic or domain) to acquire the authentication tokens being used during delivery / dead-lettering.
        :param 'EventSubscriptionIdentityResponse' identity: The identity to use when dead-lettering events.
        """
        if dead_letter_destination is not None:
            pulumi.set(__self__, "dead_letter_destination", dead_letter_destination)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)

    @property
    @pulumi.getter(name="deadLetterDestination")
    def dead_letter_destination(self) -> Optional['outputs.StorageBlobDeadLetterDestinationResponse']:
        """
        Information about the destination where events have to be delivered for the event subscription.
        Uses the managed identity setup on the parent resource (namely, topic or domain) to acquire the authentication tokens being used during delivery / dead-lettering.
        """
        return pulumi.get(self, "dead_letter_destination")

    @property
    @pulumi.getter
    def identity(self) -> Optional['outputs.EventSubscriptionIdentityResponse']:
        """
        The identity to use when dead-lettering events.
        """
        return pulumi.get(self, "identity")


@pulumi.output_type
class DeliveryWithResourceIdentityResponse(dict):
    """
    Information about the delivery for an event subscription with resource identity.
    """
    def __init__(__self__, *,
                 destination: Optional[Any] = None,
                 identity: Optional['outputs.EventSubscriptionIdentityResponse'] = None):
        """
        Information about the delivery for an event subscription with resource identity.
        :param Union['AzureFunctionEventSubscriptionDestinationResponse', 'EventHubEventSubscriptionDestinationResponse', 'HybridConnectionEventSubscriptionDestinationResponse', 'ServiceBusQueueEventSubscriptionDestinationResponse', 'ServiceBusTopicEventSubscriptionDestinationResponse', 'StorageQueueEventSubscriptionDestinationResponse', 'WebHookEventSubscriptionDestinationResponse'] destination: Information about the destination where events have to be delivered for the event subscription.
               Uses Azure Event Grid's identity to acquire the authentication tokens being used during delivery / dead-lettering.
        :param 'EventSubscriptionIdentityResponse' identity: The identity to use when delivering events.
        """
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)

    @property
    @pulumi.getter
    def destination(self) -> Optional[Any]:
        """
        Information about the destination where events have to be delivered for the event subscription.
        Uses Azure Event Grid's identity to acquire the authentication tokens being used during delivery / dead-lettering.
        """
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter
    def identity(self) -> Optional['outputs.EventSubscriptionIdentityResponse']:
        """
        The identity to use when delivering events.
        """
        return pulumi.get(self, "identity")


@pulumi.output_type
class DynamicDeliveryAttributeMappingResponse(dict):
    """
    Dynamic delivery attribute mapping details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceField":
            suggest = "source_field"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DynamicDeliveryAttributeMappingResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DynamicDeliveryAttributeMappingResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DynamicDeliveryAttributeMappingResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 name: Optional[str] = None,
                 source_field: Optional[str] = None):
        """
        Dynamic delivery attribute mapping details.
        :param str type: Type of the delivery attribute or header name.
               Expected value is 'Dynamic'.
        :param str name: Name of the delivery attribute or header.
        :param str source_field: JSON path in the event which contains attribute value.
        """
        pulumi.set(__self__, "type", 'Dynamic')
        if name is not None:
            pulumi.set(__self__, "name", name)
        if source_field is not None:
            pulumi.set(__self__, "source_field", source_field)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the delivery attribute or header name.
        Expected value is 'Dynamic'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the delivery attribute or header.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sourceField")
    def source_field(self) -> Optional[str]:
        """
        JSON path in the event which contains attribute value.
        """
        return pulumi.get(self, "source_field")


@pulumi.output_type
class EventChannelDestinationResponse(dict):
    """
    Properties of the destination of an event channel.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "azureSubscriptionId":
            suggest = "azure_subscription_id"
        elif key == "partnerTopicName":
            suggest = "partner_topic_name"
        elif key == "resourceGroup":
            suggest = "resource_group"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventChannelDestinationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventChannelDestinationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventChannelDestinationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 azure_subscription_id: Optional[str] = None,
                 partner_topic_name: Optional[str] = None,
                 resource_group: Optional[str] = None):
        """
        Properties of the destination of an event channel.
        :param str azure_subscription_id: Azure subscription ID of the customer creating the event channel. The partner topic
               associated with the event channel will be created under this Azure subscription.
        :param str partner_topic_name: Name of the partner topic associated with the event channel.
        :param str resource_group: Azure Resource Group of the customer creating the event channel. The partner topic
               associated with the event channel will be created under this resource group.
        """
        if azure_subscription_id is not None:
            pulumi.set(__self__, "azure_subscription_id", azure_subscription_id)
        if partner_topic_name is not None:
            pulumi.set(__self__, "partner_topic_name", partner_topic_name)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)

    @property
    @pulumi.getter(name="azureSubscriptionId")
    def azure_subscription_id(self) -> Optional[str]:
        """
        Azure subscription ID of the customer creating the event channel. The partner topic
        associated with the event channel will be created under this Azure subscription.
        """
        return pulumi.get(self, "azure_subscription_id")

    @property
    @pulumi.getter(name="partnerTopicName")
    def partner_topic_name(self) -> Optional[str]:
        """
        Name of the partner topic associated with the event channel.
        """
        return pulumi.get(self, "partner_topic_name")

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[str]:
        """
        Azure Resource Group of the customer creating the event channel. The partner topic
        associated with the event channel will be created under this resource group.
        """
        return pulumi.get(self, "resource_group")


@pulumi.output_type
class EventChannelFilterResponse(dict):
    """
    Filter for the Event Channel.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "advancedFilters":
            suggest = "advanced_filters"
        elif key == "enableAdvancedFilteringOnArrays":
            suggest = "enable_advanced_filtering_on_arrays"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventChannelFilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventChannelFilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventChannelFilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 advanced_filters: Optional[Sequence[Any]] = None,
                 enable_advanced_filtering_on_arrays: Optional[bool] = None):
        """
        Filter for the Event Channel.
        :param Sequence[Union['BoolEqualsAdvancedFilterResponse', 'IsNotNullAdvancedFilterResponse', 'IsNullOrUndefinedAdvancedFilterResponse', 'NumberGreaterThanAdvancedFilterResponse', 'NumberGreaterThanOrEqualsAdvancedFilterResponse', 'NumberInAdvancedFilterResponse', 'NumberInRangeAdvancedFilterResponse', 'NumberLessThanAdvancedFilterResponse', 'NumberLessThanOrEqualsAdvancedFilterResponse', 'NumberNotInAdvancedFilterResponse', 'NumberNotInRangeAdvancedFilterResponse', 'StringBeginsWithAdvancedFilterResponse', 'StringContainsAdvancedFilterResponse', 'StringEndsWithAdvancedFilterResponse', 'StringInAdvancedFilterResponse', 'StringNotBeginsWithAdvancedFilterResponse', 'StringNotContainsAdvancedFilterResponse', 'StringNotEndsWithAdvancedFilterResponse', 'StringNotInAdvancedFilterResponse']] advanced_filters: An array of advanced filters that are used for filtering event channels.
        :param bool enable_advanced_filtering_on_arrays: Allows advanced filters to be evaluated against an array of values instead of expecting a singular value. The default value is either false or null.
        """
        if advanced_filters is not None:
            pulumi.set(__self__, "advanced_filters", advanced_filters)
        if enable_advanced_filtering_on_arrays is None:
            enable_advanced_filtering_on_arrays = False
        if enable_advanced_filtering_on_arrays is not None:
            pulumi.set(__self__, "enable_advanced_filtering_on_arrays", enable_advanced_filtering_on_arrays)

    @property
    @pulumi.getter(name="advancedFilters")
    def advanced_filters(self) -> Optional[Sequence[Any]]:
        """
        An array of advanced filters that are used for filtering event channels.
        """
        return pulumi.get(self, "advanced_filters")

    @property
    @pulumi.getter(name="enableAdvancedFilteringOnArrays")
    def enable_advanced_filtering_on_arrays(self) -> Optional[bool]:
        """
        Allows advanced filters to be evaluated against an array of values instead of expecting a singular value. The default value is either false or null.
        """
        return pulumi.get(self, "enable_advanced_filtering_on_arrays")


@pulumi.output_type
class EventChannelSourceResponse(dict):
    """
    Properties of the source of an event channel.
    """
    def __init__(__self__, *,
                 source: Optional[str] = None):
        """
        Properties of the source of an event channel.
        :param str source: The identifier of the resource that's the source of the events.
               This represents a unique resource in the partner's resource model.
        """
        if source is not None:
            pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter
    def source(self) -> Optional[str]:
        """
        The identifier of the resource that's the source of the events.
        This represents a unique resource in the partner's resource model.
        """
        return pulumi.get(self, "source")


@pulumi.output_type
class EventHubEventSubscriptionDestinationResponse(dict):
    """
    Information about the event hub destination for an event subscription.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointType":
            suggest = "endpoint_type"
        elif key == "deliveryAttributeMappings":
            suggest = "delivery_attribute_mappings"
        elif key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventHubEventSubscriptionDestinationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventHubEventSubscriptionDestinationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventHubEventSubscriptionDestinationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_type: str,
                 delivery_attribute_mappings: Optional[Sequence[Any]] = None,
                 resource_id: Optional[str] = None):
        """
        Information about the event hub destination for an event subscription.
        :param str endpoint_type: Type of the endpoint for the event subscription destination.
               Expected value is 'EventHub'.
        :param Sequence[Union['DynamicDeliveryAttributeMappingResponse', 'StaticDeliveryAttributeMappingResponse']] delivery_attribute_mappings: Delivery attribute details.
        :param str resource_id: The Azure Resource Id that represents the endpoint of an Event Hub destination of an event subscription.
        """
        pulumi.set(__self__, "endpoint_type", 'EventHub')
        if delivery_attribute_mappings is not None:
            pulumi.set(__self__, "delivery_attribute_mappings", delivery_attribute_mappings)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> str:
        """
        Type of the endpoint for the event subscription destination.
        Expected value is 'EventHub'.
        """
        return pulumi.get(self, "endpoint_type")

    @property
    @pulumi.getter(name="deliveryAttributeMappings")
    def delivery_attribute_mappings(self) -> Optional[Sequence[Any]]:
        """
        Delivery attribute details.
        """
        return pulumi.get(self, "delivery_attribute_mappings")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        The Azure Resource Id that represents the endpoint of an Event Hub destination of an event subscription.
        """
        return pulumi.get(self, "resource_id")


@pulumi.output_type
class EventSubscriptionFilterResponse(dict):
    """
    Filter for the Event Subscription.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "advancedFilters":
            suggest = "advanced_filters"
        elif key == "enableAdvancedFilteringOnArrays":
            suggest = "enable_advanced_filtering_on_arrays"
        elif key == "includedEventTypes":
            suggest = "included_event_types"
        elif key == "isSubjectCaseSensitive":
            suggest = "is_subject_case_sensitive"
        elif key == "subjectBeginsWith":
            suggest = "subject_begins_with"
        elif key == "subjectEndsWith":
            suggest = "subject_ends_with"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventSubscriptionFilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventSubscriptionFilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventSubscriptionFilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 advanced_filters: Optional[Sequence[Any]] = None,
                 enable_advanced_filtering_on_arrays: Optional[bool] = None,
                 included_event_types: Optional[Sequence[str]] = None,
                 is_subject_case_sensitive: Optional[bool] = None,
                 subject_begins_with: Optional[str] = None,
                 subject_ends_with: Optional[str] = None):
        """
        Filter for the Event Subscription.
        :param Sequence[Union['BoolEqualsAdvancedFilterResponse', 'IsNotNullAdvancedFilterResponse', 'IsNullOrUndefinedAdvancedFilterResponse', 'NumberGreaterThanAdvancedFilterResponse', 'NumberGreaterThanOrEqualsAdvancedFilterResponse', 'NumberInAdvancedFilterResponse', 'NumberInRangeAdvancedFilterResponse', 'NumberLessThanAdvancedFilterResponse', 'NumberLessThanOrEqualsAdvancedFilterResponse', 'NumberNotInAdvancedFilterResponse', 'NumberNotInRangeAdvancedFilterResponse', 'StringBeginsWithAdvancedFilterResponse', 'StringContainsAdvancedFilterResponse', 'StringEndsWithAdvancedFilterResponse', 'StringInAdvancedFilterResponse', 'StringNotBeginsWithAdvancedFilterResponse', 'StringNotContainsAdvancedFilterResponse', 'StringNotEndsWithAdvancedFilterResponse', 'StringNotInAdvancedFilterResponse']] advanced_filters: An array of advanced filters that are used for filtering event subscriptions.
        :param bool enable_advanced_filtering_on_arrays: Allows advanced filters to be evaluated against an array of values instead of expecting a singular value.
        :param Sequence[str] included_event_types: A list of applicable event types that need to be part of the event subscription. If it is desired to subscribe to all default event types, set the IncludedEventTypes to null.
        :param bool is_subject_case_sensitive: Specifies if the SubjectBeginsWith and SubjectEndsWith properties of the filter
               should be compared in a case sensitive manner.
        :param str subject_begins_with: An optional string to filter events for an event subscription based on a resource path prefix.
               The format of this depends on the publisher of the events.
               Wildcard characters are not supported in this path.
        :param str subject_ends_with: An optional string to filter events for an event subscription based on a resource path suffix.
               Wildcard characters are not supported in this path.
        """
        if advanced_filters is not None:
            pulumi.set(__self__, "advanced_filters", advanced_filters)
        if enable_advanced_filtering_on_arrays is not None:
            pulumi.set(__self__, "enable_advanced_filtering_on_arrays", enable_advanced_filtering_on_arrays)
        if included_event_types is not None:
            pulumi.set(__self__, "included_event_types", included_event_types)
        if is_subject_case_sensitive is None:
            is_subject_case_sensitive = False
        if is_subject_case_sensitive is not None:
            pulumi.set(__self__, "is_subject_case_sensitive", is_subject_case_sensitive)
        if subject_begins_with is not None:
            pulumi.set(__self__, "subject_begins_with", subject_begins_with)
        if subject_ends_with is not None:
            pulumi.set(__self__, "subject_ends_with", subject_ends_with)

    @property
    @pulumi.getter(name="advancedFilters")
    def advanced_filters(self) -> Optional[Sequence[Any]]:
        """
        An array of advanced filters that are used for filtering event subscriptions.
        """
        return pulumi.get(self, "advanced_filters")

    @property
    @pulumi.getter(name="enableAdvancedFilteringOnArrays")
    def enable_advanced_filtering_on_arrays(self) -> Optional[bool]:
        """
        Allows advanced filters to be evaluated against an array of values instead of expecting a singular value.
        """
        return pulumi.get(self, "enable_advanced_filtering_on_arrays")

    @property
    @pulumi.getter(name="includedEventTypes")
    def included_event_types(self) -> Optional[Sequence[str]]:
        """
        A list of applicable event types that need to be part of the event subscription. If it is desired to subscribe to all default event types, set the IncludedEventTypes to null.
        """
        return pulumi.get(self, "included_event_types")

    @property
    @pulumi.getter(name="isSubjectCaseSensitive")
    def is_subject_case_sensitive(self) -> Optional[bool]:
        """
        Specifies if the SubjectBeginsWith and SubjectEndsWith properties of the filter
        should be compared in a case sensitive manner.
        """
        return pulumi.get(self, "is_subject_case_sensitive")

    @property
    @pulumi.getter(name="subjectBeginsWith")
    def subject_begins_with(self) -> Optional[str]:
        """
        An optional string to filter events for an event subscription based on a resource path prefix.
        The format of this depends on the publisher of the events.
        Wildcard characters are not supported in this path.
        """
        return pulumi.get(self, "subject_begins_with")

    @property
    @pulumi.getter(name="subjectEndsWith")
    def subject_ends_with(self) -> Optional[str]:
        """
        An optional string to filter events for an event subscription based on a resource path suffix.
        Wildcard characters are not supported in this path.
        """
        return pulumi.get(self, "subject_ends_with")


@pulumi.output_type
class EventSubscriptionIdentityResponse(dict):
    """
    The identity information with the event subscription.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userAssignedIdentity":
            suggest = "user_assigned_identity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventSubscriptionIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventSubscriptionIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventSubscriptionIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: Optional[str] = None,
                 user_assigned_identity: Optional[str] = None):
        """
        The identity information with the event subscription.
        :param str type: The type of managed identity used. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user-assigned identities. The type 'None' will remove any identity.
        :param str user_assigned_identity: The user identity associated with the resource.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_assigned_identity is not None:
            pulumi.set(__self__, "user_assigned_identity", user_assigned_identity)

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of managed identity used. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user-assigned identities. The type 'None' will remove any identity.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userAssignedIdentity")
    def user_assigned_identity(self) -> Optional[str]:
        """
        The user identity associated with the resource.
        """
        return pulumi.get(self, "user_assigned_identity")


@pulumi.output_type
class ExtendedLocationResponse(dict):
    """
    Definition of an Extended Location
    """
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 type: Optional[str] = None):
        """
        Definition of an Extended Location
        :param str name: Fully qualified name of the extended location.
        :param str type: Type of the extended location.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Fully qualified name of the extended location.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Type of the extended location.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class HybridConnectionEventSubscriptionDestinationResponse(dict):
    """
    Information about the HybridConnection destination for an event subscription.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointType":
            suggest = "endpoint_type"
        elif key == "deliveryAttributeMappings":
            suggest = "delivery_attribute_mappings"
        elif key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HybridConnectionEventSubscriptionDestinationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HybridConnectionEventSubscriptionDestinationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HybridConnectionEventSubscriptionDestinationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_type: str,
                 delivery_attribute_mappings: Optional[Sequence[Any]] = None,
                 resource_id: Optional[str] = None):
        """
        Information about the HybridConnection destination for an event subscription.
        :param str endpoint_type: Type of the endpoint for the event subscription destination.
               Expected value is 'HybridConnection'.
        :param Sequence[Union['DynamicDeliveryAttributeMappingResponse', 'StaticDeliveryAttributeMappingResponse']] delivery_attribute_mappings: Delivery attribute details.
        :param str resource_id: The Azure Resource ID of an hybrid connection that is the destination of an event subscription.
        """
        pulumi.set(__self__, "endpoint_type", 'HybridConnection')
        if delivery_attribute_mappings is not None:
            pulumi.set(__self__, "delivery_attribute_mappings", delivery_attribute_mappings)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> str:
        """
        Type of the endpoint for the event subscription destination.
        Expected value is 'HybridConnection'.
        """
        return pulumi.get(self, "endpoint_type")

    @property
    @pulumi.getter(name="deliveryAttributeMappings")
    def delivery_attribute_mappings(self) -> Optional[Sequence[Any]]:
        """
        Delivery attribute details.
        """
        return pulumi.get(self, "delivery_attribute_mappings")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        The Azure Resource ID of an hybrid connection that is the destination of an event subscription.
        """
        return pulumi.get(self, "resource_id")


@pulumi.output_type
class IdentityInfoResponse(dict):
    """
    The identity information for the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"
        elif key == "userAssignedIdentities":
            suggest = "user_assigned_identities"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdentityInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdentityInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdentityInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: Optional[str] = None,
                 tenant_id: Optional[str] = None,
                 type: Optional[str] = None,
                 user_assigned_identities: Optional[Mapping[str, 'outputs.UserIdentityPropertiesResponse']] = None):
        """
        The identity information for the resource.
        :param str principal_id: The principal ID of resource identity.
        :param str tenant_id: The tenant ID of resource.
        :param str type: The type of managed identity used. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user-assigned identities. The type 'None' will remove any identity.
        :param Mapping[str, 'UserIdentityPropertiesResponse'] user_assigned_identities: The list of user identities associated with the resource. The user identity dictionary key references will be ARM resource ids in the form:
               '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
               This property is currently not used and reserved for future usage.
        """
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[str]:
        """
        The principal ID of resource identity.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[str]:
        """
        The tenant ID of resource.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of managed identity used. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user-assigned identities. The type 'None' will remove any identity.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[Mapping[str, 'outputs.UserIdentityPropertiesResponse']]:
        """
        The list of user identities associated with the resource. The user identity dictionary key references will be ARM resource ids in the form:
        '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        This property is currently not used and reserved for future usage.
        """
        return pulumi.get(self, "user_assigned_identities")


@pulumi.output_type
class InboundIpRuleResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipMask":
            suggest = "ip_mask"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InboundIpRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InboundIpRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InboundIpRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: Optional[str] = None,
                 ip_mask: Optional[str] = None):
        """
        :param str action: Action to perform based on the match or no match of the IpMask.
        :param str ip_mask: IP Address in CIDR notation e.g., 10.0.0.0/8.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if ip_mask is not None:
            pulumi.set(__self__, "ip_mask", ip_mask)

    @property
    @pulumi.getter
    def action(self) -> Optional[str]:
        """
        Action to perform based on the match or no match of the IpMask.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="ipMask")
    def ip_mask(self) -> Optional[str]:
        """
        IP Address in CIDR notation e.g., 10.0.0.0/8.
        """
        return pulumi.get(self, "ip_mask")


@pulumi.output_type
class IsNotNullAdvancedFilterResponse(dict):
    """
    IsNotNull Advanced Filter.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "operatorType":
            suggest = "operator_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IsNotNullAdvancedFilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IsNotNullAdvancedFilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IsNotNullAdvancedFilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operator_type: str,
                 key: Optional[str] = None):
        """
        IsNotNull Advanced Filter.
        :param str operator_type: The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
               Expected value is 'IsNotNull'.
        :param str key: The field/property in the event based on which you want to filter.
        """
        pulumi.set(__self__, "operator_type", 'IsNotNull')
        if key is not None:
            pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter(name="operatorType")
    def operator_type(self) -> str:
        """
        The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
        Expected value is 'IsNotNull'.
        """
        return pulumi.get(self, "operator_type")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The field/property in the event based on which you want to filter.
        """
        return pulumi.get(self, "key")


@pulumi.output_type
class IsNullOrUndefinedAdvancedFilterResponse(dict):
    """
    IsNullOrUndefined Advanced Filter.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "operatorType":
            suggest = "operator_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IsNullOrUndefinedAdvancedFilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IsNullOrUndefinedAdvancedFilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IsNullOrUndefinedAdvancedFilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operator_type: str,
                 key: Optional[str] = None):
        """
        IsNullOrUndefined Advanced Filter.
        :param str operator_type: The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
               Expected value is 'IsNullOrUndefined'.
        :param str key: The field/property in the event based on which you want to filter.
        """
        pulumi.set(__self__, "operator_type", 'IsNullOrUndefined')
        if key is not None:
            pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter(name="operatorType")
    def operator_type(self) -> str:
        """
        The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
        Expected value is 'IsNullOrUndefined'.
        """
        return pulumi.get(self, "operator_type")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The field/property in the event based on which you want to filter.
        """
        return pulumi.get(self, "key")


@pulumi.output_type
class JsonFieldResponse(dict):
    """
    This is used to express the source of an input schema mapping for a single target field in the Event Grid Event schema. This is currently used in the mappings for the 'id', 'topic' and 'eventtime' properties. This represents a field in the input event schema.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceField":
            suggest = "source_field"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JsonFieldResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JsonFieldResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JsonFieldResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_field: Optional[str] = None):
        """
        This is used to express the source of an input schema mapping for a single target field in the Event Grid Event schema. This is currently used in the mappings for the 'id', 'topic' and 'eventtime' properties. This represents a field in the input event schema.
        :param str source_field: Name of a field in the input event schema that's to be used as the source of a mapping.
        """
        if source_field is not None:
            pulumi.set(__self__, "source_field", source_field)

    @property
    @pulumi.getter(name="sourceField")
    def source_field(self) -> Optional[str]:
        """
        Name of a field in the input event schema that's to be used as the source of a mapping.
        """
        return pulumi.get(self, "source_field")


@pulumi.output_type
class JsonFieldWithDefaultResponse(dict):
    """
    This is used to express the source of an input schema mapping for a single target field
    in the Event Grid Event schema. This is currently used in the mappings for the 'subject',
    'eventtype' and 'dataversion' properties. This represents a field in the input event schema
    along with a default value to be used, and at least one of these two properties should be provided.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultValue":
            suggest = "default_value"
        elif key == "sourceField":
            suggest = "source_field"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JsonFieldWithDefaultResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JsonFieldWithDefaultResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JsonFieldWithDefaultResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_value: Optional[str] = None,
                 source_field: Optional[str] = None):
        """
        This is used to express the source of an input schema mapping for a single target field
        in the Event Grid Event schema. This is currently used in the mappings for the 'subject',
        'eventtype' and 'dataversion' properties. This represents a field in the input event schema
        along with a default value to be used, and at least one of these two properties should be provided.
        :param str default_value: The default value to be used for mapping when a SourceField is not provided or if there's no property with the specified name in the published JSON event payload.
        :param str source_field: Name of a field in the input event schema that's to be used as the source of a mapping.
        """
        if default_value is not None:
            pulumi.set(__self__, "default_value", default_value)
        if source_field is not None:
            pulumi.set(__self__, "source_field", source_field)

    @property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> Optional[str]:
        """
        The default value to be used for mapping when a SourceField is not provided or if there's no property with the specified name in the published JSON event payload.
        """
        return pulumi.get(self, "default_value")

    @property
    @pulumi.getter(name="sourceField")
    def source_field(self) -> Optional[str]:
        """
        Name of a field in the input event schema that's to be used as the source of a mapping.
        """
        return pulumi.get(self, "source_field")


@pulumi.output_type
class JsonInputSchemaMappingResponse(dict):
    """
    This enables publishing to Event Grid using a custom input schema. This can be used to map properties from a custom input JSON schema to the Event Grid event schema.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inputSchemaMappingType":
            suggest = "input_schema_mapping_type"
        elif key == "dataVersion":
            suggest = "data_version"
        elif key == "eventTime":
            suggest = "event_time"
        elif key == "eventType":
            suggest = "event_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JsonInputSchemaMappingResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JsonInputSchemaMappingResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JsonInputSchemaMappingResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 input_schema_mapping_type: str,
                 data_version: Optional['outputs.JsonFieldWithDefaultResponse'] = None,
                 event_time: Optional['outputs.JsonFieldResponse'] = None,
                 event_type: Optional['outputs.JsonFieldWithDefaultResponse'] = None,
                 id: Optional['outputs.JsonFieldResponse'] = None,
                 subject: Optional['outputs.JsonFieldWithDefaultResponse'] = None,
                 topic: Optional['outputs.JsonFieldResponse'] = None):
        """
        This enables publishing to Event Grid using a custom input schema. This can be used to map properties from a custom input JSON schema to the Event Grid event schema.
        :param str input_schema_mapping_type: Type of the custom mapping
               Expected value is 'Json'.
        :param 'JsonFieldWithDefaultResponse' data_version: The mapping information for the DataVersion property of the Event Grid Event.
        :param 'JsonFieldResponse' event_time: The mapping information for the EventTime property of the Event Grid Event.
        :param 'JsonFieldWithDefaultResponse' event_type: The mapping information for the EventType property of the Event Grid Event.
        :param 'JsonFieldResponse' id: The mapping information for the Id property of the Event Grid Event.
        :param 'JsonFieldWithDefaultResponse' subject: The mapping information for the Subject property of the Event Grid Event.
        :param 'JsonFieldResponse' topic: The mapping information for the Topic property of the Event Grid Event.
        """
        pulumi.set(__self__, "input_schema_mapping_type", 'Json')
        if data_version is not None:
            pulumi.set(__self__, "data_version", data_version)
        if event_time is not None:
            pulumi.set(__self__, "event_time", event_time)
        if event_type is not None:
            pulumi.set(__self__, "event_type", event_type)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if subject is not None:
            pulumi.set(__self__, "subject", subject)
        if topic is not None:
            pulumi.set(__self__, "topic", topic)

    @property
    @pulumi.getter(name="inputSchemaMappingType")
    def input_schema_mapping_type(self) -> str:
        """
        Type of the custom mapping
        Expected value is 'Json'.
        """
        return pulumi.get(self, "input_schema_mapping_type")

    @property
    @pulumi.getter(name="dataVersion")
    def data_version(self) -> Optional['outputs.JsonFieldWithDefaultResponse']:
        """
        The mapping information for the DataVersion property of the Event Grid Event.
        """
        return pulumi.get(self, "data_version")

    @property
    @pulumi.getter(name="eventTime")
    def event_time(self) -> Optional['outputs.JsonFieldResponse']:
        """
        The mapping information for the EventTime property of the Event Grid Event.
        """
        return pulumi.get(self, "event_time")

    @property
    @pulumi.getter(name="eventType")
    def event_type(self) -> Optional['outputs.JsonFieldWithDefaultResponse']:
        """
        The mapping information for the EventType property of the Event Grid Event.
        """
        return pulumi.get(self, "event_type")

    @property
    @pulumi.getter
    def id(self) -> Optional['outputs.JsonFieldResponse']:
        """
        The mapping information for the Id property of the Event Grid Event.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def subject(self) -> Optional['outputs.JsonFieldWithDefaultResponse']:
        """
        The mapping information for the Subject property of the Event Grid Event.
        """
        return pulumi.get(self, "subject")

    @property
    @pulumi.getter
    def topic(self) -> Optional['outputs.JsonFieldResponse']:
        """
        The mapping information for the Topic property of the Event Grid Event.
        """
        return pulumi.get(self, "topic")


@pulumi.output_type
class NumberGreaterThanAdvancedFilterResponse(dict):
    """
    NumberGreaterThan Advanced Filter.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "operatorType":
            suggest = "operator_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NumberGreaterThanAdvancedFilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NumberGreaterThanAdvancedFilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NumberGreaterThanAdvancedFilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operator_type: str,
                 key: Optional[str] = None,
                 value: Optional[float] = None):
        """
        NumberGreaterThan Advanced Filter.
        :param str operator_type: The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
               Expected value is 'NumberGreaterThan'.
        :param str key: The field/property in the event based on which you want to filter.
        :param float value: The filter value.
        """
        pulumi.set(__self__, "operator_type", 'NumberGreaterThan')
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="operatorType")
    def operator_type(self) -> str:
        """
        The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
        Expected value is 'NumberGreaterThan'.
        """
        return pulumi.get(self, "operator_type")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The field/property in the event based on which you want to filter.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[float]:
        """
        The filter value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class NumberGreaterThanOrEqualsAdvancedFilterResponse(dict):
    """
    NumberGreaterThanOrEquals Advanced Filter.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "operatorType":
            suggest = "operator_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NumberGreaterThanOrEqualsAdvancedFilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NumberGreaterThanOrEqualsAdvancedFilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NumberGreaterThanOrEqualsAdvancedFilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operator_type: str,
                 key: Optional[str] = None,
                 value: Optional[float] = None):
        """
        NumberGreaterThanOrEquals Advanced Filter.
        :param str operator_type: The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
               Expected value is 'NumberGreaterThanOrEquals'.
        :param str key: The field/property in the event based on which you want to filter.
        :param float value: The filter value.
        """
        pulumi.set(__self__, "operator_type", 'NumberGreaterThanOrEquals')
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="operatorType")
    def operator_type(self) -> str:
        """
        The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
        Expected value is 'NumberGreaterThanOrEquals'.
        """
        return pulumi.get(self, "operator_type")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The field/property in the event based on which you want to filter.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[float]:
        """
        The filter value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class NumberInAdvancedFilterResponse(dict):
    """
    NumberIn Advanced Filter.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "operatorType":
            suggest = "operator_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NumberInAdvancedFilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NumberInAdvancedFilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NumberInAdvancedFilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operator_type: str,
                 key: Optional[str] = None,
                 values: Optional[Sequence[float]] = None):
        """
        NumberIn Advanced Filter.
        :param str operator_type: The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
               Expected value is 'NumberIn'.
        :param str key: The field/property in the event based on which you want to filter.
        :param Sequence[float] values: The set of filter values.
        """
        pulumi.set(__self__, "operator_type", 'NumberIn')
        if key is not None:
            pulumi.set(__self__, "key", key)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="operatorType")
    def operator_type(self) -> str:
        """
        The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
        Expected value is 'NumberIn'.
        """
        return pulumi.get(self, "operator_type")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The field/property in the event based on which you want to filter.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Optional[Sequence[float]]:
        """
        The set of filter values.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class NumberInRangeAdvancedFilterResponse(dict):
    """
    NumberInRange Advanced Filter.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "operatorType":
            suggest = "operator_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NumberInRangeAdvancedFilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NumberInRangeAdvancedFilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NumberInRangeAdvancedFilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operator_type: str,
                 key: Optional[str] = None,
                 values: Optional[Sequence[Sequence[float]]] = None):
        """
        NumberInRange Advanced Filter.
        :param str operator_type: The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
               Expected value is 'NumberInRange'.
        :param str key: The field/property in the event based on which you want to filter.
        :param Sequence[Sequence[float]] values: The set of filter values.
        """
        pulumi.set(__self__, "operator_type", 'NumberInRange')
        if key is not None:
            pulumi.set(__self__, "key", key)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="operatorType")
    def operator_type(self) -> str:
        """
        The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
        Expected value is 'NumberInRange'.
        """
        return pulumi.get(self, "operator_type")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The field/property in the event based on which you want to filter.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Optional[Sequence[Sequence[float]]]:
        """
        The set of filter values.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class NumberLessThanAdvancedFilterResponse(dict):
    """
    NumberLessThan Advanced Filter.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "operatorType":
            suggest = "operator_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NumberLessThanAdvancedFilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NumberLessThanAdvancedFilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NumberLessThanAdvancedFilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operator_type: str,
                 key: Optional[str] = None,
                 value: Optional[float] = None):
        """
        NumberLessThan Advanced Filter.
        :param str operator_type: The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
               Expected value is 'NumberLessThan'.
        :param str key: The field/property in the event based on which you want to filter.
        :param float value: The filter value.
        """
        pulumi.set(__self__, "operator_type", 'NumberLessThan')
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="operatorType")
    def operator_type(self) -> str:
        """
        The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
        Expected value is 'NumberLessThan'.
        """
        return pulumi.get(self, "operator_type")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The field/property in the event based on which you want to filter.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[float]:
        """
        The filter value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class NumberLessThanOrEqualsAdvancedFilterResponse(dict):
    """
    NumberLessThanOrEquals Advanced Filter.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "operatorType":
            suggest = "operator_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NumberLessThanOrEqualsAdvancedFilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NumberLessThanOrEqualsAdvancedFilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NumberLessThanOrEqualsAdvancedFilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operator_type: str,
                 key: Optional[str] = None,
                 value: Optional[float] = None):
        """
        NumberLessThanOrEquals Advanced Filter.
        :param str operator_type: The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
               Expected value is 'NumberLessThanOrEquals'.
        :param str key: The field/property in the event based on which you want to filter.
        :param float value: The filter value.
        """
        pulumi.set(__self__, "operator_type", 'NumberLessThanOrEquals')
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="operatorType")
    def operator_type(self) -> str:
        """
        The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
        Expected value is 'NumberLessThanOrEquals'.
        """
        return pulumi.get(self, "operator_type")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The field/property in the event based on which you want to filter.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[float]:
        """
        The filter value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class NumberNotInAdvancedFilterResponse(dict):
    """
    NumberNotIn Advanced Filter.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "operatorType":
            suggest = "operator_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NumberNotInAdvancedFilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NumberNotInAdvancedFilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NumberNotInAdvancedFilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operator_type: str,
                 key: Optional[str] = None,
                 values: Optional[Sequence[float]] = None):
        """
        NumberNotIn Advanced Filter.
        :param str operator_type: The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
               Expected value is 'NumberNotIn'.
        :param str key: The field/property in the event based on which you want to filter.
        :param Sequence[float] values: The set of filter values.
        """
        pulumi.set(__self__, "operator_type", 'NumberNotIn')
        if key is not None:
            pulumi.set(__self__, "key", key)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="operatorType")
    def operator_type(self) -> str:
        """
        The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
        Expected value is 'NumberNotIn'.
        """
        return pulumi.get(self, "operator_type")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The field/property in the event based on which you want to filter.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Optional[Sequence[float]]:
        """
        The set of filter values.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class NumberNotInRangeAdvancedFilterResponse(dict):
    """
    NumberNotInRange Advanced Filter.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "operatorType":
            suggest = "operator_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NumberNotInRangeAdvancedFilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NumberNotInRangeAdvancedFilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NumberNotInRangeAdvancedFilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operator_type: str,
                 key: Optional[str] = None,
                 values: Optional[Sequence[Sequence[float]]] = None):
        """
        NumberNotInRange Advanced Filter.
        :param str operator_type: The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
               Expected value is 'NumberNotInRange'.
        :param str key: The field/property in the event based on which you want to filter.
        :param Sequence[Sequence[float]] values: The set of filter values.
        """
        pulumi.set(__self__, "operator_type", 'NumberNotInRange')
        if key is not None:
            pulumi.set(__self__, "key", key)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="operatorType")
    def operator_type(self) -> str:
        """
        The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
        Expected value is 'NumberNotInRange'.
        """
        return pulumi.get(self, "operator_type")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The field/property in the event based on which you want to filter.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Optional[Sequence[Sequence[float]]]:
        """
        The set of filter values.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class PrivateEndpointConnectionResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groupIds":
            suggest = "group_ids"
        elif key == "privateEndpoint":
            suggest = "private_endpoint"
        elif key == "privateLinkServiceConnectionState":
            suggest = "private_link_service_connection_state"
        elif key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateEndpointConnectionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateEndpointConnectionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateEndpointConnectionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 name: str,
                 type: str,
                 group_ids: Optional[Sequence[str]] = None,
                 private_endpoint: Optional['outputs.PrivateEndpointResponse'] = None,
                 private_link_service_connection_state: Optional['outputs.ConnectionStateResponse'] = None,
                 provisioning_state: Optional[str] = None):
        """
        :param str id: Fully qualified identifier of the resource.
        :param str name: Name of the resource.
        :param str type: Type of the resource.
        :param Sequence[str] group_ids: GroupIds from the private link service resource.
        :param 'PrivateEndpointResponse' private_endpoint: The Private Endpoint resource for this Connection.
        :param 'ConnectionStateResponse' private_link_service_connection_state: Details about the state of the connection.
        :param str provisioning_state: Provisioning state of the Private Endpoint Connection.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if group_ids is not None:
            pulumi.set(__self__, "group_ids", group_ids)
        if private_endpoint is not None:
            pulumi.set(__self__, "private_endpoint", private_endpoint)
        if private_link_service_connection_state is not None:
            pulumi.set(__self__, "private_link_service_connection_state", private_link_service_connection_state)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Fully qualified identifier of the resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the resource.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="groupIds")
    def group_ids(self) -> Optional[Sequence[str]]:
        """
        GroupIds from the private link service resource.
        """
        return pulumi.get(self, "group_ids")

    @property
    @pulumi.getter(name="privateEndpoint")
    def private_endpoint(self) -> Optional['outputs.PrivateEndpointResponse']:
        """
        The Private Endpoint resource for this Connection.
        """
        return pulumi.get(self, "private_endpoint")

    @property
    @pulumi.getter(name="privateLinkServiceConnectionState")
    def private_link_service_connection_state(self) -> Optional['outputs.ConnectionStateResponse']:
        """
        Details about the state of the connection.
        """
        return pulumi.get(self, "private_link_service_connection_state")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        Provisioning state of the Private Endpoint Connection.
        """
        return pulumi.get(self, "provisioning_state")


@pulumi.output_type
class PrivateEndpointResponse(dict):
    """
    PrivateEndpoint information.
    """
    def __init__(__self__, *,
                 id: Optional[str] = None):
        """
        PrivateEndpoint information.
        :param str id: The ARM identifier for Private Endpoint.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The ARM identifier for Private Endpoint.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class ResourceSkuResponse(dict):
    """
    Describes an EventGrid Resource Sku.
    """
    def __init__(__self__, *,
                 name: Optional[str] = None):
        """
        Describes an EventGrid Resource Sku.
        :param str name: The Sku name of the resource. The possible values are: Basic or Premium.
        """
        if name is None:
            name = 'Basic'
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The Sku name of the resource. The possible values are: Basic or Premium.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class RetryPolicyResponse(dict):
    """
    Information about the retry policy for an event subscription.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eventTimeToLiveInMinutes":
            suggest = "event_time_to_live_in_minutes"
        elif key == "maxDeliveryAttempts":
            suggest = "max_delivery_attempts"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RetryPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RetryPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RetryPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 event_time_to_live_in_minutes: Optional[int] = None,
                 max_delivery_attempts: Optional[int] = None):
        """
        Information about the retry policy for an event subscription.
        :param int event_time_to_live_in_minutes: Time To Live (in minutes) for events.
        :param int max_delivery_attempts: Maximum number of delivery retry attempts for events.
        """
        if event_time_to_live_in_minutes is None:
            event_time_to_live_in_minutes = 1440
        if event_time_to_live_in_minutes is not None:
            pulumi.set(__self__, "event_time_to_live_in_minutes", event_time_to_live_in_minutes)
        if max_delivery_attempts is None:
            max_delivery_attempts = 30
        if max_delivery_attempts is not None:
            pulumi.set(__self__, "max_delivery_attempts", max_delivery_attempts)

    @property
    @pulumi.getter(name="eventTimeToLiveInMinutes")
    def event_time_to_live_in_minutes(self) -> Optional[int]:
        """
        Time To Live (in minutes) for events.
        """
        return pulumi.get(self, "event_time_to_live_in_minutes")

    @property
    @pulumi.getter(name="maxDeliveryAttempts")
    def max_delivery_attempts(self) -> Optional[int]:
        """
        Maximum number of delivery retry attempts for events.
        """
        return pulumi.get(self, "max_delivery_attempts")


@pulumi.output_type
class ServiceBusQueueEventSubscriptionDestinationResponse(dict):
    """
    Information about the service bus destination for an event subscription.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointType":
            suggest = "endpoint_type"
        elif key == "deliveryAttributeMappings":
            suggest = "delivery_attribute_mappings"
        elif key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceBusQueueEventSubscriptionDestinationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceBusQueueEventSubscriptionDestinationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceBusQueueEventSubscriptionDestinationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_type: str,
                 delivery_attribute_mappings: Optional[Sequence[Any]] = None,
                 resource_id: Optional[str] = None):
        """
        Information about the service bus destination for an event subscription.
        :param str endpoint_type: Type of the endpoint for the event subscription destination.
               Expected value is 'ServiceBusQueue'.
        :param Sequence[Union['DynamicDeliveryAttributeMappingResponse', 'StaticDeliveryAttributeMappingResponse']] delivery_attribute_mappings: Delivery attribute details.
        :param str resource_id: The Azure Resource Id that represents the endpoint of the Service Bus destination of an event subscription.
        """
        pulumi.set(__self__, "endpoint_type", 'ServiceBusQueue')
        if delivery_attribute_mappings is not None:
            pulumi.set(__self__, "delivery_attribute_mappings", delivery_attribute_mappings)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> str:
        """
        Type of the endpoint for the event subscription destination.
        Expected value is 'ServiceBusQueue'.
        """
        return pulumi.get(self, "endpoint_type")

    @property
    @pulumi.getter(name="deliveryAttributeMappings")
    def delivery_attribute_mappings(self) -> Optional[Sequence[Any]]:
        """
        Delivery attribute details.
        """
        return pulumi.get(self, "delivery_attribute_mappings")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        The Azure Resource Id that represents the endpoint of the Service Bus destination of an event subscription.
        """
        return pulumi.get(self, "resource_id")


@pulumi.output_type
class ServiceBusTopicEventSubscriptionDestinationResponse(dict):
    """
    Information about the service bus topic destination for an event subscription.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointType":
            suggest = "endpoint_type"
        elif key == "deliveryAttributeMappings":
            suggest = "delivery_attribute_mappings"
        elif key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceBusTopicEventSubscriptionDestinationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceBusTopicEventSubscriptionDestinationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceBusTopicEventSubscriptionDestinationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_type: str,
                 delivery_attribute_mappings: Optional[Sequence[Any]] = None,
                 resource_id: Optional[str] = None):
        """
        Information about the service bus topic destination for an event subscription.
        :param str endpoint_type: Type of the endpoint for the event subscription destination.
               Expected value is 'ServiceBusTopic'.
        :param Sequence[Union['DynamicDeliveryAttributeMappingResponse', 'StaticDeliveryAttributeMappingResponse']] delivery_attribute_mappings: Delivery attribute details.
        :param str resource_id: The Azure Resource Id that represents the endpoint of the Service Bus Topic destination of an event subscription.
        """
        pulumi.set(__self__, "endpoint_type", 'ServiceBusTopic')
        if delivery_attribute_mappings is not None:
            pulumi.set(__self__, "delivery_attribute_mappings", delivery_attribute_mappings)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> str:
        """
        Type of the endpoint for the event subscription destination.
        Expected value is 'ServiceBusTopic'.
        """
        return pulumi.get(self, "endpoint_type")

    @property
    @pulumi.getter(name="deliveryAttributeMappings")
    def delivery_attribute_mappings(self) -> Optional[Sequence[Any]]:
        """
        Delivery attribute details.
        """
        return pulumi.get(self, "delivery_attribute_mappings")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        The Azure Resource Id that represents the endpoint of the Service Bus Topic destination of an event subscription.
        """
        return pulumi.get(self, "resource_id")


@pulumi.output_type
class StaticDeliveryAttributeMappingResponse(dict):
    """
    Static delivery attribute mapping details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isSecret":
            suggest = "is_secret"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StaticDeliveryAttributeMappingResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StaticDeliveryAttributeMappingResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StaticDeliveryAttributeMappingResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 is_secret: Optional[bool] = None,
                 name: Optional[str] = None,
                 value: Optional[str] = None):
        """
        Static delivery attribute mapping details.
        :param str type: Type of the delivery attribute or header name.
               Expected value is 'Static'.
        :param bool is_secret: Boolean flag to tell if the attribute contains sensitive information .
        :param str name: Name of the delivery attribute or header.
        :param str value: Value of the delivery attribute.
        """
        pulumi.set(__self__, "type", 'Static')
        if is_secret is None:
            is_secret = False
        if is_secret is not None:
            pulumi.set(__self__, "is_secret", is_secret)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the delivery attribute or header name.
        Expected value is 'Static'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="isSecret")
    def is_secret(self) -> Optional[bool]:
        """
        Boolean flag to tell if the attribute contains sensitive information .
        """
        return pulumi.get(self, "is_secret")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the delivery attribute or header.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        Value of the delivery attribute.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class StorageBlobDeadLetterDestinationResponse(dict):
    """
    Information about the storage blob based dead letter destination.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointType":
            suggest = "endpoint_type"
        elif key == "blobContainerName":
            suggest = "blob_container_name"
        elif key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageBlobDeadLetterDestinationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageBlobDeadLetterDestinationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageBlobDeadLetterDestinationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_type: str,
                 blob_container_name: Optional[str] = None,
                 resource_id: Optional[str] = None):
        """
        Information about the storage blob based dead letter destination.
        :param str endpoint_type: Type of the endpoint for the dead letter destination
               Expected value is 'StorageBlob'.
        :param str blob_container_name: The name of the Storage blob container that is the destination of the deadletter events
        :param str resource_id: The Azure Resource ID of the storage account that is the destination of the deadletter events
        """
        pulumi.set(__self__, "endpoint_type", 'StorageBlob')
        if blob_container_name is not None:
            pulumi.set(__self__, "blob_container_name", blob_container_name)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> str:
        """
        Type of the endpoint for the dead letter destination
        Expected value is 'StorageBlob'.
        """
        return pulumi.get(self, "endpoint_type")

    @property
    @pulumi.getter(name="blobContainerName")
    def blob_container_name(self) -> Optional[str]:
        """
        The name of the Storage blob container that is the destination of the deadletter events
        """
        return pulumi.get(self, "blob_container_name")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        The Azure Resource ID of the storage account that is the destination of the deadletter events
        """
        return pulumi.get(self, "resource_id")


@pulumi.output_type
class StorageQueueEventSubscriptionDestinationResponse(dict):
    """
    Information about the storage queue destination for an event subscription.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointType":
            suggest = "endpoint_type"
        elif key == "queueMessageTimeToLiveInSeconds":
            suggest = "queue_message_time_to_live_in_seconds"
        elif key == "queueName":
            suggest = "queue_name"
        elif key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageQueueEventSubscriptionDestinationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageQueueEventSubscriptionDestinationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageQueueEventSubscriptionDestinationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_type: str,
                 queue_message_time_to_live_in_seconds: Optional[float] = None,
                 queue_name: Optional[str] = None,
                 resource_id: Optional[str] = None):
        """
        Information about the storage queue destination for an event subscription.
        :param str endpoint_type: Type of the endpoint for the event subscription destination.
               Expected value is 'StorageQueue'.
        :param float queue_message_time_to_live_in_seconds: Storage queue message time to live in seconds.
        :param str queue_name: The name of the Storage queue under a storage account that is the destination of an event subscription.
        :param str resource_id: The Azure Resource ID of the storage account that contains the queue that is the destination of an event subscription.
        """
        pulumi.set(__self__, "endpoint_type", 'StorageQueue')
        if queue_message_time_to_live_in_seconds is not None:
            pulumi.set(__self__, "queue_message_time_to_live_in_seconds", queue_message_time_to_live_in_seconds)
        if queue_name is not None:
            pulumi.set(__self__, "queue_name", queue_name)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> str:
        """
        Type of the endpoint for the event subscription destination.
        Expected value is 'StorageQueue'.
        """
        return pulumi.get(self, "endpoint_type")

    @property
    @pulumi.getter(name="queueMessageTimeToLiveInSeconds")
    def queue_message_time_to_live_in_seconds(self) -> Optional[float]:
        """
        Storage queue message time to live in seconds.
        """
        return pulumi.get(self, "queue_message_time_to_live_in_seconds")

    @property
    @pulumi.getter(name="queueName")
    def queue_name(self) -> Optional[str]:
        """
        The name of the Storage queue under a storage account that is the destination of an event subscription.
        """
        return pulumi.get(self, "queue_name")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        The Azure Resource ID of the storage account that contains the queue that is the destination of an event subscription.
        """
        return pulumi.get(self, "resource_id")


@pulumi.output_type
class StringBeginsWithAdvancedFilterResponse(dict):
    """
    StringBeginsWith Advanced Filter.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "operatorType":
            suggest = "operator_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StringBeginsWithAdvancedFilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StringBeginsWithAdvancedFilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StringBeginsWithAdvancedFilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operator_type: str,
                 key: Optional[str] = None,
                 values: Optional[Sequence[str]] = None):
        """
        StringBeginsWith Advanced Filter.
        :param str operator_type: The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
               Expected value is 'StringBeginsWith'.
        :param str key: The field/property in the event based on which you want to filter.
        :param Sequence[str] values: The set of filter values.
        """
        pulumi.set(__self__, "operator_type", 'StringBeginsWith')
        if key is not None:
            pulumi.set(__self__, "key", key)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="operatorType")
    def operator_type(self) -> str:
        """
        The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
        Expected value is 'StringBeginsWith'.
        """
        return pulumi.get(self, "operator_type")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The field/property in the event based on which you want to filter.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Optional[Sequence[str]]:
        """
        The set of filter values.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class StringContainsAdvancedFilterResponse(dict):
    """
    StringContains Advanced Filter.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "operatorType":
            suggest = "operator_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StringContainsAdvancedFilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StringContainsAdvancedFilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StringContainsAdvancedFilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operator_type: str,
                 key: Optional[str] = None,
                 values: Optional[Sequence[str]] = None):
        """
        StringContains Advanced Filter.
        :param str operator_type: The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
               Expected value is 'StringContains'.
        :param str key: The field/property in the event based on which you want to filter.
        :param Sequence[str] values: The set of filter values.
        """
        pulumi.set(__self__, "operator_type", 'StringContains')
        if key is not None:
            pulumi.set(__self__, "key", key)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="operatorType")
    def operator_type(self) -> str:
        """
        The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
        Expected value is 'StringContains'.
        """
        return pulumi.get(self, "operator_type")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The field/property in the event based on which you want to filter.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Optional[Sequence[str]]:
        """
        The set of filter values.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class StringEndsWithAdvancedFilterResponse(dict):
    """
    StringEndsWith Advanced Filter.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "operatorType":
            suggest = "operator_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StringEndsWithAdvancedFilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StringEndsWithAdvancedFilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StringEndsWithAdvancedFilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operator_type: str,
                 key: Optional[str] = None,
                 values: Optional[Sequence[str]] = None):
        """
        StringEndsWith Advanced Filter.
        :param str operator_type: The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
               Expected value is 'StringEndsWith'.
        :param str key: The field/property in the event based on which you want to filter.
        :param Sequence[str] values: The set of filter values.
        """
        pulumi.set(__self__, "operator_type", 'StringEndsWith')
        if key is not None:
            pulumi.set(__self__, "key", key)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="operatorType")
    def operator_type(self) -> str:
        """
        The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
        Expected value is 'StringEndsWith'.
        """
        return pulumi.get(self, "operator_type")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The field/property in the event based on which you want to filter.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Optional[Sequence[str]]:
        """
        The set of filter values.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class StringInAdvancedFilterResponse(dict):
    """
    StringIn Advanced Filter.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "operatorType":
            suggest = "operator_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StringInAdvancedFilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StringInAdvancedFilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StringInAdvancedFilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operator_type: str,
                 key: Optional[str] = None,
                 values: Optional[Sequence[str]] = None):
        """
        StringIn Advanced Filter.
        :param str operator_type: The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
               Expected value is 'StringIn'.
        :param str key: The field/property in the event based on which you want to filter.
        :param Sequence[str] values: The set of filter values.
        """
        pulumi.set(__self__, "operator_type", 'StringIn')
        if key is not None:
            pulumi.set(__self__, "key", key)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="operatorType")
    def operator_type(self) -> str:
        """
        The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
        Expected value is 'StringIn'.
        """
        return pulumi.get(self, "operator_type")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The field/property in the event based on which you want to filter.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Optional[Sequence[str]]:
        """
        The set of filter values.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class StringNotBeginsWithAdvancedFilterResponse(dict):
    """
    StringNotBeginsWith Advanced Filter.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "operatorType":
            suggest = "operator_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StringNotBeginsWithAdvancedFilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StringNotBeginsWithAdvancedFilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StringNotBeginsWithAdvancedFilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operator_type: str,
                 key: Optional[str] = None,
                 values: Optional[Sequence[str]] = None):
        """
        StringNotBeginsWith Advanced Filter.
        :param str operator_type: The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
               Expected value is 'StringNotBeginsWith'.
        :param str key: The field/property in the event based on which you want to filter.
        :param Sequence[str] values: The set of filter values.
        """
        pulumi.set(__self__, "operator_type", 'StringNotBeginsWith')
        if key is not None:
            pulumi.set(__self__, "key", key)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="operatorType")
    def operator_type(self) -> str:
        """
        The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
        Expected value is 'StringNotBeginsWith'.
        """
        return pulumi.get(self, "operator_type")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The field/property in the event based on which you want to filter.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Optional[Sequence[str]]:
        """
        The set of filter values.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class StringNotContainsAdvancedFilterResponse(dict):
    """
    StringNotContains Advanced Filter.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "operatorType":
            suggest = "operator_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StringNotContainsAdvancedFilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StringNotContainsAdvancedFilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StringNotContainsAdvancedFilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operator_type: str,
                 key: Optional[str] = None,
                 values: Optional[Sequence[str]] = None):
        """
        StringNotContains Advanced Filter.
        :param str operator_type: The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
               Expected value is 'StringNotContains'.
        :param str key: The field/property in the event based on which you want to filter.
        :param Sequence[str] values: The set of filter values.
        """
        pulumi.set(__self__, "operator_type", 'StringNotContains')
        if key is not None:
            pulumi.set(__self__, "key", key)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="operatorType")
    def operator_type(self) -> str:
        """
        The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
        Expected value is 'StringNotContains'.
        """
        return pulumi.get(self, "operator_type")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The field/property in the event based on which you want to filter.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Optional[Sequence[str]]:
        """
        The set of filter values.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class StringNotEndsWithAdvancedFilterResponse(dict):
    """
    StringNotEndsWith Advanced Filter.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "operatorType":
            suggest = "operator_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StringNotEndsWithAdvancedFilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StringNotEndsWithAdvancedFilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StringNotEndsWithAdvancedFilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operator_type: str,
                 key: Optional[str] = None,
                 values: Optional[Sequence[str]] = None):
        """
        StringNotEndsWith Advanced Filter.
        :param str operator_type: The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
               Expected value is 'StringNotEndsWith'.
        :param str key: The field/property in the event based on which you want to filter.
        :param Sequence[str] values: The set of filter values.
        """
        pulumi.set(__self__, "operator_type", 'StringNotEndsWith')
        if key is not None:
            pulumi.set(__self__, "key", key)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="operatorType")
    def operator_type(self) -> str:
        """
        The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
        Expected value is 'StringNotEndsWith'.
        """
        return pulumi.get(self, "operator_type")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The field/property in the event based on which you want to filter.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Optional[Sequence[str]]:
        """
        The set of filter values.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class StringNotInAdvancedFilterResponse(dict):
    """
    StringNotIn Advanced Filter.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "operatorType":
            suggest = "operator_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StringNotInAdvancedFilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StringNotInAdvancedFilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StringNotInAdvancedFilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operator_type: str,
                 key: Optional[str] = None,
                 values: Optional[Sequence[str]] = None):
        """
        StringNotIn Advanced Filter.
        :param str operator_type: The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
               Expected value is 'StringNotIn'.
        :param str key: The field/property in the event based on which you want to filter.
        :param Sequence[str] values: The set of filter values.
        """
        pulumi.set(__self__, "operator_type", 'StringNotIn')
        if key is not None:
            pulumi.set(__self__, "key", key)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="operatorType")
    def operator_type(self) -> str:
        """
        The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
        Expected value is 'StringNotIn'.
        """
        return pulumi.get(self, "operator_type")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The field/property in the event based on which you want to filter.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Optional[Sequence[str]]:
        """
        The set of filter values.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The timestamp of resource last modification (UTC)
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The timestamp of resource last modification (UTC)
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


@pulumi.output_type
class UserIdentityPropertiesResponse(dict):
    """
    The information about the user identity.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "principalId":
            suggest = "principal_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserIdentityPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserIdentityPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserIdentityPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: Optional[str] = None,
                 principal_id: Optional[str] = None):
        """
        The information about the user identity.
        :param str client_id: The client id of user assigned identity.
        :param str principal_id: The principal id of user assigned identity.
        """
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[str]:
        """
        The client id of user assigned identity.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[str]:
        """
        The principal id of user assigned identity.
        """
        return pulumi.get(self, "principal_id")


@pulumi.output_type
class WebHookEventSubscriptionDestinationResponse(dict):
    """
    Information about the webhook destination for an event subscription.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointBaseUrl":
            suggest = "endpoint_base_url"
        elif key == "endpointType":
            suggest = "endpoint_type"
        elif key == "azureActiveDirectoryApplicationIdOrUri":
            suggest = "azure_active_directory_application_id_or_uri"
        elif key == "azureActiveDirectoryTenantId":
            suggest = "azure_active_directory_tenant_id"
        elif key == "deliveryAttributeMappings":
            suggest = "delivery_attribute_mappings"
        elif key == "endpointUrl":
            suggest = "endpoint_url"
        elif key == "maxEventsPerBatch":
            suggest = "max_events_per_batch"
        elif key == "preferredBatchSizeInKilobytes":
            suggest = "preferred_batch_size_in_kilobytes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebHookEventSubscriptionDestinationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebHookEventSubscriptionDestinationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebHookEventSubscriptionDestinationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_base_url: str,
                 endpoint_type: str,
                 azure_active_directory_application_id_or_uri: Optional[str] = None,
                 azure_active_directory_tenant_id: Optional[str] = None,
                 delivery_attribute_mappings: Optional[Sequence[Any]] = None,
                 endpoint_url: Optional[str] = None,
                 max_events_per_batch: Optional[int] = None,
                 preferred_batch_size_in_kilobytes: Optional[int] = None):
        """
        Information about the webhook destination for an event subscription.
        :param str endpoint_base_url: The base URL that represents the endpoint of the destination of an event subscription.
        :param str endpoint_type: Type of the endpoint for the event subscription destination.
               Expected value is 'WebHook'.
        :param str azure_active_directory_application_id_or_uri: The Azure Active Directory Application ID or URI to get the access token that will be included as the bearer token in delivery requests.
        :param str azure_active_directory_tenant_id: The Azure Active Directory Tenant ID to get the access token that will be included as the bearer token in delivery requests.
        :param Sequence[Union['DynamicDeliveryAttributeMappingResponse', 'StaticDeliveryAttributeMappingResponse']] delivery_attribute_mappings: Delivery attribute details.
        :param str endpoint_url: The URL that represents the endpoint of the destination of an event subscription.
        :param int max_events_per_batch: Maximum number of events per batch.
        :param int preferred_batch_size_in_kilobytes: Preferred batch size in Kilobytes.
        """
        pulumi.set(__self__, "endpoint_base_url", endpoint_base_url)
        pulumi.set(__self__, "endpoint_type", 'WebHook')
        if azure_active_directory_application_id_or_uri is not None:
            pulumi.set(__self__, "azure_active_directory_application_id_or_uri", azure_active_directory_application_id_or_uri)
        if azure_active_directory_tenant_id is not None:
            pulumi.set(__self__, "azure_active_directory_tenant_id", azure_active_directory_tenant_id)
        if delivery_attribute_mappings is not None:
            pulumi.set(__self__, "delivery_attribute_mappings", delivery_attribute_mappings)
        if endpoint_url is not None:
            pulumi.set(__self__, "endpoint_url", endpoint_url)
        if max_events_per_batch is None:
            max_events_per_batch = 1
        if max_events_per_batch is not None:
            pulumi.set(__self__, "max_events_per_batch", max_events_per_batch)
        if preferred_batch_size_in_kilobytes is None:
            preferred_batch_size_in_kilobytes = 64
        if preferred_batch_size_in_kilobytes is not None:
            pulumi.set(__self__, "preferred_batch_size_in_kilobytes", preferred_batch_size_in_kilobytes)

    @property
    @pulumi.getter(name="endpointBaseUrl")
    def endpoint_base_url(self) -> str:
        """
        The base URL that represents the endpoint of the destination of an event subscription.
        """
        return pulumi.get(self, "endpoint_base_url")

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> str:
        """
        Type of the endpoint for the event subscription destination.
        Expected value is 'WebHook'.
        """
        return pulumi.get(self, "endpoint_type")

    @property
    @pulumi.getter(name="azureActiveDirectoryApplicationIdOrUri")
    def azure_active_directory_application_id_or_uri(self) -> Optional[str]:
        """
        The Azure Active Directory Application ID or URI to get the access token that will be included as the bearer token in delivery requests.
        """
        return pulumi.get(self, "azure_active_directory_application_id_or_uri")

    @property
    @pulumi.getter(name="azureActiveDirectoryTenantId")
    def azure_active_directory_tenant_id(self) -> Optional[str]:
        """
        The Azure Active Directory Tenant ID to get the access token that will be included as the bearer token in delivery requests.
        """
        return pulumi.get(self, "azure_active_directory_tenant_id")

    @property
    @pulumi.getter(name="deliveryAttributeMappings")
    def delivery_attribute_mappings(self) -> Optional[Sequence[Any]]:
        """
        Delivery attribute details.
        """
        return pulumi.get(self, "delivery_attribute_mappings")

    @property
    @pulumi.getter(name="endpointUrl")
    def endpoint_url(self) -> Optional[str]:
        """
        The URL that represents the endpoint of the destination of an event subscription.
        """
        return pulumi.get(self, "endpoint_url")

    @property
    @pulumi.getter(name="maxEventsPerBatch")
    def max_events_per_batch(self) -> Optional[int]:
        """
        Maximum number of events per batch.
        """
        return pulumi.get(self, "max_events_per_batch")

    @property
    @pulumi.getter(name="preferredBatchSizeInKilobytes")
    def preferred_batch_size_in_kilobytes(self) -> Optional[int]:
        """
        Preferred batch size in Kilobytes.
        """
        return pulumi.get(self, "preferred_batch_size_in_kilobytes")


