# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AzureDataExplorerConnectionPropertiesResponse',
    'ConnectionPropertiesResponse',
    'ConnectionPropertiesResponsePrivateLinkServiceConnectionState',
    'DigitalTwinsIdentityResponse',
    'EventGridResponse',
    'EventHubResponse',
    'PrivateEndpointConnectionResponse',
    'PrivateEndpointResponse',
    'ServiceBusResponse',
    'SystemDataResponse',
]

@pulumi.output_type
class AzureDataExplorerConnectionPropertiesResponse(dict):
    """
    Properties of a time series database connection to Azure Data Explorer with data being sent via an EventHub.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adxDatabaseName":
            suggest = "adx_database_name"
        elif key == "adxEndpointUri":
            suggest = "adx_endpoint_uri"
        elif key == "adxResourceId":
            suggest = "adx_resource_id"
        elif key == "connectionType":
            suggest = "connection_type"
        elif key == "eventHubEndpointUri":
            suggest = "event_hub_endpoint_uri"
        elif key == "eventHubEntityPath":
            suggest = "event_hub_entity_path"
        elif key == "eventHubNamespaceResourceId":
            suggest = "event_hub_namespace_resource_id"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "adxTableName":
            suggest = "adx_table_name"
        elif key == "eventHubConsumerGroup":
            suggest = "event_hub_consumer_group"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureDataExplorerConnectionPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureDataExplorerConnectionPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureDataExplorerConnectionPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 adx_database_name: str,
                 adx_endpoint_uri: str,
                 adx_resource_id: str,
                 connection_type: str,
                 event_hub_endpoint_uri: str,
                 event_hub_entity_path: str,
                 event_hub_namespace_resource_id: str,
                 provisioning_state: str,
                 adx_table_name: Optional[str] = None,
                 event_hub_consumer_group: Optional[str] = None):
        """
        Properties of a time series database connection to Azure Data Explorer with data being sent via an EventHub.
        :param str adx_database_name: The name of the Azure Data Explorer database.
        :param str adx_endpoint_uri: The URI of the Azure Data Explorer endpoint.
        :param str adx_resource_id: The resource ID of the Azure Data Explorer cluster.
        :param str connection_type: The type of time series connection resource.
               Expected value is 'AzureDataExplorer'.
        :param str event_hub_endpoint_uri: The URL of the EventHub namespace for identity-based authentication. It must include the protocol sb://
        :param str event_hub_entity_path: The EventHub name in the EventHub namespace for identity-based authentication.
        :param str event_hub_namespace_resource_id: The resource ID of the EventHub namespace.
        :param str provisioning_state: The provisioning state.
        :param str adx_table_name: The name of the Azure Data Explorer table.
        :param str event_hub_consumer_group: The EventHub consumer group to use when ADX reads from EventHub. Defaults to $Default.
        """
        pulumi.set(__self__, "adx_database_name", adx_database_name)
        pulumi.set(__self__, "adx_endpoint_uri", adx_endpoint_uri)
        pulumi.set(__self__, "adx_resource_id", adx_resource_id)
        pulumi.set(__self__, "connection_type", 'AzureDataExplorer')
        pulumi.set(__self__, "event_hub_endpoint_uri", event_hub_endpoint_uri)
        pulumi.set(__self__, "event_hub_entity_path", event_hub_entity_path)
        pulumi.set(__self__, "event_hub_namespace_resource_id", event_hub_namespace_resource_id)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if adx_table_name is not None:
            pulumi.set(__self__, "adx_table_name", adx_table_name)
        if event_hub_consumer_group is not None:
            pulumi.set(__self__, "event_hub_consumer_group", event_hub_consumer_group)

    @property
    @pulumi.getter(name="adxDatabaseName")
    def adx_database_name(self) -> str:
        """
        The name of the Azure Data Explorer database.
        """
        return pulumi.get(self, "adx_database_name")

    @property
    @pulumi.getter(name="adxEndpointUri")
    def adx_endpoint_uri(self) -> str:
        """
        The URI of the Azure Data Explorer endpoint.
        """
        return pulumi.get(self, "adx_endpoint_uri")

    @property
    @pulumi.getter(name="adxResourceId")
    def adx_resource_id(self) -> str:
        """
        The resource ID of the Azure Data Explorer cluster.
        """
        return pulumi.get(self, "adx_resource_id")

    @property
    @pulumi.getter(name="connectionType")
    def connection_type(self) -> str:
        """
        The type of time series connection resource.
        Expected value is 'AzureDataExplorer'.
        """
        return pulumi.get(self, "connection_type")

    @property
    @pulumi.getter(name="eventHubEndpointUri")
    def event_hub_endpoint_uri(self) -> str:
        """
        The URL of the EventHub namespace for identity-based authentication. It must include the protocol sb://
        """
        return pulumi.get(self, "event_hub_endpoint_uri")

    @property
    @pulumi.getter(name="eventHubEntityPath")
    def event_hub_entity_path(self) -> str:
        """
        The EventHub name in the EventHub namespace for identity-based authentication.
        """
        return pulumi.get(self, "event_hub_entity_path")

    @property
    @pulumi.getter(name="eventHubNamespaceResourceId")
    def event_hub_namespace_resource_id(self) -> str:
        """
        The resource ID of the EventHub namespace.
        """
        return pulumi.get(self, "event_hub_namespace_resource_id")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="adxTableName")
    def adx_table_name(self) -> Optional[str]:
        """
        The name of the Azure Data Explorer table.
        """
        return pulumi.get(self, "adx_table_name")

    @property
    @pulumi.getter(name="eventHubConsumerGroup")
    def event_hub_consumer_group(self) -> Optional[str]:
        """
        The EventHub consumer group to use when ADX reads from EventHub. Defaults to $Default.
        """
        return pulumi.get(self, "event_hub_consumer_group")


@pulumi.output_type
class ConnectionPropertiesResponse(dict):
    """
    The properties of a private endpoint connection.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "groupIds":
            suggest = "group_ids"
        elif key == "privateEndpoint":
            suggest = "private_endpoint"
        elif key == "privateLinkServiceConnectionState":
            suggest = "private_link_service_connection_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provisioning_state: str,
                 group_ids: Optional[Sequence[str]] = None,
                 private_endpoint: Optional['outputs.PrivateEndpointResponse'] = None,
                 private_link_service_connection_state: Optional['outputs.ConnectionPropertiesResponsePrivateLinkServiceConnectionState'] = None):
        """
        The properties of a private endpoint connection.
        :param str provisioning_state: The provisioning state.
        :param Sequence[str] group_ids: The list of group ids for the private endpoint connection.
        :param 'PrivateEndpointResponse' private_endpoint: The private endpoint.
        :param 'ConnectionPropertiesResponsePrivateLinkServiceConnectionState' private_link_service_connection_state: The connection state.
        """
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if group_ids is not None:
            pulumi.set(__self__, "group_ids", group_ids)
        if private_endpoint is not None:
            pulumi.set(__self__, "private_endpoint", private_endpoint)
        if private_link_service_connection_state is not None:
            pulumi.set(__self__, "private_link_service_connection_state", private_link_service_connection_state)

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="groupIds")
    def group_ids(self) -> Optional[Sequence[str]]:
        """
        The list of group ids for the private endpoint connection.
        """
        return pulumi.get(self, "group_ids")

    @property
    @pulumi.getter(name="privateEndpoint")
    def private_endpoint(self) -> Optional['outputs.PrivateEndpointResponse']:
        """
        The private endpoint.
        """
        return pulumi.get(self, "private_endpoint")

    @property
    @pulumi.getter(name="privateLinkServiceConnectionState")
    def private_link_service_connection_state(self) -> Optional['outputs.ConnectionPropertiesResponsePrivateLinkServiceConnectionState']:
        """
        The connection state.
        """
        return pulumi.get(self, "private_link_service_connection_state")


@pulumi.output_type
class ConnectionPropertiesResponsePrivateLinkServiceConnectionState(dict):
    """
    The connection state.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionsRequired":
            suggest = "actions_required"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionPropertiesResponsePrivateLinkServiceConnectionState. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionPropertiesResponsePrivateLinkServiceConnectionState.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionPropertiesResponsePrivateLinkServiceConnectionState.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: str,
                 status: str,
                 actions_required: Optional[str] = None):
        """
        The connection state.
        :param str description: The description for the current state of a private endpoint connection.
        :param str status: The status of a private endpoint connection.
        :param str actions_required: Actions required for a private endpoint connection.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "status", status)
        if actions_required is not None:
            pulumi.set(__self__, "actions_required", actions_required)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description for the current state of a private endpoint connection.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of a private endpoint connection.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="actionsRequired")
    def actions_required(self) -> Optional[str]:
        """
        Actions required for a private endpoint connection.
        """
        return pulumi.get(self, "actions_required")


@pulumi.output_type
class DigitalTwinsIdentityResponse(dict):
    """
    The managed identity for the DigitalTwinsInstance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DigitalTwinsIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DigitalTwinsIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DigitalTwinsIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: str,
                 tenant_id: str,
                 type: Optional[str] = None):
        """
        The managed identity for the DigitalTwinsInstance.
        :param str principal_id: The object id of the Managed Identity Resource. This will be sent to the RP from ARM via the x-ms-identity-principal-id header in the PUT request if the resource has a systemAssigned(implicit) identity
        :param str tenant_id: The tenant id of the Managed Identity Resource. This will be sent to the RP from ARM via the x-ms-client-tenant-id header in the PUT request if the resource has a systemAssigned(implicit) identity
        :param str type: The type of Managed Identity used by the DigitalTwinsInstance. Only SystemAssigned is supported.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The object id of the Managed Identity Resource. This will be sent to the RP from ARM via the x-ms-identity-principal-id header in the PUT request if the resource has a systemAssigned(implicit) identity
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The tenant id of the Managed Identity Resource. This will be sent to the RP from ARM via the x-ms-client-tenant-id header in the PUT request if the resource has a systemAssigned(implicit) identity
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of Managed Identity used by the DigitalTwinsInstance. Only SystemAssigned is supported.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class EventGridResponse(dict):
    """
    Properties related to EventGrid.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKey1":
            suggest = "access_key1"
        elif key == "createdTime":
            suggest = "created_time"
        elif key == "endpointType":
            suggest = "endpoint_type"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "topicEndpoint":
            suggest = "topic_endpoint"
        elif key == "accessKey2":
            suggest = "access_key2"
        elif key == "authenticationType":
            suggest = "authentication_type"
        elif key == "deadLetterSecret":
            suggest = "dead_letter_secret"
        elif key == "deadLetterUri":
            suggest = "dead_letter_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventGridResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventGridResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventGridResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_key1: str,
                 created_time: str,
                 endpoint_type: str,
                 provisioning_state: str,
                 topic_endpoint: str,
                 access_key2: Optional[str] = None,
                 authentication_type: Optional[str] = None,
                 dead_letter_secret: Optional[str] = None,
                 dead_letter_uri: Optional[str] = None):
        """
        Properties related to EventGrid.
        :param str access_key1: EventGrid secondary accesskey. Will be obfuscated during read.
        :param str created_time: Time when the Endpoint was added to DigitalTwinsInstance.
        :param str endpoint_type: The type of Digital Twins endpoint
               Expected value is 'EventGrid'.
        :param str provisioning_state: The provisioning state.
        :param str topic_endpoint: EventGrid Topic Endpoint.
        :param str access_key2: EventGrid secondary accesskey. Will be obfuscated during read.
        :param str authentication_type: Specifies the authentication type being used for connecting to the endpoint. Defaults to 'KeyBased'. If 'KeyBased' is selected, a connection string must be specified (at least the primary connection string). If 'IdentityBased' is select, the endpointUri and entityPath properties must be specified.
        :param str dead_letter_secret: Dead letter storage secret for key-based authentication. Will be obfuscated during read.
        :param str dead_letter_uri: Dead letter storage URL for identity-based authentication.
        """
        pulumi.set(__self__, "access_key1", access_key1)
        pulumi.set(__self__, "created_time", created_time)
        pulumi.set(__self__, "endpoint_type", 'EventGrid')
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "topic_endpoint", topic_endpoint)
        if access_key2 is not None:
            pulumi.set(__self__, "access_key2", access_key2)
        if authentication_type is not None:
            pulumi.set(__self__, "authentication_type", authentication_type)
        if dead_letter_secret is not None:
            pulumi.set(__self__, "dead_letter_secret", dead_letter_secret)
        if dead_letter_uri is not None:
            pulumi.set(__self__, "dead_letter_uri", dead_letter_uri)

    @property
    @pulumi.getter(name="accessKey1")
    def access_key1(self) -> str:
        """
        EventGrid secondary accesskey. Will be obfuscated during read.
        """
        return pulumi.get(self, "access_key1")

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> str:
        """
        Time when the Endpoint was added to DigitalTwinsInstance.
        """
        return pulumi.get(self, "created_time")

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> str:
        """
        The type of Digital Twins endpoint
        Expected value is 'EventGrid'.
        """
        return pulumi.get(self, "endpoint_type")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="topicEndpoint")
    def topic_endpoint(self) -> str:
        """
        EventGrid Topic Endpoint.
        """
        return pulumi.get(self, "topic_endpoint")

    @property
    @pulumi.getter(name="accessKey2")
    def access_key2(self) -> Optional[str]:
        """
        EventGrid secondary accesskey. Will be obfuscated during read.
        """
        return pulumi.get(self, "access_key2")

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> Optional[str]:
        """
        Specifies the authentication type being used for connecting to the endpoint. Defaults to 'KeyBased'. If 'KeyBased' is selected, a connection string must be specified (at least the primary connection string). If 'IdentityBased' is select, the endpointUri and entityPath properties must be specified.
        """
        return pulumi.get(self, "authentication_type")

    @property
    @pulumi.getter(name="deadLetterSecret")
    def dead_letter_secret(self) -> Optional[str]:
        """
        Dead letter storage secret for key-based authentication. Will be obfuscated during read.
        """
        return pulumi.get(self, "dead_letter_secret")

    @property
    @pulumi.getter(name="deadLetterUri")
    def dead_letter_uri(self) -> Optional[str]:
        """
        Dead letter storage URL for identity-based authentication.
        """
        return pulumi.get(self, "dead_letter_uri")


@pulumi.output_type
class EventHubResponse(dict):
    """
    Properties related to EventHub.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdTime":
            suggest = "created_time"
        elif key == "endpointType":
            suggest = "endpoint_type"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "authenticationType":
            suggest = "authentication_type"
        elif key == "connectionStringPrimaryKey":
            suggest = "connection_string_primary_key"
        elif key == "connectionStringSecondaryKey":
            suggest = "connection_string_secondary_key"
        elif key == "deadLetterSecret":
            suggest = "dead_letter_secret"
        elif key == "deadLetterUri":
            suggest = "dead_letter_uri"
        elif key == "endpointUri":
            suggest = "endpoint_uri"
        elif key == "entityPath":
            suggest = "entity_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventHubResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventHubResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventHubResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_time: str,
                 endpoint_type: str,
                 provisioning_state: str,
                 authentication_type: Optional[str] = None,
                 connection_string_primary_key: Optional[str] = None,
                 connection_string_secondary_key: Optional[str] = None,
                 dead_letter_secret: Optional[str] = None,
                 dead_letter_uri: Optional[str] = None,
                 endpoint_uri: Optional[str] = None,
                 entity_path: Optional[str] = None):
        """
        Properties related to EventHub.
        :param str created_time: Time when the Endpoint was added to DigitalTwinsInstance.
        :param str endpoint_type: The type of Digital Twins endpoint
               Expected value is 'EventHub'.
        :param str provisioning_state: The provisioning state.
        :param str authentication_type: Specifies the authentication type being used for connecting to the endpoint. Defaults to 'KeyBased'. If 'KeyBased' is selected, a connection string must be specified (at least the primary connection string). If 'IdentityBased' is select, the endpointUri and entityPath properties must be specified.
        :param str connection_string_primary_key: PrimaryConnectionString of the endpoint for key-based authentication. Will be obfuscated during read.
        :param str connection_string_secondary_key: SecondaryConnectionString of the endpoint for key-based authentication. Will be obfuscated during read.
        :param str dead_letter_secret: Dead letter storage secret for key-based authentication. Will be obfuscated during read.
        :param str dead_letter_uri: Dead letter storage URL for identity-based authentication.
        :param str endpoint_uri: The URL of the EventHub namespace for identity-based authentication. It must include the protocol 'sb://'.
        :param str entity_path: The EventHub name in the EventHub namespace for identity-based authentication.
        """
        pulumi.set(__self__, "created_time", created_time)
        pulumi.set(__self__, "endpoint_type", 'EventHub')
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if authentication_type is not None:
            pulumi.set(__self__, "authentication_type", authentication_type)
        if connection_string_primary_key is not None:
            pulumi.set(__self__, "connection_string_primary_key", connection_string_primary_key)
        if connection_string_secondary_key is not None:
            pulumi.set(__self__, "connection_string_secondary_key", connection_string_secondary_key)
        if dead_letter_secret is not None:
            pulumi.set(__self__, "dead_letter_secret", dead_letter_secret)
        if dead_letter_uri is not None:
            pulumi.set(__self__, "dead_letter_uri", dead_letter_uri)
        if endpoint_uri is not None:
            pulumi.set(__self__, "endpoint_uri", endpoint_uri)
        if entity_path is not None:
            pulumi.set(__self__, "entity_path", entity_path)

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> str:
        """
        Time when the Endpoint was added to DigitalTwinsInstance.
        """
        return pulumi.get(self, "created_time")

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> str:
        """
        The type of Digital Twins endpoint
        Expected value is 'EventHub'.
        """
        return pulumi.get(self, "endpoint_type")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> Optional[str]:
        """
        Specifies the authentication type being used for connecting to the endpoint. Defaults to 'KeyBased'. If 'KeyBased' is selected, a connection string must be specified (at least the primary connection string). If 'IdentityBased' is select, the endpointUri and entityPath properties must be specified.
        """
        return pulumi.get(self, "authentication_type")

    @property
    @pulumi.getter(name="connectionStringPrimaryKey")
    def connection_string_primary_key(self) -> Optional[str]:
        """
        PrimaryConnectionString of the endpoint for key-based authentication. Will be obfuscated during read.
        """
        return pulumi.get(self, "connection_string_primary_key")

    @property
    @pulumi.getter(name="connectionStringSecondaryKey")
    def connection_string_secondary_key(self) -> Optional[str]:
        """
        SecondaryConnectionString of the endpoint for key-based authentication. Will be obfuscated during read.
        """
        return pulumi.get(self, "connection_string_secondary_key")

    @property
    @pulumi.getter(name="deadLetterSecret")
    def dead_letter_secret(self) -> Optional[str]:
        """
        Dead letter storage secret for key-based authentication. Will be obfuscated during read.
        """
        return pulumi.get(self, "dead_letter_secret")

    @property
    @pulumi.getter(name="deadLetterUri")
    def dead_letter_uri(self) -> Optional[str]:
        """
        Dead letter storage URL for identity-based authentication.
        """
        return pulumi.get(self, "dead_letter_uri")

    @property
    @pulumi.getter(name="endpointUri")
    def endpoint_uri(self) -> Optional[str]:
        """
        The URL of the EventHub namespace for identity-based authentication. It must include the protocol 'sb://'.
        """
        return pulumi.get(self, "endpoint_uri")

    @property
    @pulumi.getter(name="entityPath")
    def entity_path(self) -> Optional[str]:
        """
        The EventHub name in the EventHub namespace for identity-based authentication.
        """
        return pulumi.get(self, "entity_path")


@pulumi.output_type
class PrivateEndpointConnectionResponse(dict):
    """
    The private endpoint connection of a Digital Twin.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "systemData":
            suggest = "system_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateEndpointConnectionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateEndpointConnectionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateEndpointConnectionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 name: str,
                 properties: 'outputs.ConnectionPropertiesResponse',
                 system_data: 'outputs.SystemDataResponse',
                 type: str):
        """
        The private endpoint connection of a Digital Twin.
        :param str id: The resource identifier.
        :param str name: The resource name.
        :param 'ConnectionPropertiesResponse' properties: The connection properties.
        :param 'SystemDataResponse' system_data: Metadata pertaining to creation and last modification of the private endpoint connection.
        :param str type: The resource type.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "properties", properties)
        pulumi.set(__self__, "system_data", system_data)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The resource identifier.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def properties(self) -> 'outputs.ConnectionPropertiesResponse':
        """
        The connection properties.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> 'outputs.SystemDataResponse':
        """
        Metadata pertaining to creation and last modification of the private endpoint connection.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The resource type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class PrivateEndpointResponse(dict):
    """
    The private endpoint property of a private endpoint connection.
    """
    def __init__(__self__, *,
                 id: str):
        """
        The private endpoint property of a private endpoint connection.
        :param str id: The resource identifier.
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The resource identifier.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class ServiceBusResponse(dict):
    """
    Properties related to ServiceBus.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdTime":
            suggest = "created_time"
        elif key == "endpointType":
            suggest = "endpoint_type"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "authenticationType":
            suggest = "authentication_type"
        elif key == "deadLetterSecret":
            suggest = "dead_letter_secret"
        elif key == "deadLetterUri":
            suggest = "dead_letter_uri"
        elif key == "endpointUri":
            suggest = "endpoint_uri"
        elif key == "entityPath":
            suggest = "entity_path"
        elif key == "primaryConnectionString":
            suggest = "primary_connection_string"
        elif key == "secondaryConnectionString":
            suggest = "secondary_connection_string"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceBusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceBusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceBusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_time: str,
                 endpoint_type: str,
                 provisioning_state: str,
                 authentication_type: Optional[str] = None,
                 dead_letter_secret: Optional[str] = None,
                 dead_letter_uri: Optional[str] = None,
                 endpoint_uri: Optional[str] = None,
                 entity_path: Optional[str] = None,
                 primary_connection_string: Optional[str] = None,
                 secondary_connection_string: Optional[str] = None):
        """
        Properties related to ServiceBus.
        :param str created_time: Time when the Endpoint was added to DigitalTwinsInstance.
        :param str endpoint_type: The type of Digital Twins endpoint
               Expected value is 'ServiceBus'.
        :param str provisioning_state: The provisioning state.
        :param str authentication_type: Specifies the authentication type being used for connecting to the endpoint. Defaults to 'KeyBased'. If 'KeyBased' is selected, a connection string must be specified (at least the primary connection string). If 'IdentityBased' is select, the endpointUri and entityPath properties must be specified.
        :param str dead_letter_secret: Dead letter storage secret for key-based authentication. Will be obfuscated during read.
        :param str dead_letter_uri: Dead letter storage URL for identity-based authentication.
        :param str endpoint_uri: The URL of the ServiceBus namespace for identity-based authentication. It must include the protocol 'sb://'.
        :param str entity_path: The ServiceBus Topic name for identity-based authentication.
        :param str primary_connection_string: PrimaryConnectionString of the endpoint for key-based authentication. Will be obfuscated during read.
        :param str secondary_connection_string: SecondaryConnectionString of the endpoint for key-based authentication. Will be obfuscated during read.
        """
        pulumi.set(__self__, "created_time", created_time)
        pulumi.set(__self__, "endpoint_type", 'ServiceBus')
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if authentication_type is not None:
            pulumi.set(__self__, "authentication_type", authentication_type)
        if dead_letter_secret is not None:
            pulumi.set(__self__, "dead_letter_secret", dead_letter_secret)
        if dead_letter_uri is not None:
            pulumi.set(__self__, "dead_letter_uri", dead_letter_uri)
        if endpoint_uri is not None:
            pulumi.set(__self__, "endpoint_uri", endpoint_uri)
        if entity_path is not None:
            pulumi.set(__self__, "entity_path", entity_path)
        if primary_connection_string is not None:
            pulumi.set(__self__, "primary_connection_string", primary_connection_string)
        if secondary_connection_string is not None:
            pulumi.set(__self__, "secondary_connection_string", secondary_connection_string)

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> str:
        """
        Time when the Endpoint was added to DigitalTwinsInstance.
        """
        return pulumi.get(self, "created_time")

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> str:
        """
        The type of Digital Twins endpoint
        Expected value is 'ServiceBus'.
        """
        return pulumi.get(self, "endpoint_type")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> Optional[str]:
        """
        Specifies the authentication type being used for connecting to the endpoint. Defaults to 'KeyBased'. If 'KeyBased' is selected, a connection string must be specified (at least the primary connection string). If 'IdentityBased' is select, the endpointUri and entityPath properties must be specified.
        """
        return pulumi.get(self, "authentication_type")

    @property
    @pulumi.getter(name="deadLetterSecret")
    def dead_letter_secret(self) -> Optional[str]:
        """
        Dead letter storage secret for key-based authentication. Will be obfuscated during read.
        """
        return pulumi.get(self, "dead_letter_secret")

    @property
    @pulumi.getter(name="deadLetterUri")
    def dead_letter_uri(self) -> Optional[str]:
        """
        Dead letter storage URL for identity-based authentication.
        """
        return pulumi.get(self, "dead_letter_uri")

    @property
    @pulumi.getter(name="endpointUri")
    def endpoint_uri(self) -> Optional[str]:
        """
        The URL of the ServiceBus namespace for identity-based authentication. It must include the protocol 'sb://'.
        """
        return pulumi.get(self, "endpoint_uri")

    @property
    @pulumi.getter(name="entityPath")
    def entity_path(self) -> Optional[str]:
        """
        The ServiceBus Topic name for identity-based authentication.
        """
        return pulumi.get(self, "entity_path")

    @property
    @pulumi.getter(name="primaryConnectionString")
    def primary_connection_string(self) -> Optional[str]:
        """
        PrimaryConnectionString of the endpoint for key-based authentication. Will be obfuscated during read.
        """
        return pulumi.get(self, "primary_connection_string")

    @property
    @pulumi.getter(name="secondaryConnectionString")
    def secondary_connection_string(self) -> Optional[str]:
        """
        SecondaryConnectionString of the endpoint for key-based authentication. Will be obfuscated during read.
        """
        return pulumi.get(self, "secondary_connection_string")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The timestamp of resource last modification (UTC)
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The timestamp of resource last modification (UTC)
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


