# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['VirtualMachineArgs', 'VirtualMachine']

@pulumi.input_type
class VirtualMachineArgs:
    def __init__(__self__, *,
                 lab_name: pulumi.Input[str],
                 resource_group_name: pulumi.Input[str],
                 allow_claim: Optional[pulumi.Input[bool]] = None,
                 artifacts: Optional[pulumi.Input[Sequence[pulumi.Input['ArtifactInstallPropertiesArgs']]]] = None,
                 created_date: Optional[pulumi.Input[str]] = None,
                 custom_image_id: Optional[pulumi.Input[str]] = None,
                 data_disk_parameters: Optional[pulumi.Input[Sequence[pulumi.Input['DataDiskPropertiesArgs']]]] = None,
                 disallow_public_ip_address: Optional[pulumi.Input[bool]] = None,
                 environment_id: Optional[pulumi.Input[str]] = None,
                 expiration_date: Optional[pulumi.Input[str]] = None,
                 gallery_image_reference: Optional[pulumi.Input['GalleryImageReferenceArgs']] = None,
                 is_authentication_with_ssh_key: Optional[pulumi.Input[bool]] = None,
                 lab_subnet_name: Optional[pulumi.Input[str]] = None,
                 lab_virtual_network_id: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_interface: Optional[pulumi.Input['NetworkInterfacePropertiesArgs']] = None,
                 notes: Optional[pulumi.Input[str]] = None,
                 owner_object_id: Optional[pulumi.Input[str]] = None,
                 owner_user_principal_name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 plan_id: Optional[pulumi.Input[str]] = None,
                 schedule_parameters: Optional[pulumi.Input[Sequence[pulumi.Input['ScheduleCreationParameterArgs']]]] = None,
                 size: Optional[pulumi.Input[str]] = None,
                 ssh_key: Optional[pulumi.Input[str]] = None,
                 storage_type: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 user_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a VirtualMachine resource.
        :param pulumi.Input[str] lab_name: The name of the lab.
        :param pulumi.Input[str] resource_group_name: The name of the resource group.
        :param pulumi.Input[bool] allow_claim: Indicates whether another user can take ownership of the virtual machine
        :param pulumi.Input[Sequence[pulumi.Input['ArtifactInstallPropertiesArgs']]] artifacts: The artifacts to be installed on the virtual machine.
        :param pulumi.Input[str] created_date: The creation date of the virtual machine.
        :param pulumi.Input[str] custom_image_id: The custom image identifier of the virtual machine.
        :param pulumi.Input[Sequence[pulumi.Input['DataDiskPropertiesArgs']]] data_disk_parameters: New or existing data disks to attach to the virtual machine after creation
        :param pulumi.Input[bool] disallow_public_ip_address: Indicates whether the virtual machine is to be created without a public IP address.
        :param pulumi.Input[str] environment_id: The resource ID of the environment that contains this virtual machine, if any.
        :param pulumi.Input[str] expiration_date: The expiration date for VM.
        :param pulumi.Input['GalleryImageReferenceArgs'] gallery_image_reference: The Microsoft Azure Marketplace image reference of the virtual machine.
        :param pulumi.Input[bool] is_authentication_with_ssh_key: Indicates whether this virtual machine uses an SSH key for authentication.
        :param pulumi.Input[str] lab_subnet_name: The lab subnet name of the virtual machine.
        :param pulumi.Input[str] lab_virtual_network_id: The lab virtual network identifier of the virtual machine.
        :param pulumi.Input[str] location: The location of the resource.
        :param pulumi.Input[str] name: The name of the virtual machine.
        :param pulumi.Input['NetworkInterfacePropertiesArgs'] network_interface: The network interface properties.
        :param pulumi.Input[str] notes: The notes of the virtual machine.
        :param pulumi.Input[str] owner_object_id: The object identifier of the owner of the virtual machine.
        :param pulumi.Input[str] owner_user_principal_name: The user principal name of the virtual machine owner.
        :param pulumi.Input[str] password: The password of the virtual machine administrator.
        :param pulumi.Input[str] plan_id: The id of the plan associated with the virtual machine image
        :param pulumi.Input[Sequence[pulumi.Input['ScheduleCreationParameterArgs']]] schedule_parameters: Virtual Machine schedules to be created
        :param pulumi.Input[str] size: The size of the virtual machine.
        :param pulumi.Input[str] ssh_key: The SSH key of the virtual machine administrator.
        :param pulumi.Input[str] storage_type: Storage type to use for virtual machine (i.e. Standard, Premium).
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The tags of the resource.
        :param pulumi.Input[str] user_name: The user name of the virtual machine.
        """
        pulumi.set(__self__, "lab_name", lab_name)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if allow_claim is None:
            allow_claim = False
        if allow_claim is not None:
            pulumi.set(__self__, "allow_claim", allow_claim)
        if artifacts is not None:
            pulumi.set(__self__, "artifacts", artifacts)
        if created_date is not None:
            pulumi.set(__self__, "created_date", created_date)
        if custom_image_id is not None:
            pulumi.set(__self__, "custom_image_id", custom_image_id)
        if data_disk_parameters is not None:
            pulumi.set(__self__, "data_disk_parameters", data_disk_parameters)
        if disallow_public_ip_address is None:
            disallow_public_ip_address = False
        if disallow_public_ip_address is not None:
            pulumi.set(__self__, "disallow_public_ip_address", disallow_public_ip_address)
        if environment_id is not None:
            pulumi.set(__self__, "environment_id", environment_id)
        if expiration_date is not None:
            pulumi.set(__self__, "expiration_date", expiration_date)
        if gallery_image_reference is not None:
            pulumi.set(__self__, "gallery_image_reference", gallery_image_reference)
        if is_authentication_with_ssh_key is not None:
            pulumi.set(__self__, "is_authentication_with_ssh_key", is_authentication_with_ssh_key)
        if lab_subnet_name is not None:
            pulumi.set(__self__, "lab_subnet_name", lab_subnet_name)
        if lab_virtual_network_id is not None:
            pulumi.set(__self__, "lab_virtual_network_id", lab_virtual_network_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_interface is not None:
            pulumi.set(__self__, "network_interface", network_interface)
        if notes is not None:
            pulumi.set(__self__, "notes", notes)
        if owner_object_id is None:
            owner_object_id = 'dynamicValue'
        if owner_object_id is not None:
            pulumi.set(__self__, "owner_object_id", owner_object_id)
        if owner_user_principal_name is not None:
            pulumi.set(__self__, "owner_user_principal_name", owner_user_principal_name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if plan_id is not None:
            pulumi.set(__self__, "plan_id", plan_id)
        if schedule_parameters is not None:
            pulumi.set(__self__, "schedule_parameters", schedule_parameters)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if ssh_key is not None:
            pulumi.set(__self__, "ssh_key", ssh_key)
        if storage_type is None:
            storage_type = 'labStorageType'
        if storage_type is not None:
            pulumi.set(__self__, "storage_type", storage_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter(name="labName")
    def lab_name(self) -> pulumi.Input[str]:
        """
        The name of the lab.
        """
        return pulumi.get(self, "lab_name")

    @lab_name.setter
    def lab_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "lab_name", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[str]:
        """
        The name of the resource group.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="allowClaim")
    def allow_claim(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether another user can take ownership of the virtual machine
        """
        return pulumi.get(self, "allow_claim")

    @allow_claim.setter
    def allow_claim(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_claim", value)

    @property
    @pulumi.getter
    def artifacts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ArtifactInstallPropertiesArgs']]]]:
        """
        The artifacts to be installed on the virtual machine.
        """
        return pulumi.get(self, "artifacts")

    @artifacts.setter
    def artifacts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ArtifactInstallPropertiesArgs']]]]):
        pulumi.set(self, "artifacts", value)

    @property
    @pulumi.getter(name="createdDate")
    def created_date(self) -> Optional[pulumi.Input[str]]:
        """
        The creation date of the virtual machine.
        """
        return pulumi.get(self, "created_date")

    @created_date.setter
    def created_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_date", value)

    @property
    @pulumi.getter(name="customImageId")
    def custom_image_id(self) -> Optional[pulumi.Input[str]]:
        """
        The custom image identifier of the virtual machine.
        """
        return pulumi.get(self, "custom_image_id")

    @custom_image_id.setter
    def custom_image_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_image_id", value)

    @property
    @pulumi.getter(name="dataDiskParameters")
    def data_disk_parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DataDiskPropertiesArgs']]]]:
        """
        New or existing data disks to attach to the virtual machine after creation
        """
        return pulumi.get(self, "data_disk_parameters")

    @data_disk_parameters.setter
    def data_disk_parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DataDiskPropertiesArgs']]]]):
        pulumi.set(self, "data_disk_parameters", value)

    @property
    @pulumi.getter(name="disallowPublicIpAddress")
    def disallow_public_ip_address(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the virtual machine is to be created without a public IP address.
        """
        return pulumi.get(self, "disallow_public_ip_address")

    @disallow_public_ip_address.setter
    def disallow_public_ip_address(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disallow_public_ip_address", value)

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The resource ID of the environment that contains this virtual machine, if any.
        """
        return pulumi.get(self, "environment_id")

    @environment_id.setter
    def environment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "environment_id", value)

    @property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> Optional[pulumi.Input[str]]:
        """
        The expiration date for VM.
        """
        return pulumi.get(self, "expiration_date")

    @expiration_date.setter
    def expiration_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expiration_date", value)

    @property
    @pulumi.getter(name="galleryImageReference")
    def gallery_image_reference(self) -> Optional[pulumi.Input['GalleryImageReferenceArgs']]:
        """
        The Microsoft Azure Marketplace image reference of the virtual machine.
        """
        return pulumi.get(self, "gallery_image_reference")

    @gallery_image_reference.setter
    def gallery_image_reference(self, value: Optional[pulumi.Input['GalleryImageReferenceArgs']]):
        pulumi.set(self, "gallery_image_reference", value)

    @property
    @pulumi.getter(name="isAuthenticationWithSshKey")
    def is_authentication_with_ssh_key(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether this virtual machine uses an SSH key for authentication.
        """
        return pulumi.get(self, "is_authentication_with_ssh_key")

    @is_authentication_with_ssh_key.setter
    def is_authentication_with_ssh_key(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_authentication_with_ssh_key", value)

    @property
    @pulumi.getter(name="labSubnetName")
    def lab_subnet_name(self) -> Optional[pulumi.Input[str]]:
        """
        The lab subnet name of the virtual machine.
        """
        return pulumi.get(self, "lab_subnet_name")

    @lab_subnet_name.setter
    def lab_subnet_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lab_subnet_name", value)

    @property
    @pulumi.getter(name="labVirtualNetworkId")
    def lab_virtual_network_id(self) -> Optional[pulumi.Input[str]]:
        """
        The lab virtual network identifier of the virtual machine.
        """
        return pulumi.get(self, "lab_virtual_network_id")

    @lab_virtual_network_id.setter
    def lab_virtual_network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lab_virtual_network_id", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The location of the resource.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the virtual machine.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkInterface")
    def network_interface(self) -> Optional[pulumi.Input['NetworkInterfacePropertiesArgs']]:
        """
        The network interface properties.
        """
        return pulumi.get(self, "network_interface")

    @network_interface.setter
    def network_interface(self, value: Optional[pulumi.Input['NetworkInterfacePropertiesArgs']]):
        pulumi.set(self, "network_interface", value)

    @property
    @pulumi.getter
    def notes(self) -> Optional[pulumi.Input[str]]:
        """
        The notes of the virtual machine.
        """
        return pulumi.get(self, "notes")

    @notes.setter
    def notes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "notes", value)

    @property
    @pulumi.getter(name="ownerObjectId")
    def owner_object_id(self) -> Optional[pulumi.Input[str]]:
        """
        The object identifier of the owner of the virtual machine.
        """
        return pulumi.get(self, "owner_object_id")

    @owner_object_id.setter
    def owner_object_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "owner_object_id", value)

    @property
    @pulumi.getter(name="ownerUserPrincipalName")
    def owner_user_principal_name(self) -> Optional[pulumi.Input[str]]:
        """
        The user principal name of the virtual machine owner.
        """
        return pulumi.get(self, "owner_user_principal_name")

    @owner_user_principal_name.setter
    def owner_user_principal_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "owner_user_principal_name", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The password of the virtual machine administrator.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="planId")
    def plan_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the plan associated with the virtual machine image
        """
        return pulumi.get(self, "plan_id")

    @plan_id.setter
    def plan_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "plan_id", value)

    @property
    @pulumi.getter(name="scheduleParameters")
    def schedule_parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScheduleCreationParameterArgs']]]]:
        """
        Virtual Machine schedules to be created
        """
        return pulumi.get(self, "schedule_parameters")

    @schedule_parameters.setter
    def schedule_parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScheduleCreationParameterArgs']]]]):
        pulumi.set(self, "schedule_parameters", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[str]]:
        """
        The size of the virtual machine.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter(name="sshKey")
    def ssh_key(self) -> Optional[pulumi.Input[str]]:
        """
        The SSH key of the virtual machine administrator.
        """
        return pulumi.get(self, "ssh_key")

    @ssh_key.setter
    def ssh_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssh_key", value)

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> Optional[pulumi.Input[str]]:
        """
        Storage type to use for virtual machine (i.e. Standard, Premium).
        """
        return pulumi.get(self, "storage_type")

    @storage_type.setter
    def storage_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_type", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The tags of the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[str]]:
        """
        The user name of the virtual machine.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name", value)


class VirtualMachine(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_claim: Optional[pulumi.Input[bool]] = None,
                 artifacts: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ArtifactInstallPropertiesArgs']]]]] = None,
                 created_date: Optional[pulumi.Input[str]] = None,
                 custom_image_id: Optional[pulumi.Input[str]] = None,
                 data_disk_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DataDiskPropertiesArgs']]]]] = None,
                 disallow_public_ip_address: Optional[pulumi.Input[bool]] = None,
                 environment_id: Optional[pulumi.Input[str]] = None,
                 expiration_date: Optional[pulumi.Input[str]] = None,
                 gallery_image_reference: Optional[pulumi.Input[pulumi.InputType['GalleryImageReferenceArgs']]] = None,
                 is_authentication_with_ssh_key: Optional[pulumi.Input[bool]] = None,
                 lab_name: Optional[pulumi.Input[str]] = None,
                 lab_subnet_name: Optional[pulumi.Input[str]] = None,
                 lab_virtual_network_id: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_interface: Optional[pulumi.Input[pulumi.InputType['NetworkInterfacePropertiesArgs']]] = None,
                 notes: Optional[pulumi.Input[str]] = None,
                 owner_object_id: Optional[pulumi.Input[str]] = None,
                 owner_user_principal_name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 plan_id: Optional[pulumi.Input[str]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 schedule_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ScheduleCreationParameterArgs']]]]] = None,
                 size: Optional[pulumi.Input[str]] = None,
                 ssh_key: Optional[pulumi.Input[str]] = None,
                 storage_type: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 user_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        A virtual machine.
        API Version: 2018-09-15.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] allow_claim: Indicates whether another user can take ownership of the virtual machine
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ArtifactInstallPropertiesArgs']]]] artifacts: The artifacts to be installed on the virtual machine.
        :param pulumi.Input[str] created_date: The creation date of the virtual machine.
        :param pulumi.Input[str] custom_image_id: The custom image identifier of the virtual machine.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DataDiskPropertiesArgs']]]] data_disk_parameters: New or existing data disks to attach to the virtual machine after creation
        :param pulumi.Input[bool] disallow_public_ip_address: Indicates whether the virtual machine is to be created without a public IP address.
        :param pulumi.Input[str] environment_id: The resource ID of the environment that contains this virtual machine, if any.
        :param pulumi.Input[str] expiration_date: The expiration date for VM.
        :param pulumi.Input[pulumi.InputType['GalleryImageReferenceArgs']] gallery_image_reference: The Microsoft Azure Marketplace image reference of the virtual machine.
        :param pulumi.Input[bool] is_authentication_with_ssh_key: Indicates whether this virtual machine uses an SSH key for authentication.
        :param pulumi.Input[str] lab_name: The name of the lab.
        :param pulumi.Input[str] lab_subnet_name: The lab subnet name of the virtual machine.
        :param pulumi.Input[str] lab_virtual_network_id: The lab virtual network identifier of the virtual machine.
        :param pulumi.Input[str] location: The location of the resource.
        :param pulumi.Input[str] name: The name of the virtual machine.
        :param pulumi.Input[pulumi.InputType['NetworkInterfacePropertiesArgs']] network_interface: The network interface properties.
        :param pulumi.Input[str] notes: The notes of the virtual machine.
        :param pulumi.Input[str] owner_object_id: The object identifier of the owner of the virtual machine.
        :param pulumi.Input[str] owner_user_principal_name: The user principal name of the virtual machine owner.
        :param pulumi.Input[str] password: The password of the virtual machine administrator.
        :param pulumi.Input[str] plan_id: The id of the plan associated with the virtual machine image
        :param pulumi.Input[str] resource_group_name: The name of the resource group.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ScheduleCreationParameterArgs']]]] schedule_parameters: Virtual Machine schedules to be created
        :param pulumi.Input[str] size: The size of the virtual machine.
        :param pulumi.Input[str] ssh_key: The SSH key of the virtual machine administrator.
        :param pulumi.Input[str] storage_type: Storage type to use for virtual machine (i.e. Standard, Premium).
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The tags of the resource.
        :param pulumi.Input[str] user_name: The user name of the virtual machine.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VirtualMachineArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A virtual machine.
        API Version: 2018-09-15.

        :param str resource_name: The name of the resource.
        :param VirtualMachineArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VirtualMachineArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_claim: Optional[pulumi.Input[bool]] = None,
                 artifacts: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ArtifactInstallPropertiesArgs']]]]] = None,
                 created_date: Optional[pulumi.Input[str]] = None,
                 custom_image_id: Optional[pulumi.Input[str]] = None,
                 data_disk_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DataDiskPropertiesArgs']]]]] = None,
                 disallow_public_ip_address: Optional[pulumi.Input[bool]] = None,
                 environment_id: Optional[pulumi.Input[str]] = None,
                 expiration_date: Optional[pulumi.Input[str]] = None,
                 gallery_image_reference: Optional[pulumi.Input[pulumi.InputType['GalleryImageReferenceArgs']]] = None,
                 is_authentication_with_ssh_key: Optional[pulumi.Input[bool]] = None,
                 lab_name: Optional[pulumi.Input[str]] = None,
                 lab_subnet_name: Optional[pulumi.Input[str]] = None,
                 lab_virtual_network_id: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_interface: Optional[pulumi.Input[pulumi.InputType['NetworkInterfacePropertiesArgs']]] = None,
                 notes: Optional[pulumi.Input[str]] = None,
                 owner_object_id: Optional[pulumi.Input[str]] = None,
                 owner_user_principal_name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 plan_id: Optional[pulumi.Input[str]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 schedule_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ScheduleCreationParameterArgs']]]]] = None,
                 size: Optional[pulumi.Input[str]] = None,
                 ssh_key: Optional[pulumi.Input[str]] = None,
                 storage_type: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 user_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VirtualMachineArgs.__new__(VirtualMachineArgs)

            if allow_claim is None:
                allow_claim = False
            __props__.__dict__["allow_claim"] = allow_claim
            __props__.__dict__["artifacts"] = artifacts
            __props__.__dict__["created_date"] = created_date
            __props__.__dict__["custom_image_id"] = custom_image_id
            __props__.__dict__["data_disk_parameters"] = data_disk_parameters
            if disallow_public_ip_address is None:
                disallow_public_ip_address = False
            __props__.__dict__["disallow_public_ip_address"] = disallow_public_ip_address
            __props__.__dict__["environment_id"] = environment_id
            __props__.__dict__["expiration_date"] = expiration_date
            __props__.__dict__["gallery_image_reference"] = gallery_image_reference
            __props__.__dict__["is_authentication_with_ssh_key"] = is_authentication_with_ssh_key
            if lab_name is None and not opts.urn:
                raise TypeError("Missing required property 'lab_name'")
            __props__.__dict__["lab_name"] = lab_name
            __props__.__dict__["lab_subnet_name"] = lab_subnet_name
            __props__.__dict__["lab_virtual_network_id"] = lab_virtual_network_id
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["network_interface"] = network_interface
            __props__.__dict__["notes"] = notes
            if owner_object_id is None:
                owner_object_id = 'dynamicValue'
            __props__.__dict__["owner_object_id"] = owner_object_id
            __props__.__dict__["owner_user_principal_name"] = owner_user_principal_name
            __props__.__dict__["password"] = password
            __props__.__dict__["plan_id"] = plan_id
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["schedule_parameters"] = schedule_parameters
            __props__.__dict__["size"] = size
            __props__.__dict__["ssh_key"] = ssh_key
            if storage_type is None:
                storage_type = 'labStorageType'
            __props__.__dict__["storage_type"] = storage_type
            __props__.__dict__["tags"] = tags
            __props__.__dict__["user_name"] = user_name
            __props__.__dict__["applicable_schedule"] = None
            __props__.__dict__["artifact_deployment_status"] = None
            __props__.__dict__["compute_id"] = None
            __props__.__dict__["compute_vm"] = None
            __props__.__dict__["created_by_user"] = None
            __props__.__dict__["created_by_user_id"] = None
            __props__.__dict__["fqdn"] = None
            __props__.__dict__["last_known_power_state"] = None
            __props__.__dict__["os_type"] = None
            __props__.__dict__["provisioning_state"] = None
            __props__.__dict__["type"] = None
            __props__.__dict__["unique_identifier"] = None
            __props__.__dict__["virtual_machine_creation_source"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="azure-native:devtestlab/v20150521preview:VirtualMachine"), pulumi.Alias(type_="azure-native:devtestlab/v20160515:VirtualMachine"), pulumi.Alias(type_="azure-native:devtestlab/v20180915:VirtualMachine")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(VirtualMachine, __self__).__init__(
            'azure-native:devtestlab:VirtualMachine',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'VirtualMachine':
        """
        Get an existing VirtualMachine resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = VirtualMachineArgs.__new__(VirtualMachineArgs)

        __props__.__dict__["allow_claim"] = None
        __props__.__dict__["applicable_schedule"] = None
        __props__.__dict__["artifact_deployment_status"] = None
        __props__.__dict__["artifacts"] = None
        __props__.__dict__["compute_id"] = None
        __props__.__dict__["compute_vm"] = None
        __props__.__dict__["created_by_user"] = None
        __props__.__dict__["created_by_user_id"] = None
        __props__.__dict__["created_date"] = None
        __props__.__dict__["custom_image_id"] = None
        __props__.__dict__["data_disk_parameters"] = None
        __props__.__dict__["disallow_public_ip_address"] = None
        __props__.__dict__["environment_id"] = None
        __props__.__dict__["expiration_date"] = None
        __props__.__dict__["fqdn"] = None
        __props__.__dict__["gallery_image_reference"] = None
        __props__.__dict__["is_authentication_with_ssh_key"] = None
        __props__.__dict__["lab_subnet_name"] = None
        __props__.__dict__["lab_virtual_network_id"] = None
        __props__.__dict__["last_known_power_state"] = None
        __props__.__dict__["location"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["network_interface"] = None
        __props__.__dict__["notes"] = None
        __props__.__dict__["os_type"] = None
        __props__.__dict__["owner_object_id"] = None
        __props__.__dict__["owner_user_principal_name"] = None
        __props__.__dict__["password"] = None
        __props__.__dict__["plan_id"] = None
        __props__.__dict__["provisioning_state"] = None
        __props__.__dict__["schedule_parameters"] = None
        __props__.__dict__["size"] = None
        __props__.__dict__["ssh_key"] = None
        __props__.__dict__["storage_type"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["type"] = None
        __props__.__dict__["unique_identifier"] = None
        __props__.__dict__["user_name"] = None
        __props__.__dict__["virtual_machine_creation_source"] = None
        return VirtualMachine(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowClaim")
    def allow_claim(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicates whether another user can take ownership of the virtual machine
        """
        return pulumi.get(self, "allow_claim")

    @property
    @pulumi.getter(name="applicableSchedule")
    def applicable_schedule(self) -> pulumi.Output['outputs.ApplicableScheduleResponse']:
        """
        The applicable schedule for the virtual machine.
        """
        return pulumi.get(self, "applicable_schedule")

    @property
    @pulumi.getter(name="artifactDeploymentStatus")
    def artifact_deployment_status(self) -> pulumi.Output['outputs.ArtifactDeploymentStatusPropertiesResponse']:
        """
        The artifact deployment status for the virtual machine.
        """
        return pulumi.get(self, "artifact_deployment_status")

    @property
    @pulumi.getter
    def artifacts(self) -> pulumi.Output[Optional[Sequence['outputs.ArtifactInstallPropertiesResponse']]]:
        """
        The artifacts to be installed on the virtual machine.
        """
        return pulumi.get(self, "artifacts")

    @property
    @pulumi.getter(name="computeId")
    def compute_id(self) -> pulumi.Output[str]:
        """
        The resource identifier (Microsoft.Compute) of the virtual machine.
        """
        return pulumi.get(self, "compute_id")

    @property
    @pulumi.getter(name="computeVm")
    def compute_vm(self) -> pulumi.Output['outputs.ComputeVmPropertiesResponse']:
        """
        The compute virtual machine properties.
        """
        return pulumi.get(self, "compute_vm")

    @property
    @pulumi.getter(name="createdByUser")
    def created_by_user(self) -> pulumi.Output[str]:
        """
        The email address of creator of the virtual machine.
        """
        return pulumi.get(self, "created_by_user")

    @property
    @pulumi.getter(name="createdByUserId")
    def created_by_user_id(self) -> pulumi.Output[str]:
        """
        The object identifier of the creator of the virtual machine.
        """
        return pulumi.get(self, "created_by_user_id")

    @property
    @pulumi.getter(name="createdDate")
    def created_date(self) -> pulumi.Output[Optional[str]]:
        """
        The creation date of the virtual machine.
        """
        return pulumi.get(self, "created_date")

    @property
    @pulumi.getter(name="customImageId")
    def custom_image_id(self) -> pulumi.Output[Optional[str]]:
        """
        The custom image identifier of the virtual machine.
        """
        return pulumi.get(self, "custom_image_id")

    @property
    @pulumi.getter(name="dataDiskParameters")
    def data_disk_parameters(self) -> pulumi.Output[Optional[Sequence['outputs.DataDiskPropertiesResponse']]]:
        """
        New or existing data disks to attach to the virtual machine after creation
        """
        return pulumi.get(self, "data_disk_parameters")

    @property
    @pulumi.getter(name="disallowPublicIpAddress")
    def disallow_public_ip_address(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicates whether the virtual machine is to be created without a public IP address.
        """
        return pulumi.get(self, "disallow_public_ip_address")

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> pulumi.Output[Optional[str]]:
        """
        The resource ID of the environment that contains this virtual machine, if any.
        """
        return pulumi.get(self, "environment_id")

    @property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> pulumi.Output[Optional[str]]:
        """
        The expiration date for VM.
        """
        return pulumi.get(self, "expiration_date")

    @property
    @pulumi.getter
    def fqdn(self) -> pulumi.Output[str]:
        """
        The fully-qualified domain name of the virtual machine.
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter(name="galleryImageReference")
    def gallery_image_reference(self) -> pulumi.Output[Optional['outputs.GalleryImageReferenceResponse']]:
        """
        The Microsoft Azure Marketplace image reference of the virtual machine.
        """
        return pulumi.get(self, "gallery_image_reference")

    @property
    @pulumi.getter(name="isAuthenticationWithSshKey")
    def is_authentication_with_ssh_key(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicates whether this virtual machine uses an SSH key for authentication.
        """
        return pulumi.get(self, "is_authentication_with_ssh_key")

    @property
    @pulumi.getter(name="labSubnetName")
    def lab_subnet_name(self) -> pulumi.Output[Optional[str]]:
        """
        The lab subnet name of the virtual machine.
        """
        return pulumi.get(self, "lab_subnet_name")

    @property
    @pulumi.getter(name="labVirtualNetworkId")
    def lab_virtual_network_id(self) -> pulumi.Output[Optional[str]]:
        """
        The lab virtual network identifier of the virtual machine.
        """
        return pulumi.get(self, "lab_virtual_network_id")

    @property
    @pulumi.getter(name="lastKnownPowerState")
    def last_known_power_state(self) -> pulumi.Output[str]:
        """
        Last known compute power state captured in DTL
        """
        return pulumi.get(self, "last_known_power_state")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[Optional[str]]:
        """
        The location of the resource.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkInterface")
    def network_interface(self) -> pulumi.Output[Optional['outputs.NetworkInterfacePropertiesResponse']]:
        """
        The network interface properties.
        """
        return pulumi.get(self, "network_interface")

    @property
    @pulumi.getter
    def notes(self) -> pulumi.Output[Optional[str]]:
        """
        The notes of the virtual machine.
        """
        return pulumi.get(self, "notes")

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> pulumi.Output[str]:
        """
        The OS type of the virtual machine.
        """
        return pulumi.get(self, "os_type")

    @property
    @pulumi.getter(name="ownerObjectId")
    def owner_object_id(self) -> pulumi.Output[Optional[str]]:
        """
        The object identifier of the owner of the virtual machine.
        """
        return pulumi.get(self, "owner_object_id")

    @property
    @pulumi.getter(name="ownerUserPrincipalName")
    def owner_user_principal_name(self) -> pulumi.Output[Optional[str]]:
        """
        The user principal name of the virtual machine owner.
        """
        return pulumi.get(self, "owner_user_principal_name")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[str]]:
        """
        The password of the virtual machine administrator.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="planId")
    def plan_id(self) -> pulumi.Output[Optional[str]]:
        """
        The id of the plan associated with the virtual machine image
        """
        return pulumi.get(self, "plan_id")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> pulumi.Output[str]:
        """
        The provisioning status of the resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="scheduleParameters")
    def schedule_parameters(self) -> pulumi.Output[Optional[Sequence['outputs.ScheduleCreationParameterResponse']]]:
        """
        Virtual Machine schedules to be created
        """
        return pulumi.get(self, "schedule_parameters")

    @property
    @pulumi.getter
    def size(self) -> pulumi.Output[Optional[str]]:
        """
        The size of the virtual machine.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="sshKey")
    def ssh_key(self) -> pulumi.Output[Optional[str]]:
        """
        The SSH key of the virtual machine administrator.
        """
        return pulumi.get(self, "ssh_key")

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> pulumi.Output[Optional[str]]:
        """
        Storage type to use for virtual machine (i.e. Standard, Premium).
        """
        return pulumi.get(self, "storage_type")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        The tags of the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of the resource.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="uniqueIdentifier")
    def unique_identifier(self) -> pulumi.Output[str]:
        """
        The unique immutable identifier of a resource (Guid).
        """
        return pulumi.get(self, "unique_identifier")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Output[Optional[str]]:
        """
        The user name of the virtual machine.
        """
        return pulumi.get(self, "user_name")

    @property
    @pulumi.getter(name="virtualMachineCreationSource")
    def virtual_machine_creation_source(self) -> pulumi.Output[str]:
        """
        Tells source of creation of lab virtual machine. Output property only.
        """
        return pulumi.get(self, "virtual_machine_creation_source")

