# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ApplicableScheduleResponse',
    'ArmTemplateParameterPropertiesResponse',
    'ArtifactDeploymentStatusPropertiesResponse',
    'ArtifactInstallPropertiesResponse',
    'ArtifactParameterPropertiesResponse',
    'AttachNewDataDiskOptionsResponse',
    'BulkCreationParametersResponse',
    'ComputeDataDiskResponse',
    'ComputeVmInstanceViewStatusResponse',
    'ComputeVmPropertiesResponse',
    'CustomImagePropertiesCustomResponse',
    'CustomImagePropertiesFromPlanResponse',
    'CustomImagePropertiesFromVmResponse',
    'DataDiskPropertiesResponse',
    'DataDiskStorageTypeInfoResponse',
    'DayDetailsResponse',
    'EnvironmentDeploymentPropertiesResponse',
    'EventResponse',
    'ExternalSubnetResponse',
    'FormulaPropertiesFromVmResponse',
    'GalleryImageReferenceResponse',
    'HourDetailsResponse',
    'IdentityPropertiesResponse',
    'InboundNatRuleResponse',
    'LabAnnouncementPropertiesResponse',
    'LabSupportPropertiesResponse',
    'LabVhdResponse',
    'LabVirtualMachineCreationParameterResponse',
    'LinuxOsInfoResponse',
    'NetworkInterfacePropertiesResponse',
    'NotificationSettingsResponse',
    'PortResponse',
    'ScheduleCreationParameterResponse',
    'ScheduleResponse',
    'SharedPublicIpAddressConfigurationResponse',
    'SubnetOverrideResponse',
    'SubnetResponse',
    'SubnetSharedPublicIpAddressConfigurationResponse',
    'UserIdentityResponse',
    'UserSecretStoreResponse',
    'WeekDetailsResponse',
    'WindowsOsInfoResponse',
]

@pulumi.output_type
class ApplicableScheduleResponse(dict):
    """
    Schedules applicable to a virtual machine. The schedules may have been defined on a VM or on lab level.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "labVmsShutdown":
            suggest = "lab_vms_shutdown"
        elif key == "labVmsStartup":
            suggest = "lab_vms_startup"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicableScheduleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicableScheduleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicableScheduleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 name: str,
                 type: str,
                 lab_vms_shutdown: Optional['outputs.ScheduleResponse'] = None,
                 lab_vms_startup: Optional['outputs.ScheduleResponse'] = None,
                 location: Optional[str] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        Schedules applicable to a virtual machine. The schedules may have been defined on a VM or on lab level.
        :param str id: The identifier of the resource.
        :param str name: The name of the resource.
        :param str type: The type of the resource.
        :param 'ScheduleResponse' lab_vms_shutdown: The auto-shutdown schedule, if one has been set at the lab or lab resource level.
        :param 'ScheduleResponse' lab_vms_startup: The auto-startup schedule, if one has been set at the lab or lab resource level.
        :param str location: The location of the resource.
        :param Mapping[str, str] tags: The tags of the resource.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if lab_vms_shutdown is not None:
            pulumi.set(__self__, "lab_vms_shutdown", lab_vms_shutdown)
        if lab_vms_startup is not None:
            pulumi.set(__self__, "lab_vms_startup", lab_vms_startup)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The identifier of the resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the resource.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="labVmsShutdown")
    def lab_vms_shutdown(self) -> Optional['outputs.ScheduleResponse']:
        """
        The auto-shutdown schedule, if one has been set at the lab or lab resource level.
        """
        return pulumi.get(self, "lab_vms_shutdown")

    @property
    @pulumi.getter(name="labVmsStartup")
    def lab_vms_startup(self) -> Optional['outputs.ScheduleResponse']:
        """
        The auto-startup schedule, if one has been set at the lab or lab resource level.
        """
        return pulumi.get(self, "lab_vms_startup")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        The location of the resource.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        The tags of the resource.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class ArmTemplateParameterPropertiesResponse(dict):
    """
    Properties of an Azure Resource Manager template parameter.
    """
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 value: Optional[str] = None):
        """
        Properties of an Azure Resource Manager template parameter.
        :param str name: The name of the template parameter.
        :param str value: The value of the template parameter.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the template parameter.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The value of the template parameter.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ArtifactDeploymentStatusPropertiesResponse(dict):
    """
    Properties of an artifact deployment.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "artifactsApplied":
            suggest = "artifacts_applied"
        elif key == "deploymentStatus":
            suggest = "deployment_status"
        elif key == "totalArtifacts":
            suggest = "total_artifacts"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ArtifactDeploymentStatusPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ArtifactDeploymentStatusPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ArtifactDeploymentStatusPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 artifacts_applied: Optional[int] = None,
                 deployment_status: Optional[str] = None,
                 total_artifacts: Optional[int] = None):
        """
        Properties of an artifact deployment.
        :param int artifacts_applied: The total count of the artifacts that were successfully applied.
        :param str deployment_status: The deployment status of the artifact.
        :param int total_artifacts: The total count of the artifacts that were tentatively applied.
        """
        if artifacts_applied is not None:
            pulumi.set(__self__, "artifacts_applied", artifacts_applied)
        if deployment_status is not None:
            pulumi.set(__self__, "deployment_status", deployment_status)
        if total_artifacts is not None:
            pulumi.set(__self__, "total_artifacts", total_artifacts)

    @property
    @pulumi.getter(name="artifactsApplied")
    def artifacts_applied(self) -> Optional[int]:
        """
        The total count of the artifacts that were successfully applied.
        """
        return pulumi.get(self, "artifacts_applied")

    @property
    @pulumi.getter(name="deploymentStatus")
    def deployment_status(self) -> Optional[str]:
        """
        The deployment status of the artifact.
        """
        return pulumi.get(self, "deployment_status")

    @property
    @pulumi.getter(name="totalArtifacts")
    def total_artifacts(self) -> Optional[int]:
        """
        The total count of the artifacts that were tentatively applied.
        """
        return pulumi.get(self, "total_artifacts")


@pulumi.output_type
class ArtifactInstallPropertiesResponse(dict):
    """
    Properties of an artifact.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "artifactId":
            suggest = "artifact_id"
        elif key == "artifactTitle":
            suggest = "artifact_title"
        elif key == "deploymentStatusMessage":
            suggest = "deployment_status_message"
        elif key == "installTime":
            suggest = "install_time"
        elif key == "vmExtensionStatusMessage":
            suggest = "vm_extension_status_message"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ArtifactInstallPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ArtifactInstallPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ArtifactInstallPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 artifact_id: Optional[str] = None,
                 artifact_title: Optional[str] = None,
                 deployment_status_message: Optional[str] = None,
                 install_time: Optional[str] = None,
                 parameters: Optional[Sequence['outputs.ArtifactParameterPropertiesResponse']] = None,
                 status: Optional[str] = None,
                 vm_extension_status_message: Optional[str] = None):
        """
        Properties of an artifact.
        :param str artifact_id: The artifact's identifier.
        :param str artifact_title: The artifact's title.
        :param str deployment_status_message: The status message from the deployment.
        :param str install_time: The time that the artifact starts to install on the virtual machine.
        :param Sequence['ArtifactParameterPropertiesResponse'] parameters: The parameters of the artifact.
        :param str status: The status of the artifact.
        :param str vm_extension_status_message: The status message from the virtual machine extension.
        """
        if artifact_id is not None:
            pulumi.set(__self__, "artifact_id", artifact_id)
        if artifact_title is not None:
            pulumi.set(__self__, "artifact_title", artifact_title)
        if deployment_status_message is not None:
            pulumi.set(__self__, "deployment_status_message", deployment_status_message)
        if install_time is not None:
            pulumi.set(__self__, "install_time", install_time)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if vm_extension_status_message is not None:
            pulumi.set(__self__, "vm_extension_status_message", vm_extension_status_message)

    @property
    @pulumi.getter(name="artifactId")
    def artifact_id(self) -> Optional[str]:
        """
        The artifact's identifier.
        """
        return pulumi.get(self, "artifact_id")

    @property
    @pulumi.getter(name="artifactTitle")
    def artifact_title(self) -> Optional[str]:
        """
        The artifact's title.
        """
        return pulumi.get(self, "artifact_title")

    @property
    @pulumi.getter(name="deploymentStatusMessage")
    def deployment_status_message(self) -> Optional[str]:
        """
        The status message from the deployment.
        """
        return pulumi.get(self, "deployment_status_message")

    @property
    @pulumi.getter(name="installTime")
    def install_time(self) -> Optional[str]:
        """
        The time that the artifact starts to install on the virtual machine.
        """
        return pulumi.get(self, "install_time")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Sequence['outputs.ArtifactParameterPropertiesResponse']]:
        """
        The parameters of the artifact.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The status of the artifact.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="vmExtensionStatusMessage")
    def vm_extension_status_message(self) -> Optional[str]:
        """
        The status message from the virtual machine extension.
        """
        return pulumi.get(self, "vm_extension_status_message")


@pulumi.output_type
class ArtifactParameterPropertiesResponse(dict):
    """
    Properties of an artifact parameter.
    """
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 value: Optional[str] = None):
        """
        Properties of an artifact parameter.
        :param str name: The name of the artifact parameter.
        :param str value: The value of the artifact parameter.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the artifact parameter.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The value of the artifact parameter.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class AttachNewDataDiskOptionsResponse(dict):
    """
    Properties to attach new disk to the Virtual Machine.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskName":
            suggest = "disk_name"
        elif key == "diskSizeGiB":
            suggest = "disk_size_gi_b"
        elif key == "diskType":
            suggest = "disk_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AttachNewDataDiskOptionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AttachNewDataDiskOptionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AttachNewDataDiskOptionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_name: Optional[str] = None,
                 disk_size_gi_b: Optional[int] = None,
                 disk_type: Optional[str] = None):
        """
        Properties to attach new disk to the Virtual Machine.
        :param str disk_name: The name of the disk to be attached.
        :param int disk_size_gi_b: Size of the disk to be attached in Gibibytes.
        :param str disk_type: The storage type for the disk (i.e. Standard, Premium).
        """
        if disk_name is not None:
            pulumi.set(__self__, "disk_name", disk_name)
        if disk_size_gi_b is not None:
            pulumi.set(__self__, "disk_size_gi_b", disk_size_gi_b)
        if disk_type is not None:
            pulumi.set(__self__, "disk_type", disk_type)

    @property
    @pulumi.getter(name="diskName")
    def disk_name(self) -> Optional[str]:
        """
        The name of the disk to be attached.
        """
        return pulumi.get(self, "disk_name")

    @property
    @pulumi.getter(name="diskSizeGiB")
    def disk_size_gi_b(self) -> Optional[int]:
        """
        Size of the disk to be attached in Gibibytes.
        """
        return pulumi.get(self, "disk_size_gi_b")

    @property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> Optional[str]:
        """
        The storage type for the disk (i.e. Standard, Premium).
        """
        return pulumi.get(self, "disk_type")


@pulumi.output_type
class BulkCreationParametersResponse(dict):
    """
    Parameters for creating multiple virtual machines as a single action.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceCount":
            suggest = "instance_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BulkCreationParametersResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BulkCreationParametersResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BulkCreationParametersResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_count: Optional[int] = None):
        """
        Parameters for creating multiple virtual machines as a single action.
        :param int instance_count: The number of virtual machine instances to create.
        """
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[int]:
        """
        The number of virtual machine instances to create.
        """
        return pulumi.get(self, "instance_count")


@pulumi.output_type
class ComputeDataDiskResponse(dict):
    """
    A data disks attached to a virtual machine.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskSizeGiB":
            suggest = "disk_size_gi_b"
        elif key == "diskUri":
            suggest = "disk_uri"
        elif key == "managedDiskId":
            suggest = "managed_disk_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComputeDataDiskResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComputeDataDiskResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComputeDataDiskResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_size_gi_b: Optional[int] = None,
                 disk_uri: Optional[str] = None,
                 managed_disk_id: Optional[str] = None,
                 name: Optional[str] = None):
        """
        A data disks attached to a virtual machine.
        :param int disk_size_gi_b: Gets data disk size in GiB.
        :param str disk_uri: When backed by a blob, the URI of underlying blob.
        :param str managed_disk_id: When backed by managed disk, this is the ID of the compute disk resource.
        :param str name: Gets data disk name.
        """
        if disk_size_gi_b is not None:
            pulumi.set(__self__, "disk_size_gi_b", disk_size_gi_b)
        if disk_uri is not None:
            pulumi.set(__self__, "disk_uri", disk_uri)
        if managed_disk_id is not None:
            pulumi.set(__self__, "managed_disk_id", managed_disk_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="diskSizeGiB")
    def disk_size_gi_b(self) -> Optional[int]:
        """
        Gets data disk size in GiB.
        """
        return pulumi.get(self, "disk_size_gi_b")

    @property
    @pulumi.getter(name="diskUri")
    def disk_uri(self) -> Optional[str]:
        """
        When backed by a blob, the URI of underlying blob.
        """
        return pulumi.get(self, "disk_uri")

    @property
    @pulumi.getter(name="managedDiskId")
    def managed_disk_id(self) -> Optional[str]:
        """
        When backed by managed disk, this is the ID of the compute disk resource.
        """
        return pulumi.get(self, "managed_disk_id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Gets data disk name.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ComputeVmInstanceViewStatusResponse(dict):
    """
    Status information about a virtual machine.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayStatus":
            suggest = "display_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComputeVmInstanceViewStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComputeVmInstanceViewStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComputeVmInstanceViewStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 code: Optional[str] = None,
                 display_status: Optional[str] = None,
                 message: Optional[str] = None):
        """
        Status information about a virtual machine.
        :param str code: Gets the status Code.
        :param str display_status: Gets the short localizable label for the status.
        :param str message: Gets the message associated with the status.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if display_status is not None:
            pulumi.set(__self__, "display_status", display_status)
        if message is not None:
            pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> Optional[str]:
        """
        Gets the status Code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter(name="displayStatus")
    def display_status(self) -> Optional[str]:
        """
        Gets the short localizable label for the status.
        """
        return pulumi.get(self, "display_status")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        Gets the message associated with the status.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class ComputeVmPropertiesResponse(dict):
    """
    Properties of a virtual machine returned by the Microsoft.Compute API.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataDiskIds":
            suggest = "data_disk_ids"
        elif key == "dataDisks":
            suggest = "data_disks"
        elif key == "networkInterfaceId":
            suggest = "network_interface_id"
        elif key == "osDiskId":
            suggest = "os_disk_id"
        elif key == "osType":
            suggest = "os_type"
        elif key == "vmSize":
            suggest = "vm_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComputeVmPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComputeVmPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComputeVmPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_disk_ids: Optional[Sequence[str]] = None,
                 data_disks: Optional[Sequence['outputs.ComputeDataDiskResponse']] = None,
                 network_interface_id: Optional[str] = None,
                 os_disk_id: Optional[str] = None,
                 os_type: Optional[str] = None,
                 statuses: Optional[Sequence['outputs.ComputeVmInstanceViewStatusResponse']] = None,
                 vm_size: Optional[str] = None):
        """
        Properties of a virtual machine returned by the Microsoft.Compute API.
        :param Sequence[str] data_disk_ids: Gets data disks blob uri for the virtual machine.
        :param Sequence['ComputeDataDiskResponse'] data_disks: Gets all data disks attached to the virtual machine.
        :param str network_interface_id: Gets the network interface ID of the virtual machine.
        :param str os_disk_id: Gets OS disk blob uri for the virtual machine.
        :param str os_type: Gets the OS type of the virtual machine.
        :param Sequence['ComputeVmInstanceViewStatusResponse'] statuses: Gets the statuses of the virtual machine.
        :param str vm_size: Gets the size of the virtual machine.
        """
        if data_disk_ids is not None:
            pulumi.set(__self__, "data_disk_ids", data_disk_ids)
        if data_disks is not None:
            pulumi.set(__self__, "data_disks", data_disks)
        if network_interface_id is not None:
            pulumi.set(__self__, "network_interface_id", network_interface_id)
        if os_disk_id is not None:
            pulumi.set(__self__, "os_disk_id", os_disk_id)
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if statuses is not None:
            pulumi.set(__self__, "statuses", statuses)
        if vm_size is not None:
            pulumi.set(__self__, "vm_size", vm_size)

    @property
    @pulumi.getter(name="dataDiskIds")
    def data_disk_ids(self) -> Optional[Sequence[str]]:
        """
        Gets data disks blob uri for the virtual machine.
        """
        return pulumi.get(self, "data_disk_ids")

    @property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Optional[Sequence['outputs.ComputeDataDiskResponse']]:
        """
        Gets all data disks attached to the virtual machine.
        """
        return pulumi.get(self, "data_disks")

    @property
    @pulumi.getter(name="networkInterfaceId")
    def network_interface_id(self) -> Optional[str]:
        """
        Gets the network interface ID of the virtual machine.
        """
        return pulumi.get(self, "network_interface_id")

    @property
    @pulumi.getter(name="osDiskId")
    def os_disk_id(self) -> Optional[str]:
        """
        Gets OS disk blob uri for the virtual machine.
        """
        return pulumi.get(self, "os_disk_id")

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[str]:
        """
        Gets the OS type of the virtual machine.
        """
        return pulumi.get(self, "os_type")

    @property
    @pulumi.getter
    def statuses(self) -> Optional[Sequence['outputs.ComputeVmInstanceViewStatusResponse']]:
        """
        Gets the statuses of the virtual machine.
        """
        return pulumi.get(self, "statuses")

    @property
    @pulumi.getter(name="vmSize")
    def vm_size(self) -> Optional[str]:
        """
        Gets the size of the virtual machine.
        """
        return pulumi.get(self, "vm_size")


@pulumi.output_type
class CustomImagePropertiesCustomResponse(dict):
    """
    Properties for creating a custom image from a VHD.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "osType":
            suggest = "os_type"
        elif key == "imageName":
            suggest = "image_name"
        elif key == "sysPrep":
            suggest = "sys_prep"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomImagePropertiesCustomResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomImagePropertiesCustomResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomImagePropertiesCustomResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 os_type: str,
                 image_name: Optional[str] = None,
                 sys_prep: Optional[bool] = None):
        """
        Properties for creating a custom image from a VHD.
        :param str os_type: The OS type of the custom image (i.e. Windows, Linux)
        :param str image_name: The image name.
        :param bool sys_prep: Indicates whether sysprep has been run on the VHD.
        """
        pulumi.set(__self__, "os_type", os_type)
        if image_name is not None:
            pulumi.set(__self__, "image_name", image_name)
        if sys_prep is not None:
            pulumi.set(__self__, "sys_prep", sys_prep)

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> str:
        """
        The OS type of the custom image (i.e. Windows, Linux)
        """
        return pulumi.get(self, "os_type")

    @property
    @pulumi.getter(name="imageName")
    def image_name(self) -> Optional[str]:
        """
        The image name.
        """
        return pulumi.get(self, "image_name")

    @property
    @pulumi.getter(name="sysPrep")
    def sys_prep(self) -> Optional[bool]:
        """
        Indicates whether sysprep has been run on the VHD.
        """
        return pulumi.get(self, "sys_prep")


@pulumi.output_type
class CustomImagePropertiesFromPlanResponse(dict):
    """
    Properties for plan on a custom image.
    """
    def __init__(__self__, *,
                 id: Optional[str] = None,
                 offer: Optional[str] = None,
                 publisher: Optional[str] = None):
        """
        Properties for plan on a custom image.
        :param str id: The id of the plan, equivalent to name of the plan
        :param str offer: The offer for the plan from the marketplace image the custom image is derived from
        :param str publisher: The publisher for the plan from the marketplace image the custom image is derived from
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if offer is not None:
            pulumi.set(__self__, "offer", offer)
        if publisher is not None:
            pulumi.set(__self__, "publisher", publisher)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The id of the plan, equivalent to name of the plan
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def offer(self) -> Optional[str]:
        """
        The offer for the plan from the marketplace image the custom image is derived from
        """
        return pulumi.get(self, "offer")

    @property
    @pulumi.getter
    def publisher(self) -> Optional[str]:
        """
        The publisher for the plan from the marketplace image the custom image is derived from
        """
        return pulumi.get(self, "publisher")


@pulumi.output_type
class CustomImagePropertiesFromVmResponse(dict):
    """
    Properties for creating a custom image from a virtual machine.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "linuxOsInfo":
            suggest = "linux_os_info"
        elif key == "sourceVmId":
            suggest = "source_vm_id"
        elif key == "windowsOsInfo":
            suggest = "windows_os_info"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomImagePropertiesFromVmResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomImagePropertiesFromVmResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomImagePropertiesFromVmResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 linux_os_info: Optional['outputs.LinuxOsInfoResponse'] = None,
                 source_vm_id: Optional[str] = None,
                 windows_os_info: Optional['outputs.WindowsOsInfoResponse'] = None):
        """
        Properties for creating a custom image from a virtual machine.
        :param 'LinuxOsInfoResponse' linux_os_info: The Linux OS information of the VM.
        :param str source_vm_id: The source vm identifier.
        :param 'WindowsOsInfoResponse' windows_os_info: The Windows OS information of the VM.
        """
        if linux_os_info is not None:
            pulumi.set(__self__, "linux_os_info", linux_os_info)
        if source_vm_id is not None:
            pulumi.set(__self__, "source_vm_id", source_vm_id)
        if windows_os_info is not None:
            pulumi.set(__self__, "windows_os_info", windows_os_info)

    @property
    @pulumi.getter(name="linuxOsInfo")
    def linux_os_info(self) -> Optional['outputs.LinuxOsInfoResponse']:
        """
        The Linux OS information of the VM.
        """
        return pulumi.get(self, "linux_os_info")

    @property
    @pulumi.getter(name="sourceVmId")
    def source_vm_id(self) -> Optional[str]:
        """
        The source vm identifier.
        """
        return pulumi.get(self, "source_vm_id")

    @property
    @pulumi.getter(name="windowsOsInfo")
    def windows_os_info(self) -> Optional['outputs.WindowsOsInfoResponse']:
        """
        The Windows OS information of the VM.
        """
        return pulumi.get(self, "windows_os_info")


@pulumi.output_type
class DataDiskPropertiesResponse(dict):
    """
    Request body for adding a new or existing data disk to a virtual machine.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "attachNewDataDiskOptions":
            suggest = "attach_new_data_disk_options"
        elif key == "existingLabDiskId":
            suggest = "existing_lab_disk_id"
        elif key == "hostCaching":
            suggest = "host_caching"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataDiskPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataDiskPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataDiskPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 attach_new_data_disk_options: Optional['outputs.AttachNewDataDiskOptionsResponse'] = None,
                 existing_lab_disk_id: Optional[str] = None,
                 host_caching: Optional[str] = None):
        """
        Request body for adding a new or existing data disk to a virtual machine.
        :param 'AttachNewDataDiskOptionsResponse' attach_new_data_disk_options: Specifies options to attach a new disk to the virtual machine.
        :param str existing_lab_disk_id: Specifies the existing lab disk id to attach to virtual machine.
        :param str host_caching: Caching option for a data disk (i.e. None, ReadOnly, ReadWrite).
        """
        if attach_new_data_disk_options is not None:
            pulumi.set(__self__, "attach_new_data_disk_options", attach_new_data_disk_options)
        if existing_lab_disk_id is not None:
            pulumi.set(__self__, "existing_lab_disk_id", existing_lab_disk_id)
        if host_caching is not None:
            pulumi.set(__self__, "host_caching", host_caching)

    @property
    @pulumi.getter(name="attachNewDataDiskOptions")
    def attach_new_data_disk_options(self) -> Optional['outputs.AttachNewDataDiskOptionsResponse']:
        """
        Specifies options to attach a new disk to the virtual machine.
        """
        return pulumi.get(self, "attach_new_data_disk_options")

    @property
    @pulumi.getter(name="existingLabDiskId")
    def existing_lab_disk_id(self) -> Optional[str]:
        """
        Specifies the existing lab disk id to attach to virtual machine.
        """
        return pulumi.get(self, "existing_lab_disk_id")

    @property
    @pulumi.getter(name="hostCaching")
    def host_caching(self) -> Optional[str]:
        """
        Caching option for a data disk (i.e. None, ReadOnly, ReadWrite).
        """
        return pulumi.get(self, "host_caching")


@pulumi.output_type
class DataDiskStorageTypeInfoResponse(dict):
    """
    Storage information about the data disks present in the custom image
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageType":
            suggest = "storage_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataDiskStorageTypeInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataDiskStorageTypeInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataDiskStorageTypeInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 lun: Optional[str] = None,
                 storage_type: Optional[str] = None):
        """
        Storage information about the data disks present in the custom image
        :param str lun: Disk Lun
        :param str storage_type: Disk Storage Type
        """
        if lun is not None:
            pulumi.set(__self__, "lun", lun)
        if storage_type is not None:
            pulumi.set(__self__, "storage_type", storage_type)

    @property
    @pulumi.getter
    def lun(self) -> Optional[str]:
        """
        Disk Lun
        """
        return pulumi.get(self, "lun")

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> Optional[str]:
        """
        Disk Storage Type
        """
        return pulumi.get(self, "storage_type")


@pulumi.output_type
class DayDetailsResponse(dict):
    """
    Properties of a daily schedule.
    """
    def __init__(__self__, *,
                 time: Optional[str] = None):
        """
        Properties of a daily schedule.
        :param str time: The time of day the schedule will occur.
        """
        if time is not None:
            pulumi.set(__self__, "time", time)

    @property
    @pulumi.getter
    def time(self) -> Optional[str]:
        """
        The time of day the schedule will occur.
        """
        return pulumi.get(self, "time")


@pulumi.output_type
class EnvironmentDeploymentPropertiesResponse(dict):
    """
    Properties of an environment deployment.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "armTemplateId":
            suggest = "arm_template_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvironmentDeploymentPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvironmentDeploymentPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvironmentDeploymentPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 arm_template_id: Optional[str] = None,
                 parameters: Optional[Sequence['outputs.ArmTemplateParameterPropertiesResponse']] = None):
        """
        Properties of an environment deployment.
        :param str arm_template_id: The Azure Resource Manager template's identifier.
        :param Sequence['ArmTemplateParameterPropertiesResponse'] parameters: The parameters of the Azure Resource Manager template.
        """
        if arm_template_id is not None:
            pulumi.set(__self__, "arm_template_id", arm_template_id)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter(name="armTemplateId")
    def arm_template_id(self) -> Optional[str]:
        """
        The Azure Resource Manager template's identifier.
        """
        return pulumi.get(self, "arm_template_id")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Sequence['outputs.ArmTemplateParameterPropertiesResponse']]:
        """
        The parameters of the Azure Resource Manager template.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class EventResponse(dict):
    """
    An event to be notified for.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eventName":
            suggest = "event_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 event_name: Optional[str] = None):
        """
        An event to be notified for.
        :param str event_name: The event type for which this notification is enabled (i.e. AutoShutdown, Cost)
        """
        if event_name is not None:
            pulumi.set(__self__, "event_name", event_name)

    @property
    @pulumi.getter(name="eventName")
    def event_name(self) -> Optional[str]:
        """
        The event type for which this notification is enabled (i.e. AutoShutdown, Cost)
        """
        return pulumi.get(self, "event_name")


@pulumi.output_type
class ExternalSubnetResponse(dict):
    """
    Subnet information as returned by the Microsoft.Network API.
    """
    def __init__(__self__, *,
                 id: Optional[str] = None,
                 name: Optional[str] = None):
        """
        Subnet information as returned by the Microsoft.Network API.
        :param str id: Gets or sets the identifier.
        :param str name: Gets or sets the name.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Gets or sets the identifier.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Gets or sets the name.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class FormulaPropertiesFromVmResponse(dict):
    """
    Information about a VM from which a formula is to be created.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "labVmId":
            suggest = "lab_vm_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FormulaPropertiesFromVmResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FormulaPropertiesFromVmResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FormulaPropertiesFromVmResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 lab_vm_id: Optional[str] = None):
        """
        Information about a VM from which a formula is to be created.
        :param str lab_vm_id: The identifier of the VM from which a formula is to be created.
        """
        if lab_vm_id is not None:
            pulumi.set(__self__, "lab_vm_id", lab_vm_id)

    @property
    @pulumi.getter(name="labVmId")
    def lab_vm_id(self) -> Optional[str]:
        """
        The identifier of the VM from which a formula is to be created.
        """
        return pulumi.get(self, "lab_vm_id")


@pulumi.output_type
class GalleryImageReferenceResponse(dict):
    """
    The reference information for an Azure Marketplace image.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "osType":
            suggest = "os_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GalleryImageReferenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GalleryImageReferenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GalleryImageReferenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 offer: Optional[str] = None,
                 os_type: Optional[str] = None,
                 publisher: Optional[str] = None,
                 sku: Optional[str] = None,
                 version: Optional[str] = None):
        """
        The reference information for an Azure Marketplace image.
        :param str offer: The offer of the gallery image.
        :param str os_type: The OS type of the gallery image.
        :param str publisher: The publisher of the gallery image.
        :param str sku: The SKU of the gallery image.
        :param str version: The version of the gallery image.
        """
        if offer is not None:
            pulumi.set(__self__, "offer", offer)
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if publisher is not None:
            pulumi.set(__self__, "publisher", publisher)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def offer(self) -> Optional[str]:
        """
        The offer of the gallery image.
        """
        return pulumi.get(self, "offer")

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[str]:
        """
        The OS type of the gallery image.
        """
        return pulumi.get(self, "os_type")

    @property
    @pulumi.getter
    def publisher(self) -> Optional[str]:
        """
        The publisher of the gallery image.
        """
        return pulumi.get(self, "publisher")

    @property
    @pulumi.getter
    def sku(self) -> Optional[str]:
        """
        The SKU of the gallery image.
        """
        return pulumi.get(self, "sku")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        The version of the gallery image.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class HourDetailsResponse(dict):
    """
    Properties of an hourly schedule.
    """
    def __init__(__self__, *,
                 minute: Optional[int] = None):
        """
        Properties of an hourly schedule.
        :param int minute: Minutes of the hour the schedule will run.
        """
        if minute is not None:
            pulumi.set(__self__, "minute", minute)

    @property
    @pulumi.getter
    def minute(self) -> Optional[int]:
        """
        Minutes of the hour the schedule will run.
        """
        return pulumi.get(self, "minute")


@pulumi.output_type
class IdentityPropertiesResponse(dict):
    """
    Properties of a managed identity
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientSecretUrl":
            suggest = "client_secret_url"
        elif key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdentityPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdentityPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdentityPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_secret_url: Optional[str] = None,
                 principal_id: Optional[str] = None,
                 tenant_id: Optional[str] = None,
                 type: Optional[str] = None):
        """
        Properties of a managed identity
        :param str client_secret_url: The client secret URL of the identity.
        :param str principal_id: The principal id of resource identity.
        :param str tenant_id: The tenant identifier of resource.
        :param str type: Managed identity.
        """
        if client_secret_url is not None:
            pulumi.set(__self__, "client_secret_url", client_secret_url)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="clientSecretUrl")
    def client_secret_url(self) -> Optional[str]:
        """
        The client secret URL of the identity.
        """
        return pulumi.get(self, "client_secret_url")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[str]:
        """
        The principal id of resource identity.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[str]:
        """
        The tenant identifier of resource.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Managed identity.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class InboundNatRuleResponse(dict):
    """
    A rule for NAT - exposing a VM's port (backendPort) on the public IP address using a load balancer.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backendPort":
            suggest = "backend_port"
        elif key == "frontendPort":
            suggest = "frontend_port"
        elif key == "transportProtocol":
            suggest = "transport_protocol"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InboundNatRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InboundNatRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InboundNatRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backend_port: Optional[int] = None,
                 frontend_port: Optional[int] = None,
                 transport_protocol: Optional[str] = None):
        """
        A rule for NAT - exposing a VM's port (backendPort) on the public IP address using a load balancer.
        :param int backend_port: The port to which the external traffic will be redirected.
        :param int frontend_port: The external endpoint port of the inbound connection. Possible values range between 1 and 65535, inclusive. If unspecified, a value will be allocated automatically.
        :param str transport_protocol: The transport protocol for the endpoint.
        """
        if backend_port is not None:
            pulumi.set(__self__, "backend_port", backend_port)
        if frontend_port is not None:
            pulumi.set(__self__, "frontend_port", frontend_port)
        if transport_protocol is not None:
            pulumi.set(__self__, "transport_protocol", transport_protocol)

    @property
    @pulumi.getter(name="backendPort")
    def backend_port(self) -> Optional[int]:
        """
        The port to which the external traffic will be redirected.
        """
        return pulumi.get(self, "backend_port")

    @property
    @pulumi.getter(name="frontendPort")
    def frontend_port(self) -> Optional[int]:
        """
        The external endpoint port of the inbound connection. Possible values range between 1 and 65535, inclusive. If unspecified, a value will be allocated automatically.
        """
        return pulumi.get(self, "frontend_port")

    @property
    @pulumi.getter(name="transportProtocol")
    def transport_protocol(self) -> Optional[str]:
        """
        The transport protocol for the endpoint.
        """
        return pulumi.get(self, "transport_protocol")


@pulumi.output_type
class LabAnnouncementPropertiesResponse(dict):
    """
    Properties of a lab's announcement banner
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "uniqueIdentifier":
            suggest = "unique_identifier"
        elif key == "expirationDate":
            suggest = "expiration_date"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LabAnnouncementPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LabAnnouncementPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LabAnnouncementPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provisioning_state: str,
                 unique_identifier: str,
                 enabled: Optional[str] = None,
                 expiration_date: Optional[str] = None,
                 expired: Optional[bool] = None,
                 markdown: Optional[str] = None,
                 title: Optional[str] = None):
        """
        Properties of a lab's announcement banner
        :param str provisioning_state: The provisioning status of the resource.
        :param str unique_identifier: The unique immutable identifier of a resource (Guid).
        :param str enabled: Is the lab announcement active/enabled at this time?
        :param str expiration_date: The time at which the announcement expires (null for never)
        :param bool expired: Has this announcement expired?
        :param str markdown: The markdown text (if any) that this lab displays in the UI. If left empty/null, nothing will be shown.
        :param str title: The plain text title for the lab announcement
        """
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "unique_identifier", unique_identifier)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if expiration_date is not None:
            pulumi.set(__self__, "expiration_date", expiration_date)
        if expired is not None:
            pulumi.set(__self__, "expired", expired)
        if markdown is not None:
            pulumi.set(__self__, "markdown", markdown)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning status of the resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="uniqueIdentifier")
    def unique_identifier(self) -> str:
        """
        The unique immutable identifier of a resource (Guid).
        """
        return pulumi.get(self, "unique_identifier")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[str]:
        """
        Is the lab announcement active/enabled at this time?
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> Optional[str]:
        """
        The time at which the announcement expires (null for never)
        """
        return pulumi.get(self, "expiration_date")

    @property
    @pulumi.getter
    def expired(self) -> Optional[bool]:
        """
        Has this announcement expired?
        """
        return pulumi.get(self, "expired")

    @property
    @pulumi.getter
    def markdown(self) -> Optional[str]:
        """
        The markdown text (if any) that this lab displays in the UI. If left empty/null, nothing will be shown.
        """
        return pulumi.get(self, "markdown")

    @property
    @pulumi.getter
    def title(self) -> Optional[str]:
        """
        The plain text title for the lab announcement
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class LabSupportPropertiesResponse(dict):
    """
    Properties of a lab's support banner
    """
    def __init__(__self__, *,
                 enabled: Optional[str] = None,
                 markdown: Optional[str] = None):
        """
        Properties of a lab's support banner
        :param str enabled: Is the lab support banner active/enabled at this time?
        :param str markdown: The markdown text (if any) that this lab displays in the UI. If left empty/null, nothing will be shown.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if markdown is not None:
            pulumi.set(__self__, "markdown", markdown)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[str]:
        """
        Is the lab support banner active/enabled at this time?
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def markdown(self) -> Optional[str]:
        """
        The markdown text (if any) that this lab displays in the UI. If left empty/null, nothing will be shown.
        """
        return pulumi.get(self, "markdown")


@pulumi.output_type
class LabVhdResponse(dict):
    """
    Properties of a VHD in the lab.
    """
    def __init__(__self__, *,
                 id: Optional[str] = None):
        """
        Properties of a VHD in the lab.
        :param str id: The URI to the VHD.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The URI to the VHD.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class LabVirtualMachineCreationParameterResponse(dict):
    """
    Properties for creating a virtual machine.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowClaim":
            suggest = "allow_claim"
        elif key == "bulkCreationParameters":
            suggest = "bulk_creation_parameters"
        elif key == "createdDate":
            suggest = "created_date"
        elif key == "customImageId":
            suggest = "custom_image_id"
        elif key == "dataDiskParameters":
            suggest = "data_disk_parameters"
        elif key == "disallowPublicIpAddress":
            suggest = "disallow_public_ip_address"
        elif key == "environmentId":
            suggest = "environment_id"
        elif key == "expirationDate":
            suggest = "expiration_date"
        elif key == "galleryImageReference":
            suggest = "gallery_image_reference"
        elif key == "isAuthenticationWithSshKey":
            suggest = "is_authentication_with_ssh_key"
        elif key == "labSubnetName":
            suggest = "lab_subnet_name"
        elif key == "labVirtualNetworkId":
            suggest = "lab_virtual_network_id"
        elif key == "networkInterface":
            suggest = "network_interface"
        elif key == "ownerObjectId":
            suggest = "owner_object_id"
        elif key == "ownerUserPrincipalName":
            suggest = "owner_user_principal_name"
        elif key == "planId":
            suggest = "plan_id"
        elif key == "scheduleParameters":
            suggest = "schedule_parameters"
        elif key == "sshKey":
            suggest = "ssh_key"
        elif key == "storageType":
            suggest = "storage_type"
        elif key == "userName":
            suggest = "user_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LabVirtualMachineCreationParameterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LabVirtualMachineCreationParameterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LabVirtualMachineCreationParameterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_claim: Optional[bool] = None,
                 artifacts: Optional[Sequence['outputs.ArtifactInstallPropertiesResponse']] = None,
                 bulk_creation_parameters: Optional['outputs.BulkCreationParametersResponse'] = None,
                 created_date: Optional[str] = None,
                 custom_image_id: Optional[str] = None,
                 data_disk_parameters: Optional[Sequence['outputs.DataDiskPropertiesResponse']] = None,
                 disallow_public_ip_address: Optional[bool] = None,
                 environment_id: Optional[str] = None,
                 expiration_date: Optional[str] = None,
                 gallery_image_reference: Optional['outputs.GalleryImageReferenceResponse'] = None,
                 is_authentication_with_ssh_key: Optional[bool] = None,
                 lab_subnet_name: Optional[str] = None,
                 lab_virtual_network_id: Optional[str] = None,
                 location: Optional[str] = None,
                 name: Optional[str] = None,
                 network_interface: Optional['outputs.NetworkInterfacePropertiesResponse'] = None,
                 notes: Optional[str] = None,
                 owner_object_id: Optional[str] = None,
                 owner_user_principal_name: Optional[str] = None,
                 password: Optional[str] = None,
                 plan_id: Optional[str] = None,
                 schedule_parameters: Optional[Sequence['outputs.ScheduleCreationParameterResponse']] = None,
                 size: Optional[str] = None,
                 ssh_key: Optional[str] = None,
                 storage_type: Optional[str] = None,
                 tags: Optional[Mapping[str, str]] = None,
                 user_name: Optional[str] = None):
        """
        Properties for creating a virtual machine.
        :param bool allow_claim: Indicates whether another user can take ownership of the virtual machine
        :param Sequence['ArtifactInstallPropertiesResponse'] artifacts: The artifacts to be installed on the virtual machine.
        :param 'BulkCreationParametersResponse' bulk_creation_parameters: The number of virtual machine instances to create.
        :param str created_date: The creation date of the virtual machine.
        :param str custom_image_id: The custom image identifier of the virtual machine.
        :param Sequence['DataDiskPropertiesResponse'] data_disk_parameters: New or existing data disks to attach to the virtual machine after creation
        :param bool disallow_public_ip_address: Indicates whether the virtual machine is to be created without a public IP address.
        :param str environment_id: The resource ID of the environment that contains this virtual machine, if any.
        :param str expiration_date: The expiration date for VM.
        :param 'GalleryImageReferenceResponse' gallery_image_reference: The Microsoft Azure Marketplace image reference of the virtual machine.
        :param bool is_authentication_with_ssh_key: Indicates whether this virtual machine uses an SSH key for authentication.
        :param str lab_subnet_name: The lab subnet name of the virtual machine.
        :param str lab_virtual_network_id: The lab virtual network identifier of the virtual machine.
        :param str location: The location of the new virtual machine or environment
        :param str name: The name of the virtual machine or environment
        :param 'NetworkInterfacePropertiesResponse' network_interface: The network interface properties.
        :param str notes: The notes of the virtual machine.
        :param str owner_object_id: The object identifier of the owner of the virtual machine.
        :param str owner_user_principal_name: The user principal name of the virtual machine owner.
        :param str password: The password of the virtual machine administrator.
        :param str plan_id: The id of the plan associated with the virtual machine image
        :param Sequence['ScheduleCreationParameterResponse'] schedule_parameters: Virtual Machine schedules to be created
        :param str size: The size of the virtual machine.
        :param str ssh_key: The SSH key of the virtual machine administrator.
        :param str storage_type: Storage type to use for virtual machine (i.e. Standard, Premium).
        :param Mapping[str, str] tags: The tags of the resource.
        :param str user_name: The user name of the virtual machine.
        """
        if allow_claim is None:
            allow_claim = False
        if allow_claim is not None:
            pulumi.set(__self__, "allow_claim", allow_claim)
        if artifacts is not None:
            pulumi.set(__self__, "artifacts", artifacts)
        if bulk_creation_parameters is not None:
            pulumi.set(__self__, "bulk_creation_parameters", bulk_creation_parameters)
        if created_date is not None:
            pulumi.set(__self__, "created_date", created_date)
        if custom_image_id is not None:
            pulumi.set(__self__, "custom_image_id", custom_image_id)
        if data_disk_parameters is not None:
            pulumi.set(__self__, "data_disk_parameters", data_disk_parameters)
        if disallow_public_ip_address is None:
            disallow_public_ip_address = False
        if disallow_public_ip_address is not None:
            pulumi.set(__self__, "disallow_public_ip_address", disallow_public_ip_address)
        if environment_id is not None:
            pulumi.set(__self__, "environment_id", environment_id)
        if expiration_date is not None:
            pulumi.set(__self__, "expiration_date", expiration_date)
        if gallery_image_reference is not None:
            pulumi.set(__self__, "gallery_image_reference", gallery_image_reference)
        if is_authentication_with_ssh_key is not None:
            pulumi.set(__self__, "is_authentication_with_ssh_key", is_authentication_with_ssh_key)
        if lab_subnet_name is not None:
            pulumi.set(__self__, "lab_subnet_name", lab_subnet_name)
        if lab_virtual_network_id is not None:
            pulumi.set(__self__, "lab_virtual_network_id", lab_virtual_network_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_interface is not None:
            pulumi.set(__self__, "network_interface", network_interface)
        if notes is not None:
            pulumi.set(__self__, "notes", notes)
        if owner_object_id is None:
            owner_object_id = 'dynamicValue'
        if owner_object_id is not None:
            pulumi.set(__self__, "owner_object_id", owner_object_id)
        if owner_user_principal_name is not None:
            pulumi.set(__self__, "owner_user_principal_name", owner_user_principal_name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if plan_id is not None:
            pulumi.set(__self__, "plan_id", plan_id)
        if schedule_parameters is not None:
            pulumi.set(__self__, "schedule_parameters", schedule_parameters)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if ssh_key is not None:
            pulumi.set(__self__, "ssh_key", ssh_key)
        if storage_type is None:
            storage_type = 'labStorageType'
        if storage_type is not None:
            pulumi.set(__self__, "storage_type", storage_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter(name="allowClaim")
    def allow_claim(self) -> Optional[bool]:
        """
        Indicates whether another user can take ownership of the virtual machine
        """
        return pulumi.get(self, "allow_claim")

    @property
    @pulumi.getter
    def artifacts(self) -> Optional[Sequence['outputs.ArtifactInstallPropertiesResponse']]:
        """
        The artifacts to be installed on the virtual machine.
        """
        return pulumi.get(self, "artifacts")

    @property
    @pulumi.getter(name="bulkCreationParameters")
    def bulk_creation_parameters(self) -> Optional['outputs.BulkCreationParametersResponse']:
        """
        The number of virtual machine instances to create.
        """
        return pulumi.get(self, "bulk_creation_parameters")

    @property
    @pulumi.getter(name="createdDate")
    def created_date(self) -> Optional[str]:
        """
        The creation date of the virtual machine.
        """
        return pulumi.get(self, "created_date")

    @property
    @pulumi.getter(name="customImageId")
    def custom_image_id(self) -> Optional[str]:
        """
        The custom image identifier of the virtual machine.
        """
        return pulumi.get(self, "custom_image_id")

    @property
    @pulumi.getter(name="dataDiskParameters")
    def data_disk_parameters(self) -> Optional[Sequence['outputs.DataDiskPropertiesResponse']]:
        """
        New or existing data disks to attach to the virtual machine after creation
        """
        return pulumi.get(self, "data_disk_parameters")

    @property
    @pulumi.getter(name="disallowPublicIpAddress")
    def disallow_public_ip_address(self) -> Optional[bool]:
        """
        Indicates whether the virtual machine is to be created without a public IP address.
        """
        return pulumi.get(self, "disallow_public_ip_address")

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> Optional[str]:
        """
        The resource ID of the environment that contains this virtual machine, if any.
        """
        return pulumi.get(self, "environment_id")

    @property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> Optional[str]:
        """
        The expiration date for VM.
        """
        return pulumi.get(self, "expiration_date")

    @property
    @pulumi.getter(name="galleryImageReference")
    def gallery_image_reference(self) -> Optional['outputs.GalleryImageReferenceResponse']:
        """
        The Microsoft Azure Marketplace image reference of the virtual machine.
        """
        return pulumi.get(self, "gallery_image_reference")

    @property
    @pulumi.getter(name="isAuthenticationWithSshKey")
    def is_authentication_with_ssh_key(self) -> Optional[bool]:
        """
        Indicates whether this virtual machine uses an SSH key for authentication.
        """
        return pulumi.get(self, "is_authentication_with_ssh_key")

    @property
    @pulumi.getter(name="labSubnetName")
    def lab_subnet_name(self) -> Optional[str]:
        """
        The lab subnet name of the virtual machine.
        """
        return pulumi.get(self, "lab_subnet_name")

    @property
    @pulumi.getter(name="labVirtualNetworkId")
    def lab_virtual_network_id(self) -> Optional[str]:
        """
        The lab virtual network identifier of the virtual machine.
        """
        return pulumi.get(self, "lab_virtual_network_id")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        The location of the new virtual machine or environment
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the virtual machine or environment
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkInterface")
    def network_interface(self) -> Optional['outputs.NetworkInterfacePropertiesResponse']:
        """
        The network interface properties.
        """
        return pulumi.get(self, "network_interface")

    @property
    @pulumi.getter
    def notes(self) -> Optional[str]:
        """
        The notes of the virtual machine.
        """
        return pulumi.get(self, "notes")

    @property
    @pulumi.getter(name="ownerObjectId")
    def owner_object_id(self) -> Optional[str]:
        """
        The object identifier of the owner of the virtual machine.
        """
        return pulumi.get(self, "owner_object_id")

    @property
    @pulumi.getter(name="ownerUserPrincipalName")
    def owner_user_principal_name(self) -> Optional[str]:
        """
        The user principal name of the virtual machine owner.
        """
        return pulumi.get(self, "owner_user_principal_name")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        The password of the virtual machine administrator.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="planId")
    def plan_id(self) -> Optional[str]:
        """
        The id of the plan associated with the virtual machine image
        """
        return pulumi.get(self, "plan_id")

    @property
    @pulumi.getter(name="scheduleParameters")
    def schedule_parameters(self) -> Optional[Sequence['outputs.ScheduleCreationParameterResponse']]:
        """
        Virtual Machine schedules to be created
        """
        return pulumi.get(self, "schedule_parameters")

    @property
    @pulumi.getter
    def size(self) -> Optional[str]:
        """
        The size of the virtual machine.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="sshKey")
    def ssh_key(self) -> Optional[str]:
        """
        The SSH key of the virtual machine administrator.
        """
        return pulumi.get(self, "ssh_key")

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> Optional[str]:
        """
        Storage type to use for virtual machine (i.e. Standard, Premium).
        """
        return pulumi.get(self, "storage_type")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        The tags of the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[str]:
        """
        The user name of the virtual machine.
        """
        return pulumi.get(self, "user_name")


@pulumi.output_type
class LinuxOsInfoResponse(dict):
    """
    Information about a Linux OS.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "linuxOsState":
            suggest = "linux_os_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LinuxOsInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LinuxOsInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LinuxOsInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 linux_os_state: Optional[str] = None):
        """
        Information about a Linux OS.
        :param str linux_os_state: The state of the Linux OS (i.e. NonDeprovisioned, DeprovisionRequested, DeprovisionApplied).
        """
        if linux_os_state is not None:
            pulumi.set(__self__, "linux_os_state", linux_os_state)

    @property
    @pulumi.getter(name="linuxOsState")
    def linux_os_state(self) -> Optional[str]:
        """
        The state of the Linux OS (i.e. NonDeprovisioned, DeprovisionRequested, DeprovisionApplied).
        """
        return pulumi.get(self, "linux_os_state")


@pulumi.output_type
class NetworkInterfacePropertiesResponse(dict):
    """
    Properties of a network interface.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsName":
            suggest = "dns_name"
        elif key == "privateIpAddress":
            suggest = "private_ip_address"
        elif key == "publicIpAddress":
            suggest = "public_ip_address"
        elif key == "publicIpAddressId":
            suggest = "public_ip_address_id"
        elif key == "rdpAuthority":
            suggest = "rdp_authority"
        elif key == "sharedPublicIpAddressConfiguration":
            suggest = "shared_public_ip_address_configuration"
        elif key == "sshAuthority":
            suggest = "ssh_authority"
        elif key == "subnetId":
            suggest = "subnet_id"
        elif key == "virtualNetworkId":
            suggest = "virtual_network_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkInterfacePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkInterfacePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkInterfacePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dns_name: Optional[str] = None,
                 private_ip_address: Optional[str] = None,
                 public_ip_address: Optional[str] = None,
                 public_ip_address_id: Optional[str] = None,
                 rdp_authority: Optional[str] = None,
                 shared_public_ip_address_configuration: Optional['outputs.SharedPublicIpAddressConfigurationResponse'] = None,
                 ssh_authority: Optional[str] = None,
                 subnet_id: Optional[str] = None,
                 virtual_network_id: Optional[str] = None):
        """
        Properties of a network interface.
        :param str dns_name: The DNS name.
        :param str private_ip_address: The private IP address.
        :param str public_ip_address: The public IP address.
        :param str public_ip_address_id: The resource ID of the public IP address.
        :param str rdp_authority: The RdpAuthority property is a server DNS host name or IP address followed by the service port number for RDP (Remote Desktop Protocol).
        :param 'SharedPublicIpAddressConfigurationResponse' shared_public_ip_address_configuration: The configuration for sharing a public IP address across multiple virtual machines.
        :param str ssh_authority: The SshAuthority property is a server DNS host name or IP address followed by the service port number for SSH.
        :param str subnet_id: The resource ID of the sub net.
        :param str virtual_network_id: The resource ID of the virtual network.
        """
        if dns_name is not None:
            pulumi.set(__self__, "dns_name", dns_name)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if public_ip_address is not None:
            pulumi.set(__self__, "public_ip_address", public_ip_address)
        if public_ip_address_id is not None:
            pulumi.set(__self__, "public_ip_address_id", public_ip_address_id)
        if rdp_authority is not None:
            pulumi.set(__self__, "rdp_authority", rdp_authority)
        if shared_public_ip_address_configuration is not None:
            pulumi.set(__self__, "shared_public_ip_address_configuration", shared_public_ip_address_configuration)
        if ssh_authority is not None:
            pulumi.set(__self__, "ssh_authority", ssh_authority)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if virtual_network_id is not None:
            pulumi.set(__self__, "virtual_network_id", virtual_network_id)

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> Optional[str]:
        """
        The DNS name.
        """
        return pulumi.get(self, "dns_name")

    @property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> Optional[str]:
        """
        The private IP address.
        """
        return pulumi.get(self, "private_ip_address")

    @property
    @pulumi.getter(name="publicIpAddress")
    def public_ip_address(self) -> Optional[str]:
        """
        The public IP address.
        """
        return pulumi.get(self, "public_ip_address")

    @property
    @pulumi.getter(name="publicIpAddressId")
    def public_ip_address_id(self) -> Optional[str]:
        """
        The resource ID of the public IP address.
        """
        return pulumi.get(self, "public_ip_address_id")

    @property
    @pulumi.getter(name="rdpAuthority")
    def rdp_authority(self) -> Optional[str]:
        """
        The RdpAuthority property is a server DNS host name or IP address followed by the service port number for RDP (Remote Desktop Protocol).
        """
        return pulumi.get(self, "rdp_authority")

    @property
    @pulumi.getter(name="sharedPublicIpAddressConfiguration")
    def shared_public_ip_address_configuration(self) -> Optional['outputs.SharedPublicIpAddressConfigurationResponse']:
        """
        The configuration for sharing a public IP address across multiple virtual machines.
        """
        return pulumi.get(self, "shared_public_ip_address_configuration")

    @property
    @pulumi.getter(name="sshAuthority")
    def ssh_authority(self) -> Optional[str]:
        """
        The SshAuthority property is a server DNS host name or IP address followed by the service port number for SSH.
        """
        return pulumi.get(self, "ssh_authority")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[str]:
        """
        The resource ID of the sub net.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="virtualNetworkId")
    def virtual_network_id(self) -> Optional[str]:
        """
        The resource ID of the virtual network.
        """
        return pulumi.get(self, "virtual_network_id")


@pulumi.output_type
class NotificationSettingsResponse(dict):
    """
    Notification settings for a schedule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "emailRecipient":
            suggest = "email_recipient"
        elif key == "notificationLocale":
            suggest = "notification_locale"
        elif key == "timeInMinutes":
            suggest = "time_in_minutes"
        elif key == "webhookUrl":
            suggest = "webhook_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NotificationSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NotificationSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NotificationSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 email_recipient: Optional[str] = None,
                 notification_locale: Optional[str] = None,
                 status: Optional[str] = None,
                 time_in_minutes: Optional[int] = None,
                 webhook_url: Optional[str] = None):
        """
        Notification settings for a schedule.
        :param str email_recipient: The email recipient to send notifications to (can be a list of semi-colon separated email addresses).
        :param str notification_locale: The locale to use when sending a notification (fallback for unsupported languages is EN).
        :param str status: If notifications are enabled for this schedule (i.e. Enabled, Disabled).
        :param int time_in_minutes: Time in minutes before event at which notification will be sent.
        :param str webhook_url: The webhook URL to which the notification will be sent.
        """
        if email_recipient is not None:
            pulumi.set(__self__, "email_recipient", email_recipient)
        if notification_locale is not None:
            pulumi.set(__self__, "notification_locale", notification_locale)
        if status is None:
            status = 'Disabled'
        if status is not None:
            pulumi.set(__self__, "status", status)
        if time_in_minutes is not None:
            pulumi.set(__self__, "time_in_minutes", time_in_minutes)
        if webhook_url is not None:
            pulumi.set(__self__, "webhook_url", webhook_url)

    @property
    @pulumi.getter(name="emailRecipient")
    def email_recipient(self) -> Optional[str]:
        """
        The email recipient to send notifications to (can be a list of semi-colon separated email addresses).
        """
        return pulumi.get(self, "email_recipient")

    @property
    @pulumi.getter(name="notificationLocale")
    def notification_locale(self) -> Optional[str]:
        """
        The locale to use when sending a notification (fallback for unsupported languages is EN).
        """
        return pulumi.get(self, "notification_locale")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        If notifications are enabled for this schedule (i.e. Enabled, Disabled).
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="timeInMinutes")
    def time_in_minutes(self) -> Optional[int]:
        """
        Time in minutes before event at which notification will be sent.
        """
        return pulumi.get(self, "time_in_minutes")

    @property
    @pulumi.getter(name="webhookUrl")
    def webhook_url(self) -> Optional[str]:
        """
        The webhook URL to which the notification will be sent.
        """
        return pulumi.get(self, "webhook_url")


@pulumi.output_type
class PortResponse(dict):
    """
    Properties of a network port.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backendPort":
            suggest = "backend_port"
        elif key == "transportProtocol":
            suggest = "transport_protocol"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PortResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PortResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PortResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backend_port: Optional[int] = None,
                 transport_protocol: Optional[str] = None):
        """
        Properties of a network port.
        :param int backend_port: Backend port of the target virtual machine.
        :param str transport_protocol: Protocol type of the port.
        """
        if backend_port is not None:
            pulumi.set(__self__, "backend_port", backend_port)
        if transport_protocol is not None:
            pulumi.set(__self__, "transport_protocol", transport_protocol)

    @property
    @pulumi.getter(name="backendPort")
    def backend_port(self) -> Optional[int]:
        """
        Backend port of the target virtual machine.
        """
        return pulumi.get(self, "backend_port")

    @property
    @pulumi.getter(name="transportProtocol")
    def transport_protocol(self) -> Optional[str]:
        """
        Protocol type of the port.
        """
        return pulumi.get(self, "transport_protocol")


@pulumi.output_type
class ScheduleCreationParameterResponse(dict):
    """
    Properties for creating a schedule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dailyRecurrence":
            suggest = "daily_recurrence"
        elif key == "hourlyRecurrence":
            suggest = "hourly_recurrence"
        elif key == "notificationSettings":
            suggest = "notification_settings"
        elif key == "targetResourceId":
            suggest = "target_resource_id"
        elif key == "taskType":
            suggest = "task_type"
        elif key == "timeZoneId":
            suggest = "time_zone_id"
        elif key == "weeklyRecurrence":
            suggest = "weekly_recurrence"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduleCreationParameterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduleCreationParameterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduleCreationParameterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 location: str,
                 daily_recurrence: Optional['outputs.DayDetailsResponse'] = None,
                 hourly_recurrence: Optional['outputs.HourDetailsResponse'] = None,
                 name: Optional[str] = None,
                 notification_settings: Optional['outputs.NotificationSettingsResponse'] = None,
                 status: Optional[str] = None,
                 tags: Optional[Mapping[str, str]] = None,
                 target_resource_id: Optional[str] = None,
                 task_type: Optional[str] = None,
                 time_zone_id: Optional[str] = None,
                 weekly_recurrence: Optional['outputs.WeekDetailsResponse'] = None):
        """
        Properties for creating a schedule.
        :param str location: The location of the new virtual machine or environment
        :param 'DayDetailsResponse' daily_recurrence: If the schedule will occur once each day of the week, specify the daily recurrence.
        :param 'HourDetailsResponse' hourly_recurrence: If the schedule will occur multiple times a day, specify the hourly recurrence.
        :param str name: The name of the virtual machine or environment
        :param 'NotificationSettingsResponse' notification_settings: Notification settings.
        :param str status: The status of the schedule (i.e. Enabled, Disabled)
        :param Mapping[str, str] tags: The tags of the resource.
        :param str target_resource_id: The resource ID to which the schedule belongs
        :param str task_type: The task type of the schedule (e.g. LabVmsShutdownTask, LabVmAutoStart).
        :param str time_zone_id: The time zone ID (e.g. Pacific Standard time).
        :param 'WeekDetailsResponse' weekly_recurrence: If the schedule will occur only some days of the week, specify the weekly recurrence.
        """
        pulumi.set(__self__, "location", location)
        if daily_recurrence is not None:
            pulumi.set(__self__, "daily_recurrence", daily_recurrence)
        if hourly_recurrence is not None:
            pulumi.set(__self__, "hourly_recurrence", hourly_recurrence)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notification_settings is not None:
            pulumi.set(__self__, "notification_settings", notification_settings)
        if status is None:
            status = 'Disabled'
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if target_resource_id is not None:
            pulumi.set(__self__, "target_resource_id", target_resource_id)
        if task_type is not None:
            pulumi.set(__self__, "task_type", task_type)
        if time_zone_id is not None:
            pulumi.set(__self__, "time_zone_id", time_zone_id)
        if weekly_recurrence is not None:
            pulumi.set(__self__, "weekly_recurrence", weekly_recurrence)

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        The location of the new virtual machine or environment
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="dailyRecurrence")
    def daily_recurrence(self) -> Optional['outputs.DayDetailsResponse']:
        """
        If the schedule will occur once each day of the week, specify the daily recurrence.
        """
        return pulumi.get(self, "daily_recurrence")

    @property
    @pulumi.getter(name="hourlyRecurrence")
    def hourly_recurrence(self) -> Optional['outputs.HourDetailsResponse']:
        """
        If the schedule will occur multiple times a day, specify the hourly recurrence.
        """
        return pulumi.get(self, "hourly_recurrence")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the virtual machine or environment
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="notificationSettings")
    def notification_settings(self) -> Optional['outputs.NotificationSettingsResponse']:
        """
        Notification settings.
        """
        return pulumi.get(self, "notification_settings")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The status of the schedule (i.e. Enabled, Disabled)
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        The tags of the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="targetResourceId")
    def target_resource_id(self) -> Optional[str]:
        """
        The resource ID to which the schedule belongs
        """
        return pulumi.get(self, "target_resource_id")

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> Optional[str]:
        """
        The task type of the schedule (e.g. LabVmsShutdownTask, LabVmAutoStart).
        """
        return pulumi.get(self, "task_type")

    @property
    @pulumi.getter(name="timeZoneId")
    def time_zone_id(self) -> Optional[str]:
        """
        The time zone ID (e.g. Pacific Standard time).
        """
        return pulumi.get(self, "time_zone_id")

    @property
    @pulumi.getter(name="weeklyRecurrence")
    def weekly_recurrence(self) -> Optional['outputs.WeekDetailsResponse']:
        """
        If the schedule will occur only some days of the week, specify the weekly recurrence.
        """
        return pulumi.get(self, "weekly_recurrence")


@pulumi.output_type
class ScheduleResponse(dict):
    """
    A schedule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdDate":
            suggest = "created_date"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "uniqueIdentifier":
            suggest = "unique_identifier"
        elif key == "dailyRecurrence":
            suggest = "daily_recurrence"
        elif key == "hourlyRecurrence":
            suggest = "hourly_recurrence"
        elif key == "notificationSettings":
            suggest = "notification_settings"
        elif key == "targetResourceId":
            suggest = "target_resource_id"
        elif key == "taskType":
            suggest = "task_type"
        elif key == "timeZoneId":
            suggest = "time_zone_id"
        elif key == "weeklyRecurrence":
            suggest = "weekly_recurrence"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_date: str,
                 id: str,
                 name: str,
                 provisioning_state: str,
                 type: str,
                 unique_identifier: str,
                 daily_recurrence: Optional['outputs.DayDetailsResponse'] = None,
                 hourly_recurrence: Optional['outputs.HourDetailsResponse'] = None,
                 location: Optional[str] = None,
                 notification_settings: Optional['outputs.NotificationSettingsResponse'] = None,
                 status: Optional[str] = None,
                 tags: Optional[Mapping[str, str]] = None,
                 target_resource_id: Optional[str] = None,
                 task_type: Optional[str] = None,
                 time_zone_id: Optional[str] = None,
                 weekly_recurrence: Optional['outputs.WeekDetailsResponse'] = None):
        """
        A schedule.
        :param str created_date: The creation date of the schedule.
        :param str id: The identifier of the resource.
        :param str name: The name of the resource.
        :param str provisioning_state: The provisioning status of the resource.
        :param str type: The type of the resource.
        :param str unique_identifier: The unique immutable identifier of a resource (Guid).
        :param 'DayDetailsResponse' daily_recurrence: If the schedule will occur once each day of the week, specify the daily recurrence.
        :param 'HourDetailsResponse' hourly_recurrence: If the schedule will occur multiple times a day, specify the hourly recurrence.
        :param str location: The location of the resource.
        :param 'NotificationSettingsResponse' notification_settings: Notification settings.
        :param str status: The status of the schedule (i.e. Enabled, Disabled)
        :param Mapping[str, str] tags: The tags of the resource.
        :param str target_resource_id: The resource ID to which the schedule belongs
        :param str task_type: The task type of the schedule (e.g. LabVmsShutdownTask, LabVmAutoStart).
        :param str time_zone_id: The time zone ID (e.g. Pacific Standard time).
        :param 'WeekDetailsResponse' weekly_recurrence: If the schedule will occur only some days of the week, specify the weekly recurrence.
        """
        pulumi.set(__self__, "created_date", created_date)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "unique_identifier", unique_identifier)
        if daily_recurrence is not None:
            pulumi.set(__self__, "daily_recurrence", daily_recurrence)
        if hourly_recurrence is not None:
            pulumi.set(__self__, "hourly_recurrence", hourly_recurrence)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if notification_settings is not None:
            pulumi.set(__self__, "notification_settings", notification_settings)
        if status is None:
            status = 'Disabled'
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if target_resource_id is not None:
            pulumi.set(__self__, "target_resource_id", target_resource_id)
        if task_type is not None:
            pulumi.set(__self__, "task_type", task_type)
        if time_zone_id is not None:
            pulumi.set(__self__, "time_zone_id", time_zone_id)
        if weekly_recurrence is not None:
            pulumi.set(__self__, "weekly_recurrence", weekly_recurrence)

    @property
    @pulumi.getter(name="createdDate")
    def created_date(self) -> str:
        """
        The creation date of the schedule.
        """
        return pulumi.get(self, "created_date")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The identifier of the resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning status of the resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the resource.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="uniqueIdentifier")
    def unique_identifier(self) -> str:
        """
        The unique immutable identifier of a resource (Guid).
        """
        return pulumi.get(self, "unique_identifier")

    @property
    @pulumi.getter(name="dailyRecurrence")
    def daily_recurrence(self) -> Optional['outputs.DayDetailsResponse']:
        """
        If the schedule will occur once each day of the week, specify the daily recurrence.
        """
        return pulumi.get(self, "daily_recurrence")

    @property
    @pulumi.getter(name="hourlyRecurrence")
    def hourly_recurrence(self) -> Optional['outputs.HourDetailsResponse']:
        """
        If the schedule will occur multiple times a day, specify the hourly recurrence.
        """
        return pulumi.get(self, "hourly_recurrence")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        The location of the resource.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="notificationSettings")
    def notification_settings(self) -> Optional['outputs.NotificationSettingsResponse']:
        """
        Notification settings.
        """
        return pulumi.get(self, "notification_settings")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The status of the schedule (i.e. Enabled, Disabled)
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        The tags of the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="targetResourceId")
    def target_resource_id(self) -> Optional[str]:
        """
        The resource ID to which the schedule belongs
        """
        return pulumi.get(self, "target_resource_id")

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> Optional[str]:
        """
        The task type of the schedule (e.g. LabVmsShutdownTask, LabVmAutoStart).
        """
        return pulumi.get(self, "task_type")

    @property
    @pulumi.getter(name="timeZoneId")
    def time_zone_id(self) -> Optional[str]:
        """
        The time zone ID (e.g. Pacific Standard time).
        """
        return pulumi.get(self, "time_zone_id")

    @property
    @pulumi.getter(name="weeklyRecurrence")
    def weekly_recurrence(self) -> Optional['outputs.WeekDetailsResponse']:
        """
        If the schedule will occur only some days of the week, specify the weekly recurrence.
        """
        return pulumi.get(self, "weekly_recurrence")


@pulumi.output_type
class SharedPublicIpAddressConfigurationResponse(dict):
    """
    Properties of a virtual machine that determine how it is connected to a load balancer.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inboundNatRules":
            suggest = "inbound_nat_rules"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SharedPublicIpAddressConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SharedPublicIpAddressConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SharedPublicIpAddressConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 inbound_nat_rules: Optional[Sequence['outputs.InboundNatRuleResponse']] = None):
        """
        Properties of a virtual machine that determine how it is connected to a load balancer.
        :param Sequence['InboundNatRuleResponse'] inbound_nat_rules: The incoming NAT rules
        """
        if inbound_nat_rules is not None:
            pulumi.set(__self__, "inbound_nat_rules", inbound_nat_rules)

    @property
    @pulumi.getter(name="inboundNatRules")
    def inbound_nat_rules(self) -> Optional[Sequence['outputs.InboundNatRuleResponse']]:
        """
        The incoming NAT rules
        """
        return pulumi.get(self, "inbound_nat_rules")


@pulumi.output_type
class SubnetOverrideResponse(dict):
    """
    Property overrides on a subnet of a virtual network.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "labSubnetName":
            suggest = "lab_subnet_name"
        elif key == "resourceId":
            suggest = "resource_id"
        elif key == "sharedPublicIpAddressConfiguration":
            suggest = "shared_public_ip_address_configuration"
        elif key == "useInVmCreationPermission":
            suggest = "use_in_vm_creation_permission"
        elif key == "usePublicIpAddressPermission":
            suggest = "use_public_ip_address_permission"
        elif key == "virtualNetworkPoolName":
            suggest = "virtual_network_pool_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SubnetOverrideResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SubnetOverrideResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SubnetOverrideResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 lab_subnet_name: Optional[str] = None,
                 resource_id: Optional[str] = None,
                 shared_public_ip_address_configuration: Optional['outputs.SubnetSharedPublicIpAddressConfigurationResponse'] = None,
                 use_in_vm_creation_permission: Optional[str] = None,
                 use_public_ip_address_permission: Optional[str] = None,
                 virtual_network_pool_name: Optional[str] = None):
        """
        Property overrides on a subnet of a virtual network.
        :param str lab_subnet_name: The name given to the subnet within the lab.
        :param str resource_id: The resource ID of the subnet.
        :param 'SubnetSharedPublicIpAddressConfigurationResponse' shared_public_ip_address_configuration: Properties that virtual machines on this subnet will share.
        :param str use_in_vm_creation_permission: Indicates whether this subnet can be used during virtual machine creation (i.e. Allow, Deny).
        :param str use_public_ip_address_permission: Indicates whether public IP addresses can be assigned to virtual machines on this subnet (i.e. Allow, Deny).
        :param str virtual_network_pool_name: The virtual network pool associated with this subnet.
        """
        if lab_subnet_name is not None:
            pulumi.set(__self__, "lab_subnet_name", lab_subnet_name)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if shared_public_ip_address_configuration is not None:
            pulumi.set(__self__, "shared_public_ip_address_configuration", shared_public_ip_address_configuration)
        if use_in_vm_creation_permission is not None:
            pulumi.set(__self__, "use_in_vm_creation_permission", use_in_vm_creation_permission)
        if use_public_ip_address_permission is not None:
            pulumi.set(__self__, "use_public_ip_address_permission", use_public_ip_address_permission)
        if virtual_network_pool_name is not None:
            pulumi.set(__self__, "virtual_network_pool_name", virtual_network_pool_name)

    @property
    @pulumi.getter(name="labSubnetName")
    def lab_subnet_name(self) -> Optional[str]:
        """
        The name given to the subnet within the lab.
        """
        return pulumi.get(self, "lab_subnet_name")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        The resource ID of the subnet.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="sharedPublicIpAddressConfiguration")
    def shared_public_ip_address_configuration(self) -> Optional['outputs.SubnetSharedPublicIpAddressConfigurationResponse']:
        """
        Properties that virtual machines on this subnet will share.
        """
        return pulumi.get(self, "shared_public_ip_address_configuration")

    @property
    @pulumi.getter(name="useInVmCreationPermission")
    def use_in_vm_creation_permission(self) -> Optional[str]:
        """
        Indicates whether this subnet can be used during virtual machine creation (i.e. Allow, Deny).
        """
        return pulumi.get(self, "use_in_vm_creation_permission")

    @property
    @pulumi.getter(name="usePublicIpAddressPermission")
    def use_public_ip_address_permission(self) -> Optional[str]:
        """
        Indicates whether public IP addresses can be assigned to virtual machines on this subnet (i.e. Allow, Deny).
        """
        return pulumi.get(self, "use_public_ip_address_permission")

    @property
    @pulumi.getter(name="virtualNetworkPoolName")
    def virtual_network_pool_name(self) -> Optional[str]:
        """
        The virtual network pool associated with this subnet.
        """
        return pulumi.get(self, "virtual_network_pool_name")


@pulumi.output_type
class SubnetResponse(dict):
    """
    Subnet information.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowPublicIp":
            suggest = "allow_public_ip"
        elif key == "labSubnetName":
            suggest = "lab_subnet_name"
        elif key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SubnetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SubnetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SubnetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_public_ip: Optional[str] = None,
                 lab_subnet_name: Optional[str] = None,
                 resource_id: Optional[str] = None):
        """
        Subnet information.
        :param str allow_public_ip: The permission policy of the subnet for allowing public IP addresses (i.e. Allow, Deny)).
        :param str lab_subnet_name: The name of the subnet as seen in the lab.
        :param str resource_id: The resource ID of the subnet.
        """
        if allow_public_ip is not None:
            pulumi.set(__self__, "allow_public_ip", allow_public_ip)
        if lab_subnet_name is not None:
            pulumi.set(__self__, "lab_subnet_name", lab_subnet_name)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="allowPublicIp")
    def allow_public_ip(self) -> Optional[str]:
        """
        The permission policy of the subnet for allowing public IP addresses (i.e. Allow, Deny)).
        """
        return pulumi.get(self, "allow_public_ip")

    @property
    @pulumi.getter(name="labSubnetName")
    def lab_subnet_name(self) -> Optional[str]:
        """
        The name of the subnet as seen in the lab.
        """
        return pulumi.get(self, "lab_subnet_name")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        The resource ID of the subnet.
        """
        return pulumi.get(self, "resource_id")


@pulumi.output_type
class SubnetSharedPublicIpAddressConfigurationResponse(dict):
    """
    Configuration for public IP address sharing.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedPorts":
            suggest = "allowed_ports"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SubnetSharedPublicIpAddressConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SubnetSharedPublicIpAddressConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SubnetSharedPublicIpAddressConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_ports: Optional[Sequence['outputs.PortResponse']] = None):
        """
        Configuration for public IP address sharing.
        :param Sequence['PortResponse'] allowed_ports: Backend ports that virtual machines on this subnet are allowed to expose
        """
        if allowed_ports is not None:
            pulumi.set(__self__, "allowed_ports", allowed_ports)

    @property
    @pulumi.getter(name="allowedPorts")
    def allowed_ports(self) -> Optional[Sequence['outputs.PortResponse']]:
        """
        Backend ports that virtual machines on this subnet are allowed to expose
        """
        return pulumi.get(self, "allowed_ports")


@pulumi.output_type
class UserIdentityResponse(dict):
    """
    Identity attributes of a lab user.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appId":
            suggest = "app_id"
        elif key == "objectId":
            suggest = "object_id"
        elif key == "principalId":
            suggest = "principal_id"
        elif key == "principalName":
            suggest = "principal_name"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 app_id: Optional[str] = None,
                 object_id: Optional[str] = None,
                 principal_id: Optional[str] = None,
                 principal_name: Optional[str] = None,
                 tenant_id: Optional[str] = None):
        """
        Identity attributes of a lab user.
        :param str app_id: Set to the app Id of the client JWT making the request.
        :param str object_id: Set to the object Id of the client JWT making the request. Not all users have object Id. For CSP (reseller) scenarios for example, object Id is not available.
        :param str principal_id: Set to the principal Id of the client JWT making the request. Service principal will not have the principal Id.
        :param str principal_name: Set to the principal name / UPN of the client JWT making the request.
        :param str tenant_id: Set to the tenant ID of the client JWT making the request.
        """
        if app_id is not None:
            pulumi.set(__self__, "app_id", app_id)
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if principal_name is not None:
            pulumi.set(__self__, "principal_name", principal_name)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> Optional[str]:
        """
        Set to the app Id of the client JWT making the request.
        """
        return pulumi.get(self, "app_id")

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[str]:
        """
        Set to the object Id of the client JWT making the request. Not all users have object Id. For CSP (reseller) scenarios for example, object Id is not available.
        """
        return pulumi.get(self, "object_id")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[str]:
        """
        Set to the principal Id of the client JWT making the request. Service principal will not have the principal Id.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="principalName")
    def principal_name(self) -> Optional[str]:
        """
        Set to the principal name / UPN of the client JWT making the request.
        """
        return pulumi.get(self, "principal_name")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[str]:
        """
        Set to the tenant ID of the client JWT making the request.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class UserSecretStoreResponse(dict):
    """
    Properties of a user's secret store.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyVaultId":
            suggest = "key_vault_id"
        elif key == "keyVaultUri":
            suggest = "key_vault_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserSecretStoreResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserSecretStoreResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserSecretStoreResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_vault_id: Optional[str] = None,
                 key_vault_uri: Optional[str] = None):
        """
        Properties of a user's secret store.
        :param str key_vault_id: The ID of the user's Key vault.
        :param str key_vault_uri: The URI of the user's Key vault.
        """
        if key_vault_id is not None:
            pulumi.set(__self__, "key_vault_id", key_vault_id)
        if key_vault_uri is not None:
            pulumi.set(__self__, "key_vault_uri", key_vault_uri)

    @property
    @pulumi.getter(name="keyVaultId")
    def key_vault_id(self) -> Optional[str]:
        """
        The ID of the user's Key vault.
        """
        return pulumi.get(self, "key_vault_id")

    @property
    @pulumi.getter(name="keyVaultUri")
    def key_vault_uri(self) -> Optional[str]:
        """
        The URI of the user's Key vault.
        """
        return pulumi.get(self, "key_vault_uri")


@pulumi.output_type
class WeekDetailsResponse(dict):
    """
    Properties of a weekly schedule.
    """
    def __init__(__self__, *,
                 time: Optional[str] = None,
                 weekdays: Optional[Sequence[str]] = None):
        """
        Properties of a weekly schedule.
        :param str time: The time of the day the schedule will occur.
        :param Sequence[str] weekdays: The days of the week for which the schedule is set (e.g. Sunday, Monday, Tuesday, etc.).
        """
        if time is not None:
            pulumi.set(__self__, "time", time)
        if weekdays is not None:
            pulumi.set(__self__, "weekdays", weekdays)

    @property
    @pulumi.getter
    def time(self) -> Optional[str]:
        """
        The time of the day the schedule will occur.
        """
        return pulumi.get(self, "time")

    @property
    @pulumi.getter
    def weekdays(self) -> Optional[Sequence[str]]:
        """
        The days of the week for which the schedule is set (e.g. Sunday, Monday, Tuesday, etc.).
        """
        return pulumi.get(self, "weekdays")


@pulumi.output_type
class WindowsOsInfoResponse(dict):
    """
    Information about a Windows OS.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "windowsOsState":
            suggest = "windows_os_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WindowsOsInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WindowsOsInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WindowsOsInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 windows_os_state: Optional[str] = None):
        """
        Information about a Windows OS.
        :param str windows_os_state: The state of the Windows OS (i.e. NonSysprepped, SysprepRequested, SysprepApplied).
        """
        if windows_os_state is not None:
            pulumi.set(__self__, "windows_os_state", windows_os_state)

    @property
    @pulumi.getter(name="windowsOsState")
    def windows_os_state(self) -> Optional[str]:
        """
        The state of the Windows OS (i.e. NonSysprepped, SysprepRequested, SysprepApplied).
        """
        return pulumi.get(self, "windows_os_state")


