# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'MsixPackageApplicationsArgs',
    'MsixPackageDependenciesArgs',
    'RegistrationInfoArgs',
]

@pulumi.input_type
class MsixPackageApplicationsArgs:
    def __init__(__self__, *,
                 app_id: Optional[pulumi.Input[str]] = None,
                 app_user_model_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 friendly_name: Optional[pulumi.Input[str]] = None,
                 icon_image_name: Optional[pulumi.Input[str]] = None,
                 raw_icon: Optional[pulumi.Input[str]] = None,
                 raw_png: Optional[pulumi.Input[str]] = None):
        """
        Schema for MSIX Package Application properties.
        :param pulumi.Input[str] app_id: Package Application Id, found in appxmanifest.xml.
        :param pulumi.Input[str] app_user_model_id: Used to activate Package Application. Consists of Package Name and ApplicationID. Found in appxmanifest.xml.
        :param pulumi.Input[str] description: Description of Package Application.
        :param pulumi.Input[str] friendly_name: User friendly name.
        :param pulumi.Input[str] icon_image_name: User friendly name.
        :param pulumi.Input[str] raw_icon: the icon a 64 bit string as a byte array.
        :param pulumi.Input[str] raw_png: the icon a 64 bit string as a byte array.
        """
        if app_id is not None:
            pulumi.set(__self__, "app_id", app_id)
        if app_user_model_id is not None:
            pulumi.set(__self__, "app_user_model_id", app_user_model_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if icon_image_name is not None:
            pulumi.set(__self__, "icon_image_name", icon_image_name)
        if raw_icon is not None:
            pulumi.set(__self__, "raw_icon", raw_icon)
        if raw_png is not None:
            pulumi.set(__self__, "raw_png", raw_png)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> Optional[pulumi.Input[str]]:
        """
        Package Application Id, found in appxmanifest.xml.
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_id", value)

    @property
    @pulumi.getter(name="appUserModelID")
    def app_user_model_id(self) -> Optional[pulumi.Input[str]]:
        """
        Used to activate Package Application. Consists of Package Name and ApplicationID. Found in appxmanifest.xml.
        """
        return pulumi.get(self, "app_user_model_id")

    @app_user_model_id.setter
    def app_user_model_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_user_model_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of Package Application.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[str]]:
        """
        User friendly name.
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "friendly_name", value)

    @property
    @pulumi.getter(name="iconImageName")
    def icon_image_name(self) -> Optional[pulumi.Input[str]]:
        """
        User friendly name.
        """
        return pulumi.get(self, "icon_image_name")

    @icon_image_name.setter
    def icon_image_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "icon_image_name", value)

    @property
    @pulumi.getter(name="rawIcon")
    def raw_icon(self) -> Optional[pulumi.Input[str]]:
        """
        the icon a 64 bit string as a byte array.
        """
        return pulumi.get(self, "raw_icon")

    @raw_icon.setter
    def raw_icon(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "raw_icon", value)

    @property
    @pulumi.getter(name="rawPng")
    def raw_png(self) -> Optional[pulumi.Input[str]]:
        """
        the icon a 64 bit string as a byte array.
        """
        return pulumi.get(self, "raw_png")

    @raw_png.setter
    def raw_png(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "raw_png", value)


@pulumi.input_type
class MsixPackageDependenciesArgs:
    def __init__(__self__, *,
                 dependency_name: Optional[pulumi.Input[str]] = None,
                 min_version: Optional[pulumi.Input[str]] = None,
                 publisher: Optional[pulumi.Input[str]] = None):
        """
        Schema for MSIX Package Dependencies properties.
        :param pulumi.Input[str] dependency_name: Name of package dependency.
        :param pulumi.Input[str] min_version: Dependency version required.
        :param pulumi.Input[str] publisher: Name of dependency publisher.
        """
        if dependency_name is not None:
            pulumi.set(__self__, "dependency_name", dependency_name)
        if min_version is not None:
            pulumi.set(__self__, "min_version", min_version)
        if publisher is not None:
            pulumi.set(__self__, "publisher", publisher)

    @property
    @pulumi.getter(name="dependencyName")
    def dependency_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of package dependency.
        """
        return pulumi.get(self, "dependency_name")

    @dependency_name.setter
    def dependency_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dependency_name", value)

    @property
    @pulumi.getter(name="minVersion")
    def min_version(self) -> Optional[pulumi.Input[str]]:
        """
        Dependency version required.
        """
        return pulumi.get(self, "min_version")

    @min_version.setter
    def min_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "min_version", value)

    @property
    @pulumi.getter
    def publisher(self) -> Optional[pulumi.Input[str]]:
        """
        Name of dependency publisher.
        """
        return pulumi.get(self, "publisher")

    @publisher.setter
    def publisher(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "publisher", value)


@pulumi.input_type
class RegistrationInfoArgs:
    def __init__(__self__, *,
                 expiration_time: Optional[pulumi.Input[str]] = None,
                 registration_token_operation: Optional[pulumi.Input[Union[str, 'RegistrationTokenOperation']]] = None,
                 token: Optional[pulumi.Input[str]] = None):
        """
        Represents a RegistrationInfo definition.
        :param pulumi.Input[str] expiration_time: Expiration time of registration token.
        :param pulumi.Input[Union[str, 'RegistrationTokenOperation']] registration_token_operation: The type of resetting the token.
        :param pulumi.Input[str] token: The registration token base64 encoded string.
        """
        if expiration_time is not None:
            pulumi.set(__self__, "expiration_time", expiration_time)
        if registration_token_operation is not None:
            pulumi.set(__self__, "registration_token_operation", registration_token_operation)
        if token is not None:
            pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> Optional[pulumi.Input[str]]:
        """
        Expiration time of registration token.
        """
        return pulumi.get(self, "expiration_time")

    @expiration_time.setter
    def expiration_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expiration_time", value)

    @property
    @pulumi.getter(name="registrationTokenOperation")
    def registration_token_operation(self) -> Optional[pulumi.Input[Union[str, 'RegistrationTokenOperation']]]:
        """
        The type of resetting the token.
        """
        return pulumi.get(self, "registration_token_operation")

    @registration_token_operation.setter
    def registration_token_operation(self, value: Optional[pulumi.Input[Union[str, 'RegistrationTokenOperation']]]):
        pulumi.set(self, "registration_token_operation", value)

    @property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[str]]:
        """
        The registration token base64 encoded string.
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "token", value)


