# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'ExportDatasetConfigurationArgs',
    'ExportDatasetArgs',
    'ExportDefinitionArgs',
    'ExportDeliveryDestinationArgs',
    'ExportDeliveryInfoArgs',
    'ExportRecurrencePeriodArgs',
    'ExportScheduleArgs',
    'ExportTimePeriodArgs',
]

@pulumi.input_type
class ExportDatasetConfigurationArgs:
    def __init__(__self__, *,
                 columns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The export dataset configuration. Allows columns to be selected for the export. If not provided then the export will include all available columns.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] columns: Array of column names to be included in the export. If not provided then the export will include all available columns. The available columns can vary by customer channel (see examples).
        """
        if columns is not None:
            pulumi.set(__self__, "columns", columns)

    @property
    @pulumi.getter
    def columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Array of column names to be included in the export. If not provided then the export will include all available columns. The available columns can vary by customer channel (see examples).
        """
        return pulumi.get(self, "columns")

    @columns.setter
    def columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "columns", value)


@pulumi.input_type
class ExportDatasetArgs:
    def __init__(__self__, *,
                 configuration: Optional[pulumi.Input['ExportDatasetConfigurationArgs']] = None,
                 granularity: Optional[pulumi.Input[Union[str, 'GranularityType']]] = None):
        """
        The definition for data in the export.
        :param pulumi.Input['ExportDatasetConfigurationArgs'] configuration: The export dataset configuration.
        :param pulumi.Input[Union[str, 'GranularityType']] granularity: The granularity of rows in the export. Currently only 'Daily' is supported.
        """
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if granularity is not None:
            pulumi.set(__self__, "granularity", granularity)

    @property
    @pulumi.getter
    def configuration(self) -> Optional[pulumi.Input['ExportDatasetConfigurationArgs']]:
        """
        The export dataset configuration.
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: Optional[pulumi.Input['ExportDatasetConfigurationArgs']]):
        pulumi.set(self, "configuration", value)

    @property
    @pulumi.getter
    def granularity(self) -> Optional[pulumi.Input[Union[str, 'GranularityType']]]:
        """
        The granularity of rows in the export. Currently only 'Daily' is supported.
        """
        return pulumi.get(self, "granularity")

    @granularity.setter
    def granularity(self, value: Optional[pulumi.Input[Union[str, 'GranularityType']]]):
        pulumi.set(self, "granularity", value)


@pulumi.input_type
class ExportDefinitionArgs:
    def __init__(__self__, *,
                 timeframe: pulumi.Input[Union[str, 'TimeframeType']],
                 type: pulumi.Input[Union[str, 'ExportType']],
                 data_set: Optional[pulumi.Input['ExportDatasetArgs']] = None,
                 time_period: Optional[pulumi.Input['ExportTimePeriodArgs']] = None):
        """
        The definition of an export.
        :param pulumi.Input[Union[str, 'TimeframeType']] timeframe: The time frame for pulling data for the export. If custom, then a specific time period must be provided.
        :param pulumi.Input[Union[str, 'ExportType']] type: The type of the export. Note that 'Usage' is equivalent to 'ActualCost' and is applicable to exports that do not yet provide data for charges or amortization for service reservations.
        :param pulumi.Input['ExportDatasetArgs'] data_set: The definition for data in the export.
        :param pulumi.Input['ExportTimePeriodArgs'] time_period: Has time period for pulling data for the export.
        """
        pulumi.set(__self__, "timeframe", timeframe)
        pulumi.set(__self__, "type", type)
        if data_set is not None:
            pulumi.set(__self__, "data_set", data_set)
        if time_period is not None:
            pulumi.set(__self__, "time_period", time_period)

    @property
    @pulumi.getter
    def timeframe(self) -> pulumi.Input[Union[str, 'TimeframeType']]:
        """
        The time frame for pulling data for the export. If custom, then a specific time period must be provided.
        """
        return pulumi.get(self, "timeframe")

    @timeframe.setter
    def timeframe(self, value: pulumi.Input[Union[str, 'TimeframeType']]):
        pulumi.set(self, "timeframe", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[Union[str, 'ExportType']]:
        """
        The type of the export. Note that 'Usage' is equivalent to 'ActualCost' and is applicable to exports that do not yet provide data for charges or amortization for service reservations.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[Union[str, 'ExportType']]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="dataSet")
    def data_set(self) -> Optional[pulumi.Input['ExportDatasetArgs']]:
        """
        The definition for data in the export.
        """
        return pulumi.get(self, "data_set")

    @data_set.setter
    def data_set(self, value: Optional[pulumi.Input['ExportDatasetArgs']]):
        pulumi.set(self, "data_set", value)

    @property
    @pulumi.getter(name="timePeriod")
    def time_period(self) -> Optional[pulumi.Input['ExportTimePeriodArgs']]:
        """
        Has time period for pulling data for the export.
        """
        return pulumi.get(self, "time_period")

    @time_period.setter
    def time_period(self, value: Optional[pulumi.Input['ExportTimePeriodArgs']]):
        pulumi.set(self, "time_period", value)


@pulumi.input_type
class ExportDeliveryDestinationArgs:
    def __init__(__self__, *,
                 container: pulumi.Input[str],
                 resource_id: Optional[pulumi.Input[str]] = None,
                 root_folder_path: Optional[pulumi.Input[str]] = None,
                 sas_token: Optional[pulumi.Input[str]] = None,
                 storage_account: Optional[pulumi.Input[str]] = None):
        """
        This represents the blob storage account location where exports of costs will be delivered. There are two ways to configure the destination. The approach recommended for most customers is to specify the resourceId of the storage account. This requires a one-time registration of the account's subscription with the Microsoft.CostManagementExports resource provider in order to give Azure Cost Management services access to the storage. When creating an export in the Azure portal this registration is performed automatically but API users may need to register the subscription explicitly (for more information see https://docs.microsoft.com/en-us/azure/azure-resource-manager/resource-manager-supported-services ). Another way to configure the destination is available ONLY to Partners with a Microsoft Partner Agreement plan who are global admins of their billing account. These Partners, instead of specifying the resourceId of a storage account, can specify the storage account name along with a SAS token for the account. This allows exports of costs to a storage account in any tenant. The SAS token should be created for the blob service with Service/Container/Object resource types and with Read/Write/Delete/List/Add/Create permissions (for more information see https://docs.microsoft.com/en-us/azure/cost-management-billing/costs/export-cost-data-storage-account-sas-key ).
        :param pulumi.Input[str] container: The name of the container where exports will be uploaded. If the container does not exist it will be created.
        :param pulumi.Input[str] resource_id: The resource id of the storage account where exports will be delivered. This is not required if a sasToken and storageAccount are specified.
        :param pulumi.Input[str] root_folder_path: The name of the directory where exports will be uploaded.
        :param pulumi.Input[str] sas_token: A SAS token for the storage account. For a restricted set of Azure customers this together with storageAccount can be specified instead of resourceId. Note: the value returned by the API for this property will always be obfuscated. Returning this same obfuscated value will not result in the SAS token being updated. To update this value a new SAS token must be specified.
        :param pulumi.Input[str] storage_account: The storage account where exports will be uploaded. For a restricted set of Azure customers this together with sasToken can be specified instead of resourceId.
        """
        pulumi.set(__self__, "container", container)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if root_folder_path is not None:
            pulumi.set(__self__, "root_folder_path", root_folder_path)
        if sas_token is not None:
            pulumi.set(__self__, "sas_token", sas_token)
        if storage_account is not None:
            pulumi.set(__self__, "storage_account", storage_account)

    @property
    @pulumi.getter
    def container(self) -> pulumi.Input[str]:
        """
        The name of the container where exports will be uploaded. If the container does not exist it will be created.
        """
        return pulumi.get(self, "container")

    @container.setter
    def container(self, value: pulumi.Input[str]):
        pulumi.set(self, "container", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The resource id of the storage account where exports will be delivered. This is not required if a sasToken and storageAccount are specified.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)

    @property
    @pulumi.getter(name="rootFolderPath")
    def root_folder_path(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the directory where exports will be uploaded.
        """
        return pulumi.get(self, "root_folder_path")

    @root_folder_path.setter
    def root_folder_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "root_folder_path", value)

    @property
    @pulumi.getter(name="sasToken")
    def sas_token(self) -> Optional[pulumi.Input[str]]:
        """
        A SAS token for the storage account. For a restricted set of Azure customers this together with storageAccount can be specified instead of resourceId. Note: the value returned by the API for this property will always be obfuscated. Returning this same obfuscated value will not result in the SAS token being updated. To update this value a new SAS token must be specified.
        """
        return pulumi.get(self, "sas_token")

    @sas_token.setter
    def sas_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sas_token", value)

    @property
    @pulumi.getter(name="storageAccount")
    def storage_account(self) -> Optional[pulumi.Input[str]]:
        """
        The storage account where exports will be uploaded. For a restricted set of Azure customers this together with sasToken can be specified instead of resourceId.
        """
        return pulumi.get(self, "storage_account")

    @storage_account.setter
    def storage_account(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_account", value)


@pulumi.input_type
class ExportDeliveryInfoArgs:
    def __init__(__self__, *,
                 destination: pulumi.Input['ExportDeliveryDestinationArgs']):
        """
        The delivery information associated with a export.
        :param pulumi.Input['ExportDeliveryDestinationArgs'] destination: Has destination for the export being delivered.
        """
        pulumi.set(__self__, "destination", destination)

    @property
    @pulumi.getter
    def destination(self) -> pulumi.Input['ExportDeliveryDestinationArgs']:
        """
        Has destination for the export being delivered.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: pulumi.Input['ExportDeliveryDestinationArgs']):
        pulumi.set(self, "destination", value)


@pulumi.input_type
class ExportRecurrencePeriodArgs:
    def __init__(__self__, *,
                 from_: pulumi.Input[str],
                 to: Optional[pulumi.Input[str]] = None):
        """
        The start and end date for recurrence schedule.
        :param pulumi.Input[str] from_: The start date of recurrence.
        :param pulumi.Input[str] to: The end date of recurrence.
        """
        pulumi.set(__self__, "from_", from_)
        if to is not None:
            pulumi.set(__self__, "to", to)

    @property
    @pulumi.getter(name="from")
    def from_(self) -> pulumi.Input[str]:
        """
        The start date of recurrence.
        """
        return pulumi.get(self, "from_")

    @from_.setter
    def from_(self, value: pulumi.Input[str]):
        pulumi.set(self, "from_", value)

    @property
    @pulumi.getter
    def to(self) -> Optional[pulumi.Input[str]]:
        """
        The end date of recurrence.
        """
        return pulumi.get(self, "to")

    @to.setter
    def to(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "to", value)


@pulumi.input_type
class ExportScheduleArgs:
    def __init__(__self__, *,
                 recurrence: Optional[pulumi.Input[Union[str, 'RecurrenceType']]] = None,
                 recurrence_period: Optional[pulumi.Input['ExportRecurrencePeriodArgs']] = None,
                 status: Optional[pulumi.Input[Union[str, 'StatusType']]] = None):
        """
        The schedule associated with the export.
        :param pulumi.Input[Union[str, 'RecurrenceType']] recurrence: The schedule recurrence.
        :param pulumi.Input['ExportRecurrencePeriodArgs'] recurrence_period: Has start and end date of the recurrence. The start date must be in future. If present, the end date must be greater than start date.
        :param pulumi.Input[Union[str, 'StatusType']] status: The status of the export's schedule. If 'Inactive', the export's schedule is paused.
        """
        if recurrence is not None:
            pulumi.set(__self__, "recurrence", recurrence)
        if recurrence_period is not None:
            pulumi.set(__self__, "recurrence_period", recurrence_period)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def recurrence(self) -> Optional[pulumi.Input[Union[str, 'RecurrenceType']]]:
        """
        The schedule recurrence.
        """
        return pulumi.get(self, "recurrence")

    @recurrence.setter
    def recurrence(self, value: Optional[pulumi.Input[Union[str, 'RecurrenceType']]]):
        pulumi.set(self, "recurrence", value)

    @property
    @pulumi.getter(name="recurrencePeriod")
    def recurrence_period(self) -> Optional[pulumi.Input['ExportRecurrencePeriodArgs']]:
        """
        Has start and end date of the recurrence. The start date must be in future. If present, the end date must be greater than start date.
        """
        return pulumi.get(self, "recurrence_period")

    @recurrence_period.setter
    def recurrence_period(self, value: Optional[pulumi.Input['ExportRecurrencePeriodArgs']]):
        pulumi.set(self, "recurrence_period", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[Union[str, 'StatusType']]]:
        """
        The status of the export's schedule. If 'Inactive', the export's schedule is paused.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[Union[str, 'StatusType']]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class ExportTimePeriodArgs:
    def __init__(__self__, *,
                 from_: pulumi.Input[str],
                 to: pulumi.Input[str]):
        """
        The date range for data in the export. This should only be specified with timeFrame set to 'Custom'. The maximum date range is 3 months.
        :param pulumi.Input[str] from_: The start date for export data.
        :param pulumi.Input[str] to: The end date for export data.
        """
        pulumi.set(__self__, "from_", from_)
        pulumi.set(__self__, "to", to)

    @property
    @pulumi.getter(name="from")
    def from_(self) -> pulumi.Input[str]:
        """
        The start date for export data.
        """
        return pulumi.get(self, "from_")

    @from_.setter
    def from_(self, value: pulumi.Input[str]):
        pulumi.set(self, "from_", value)

    @property
    @pulumi.getter
    def to(self) -> pulumi.Input[str]:
        """
        The end date for export data.
        """
        return pulumi.get(self, "to")

    @to.setter
    def to(self, value: pulumi.Input[str]):
        pulumi.set(self, "to", value)


