# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'ReportAggregationArgs',
    'ReportComparisonExpressionArgs',
    'ReportDatasetConfigurationArgs',
    'ReportDatasetArgs',
    'ReportDefinitionArgs',
    'ReportDeliveryDestinationArgs',
    'ReportDeliveryInfoArgs',
    'ReportFilterArgs',
    'ReportGroupingArgs',
    'ReportRecurrencePeriodArgs',
    'ReportScheduleArgs',
    'ReportTimePeriodArgs',
]

@pulumi.input_type
class ReportAggregationArgs:
    def __init__(__self__, *,
                 function: pulumi.Input[Union[str, 'FunctionType']],
                 name: pulumi.Input[str]):
        """
        The aggregation expression to be used in the report.
        :param pulumi.Input[Union[str, 'FunctionType']] function: The name of the aggregation function to use.
        :param pulumi.Input[str] name: The name of the column to aggregate.
        """
        pulumi.set(__self__, "function", function)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def function(self) -> pulumi.Input[Union[str, 'FunctionType']]:
        """
        The name of the aggregation function to use.
        """
        return pulumi.get(self, "function")

    @function.setter
    def function(self, value: pulumi.Input[Union[str, 'FunctionType']]):
        pulumi.set(self, "function", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the column to aggregate.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class ReportComparisonExpressionArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 operator: pulumi.Input[Union[str, 'OperatorType']],
                 values: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        The comparison expression to be used in the report.
        :param pulumi.Input[str] name: The name of the column to use in comparison.
        :param pulumi.Input[Union[str, 'OperatorType']] operator: The operator to use for comparison.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] values: Array of values to use for comparison
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the column to use in comparison.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def operator(self) -> pulumi.Input[Union[str, 'OperatorType']]:
        """
        The operator to use for comparison.
        """
        return pulumi.get(self, "operator")

    @operator.setter
    def operator(self, value: pulumi.Input[Union[str, 'OperatorType']]):
        pulumi.set(self, "operator", value)

    @property
    @pulumi.getter
    def values(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Array of values to use for comparison
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class ReportDatasetConfigurationArgs:
    def __init__(__self__, *,
                 columns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The configuration of dataset in the report.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] columns: Array of column names to be included in the report. Any valid report column name is allowed. If not provided, then report includes all columns.
        """
        if columns is not None:
            pulumi.set(__self__, "columns", columns)

    @property
    @pulumi.getter
    def columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Array of column names to be included in the report. Any valid report column name is allowed. If not provided, then report includes all columns.
        """
        return pulumi.get(self, "columns")

    @columns.setter
    def columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "columns", value)


@pulumi.input_type
class ReportDatasetArgs:
    def __init__(__self__, *,
                 aggregation: Optional[pulumi.Input[Mapping[str, pulumi.Input['ReportAggregationArgs']]]] = None,
                 configuration: Optional[pulumi.Input['ReportDatasetConfigurationArgs']] = None,
                 filter: Optional[pulumi.Input['ReportFilterArgs']] = None,
                 granularity: Optional[pulumi.Input[Union[str, 'GranularityType']]] = None,
                 grouping: Optional[pulumi.Input[Sequence[pulumi.Input['ReportGroupingArgs']]]] = None):
        """
        The definition of data present in the report.
        :param pulumi.Input[Mapping[str, pulumi.Input['ReportAggregationArgs']]] aggregation: Dictionary of aggregation expression to use in the report. The key of each item in the dictionary is the alias for the aggregated column. Report can have up to 2 aggregation clauses.
        :param pulumi.Input['ReportDatasetConfigurationArgs'] configuration: Has configuration information for the data in the report. The configuration will be ignored if aggregation and grouping are provided.
        :param pulumi.Input['ReportFilterArgs'] filter: Has filter expression to use in the report.
        :param pulumi.Input[Union[str, 'GranularityType']] granularity: The granularity of rows in the report.
        :param pulumi.Input[Sequence[pulumi.Input['ReportGroupingArgs']]] grouping: Array of group by expression to use in the report. Report can have up to 2 group by clauses.
        """
        if aggregation is not None:
            pulumi.set(__self__, "aggregation", aggregation)
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if granularity is not None:
            pulumi.set(__self__, "granularity", granularity)
        if grouping is not None:
            pulumi.set(__self__, "grouping", grouping)

    @property
    @pulumi.getter
    def aggregation(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ReportAggregationArgs']]]]:
        """
        Dictionary of aggregation expression to use in the report. The key of each item in the dictionary is the alias for the aggregated column. Report can have up to 2 aggregation clauses.
        """
        return pulumi.get(self, "aggregation")

    @aggregation.setter
    def aggregation(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ReportAggregationArgs']]]]):
        pulumi.set(self, "aggregation", value)

    @property
    @pulumi.getter
    def configuration(self) -> Optional[pulumi.Input['ReportDatasetConfigurationArgs']]:
        """
        Has configuration information for the data in the report. The configuration will be ignored if aggregation and grouping are provided.
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: Optional[pulumi.Input['ReportDatasetConfigurationArgs']]):
        pulumi.set(self, "configuration", value)

    @property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input['ReportFilterArgs']]:
        """
        Has filter expression to use in the report.
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input['ReportFilterArgs']]):
        pulumi.set(self, "filter", value)

    @property
    @pulumi.getter
    def granularity(self) -> Optional[pulumi.Input[Union[str, 'GranularityType']]]:
        """
        The granularity of rows in the report.
        """
        return pulumi.get(self, "granularity")

    @granularity.setter
    def granularity(self, value: Optional[pulumi.Input[Union[str, 'GranularityType']]]):
        pulumi.set(self, "granularity", value)

    @property
    @pulumi.getter
    def grouping(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ReportGroupingArgs']]]]:
        """
        Array of group by expression to use in the report. Report can have up to 2 group by clauses.
        """
        return pulumi.get(self, "grouping")

    @grouping.setter
    def grouping(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ReportGroupingArgs']]]]):
        pulumi.set(self, "grouping", value)


@pulumi.input_type
class ReportDefinitionArgs:
    def __init__(__self__, *,
                 timeframe: pulumi.Input[Union[str, 'TimeframeType']],
                 type: pulumi.Input[Union[str, 'ReportType']],
                 dataset: Optional[pulumi.Input['ReportDatasetArgs']] = None,
                 time_period: Optional[pulumi.Input['ReportTimePeriodArgs']] = None):
        """
        The definition of a report.
        :param pulumi.Input[Union[str, 'TimeframeType']] timeframe: The time frame for pulling data for the report. If custom, then a specific time period must be provided.
        :param pulumi.Input[Union[str, 'ReportType']] type: The type of the report.
        :param pulumi.Input['ReportDatasetArgs'] dataset: Has definition for data in this report.
        :param pulumi.Input['ReportTimePeriodArgs'] time_period: Has time period for pulling data for the report.
        """
        pulumi.set(__self__, "timeframe", timeframe)
        pulumi.set(__self__, "type", type)
        if dataset is not None:
            pulumi.set(__self__, "dataset", dataset)
        if time_period is not None:
            pulumi.set(__self__, "time_period", time_period)

    @property
    @pulumi.getter
    def timeframe(self) -> pulumi.Input[Union[str, 'TimeframeType']]:
        """
        The time frame for pulling data for the report. If custom, then a specific time period must be provided.
        """
        return pulumi.get(self, "timeframe")

    @timeframe.setter
    def timeframe(self, value: pulumi.Input[Union[str, 'TimeframeType']]):
        pulumi.set(self, "timeframe", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[Union[str, 'ReportType']]:
        """
        The type of the report.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[Union[str, 'ReportType']]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def dataset(self) -> Optional[pulumi.Input['ReportDatasetArgs']]:
        """
        Has definition for data in this report.
        """
        return pulumi.get(self, "dataset")

    @dataset.setter
    def dataset(self, value: Optional[pulumi.Input['ReportDatasetArgs']]):
        pulumi.set(self, "dataset", value)

    @property
    @pulumi.getter(name="timePeriod")
    def time_period(self) -> Optional[pulumi.Input['ReportTimePeriodArgs']]:
        """
        Has time period for pulling data for the report.
        """
        return pulumi.get(self, "time_period")

    @time_period.setter
    def time_period(self, value: Optional[pulumi.Input['ReportTimePeriodArgs']]):
        pulumi.set(self, "time_period", value)


@pulumi.input_type
class ReportDeliveryDestinationArgs:
    def __init__(__self__, *,
                 container: pulumi.Input[str],
                 resource_id: pulumi.Input[str],
                 root_folder_path: Optional[pulumi.Input[str]] = None):
        """
        The destination information for the delivery of the report.
        :param pulumi.Input[str] container: The name of the container where reports will be uploaded.
        :param pulumi.Input[str] resource_id: The resource id of the storage account where reports will be delivered.
        :param pulumi.Input[str] root_folder_path: The name of the directory where reports will be uploaded.
        """
        pulumi.set(__self__, "container", container)
        pulumi.set(__self__, "resource_id", resource_id)
        if root_folder_path is not None:
            pulumi.set(__self__, "root_folder_path", root_folder_path)

    @property
    @pulumi.getter
    def container(self) -> pulumi.Input[str]:
        """
        The name of the container where reports will be uploaded.
        """
        return pulumi.get(self, "container")

    @container.setter
    def container(self, value: pulumi.Input[str]):
        pulumi.set(self, "container", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Input[str]:
        """
        The resource id of the storage account where reports will be delivered.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_id", value)

    @property
    @pulumi.getter(name="rootFolderPath")
    def root_folder_path(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the directory where reports will be uploaded.
        """
        return pulumi.get(self, "root_folder_path")

    @root_folder_path.setter
    def root_folder_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "root_folder_path", value)


@pulumi.input_type
class ReportDeliveryInfoArgs:
    def __init__(__self__, *,
                 destination: pulumi.Input['ReportDeliveryDestinationArgs']):
        """
        The delivery information associated with a report.
        :param pulumi.Input['ReportDeliveryDestinationArgs'] destination: Has destination for the report being delivered.
        """
        pulumi.set(__self__, "destination", destination)

    @property
    @pulumi.getter
    def destination(self) -> pulumi.Input['ReportDeliveryDestinationArgs']:
        """
        Has destination for the report being delivered.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: pulumi.Input['ReportDeliveryDestinationArgs']):
        pulumi.set(self, "destination", value)


@pulumi.input_type
class ReportFilterArgs:
    def __init__(__self__, *,
                 and_: Optional[pulumi.Input[Sequence[pulumi.Input['ReportFilterArgs']]]] = None,
                 dimension: Optional[pulumi.Input['ReportComparisonExpressionArgs']] = None,
                 not_: Optional[pulumi.Input['ReportFilterArgs']] = None,
                 or_: Optional[pulumi.Input[Sequence[pulumi.Input['ReportFilterArgs']]]] = None,
                 tag: Optional[pulumi.Input['ReportComparisonExpressionArgs']] = None):
        """
        The filter expression to be used in the report.
        :param pulumi.Input[Sequence[pulumi.Input['ReportFilterArgs']]] and_: The logical "AND" expression. Must have at least 2 items.
        :param pulumi.Input['ReportComparisonExpressionArgs'] dimension: Has comparison expression for a dimension
        :param pulumi.Input['ReportFilterArgs'] not_: The logical "NOT" expression.
        :param pulumi.Input[Sequence[pulumi.Input['ReportFilterArgs']]] or_: The logical "OR" expression. Must have at least 2 items.
        :param pulumi.Input['ReportComparisonExpressionArgs'] tag: Has comparison expression for a tag
        """
        if and_ is not None:
            pulumi.set(__self__, "and_", and_)
        if dimension is not None:
            pulumi.set(__self__, "dimension", dimension)
        if not_ is not None:
            pulumi.set(__self__, "not_", not_)
        if or_ is not None:
            pulumi.set(__self__, "or_", or_)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)

    @property
    @pulumi.getter(name="and")
    def and_(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ReportFilterArgs']]]]:
        """
        The logical "AND" expression. Must have at least 2 items.
        """
        return pulumi.get(self, "and_")

    @and_.setter
    def and_(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ReportFilterArgs']]]]):
        pulumi.set(self, "and_", value)

    @property
    @pulumi.getter
    def dimension(self) -> Optional[pulumi.Input['ReportComparisonExpressionArgs']]:
        """
        Has comparison expression for a dimension
        """
        return pulumi.get(self, "dimension")

    @dimension.setter
    def dimension(self, value: Optional[pulumi.Input['ReportComparisonExpressionArgs']]):
        pulumi.set(self, "dimension", value)

    @property
    @pulumi.getter(name="not")
    def not_(self) -> Optional[pulumi.Input['ReportFilterArgs']]:
        """
        The logical "NOT" expression.
        """
        return pulumi.get(self, "not_")

    @not_.setter
    def not_(self, value: Optional[pulumi.Input['ReportFilterArgs']]):
        pulumi.set(self, "not_", value)

    @property
    @pulumi.getter(name="or")
    def or_(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ReportFilterArgs']]]]:
        """
        The logical "OR" expression. Must have at least 2 items.
        """
        return pulumi.get(self, "or_")

    @or_.setter
    def or_(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ReportFilterArgs']]]]):
        pulumi.set(self, "or_", value)

    @property
    @pulumi.getter
    def tag(self) -> Optional[pulumi.Input['ReportComparisonExpressionArgs']]:
        """
        Has comparison expression for a tag
        """
        return pulumi.get(self, "tag")

    @tag.setter
    def tag(self, value: Optional[pulumi.Input['ReportComparisonExpressionArgs']]):
        pulumi.set(self, "tag", value)


@pulumi.input_type
class ReportGroupingArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 type: pulumi.Input[Union[str, 'ReportColumnType']]):
        """
        The group by expression to be used in the report.
        :param pulumi.Input[str] name: The name of the column to group.
        :param pulumi.Input[Union[str, 'ReportColumnType']] type: Has type of the column to group.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the column to group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[Union[str, 'ReportColumnType']]:
        """
        Has type of the column to group.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[Union[str, 'ReportColumnType']]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class ReportRecurrencePeriodArgs:
    def __init__(__self__, *,
                 from_: pulumi.Input[str],
                 to: Optional[pulumi.Input[str]] = None):
        """
        The start and end date for recurrence schedule.
        :param pulumi.Input[str] from_: The start date of recurrence.
        :param pulumi.Input[str] to: The end date of recurrence.
        """
        pulumi.set(__self__, "from_", from_)
        if to is not None:
            pulumi.set(__self__, "to", to)

    @property
    @pulumi.getter(name="from")
    def from_(self) -> pulumi.Input[str]:
        """
        The start date of recurrence.
        """
        return pulumi.get(self, "from_")

    @from_.setter
    def from_(self, value: pulumi.Input[str]):
        pulumi.set(self, "from_", value)

    @property
    @pulumi.getter
    def to(self) -> Optional[pulumi.Input[str]]:
        """
        The end date of recurrence.
        """
        return pulumi.get(self, "to")

    @to.setter
    def to(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "to", value)


@pulumi.input_type
class ReportScheduleArgs:
    def __init__(__self__, *,
                 recurrence: pulumi.Input[Union[str, 'RecurrenceType']],
                 recurrence_period: Optional[pulumi.Input['ReportRecurrencePeriodArgs']] = None,
                 status: Optional[pulumi.Input[Union[str, 'StatusType']]] = None):
        """
        The schedule associated with a report.
        :param pulumi.Input[Union[str, 'RecurrenceType']] recurrence: The schedule recurrence.
        :param pulumi.Input['ReportRecurrencePeriodArgs'] recurrence_period: Has start and end date of the recurrence. The start date must be in future. If present, the end date must be greater than start date.
        :param pulumi.Input[Union[str, 'StatusType']] status: The status of the schedule. Whether active or not. If inactive, the report's scheduled execution is paused.
        """
        pulumi.set(__self__, "recurrence", recurrence)
        if recurrence_period is not None:
            pulumi.set(__self__, "recurrence_period", recurrence_period)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def recurrence(self) -> pulumi.Input[Union[str, 'RecurrenceType']]:
        """
        The schedule recurrence.
        """
        return pulumi.get(self, "recurrence")

    @recurrence.setter
    def recurrence(self, value: pulumi.Input[Union[str, 'RecurrenceType']]):
        pulumi.set(self, "recurrence", value)

    @property
    @pulumi.getter(name="recurrencePeriod")
    def recurrence_period(self) -> Optional[pulumi.Input['ReportRecurrencePeriodArgs']]:
        """
        Has start and end date of the recurrence. The start date must be in future. If present, the end date must be greater than start date.
        """
        return pulumi.get(self, "recurrence_period")

    @recurrence_period.setter
    def recurrence_period(self, value: Optional[pulumi.Input['ReportRecurrencePeriodArgs']]):
        pulumi.set(self, "recurrence_period", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[Union[str, 'StatusType']]]:
        """
        The status of the schedule. Whether active or not. If inactive, the report's scheduled execution is paused.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[Union[str, 'StatusType']]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class ReportTimePeriodArgs:
    def __init__(__self__, *,
                 from_: pulumi.Input[str],
                 to: pulumi.Input[str]):
        """
        The start and end date for pulling data for the report.
        :param pulumi.Input[str] from_: The start date to pull data from.
        :param pulumi.Input[str] to: The end date to pull data to.
        """
        pulumi.set(__self__, "from_", from_)
        pulumi.set(__self__, "to", to)

    @property
    @pulumi.getter(name="from")
    def from_(self) -> pulumi.Input[str]:
        """
        The start date to pull data from.
        """
        return pulumi.get(self, "from_")

    @from_.setter
    def from_(self, value: pulumi.Input[str]):
        pulumi.set(self, "from_", value)

    @property
    @pulumi.getter
    def to(self) -> pulumi.Input[str]:
        """
        The end date to pull data to.
        """
        return pulumi.get(self, "to")

    @to.setter
    def to(self, value: pulumi.Input[str]):
        pulumi.set(self, "to", value)


