# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AdditionalUnattendContentResponse',
    'ApiEntityReferenceResponse',
    'ApiErrorBaseResponse',
    'ApiErrorResponse',
    'AutoOSUpgradePolicyResponse',
    'BootDiagnosticsInstanceViewResponse',
    'BootDiagnosticsResponse',
    'DataDiskResponse',
    'DiagnosticsProfileResponse',
    'DiskEncryptionSettingsResponse',
    'DiskInstanceViewResponse',
    'HardwareProfileResponse',
    'ImageDataDiskResponse',
    'ImageOSDiskResponse',
    'ImageReferenceResponse',
    'ImageStorageProfileResponse',
    'InnerErrorResponse',
    'InstanceViewStatusResponse',
    'KeyVaultKeyReferenceResponse',
    'KeyVaultSecretReferenceResponse',
    'LinuxConfigurationResponse',
    'LogAnalyticsOutputResponse',
    'MaintenanceRedeployStatusResponse',
    'ManagedDiskParametersResponse',
    'NetworkInterfaceReferenceResponse',
    'NetworkProfileResponse',
    'OSDiskResponse',
    'OSProfileResponse',
    'PlanResponse',
    'RollingUpgradePolicyResponse',
    'SkuResponse',
    'SshConfigurationResponse',
    'SshPublicKeyResponse',
    'StorageProfileResponse',
    'SubResourceResponse',
    'UpgradePolicyResponse',
    'VaultCertificateResponse',
    'VaultSecretGroupResponse',
    'VirtualHardDiskResponse',
    'VirtualMachineAgentInstanceViewResponse',
    'VirtualMachineExtensionHandlerInstanceViewResponse',
    'VirtualMachineExtensionInstanceViewResponse',
    'VirtualMachineExtensionResponse',
    'VirtualMachineHealthStatusResponse',
    'VirtualMachineIdentityResponse',
    'VirtualMachineInstanceViewResponse',
    'VirtualMachineScaleSetDataDiskResponse',
    'VirtualMachineScaleSetExtensionProfileResponse',
    'VirtualMachineScaleSetExtensionResponse',
    'VirtualMachineScaleSetIPConfigurationResponse',
    'VirtualMachineScaleSetIdentityResponse',
    'VirtualMachineScaleSetManagedDiskParametersResponse',
    'VirtualMachineScaleSetNetworkConfigurationDnsSettingsResponse',
    'VirtualMachineScaleSetNetworkConfigurationResponse',
    'VirtualMachineScaleSetNetworkProfileResponse',
    'VirtualMachineScaleSetOSDiskResponse',
    'VirtualMachineScaleSetOSProfileResponse',
    'VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettingsResponse',
    'VirtualMachineScaleSetPublicIPAddressConfigurationResponse',
    'VirtualMachineScaleSetStorageProfileResponse',
    'VirtualMachineScaleSetVMInstanceViewResponse',
    'VirtualMachineScaleSetVMProfileResponse',
    'WinRMConfigurationResponse',
    'WinRMListenerResponse',
    'WindowsConfigurationResponse',
]

@pulumi.output_type
class AdditionalUnattendContentResponse(dict):
    """
    Specifies additional XML formatted information that can be included in the Unattend.xml file, which is used by Windows Setup. Contents are defined by setting name, component name, and the pass in which the content is applied.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "componentName":
            suggest = "component_name"
        elif key == "passName":
            suggest = "pass_name"
        elif key == "settingName":
            suggest = "setting_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AdditionalUnattendContentResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AdditionalUnattendContentResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AdditionalUnattendContentResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 component_name: Optional[str] = None,
                 content: Optional[str] = None,
                 pass_name: Optional[str] = None,
                 setting_name: Optional[str] = None):
        """
        Specifies additional XML formatted information that can be included in the Unattend.xml file, which is used by Windows Setup. Contents are defined by setting name, component name, and the pass in which the content is applied.
        :param str component_name: The component name. Currently, the only allowable value is Microsoft-Windows-Shell-Setup.
        :param str content: Specifies the XML formatted content that is added to the unattend.xml file for the specified path and component. The XML must be less than 4KB and must include the root element for the setting or feature that is being inserted.
        :param str pass_name: The pass name. Currently, the only allowable value is OobeSystem.
        :param str setting_name: Specifies the name of the setting to which the content applies. Possible values are: FirstLogonCommands and AutoLogon.
        """
        if component_name is not None:
            pulumi.set(__self__, "component_name", component_name)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if pass_name is not None:
            pulumi.set(__self__, "pass_name", pass_name)
        if setting_name is not None:
            pulumi.set(__self__, "setting_name", setting_name)

    @property
    @pulumi.getter(name="componentName")
    def component_name(self) -> Optional[str]:
        """
        The component name. Currently, the only allowable value is Microsoft-Windows-Shell-Setup.
        """
        return pulumi.get(self, "component_name")

    @property
    @pulumi.getter
    def content(self) -> Optional[str]:
        """
        Specifies the XML formatted content that is added to the unattend.xml file for the specified path and component. The XML must be less than 4KB and must include the root element for the setting or feature that is being inserted.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="passName")
    def pass_name(self) -> Optional[str]:
        """
        The pass name. Currently, the only allowable value is OobeSystem.
        """
        return pulumi.get(self, "pass_name")

    @property
    @pulumi.getter(name="settingName")
    def setting_name(self) -> Optional[str]:
        """
        Specifies the name of the setting to which the content applies. Possible values are: FirstLogonCommands and AutoLogon.
        """
        return pulumi.get(self, "setting_name")


@pulumi.output_type
class ApiEntityReferenceResponse(dict):
    """
    The API entity reference.
    """
    def __init__(__self__, *,
                 id: Optional[str] = None):
        """
        The API entity reference.
        :param str id: The ARM resource id in the form of /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/...
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The ARM resource id in the form of /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/...
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class ApiErrorBaseResponse(dict):
    """
    Api error base.
    """
    def __init__(__self__, *,
                 code: Optional[str] = None,
                 message: Optional[str] = None,
                 target: Optional[str] = None):
        """
        Api error base.
        :param str code: The error code.
        :param str message: The error message.
        :param str target: The target of the particular error.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter
    def code(self) -> Optional[str]:
        """
        The error code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        The error message.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def target(self) -> Optional[str]:
        """
        The target of the particular error.
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class ApiErrorResponse(dict):
    """
    Api error.
    """
    def __init__(__self__, *,
                 code: Optional[str] = None,
                 details: Optional[Sequence['outputs.ApiErrorBaseResponse']] = None,
                 innererror: Optional['outputs.InnerErrorResponse'] = None,
                 message: Optional[str] = None,
                 target: Optional[str] = None):
        """
        Api error.
        :param str code: The error code.
        :param Sequence['ApiErrorBaseResponse'] details: The Api error details
        :param 'InnerErrorResponse' innererror: The Api inner error
        :param str message: The error message.
        :param str target: The target of the particular error.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if details is not None:
            pulumi.set(__self__, "details", details)
        if innererror is not None:
            pulumi.set(__self__, "innererror", innererror)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter
    def code(self) -> Optional[str]:
        """
        The error code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def details(self) -> Optional[Sequence['outputs.ApiErrorBaseResponse']]:
        """
        The Api error details
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def innererror(self) -> Optional['outputs.InnerErrorResponse']:
        """
        The Api inner error
        """
        return pulumi.get(self, "innererror")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        The error message.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def target(self) -> Optional[str]:
        """
        The target of the particular error.
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class AutoOSUpgradePolicyResponse(dict):
    """
    The configuration parameters used for performing automatic OS upgrade.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "disableAutoRollback":
            suggest = "disable_auto_rollback"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoOSUpgradePolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoOSUpgradePolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoOSUpgradePolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disable_auto_rollback: Optional[bool] = None):
        """
        The configuration parameters used for performing automatic OS upgrade.
        :param bool disable_auto_rollback: Whether OS image rollback feature should be disabled. Default value is false.
        """
        if disable_auto_rollback is not None:
            pulumi.set(__self__, "disable_auto_rollback", disable_auto_rollback)

    @property
    @pulumi.getter(name="disableAutoRollback")
    def disable_auto_rollback(self) -> Optional[bool]:
        """
        Whether OS image rollback feature should be disabled. Default value is false.
        """
        return pulumi.get(self, "disable_auto_rollback")


@pulumi.output_type
class BootDiagnosticsInstanceViewResponse(dict):
    """
    The instance view of a virtual machine boot diagnostics.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "consoleScreenshotBlobUri":
            suggest = "console_screenshot_blob_uri"
        elif key == "serialConsoleLogBlobUri":
            suggest = "serial_console_log_blob_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BootDiagnosticsInstanceViewResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BootDiagnosticsInstanceViewResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BootDiagnosticsInstanceViewResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 console_screenshot_blob_uri: str,
                 serial_console_log_blob_uri: str):
        """
        The instance view of a virtual machine boot diagnostics.
        :param str console_screenshot_blob_uri: The console screenshot blob URI.
        :param str serial_console_log_blob_uri: The Linux serial console log blob Uri.
        """
        pulumi.set(__self__, "console_screenshot_blob_uri", console_screenshot_blob_uri)
        pulumi.set(__self__, "serial_console_log_blob_uri", serial_console_log_blob_uri)

    @property
    @pulumi.getter(name="consoleScreenshotBlobUri")
    def console_screenshot_blob_uri(self) -> str:
        """
        The console screenshot blob URI.
        """
        return pulumi.get(self, "console_screenshot_blob_uri")

    @property
    @pulumi.getter(name="serialConsoleLogBlobUri")
    def serial_console_log_blob_uri(self) -> str:
        """
        The Linux serial console log blob Uri.
        """
        return pulumi.get(self, "serial_console_log_blob_uri")


@pulumi.output_type
class BootDiagnosticsResponse(dict):
    """
    Boot Diagnostics is a debugging feature which allows you to view Console Output and Screenshot to diagnose VM status. <br><br> You can easily view the output of your console log. <br><br> Azure also enables you to see a screenshot of the VM from the hypervisor.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageUri":
            suggest = "storage_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BootDiagnosticsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BootDiagnosticsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BootDiagnosticsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[bool] = None,
                 storage_uri: Optional[str] = None):
        """
        Boot Diagnostics is a debugging feature which allows you to view Console Output and Screenshot to diagnose VM status. <br><br> You can easily view the output of your console log. <br><br> Azure also enables you to see a screenshot of the VM from the hypervisor.
        :param bool enabled: Whether boot diagnostics should be enabled on the Virtual Machine.
        :param str storage_uri: Uri of the storage account to use for placing the console output and screenshot.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if storage_uri is not None:
            pulumi.set(__self__, "storage_uri", storage_uri)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Whether boot diagnostics should be enabled on the Virtual Machine.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="storageUri")
    def storage_uri(self) -> Optional[str]:
        """
        Uri of the storage account to use for placing the console output and screenshot.
        """
        return pulumi.get(self, "storage_uri")


@pulumi.output_type
class DataDiskResponse(dict):
    """
    Describes a data disk.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createOption":
            suggest = "create_option"
        elif key == "diskSizeGB":
            suggest = "disk_size_gb"
        elif key == "managedDisk":
            suggest = "managed_disk"
        elif key == "writeAcceleratorEnabled":
            suggest = "write_accelerator_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataDiskResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataDiskResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataDiskResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 create_option: str,
                 lun: int,
                 caching: Optional[str] = None,
                 disk_size_gb: Optional[int] = None,
                 image: Optional['outputs.VirtualHardDiskResponse'] = None,
                 managed_disk: Optional['outputs.ManagedDiskParametersResponse'] = None,
                 name: Optional[str] = None,
                 vhd: Optional['outputs.VirtualHardDiskResponse'] = None,
                 write_accelerator_enabled: Optional[bool] = None):
        """
        Describes a data disk.
        :param str create_option: Specifies how the virtual machine should be created.<br><br> Possible values are:<br><br> **Attach** \u2013 This value is used when you are using a specialized disk to create the virtual machine.<br><br> **FromImage** \u2013 This value is used when you are using an image to create the virtual machine. If you are using a platform image, you also use the imageReference element described above. If you are using a marketplace image, you  also use the plan element previously described.
        :param int lun: Specifies the logical unit number of the data disk. This value is used to identify data disks within the VM and therefore must be unique for each data disk attached to a VM.
        :param str caching: Specifies the caching requirements. <br><br> Possible values are: <br><br> **None** <br><br> **ReadOnly** <br><br> **ReadWrite** <br><br> Default: **None for Standard storage. ReadOnly for Premium storage**
        :param int disk_size_gb: Specifies the size of an empty data disk in gigabytes. This element can be used to overwrite the size of the disk in a virtual machine image. <br><br> This value cannot be larger than 1023 GB
        :param 'VirtualHardDiskResponse' image: The source user image virtual hard disk. The virtual hard disk will be copied before being attached to the virtual machine. If SourceImage is provided, the destination virtual hard drive must not exist.
        :param 'ManagedDiskParametersResponse' managed_disk: The managed disk parameters.
        :param str name: The disk name.
        :param 'VirtualHardDiskResponse' vhd: The virtual hard disk.
        :param bool write_accelerator_enabled: Specifies whether writeAccelerator should be enabled or disabled on the disk.
        """
        pulumi.set(__self__, "create_option", create_option)
        pulumi.set(__self__, "lun", lun)
        if caching is not None:
            pulumi.set(__self__, "caching", caching)
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if managed_disk is not None:
            pulumi.set(__self__, "managed_disk", managed_disk)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if vhd is not None:
            pulumi.set(__self__, "vhd", vhd)
        if write_accelerator_enabled is not None:
            pulumi.set(__self__, "write_accelerator_enabled", write_accelerator_enabled)

    @property
    @pulumi.getter(name="createOption")
    def create_option(self) -> str:
        """
        Specifies how the virtual machine should be created.<br><br> Possible values are:<br><br> **Attach** \u2013 This value is used when you are using a specialized disk to create the virtual machine.<br><br> **FromImage** \u2013 This value is used when you are using an image to create the virtual machine. If you are using a platform image, you also use the imageReference element described above. If you are using a marketplace image, you  also use the plan element previously described.
        """
        return pulumi.get(self, "create_option")

    @property
    @pulumi.getter
    def lun(self) -> int:
        """
        Specifies the logical unit number of the data disk. This value is used to identify data disks within the VM and therefore must be unique for each data disk attached to a VM.
        """
        return pulumi.get(self, "lun")

    @property
    @pulumi.getter
    def caching(self) -> Optional[str]:
        """
        Specifies the caching requirements. <br><br> Possible values are: <br><br> **None** <br><br> **ReadOnly** <br><br> **ReadWrite** <br><br> Default: **None for Standard storage. ReadOnly for Premium storage**
        """
        return pulumi.get(self, "caching")

    @property
    @pulumi.getter(name="diskSizeGB")
    def disk_size_gb(self) -> Optional[int]:
        """
        Specifies the size of an empty data disk in gigabytes. This element can be used to overwrite the size of the disk in a virtual machine image. <br><br> This value cannot be larger than 1023 GB
        """
        return pulumi.get(self, "disk_size_gb")

    @property
    @pulumi.getter
    def image(self) -> Optional['outputs.VirtualHardDiskResponse']:
        """
        The source user image virtual hard disk. The virtual hard disk will be copied before being attached to the virtual machine. If SourceImage is provided, the destination virtual hard drive must not exist.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="managedDisk")
    def managed_disk(self) -> Optional['outputs.ManagedDiskParametersResponse']:
        """
        The managed disk parameters.
        """
        return pulumi.get(self, "managed_disk")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The disk name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def vhd(self) -> Optional['outputs.VirtualHardDiskResponse']:
        """
        The virtual hard disk.
        """
        return pulumi.get(self, "vhd")

    @property
    @pulumi.getter(name="writeAcceleratorEnabled")
    def write_accelerator_enabled(self) -> Optional[bool]:
        """
        Specifies whether writeAccelerator should be enabled or disabled on the disk.
        """
        return pulumi.get(self, "write_accelerator_enabled")


@pulumi.output_type
class DiagnosticsProfileResponse(dict):
    """
    Specifies the boot diagnostic settings state. <br><br>Minimum api-version: 2015-06-15.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bootDiagnostics":
            suggest = "boot_diagnostics"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DiagnosticsProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DiagnosticsProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DiagnosticsProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 boot_diagnostics: Optional['outputs.BootDiagnosticsResponse'] = None):
        """
        Specifies the boot diagnostic settings state. <br><br>Minimum api-version: 2015-06-15.
        :param 'BootDiagnosticsResponse' boot_diagnostics: Boot Diagnostics is a debugging feature which allows you to view Console Output and Screenshot to diagnose VM status. <br><br> You can easily view the output of your console log. <br><br> Azure also enables you to see a screenshot of the VM from the hypervisor.
        """
        if boot_diagnostics is not None:
            pulumi.set(__self__, "boot_diagnostics", boot_diagnostics)

    @property
    @pulumi.getter(name="bootDiagnostics")
    def boot_diagnostics(self) -> Optional['outputs.BootDiagnosticsResponse']:
        """
        Boot Diagnostics is a debugging feature which allows you to view Console Output and Screenshot to diagnose VM status. <br><br> You can easily view the output of your console log. <br><br> Azure also enables you to see a screenshot of the VM from the hypervisor.
        """
        return pulumi.get(self, "boot_diagnostics")


@pulumi.output_type
class DiskEncryptionSettingsResponse(dict):
    """
    Describes a Encryption Settings for a Disk
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskEncryptionKey":
            suggest = "disk_encryption_key"
        elif key == "keyEncryptionKey":
            suggest = "key_encryption_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DiskEncryptionSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DiskEncryptionSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DiskEncryptionSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_encryption_key: Optional['outputs.KeyVaultSecretReferenceResponse'] = None,
                 enabled: Optional[bool] = None,
                 key_encryption_key: Optional['outputs.KeyVaultKeyReferenceResponse'] = None):
        """
        Describes a Encryption Settings for a Disk
        :param 'KeyVaultSecretReferenceResponse' disk_encryption_key: Specifies the location of the disk encryption key, which is a Key Vault Secret.
        :param bool enabled: Specifies whether disk encryption should be enabled on the virtual machine.
        :param 'KeyVaultKeyReferenceResponse' key_encryption_key: Specifies the location of the key encryption key in Key Vault.
        """
        if disk_encryption_key is not None:
            pulumi.set(__self__, "disk_encryption_key", disk_encryption_key)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if key_encryption_key is not None:
            pulumi.set(__self__, "key_encryption_key", key_encryption_key)

    @property
    @pulumi.getter(name="diskEncryptionKey")
    def disk_encryption_key(self) -> Optional['outputs.KeyVaultSecretReferenceResponse']:
        """
        Specifies the location of the disk encryption key, which is a Key Vault Secret.
        """
        return pulumi.get(self, "disk_encryption_key")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Specifies whether disk encryption should be enabled on the virtual machine.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="keyEncryptionKey")
    def key_encryption_key(self) -> Optional['outputs.KeyVaultKeyReferenceResponse']:
        """
        Specifies the location of the key encryption key in Key Vault.
        """
        return pulumi.get(self, "key_encryption_key")


@pulumi.output_type
class DiskInstanceViewResponse(dict):
    """
    The instance view of the disk.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encryptionSettings":
            suggest = "encryption_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DiskInstanceViewResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DiskInstanceViewResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DiskInstanceViewResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 encryption_settings: Optional[Sequence['outputs.DiskEncryptionSettingsResponse']] = None,
                 name: Optional[str] = None,
                 statuses: Optional[Sequence['outputs.InstanceViewStatusResponse']] = None):
        """
        The instance view of the disk.
        :param Sequence['DiskEncryptionSettingsResponse'] encryption_settings: Specifies the encryption settings for the OS Disk. <br><br> Minimum api-version: 2015-06-15
        :param str name: The disk name.
        :param Sequence['InstanceViewStatusResponse'] statuses: The resource status information.
        """
        if encryption_settings is not None:
            pulumi.set(__self__, "encryption_settings", encryption_settings)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if statuses is not None:
            pulumi.set(__self__, "statuses", statuses)

    @property
    @pulumi.getter(name="encryptionSettings")
    def encryption_settings(self) -> Optional[Sequence['outputs.DiskEncryptionSettingsResponse']]:
        """
        Specifies the encryption settings for the OS Disk. <br><br> Minimum api-version: 2015-06-15
        """
        return pulumi.get(self, "encryption_settings")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The disk name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def statuses(self) -> Optional[Sequence['outputs.InstanceViewStatusResponse']]:
        """
        The resource status information.
        """
        return pulumi.get(self, "statuses")


@pulumi.output_type
class HardwareProfileResponse(dict):
    """
    Specifies the hardware settings for the virtual machine.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "vmSize":
            suggest = "vm_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HardwareProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HardwareProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HardwareProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 vm_size: Optional[str] = None):
        """
        Specifies the hardware settings for the virtual machine.
        :param str vm_size: Specifies the size of the virtual machine. For more information about virtual machine sizes, see [Sizes for virtual machines](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-sizes?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json). <br><br> The available VM sizes depend on region and availability set. For a list of available sizes use these APIs:  <br><br> [List all available virtual machine sizes in an availability set](https://docs.microsoft.com/rest/api/compute/availabilitysets/listavailablesizes) <br><br> [List all available virtual machine sizes in a region](https://docs.microsoft.com/rest/api/compute/virtualmachinesizes/list) <br><br> [List all available virtual machine sizes for resizing](https://docs.microsoft.com/rest/api/compute/virtualmachines/listavailablesizes)
        """
        if vm_size is not None:
            pulumi.set(__self__, "vm_size", vm_size)

    @property
    @pulumi.getter(name="vmSize")
    def vm_size(self) -> Optional[str]:
        """
        Specifies the size of the virtual machine. For more information about virtual machine sizes, see [Sizes for virtual machines](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-sizes?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json). <br><br> The available VM sizes depend on region and availability set. For a list of available sizes use these APIs:  <br><br> [List all available virtual machine sizes in an availability set](https://docs.microsoft.com/rest/api/compute/availabilitysets/listavailablesizes) <br><br> [List all available virtual machine sizes in a region](https://docs.microsoft.com/rest/api/compute/virtualmachinesizes/list) <br><br> [List all available virtual machine sizes for resizing](https://docs.microsoft.com/rest/api/compute/virtualmachines/listavailablesizes)
        """
        return pulumi.get(self, "vm_size")


@pulumi.output_type
class ImageDataDiskResponse(dict):
    """
    Describes a data disk.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "blobUri":
            suggest = "blob_uri"
        elif key == "diskSizeGB":
            suggest = "disk_size_gb"
        elif key == "managedDisk":
            suggest = "managed_disk"
        elif key == "storageAccountType":
            suggest = "storage_account_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageDataDiskResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageDataDiskResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageDataDiskResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 lun: int,
                 blob_uri: Optional[str] = None,
                 caching: Optional[str] = None,
                 disk_size_gb: Optional[int] = None,
                 managed_disk: Optional['outputs.SubResourceResponse'] = None,
                 snapshot: Optional['outputs.SubResourceResponse'] = None,
                 storage_account_type: Optional[str] = None):
        """
        Describes a data disk.
        :param int lun: Specifies the logical unit number of the data disk. This value is used to identify data disks within the VM and therefore must be unique for each data disk attached to a VM.
        :param str blob_uri: The Virtual Hard Disk.
        :param str caching: Specifies the caching requirements. <br><br> Possible values are: <br><br> **None** <br><br> **ReadOnly** <br><br> **ReadWrite** <br><br> Default: **None for Standard storage. ReadOnly for Premium storage**
        :param int disk_size_gb: Specifies the size of empty data disks in gigabytes. This element can be used to overwrite the name of the disk in a virtual machine image. <br><br> This value cannot be larger than 1023 GB
        :param 'SubResourceResponse' managed_disk: The managedDisk.
        :param 'SubResourceResponse' snapshot: The snapshot.
        :param str storage_account_type: Specifies the storage account type for the managed disk. Possible values are: Standard_LRS or Premium_LRS.
        """
        pulumi.set(__self__, "lun", lun)
        if blob_uri is not None:
            pulumi.set(__self__, "blob_uri", blob_uri)
        if caching is not None:
            pulumi.set(__self__, "caching", caching)
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if managed_disk is not None:
            pulumi.set(__self__, "managed_disk", managed_disk)
        if snapshot is not None:
            pulumi.set(__self__, "snapshot", snapshot)
        if storage_account_type is not None:
            pulumi.set(__self__, "storage_account_type", storage_account_type)

    @property
    @pulumi.getter
    def lun(self) -> int:
        """
        Specifies the logical unit number of the data disk. This value is used to identify data disks within the VM and therefore must be unique for each data disk attached to a VM.
        """
        return pulumi.get(self, "lun")

    @property
    @pulumi.getter(name="blobUri")
    def blob_uri(self) -> Optional[str]:
        """
        The Virtual Hard Disk.
        """
        return pulumi.get(self, "blob_uri")

    @property
    @pulumi.getter
    def caching(self) -> Optional[str]:
        """
        Specifies the caching requirements. <br><br> Possible values are: <br><br> **None** <br><br> **ReadOnly** <br><br> **ReadWrite** <br><br> Default: **None for Standard storage. ReadOnly for Premium storage**
        """
        return pulumi.get(self, "caching")

    @property
    @pulumi.getter(name="diskSizeGB")
    def disk_size_gb(self) -> Optional[int]:
        """
        Specifies the size of empty data disks in gigabytes. This element can be used to overwrite the name of the disk in a virtual machine image. <br><br> This value cannot be larger than 1023 GB
        """
        return pulumi.get(self, "disk_size_gb")

    @property
    @pulumi.getter(name="managedDisk")
    def managed_disk(self) -> Optional['outputs.SubResourceResponse']:
        """
        The managedDisk.
        """
        return pulumi.get(self, "managed_disk")

    @property
    @pulumi.getter
    def snapshot(self) -> Optional['outputs.SubResourceResponse']:
        """
        The snapshot.
        """
        return pulumi.get(self, "snapshot")

    @property
    @pulumi.getter(name="storageAccountType")
    def storage_account_type(self) -> Optional[str]:
        """
        Specifies the storage account type for the managed disk. Possible values are: Standard_LRS or Premium_LRS.
        """
        return pulumi.get(self, "storage_account_type")


@pulumi.output_type
class ImageOSDiskResponse(dict):
    """
    Describes an Operating System disk.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "osState":
            suggest = "os_state"
        elif key == "osType":
            suggest = "os_type"
        elif key == "blobUri":
            suggest = "blob_uri"
        elif key == "diskSizeGB":
            suggest = "disk_size_gb"
        elif key == "managedDisk":
            suggest = "managed_disk"
        elif key == "storageAccountType":
            suggest = "storage_account_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageOSDiskResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageOSDiskResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageOSDiskResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 os_state: str,
                 os_type: str,
                 blob_uri: Optional[str] = None,
                 caching: Optional[str] = None,
                 disk_size_gb: Optional[int] = None,
                 managed_disk: Optional['outputs.SubResourceResponse'] = None,
                 snapshot: Optional['outputs.SubResourceResponse'] = None,
                 storage_account_type: Optional[str] = None):
        """
        Describes an Operating System disk.
        :param str os_state: The OS State.
        :param str os_type: This property allows you to specify the type of the OS that is included in the disk if creating a VM from a custom image. <br><br> Possible values are: <br><br> **Windows** <br><br> **Linux**
        :param str blob_uri: The Virtual Hard Disk.
        :param str caching: Specifies the caching requirements. <br><br> Possible values are: <br><br> **None** <br><br> **ReadOnly** <br><br> **ReadWrite** <br><br> Default: **None for Standard storage. ReadOnly for Premium storage**
        :param int disk_size_gb: Specifies the size of empty data disks in gigabytes. This element can be used to overwrite the name of the disk in a virtual machine image. <br><br> This value cannot be larger than 1023 GB
        :param 'SubResourceResponse' managed_disk: The managedDisk.
        :param 'SubResourceResponse' snapshot: The snapshot.
        :param str storage_account_type: Specifies the storage account type for the managed disk. Possible values are: Standard_LRS or Premium_LRS.
        """
        pulumi.set(__self__, "os_state", os_state)
        pulumi.set(__self__, "os_type", os_type)
        if blob_uri is not None:
            pulumi.set(__self__, "blob_uri", blob_uri)
        if caching is not None:
            pulumi.set(__self__, "caching", caching)
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if managed_disk is not None:
            pulumi.set(__self__, "managed_disk", managed_disk)
        if snapshot is not None:
            pulumi.set(__self__, "snapshot", snapshot)
        if storage_account_type is not None:
            pulumi.set(__self__, "storage_account_type", storage_account_type)

    @property
    @pulumi.getter(name="osState")
    def os_state(self) -> str:
        """
        The OS State.
        """
        return pulumi.get(self, "os_state")

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> str:
        """
        This property allows you to specify the type of the OS that is included in the disk if creating a VM from a custom image. <br><br> Possible values are: <br><br> **Windows** <br><br> **Linux**
        """
        return pulumi.get(self, "os_type")

    @property
    @pulumi.getter(name="blobUri")
    def blob_uri(self) -> Optional[str]:
        """
        The Virtual Hard Disk.
        """
        return pulumi.get(self, "blob_uri")

    @property
    @pulumi.getter
    def caching(self) -> Optional[str]:
        """
        Specifies the caching requirements. <br><br> Possible values are: <br><br> **None** <br><br> **ReadOnly** <br><br> **ReadWrite** <br><br> Default: **None for Standard storage. ReadOnly for Premium storage**
        """
        return pulumi.get(self, "caching")

    @property
    @pulumi.getter(name="diskSizeGB")
    def disk_size_gb(self) -> Optional[int]:
        """
        Specifies the size of empty data disks in gigabytes. This element can be used to overwrite the name of the disk in a virtual machine image. <br><br> This value cannot be larger than 1023 GB
        """
        return pulumi.get(self, "disk_size_gb")

    @property
    @pulumi.getter(name="managedDisk")
    def managed_disk(self) -> Optional['outputs.SubResourceResponse']:
        """
        The managedDisk.
        """
        return pulumi.get(self, "managed_disk")

    @property
    @pulumi.getter
    def snapshot(self) -> Optional['outputs.SubResourceResponse']:
        """
        The snapshot.
        """
        return pulumi.get(self, "snapshot")

    @property
    @pulumi.getter(name="storageAccountType")
    def storage_account_type(self) -> Optional[str]:
        """
        Specifies the storage account type for the managed disk. Possible values are: Standard_LRS or Premium_LRS.
        """
        return pulumi.get(self, "storage_account_type")


@pulumi.output_type
class ImageReferenceResponse(dict):
    """
    Specifies information about the image to use. You can specify information about platform images, marketplace images, or virtual machine images. This element is required when you want to use a platform image, marketplace image, or virtual machine image, but is not used in other creation operations. NOTE: Image reference publisher and offer can only be set when you create the scale set.
    """
    def __init__(__self__, *,
                 id: Optional[str] = None,
                 offer: Optional[str] = None,
                 publisher: Optional[str] = None,
                 sku: Optional[str] = None,
                 version: Optional[str] = None):
        """
        Specifies information about the image to use. You can specify information about platform images, marketplace images, or virtual machine images. This element is required when you want to use a platform image, marketplace image, or virtual machine image, but is not used in other creation operations. NOTE: Image reference publisher and offer can only be set when you create the scale set.
        :param str id: Resource Id
        :param str offer: Specifies the offer of the platform image or marketplace image used to create the virtual machine.
        :param str publisher: The image publisher.
        :param str sku: The image SKU.
        :param str version: Specifies the version of the platform image or marketplace image used to create the virtual machine. The allowed formats are Major.Minor.Build or 'latest'. Major, Minor, and Build are decimal numbers. Specify 'latest' to use the latest version of an image available at deploy time. Even if you use 'latest', the VM image will not automatically update after deploy time even if a new version becomes available.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if offer is not None:
            pulumi.set(__self__, "offer", offer)
        if publisher is not None:
            pulumi.set(__self__, "publisher", publisher)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def offer(self) -> Optional[str]:
        """
        Specifies the offer of the platform image or marketplace image used to create the virtual machine.
        """
        return pulumi.get(self, "offer")

    @property
    @pulumi.getter
    def publisher(self) -> Optional[str]:
        """
        The image publisher.
        """
        return pulumi.get(self, "publisher")

    @property
    @pulumi.getter
    def sku(self) -> Optional[str]:
        """
        The image SKU.
        """
        return pulumi.get(self, "sku")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        Specifies the version of the platform image or marketplace image used to create the virtual machine. The allowed formats are Major.Minor.Build or 'latest'. Major, Minor, and Build are decimal numbers. Specify 'latest' to use the latest version of an image available at deploy time. Even if you use 'latest', the VM image will not automatically update after deploy time even if a new version becomes available.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class ImageStorageProfileResponse(dict):
    """
    Describes a storage profile.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataDisks":
            suggest = "data_disks"
        elif key == "osDisk":
            suggest = "os_disk"
        elif key == "zoneResilient":
            suggest = "zone_resilient"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageStorageProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageStorageProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageStorageProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_disks: Optional[Sequence['outputs.ImageDataDiskResponse']] = None,
                 os_disk: Optional['outputs.ImageOSDiskResponse'] = None,
                 zone_resilient: Optional[bool] = None):
        """
        Describes a storage profile.
        :param Sequence['ImageDataDiskResponse'] data_disks: Specifies the parameters that are used to add a data disk to a virtual machine. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json).
        :param 'ImageOSDiskResponse' os_disk: Specifies information about the operating system disk used by the virtual machine. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json).
        :param bool zone_resilient: Specifies whether an image is zone resilient or not. Default is false. Zone resilient images can be created only in regions that provide Zone Redundant Storage (ZRS).
        """
        if data_disks is not None:
            pulumi.set(__self__, "data_disks", data_disks)
        if os_disk is not None:
            pulumi.set(__self__, "os_disk", os_disk)
        if zone_resilient is not None:
            pulumi.set(__self__, "zone_resilient", zone_resilient)

    @property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Optional[Sequence['outputs.ImageDataDiskResponse']]:
        """
        Specifies the parameters that are used to add a data disk to a virtual machine. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json).
        """
        return pulumi.get(self, "data_disks")

    @property
    @pulumi.getter(name="osDisk")
    def os_disk(self) -> Optional['outputs.ImageOSDiskResponse']:
        """
        Specifies information about the operating system disk used by the virtual machine. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json).
        """
        return pulumi.get(self, "os_disk")

    @property
    @pulumi.getter(name="zoneResilient")
    def zone_resilient(self) -> Optional[bool]:
        """
        Specifies whether an image is zone resilient or not. Default is false. Zone resilient images can be created only in regions that provide Zone Redundant Storage (ZRS).
        """
        return pulumi.get(self, "zone_resilient")


@pulumi.output_type
class InnerErrorResponse(dict):
    """
    Inner error details.
    """
    def __init__(__self__, *,
                 errordetail: Optional[str] = None,
                 exceptiontype: Optional[str] = None):
        """
        Inner error details.
        :param str errordetail: The internal error message or exception dump.
        :param str exceptiontype: The exception type.
        """
        if errordetail is not None:
            pulumi.set(__self__, "errordetail", errordetail)
        if exceptiontype is not None:
            pulumi.set(__self__, "exceptiontype", exceptiontype)

    @property
    @pulumi.getter
    def errordetail(self) -> Optional[str]:
        """
        The internal error message or exception dump.
        """
        return pulumi.get(self, "errordetail")

    @property
    @pulumi.getter
    def exceptiontype(self) -> Optional[str]:
        """
        The exception type.
        """
        return pulumi.get(self, "exceptiontype")


@pulumi.output_type
class InstanceViewStatusResponse(dict):
    """
    Instance view status.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayStatus":
            suggest = "display_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceViewStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceViewStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceViewStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 code: Optional[str] = None,
                 display_status: Optional[str] = None,
                 level: Optional[str] = None,
                 message: Optional[str] = None,
                 time: Optional[str] = None):
        """
        Instance view status.
        :param str code: The status code.
        :param str display_status: The short localizable label for the status.
        :param str level: The level code.
        :param str message: The detailed status message, including for alerts and error messages.
        :param str time: The time of the status.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if display_status is not None:
            pulumi.set(__self__, "display_status", display_status)
        if level is not None:
            pulumi.set(__self__, "level", level)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if time is not None:
            pulumi.set(__self__, "time", time)

    @property
    @pulumi.getter
    def code(self) -> Optional[str]:
        """
        The status code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter(name="displayStatus")
    def display_status(self) -> Optional[str]:
        """
        The short localizable label for the status.
        """
        return pulumi.get(self, "display_status")

    @property
    @pulumi.getter
    def level(self) -> Optional[str]:
        """
        The level code.
        """
        return pulumi.get(self, "level")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        The detailed status message, including for alerts and error messages.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def time(self) -> Optional[str]:
        """
        The time of the status.
        """
        return pulumi.get(self, "time")


@pulumi.output_type
class KeyVaultKeyReferenceResponse(dict):
    """
    Describes a reference to Key Vault Key
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyUrl":
            suggest = "key_url"
        elif key == "sourceVault":
            suggest = "source_vault"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeyVaultKeyReferenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeyVaultKeyReferenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeyVaultKeyReferenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_url: str,
                 source_vault: 'outputs.SubResourceResponse'):
        """
        Describes a reference to Key Vault Key
        :param str key_url: The URL referencing a key encryption key in Key Vault.
        :param 'SubResourceResponse' source_vault: The relative URL of the Key Vault containing the key.
        """
        pulumi.set(__self__, "key_url", key_url)
        pulumi.set(__self__, "source_vault", source_vault)

    @property
    @pulumi.getter(name="keyUrl")
    def key_url(self) -> str:
        """
        The URL referencing a key encryption key in Key Vault.
        """
        return pulumi.get(self, "key_url")

    @property
    @pulumi.getter(name="sourceVault")
    def source_vault(self) -> 'outputs.SubResourceResponse':
        """
        The relative URL of the Key Vault containing the key.
        """
        return pulumi.get(self, "source_vault")


@pulumi.output_type
class KeyVaultSecretReferenceResponse(dict):
    """
    Describes a reference to Key Vault Secret
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretUrl":
            suggest = "secret_url"
        elif key == "sourceVault":
            suggest = "source_vault"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeyVaultSecretReferenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeyVaultSecretReferenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeyVaultSecretReferenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_url: str,
                 source_vault: 'outputs.SubResourceResponse'):
        """
        Describes a reference to Key Vault Secret
        :param str secret_url: The URL referencing a secret in a Key Vault.
        :param 'SubResourceResponse' source_vault: The relative URL of the Key Vault containing the secret.
        """
        pulumi.set(__self__, "secret_url", secret_url)
        pulumi.set(__self__, "source_vault", source_vault)

    @property
    @pulumi.getter(name="secretUrl")
    def secret_url(self) -> str:
        """
        The URL referencing a secret in a Key Vault.
        """
        return pulumi.get(self, "secret_url")

    @property
    @pulumi.getter(name="sourceVault")
    def source_vault(self) -> 'outputs.SubResourceResponse':
        """
        The relative URL of the Key Vault containing the secret.
        """
        return pulumi.get(self, "source_vault")


@pulumi.output_type
class LinuxConfigurationResponse(dict):
    """
    Specifies the Linux operating system settings on the virtual machine. <br><br>For a list of supported Linux distributions, see [Linux on Azure-Endorsed Distributions](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-endorsed-distros?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json) <br><br> For running non-endorsed distributions, see [Information for Non-Endorsed Distributions](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-create-upload-generic?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "disablePasswordAuthentication":
            suggest = "disable_password_authentication"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LinuxConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LinuxConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LinuxConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disable_password_authentication: Optional[bool] = None,
                 ssh: Optional['outputs.SshConfigurationResponse'] = None):
        """
        Specifies the Linux operating system settings on the virtual machine. <br><br>For a list of supported Linux distributions, see [Linux on Azure-Endorsed Distributions](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-endorsed-distros?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json) <br><br> For running non-endorsed distributions, see [Information for Non-Endorsed Distributions](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-create-upload-generic?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json).
        :param bool disable_password_authentication: Specifies whether password authentication should be disabled.
        :param 'SshConfigurationResponse' ssh: Specifies the ssh key configuration for a Linux OS.
        """
        if disable_password_authentication is not None:
            pulumi.set(__self__, "disable_password_authentication", disable_password_authentication)
        if ssh is not None:
            pulumi.set(__self__, "ssh", ssh)

    @property
    @pulumi.getter(name="disablePasswordAuthentication")
    def disable_password_authentication(self) -> Optional[bool]:
        """
        Specifies whether password authentication should be disabled.
        """
        return pulumi.get(self, "disable_password_authentication")

    @property
    @pulumi.getter
    def ssh(self) -> Optional['outputs.SshConfigurationResponse']:
        """
        Specifies the ssh key configuration for a Linux OS.
        """
        return pulumi.get(self, "ssh")


@pulumi.output_type
class LogAnalyticsOutputResponse(dict):
    """
    LogAnalytics output properties
    """
    def __init__(__self__, *,
                 output: str):
        """
        LogAnalytics output properties
        :param str output: Output file Uri path to blob container.
        """
        pulumi.set(__self__, "output", output)

    @property
    @pulumi.getter
    def output(self) -> str:
        """
        Output file Uri path to blob container.
        """
        return pulumi.get(self, "output")


@pulumi.output_type
class MaintenanceRedeployStatusResponse(dict):
    """
    Maintenance Operation Status.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isCustomerInitiatedMaintenanceAllowed":
            suggest = "is_customer_initiated_maintenance_allowed"
        elif key == "lastOperationMessage":
            suggest = "last_operation_message"
        elif key == "lastOperationResultCode":
            suggest = "last_operation_result_code"
        elif key == "maintenanceWindowEndTime":
            suggest = "maintenance_window_end_time"
        elif key == "maintenanceWindowStartTime":
            suggest = "maintenance_window_start_time"
        elif key == "preMaintenanceWindowEndTime":
            suggest = "pre_maintenance_window_end_time"
        elif key == "preMaintenanceWindowStartTime":
            suggest = "pre_maintenance_window_start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MaintenanceRedeployStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MaintenanceRedeployStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MaintenanceRedeployStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_customer_initiated_maintenance_allowed: Optional[bool] = None,
                 last_operation_message: Optional[str] = None,
                 last_operation_result_code: Optional[str] = None,
                 maintenance_window_end_time: Optional[str] = None,
                 maintenance_window_start_time: Optional[str] = None,
                 pre_maintenance_window_end_time: Optional[str] = None,
                 pre_maintenance_window_start_time: Optional[str] = None):
        """
        Maintenance Operation Status.
        :param bool is_customer_initiated_maintenance_allowed: True, if customer is allowed to perform Maintenance.
        :param str last_operation_message: Message returned for the last Maintenance Operation.
        :param str last_operation_result_code: The Last Maintenance Operation Result Code.
        :param str maintenance_window_end_time: End Time for the Maintenance Window.
        :param str maintenance_window_start_time: Start Time for the Maintenance Window.
        :param str pre_maintenance_window_end_time: End Time for the Pre Maintenance Window.
        :param str pre_maintenance_window_start_time: Start Time for the Pre Maintenance Window.
        """
        if is_customer_initiated_maintenance_allowed is not None:
            pulumi.set(__self__, "is_customer_initiated_maintenance_allowed", is_customer_initiated_maintenance_allowed)
        if last_operation_message is not None:
            pulumi.set(__self__, "last_operation_message", last_operation_message)
        if last_operation_result_code is not None:
            pulumi.set(__self__, "last_operation_result_code", last_operation_result_code)
        if maintenance_window_end_time is not None:
            pulumi.set(__self__, "maintenance_window_end_time", maintenance_window_end_time)
        if maintenance_window_start_time is not None:
            pulumi.set(__self__, "maintenance_window_start_time", maintenance_window_start_time)
        if pre_maintenance_window_end_time is not None:
            pulumi.set(__self__, "pre_maintenance_window_end_time", pre_maintenance_window_end_time)
        if pre_maintenance_window_start_time is not None:
            pulumi.set(__self__, "pre_maintenance_window_start_time", pre_maintenance_window_start_time)

    @property
    @pulumi.getter(name="isCustomerInitiatedMaintenanceAllowed")
    def is_customer_initiated_maintenance_allowed(self) -> Optional[bool]:
        """
        True, if customer is allowed to perform Maintenance.
        """
        return pulumi.get(self, "is_customer_initiated_maintenance_allowed")

    @property
    @pulumi.getter(name="lastOperationMessage")
    def last_operation_message(self) -> Optional[str]:
        """
        Message returned for the last Maintenance Operation.
        """
        return pulumi.get(self, "last_operation_message")

    @property
    @pulumi.getter(name="lastOperationResultCode")
    def last_operation_result_code(self) -> Optional[str]:
        """
        The Last Maintenance Operation Result Code.
        """
        return pulumi.get(self, "last_operation_result_code")

    @property
    @pulumi.getter(name="maintenanceWindowEndTime")
    def maintenance_window_end_time(self) -> Optional[str]:
        """
        End Time for the Maintenance Window.
        """
        return pulumi.get(self, "maintenance_window_end_time")

    @property
    @pulumi.getter(name="maintenanceWindowStartTime")
    def maintenance_window_start_time(self) -> Optional[str]:
        """
        Start Time for the Maintenance Window.
        """
        return pulumi.get(self, "maintenance_window_start_time")

    @property
    @pulumi.getter(name="preMaintenanceWindowEndTime")
    def pre_maintenance_window_end_time(self) -> Optional[str]:
        """
        End Time for the Pre Maintenance Window.
        """
        return pulumi.get(self, "pre_maintenance_window_end_time")

    @property
    @pulumi.getter(name="preMaintenanceWindowStartTime")
    def pre_maintenance_window_start_time(self) -> Optional[str]:
        """
        Start Time for the Pre Maintenance Window.
        """
        return pulumi.get(self, "pre_maintenance_window_start_time")


@pulumi.output_type
class ManagedDiskParametersResponse(dict):
    """
    The parameters of a managed disk.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageAccountType":
            suggest = "storage_account_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedDiskParametersResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedDiskParametersResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedDiskParametersResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: Optional[str] = None,
                 storage_account_type: Optional[str] = None):
        """
        The parameters of a managed disk.
        :param str id: Resource Id
        :param str storage_account_type: Specifies the storage account type for the managed disk. Possible values are: Standard_LRS or Premium_LRS.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if storage_account_type is not None:
            pulumi.set(__self__, "storage_account_type", storage_account_type)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="storageAccountType")
    def storage_account_type(self) -> Optional[str]:
        """
        Specifies the storage account type for the managed disk. Possible values are: Standard_LRS or Premium_LRS.
        """
        return pulumi.get(self, "storage_account_type")


@pulumi.output_type
class NetworkInterfaceReferenceResponse(dict):
    """
    Describes a network interface reference.
    """
    def __init__(__self__, *,
                 id: Optional[str] = None,
                 primary: Optional[bool] = None):
        """
        Describes a network interface reference.
        :param str id: Resource Id
        :param bool primary: Specifies the primary network interface in case the virtual machine has more than 1 network interface.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if primary is not None:
            pulumi.set(__self__, "primary", primary)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def primary(self) -> Optional[bool]:
        """
        Specifies the primary network interface in case the virtual machine has more than 1 network interface.
        """
        return pulumi.get(self, "primary")


@pulumi.output_type
class NetworkProfileResponse(dict):
    """
    Specifies the network interfaces of the virtual machine.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkInterfaces":
            suggest = "network_interfaces"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 network_interfaces: Optional[Sequence['outputs.NetworkInterfaceReferenceResponse']] = None):
        """
        Specifies the network interfaces of the virtual machine.
        :param Sequence['NetworkInterfaceReferenceResponse'] network_interfaces: Specifies the list of resource Ids for the network interfaces associated with the virtual machine.
        """
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[Sequence['outputs.NetworkInterfaceReferenceResponse']]:
        """
        Specifies the list of resource Ids for the network interfaces associated with the virtual machine.
        """
        return pulumi.get(self, "network_interfaces")


@pulumi.output_type
class OSDiskResponse(dict):
    """
    Specifies information about the operating system disk used by the virtual machine. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createOption":
            suggest = "create_option"
        elif key == "diskSizeGB":
            suggest = "disk_size_gb"
        elif key == "encryptionSettings":
            suggest = "encryption_settings"
        elif key == "managedDisk":
            suggest = "managed_disk"
        elif key == "osType":
            suggest = "os_type"
        elif key == "writeAcceleratorEnabled":
            suggest = "write_accelerator_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OSDiskResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OSDiskResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OSDiskResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 create_option: str,
                 caching: Optional[str] = None,
                 disk_size_gb: Optional[int] = None,
                 encryption_settings: Optional['outputs.DiskEncryptionSettingsResponse'] = None,
                 image: Optional['outputs.VirtualHardDiskResponse'] = None,
                 managed_disk: Optional['outputs.ManagedDiskParametersResponse'] = None,
                 name: Optional[str] = None,
                 os_type: Optional[str] = None,
                 vhd: Optional['outputs.VirtualHardDiskResponse'] = None,
                 write_accelerator_enabled: Optional[bool] = None):
        """
        Specifies information about the operating system disk used by the virtual machine. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json).
        :param str create_option: Specifies how the virtual machine should be created.<br><br> Possible values are:<br><br> **Attach** \u2013 This value is used when you are using a specialized disk to create the virtual machine.<br><br> **FromImage** \u2013 This value is used when you are using an image to create the virtual machine. If you are using a platform image, you also use the imageReference element described above. If you are using a marketplace image, you  also use the plan element previously described.
        :param str caching: Specifies the caching requirements. <br><br> Possible values are: <br><br> **None** <br><br> **ReadOnly** <br><br> **ReadWrite** <br><br> Default: **None for Standard storage. ReadOnly for Premium storage**
        :param int disk_size_gb: Specifies the size of an empty data disk in gigabytes. This element can be used to overwrite the size of the disk in a virtual machine image. <br><br> This value cannot be larger than 1023 GB
        :param 'DiskEncryptionSettingsResponse' encryption_settings: Specifies the encryption settings for the OS Disk. <br><br> Minimum api-version: 2015-06-15
        :param 'VirtualHardDiskResponse' image: The source user image virtual hard disk. The virtual hard disk will be copied before being attached to the virtual machine. If SourceImage is provided, the destination virtual hard drive must not exist.
        :param 'ManagedDiskParametersResponse' managed_disk: The managed disk parameters.
        :param str name: The disk name.
        :param str os_type: This property allows you to specify the type of the OS that is included in the disk if creating a VM from user-image or a specialized VHD. <br><br> Possible values are: <br><br> **Windows** <br><br> **Linux**
        :param 'VirtualHardDiskResponse' vhd: The virtual hard disk.
        :param bool write_accelerator_enabled: Specifies whether writeAccelerator should be enabled or disabled on the disk.
        """
        pulumi.set(__self__, "create_option", create_option)
        if caching is not None:
            pulumi.set(__self__, "caching", caching)
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if encryption_settings is not None:
            pulumi.set(__self__, "encryption_settings", encryption_settings)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if managed_disk is not None:
            pulumi.set(__self__, "managed_disk", managed_disk)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if vhd is not None:
            pulumi.set(__self__, "vhd", vhd)
        if write_accelerator_enabled is not None:
            pulumi.set(__self__, "write_accelerator_enabled", write_accelerator_enabled)

    @property
    @pulumi.getter(name="createOption")
    def create_option(self) -> str:
        """
        Specifies how the virtual machine should be created.<br><br> Possible values are:<br><br> **Attach** \u2013 This value is used when you are using a specialized disk to create the virtual machine.<br><br> **FromImage** \u2013 This value is used when you are using an image to create the virtual machine. If you are using a platform image, you also use the imageReference element described above. If you are using a marketplace image, you  also use the plan element previously described.
        """
        return pulumi.get(self, "create_option")

    @property
    @pulumi.getter
    def caching(self) -> Optional[str]:
        """
        Specifies the caching requirements. <br><br> Possible values are: <br><br> **None** <br><br> **ReadOnly** <br><br> **ReadWrite** <br><br> Default: **None for Standard storage. ReadOnly for Premium storage**
        """
        return pulumi.get(self, "caching")

    @property
    @pulumi.getter(name="diskSizeGB")
    def disk_size_gb(self) -> Optional[int]:
        """
        Specifies the size of an empty data disk in gigabytes. This element can be used to overwrite the size of the disk in a virtual machine image. <br><br> This value cannot be larger than 1023 GB
        """
        return pulumi.get(self, "disk_size_gb")

    @property
    @pulumi.getter(name="encryptionSettings")
    def encryption_settings(self) -> Optional['outputs.DiskEncryptionSettingsResponse']:
        """
        Specifies the encryption settings for the OS Disk. <br><br> Minimum api-version: 2015-06-15
        """
        return pulumi.get(self, "encryption_settings")

    @property
    @pulumi.getter
    def image(self) -> Optional['outputs.VirtualHardDiskResponse']:
        """
        The source user image virtual hard disk. The virtual hard disk will be copied before being attached to the virtual machine. If SourceImage is provided, the destination virtual hard drive must not exist.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="managedDisk")
    def managed_disk(self) -> Optional['outputs.ManagedDiskParametersResponse']:
        """
        The managed disk parameters.
        """
        return pulumi.get(self, "managed_disk")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The disk name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[str]:
        """
        This property allows you to specify the type of the OS that is included in the disk if creating a VM from user-image or a specialized VHD. <br><br> Possible values are: <br><br> **Windows** <br><br> **Linux**
        """
        return pulumi.get(self, "os_type")

    @property
    @pulumi.getter
    def vhd(self) -> Optional['outputs.VirtualHardDiskResponse']:
        """
        The virtual hard disk.
        """
        return pulumi.get(self, "vhd")

    @property
    @pulumi.getter(name="writeAcceleratorEnabled")
    def write_accelerator_enabled(self) -> Optional[bool]:
        """
        Specifies whether writeAccelerator should be enabled or disabled on the disk.
        """
        return pulumi.get(self, "write_accelerator_enabled")


@pulumi.output_type
class OSProfileResponse(dict):
    """
    Specifies the operating system settings for the virtual machine.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adminPassword":
            suggest = "admin_password"
        elif key == "adminUsername":
            suggest = "admin_username"
        elif key == "computerName":
            suggest = "computer_name"
        elif key == "customData":
            suggest = "custom_data"
        elif key == "linuxConfiguration":
            suggest = "linux_configuration"
        elif key == "windowsConfiguration":
            suggest = "windows_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OSProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OSProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OSProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 admin_password: Optional[str] = None,
                 admin_username: Optional[str] = None,
                 computer_name: Optional[str] = None,
                 custom_data: Optional[str] = None,
                 linux_configuration: Optional['outputs.LinuxConfigurationResponse'] = None,
                 secrets: Optional[Sequence['outputs.VaultSecretGroupResponse']] = None,
                 windows_configuration: Optional['outputs.WindowsConfigurationResponse'] = None):
        """
        Specifies the operating system settings for the virtual machine.
        :param str admin_password: Specifies the password of the administrator account. <br><br> **Minimum-length (Windows):** 8 characters <br><br> **Minimum-length (Linux):** 6 characters <br><br> **Max-length (Windows):** 123 characters <br><br> **Max-length (Linux):** 72 characters <br><br> **Complexity requirements:** 3 out of 4 conditions below need to be fulfilled <br> Has lower characters <br>Has upper characters <br> Has a digit <br> Has a special character (Regex match [\W_]) <br><br> **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1", "Password22", "iloveyou!" <br><br> For resetting the password, see [How to reset the Remote Desktop service or its login password in a Windows VM](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-reset-rdp?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json) <br><br> For resetting root password, see [Manage users, SSH, and check or repair disks on Azure Linux VMs using the VMAccess Extension](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-using-vmaccess-extension?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json#reset-root-password)
        :param str admin_username: Specifies the name of the administrator account. <br><br> **Windows-only restriction:** Cannot end in "." <br><br> **Disallowed values:** "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest", "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5". <br><br> **Minimum-length (Linux):** 1  character <br><br> **Max-length (Linux):** 64 characters <br><br> **Max-length (Windows):** 20 characters  <br><br><li> For root access to the Linux VM, see [Using root privileges on Linux virtual machines in Azure](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-use-root-privileges?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json)<br><li> For a list of built-in system users on Linux that should not be used in this field, see [Selecting User Names for Linux on Azure](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-usernames?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json)
        :param str computer_name: Specifies the host OS name of the virtual machine. <br><br> This name cannot be updated after the VM is created. <br><br> **Max-length (Windows):** 15 characters <br><br> **Max-length (Linux):** 64 characters. <br><br> For naming conventions and restrictions see [Azure infrastructure services implementation guidelines](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-infrastructure-subscription-accounts-guidelines?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json#1-naming-conventions).
        :param str custom_data: Specifies a base-64 encoded string of custom data. The base-64 encoded string is decoded to a binary array that is saved as a file on the Virtual Machine. The maximum length of the binary array is 65535 bytes. <br><br> For using cloud-init for your VM, see [Using cloud-init to customize a Linux VM during creation](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-using-cloud-init?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json)
        :param 'LinuxConfigurationResponse' linux_configuration: Specifies the Linux operating system settings on the virtual machine. <br><br>For a list of supported Linux distributions, see [Linux on Azure-Endorsed Distributions](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-endorsed-distros?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json) <br><br> For running non-endorsed distributions, see [Information for Non-Endorsed Distributions](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-create-upload-generic?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json).
        :param Sequence['VaultSecretGroupResponse'] secrets: Specifies set of certificates that should be installed onto the virtual machine.
        :param 'WindowsConfigurationResponse' windows_configuration: Specifies Windows operating system settings on the virtual machine.
        """
        if admin_password is not None:
            pulumi.set(__self__, "admin_password", admin_password)
        if admin_username is not None:
            pulumi.set(__self__, "admin_username", admin_username)
        if computer_name is not None:
            pulumi.set(__self__, "computer_name", computer_name)
        if custom_data is not None:
            pulumi.set(__self__, "custom_data", custom_data)
        if linux_configuration is not None:
            pulumi.set(__self__, "linux_configuration", linux_configuration)
        if secrets is not None:
            pulumi.set(__self__, "secrets", secrets)
        if windows_configuration is not None:
            pulumi.set(__self__, "windows_configuration", windows_configuration)

    @property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> Optional[str]:
        """
        Specifies the password of the administrator account. <br><br> **Minimum-length (Windows):** 8 characters <br><br> **Minimum-length (Linux):** 6 characters <br><br> **Max-length (Windows):** 123 characters <br><br> **Max-length (Linux):** 72 characters <br><br> **Complexity requirements:** 3 out of 4 conditions below need to be fulfilled <br> Has lower characters <br>Has upper characters <br> Has a digit <br> Has a special character (Regex match [\W_]) <br><br> **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1", "Password22", "iloveyou!" <br><br> For resetting the password, see [How to reset the Remote Desktop service or its login password in a Windows VM](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-reset-rdp?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json) <br><br> For resetting root password, see [Manage users, SSH, and check or repair disks on Azure Linux VMs using the VMAccess Extension](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-using-vmaccess-extension?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json#reset-root-password)
        """
        return pulumi.get(self, "admin_password")

    @property
    @pulumi.getter(name="adminUsername")
    def admin_username(self) -> Optional[str]:
        """
        Specifies the name of the administrator account. <br><br> **Windows-only restriction:** Cannot end in "." <br><br> **Disallowed values:** "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest", "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5". <br><br> **Minimum-length (Linux):** 1  character <br><br> **Max-length (Linux):** 64 characters <br><br> **Max-length (Windows):** 20 characters  <br><br><li> For root access to the Linux VM, see [Using root privileges on Linux virtual machines in Azure](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-use-root-privileges?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json)<br><li> For a list of built-in system users on Linux that should not be used in this field, see [Selecting User Names for Linux on Azure](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-usernames?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json)
        """
        return pulumi.get(self, "admin_username")

    @property
    @pulumi.getter(name="computerName")
    def computer_name(self) -> Optional[str]:
        """
        Specifies the host OS name of the virtual machine. <br><br> This name cannot be updated after the VM is created. <br><br> **Max-length (Windows):** 15 characters <br><br> **Max-length (Linux):** 64 characters. <br><br> For naming conventions and restrictions see [Azure infrastructure services implementation guidelines](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-infrastructure-subscription-accounts-guidelines?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json#1-naming-conventions).
        """
        return pulumi.get(self, "computer_name")

    @property
    @pulumi.getter(name="customData")
    def custom_data(self) -> Optional[str]:
        """
        Specifies a base-64 encoded string of custom data. The base-64 encoded string is decoded to a binary array that is saved as a file on the Virtual Machine. The maximum length of the binary array is 65535 bytes. <br><br> For using cloud-init for your VM, see [Using cloud-init to customize a Linux VM during creation](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-using-cloud-init?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json)
        """
        return pulumi.get(self, "custom_data")

    @property
    @pulumi.getter(name="linuxConfiguration")
    def linux_configuration(self) -> Optional['outputs.LinuxConfigurationResponse']:
        """
        Specifies the Linux operating system settings on the virtual machine. <br><br>For a list of supported Linux distributions, see [Linux on Azure-Endorsed Distributions](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-endorsed-distros?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json) <br><br> For running non-endorsed distributions, see [Information for Non-Endorsed Distributions](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-create-upload-generic?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json).
        """
        return pulumi.get(self, "linux_configuration")

    @property
    @pulumi.getter
    def secrets(self) -> Optional[Sequence['outputs.VaultSecretGroupResponse']]:
        """
        Specifies set of certificates that should be installed onto the virtual machine.
        """
        return pulumi.get(self, "secrets")

    @property
    @pulumi.getter(name="windowsConfiguration")
    def windows_configuration(self) -> Optional['outputs.WindowsConfigurationResponse']:
        """
        Specifies Windows operating system settings on the virtual machine.
        """
        return pulumi.get(self, "windows_configuration")


@pulumi.output_type
class PlanResponse(dict):
    """
    Specifies information about the marketplace image used to create the virtual machine. This element is only used for marketplace images. Before you can use a marketplace image from an API, you must enable the image for programmatic use.  In the Azure portal, find the marketplace image that you want to use and then click **Want to deploy programmatically, Get Started ->**. Enter any required information and then click **Save**.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "promotionCode":
            suggest = "promotion_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PlanResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PlanResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PlanResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[str] = None,
                 product: Optional[str] = None,
                 promotion_code: Optional[str] = None,
                 publisher: Optional[str] = None):
        """
        Specifies information about the marketplace image used to create the virtual machine. This element is only used for marketplace images. Before you can use a marketplace image from an API, you must enable the image for programmatic use.  In the Azure portal, find the marketplace image that you want to use and then click **Want to deploy programmatically, Get Started ->**. Enter any required information and then click **Save**.
        :param str name: The plan ID.
        :param str product: Specifies the product of the image from the marketplace. This is the same value as Offer under the imageReference element.
        :param str promotion_code: The promotion code.
        :param str publisher: The publisher ID.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if product is not None:
            pulumi.set(__self__, "product", product)
        if promotion_code is not None:
            pulumi.set(__self__, "promotion_code", promotion_code)
        if publisher is not None:
            pulumi.set(__self__, "publisher", publisher)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The plan ID.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def product(self) -> Optional[str]:
        """
        Specifies the product of the image from the marketplace. This is the same value as Offer under the imageReference element.
        """
        return pulumi.get(self, "product")

    @property
    @pulumi.getter(name="promotionCode")
    def promotion_code(self) -> Optional[str]:
        """
        The promotion code.
        """
        return pulumi.get(self, "promotion_code")

    @property
    @pulumi.getter
    def publisher(self) -> Optional[str]:
        """
        The publisher ID.
        """
        return pulumi.get(self, "publisher")


@pulumi.output_type
class RollingUpgradePolicyResponse(dict):
    """
    The configuration parameters used while performing a rolling upgrade.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxBatchInstancePercent":
            suggest = "max_batch_instance_percent"
        elif key == "maxUnhealthyInstancePercent":
            suggest = "max_unhealthy_instance_percent"
        elif key == "maxUnhealthyUpgradedInstancePercent":
            suggest = "max_unhealthy_upgraded_instance_percent"
        elif key == "pauseTimeBetweenBatches":
            suggest = "pause_time_between_batches"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RollingUpgradePolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RollingUpgradePolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RollingUpgradePolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_batch_instance_percent: Optional[int] = None,
                 max_unhealthy_instance_percent: Optional[int] = None,
                 max_unhealthy_upgraded_instance_percent: Optional[int] = None,
                 pause_time_between_batches: Optional[str] = None):
        """
        The configuration parameters used while performing a rolling upgrade.
        :param int max_batch_instance_percent: The maximum percent of total virtual machine instances that will be upgraded simultaneously by the rolling upgrade in one batch. As this is a maximum, unhealthy instances in previous or future batches can cause the percentage of instances in a batch to decrease to ensure higher reliability. The default value for this parameter is 20%.
        :param int max_unhealthy_instance_percent: The maximum percentage of the total virtual machine instances in the scale set that can be simultaneously unhealthy, either as a result of being upgraded, or by being found in an unhealthy state by the virtual machine health checks before the rolling upgrade aborts. This constraint will be checked prior to starting any batch. The default value for this parameter is 20%.
        :param int max_unhealthy_upgraded_instance_percent: The maximum percentage of upgraded virtual machine instances that can be found to be in an unhealthy state. This check will happen after each batch is upgraded. If this percentage is ever exceeded, the rolling update aborts. The default value for this parameter is 20%.
        :param str pause_time_between_batches: The wait time between completing the update for all virtual machines in one batch and starting the next batch. The time duration should be specified in ISO 8601 format. The default value is 0 seconds (PT0S).
        """
        if max_batch_instance_percent is not None:
            pulumi.set(__self__, "max_batch_instance_percent", max_batch_instance_percent)
        if max_unhealthy_instance_percent is not None:
            pulumi.set(__self__, "max_unhealthy_instance_percent", max_unhealthy_instance_percent)
        if max_unhealthy_upgraded_instance_percent is not None:
            pulumi.set(__self__, "max_unhealthy_upgraded_instance_percent", max_unhealthy_upgraded_instance_percent)
        if pause_time_between_batches is not None:
            pulumi.set(__self__, "pause_time_between_batches", pause_time_between_batches)

    @property
    @pulumi.getter(name="maxBatchInstancePercent")
    def max_batch_instance_percent(self) -> Optional[int]:
        """
        The maximum percent of total virtual machine instances that will be upgraded simultaneously by the rolling upgrade in one batch. As this is a maximum, unhealthy instances in previous or future batches can cause the percentage of instances in a batch to decrease to ensure higher reliability. The default value for this parameter is 20%.
        """
        return pulumi.get(self, "max_batch_instance_percent")

    @property
    @pulumi.getter(name="maxUnhealthyInstancePercent")
    def max_unhealthy_instance_percent(self) -> Optional[int]:
        """
        The maximum percentage of the total virtual machine instances in the scale set that can be simultaneously unhealthy, either as a result of being upgraded, or by being found in an unhealthy state by the virtual machine health checks before the rolling upgrade aborts. This constraint will be checked prior to starting any batch. The default value for this parameter is 20%.
        """
        return pulumi.get(self, "max_unhealthy_instance_percent")

    @property
    @pulumi.getter(name="maxUnhealthyUpgradedInstancePercent")
    def max_unhealthy_upgraded_instance_percent(self) -> Optional[int]:
        """
        The maximum percentage of upgraded virtual machine instances that can be found to be in an unhealthy state. This check will happen after each batch is upgraded. If this percentage is ever exceeded, the rolling update aborts. The default value for this parameter is 20%.
        """
        return pulumi.get(self, "max_unhealthy_upgraded_instance_percent")

    @property
    @pulumi.getter(name="pauseTimeBetweenBatches")
    def pause_time_between_batches(self) -> Optional[str]:
        """
        The wait time between completing the update for all virtual machines in one batch and starting the next batch. The time duration should be specified in ISO 8601 format. The default value is 0 seconds (PT0S).
        """
        return pulumi.get(self, "pause_time_between_batches")


@pulumi.output_type
class SkuResponse(dict):
    """
    Describes a virtual machine scale set sku. NOTE: If the new VM SKU is not supported on the hardware the scale set is currently on, you need to deallocate the VMs in the scale set before you modify the SKU name.
    """
    def __init__(__self__, *,
                 capacity: Optional[float] = None,
                 name: Optional[str] = None,
                 tier: Optional[str] = None):
        """
        Describes a virtual machine scale set sku. NOTE: If the new VM SKU is not supported on the hardware the scale set is currently on, you need to deallocate the VMs in the scale set before you modify the SKU name.
        :param float capacity: Specifies the number of virtual machines in the scale set.
        :param str name: The sku name.
        :param str tier: Specifies the tier of virtual machines in a scale set.<br /><br /> Possible Values:<br /><br /> **Standard**<br /><br /> **Basic**
        """
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[float]:
        """
        Specifies the number of virtual machines in the scale set.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The sku name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tier(self) -> Optional[str]:
        """
        Specifies the tier of virtual machines in a scale set.<br /><br /> Possible Values:<br /><br /> **Standard**<br /><br /> **Basic**
        """
        return pulumi.get(self, "tier")


@pulumi.output_type
class SshConfigurationResponse(dict):
    """
    SSH configuration for Linux based VMs running on Azure
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicKeys":
            suggest = "public_keys"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SshConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SshConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SshConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 public_keys: Optional[Sequence['outputs.SshPublicKeyResponse']] = None):
        """
        SSH configuration for Linux based VMs running on Azure
        :param Sequence['SshPublicKeyResponse'] public_keys: The list of SSH public keys used to authenticate with linux based VMs.
        """
        if public_keys is not None:
            pulumi.set(__self__, "public_keys", public_keys)

    @property
    @pulumi.getter(name="publicKeys")
    def public_keys(self) -> Optional[Sequence['outputs.SshPublicKeyResponse']]:
        """
        The list of SSH public keys used to authenticate with linux based VMs.
        """
        return pulumi.get(self, "public_keys")


@pulumi.output_type
class SshPublicKeyResponse(dict):
    """
    Contains information about SSH certificate public key and the path on the Linux VM where the public key is placed.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyData":
            suggest = "key_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SshPublicKeyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SshPublicKeyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SshPublicKeyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_data: Optional[str] = None,
                 path: Optional[str] = None):
        """
        Contains information about SSH certificate public key and the path on the Linux VM where the public key is placed.
        :param str key_data: SSH public key certificate used to authenticate with the VM through ssh. The key needs to be at least 2048-bit and in ssh-rsa format. <br><br> For creating ssh keys, see [Create SSH keys on Linux and Mac for Linux VMs in Azure](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-mac-create-ssh-keys?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json).
        :param str path: Specifies the full path on the created VM where ssh public key is stored. If the file already exists, the specified key is appended to the file. Example: /home/user/.ssh/authorized_keys
        """
        if key_data is not None:
            pulumi.set(__self__, "key_data", key_data)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="keyData")
    def key_data(self) -> Optional[str]:
        """
        SSH public key certificate used to authenticate with the VM through ssh. The key needs to be at least 2048-bit and in ssh-rsa format. <br><br> For creating ssh keys, see [Create SSH keys on Linux and Mac for Linux VMs in Azure](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-mac-create-ssh-keys?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json).
        """
        return pulumi.get(self, "key_data")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        Specifies the full path on the created VM where ssh public key is stored. If the file already exists, the specified key is appended to the file. Example: /home/user/.ssh/authorized_keys
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class StorageProfileResponse(dict):
    """
    Specifies the storage settings for the virtual machine disks.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataDisks":
            suggest = "data_disks"
        elif key == "imageReference":
            suggest = "image_reference"
        elif key == "osDisk":
            suggest = "os_disk"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_disks: Optional[Sequence['outputs.DataDiskResponse']] = None,
                 image_reference: Optional['outputs.ImageReferenceResponse'] = None,
                 os_disk: Optional['outputs.OSDiskResponse'] = None):
        """
        Specifies the storage settings for the virtual machine disks.
        :param Sequence['DataDiskResponse'] data_disks: Specifies the parameters that are used to add a data disk to a virtual machine. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json).
        :param 'ImageReferenceResponse' image_reference: Specifies information about the image to use. You can specify information about platform images, marketplace images, or virtual machine images. This element is required when you want to use a platform image, marketplace image, or virtual machine image, but is not used in other creation operations.
        :param 'OSDiskResponse' os_disk: Specifies information about the operating system disk used by the virtual machine. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json).
        """
        if data_disks is not None:
            pulumi.set(__self__, "data_disks", data_disks)
        if image_reference is not None:
            pulumi.set(__self__, "image_reference", image_reference)
        if os_disk is not None:
            pulumi.set(__self__, "os_disk", os_disk)

    @property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Optional[Sequence['outputs.DataDiskResponse']]:
        """
        Specifies the parameters that are used to add a data disk to a virtual machine. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json).
        """
        return pulumi.get(self, "data_disks")

    @property
    @pulumi.getter(name="imageReference")
    def image_reference(self) -> Optional['outputs.ImageReferenceResponse']:
        """
        Specifies information about the image to use. You can specify information about platform images, marketplace images, or virtual machine images. This element is required when you want to use a platform image, marketplace image, or virtual machine image, but is not used in other creation operations.
        """
        return pulumi.get(self, "image_reference")

    @property
    @pulumi.getter(name="osDisk")
    def os_disk(self) -> Optional['outputs.OSDiskResponse']:
        """
        Specifies information about the operating system disk used by the virtual machine. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json).
        """
        return pulumi.get(self, "os_disk")


@pulumi.output_type
class SubResourceResponse(dict):
    def __init__(__self__, *,
                 id: Optional[str] = None):
        """
        :param str id: Resource Id
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class UpgradePolicyResponse(dict):
    """
    Describes an upgrade policy - automatic, manual, or rolling.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoOSUpgradePolicy":
            suggest = "auto_os_upgrade_policy"
        elif key == "automaticOSUpgrade":
            suggest = "automatic_os_upgrade"
        elif key == "rollingUpgradePolicy":
            suggest = "rolling_upgrade_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UpgradePolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UpgradePolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UpgradePolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auto_os_upgrade_policy: Optional['outputs.AutoOSUpgradePolicyResponse'] = None,
                 automatic_os_upgrade: Optional[bool] = None,
                 mode: Optional[str] = None,
                 rolling_upgrade_policy: Optional['outputs.RollingUpgradePolicyResponse'] = None):
        """
        Describes an upgrade policy - automatic, manual, or rolling.
        :param 'AutoOSUpgradePolicyResponse' auto_os_upgrade_policy: Configuration parameters used for performing automatic OS Upgrade.
        :param bool automatic_os_upgrade: Whether OS upgrades should automatically be applied to scale set instances in a rolling fashion when a newer version of the image becomes available.
        :param str mode: Specifies the mode of an upgrade to virtual machines in the scale set.<br /><br /> Possible values are:<br /><br /> **Manual** - You  control the application of updates to virtual machines in the scale set. You do this by using the manualUpgrade action.<br /><br /> **Automatic** - All virtual machines in the scale set are  automatically updated at the same time.
        :param 'RollingUpgradePolicyResponse' rolling_upgrade_policy: The configuration parameters used while performing a rolling upgrade.
        """
        if auto_os_upgrade_policy is not None:
            pulumi.set(__self__, "auto_os_upgrade_policy", auto_os_upgrade_policy)
        if automatic_os_upgrade is not None:
            pulumi.set(__self__, "automatic_os_upgrade", automatic_os_upgrade)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if rolling_upgrade_policy is not None:
            pulumi.set(__self__, "rolling_upgrade_policy", rolling_upgrade_policy)

    @property
    @pulumi.getter(name="autoOSUpgradePolicy")
    def auto_os_upgrade_policy(self) -> Optional['outputs.AutoOSUpgradePolicyResponse']:
        """
        Configuration parameters used for performing automatic OS Upgrade.
        """
        return pulumi.get(self, "auto_os_upgrade_policy")

    @property
    @pulumi.getter(name="automaticOSUpgrade")
    def automatic_os_upgrade(self) -> Optional[bool]:
        """
        Whether OS upgrades should automatically be applied to scale set instances in a rolling fashion when a newer version of the image becomes available.
        """
        return pulumi.get(self, "automatic_os_upgrade")

    @property
    @pulumi.getter
    def mode(self) -> Optional[str]:
        """
        Specifies the mode of an upgrade to virtual machines in the scale set.<br /><br /> Possible values are:<br /><br /> **Manual** - You  control the application of updates to virtual machines in the scale set. You do this by using the manualUpgrade action.<br /><br /> **Automatic** - All virtual machines in the scale set are  automatically updated at the same time.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter(name="rollingUpgradePolicy")
    def rolling_upgrade_policy(self) -> Optional['outputs.RollingUpgradePolicyResponse']:
        """
        The configuration parameters used while performing a rolling upgrade.
        """
        return pulumi.get(self, "rolling_upgrade_policy")


@pulumi.output_type
class VaultCertificateResponse(dict):
    """
    Describes a single certificate reference in a Key Vault, and where the certificate should reside on the VM.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateStore":
            suggest = "certificate_store"
        elif key == "certificateUrl":
            suggest = "certificate_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VaultCertificateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VaultCertificateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VaultCertificateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_store: Optional[str] = None,
                 certificate_url: Optional[str] = None):
        """
        Describes a single certificate reference in a Key Vault, and where the certificate should reside on the VM.
        :param str certificate_store: For Windows VMs, specifies the certificate store on the Virtual Machine to which the certificate should be added. The specified certificate store is implicitly in the LocalMachine account. <br><br>For Linux VMs, the certificate file is placed under the /var/lib/waagent directory, with the file name &lt;UppercaseThumbprint&gt;.crt for the X509 certificate file and &lt;UppercaseThumbprint&gt;.prv for private key. Both of these files are .pem formatted.
        :param str certificate_url: This is the URL of a certificate that has been uploaded to Key Vault as a secret. For adding a secret to the Key Vault, see [Add a key or secret to the key vault](https://docs.microsoft.com/azure/key-vault/key-vault-get-started/#add). In this case, your certificate needs to be It is the Base64 encoding of the following JSON Object which is encoded in UTF-8: <br><br> {<br>  "data":"<Base64-encoded-certificate>",<br>  "dataType":"pfx",<br>  "password":"<pfx-file-password>"<br>}
        """
        if certificate_store is not None:
            pulumi.set(__self__, "certificate_store", certificate_store)
        if certificate_url is not None:
            pulumi.set(__self__, "certificate_url", certificate_url)

    @property
    @pulumi.getter(name="certificateStore")
    def certificate_store(self) -> Optional[str]:
        """
        For Windows VMs, specifies the certificate store on the Virtual Machine to which the certificate should be added. The specified certificate store is implicitly in the LocalMachine account. <br><br>For Linux VMs, the certificate file is placed under the /var/lib/waagent directory, with the file name &lt;UppercaseThumbprint&gt;.crt for the X509 certificate file and &lt;UppercaseThumbprint&gt;.prv for private key. Both of these files are .pem formatted.
        """
        return pulumi.get(self, "certificate_store")

    @property
    @pulumi.getter(name="certificateUrl")
    def certificate_url(self) -> Optional[str]:
        """
        This is the URL of a certificate that has been uploaded to Key Vault as a secret. For adding a secret to the Key Vault, see [Add a key or secret to the key vault](https://docs.microsoft.com/azure/key-vault/key-vault-get-started/#add). In this case, your certificate needs to be It is the Base64 encoding of the following JSON Object which is encoded in UTF-8: <br><br> {<br>  "data":"<Base64-encoded-certificate>",<br>  "dataType":"pfx",<br>  "password":"<pfx-file-password>"<br>}
        """
        return pulumi.get(self, "certificate_url")


@pulumi.output_type
class VaultSecretGroupResponse(dict):
    """
    Describes a set of certificates which are all in the same Key Vault.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceVault":
            suggest = "source_vault"
        elif key == "vaultCertificates":
            suggest = "vault_certificates"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VaultSecretGroupResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VaultSecretGroupResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VaultSecretGroupResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_vault: Optional['outputs.SubResourceResponse'] = None,
                 vault_certificates: Optional[Sequence['outputs.VaultCertificateResponse']] = None):
        """
        Describes a set of certificates which are all in the same Key Vault.
        :param 'SubResourceResponse' source_vault: The relative URL of the Key Vault containing all of the certificates in VaultCertificates.
        :param Sequence['VaultCertificateResponse'] vault_certificates: The list of key vault references in SourceVault which contain certificates.
        """
        if source_vault is not None:
            pulumi.set(__self__, "source_vault", source_vault)
        if vault_certificates is not None:
            pulumi.set(__self__, "vault_certificates", vault_certificates)

    @property
    @pulumi.getter(name="sourceVault")
    def source_vault(self) -> Optional['outputs.SubResourceResponse']:
        """
        The relative URL of the Key Vault containing all of the certificates in VaultCertificates.
        """
        return pulumi.get(self, "source_vault")

    @property
    @pulumi.getter(name="vaultCertificates")
    def vault_certificates(self) -> Optional[Sequence['outputs.VaultCertificateResponse']]:
        """
        The list of key vault references in SourceVault which contain certificates.
        """
        return pulumi.get(self, "vault_certificates")


@pulumi.output_type
class VirtualHardDiskResponse(dict):
    """
    Describes the uri of a disk.
    """
    def __init__(__self__, *,
                 uri: Optional[str] = None):
        """
        Describes the uri of a disk.
        :param str uri: Specifies the virtual hard disk's uri.
        """
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def uri(self) -> Optional[str]:
        """
        Specifies the virtual hard disk's uri.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class VirtualMachineAgentInstanceViewResponse(dict):
    """
    The instance view of the VM Agent running on the virtual machine.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "extensionHandlers":
            suggest = "extension_handlers"
        elif key == "vmAgentVersion":
            suggest = "vm_agent_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineAgentInstanceViewResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineAgentInstanceViewResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineAgentInstanceViewResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 extension_handlers: Optional[Sequence['outputs.VirtualMachineExtensionHandlerInstanceViewResponse']] = None,
                 statuses: Optional[Sequence['outputs.InstanceViewStatusResponse']] = None,
                 vm_agent_version: Optional[str] = None):
        """
        The instance view of the VM Agent running on the virtual machine.
        :param Sequence['VirtualMachineExtensionHandlerInstanceViewResponse'] extension_handlers: The virtual machine extension handler instance view.
        :param Sequence['InstanceViewStatusResponse'] statuses: The resource status information.
        :param str vm_agent_version: The VM Agent full version.
        """
        if extension_handlers is not None:
            pulumi.set(__self__, "extension_handlers", extension_handlers)
        if statuses is not None:
            pulumi.set(__self__, "statuses", statuses)
        if vm_agent_version is not None:
            pulumi.set(__self__, "vm_agent_version", vm_agent_version)

    @property
    @pulumi.getter(name="extensionHandlers")
    def extension_handlers(self) -> Optional[Sequence['outputs.VirtualMachineExtensionHandlerInstanceViewResponse']]:
        """
        The virtual machine extension handler instance view.
        """
        return pulumi.get(self, "extension_handlers")

    @property
    @pulumi.getter
    def statuses(self) -> Optional[Sequence['outputs.InstanceViewStatusResponse']]:
        """
        The resource status information.
        """
        return pulumi.get(self, "statuses")

    @property
    @pulumi.getter(name="vmAgentVersion")
    def vm_agent_version(self) -> Optional[str]:
        """
        The VM Agent full version.
        """
        return pulumi.get(self, "vm_agent_version")


@pulumi.output_type
class VirtualMachineExtensionHandlerInstanceViewResponse(dict):
    """
    The instance view of a virtual machine extension handler.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "typeHandlerVersion":
            suggest = "type_handler_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineExtensionHandlerInstanceViewResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineExtensionHandlerInstanceViewResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineExtensionHandlerInstanceViewResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 status: Optional['outputs.InstanceViewStatusResponse'] = None,
                 type: Optional[str] = None,
                 type_handler_version: Optional[str] = None):
        """
        The instance view of a virtual machine extension handler.
        :param 'InstanceViewStatusResponse' status: The extension handler status.
        :param str type: Specifies the type of the extension; an example is "CustomScriptExtension".
        :param str type_handler_version: Specifies the version of the script handler.
        """
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if type_handler_version is not None:
            pulumi.set(__self__, "type_handler_version", type_handler_version)

    @property
    @pulumi.getter
    def status(self) -> Optional['outputs.InstanceViewStatusResponse']:
        """
        The extension handler status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Specifies the type of the extension; an example is "CustomScriptExtension".
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="typeHandlerVersion")
    def type_handler_version(self) -> Optional[str]:
        """
        Specifies the version of the script handler.
        """
        return pulumi.get(self, "type_handler_version")


@pulumi.output_type
class VirtualMachineExtensionInstanceViewResponse(dict):
    """
    The instance view of a virtual machine extension.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "typeHandlerVersion":
            suggest = "type_handler_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineExtensionInstanceViewResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineExtensionInstanceViewResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineExtensionInstanceViewResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[str] = None,
                 statuses: Optional[Sequence['outputs.InstanceViewStatusResponse']] = None,
                 substatuses: Optional[Sequence['outputs.InstanceViewStatusResponse']] = None,
                 type: Optional[str] = None,
                 type_handler_version: Optional[str] = None):
        """
        The instance view of a virtual machine extension.
        :param str name: The virtual machine extension name.
        :param Sequence['InstanceViewStatusResponse'] statuses: The resource status information.
        :param Sequence['InstanceViewStatusResponse'] substatuses: The resource status information.
        :param str type: Specifies the type of the extension; an example is "CustomScriptExtension".
        :param str type_handler_version: Specifies the version of the script handler.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if statuses is not None:
            pulumi.set(__self__, "statuses", statuses)
        if substatuses is not None:
            pulumi.set(__self__, "substatuses", substatuses)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if type_handler_version is not None:
            pulumi.set(__self__, "type_handler_version", type_handler_version)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The virtual machine extension name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def statuses(self) -> Optional[Sequence['outputs.InstanceViewStatusResponse']]:
        """
        The resource status information.
        """
        return pulumi.get(self, "statuses")

    @property
    @pulumi.getter
    def substatuses(self) -> Optional[Sequence['outputs.InstanceViewStatusResponse']]:
        """
        The resource status information.
        """
        return pulumi.get(self, "substatuses")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Specifies the type of the extension; an example is "CustomScriptExtension".
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="typeHandlerVersion")
    def type_handler_version(self) -> Optional[str]:
        """
        Specifies the version of the script handler.
        """
        return pulumi.get(self, "type_handler_version")


@pulumi.output_type
class VirtualMachineExtensionResponse(dict):
    """
    Describes a Virtual Machine Extension.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "autoUpgradeMinorVersion":
            suggest = "auto_upgrade_minor_version"
        elif key == "forceUpdateTag":
            suggest = "force_update_tag"
        elif key == "instanceView":
            suggest = "instance_view"
        elif key == "protectedSettings":
            suggest = "protected_settings"
        elif key == "typeHandlerVersion":
            suggest = "type_handler_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineExtensionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineExtensionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineExtensionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 location: str,
                 name: str,
                 provisioning_state: str,
                 type: str,
                 auto_upgrade_minor_version: Optional[bool] = None,
                 force_update_tag: Optional[str] = None,
                 instance_view: Optional['outputs.VirtualMachineExtensionInstanceViewResponse'] = None,
                 protected_settings: Optional[Any] = None,
                 publisher: Optional[str] = None,
                 settings: Optional[Any] = None,
                 tags: Optional[Mapping[str, str]] = None,
                 type_handler_version: Optional[str] = None):
        """
        Describes a Virtual Machine Extension.
        :param str id: Resource Id
        :param str location: Resource location
        :param str name: Resource name
        :param str provisioning_state: The provisioning state, which only appears in the response.
        :param str type: Resource type
        :param bool auto_upgrade_minor_version: Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.
        :param str force_update_tag: How the extension handler should be forced to update even if the extension configuration has not changed.
        :param 'VirtualMachineExtensionInstanceViewResponse' instance_view: The virtual machine extension instance view.
        :param Any protected_settings: The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at all.
        :param str publisher: The name of the extension handler publisher.
        :param Any settings: Json formatted public settings for the extension.
        :param Mapping[str, str] tags: Resource tags
        :param str type_handler_version: Specifies the version of the script handler.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "type", type)
        if auto_upgrade_minor_version is not None:
            pulumi.set(__self__, "auto_upgrade_minor_version", auto_upgrade_minor_version)
        if force_update_tag is not None:
            pulumi.set(__self__, "force_update_tag", force_update_tag)
        if instance_view is not None:
            pulumi.set(__self__, "instance_view", instance_view)
        if protected_settings is not None:
            pulumi.set(__self__, "protected_settings", protected_settings)
        if publisher is not None:
            pulumi.set(__self__, "publisher", publisher)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type_handler_version is not None:
            pulumi.set(__self__, "type_handler_version", type_handler_version)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Resource location
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state, which only appears in the response.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="autoUpgradeMinorVersion")
    def auto_upgrade_minor_version(self) -> Optional[bool]:
        """
        Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.
        """
        return pulumi.get(self, "auto_upgrade_minor_version")

    @property
    @pulumi.getter(name="forceUpdateTag")
    def force_update_tag(self) -> Optional[str]:
        """
        How the extension handler should be forced to update even if the extension configuration has not changed.
        """
        return pulumi.get(self, "force_update_tag")

    @property
    @pulumi.getter(name="instanceView")
    def instance_view(self) -> Optional['outputs.VirtualMachineExtensionInstanceViewResponse']:
        """
        The virtual machine extension instance view.
        """
        return pulumi.get(self, "instance_view")

    @property
    @pulumi.getter(name="protectedSettings")
    def protected_settings(self) -> Optional[Any]:
        """
        The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at all.
        """
        return pulumi.get(self, "protected_settings")

    @property
    @pulumi.getter
    def publisher(self) -> Optional[str]:
        """
        The name of the extension handler publisher.
        """
        return pulumi.get(self, "publisher")

    @property
    @pulumi.getter
    def settings(self) -> Optional[Any]:
        """
        Json formatted public settings for the extension.
        """
        return pulumi.get(self, "settings")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="typeHandlerVersion")
    def type_handler_version(self) -> Optional[str]:
        """
        Specifies the version of the script handler.
        """
        return pulumi.get(self, "type_handler_version")


@pulumi.output_type
class VirtualMachineHealthStatusResponse(dict):
    """
    The health status of the VM.
    """
    def __init__(__self__, *,
                 status: 'outputs.InstanceViewStatusResponse'):
        """
        The health status of the VM.
        :param 'InstanceViewStatusResponse' status: The health status information for the VM.
        """
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def status(self) -> 'outputs.InstanceViewStatusResponse':
        """
        The health status information for the VM.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class VirtualMachineIdentityResponse(dict):
    """
    Identity for the virtual machine.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"
        elif key == "identityIds":
            suggest = "identity_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: str,
                 tenant_id: str,
                 identity_ids: Optional[Sequence[str]] = None,
                 type: Optional[str] = None):
        """
        Identity for the virtual machine.
        :param str principal_id: The principal id of virtual machine identity. This property will only be provided for a system assigned identity.
        :param str tenant_id: The tenant id associated with the virtual machine. This property will only be provided for a system assigned identity.
        :param Sequence[str] identity_ids: The list of user identities associated with the Virtual Machine. The user identity references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/identities/{identityName}'.
        :param str type: The type of identity used for the virtual machine. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user assigned identities. The type 'None' will remove any identities from the virtual machine.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal id of virtual machine identity. This property will only be provided for a system assigned identity.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The tenant id associated with the virtual machine. This property will only be provided for a system assigned identity.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[Sequence[str]]:
        """
        The list of user identities associated with the Virtual Machine. The user identity references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/identities/{identityName}'.
        """
        return pulumi.get(self, "identity_ids")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of identity used for the virtual machine. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user assigned identities. The type 'None' will remove any identities from the virtual machine.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class VirtualMachineInstanceViewResponse(dict):
    """
    The instance view of a virtual machine.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bootDiagnostics":
            suggest = "boot_diagnostics"
        elif key == "computerName":
            suggest = "computer_name"
        elif key == "maintenanceRedeployStatus":
            suggest = "maintenance_redeploy_status"
        elif key == "osName":
            suggest = "os_name"
        elif key == "osVersion":
            suggest = "os_version"
        elif key == "platformFaultDomain":
            suggest = "platform_fault_domain"
        elif key == "platformUpdateDomain":
            suggest = "platform_update_domain"
        elif key == "rdpThumbPrint":
            suggest = "rdp_thumb_print"
        elif key == "vmAgent":
            suggest = "vm_agent"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineInstanceViewResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineInstanceViewResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineInstanceViewResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 boot_diagnostics: Optional['outputs.BootDiagnosticsInstanceViewResponse'] = None,
                 computer_name: Optional[str] = None,
                 disks: Optional[Sequence['outputs.DiskInstanceViewResponse']] = None,
                 extensions: Optional[Sequence['outputs.VirtualMachineExtensionInstanceViewResponse']] = None,
                 maintenance_redeploy_status: Optional['outputs.MaintenanceRedeployStatusResponse'] = None,
                 os_name: Optional[str] = None,
                 os_version: Optional[str] = None,
                 platform_fault_domain: Optional[int] = None,
                 platform_update_domain: Optional[int] = None,
                 rdp_thumb_print: Optional[str] = None,
                 statuses: Optional[Sequence['outputs.InstanceViewStatusResponse']] = None,
                 vm_agent: Optional['outputs.VirtualMachineAgentInstanceViewResponse'] = None):
        """
        The instance view of a virtual machine.
        :param 'BootDiagnosticsInstanceViewResponse' boot_diagnostics: Boot Diagnostics is a debugging feature which allows you to view Console Output and Screenshot to diagnose VM status. <br><br> You can easily view the output of your console log. <br><br> Azure also enables you to see a screenshot of the VM from the hypervisor.
        :param str computer_name: The computer name assigned to the virtual machine.
        :param Sequence['DiskInstanceViewResponse'] disks: The virtual machine disk information.
        :param Sequence['VirtualMachineExtensionInstanceViewResponse'] extensions: The extensions information.
        :param 'MaintenanceRedeployStatusResponse' maintenance_redeploy_status: The Maintenance Operation status on the virtual machine.
        :param str os_name: The Operating System running on the virtual machine.
        :param str os_version: The version of Operating System running on the virtual machine.
        :param int platform_fault_domain: Specifies the fault domain of the virtual machine.
        :param int platform_update_domain: Specifies the update domain of the virtual machine.
        :param str rdp_thumb_print: The Remote desktop certificate thumbprint.
        :param Sequence['InstanceViewStatusResponse'] statuses: The resource status information.
        :param 'VirtualMachineAgentInstanceViewResponse' vm_agent: The VM Agent running on the virtual machine.
        """
        if boot_diagnostics is not None:
            pulumi.set(__self__, "boot_diagnostics", boot_diagnostics)
        if computer_name is not None:
            pulumi.set(__self__, "computer_name", computer_name)
        if disks is not None:
            pulumi.set(__self__, "disks", disks)
        if extensions is not None:
            pulumi.set(__self__, "extensions", extensions)
        if maintenance_redeploy_status is not None:
            pulumi.set(__self__, "maintenance_redeploy_status", maintenance_redeploy_status)
        if os_name is not None:
            pulumi.set(__self__, "os_name", os_name)
        if os_version is not None:
            pulumi.set(__self__, "os_version", os_version)
        if platform_fault_domain is not None:
            pulumi.set(__self__, "platform_fault_domain", platform_fault_domain)
        if platform_update_domain is not None:
            pulumi.set(__self__, "platform_update_domain", platform_update_domain)
        if rdp_thumb_print is not None:
            pulumi.set(__self__, "rdp_thumb_print", rdp_thumb_print)
        if statuses is not None:
            pulumi.set(__self__, "statuses", statuses)
        if vm_agent is not None:
            pulumi.set(__self__, "vm_agent", vm_agent)

    @property
    @pulumi.getter(name="bootDiagnostics")
    def boot_diagnostics(self) -> Optional['outputs.BootDiagnosticsInstanceViewResponse']:
        """
        Boot Diagnostics is a debugging feature which allows you to view Console Output and Screenshot to diagnose VM status. <br><br> You can easily view the output of your console log. <br><br> Azure also enables you to see a screenshot of the VM from the hypervisor.
        """
        return pulumi.get(self, "boot_diagnostics")

    @property
    @pulumi.getter(name="computerName")
    def computer_name(self) -> Optional[str]:
        """
        The computer name assigned to the virtual machine.
        """
        return pulumi.get(self, "computer_name")

    @property
    @pulumi.getter
    def disks(self) -> Optional[Sequence['outputs.DiskInstanceViewResponse']]:
        """
        The virtual machine disk information.
        """
        return pulumi.get(self, "disks")

    @property
    @pulumi.getter
    def extensions(self) -> Optional[Sequence['outputs.VirtualMachineExtensionInstanceViewResponse']]:
        """
        The extensions information.
        """
        return pulumi.get(self, "extensions")

    @property
    @pulumi.getter(name="maintenanceRedeployStatus")
    def maintenance_redeploy_status(self) -> Optional['outputs.MaintenanceRedeployStatusResponse']:
        """
        The Maintenance Operation status on the virtual machine.
        """
        return pulumi.get(self, "maintenance_redeploy_status")

    @property
    @pulumi.getter(name="osName")
    def os_name(self) -> Optional[str]:
        """
        The Operating System running on the virtual machine.
        """
        return pulumi.get(self, "os_name")

    @property
    @pulumi.getter(name="osVersion")
    def os_version(self) -> Optional[str]:
        """
        The version of Operating System running on the virtual machine.
        """
        return pulumi.get(self, "os_version")

    @property
    @pulumi.getter(name="platformFaultDomain")
    def platform_fault_domain(self) -> Optional[int]:
        """
        Specifies the fault domain of the virtual machine.
        """
        return pulumi.get(self, "platform_fault_domain")

    @property
    @pulumi.getter(name="platformUpdateDomain")
    def platform_update_domain(self) -> Optional[int]:
        """
        Specifies the update domain of the virtual machine.
        """
        return pulumi.get(self, "platform_update_domain")

    @property
    @pulumi.getter(name="rdpThumbPrint")
    def rdp_thumb_print(self) -> Optional[str]:
        """
        The Remote desktop certificate thumbprint.
        """
        return pulumi.get(self, "rdp_thumb_print")

    @property
    @pulumi.getter
    def statuses(self) -> Optional[Sequence['outputs.InstanceViewStatusResponse']]:
        """
        The resource status information.
        """
        return pulumi.get(self, "statuses")

    @property
    @pulumi.getter(name="vmAgent")
    def vm_agent(self) -> Optional['outputs.VirtualMachineAgentInstanceViewResponse']:
        """
        The VM Agent running on the virtual machine.
        """
        return pulumi.get(self, "vm_agent")


@pulumi.output_type
class VirtualMachineScaleSetDataDiskResponse(dict):
    """
    Describes a virtual machine scale set data disk.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createOption":
            suggest = "create_option"
        elif key == "diskSizeGB":
            suggest = "disk_size_gb"
        elif key == "managedDisk":
            suggest = "managed_disk"
        elif key == "writeAcceleratorEnabled":
            suggest = "write_accelerator_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineScaleSetDataDiskResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineScaleSetDataDiskResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineScaleSetDataDiskResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 create_option: str,
                 lun: int,
                 caching: Optional[str] = None,
                 disk_size_gb: Optional[int] = None,
                 managed_disk: Optional['outputs.VirtualMachineScaleSetManagedDiskParametersResponse'] = None,
                 name: Optional[str] = None,
                 write_accelerator_enabled: Optional[bool] = None):
        """
        Describes a virtual machine scale set data disk.
        :param str create_option: The create option.
        :param int lun: Specifies the logical unit number of the data disk. This value is used to identify data disks within the VM and therefore must be unique for each data disk attached to a VM.
        :param str caching: Specifies the caching requirements. <br><br> Possible values are: <br><br> **None** <br><br> **ReadOnly** <br><br> **ReadWrite** <br><br> Default: **None for Standard storage. ReadOnly for Premium storage**
        :param int disk_size_gb: Specifies the size of an empty data disk in gigabytes. This element can be used to overwrite the size of the disk in a virtual machine image. <br><br> This value cannot be larger than 1023 GB
        :param 'VirtualMachineScaleSetManagedDiskParametersResponse' managed_disk: The managed disk parameters.
        :param str name: The disk name.
        :param bool write_accelerator_enabled: Specifies whether writeAccelerator should be enabled or disabled on the disk.
        """
        pulumi.set(__self__, "create_option", create_option)
        pulumi.set(__self__, "lun", lun)
        if caching is not None:
            pulumi.set(__self__, "caching", caching)
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if managed_disk is not None:
            pulumi.set(__self__, "managed_disk", managed_disk)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if write_accelerator_enabled is not None:
            pulumi.set(__self__, "write_accelerator_enabled", write_accelerator_enabled)

    @property
    @pulumi.getter(name="createOption")
    def create_option(self) -> str:
        """
        The create option.
        """
        return pulumi.get(self, "create_option")

    @property
    @pulumi.getter
    def lun(self) -> int:
        """
        Specifies the logical unit number of the data disk. This value is used to identify data disks within the VM and therefore must be unique for each data disk attached to a VM.
        """
        return pulumi.get(self, "lun")

    @property
    @pulumi.getter
    def caching(self) -> Optional[str]:
        """
        Specifies the caching requirements. <br><br> Possible values are: <br><br> **None** <br><br> **ReadOnly** <br><br> **ReadWrite** <br><br> Default: **None for Standard storage. ReadOnly for Premium storage**
        """
        return pulumi.get(self, "caching")

    @property
    @pulumi.getter(name="diskSizeGB")
    def disk_size_gb(self) -> Optional[int]:
        """
        Specifies the size of an empty data disk in gigabytes. This element can be used to overwrite the size of the disk in a virtual machine image. <br><br> This value cannot be larger than 1023 GB
        """
        return pulumi.get(self, "disk_size_gb")

    @property
    @pulumi.getter(name="managedDisk")
    def managed_disk(self) -> Optional['outputs.VirtualMachineScaleSetManagedDiskParametersResponse']:
        """
        The managed disk parameters.
        """
        return pulumi.get(self, "managed_disk")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The disk name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="writeAcceleratorEnabled")
    def write_accelerator_enabled(self) -> Optional[bool]:
        """
        Specifies whether writeAccelerator should be enabled or disabled on the disk.
        """
        return pulumi.get(self, "write_accelerator_enabled")


@pulumi.output_type
class VirtualMachineScaleSetExtensionProfileResponse(dict):
    """
    Describes a virtual machine scale set extension profile.
    """
    def __init__(__self__, *,
                 extensions: Optional[Sequence['outputs.VirtualMachineScaleSetExtensionResponse']] = None):
        """
        Describes a virtual machine scale set extension profile.
        :param Sequence['VirtualMachineScaleSetExtensionResponse'] extensions: The virtual machine scale set child extension resources.
        """
        if extensions is not None:
            pulumi.set(__self__, "extensions", extensions)

    @property
    @pulumi.getter
    def extensions(self) -> Optional[Sequence['outputs.VirtualMachineScaleSetExtensionResponse']]:
        """
        The virtual machine scale set child extension resources.
        """
        return pulumi.get(self, "extensions")


@pulumi.output_type
class VirtualMachineScaleSetExtensionResponse(dict):
    """
    Describes a Virtual Machine Scale Set Extension.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "autoUpgradeMinorVersion":
            suggest = "auto_upgrade_minor_version"
        elif key == "forceUpdateTag":
            suggest = "force_update_tag"
        elif key == "protectedSettings":
            suggest = "protected_settings"
        elif key == "typeHandlerVersion":
            suggest = "type_handler_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineScaleSetExtensionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineScaleSetExtensionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineScaleSetExtensionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 provisioning_state: str,
                 auto_upgrade_minor_version: Optional[bool] = None,
                 force_update_tag: Optional[str] = None,
                 name: Optional[str] = None,
                 protected_settings: Optional[Any] = None,
                 publisher: Optional[str] = None,
                 settings: Optional[Any] = None,
                 type: Optional[str] = None,
                 type_handler_version: Optional[str] = None):
        """
        Describes a Virtual Machine Scale Set Extension.
        :param str id: Resource Id
        :param str provisioning_state: The provisioning state, which only appears in the response.
        :param bool auto_upgrade_minor_version: Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.
        :param str force_update_tag: If a value is provided and is different from the previous value, the extension handler will be forced to update even if the extension configuration has not changed.
        :param str name: The name of the extension.
        :param Any protected_settings: The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at all.
        :param str publisher: The name of the extension handler publisher.
        :param Any settings: Json formatted public settings for the extension.
        :param str type: Specifies the type of the extension; an example is "CustomScriptExtension".
        :param str type_handler_version: Specifies the version of the script handler.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if auto_upgrade_minor_version is not None:
            pulumi.set(__self__, "auto_upgrade_minor_version", auto_upgrade_minor_version)
        if force_update_tag is not None:
            pulumi.set(__self__, "force_update_tag", force_update_tag)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protected_settings is not None:
            pulumi.set(__self__, "protected_settings", protected_settings)
        if publisher is not None:
            pulumi.set(__self__, "publisher", publisher)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if type_handler_version is not None:
            pulumi.set(__self__, "type_handler_version", type_handler_version)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state, which only appears in the response.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="autoUpgradeMinorVersion")
    def auto_upgrade_minor_version(self) -> Optional[bool]:
        """
        Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.
        """
        return pulumi.get(self, "auto_upgrade_minor_version")

    @property
    @pulumi.getter(name="forceUpdateTag")
    def force_update_tag(self) -> Optional[str]:
        """
        If a value is provided and is different from the previous value, the extension handler will be forced to update even if the extension configuration has not changed.
        """
        return pulumi.get(self, "force_update_tag")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the extension.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="protectedSettings")
    def protected_settings(self) -> Optional[Any]:
        """
        The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at all.
        """
        return pulumi.get(self, "protected_settings")

    @property
    @pulumi.getter
    def publisher(self) -> Optional[str]:
        """
        The name of the extension handler publisher.
        """
        return pulumi.get(self, "publisher")

    @property
    @pulumi.getter
    def settings(self) -> Optional[Any]:
        """
        Json formatted public settings for the extension.
        """
        return pulumi.get(self, "settings")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Specifies the type of the extension; an example is "CustomScriptExtension".
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="typeHandlerVersion")
    def type_handler_version(self) -> Optional[str]:
        """
        Specifies the version of the script handler.
        """
        return pulumi.get(self, "type_handler_version")


@pulumi.output_type
class VirtualMachineScaleSetIPConfigurationResponse(dict):
    """
    Describes a virtual machine scale set network profile's IP configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applicationGatewayBackendAddressPools":
            suggest = "application_gateway_backend_address_pools"
        elif key == "loadBalancerBackendAddressPools":
            suggest = "load_balancer_backend_address_pools"
        elif key == "loadBalancerInboundNatPools":
            suggest = "load_balancer_inbound_nat_pools"
        elif key == "privateIPAddressVersion":
            suggest = "private_ip_address_version"
        elif key == "publicIPAddressConfiguration":
            suggest = "public_ip_address_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineScaleSetIPConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineScaleSetIPConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineScaleSetIPConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 application_gateway_backend_address_pools: Optional[Sequence['outputs.SubResourceResponse']] = None,
                 id: Optional[str] = None,
                 load_balancer_backend_address_pools: Optional[Sequence['outputs.SubResourceResponse']] = None,
                 load_balancer_inbound_nat_pools: Optional[Sequence['outputs.SubResourceResponse']] = None,
                 primary: Optional[bool] = None,
                 private_ip_address_version: Optional[str] = None,
                 public_ip_address_configuration: Optional['outputs.VirtualMachineScaleSetPublicIPAddressConfigurationResponse'] = None,
                 subnet: Optional['outputs.ApiEntityReferenceResponse'] = None):
        """
        Describes a virtual machine scale set network profile's IP configuration.
        :param str name: The IP configuration name.
        :param Sequence['SubResourceResponse'] application_gateway_backend_address_pools: Specifies an array of references to backend address pools of application gateways. A scale set can reference backend address pools of multiple application gateways. Multiple scale sets cannot use the same application gateway.
        :param str id: Resource Id
        :param Sequence['SubResourceResponse'] load_balancer_backend_address_pools: Specifies an array of references to backend address pools of load balancers. A scale set can reference backend address pools of one public and one internal load balancer. Multiple scale sets cannot use the same load balancer.
        :param Sequence['SubResourceResponse'] load_balancer_inbound_nat_pools: Specifies an array of references to inbound Nat pools of the load balancers. A scale set can reference inbound nat pools of one public and one internal load balancer. Multiple scale sets cannot use the same load balancer
        :param bool primary: Specifies the primary network interface in case the virtual machine has more than 1 network interface.
        :param str private_ip_address_version: Available from Api-Version 2017-03-30 onwards, it represents whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.  Possible values are: 'IPv4' and 'IPv6'.
        :param 'VirtualMachineScaleSetPublicIPAddressConfigurationResponse' public_ip_address_configuration: The publicIPAddressConfiguration.
        :param 'ApiEntityReferenceResponse' subnet: Specifies the identifier of the subnet.
        """
        pulumi.set(__self__, "name", name)
        if application_gateway_backend_address_pools is not None:
            pulumi.set(__self__, "application_gateway_backend_address_pools", application_gateway_backend_address_pools)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if load_balancer_backend_address_pools is not None:
            pulumi.set(__self__, "load_balancer_backend_address_pools", load_balancer_backend_address_pools)
        if load_balancer_inbound_nat_pools is not None:
            pulumi.set(__self__, "load_balancer_inbound_nat_pools", load_balancer_inbound_nat_pools)
        if primary is not None:
            pulumi.set(__self__, "primary", primary)
        if private_ip_address_version is not None:
            pulumi.set(__self__, "private_ip_address_version", private_ip_address_version)
        if public_ip_address_configuration is not None:
            pulumi.set(__self__, "public_ip_address_configuration", public_ip_address_configuration)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The IP configuration name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="applicationGatewayBackendAddressPools")
    def application_gateway_backend_address_pools(self) -> Optional[Sequence['outputs.SubResourceResponse']]:
        """
        Specifies an array of references to backend address pools of application gateways. A scale set can reference backend address pools of multiple application gateways. Multiple scale sets cannot use the same application gateway.
        """
        return pulumi.get(self, "application_gateway_backend_address_pools")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="loadBalancerBackendAddressPools")
    def load_balancer_backend_address_pools(self) -> Optional[Sequence['outputs.SubResourceResponse']]:
        """
        Specifies an array of references to backend address pools of load balancers. A scale set can reference backend address pools of one public and one internal load balancer. Multiple scale sets cannot use the same load balancer.
        """
        return pulumi.get(self, "load_balancer_backend_address_pools")

    @property
    @pulumi.getter(name="loadBalancerInboundNatPools")
    def load_balancer_inbound_nat_pools(self) -> Optional[Sequence['outputs.SubResourceResponse']]:
        """
        Specifies an array of references to inbound Nat pools of the load balancers. A scale set can reference inbound nat pools of one public and one internal load balancer. Multiple scale sets cannot use the same load balancer
        """
        return pulumi.get(self, "load_balancer_inbound_nat_pools")

    @property
    @pulumi.getter
    def primary(self) -> Optional[bool]:
        """
        Specifies the primary network interface in case the virtual machine has more than 1 network interface.
        """
        return pulumi.get(self, "primary")

    @property
    @pulumi.getter(name="privateIPAddressVersion")
    def private_ip_address_version(self) -> Optional[str]:
        """
        Available from Api-Version 2017-03-30 onwards, it represents whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.  Possible values are: 'IPv4' and 'IPv6'.
        """
        return pulumi.get(self, "private_ip_address_version")

    @property
    @pulumi.getter(name="publicIPAddressConfiguration")
    def public_ip_address_configuration(self) -> Optional['outputs.VirtualMachineScaleSetPublicIPAddressConfigurationResponse']:
        """
        The publicIPAddressConfiguration.
        """
        return pulumi.get(self, "public_ip_address_configuration")

    @property
    @pulumi.getter
    def subnet(self) -> Optional['outputs.ApiEntityReferenceResponse']:
        """
        Specifies the identifier of the subnet.
        """
        return pulumi.get(self, "subnet")


@pulumi.output_type
class VirtualMachineScaleSetIdentityResponse(dict):
    """
    Identity for the virtual machine scale set.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"
        elif key == "identityIds":
            suggest = "identity_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineScaleSetIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineScaleSetIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineScaleSetIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: str,
                 tenant_id: str,
                 identity_ids: Optional[Sequence[str]] = None,
                 type: Optional[str] = None):
        """
        Identity for the virtual machine scale set.
        :param str principal_id: The principal id of virtual machine scale set identity. This property will only be provided for a system assigned identity.
        :param str tenant_id: The tenant id associated with the virtual machine scale set. This property will only be provided for a system assigned identity.
        :param Sequence[str] identity_ids: The list of user identities associated with the virtual machine scale set. The user identity references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/identities/{identityName}'.
        :param str type: The type of identity used for the virtual machine scale set. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user assigned identities. The type 'None' will remove any identities from the virtual machine scale set.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal id of virtual machine scale set identity. This property will only be provided for a system assigned identity.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The tenant id associated with the virtual machine scale set. This property will only be provided for a system assigned identity.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[Sequence[str]]:
        """
        The list of user identities associated with the virtual machine scale set. The user identity references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/identities/{identityName}'.
        """
        return pulumi.get(self, "identity_ids")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of identity used for the virtual machine scale set. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user assigned identities. The type 'None' will remove any identities from the virtual machine scale set.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class VirtualMachineScaleSetManagedDiskParametersResponse(dict):
    """
    Describes the parameters of a ScaleSet managed disk.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageAccountType":
            suggest = "storage_account_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineScaleSetManagedDiskParametersResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineScaleSetManagedDiskParametersResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineScaleSetManagedDiskParametersResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 storage_account_type: Optional[str] = None):
        """
        Describes the parameters of a ScaleSet managed disk.
        :param str storage_account_type: Specifies the storage account type for the managed disk. Managed OS disk storage account type can only be set when you create the scale set. Possible values are: Standard_LRS or Premium_LRS.
        """
        if storage_account_type is not None:
            pulumi.set(__self__, "storage_account_type", storage_account_type)

    @property
    @pulumi.getter(name="storageAccountType")
    def storage_account_type(self) -> Optional[str]:
        """
        Specifies the storage account type for the managed disk. Managed OS disk storage account type can only be set when you create the scale set. Possible values are: Standard_LRS or Premium_LRS.
        """
        return pulumi.get(self, "storage_account_type")


@pulumi.output_type
class VirtualMachineScaleSetNetworkConfigurationDnsSettingsResponse(dict):
    """
    Describes a virtual machines scale sets network configuration's DNS settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsServers":
            suggest = "dns_servers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineScaleSetNetworkConfigurationDnsSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineScaleSetNetworkConfigurationDnsSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineScaleSetNetworkConfigurationDnsSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dns_servers: Optional[Sequence[str]] = None):
        """
        Describes a virtual machines scale sets network configuration's DNS settings.
        :param Sequence[str] dns_servers: List of DNS servers IP addresses
        """
        if dns_servers is not None:
            pulumi.set(__self__, "dns_servers", dns_servers)

    @property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> Optional[Sequence[str]]:
        """
        List of DNS servers IP addresses
        """
        return pulumi.get(self, "dns_servers")


@pulumi.output_type
class VirtualMachineScaleSetNetworkConfigurationResponse(dict):
    """
    Describes a virtual machine scale set network profile's network configurations.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipConfigurations":
            suggest = "ip_configurations"
        elif key == "dnsSettings":
            suggest = "dns_settings"
        elif key == "enableAcceleratedNetworking":
            suggest = "enable_accelerated_networking"
        elif key == "enableIPForwarding":
            suggest = "enable_ip_forwarding"
        elif key == "networkSecurityGroup":
            suggest = "network_security_group"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineScaleSetNetworkConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineScaleSetNetworkConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineScaleSetNetworkConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_configurations: Sequence['outputs.VirtualMachineScaleSetIPConfigurationResponse'],
                 name: str,
                 dns_settings: Optional['outputs.VirtualMachineScaleSetNetworkConfigurationDnsSettingsResponse'] = None,
                 enable_accelerated_networking: Optional[bool] = None,
                 enable_ip_forwarding: Optional[bool] = None,
                 id: Optional[str] = None,
                 network_security_group: Optional['outputs.SubResourceResponse'] = None,
                 primary: Optional[bool] = None):
        """
        Describes a virtual machine scale set network profile's network configurations.
        :param Sequence['VirtualMachineScaleSetIPConfigurationResponse'] ip_configurations: Specifies the IP configurations of the network interface.
        :param str name: The network configuration name.
        :param 'VirtualMachineScaleSetNetworkConfigurationDnsSettingsResponse' dns_settings: The dns settings to be applied on the network interfaces.
        :param bool enable_accelerated_networking: Specifies whether the network interface is accelerated networking-enabled.
        :param bool enable_ip_forwarding: Whether IP forwarding enabled on this NIC.
        :param str id: Resource Id
        :param 'SubResourceResponse' network_security_group: The network security group.
        :param bool primary: Specifies the primary network interface in case the virtual machine has more than 1 network interface.
        """
        pulumi.set(__self__, "ip_configurations", ip_configurations)
        pulumi.set(__self__, "name", name)
        if dns_settings is not None:
            pulumi.set(__self__, "dns_settings", dns_settings)
        if enable_accelerated_networking is not None:
            pulumi.set(__self__, "enable_accelerated_networking", enable_accelerated_networking)
        if enable_ip_forwarding is not None:
            pulumi.set(__self__, "enable_ip_forwarding", enable_ip_forwarding)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if network_security_group is not None:
            pulumi.set(__self__, "network_security_group", network_security_group)
        if primary is not None:
            pulumi.set(__self__, "primary", primary)

    @property
    @pulumi.getter(name="ipConfigurations")
    def ip_configurations(self) -> Sequence['outputs.VirtualMachineScaleSetIPConfigurationResponse']:
        """
        Specifies the IP configurations of the network interface.
        """
        return pulumi.get(self, "ip_configurations")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The network configuration name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="dnsSettings")
    def dns_settings(self) -> Optional['outputs.VirtualMachineScaleSetNetworkConfigurationDnsSettingsResponse']:
        """
        The dns settings to be applied on the network interfaces.
        """
        return pulumi.get(self, "dns_settings")

    @property
    @pulumi.getter(name="enableAcceleratedNetworking")
    def enable_accelerated_networking(self) -> Optional[bool]:
        """
        Specifies whether the network interface is accelerated networking-enabled.
        """
        return pulumi.get(self, "enable_accelerated_networking")

    @property
    @pulumi.getter(name="enableIPForwarding")
    def enable_ip_forwarding(self) -> Optional[bool]:
        """
        Whether IP forwarding enabled on this NIC.
        """
        return pulumi.get(self, "enable_ip_forwarding")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="networkSecurityGroup")
    def network_security_group(self) -> Optional['outputs.SubResourceResponse']:
        """
        The network security group.
        """
        return pulumi.get(self, "network_security_group")

    @property
    @pulumi.getter
    def primary(self) -> Optional[bool]:
        """
        Specifies the primary network interface in case the virtual machine has more than 1 network interface.
        """
        return pulumi.get(self, "primary")


@pulumi.output_type
class VirtualMachineScaleSetNetworkProfileResponse(dict):
    """
    Describes a virtual machine scale set network profile.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "healthProbe":
            suggest = "health_probe"
        elif key == "networkInterfaceConfigurations":
            suggest = "network_interface_configurations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineScaleSetNetworkProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineScaleSetNetworkProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineScaleSetNetworkProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 health_probe: Optional['outputs.ApiEntityReferenceResponse'] = None,
                 network_interface_configurations: Optional[Sequence['outputs.VirtualMachineScaleSetNetworkConfigurationResponse']] = None):
        """
        Describes a virtual machine scale set network profile.
        :param 'ApiEntityReferenceResponse' health_probe: A reference to a load balancer probe used to determine the health of an instance in the virtual machine scale set. The reference will be in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/probes/{probeName}'.
        :param Sequence['VirtualMachineScaleSetNetworkConfigurationResponse'] network_interface_configurations: The list of network configurations.
        """
        if health_probe is not None:
            pulumi.set(__self__, "health_probe", health_probe)
        if network_interface_configurations is not None:
            pulumi.set(__self__, "network_interface_configurations", network_interface_configurations)

    @property
    @pulumi.getter(name="healthProbe")
    def health_probe(self) -> Optional['outputs.ApiEntityReferenceResponse']:
        """
        A reference to a load balancer probe used to determine the health of an instance in the virtual machine scale set. The reference will be in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/probes/{probeName}'.
        """
        return pulumi.get(self, "health_probe")

    @property
    @pulumi.getter(name="networkInterfaceConfigurations")
    def network_interface_configurations(self) -> Optional[Sequence['outputs.VirtualMachineScaleSetNetworkConfigurationResponse']]:
        """
        The list of network configurations.
        """
        return pulumi.get(self, "network_interface_configurations")


@pulumi.output_type
class VirtualMachineScaleSetOSDiskResponse(dict):
    """
    Describes a virtual machine scale set operating system disk.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createOption":
            suggest = "create_option"
        elif key == "managedDisk":
            suggest = "managed_disk"
        elif key == "osType":
            suggest = "os_type"
        elif key == "vhdContainers":
            suggest = "vhd_containers"
        elif key == "writeAcceleratorEnabled":
            suggest = "write_accelerator_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineScaleSetOSDiskResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineScaleSetOSDiskResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineScaleSetOSDiskResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 create_option: str,
                 caching: Optional[str] = None,
                 image: Optional['outputs.VirtualHardDiskResponse'] = None,
                 managed_disk: Optional['outputs.VirtualMachineScaleSetManagedDiskParametersResponse'] = None,
                 name: Optional[str] = None,
                 os_type: Optional[str] = None,
                 vhd_containers: Optional[Sequence[str]] = None,
                 write_accelerator_enabled: Optional[bool] = None):
        """
        Describes a virtual machine scale set operating system disk.
        :param str create_option: Specifies how the virtual machines in the scale set should be created.<br><br> The only allowed value is: **FromImage** \u2013 This value is used when you are using an image to create the virtual machine. If you are using a platform image, you also use the imageReference element described above. If you are using a marketplace image, you  also use the plan element previously described.
        :param str caching: Specifies the caching requirements. <br><br> Possible values are: <br><br> **None** <br><br> **ReadOnly** <br><br> **ReadWrite** <br><br> Default: **None for Standard storage. ReadOnly for Premium storage**
        :param 'VirtualHardDiskResponse' image: Specifies information about the unmanaged user image to base the scale set on.
        :param 'VirtualMachineScaleSetManagedDiskParametersResponse' managed_disk: The managed disk parameters.
        :param str name: The disk name.
        :param str os_type: This property allows you to specify the type of the OS that is included in the disk if creating a VM from user-image or a specialized VHD. <br><br> Possible values are: <br><br> **Windows** <br><br> **Linux**
        :param Sequence[str] vhd_containers: Specifies the container urls that are used to store operating system disks for the scale set.
        :param bool write_accelerator_enabled: Specifies whether writeAccelerator should be enabled or disabled on the disk.
        """
        pulumi.set(__self__, "create_option", create_option)
        if caching is not None:
            pulumi.set(__self__, "caching", caching)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if managed_disk is not None:
            pulumi.set(__self__, "managed_disk", managed_disk)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if vhd_containers is not None:
            pulumi.set(__self__, "vhd_containers", vhd_containers)
        if write_accelerator_enabled is not None:
            pulumi.set(__self__, "write_accelerator_enabled", write_accelerator_enabled)

    @property
    @pulumi.getter(name="createOption")
    def create_option(self) -> str:
        """
        Specifies how the virtual machines in the scale set should be created.<br><br> The only allowed value is: **FromImage** \u2013 This value is used when you are using an image to create the virtual machine. If you are using a platform image, you also use the imageReference element described above. If you are using a marketplace image, you  also use the plan element previously described.
        """
        return pulumi.get(self, "create_option")

    @property
    @pulumi.getter
    def caching(self) -> Optional[str]:
        """
        Specifies the caching requirements. <br><br> Possible values are: <br><br> **None** <br><br> **ReadOnly** <br><br> **ReadWrite** <br><br> Default: **None for Standard storage. ReadOnly for Premium storage**
        """
        return pulumi.get(self, "caching")

    @property
    @pulumi.getter
    def image(self) -> Optional['outputs.VirtualHardDiskResponse']:
        """
        Specifies information about the unmanaged user image to base the scale set on.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="managedDisk")
    def managed_disk(self) -> Optional['outputs.VirtualMachineScaleSetManagedDiskParametersResponse']:
        """
        The managed disk parameters.
        """
        return pulumi.get(self, "managed_disk")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The disk name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[str]:
        """
        This property allows you to specify the type of the OS that is included in the disk if creating a VM from user-image or a specialized VHD. <br><br> Possible values are: <br><br> **Windows** <br><br> **Linux**
        """
        return pulumi.get(self, "os_type")

    @property
    @pulumi.getter(name="vhdContainers")
    def vhd_containers(self) -> Optional[Sequence[str]]:
        """
        Specifies the container urls that are used to store operating system disks for the scale set.
        """
        return pulumi.get(self, "vhd_containers")

    @property
    @pulumi.getter(name="writeAcceleratorEnabled")
    def write_accelerator_enabled(self) -> Optional[bool]:
        """
        Specifies whether writeAccelerator should be enabled or disabled on the disk.
        """
        return pulumi.get(self, "write_accelerator_enabled")


@pulumi.output_type
class VirtualMachineScaleSetOSProfileResponse(dict):
    """
    Describes a virtual machine scale set OS profile.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adminPassword":
            suggest = "admin_password"
        elif key == "adminUsername":
            suggest = "admin_username"
        elif key == "computerNamePrefix":
            suggest = "computer_name_prefix"
        elif key == "customData":
            suggest = "custom_data"
        elif key == "linuxConfiguration":
            suggest = "linux_configuration"
        elif key == "windowsConfiguration":
            suggest = "windows_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineScaleSetOSProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineScaleSetOSProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineScaleSetOSProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 admin_password: Optional[str] = None,
                 admin_username: Optional[str] = None,
                 computer_name_prefix: Optional[str] = None,
                 custom_data: Optional[str] = None,
                 linux_configuration: Optional['outputs.LinuxConfigurationResponse'] = None,
                 secrets: Optional[Sequence['outputs.VaultSecretGroupResponse']] = None,
                 windows_configuration: Optional['outputs.WindowsConfigurationResponse'] = None):
        """
        Describes a virtual machine scale set OS profile.
        :param str admin_password: Specifies the password of the administrator account. <br><br> **Minimum-length (Windows):** 8 characters <br><br> **Minimum-length (Linux):** 6 characters <br><br> **Max-length (Windows):** 123 characters <br><br> **Max-length (Linux):** 72 characters <br><br> **Complexity requirements:** 3 out of 4 conditions below need to be fulfilled <br> Has lower characters <br>Has upper characters <br> Has a digit <br> Has a special character (Regex match [\W_]) <br><br> **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1", "Password22", "iloveyou!" <br><br> For resetting the password, see [How to reset the Remote Desktop service or its login password in a Windows VM](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-reset-rdp?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json) <br><br> For resetting root password, see [Manage users, SSH, and check or repair disks on Azure Linux VMs using the VMAccess Extension](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-using-vmaccess-extension?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json#reset-root-password)
        :param str admin_username: Specifies the name of the administrator account. <br><br> **Windows-only restriction:** Cannot end in "." <br><br> **Disallowed values:** "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest", "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5". <br><br> **Minimum-length (Linux):** 1  character <br><br> **Max-length (Linux):** 64 characters <br><br> **Max-length (Windows):** 20 characters  <br><br><li> For root access to the Linux VM, see [Using root privileges on Linux virtual machines in Azure](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-use-root-privileges?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json)<br><li> For a list of built-in system users on Linux that should not be used in this field, see [Selecting User Names for Linux on Azure](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-usernames?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json)
        :param str computer_name_prefix: Specifies the computer name prefix for all of the virtual machines in the scale set. Computer name prefixes must be 1 to 15 characters long.
        :param str custom_data: Specifies a base-64 encoded string of custom data. The base-64 encoded string is decoded to a binary array that is saved as a file on the Virtual Machine. The maximum length of the binary array is 65535 bytes. <br><br> For using cloud-init for your VM, see [Using cloud-init to customize a Linux VM during creation](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-using-cloud-init?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json)
        :param 'LinuxConfigurationResponse' linux_configuration: Specifies the Linux operating system settings on the virtual machine. <br><br>For a list of supported Linux distributions, see [Linux on Azure-Endorsed Distributions](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-endorsed-distros?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json) <br><br> For running non-endorsed distributions, see [Information for Non-Endorsed Distributions](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-create-upload-generic?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json).
        :param Sequence['VaultSecretGroupResponse'] secrets: Specifies set of certificates that should be installed onto the virtual machines in the scale set.
        :param 'WindowsConfigurationResponse' windows_configuration: Specifies Windows operating system settings on the virtual machine.
        """
        if admin_password is not None:
            pulumi.set(__self__, "admin_password", admin_password)
        if admin_username is not None:
            pulumi.set(__self__, "admin_username", admin_username)
        if computer_name_prefix is not None:
            pulumi.set(__self__, "computer_name_prefix", computer_name_prefix)
        if custom_data is not None:
            pulumi.set(__self__, "custom_data", custom_data)
        if linux_configuration is not None:
            pulumi.set(__self__, "linux_configuration", linux_configuration)
        if secrets is not None:
            pulumi.set(__self__, "secrets", secrets)
        if windows_configuration is not None:
            pulumi.set(__self__, "windows_configuration", windows_configuration)

    @property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> Optional[str]:
        """
        Specifies the password of the administrator account. <br><br> **Minimum-length (Windows):** 8 characters <br><br> **Minimum-length (Linux):** 6 characters <br><br> **Max-length (Windows):** 123 characters <br><br> **Max-length (Linux):** 72 characters <br><br> **Complexity requirements:** 3 out of 4 conditions below need to be fulfilled <br> Has lower characters <br>Has upper characters <br> Has a digit <br> Has a special character (Regex match [\W_]) <br><br> **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1", "Password22", "iloveyou!" <br><br> For resetting the password, see [How to reset the Remote Desktop service or its login password in a Windows VM](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-reset-rdp?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json) <br><br> For resetting root password, see [Manage users, SSH, and check or repair disks on Azure Linux VMs using the VMAccess Extension](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-using-vmaccess-extension?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json#reset-root-password)
        """
        return pulumi.get(self, "admin_password")

    @property
    @pulumi.getter(name="adminUsername")
    def admin_username(self) -> Optional[str]:
        """
        Specifies the name of the administrator account. <br><br> **Windows-only restriction:** Cannot end in "." <br><br> **Disallowed values:** "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest", "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5". <br><br> **Minimum-length (Linux):** 1  character <br><br> **Max-length (Linux):** 64 characters <br><br> **Max-length (Windows):** 20 characters  <br><br><li> For root access to the Linux VM, see [Using root privileges on Linux virtual machines in Azure](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-use-root-privileges?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json)<br><li> For a list of built-in system users on Linux that should not be used in this field, see [Selecting User Names for Linux on Azure](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-usernames?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json)
        """
        return pulumi.get(self, "admin_username")

    @property
    @pulumi.getter(name="computerNamePrefix")
    def computer_name_prefix(self) -> Optional[str]:
        """
        Specifies the computer name prefix for all of the virtual machines in the scale set. Computer name prefixes must be 1 to 15 characters long.
        """
        return pulumi.get(self, "computer_name_prefix")

    @property
    @pulumi.getter(name="customData")
    def custom_data(self) -> Optional[str]:
        """
        Specifies a base-64 encoded string of custom data. The base-64 encoded string is decoded to a binary array that is saved as a file on the Virtual Machine. The maximum length of the binary array is 65535 bytes. <br><br> For using cloud-init for your VM, see [Using cloud-init to customize a Linux VM during creation](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-using-cloud-init?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json)
        """
        return pulumi.get(self, "custom_data")

    @property
    @pulumi.getter(name="linuxConfiguration")
    def linux_configuration(self) -> Optional['outputs.LinuxConfigurationResponse']:
        """
        Specifies the Linux operating system settings on the virtual machine. <br><br>For a list of supported Linux distributions, see [Linux on Azure-Endorsed Distributions](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-endorsed-distros?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json) <br><br> For running non-endorsed distributions, see [Information for Non-Endorsed Distributions](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-create-upload-generic?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json).
        """
        return pulumi.get(self, "linux_configuration")

    @property
    @pulumi.getter
    def secrets(self) -> Optional[Sequence['outputs.VaultSecretGroupResponse']]:
        """
        Specifies set of certificates that should be installed onto the virtual machines in the scale set.
        """
        return pulumi.get(self, "secrets")

    @property
    @pulumi.getter(name="windowsConfiguration")
    def windows_configuration(self) -> Optional['outputs.WindowsConfigurationResponse']:
        """
        Specifies Windows operating system settings on the virtual machine.
        """
        return pulumi.get(self, "windows_configuration")


@pulumi.output_type
class VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettingsResponse(dict):
    """
    Describes a virtual machines scale sets network configuration's DNS settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainNameLabel":
            suggest = "domain_name_label"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain_name_label: str):
        """
        Describes a virtual machines scale sets network configuration's DNS settings.
        :param str domain_name_label: The Domain name label.The concatenation of the domain name label and vm index will be the domain name labels of the PublicIPAddress resources that will be created
        """
        pulumi.set(__self__, "domain_name_label", domain_name_label)

    @property
    @pulumi.getter(name="domainNameLabel")
    def domain_name_label(self) -> str:
        """
        The Domain name label.The concatenation of the domain name label and vm index will be the domain name labels of the PublicIPAddress resources that will be created
        """
        return pulumi.get(self, "domain_name_label")


@pulumi.output_type
class VirtualMachineScaleSetPublicIPAddressConfigurationResponse(dict):
    """
    Describes a virtual machines scale set IP Configuration's PublicIPAddress configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsSettings":
            suggest = "dns_settings"
        elif key == "idleTimeoutInMinutes":
            suggest = "idle_timeout_in_minutes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineScaleSetPublicIPAddressConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineScaleSetPublicIPAddressConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineScaleSetPublicIPAddressConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 dns_settings: Optional['outputs.VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettingsResponse'] = None,
                 idle_timeout_in_minutes: Optional[int] = None):
        """
        Describes a virtual machines scale set IP Configuration's PublicIPAddress configuration
        :param str name: The publicIP address configuration name.
        :param 'VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettingsResponse' dns_settings: The dns settings to be applied on the publicIP addresses .
        :param int idle_timeout_in_minutes: The idle timeout of the public IP address.
        """
        pulumi.set(__self__, "name", name)
        if dns_settings is not None:
            pulumi.set(__self__, "dns_settings", dns_settings)
        if idle_timeout_in_minutes is not None:
            pulumi.set(__self__, "idle_timeout_in_minutes", idle_timeout_in_minutes)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The publicIP address configuration name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="dnsSettings")
    def dns_settings(self) -> Optional['outputs.VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettingsResponse']:
        """
        The dns settings to be applied on the publicIP addresses .
        """
        return pulumi.get(self, "dns_settings")

    @property
    @pulumi.getter(name="idleTimeoutInMinutes")
    def idle_timeout_in_minutes(self) -> Optional[int]:
        """
        The idle timeout of the public IP address.
        """
        return pulumi.get(self, "idle_timeout_in_minutes")


@pulumi.output_type
class VirtualMachineScaleSetStorageProfileResponse(dict):
    """
    Describes a virtual machine scale set storage profile.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataDisks":
            suggest = "data_disks"
        elif key == "imageReference":
            suggest = "image_reference"
        elif key == "osDisk":
            suggest = "os_disk"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineScaleSetStorageProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineScaleSetStorageProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineScaleSetStorageProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_disks: Optional[Sequence['outputs.VirtualMachineScaleSetDataDiskResponse']] = None,
                 image_reference: Optional['outputs.ImageReferenceResponse'] = None,
                 os_disk: Optional['outputs.VirtualMachineScaleSetOSDiskResponse'] = None):
        """
        Describes a virtual machine scale set storage profile.
        :param Sequence['VirtualMachineScaleSetDataDiskResponse'] data_disks: Specifies the parameters that are used to add data disks to the virtual machines in the scale set. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json).
        :param 'ImageReferenceResponse' image_reference: Specifies information about the image to use. You can specify information about platform images, marketplace images, or virtual machine images. This element is required when you want to use a platform image, marketplace image, or virtual machine image, but is not used in other creation operations.
        :param 'VirtualMachineScaleSetOSDiskResponse' os_disk: Specifies information about the operating system disk used by the virtual machines in the scale set. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json).
        """
        if data_disks is not None:
            pulumi.set(__self__, "data_disks", data_disks)
        if image_reference is not None:
            pulumi.set(__self__, "image_reference", image_reference)
        if os_disk is not None:
            pulumi.set(__self__, "os_disk", os_disk)

    @property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Optional[Sequence['outputs.VirtualMachineScaleSetDataDiskResponse']]:
        """
        Specifies the parameters that are used to add data disks to the virtual machines in the scale set. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json).
        """
        return pulumi.get(self, "data_disks")

    @property
    @pulumi.getter(name="imageReference")
    def image_reference(self) -> Optional['outputs.ImageReferenceResponse']:
        """
        Specifies information about the image to use. You can specify information about platform images, marketplace images, or virtual machine images. This element is required when you want to use a platform image, marketplace image, or virtual machine image, but is not used in other creation operations.
        """
        return pulumi.get(self, "image_reference")

    @property
    @pulumi.getter(name="osDisk")
    def os_disk(self) -> Optional['outputs.VirtualMachineScaleSetOSDiskResponse']:
        """
        Specifies information about the operating system disk used by the virtual machines in the scale set. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json).
        """
        return pulumi.get(self, "os_disk")


@pulumi.output_type
class VirtualMachineScaleSetVMInstanceViewResponse(dict):
    """
    The instance view of a virtual machine scale set VM.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "vmHealth":
            suggest = "vm_health"
        elif key == "bootDiagnostics":
            suggest = "boot_diagnostics"
        elif key == "maintenanceRedeployStatus":
            suggest = "maintenance_redeploy_status"
        elif key == "placementGroupId":
            suggest = "placement_group_id"
        elif key == "platformFaultDomain":
            suggest = "platform_fault_domain"
        elif key == "platformUpdateDomain":
            suggest = "platform_update_domain"
        elif key == "rdpThumbPrint":
            suggest = "rdp_thumb_print"
        elif key == "vmAgent":
            suggest = "vm_agent"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineScaleSetVMInstanceViewResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineScaleSetVMInstanceViewResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineScaleSetVMInstanceViewResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 vm_health: 'outputs.VirtualMachineHealthStatusResponse',
                 boot_diagnostics: Optional['outputs.BootDiagnosticsInstanceViewResponse'] = None,
                 disks: Optional[Sequence['outputs.DiskInstanceViewResponse']] = None,
                 extensions: Optional[Sequence['outputs.VirtualMachineExtensionInstanceViewResponse']] = None,
                 maintenance_redeploy_status: Optional['outputs.MaintenanceRedeployStatusResponse'] = None,
                 placement_group_id: Optional[str] = None,
                 platform_fault_domain: Optional[int] = None,
                 platform_update_domain: Optional[int] = None,
                 rdp_thumb_print: Optional[str] = None,
                 statuses: Optional[Sequence['outputs.InstanceViewStatusResponse']] = None,
                 vm_agent: Optional['outputs.VirtualMachineAgentInstanceViewResponse'] = None):
        """
        The instance view of a virtual machine scale set VM.
        :param 'VirtualMachineHealthStatusResponse' vm_health: The health status for the VM.
        :param 'BootDiagnosticsInstanceViewResponse' boot_diagnostics: Boot Diagnostics is a debugging feature which allows you to view Console Output and Screenshot to diagnose VM status. <br><br> You can easily view the output of your console log. <br><br> Azure also enables you to see a screenshot of the VM from the hypervisor.
        :param Sequence['DiskInstanceViewResponse'] disks: The disks information.
        :param Sequence['VirtualMachineExtensionInstanceViewResponse'] extensions: The extensions information.
        :param 'MaintenanceRedeployStatusResponse' maintenance_redeploy_status: The Maintenance Operation status on the virtual machine.
        :param str placement_group_id: The placement group in which the VM is running. If the VM is deallocated it will not have a placementGroupId.
        :param int platform_fault_domain: The Fault Domain count.
        :param int platform_update_domain: The Update Domain count.
        :param str rdp_thumb_print: The Remote desktop certificate thumbprint.
        :param Sequence['InstanceViewStatusResponse'] statuses: The resource status information.
        :param 'VirtualMachineAgentInstanceViewResponse' vm_agent: The VM Agent running on the virtual machine.
        """
        pulumi.set(__self__, "vm_health", vm_health)
        if boot_diagnostics is not None:
            pulumi.set(__self__, "boot_diagnostics", boot_diagnostics)
        if disks is not None:
            pulumi.set(__self__, "disks", disks)
        if extensions is not None:
            pulumi.set(__self__, "extensions", extensions)
        if maintenance_redeploy_status is not None:
            pulumi.set(__self__, "maintenance_redeploy_status", maintenance_redeploy_status)
        if placement_group_id is not None:
            pulumi.set(__self__, "placement_group_id", placement_group_id)
        if platform_fault_domain is not None:
            pulumi.set(__self__, "platform_fault_domain", platform_fault_domain)
        if platform_update_domain is not None:
            pulumi.set(__self__, "platform_update_domain", platform_update_domain)
        if rdp_thumb_print is not None:
            pulumi.set(__self__, "rdp_thumb_print", rdp_thumb_print)
        if statuses is not None:
            pulumi.set(__self__, "statuses", statuses)
        if vm_agent is not None:
            pulumi.set(__self__, "vm_agent", vm_agent)

    @property
    @pulumi.getter(name="vmHealth")
    def vm_health(self) -> 'outputs.VirtualMachineHealthStatusResponse':
        """
        The health status for the VM.
        """
        return pulumi.get(self, "vm_health")

    @property
    @pulumi.getter(name="bootDiagnostics")
    def boot_diagnostics(self) -> Optional['outputs.BootDiagnosticsInstanceViewResponse']:
        """
        Boot Diagnostics is a debugging feature which allows you to view Console Output and Screenshot to diagnose VM status. <br><br> You can easily view the output of your console log. <br><br> Azure also enables you to see a screenshot of the VM from the hypervisor.
        """
        return pulumi.get(self, "boot_diagnostics")

    @property
    @pulumi.getter
    def disks(self) -> Optional[Sequence['outputs.DiskInstanceViewResponse']]:
        """
        The disks information.
        """
        return pulumi.get(self, "disks")

    @property
    @pulumi.getter
    def extensions(self) -> Optional[Sequence['outputs.VirtualMachineExtensionInstanceViewResponse']]:
        """
        The extensions information.
        """
        return pulumi.get(self, "extensions")

    @property
    @pulumi.getter(name="maintenanceRedeployStatus")
    def maintenance_redeploy_status(self) -> Optional['outputs.MaintenanceRedeployStatusResponse']:
        """
        The Maintenance Operation status on the virtual machine.
        """
        return pulumi.get(self, "maintenance_redeploy_status")

    @property
    @pulumi.getter(name="placementGroupId")
    def placement_group_id(self) -> Optional[str]:
        """
        The placement group in which the VM is running. If the VM is deallocated it will not have a placementGroupId.
        """
        return pulumi.get(self, "placement_group_id")

    @property
    @pulumi.getter(name="platformFaultDomain")
    def platform_fault_domain(self) -> Optional[int]:
        """
        The Fault Domain count.
        """
        return pulumi.get(self, "platform_fault_domain")

    @property
    @pulumi.getter(name="platformUpdateDomain")
    def platform_update_domain(self) -> Optional[int]:
        """
        The Update Domain count.
        """
        return pulumi.get(self, "platform_update_domain")

    @property
    @pulumi.getter(name="rdpThumbPrint")
    def rdp_thumb_print(self) -> Optional[str]:
        """
        The Remote desktop certificate thumbprint.
        """
        return pulumi.get(self, "rdp_thumb_print")

    @property
    @pulumi.getter
    def statuses(self) -> Optional[Sequence['outputs.InstanceViewStatusResponse']]:
        """
        The resource status information.
        """
        return pulumi.get(self, "statuses")

    @property
    @pulumi.getter(name="vmAgent")
    def vm_agent(self) -> Optional['outputs.VirtualMachineAgentInstanceViewResponse']:
        """
        The VM Agent running on the virtual machine.
        """
        return pulumi.get(self, "vm_agent")


@pulumi.output_type
class VirtualMachineScaleSetVMProfileResponse(dict):
    """
    Describes a virtual machine scale set virtual machine profile.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diagnosticsProfile":
            suggest = "diagnostics_profile"
        elif key == "evictionPolicy":
            suggest = "eviction_policy"
        elif key == "extensionProfile":
            suggest = "extension_profile"
        elif key == "licenseType":
            suggest = "license_type"
        elif key == "networkProfile":
            suggest = "network_profile"
        elif key == "osProfile":
            suggest = "os_profile"
        elif key == "storageProfile":
            suggest = "storage_profile"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineScaleSetVMProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineScaleSetVMProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineScaleSetVMProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 diagnostics_profile: Optional['outputs.DiagnosticsProfileResponse'] = None,
                 eviction_policy: Optional[str] = None,
                 extension_profile: Optional['outputs.VirtualMachineScaleSetExtensionProfileResponse'] = None,
                 license_type: Optional[str] = None,
                 network_profile: Optional['outputs.VirtualMachineScaleSetNetworkProfileResponse'] = None,
                 os_profile: Optional['outputs.VirtualMachineScaleSetOSProfileResponse'] = None,
                 priority: Optional[str] = None,
                 storage_profile: Optional['outputs.VirtualMachineScaleSetStorageProfileResponse'] = None):
        """
        Describes a virtual machine scale set virtual machine profile.
        :param 'DiagnosticsProfileResponse' diagnostics_profile: Specifies the boot diagnostic settings state. <br><br>Minimum api-version: 2015-06-15.
        :param str eviction_policy: Specifies the eviction policy for virtual machines in a low priority scale set. <br><br>Minimum api-version: 2017-10-30-preview
        :param 'VirtualMachineScaleSetExtensionProfileResponse' extension_profile: Specifies a collection of settings for extensions installed on virtual machines in the scale set.
        :param str license_type: Specifies that the image or disk that is being used was licensed on-premises. This element is only used for images that contain the Windows Server operating system. <br><br> Possible values are: <br><br> Windows_Client <br><br> Windows_Server <br><br> If this element is included in a request for an update, the value must match the initial value. This value cannot be updated. <br><br> For more information, see [Azure Hybrid Use Benefit for Windows Server](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-hybrid-use-benefit-licensing?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json) <br><br> Minimum api-version: 2015-06-15
        :param 'VirtualMachineScaleSetNetworkProfileResponse' network_profile: Specifies properties of the network interfaces of the virtual machines in the scale set.
        :param 'VirtualMachineScaleSetOSProfileResponse' os_profile: Specifies the operating system settings for the virtual machines in the scale set.
        :param str priority: Specifies the priority for the virtual machines in the scale set. <br><br>Minimum api-version: 2017-10-30-preview
        :param 'VirtualMachineScaleSetStorageProfileResponse' storage_profile: Specifies the storage settings for the virtual machine disks.
        """
        if diagnostics_profile is not None:
            pulumi.set(__self__, "diagnostics_profile", diagnostics_profile)
        if eviction_policy is not None:
            pulumi.set(__self__, "eviction_policy", eviction_policy)
        if extension_profile is not None:
            pulumi.set(__self__, "extension_profile", extension_profile)
        if license_type is not None:
            pulumi.set(__self__, "license_type", license_type)
        if network_profile is not None:
            pulumi.set(__self__, "network_profile", network_profile)
        if os_profile is not None:
            pulumi.set(__self__, "os_profile", os_profile)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if storage_profile is not None:
            pulumi.set(__self__, "storage_profile", storage_profile)

    @property
    @pulumi.getter(name="diagnosticsProfile")
    def diagnostics_profile(self) -> Optional['outputs.DiagnosticsProfileResponse']:
        """
        Specifies the boot diagnostic settings state. <br><br>Minimum api-version: 2015-06-15.
        """
        return pulumi.get(self, "diagnostics_profile")

    @property
    @pulumi.getter(name="evictionPolicy")
    def eviction_policy(self) -> Optional[str]:
        """
        Specifies the eviction policy for virtual machines in a low priority scale set. <br><br>Minimum api-version: 2017-10-30-preview
        """
        return pulumi.get(self, "eviction_policy")

    @property
    @pulumi.getter(name="extensionProfile")
    def extension_profile(self) -> Optional['outputs.VirtualMachineScaleSetExtensionProfileResponse']:
        """
        Specifies a collection of settings for extensions installed on virtual machines in the scale set.
        """
        return pulumi.get(self, "extension_profile")

    @property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> Optional[str]:
        """
        Specifies that the image or disk that is being used was licensed on-premises. This element is only used for images that contain the Windows Server operating system. <br><br> Possible values are: <br><br> Windows_Client <br><br> Windows_Server <br><br> If this element is included in a request for an update, the value must match the initial value. This value cannot be updated. <br><br> For more information, see [Azure Hybrid Use Benefit for Windows Server](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-hybrid-use-benefit-licensing?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json) <br><br> Minimum api-version: 2015-06-15
        """
        return pulumi.get(self, "license_type")

    @property
    @pulumi.getter(name="networkProfile")
    def network_profile(self) -> Optional['outputs.VirtualMachineScaleSetNetworkProfileResponse']:
        """
        Specifies properties of the network interfaces of the virtual machines in the scale set.
        """
        return pulumi.get(self, "network_profile")

    @property
    @pulumi.getter(name="osProfile")
    def os_profile(self) -> Optional['outputs.VirtualMachineScaleSetOSProfileResponse']:
        """
        Specifies the operating system settings for the virtual machines in the scale set.
        """
        return pulumi.get(self, "os_profile")

    @property
    @pulumi.getter
    def priority(self) -> Optional[str]:
        """
        Specifies the priority for the virtual machines in the scale set. <br><br>Minimum api-version: 2017-10-30-preview
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="storageProfile")
    def storage_profile(self) -> Optional['outputs.VirtualMachineScaleSetStorageProfileResponse']:
        """
        Specifies the storage settings for the virtual machine disks.
        """
        return pulumi.get(self, "storage_profile")


@pulumi.output_type
class WinRMConfigurationResponse(dict):
    """
    Describes Windows Remote Management configuration of the VM
    """
    def __init__(__self__, *,
                 listeners: Optional[Sequence['outputs.WinRMListenerResponse']] = None):
        """
        Describes Windows Remote Management configuration of the VM
        :param Sequence['WinRMListenerResponse'] listeners: The list of Windows Remote Management listeners
        """
        if listeners is not None:
            pulumi.set(__self__, "listeners", listeners)

    @property
    @pulumi.getter
    def listeners(self) -> Optional[Sequence['outputs.WinRMListenerResponse']]:
        """
        The list of Windows Remote Management listeners
        """
        return pulumi.get(self, "listeners")


@pulumi.output_type
class WinRMListenerResponse(dict):
    """
    Describes Protocol and thumbprint of Windows Remote Management listener
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateUrl":
            suggest = "certificate_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WinRMListenerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WinRMListenerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WinRMListenerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_url: Optional[str] = None,
                 protocol: Optional[str] = None):
        """
        Describes Protocol and thumbprint of Windows Remote Management listener
        :param str certificate_url: This is the URL of a certificate that has been uploaded to Key Vault as a secret. For adding a secret to the Key Vault, see [Add a key or secret to the key vault](https://docs.microsoft.com/azure/key-vault/key-vault-get-started/#add). In this case, your certificate needs to be It is the Base64 encoding of the following JSON Object which is encoded in UTF-8: <br><br> {<br>  "data":"<Base64-encoded-certificate>",<br>  "dataType":"pfx",<br>  "password":"<pfx-file-password>"<br>}
        :param str protocol: Specifies the protocol of listener. <br><br> Possible values are: <br>**http** <br><br> **https**
        """
        if certificate_url is not None:
            pulumi.set(__self__, "certificate_url", certificate_url)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter(name="certificateUrl")
    def certificate_url(self) -> Optional[str]:
        """
        This is the URL of a certificate that has been uploaded to Key Vault as a secret. For adding a secret to the Key Vault, see [Add a key or secret to the key vault](https://docs.microsoft.com/azure/key-vault/key-vault-get-started/#add). In this case, your certificate needs to be It is the Base64 encoding of the following JSON Object which is encoded in UTF-8: <br><br> {<br>  "data":"<Base64-encoded-certificate>",<br>  "dataType":"pfx",<br>  "password":"<pfx-file-password>"<br>}
        """
        return pulumi.get(self, "certificate_url")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        """
        Specifies the protocol of listener. <br><br> Possible values are: <br>**http** <br><br> **https**
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class WindowsConfigurationResponse(dict):
    """
    Specifies Windows operating system settings on the virtual machine.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalUnattendContent":
            suggest = "additional_unattend_content"
        elif key == "enableAutomaticUpdates":
            suggest = "enable_automatic_updates"
        elif key == "provisionVMAgent":
            suggest = "provision_vm_agent"
        elif key == "timeZone":
            suggest = "time_zone"
        elif key == "winRM":
            suggest = "win_rm"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WindowsConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WindowsConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WindowsConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 additional_unattend_content: Optional[Sequence['outputs.AdditionalUnattendContentResponse']] = None,
                 enable_automatic_updates: Optional[bool] = None,
                 provision_vm_agent: Optional[bool] = None,
                 time_zone: Optional[str] = None,
                 win_rm: Optional['outputs.WinRMConfigurationResponse'] = None):
        """
        Specifies Windows operating system settings on the virtual machine.
        :param Sequence['AdditionalUnattendContentResponse'] additional_unattend_content: Specifies additional base-64 encoded XML formatted information that can be included in the Unattend.xml file, which is used by Windows Setup.
        :param bool enable_automatic_updates: Indicates whether virtual machine is enabled for automatic updates.
        :param bool provision_vm_agent: Indicates whether virtual machine agent should be provisioned on the virtual machine. <br><br> When this property is not specified in the request body, default behavior is to set it to true.  This will ensure that VM Agent is installed on the VM so that extensions can be added to the VM later.
        :param str time_zone: Specifies the time zone of the virtual machine. e.g. "Pacific Standard Time"
        :param 'WinRMConfigurationResponse' win_rm: Specifies the Windows Remote Management listeners. This enables remote Windows PowerShell.
        """
        if additional_unattend_content is not None:
            pulumi.set(__self__, "additional_unattend_content", additional_unattend_content)
        if enable_automatic_updates is not None:
            pulumi.set(__self__, "enable_automatic_updates", enable_automatic_updates)
        if provision_vm_agent is not None:
            pulumi.set(__self__, "provision_vm_agent", provision_vm_agent)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)
        if win_rm is not None:
            pulumi.set(__self__, "win_rm", win_rm)

    @property
    @pulumi.getter(name="additionalUnattendContent")
    def additional_unattend_content(self) -> Optional[Sequence['outputs.AdditionalUnattendContentResponse']]:
        """
        Specifies additional base-64 encoded XML formatted information that can be included in the Unattend.xml file, which is used by Windows Setup.
        """
        return pulumi.get(self, "additional_unattend_content")

    @property
    @pulumi.getter(name="enableAutomaticUpdates")
    def enable_automatic_updates(self) -> Optional[bool]:
        """
        Indicates whether virtual machine is enabled for automatic updates.
        """
        return pulumi.get(self, "enable_automatic_updates")

    @property
    @pulumi.getter(name="provisionVMAgent")
    def provision_vm_agent(self) -> Optional[bool]:
        """
        Indicates whether virtual machine agent should be provisioned on the virtual machine. <br><br> When this property is not specified in the request body, default behavior is to set it to true.  This will ensure that VM Agent is installed on the VM so that extensions can be added to the VM later.
        """
        return pulumi.get(self, "provision_vm_agent")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[str]:
        """
        Specifies the time zone of the virtual machine. e.g. "Pacific Standard Time"
        """
        return pulumi.get(self, "time_zone")

    @property
    @pulumi.getter(name="winRM")
    def win_rm(self) -> Optional['outputs.WinRMConfigurationResponse']:
        """
        Specifies the Windows Remote Management listeners. This enables remote Windows PowerShell.
        """
        return pulumi.get(self, "win_rm")


