# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetBlockchainMemberResult',
    'AwaitableGetBlockchainMemberResult',
    'get_blockchain_member',
    'get_blockchain_member_output',
]

@pulumi.output_type
class GetBlockchainMemberResult:
    """
    Payload of the blockchain member which is exposed in the request/response of the resource provider.
    """
    def __init__(__self__, consortium=None, consortium_management_account_address=None, consortium_management_account_password=None, consortium_member_display_name=None, consortium_role=None, dns=None, firewall_rules=None, id=None, location=None, name=None, password=None, protocol=None, provisioning_state=None, public_key=None, root_contract_address=None, sku=None, tags=None, type=None, user_name=None, validator_nodes_sku=None):
        if consortium and not isinstance(consortium, str):
            raise TypeError("Expected argument 'consortium' to be a str")
        pulumi.set(__self__, "consortium", consortium)
        if consortium_management_account_address and not isinstance(consortium_management_account_address, str):
            raise TypeError("Expected argument 'consortium_management_account_address' to be a str")
        pulumi.set(__self__, "consortium_management_account_address", consortium_management_account_address)
        if consortium_management_account_password and not isinstance(consortium_management_account_password, str):
            raise TypeError("Expected argument 'consortium_management_account_password' to be a str")
        pulumi.set(__self__, "consortium_management_account_password", consortium_management_account_password)
        if consortium_member_display_name and not isinstance(consortium_member_display_name, str):
            raise TypeError("Expected argument 'consortium_member_display_name' to be a str")
        pulumi.set(__self__, "consortium_member_display_name", consortium_member_display_name)
        if consortium_role and not isinstance(consortium_role, str):
            raise TypeError("Expected argument 'consortium_role' to be a str")
        pulumi.set(__self__, "consortium_role", consortium_role)
        if dns and not isinstance(dns, str):
            raise TypeError("Expected argument 'dns' to be a str")
        pulumi.set(__self__, "dns", dns)
        if firewall_rules and not isinstance(firewall_rules, list):
            raise TypeError("Expected argument 'firewall_rules' to be a list")
        pulumi.set(__self__, "firewall_rules", firewall_rules)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if password and not isinstance(password, str):
            raise TypeError("Expected argument 'password' to be a str")
        pulumi.set(__self__, "password", password)
        if protocol and not isinstance(protocol, str):
            raise TypeError("Expected argument 'protocol' to be a str")
        pulumi.set(__self__, "protocol", protocol)
        if provisioning_state and not isinstance(provisioning_state, str):
            raise TypeError("Expected argument 'provisioning_state' to be a str")
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if public_key and not isinstance(public_key, str):
            raise TypeError("Expected argument 'public_key' to be a str")
        pulumi.set(__self__, "public_key", public_key)
        if root_contract_address and not isinstance(root_contract_address, str):
            raise TypeError("Expected argument 'root_contract_address' to be a str")
        pulumi.set(__self__, "root_contract_address", root_contract_address)
        if sku and not isinstance(sku, dict):
            raise TypeError("Expected argument 'sku' to be a dict")
        pulumi.set(__self__, "sku", sku)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if user_name and not isinstance(user_name, str):
            raise TypeError("Expected argument 'user_name' to be a str")
        pulumi.set(__self__, "user_name", user_name)
        if validator_nodes_sku and not isinstance(validator_nodes_sku, dict):
            raise TypeError("Expected argument 'validator_nodes_sku' to be a dict")
        pulumi.set(__self__, "validator_nodes_sku", validator_nodes_sku)

    @property
    @pulumi.getter
    def consortium(self) -> Optional[str]:
        """
        Gets or sets the consortium for the blockchain member.
        """
        return pulumi.get(self, "consortium")

    @property
    @pulumi.getter(name="consortiumManagementAccountAddress")
    def consortium_management_account_address(self) -> str:
        """
        Gets the managed consortium management account address.
        """
        return pulumi.get(self, "consortium_management_account_address")

    @property
    @pulumi.getter(name="consortiumManagementAccountPassword")
    def consortium_management_account_password(self) -> Optional[str]:
        """
        Sets the managed consortium management account password.
        """
        return pulumi.get(self, "consortium_management_account_password")

    @property
    @pulumi.getter(name="consortiumMemberDisplayName")
    def consortium_member_display_name(self) -> Optional[str]:
        """
        Gets the display name of the member in the consortium.
        """
        return pulumi.get(self, "consortium_member_display_name")

    @property
    @pulumi.getter(name="consortiumRole")
    def consortium_role(self) -> Optional[str]:
        """
        Gets the role of the member in the consortium.
        """
        return pulumi.get(self, "consortium_role")

    @property
    @pulumi.getter
    def dns(self) -> str:
        """
        Gets the dns endpoint of the blockchain member.
        """
        return pulumi.get(self, "dns")

    @property
    @pulumi.getter(name="firewallRules")
    def firewall_rules(self) -> Optional[Sequence['outputs.FirewallRuleResponse']]:
        """
        Gets or sets firewall rules
        """
        return pulumi.get(self, "firewall_rules")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Fully qualified resource Id of the resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        The GEO location of the blockchain service.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        Sets the basic auth password of the blockchain member.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        """
        Gets or sets the blockchain protocol.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Gets or sets the blockchain member provision state.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> str:
        """
        Gets the public key of the blockchain member (default transaction node).
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter(name="rootContractAddress")
    def root_contract_address(self) -> str:
        """
        Gets the Ethereum root contract address of the blockchain.
        """
        return pulumi.get(self, "root_contract_address")

    @property
    @pulumi.getter
    def sku(self) -> Optional['outputs.SkuResponse']:
        """
        Gets or sets the blockchain member Sku.
        """
        return pulumi.get(self, "sku")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Tags of the service which is a list of key value pairs that describes the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the service - e.g. "Microsoft.Blockchain"
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> str:
        """
        Gets the auth user name of the blockchain member.
        """
        return pulumi.get(self, "user_name")

    @property
    @pulumi.getter(name="validatorNodesSku")
    def validator_nodes_sku(self) -> Optional['outputs.BlockchainMemberNodesSkuResponse']:
        """
        Gets or sets the blockchain validator nodes Sku.
        """
        return pulumi.get(self, "validator_nodes_sku")


class AwaitableGetBlockchainMemberResult(GetBlockchainMemberResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBlockchainMemberResult(
            consortium=self.consortium,
            consortium_management_account_address=self.consortium_management_account_address,
            consortium_management_account_password=self.consortium_management_account_password,
            consortium_member_display_name=self.consortium_member_display_name,
            consortium_role=self.consortium_role,
            dns=self.dns,
            firewall_rules=self.firewall_rules,
            id=self.id,
            location=self.location,
            name=self.name,
            password=self.password,
            protocol=self.protocol,
            provisioning_state=self.provisioning_state,
            public_key=self.public_key,
            root_contract_address=self.root_contract_address,
            sku=self.sku,
            tags=self.tags,
            type=self.type,
            user_name=self.user_name,
            validator_nodes_sku=self.validator_nodes_sku)


def get_blockchain_member(blockchain_member_name: Optional[str] = None,
                          resource_group_name: Optional[str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBlockchainMemberResult:
    """
    Payload of the blockchain member which is exposed in the request/response of the resource provider.
    API Version: 2018-06-01-preview.


    :param str blockchain_member_name: Blockchain member name.
    :param str resource_group_name: The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
    """
    __args__ = dict()
    __args__['blockchainMemberName'] = blockchain_member_name
    __args__['resourceGroupName'] = resource_group_name
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('azure-native:blockchain:getBlockchainMember', __args__, opts=opts, typ=GetBlockchainMemberResult).value

    return AwaitableGetBlockchainMemberResult(
        consortium=__ret__.consortium,
        consortium_management_account_address=__ret__.consortium_management_account_address,
        consortium_management_account_password=__ret__.consortium_management_account_password,
        consortium_member_display_name=__ret__.consortium_member_display_name,
        consortium_role=__ret__.consortium_role,
        dns=__ret__.dns,
        firewall_rules=__ret__.firewall_rules,
        id=__ret__.id,
        location=__ret__.location,
        name=__ret__.name,
        password=__ret__.password,
        protocol=__ret__.protocol,
        provisioning_state=__ret__.provisioning_state,
        public_key=__ret__.public_key,
        root_contract_address=__ret__.root_contract_address,
        sku=__ret__.sku,
        tags=__ret__.tags,
        type=__ret__.type,
        user_name=__ret__.user_name,
        validator_nodes_sku=__ret__.validator_nodes_sku)


@_utilities.lift_output_func(get_blockchain_member)
def get_blockchain_member_output(blockchain_member_name: Optional[pulumi.Input[str]] = None,
                                 resource_group_name: Optional[pulumi.Input[str]] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetBlockchainMemberResult]:
    """
    Payload of the blockchain member which is exposed in the request/response of the resource provider.
    API Version: 2018-06-01-preview.


    :param str blockchain_member_name: Blockchain member name.
    :param str resource_group_name: The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
    """
    ...
