# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetActiveDirectoryConnectorResult',
    'AwaitableGetActiveDirectoryConnectorResult',
    'get_active_directory_connector',
    'get_active_directory_connector_output',
]

@pulumi.output_type
class GetActiveDirectoryConnectorResult:
    """
    Active directory connector resource
    """
    def __init__(__self__, id=None, name=None, properties=None, system_data=None, type=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if properties and not isinstance(properties, dict):
            raise TypeError("Expected argument 'properties' to be a dict")
        pulumi.set(__self__, "properties", properties)
        if system_data and not isinstance(system_data, dict):
            raise TypeError("Expected argument 'system_data' to be a dict")
        pulumi.set(__self__, "system_data", system_data)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def properties(self) -> 'outputs.ActiveDirectoryConnectorPropertiesResponse':
        """
        null
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> 'outputs.SystemDataResponse':
        """
        Azure Resource Manager metadata containing createdBy and modifiedBy information.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")


class AwaitableGetActiveDirectoryConnectorResult(GetActiveDirectoryConnectorResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetActiveDirectoryConnectorResult(
            id=self.id,
            name=self.name,
            properties=self.properties,
            system_data=self.system_data,
            type=self.type)


def get_active_directory_connector(active_directory_connector_name: Optional[str] = None,
                                   data_controller_name: Optional[str] = None,
                                   resource_group_name: Optional[str] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetActiveDirectoryConnectorResult:
    """
    Active directory connector resource
    API Version: 2022-03-01-preview.


    :param str active_directory_connector_name: The name of the Active Directory connector instance
    :param str data_controller_name: The name of the data controller
    :param str resource_group_name: The name of the Azure resource group
    """
    __args__ = dict()
    __args__['activeDirectoryConnectorName'] = active_directory_connector_name
    __args__['dataControllerName'] = data_controller_name
    __args__['resourceGroupName'] = resource_group_name
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('azure-native:azurearcdata:getActiveDirectoryConnector', __args__, opts=opts, typ=GetActiveDirectoryConnectorResult).value

    return AwaitableGetActiveDirectoryConnectorResult(
        id=__ret__.id,
        name=__ret__.name,
        properties=__ret__.properties,
        system_data=__ret__.system_data,
        type=__ret__.type)


@_utilities.lift_output_func(get_active_directory_connector)
def get_active_directory_connector_output(active_directory_connector_name: Optional[pulumi.Input[str]] = None,
                                          data_controller_name: Optional[pulumi.Input[str]] = None,
                                          resource_group_name: Optional[pulumi.Input[str]] = None,
                                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetActiveDirectoryConnectorResult]:
    """
    Active directory connector resource
    API Version: 2022-03-01-preview.


    :param str active_directory_connector_name: The name of the Active Directory connector instance
    :param str data_controller_name: The name of the data controller
    :param str resource_group_name: The name of the Azure resource group
    """
    ...
