# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'ActionGroupsInformationResponse',
    'DetectorResponse',
    'ThrottlingInformationResponse',
]

@pulumi.output_type
class ActionGroupsInformationResponse(dict):
    """
    The Action Groups information, used by the alert rule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groupIds":
            suggest = "group_ids"
        elif key == "customEmailSubject":
            suggest = "custom_email_subject"
        elif key == "customWebhookPayload":
            suggest = "custom_webhook_payload"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ActionGroupsInformationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ActionGroupsInformationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ActionGroupsInformationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 group_ids: Sequence[str],
                 custom_email_subject: Optional[str] = None,
                 custom_webhook_payload: Optional[str] = None):
        """
        The Action Groups information, used by the alert rule.
        :param Sequence[str] group_ids: The Action Group resource IDs.
        :param str custom_email_subject: An optional custom email subject to use in email notifications.
        :param str custom_webhook_payload: An optional custom web-hook payload to use in web-hook notifications.
        """
        pulumi.set(__self__, "group_ids", group_ids)
        if custom_email_subject is not None:
            pulumi.set(__self__, "custom_email_subject", custom_email_subject)
        if custom_webhook_payload is not None:
            pulumi.set(__self__, "custom_webhook_payload", custom_webhook_payload)

    @property
    @pulumi.getter(name="groupIds")
    def group_ids(self) -> Sequence[str]:
        """
        The Action Group resource IDs.
        """
        return pulumi.get(self, "group_ids")

    @property
    @pulumi.getter(name="customEmailSubject")
    def custom_email_subject(self) -> Optional[str]:
        """
        An optional custom email subject to use in email notifications.
        """
        return pulumi.get(self, "custom_email_subject")

    @property
    @pulumi.getter(name="customWebhookPayload")
    def custom_webhook_payload(self) -> Optional[str]:
        """
        An optional custom web-hook payload to use in web-hook notifications.
        """
        return pulumi.get(self, "custom_webhook_payload")


@pulumi.output_type
class DetectorResponse(dict):
    """
    The detector information. By default this is not populated, unless it's specified in expandDetector
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "imagePaths":
            suggest = "image_paths"
        elif key == "supportedResourceTypes":
            suggest = "supported_resource_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DetectorResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DetectorResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DetectorResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 description: Optional[str] = None,
                 image_paths: Optional[Sequence[str]] = None,
                 name: Optional[str] = None,
                 parameters: Optional[Mapping[str, Any]] = None,
                 supported_resource_types: Optional[Sequence[str]] = None):
        """
        The detector information. By default this is not populated, unless it's specified in expandDetector
        :param str id: The detector id.
        :param str description: The Smart Detector description. By default this is not populated, unless it's specified in expandDetector
        :param Sequence[str] image_paths: The Smart Detector image path. By default this is not populated, unless it's specified in expandDetector
        :param str name: The Smart Detector name. By default this is not populated, unless it's specified in expandDetector
        :param Mapping[str, Any] parameters: The detector's parameters.'
        :param Sequence[str] supported_resource_types: The Smart Detector supported resource types. By default this is not populated, unless it's specified in expandDetector
        """
        pulumi.set(__self__, "id", id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if image_paths is not None:
            pulumi.set(__self__, "image_paths", image_paths)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if supported_resource_types is not None:
            pulumi.set(__self__, "supported_resource_types", supported_resource_types)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The detector id.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The Smart Detector description. By default this is not populated, unless it's specified in expandDetector
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="imagePaths")
    def image_paths(self) -> Optional[Sequence[str]]:
        """
        The Smart Detector image path. By default this is not populated, unless it's specified in expandDetector
        """
        return pulumi.get(self, "image_paths")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The Smart Detector name. By default this is not populated, unless it's specified in expandDetector
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, Any]]:
        """
        The detector's parameters.'
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="supportedResourceTypes")
    def supported_resource_types(self) -> Optional[Sequence[str]]:
        """
        The Smart Detector supported resource types. By default this is not populated, unless it's specified in expandDetector
        """
        return pulumi.get(self, "supported_resource_types")


@pulumi.output_type
class ThrottlingInformationResponse(dict):
    """
    Optional throttling information for the alert rule.
    """
    def __init__(__self__, *,
                 duration: Optional[str] = None):
        """
        Optional throttling information for the alert rule.
        :param str duration: The required duration (in ISO8601 format) to wait before notifying on the alert rule again. The time granularity must be in minutes and minimum value is 0 minutes
        """
        if duration is not None:
            pulumi.set(__self__, "duration", duration)

    @property
    @pulumi.getter
    def duration(self) -> Optional[str]:
        """
        The required duration (in ISO8601 format) to wait before notifying on the alert rule again. The time granularity must be in minutes and minimum value is 0 minutes
        """
        return pulumi.get(self, "duration")


