# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AsymmetricEncryptedSecretArgs',
    'ManagerIntrinsicSettingsArgs',
    'ManagerSkuArgs',
    'TimeArgs',
]

@pulumi.input_type
class AsymmetricEncryptedSecretArgs:
    def __init__(__self__, *,
                 encryption_algorithm: pulumi.Input['EncryptionAlgorithm'],
                 value: pulumi.Input[str],
                 encryption_certificate_thumbprint: Optional[pulumi.Input[str]] = None):
        """
        This class can be used as the Type for any secret entity represented as Password, CertThumbprint, Algorithm. This class is intended to be used when the secret is encrypted with an asymmetric key pair. The encryptionAlgorithm field is mainly for future usage to potentially allow different entities encrypted using different algorithms.
        :param pulumi.Input['EncryptionAlgorithm'] encryption_algorithm: Algorithm used to encrypt "Value"
        :param pulumi.Input[str] value: The value of the secret itself. If the secret is in plaintext then EncryptionAlgorithm will be none and EncryptionCertThumbprint will be null.
        :param pulumi.Input[str] encryption_certificate_thumbprint: Thumbprint certificate that was used to encrypt "Value"
        """
        pulumi.set(__self__, "encryption_algorithm", encryption_algorithm)
        pulumi.set(__self__, "value", value)
        if encryption_certificate_thumbprint is not None:
            pulumi.set(__self__, "encryption_certificate_thumbprint", encryption_certificate_thumbprint)

    @property
    @pulumi.getter(name="encryptionAlgorithm")
    def encryption_algorithm(self) -> pulumi.Input['EncryptionAlgorithm']:
        """
        Algorithm used to encrypt "Value"
        """
        return pulumi.get(self, "encryption_algorithm")

    @encryption_algorithm.setter
    def encryption_algorithm(self, value: pulumi.Input['EncryptionAlgorithm']):
        pulumi.set(self, "encryption_algorithm", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The value of the secret itself. If the secret is in plaintext then EncryptionAlgorithm will be none and EncryptionCertThumbprint will be null.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter(name="encryptionCertificateThumbprint")
    def encryption_certificate_thumbprint(self) -> Optional[pulumi.Input[str]]:
        """
        Thumbprint certificate that was used to encrypt "Value"
        """
        return pulumi.get(self, "encryption_certificate_thumbprint")

    @encryption_certificate_thumbprint.setter
    def encryption_certificate_thumbprint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encryption_certificate_thumbprint", value)


@pulumi.input_type
class ManagerIntrinsicSettingsArgs:
    def __init__(__self__, *,
                 type: pulumi.Input['ManagerType']):
        """
        Intrinsic settings which refers to the type of the StorSimple manager
        :param pulumi.Input['ManagerType'] type: Refers to the type of the StorSimple Manager
        """
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input['ManagerType']:
        """
        Refers to the type of the StorSimple Manager
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input['ManagerType']):
        pulumi.set(self, "type", value)


@pulumi.input_type
class ManagerSkuArgs:
    def __init__(__self__, *,
                 name: pulumi.Input['ManagerSkuType']):
        """
        The Sku.
        :param pulumi.Input['ManagerSkuType'] name: Refers to the sku name which should be "Standard"
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input['ManagerSkuType']:
        """
        Refers to the sku name which should be "Standard"
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input['ManagerSkuType']):
        pulumi.set(self, "name", value)


@pulumi.input_type
class TimeArgs:
    def __init__(__self__, *,
                 hour: pulumi.Input[int],
                 minute: pulumi.Input[int]):
        """
        The Time.
        :param pulumi.Input[int] hour: The hour.
        :param pulumi.Input[int] minute: The minute.
        """
        pulumi.set(__self__, "hour", hour)
        pulumi.set(__self__, "minute", minute)

    @property
    @pulumi.getter
    def hour(self) -> pulumi.Input[int]:
        """
        The hour.
        """
        return pulumi.get(self, "hour")

    @hour.setter
    def hour(self, value: pulumi.Input[int]):
        pulumi.set(self, "hour", value)

    @property
    @pulumi.getter
    def minute(self) -> pulumi.Input[int]:
        """
        The minute.
        """
        return pulumi.get(self, "minute")

    @minute.setter
    def minute(self, value: pulumi.Input[int]):
        pulumi.set(self, "minute", value)


