# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'CacheEncryptionSettingsArgs',
    'CacheIdentityArgs',
    'CacheNetworkSettingsArgs',
    'CacheSecuritySettingsArgs',
    'CacheSkuArgs',
    'ClfsTargetArgs',
    'KeyVaultKeyReferenceSourceVaultArgs',
    'KeyVaultKeyReferenceArgs',
    'NamespaceJunctionArgs',
    'Nfs3TargetArgs',
    'UnknownTargetArgs',
]

@pulumi.input_type
class CacheEncryptionSettingsArgs:
    def __init__(__self__, *,
                 key_encryption_key: Optional[pulumi.Input['KeyVaultKeyReferenceArgs']] = None):
        """
        Cache encryption settings.
        :param pulumi.Input['KeyVaultKeyReferenceArgs'] key_encryption_key: Specifies the location of the key encryption key in Key Vault.
        """
        if key_encryption_key is not None:
            pulumi.set(__self__, "key_encryption_key", key_encryption_key)

    @property
    @pulumi.getter(name="keyEncryptionKey")
    def key_encryption_key(self) -> Optional[pulumi.Input['KeyVaultKeyReferenceArgs']]:
        """
        Specifies the location of the key encryption key in Key Vault.
        """
        return pulumi.get(self, "key_encryption_key")

    @key_encryption_key.setter
    def key_encryption_key(self, value: Optional[pulumi.Input['KeyVaultKeyReferenceArgs']]):
        pulumi.set(self, "key_encryption_key", value)


@pulumi.input_type
class CacheIdentityArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input['CacheIdentityType']] = None):
        """
        Cache identity properties.
        :param pulumi.Input['CacheIdentityType'] type: The type of identity used for the cache
        """
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['CacheIdentityType']]:
        """
        The type of identity used for the cache
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['CacheIdentityType']]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class CacheNetworkSettingsArgs:
    def __init__(__self__, *,
                 mtu: Optional[pulumi.Input[int]] = None):
        """
        Cache network settings.
        :param pulumi.Input[int] mtu: The IPv4 maximum transmission unit configured for the subnet.
        """
        if mtu is None:
            mtu = 1500
        if mtu is not None:
            pulumi.set(__self__, "mtu", mtu)

    @property
    @pulumi.getter
    def mtu(self) -> Optional[pulumi.Input[int]]:
        """
        The IPv4 maximum transmission unit configured for the subnet.
        """
        return pulumi.get(self, "mtu")

    @mtu.setter
    def mtu(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "mtu", value)


@pulumi.input_type
class CacheSecuritySettingsArgs:
    def __init__(__self__, *,
                 root_squash: Optional[pulumi.Input[bool]] = None):
        """
        Cache security settings.
        :param pulumi.Input[bool] root_squash: root squash of cache property.
        """
        if root_squash is not None:
            pulumi.set(__self__, "root_squash", root_squash)

    @property
    @pulumi.getter(name="rootSquash")
    def root_squash(self) -> Optional[pulumi.Input[bool]]:
        """
        root squash of cache property.
        """
        return pulumi.get(self, "root_squash")

    @root_squash.setter
    def root_squash(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "root_squash", value)


@pulumi.input_type
class CacheSkuArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None):
        """
        SKU for the Cache.
        :param pulumi.Input[str] name: SKU name for this Cache.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        SKU name for this Cache.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class ClfsTargetArgs:
    def __init__(__self__, *,
                 target: Optional[pulumi.Input[str]] = None):
        """
        Properties pertained to ClfsTarget
        :param pulumi.Input[str] target: Resource ID of storage container.
        """
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID of storage container.
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target", value)


@pulumi.input_type
class KeyVaultKeyReferenceSourceVaultArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None):
        """
        Describes a resource Id to source Key Vault.
        :param pulumi.Input[str] id: Resource Id.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource Id.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class KeyVaultKeyReferenceArgs:
    def __init__(__self__, *,
                 key_url: pulumi.Input[str],
                 source_vault: pulumi.Input['KeyVaultKeyReferenceSourceVaultArgs']):
        """
        Describes a reference to Key Vault Key.
        :param pulumi.Input[str] key_url: The URL referencing a key encryption key in Key Vault.
        :param pulumi.Input['KeyVaultKeyReferenceSourceVaultArgs'] source_vault: Describes a resource Id to source Key Vault.
        """
        pulumi.set(__self__, "key_url", key_url)
        pulumi.set(__self__, "source_vault", source_vault)

    @property
    @pulumi.getter(name="keyUrl")
    def key_url(self) -> pulumi.Input[str]:
        """
        The URL referencing a key encryption key in Key Vault.
        """
        return pulumi.get(self, "key_url")

    @key_url.setter
    def key_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "key_url", value)

    @property
    @pulumi.getter(name="sourceVault")
    def source_vault(self) -> pulumi.Input['KeyVaultKeyReferenceSourceVaultArgs']:
        """
        Describes a resource Id to source Key Vault.
        """
        return pulumi.get(self, "source_vault")

    @source_vault.setter
    def source_vault(self, value: pulumi.Input['KeyVaultKeyReferenceSourceVaultArgs']):
        pulumi.set(self, "source_vault", value)


@pulumi.input_type
class NamespaceJunctionArgs:
    def __init__(__self__, *,
                 namespace_path: Optional[pulumi.Input[str]] = None,
                 nfs_export: Optional[pulumi.Input[str]] = None,
                 target_path: Optional[pulumi.Input[str]] = None):
        """
        A namespace junction.
        :param pulumi.Input[str] namespace_path: Namespace path on a Cache for a Storage Target.
        :param pulumi.Input[str] nfs_export: NFS export where targetPath exists.
        :param pulumi.Input[str] target_path: Path in Storage Target to which namespacePath points.
        """
        if namespace_path is not None:
            pulumi.set(__self__, "namespace_path", namespace_path)
        if nfs_export is not None:
            pulumi.set(__self__, "nfs_export", nfs_export)
        if target_path is not None:
            pulumi.set(__self__, "target_path", target_path)

    @property
    @pulumi.getter(name="namespacePath")
    def namespace_path(self) -> Optional[pulumi.Input[str]]:
        """
        Namespace path on a Cache for a Storage Target.
        """
        return pulumi.get(self, "namespace_path")

    @namespace_path.setter
    def namespace_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace_path", value)

    @property
    @pulumi.getter(name="nfsExport")
    def nfs_export(self) -> Optional[pulumi.Input[str]]:
        """
        NFS export where targetPath exists.
        """
        return pulumi.get(self, "nfs_export")

    @nfs_export.setter
    def nfs_export(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "nfs_export", value)

    @property
    @pulumi.getter(name="targetPath")
    def target_path(self) -> Optional[pulumi.Input[str]]:
        """
        Path in Storage Target to which namespacePath points.
        """
        return pulumi.get(self, "target_path")

    @target_path.setter
    def target_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_path", value)


@pulumi.input_type
class Nfs3TargetArgs:
    def __init__(__self__, *,
                 target: Optional[pulumi.Input[str]] = None,
                 usage_model: Optional[pulumi.Input[str]] = None):
        """
        Properties pertained to Nfs3Target
        :param pulumi.Input[str] target: IP address or host name of an NFSv3 host (e.g., 10.0.44.44).
        :param pulumi.Input[str] usage_model: Identifies the primary usage model to be used for this Storage Target. Get choices from .../usageModels
        """
        if target is not None:
            pulumi.set(__self__, "target", target)
        if usage_model is not None:
            pulumi.set(__self__, "usage_model", usage_model)

    @property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input[str]]:
        """
        IP address or host name of an NFSv3 host (e.g., 10.0.44.44).
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target", value)

    @property
    @pulumi.getter(name="usageModel")
    def usage_model(self) -> Optional[pulumi.Input[str]]:
        """
        Identifies the primary usage model to be used for this Storage Target. Get choices from .../usageModels
        """
        return pulumi.get(self, "usage_model")

    @usage_model.setter
    def usage_model(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "usage_model", value)


@pulumi.input_type
class UnknownTargetArgs:
    def __init__(__self__, *,
                 unknown_map: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Properties pertained to UnknownTarget
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] unknown_map: Dictionary of string->string pairs containing information about the Storage Target.
        """
        if unknown_map is not None:
            pulumi.set(__self__, "unknown_map", unknown_map)

    @property
    @pulumi.getter(name="unknownMap")
    def unknown_map(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Dictionary of string->string pairs containing information about the Storage Target.
        """
        return pulumi.get(self, "unknown_map")

    @unknown_map.setter
    def unknown_map(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "unknown_map", value)


