# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'DatabaseVulnerabilityAssessmentRuleBaselineItemArgs',
    'JobScheduleArgs',
    'JobStepActionArgs',
    'JobStepExecutionOptionsArgs',
    'JobStepOutputArgs',
    'JobTargetArgs',
    'SkuArgs',
    'VulnerabilityAssessmentRecurringScansPropertiesArgs',
]

@pulumi.input_type
class DatabaseVulnerabilityAssessmentRuleBaselineItemArgs:
    def __init__(__self__, *,
                 result: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        Properties for an Azure SQL Database Vulnerability Assessment rule baseline's result.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] result: The rule baseline result
        """
        pulumi.set(__self__, "result", result)

    @property
    @pulumi.getter
    def result(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The rule baseline result
        """
        return pulumi.get(self, "result")

    @result.setter
    def result(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "result", value)


@pulumi.input_type
class JobScheduleArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 end_time: Optional[pulumi.Input[str]] = None,
                 interval: Optional[pulumi.Input[str]] = None,
                 start_time: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input['JobScheduleType']] = None):
        """
        Scheduling properties of a job.
        :param pulumi.Input[bool] enabled: Whether or not the schedule is enabled.
        :param pulumi.Input[str] end_time: Schedule end time.
        :param pulumi.Input[str] interval: Value of the schedule's recurring interval, if the schedule type is recurring. ISO8601 duration format.
        :param pulumi.Input[str] start_time: Schedule start time.
        :param pulumi.Input['JobScheduleType'] type: Schedule interval type
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if end_time is None:
            end_time = '9999-12-31T11:59:59Z'
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if start_time is None:
            start_time = '0001-01-01T00:00:00Z'
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if type is None:
            type = 'Once'
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not the schedule is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[str]]:
        """
        Schedule end time.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end_time", value)

    @property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[str]]:
        """
        Value of the schedule's recurring interval, if the schedule type is recurring. ISO8601 duration format.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "interval", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[str]]:
        """
        Schedule start time.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['JobScheduleType']]:
        """
        Schedule interval type
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['JobScheduleType']]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class JobStepActionArgs:
    def __init__(__self__, *,
                 value: pulumi.Input[str],
                 source: Optional[pulumi.Input[Union[str, 'JobStepActionSource']]] = None,
                 type: Optional[pulumi.Input[Union[str, 'JobStepActionType']]] = None):
        """
        The action to be executed by a job step.
        :param pulumi.Input[str] value: The action value, for example the text of the T-SQL script to execute.
        :param pulumi.Input[Union[str, 'JobStepActionSource']] source: The source of the action to execute.
        :param pulumi.Input[Union[str, 'JobStepActionType']] type: Type of action being executed by the job step.
        """
        pulumi.set(__self__, "value", value)
        if source is None:
            source = 'Inline'
        if source is not None:
            pulumi.set(__self__, "source", source)
        if type is None:
            type = 'TSql'
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The action value, for example the text of the T-SQL script to execute.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[Union[str, 'JobStepActionSource']]]:
        """
        The source of the action to execute.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[Union[str, 'JobStepActionSource']]]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Union[str, 'JobStepActionType']]]:
        """
        Type of action being executed by the job step.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Union[str, 'JobStepActionType']]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class JobStepExecutionOptionsArgs:
    def __init__(__self__, *,
                 initial_retry_interval_seconds: Optional[pulumi.Input[int]] = None,
                 maximum_retry_interval_seconds: Optional[pulumi.Input[int]] = None,
                 retry_attempts: Optional[pulumi.Input[int]] = None,
                 retry_interval_backoff_multiplier: Optional[pulumi.Input[float]] = None,
                 timeout_seconds: Optional[pulumi.Input[int]] = None):
        """
        The execution options of a job step.
        :param pulumi.Input[int] initial_retry_interval_seconds: Initial delay between retries for job step execution.
        :param pulumi.Input[int] maximum_retry_interval_seconds: The maximum amount of time to wait between retries for job step execution.
        :param pulumi.Input[int] retry_attempts: Maximum number of times the job step will be reattempted if the first attempt fails.
        :param pulumi.Input[float] retry_interval_backoff_multiplier: The backoff multiplier for the time between retries.
        :param pulumi.Input[int] timeout_seconds: Execution timeout for the job step.
        """
        if initial_retry_interval_seconds is None:
            initial_retry_interval_seconds = 1
        if initial_retry_interval_seconds is not None:
            pulumi.set(__self__, "initial_retry_interval_seconds", initial_retry_interval_seconds)
        if maximum_retry_interval_seconds is None:
            maximum_retry_interval_seconds = 120
        if maximum_retry_interval_seconds is not None:
            pulumi.set(__self__, "maximum_retry_interval_seconds", maximum_retry_interval_seconds)
        if retry_attempts is None:
            retry_attempts = 10
        if retry_attempts is not None:
            pulumi.set(__self__, "retry_attempts", retry_attempts)
        if retry_interval_backoff_multiplier is None:
            retry_interval_backoff_multiplier = 2
        if retry_interval_backoff_multiplier is not None:
            pulumi.set(__self__, "retry_interval_backoff_multiplier", retry_interval_backoff_multiplier)
        if timeout_seconds is None:
            timeout_seconds = 43200
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)

    @property
    @pulumi.getter(name="initialRetryIntervalSeconds")
    def initial_retry_interval_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Initial delay between retries for job step execution.
        """
        return pulumi.get(self, "initial_retry_interval_seconds")

    @initial_retry_interval_seconds.setter
    def initial_retry_interval_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "initial_retry_interval_seconds", value)

    @property
    @pulumi.getter(name="maximumRetryIntervalSeconds")
    def maximum_retry_interval_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum amount of time to wait between retries for job step execution.
        """
        return pulumi.get(self, "maximum_retry_interval_seconds")

    @maximum_retry_interval_seconds.setter
    def maximum_retry_interval_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "maximum_retry_interval_seconds", value)

    @property
    @pulumi.getter(name="retryAttempts")
    def retry_attempts(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of times the job step will be reattempted if the first attempt fails.
        """
        return pulumi.get(self, "retry_attempts")

    @retry_attempts.setter
    def retry_attempts(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "retry_attempts", value)

    @property
    @pulumi.getter(name="retryIntervalBackoffMultiplier")
    def retry_interval_backoff_multiplier(self) -> Optional[pulumi.Input[float]]:
        """
        The backoff multiplier for the time between retries.
        """
        return pulumi.get(self, "retry_interval_backoff_multiplier")

    @retry_interval_backoff_multiplier.setter
    def retry_interval_backoff_multiplier(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "retry_interval_backoff_multiplier", value)

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Execution timeout for the job step.
        """
        return pulumi.get(self, "timeout_seconds")

    @timeout_seconds.setter
    def timeout_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout_seconds", value)


@pulumi.input_type
class JobStepOutputArgs:
    def __init__(__self__, *,
                 credential: pulumi.Input[str],
                 database_name: pulumi.Input[str],
                 server_name: pulumi.Input[str],
                 table_name: pulumi.Input[str],
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 schema_name: Optional[pulumi.Input[str]] = None,
                 subscription_id: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[Union[str, 'JobStepOutputType']]] = None):
        """
        The output configuration of a job step.
        :param pulumi.Input[str] credential: The resource ID of the credential to use to connect to the output destination.
        :param pulumi.Input[str] database_name: The output destination database.
        :param pulumi.Input[str] server_name: The output destination server name.
        :param pulumi.Input[str] table_name: The output destination table.
        :param pulumi.Input[str] resource_group_name: The output destination resource group.
        :param pulumi.Input[str] schema_name: The output destination schema.
        :param pulumi.Input[str] subscription_id: The output destination subscription id.
        :param pulumi.Input[Union[str, 'JobStepOutputType']] type: The output destination type.
        """
        pulumi.set(__self__, "credential", credential)
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "server_name", server_name)
        pulumi.set(__self__, "table_name", table_name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if schema_name is None:
            schema_name = 'dbo'
        if schema_name is not None:
            pulumi.set(__self__, "schema_name", schema_name)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)
        if type is None:
            type = 'SqlDatabase'
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def credential(self) -> pulumi.Input[str]:
        """
        The resource ID of the credential to use to connect to the output destination.
        """
        return pulumi.get(self, "credential")

    @credential.setter
    def credential(self, value: pulumi.Input[str]):
        pulumi.set(self, "credential", value)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Input[str]:
        """
        The output destination database.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> pulumi.Input[str]:
        """
        The output destination server name.
        """
        return pulumi.get(self, "server_name")

    @server_name.setter
    def server_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "server_name", value)

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> pulumi.Input[str]:
        """
        The output destination table.
        """
        return pulumi.get(self, "table_name")

    @table_name.setter
    def table_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "table_name", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        The output destination resource group.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> Optional[pulumi.Input[str]]:
        """
        The output destination schema.
        """
        return pulumi.get(self, "schema_name")

    @schema_name.setter
    def schema_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schema_name", value)

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[pulumi.Input[str]]:
        """
        The output destination subscription id.
        """
        return pulumi.get(self, "subscription_id")

    @subscription_id.setter
    def subscription_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subscription_id", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Union[str, 'JobStepOutputType']]]:
        """
        The output destination type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Union[str, 'JobStepOutputType']]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class JobTargetArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[Union[str, 'JobTargetType']],
                 database_name: Optional[pulumi.Input[str]] = None,
                 elastic_pool_name: Optional[pulumi.Input[str]] = None,
                 membership_type: Optional[pulumi.Input['JobTargetGroupMembershipType']] = None,
                 refresh_credential: Optional[pulumi.Input[str]] = None,
                 server_name: Optional[pulumi.Input[str]] = None,
                 shard_map_name: Optional[pulumi.Input[str]] = None):
        """
        A job target, for example a specific database or a container of databases that is evaluated during job execution.
        :param pulumi.Input[Union[str, 'JobTargetType']] type: The target type.
        :param pulumi.Input[str] database_name: The target database name.
        :param pulumi.Input[str] elastic_pool_name: The target elastic pool name.
        :param pulumi.Input['JobTargetGroupMembershipType'] membership_type: Whether the target is included or excluded from the group.
        :param pulumi.Input[str] refresh_credential: The resource ID of the credential that is used during job execution to connect to the target and determine the list of databases inside the target.
        :param pulumi.Input[str] server_name: The target server name.
        :param pulumi.Input[str] shard_map_name: The target shard map.
        """
        pulumi.set(__self__, "type", type)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if elastic_pool_name is not None:
            pulumi.set(__self__, "elastic_pool_name", elastic_pool_name)
        if membership_type is None:
            membership_type = 'Include'
        if membership_type is not None:
            pulumi.set(__self__, "membership_type", membership_type)
        if refresh_credential is not None:
            pulumi.set(__self__, "refresh_credential", refresh_credential)
        if server_name is not None:
            pulumi.set(__self__, "server_name", server_name)
        if shard_map_name is not None:
            pulumi.set(__self__, "shard_map_name", shard_map_name)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[Union[str, 'JobTargetType']]:
        """
        The target type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[Union[str, 'JobTargetType']]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[str]]:
        """
        The target database name.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter(name="elasticPoolName")
    def elastic_pool_name(self) -> Optional[pulumi.Input[str]]:
        """
        The target elastic pool name.
        """
        return pulumi.get(self, "elastic_pool_name")

    @elastic_pool_name.setter
    def elastic_pool_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "elastic_pool_name", value)

    @property
    @pulumi.getter(name="membershipType")
    def membership_type(self) -> Optional[pulumi.Input['JobTargetGroupMembershipType']]:
        """
        Whether the target is included or excluded from the group.
        """
        return pulumi.get(self, "membership_type")

    @membership_type.setter
    def membership_type(self, value: Optional[pulumi.Input['JobTargetGroupMembershipType']]):
        pulumi.set(self, "membership_type", value)

    @property
    @pulumi.getter(name="refreshCredential")
    def refresh_credential(self) -> Optional[pulumi.Input[str]]:
        """
        The resource ID of the credential that is used during job execution to connect to the target and determine the list of databases inside the target.
        """
        return pulumi.get(self, "refresh_credential")

    @refresh_credential.setter
    def refresh_credential(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "refresh_credential", value)

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> Optional[pulumi.Input[str]]:
        """
        The target server name.
        """
        return pulumi.get(self, "server_name")

    @server_name.setter
    def server_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_name", value)

    @property
    @pulumi.getter(name="shardMapName")
    def shard_map_name(self) -> Optional[pulumi.Input[str]]:
        """
        The target shard map.
        """
        return pulumi.get(self, "shard_map_name")

    @shard_map_name.setter
    def shard_map_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shard_map_name", value)


@pulumi.input_type
class SkuArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 capacity: Optional[pulumi.Input[int]] = None,
                 family: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[str]] = None,
                 tier: Optional[pulumi.Input[str]] = None):
        """
        An ARM Resource SKU.
        :param pulumi.Input[str] name: The name of the SKU, typically, a letter + Number code, e.g. P3.
        :param pulumi.Input[int] capacity: Capacity of the particular SKU.
        :param pulumi.Input[str] family: If the service has different generations of hardware, for the same SKU, then that can be captured here.
        :param pulumi.Input[str] size: Size of the particular SKU
        :param pulumi.Input[str] tier: The tier or edition of the particular SKU, e.g. Basic, Premium.
        """
        pulumi.set(__self__, "name", name)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if family is not None:
            pulumi.set(__self__, "family", family)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the SKU, typically, a letter + Number code, e.g. P3.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[int]]:
        """
        Capacity of the particular SKU.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "capacity", value)

    @property
    @pulumi.getter
    def family(self) -> Optional[pulumi.Input[str]]:
        """
        If the service has different generations of hardware, for the same SKU, then that can be captured here.
        """
        return pulumi.get(self, "family")

    @family.setter
    def family(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "family", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[str]]:
        """
        Size of the particular SKU
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter
    def tier(self) -> Optional[pulumi.Input[str]]:
        """
        The tier or edition of the particular SKU, e.g. Basic, Premium.
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tier", value)


@pulumi.input_type
class VulnerabilityAssessmentRecurringScansPropertiesArgs:
    def __init__(__self__, *,
                 email_subscription_admins: Optional[pulumi.Input[bool]] = None,
                 emails: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 is_enabled: Optional[pulumi.Input[bool]] = None):
        """
        Properties of a Vulnerability Assessment recurring scans.
        :param pulumi.Input[bool] email_subscription_admins: Specifies that the schedule scan notification will be is sent to the subscription administrators.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] emails: Specifies an array of e-mail addresses to which the scan notification is sent.
        :param pulumi.Input[bool] is_enabled: Recurring scans state.
        """
        if email_subscription_admins is None:
            email_subscription_admins = True
        if email_subscription_admins is not None:
            pulumi.set(__self__, "email_subscription_admins", email_subscription_admins)
        if emails is not None:
            pulumi.set(__self__, "emails", emails)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)

    @property
    @pulumi.getter(name="emailSubscriptionAdmins")
    def email_subscription_admins(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies that the schedule scan notification will be is sent to the subscription administrators.
        """
        return pulumi.get(self, "email_subscription_admins")

    @email_subscription_admins.setter
    def email_subscription_admins(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "email_subscription_admins", value)

    @property
    @pulumi.getter
    def emails(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies an array of e-mail addresses to which the scan notification is sent.
        """
        return pulumi.get(self, "emails")

    @emails.setter
    def emails(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "emails", value)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Recurring scans state.
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_enabled", value)


