# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from ._enums import *

__all__ = [
    'ActivityEntityQueriesPropertiesQueryDefinitionsArgs',
    'AlertsDataTypeOfDataConnectorArgs',
    'AutomationRuleModifyPropertiesActionActionConfigurationArgs',
    'AutomationRuleModifyPropertiesActionArgs',
    'AutomationRulePropertyValuesConditionConditionPropertiesArgs',
    'AutomationRulePropertyValuesConditionArgs',
    'AutomationRuleRunPlaybookActionActionConfigurationArgs',
    'AutomationRuleRunPlaybookActionArgs',
    'AutomationRuleTriggeringLogicArgs',
    'AwsCloudTrailDataConnectorDataTypesLogsArgs',
    'AwsCloudTrailDataConnectorDataTypesArgs',
    'ContentPathMapArgs',
    'DataConnectorDataTypeCommonArgs',
    'IncidentInfoArgs',
    'IncidentLabelArgs',
    'IncidentOwnerInfoArgs',
    'MCASDataConnectorDataTypesArgs',
    'MetadataAuthorArgs',
    'MetadataCategoriesArgs',
    'MetadataDependenciesArgs',
    'MetadataSourceArgs',
    'MetadataSupportArgs',
    'OfficeDataConnectorDataTypesExchangeArgs',
    'OfficeDataConnectorDataTypesSharePointArgs',
    'OfficeDataConnectorDataTypesTeamsArgs',
    'OfficeDataConnectorDataTypesArgs',
    'RepositoryArgs',
    'TIDataConnectorDataTypesIndicatorsArgs',
    'TIDataConnectorDataTypesArgs',
    'ThreatIntelligenceExternalReferenceArgs',
    'ThreatIntelligenceGranularMarkingModelArgs',
    'ThreatIntelligenceKillChainPhaseArgs',
    'ThreatIntelligenceParsedPatternTypeValueArgs',
    'ThreatIntelligenceParsedPatternArgs',
    'UserInfoArgs',
    'WatchlistUserInfoArgs',
]

@pulumi.input_type
class ActivityEntityQueriesPropertiesQueryDefinitionsArgs:
    def __init__(__self__, *,
                 query: Optional[pulumi.Input[str]] = None):
        """
        The Activity query definitions
        :param pulumi.Input[str] query: The Activity query to run on a given entity
        """
        if query is not None:
            pulumi.set(__self__, "query", query)

    @property
    @pulumi.getter
    def query(self) -> Optional[pulumi.Input[str]]:
        """
        The Activity query to run on a given entity
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "query", value)


@pulumi.input_type
class AlertsDataTypeOfDataConnectorArgs:
    def __init__(__self__, *,
                 alerts: Optional[pulumi.Input['DataConnectorDataTypeCommonArgs']] = None):
        """
        Alerts data type for data connectors.
        :param pulumi.Input['DataConnectorDataTypeCommonArgs'] alerts: Alerts data type connection.
        """
        if alerts is not None:
            pulumi.set(__self__, "alerts", alerts)

    @property
    @pulumi.getter
    def alerts(self) -> Optional[pulumi.Input['DataConnectorDataTypeCommonArgs']]:
        """
        Alerts data type connection.
        """
        return pulumi.get(self, "alerts")

    @alerts.setter
    def alerts(self, value: Optional[pulumi.Input['DataConnectorDataTypeCommonArgs']]):
        pulumi.set(self, "alerts", value)


@pulumi.input_type
class AutomationRuleModifyPropertiesActionActionConfigurationArgs:
    def __init__(__self__, *,
                 classification: Optional[pulumi.Input[Union[str, 'IncidentClassification']]] = None,
                 classification_comment: Optional[pulumi.Input[str]] = None,
                 classification_reason: Optional[pulumi.Input[Union[str, 'IncidentClassificationReason']]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input['IncidentLabelArgs']]]] = None,
                 owner: Optional[pulumi.Input['IncidentOwnerInfoArgs']] = None,
                 severity: Optional[pulumi.Input[Union[str, 'IncidentSeverity']]] = None,
                 status: Optional[pulumi.Input[Union[str, 'IncidentStatus']]] = None):
        """
        The configuration of the modify properties automation rule action
        :param pulumi.Input[Union[str, 'IncidentClassification']] classification: The reason the incident was closed
        :param pulumi.Input[str] classification_comment: Describes the reason the incident was closed
        :param pulumi.Input[Union[str, 'IncidentClassificationReason']] classification_reason: The classification reason to close the incident with
        :param pulumi.Input[Sequence[pulumi.Input['IncidentLabelArgs']]] labels: List of labels to add to the incident
        :param pulumi.Input['IncidentOwnerInfoArgs'] owner: Describes a user that the incident is assigned to
        :param pulumi.Input[Union[str, 'IncidentSeverity']] severity: The severity of the incident
        :param pulumi.Input[Union[str, 'IncidentStatus']] status: The status of the incident
        """
        if classification is not None:
            pulumi.set(__self__, "classification", classification)
        if classification_comment is not None:
            pulumi.set(__self__, "classification_comment", classification_comment)
        if classification_reason is not None:
            pulumi.set(__self__, "classification_reason", classification_reason)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def classification(self) -> Optional[pulumi.Input[Union[str, 'IncidentClassification']]]:
        """
        The reason the incident was closed
        """
        return pulumi.get(self, "classification")

    @classification.setter
    def classification(self, value: Optional[pulumi.Input[Union[str, 'IncidentClassification']]]):
        pulumi.set(self, "classification", value)

    @property
    @pulumi.getter(name="classificationComment")
    def classification_comment(self) -> Optional[pulumi.Input[str]]:
        """
        Describes the reason the incident was closed
        """
        return pulumi.get(self, "classification_comment")

    @classification_comment.setter
    def classification_comment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "classification_comment", value)

    @property
    @pulumi.getter(name="classificationReason")
    def classification_reason(self) -> Optional[pulumi.Input[Union[str, 'IncidentClassificationReason']]]:
        """
        The classification reason to close the incident with
        """
        return pulumi.get(self, "classification_reason")

    @classification_reason.setter
    def classification_reason(self, value: Optional[pulumi.Input[Union[str, 'IncidentClassificationReason']]]):
        pulumi.set(self, "classification_reason", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IncidentLabelArgs']]]]:
        """
        List of labels to add to the incident
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IncidentLabelArgs']]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input['IncidentOwnerInfoArgs']]:
        """
        Describes a user that the incident is assigned to
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input['IncidentOwnerInfoArgs']]):
        pulumi.set(self, "owner", value)

    @property
    @pulumi.getter
    def severity(self) -> Optional[pulumi.Input[Union[str, 'IncidentSeverity']]]:
        """
        The severity of the incident
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: Optional[pulumi.Input[Union[str, 'IncidentSeverity']]]):
        pulumi.set(self, "severity", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[Union[str, 'IncidentStatus']]]:
        """
        The status of the incident
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[Union[str, 'IncidentStatus']]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class AutomationRuleModifyPropertiesActionArgs:
    def __init__(__self__, *,
                 action_configuration: pulumi.Input['AutomationRuleModifyPropertiesActionActionConfigurationArgs'],
                 action_type: pulumi.Input[str],
                 order: pulumi.Input[int]):
        """
        Describes an automation rule action to modify an object's properties
        :param pulumi.Input['AutomationRuleModifyPropertiesActionActionConfigurationArgs'] action_configuration: The configuration of the modify properties automation rule action
        :param pulumi.Input[str] action_type: The type of the automation rule action
               Expected value is 'ModifyProperties'.
        :param pulumi.Input[int] order: The order of execution of the automation rule action
        """
        pulumi.set(__self__, "action_configuration", action_configuration)
        pulumi.set(__self__, "action_type", 'ModifyProperties')
        pulumi.set(__self__, "order", order)

    @property
    @pulumi.getter(name="actionConfiguration")
    def action_configuration(self) -> pulumi.Input['AutomationRuleModifyPropertiesActionActionConfigurationArgs']:
        """
        The configuration of the modify properties automation rule action
        """
        return pulumi.get(self, "action_configuration")

    @action_configuration.setter
    def action_configuration(self, value: pulumi.Input['AutomationRuleModifyPropertiesActionActionConfigurationArgs']):
        pulumi.set(self, "action_configuration", value)

    @property
    @pulumi.getter(name="actionType")
    def action_type(self) -> pulumi.Input[str]:
        """
        The type of the automation rule action
        Expected value is 'ModifyProperties'.
        """
        return pulumi.get(self, "action_type")

    @action_type.setter
    def action_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "action_type", value)

    @property
    @pulumi.getter
    def order(self) -> pulumi.Input[int]:
        """
        The order of execution of the automation rule action
        """
        return pulumi.get(self, "order")

    @order.setter
    def order(self, value: pulumi.Input[int]):
        pulumi.set(self, "order", value)


@pulumi.input_type
class AutomationRulePropertyValuesConditionConditionPropertiesArgs:
    def __init__(__self__, *,
                 operator: Optional[pulumi.Input[Union[str, 'AutomationRulePropertyConditionSupportedOperator']]] = None,
                 property_name: Optional[pulumi.Input[Union[str, 'AutomationRulePropertyConditionSupportedProperty']]] = None,
                 property_values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The configuration of the automation rule condition
        :param pulumi.Input[Union[str, 'AutomationRulePropertyConditionSupportedOperator']] operator: The operator to use for evaluation the condition
        :param pulumi.Input[Union[str, 'AutomationRulePropertyConditionSupportedProperty']] property_name: The property to evaluate
        :param pulumi.Input[Sequence[pulumi.Input[str]]] property_values: The values to use for evaluating the condition
        """
        if operator is not None:
            pulumi.set(__self__, "operator", operator)
        if property_name is not None:
            pulumi.set(__self__, "property_name", property_name)
        if property_values is not None:
            pulumi.set(__self__, "property_values", property_values)

    @property
    @pulumi.getter
    def operator(self) -> Optional[pulumi.Input[Union[str, 'AutomationRulePropertyConditionSupportedOperator']]]:
        """
        The operator to use for evaluation the condition
        """
        return pulumi.get(self, "operator")

    @operator.setter
    def operator(self, value: Optional[pulumi.Input[Union[str, 'AutomationRulePropertyConditionSupportedOperator']]]):
        pulumi.set(self, "operator", value)

    @property
    @pulumi.getter(name="propertyName")
    def property_name(self) -> Optional[pulumi.Input[Union[str, 'AutomationRulePropertyConditionSupportedProperty']]]:
        """
        The property to evaluate
        """
        return pulumi.get(self, "property_name")

    @property_name.setter
    def property_name(self, value: Optional[pulumi.Input[Union[str, 'AutomationRulePropertyConditionSupportedProperty']]]):
        pulumi.set(self, "property_name", value)

    @property
    @pulumi.getter(name="propertyValues")
    def property_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The values to use for evaluating the condition
        """
        return pulumi.get(self, "property_values")

    @property_values.setter
    def property_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "property_values", value)


@pulumi.input_type
class AutomationRulePropertyValuesConditionArgs:
    def __init__(__self__, *,
                 condition_properties: pulumi.Input['AutomationRulePropertyValuesConditionConditionPropertiesArgs'],
                 condition_type: pulumi.Input[str]):
        """
        Describes an automation rule condition that evaluates a property's value
        :param pulumi.Input['AutomationRulePropertyValuesConditionConditionPropertiesArgs'] condition_properties: The configuration of the automation rule condition
        :param pulumi.Input[str] condition_type: The type of the automation rule condition
               Expected value is 'Property'.
        """
        pulumi.set(__self__, "condition_properties", condition_properties)
        pulumi.set(__self__, "condition_type", 'Property')

    @property
    @pulumi.getter(name="conditionProperties")
    def condition_properties(self) -> pulumi.Input['AutomationRulePropertyValuesConditionConditionPropertiesArgs']:
        """
        The configuration of the automation rule condition
        """
        return pulumi.get(self, "condition_properties")

    @condition_properties.setter
    def condition_properties(self, value: pulumi.Input['AutomationRulePropertyValuesConditionConditionPropertiesArgs']):
        pulumi.set(self, "condition_properties", value)

    @property
    @pulumi.getter(name="conditionType")
    def condition_type(self) -> pulumi.Input[str]:
        """
        The type of the automation rule condition
        Expected value is 'Property'.
        """
        return pulumi.get(self, "condition_type")

    @condition_type.setter
    def condition_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "condition_type", value)


@pulumi.input_type
class AutomationRuleRunPlaybookActionActionConfigurationArgs:
    def __init__(__self__, *,
                 logic_app_resource_id: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None):
        """
        The configuration of the run playbook automation rule action
        :param pulumi.Input[str] logic_app_resource_id: The resource id of the playbook resource
        :param pulumi.Input[str] tenant_id: The tenant id of the playbook resource
        """
        if logic_app_resource_id is not None:
            pulumi.set(__self__, "logic_app_resource_id", logic_app_resource_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="logicAppResourceId")
    def logic_app_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The resource id of the playbook resource
        """
        return pulumi.get(self, "logic_app_resource_id")

    @logic_app_resource_id.setter
    def logic_app_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logic_app_resource_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The tenant id of the playbook resource
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)


@pulumi.input_type
class AutomationRuleRunPlaybookActionArgs:
    def __init__(__self__, *,
                 action_configuration: pulumi.Input['AutomationRuleRunPlaybookActionActionConfigurationArgs'],
                 action_type: pulumi.Input[str],
                 order: pulumi.Input[int]):
        """
        Describes an automation rule action to run a playbook
        :param pulumi.Input['AutomationRuleRunPlaybookActionActionConfigurationArgs'] action_configuration: The configuration of the run playbook automation rule action
        :param pulumi.Input[str] action_type: The type of the automation rule action
               Expected value is 'RunPlaybook'.
        :param pulumi.Input[int] order: The order of execution of the automation rule action
        """
        pulumi.set(__self__, "action_configuration", action_configuration)
        pulumi.set(__self__, "action_type", 'RunPlaybook')
        pulumi.set(__self__, "order", order)

    @property
    @pulumi.getter(name="actionConfiguration")
    def action_configuration(self) -> pulumi.Input['AutomationRuleRunPlaybookActionActionConfigurationArgs']:
        """
        The configuration of the run playbook automation rule action
        """
        return pulumi.get(self, "action_configuration")

    @action_configuration.setter
    def action_configuration(self, value: pulumi.Input['AutomationRuleRunPlaybookActionActionConfigurationArgs']):
        pulumi.set(self, "action_configuration", value)

    @property
    @pulumi.getter(name="actionType")
    def action_type(self) -> pulumi.Input[str]:
        """
        The type of the automation rule action
        Expected value is 'RunPlaybook'.
        """
        return pulumi.get(self, "action_type")

    @action_type.setter
    def action_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "action_type", value)

    @property
    @pulumi.getter
    def order(self) -> pulumi.Input[int]:
        """
        The order of execution of the automation rule action
        """
        return pulumi.get(self, "order")

    @order.setter
    def order(self, value: pulumi.Input[int]):
        pulumi.set(self, "order", value)


@pulumi.input_type
class AutomationRuleTriggeringLogicArgs:
    def __init__(__self__, *,
                 is_enabled: pulumi.Input[bool],
                 triggers_on: pulumi.Input[Union[str, 'TriggersOn']],
                 triggers_when: pulumi.Input[Union[str, 'TriggersWhen']],
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input['AutomationRulePropertyValuesConditionArgs']]]] = None,
                 expiration_time_utc: Optional[pulumi.Input[str]] = None):
        """
        Describes automation rule triggering logic
        :param pulumi.Input[bool] is_enabled: Determines whether the automation rule is enabled or disabled.
        :param pulumi.Input[Union[str, 'TriggersOn']] triggers_on: The type of object the automation rule triggers on
        :param pulumi.Input[Union[str, 'TriggersWhen']] triggers_when: The type of event the automation rule triggers on
        :param pulumi.Input[Sequence[pulumi.Input['AutomationRulePropertyValuesConditionArgs']]] conditions: The conditions to evaluate to determine if the automation rule should be triggered on a given object
        :param pulumi.Input[str] expiration_time_utc: Determines when the automation rule should automatically expire and be disabled.
        """
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "triggers_on", triggers_on)
        pulumi.set(__self__, "triggers_when", triggers_when)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if expiration_time_utc is not None:
            pulumi.set(__self__, "expiration_time_utc", expiration_time_utc)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> pulumi.Input[bool]:
        """
        Determines whether the automation rule is enabled or disabled.
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_enabled", value)

    @property
    @pulumi.getter(name="triggersOn")
    def triggers_on(self) -> pulumi.Input[Union[str, 'TriggersOn']]:
        """
        The type of object the automation rule triggers on
        """
        return pulumi.get(self, "triggers_on")

    @triggers_on.setter
    def triggers_on(self, value: pulumi.Input[Union[str, 'TriggersOn']]):
        pulumi.set(self, "triggers_on", value)

    @property
    @pulumi.getter(name="triggersWhen")
    def triggers_when(self) -> pulumi.Input[Union[str, 'TriggersWhen']]:
        """
        The type of event the automation rule triggers on
        """
        return pulumi.get(self, "triggers_when")

    @triggers_when.setter
    def triggers_when(self, value: pulumi.Input[Union[str, 'TriggersWhen']]):
        pulumi.set(self, "triggers_when", value)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AutomationRulePropertyValuesConditionArgs']]]]:
        """
        The conditions to evaluate to determine if the automation rule should be triggered on a given object
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AutomationRulePropertyValuesConditionArgs']]]]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter(name="expirationTimeUtc")
    def expiration_time_utc(self) -> Optional[pulumi.Input[str]]:
        """
        Determines when the automation rule should automatically expire and be disabled.
        """
        return pulumi.get(self, "expiration_time_utc")

    @expiration_time_utc.setter
    def expiration_time_utc(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expiration_time_utc", value)


@pulumi.input_type
class AwsCloudTrailDataConnectorDataTypesLogsArgs:
    def __init__(__self__, *,
                 state: Optional[pulumi.Input[Union[str, 'DataTypeState']]] = None):
        """
        Logs data type.
        :param pulumi.Input[Union[str, 'DataTypeState']] state: Describe whether this data type connection is enabled or not.
        """
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[Union[str, 'DataTypeState']]]:
        """
        Describe whether this data type connection is enabled or not.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[Union[str, 'DataTypeState']]]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class AwsCloudTrailDataConnectorDataTypesArgs:
    def __init__(__self__, *,
                 logs: Optional[pulumi.Input['AwsCloudTrailDataConnectorDataTypesLogsArgs']] = None):
        """
        The available data types for Amazon Web Services CloudTrail data connector.
        :param pulumi.Input['AwsCloudTrailDataConnectorDataTypesLogsArgs'] logs: Logs data type.
        """
        if logs is not None:
            pulumi.set(__self__, "logs", logs)

    @property
    @pulumi.getter
    def logs(self) -> Optional[pulumi.Input['AwsCloudTrailDataConnectorDataTypesLogsArgs']]:
        """
        Logs data type.
        """
        return pulumi.get(self, "logs")

    @logs.setter
    def logs(self, value: Optional[pulumi.Input['AwsCloudTrailDataConnectorDataTypesLogsArgs']]):
        pulumi.set(self, "logs", value)


@pulumi.input_type
class ContentPathMapArgs:
    def __init__(__self__, *,
                 content_type: Optional[pulumi.Input[Union[str, 'ContentType']]] = None,
                 path: Optional[pulumi.Input[str]] = None):
        """
        The mapping of content type to a repo path.
        :param pulumi.Input[Union[str, 'ContentType']] content_type: Content type.
        :param pulumi.Input[str] path: The path to the content.
        """
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[pulumi.Input[Union[str, 'ContentType']]]:
        """
        Content type.
        """
        return pulumi.get(self, "content_type")

    @content_type.setter
    def content_type(self, value: Optional[pulumi.Input[Union[str, 'ContentType']]]):
        pulumi.set(self, "content_type", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The path to the content.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)


@pulumi.input_type
class DataConnectorDataTypeCommonArgs:
    def __init__(__self__, *,
                 state: Optional[pulumi.Input[Union[str, 'DataTypeState']]] = None):
        """
        Common field for data type in data connectors.
        :param pulumi.Input[Union[str, 'DataTypeState']] state: Describe whether this data type connection is enabled or not.
        """
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[Union[str, 'DataTypeState']]]:
        """
        Describe whether this data type connection is enabled or not.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[Union[str, 'DataTypeState']]]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class IncidentInfoArgs:
    def __init__(__self__, *,
                 incident_id: Optional[pulumi.Input[str]] = None,
                 relation_name: Optional[pulumi.Input[str]] = None,
                 severity: Optional[pulumi.Input[Union[str, 'IncidentSeverity']]] = None,
                 title: Optional[pulumi.Input[str]] = None):
        """
        Describes related incident information for the bookmark
        :param pulumi.Input[str] incident_id: Incident Id
        :param pulumi.Input[str] relation_name: Relation Name
        :param pulumi.Input[Union[str, 'IncidentSeverity']] severity: The severity of the incident
        :param pulumi.Input[str] title: The title of the incident
        """
        if incident_id is not None:
            pulumi.set(__self__, "incident_id", incident_id)
        if relation_name is not None:
            pulumi.set(__self__, "relation_name", relation_name)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter(name="incidentId")
    def incident_id(self) -> Optional[pulumi.Input[str]]:
        """
        Incident Id
        """
        return pulumi.get(self, "incident_id")

    @incident_id.setter
    def incident_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "incident_id", value)

    @property
    @pulumi.getter(name="relationName")
    def relation_name(self) -> Optional[pulumi.Input[str]]:
        """
        Relation Name
        """
        return pulumi.get(self, "relation_name")

    @relation_name.setter
    def relation_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "relation_name", value)

    @property
    @pulumi.getter
    def severity(self) -> Optional[pulumi.Input[Union[str, 'IncidentSeverity']]]:
        """
        The severity of the incident
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: Optional[pulumi.Input[Union[str, 'IncidentSeverity']]]):
        pulumi.set(self, "severity", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        The title of the incident
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)


@pulumi.input_type
class IncidentLabelArgs:
    def __init__(__self__, *,
                 label_name: pulumi.Input[str]):
        """
        Represents an incident label
        :param pulumi.Input[str] label_name: The name of the label
        """
        pulumi.set(__self__, "label_name", label_name)

    @property
    @pulumi.getter(name="labelName")
    def label_name(self) -> pulumi.Input[str]:
        """
        The name of the label
        """
        return pulumi.get(self, "label_name")

    @label_name.setter
    def label_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "label_name", value)


@pulumi.input_type
class IncidentOwnerInfoArgs:
    def __init__(__self__, *,
                 assigned_to: Optional[pulumi.Input[str]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 object_id: Optional[pulumi.Input[str]] = None,
                 user_principal_name: Optional[pulumi.Input[str]] = None):
        """
        Information on the user an incident is assigned to
        :param pulumi.Input[str] assigned_to: The name of the user the incident is assigned to.
        :param pulumi.Input[str] email: The email of the user the incident is assigned to.
        :param pulumi.Input[str] object_id: The object id of the user the incident is assigned to.
        :param pulumi.Input[str] user_principal_name: The user principal name of the user the incident is assigned to.
        """
        if assigned_to is not None:
            pulumi.set(__self__, "assigned_to", assigned_to)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)
        if user_principal_name is not None:
            pulumi.set(__self__, "user_principal_name", user_principal_name)

    @property
    @pulumi.getter(name="assignedTo")
    def assigned_to(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the user the incident is assigned to.
        """
        return pulumi.get(self, "assigned_to")

    @assigned_to.setter
    def assigned_to(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "assigned_to", value)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[str]]:
        """
        The email of the user the incident is assigned to.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[pulumi.Input[str]]:
        """
        The object id of the user the incident is assigned to.
        """
        return pulumi.get(self, "object_id")

    @object_id.setter
    def object_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object_id", value)

    @property
    @pulumi.getter(name="userPrincipalName")
    def user_principal_name(self) -> Optional[pulumi.Input[str]]:
        """
        The user principal name of the user the incident is assigned to.
        """
        return pulumi.get(self, "user_principal_name")

    @user_principal_name.setter
    def user_principal_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_principal_name", value)


@pulumi.input_type
class MCASDataConnectorDataTypesArgs:
    def __init__(__self__, *,
                 alerts: Optional[pulumi.Input['DataConnectorDataTypeCommonArgs']] = None,
                 discovery_logs: Optional[pulumi.Input['DataConnectorDataTypeCommonArgs']] = None):
        """
        The available data types for MCAS (Microsoft Cloud App Security) data connector.
        :param pulumi.Input['DataConnectorDataTypeCommonArgs'] alerts: Alerts data type connection.
        :param pulumi.Input['DataConnectorDataTypeCommonArgs'] discovery_logs: Discovery log data type connection.
        """
        if alerts is not None:
            pulumi.set(__self__, "alerts", alerts)
        if discovery_logs is not None:
            pulumi.set(__self__, "discovery_logs", discovery_logs)

    @property
    @pulumi.getter
    def alerts(self) -> Optional[pulumi.Input['DataConnectorDataTypeCommonArgs']]:
        """
        Alerts data type connection.
        """
        return pulumi.get(self, "alerts")

    @alerts.setter
    def alerts(self, value: Optional[pulumi.Input['DataConnectorDataTypeCommonArgs']]):
        pulumi.set(self, "alerts", value)

    @property
    @pulumi.getter(name="discoveryLogs")
    def discovery_logs(self) -> Optional[pulumi.Input['DataConnectorDataTypeCommonArgs']]:
        """
        Discovery log data type connection.
        """
        return pulumi.get(self, "discovery_logs")

    @discovery_logs.setter
    def discovery_logs(self, value: Optional[pulumi.Input['DataConnectorDataTypeCommonArgs']]):
        pulumi.set(self, "discovery_logs", value)


@pulumi.input_type
class MetadataAuthorArgs:
    def __init__(__self__, *,
                 email: Optional[pulumi.Input[str]] = None,
                 link: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Publisher or creator of the content item.
        :param pulumi.Input[str] email: Email of author contact
        :param pulumi.Input[str] link: Link for author/vendor page
        :param pulumi.Input[str] name: Name of the author. Company or person.
        """
        if email is not None:
            pulumi.set(__self__, "email", email)
        if link is not None:
            pulumi.set(__self__, "link", link)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[str]]:
        """
        Email of author contact
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter
    def link(self) -> Optional[pulumi.Input[str]]:
        """
        Link for author/vendor page
        """
        return pulumi.get(self, "link")

    @link.setter
    def link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "link", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the author. Company or person.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class MetadataCategoriesArgs:
    def __init__(__self__, *,
                 domains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 verticals: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        ies for the solution content item
        :param pulumi.Input[Sequence[pulumi.Input[str]]] domains: domain for the solution content item
        :param pulumi.Input[Sequence[pulumi.Input[str]]] verticals: Industry verticals for the solution content item
        """
        if domains is not None:
            pulumi.set(__self__, "domains", domains)
        if verticals is not None:
            pulumi.set(__self__, "verticals", verticals)

    @property
    @pulumi.getter
    def domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        domain for the solution content item
        """
        return pulumi.get(self, "domains")

    @domains.setter
    def domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "domains", value)

    @property
    @pulumi.getter
    def verticals(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Industry verticals for the solution content item
        """
        return pulumi.get(self, "verticals")

    @verticals.setter
    def verticals(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "verticals", value)


@pulumi.input_type
class MetadataDependenciesArgs:
    def __init__(__self__, *,
                 content_id: Optional[pulumi.Input[str]] = None,
                 criteria: Optional[pulumi.Input[Sequence[pulumi.Input['MetadataDependenciesArgs']]]] = None,
                 kind: Optional[pulumi.Input[Union[str, 'Kind']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 operator: Optional[pulumi.Input[Union[str, 'Operator']]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        Dependencies for the content item, what other content items it requires to work.  Can describe more complex dependencies using a recursive/nested structure. For a single dependency an id/kind/version can be supplied or operator/criteria for complex dependencies.
        :param pulumi.Input[str] content_id: Id of the content item we depend on
        :param pulumi.Input[Sequence[pulumi.Input['MetadataDependenciesArgs']]] criteria: This is the list of dependencies we must fulfill, according to the AND/OR operator
        :param pulumi.Input[Union[str, 'Kind']] kind: Type of the content item we depend on
        :param pulumi.Input[str] name: Name of the content item
        :param pulumi.Input[Union[str, 'Operator']] operator: Operator used for list of dependencies in criteria array.
        :param pulumi.Input[str] version: Version of the the content item we depend on.  Can be blank, * or missing to indicate any version fulfills the dependency.  If version does not match our defined numeric format then an exact match is required.
        """
        if content_id is not None:
            pulumi.set(__self__, "content_id", content_id)
        if criteria is not None:
            pulumi.set(__self__, "criteria", criteria)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if operator is not None:
            pulumi.set(__self__, "operator", operator)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="contentId")
    def content_id(self) -> Optional[pulumi.Input[str]]:
        """
        Id of the content item we depend on
        """
        return pulumi.get(self, "content_id")

    @content_id.setter
    def content_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content_id", value)

    @property
    @pulumi.getter
    def criteria(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MetadataDependenciesArgs']]]]:
        """
        This is the list of dependencies we must fulfill, according to the AND/OR operator
        """
        return pulumi.get(self, "criteria")

    @criteria.setter
    def criteria(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MetadataDependenciesArgs']]]]):
        pulumi.set(self, "criteria", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[Union[str, 'Kind']]]:
        """
        Type of the content item we depend on
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[Union[str, 'Kind']]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the content item
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def operator(self) -> Optional[pulumi.Input[Union[str, 'Operator']]]:
        """
        Operator used for list of dependencies in criteria array.
        """
        return pulumi.get(self, "operator")

    @operator.setter
    def operator(self, value: Optional[pulumi.Input[Union[str, 'Operator']]]):
        pulumi.set(self, "operator", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Version of the the content item we depend on.  Can be blank, * or missing to indicate any version fulfills the dependency.  If version does not match our defined numeric format then an exact match is required.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class MetadataSourceArgs:
    def __init__(__self__, *,
                 kind: pulumi.Input[Union[str, 'SourceKind']],
                 name: Optional[pulumi.Input[str]] = None,
                 source_id: Optional[pulumi.Input[str]] = None):
        """
        The original source of the content item, where it comes from.
        :param pulumi.Input[Union[str, 'SourceKind']] kind: Source type of the content
        :param pulumi.Input[str] name: Name of the content source.  The repo name, solution name, LA workspace name etc.
        :param pulumi.Input[str] source_id: ID of the content source.  The solution ID, workspace ID, etc
        """
        pulumi.set(__self__, "kind", kind)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if source_id is not None:
            pulumi.set(__self__, "source_id", source_id)

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Input[Union[str, 'SourceKind']]:
        """
        Source type of the content
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: pulumi.Input[Union[str, 'SourceKind']]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the content source.  The repo name, solution name, LA workspace name etc.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="sourceId")
    def source_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the content source.  The solution ID, workspace ID, etc
        """
        return pulumi.get(self, "source_id")

    @source_id.setter
    def source_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_id", value)


@pulumi.input_type
class MetadataSupportArgs:
    def __init__(__self__, *,
                 tier: pulumi.Input[Union[str, 'SupportTier']],
                 email: Optional[pulumi.Input[str]] = None,
                 link: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Support information for the content item.
        :param pulumi.Input[Union[str, 'SupportTier']] tier: Type of support for content item
        :param pulumi.Input[str] email: Email of support contact
        :param pulumi.Input[str] link: Link for support help, like to support page to open a ticket etc.
        :param pulumi.Input[str] name: Name of the support contact. Company or person.
        """
        pulumi.set(__self__, "tier", tier)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if link is not None:
            pulumi.set(__self__, "link", link)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def tier(self) -> pulumi.Input[Union[str, 'SupportTier']]:
        """
        Type of support for content item
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: pulumi.Input[Union[str, 'SupportTier']]):
        pulumi.set(self, "tier", value)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[str]]:
        """
        Email of support contact
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter
    def link(self) -> Optional[pulumi.Input[str]]:
        """
        Link for support help, like to support page to open a ticket etc.
        """
        return pulumi.get(self, "link")

    @link.setter
    def link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "link", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the support contact. Company or person.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class OfficeDataConnectorDataTypesExchangeArgs:
    def __init__(__self__, *,
                 state: Optional[pulumi.Input[Union[str, 'DataTypeState']]] = None):
        """
        Exchange data type connection.
        :param pulumi.Input[Union[str, 'DataTypeState']] state: Describe whether this data type connection is enabled or not.
        """
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[Union[str, 'DataTypeState']]]:
        """
        Describe whether this data type connection is enabled or not.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[Union[str, 'DataTypeState']]]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class OfficeDataConnectorDataTypesSharePointArgs:
    def __init__(__self__, *,
                 state: Optional[pulumi.Input[Union[str, 'DataTypeState']]] = None):
        """
        SharePoint data type connection.
        :param pulumi.Input[Union[str, 'DataTypeState']] state: Describe whether this data type connection is enabled or not.
        """
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[Union[str, 'DataTypeState']]]:
        """
        Describe whether this data type connection is enabled or not.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[Union[str, 'DataTypeState']]]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class OfficeDataConnectorDataTypesTeamsArgs:
    def __init__(__self__, *,
                 state: Optional[pulumi.Input[Union[str, 'DataTypeState']]] = None):
        """
        Teams data type connection.
        :param pulumi.Input[Union[str, 'DataTypeState']] state: Describe whether this data type connection is enabled or not.
        """
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[Union[str, 'DataTypeState']]]:
        """
        Describe whether this data type connection is enabled or not.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[Union[str, 'DataTypeState']]]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class OfficeDataConnectorDataTypesArgs:
    def __init__(__self__, *,
                 exchange: Optional[pulumi.Input['OfficeDataConnectorDataTypesExchangeArgs']] = None,
                 share_point: Optional[pulumi.Input['OfficeDataConnectorDataTypesSharePointArgs']] = None,
                 teams: Optional[pulumi.Input['OfficeDataConnectorDataTypesTeamsArgs']] = None):
        """
        The available data types for office data connector.
        :param pulumi.Input['OfficeDataConnectorDataTypesExchangeArgs'] exchange: Exchange data type connection.
        :param pulumi.Input['OfficeDataConnectorDataTypesSharePointArgs'] share_point: SharePoint data type connection.
        :param pulumi.Input['OfficeDataConnectorDataTypesTeamsArgs'] teams: Teams data type connection.
        """
        if exchange is not None:
            pulumi.set(__self__, "exchange", exchange)
        if share_point is not None:
            pulumi.set(__self__, "share_point", share_point)
        if teams is not None:
            pulumi.set(__self__, "teams", teams)

    @property
    @pulumi.getter
    def exchange(self) -> Optional[pulumi.Input['OfficeDataConnectorDataTypesExchangeArgs']]:
        """
        Exchange data type connection.
        """
        return pulumi.get(self, "exchange")

    @exchange.setter
    def exchange(self, value: Optional[pulumi.Input['OfficeDataConnectorDataTypesExchangeArgs']]):
        pulumi.set(self, "exchange", value)

    @property
    @pulumi.getter(name="sharePoint")
    def share_point(self) -> Optional[pulumi.Input['OfficeDataConnectorDataTypesSharePointArgs']]:
        """
        SharePoint data type connection.
        """
        return pulumi.get(self, "share_point")

    @share_point.setter
    def share_point(self, value: Optional[pulumi.Input['OfficeDataConnectorDataTypesSharePointArgs']]):
        pulumi.set(self, "share_point", value)

    @property
    @pulumi.getter
    def teams(self) -> Optional[pulumi.Input['OfficeDataConnectorDataTypesTeamsArgs']]:
        """
        Teams data type connection.
        """
        return pulumi.get(self, "teams")

    @teams.setter
    def teams(self, value: Optional[pulumi.Input['OfficeDataConnectorDataTypesTeamsArgs']]):
        pulumi.set(self, "teams", value)


@pulumi.input_type
class RepositoryArgs:
    def __init__(__self__, *,
                 branch: Optional[pulumi.Input[str]] = None,
                 deployment_logs_url: Optional[pulumi.Input[str]] = None,
                 display_url: Optional[pulumi.Input[str]] = None,
                 path_mapping: Optional[pulumi.Input[Sequence[pulumi.Input['ContentPathMapArgs']]]] = None,
                 url: Optional[pulumi.Input[str]] = None):
        """
        metadata of a repository.
        :param pulumi.Input[str] branch: Branch name of repository.
        :param pulumi.Input[str] deployment_logs_url: Url to access repository action logs.
        :param pulumi.Input[str] display_url: Display url of repository.
        :param pulumi.Input[Sequence[pulumi.Input['ContentPathMapArgs']]] path_mapping: Dictionary of source control content type and path mapping.
        :param pulumi.Input[str] url: Url of repository.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if deployment_logs_url is not None:
            pulumi.set(__self__, "deployment_logs_url", deployment_logs_url)
        if display_url is not None:
            pulumi.set(__self__, "display_url", display_url)
        if path_mapping is not None:
            pulumi.set(__self__, "path_mapping", path_mapping)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def branch(self) -> Optional[pulumi.Input[str]]:
        """
        Branch name of repository.
        """
        return pulumi.get(self, "branch")

    @branch.setter
    def branch(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "branch", value)

    @property
    @pulumi.getter(name="deploymentLogsUrl")
    def deployment_logs_url(self) -> Optional[pulumi.Input[str]]:
        """
        Url to access repository action logs.
        """
        return pulumi.get(self, "deployment_logs_url")

    @deployment_logs_url.setter
    def deployment_logs_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deployment_logs_url", value)

    @property
    @pulumi.getter(name="displayUrl")
    def display_url(self) -> Optional[pulumi.Input[str]]:
        """
        Display url of repository.
        """
        return pulumi.get(self, "display_url")

    @display_url.setter
    def display_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_url", value)

    @property
    @pulumi.getter(name="pathMapping")
    def path_mapping(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContentPathMapArgs']]]]:
        """
        Dictionary of source control content type and path mapping.
        """
        return pulumi.get(self, "path_mapping")

    @path_mapping.setter
    def path_mapping(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContentPathMapArgs']]]]):
        pulumi.set(self, "path_mapping", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        Url of repository.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class TIDataConnectorDataTypesIndicatorsArgs:
    def __init__(__self__, *,
                 state: Optional[pulumi.Input[Union[str, 'DataTypeState']]] = None):
        """
        Data type for indicators connection.
        :param pulumi.Input[Union[str, 'DataTypeState']] state: Describe whether this data type connection is enabled or not.
        """
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[Union[str, 'DataTypeState']]]:
        """
        Describe whether this data type connection is enabled or not.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[Union[str, 'DataTypeState']]]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class TIDataConnectorDataTypesArgs:
    def __init__(__self__, *,
                 indicators: Optional[pulumi.Input['TIDataConnectorDataTypesIndicatorsArgs']] = None):
        """
        The available data types for TI (Threat Intelligence) data connector.
        :param pulumi.Input['TIDataConnectorDataTypesIndicatorsArgs'] indicators: Data type for indicators connection.
        """
        if indicators is not None:
            pulumi.set(__self__, "indicators", indicators)

    @property
    @pulumi.getter
    def indicators(self) -> Optional[pulumi.Input['TIDataConnectorDataTypesIndicatorsArgs']]:
        """
        Data type for indicators connection.
        """
        return pulumi.get(self, "indicators")

    @indicators.setter
    def indicators(self, value: Optional[pulumi.Input['TIDataConnectorDataTypesIndicatorsArgs']]):
        pulumi.set(self, "indicators", value)


@pulumi.input_type
class ThreatIntelligenceExternalReferenceArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 external_id: Optional[pulumi.Input[str]] = None,
                 hashes: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 source_name: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None):
        """
        Describes external reference
        :param pulumi.Input[str] description: External reference description
        :param pulumi.Input[str] external_id: External reference ID
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] hashes: External reference hashes
        :param pulumi.Input[str] source_name: External reference source name
        :param pulumi.Input[str] url: External reference URL
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if hashes is not None:
            pulumi.set(__self__, "hashes", hashes)
        if source_name is not None:
            pulumi.set(__self__, "source_name", source_name)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        External reference description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[pulumi.Input[str]]:
        """
        External reference ID
        """
        return pulumi.get(self, "external_id")

    @external_id.setter
    def external_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "external_id", value)

    @property
    @pulumi.getter
    def hashes(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        External reference hashes
        """
        return pulumi.get(self, "hashes")

    @hashes.setter
    def hashes(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "hashes", value)

    @property
    @pulumi.getter(name="sourceName")
    def source_name(self) -> Optional[pulumi.Input[str]]:
        """
        External reference source name
        """
        return pulumi.get(self, "source_name")

    @source_name.setter
    def source_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_name", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        External reference URL
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class ThreatIntelligenceGranularMarkingModelArgs:
    def __init__(__self__, *,
                 language: Optional[pulumi.Input[str]] = None,
                 marking_ref: Optional[pulumi.Input[int]] = None,
                 selectors: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Describes threat granular marking model entity
        :param pulumi.Input[str] language: Language granular marking model
        :param pulumi.Input[int] marking_ref: marking reference granular marking model
        :param pulumi.Input[Sequence[pulumi.Input[str]]] selectors: granular marking model selectors
        """
        if language is not None:
            pulumi.set(__self__, "language", language)
        if marking_ref is not None:
            pulumi.set(__self__, "marking_ref", marking_ref)
        if selectors is not None:
            pulumi.set(__self__, "selectors", selectors)

    @property
    @pulumi.getter
    def language(self) -> Optional[pulumi.Input[str]]:
        """
        Language granular marking model
        """
        return pulumi.get(self, "language")

    @language.setter
    def language(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "language", value)

    @property
    @pulumi.getter(name="markingRef")
    def marking_ref(self) -> Optional[pulumi.Input[int]]:
        """
        marking reference granular marking model
        """
        return pulumi.get(self, "marking_ref")

    @marking_ref.setter
    def marking_ref(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "marking_ref", value)

    @property
    @pulumi.getter
    def selectors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        granular marking model selectors
        """
        return pulumi.get(self, "selectors")

    @selectors.setter
    def selectors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "selectors", value)


@pulumi.input_type
class ThreatIntelligenceKillChainPhaseArgs:
    def __init__(__self__, *,
                 kill_chain_name: Optional[pulumi.Input[str]] = None,
                 phase_name: Optional[pulumi.Input[str]] = None):
        """
        Describes threat kill chain phase entity
        :param pulumi.Input[str] kill_chain_name: Kill chainName name
        :param pulumi.Input[str] phase_name: Phase name
        """
        if kill_chain_name is not None:
            pulumi.set(__self__, "kill_chain_name", kill_chain_name)
        if phase_name is not None:
            pulumi.set(__self__, "phase_name", phase_name)

    @property
    @pulumi.getter(name="killChainName")
    def kill_chain_name(self) -> Optional[pulumi.Input[str]]:
        """
        Kill chainName name
        """
        return pulumi.get(self, "kill_chain_name")

    @kill_chain_name.setter
    def kill_chain_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kill_chain_name", value)

    @property
    @pulumi.getter(name="phaseName")
    def phase_name(self) -> Optional[pulumi.Input[str]]:
        """
        Phase name
        """
        return pulumi.get(self, "phase_name")

    @phase_name.setter
    def phase_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "phase_name", value)


@pulumi.input_type
class ThreatIntelligenceParsedPatternTypeValueArgs:
    def __init__(__self__, *,
                 value: Optional[pulumi.Input[str]] = None,
                 value_type: Optional[pulumi.Input[str]] = None):
        """
        Describes threat kill chain phase entity
        :param pulumi.Input[str] value: Value of parsed pattern
        :param pulumi.Input[str] value_type: Type of the value
        """
        if value is not None:
            pulumi.set(__self__, "value", value)
        if value_type is not None:
            pulumi.set(__self__, "value_type", value_type)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Value of parsed pattern
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter(name="valueType")
    def value_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of the value
        """
        return pulumi.get(self, "value_type")

    @value_type.setter
    def value_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value_type", value)


@pulumi.input_type
class ThreatIntelligenceParsedPatternArgs:
    def __init__(__self__, *,
                 pattern_type_key: Optional[pulumi.Input[str]] = None,
                 pattern_type_values: Optional[pulumi.Input[Sequence[pulumi.Input['ThreatIntelligenceParsedPatternTypeValueArgs']]]] = None):
        """
        Describes parsed pattern entity
        :param pulumi.Input[str] pattern_type_key: Pattern type key
        :param pulumi.Input[Sequence[pulumi.Input['ThreatIntelligenceParsedPatternTypeValueArgs']]] pattern_type_values: Pattern type keys
        """
        if pattern_type_key is not None:
            pulumi.set(__self__, "pattern_type_key", pattern_type_key)
        if pattern_type_values is not None:
            pulumi.set(__self__, "pattern_type_values", pattern_type_values)

    @property
    @pulumi.getter(name="patternTypeKey")
    def pattern_type_key(self) -> Optional[pulumi.Input[str]]:
        """
        Pattern type key
        """
        return pulumi.get(self, "pattern_type_key")

    @pattern_type_key.setter
    def pattern_type_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pattern_type_key", value)

    @property
    @pulumi.getter(name="patternTypeValues")
    def pattern_type_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ThreatIntelligenceParsedPatternTypeValueArgs']]]]:
        """
        Pattern type keys
        """
        return pulumi.get(self, "pattern_type_values")

    @pattern_type_values.setter
    def pattern_type_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ThreatIntelligenceParsedPatternTypeValueArgs']]]]):
        pulumi.set(self, "pattern_type_values", value)


@pulumi.input_type
class UserInfoArgs:
    def __init__(__self__, *,
                 object_id: pulumi.Input[str]):
        """
        User information that made some action
        :param pulumi.Input[str] object_id: The object id of the user.
        """
        pulumi.set(__self__, "object_id", object_id)

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> pulumi.Input[str]:
        """
        The object id of the user.
        """
        return pulumi.get(self, "object_id")

    @object_id.setter
    def object_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "object_id", value)


@pulumi.input_type
class WatchlistUserInfoArgs:
    def __init__(__self__, *,
                 object_id: Optional[pulumi.Input[str]] = None):
        """
        User information that made some action
        :param pulumi.Input[str] object_id: The object id of the user.
        """
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[pulumi.Input[str]]:
        """
        The object id of the user.
        """
        return pulumi.get(self, "object_id")

    @object_id.setter
    def object_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object_id", value)


