# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

from enum import Enum

__all__ = [
    'ActionType',
    'AssessmentStatusCode',
    'AssessmentType',
    'Categories',
    'EventSource',
    'ImplementationEffort',
    'Operator',
    'PropertyType',
    'RuleState',
    'Severity',
    'Source',
    'Threats',
    'UserImpact',
]


class ActionType(str, Enum):
    """
    The type of the action that will be triggered by the Automation
    """
    LOGIC_APP = "LogicApp"
    EVENT_HUB = "EventHub"
    WORKSPACE = "Workspace"


class AssessmentStatusCode(str, Enum):
    """
    Programmatic code for the status of the assessment
    """
    HEALTHY = "Healthy"
    """
    The resource is healthy
    """
    UNHEALTHY = "Unhealthy"
    """
    The resource has a security issue that needs to be addressed
    """
    NOT_APPLICABLE = "NotApplicable"
    """
    Assessment for this resource did not happen
    """


class AssessmentType(str, Enum):
    """
    BuiltIn if the assessment based on built-in Azure Policy definition, Custom if the assessment based on custom Azure Policy definition
    """
    BUILT_IN = "BuiltIn"
    """
    Azure Security Center managed assessments
    """
    CUSTOM_POLICY = "CustomPolicy"
    """
    User defined policies that are automatically ingested from Azure Policy to Azure Security Center
    """
    CUSTOMER_MANAGED = "CustomerManaged"
    """
    User assessments pushed directly by the user or other third party to Azure Security Center
    """


class Categories(str, Enum):
    """
    The categories of resource that is at risk when the assessment is unhealthy
    """
    COMPUTE = "Compute"
    NETWORKING = "Networking"
    DATA = "Data"
    IDENTITY_AND_ACCESS = "IdentityAndAccess"
    IO_T = "IoT"


class EventSource(str, Enum):
    """
    A valid event source type.
    """
    ASSESSMENTS = "Assessments"
    ASSESSMENTS_SNAPSHOT = "AssessmentsSnapshot"
    SUB_ASSESSMENTS = "SubAssessments"
    SUB_ASSESSMENTS_SNAPSHOT = "SubAssessmentsSnapshot"
    ALERTS = "Alerts"
    SECURE_SCORES = "SecureScores"
    SECURE_SCORES_SNAPSHOT = "SecureScoresSnapshot"
    SECURE_SCORE_CONTROLS = "SecureScoreControls"
    SECURE_SCORE_CONTROLS_SNAPSHOT = "SecureScoreControlsSnapshot"
    REGULATORY_COMPLIANCE_ASSESSMENT = "RegulatoryComplianceAssessment"
    REGULATORY_COMPLIANCE_ASSESSMENT_SNAPSHOT = "RegulatoryComplianceAssessmentSnapshot"


class ImplementationEffort(str, Enum):
    """
    The implementation effort required to remediate this assessment
    """
    LOW = "Low"
    MODERATE = "Moderate"
    HIGH = "High"


class Operator(str, Enum):
    """
    A valid comparer operator to use. A case-insensitive comparison will be applied for String PropertyType.
    """
    EQUALS = "Equals"
    """
    Applies for decimal and non-decimal operands
    """
    GREATER_THAN = "GreaterThan"
    """
    Applies only for decimal operands
    """
    GREATER_THAN_OR_EQUAL_TO = "GreaterThanOrEqualTo"
    """
    Applies only for decimal operands
    """
    LESSER_THAN = "LesserThan"
    """
    Applies only for decimal operands
    """
    LESSER_THAN_OR_EQUAL_TO = "LesserThanOrEqualTo"
    """
    Applies only for decimal operands
    """
    NOT_EQUALS = "NotEquals"
    """
    Applies  for decimal and non-decimal operands
    """
    CONTAINS = "Contains"
    """
    Applies only for non-decimal operands
    """
    STARTS_WITH = "StartsWith"
    """
    Applies only for non-decimal operands
    """
    ENDS_WITH = "EndsWith"
    """
    Applies only for non-decimal operands
    """


class PropertyType(str, Enum):
    """
    The data type of the compared operands (string, integer, floating point number or a boolean [true/false]]
    """
    STRING = "String"
    INTEGER = "Integer"
    NUMBER = "Number"
    BOOLEAN = "Boolean"


class RuleState(str, Enum):
    """
    Possible states of the rule
    """
    ENABLED = "Enabled"
    DISABLED = "Disabled"
    EXPIRED = "Expired"


class Severity(str, Enum):
    """
    The severity level of the assessment
    """
    LOW = "Low"
    MEDIUM = "Medium"
    HIGH = "High"


class Source(str, Enum):
    """
    The platform where the assessed resource resides
    """
    AZURE = "Azure"
    """
    Resource is in Azure
    """
    ON_PREMISE = "OnPremise"
    """
    Resource in an on premise machine connected to Azure cloud
    """
    ON_PREMISE_SQL = "OnPremiseSql"
    """
    SQL Resource in an on premise machine connected to Azure cloud
    """


class Threats(str, Enum):
    """
    Threats impact of the assessment
    """
    ACCOUNT_BREACH = "accountBreach"
    DATA_EXFILTRATION = "dataExfiltration"
    DATA_SPILLAGE = "dataSpillage"
    MALICIOUS_INSIDER = "maliciousInsider"
    ELEVATION_OF_PRIVILEGE = "elevationOfPrivilege"
    THREAT_RESISTANCE = "threatResistance"
    MISSING_COVERAGE = "missingCoverage"
    DENIAL_OF_SERVICE = "denialOfService"


class UserImpact(str, Enum):
    """
    The user impact of the assessment
    """
    LOW = "Low"
    MODERATE = "Moderate"
    HIGH = "High"
