# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['ServerVulnerabilityAssessmentArgs', 'ServerVulnerabilityAssessment']

@pulumi.input_type
class ServerVulnerabilityAssessmentArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[str],
                 resource_name: pulumi.Input[str],
                 resource_namespace: pulumi.Input[str],
                 resource_type: pulumi.Input[str],
                 server_vulnerability_assessment: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ServerVulnerabilityAssessment resource.
        :param pulumi.Input[str] resource_group_name: The name of the resource group within the user's subscription. The name is case insensitive.
        :param pulumi.Input[str] resource_name: Name of the resource.
        :param pulumi.Input[str] resource_namespace: The Namespace of the resource.
        :param pulumi.Input[str] resource_type: The type of the resource.
        :param pulumi.Input[str] server_vulnerability_assessment: ServerVulnerabilityAssessment status. only a 'default' value is supported.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "resource_name", resource_name)
        pulumi.set(__self__, "resource_namespace", resource_namespace)
        pulumi.set(__self__, "resource_type", resource_type)
        if server_vulnerability_assessment is not None:
            pulumi.set(__self__, "server_vulnerability_assessment", server_vulnerability_assessment)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[str]:
        """
        The name of the resource group within the user's subscription. The name is case insensitive.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> pulumi.Input[str]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "resource_name")

    @resource_name.setter
    def resource_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_name", value)

    @property
    @pulumi.getter(name="resourceNamespace")
    def resource_namespace(self) -> pulumi.Input[str]:
        """
        The Namespace of the resource.
        """
        return pulumi.get(self, "resource_namespace")

    @resource_namespace.setter
    def resource_namespace(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_namespace", value)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Input[str]:
        """
        The type of the resource.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter(name="serverVulnerabilityAssessment")
    def server_vulnerability_assessment(self) -> Optional[pulumi.Input[str]]:
        """
        ServerVulnerabilityAssessment status. only a 'default' value is supported.
        """
        return pulumi.get(self, "server_vulnerability_assessment")

    @server_vulnerability_assessment.setter
    def server_vulnerability_assessment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_vulnerability_assessment", value)


class ServerVulnerabilityAssessment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 resource_name_: Optional[pulumi.Input[str]] = None,
                 resource_namespace: Optional[pulumi.Input[str]] = None,
                 resource_type: Optional[pulumi.Input[str]] = None,
                 server_vulnerability_assessment: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Describes the server vulnerability assessment details on a resource
        API Version: 2020-01-01.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] resource_group_name: The name of the resource group within the user's subscription. The name is case insensitive.
        :param pulumi.Input[str] resource_name_: Name of the resource.
        :param pulumi.Input[str] resource_namespace: The Namespace of the resource.
        :param pulumi.Input[str] resource_type: The type of the resource.
        :param pulumi.Input[str] server_vulnerability_assessment: ServerVulnerabilityAssessment status. only a 'default' value is supported.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServerVulnerabilityAssessmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Describes the server vulnerability assessment details on a resource
        API Version: 2020-01-01.

        :param str resource_name: The name of the resource.
        :param ServerVulnerabilityAssessmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServerVulnerabilityAssessmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 resource_name_: Optional[pulumi.Input[str]] = None,
                 resource_namespace: Optional[pulumi.Input[str]] = None,
                 resource_type: Optional[pulumi.Input[str]] = None,
                 server_vulnerability_assessment: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServerVulnerabilityAssessmentArgs.__new__(ServerVulnerabilityAssessmentArgs)

            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if resource_name_ is None and not opts.urn:
                raise TypeError("Missing required property 'resource_name_'")
            __props__.__dict__["resource_name"] = resource_name_
            if resource_namespace is None and not opts.urn:
                raise TypeError("Missing required property 'resource_namespace'")
            __props__.__dict__["resource_namespace"] = resource_namespace
            if resource_type is None and not opts.urn:
                raise TypeError("Missing required property 'resource_type'")
            __props__.__dict__["resource_type"] = resource_type
            __props__.__dict__["server_vulnerability_assessment"] = server_vulnerability_assessment
            __props__.__dict__["name"] = None
            __props__.__dict__["provisioning_state"] = None
            __props__.__dict__["type"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="azure-native:security/v20200101:ServerVulnerabilityAssessment")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(ServerVulnerabilityAssessment, __self__).__init__(
            'azure-native:security:ServerVulnerabilityAssessment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'ServerVulnerabilityAssessment':
        """
        Get an existing ServerVulnerabilityAssessment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ServerVulnerabilityAssessmentArgs.__new__(ServerVulnerabilityAssessmentArgs)

        __props__.__dict__["name"] = None
        __props__.__dict__["provisioning_state"] = None
        __props__.__dict__["type"] = None
        return ServerVulnerabilityAssessment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Resource name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> pulumi.Output[str]:
        """
        The provisioningState of the vulnerability assessment capability on the VM
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Resource type
        """
        return pulumi.get(self, "type")

