# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = [
    'StorageAccountResponse',
    'StorageInsightStatusResponse',
    'TagResponse',
]

@pulumi.output_type
class StorageAccountResponse(dict):
    """
    Describes a storage account connection.
    """
    def __init__(__self__, *,
                 id: str,
                 key: str):
        """
        Describes a storage account connection.
        :param str id: The Azure Resource Manager ID of the storage account resource.
        :param str key: The storage account key.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The Azure Resource Manager ID of the storage account resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The storage account key.
        """
        return pulumi.get(self, "key")


@pulumi.output_type
class StorageInsightStatusResponse(dict):
    """
    The status of the storage insight.
    """
    def __init__(__self__, *,
                 state: str,
                 description: Optional[str] = None):
        """
        The status of the storage insight.
        :param str state: The state of the storage insight connection to the workspace
        :param str description: Description of the state of the storage insight.
        """
        pulumi.set(__self__, "state", state)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of the storage insight connection to the workspace
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of the state of the storage insight.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class TagResponse(dict):
    """
    A tag of a saved search.
    """
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        A tag of a saved search.
        :param str name: The tag name.
        :param str value: The tag value.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The tag name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The tag value.
        """
        return pulumi.get(self, "value")


