# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetManagementGroupNetworkManagerConnectionResult',
    'AwaitableGetManagementGroupNetworkManagerConnectionResult',
    'get_management_group_network_manager_connection',
    'get_management_group_network_manager_connection_output',
]

@pulumi.output_type
class GetManagementGroupNetworkManagerConnectionResult:
    """
    The Network Manager Connection resource
    """
    def __init__(__self__, description=None, etag=None, id=None, name=None, network_manager_id=None, system_data=None, type=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if network_manager_id and not isinstance(network_manager_id, str):
            raise TypeError("Expected argument 'network_manager_id' to be a str")
        pulumi.set(__self__, "network_manager_id", network_manager_id)
        if system_data and not isinstance(system_data, dict):
            raise TypeError("Expected argument 'system_data' to be a dict")
        pulumi.set(__self__, "system_data", system_data)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description of the scope connection.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkManagerId")
    def network_manager_id(self) -> Optional[str]:
        """
        Network Manager Id.
        """
        return pulumi.get(self, "network_manager_id")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> 'outputs.SystemDataResponse':
        """
        The system metadata related to this resource.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type.
        """
        return pulumi.get(self, "type")


class AwaitableGetManagementGroupNetworkManagerConnectionResult(GetManagementGroupNetworkManagerConnectionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetManagementGroupNetworkManagerConnectionResult(
            description=self.description,
            etag=self.etag,
            id=self.id,
            name=self.name,
            network_manager_id=self.network_manager_id,
            system_data=self.system_data,
            type=self.type)


def get_management_group_network_manager_connection(management_group_id: Optional[str] = None,
                                                    network_manager_connection_name: Optional[str] = None,
                                                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetManagementGroupNetworkManagerConnectionResult:
    """
    The Network Manager Connection resource


    :param str management_group_id: The management group Id which uniquely identify the Microsoft Azure management group.
    :param str network_manager_connection_name: Name for the network manager connection.
    """
    __args__ = dict()
    __args__['managementGroupId'] = management_group_id
    __args__['networkManagerConnectionName'] = network_manager_connection_name
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('azure-native:network/v20210501preview:getManagementGroupNetworkManagerConnection', __args__, opts=opts, typ=GetManagementGroupNetworkManagerConnectionResult).value

    return AwaitableGetManagementGroupNetworkManagerConnectionResult(
        description=__ret__.description,
        etag=__ret__.etag,
        id=__ret__.id,
        name=__ret__.name,
        network_manager_id=__ret__.network_manager_id,
        system_data=__ret__.system_data,
        type=__ret__.type)


@_utilities.lift_output_func(get_management_group_network_manager_connection)
def get_management_group_network_manager_connection_output(management_group_id: Optional[pulumi.Input[str]] = None,
                                                           network_manager_connection_name: Optional[pulumi.Input[str]] = None,
                                                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetManagementGroupNetworkManagerConnectionResult]:
    """
    The Network Manager Connection resource


    :param str management_group_id: The management group Id which uniquely identify the Microsoft Azure management group.
    :param str network_manager_connection_name: Name for the network manager connection.
    """
    ...
