# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AmbrArgs',
    'AttachedDataNetworkResourceIdArgs',
    'CustomLocationResourceIdArgs',
    'DataNetworkConfigurationArgs',
    'DataNetworkResourceIdArgs',
    'InterfacePropertiesArgs',
    'MobileNetworkResourceIdArgs',
    'NaptConfigurationArgs',
    'PccRuleConfigurationArgs',
    'PccRuleQosPolicyArgs',
    'PinholeTimeoutsArgs',
    'PlmnIdArgs',
    'PortRangeArgs',
    'PortReuseHoldTimesArgs',
    'QosPolicyArgs',
    'ServiceDataFlowTemplateArgs',
    'ServiceResourceIdArgs',
    'SimPolicyResourceIdArgs',
    'SimStaticIpPropertiesStaticIpArgs',
    'SimStaticIpPropertiesArgs',
    'SliceConfigurationArgs',
    'SliceResourceIdArgs',
    'SnssaiArgs',
    'SubResourceArgs',
]

@pulumi.input_type
class AmbrArgs:
    def __init__(__self__, *,
                 downlink: pulumi.Input[str],
                 uplink: pulumi.Input[str]):
        """
        Aggregate Maximum Bit Rate.
        :param pulumi.Input[str] downlink: Downlink bit rate.
        :param pulumi.Input[str] uplink: Uplink bit rate.
        """
        pulumi.set(__self__, "downlink", downlink)
        pulumi.set(__self__, "uplink", uplink)

    @property
    @pulumi.getter
    def downlink(self) -> pulumi.Input[str]:
        """
        Downlink bit rate.
        """
        return pulumi.get(self, "downlink")

    @downlink.setter
    def downlink(self, value: pulumi.Input[str]):
        pulumi.set(self, "downlink", value)

    @property
    @pulumi.getter
    def uplink(self) -> pulumi.Input[str]:
        """
        Uplink bit rate.
        """
        return pulumi.get(self, "uplink")

    @uplink.setter
    def uplink(self, value: pulumi.Input[str]):
        pulumi.set(self, "uplink", value)


@pulumi.input_type
class AttachedDataNetworkResourceIdArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str]):
        """
        Reference to an Attached Data Network resource.
        :param pulumi.Input[str] id: Attached Data Network resource ID.
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        Attached Data Network resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class CustomLocationResourceIdArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str]):
        """
        Reference to an Azure ARC custom location resource.
        :param pulumi.Input[str] id: Azure ARC custom location resource ID.
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        Azure ARC custom location resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class DataNetworkConfigurationArgs:
    def __init__(__self__, *,
                 allowed_services: pulumi.Input[Sequence[pulumi.Input['ServiceResourceIdArgs']]],
                 data_network: pulumi.Input['DataNetworkResourceIdArgs'],
                 session_ambr: pulumi.Input['AmbrArgs'],
                 additional_allowed_session_types: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'PduSessionType']]]]] = None,
                 allocation_and_retention_priority_level: Optional[pulumi.Input[int]] = None,
                 default_session_type: Optional[pulumi.Input[Union[str, 'PduSessionType']]] = None,
                 five_qi: Optional[pulumi.Input[int]] = None,
                 preemption_capability: Optional[pulumi.Input[Union[str, 'PreemptionCapability']]] = None,
                 preemption_vulnerability: Optional[pulumi.Input[Union[str, 'PreemptionVulnerability']]] = None):
        """
        Settings controlling Data Network use
        :param pulumi.Input[Sequence[pulumi.Input['ServiceResourceIdArgs']]] allowed_services: List of Services that can be used as part of this Sim Policy. The list must not contain duplicate items and must contain at least one item.
        :param pulumi.Input['DataNetworkResourceIdArgs'] data_network: A reference to the Data Network that these settings apply to
        :param pulumi.Input['AmbrArgs'] session_ambr: Aggregate maximum bit rate across all non-GBR QoS flows of a given PDU session. See 3GPP TS23.501 section 5.7.2.6 for a full description of the Session-AMBR.
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'PduSessionType']]]] additional_allowed_session_types: Allowed session types in addition to the default session type.  Must not duplicate the default session type.
        :param pulumi.Input[int] allocation_and_retention_priority_level: Default QoS Flow allocation and retention priority (ARP) level. Flows with higher priority preempt flows with lower priority, if the settings of `preemptionCapability` and `preemptionVulnerability` allow it. 1 is the highest level of priority. If this field is not specified then `5qi` is used to derive the ARP value. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        :param pulumi.Input[Union[str, 'PduSessionType']] default_session_type: The default PDU session type, which is used if the UE does not request a specific session type.
        :param pulumi.Input[int] five_qi: Default QoS Flow 5G QoS Indicator value.  The 5QI identifies a specific QoS forwarding treatment to be provided to a flow. This must not be a standardized 5QI value selecting a GBR (Guaranteed Bit Rate) QoS.  The illegal GBR 5QI values are: 1, 2, 3, 4, 65, 66, 67, 71, 72, 73, 74, 75, 76, 82, 83, 84, and 85. See 3GPP TS23.501 section 5.7.2.1 for a full description of the 5Qi parameter, and table 5.7.4-1 for the definition of which are the GBR 5QI values.
        :param pulumi.Input[Union[str, 'PreemptionCapability']] preemption_capability: Default QoS Flow preemption capability.  The Preemption Capability of a QoS Flow controls whether it can preempt another QoS Flow with a lower priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        :param pulumi.Input[Union[str, 'PreemptionVulnerability']] preemption_vulnerability: Default QoS Flow preemption vulnerability.  The Preemption Vulnerability of a QoS Flow controls whether it can be preempted by QoS Flow with a higher priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        """
        pulumi.set(__self__, "allowed_services", allowed_services)
        pulumi.set(__self__, "data_network", data_network)
        pulumi.set(__self__, "session_ambr", session_ambr)
        if additional_allowed_session_types is not None:
            pulumi.set(__self__, "additional_allowed_session_types", additional_allowed_session_types)
        if allocation_and_retention_priority_level is None:
            allocation_and_retention_priority_level = 9
        if allocation_and_retention_priority_level is not None:
            pulumi.set(__self__, "allocation_and_retention_priority_level", allocation_and_retention_priority_level)
        if default_session_type is None:
            default_session_type = 'IPv4'
        if default_session_type is not None:
            pulumi.set(__self__, "default_session_type", default_session_type)
        if five_qi is None:
            five_qi = 9
        if five_qi is not None:
            pulumi.set(__self__, "five_qi", five_qi)
        if preemption_capability is None:
            preemption_capability = 'NotPreempt'
        if preemption_capability is not None:
            pulumi.set(__self__, "preemption_capability", preemption_capability)
        if preemption_vulnerability is None:
            preemption_vulnerability = 'Preemptable'
        if preemption_vulnerability is not None:
            pulumi.set(__self__, "preemption_vulnerability", preemption_vulnerability)

    @property
    @pulumi.getter(name="allowedServices")
    def allowed_services(self) -> pulumi.Input[Sequence[pulumi.Input['ServiceResourceIdArgs']]]:
        """
        List of Services that can be used as part of this Sim Policy. The list must not contain duplicate items and must contain at least one item.
        """
        return pulumi.get(self, "allowed_services")

    @allowed_services.setter
    def allowed_services(self, value: pulumi.Input[Sequence[pulumi.Input['ServiceResourceIdArgs']]]):
        pulumi.set(self, "allowed_services", value)

    @property
    @pulumi.getter(name="dataNetwork")
    def data_network(self) -> pulumi.Input['DataNetworkResourceIdArgs']:
        """
        A reference to the Data Network that these settings apply to
        """
        return pulumi.get(self, "data_network")

    @data_network.setter
    def data_network(self, value: pulumi.Input['DataNetworkResourceIdArgs']):
        pulumi.set(self, "data_network", value)

    @property
    @pulumi.getter(name="sessionAmbr")
    def session_ambr(self) -> pulumi.Input['AmbrArgs']:
        """
        Aggregate maximum bit rate across all non-GBR QoS flows of a given PDU session. See 3GPP TS23.501 section 5.7.2.6 for a full description of the Session-AMBR.
        """
        return pulumi.get(self, "session_ambr")

    @session_ambr.setter
    def session_ambr(self, value: pulumi.Input['AmbrArgs']):
        pulumi.set(self, "session_ambr", value)

    @property
    @pulumi.getter(name="additionalAllowedSessionTypes")
    def additional_allowed_session_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'PduSessionType']]]]]:
        """
        Allowed session types in addition to the default session type.  Must not duplicate the default session type.
        """
        return pulumi.get(self, "additional_allowed_session_types")

    @additional_allowed_session_types.setter
    def additional_allowed_session_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'PduSessionType']]]]]):
        pulumi.set(self, "additional_allowed_session_types", value)

    @property
    @pulumi.getter(name="allocationAndRetentionPriorityLevel")
    def allocation_and_retention_priority_level(self) -> Optional[pulumi.Input[int]]:
        """
        Default QoS Flow allocation and retention priority (ARP) level. Flows with higher priority preempt flows with lower priority, if the settings of `preemptionCapability` and `preemptionVulnerability` allow it. 1 is the highest level of priority. If this field is not specified then `5qi` is used to derive the ARP value. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        """
        return pulumi.get(self, "allocation_and_retention_priority_level")

    @allocation_and_retention_priority_level.setter
    def allocation_and_retention_priority_level(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "allocation_and_retention_priority_level", value)

    @property
    @pulumi.getter(name="defaultSessionType")
    def default_session_type(self) -> Optional[pulumi.Input[Union[str, 'PduSessionType']]]:
        """
        The default PDU session type, which is used if the UE does not request a specific session type.
        """
        return pulumi.get(self, "default_session_type")

    @default_session_type.setter
    def default_session_type(self, value: Optional[pulumi.Input[Union[str, 'PduSessionType']]]):
        pulumi.set(self, "default_session_type", value)

    @property
    @pulumi.getter(name="fiveQi")
    def five_qi(self) -> Optional[pulumi.Input[int]]:
        """
        Default QoS Flow 5G QoS Indicator value.  The 5QI identifies a specific QoS forwarding treatment to be provided to a flow. This must not be a standardized 5QI value selecting a GBR (Guaranteed Bit Rate) QoS.  The illegal GBR 5QI values are: 1, 2, 3, 4, 65, 66, 67, 71, 72, 73, 74, 75, 76, 82, 83, 84, and 85. See 3GPP TS23.501 section 5.7.2.1 for a full description of the 5Qi parameter, and table 5.7.4-1 for the definition of which are the GBR 5QI values.
        """
        return pulumi.get(self, "five_qi")

    @five_qi.setter
    def five_qi(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "five_qi", value)

    @property
    @pulumi.getter(name="preemptionCapability")
    def preemption_capability(self) -> Optional[pulumi.Input[Union[str, 'PreemptionCapability']]]:
        """
        Default QoS Flow preemption capability.  The Preemption Capability of a QoS Flow controls whether it can preempt another QoS Flow with a lower priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        """
        return pulumi.get(self, "preemption_capability")

    @preemption_capability.setter
    def preemption_capability(self, value: Optional[pulumi.Input[Union[str, 'PreemptionCapability']]]):
        pulumi.set(self, "preemption_capability", value)

    @property
    @pulumi.getter(name="preemptionVulnerability")
    def preemption_vulnerability(self) -> Optional[pulumi.Input[Union[str, 'PreemptionVulnerability']]]:
        """
        Default QoS Flow preemption vulnerability.  The Preemption Vulnerability of a QoS Flow controls whether it can be preempted by QoS Flow with a higher priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        """
        return pulumi.get(self, "preemption_vulnerability")

    @preemption_vulnerability.setter
    def preemption_vulnerability(self, value: Optional[pulumi.Input[Union[str, 'PreemptionVulnerability']]]):
        pulumi.set(self, "preemption_vulnerability", value)


@pulumi.input_type
class DataNetworkResourceIdArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str]):
        """
        Reference to a Data Network resource.
        :param pulumi.Input[str] id: Data Network resource ID.
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        Data Network resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class InterfacePropertiesArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 ipv4_address: Optional[pulumi.Input[str]] = None,
                 ipv4_gateway: Optional[pulumi.Input[str]] = None,
                 ipv4_subnet: Optional[pulumi.Input[str]] = None):
        """
        Interface properties
        :param pulumi.Input[str] name: The logical name for this interface. This should match one of the interfaces configured on your Azure Stack Edge machine.
        :param pulumi.Input[str] ipv4_address: The IPv4 address.
        :param pulumi.Input[str] ipv4_gateway: The default IPv4 gateway (router).
        :param pulumi.Input[str] ipv4_subnet: The IPv4 subnet.
        """
        pulumi.set(__self__, "name", name)
        if ipv4_address is not None:
            pulumi.set(__self__, "ipv4_address", ipv4_address)
        if ipv4_gateway is not None:
            pulumi.set(__self__, "ipv4_gateway", ipv4_gateway)
        if ipv4_subnet is not None:
            pulumi.set(__self__, "ipv4_subnet", ipv4_subnet)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The logical name for this interface. This should match one of the interfaces configured on your Azure Stack Edge machine.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="ipv4Address")
    def ipv4_address(self) -> Optional[pulumi.Input[str]]:
        """
        The IPv4 address.
        """
        return pulumi.get(self, "ipv4_address")

    @ipv4_address.setter
    def ipv4_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv4_address", value)

    @property
    @pulumi.getter(name="ipv4Gateway")
    def ipv4_gateway(self) -> Optional[pulumi.Input[str]]:
        """
        The default IPv4 gateway (router).
        """
        return pulumi.get(self, "ipv4_gateway")

    @ipv4_gateway.setter
    def ipv4_gateway(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv4_gateway", value)

    @property
    @pulumi.getter(name="ipv4Subnet")
    def ipv4_subnet(self) -> Optional[pulumi.Input[str]]:
        """
        The IPv4 subnet.
        """
        return pulumi.get(self, "ipv4_subnet")

    @ipv4_subnet.setter
    def ipv4_subnet(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv4_subnet", value)


@pulumi.input_type
class MobileNetworkResourceIdArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str]):
        """
        Reference to a Mobile Network resource.
        :param pulumi.Input[str] id: Mobile Network resource ID.
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        Mobile Network resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class NaptConfigurationArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[Union[str, 'NaptEnabled']]] = None,
                 pinhole_limits: Optional[pulumi.Input[int]] = None,
                 pinhole_timeouts: Optional[pulumi.Input['PinholeTimeoutsArgs']] = None,
                 port_range: Optional[pulumi.Input['PortRangeArgs']] = None,
                 port_reuse_hold_time: Optional[pulumi.Input['PortReuseHoldTimesArgs']] = None):
        """
        The Network Address and Port Translation settings to use for the attached data network.
        :param pulumi.Input[Union[str, 'NaptEnabled']] enabled: Whether NAPT is enabled for connections to this attachedDataNetwork.
        :param pulumi.Input[int] pinhole_limits: Maximum number of UDP and TCP pinholes that can be open simultaneously on the core interface.
        :param pulumi.Input['PinholeTimeoutsArgs'] pinhole_timeouts: Expiry times of inactive NAPT pinholes, in seconds. All timers must be at least 1 second.
        :param pulumi.Input['PortRangeArgs'] port_range: Range of port numbers to use as translated ports on each translated address.
               If not specified and NAPT is enabled, this range defaults to 1,024 - 65,535. (Ports under 1,024 should not be used because these are special purpose ports reserved by IANA.)
        :param pulumi.Input['PortReuseHoldTimesArgs'] port_reuse_hold_time: The minimum time (in seconds) that will pass before a port that was used by a closed pinhole can be recycled for use by another pinhole. All hold times must be minimum 1 second.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if pinhole_limits is None:
            pinhole_limits = 65536
        if pinhole_limits is not None:
            pulumi.set(__self__, "pinhole_limits", pinhole_limits)
        if pinhole_timeouts is not None:
            pulumi.set(__self__, "pinhole_timeouts", pinhole_timeouts)
        if port_range is not None:
            pulumi.set(__self__, "port_range", port_range)
        if port_reuse_hold_time is not None:
            pulumi.set(__self__, "port_reuse_hold_time", port_reuse_hold_time)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[Union[str, 'NaptEnabled']]]:
        """
        Whether NAPT is enabled for connections to this attachedDataNetwork.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[Union[str, 'NaptEnabled']]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="pinholeLimits")
    def pinhole_limits(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of UDP and TCP pinholes that can be open simultaneously on the core interface.
        """
        return pulumi.get(self, "pinhole_limits")

    @pinhole_limits.setter
    def pinhole_limits(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "pinhole_limits", value)

    @property
    @pulumi.getter(name="pinholeTimeouts")
    def pinhole_timeouts(self) -> Optional[pulumi.Input['PinholeTimeoutsArgs']]:
        """
        Expiry times of inactive NAPT pinholes, in seconds. All timers must be at least 1 second.
        """
        return pulumi.get(self, "pinhole_timeouts")

    @pinhole_timeouts.setter
    def pinhole_timeouts(self, value: Optional[pulumi.Input['PinholeTimeoutsArgs']]):
        pulumi.set(self, "pinhole_timeouts", value)

    @property
    @pulumi.getter(name="portRange")
    def port_range(self) -> Optional[pulumi.Input['PortRangeArgs']]:
        """
        Range of port numbers to use as translated ports on each translated address.
        If not specified and NAPT is enabled, this range defaults to 1,024 - 65,535. (Ports under 1,024 should not be used because these are special purpose ports reserved by IANA.)
        """
        return pulumi.get(self, "port_range")

    @port_range.setter
    def port_range(self, value: Optional[pulumi.Input['PortRangeArgs']]):
        pulumi.set(self, "port_range", value)

    @property
    @pulumi.getter(name="portReuseHoldTime")
    def port_reuse_hold_time(self) -> Optional[pulumi.Input['PortReuseHoldTimesArgs']]:
        """
        The minimum time (in seconds) that will pass before a port that was used by a closed pinhole can be recycled for use by another pinhole. All hold times must be minimum 1 second.
        """
        return pulumi.get(self, "port_reuse_hold_time")

    @port_reuse_hold_time.setter
    def port_reuse_hold_time(self, value: Optional[pulumi.Input['PortReuseHoldTimesArgs']]):
        pulumi.set(self, "port_reuse_hold_time", value)


@pulumi.input_type
class PccRuleConfigurationArgs:
    def __init__(__self__, *,
                 rule_name: pulumi.Input[str],
                 rule_precedence: pulumi.Input[int],
                 service_data_flow_templates: pulumi.Input[Sequence[pulumi.Input['ServiceDataFlowTemplateArgs']]],
                 rule_qos_policy: Optional[pulumi.Input['PccRuleQosPolicyArgs']] = None,
                 traffic_control: Optional[pulumi.Input[Union[str, 'TrafficControlPermission']]] = None):
        """
        PCC rule configuration
        :param pulumi.Input[str] rule_name: The name of the rule. This must be unique within the parent Service. You must not use any of the following reserved strings - `default`, `requested` or `service`.
        :param pulumi.Input[int] rule_precedence: A precedence value that is used to decide between PCC Rules when identifying the QoS values to use for a particular Sim. A lower value means a higher priority. This value should be unique among all PCC Rules configured in the Mobile Network.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceDataFlowTemplateArgs']]] service_data_flow_templates: The set of service data flow templates to use for this PCC Rule.
        :param pulumi.Input['PccRuleQosPolicyArgs'] rule_qos_policy: The QoS policy to use for packets matching this rule. If this field is null then the Service will define the QoS settings.
        :param pulumi.Input[Union[str, 'TrafficControlPermission']] traffic_control: Determines whether flows that match this PCC Rule are permitted.
        """
        pulumi.set(__self__, "rule_name", rule_name)
        pulumi.set(__self__, "rule_precedence", rule_precedence)
        pulumi.set(__self__, "service_data_flow_templates", service_data_flow_templates)
        if rule_qos_policy is not None:
            pulumi.set(__self__, "rule_qos_policy", rule_qos_policy)
        if traffic_control is None:
            traffic_control = 'Enabled'
        if traffic_control is not None:
            pulumi.set(__self__, "traffic_control", traffic_control)

    @property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> pulumi.Input[str]:
        """
        The name of the rule. This must be unique within the parent Service. You must not use any of the following reserved strings - `default`, `requested` or `service`.
        """
        return pulumi.get(self, "rule_name")

    @rule_name.setter
    def rule_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "rule_name", value)

    @property
    @pulumi.getter(name="rulePrecedence")
    def rule_precedence(self) -> pulumi.Input[int]:
        """
        A precedence value that is used to decide between PCC Rules when identifying the QoS values to use for a particular Sim. A lower value means a higher priority. This value should be unique among all PCC Rules configured in the Mobile Network.
        """
        return pulumi.get(self, "rule_precedence")

    @rule_precedence.setter
    def rule_precedence(self, value: pulumi.Input[int]):
        pulumi.set(self, "rule_precedence", value)

    @property
    @pulumi.getter(name="serviceDataFlowTemplates")
    def service_data_flow_templates(self) -> pulumi.Input[Sequence[pulumi.Input['ServiceDataFlowTemplateArgs']]]:
        """
        The set of service data flow templates to use for this PCC Rule.
        """
        return pulumi.get(self, "service_data_flow_templates")

    @service_data_flow_templates.setter
    def service_data_flow_templates(self, value: pulumi.Input[Sequence[pulumi.Input['ServiceDataFlowTemplateArgs']]]):
        pulumi.set(self, "service_data_flow_templates", value)

    @property
    @pulumi.getter(name="ruleQosPolicy")
    def rule_qos_policy(self) -> Optional[pulumi.Input['PccRuleQosPolicyArgs']]:
        """
        The QoS policy to use for packets matching this rule. If this field is null then the Service will define the QoS settings.
        """
        return pulumi.get(self, "rule_qos_policy")

    @rule_qos_policy.setter
    def rule_qos_policy(self, value: Optional[pulumi.Input['PccRuleQosPolicyArgs']]):
        pulumi.set(self, "rule_qos_policy", value)

    @property
    @pulumi.getter(name="trafficControl")
    def traffic_control(self) -> Optional[pulumi.Input[Union[str, 'TrafficControlPermission']]]:
        """
        Determines whether flows that match this PCC Rule are permitted.
        """
        return pulumi.get(self, "traffic_control")

    @traffic_control.setter
    def traffic_control(self, value: Optional[pulumi.Input[Union[str, 'TrafficControlPermission']]]):
        pulumi.set(self, "traffic_control", value)


@pulumi.input_type
class PccRuleQosPolicyArgs:
    def __init__(__self__, *,
                 maximum_bit_rate: pulumi.Input['AmbrArgs'],
                 allocation_and_retention_priority_level: Optional[pulumi.Input[int]] = None,
                 five_qi: Optional[pulumi.Input[int]] = None,
                 guaranteed_bit_rate: Optional[pulumi.Input['AmbrArgs']] = None,
                 preemption_capability: Optional[pulumi.Input[Union[str, 'PreemptionCapability']]] = None,
                 preemption_vulnerability: Optional[pulumi.Input[Union[str, 'PreemptionVulnerability']]] = None):
        """
        PCC rule QoS policy
        :param pulumi.Input['AmbrArgs'] maximum_bit_rate: The Maximum Bit Rate (MBR) for all service data flows that use this PCC Rule or Service.
        :param pulumi.Input[int] allocation_and_retention_priority_level: QoS Flow allocation and retention priority (ARP) level. Flows with higher priority preempt flows with lower priority, if the settings of `preemptionCapability` and `preemptionVulnerability` allow it. 1 is the highest level of priority. If this field is not specified then `5qi` is used to derive the ARP value. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        :param pulumi.Input[int] five_qi: QoS Flow 5G QoS Indicator value.  The 5QI identifies a specific QoS forwarding treatment to be provided to a flow. This must not be a standardized 5QI value selecting a GBR (Guaranteed Bit Rate) QoS.  The illegal GBR 5QI values are: 1, 2, 3, 4, 65, 66, 67, 71, 72, 73, 74, 75, 76, 82, 83, 84, and 85. See 3GPP TS23.501 section 5.7.2.1 for a full description of the 5Qi parameter, and table 5.7.4-1 for the definition of which are the GBR 5QI values.
        :param pulumi.Input['AmbrArgs'] guaranteed_bit_rate: The Guaranteed Bit Rate (GBR) for all service data flows that use this PCC Rule. This is an optional setting. If you do not provide a value, there will be no GBR set for the PCC Rule that uses this QoS definition.
        :param pulumi.Input[Union[str, 'PreemptionCapability']] preemption_capability: QoS Flow preemption capability.  The Preemption Capability of a QoS Flow controls whether it can preempt another QoS Flow with a lower priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        :param pulumi.Input[Union[str, 'PreemptionVulnerability']] preemption_vulnerability: QoS Flow preemption vulnerability.  The Preemption Vulnerability of a QoS Flow controls whether it can be preempted by QoS Flow with a higher priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        """
        pulumi.set(__self__, "maximum_bit_rate", maximum_bit_rate)
        if allocation_and_retention_priority_level is None:
            allocation_and_retention_priority_level = 9
        if allocation_and_retention_priority_level is not None:
            pulumi.set(__self__, "allocation_and_retention_priority_level", allocation_and_retention_priority_level)
        if five_qi is None:
            five_qi = 9
        if five_qi is not None:
            pulumi.set(__self__, "five_qi", five_qi)
        if guaranteed_bit_rate is not None:
            pulumi.set(__self__, "guaranteed_bit_rate", guaranteed_bit_rate)
        if preemption_capability is None:
            preemption_capability = 'NotPreempt'
        if preemption_capability is not None:
            pulumi.set(__self__, "preemption_capability", preemption_capability)
        if preemption_vulnerability is None:
            preemption_vulnerability = 'Preemptable'
        if preemption_vulnerability is not None:
            pulumi.set(__self__, "preemption_vulnerability", preemption_vulnerability)

    @property
    @pulumi.getter(name="maximumBitRate")
    def maximum_bit_rate(self) -> pulumi.Input['AmbrArgs']:
        """
        The Maximum Bit Rate (MBR) for all service data flows that use this PCC Rule or Service.
        """
        return pulumi.get(self, "maximum_bit_rate")

    @maximum_bit_rate.setter
    def maximum_bit_rate(self, value: pulumi.Input['AmbrArgs']):
        pulumi.set(self, "maximum_bit_rate", value)

    @property
    @pulumi.getter(name="allocationAndRetentionPriorityLevel")
    def allocation_and_retention_priority_level(self) -> Optional[pulumi.Input[int]]:
        """
        QoS Flow allocation and retention priority (ARP) level. Flows with higher priority preempt flows with lower priority, if the settings of `preemptionCapability` and `preemptionVulnerability` allow it. 1 is the highest level of priority. If this field is not specified then `5qi` is used to derive the ARP value. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        """
        return pulumi.get(self, "allocation_and_retention_priority_level")

    @allocation_and_retention_priority_level.setter
    def allocation_and_retention_priority_level(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "allocation_and_retention_priority_level", value)

    @property
    @pulumi.getter(name="fiveQi")
    def five_qi(self) -> Optional[pulumi.Input[int]]:
        """
        QoS Flow 5G QoS Indicator value.  The 5QI identifies a specific QoS forwarding treatment to be provided to a flow. This must not be a standardized 5QI value selecting a GBR (Guaranteed Bit Rate) QoS.  The illegal GBR 5QI values are: 1, 2, 3, 4, 65, 66, 67, 71, 72, 73, 74, 75, 76, 82, 83, 84, and 85. See 3GPP TS23.501 section 5.7.2.1 for a full description of the 5Qi parameter, and table 5.7.4-1 for the definition of which are the GBR 5QI values.
        """
        return pulumi.get(self, "five_qi")

    @five_qi.setter
    def five_qi(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "five_qi", value)

    @property
    @pulumi.getter(name="guaranteedBitRate")
    def guaranteed_bit_rate(self) -> Optional[pulumi.Input['AmbrArgs']]:
        """
        The Guaranteed Bit Rate (GBR) for all service data flows that use this PCC Rule. This is an optional setting. If you do not provide a value, there will be no GBR set for the PCC Rule that uses this QoS definition.
        """
        return pulumi.get(self, "guaranteed_bit_rate")

    @guaranteed_bit_rate.setter
    def guaranteed_bit_rate(self, value: Optional[pulumi.Input['AmbrArgs']]):
        pulumi.set(self, "guaranteed_bit_rate", value)

    @property
    @pulumi.getter(name="preemptionCapability")
    def preemption_capability(self) -> Optional[pulumi.Input[Union[str, 'PreemptionCapability']]]:
        """
        QoS Flow preemption capability.  The Preemption Capability of a QoS Flow controls whether it can preempt another QoS Flow with a lower priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        """
        return pulumi.get(self, "preemption_capability")

    @preemption_capability.setter
    def preemption_capability(self, value: Optional[pulumi.Input[Union[str, 'PreemptionCapability']]]):
        pulumi.set(self, "preemption_capability", value)

    @property
    @pulumi.getter(name="preemptionVulnerability")
    def preemption_vulnerability(self) -> Optional[pulumi.Input[Union[str, 'PreemptionVulnerability']]]:
        """
        QoS Flow preemption vulnerability.  The Preemption Vulnerability of a QoS Flow controls whether it can be preempted by QoS Flow with a higher priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        """
        return pulumi.get(self, "preemption_vulnerability")

    @preemption_vulnerability.setter
    def preemption_vulnerability(self, value: Optional[pulumi.Input[Union[str, 'PreemptionVulnerability']]]):
        pulumi.set(self, "preemption_vulnerability", value)


@pulumi.input_type
class PinholeTimeoutsArgs:
    def __init__(__self__, *,
                 icmp: Optional[pulumi.Input[int]] = None,
                 tcp: Optional[pulumi.Input[int]] = None,
                 udp: Optional[pulumi.Input[int]] = None):
        """
        Expiry times of inactive NAPT pinholes, in seconds. All timers must be at least 1 second.
        :param pulumi.Input[int] icmp: Pinhole timeout for ICMP pinholes in seconds. Default for ICMP Echo is 60 seconds per RFC 5508 section 3.2.
        :param pulumi.Input[int] tcp: Pinhole timeout for TCP pinholes in seconds. Default for TCP is 2 hours 4 minutes per RFC 5382 section 5.
        :param pulumi.Input[int] udp: Pinhole timeout for UDP pinholes in seconds. Default for UDP is 5 minutes per RFC 4787 section 4.3.
        """
        if icmp is None:
            icmp = 60
        if icmp is not None:
            pulumi.set(__self__, "icmp", icmp)
        if tcp is None:
            tcp = 7440
        if tcp is not None:
            pulumi.set(__self__, "tcp", tcp)
        if udp is None:
            udp = 300
        if udp is not None:
            pulumi.set(__self__, "udp", udp)

    @property
    @pulumi.getter
    def icmp(self) -> Optional[pulumi.Input[int]]:
        """
        Pinhole timeout for ICMP pinholes in seconds. Default for ICMP Echo is 60 seconds per RFC 5508 section 3.2.
        """
        return pulumi.get(self, "icmp")

    @icmp.setter
    def icmp(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "icmp", value)

    @property
    @pulumi.getter
    def tcp(self) -> Optional[pulumi.Input[int]]:
        """
        Pinhole timeout for TCP pinholes in seconds. Default for TCP is 2 hours 4 minutes per RFC 5382 section 5.
        """
        return pulumi.get(self, "tcp")

    @tcp.setter
    def tcp(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "tcp", value)

    @property
    @pulumi.getter
    def udp(self) -> Optional[pulumi.Input[int]]:
        """
        Pinhole timeout for UDP pinholes in seconds. Default for UDP is 5 minutes per RFC 4787 section 4.3.
        """
        return pulumi.get(self, "udp")

    @udp.setter
    def udp(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "udp", value)


@pulumi.input_type
class PlmnIdArgs:
    def __init__(__self__, *,
                 mcc: pulumi.Input[str],
                 mnc: pulumi.Input[str]):
        """
        Public Land Mobile Network (PLMN) ID.
        :param pulumi.Input[str] mcc: Mobile Country Code (MCC).
        :param pulumi.Input[str] mnc: Mobile Network Code (MNC).
        """
        pulumi.set(__self__, "mcc", mcc)
        pulumi.set(__self__, "mnc", mnc)

    @property
    @pulumi.getter
    def mcc(self) -> pulumi.Input[str]:
        """
        Mobile Country Code (MCC).
        """
        return pulumi.get(self, "mcc")

    @mcc.setter
    def mcc(self, value: pulumi.Input[str]):
        pulumi.set(self, "mcc", value)

    @property
    @pulumi.getter
    def mnc(self) -> pulumi.Input[str]:
        """
        Mobile Network Code (MNC).
        """
        return pulumi.get(self, "mnc")

    @mnc.setter
    def mnc(self, value: pulumi.Input[str]):
        pulumi.set(self, "mnc", value)


@pulumi.input_type
class PortRangeArgs:
    def __init__(__self__, *,
                 max_port: Optional[pulumi.Input[int]] = None,
                 min_port: Optional[pulumi.Input[int]] = None):
        """
        Range of port numbers to use as translated ports on each translated address.
        If not specified and NAPT is enabled, this range defaults to 1,024 - 65,535. (Ports under 1,024 should not be used because these are special purpose ports reserved by IANA.)
        :param pulumi.Input[int] max_port: The maximum port number
        :param pulumi.Input[int] min_port: The minimum port number
        """
        if max_port is None:
            max_port = 65535
        if max_port is not None:
            pulumi.set(__self__, "max_port", max_port)
        if min_port is None:
            min_port = 1024
        if min_port is not None:
            pulumi.set(__self__, "min_port", min_port)

    @property
    @pulumi.getter(name="maxPort")
    def max_port(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum port number
        """
        return pulumi.get(self, "max_port")

    @max_port.setter
    def max_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_port", value)

    @property
    @pulumi.getter(name="minPort")
    def min_port(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum port number
        """
        return pulumi.get(self, "min_port")

    @min_port.setter
    def min_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_port", value)


@pulumi.input_type
class PortReuseHoldTimesArgs:
    def __init__(__self__, *,
                 tcp: Optional[pulumi.Input[int]] = None,
                 udp: Optional[pulumi.Input[int]] = None):
        """
        The minimum time (in seconds) that will pass before a port that was used by a closed pinhole can be recycled for use by another pinhole. All hold times must be minimum 1 second.
        :param pulumi.Input[int] tcp: Minimum time in seconds that will pass before a TCP port that was used by a closed pinhole can be reused. Default for TCP is 2 minutes.
        :param pulumi.Input[int] udp: Minimum time in seconds that will pass before a UDP port that was used by a closed pinhole can be reused. Default for UDP is 1 minute.
        """
        if tcp is None:
            tcp = 120
        if tcp is not None:
            pulumi.set(__self__, "tcp", tcp)
        if udp is None:
            udp = 60
        if udp is not None:
            pulumi.set(__self__, "udp", udp)

    @property
    @pulumi.getter
    def tcp(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum time in seconds that will pass before a TCP port that was used by a closed pinhole can be reused. Default for TCP is 2 minutes.
        """
        return pulumi.get(self, "tcp")

    @tcp.setter
    def tcp(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "tcp", value)

    @property
    @pulumi.getter
    def udp(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum time in seconds that will pass before a UDP port that was used by a closed pinhole can be reused. Default for UDP is 1 minute.
        """
        return pulumi.get(self, "udp")

    @udp.setter
    def udp(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "udp", value)


@pulumi.input_type
class QosPolicyArgs:
    def __init__(__self__, *,
                 maximum_bit_rate: pulumi.Input['AmbrArgs'],
                 allocation_and_retention_priority_level: Optional[pulumi.Input[int]] = None,
                 five_qi: Optional[pulumi.Input[int]] = None,
                 preemption_capability: Optional[pulumi.Input[Union[str, 'PreemptionCapability']]] = None,
                 preemption_vulnerability: Optional[pulumi.Input[Union[str, 'PreemptionVulnerability']]] = None):
        """
        QoS policy
        :param pulumi.Input['AmbrArgs'] maximum_bit_rate: The Maximum Bit Rate (MBR) for all service data flows that use this PCC Rule or Service.
        :param pulumi.Input[int] allocation_and_retention_priority_level: QoS Flow allocation and retention priority (ARP) level. Flows with higher priority preempt flows with lower priority, if the settings of `preemptionCapability` and `preemptionVulnerability` allow it. 1 is the highest level of priority. If this field is not specified then `5qi` is used to derive the ARP value. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        :param pulumi.Input[int] five_qi: QoS Flow 5G QoS Indicator value.  The 5QI identifies a specific QoS forwarding treatment to be provided to a flow. This must not be a standardized 5QI value selecting a GBR (Guaranteed Bit Rate) QoS.  The illegal GBR 5QI values are: 1, 2, 3, 4, 65, 66, 67, 71, 72, 73, 74, 75, 76, 82, 83, 84, and 85. See 3GPP TS23.501 section 5.7.2.1 for a full description of the 5Qi parameter, and table 5.7.4-1 for the definition of which are the GBR 5QI values.
        :param pulumi.Input[Union[str, 'PreemptionCapability']] preemption_capability: QoS Flow preemption capability.  The Preemption Capability of a QoS Flow controls whether it can preempt another QoS Flow with a lower priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        :param pulumi.Input[Union[str, 'PreemptionVulnerability']] preemption_vulnerability: QoS Flow preemption vulnerability.  The Preemption Vulnerability of a QoS Flow controls whether it can be preempted by QoS Flow with a higher priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        """
        pulumi.set(__self__, "maximum_bit_rate", maximum_bit_rate)
        if allocation_and_retention_priority_level is None:
            allocation_and_retention_priority_level = 9
        if allocation_and_retention_priority_level is not None:
            pulumi.set(__self__, "allocation_and_retention_priority_level", allocation_and_retention_priority_level)
        if five_qi is None:
            five_qi = 9
        if five_qi is not None:
            pulumi.set(__self__, "five_qi", five_qi)
        if preemption_capability is None:
            preemption_capability = 'NotPreempt'
        if preemption_capability is not None:
            pulumi.set(__self__, "preemption_capability", preemption_capability)
        if preemption_vulnerability is None:
            preemption_vulnerability = 'Preemptable'
        if preemption_vulnerability is not None:
            pulumi.set(__self__, "preemption_vulnerability", preemption_vulnerability)

    @property
    @pulumi.getter(name="maximumBitRate")
    def maximum_bit_rate(self) -> pulumi.Input['AmbrArgs']:
        """
        The Maximum Bit Rate (MBR) for all service data flows that use this PCC Rule or Service.
        """
        return pulumi.get(self, "maximum_bit_rate")

    @maximum_bit_rate.setter
    def maximum_bit_rate(self, value: pulumi.Input['AmbrArgs']):
        pulumi.set(self, "maximum_bit_rate", value)

    @property
    @pulumi.getter(name="allocationAndRetentionPriorityLevel")
    def allocation_and_retention_priority_level(self) -> Optional[pulumi.Input[int]]:
        """
        QoS Flow allocation and retention priority (ARP) level. Flows with higher priority preempt flows with lower priority, if the settings of `preemptionCapability` and `preemptionVulnerability` allow it. 1 is the highest level of priority. If this field is not specified then `5qi` is used to derive the ARP value. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        """
        return pulumi.get(self, "allocation_and_retention_priority_level")

    @allocation_and_retention_priority_level.setter
    def allocation_and_retention_priority_level(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "allocation_and_retention_priority_level", value)

    @property
    @pulumi.getter(name="fiveQi")
    def five_qi(self) -> Optional[pulumi.Input[int]]:
        """
        QoS Flow 5G QoS Indicator value.  The 5QI identifies a specific QoS forwarding treatment to be provided to a flow. This must not be a standardized 5QI value selecting a GBR (Guaranteed Bit Rate) QoS.  The illegal GBR 5QI values are: 1, 2, 3, 4, 65, 66, 67, 71, 72, 73, 74, 75, 76, 82, 83, 84, and 85. See 3GPP TS23.501 section 5.7.2.1 for a full description of the 5Qi parameter, and table 5.7.4-1 for the definition of which are the GBR 5QI values.
        """
        return pulumi.get(self, "five_qi")

    @five_qi.setter
    def five_qi(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "five_qi", value)

    @property
    @pulumi.getter(name="preemptionCapability")
    def preemption_capability(self) -> Optional[pulumi.Input[Union[str, 'PreemptionCapability']]]:
        """
        QoS Flow preemption capability.  The Preemption Capability of a QoS Flow controls whether it can preempt another QoS Flow with a lower priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        """
        return pulumi.get(self, "preemption_capability")

    @preemption_capability.setter
    def preemption_capability(self, value: Optional[pulumi.Input[Union[str, 'PreemptionCapability']]]):
        pulumi.set(self, "preemption_capability", value)

    @property
    @pulumi.getter(name="preemptionVulnerability")
    def preemption_vulnerability(self) -> Optional[pulumi.Input[Union[str, 'PreemptionVulnerability']]]:
        """
        QoS Flow preemption vulnerability.  The Preemption Vulnerability of a QoS Flow controls whether it can be preempted by QoS Flow with a higher priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        """
        return pulumi.get(self, "preemption_vulnerability")

    @preemption_vulnerability.setter
    def preemption_vulnerability(self, value: Optional[pulumi.Input[Union[str, 'PreemptionVulnerability']]]):
        pulumi.set(self, "preemption_vulnerability", value)


@pulumi.input_type
class ServiceDataFlowTemplateArgs:
    def __init__(__self__, *,
                 direction: pulumi.Input[Union[str, 'SdfDirection']],
                 protocol: pulumi.Input[Sequence[pulumi.Input[str]]],
                 remote_ip_list: pulumi.Input[Sequence[pulumi.Input[str]]],
                 template_name: pulumi.Input[str],
                 ports: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Service data flow (SDF) template
        :param pulumi.Input[Union[str, 'SdfDirection']] direction: The direction of this flow.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] protocol: A list of the allowed protocol(s) for this flow. If you want this flow to be able to use any protocol within the internet protocol suite, use the value `ip`. If you only want to allow a selection of protocols, you must use the corresponding IANA Assigned Internet Protocol Number for each protocol, as described in https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml. For example, for UDP, you must use 17. If you use the value `ip` then you must leave the field `port` unspecified.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] remote_ip_list: The remote IP address(es) to which UEs will connect for this flow. If you want to allow connections on any IP address, use the value `any`. Otherwise, you must provide each of the remote IP addresses to which Fusion Core will connect for this flow. You must provide each IP address in CIDR notation, including the netmask (for example, 192.0.2.54/24).
        :param pulumi.Input[str] template_name: The name of the SDF template. This must be unique within the parent PccRuleConfiguration. You must not use any of the following reserved strings - `default`, `requested` or `service`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ports: The port(s) to which UEs will connect for this flow. You can specify zero or more ports or port ranges. If you specify one or more ports or port ranges then you must specify a value other than `ip` in the `protocol` field. This is an optional setting. If you do not specify it then connections will be allowed on all ports. Port ranges must be specified as <FirstPort>-<LastPort>. For example: [`8080`, `8082-8085`].
        """
        pulumi.set(__self__, "direction", direction)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "remote_ip_list", remote_ip_list)
        pulumi.set(__self__, "template_name", template_name)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)

    @property
    @pulumi.getter
    def direction(self) -> pulumi.Input[Union[str, 'SdfDirection']]:
        """
        The direction of this flow.
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: pulumi.Input[Union[str, 'SdfDirection']]):
        pulumi.set(self, "direction", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A list of the allowed protocol(s) for this flow. If you want this flow to be able to use any protocol within the internet protocol suite, use the value `ip`. If you only want to allow a selection of protocols, you must use the corresponding IANA Assigned Internet Protocol Number for each protocol, as described in https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml. For example, for UDP, you must use 17. If you use the value `ip` then you must leave the field `port` unspecified.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="remoteIpList")
    def remote_ip_list(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The remote IP address(es) to which UEs will connect for this flow. If you want to allow connections on any IP address, use the value `any`. Otherwise, you must provide each of the remote IP addresses to which Fusion Core will connect for this flow. You must provide each IP address in CIDR notation, including the netmask (for example, 192.0.2.54/24).
        """
        return pulumi.get(self, "remote_ip_list")

    @remote_ip_list.setter
    def remote_ip_list(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "remote_ip_list", value)

    @property
    @pulumi.getter(name="templateName")
    def template_name(self) -> pulumi.Input[str]:
        """
        The name of the SDF template. This must be unique within the parent PccRuleConfiguration. You must not use any of the following reserved strings - `default`, `requested` or `service`.
        """
        return pulumi.get(self, "template_name")

    @template_name.setter
    def template_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "template_name", value)

    @property
    @pulumi.getter
    def ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The port(s) to which UEs will connect for this flow. You can specify zero or more ports or port ranges. If you specify one or more ports or port ranges then you must specify a value other than `ip` in the `protocol` field. This is an optional setting. If you do not specify it then connections will be allowed on all ports. Port ranges must be specified as <FirstPort>-<LastPort>. For example: [`8080`, `8082-8085`].
        """
        return pulumi.get(self, "ports")

    @ports.setter
    def ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ports", value)


@pulumi.input_type
class ServiceResourceIdArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str]):
        """
        Reference to a Service resource.
        :param pulumi.Input[str] id: Service resource ID.
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        Service resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class SimPolicyResourceIdArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str]):
        """
        Reference to a SIM Policy resource.
        :param pulumi.Input[str] id: SIM Policy resource ID.
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        SIM Policy resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class SimStaticIpPropertiesStaticIpArgs:
    def __init__(__self__, *,
                 ipv4_address: Optional[pulumi.Input[str]] = None):
        """
        The static IP configuration for the sim to use at the defined network scope.
        :param pulumi.Input[str] ipv4_address: The IPv4 address assigned to the sim at this network scope. This address must be in the userEquipmentStaticAddressPoolPrefix defined in the attachedDataNetwork.
        """
        if ipv4_address is not None:
            pulumi.set(__self__, "ipv4_address", ipv4_address)

    @property
    @pulumi.getter(name="ipv4Address")
    def ipv4_address(self) -> Optional[pulumi.Input[str]]:
        """
        The IPv4 address assigned to the sim at this network scope. This address must be in the userEquipmentStaticAddressPoolPrefix defined in the attachedDataNetwork.
        """
        return pulumi.get(self, "ipv4_address")

    @ipv4_address.setter
    def ipv4_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv4_address", value)


@pulumi.input_type
class SimStaticIpPropertiesArgs:
    def __init__(__self__, *,
                 attached_data_network: Optional[pulumi.Input['AttachedDataNetworkResourceIdArgs']] = None,
                 slice: Optional[pulumi.Input['SliceResourceIdArgs']] = None,
                 static_ip: Optional[pulumi.Input['SimStaticIpPropertiesStaticIpArgs']] = None):
        """
        Static IP configuration for a sim, scoped to a particular attached data network and slice.
        :param pulumi.Input['AttachedDataNetworkResourceIdArgs'] attached_data_network: The attached data network on which the static IP address will be used. The combination of attachedDataNetwork and slice defines the network scope of the IP address.
        :param pulumi.Input['SliceResourceIdArgs'] slice: The network slice on which the static IP address will be used. The combination of attachedDataNetwork and slice defines the network scope of the IP address.
        :param pulumi.Input['SimStaticIpPropertiesStaticIpArgs'] static_ip: The static IP configuration for the sim to use at the defined network scope.
        """
        if attached_data_network is not None:
            pulumi.set(__self__, "attached_data_network", attached_data_network)
        if slice is not None:
            pulumi.set(__self__, "slice", slice)
        if static_ip is not None:
            pulumi.set(__self__, "static_ip", static_ip)

    @property
    @pulumi.getter(name="attachedDataNetwork")
    def attached_data_network(self) -> Optional[pulumi.Input['AttachedDataNetworkResourceIdArgs']]:
        """
        The attached data network on which the static IP address will be used. The combination of attachedDataNetwork and slice defines the network scope of the IP address.
        """
        return pulumi.get(self, "attached_data_network")

    @attached_data_network.setter
    def attached_data_network(self, value: Optional[pulumi.Input['AttachedDataNetworkResourceIdArgs']]):
        pulumi.set(self, "attached_data_network", value)

    @property
    @pulumi.getter
    def slice(self) -> Optional[pulumi.Input['SliceResourceIdArgs']]:
        """
        The network slice on which the static IP address will be used. The combination of attachedDataNetwork and slice defines the network scope of the IP address.
        """
        return pulumi.get(self, "slice")

    @slice.setter
    def slice(self, value: Optional[pulumi.Input['SliceResourceIdArgs']]):
        pulumi.set(self, "slice", value)

    @property
    @pulumi.getter(name="staticIp")
    def static_ip(self) -> Optional[pulumi.Input['SimStaticIpPropertiesStaticIpArgs']]:
        """
        The static IP configuration for the sim to use at the defined network scope.
        """
        return pulumi.get(self, "static_ip")

    @static_ip.setter
    def static_ip(self, value: Optional[pulumi.Input['SimStaticIpPropertiesStaticIpArgs']]):
        pulumi.set(self, "static_ip", value)


@pulumi.input_type
class SliceConfigurationArgs:
    def __init__(__self__, *,
                 data_network_configurations: pulumi.Input[Sequence[pulumi.Input['DataNetworkConfigurationArgs']]],
                 default_data_network: pulumi.Input['DataNetworkResourceIdArgs'],
                 slice: pulumi.Input['SliceResourceIdArgs']):
        """
        Per-slice settings
        :param pulumi.Input[Sequence[pulumi.Input['DataNetworkConfigurationArgs']]] data_network_configurations: The allowed data networks and the settings to use for them. The list must not contain duplicate items and must contain at least one item.
        :param pulumi.Input['DataNetworkResourceIdArgs'] default_data_network: The default data network to use if the UE does not explicitly specify it.  Configuration for this object must exist in the `dataNetworkConfigurations` map.
        :param pulumi.Input['SliceResourceIdArgs'] slice: A reference to the Slice that these settings apply to
        """
        pulumi.set(__self__, "data_network_configurations", data_network_configurations)
        pulumi.set(__self__, "default_data_network", default_data_network)
        pulumi.set(__self__, "slice", slice)

    @property
    @pulumi.getter(name="dataNetworkConfigurations")
    def data_network_configurations(self) -> pulumi.Input[Sequence[pulumi.Input['DataNetworkConfigurationArgs']]]:
        """
        The allowed data networks and the settings to use for them. The list must not contain duplicate items and must contain at least one item.
        """
        return pulumi.get(self, "data_network_configurations")

    @data_network_configurations.setter
    def data_network_configurations(self, value: pulumi.Input[Sequence[pulumi.Input['DataNetworkConfigurationArgs']]]):
        pulumi.set(self, "data_network_configurations", value)

    @property
    @pulumi.getter(name="defaultDataNetwork")
    def default_data_network(self) -> pulumi.Input['DataNetworkResourceIdArgs']:
        """
        The default data network to use if the UE does not explicitly specify it.  Configuration for this object must exist in the `dataNetworkConfigurations` map.
        """
        return pulumi.get(self, "default_data_network")

    @default_data_network.setter
    def default_data_network(self, value: pulumi.Input['DataNetworkResourceIdArgs']):
        pulumi.set(self, "default_data_network", value)

    @property
    @pulumi.getter
    def slice(self) -> pulumi.Input['SliceResourceIdArgs']:
        """
        A reference to the Slice that these settings apply to
        """
        return pulumi.get(self, "slice")

    @slice.setter
    def slice(self, value: pulumi.Input['SliceResourceIdArgs']):
        pulumi.set(self, "slice", value)


@pulumi.input_type
class SliceResourceIdArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str]):
        """
        Reference to a Slice resource.
        :param pulumi.Input[str] id: Slice resource ID.
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        Slice resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class SnssaiArgs:
    def __init__(__self__, *,
                 sst: pulumi.Input[int],
                 sd: Optional[pulumi.Input[str]] = None):
        """
        Single-Network Slice Selection Assistance Information (S-NSSAI).
        :param pulumi.Input[int] sst: Slice/Service Type (SST).
        :param pulumi.Input[str] sd: Slice Differentiator (SD).
        """
        pulumi.set(__self__, "sst", sst)
        if sd is not None:
            pulumi.set(__self__, "sd", sd)

    @property
    @pulumi.getter
    def sst(self) -> pulumi.Input[int]:
        """
        Slice/Service Type (SST).
        """
        return pulumi.get(self, "sst")

    @sst.setter
    def sst(self, value: pulumi.Input[int]):
        pulumi.set(self, "sst", value)

    @property
    @pulumi.getter
    def sd(self) -> Optional[pulumi.Input[str]]:
        """
        Slice Differentiator (SD).
        """
        return pulumi.get(self, "sd")

    @sd.setter
    def sd(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sd", value)


@pulumi.input_type
class SubResourceArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str]):
        """
        Reference to another sub resource.
        :param pulumi.Input[str] id: Resource ID.
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)


