# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'ListAssetStreamingLocatorsResult',
    'AwaitableListAssetStreamingLocatorsResult',
    'list_asset_streaming_locators',
    'list_asset_streaming_locators_output',
]

@pulumi.output_type
class ListAssetStreamingLocatorsResult:
    """
    The Streaming Locators associated with this Asset.
    """
    def __init__(__self__, streaming_locators=None):
        if streaming_locators and not isinstance(streaming_locators, list):
            raise TypeError("Expected argument 'streaming_locators' to be a list")
        pulumi.set(__self__, "streaming_locators", streaming_locators)

    @property
    @pulumi.getter(name="streamingLocators")
    def streaming_locators(self) -> Sequence['outputs.AssetStreamingLocatorResponse']:
        """
        The list of Streaming Locators.
        """
        return pulumi.get(self, "streaming_locators")


class AwaitableListAssetStreamingLocatorsResult(ListAssetStreamingLocatorsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return ListAssetStreamingLocatorsResult(
            streaming_locators=self.streaming_locators)


def list_asset_streaming_locators(account_name: Optional[str] = None,
                                  asset_name: Optional[str] = None,
                                  resource_group_name: Optional[str] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableListAssetStreamingLocatorsResult:
    """
    The Streaming Locators associated with this Asset.


    :param str account_name: The Media Services account name.
    :param str asset_name: The Asset name.
    :param str resource_group_name: The name of the resource group within the Azure subscription.
    """
    __args__ = dict()
    __args__['accountName'] = account_name
    __args__['assetName'] = asset_name
    __args__['resourceGroupName'] = resource_group_name
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('azure-native:media/v20180701:listAssetStreamingLocators', __args__, opts=opts, typ=ListAssetStreamingLocatorsResult).value

    return AwaitableListAssetStreamingLocatorsResult(
        streaming_locators=__ret__.streaming_locators)


@_utilities.lift_output_func(list_asset_streaming_locators)
def list_asset_streaming_locators_output(account_name: Optional[pulumi.Input[str]] = None,
                                         asset_name: Optional[pulumi.Input[str]] = None,
                                         resource_group_name: Optional[pulumi.Input[str]] = None,
                                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[ListAssetStreamingLocatorsResult]:
    """
    The Streaming Locators associated with this Asset.


    :param str account_name: The Media Services account name.
    :param str asset_name: The Asset name.
    :param str resource_group_name: The name of the resource group within the Azure subscription.
    """
    ...
