# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AacAudioResponse',
    'AkamaiAccessControlResponse',
    'AkamaiSignatureHeaderAuthenticationKeyResponse',
    'AudioAnalyzerPresetResponse',
    'AudioOverlayResponse',
    'AudioResponse',
    'BuiltInStandardEncoderPresetResponse',
    'CbcsDrmConfigurationResponse',
    'CencDrmConfigurationResponse',
    'CommonEncryptionCbcsResponse',
    'CommonEncryptionCencResponse',
    'ContentKeyPolicyClearKeyConfigurationResponse',
    'ContentKeyPolicyFairPlayConfigurationResponse',
    'ContentKeyPolicyOpenRestrictionResponse',
    'ContentKeyPolicyOptionResponse',
    'ContentKeyPolicyPlayReadyConfigurationResponse',
    'ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeaderResponse',
    'ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifierResponse',
    'ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestrictionResponse',
    'ContentKeyPolicyPlayReadyLicenseResponse',
    'ContentKeyPolicyPlayReadyPlayRightResponse',
    'ContentKeyPolicyRsaTokenKeyResponse',
    'ContentKeyPolicySymmetricTokenKeyResponse',
    'ContentKeyPolicyTokenClaimResponse',
    'ContentKeyPolicyTokenRestrictionResponse',
    'ContentKeyPolicyUnknownConfigurationResponse',
    'ContentKeyPolicyUnknownRestrictionResponse',
    'ContentKeyPolicyWidevineConfigurationResponse',
    'ContentKeyPolicyX509CertificateTokenKeyResponse',
    'CopyAudioResponse',
    'CopyVideoResponse',
    'CrossSiteAccessPoliciesResponse',
    'DefaultKeyResponse',
    'DeinterlaceResponse',
    'EnabledProtocolsResponse',
    'EnvelopeEncryptionResponse',
    'FiltersResponse',
    'H264LayerResponse',
    'H264VideoResponse',
    'HlsResponse',
    'IPAccessControlResponse',
    'IPRangeResponse',
    'ImageFormatResponse',
    'ImageResponse',
    'JobErrorDetailResponse',
    'JobErrorResponse',
    'JobInputAssetResponse',
    'JobInputClipResponse',
    'JobInputHttpResponse',
    'JobInputsResponse',
    'JobOutputAssetResponse',
    'JpgFormatResponse',
    'JpgImageResponse',
    'JpgLayerResponse',
    'LiveEventEncodingResponse',
    'LiveEventEndpointResponse',
    'LiveEventInputResponse',
    'LiveEventPreviewAccessControlResponse',
    'LiveEventPreviewResponse',
    'Mp4FormatResponse',
    'MultiBitrateFormatResponse',
    'NoEncryptionResponse',
    'OutputFileResponse',
    'PngFormatResponse',
    'PngImageResponse',
    'PngLayerResponse',
    'RectangleResponse',
    'StandardEncoderPresetResponse',
    'StorageAccountResponse',
    'StreamingEndpointAccessControlResponse',
    'StreamingLocatorContentKeyResponse',
    'StreamingPathResponse',
    'StreamingPolicyContentKeyResponse',
    'StreamingPolicyContentKeysResponse',
    'StreamingPolicyFairPlayConfigurationResponse',
    'StreamingPolicyPlayReadyConfigurationResponse',
    'StreamingPolicyWidevineConfigurationResponse',
    'TrackPropertyConditionResponse',
    'TrackSelectionResponse',
    'TransformOutputResponse',
    'TransportStreamFormatResponse',
    'VideoAnalyzerPresetResponse',
    'VideoOverlayResponse',
    'VideoResponse',
]

@pulumi.output_type
class AacAudioResponse(dict):
    """
    Describes Advanced Audio Codec (AAC) audio encoding settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "samplingRate":
            suggest = "sampling_rate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AacAudioResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AacAudioResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AacAudioResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 bitrate: Optional[int] = None,
                 channels: Optional[int] = None,
                 label: Optional[str] = None,
                 profile: Optional[str] = None,
                 sampling_rate: Optional[int] = None):
        """
        Describes Advanced Audio Codec (AAC) audio encoding settings.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.AacAudio'.
        :param int bitrate: The bitrate, in bits per second, of the output encoded audio.
        :param int channels: The number of channels in the audio.
        :param str label: An optional label for the codec. The label can be used to control muxing behavior.
        :param str profile: The encoding profile to be used when encoding audio with AAC.
        :param int sampling_rate: The sampling rate to use for encoding in hertz.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.AacAudio')
        if bitrate is not None:
            pulumi.set(__self__, "bitrate", bitrate)
        if channels is not None:
            pulumi.set(__self__, "channels", channels)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if profile is not None:
            pulumi.set(__self__, "profile", profile)
        if sampling_rate is not None:
            pulumi.set(__self__, "sampling_rate", sampling_rate)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.AacAudio'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter
    def bitrate(self) -> Optional[int]:
        """
        The bitrate, in bits per second, of the output encoded audio.
        """
        return pulumi.get(self, "bitrate")

    @property
    @pulumi.getter
    def channels(self) -> Optional[int]:
        """
        The number of channels in the audio.
        """
        return pulumi.get(self, "channels")

    @property
    @pulumi.getter
    def label(self) -> Optional[str]:
        """
        An optional label for the codec. The label can be used to control muxing behavior.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def profile(self) -> Optional[str]:
        """
        The encoding profile to be used when encoding audio with AAC.
        """
        return pulumi.get(self, "profile")

    @property
    @pulumi.getter(name="samplingRate")
    def sampling_rate(self) -> Optional[int]:
        """
        The sampling rate to use for encoding in hertz.
        """
        return pulumi.get(self, "sampling_rate")


@pulumi.output_type
class AkamaiAccessControlResponse(dict):
    """
    Akamai access control
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "akamaiSignatureHeaderAuthenticationKeyList":
            suggest = "akamai_signature_header_authentication_key_list"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AkamaiAccessControlResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AkamaiAccessControlResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AkamaiAccessControlResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 akamai_signature_header_authentication_key_list: Optional[Sequence['outputs.AkamaiSignatureHeaderAuthenticationKeyResponse']] = None):
        """
        Akamai access control
        :param Sequence['AkamaiSignatureHeaderAuthenticationKeyResponse'] akamai_signature_header_authentication_key_list: authentication key list
        """
        if akamai_signature_header_authentication_key_list is not None:
            pulumi.set(__self__, "akamai_signature_header_authentication_key_list", akamai_signature_header_authentication_key_list)

    @property
    @pulumi.getter(name="akamaiSignatureHeaderAuthenticationKeyList")
    def akamai_signature_header_authentication_key_list(self) -> Optional[Sequence['outputs.AkamaiSignatureHeaderAuthenticationKeyResponse']]:
        """
        authentication key list
        """
        return pulumi.get(self, "akamai_signature_header_authentication_key_list")


@pulumi.output_type
class AkamaiSignatureHeaderAuthenticationKeyResponse(dict):
    """
    Akamai Signature Header authentication key.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "base64Key":
            suggest = "base64_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AkamaiSignatureHeaderAuthenticationKeyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AkamaiSignatureHeaderAuthenticationKeyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AkamaiSignatureHeaderAuthenticationKeyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 base64_key: Optional[str] = None,
                 expiration: Optional[str] = None,
                 identifier: Optional[str] = None):
        """
        Akamai Signature Header authentication key.
        :param str base64_key: authentication key
        :param str expiration: The exact time the authentication key.
        :param str identifier: identifier of the key
        """
        if base64_key is not None:
            pulumi.set(__self__, "base64_key", base64_key)
        if expiration is not None:
            pulumi.set(__self__, "expiration", expiration)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)

    @property
    @pulumi.getter(name="base64Key")
    def base64_key(self) -> Optional[str]:
        """
        authentication key
        """
        return pulumi.get(self, "base64_key")

    @property
    @pulumi.getter
    def expiration(self) -> Optional[str]:
        """
        The exact time the authentication key.
        """
        return pulumi.get(self, "expiration")

    @property
    @pulumi.getter
    def identifier(self) -> Optional[str]:
        """
        identifier of the key
        """
        return pulumi.get(self, "identifier")


@pulumi.output_type
class AudioAnalyzerPresetResponse(dict):
    """
    The Audio Analyzer preset applies a pre-defined set of AI-based analysis operations, including speech transcription. Currently, the preset supports processing of content with a single audio track.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "audioLanguage":
            suggest = "audio_language"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AudioAnalyzerPresetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AudioAnalyzerPresetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AudioAnalyzerPresetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 audio_language: Optional[str] = None):
        """
        The Audio Analyzer preset applies a pre-defined set of AI-based analysis operations, including speech transcription. Currently, the preset supports processing of content with a single audio track.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.AudioAnalyzerPreset'.
        :param str audio_language: The language for the audio payload in the input using the BCP-47 format of 'language tag-region' (e.g: 'en-US'). The list of supported languages are, 'en-US', 'en-GB', 'es-ES', 'es-MX', 'fr-FR', 'it-IT', 'ja-JP', 'pt-BR', 'zh-CN'.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.AudioAnalyzerPreset')
        if audio_language is not None:
            pulumi.set(__self__, "audio_language", audio_language)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.AudioAnalyzerPreset'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="audioLanguage")
    def audio_language(self) -> Optional[str]:
        """
        The language for the audio payload in the input using the BCP-47 format of 'language tag-region' (e.g: 'en-US'). The list of supported languages are, 'en-US', 'en-GB', 'es-ES', 'es-MX', 'fr-FR', 'it-IT', 'ja-JP', 'pt-BR', 'zh-CN'.
        """
        return pulumi.get(self, "audio_language")


@pulumi.output_type
class AudioOverlayResponse(dict):
    """
    Describes the properties of an audio overlay.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "audioGainLevel":
            suggest = "audio_gain_level"
        elif key == "fadeInDuration":
            suggest = "fade_in_duration"
        elif key == "fadeOutDuration":
            suggest = "fade_out_duration"
        elif key == "inputLabel":
            suggest = "input_label"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AudioOverlayResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AudioOverlayResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AudioOverlayResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 audio_gain_level: Optional[float] = None,
                 end: Optional[str] = None,
                 fade_in_duration: Optional[str] = None,
                 fade_out_duration: Optional[str] = None,
                 input_label: Optional[str] = None,
                 start: Optional[str] = None):
        """
        Describes the properties of an audio overlay.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.AudioOverlay'.
        :param float audio_gain_level: The gain level of audio in the overlay. The value should be in the range [0, 1.0]. The default is 1.0.
        :param str end: The position in the input video at which the overlay ends. The value should be in ISO 8601 duration format. For example, PT30S to end the overlay at 30 seconds in to the input video. If not specified the overlay will be applied until the end of the input video if inputLoop is true. Else, if inputLoop is false, then overlay will last as long as the duration of the overlay media.
        :param str fade_in_duration: The duration over which the overlay fades in onto the input video. The value should be in ISO 8601 duration format. If not specified the default behavior is to have no fade in (same as PT0S).
        :param str fade_out_duration: The duration over which the overlay fades out of the input video. The value should be in ISO 8601 duration format. If not specified the default behavior is to have no fade out (same as PT0S).
        :param str input_label: The label of the job input which is to be used as an overlay. The Input must specify exactly one file. You can specify an image file in JPG or PNG formats, or an audio file (such as a WAV, MP3, WMA or M4A file), or a video file. See https://aka.ms/mesformats for the complete list of supported audio and video file formats.
        :param str start: The start position, with reference to the input video, at which the overlay starts. The value should be in ISO 8601 format. For example, PT05S to start the overlay at 5 seconds in to the input video. If not specified the overlay starts from the beginning of the input video.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.AudioOverlay')
        if audio_gain_level is not None:
            pulumi.set(__self__, "audio_gain_level", audio_gain_level)
        if end is not None:
            pulumi.set(__self__, "end", end)
        if fade_in_duration is not None:
            pulumi.set(__self__, "fade_in_duration", fade_in_duration)
        if fade_out_duration is not None:
            pulumi.set(__self__, "fade_out_duration", fade_out_duration)
        if input_label is not None:
            pulumi.set(__self__, "input_label", input_label)
        if start is not None:
            pulumi.set(__self__, "start", start)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.AudioOverlay'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="audioGainLevel")
    def audio_gain_level(self) -> Optional[float]:
        """
        The gain level of audio in the overlay. The value should be in the range [0, 1.0]. The default is 1.0.
        """
        return pulumi.get(self, "audio_gain_level")

    @property
    @pulumi.getter
    def end(self) -> Optional[str]:
        """
        The position in the input video at which the overlay ends. The value should be in ISO 8601 duration format. For example, PT30S to end the overlay at 30 seconds in to the input video. If not specified the overlay will be applied until the end of the input video if inputLoop is true. Else, if inputLoop is false, then overlay will last as long as the duration of the overlay media.
        """
        return pulumi.get(self, "end")

    @property
    @pulumi.getter(name="fadeInDuration")
    def fade_in_duration(self) -> Optional[str]:
        """
        The duration over which the overlay fades in onto the input video. The value should be in ISO 8601 duration format. If not specified the default behavior is to have no fade in (same as PT0S).
        """
        return pulumi.get(self, "fade_in_duration")

    @property
    @pulumi.getter(name="fadeOutDuration")
    def fade_out_duration(self) -> Optional[str]:
        """
        The duration over which the overlay fades out of the input video. The value should be in ISO 8601 duration format. If not specified the default behavior is to have no fade out (same as PT0S).
        """
        return pulumi.get(self, "fade_out_duration")

    @property
    @pulumi.getter(name="inputLabel")
    def input_label(self) -> Optional[str]:
        """
        The label of the job input which is to be used as an overlay. The Input must specify exactly one file. You can specify an image file in JPG or PNG formats, or an audio file (such as a WAV, MP3, WMA or M4A file), or a video file. See https://aka.ms/mesformats for the complete list of supported audio and video file formats.
        """
        return pulumi.get(self, "input_label")

    @property
    @pulumi.getter
    def start(self) -> Optional[str]:
        """
        The start position, with reference to the input video, at which the overlay starts. The value should be in ISO 8601 format. For example, PT05S to start the overlay at 5 seconds in to the input video. If not specified the overlay starts from the beginning of the input video.
        """
        return pulumi.get(self, "start")


@pulumi.output_type
class AudioResponse(dict):
    """
    Defines the common properties for all audio codecs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "samplingRate":
            suggest = "sampling_rate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AudioResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AudioResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AudioResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 bitrate: Optional[int] = None,
                 channels: Optional[int] = None,
                 label: Optional[str] = None,
                 sampling_rate: Optional[int] = None):
        """
        Defines the common properties for all audio codecs.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.Audio'.
        :param int bitrate: The bitrate, in bits per second, of the output encoded audio.
        :param int channels: The number of channels in the audio.
        :param str label: An optional label for the codec. The label can be used to control muxing behavior.
        :param int sampling_rate: The sampling rate to use for encoding in hertz.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.Audio')
        if bitrate is not None:
            pulumi.set(__self__, "bitrate", bitrate)
        if channels is not None:
            pulumi.set(__self__, "channels", channels)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if sampling_rate is not None:
            pulumi.set(__self__, "sampling_rate", sampling_rate)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.Audio'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter
    def bitrate(self) -> Optional[int]:
        """
        The bitrate, in bits per second, of the output encoded audio.
        """
        return pulumi.get(self, "bitrate")

    @property
    @pulumi.getter
    def channels(self) -> Optional[int]:
        """
        The number of channels in the audio.
        """
        return pulumi.get(self, "channels")

    @property
    @pulumi.getter
    def label(self) -> Optional[str]:
        """
        An optional label for the codec. The label can be used to control muxing behavior.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter(name="samplingRate")
    def sampling_rate(self) -> Optional[int]:
        """
        The sampling rate to use for encoding in hertz.
        """
        return pulumi.get(self, "sampling_rate")


@pulumi.output_type
class BuiltInStandardEncoderPresetResponse(dict):
    """
    Describes a built-in preset for encoding the input video with the Standard Encoder.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "presetName":
            suggest = "preset_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BuiltInStandardEncoderPresetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BuiltInStandardEncoderPresetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BuiltInStandardEncoderPresetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 preset_name: str):
        """
        Describes a built-in preset for encoding the input video with the Standard Encoder.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.BuiltInStandardEncoderPreset'.
        :param str preset_name: The built-in preset to be used for encoding videos.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.BuiltInStandardEncoderPreset')
        pulumi.set(__self__, "preset_name", preset_name)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.BuiltInStandardEncoderPreset'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="presetName")
    def preset_name(self) -> str:
        """
        The built-in preset to be used for encoding videos.
        """
        return pulumi.get(self, "preset_name")


@pulumi.output_type
class CbcsDrmConfigurationResponse(dict):
    """
    Class to specify DRM configurations of CommonEncryptionCbcs scheme in Streaming Policy
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fairPlay":
            suggest = "fair_play"
        elif key == "playReady":
            suggest = "play_ready"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CbcsDrmConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CbcsDrmConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CbcsDrmConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fair_play: Optional['outputs.StreamingPolicyFairPlayConfigurationResponse'] = None,
                 play_ready: Optional['outputs.StreamingPolicyPlayReadyConfigurationResponse'] = None,
                 widevine: Optional['outputs.StreamingPolicyWidevineConfigurationResponse'] = None):
        """
        Class to specify DRM configurations of CommonEncryptionCbcs scheme in Streaming Policy
        :param 'StreamingPolicyFairPlayConfigurationResponse' fair_play: FairPlay configurations
        :param 'StreamingPolicyPlayReadyConfigurationResponse' play_ready: PlayReady configurations
        :param 'StreamingPolicyWidevineConfigurationResponse' widevine: Widevine configurations
        """
        if fair_play is not None:
            pulumi.set(__self__, "fair_play", fair_play)
        if play_ready is not None:
            pulumi.set(__self__, "play_ready", play_ready)
        if widevine is not None:
            pulumi.set(__self__, "widevine", widevine)

    @property
    @pulumi.getter(name="fairPlay")
    def fair_play(self) -> Optional['outputs.StreamingPolicyFairPlayConfigurationResponse']:
        """
        FairPlay configurations
        """
        return pulumi.get(self, "fair_play")

    @property
    @pulumi.getter(name="playReady")
    def play_ready(self) -> Optional['outputs.StreamingPolicyPlayReadyConfigurationResponse']:
        """
        PlayReady configurations
        """
        return pulumi.get(self, "play_ready")

    @property
    @pulumi.getter
    def widevine(self) -> Optional['outputs.StreamingPolicyWidevineConfigurationResponse']:
        """
        Widevine configurations
        """
        return pulumi.get(self, "widevine")


@pulumi.output_type
class CencDrmConfigurationResponse(dict):
    """
    Class to specify DRM configurations of CommonEncryptionCenc scheme in Streaming Policy
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "playReady":
            suggest = "play_ready"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CencDrmConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CencDrmConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CencDrmConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 play_ready: Optional['outputs.StreamingPolicyPlayReadyConfigurationResponse'] = None,
                 widevine: Optional['outputs.StreamingPolicyWidevineConfigurationResponse'] = None):
        """
        Class to specify DRM configurations of CommonEncryptionCenc scheme in Streaming Policy
        :param 'StreamingPolicyPlayReadyConfigurationResponse' play_ready: PlayReady configurations
        :param 'StreamingPolicyWidevineConfigurationResponse' widevine: Widevine configurations
        """
        if play_ready is not None:
            pulumi.set(__self__, "play_ready", play_ready)
        if widevine is not None:
            pulumi.set(__self__, "widevine", widevine)

    @property
    @pulumi.getter(name="playReady")
    def play_ready(self) -> Optional['outputs.StreamingPolicyPlayReadyConfigurationResponse']:
        """
        PlayReady configurations
        """
        return pulumi.get(self, "play_ready")

    @property
    @pulumi.getter
    def widevine(self) -> Optional['outputs.StreamingPolicyWidevineConfigurationResponse']:
        """
        Widevine configurations
        """
        return pulumi.get(self, "widevine")


@pulumi.output_type
class CommonEncryptionCbcsResponse(dict):
    """
    Class for CommonEncryptionCbcs encryption scheme
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clearTracks":
            suggest = "clear_tracks"
        elif key == "contentKeys":
            suggest = "content_keys"
        elif key == "enabledProtocols":
            suggest = "enabled_protocols"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CommonEncryptionCbcsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CommonEncryptionCbcsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CommonEncryptionCbcsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 clear_tracks: Optional[Sequence['outputs.TrackSelectionResponse']] = None,
                 content_keys: Optional['outputs.StreamingPolicyContentKeysResponse'] = None,
                 drm: Optional['outputs.CbcsDrmConfigurationResponse'] = None,
                 enabled_protocols: Optional['outputs.EnabledProtocolsResponse'] = None):
        """
        Class for CommonEncryptionCbcs encryption scheme
        :param Sequence['TrackSelectionResponse'] clear_tracks: Representing which tracks should not be encrypted
        :param 'StreamingPolicyContentKeysResponse' content_keys: Representing default content key for each encryption scheme and separate content keys for specific tracks
        :param 'CbcsDrmConfigurationResponse' drm: Configuration of DRMs for current encryption scheme
        :param 'EnabledProtocolsResponse' enabled_protocols: Representing supported protocols
        """
        if clear_tracks is not None:
            pulumi.set(__self__, "clear_tracks", clear_tracks)
        if content_keys is not None:
            pulumi.set(__self__, "content_keys", content_keys)
        if drm is not None:
            pulumi.set(__self__, "drm", drm)
        if enabled_protocols is not None:
            pulumi.set(__self__, "enabled_protocols", enabled_protocols)

    @property
    @pulumi.getter(name="clearTracks")
    def clear_tracks(self) -> Optional[Sequence['outputs.TrackSelectionResponse']]:
        """
        Representing which tracks should not be encrypted
        """
        return pulumi.get(self, "clear_tracks")

    @property
    @pulumi.getter(name="contentKeys")
    def content_keys(self) -> Optional['outputs.StreamingPolicyContentKeysResponse']:
        """
        Representing default content key for each encryption scheme and separate content keys for specific tracks
        """
        return pulumi.get(self, "content_keys")

    @property
    @pulumi.getter
    def drm(self) -> Optional['outputs.CbcsDrmConfigurationResponse']:
        """
        Configuration of DRMs for current encryption scheme
        """
        return pulumi.get(self, "drm")

    @property
    @pulumi.getter(name="enabledProtocols")
    def enabled_protocols(self) -> Optional['outputs.EnabledProtocolsResponse']:
        """
        Representing supported protocols
        """
        return pulumi.get(self, "enabled_protocols")


@pulumi.output_type
class CommonEncryptionCencResponse(dict):
    """
    Class for envelope encryption scheme
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clearTracks":
            suggest = "clear_tracks"
        elif key == "contentKeys":
            suggest = "content_keys"
        elif key == "enabledProtocols":
            suggest = "enabled_protocols"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CommonEncryptionCencResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CommonEncryptionCencResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CommonEncryptionCencResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 clear_tracks: Optional[Sequence['outputs.TrackSelectionResponse']] = None,
                 content_keys: Optional['outputs.StreamingPolicyContentKeysResponse'] = None,
                 drm: Optional['outputs.CencDrmConfigurationResponse'] = None,
                 enabled_protocols: Optional['outputs.EnabledProtocolsResponse'] = None):
        """
        Class for envelope encryption scheme
        :param Sequence['TrackSelectionResponse'] clear_tracks: Representing which tracks should not be encrypted
        :param 'StreamingPolicyContentKeysResponse' content_keys: Representing default content key for each encryption scheme and separate content keys for specific tracks
        :param 'CencDrmConfigurationResponse' drm: Configuration of DRMs for CommonEncryptionCenc encryption scheme
        :param 'EnabledProtocolsResponse' enabled_protocols: Representing supported protocols
        """
        if clear_tracks is not None:
            pulumi.set(__self__, "clear_tracks", clear_tracks)
        if content_keys is not None:
            pulumi.set(__self__, "content_keys", content_keys)
        if drm is not None:
            pulumi.set(__self__, "drm", drm)
        if enabled_protocols is not None:
            pulumi.set(__self__, "enabled_protocols", enabled_protocols)

    @property
    @pulumi.getter(name="clearTracks")
    def clear_tracks(self) -> Optional[Sequence['outputs.TrackSelectionResponse']]:
        """
        Representing which tracks should not be encrypted
        """
        return pulumi.get(self, "clear_tracks")

    @property
    @pulumi.getter(name="contentKeys")
    def content_keys(self) -> Optional['outputs.StreamingPolicyContentKeysResponse']:
        """
        Representing default content key for each encryption scheme and separate content keys for specific tracks
        """
        return pulumi.get(self, "content_keys")

    @property
    @pulumi.getter
    def drm(self) -> Optional['outputs.CencDrmConfigurationResponse']:
        """
        Configuration of DRMs for CommonEncryptionCenc encryption scheme
        """
        return pulumi.get(self, "drm")

    @property
    @pulumi.getter(name="enabledProtocols")
    def enabled_protocols(self) -> Optional['outputs.EnabledProtocolsResponse']:
        """
        Representing supported protocols
        """
        return pulumi.get(self, "enabled_protocols")


@pulumi.output_type
class ContentKeyPolicyClearKeyConfigurationResponse(dict):
    """
    Represents a configuration for non-DRM keys.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContentKeyPolicyClearKeyConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContentKeyPolicyClearKeyConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContentKeyPolicyClearKeyConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str):
        """
        Represents a configuration for non-DRM keys.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.ContentKeyPolicyClearKeyConfiguration'.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.ContentKeyPolicyClearKeyConfiguration')

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.ContentKeyPolicyClearKeyConfiguration'.
        """
        return pulumi.get(self, "odata_type")


@pulumi.output_type
class ContentKeyPolicyFairPlayConfigurationResponse(dict):
    """
    Specifies a configuration for FairPlay licenses.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fairPlayPfx":
            suggest = "fair_play_pfx"
        elif key == "fairPlayPfxPassword":
            suggest = "fair_play_pfx_password"
        elif key == "odataType":
            suggest = "odata_type"
        elif key == "rentalAndLeaseKeyType":
            suggest = "rental_and_lease_key_type"
        elif key == "rentalDuration":
            suggest = "rental_duration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContentKeyPolicyFairPlayConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContentKeyPolicyFairPlayConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContentKeyPolicyFairPlayConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ask: str,
                 fair_play_pfx: str,
                 fair_play_pfx_password: str,
                 odata_type: str,
                 rental_and_lease_key_type: str,
                 rental_duration: float):
        """
        Specifies a configuration for FairPlay licenses.
        :param str ask: The key that must be used as FairPlay ASk.
        :param str fair_play_pfx: The Base64 representation of FairPlay certificate in PKCS 12 (pfx) format (including private key).
        :param str fair_play_pfx_password: The password encrypting FairPlay certificate in PKCS 12 (pfx) format.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.ContentKeyPolicyFairPlayConfiguration'.
        :param str rental_and_lease_key_type: The rental and lease key type.
        :param float rental_duration: The rental duration. Must be greater than or equal to 0.
        """
        pulumi.set(__self__, "ask", ask)
        pulumi.set(__self__, "fair_play_pfx", fair_play_pfx)
        pulumi.set(__self__, "fair_play_pfx_password", fair_play_pfx_password)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.ContentKeyPolicyFairPlayConfiguration')
        pulumi.set(__self__, "rental_and_lease_key_type", rental_and_lease_key_type)
        pulumi.set(__self__, "rental_duration", rental_duration)

    @property
    @pulumi.getter
    def ask(self) -> str:
        """
        The key that must be used as FairPlay ASk.
        """
        return pulumi.get(self, "ask")

    @property
    @pulumi.getter(name="fairPlayPfx")
    def fair_play_pfx(self) -> str:
        """
        The Base64 representation of FairPlay certificate in PKCS 12 (pfx) format (including private key).
        """
        return pulumi.get(self, "fair_play_pfx")

    @property
    @pulumi.getter(name="fairPlayPfxPassword")
    def fair_play_pfx_password(self) -> str:
        """
        The password encrypting FairPlay certificate in PKCS 12 (pfx) format.
        """
        return pulumi.get(self, "fair_play_pfx_password")

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.ContentKeyPolicyFairPlayConfiguration'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="rentalAndLeaseKeyType")
    def rental_and_lease_key_type(self) -> str:
        """
        The rental and lease key type.
        """
        return pulumi.get(self, "rental_and_lease_key_type")

    @property
    @pulumi.getter(name="rentalDuration")
    def rental_duration(self) -> float:
        """
        The rental duration. Must be greater than or equal to 0.
        """
        return pulumi.get(self, "rental_duration")


@pulumi.output_type
class ContentKeyPolicyOpenRestrictionResponse(dict):
    """
    Represents an open restriction. License or key will be delivered on every request.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContentKeyPolicyOpenRestrictionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContentKeyPolicyOpenRestrictionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContentKeyPolicyOpenRestrictionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str):
        """
        Represents an open restriction. License or key will be delivered on every request.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.ContentKeyPolicyOpenRestriction'.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.ContentKeyPolicyOpenRestriction')

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.ContentKeyPolicyOpenRestriction'.
        """
        return pulumi.get(self, "odata_type")


@pulumi.output_type
class ContentKeyPolicyOptionResponse(dict):
    """
    Represents a policy option.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "policyOptionId":
            suggest = "policy_option_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContentKeyPolicyOptionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContentKeyPolicyOptionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContentKeyPolicyOptionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 configuration: Any,
                 policy_option_id: str,
                 restriction: Any,
                 name: Optional[str] = None):
        """
        Represents a policy option.
        :param Union['ContentKeyPolicyClearKeyConfigurationResponse', 'ContentKeyPolicyFairPlayConfigurationResponse', 'ContentKeyPolicyPlayReadyConfigurationResponse', 'ContentKeyPolicyUnknownConfigurationResponse', 'ContentKeyPolicyWidevineConfigurationResponse'] configuration: The key delivery configuration.
        :param str policy_option_id: The legacy Policy Option ID.
        :param Union['ContentKeyPolicyOpenRestrictionResponse', 'ContentKeyPolicyTokenRestrictionResponse', 'ContentKeyPolicyUnknownRestrictionResponse'] restriction: The requirements that must be met to deliver keys with this configuration
        :param str name: The Policy Option description.
        """
        pulumi.set(__self__, "configuration", configuration)
        pulumi.set(__self__, "policy_option_id", policy_option_id)
        pulumi.set(__self__, "restriction", restriction)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def configuration(self) -> Any:
        """
        The key delivery configuration.
        """
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter(name="policyOptionId")
    def policy_option_id(self) -> str:
        """
        The legacy Policy Option ID.
        """
        return pulumi.get(self, "policy_option_id")

    @property
    @pulumi.getter
    def restriction(self) -> Any:
        """
        The requirements that must be met to deliver keys with this configuration
        """
        return pulumi.get(self, "restriction")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The Policy Option description.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ContentKeyPolicyPlayReadyConfigurationResponse(dict):
    """
    Specifies a configuration for PlayReady licenses.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "responseCustomData":
            suggest = "response_custom_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContentKeyPolicyPlayReadyConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContentKeyPolicyPlayReadyConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContentKeyPolicyPlayReadyConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 licenses: Sequence['outputs.ContentKeyPolicyPlayReadyLicenseResponse'],
                 odata_type: str,
                 response_custom_data: Optional[str] = None):
        """
        Specifies a configuration for PlayReady licenses.
        :param Sequence['ContentKeyPolicyPlayReadyLicenseResponse'] licenses: The PlayReady licenses.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.ContentKeyPolicyPlayReadyConfiguration'.
        :param str response_custom_data: The custom response data.
        """
        pulumi.set(__self__, "licenses", licenses)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.ContentKeyPolicyPlayReadyConfiguration')
        if response_custom_data is not None:
            pulumi.set(__self__, "response_custom_data", response_custom_data)

    @property
    @pulumi.getter
    def licenses(self) -> Sequence['outputs.ContentKeyPolicyPlayReadyLicenseResponse']:
        """
        The PlayReady licenses.
        """
        return pulumi.get(self, "licenses")

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.ContentKeyPolicyPlayReadyConfiguration'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="responseCustomData")
    def response_custom_data(self) -> Optional[str]:
        """
        The custom response data.
        """
        return pulumi.get(self, "response_custom_data")


@pulumi.output_type
class ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeaderResponse(dict):
    """
    Specifies that the content key ID is in the PlayReady header.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeaderResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeaderResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeaderResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str):
        """
        Specifies that the content key ID is in the PlayReady header.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader'.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader')

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader'.
        """
        return pulumi.get(self, "odata_type")


@pulumi.output_type
class ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifierResponse(dict):
    """
    Specifies that the content key ID is specified in the PlayReady configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyId":
            suggest = "key_id"
        elif key == "odataType":
            suggest = "odata_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifierResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifierResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifierResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_id: str,
                 odata_type: str):
        """
        Specifies that the content key ID is specified in the PlayReady configuration.
        :param str key_id: The content key ID.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier'.
        """
        pulumi.set(__self__, "key_id", key_id)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier')

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> str:
        """
        The content key ID.
        """
        return pulumi.get(self, "key_id")

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier'.
        """
        return pulumi.get(self, "odata_type")


@pulumi.output_type
class ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestrictionResponse(dict):
    """
    Configures the Explicit Analog Television Output Restriction control bits. For further details see the PlayReady Compliance Rules.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bestEffort":
            suggest = "best_effort"
        elif key == "configurationData":
            suggest = "configuration_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestrictionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestrictionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestrictionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 best_effort: bool,
                 configuration_data: int):
        """
        Configures the Explicit Analog Television Output Restriction control bits. For further details see the PlayReady Compliance Rules.
        :param bool best_effort: Indicates whether this restriction is enforced on a Best Effort basis.
        :param int configuration_data: Configures the restriction control bits. Must be between 0 and 3 inclusive.
        """
        pulumi.set(__self__, "best_effort", best_effort)
        pulumi.set(__self__, "configuration_data", configuration_data)

    @property
    @pulumi.getter(name="bestEffort")
    def best_effort(self) -> bool:
        """
        Indicates whether this restriction is enforced on a Best Effort basis.
        """
        return pulumi.get(self, "best_effort")

    @property
    @pulumi.getter(name="configurationData")
    def configuration_data(self) -> int:
        """
        Configures the restriction control bits. Must be between 0 and 3 inclusive.
        """
        return pulumi.get(self, "configuration_data")


@pulumi.output_type
class ContentKeyPolicyPlayReadyLicenseResponse(dict):
    """
    The PlayReady license
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowTestDevices":
            suggest = "allow_test_devices"
        elif key == "contentKeyLocation":
            suggest = "content_key_location"
        elif key == "contentType":
            suggest = "content_type"
        elif key == "licenseType":
            suggest = "license_type"
        elif key == "beginDate":
            suggest = "begin_date"
        elif key == "expirationDate":
            suggest = "expiration_date"
        elif key == "gracePeriod":
            suggest = "grace_period"
        elif key == "playRight":
            suggest = "play_right"
        elif key == "relativeBeginDate":
            suggest = "relative_begin_date"
        elif key == "relativeExpirationDate":
            suggest = "relative_expiration_date"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContentKeyPolicyPlayReadyLicenseResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContentKeyPolicyPlayReadyLicenseResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContentKeyPolicyPlayReadyLicenseResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_test_devices: bool,
                 content_key_location: Any,
                 content_type: str,
                 license_type: str,
                 begin_date: Optional[str] = None,
                 expiration_date: Optional[str] = None,
                 grace_period: Optional[str] = None,
                 play_right: Optional['outputs.ContentKeyPolicyPlayReadyPlayRightResponse'] = None,
                 relative_begin_date: Optional[str] = None,
                 relative_expiration_date: Optional[str] = None):
        """
        The PlayReady license
        :param bool allow_test_devices: A flag indicating whether test devices can use the license.
        :param Union['ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeaderResponse', 'ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifierResponse'] content_key_location: The content key location.
        :param str content_type: The PlayReady content type.
        :param str license_type: The license type.
        :param str begin_date: The begin date of license
        :param str expiration_date: The expiration date of license.
        :param str grace_period: The grace period of license.
        :param 'ContentKeyPolicyPlayReadyPlayRightResponse' play_right: The license PlayRight
        :param str relative_begin_date: The relative begin date of license.
        :param str relative_expiration_date: The relative expiration date of license.
        """
        pulumi.set(__self__, "allow_test_devices", allow_test_devices)
        pulumi.set(__self__, "content_key_location", content_key_location)
        pulumi.set(__self__, "content_type", content_type)
        pulumi.set(__self__, "license_type", license_type)
        if begin_date is not None:
            pulumi.set(__self__, "begin_date", begin_date)
        if expiration_date is not None:
            pulumi.set(__self__, "expiration_date", expiration_date)
        if grace_period is not None:
            pulumi.set(__self__, "grace_period", grace_period)
        if play_right is not None:
            pulumi.set(__self__, "play_right", play_right)
        if relative_begin_date is not None:
            pulumi.set(__self__, "relative_begin_date", relative_begin_date)
        if relative_expiration_date is not None:
            pulumi.set(__self__, "relative_expiration_date", relative_expiration_date)

    @property
    @pulumi.getter(name="allowTestDevices")
    def allow_test_devices(self) -> bool:
        """
        A flag indicating whether test devices can use the license.
        """
        return pulumi.get(self, "allow_test_devices")

    @property
    @pulumi.getter(name="contentKeyLocation")
    def content_key_location(self) -> Any:
        """
        The content key location.
        """
        return pulumi.get(self, "content_key_location")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> str:
        """
        The PlayReady content type.
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> str:
        """
        The license type.
        """
        return pulumi.get(self, "license_type")

    @property
    @pulumi.getter(name="beginDate")
    def begin_date(self) -> Optional[str]:
        """
        The begin date of license
        """
        return pulumi.get(self, "begin_date")

    @property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> Optional[str]:
        """
        The expiration date of license.
        """
        return pulumi.get(self, "expiration_date")

    @property
    @pulumi.getter(name="gracePeriod")
    def grace_period(self) -> Optional[str]:
        """
        The grace period of license.
        """
        return pulumi.get(self, "grace_period")

    @property
    @pulumi.getter(name="playRight")
    def play_right(self) -> Optional['outputs.ContentKeyPolicyPlayReadyPlayRightResponse']:
        """
        The license PlayRight
        """
        return pulumi.get(self, "play_right")

    @property
    @pulumi.getter(name="relativeBeginDate")
    def relative_begin_date(self) -> Optional[str]:
        """
        The relative begin date of license.
        """
        return pulumi.get(self, "relative_begin_date")

    @property
    @pulumi.getter(name="relativeExpirationDate")
    def relative_expiration_date(self) -> Optional[str]:
        """
        The relative expiration date of license.
        """
        return pulumi.get(self, "relative_expiration_date")


@pulumi.output_type
class ContentKeyPolicyPlayReadyPlayRightResponse(dict):
    """
    Configures the Play Right in the PlayReady license.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowPassingVideoContentToUnknownOutput":
            suggest = "allow_passing_video_content_to_unknown_output"
        elif key == "digitalVideoOnlyContentRestriction":
            suggest = "digital_video_only_content_restriction"
        elif key == "imageConstraintForAnalogComponentVideoRestriction":
            suggest = "image_constraint_for_analog_component_video_restriction"
        elif key == "imageConstraintForAnalogComputerMonitorRestriction":
            suggest = "image_constraint_for_analog_computer_monitor_restriction"
        elif key == "agcAndColorStripeRestriction":
            suggest = "agc_and_color_stripe_restriction"
        elif key == "analogVideoOpl":
            suggest = "analog_video_opl"
        elif key == "compressedDigitalAudioOpl":
            suggest = "compressed_digital_audio_opl"
        elif key == "compressedDigitalVideoOpl":
            suggest = "compressed_digital_video_opl"
        elif key == "explicitAnalogTelevisionOutputRestriction":
            suggest = "explicit_analog_television_output_restriction"
        elif key == "firstPlayExpiration":
            suggest = "first_play_expiration"
        elif key == "scmsRestriction":
            suggest = "scms_restriction"
        elif key == "uncompressedDigitalAudioOpl":
            suggest = "uncompressed_digital_audio_opl"
        elif key == "uncompressedDigitalVideoOpl":
            suggest = "uncompressed_digital_video_opl"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContentKeyPolicyPlayReadyPlayRightResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContentKeyPolicyPlayReadyPlayRightResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContentKeyPolicyPlayReadyPlayRightResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_passing_video_content_to_unknown_output: str,
                 digital_video_only_content_restriction: bool,
                 image_constraint_for_analog_component_video_restriction: bool,
                 image_constraint_for_analog_computer_monitor_restriction: bool,
                 agc_and_color_stripe_restriction: Optional[int] = None,
                 analog_video_opl: Optional[int] = None,
                 compressed_digital_audio_opl: Optional[int] = None,
                 compressed_digital_video_opl: Optional[int] = None,
                 explicit_analog_television_output_restriction: Optional['outputs.ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestrictionResponse'] = None,
                 first_play_expiration: Optional[str] = None,
                 scms_restriction: Optional[int] = None,
                 uncompressed_digital_audio_opl: Optional[int] = None,
                 uncompressed_digital_video_opl: Optional[int] = None):
        """
        Configures the Play Right in the PlayReady license.
        :param str allow_passing_video_content_to_unknown_output: Configures Unknown output handling settings of the license.
        :param bool digital_video_only_content_restriction: Enables the Image Constraint For Analog Component Video Restriction in the license.
        :param bool image_constraint_for_analog_component_video_restriction: Enables the Image Constraint For Analog Component Video Restriction in the license.
        :param bool image_constraint_for_analog_computer_monitor_restriction: Enables the Image Constraint For Analog Component Video Restriction in the license.
        :param int agc_and_color_stripe_restriction: Configures Automatic Gain Control (AGC) and Color Stripe in the license. Must be between 0 and 3 inclusive.
        :param int analog_video_opl: Specifies the output protection level for compressed digital audio.
        :param int compressed_digital_audio_opl: Specifies the output protection level for compressed digital audio.
        :param int compressed_digital_video_opl: Specifies the output protection level for compressed digital video.
        :param 'ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestrictionResponse' explicit_analog_television_output_restriction: Configures the Explicit Analog Television Output Restriction in the license. Configuration data must be between 0 and 3 inclusive.
        :param str first_play_expiration: The amount of time that the license is valid after the license is first used to play content.
        :param int scms_restriction: Configures the Serial Copy Management System (SCMS) in the license. Must be between 0 and 3 inclusive.
        :param int uncompressed_digital_audio_opl: Specifies the output protection level for uncompressed digital audio.
        :param int uncompressed_digital_video_opl: Specifies the output protection level for uncompressed digital video.
        """
        pulumi.set(__self__, "allow_passing_video_content_to_unknown_output", allow_passing_video_content_to_unknown_output)
        pulumi.set(__self__, "digital_video_only_content_restriction", digital_video_only_content_restriction)
        pulumi.set(__self__, "image_constraint_for_analog_component_video_restriction", image_constraint_for_analog_component_video_restriction)
        pulumi.set(__self__, "image_constraint_for_analog_computer_monitor_restriction", image_constraint_for_analog_computer_monitor_restriction)
        if agc_and_color_stripe_restriction is not None:
            pulumi.set(__self__, "agc_and_color_stripe_restriction", agc_and_color_stripe_restriction)
        if analog_video_opl is not None:
            pulumi.set(__self__, "analog_video_opl", analog_video_opl)
        if compressed_digital_audio_opl is not None:
            pulumi.set(__self__, "compressed_digital_audio_opl", compressed_digital_audio_opl)
        if compressed_digital_video_opl is not None:
            pulumi.set(__self__, "compressed_digital_video_opl", compressed_digital_video_opl)
        if explicit_analog_television_output_restriction is not None:
            pulumi.set(__self__, "explicit_analog_television_output_restriction", explicit_analog_television_output_restriction)
        if first_play_expiration is not None:
            pulumi.set(__self__, "first_play_expiration", first_play_expiration)
        if scms_restriction is not None:
            pulumi.set(__self__, "scms_restriction", scms_restriction)
        if uncompressed_digital_audio_opl is not None:
            pulumi.set(__self__, "uncompressed_digital_audio_opl", uncompressed_digital_audio_opl)
        if uncompressed_digital_video_opl is not None:
            pulumi.set(__self__, "uncompressed_digital_video_opl", uncompressed_digital_video_opl)

    @property
    @pulumi.getter(name="allowPassingVideoContentToUnknownOutput")
    def allow_passing_video_content_to_unknown_output(self) -> str:
        """
        Configures Unknown output handling settings of the license.
        """
        return pulumi.get(self, "allow_passing_video_content_to_unknown_output")

    @property
    @pulumi.getter(name="digitalVideoOnlyContentRestriction")
    def digital_video_only_content_restriction(self) -> bool:
        """
        Enables the Image Constraint For Analog Component Video Restriction in the license.
        """
        return pulumi.get(self, "digital_video_only_content_restriction")

    @property
    @pulumi.getter(name="imageConstraintForAnalogComponentVideoRestriction")
    def image_constraint_for_analog_component_video_restriction(self) -> bool:
        """
        Enables the Image Constraint For Analog Component Video Restriction in the license.
        """
        return pulumi.get(self, "image_constraint_for_analog_component_video_restriction")

    @property
    @pulumi.getter(name="imageConstraintForAnalogComputerMonitorRestriction")
    def image_constraint_for_analog_computer_monitor_restriction(self) -> bool:
        """
        Enables the Image Constraint For Analog Component Video Restriction in the license.
        """
        return pulumi.get(self, "image_constraint_for_analog_computer_monitor_restriction")

    @property
    @pulumi.getter(name="agcAndColorStripeRestriction")
    def agc_and_color_stripe_restriction(self) -> Optional[int]:
        """
        Configures Automatic Gain Control (AGC) and Color Stripe in the license. Must be between 0 and 3 inclusive.
        """
        return pulumi.get(self, "agc_and_color_stripe_restriction")

    @property
    @pulumi.getter(name="analogVideoOpl")
    def analog_video_opl(self) -> Optional[int]:
        """
        Specifies the output protection level for compressed digital audio.
        """
        return pulumi.get(self, "analog_video_opl")

    @property
    @pulumi.getter(name="compressedDigitalAudioOpl")
    def compressed_digital_audio_opl(self) -> Optional[int]:
        """
        Specifies the output protection level for compressed digital audio.
        """
        return pulumi.get(self, "compressed_digital_audio_opl")

    @property
    @pulumi.getter(name="compressedDigitalVideoOpl")
    def compressed_digital_video_opl(self) -> Optional[int]:
        """
        Specifies the output protection level for compressed digital video.
        """
        return pulumi.get(self, "compressed_digital_video_opl")

    @property
    @pulumi.getter(name="explicitAnalogTelevisionOutputRestriction")
    def explicit_analog_television_output_restriction(self) -> Optional['outputs.ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestrictionResponse']:
        """
        Configures the Explicit Analog Television Output Restriction in the license. Configuration data must be between 0 and 3 inclusive.
        """
        return pulumi.get(self, "explicit_analog_television_output_restriction")

    @property
    @pulumi.getter(name="firstPlayExpiration")
    def first_play_expiration(self) -> Optional[str]:
        """
        The amount of time that the license is valid after the license is first used to play content.
        """
        return pulumi.get(self, "first_play_expiration")

    @property
    @pulumi.getter(name="scmsRestriction")
    def scms_restriction(self) -> Optional[int]:
        """
        Configures the Serial Copy Management System (SCMS) in the license. Must be between 0 and 3 inclusive.
        """
        return pulumi.get(self, "scms_restriction")

    @property
    @pulumi.getter(name="uncompressedDigitalAudioOpl")
    def uncompressed_digital_audio_opl(self) -> Optional[int]:
        """
        Specifies the output protection level for uncompressed digital audio.
        """
        return pulumi.get(self, "uncompressed_digital_audio_opl")

    @property
    @pulumi.getter(name="uncompressedDigitalVideoOpl")
    def uncompressed_digital_video_opl(self) -> Optional[int]:
        """
        Specifies the output protection level for uncompressed digital video.
        """
        return pulumi.get(self, "uncompressed_digital_video_opl")


@pulumi.output_type
class ContentKeyPolicyRsaTokenKeyResponse(dict):
    """
    Specifies a RSA key for token validation
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContentKeyPolicyRsaTokenKeyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContentKeyPolicyRsaTokenKeyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContentKeyPolicyRsaTokenKeyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exponent: str,
                 modulus: str,
                 odata_type: str):
        """
        Specifies a RSA key for token validation
        :param str exponent: The RSA Parameter exponent
        :param str modulus: The RSA Parameter modulus
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.ContentKeyPolicyRsaTokenKey'.
        """
        pulumi.set(__self__, "exponent", exponent)
        pulumi.set(__self__, "modulus", modulus)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.ContentKeyPolicyRsaTokenKey')

    @property
    @pulumi.getter
    def exponent(self) -> str:
        """
        The RSA Parameter exponent
        """
        return pulumi.get(self, "exponent")

    @property
    @pulumi.getter
    def modulus(self) -> str:
        """
        The RSA Parameter modulus
        """
        return pulumi.get(self, "modulus")

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.ContentKeyPolicyRsaTokenKey'.
        """
        return pulumi.get(self, "odata_type")


@pulumi.output_type
class ContentKeyPolicySymmetricTokenKeyResponse(dict):
    """
    Specifies a symmetric key for token validation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyValue":
            suggest = "key_value"
        elif key == "odataType":
            suggest = "odata_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContentKeyPolicySymmetricTokenKeyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContentKeyPolicySymmetricTokenKeyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContentKeyPolicySymmetricTokenKeyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_value: str,
                 odata_type: str):
        """
        Specifies a symmetric key for token validation.
        :param str key_value: The key value of the key
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.ContentKeyPolicySymmetricTokenKey'.
        """
        pulumi.set(__self__, "key_value", key_value)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.ContentKeyPolicySymmetricTokenKey')

    @property
    @pulumi.getter(name="keyValue")
    def key_value(self) -> str:
        """
        The key value of the key
        """
        return pulumi.get(self, "key_value")

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.ContentKeyPolicySymmetricTokenKey'.
        """
        return pulumi.get(self, "odata_type")


@pulumi.output_type
class ContentKeyPolicyTokenClaimResponse(dict):
    """
    Represents a token claim.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "claimType":
            suggest = "claim_type"
        elif key == "claimValue":
            suggest = "claim_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContentKeyPolicyTokenClaimResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContentKeyPolicyTokenClaimResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContentKeyPolicyTokenClaimResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 claim_type: Optional[str] = None,
                 claim_value: Optional[str] = None):
        """
        Represents a token claim.
        :param str claim_type: Token claim type.
        :param str claim_value: Token claim value.
        """
        if claim_type is not None:
            pulumi.set(__self__, "claim_type", claim_type)
        if claim_value is not None:
            pulumi.set(__self__, "claim_value", claim_value)

    @property
    @pulumi.getter(name="claimType")
    def claim_type(self) -> Optional[str]:
        """
        Token claim type.
        """
        return pulumi.get(self, "claim_type")

    @property
    @pulumi.getter(name="claimValue")
    def claim_value(self) -> Optional[str]:
        """
        Token claim value.
        """
        return pulumi.get(self, "claim_value")


@pulumi.output_type
class ContentKeyPolicyTokenRestrictionResponse(dict):
    """
    Represents a token restriction. Provided token must match these requirements for successful license or key delivery.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "primaryVerificationKey":
            suggest = "primary_verification_key"
        elif key == "restrictionTokenType":
            suggest = "restriction_token_type"
        elif key == "alternateVerificationKeys":
            suggest = "alternate_verification_keys"
        elif key == "openIdConnectDiscoveryDocument":
            suggest = "open_id_connect_discovery_document"
        elif key == "requiredClaims":
            suggest = "required_claims"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContentKeyPolicyTokenRestrictionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContentKeyPolicyTokenRestrictionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContentKeyPolicyTokenRestrictionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 audience: str,
                 issuer: str,
                 odata_type: str,
                 primary_verification_key: Any,
                 restriction_token_type: str,
                 alternate_verification_keys: Optional[Sequence[Any]] = None,
                 open_id_connect_discovery_document: Optional[str] = None,
                 required_claims: Optional[Sequence['outputs.ContentKeyPolicyTokenClaimResponse']] = None):
        """
        Represents a token restriction. Provided token must match these requirements for successful license or key delivery.
        :param str audience: The audience for the token.
        :param str issuer: The token issuer.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.ContentKeyPolicyTokenRestriction'.
        :param Union['ContentKeyPolicyRsaTokenKeyResponse', 'ContentKeyPolicySymmetricTokenKeyResponse', 'ContentKeyPolicyX509CertificateTokenKeyResponse'] primary_verification_key: The primary verification key.
        :param str restriction_token_type: The type of token.
        :param Sequence[Union['ContentKeyPolicyRsaTokenKeyResponse', 'ContentKeyPolicySymmetricTokenKeyResponse', 'ContentKeyPolicyX509CertificateTokenKeyResponse']] alternate_verification_keys: A list of alternative verification keys.
        :param str open_id_connect_discovery_document: The OpenID connect discovery document.
        :param Sequence['ContentKeyPolicyTokenClaimResponse'] required_claims: A list of required token claims.
        """
        pulumi.set(__self__, "audience", audience)
        pulumi.set(__self__, "issuer", issuer)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.ContentKeyPolicyTokenRestriction')
        pulumi.set(__self__, "primary_verification_key", primary_verification_key)
        pulumi.set(__self__, "restriction_token_type", restriction_token_type)
        if alternate_verification_keys is not None:
            pulumi.set(__self__, "alternate_verification_keys", alternate_verification_keys)
        if open_id_connect_discovery_document is not None:
            pulumi.set(__self__, "open_id_connect_discovery_document", open_id_connect_discovery_document)
        if required_claims is not None:
            pulumi.set(__self__, "required_claims", required_claims)

    @property
    @pulumi.getter
    def audience(self) -> str:
        """
        The audience for the token.
        """
        return pulumi.get(self, "audience")

    @property
    @pulumi.getter
    def issuer(self) -> str:
        """
        The token issuer.
        """
        return pulumi.get(self, "issuer")

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.ContentKeyPolicyTokenRestriction'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="primaryVerificationKey")
    def primary_verification_key(self) -> Any:
        """
        The primary verification key.
        """
        return pulumi.get(self, "primary_verification_key")

    @property
    @pulumi.getter(name="restrictionTokenType")
    def restriction_token_type(self) -> str:
        """
        The type of token.
        """
        return pulumi.get(self, "restriction_token_type")

    @property
    @pulumi.getter(name="alternateVerificationKeys")
    def alternate_verification_keys(self) -> Optional[Sequence[Any]]:
        """
        A list of alternative verification keys.
        """
        return pulumi.get(self, "alternate_verification_keys")

    @property
    @pulumi.getter(name="openIdConnectDiscoveryDocument")
    def open_id_connect_discovery_document(self) -> Optional[str]:
        """
        The OpenID connect discovery document.
        """
        return pulumi.get(self, "open_id_connect_discovery_document")

    @property
    @pulumi.getter(name="requiredClaims")
    def required_claims(self) -> Optional[Sequence['outputs.ContentKeyPolicyTokenClaimResponse']]:
        """
        A list of required token claims.
        """
        return pulumi.get(self, "required_claims")


@pulumi.output_type
class ContentKeyPolicyUnknownConfigurationResponse(dict):
    """
    Represents a ContentKeyPolicyConfiguration that is unavailable in the current API version.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContentKeyPolicyUnknownConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContentKeyPolicyUnknownConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContentKeyPolicyUnknownConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str):
        """
        Represents a ContentKeyPolicyConfiguration that is unavailable in the current API version.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.ContentKeyPolicyUnknownConfiguration'.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.ContentKeyPolicyUnknownConfiguration')

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.ContentKeyPolicyUnknownConfiguration'.
        """
        return pulumi.get(self, "odata_type")


@pulumi.output_type
class ContentKeyPolicyUnknownRestrictionResponse(dict):
    """
    Represents a ContentKeyPolicyRestriction that is unavailable in the current API version.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContentKeyPolicyUnknownRestrictionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContentKeyPolicyUnknownRestrictionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContentKeyPolicyUnknownRestrictionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str):
        """
        Represents a ContentKeyPolicyRestriction that is unavailable in the current API version.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.ContentKeyPolicyUnknownRestriction'.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.ContentKeyPolicyUnknownRestriction')

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.ContentKeyPolicyUnknownRestriction'.
        """
        return pulumi.get(self, "odata_type")


@pulumi.output_type
class ContentKeyPolicyWidevineConfigurationResponse(dict):
    """
    Specifies a configuration for Widevine licenses.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "widevineTemplate":
            suggest = "widevine_template"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContentKeyPolicyWidevineConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContentKeyPolicyWidevineConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContentKeyPolicyWidevineConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 widevine_template: str):
        """
        Specifies a configuration for Widevine licenses.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.ContentKeyPolicyWidevineConfiguration'.
        :param str widevine_template: The Widevine template.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.ContentKeyPolicyWidevineConfiguration')
        pulumi.set(__self__, "widevine_template", widevine_template)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.ContentKeyPolicyWidevineConfiguration'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="widevineTemplate")
    def widevine_template(self) -> str:
        """
        The Widevine template.
        """
        return pulumi.get(self, "widevine_template")


@pulumi.output_type
class ContentKeyPolicyX509CertificateTokenKeyResponse(dict):
    """
    Specifies a certificate for token validation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "rawBody":
            suggest = "raw_body"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContentKeyPolicyX509CertificateTokenKeyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContentKeyPolicyX509CertificateTokenKeyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContentKeyPolicyX509CertificateTokenKeyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 raw_body: str):
        """
        Specifies a certificate for token validation.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.ContentKeyPolicyX509CertificateTokenKey'.
        :param str raw_body: The raw data field of a certificate in PKCS 12 format (X509Certificate2 in .NET)
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.ContentKeyPolicyX509CertificateTokenKey')
        pulumi.set(__self__, "raw_body", raw_body)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.ContentKeyPolicyX509CertificateTokenKey'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="rawBody")
    def raw_body(self) -> str:
        """
        The raw data field of a certificate in PKCS 12 format (X509Certificate2 in .NET)
        """
        return pulumi.get(self, "raw_body")


@pulumi.output_type
class CopyAudioResponse(dict):
    """
    A codec flag, which tells the encoder to copy the input audio bitstream.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CopyAudioResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CopyAudioResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CopyAudioResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 label: Optional[str] = None):
        """
        A codec flag, which tells the encoder to copy the input audio bitstream.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.CopyAudio'.
        :param str label: An optional label for the codec. The label can be used to control muxing behavior.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.CopyAudio')
        if label is not None:
            pulumi.set(__self__, "label", label)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.CopyAudio'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter
    def label(self) -> Optional[str]:
        """
        An optional label for the codec. The label can be used to control muxing behavior.
        """
        return pulumi.get(self, "label")


@pulumi.output_type
class CopyVideoResponse(dict):
    """
    A codec flag, which tells the encoder to copy the input video bitstream without re-encoding.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CopyVideoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CopyVideoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CopyVideoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 label: Optional[str] = None):
        """
        A codec flag, which tells the encoder to copy the input video bitstream without re-encoding.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.CopyVideo'.
        :param str label: An optional label for the codec. The label can be used to control muxing behavior.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.CopyVideo')
        if label is not None:
            pulumi.set(__self__, "label", label)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.CopyVideo'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter
    def label(self) -> Optional[str]:
        """
        An optional label for the codec. The label can be used to control muxing behavior.
        """
        return pulumi.get(self, "label")


@pulumi.output_type
class CrossSiteAccessPoliciesResponse(dict):
    """
    The client access policy.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientAccessPolicy":
            suggest = "client_access_policy"
        elif key == "crossDomainPolicy":
            suggest = "cross_domain_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CrossSiteAccessPoliciesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CrossSiteAccessPoliciesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CrossSiteAccessPoliciesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_access_policy: Optional[str] = None,
                 cross_domain_policy: Optional[str] = None):
        """
        The client access policy.
        :param str client_access_policy: The content of clientaccesspolicy.xml used by Silverlight.
        :param str cross_domain_policy: The content of crossdomain.xml used by Silverlight.
        """
        if client_access_policy is not None:
            pulumi.set(__self__, "client_access_policy", client_access_policy)
        if cross_domain_policy is not None:
            pulumi.set(__self__, "cross_domain_policy", cross_domain_policy)

    @property
    @pulumi.getter(name="clientAccessPolicy")
    def client_access_policy(self) -> Optional[str]:
        """
        The content of clientaccesspolicy.xml used by Silverlight.
        """
        return pulumi.get(self, "client_access_policy")

    @property
    @pulumi.getter(name="crossDomainPolicy")
    def cross_domain_policy(self) -> Optional[str]:
        """
        The content of crossdomain.xml used by Silverlight.
        """
        return pulumi.get(self, "cross_domain_policy")


@pulumi.output_type
class DefaultKeyResponse(dict):
    """
    Class to specify properties of default content key for each encryption scheme
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "policyName":
            suggest = "policy_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DefaultKeyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DefaultKeyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DefaultKeyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 label: Optional[str] = None,
                 policy_name: Optional[str] = None):
        """
        Class to specify properties of default content key for each encryption scheme
        :param str label: Label can be used to specify Content Key when creating a Streaming Locator
        :param str policy_name: Policy used by Default Key
        """
        if label is not None:
            pulumi.set(__self__, "label", label)
        if policy_name is not None:
            pulumi.set(__self__, "policy_name", policy_name)

    @property
    @pulumi.getter
    def label(self) -> Optional[str]:
        """
        Label can be used to specify Content Key when creating a Streaming Locator
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> Optional[str]:
        """
        Policy used by Default Key
        """
        return pulumi.get(self, "policy_name")


@pulumi.output_type
class DeinterlaceResponse(dict):
    """
    Describes the de-interlacing settings.
    """
    def __init__(__self__, *,
                 mode: Optional[str] = None,
                 parity: Optional[str] = None):
        """
        Describes the de-interlacing settings.
        :param str mode: The deinterlacing mode. Defaults to AutoPixelAdaptive.
        :param str parity: The field parity for de-interlacing, defaults to Auto.
        """
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if parity is not None:
            pulumi.set(__self__, "parity", parity)

    @property
    @pulumi.getter
    def mode(self) -> Optional[str]:
        """
        The deinterlacing mode. Defaults to AutoPixelAdaptive.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def parity(self) -> Optional[str]:
        """
        The field parity for de-interlacing, defaults to Auto.
        """
        return pulumi.get(self, "parity")


@pulumi.output_type
class EnabledProtocolsResponse(dict):
    """
    Class to specify which protocols are enabled
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "smoothStreaming":
            suggest = "smooth_streaming"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnabledProtocolsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnabledProtocolsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnabledProtocolsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dash: bool,
                 download: bool,
                 hls: bool,
                 smooth_streaming: bool):
        """
        Class to specify which protocols are enabled
        :param bool dash: Enable DASH protocol or not
        :param bool download: Enable Download protocol or not
        :param bool hls: Enable HLS protocol or not
        :param bool smooth_streaming: Enable SmoothStreaming protocol or not
        """
        pulumi.set(__self__, "dash", dash)
        pulumi.set(__self__, "download", download)
        pulumi.set(__self__, "hls", hls)
        pulumi.set(__self__, "smooth_streaming", smooth_streaming)

    @property
    @pulumi.getter
    def dash(self) -> bool:
        """
        Enable DASH protocol or not
        """
        return pulumi.get(self, "dash")

    @property
    @pulumi.getter
    def download(self) -> bool:
        """
        Enable Download protocol or not
        """
        return pulumi.get(self, "download")

    @property
    @pulumi.getter
    def hls(self) -> bool:
        """
        Enable HLS protocol or not
        """
        return pulumi.get(self, "hls")

    @property
    @pulumi.getter(name="smoothStreaming")
    def smooth_streaming(self) -> bool:
        """
        Enable SmoothStreaming protocol or not
        """
        return pulumi.get(self, "smooth_streaming")


@pulumi.output_type
class EnvelopeEncryptionResponse(dict):
    """
    Class for EnvelopeEncryption encryption scheme
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clearTracks":
            suggest = "clear_tracks"
        elif key == "contentKeys":
            suggest = "content_keys"
        elif key == "customKeyAcquisitionUrlTemplate":
            suggest = "custom_key_acquisition_url_template"
        elif key == "enabledProtocols":
            suggest = "enabled_protocols"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvelopeEncryptionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvelopeEncryptionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvelopeEncryptionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 clear_tracks: Optional[Sequence['outputs.TrackSelectionResponse']] = None,
                 content_keys: Optional['outputs.StreamingPolicyContentKeysResponse'] = None,
                 custom_key_acquisition_url_template: Optional[str] = None,
                 enabled_protocols: Optional['outputs.EnabledProtocolsResponse'] = None):
        """
        Class for EnvelopeEncryption encryption scheme
        :param Sequence['TrackSelectionResponse'] clear_tracks: Representing which tracks should not be encrypted
        :param 'StreamingPolicyContentKeysResponse' content_keys: Representing default content key for each encryption scheme and separate content keys for specific tracks
        :param str custom_key_acquisition_url_template: KeyAcquisitionUrlTemplate is used to point to user specified service to delivery content keys
        :param 'EnabledProtocolsResponse' enabled_protocols: Representing supported protocols
        """
        if clear_tracks is not None:
            pulumi.set(__self__, "clear_tracks", clear_tracks)
        if content_keys is not None:
            pulumi.set(__self__, "content_keys", content_keys)
        if custom_key_acquisition_url_template is not None:
            pulumi.set(__self__, "custom_key_acquisition_url_template", custom_key_acquisition_url_template)
        if enabled_protocols is not None:
            pulumi.set(__self__, "enabled_protocols", enabled_protocols)

    @property
    @pulumi.getter(name="clearTracks")
    def clear_tracks(self) -> Optional[Sequence['outputs.TrackSelectionResponse']]:
        """
        Representing which tracks should not be encrypted
        """
        return pulumi.get(self, "clear_tracks")

    @property
    @pulumi.getter(name="contentKeys")
    def content_keys(self) -> Optional['outputs.StreamingPolicyContentKeysResponse']:
        """
        Representing default content key for each encryption scheme and separate content keys for specific tracks
        """
        return pulumi.get(self, "content_keys")

    @property
    @pulumi.getter(name="customKeyAcquisitionUrlTemplate")
    def custom_key_acquisition_url_template(self) -> Optional[str]:
        """
        KeyAcquisitionUrlTemplate is used to point to user specified service to delivery content keys
        """
        return pulumi.get(self, "custom_key_acquisition_url_template")

    @property
    @pulumi.getter(name="enabledProtocols")
    def enabled_protocols(self) -> Optional['outputs.EnabledProtocolsResponse']:
        """
        Representing supported protocols
        """
        return pulumi.get(self, "enabled_protocols")


@pulumi.output_type
class FiltersResponse(dict):
    """
    Describes all the filtering operations, such as de-interlacing, rotation etc. that are to be applied to the input media before encoding.
    """
    def __init__(__self__, *,
                 crop: Optional['outputs.RectangleResponse'] = None,
                 deinterlace: Optional['outputs.DeinterlaceResponse'] = None,
                 overlays: Optional[Sequence[Any]] = None,
                 rotation: Optional[str] = None):
        """
        Describes all the filtering operations, such as de-interlacing, rotation etc. that are to be applied to the input media before encoding.
        :param 'RectangleResponse' crop: The parameters for the rectangular window with which to crop the input video.
        :param 'DeinterlaceResponse' deinterlace: The de-interlacing settings.
        :param Sequence[Union['AudioOverlayResponse', 'VideoOverlayResponse']] overlays: The properties of overlays to be applied to the input video. These could be audio, image or video overlays.
        :param str rotation: The rotation, if any, to be applied to the input video, before it is encoded. Default is Auto
        """
        if crop is not None:
            pulumi.set(__self__, "crop", crop)
        if deinterlace is not None:
            pulumi.set(__self__, "deinterlace", deinterlace)
        if overlays is not None:
            pulumi.set(__self__, "overlays", overlays)
        if rotation is not None:
            pulumi.set(__self__, "rotation", rotation)

    @property
    @pulumi.getter
    def crop(self) -> Optional['outputs.RectangleResponse']:
        """
        The parameters for the rectangular window with which to crop the input video.
        """
        return pulumi.get(self, "crop")

    @property
    @pulumi.getter
    def deinterlace(self) -> Optional['outputs.DeinterlaceResponse']:
        """
        The de-interlacing settings.
        """
        return pulumi.get(self, "deinterlace")

    @property
    @pulumi.getter
    def overlays(self) -> Optional[Sequence[Any]]:
        """
        The properties of overlays to be applied to the input video. These could be audio, image or video overlays.
        """
        return pulumi.get(self, "overlays")

    @property
    @pulumi.getter
    def rotation(self) -> Optional[str]:
        """
        The rotation, if any, to be applied to the input video, before it is encoded. Default is Auto
        """
        return pulumi.get(self, "rotation")


@pulumi.output_type
class H264LayerResponse(dict):
    """
    Describes the settings to be used when encoding the input video into a desired output bitrate layer with the H.264 video codec.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "adaptiveBFrame":
            suggest = "adaptive_b_frame"
        elif key == "bFrames":
            suggest = "b_frames"
        elif key == "bufferWindow":
            suggest = "buffer_window"
        elif key == "entropyMode":
            suggest = "entropy_mode"
        elif key == "frameRate":
            suggest = "frame_rate"
        elif key == "maxBitrate":
            suggest = "max_bitrate"
        elif key == "referenceFrames":
            suggest = "reference_frames"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in H264LayerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        H264LayerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        H264LayerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 adaptive_b_frame: Optional[bool] = None,
                 b_frames: Optional[int] = None,
                 bitrate: Optional[int] = None,
                 buffer_window: Optional[str] = None,
                 entropy_mode: Optional[str] = None,
                 frame_rate: Optional[str] = None,
                 height: Optional[str] = None,
                 label: Optional[str] = None,
                 level: Optional[str] = None,
                 max_bitrate: Optional[int] = None,
                 profile: Optional[str] = None,
                 reference_frames: Optional[int] = None,
                 slices: Optional[int] = None,
                 width: Optional[str] = None):
        """
        Describes the settings to be used when encoding the input video into a desired output bitrate layer with the H.264 video codec.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.H264Layer'.
        :param bool adaptive_b_frame: Whether or not adaptive B-frames are to be used when encoding this layer. If not specified, the encoder will turn it on whenever the video profile permits its use.
        :param int b_frames: The number of B-frames to be used when encoding this layer.  If not specified, the encoder chooses an appropriate number based on the video profile and level.
        :param int bitrate: The average bitrate in bits per second at which to encode the input video when generating this layer. This is a required field.
        :param str buffer_window: The VBV buffer window length. The value should be in ISO 8601 format. The value should be in the range [0.1-100] seconds. The default is 5 seconds (for example, PT5S).
        :param str entropy_mode: The entropy mode to be used for this layer. If not specified, the encoder chooses the mode that is appropriate for the profile and level.
        :param str frame_rate: The frame rate (in frames per second) at which to encode this layer. The value can be in the form of M/N where M and N are integers (For example, 30000/1001), or in the form of a number (For example, 30, or 29.97). The encoder enforces constraints on allowed frame rates based on the profile and level. If it is not specified, the encoder will use the same frame rate as the input video.
        :param str height: The height of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in height as the input.
        :param str label: The alphanumeric label for this layer, which can be used in multiplexing different video and audio layers, or in naming the output file.
        :param str level: Which level of the H.264 standard should be used when encoding this layer. The value can be Auto, or a number that matches the H.264 profile. If not specified, the default is Auto, which lets the encoder choose the Level that is appropriate for this layer.
        :param int max_bitrate: The maximum bitrate (in bits per second), at which the VBV buffer should be assumed to refill. If not specified, defaults to the same value as bitrate.
        :param str profile: Which profile of the H.264 standard should be used when encoding this layer. Default is Auto.
        :param int reference_frames: The number of reference frames to be used when encoding this layer. If not specified, the encoder determines an appropriate number based on the encoder complexity setting.
        :param int slices: The number of slices to be used when encoding this layer. If not specified, default is zero, which means that encoder will use a single slice for each frame.
        :param str width: The width of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in width as the input.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.H264Layer')
        if adaptive_b_frame is not None:
            pulumi.set(__self__, "adaptive_b_frame", adaptive_b_frame)
        if b_frames is not None:
            pulumi.set(__self__, "b_frames", b_frames)
        if bitrate is not None:
            pulumi.set(__self__, "bitrate", bitrate)
        if buffer_window is not None:
            pulumi.set(__self__, "buffer_window", buffer_window)
        if entropy_mode is not None:
            pulumi.set(__self__, "entropy_mode", entropy_mode)
        if frame_rate is not None:
            pulumi.set(__self__, "frame_rate", frame_rate)
        if height is not None:
            pulumi.set(__self__, "height", height)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if level is not None:
            pulumi.set(__self__, "level", level)
        if max_bitrate is not None:
            pulumi.set(__self__, "max_bitrate", max_bitrate)
        if profile is not None:
            pulumi.set(__self__, "profile", profile)
        if reference_frames is not None:
            pulumi.set(__self__, "reference_frames", reference_frames)
        if slices is not None:
            pulumi.set(__self__, "slices", slices)
        if width is not None:
            pulumi.set(__self__, "width", width)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.H264Layer'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="adaptiveBFrame")
    def adaptive_b_frame(self) -> Optional[bool]:
        """
        Whether or not adaptive B-frames are to be used when encoding this layer. If not specified, the encoder will turn it on whenever the video profile permits its use.
        """
        return pulumi.get(self, "adaptive_b_frame")

    @property
    @pulumi.getter(name="bFrames")
    def b_frames(self) -> Optional[int]:
        """
        The number of B-frames to be used when encoding this layer.  If not specified, the encoder chooses an appropriate number based on the video profile and level.
        """
        return pulumi.get(self, "b_frames")

    @property
    @pulumi.getter
    def bitrate(self) -> Optional[int]:
        """
        The average bitrate in bits per second at which to encode the input video when generating this layer. This is a required field.
        """
        return pulumi.get(self, "bitrate")

    @property
    @pulumi.getter(name="bufferWindow")
    def buffer_window(self) -> Optional[str]:
        """
        The VBV buffer window length. The value should be in ISO 8601 format. The value should be in the range [0.1-100] seconds. The default is 5 seconds (for example, PT5S).
        """
        return pulumi.get(self, "buffer_window")

    @property
    @pulumi.getter(name="entropyMode")
    def entropy_mode(self) -> Optional[str]:
        """
        The entropy mode to be used for this layer. If not specified, the encoder chooses the mode that is appropriate for the profile and level.
        """
        return pulumi.get(self, "entropy_mode")

    @property
    @pulumi.getter(name="frameRate")
    def frame_rate(self) -> Optional[str]:
        """
        The frame rate (in frames per second) at which to encode this layer. The value can be in the form of M/N where M and N are integers (For example, 30000/1001), or in the form of a number (For example, 30, or 29.97). The encoder enforces constraints on allowed frame rates based on the profile and level. If it is not specified, the encoder will use the same frame rate as the input video.
        """
        return pulumi.get(self, "frame_rate")

    @property
    @pulumi.getter
    def height(self) -> Optional[str]:
        """
        The height of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in height as the input.
        """
        return pulumi.get(self, "height")

    @property
    @pulumi.getter
    def label(self) -> Optional[str]:
        """
        The alphanumeric label for this layer, which can be used in multiplexing different video and audio layers, or in naming the output file.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def level(self) -> Optional[str]:
        """
        Which level of the H.264 standard should be used when encoding this layer. The value can be Auto, or a number that matches the H.264 profile. If not specified, the default is Auto, which lets the encoder choose the Level that is appropriate for this layer.
        """
        return pulumi.get(self, "level")

    @property
    @pulumi.getter(name="maxBitrate")
    def max_bitrate(self) -> Optional[int]:
        """
        The maximum bitrate (in bits per second), at which the VBV buffer should be assumed to refill. If not specified, defaults to the same value as bitrate.
        """
        return pulumi.get(self, "max_bitrate")

    @property
    @pulumi.getter
    def profile(self) -> Optional[str]:
        """
        Which profile of the H.264 standard should be used when encoding this layer. Default is Auto.
        """
        return pulumi.get(self, "profile")

    @property
    @pulumi.getter(name="referenceFrames")
    def reference_frames(self) -> Optional[int]:
        """
        The number of reference frames to be used when encoding this layer. If not specified, the encoder determines an appropriate number based on the encoder complexity setting.
        """
        return pulumi.get(self, "reference_frames")

    @property
    @pulumi.getter
    def slices(self) -> Optional[int]:
        """
        The number of slices to be used when encoding this layer. If not specified, default is zero, which means that encoder will use a single slice for each frame.
        """
        return pulumi.get(self, "slices")

    @property
    @pulumi.getter
    def width(self) -> Optional[str]:
        """
        The width of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in width as the input.
        """
        return pulumi.get(self, "width")


@pulumi.output_type
class H264VideoResponse(dict):
    """
    Describes all the properties for encoding a video with the H.264 codec.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "keyFrameInterval":
            suggest = "key_frame_interval"
        elif key == "sceneChangeDetection":
            suggest = "scene_change_detection"
        elif key == "stretchMode":
            suggest = "stretch_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in H264VideoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        H264VideoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        H264VideoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 complexity: Optional[str] = None,
                 key_frame_interval: Optional[str] = None,
                 label: Optional[str] = None,
                 layers: Optional[Sequence['outputs.H264LayerResponse']] = None,
                 scene_change_detection: Optional[bool] = None,
                 stretch_mode: Optional[str] = None):
        """
        Describes all the properties for encoding a video with the H.264 codec.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.H264Video'.
        :param str complexity: Tells the encoder how to choose its encoding settings. The default value is Balanced.
        :param str key_frame_interval: The distance between two key frames, thereby defining a group of pictures (GOP). The value should be a non-zero integer in the range [1, 30] seconds, specified in ISO 8601 format. The default is 2 seconds (PT2S).
        :param str label: An optional label for the codec. The label can be used to control muxing behavior.
        :param Sequence['H264LayerResponse'] layers: The collection of output H.264 layers to be produced by the encoder.
        :param bool scene_change_detection: Whether or not the encoder should insert key frames at scene changes. If not specified, the default is false. This flag should be set to true only when the encoder is being configured to produce a single output video.
        :param str stretch_mode: The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.H264Video')
        if complexity is not None:
            pulumi.set(__self__, "complexity", complexity)
        if key_frame_interval is not None:
            pulumi.set(__self__, "key_frame_interval", key_frame_interval)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if layers is not None:
            pulumi.set(__self__, "layers", layers)
        if scene_change_detection is not None:
            pulumi.set(__self__, "scene_change_detection", scene_change_detection)
        if stretch_mode is not None:
            pulumi.set(__self__, "stretch_mode", stretch_mode)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.H264Video'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter
    def complexity(self) -> Optional[str]:
        """
        Tells the encoder how to choose its encoding settings. The default value is Balanced.
        """
        return pulumi.get(self, "complexity")

    @property
    @pulumi.getter(name="keyFrameInterval")
    def key_frame_interval(self) -> Optional[str]:
        """
        The distance between two key frames, thereby defining a group of pictures (GOP). The value should be a non-zero integer in the range [1, 30] seconds, specified in ISO 8601 format. The default is 2 seconds (PT2S).
        """
        return pulumi.get(self, "key_frame_interval")

    @property
    @pulumi.getter
    def label(self) -> Optional[str]:
        """
        An optional label for the codec. The label can be used to control muxing behavior.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def layers(self) -> Optional[Sequence['outputs.H264LayerResponse']]:
        """
        The collection of output H.264 layers to be produced by the encoder.
        """
        return pulumi.get(self, "layers")

    @property
    @pulumi.getter(name="sceneChangeDetection")
    def scene_change_detection(self) -> Optional[bool]:
        """
        Whether or not the encoder should insert key frames at scene changes. If not specified, the default is false. This flag should be set to true only when the encoder is being configured to produce a single output video.
        """
        return pulumi.get(self, "scene_change_detection")

    @property
    @pulumi.getter(name="stretchMode")
    def stretch_mode(self) -> Optional[str]:
        """
        The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
        """
        return pulumi.get(self, "stretch_mode")


@pulumi.output_type
class HlsResponse(dict):
    """
    The HLS configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fragmentsPerTsSegment":
            suggest = "fragments_per_ts_segment"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HlsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HlsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HlsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fragments_per_ts_segment: Optional[int] = None):
        """
        The HLS configuration.
        :param int fragments_per_ts_segment: The amount of fragments per HTTP Live Streaming (HLS) segment.
        """
        if fragments_per_ts_segment is not None:
            pulumi.set(__self__, "fragments_per_ts_segment", fragments_per_ts_segment)

    @property
    @pulumi.getter(name="fragmentsPerTsSegment")
    def fragments_per_ts_segment(self) -> Optional[int]:
        """
        The amount of fragments per HTTP Live Streaming (HLS) segment.
        """
        return pulumi.get(self, "fragments_per_ts_segment")


@pulumi.output_type
class IPAccessControlResponse(dict):
    """
    The IP access control.
    """
    def __init__(__self__, *,
                 allow: Optional[Sequence['outputs.IPRangeResponse']] = None):
        """
        The IP access control.
        :param Sequence['IPRangeResponse'] allow: The IP allow list.
        """
        if allow is not None:
            pulumi.set(__self__, "allow", allow)

    @property
    @pulumi.getter
    def allow(self) -> Optional[Sequence['outputs.IPRangeResponse']]:
        """
        The IP allow list.
        """
        return pulumi.get(self, "allow")


@pulumi.output_type
class IPRangeResponse(dict):
    """
    The IP address range in the CIDR scheme.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subnetPrefixLength":
            suggest = "subnet_prefix_length"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IPRangeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IPRangeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IPRangeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: Optional[str] = None,
                 name: Optional[str] = None,
                 subnet_prefix_length: Optional[int] = None):
        """
        The IP address range in the CIDR scheme.
        :param str address: The IP address.
        :param str name: The friendly name for the IP address range.
        :param int subnet_prefix_length: The subnet mask prefix length (see CIDR notation).
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if subnet_prefix_length is not None:
            pulumi.set(__self__, "subnet_prefix_length", subnet_prefix_length)

    @property
    @pulumi.getter
    def address(self) -> Optional[str]:
        """
        The IP address.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The friendly name for the IP address range.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="subnetPrefixLength")
    def subnet_prefix_length(self) -> Optional[int]:
        """
        The subnet mask prefix length (see CIDR notation).
        """
        return pulumi.get(self, "subnet_prefix_length")


@pulumi.output_type
class ImageFormatResponse(dict):
    """
    Describes the properties for an output image file.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "filenamePattern":
            suggest = "filename_pattern"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageFormatResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageFormatResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageFormatResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 filename_pattern: Optional[str] = None):
        """
        Describes the properties for an output image file.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.ImageFormat'.
        :param str filename_pattern: The pattern of the file names for the generated output files. The following macros are supported in the file name: {Basename} - The base name of the input video {Extension} - The appropriate extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {Bitrate} - The audio/video bitrate. Not applicable to thumbnails. {Codec} - The type of the audio/video codec. Any unsubstituted macros will be collapsed and removed from the filename.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.ImageFormat')
        if filename_pattern is not None:
            pulumi.set(__self__, "filename_pattern", filename_pattern)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.ImageFormat'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="filenamePattern")
    def filename_pattern(self) -> Optional[str]:
        """
        The pattern of the file names for the generated output files. The following macros are supported in the file name: {Basename} - The base name of the input video {Extension} - The appropriate extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {Bitrate} - The audio/video bitrate. Not applicable to thumbnails. {Codec} - The type of the audio/video codec. Any unsubstituted macros will be collapsed and removed from the filename.
        """
        return pulumi.get(self, "filename_pattern")


@pulumi.output_type
class ImageResponse(dict):
    """
    Describes the basic properties for generating thumbnails from the input video
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "keyFrameInterval":
            suggest = "key_frame_interval"
        elif key == "stretchMode":
            suggest = "stretch_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 key_frame_interval: Optional[str] = None,
                 label: Optional[str] = None,
                 range: Optional[str] = None,
                 start: Optional[str] = None,
                 step: Optional[str] = None,
                 stretch_mode: Optional[str] = None):
        """
        Describes the basic properties for generating thumbnails from the input video
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.Image'.
        :param str key_frame_interval: The distance between two key frames, thereby defining a group of pictures (GOP). The value should be a non-zero integer in the range [1, 30] seconds, specified in ISO 8601 format. The default is 2 seconds (PT2S).
        :param str label: An optional label for the codec. The label can be used to control muxing behavior.
        :param str range: The position in the input video at which to stop generating thumbnails. The value can be in absolute timestamp (ISO 8601, e.g: PT5M30S to stop at 5 minutes and 30 seconds), or a frame count (For example, 300 to stop at the 300th frame), or a relative value (For example, 100%).
        :param str start: The position in the input video from where to start generating thumbnails. The value can be in absolute timestamp (ISO 8601, e.g: PT05S), or a frame count (For example, 10 for the 10th frame), or a relative value (For example, 1%). Also supports a macro {Best}, which tells the encoder to select the best thumbnail from the first few seconds of the video.
        :param str step: The intervals at which thumbnails are generated. The value can be in absolute timestamp (ISO 8601, e.g: PT05S for one image every 5 seconds), or a frame count (For example, 30 for every 30 frames), or a relative value (For example, 1%).
        :param str stretch_mode: The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.Image')
        if key_frame_interval is not None:
            pulumi.set(__self__, "key_frame_interval", key_frame_interval)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if range is not None:
            pulumi.set(__self__, "range", range)
        if start is not None:
            pulumi.set(__self__, "start", start)
        if step is not None:
            pulumi.set(__self__, "step", step)
        if stretch_mode is not None:
            pulumi.set(__self__, "stretch_mode", stretch_mode)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.Image'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="keyFrameInterval")
    def key_frame_interval(self) -> Optional[str]:
        """
        The distance between two key frames, thereby defining a group of pictures (GOP). The value should be a non-zero integer in the range [1, 30] seconds, specified in ISO 8601 format. The default is 2 seconds (PT2S).
        """
        return pulumi.get(self, "key_frame_interval")

    @property
    @pulumi.getter
    def label(self) -> Optional[str]:
        """
        An optional label for the codec. The label can be used to control muxing behavior.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def range(self) -> Optional[str]:
        """
        The position in the input video at which to stop generating thumbnails. The value can be in absolute timestamp (ISO 8601, e.g: PT5M30S to stop at 5 minutes and 30 seconds), or a frame count (For example, 300 to stop at the 300th frame), or a relative value (For example, 100%).
        """
        return pulumi.get(self, "range")

    @property
    @pulumi.getter
    def start(self) -> Optional[str]:
        """
        The position in the input video from where to start generating thumbnails. The value can be in absolute timestamp (ISO 8601, e.g: PT05S), or a frame count (For example, 10 for the 10th frame), or a relative value (For example, 1%). Also supports a macro {Best}, which tells the encoder to select the best thumbnail from the first few seconds of the video.
        """
        return pulumi.get(self, "start")

    @property
    @pulumi.getter
    def step(self) -> Optional[str]:
        """
        The intervals at which thumbnails are generated. The value can be in absolute timestamp (ISO 8601, e.g: PT05S for one image every 5 seconds), or a frame count (For example, 30 for every 30 frames), or a relative value (For example, 1%).
        """
        return pulumi.get(self, "step")

    @property
    @pulumi.getter(name="stretchMode")
    def stretch_mode(self) -> Optional[str]:
        """
        The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
        """
        return pulumi.get(self, "stretch_mode")


@pulumi.output_type
class JobErrorDetailResponse(dict):
    """
    Details of JobOutput errors.
    """
    def __init__(__self__, *,
                 code: str,
                 message: str):
        """
        Details of JobOutput errors.
        :param str code: Code describing the error detail.
        :param str message: A human-readable representation of the error.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        Code describing the error detail.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        A human-readable representation of the error.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class JobErrorResponse(dict):
    """
    Details of JobOutput errors.
    """
    def __init__(__self__, *,
                 category: str,
                 code: str,
                 details: Sequence['outputs.JobErrorDetailResponse'],
                 message: str,
                 retry: str):
        """
        Details of JobOutput errors.
        :param str category: Helps with categorization of errors.
        :param str code: Error code describing the error.
        :param Sequence['JobErrorDetailResponse'] details: An array of details about specific errors that led to this reported error.
        :param str message: A human-readable language-dependent representation of the error.
        :param str retry: Indicates that it may be possible to retry the Job. If retry is unsuccessful, please contact Azure support via Azure Portal.
        """
        pulumi.set(__self__, "category", category)
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "details", details)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "retry", retry)

    @property
    @pulumi.getter
    def category(self) -> str:
        """
        Helps with categorization of errors.
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        Error code describing the error.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def details(self) -> Sequence['outputs.JobErrorDetailResponse']:
        """
        An array of details about specific errors that led to this reported error.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        A human-readable language-dependent representation of the error.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def retry(self) -> str:
        """
        Indicates that it may be possible to retry the Job. If retry is unsuccessful, please contact Azure support via Azure Portal.
        """
        return pulumi.get(self, "retry")


@pulumi.output_type
class JobInputAssetResponse(dict):
    """
    Represents an Asset for input into a Job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "assetName":
            suggest = "asset_name"
        elif key == "odataType":
            suggest = "odata_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobInputAssetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobInputAssetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobInputAssetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 asset_name: str,
                 odata_type: str,
                 files: Optional[Sequence[str]] = None,
                 label: Optional[str] = None):
        """
        Represents an Asset for input into a Job.
        :param str asset_name: The name of the input Asset.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.JobInputAsset'.
        :param Sequence[str] files: List of files. Required for JobInputHttp.
        :param str label: A label that is assigned to a JobInput, that is used to satisfy a reference used in the Transform. For example, a Transform can be authored so as to take an image file with the label 'xyz' and apply it as an overlay onto the input video before it is encoded. When submitting a Job, exactly one of the JobInputs should be the image file, and it should have the label 'xyz'.
        """
        pulumi.set(__self__, "asset_name", asset_name)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.JobInputAsset')
        if files is not None:
            pulumi.set(__self__, "files", files)
        if label is not None:
            pulumi.set(__self__, "label", label)

    @property
    @pulumi.getter(name="assetName")
    def asset_name(self) -> str:
        """
        The name of the input Asset.
        """
        return pulumi.get(self, "asset_name")

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.JobInputAsset'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter
    def files(self) -> Optional[Sequence[str]]:
        """
        List of files. Required for JobInputHttp.
        """
        return pulumi.get(self, "files")

    @property
    @pulumi.getter
    def label(self) -> Optional[str]:
        """
        A label that is assigned to a JobInput, that is used to satisfy a reference used in the Transform. For example, a Transform can be authored so as to take an image file with the label 'xyz' and apply it as an overlay onto the input video before it is encoded. When submitting a Job, exactly one of the JobInputs should be the image file, and it should have the label 'xyz'.
        """
        return pulumi.get(self, "label")


@pulumi.output_type
class JobInputClipResponse(dict):
    """
    Represents input files for a Job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobInputClipResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobInputClipResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobInputClipResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 files: Optional[Sequence[str]] = None,
                 label: Optional[str] = None):
        """
        Represents input files for a Job.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.JobInputClip'.
        :param Sequence[str] files: List of files. Required for JobInputHttp.
        :param str label: A label that is assigned to a JobInput, that is used to satisfy a reference used in the Transform. For example, a Transform can be authored so as to take an image file with the label 'xyz' and apply it as an overlay onto the input video before it is encoded. When submitting a Job, exactly one of the JobInputs should be the image file, and it should have the label 'xyz'.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.JobInputClip')
        if files is not None:
            pulumi.set(__self__, "files", files)
        if label is not None:
            pulumi.set(__self__, "label", label)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.JobInputClip'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter
    def files(self) -> Optional[Sequence[str]]:
        """
        List of files. Required for JobInputHttp.
        """
        return pulumi.get(self, "files")

    @property
    @pulumi.getter
    def label(self) -> Optional[str]:
        """
        A label that is assigned to a JobInput, that is used to satisfy a reference used in the Transform. For example, a Transform can be authored so as to take an image file with the label 'xyz' and apply it as an overlay onto the input video before it is encoded. When submitting a Job, exactly one of the JobInputs should be the image file, and it should have the label 'xyz'.
        """
        return pulumi.get(self, "label")


@pulumi.output_type
class JobInputHttpResponse(dict):
    """
    Represents HTTPS job input.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "baseUri":
            suggest = "base_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobInputHttpResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobInputHttpResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobInputHttpResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 base_uri: Optional[str] = None,
                 files: Optional[Sequence[str]] = None,
                 label: Optional[str] = None):
        """
        Represents HTTPS job input.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.JobInputHttp'.
        :param str base_uri: Base URI for HTTPS job input. It will be concatenated with provided file names.   If no base uri is given, then the provided file list is assumed to be fully qualified uris.
        :param Sequence[str] files: List of files. Required for JobInputHttp.
        :param str label: A label that is assigned to a JobInput, that is used to satisfy a reference used in the Transform. For example, a Transform can be authored so as to take an image file with the label 'xyz' and apply it as an overlay onto the input video before it is encoded. When submitting a Job, exactly one of the JobInputs should be the image file, and it should have the label 'xyz'.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.JobInputHttp')
        if base_uri is not None:
            pulumi.set(__self__, "base_uri", base_uri)
        if files is not None:
            pulumi.set(__self__, "files", files)
        if label is not None:
            pulumi.set(__self__, "label", label)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.JobInputHttp'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="baseUri")
    def base_uri(self) -> Optional[str]:
        """
        Base URI for HTTPS job input. It will be concatenated with provided file names.   If no base uri is given, then the provided file list is assumed to be fully qualified uris.
        """
        return pulumi.get(self, "base_uri")

    @property
    @pulumi.getter
    def files(self) -> Optional[Sequence[str]]:
        """
        List of files. Required for JobInputHttp.
        """
        return pulumi.get(self, "files")

    @property
    @pulumi.getter
    def label(self) -> Optional[str]:
        """
        A label that is assigned to a JobInput, that is used to satisfy a reference used in the Transform. For example, a Transform can be authored so as to take an image file with the label 'xyz' and apply it as an overlay onto the input video before it is encoded. When submitting a Job, exactly one of the JobInputs should be the image file, and it should have the label 'xyz'.
        """
        return pulumi.get(self, "label")


@pulumi.output_type
class JobInputsResponse(dict):
    """
    Describes a list of inputs to a Job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobInputsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobInputsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobInputsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 inputs: Optional[Sequence[Any]] = None,
                 label: Optional[str] = None):
        """
        Describes a list of inputs to a Job.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.JobInputs'.
        :param Sequence[Union['JobInputAssetResponse', 'JobInputClipResponse', 'JobInputHttpResponse', 'JobInputsResponse']] inputs: List of inputs to a Job.
        :param str label: A label that is assigned to a JobInput, that is used to satisfy a reference used in the Transform. For example, a Transform can be authored so as to take an image file with the label 'xyz' and apply it as an overlay onto the input video before it is encoded. When submitting a Job, exactly one of the JobInputs should be the image file, and it should have the label 'xyz'.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.JobInputs')
        if inputs is not None:
            pulumi.set(__self__, "inputs", inputs)
        if label is not None:
            pulumi.set(__self__, "label", label)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.JobInputs'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter
    def inputs(self) -> Optional[Sequence[Any]]:
        """
        List of inputs to a Job.
        """
        return pulumi.get(self, "inputs")

    @property
    @pulumi.getter
    def label(self) -> Optional[str]:
        """
        A label that is assigned to a JobInput, that is used to satisfy a reference used in the Transform. For example, a Transform can be authored so as to take an image file with the label 'xyz' and apply it as an overlay onto the input video before it is encoded. When submitting a Job, exactly one of the JobInputs should be the image file, and it should have the label 'xyz'.
        """
        return pulumi.get(self, "label")


@pulumi.output_type
class JobOutputAssetResponse(dict):
    """
    Represents an Asset used as a JobOutput.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "assetName":
            suggest = "asset_name"
        elif key == "odataType":
            suggest = "odata_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobOutputAssetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobOutputAssetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobOutputAssetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 asset_name: str,
                 error: 'outputs.JobErrorResponse',
                 odata_type: str,
                 progress: int,
                 state: str):
        """
        Represents an Asset used as a JobOutput.
        :param str asset_name: The name of the output Asset.
        :param 'JobErrorResponse' error: If the JobOutput is in the Error state, it contains the details of the error.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.JobOutputAsset'.
        :param int progress: If the JobOutput is in a Processing state, this contains the job completion percentage.  The value is an estimate and not intended to be used to predict job completion times. To determine if the JobOutput is complete, use the State property.
        :param str state: Describes the state of the JobOutput.
        """
        pulumi.set(__self__, "asset_name", asset_name)
        pulumi.set(__self__, "error", error)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.JobOutputAsset')
        pulumi.set(__self__, "progress", progress)
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="assetName")
    def asset_name(self) -> str:
        """
        The name of the output Asset.
        """
        return pulumi.get(self, "asset_name")

    @property
    @pulumi.getter
    def error(self) -> 'outputs.JobErrorResponse':
        """
        If the JobOutput is in the Error state, it contains the details of the error.
        """
        return pulumi.get(self, "error")

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.JobOutputAsset'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter
    def progress(self) -> int:
        """
        If the JobOutput is in a Processing state, this contains the job completion percentage.  The value is an estimate and not intended to be used to predict job completion times. To determine if the JobOutput is complete, use the State property.
        """
        return pulumi.get(self, "progress")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Describes the state of the JobOutput.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class JpgFormatResponse(dict):
    """
    Describes the settings for producing JPEG thumbnails.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "filenamePattern":
            suggest = "filename_pattern"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JpgFormatResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JpgFormatResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JpgFormatResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 filename_pattern: Optional[str] = None):
        """
        Describes the settings for producing JPEG thumbnails.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.JpgFormat'.
        :param str filename_pattern: The pattern of the file names for the generated output files. The following macros are supported in the file name: {Basename} - The base name of the input video {Extension} - The appropriate extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {Bitrate} - The audio/video bitrate. Not applicable to thumbnails. {Codec} - The type of the audio/video codec. Any unsubstituted macros will be collapsed and removed from the filename.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.JpgFormat')
        if filename_pattern is not None:
            pulumi.set(__self__, "filename_pattern", filename_pattern)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.JpgFormat'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="filenamePattern")
    def filename_pattern(self) -> Optional[str]:
        """
        The pattern of the file names for the generated output files. The following macros are supported in the file name: {Basename} - The base name of the input video {Extension} - The appropriate extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {Bitrate} - The audio/video bitrate. Not applicable to thumbnails. {Codec} - The type of the audio/video codec. Any unsubstituted macros will be collapsed and removed from the filename.
        """
        return pulumi.get(self, "filename_pattern")


@pulumi.output_type
class JpgImageResponse(dict):
    """
    Describes the properties for producing a series of JPEG images from the input video.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "keyFrameInterval":
            suggest = "key_frame_interval"
        elif key == "stretchMode":
            suggest = "stretch_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JpgImageResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JpgImageResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JpgImageResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 key_frame_interval: Optional[str] = None,
                 label: Optional[str] = None,
                 layers: Optional[Sequence['outputs.JpgLayerResponse']] = None,
                 range: Optional[str] = None,
                 start: Optional[str] = None,
                 step: Optional[str] = None,
                 stretch_mode: Optional[str] = None):
        """
        Describes the properties for producing a series of JPEG images from the input video.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.JpgImage'.
        :param str key_frame_interval: The distance between two key frames, thereby defining a group of pictures (GOP). The value should be a non-zero integer in the range [1, 30] seconds, specified in ISO 8601 format. The default is 2 seconds (PT2S).
        :param str label: An optional label for the codec. The label can be used to control muxing behavior.
        :param Sequence['JpgLayerResponse'] layers: A collection of output JPEG image layers to be produced by the encoder.
        :param str range: The position in the input video at which to stop generating thumbnails. The value can be in absolute timestamp (ISO 8601, e.g: PT5M30S to stop at 5 minutes and 30 seconds), or a frame count (For example, 300 to stop at the 300th frame), or a relative value (For example, 100%).
        :param str start: The position in the input video from where to start generating thumbnails. The value can be in absolute timestamp (ISO 8601, e.g: PT05S), or a frame count (For example, 10 for the 10th frame), or a relative value (For example, 1%). Also supports a macro {Best}, which tells the encoder to select the best thumbnail from the first few seconds of the video.
        :param str step: The intervals at which thumbnails are generated. The value can be in absolute timestamp (ISO 8601, e.g: PT05S for one image every 5 seconds), or a frame count (For example, 30 for every 30 frames), or a relative value (For example, 1%).
        :param str stretch_mode: The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.JpgImage')
        if key_frame_interval is not None:
            pulumi.set(__self__, "key_frame_interval", key_frame_interval)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if layers is not None:
            pulumi.set(__self__, "layers", layers)
        if range is not None:
            pulumi.set(__self__, "range", range)
        if start is not None:
            pulumi.set(__self__, "start", start)
        if step is not None:
            pulumi.set(__self__, "step", step)
        if stretch_mode is not None:
            pulumi.set(__self__, "stretch_mode", stretch_mode)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.JpgImage'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="keyFrameInterval")
    def key_frame_interval(self) -> Optional[str]:
        """
        The distance between two key frames, thereby defining a group of pictures (GOP). The value should be a non-zero integer in the range [1, 30] seconds, specified in ISO 8601 format. The default is 2 seconds (PT2S).
        """
        return pulumi.get(self, "key_frame_interval")

    @property
    @pulumi.getter
    def label(self) -> Optional[str]:
        """
        An optional label for the codec. The label can be used to control muxing behavior.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def layers(self) -> Optional[Sequence['outputs.JpgLayerResponse']]:
        """
        A collection of output JPEG image layers to be produced by the encoder.
        """
        return pulumi.get(self, "layers")

    @property
    @pulumi.getter
    def range(self) -> Optional[str]:
        """
        The position in the input video at which to stop generating thumbnails. The value can be in absolute timestamp (ISO 8601, e.g: PT5M30S to stop at 5 minutes and 30 seconds), or a frame count (For example, 300 to stop at the 300th frame), or a relative value (For example, 100%).
        """
        return pulumi.get(self, "range")

    @property
    @pulumi.getter
    def start(self) -> Optional[str]:
        """
        The position in the input video from where to start generating thumbnails. The value can be in absolute timestamp (ISO 8601, e.g: PT05S), or a frame count (For example, 10 for the 10th frame), or a relative value (For example, 1%). Also supports a macro {Best}, which tells the encoder to select the best thumbnail from the first few seconds of the video.
        """
        return pulumi.get(self, "start")

    @property
    @pulumi.getter
    def step(self) -> Optional[str]:
        """
        The intervals at which thumbnails are generated. The value can be in absolute timestamp (ISO 8601, e.g: PT05S for one image every 5 seconds), or a frame count (For example, 30 for every 30 frames), or a relative value (For example, 1%).
        """
        return pulumi.get(self, "step")

    @property
    @pulumi.getter(name="stretchMode")
    def stretch_mode(self) -> Optional[str]:
        """
        The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
        """
        return pulumi.get(self, "stretch_mode")


@pulumi.output_type
class JpgLayerResponse(dict):
    """
    Describes the settings to produce a JPEG image from the input video.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JpgLayerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JpgLayerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JpgLayerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 height: Optional[str] = None,
                 label: Optional[str] = None,
                 quality: Optional[int] = None,
                 width: Optional[str] = None):
        """
        Describes the settings to produce a JPEG image from the input video.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.JpgLayer'.
        :param str height: The height of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in height as the input.
        :param str label: The alphanumeric label for this layer, which can be used in multiplexing different video and audio layers, or in naming the output file.
        :param int quality: The compression quality of the JPEG output. Range is from 0-100 and the default is 70.
        :param str width: The width of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in width as the input.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.JpgLayer')
        if height is not None:
            pulumi.set(__self__, "height", height)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if quality is not None:
            pulumi.set(__self__, "quality", quality)
        if width is not None:
            pulumi.set(__self__, "width", width)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.JpgLayer'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter
    def height(self) -> Optional[str]:
        """
        The height of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in height as the input.
        """
        return pulumi.get(self, "height")

    @property
    @pulumi.getter
    def label(self) -> Optional[str]:
        """
        The alphanumeric label for this layer, which can be used in multiplexing different video and audio layers, or in naming the output file.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def quality(self) -> Optional[int]:
        """
        The compression quality of the JPEG output. Range is from 0-100 and the default is 70.
        """
        return pulumi.get(self, "quality")

    @property
    @pulumi.getter
    def width(self) -> Optional[str]:
        """
        The width of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in width as the input.
        """
        return pulumi.get(self, "width")


@pulumi.output_type
class LiveEventEncodingResponse(dict):
    """
    The Live Event encoding.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encodingType":
            suggest = "encoding_type"
        elif key == "presetName":
            suggest = "preset_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LiveEventEncodingResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LiveEventEncodingResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LiveEventEncodingResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 encoding_type: Optional[str] = None,
                 preset_name: Optional[str] = None):
        """
        The Live Event encoding.
        :param str encoding_type: The encoding type for Live Event.
        :param str preset_name: The encoding preset name.
        """
        if encoding_type is not None:
            pulumi.set(__self__, "encoding_type", encoding_type)
        if preset_name is not None:
            pulumi.set(__self__, "preset_name", preset_name)

    @property
    @pulumi.getter(name="encodingType")
    def encoding_type(self) -> Optional[str]:
        """
        The encoding type for Live Event.
        """
        return pulumi.get(self, "encoding_type")

    @property
    @pulumi.getter(name="presetName")
    def preset_name(self) -> Optional[str]:
        """
        The encoding preset name.
        """
        return pulumi.get(self, "preset_name")


@pulumi.output_type
class LiveEventEndpointResponse(dict):
    """
    The Live Event endpoint.
    """
    def __init__(__self__, *,
                 protocol: Optional[str] = None,
                 url: Optional[str] = None):
        """
        The Live Event endpoint.
        :param str protocol: The endpoint protocol.
        :param str url: The endpoint URL.
        """
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        """
        The endpoint protocol.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter
    def url(self) -> Optional[str]:
        """
        The endpoint URL.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class LiveEventInputResponse(dict):
    """
    The Live Event input.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "streamingProtocol":
            suggest = "streaming_protocol"
        elif key == "accessToken":
            suggest = "access_token"
        elif key == "keyFrameIntervalDuration":
            suggest = "key_frame_interval_duration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LiveEventInputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LiveEventInputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LiveEventInputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 streaming_protocol: str,
                 access_token: Optional[str] = None,
                 endpoints: Optional[Sequence['outputs.LiveEventEndpointResponse']] = None,
                 key_frame_interval_duration: Optional[str] = None):
        """
        The Live Event input.
        :param str streaming_protocol: The streaming protocol for the Live Event.
        :param str access_token: The access token.
        :param Sequence['LiveEventEndpointResponse'] endpoints: The input endpoints for the Live Event.
        :param str key_frame_interval_duration: ISO 8601 timespan duration of the key frame interval duration.
        """
        pulumi.set(__self__, "streaming_protocol", streaming_protocol)
        if access_token is not None:
            pulumi.set(__self__, "access_token", access_token)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if key_frame_interval_duration is not None:
            pulumi.set(__self__, "key_frame_interval_duration", key_frame_interval_duration)

    @property
    @pulumi.getter(name="streamingProtocol")
    def streaming_protocol(self) -> str:
        """
        The streaming protocol for the Live Event.
        """
        return pulumi.get(self, "streaming_protocol")

    @property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> Optional[str]:
        """
        The access token.
        """
        return pulumi.get(self, "access_token")

    @property
    @pulumi.getter
    def endpoints(self) -> Optional[Sequence['outputs.LiveEventEndpointResponse']]:
        """
        The input endpoints for the Live Event.
        """
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter(name="keyFrameIntervalDuration")
    def key_frame_interval_duration(self) -> Optional[str]:
        """
        ISO 8601 timespan duration of the key frame interval duration.
        """
        return pulumi.get(self, "key_frame_interval_duration")


@pulumi.output_type
class LiveEventPreviewAccessControlResponse(dict):
    """
    The IP access control for Live Event preview.
    """
    def __init__(__self__, *,
                 ip: Optional['outputs.IPAccessControlResponse'] = None):
        """
        The IP access control for Live Event preview.
        :param 'IPAccessControlResponse' ip: The IP access control properties.
        """
        if ip is not None:
            pulumi.set(__self__, "ip", ip)

    @property
    @pulumi.getter
    def ip(self) -> Optional['outputs.IPAccessControlResponse']:
        """
        The IP access control properties.
        """
        return pulumi.get(self, "ip")


@pulumi.output_type
class LiveEventPreviewResponse(dict):
    """
    The Live Event preview.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessControl":
            suggest = "access_control"
        elif key == "alternativeMediaId":
            suggest = "alternative_media_id"
        elif key == "previewLocator":
            suggest = "preview_locator"
        elif key == "streamingPolicyName":
            suggest = "streaming_policy_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LiveEventPreviewResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LiveEventPreviewResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LiveEventPreviewResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_control: Optional['outputs.LiveEventPreviewAccessControlResponse'] = None,
                 alternative_media_id: Optional[str] = None,
                 endpoints: Optional[Sequence['outputs.LiveEventEndpointResponse']] = None,
                 preview_locator: Optional[str] = None,
                 streaming_policy_name: Optional[str] = None):
        """
        The Live Event preview.
        :param 'LiveEventPreviewAccessControlResponse' access_control: The access control for LiveEvent preview.
        :param str alternative_media_id: An Alternative Media Identifier associated with the preview url.  This identifier can be used to distinguish the preview of different live events for authorization purposes in the CustomLicenseAcquisitionUrlTemplate or the CustomKeyAcquisitionUrlTemplate of the StreamingPolicy specified in the StreamingPolicyName field.
        :param Sequence['LiveEventEndpointResponse'] endpoints: The endpoints for preview.
        :param str preview_locator: The preview locator Guid.
        :param str streaming_policy_name: The name of streaming policy used for LiveEvent preview
        """
        if access_control is not None:
            pulumi.set(__self__, "access_control", access_control)
        if alternative_media_id is not None:
            pulumi.set(__self__, "alternative_media_id", alternative_media_id)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if preview_locator is not None:
            pulumi.set(__self__, "preview_locator", preview_locator)
        if streaming_policy_name is not None:
            pulumi.set(__self__, "streaming_policy_name", streaming_policy_name)

    @property
    @pulumi.getter(name="accessControl")
    def access_control(self) -> Optional['outputs.LiveEventPreviewAccessControlResponse']:
        """
        The access control for LiveEvent preview.
        """
        return pulumi.get(self, "access_control")

    @property
    @pulumi.getter(name="alternativeMediaId")
    def alternative_media_id(self) -> Optional[str]:
        """
        An Alternative Media Identifier associated with the preview url.  This identifier can be used to distinguish the preview of different live events for authorization purposes in the CustomLicenseAcquisitionUrlTemplate or the CustomKeyAcquisitionUrlTemplate of the StreamingPolicy specified in the StreamingPolicyName field.
        """
        return pulumi.get(self, "alternative_media_id")

    @property
    @pulumi.getter
    def endpoints(self) -> Optional[Sequence['outputs.LiveEventEndpointResponse']]:
        """
        The endpoints for preview.
        """
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter(name="previewLocator")
    def preview_locator(self) -> Optional[str]:
        """
        The preview locator Guid.
        """
        return pulumi.get(self, "preview_locator")

    @property
    @pulumi.getter(name="streamingPolicyName")
    def streaming_policy_name(self) -> Optional[str]:
        """
        The name of streaming policy used for LiveEvent preview
        """
        return pulumi.get(self, "streaming_policy_name")


@pulumi.output_type
class Mp4FormatResponse(dict):
    """
    Describes the properties for an output ISO MP4 file.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "filenamePattern":
            suggest = "filename_pattern"
        elif key == "outputFiles":
            suggest = "output_files"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Mp4FormatResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Mp4FormatResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Mp4FormatResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 filename_pattern: Optional[str] = None,
                 output_files: Optional[Sequence['outputs.OutputFileResponse']] = None):
        """
        Describes the properties for an output ISO MP4 file.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.Mp4Format'.
        :param str filename_pattern: The pattern of the file names for the generated output files. The following macros are supported in the file name: {Basename} - The base name of the input video {Extension} - The appropriate extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {Bitrate} - The audio/video bitrate. Not applicable to thumbnails. {Codec} - The type of the audio/video codec. Any unsubstituted macros will be collapsed and removed from the filename.
        :param Sequence['OutputFileResponse'] output_files: The list of output files to produce.  Each entry in the list is a set of audio and video layer labels to be muxed together .
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.Mp4Format')
        if filename_pattern is not None:
            pulumi.set(__self__, "filename_pattern", filename_pattern)
        if output_files is not None:
            pulumi.set(__self__, "output_files", output_files)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.Mp4Format'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="filenamePattern")
    def filename_pattern(self) -> Optional[str]:
        """
        The pattern of the file names for the generated output files. The following macros are supported in the file name: {Basename} - The base name of the input video {Extension} - The appropriate extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {Bitrate} - The audio/video bitrate. Not applicable to thumbnails. {Codec} - The type of the audio/video codec. Any unsubstituted macros will be collapsed and removed from the filename.
        """
        return pulumi.get(self, "filename_pattern")

    @property
    @pulumi.getter(name="outputFiles")
    def output_files(self) -> Optional[Sequence['outputs.OutputFileResponse']]:
        """
        The list of output files to produce.  Each entry in the list is a set of audio and video layer labels to be muxed together .
        """
        return pulumi.get(self, "output_files")


@pulumi.output_type
class MultiBitrateFormatResponse(dict):
    """
    Describes the properties for producing a collection of GOP aligned multi-bitrate files. The default behavior is to produce one output file for each video layer which is muxed together with all the audios. The exact output files produced can be controlled by specifying the outputFiles collection.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "filenamePattern":
            suggest = "filename_pattern"
        elif key == "outputFiles":
            suggest = "output_files"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MultiBitrateFormatResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MultiBitrateFormatResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MultiBitrateFormatResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 filename_pattern: Optional[str] = None,
                 output_files: Optional[Sequence['outputs.OutputFileResponse']] = None):
        """
        Describes the properties for producing a collection of GOP aligned multi-bitrate files. The default behavior is to produce one output file for each video layer which is muxed together with all the audios. The exact output files produced can be controlled by specifying the outputFiles collection.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.MultiBitrateFormat'.
        :param str filename_pattern: The pattern of the file names for the generated output files. The following macros are supported in the file name: {Basename} - The base name of the input video {Extension} - The appropriate extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {Bitrate} - The audio/video bitrate. Not applicable to thumbnails. {Codec} - The type of the audio/video codec. Any unsubstituted macros will be collapsed and removed from the filename.
        :param Sequence['OutputFileResponse'] output_files: The list of output files to produce.  Each entry in the list is a set of audio and video layer labels to be muxed together .
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.MultiBitrateFormat')
        if filename_pattern is not None:
            pulumi.set(__self__, "filename_pattern", filename_pattern)
        if output_files is not None:
            pulumi.set(__self__, "output_files", output_files)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.MultiBitrateFormat'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="filenamePattern")
    def filename_pattern(self) -> Optional[str]:
        """
        The pattern of the file names for the generated output files. The following macros are supported in the file name: {Basename} - The base name of the input video {Extension} - The appropriate extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {Bitrate} - The audio/video bitrate. Not applicable to thumbnails. {Codec} - The type of the audio/video codec. Any unsubstituted macros will be collapsed and removed from the filename.
        """
        return pulumi.get(self, "filename_pattern")

    @property
    @pulumi.getter(name="outputFiles")
    def output_files(self) -> Optional[Sequence['outputs.OutputFileResponse']]:
        """
        The list of output files to produce.  Each entry in the list is a set of audio and video layer labels to be muxed together .
        """
        return pulumi.get(self, "output_files")


@pulumi.output_type
class NoEncryptionResponse(dict):
    """
    Class for NoEncryption scheme
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enabledProtocols":
            suggest = "enabled_protocols"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NoEncryptionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NoEncryptionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NoEncryptionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled_protocols: Optional['outputs.EnabledProtocolsResponse'] = None):
        """
        Class for NoEncryption scheme
        :param 'EnabledProtocolsResponse' enabled_protocols: Representing supported protocols
        """
        if enabled_protocols is not None:
            pulumi.set(__self__, "enabled_protocols", enabled_protocols)

    @property
    @pulumi.getter(name="enabledProtocols")
    def enabled_protocols(self) -> Optional['outputs.EnabledProtocolsResponse']:
        """
        Representing supported protocols
        """
        return pulumi.get(self, "enabled_protocols")


@pulumi.output_type
class OutputFileResponse(dict):
    """
    Represents an output file produced.
    """
    def __init__(__self__, *,
                 labels: Optional[Sequence[str]] = None):
        """
        Represents an output file produced.
        :param Sequence[str] labels: The list of labels that describe how the encoder should multiplex video and audio into an output file. For example, if the encoder is producing two video layers with labels v1 and v2, and one audio layer with label a1, then an array like '[v1, a1]' tells the encoder to produce an output file with the video track represented by v1 and the audio track represented by a1.
        """
        if labels is not None:
            pulumi.set(__self__, "labels", labels)

    @property
    @pulumi.getter
    def labels(self) -> Optional[Sequence[str]]:
        """
        The list of labels that describe how the encoder should multiplex video and audio into an output file. For example, if the encoder is producing two video layers with labels v1 and v2, and one audio layer with label a1, then an array like '[v1, a1]' tells the encoder to produce an output file with the video track represented by v1 and the audio track represented by a1.
        """
        return pulumi.get(self, "labels")


@pulumi.output_type
class PngFormatResponse(dict):
    """
    Describes the settings for producing PNG thumbnails.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "filenamePattern":
            suggest = "filename_pattern"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PngFormatResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PngFormatResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PngFormatResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 filename_pattern: Optional[str] = None):
        """
        Describes the settings for producing PNG thumbnails.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.PngFormat'.
        :param str filename_pattern: The pattern of the file names for the generated output files. The following macros are supported in the file name: {Basename} - The base name of the input video {Extension} - The appropriate extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {Bitrate} - The audio/video bitrate. Not applicable to thumbnails. {Codec} - The type of the audio/video codec. Any unsubstituted macros will be collapsed and removed from the filename.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.PngFormat')
        if filename_pattern is not None:
            pulumi.set(__self__, "filename_pattern", filename_pattern)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.PngFormat'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="filenamePattern")
    def filename_pattern(self) -> Optional[str]:
        """
        The pattern of the file names for the generated output files. The following macros are supported in the file name: {Basename} - The base name of the input video {Extension} - The appropriate extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {Bitrate} - The audio/video bitrate. Not applicable to thumbnails. {Codec} - The type of the audio/video codec. Any unsubstituted macros will be collapsed and removed from the filename.
        """
        return pulumi.get(self, "filename_pattern")


@pulumi.output_type
class PngImageResponse(dict):
    """
    Describes the properties for producing a series of PNG images from the input video.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "keyFrameInterval":
            suggest = "key_frame_interval"
        elif key == "stretchMode":
            suggest = "stretch_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PngImageResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PngImageResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PngImageResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 key_frame_interval: Optional[str] = None,
                 label: Optional[str] = None,
                 layers: Optional[Sequence['outputs.PngLayerResponse']] = None,
                 range: Optional[str] = None,
                 start: Optional[str] = None,
                 step: Optional[str] = None,
                 stretch_mode: Optional[str] = None):
        """
        Describes the properties for producing a series of PNG images from the input video.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.PngImage'.
        :param str key_frame_interval: The distance between two key frames, thereby defining a group of pictures (GOP). The value should be a non-zero integer in the range [1, 30] seconds, specified in ISO 8601 format. The default is 2 seconds (PT2S).
        :param str label: An optional label for the codec. The label can be used to control muxing behavior.
        :param Sequence['PngLayerResponse'] layers: A collection of output PNG image layers to be produced by the encoder.
        :param str range: The position in the input video at which to stop generating thumbnails. The value can be in absolute timestamp (ISO 8601, e.g: PT5M30S to stop at 5 minutes and 30 seconds), or a frame count (For example, 300 to stop at the 300th frame), or a relative value (For example, 100%).
        :param str start: The position in the input video from where to start generating thumbnails. The value can be in absolute timestamp (ISO 8601, e.g: PT05S), or a frame count (For example, 10 for the 10th frame), or a relative value (For example, 1%). Also supports a macro {Best}, which tells the encoder to select the best thumbnail from the first few seconds of the video.
        :param str step: The intervals at which thumbnails are generated. The value can be in absolute timestamp (ISO 8601, e.g: PT05S for one image every 5 seconds), or a frame count (For example, 30 for every 30 frames), or a relative value (For example, 1%).
        :param str stretch_mode: The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.PngImage')
        if key_frame_interval is not None:
            pulumi.set(__self__, "key_frame_interval", key_frame_interval)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if layers is not None:
            pulumi.set(__self__, "layers", layers)
        if range is not None:
            pulumi.set(__self__, "range", range)
        if start is not None:
            pulumi.set(__self__, "start", start)
        if step is not None:
            pulumi.set(__self__, "step", step)
        if stretch_mode is not None:
            pulumi.set(__self__, "stretch_mode", stretch_mode)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.PngImage'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="keyFrameInterval")
    def key_frame_interval(self) -> Optional[str]:
        """
        The distance between two key frames, thereby defining a group of pictures (GOP). The value should be a non-zero integer in the range [1, 30] seconds, specified in ISO 8601 format. The default is 2 seconds (PT2S).
        """
        return pulumi.get(self, "key_frame_interval")

    @property
    @pulumi.getter
    def label(self) -> Optional[str]:
        """
        An optional label for the codec. The label can be used to control muxing behavior.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def layers(self) -> Optional[Sequence['outputs.PngLayerResponse']]:
        """
        A collection of output PNG image layers to be produced by the encoder.
        """
        return pulumi.get(self, "layers")

    @property
    @pulumi.getter
    def range(self) -> Optional[str]:
        """
        The position in the input video at which to stop generating thumbnails. The value can be in absolute timestamp (ISO 8601, e.g: PT5M30S to stop at 5 minutes and 30 seconds), or a frame count (For example, 300 to stop at the 300th frame), or a relative value (For example, 100%).
        """
        return pulumi.get(self, "range")

    @property
    @pulumi.getter
    def start(self) -> Optional[str]:
        """
        The position in the input video from where to start generating thumbnails. The value can be in absolute timestamp (ISO 8601, e.g: PT05S), or a frame count (For example, 10 for the 10th frame), or a relative value (For example, 1%). Also supports a macro {Best}, which tells the encoder to select the best thumbnail from the first few seconds of the video.
        """
        return pulumi.get(self, "start")

    @property
    @pulumi.getter
    def step(self) -> Optional[str]:
        """
        The intervals at which thumbnails are generated. The value can be in absolute timestamp (ISO 8601, e.g: PT05S for one image every 5 seconds), or a frame count (For example, 30 for every 30 frames), or a relative value (For example, 1%).
        """
        return pulumi.get(self, "step")

    @property
    @pulumi.getter(name="stretchMode")
    def stretch_mode(self) -> Optional[str]:
        """
        The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
        """
        return pulumi.get(self, "stretch_mode")


@pulumi.output_type
class PngLayerResponse(dict):
    """
    Describes the settings to produce a PNG image from the input video.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PngLayerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PngLayerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PngLayerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 height: Optional[str] = None,
                 label: Optional[str] = None,
                 width: Optional[str] = None):
        """
        Describes the settings to produce a PNG image from the input video.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.PngLayer'.
        :param str height: The height of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in height as the input.
        :param str label: The alphanumeric label for this layer, which can be used in multiplexing different video and audio layers, or in naming the output file.
        :param str width: The width of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in width as the input.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.PngLayer')
        if height is not None:
            pulumi.set(__self__, "height", height)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if width is not None:
            pulumi.set(__self__, "width", width)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.PngLayer'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter
    def height(self) -> Optional[str]:
        """
        The height of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in height as the input.
        """
        return pulumi.get(self, "height")

    @property
    @pulumi.getter
    def label(self) -> Optional[str]:
        """
        The alphanumeric label for this layer, which can be used in multiplexing different video and audio layers, or in naming the output file.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def width(self) -> Optional[str]:
        """
        The width of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in width as the input.
        """
        return pulumi.get(self, "width")


@pulumi.output_type
class RectangleResponse(dict):
    """
    Describes the properties of a rectangular window applied to the input media before processing it.
    """
    def __init__(__self__, *,
                 height: Optional[str] = None,
                 left: Optional[str] = None,
                 top: Optional[str] = None,
                 width: Optional[str] = None):
        """
        Describes the properties of a rectangular window applied to the input media before processing it.
        :param str height: The height of the rectangular region in pixels. This can be absolute pixel value (e.g 100), or relative to the size of the video (For example, 50%).
        :param str left: The number of pixels from the left-margin. This can be absolute pixel value (e.g 100), or relative to the size of the video (For example, 50%).
        :param str top: The number of pixels from the top-margin. This can be absolute pixel value (e.g 100), or relative to the size of the video (For example, 50%).
        :param str width: The width of the rectangular region in pixels. This can be absolute pixel value (e.g 100), or relative to the size of the video (For example, 50%).
        """
        if height is not None:
            pulumi.set(__self__, "height", height)
        if left is not None:
            pulumi.set(__self__, "left", left)
        if top is not None:
            pulumi.set(__self__, "top", top)
        if width is not None:
            pulumi.set(__self__, "width", width)

    @property
    @pulumi.getter
    def height(self) -> Optional[str]:
        """
        The height of the rectangular region in pixels. This can be absolute pixel value (e.g 100), or relative to the size of the video (For example, 50%).
        """
        return pulumi.get(self, "height")

    @property
    @pulumi.getter
    def left(self) -> Optional[str]:
        """
        The number of pixels from the left-margin. This can be absolute pixel value (e.g 100), or relative to the size of the video (For example, 50%).
        """
        return pulumi.get(self, "left")

    @property
    @pulumi.getter
    def top(self) -> Optional[str]:
        """
        The number of pixels from the top-margin. This can be absolute pixel value (e.g 100), or relative to the size of the video (For example, 50%).
        """
        return pulumi.get(self, "top")

    @property
    @pulumi.getter
    def width(self) -> Optional[str]:
        """
        The width of the rectangular region in pixels. This can be absolute pixel value (e.g 100), or relative to the size of the video (For example, 50%).
        """
        return pulumi.get(self, "width")


@pulumi.output_type
class StandardEncoderPresetResponse(dict):
    """
    Describes all the settings to be used when encoding the input video with the Standard Encoder.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StandardEncoderPresetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StandardEncoderPresetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StandardEncoderPresetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 codecs: Optional[Sequence[Any]] = None,
                 filters: Optional['outputs.FiltersResponse'] = None,
                 formats: Optional[Sequence[Any]] = None):
        """
        Describes all the settings to be used when encoding the input video with the Standard Encoder.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.StandardEncoderPreset'.
        :param Sequence[Union['AacAudioResponse', 'AudioResponse', 'CopyAudioResponse', 'CopyVideoResponse', 'H264VideoResponse', 'ImageResponse', 'JpgImageResponse', 'PngImageResponse', 'VideoResponse']] codecs: The list of codecs to be used when encoding the input video.
        :param 'FiltersResponse' filters: One or more filtering operations that are applied to the input media before encoding.
        :param Sequence[Union['ImageFormatResponse', 'JpgFormatResponse', 'Mp4FormatResponse', 'MultiBitrateFormatResponse', 'PngFormatResponse', 'TransportStreamFormatResponse']] formats: The list of outputs to be produced by the encoder.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.StandardEncoderPreset')
        if codecs is not None:
            pulumi.set(__self__, "codecs", codecs)
        if filters is not None:
            pulumi.set(__self__, "filters", filters)
        if formats is not None:
            pulumi.set(__self__, "formats", formats)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.StandardEncoderPreset'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter
    def codecs(self) -> Optional[Sequence[Any]]:
        """
        The list of codecs to be used when encoding the input video.
        """
        return pulumi.get(self, "codecs")

    @property
    @pulumi.getter
    def filters(self) -> Optional['outputs.FiltersResponse']:
        """
        One or more filtering operations that are applied to the input media before encoding.
        """
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def formats(self) -> Optional[Sequence[Any]]:
        """
        The list of outputs to be produced by the encoder.
        """
        return pulumi.get(self, "formats")


@pulumi.output_type
class StorageAccountResponse(dict):
    """
    The storage account details.
    """
    def __init__(__self__, *,
                 type: str,
                 id: Optional[str] = None):
        """
        The storage account details.
        :param str type: The type of the storage account.
        :param str id: The ID of the storage account resource. Media Services relies on tables and queues as well as blobs, so the primary storage account must be a Standard Storage account (either Microsoft.ClassicStorage or Microsoft.Storage). Blob only storage accounts can be added as secondary storage accounts.
        """
        pulumi.set(__self__, "type", type)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the storage account.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The ID of the storage account resource. Media Services relies on tables and queues as well as blobs, so the primary storage account must be a Standard Storage account (either Microsoft.ClassicStorage or Microsoft.Storage). Blob only storage accounts can be added as secondary storage accounts.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class StreamingEndpointAccessControlResponse(dict):
    """
    StreamingEndpoint access control definition.
    """
    def __init__(__self__, *,
                 akamai: Optional['outputs.AkamaiAccessControlResponse'] = None,
                 ip: Optional['outputs.IPAccessControlResponse'] = None):
        """
        StreamingEndpoint access control definition.
        :param 'AkamaiAccessControlResponse' akamai: The access control of Akamai
        :param 'IPAccessControlResponse' ip: The IP access control of the StreamingEndpoint.
        """
        if akamai is not None:
            pulumi.set(__self__, "akamai", akamai)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)

    @property
    @pulumi.getter
    def akamai(self) -> Optional['outputs.AkamaiAccessControlResponse']:
        """
        The access control of Akamai
        """
        return pulumi.get(self, "akamai")

    @property
    @pulumi.getter
    def ip(self) -> Optional['outputs.IPAccessControlResponse']:
        """
        The IP access control of the StreamingEndpoint.
        """
        return pulumi.get(self, "ip")


@pulumi.output_type
class StreamingLocatorContentKeyResponse(dict):
    """
    Class for content key in Streaming Locator
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "policyName":
            suggest = "policy_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamingLocatorContentKeyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamingLocatorContentKeyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamingLocatorContentKeyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 policy_name: str,
                 type: str,
                 label: Optional[str] = None,
                 tracks: Optional[Sequence['outputs.TrackSelectionResponse']] = None,
                 value: Optional[str] = None):
        """
        Class for content key in Streaming Locator
        :param str id: ID of Content Key
        :param str policy_name: ContentKeyPolicy used by Content Key
        :param str type: Encryption type of Content Key
        :param str label: Label of Content Key
        :param Sequence['TrackSelectionResponse'] tracks: Tracks which use this Content Key
        :param str value: Value of Content Key
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "policy_name", policy_name)
        pulumi.set(__self__, "type", type)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if tracks is not None:
            pulumi.set(__self__, "tracks", tracks)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of Content Key
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> str:
        """
        ContentKeyPolicy used by Content Key
        """
        return pulumi.get(self, "policy_name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Encryption type of Content Key
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def label(self) -> Optional[str]:
        """
        Label of Content Key
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def tracks(self) -> Optional[Sequence['outputs.TrackSelectionResponse']]:
        """
        Tracks which use this Content Key
        """
        return pulumi.get(self, "tracks")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        Value of Content Key
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class StreamingPathResponse(dict):
    """
    Class of paths for streaming
    """
    def __init__(__self__, *,
                 encryption_scheme: str,
                 streaming_protocol: str,
                 paths: Optional[Sequence[str]] = None):
        """
        Class of paths for streaming
        :param str encryption_scheme: Encryption scheme
        :param str streaming_protocol: Streaming protocol
        :param Sequence[str] paths: Streaming paths for each protocol and encryptionScheme pair
        """
        pulumi.set(__self__, "encryption_scheme", encryption_scheme)
        pulumi.set(__self__, "streaming_protocol", streaming_protocol)
        if paths is not None:
            pulumi.set(__self__, "paths", paths)

    @property
    @pulumi.getter(name="encryptionScheme")
    def encryption_scheme(self) -> str:
        """
        Encryption scheme
        """
        return pulumi.get(self, "encryption_scheme")

    @property
    @pulumi.getter(name="streamingProtocol")
    def streaming_protocol(self) -> str:
        """
        Streaming protocol
        """
        return pulumi.get(self, "streaming_protocol")

    @property
    @pulumi.getter
    def paths(self) -> Optional[Sequence[str]]:
        """
        Streaming paths for each protocol and encryptionScheme pair
        """
        return pulumi.get(self, "paths")


@pulumi.output_type
class StreamingPolicyContentKeyResponse(dict):
    """
    Class to specify properties of content key
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "policyName":
            suggest = "policy_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamingPolicyContentKeyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamingPolicyContentKeyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamingPolicyContentKeyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 label: Optional[str] = None,
                 policy_name: Optional[str] = None,
                 tracks: Optional[Sequence['outputs.TrackSelectionResponse']] = None):
        """
        Class to specify properties of content key
        :param str label: Label can be used to specify Content Key when creating a Streaming Locator
        :param str policy_name: Policy used by Content Key
        :param Sequence['TrackSelectionResponse'] tracks: Tracks which use this content key
        """
        if label is not None:
            pulumi.set(__self__, "label", label)
        if policy_name is not None:
            pulumi.set(__self__, "policy_name", policy_name)
        if tracks is not None:
            pulumi.set(__self__, "tracks", tracks)

    @property
    @pulumi.getter
    def label(self) -> Optional[str]:
        """
        Label can be used to specify Content Key when creating a Streaming Locator
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> Optional[str]:
        """
        Policy used by Content Key
        """
        return pulumi.get(self, "policy_name")

    @property
    @pulumi.getter
    def tracks(self) -> Optional[Sequence['outputs.TrackSelectionResponse']]:
        """
        Tracks which use this content key
        """
        return pulumi.get(self, "tracks")


@pulumi.output_type
class StreamingPolicyContentKeysResponse(dict):
    """
    Class to specify properties of all content keys in Streaming Policy
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultKey":
            suggest = "default_key"
        elif key == "keyToTrackMappings":
            suggest = "key_to_track_mappings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamingPolicyContentKeysResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamingPolicyContentKeysResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamingPolicyContentKeysResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_key: Optional['outputs.DefaultKeyResponse'] = None,
                 key_to_track_mappings: Optional[Sequence['outputs.StreamingPolicyContentKeyResponse']] = None):
        """
        Class to specify properties of all content keys in Streaming Policy
        :param 'DefaultKeyResponse' default_key: Default content key for an encryption scheme
        :param Sequence['StreamingPolicyContentKeyResponse'] key_to_track_mappings: Representing tracks needs separate content key
        """
        if default_key is not None:
            pulumi.set(__self__, "default_key", default_key)
        if key_to_track_mappings is not None:
            pulumi.set(__self__, "key_to_track_mappings", key_to_track_mappings)

    @property
    @pulumi.getter(name="defaultKey")
    def default_key(self) -> Optional['outputs.DefaultKeyResponse']:
        """
        Default content key for an encryption scheme
        """
        return pulumi.get(self, "default_key")

    @property
    @pulumi.getter(name="keyToTrackMappings")
    def key_to_track_mappings(self) -> Optional[Sequence['outputs.StreamingPolicyContentKeyResponse']]:
        """
        Representing tracks needs separate content key
        """
        return pulumi.get(self, "key_to_track_mappings")


@pulumi.output_type
class StreamingPolicyFairPlayConfigurationResponse(dict):
    """
    Class to specify configurations of FairPlay in Streaming Policy
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowPersistentLicense":
            suggest = "allow_persistent_license"
        elif key == "customLicenseAcquisitionUrlTemplate":
            suggest = "custom_license_acquisition_url_template"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamingPolicyFairPlayConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamingPolicyFairPlayConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamingPolicyFairPlayConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_persistent_license: bool,
                 custom_license_acquisition_url_template: Optional[str] = None):
        """
        Class to specify configurations of FairPlay in Streaming Policy
        :param bool allow_persistent_license: All license to be persistent or not
        :param str custom_license_acquisition_url_template: The template for a customer service to deliver keys to end users.  Not needed when using Azure Media Services for issuing keys.
        """
        pulumi.set(__self__, "allow_persistent_license", allow_persistent_license)
        if custom_license_acquisition_url_template is not None:
            pulumi.set(__self__, "custom_license_acquisition_url_template", custom_license_acquisition_url_template)

    @property
    @pulumi.getter(name="allowPersistentLicense")
    def allow_persistent_license(self) -> bool:
        """
        All license to be persistent or not
        """
        return pulumi.get(self, "allow_persistent_license")

    @property
    @pulumi.getter(name="customLicenseAcquisitionUrlTemplate")
    def custom_license_acquisition_url_template(self) -> Optional[str]:
        """
        The template for a customer service to deliver keys to end users.  Not needed when using Azure Media Services for issuing keys.
        """
        return pulumi.get(self, "custom_license_acquisition_url_template")


@pulumi.output_type
class StreamingPolicyPlayReadyConfigurationResponse(dict):
    """
    Class to specify configurations of PlayReady in Streaming Policy
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customLicenseAcquisitionUrlTemplate":
            suggest = "custom_license_acquisition_url_template"
        elif key == "playReadyCustomAttributes":
            suggest = "play_ready_custom_attributes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamingPolicyPlayReadyConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamingPolicyPlayReadyConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamingPolicyPlayReadyConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_license_acquisition_url_template: Optional[str] = None,
                 play_ready_custom_attributes: Optional[str] = None):
        """
        Class to specify configurations of PlayReady in Streaming Policy
        :param str custom_license_acquisition_url_template: The template for a customer service to deliver keys to end users.  Not needed when using Azure Media Services for issuing keys.
        :param str play_ready_custom_attributes: Custom attributes for PlayReady
        """
        if custom_license_acquisition_url_template is not None:
            pulumi.set(__self__, "custom_license_acquisition_url_template", custom_license_acquisition_url_template)
        if play_ready_custom_attributes is not None:
            pulumi.set(__self__, "play_ready_custom_attributes", play_ready_custom_attributes)

    @property
    @pulumi.getter(name="customLicenseAcquisitionUrlTemplate")
    def custom_license_acquisition_url_template(self) -> Optional[str]:
        """
        The template for a customer service to deliver keys to end users.  Not needed when using Azure Media Services for issuing keys.
        """
        return pulumi.get(self, "custom_license_acquisition_url_template")

    @property
    @pulumi.getter(name="playReadyCustomAttributes")
    def play_ready_custom_attributes(self) -> Optional[str]:
        """
        Custom attributes for PlayReady
        """
        return pulumi.get(self, "play_ready_custom_attributes")


@pulumi.output_type
class StreamingPolicyWidevineConfigurationResponse(dict):
    """
    Class to specify configurations of Widevine in Streaming Policy
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customLicenseAcquisitionUrlTemplate":
            suggest = "custom_license_acquisition_url_template"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamingPolicyWidevineConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamingPolicyWidevineConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamingPolicyWidevineConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_license_acquisition_url_template: Optional[str] = None):
        """
        Class to specify configurations of Widevine in Streaming Policy
        :param str custom_license_acquisition_url_template: The template for a customer service to deliver keys to end users.  Not needed when using Azure Media Services for issuing keys.
        """
        if custom_license_acquisition_url_template is not None:
            pulumi.set(__self__, "custom_license_acquisition_url_template", custom_license_acquisition_url_template)

    @property
    @pulumi.getter(name="customLicenseAcquisitionUrlTemplate")
    def custom_license_acquisition_url_template(self) -> Optional[str]:
        """
        The template for a customer service to deliver keys to end users.  Not needed when using Azure Media Services for issuing keys.
        """
        return pulumi.get(self, "custom_license_acquisition_url_template")


@pulumi.output_type
class TrackPropertyConditionResponse(dict):
    """
    Class to specify one track property condition
    """
    def __init__(__self__, *,
                 operation: str,
                 property: str,
                 value: Optional[str] = None):
        """
        Class to specify one track property condition
        :param str operation: Track property condition operation
        :param str property: Track property type
        :param str value: Track property value
        """
        pulumi.set(__self__, "operation", operation)
        pulumi.set(__self__, "property", property)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def operation(self) -> str:
        """
        Track property condition operation
        """
        return pulumi.get(self, "operation")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        Track property value
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def property(self) -> str:
        """
        Track property type
        """
        return pulumi.get(self, "property")


@pulumi.output_type
class TrackSelectionResponse(dict):
    """
    Class to select a track
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "trackSelections":
            suggest = "track_selections"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TrackSelectionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TrackSelectionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TrackSelectionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 track_selections: Optional[Sequence['outputs.TrackPropertyConditionResponse']] = None):
        """
        Class to select a track
        :param Sequence['TrackPropertyConditionResponse'] track_selections: TrackSelections is a track property condition list which can specify track(s)
        """
        if track_selections is not None:
            pulumi.set(__self__, "track_selections", track_selections)

    @property
    @pulumi.getter(name="trackSelections")
    def track_selections(self) -> Optional[Sequence['outputs.TrackPropertyConditionResponse']]:
        """
        TrackSelections is a track property condition list which can specify track(s)
        """
        return pulumi.get(self, "track_selections")


@pulumi.output_type
class TransformOutputResponse(dict):
    """
    Describes the properties of a TransformOutput, which are the rules to be applied while generating the desired output.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "onError":
            suggest = "on_error"
        elif key == "relativePriority":
            suggest = "relative_priority"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TransformOutputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TransformOutputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TransformOutputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 preset: Any,
                 on_error: Optional[str] = None,
                 relative_priority: Optional[str] = None):
        """
        Describes the properties of a TransformOutput, which are the rules to be applied while generating the desired output.
        :param Union['AudioAnalyzerPresetResponse', 'BuiltInStandardEncoderPresetResponse', 'StandardEncoderPresetResponse', 'VideoAnalyzerPresetResponse'] preset: Preset that describes the operations that will be used to modify, transcode, or extract insights from the source file to generate the output.
        :param str on_error: A Transform can define more than one outputs. This property defines what the service should do when one output fails - either continue to produce other outputs, or, stop the other outputs. The default is stop.
        :param str relative_priority: Sets the relative priority of the TransformOutputs within a Transform. This sets the priority that the service uses for processing TransformOutputs. The default priority is Normal.
        """
        pulumi.set(__self__, "preset", preset)
        if on_error is not None:
            pulumi.set(__self__, "on_error", on_error)
        if relative_priority is not None:
            pulumi.set(__self__, "relative_priority", relative_priority)

    @property
    @pulumi.getter
    def preset(self) -> Any:
        """
        Preset that describes the operations that will be used to modify, transcode, or extract insights from the source file to generate the output.
        """
        return pulumi.get(self, "preset")

    @property
    @pulumi.getter(name="onError")
    def on_error(self) -> Optional[str]:
        """
        A Transform can define more than one outputs. This property defines what the service should do when one output fails - either continue to produce other outputs, or, stop the other outputs. The default is stop.
        """
        return pulumi.get(self, "on_error")

    @property
    @pulumi.getter(name="relativePriority")
    def relative_priority(self) -> Optional[str]:
        """
        Sets the relative priority of the TransformOutputs within a Transform. This sets the priority that the service uses for processing TransformOutputs. The default priority is Normal.
        """
        return pulumi.get(self, "relative_priority")


@pulumi.output_type
class TransportStreamFormatResponse(dict):
    """
    Describes the properties for generating an MPEG-2 Transport Stream (ISO/IEC 13818-1) output video file(s).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "filenamePattern":
            suggest = "filename_pattern"
        elif key == "outputFiles":
            suggest = "output_files"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TransportStreamFormatResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TransportStreamFormatResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TransportStreamFormatResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 filename_pattern: Optional[str] = None,
                 output_files: Optional[Sequence['outputs.OutputFileResponse']] = None):
        """
        Describes the properties for generating an MPEG-2 Transport Stream (ISO/IEC 13818-1) output video file(s).
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.TransportStreamFormat'.
        :param str filename_pattern: The pattern of the file names for the generated output files. The following macros are supported in the file name: {Basename} - The base name of the input video {Extension} - The appropriate extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {Bitrate} - The audio/video bitrate. Not applicable to thumbnails. {Codec} - The type of the audio/video codec. Any unsubstituted macros will be collapsed and removed from the filename.
        :param Sequence['OutputFileResponse'] output_files: The list of output files to produce.  Each entry in the list is a set of audio and video layer labels to be muxed together .
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.TransportStreamFormat')
        if filename_pattern is not None:
            pulumi.set(__self__, "filename_pattern", filename_pattern)
        if output_files is not None:
            pulumi.set(__self__, "output_files", output_files)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.TransportStreamFormat'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="filenamePattern")
    def filename_pattern(self) -> Optional[str]:
        """
        The pattern of the file names for the generated output files. The following macros are supported in the file name: {Basename} - The base name of the input video {Extension} - The appropriate extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {Bitrate} - The audio/video bitrate. Not applicable to thumbnails. {Codec} - The type of the audio/video codec. Any unsubstituted macros will be collapsed and removed from the filename.
        """
        return pulumi.get(self, "filename_pattern")

    @property
    @pulumi.getter(name="outputFiles")
    def output_files(self) -> Optional[Sequence['outputs.OutputFileResponse']]:
        """
        The list of output files to produce.  Each entry in the list is a set of audio and video layer labels to be muxed together .
        """
        return pulumi.get(self, "output_files")


@pulumi.output_type
class VideoAnalyzerPresetResponse(dict):
    """
    A video analyzer preset that extracts insights (rich metadata) from both audio and video, and outputs a JSON format file.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "audioInsightsOnly":
            suggest = "audio_insights_only"
        elif key == "audioLanguage":
            suggest = "audio_language"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VideoAnalyzerPresetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VideoAnalyzerPresetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VideoAnalyzerPresetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 audio_insights_only: Optional[bool] = None,
                 audio_language: Optional[str] = None):
        """
        A video analyzer preset that extracts insights (rich metadata) from both audio and video, and outputs a JSON format file.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.VideoAnalyzerPreset'.
        :param bool audio_insights_only: Whether to only extract audio insights when processing a video file.
        :param str audio_language: The language for the audio payload in the input using the BCP-47 format of 'language tag-region' (e.g: 'en-US'). The list of supported languages are, 'en-US', 'en-GB', 'es-ES', 'es-MX', 'fr-FR', 'it-IT', 'ja-JP', 'pt-BR', 'zh-CN'.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.VideoAnalyzerPreset')
        if audio_insights_only is not None:
            pulumi.set(__self__, "audio_insights_only", audio_insights_only)
        if audio_language is not None:
            pulumi.set(__self__, "audio_language", audio_language)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.VideoAnalyzerPreset'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="audioInsightsOnly")
    def audio_insights_only(self) -> Optional[bool]:
        """
        Whether to only extract audio insights when processing a video file.
        """
        return pulumi.get(self, "audio_insights_only")

    @property
    @pulumi.getter(name="audioLanguage")
    def audio_language(self) -> Optional[str]:
        """
        The language for the audio payload in the input using the BCP-47 format of 'language tag-region' (e.g: 'en-US'). The list of supported languages are, 'en-US', 'en-GB', 'es-ES', 'es-MX', 'fr-FR', 'it-IT', 'ja-JP', 'pt-BR', 'zh-CN'.
        """
        return pulumi.get(self, "audio_language")


@pulumi.output_type
class VideoOverlayResponse(dict):
    """
    Describes the properties of a video overlay.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "audioGainLevel":
            suggest = "audio_gain_level"
        elif key == "cropRectangle":
            suggest = "crop_rectangle"
        elif key == "fadeInDuration":
            suggest = "fade_in_duration"
        elif key == "fadeOutDuration":
            suggest = "fade_out_duration"
        elif key == "inputLabel":
            suggest = "input_label"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VideoOverlayResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VideoOverlayResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VideoOverlayResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 audio_gain_level: Optional[float] = None,
                 crop_rectangle: Optional['outputs.RectangleResponse'] = None,
                 end: Optional[str] = None,
                 fade_in_duration: Optional[str] = None,
                 fade_out_duration: Optional[str] = None,
                 input_label: Optional[str] = None,
                 opacity: Optional[float] = None,
                 position: Optional['outputs.RectangleResponse'] = None,
                 start: Optional[str] = None):
        """
        Describes the properties of a video overlay.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.VideoOverlay'.
        :param float audio_gain_level: The gain level of audio in the overlay. The value should be in the range [0, 1.0]. The default is 1.0.
        :param 'RectangleResponse' crop_rectangle: An optional rectangular window used to crop the overlay image or video.
        :param str end: The position in the input video at which the overlay ends. The value should be in ISO 8601 duration format. For example, PT30S to end the overlay at 30 seconds in to the input video. If not specified the overlay will be applied until the end of the input video if inputLoop is true. Else, if inputLoop is false, then overlay will last as long as the duration of the overlay media.
        :param str fade_in_duration: The duration over which the overlay fades in onto the input video. The value should be in ISO 8601 duration format. If not specified the default behavior is to have no fade in (same as PT0S).
        :param str fade_out_duration: The duration over which the overlay fades out of the input video. The value should be in ISO 8601 duration format. If not specified the default behavior is to have no fade out (same as PT0S).
        :param str input_label: The label of the job input which is to be used as an overlay. The Input must specify exactly one file. You can specify an image file in JPG or PNG formats, or an audio file (such as a WAV, MP3, WMA or M4A file), or a video file. See https://aka.ms/mesformats for the complete list of supported audio and video file formats.
        :param float opacity: The opacity of the overlay. This is a value in the range [0 - 1.0]. Default is 1.0 which mean the overlay is opaque.
        :param 'RectangleResponse' position: The location in the input video where the overlay is applied.
        :param str start: The start position, with reference to the input video, at which the overlay starts. The value should be in ISO 8601 format. For example, PT05S to start the overlay at 5 seconds in to the input video. If not specified the overlay starts from the beginning of the input video.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.VideoOverlay')
        if audio_gain_level is not None:
            pulumi.set(__self__, "audio_gain_level", audio_gain_level)
        if crop_rectangle is not None:
            pulumi.set(__self__, "crop_rectangle", crop_rectangle)
        if end is not None:
            pulumi.set(__self__, "end", end)
        if fade_in_duration is not None:
            pulumi.set(__self__, "fade_in_duration", fade_in_duration)
        if fade_out_duration is not None:
            pulumi.set(__self__, "fade_out_duration", fade_out_duration)
        if input_label is not None:
            pulumi.set(__self__, "input_label", input_label)
        if opacity is not None:
            pulumi.set(__self__, "opacity", opacity)
        if position is not None:
            pulumi.set(__self__, "position", position)
        if start is not None:
            pulumi.set(__self__, "start", start)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.VideoOverlay'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="audioGainLevel")
    def audio_gain_level(self) -> Optional[float]:
        """
        The gain level of audio in the overlay. The value should be in the range [0, 1.0]. The default is 1.0.
        """
        return pulumi.get(self, "audio_gain_level")

    @property
    @pulumi.getter(name="cropRectangle")
    def crop_rectangle(self) -> Optional['outputs.RectangleResponse']:
        """
        An optional rectangular window used to crop the overlay image or video.
        """
        return pulumi.get(self, "crop_rectangle")

    @property
    @pulumi.getter
    def end(self) -> Optional[str]:
        """
        The position in the input video at which the overlay ends. The value should be in ISO 8601 duration format. For example, PT30S to end the overlay at 30 seconds in to the input video. If not specified the overlay will be applied until the end of the input video if inputLoop is true. Else, if inputLoop is false, then overlay will last as long as the duration of the overlay media.
        """
        return pulumi.get(self, "end")

    @property
    @pulumi.getter(name="fadeInDuration")
    def fade_in_duration(self) -> Optional[str]:
        """
        The duration over which the overlay fades in onto the input video. The value should be in ISO 8601 duration format. If not specified the default behavior is to have no fade in (same as PT0S).
        """
        return pulumi.get(self, "fade_in_duration")

    @property
    @pulumi.getter(name="fadeOutDuration")
    def fade_out_duration(self) -> Optional[str]:
        """
        The duration over which the overlay fades out of the input video. The value should be in ISO 8601 duration format. If not specified the default behavior is to have no fade out (same as PT0S).
        """
        return pulumi.get(self, "fade_out_duration")

    @property
    @pulumi.getter(name="inputLabel")
    def input_label(self) -> Optional[str]:
        """
        The label of the job input which is to be used as an overlay. The Input must specify exactly one file. You can specify an image file in JPG or PNG formats, or an audio file (such as a WAV, MP3, WMA or M4A file), or a video file. See https://aka.ms/mesformats for the complete list of supported audio and video file formats.
        """
        return pulumi.get(self, "input_label")

    @property
    @pulumi.getter
    def opacity(self) -> Optional[float]:
        """
        The opacity of the overlay. This is a value in the range [0 - 1.0]. Default is 1.0 which mean the overlay is opaque.
        """
        return pulumi.get(self, "opacity")

    @property
    @pulumi.getter
    def position(self) -> Optional['outputs.RectangleResponse']:
        """
        The location in the input video where the overlay is applied.
        """
        return pulumi.get(self, "position")

    @property
    @pulumi.getter
    def start(self) -> Optional[str]:
        """
        The start position, with reference to the input video, at which the overlay starts. The value should be in ISO 8601 format. For example, PT05S to start the overlay at 5 seconds in to the input video. If not specified the overlay starts from the beginning of the input video.
        """
        return pulumi.get(self, "start")


@pulumi.output_type
class VideoResponse(dict):
    """
    Describes the basic properties for encoding the input video.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "keyFrameInterval":
            suggest = "key_frame_interval"
        elif key == "stretchMode":
            suggest = "stretch_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VideoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VideoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VideoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 key_frame_interval: Optional[str] = None,
                 label: Optional[str] = None,
                 stretch_mode: Optional[str] = None):
        """
        Describes the basic properties for encoding the input video.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.Video'.
        :param str key_frame_interval: The distance between two key frames, thereby defining a group of pictures (GOP). The value should be a non-zero integer in the range [1, 30] seconds, specified in ISO 8601 format. The default is 2 seconds (PT2S).
        :param str label: An optional label for the codec. The label can be used to control muxing behavior.
        :param str stretch_mode: The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.Video')
        if key_frame_interval is not None:
            pulumi.set(__self__, "key_frame_interval", key_frame_interval)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if stretch_mode is not None:
            pulumi.set(__self__, "stretch_mode", stretch_mode)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.Video'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="keyFrameInterval")
    def key_frame_interval(self) -> Optional[str]:
        """
        The distance between two key frames, thereby defining a group of pictures (GOP). The value should be a non-zero integer in the range [1, 30] seconds, specified in ISO 8601 format. The default is 2 seconds (PT2S).
        """
        return pulumi.get(self, "key_frame_interval")

    @property
    @pulumi.getter
    def label(self) -> Optional[str]:
        """
        An optional label for the codec. The label can be used to control muxing behavior.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter(name="stretchMode")
    def stretch_mode(self) -> Optional[str]:
        """
        The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
        """
        return pulumi.get(self, "stretch_mode")


