# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AKSPropertiesArgs',
    'AKSArgs',
    'AksNetworkingConfigurationArgs',
    'AmlComputePropertiesArgs',
    'AmlComputeArgs',
    'AssignedUserArgs',
    'AutoPausePropertiesArgs',
    'AutoScalePropertiesArgs',
    'ComputeInstancePropertiesArgs',
    'ComputeInstanceSshSettingsArgs',
    'ComputeInstanceArgs',
    'CosmosDbSettingsArgs',
    'DataFactoryArgs',
    'DataLakeAnalyticsPropertiesArgs',
    'DataLakeAnalyticsArgs',
    'DatabricksPropertiesArgs',
    'DatabricksArgs',
    'EncryptionPropertyArgs',
    'HDInsightPropertiesArgs',
    'HDInsightArgs',
    'IdentityForCmkArgs',
    'IdentityArgs',
    'InstanceTypeSchemaResourcesArgs',
    'InstanceTypeSchemaArgs',
    'KeyVaultPropertiesArgs',
    'KubernetesPropertiesArgs',
    'KubernetesArgs',
    'PersonalComputeInstanceSettingsArgs',
    'PrivateLinkServiceConnectionStateArgs',
    'ResourceIdArgs',
    'ScaleSettingsArgs',
    'ScriptReferenceArgs',
    'ScriptsToExecuteArgs',
    'ServiceManagedResourcesSettingsArgs',
    'SetupScriptsArgs',
    'SharedPrivateLinkResourceArgs',
    'SkuArgs',
    'SslConfigurationArgs',
    'SynapseSparkPropertiesArgs',
    'SynapseSparkArgs',
    'UserAccountCredentialsArgs',
    'VirtualMachineImageArgs',
    'VirtualMachinePropertiesArgs',
    'VirtualMachineSshCredentialsArgs',
    'VirtualMachineArgs',
]

@pulumi.input_type
class AKSPropertiesArgs:
    def __init__(__self__, *,
                 agent_count: Optional[pulumi.Input[int]] = None,
                 agent_vm_size: Optional[pulumi.Input[str]] = None,
                 aks_networking_configuration: Optional[pulumi.Input['AksNetworkingConfigurationArgs']] = None,
                 cluster_fqdn: Optional[pulumi.Input[str]] = None,
                 cluster_purpose: Optional[pulumi.Input[Union[str, 'ClusterPurpose']]] = None,
                 load_balancer_subnet: Optional[pulumi.Input[str]] = None,
                 load_balancer_type: Optional[pulumi.Input[Union[str, 'LoadBalancerType']]] = None,
                 ssl_configuration: Optional[pulumi.Input['SslConfigurationArgs']] = None):
        """
        AKS properties
        :param pulumi.Input[int] agent_count: Number of agents
        :param pulumi.Input[str] agent_vm_size: Agent virtual machine size
        :param pulumi.Input['AksNetworkingConfigurationArgs'] aks_networking_configuration: AKS networking configuration for vnet
        :param pulumi.Input[str] cluster_fqdn: Cluster full qualified domain name
        :param pulumi.Input[Union[str, 'ClusterPurpose']] cluster_purpose: Intended usage of the cluster
        :param pulumi.Input[str] load_balancer_subnet: Load Balancer Subnet
        :param pulumi.Input[Union[str, 'LoadBalancerType']] load_balancer_type: Load Balancer Type
        :param pulumi.Input['SslConfigurationArgs'] ssl_configuration: SSL configuration
        """
        if agent_count is not None:
            pulumi.set(__self__, "agent_count", agent_count)
        if agent_vm_size is not None:
            pulumi.set(__self__, "agent_vm_size", agent_vm_size)
        if aks_networking_configuration is not None:
            pulumi.set(__self__, "aks_networking_configuration", aks_networking_configuration)
        if cluster_fqdn is not None:
            pulumi.set(__self__, "cluster_fqdn", cluster_fqdn)
        if cluster_purpose is None:
            cluster_purpose = 'FastProd'
        if cluster_purpose is not None:
            pulumi.set(__self__, "cluster_purpose", cluster_purpose)
        if load_balancer_subnet is not None:
            pulumi.set(__self__, "load_balancer_subnet", load_balancer_subnet)
        if load_balancer_type is None:
            load_balancer_type = 'PublicIp'
        if load_balancer_type is not None:
            pulumi.set(__self__, "load_balancer_type", load_balancer_type)
        if ssl_configuration is not None:
            pulumi.set(__self__, "ssl_configuration", ssl_configuration)

    @property
    @pulumi.getter(name="agentCount")
    def agent_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of agents
        """
        return pulumi.get(self, "agent_count")

    @agent_count.setter
    def agent_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "agent_count", value)

    @property
    @pulumi.getter(name="agentVmSize")
    def agent_vm_size(self) -> Optional[pulumi.Input[str]]:
        """
        Agent virtual machine size
        """
        return pulumi.get(self, "agent_vm_size")

    @agent_vm_size.setter
    def agent_vm_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "agent_vm_size", value)

    @property
    @pulumi.getter(name="aksNetworkingConfiguration")
    def aks_networking_configuration(self) -> Optional[pulumi.Input['AksNetworkingConfigurationArgs']]:
        """
        AKS networking configuration for vnet
        """
        return pulumi.get(self, "aks_networking_configuration")

    @aks_networking_configuration.setter
    def aks_networking_configuration(self, value: Optional[pulumi.Input['AksNetworkingConfigurationArgs']]):
        pulumi.set(self, "aks_networking_configuration", value)

    @property
    @pulumi.getter(name="clusterFqdn")
    def cluster_fqdn(self) -> Optional[pulumi.Input[str]]:
        """
        Cluster full qualified domain name
        """
        return pulumi.get(self, "cluster_fqdn")

    @cluster_fqdn.setter
    def cluster_fqdn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_fqdn", value)

    @property
    @pulumi.getter(name="clusterPurpose")
    def cluster_purpose(self) -> Optional[pulumi.Input[Union[str, 'ClusterPurpose']]]:
        """
        Intended usage of the cluster
        """
        return pulumi.get(self, "cluster_purpose")

    @cluster_purpose.setter
    def cluster_purpose(self, value: Optional[pulumi.Input[Union[str, 'ClusterPurpose']]]):
        pulumi.set(self, "cluster_purpose", value)

    @property
    @pulumi.getter(name="loadBalancerSubnet")
    def load_balancer_subnet(self) -> Optional[pulumi.Input[str]]:
        """
        Load Balancer Subnet
        """
        return pulumi.get(self, "load_balancer_subnet")

    @load_balancer_subnet.setter
    def load_balancer_subnet(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancer_subnet", value)

    @property
    @pulumi.getter(name="loadBalancerType")
    def load_balancer_type(self) -> Optional[pulumi.Input[Union[str, 'LoadBalancerType']]]:
        """
        Load Balancer Type
        """
        return pulumi.get(self, "load_balancer_type")

    @load_balancer_type.setter
    def load_balancer_type(self, value: Optional[pulumi.Input[Union[str, 'LoadBalancerType']]]):
        pulumi.set(self, "load_balancer_type", value)

    @property
    @pulumi.getter(name="sslConfiguration")
    def ssl_configuration(self) -> Optional[pulumi.Input['SslConfigurationArgs']]:
        """
        SSL configuration
        """
        return pulumi.get(self, "ssl_configuration")

    @ssl_configuration.setter
    def ssl_configuration(self, value: Optional[pulumi.Input['SslConfigurationArgs']]):
        pulumi.set(self, "ssl_configuration", value)


@pulumi.input_type
class AKSArgs:
    def __init__(__self__, *,
                 compute_type: pulumi.Input[str],
                 compute_location: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disable_local_auth: Optional[pulumi.Input[bool]] = None,
                 properties: Optional[pulumi.Input['AKSPropertiesArgs']] = None,
                 resource_id: Optional[pulumi.Input[str]] = None):
        """
        A Machine Learning compute based on AKS.
        :param pulumi.Input[str] compute_type: The type of compute
               Expected value is 'AKS'.
        :param pulumi.Input[str] compute_location: Location for the underlying compute
        :param pulumi.Input[str] description: The description of the Machine Learning compute.
        :param pulumi.Input[bool] disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        :param pulumi.Input['AKSPropertiesArgs'] properties: AKS properties
        :param pulumi.Input[str] resource_id: ARM resource id of the underlying compute
        """
        pulumi.set(__self__, "compute_type", 'AKS')
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_local_auth is not None:
            pulumi.set(__self__, "disable_local_auth", disable_local_auth)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> pulumi.Input[str]:
        """
        The type of compute
        Expected value is 'AKS'.
        """
        return pulumi.get(self, "compute_type")

    @compute_type.setter
    def compute_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "compute_type", value)

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[pulumi.Input[str]]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @compute_location.setter
    def compute_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compute_location", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="disableLocalAuth")
    def disable_local_auth(self) -> Optional[pulumi.Input[bool]]:
        """
        Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        """
        return pulumi.get(self, "disable_local_auth")

    @disable_local_auth.setter
    def disable_local_auth(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_local_auth", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['AKSPropertiesArgs']]:
        """
        AKS properties
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['AKSPropertiesArgs']]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource id of the underlying compute
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)


@pulumi.input_type
class AksNetworkingConfigurationArgs:
    def __init__(__self__, *,
                 dns_service_ip: Optional[pulumi.Input[str]] = None,
                 docker_bridge_cidr: Optional[pulumi.Input[str]] = None,
                 service_cidr: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None):
        """
        Advance configuration for AKS networking
        :param pulumi.Input[str] dns_service_ip: An IP address assigned to the Kubernetes DNS service. It must be within the Kubernetes service address range specified in serviceCidr.
        :param pulumi.Input[str] docker_bridge_cidr: A CIDR notation IP range assigned to the Docker bridge network. It must not overlap with any Subnet IP ranges or the Kubernetes service address range.
        :param pulumi.Input[str] service_cidr: A CIDR notation IP range from which to assign service cluster IPs. It must not overlap with any Subnet IP ranges.
        :param pulumi.Input[str] subnet_id: Virtual network subnet resource ID the compute nodes belong to
        """
        if dns_service_ip is not None:
            pulumi.set(__self__, "dns_service_ip", dns_service_ip)
        if docker_bridge_cidr is not None:
            pulumi.set(__self__, "docker_bridge_cidr", docker_bridge_cidr)
        if service_cidr is not None:
            pulumi.set(__self__, "service_cidr", service_cidr)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="dnsServiceIP")
    def dns_service_ip(self) -> Optional[pulumi.Input[str]]:
        """
        An IP address assigned to the Kubernetes DNS service. It must be within the Kubernetes service address range specified in serviceCidr.
        """
        return pulumi.get(self, "dns_service_ip")

    @dns_service_ip.setter
    def dns_service_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_service_ip", value)

    @property
    @pulumi.getter(name="dockerBridgeCidr")
    def docker_bridge_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        A CIDR notation IP range assigned to the Docker bridge network. It must not overlap with any Subnet IP ranges or the Kubernetes service address range.
        """
        return pulumi.get(self, "docker_bridge_cidr")

    @docker_bridge_cidr.setter
    def docker_bridge_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "docker_bridge_cidr", value)

    @property
    @pulumi.getter(name="serviceCidr")
    def service_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        A CIDR notation IP range from which to assign service cluster IPs. It must not overlap with any Subnet IP ranges.
        """
        return pulumi.get(self, "service_cidr")

    @service_cidr.setter
    def service_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_cidr", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        Virtual network subnet resource ID the compute nodes belong to
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)


@pulumi.input_type
class AmlComputePropertiesArgs:
    def __init__(__self__, *,
                 enable_node_public_ip: Optional[pulumi.Input[bool]] = None,
                 isolated_network: Optional[pulumi.Input[bool]] = None,
                 os_type: Optional[pulumi.Input[Union[str, 'OsType']]] = None,
                 remote_login_port_public_access: Optional[pulumi.Input[Union[str, 'RemoteLoginPortPublicAccess']]] = None,
                 scale_settings: Optional[pulumi.Input['ScaleSettingsArgs']] = None,
                 subnet: Optional[pulumi.Input['ResourceIdArgs']] = None,
                 user_account_credentials: Optional[pulumi.Input['UserAccountCredentialsArgs']] = None,
                 virtual_machine_image: Optional[pulumi.Input['VirtualMachineImageArgs']] = None,
                 vm_priority: Optional[pulumi.Input[Union[str, 'VmPriority']]] = None,
                 vm_size: Optional[pulumi.Input[str]] = None):
        """
        AML Compute properties
        :param pulumi.Input[bool] enable_node_public_ip: Enable or disable node public IP address provisioning. Possible values are: Possible values are: true - Indicates that the compute nodes will have public IPs provisioned. false - Indicates that the compute nodes will have a private endpoint and no public IPs.
        :param pulumi.Input[bool] isolated_network: Network is isolated or not
        :param pulumi.Input[Union[str, 'OsType']] os_type: Compute OS Type
        :param pulumi.Input[Union[str, 'RemoteLoginPortPublicAccess']] remote_login_port_public_access: State of the public SSH port. Possible values are: Disabled - Indicates that the public ssh port is closed on all nodes of the cluster. Enabled - Indicates that the public ssh port is open on all nodes of the cluster. NotSpecified - Indicates that the public ssh port is closed on all nodes of the cluster if VNet is defined, else is open all public nodes. It can be default only during cluster creation time, after creation it will be either enabled or disabled.
        :param pulumi.Input['ScaleSettingsArgs'] scale_settings: Scale settings for AML Compute
        :param pulumi.Input['ResourceIdArgs'] subnet: Virtual network subnet resource ID the compute nodes belong to.
        :param pulumi.Input['UserAccountCredentialsArgs'] user_account_credentials: Credentials for an administrator user account that will be created on each compute node.
        :param pulumi.Input['VirtualMachineImageArgs'] virtual_machine_image: Virtual Machine image for AML Compute - windows only
        :param pulumi.Input[Union[str, 'VmPriority']] vm_priority: Virtual Machine priority
        :param pulumi.Input[str] vm_size: Virtual Machine Size
        """
        if enable_node_public_ip is None:
            enable_node_public_ip = True
        if enable_node_public_ip is not None:
            pulumi.set(__self__, "enable_node_public_ip", enable_node_public_ip)
        if isolated_network is not None:
            pulumi.set(__self__, "isolated_network", isolated_network)
        if os_type is None:
            os_type = 'Linux'
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if remote_login_port_public_access is None:
            remote_login_port_public_access = 'NotSpecified'
        if remote_login_port_public_access is not None:
            pulumi.set(__self__, "remote_login_port_public_access", remote_login_port_public_access)
        if scale_settings is not None:
            pulumi.set(__self__, "scale_settings", scale_settings)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)
        if user_account_credentials is not None:
            pulumi.set(__self__, "user_account_credentials", user_account_credentials)
        if virtual_machine_image is not None:
            pulumi.set(__self__, "virtual_machine_image", virtual_machine_image)
        if vm_priority is not None:
            pulumi.set(__self__, "vm_priority", vm_priority)
        if vm_size is not None:
            pulumi.set(__self__, "vm_size", vm_size)

    @property
    @pulumi.getter(name="enableNodePublicIp")
    def enable_node_public_ip(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable or disable node public IP address provisioning. Possible values are: Possible values are: true - Indicates that the compute nodes will have public IPs provisioned. false - Indicates that the compute nodes will have a private endpoint and no public IPs.
        """
        return pulumi.get(self, "enable_node_public_ip")

    @enable_node_public_ip.setter
    def enable_node_public_ip(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_node_public_ip", value)

    @property
    @pulumi.getter(name="isolatedNetwork")
    def isolated_network(self) -> Optional[pulumi.Input[bool]]:
        """
        Network is isolated or not
        """
        return pulumi.get(self, "isolated_network")

    @isolated_network.setter
    def isolated_network(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "isolated_network", value)

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[pulumi.Input[Union[str, 'OsType']]]:
        """
        Compute OS Type
        """
        return pulumi.get(self, "os_type")

    @os_type.setter
    def os_type(self, value: Optional[pulumi.Input[Union[str, 'OsType']]]):
        pulumi.set(self, "os_type", value)

    @property
    @pulumi.getter(name="remoteLoginPortPublicAccess")
    def remote_login_port_public_access(self) -> Optional[pulumi.Input[Union[str, 'RemoteLoginPortPublicAccess']]]:
        """
        State of the public SSH port. Possible values are: Disabled - Indicates that the public ssh port is closed on all nodes of the cluster. Enabled - Indicates that the public ssh port is open on all nodes of the cluster. NotSpecified - Indicates that the public ssh port is closed on all nodes of the cluster if VNet is defined, else is open all public nodes. It can be default only during cluster creation time, after creation it will be either enabled or disabled.
        """
        return pulumi.get(self, "remote_login_port_public_access")

    @remote_login_port_public_access.setter
    def remote_login_port_public_access(self, value: Optional[pulumi.Input[Union[str, 'RemoteLoginPortPublicAccess']]]):
        pulumi.set(self, "remote_login_port_public_access", value)

    @property
    @pulumi.getter(name="scaleSettings")
    def scale_settings(self) -> Optional[pulumi.Input['ScaleSettingsArgs']]:
        """
        Scale settings for AML Compute
        """
        return pulumi.get(self, "scale_settings")

    @scale_settings.setter
    def scale_settings(self, value: Optional[pulumi.Input['ScaleSettingsArgs']]):
        pulumi.set(self, "scale_settings", value)

    @property
    @pulumi.getter
    def subnet(self) -> Optional[pulumi.Input['ResourceIdArgs']]:
        """
        Virtual network subnet resource ID the compute nodes belong to.
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: Optional[pulumi.Input['ResourceIdArgs']]):
        pulumi.set(self, "subnet", value)

    @property
    @pulumi.getter(name="userAccountCredentials")
    def user_account_credentials(self) -> Optional[pulumi.Input['UserAccountCredentialsArgs']]:
        """
        Credentials for an administrator user account that will be created on each compute node.
        """
        return pulumi.get(self, "user_account_credentials")

    @user_account_credentials.setter
    def user_account_credentials(self, value: Optional[pulumi.Input['UserAccountCredentialsArgs']]):
        pulumi.set(self, "user_account_credentials", value)

    @property
    @pulumi.getter(name="virtualMachineImage")
    def virtual_machine_image(self) -> Optional[pulumi.Input['VirtualMachineImageArgs']]:
        """
        Virtual Machine image for AML Compute - windows only
        """
        return pulumi.get(self, "virtual_machine_image")

    @virtual_machine_image.setter
    def virtual_machine_image(self, value: Optional[pulumi.Input['VirtualMachineImageArgs']]):
        pulumi.set(self, "virtual_machine_image", value)

    @property
    @pulumi.getter(name="vmPriority")
    def vm_priority(self) -> Optional[pulumi.Input[Union[str, 'VmPriority']]]:
        """
        Virtual Machine priority
        """
        return pulumi.get(self, "vm_priority")

    @vm_priority.setter
    def vm_priority(self, value: Optional[pulumi.Input[Union[str, 'VmPriority']]]):
        pulumi.set(self, "vm_priority", value)

    @property
    @pulumi.getter(name="vmSize")
    def vm_size(self) -> Optional[pulumi.Input[str]]:
        """
        Virtual Machine Size
        """
        return pulumi.get(self, "vm_size")

    @vm_size.setter
    def vm_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vm_size", value)


@pulumi.input_type
class AmlComputeArgs:
    def __init__(__self__, *,
                 compute_type: pulumi.Input[str],
                 compute_location: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disable_local_auth: Optional[pulumi.Input[bool]] = None,
                 properties: Optional[pulumi.Input['AmlComputePropertiesArgs']] = None,
                 resource_id: Optional[pulumi.Input[str]] = None):
        """
        An Azure Machine Learning compute.
        :param pulumi.Input[str] compute_type: The type of compute
               Expected value is 'AmlCompute'.
        :param pulumi.Input[str] compute_location: Location for the underlying compute
        :param pulumi.Input[str] description: The description of the Machine Learning compute.
        :param pulumi.Input[bool] disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        :param pulumi.Input['AmlComputePropertiesArgs'] properties: Properties of AmlCompute
        :param pulumi.Input[str] resource_id: ARM resource id of the underlying compute
        """
        pulumi.set(__self__, "compute_type", 'AmlCompute')
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_local_auth is not None:
            pulumi.set(__self__, "disable_local_auth", disable_local_auth)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> pulumi.Input[str]:
        """
        The type of compute
        Expected value is 'AmlCompute'.
        """
        return pulumi.get(self, "compute_type")

    @compute_type.setter
    def compute_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "compute_type", value)

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[pulumi.Input[str]]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @compute_location.setter
    def compute_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compute_location", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="disableLocalAuth")
    def disable_local_auth(self) -> Optional[pulumi.Input[bool]]:
        """
        Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        """
        return pulumi.get(self, "disable_local_auth")

    @disable_local_auth.setter
    def disable_local_auth(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_local_auth", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['AmlComputePropertiesArgs']]:
        """
        Properties of AmlCompute
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['AmlComputePropertiesArgs']]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource id of the underlying compute
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)


@pulumi.input_type
class AssignedUserArgs:
    def __init__(__self__, *,
                 object_id: pulumi.Input[str],
                 tenant_id: pulumi.Input[str]):
        """
        A user that can be assigned to a compute instance.
        :param pulumi.Input[str] object_id: User’s AAD Object Id.
        :param pulumi.Input[str] tenant_id: User’s AAD Tenant Id.
        """
        pulumi.set(__self__, "object_id", object_id)
        pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> pulumi.Input[str]:
        """
        User’s AAD Object Id.
        """
        return pulumi.get(self, "object_id")

    @object_id.setter
    def object_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "object_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        User’s AAD Tenant Id.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)


@pulumi.input_type
class AutoPausePropertiesArgs:
    def __init__(__self__, *,
                 delay_in_minutes: Optional[pulumi.Input[int]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None):
        """
        Auto pause properties
        """
        if delay_in_minutes is not None:
            pulumi.set(__self__, "delay_in_minutes", delay_in_minutes)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter(name="delayInMinutes")
    def delay_in_minutes(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "delay_in_minutes")

    @delay_in_minutes.setter
    def delay_in_minutes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "delay_in_minutes", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class AutoScalePropertiesArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 max_node_count: Optional[pulumi.Input[int]] = None,
                 min_node_count: Optional[pulumi.Input[int]] = None):
        """
        Auto scale properties
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if max_node_count is not None:
            pulumi.set(__self__, "max_node_count", max_node_count)
        if min_node_count is not None:
            pulumi.set(__self__, "min_node_count", min_node_count)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="maxNodeCount")
    def max_node_count(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "max_node_count")

    @max_node_count.setter
    def max_node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_node_count", value)

    @property
    @pulumi.getter(name="minNodeCount")
    def min_node_count(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "min_node_count")

    @min_node_count.setter
    def min_node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_node_count", value)


@pulumi.input_type
class ComputeInstancePropertiesArgs:
    def __init__(__self__, *,
                 application_sharing_policy: Optional[pulumi.Input[Union[str, 'ApplicationSharingPolicy']]] = None,
                 compute_instance_authorization_type: Optional[pulumi.Input[Union[str, 'ComputeInstanceAuthorizationType']]] = None,
                 personal_compute_instance_settings: Optional[pulumi.Input['PersonalComputeInstanceSettingsArgs']] = None,
                 setup_scripts: Optional[pulumi.Input['SetupScriptsArgs']] = None,
                 ssh_settings: Optional[pulumi.Input['ComputeInstanceSshSettingsArgs']] = None,
                 subnet: Optional[pulumi.Input['ResourceIdArgs']] = None,
                 vm_size: Optional[pulumi.Input[str]] = None):
        """
        Compute Instance properties
        :param pulumi.Input[Union[str, 'ApplicationSharingPolicy']] application_sharing_policy: Policy for sharing applications on this compute instance among users of parent workspace. If Personal, only the creator can access applications on this compute instance. When Shared, any workspace user can access applications on this instance depending on his/her assigned role.
        :param pulumi.Input[Union[str, 'ComputeInstanceAuthorizationType']] compute_instance_authorization_type: The Compute Instance Authorization type. Available values are personal (default).
        :param pulumi.Input['PersonalComputeInstanceSettingsArgs'] personal_compute_instance_settings: Settings for a personal compute instance.
        :param pulumi.Input['SetupScriptsArgs'] setup_scripts: Details of customized scripts to execute for setting up the cluster.
        :param pulumi.Input['ComputeInstanceSshSettingsArgs'] ssh_settings: Specifies policy and settings for SSH access.
        :param pulumi.Input['ResourceIdArgs'] subnet: Virtual network subnet resource ID the compute nodes belong to.
        :param pulumi.Input[str] vm_size: Virtual Machine Size
        """
        if application_sharing_policy is None:
            application_sharing_policy = 'Shared'
        if application_sharing_policy is not None:
            pulumi.set(__self__, "application_sharing_policy", application_sharing_policy)
        if compute_instance_authorization_type is None:
            compute_instance_authorization_type = 'personal'
        if compute_instance_authorization_type is not None:
            pulumi.set(__self__, "compute_instance_authorization_type", compute_instance_authorization_type)
        if personal_compute_instance_settings is not None:
            pulumi.set(__self__, "personal_compute_instance_settings", personal_compute_instance_settings)
        if setup_scripts is not None:
            pulumi.set(__self__, "setup_scripts", setup_scripts)
        if ssh_settings is not None:
            pulumi.set(__self__, "ssh_settings", ssh_settings)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)
        if vm_size is not None:
            pulumi.set(__self__, "vm_size", vm_size)

    @property
    @pulumi.getter(name="applicationSharingPolicy")
    def application_sharing_policy(self) -> Optional[pulumi.Input[Union[str, 'ApplicationSharingPolicy']]]:
        """
        Policy for sharing applications on this compute instance among users of parent workspace. If Personal, only the creator can access applications on this compute instance. When Shared, any workspace user can access applications on this instance depending on his/her assigned role.
        """
        return pulumi.get(self, "application_sharing_policy")

    @application_sharing_policy.setter
    def application_sharing_policy(self, value: Optional[pulumi.Input[Union[str, 'ApplicationSharingPolicy']]]):
        pulumi.set(self, "application_sharing_policy", value)

    @property
    @pulumi.getter(name="computeInstanceAuthorizationType")
    def compute_instance_authorization_type(self) -> Optional[pulumi.Input[Union[str, 'ComputeInstanceAuthorizationType']]]:
        """
        The Compute Instance Authorization type. Available values are personal (default).
        """
        return pulumi.get(self, "compute_instance_authorization_type")

    @compute_instance_authorization_type.setter
    def compute_instance_authorization_type(self, value: Optional[pulumi.Input[Union[str, 'ComputeInstanceAuthorizationType']]]):
        pulumi.set(self, "compute_instance_authorization_type", value)

    @property
    @pulumi.getter(name="personalComputeInstanceSettings")
    def personal_compute_instance_settings(self) -> Optional[pulumi.Input['PersonalComputeInstanceSettingsArgs']]:
        """
        Settings for a personal compute instance.
        """
        return pulumi.get(self, "personal_compute_instance_settings")

    @personal_compute_instance_settings.setter
    def personal_compute_instance_settings(self, value: Optional[pulumi.Input['PersonalComputeInstanceSettingsArgs']]):
        pulumi.set(self, "personal_compute_instance_settings", value)

    @property
    @pulumi.getter(name="setupScripts")
    def setup_scripts(self) -> Optional[pulumi.Input['SetupScriptsArgs']]:
        """
        Details of customized scripts to execute for setting up the cluster.
        """
        return pulumi.get(self, "setup_scripts")

    @setup_scripts.setter
    def setup_scripts(self, value: Optional[pulumi.Input['SetupScriptsArgs']]):
        pulumi.set(self, "setup_scripts", value)

    @property
    @pulumi.getter(name="sshSettings")
    def ssh_settings(self) -> Optional[pulumi.Input['ComputeInstanceSshSettingsArgs']]:
        """
        Specifies policy and settings for SSH access.
        """
        return pulumi.get(self, "ssh_settings")

    @ssh_settings.setter
    def ssh_settings(self, value: Optional[pulumi.Input['ComputeInstanceSshSettingsArgs']]):
        pulumi.set(self, "ssh_settings", value)

    @property
    @pulumi.getter
    def subnet(self) -> Optional[pulumi.Input['ResourceIdArgs']]:
        """
        Virtual network subnet resource ID the compute nodes belong to.
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: Optional[pulumi.Input['ResourceIdArgs']]):
        pulumi.set(self, "subnet", value)

    @property
    @pulumi.getter(name="vmSize")
    def vm_size(self) -> Optional[pulumi.Input[str]]:
        """
        Virtual Machine Size
        """
        return pulumi.get(self, "vm_size")

    @vm_size.setter
    def vm_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vm_size", value)


@pulumi.input_type
class ComputeInstanceSshSettingsArgs:
    def __init__(__self__, *,
                 admin_public_key: Optional[pulumi.Input[str]] = None,
                 ssh_public_access: Optional[pulumi.Input[Union[str, 'SshPublicAccess']]] = None):
        """
        Specifies policy and settings for SSH access.
        :param pulumi.Input[str] admin_public_key: Specifies the SSH rsa public key file as a string. Use "ssh-keygen -t rsa -b 2048" to generate your SSH key pairs.
        :param pulumi.Input[Union[str, 'SshPublicAccess']] ssh_public_access: State of the public SSH port. Possible values are: Disabled - Indicates that the public ssh port is closed on this instance. Enabled - Indicates that the public ssh port is open and accessible according to the VNet/subnet policy if applicable.
        """
        if admin_public_key is not None:
            pulumi.set(__self__, "admin_public_key", admin_public_key)
        if ssh_public_access is None:
            ssh_public_access = 'Disabled'
        if ssh_public_access is not None:
            pulumi.set(__self__, "ssh_public_access", ssh_public_access)

    @property
    @pulumi.getter(name="adminPublicKey")
    def admin_public_key(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the SSH rsa public key file as a string. Use "ssh-keygen -t rsa -b 2048" to generate your SSH key pairs.
        """
        return pulumi.get(self, "admin_public_key")

    @admin_public_key.setter
    def admin_public_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_public_key", value)

    @property
    @pulumi.getter(name="sshPublicAccess")
    def ssh_public_access(self) -> Optional[pulumi.Input[Union[str, 'SshPublicAccess']]]:
        """
        State of the public SSH port. Possible values are: Disabled - Indicates that the public ssh port is closed on this instance. Enabled - Indicates that the public ssh port is open and accessible according to the VNet/subnet policy if applicable.
        """
        return pulumi.get(self, "ssh_public_access")

    @ssh_public_access.setter
    def ssh_public_access(self, value: Optional[pulumi.Input[Union[str, 'SshPublicAccess']]]):
        pulumi.set(self, "ssh_public_access", value)


@pulumi.input_type
class ComputeInstanceArgs:
    def __init__(__self__, *,
                 compute_type: pulumi.Input[str],
                 compute_location: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disable_local_auth: Optional[pulumi.Input[bool]] = None,
                 properties: Optional[pulumi.Input['ComputeInstancePropertiesArgs']] = None,
                 resource_id: Optional[pulumi.Input[str]] = None):
        """
        An Azure Machine Learning compute instance.
        :param pulumi.Input[str] compute_type: The type of compute
               Expected value is 'ComputeInstance'.
        :param pulumi.Input[str] compute_location: Location for the underlying compute
        :param pulumi.Input[str] description: The description of the Machine Learning compute.
        :param pulumi.Input[bool] disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        :param pulumi.Input['ComputeInstancePropertiesArgs'] properties: Properties of ComputeInstance
        :param pulumi.Input[str] resource_id: ARM resource id of the underlying compute
        """
        pulumi.set(__self__, "compute_type", 'ComputeInstance')
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_local_auth is not None:
            pulumi.set(__self__, "disable_local_auth", disable_local_auth)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> pulumi.Input[str]:
        """
        The type of compute
        Expected value is 'ComputeInstance'.
        """
        return pulumi.get(self, "compute_type")

    @compute_type.setter
    def compute_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "compute_type", value)

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[pulumi.Input[str]]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @compute_location.setter
    def compute_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compute_location", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="disableLocalAuth")
    def disable_local_auth(self) -> Optional[pulumi.Input[bool]]:
        """
        Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        """
        return pulumi.get(self, "disable_local_auth")

    @disable_local_auth.setter
    def disable_local_auth(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_local_auth", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['ComputeInstancePropertiesArgs']]:
        """
        Properties of ComputeInstance
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['ComputeInstancePropertiesArgs']]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource id of the underlying compute
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)


@pulumi.input_type
class CosmosDbSettingsArgs:
    def __init__(__self__, *,
                 collections_throughput: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] collections_throughput: The throughput of the collections in cosmosdb database
        """
        if collections_throughput is not None:
            pulumi.set(__self__, "collections_throughput", collections_throughput)

    @property
    @pulumi.getter(name="collectionsThroughput")
    def collections_throughput(self) -> Optional[pulumi.Input[int]]:
        """
        The throughput of the collections in cosmosdb database
        """
        return pulumi.get(self, "collections_throughput")

    @collections_throughput.setter
    def collections_throughput(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "collections_throughput", value)


@pulumi.input_type
class DataFactoryArgs:
    def __init__(__self__, *,
                 compute_type: pulumi.Input[str],
                 compute_location: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disable_local_auth: Optional[pulumi.Input[bool]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None):
        """
        A DataFactory compute.
        :param pulumi.Input[str] compute_type: The type of compute
               Expected value is 'DataFactory'.
        :param pulumi.Input[str] compute_location: Location for the underlying compute
        :param pulumi.Input[str] description: The description of the Machine Learning compute.
        :param pulumi.Input[bool] disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        :param pulumi.Input[str] resource_id: ARM resource id of the underlying compute
        """
        pulumi.set(__self__, "compute_type", 'DataFactory')
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_local_auth is not None:
            pulumi.set(__self__, "disable_local_auth", disable_local_auth)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> pulumi.Input[str]:
        """
        The type of compute
        Expected value is 'DataFactory'.
        """
        return pulumi.get(self, "compute_type")

    @compute_type.setter
    def compute_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "compute_type", value)

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[pulumi.Input[str]]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @compute_location.setter
    def compute_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compute_location", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="disableLocalAuth")
    def disable_local_auth(self) -> Optional[pulumi.Input[bool]]:
        """
        Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        """
        return pulumi.get(self, "disable_local_auth")

    @disable_local_auth.setter
    def disable_local_auth(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_local_auth", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource id of the underlying compute
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)


@pulumi.input_type
class DataLakeAnalyticsPropertiesArgs:
    def __init__(__self__, *,
                 data_lake_store_account_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] data_lake_store_account_name: DataLake Store Account Name
        """
        if data_lake_store_account_name is not None:
            pulumi.set(__self__, "data_lake_store_account_name", data_lake_store_account_name)

    @property
    @pulumi.getter(name="dataLakeStoreAccountName")
    def data_lake_store_account_name(self) -> Optional[pulumi.Input[str]]:
        """
        DataLake Store Account Name
        """
        return pulumi.get(self, "data_lake_store_account_name")

    @data_lake_store_account_name.setter
    def data_lake_store_account_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_lake_store_account_name", value)


@pulumi.input_type
class DataLakeAnalyticsArgs:
    def __init__(__self__, *,
                 compute_type: pulumi.Input[str],
                 compute_location: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disable_local_auth: Optional[pulumi.Input[bool]] = None,
                 properties: Optional[pulumi.Input['DataLakeAnalyticsPropertiesArgs']] = None,
                 resource_id: Optional[pulumi.Input[str]] = None):
        """
        A DataLakeAnalytics compute.
        :param pulumi.Input[str] compute_type: The type of compute
               Expected value is 'DataLakeAnalytics'.
        :param pulumi.Input[str] compute_location: Location for the underlying compute
        :param pulumi.Input[str] description: The description of the Machine Learning compute.
        :param pulumi.Input[bool] disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        :param pulumi.Input[str] resource_id: ARM resource id of the underlying compute
        """
        pulumi.set(__self__, "compute_type", 'DataLakeAnalytics')
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_local_auth is not None:
            pulumi.set(__self__, "disable_local_auth", disable_local_auth)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> pulumi.Input[str]:
        """
        The type of compute
        Expected value is 'DataLakeAnalytics'.
        """
        return pulumi.get(self, "compute_type")

    @compute_type.setter
    def compute_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "compute_type", value)

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[pulumi.Input[str]]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @compute_location.setter
    def compute_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compute_location", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="disableLocalAuth")
    def disable_local_auth(self) -> Optional[pulumi.Input[bool]]:
        """
        Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        """
        return pulumi.get(self, "disable_local_auth")

    @disable_local_auth.setter
    def disable_local_auth(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_local_auth", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['DataLakeAnalyticsPropertiesArgs']]:
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['DataLakeAnalyticsPropertiesArgs']]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource id of the underlying compute
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)


@pulumi.input_type
class DatabricksPropertiesArgs:
    def __init__(__self__, *,
                 databricks_access_token: Optional[pulumi.Input[str]] = None,
                 workspace_url: Optional[pulumi.Input[str]] = None):
        """
        Properties of Databricks
        :param pulumi.Input[str] databricks_access_token: Databricks access token
        :param pulumi.Input[str] workspace_url: Workspace Url
        """
        if databricks_access_token is not None:
            pulumi.set(__self__, "databricks_access_token", databricks_access_token)
        if workspace_url is not None:
            pulumi.set(__self__, "workspace_url", workspace_url)

    @property
    @pulumi.getter(name="databricksAccessToken")
    def databricks_access_token(self) -> Optional[pulumi.Input[str]]:
        """
        Databricks access token
        """
        return pulumi.get(self, "databricks_access_token")

    @databricks_access_token.setter
    def databricks_access_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "databricks_access_token", value)

    @property
    @pulumi.getter(name="workspaceUrl")
    def workspace_url(self) -> Optional[pulumi.Input[str]]:
        """
        Workspace Url
        """
        return pulumi.get(self, "workspace_url")

    @workspace_url.setter
    def workspace_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "workspace_url", value)


@pulumi.input_type
class DatabricksArgs:
    def __init__(__self__, *,
                 compute_type: pulumi.Input[str],
                 compute_location: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disable_local_auth: Optional[pulumi.Input[bool]] = None,
                 properties: Optional[pulumi.Input['DatabricksPropertiesArgs']] = None,
                 resource_id: Optional[pulumi.Input[str]] = None):
        """
        A DataFactory compute.
        :param pulumi.Input[str] compute_type: The type of compute
               Expected value is 'Databricks'.
        :param pulumi.Input[str] compute_location: Location for the underlying compute
        :param pulumi.Input[str] description: The description of the Machine Learning compute.
        :param pulumi.Input[bool] disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        :param pulumi.Input['DatabricksPropertiesArgs'] properties: Properties of Databricks
        :param pulumi.Input[str] resource_id: ARM resource id of the underlying compute
        """
        pulumi.set(__self__, "compute_type", 'Databricks')
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_local_auth is not None:
            pulumi.set(__self__, "disable_local_auth", disable_local_auth)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> pulumi.Input[str]:
        """
        The type of compute
        Expected value is 'Databricks'.
        """
        return pulumi.get(self, "compute_type")

    @compute_type.setter
    def compute_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "compute_type", value)

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[pulumi.Input[str]]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @compute_location.setter
    def compute_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compute_location", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="disableLocalAuth")
    def disable_local_auth(self) -> Optional[pulumi.Input[bool]]:
        """
        Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        """
        return pulumi.get(self, "disable_local_auth")

    @disable_local_auth.setter
    def disable_local_auth(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_local_auth", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['DatabricksPropertiesArgs']]:
        """
        Properties of Databricks
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['DatabricksPropertiesArgs']]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource id of the underlying compute
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)


@pulumi.input_type
class EncryptionPropertyArgs:
    def __init__(__self__, *,
                 key_vault_properties: pulumi.Input['KeyVaultPropertiesArgs'],
                 status: pulumi.Input[Union[str, 'EncryptionStatus']],
                 identity: Optional[pulumi.Input['IdentityForCmkArgs']] = None):
        """
        :param pulumi.Input['KeyVaultPropertiesArgs'] key_vault_properties: Customer Key vault properties.
        :param pulumi.Input[Union[str, 'EncryptionStatus']] status: Indicates whether or not the encryption is enabled for the workspace.
        :param pulumi.Input['IdentityForCmkArgs'] identity: The identity that will be used to access the key vault for encryption at rest.
        """
        pulumi.set(__self__, "key_vault_properties", key_vault_properties)
        pulumi.set(__self__, "status", status)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)

    @property
    @pulumi.getter(name="keyVaultProperties")
    def key_vault_properties(self) -> pulumi.Input['KeyVaultPropertiesArgs']:
        """
        Customer Key vault properties.
        """
        return pulumi.get(self, "key_vault_properties")

    @key_vault_properties.setter
    def key_vault_properties(self, value: pulumi.Input['KeyVaultPropertiesArgs']):
        pulumi.set(self, "key_vault_properties", value)

    @property
    @pulumi.getter
    def status(self) -> pulumi.Input[Union[str, 'EncryptionStatus']]:
        """
        Indicates whether or not the encryption is enabled for the workspace.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: pulumi.Input[Union[str, 'EncryptionStatus']]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['IdentityForCmkArgs']]:
        """
        The identity that will be used to access the key vault for encryption at rest.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['IdentityForCmkArgs']]):
        pulumi.set(self, "identity", value)


@pulumi.input_type
class HDInsightPropertiesArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[str]] = None,
                 administrator_account: Optional[pulumi.Input['VirtualMachineSshCredentialsArgs']] = None,
                 ssh_port: Optional[pulumi.Input[int]] = None):
        """
        HDInsight compute properties
        :param pulumi.Input[str] address: Public IP address of the master node of the cluster.
        :param pulumi.Input['VirtualMachineSshCredentialsArgs'] administrator_account: Admin credentials for master node of the cluster
        :param pulumi.Input[int] ssh_port: Port open for ssh connections on the master node of the cluster.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if administrator_account is not None:
            pulumi.set(__self__, "administrator_account", administrator_account)
        if ssh_port is not None:
            pulumi.set(__self__, "ssh_port", ssh_port)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[str]]:
        """
        Public IP address of the master node of the cluster.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter(name="administratorAccount")
    def administrator_account(self) -> Optional[pulumi.Input['VirtualMachineSshCredentialsArgs']]:
        """
        Admin credentials for master node of the cluster
        """
        return pulumi.get(self, "administrator_account")

    @administrator_account.setter
    def administrator_account(self, value: Optional[pulumi.Input['VirtualMachineSshCredentialsArgs']]):
        pulumi.set(self, "administrator_account", value)

    @property
    @pulumi.getter(name="sshPort")
    def ssh_port(self) -> Optional[pulumi.Input[int]]:
        """
        Port open for ssh connections on the master node of the cluster.
        """
        return pulumi.get(self, "ssh_port")

    @ssh_port.setter
    def ssh_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ssh_port", value)


@pulumi.input_type
class HDInsightArgs:
    def __init__(__self__, *,
                 compute_type: pulumi.Input[str],
                 compute_location: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disable_local_auth: Optional[pulumi.Input[bool]] = None,
                 properties: Optional[pulumi.Input['HDInsightPropertiesArgs']] = None,
                 resource_id: Optional[pulumi.Input[str]] = None):
        """
        A HDInsight compute.
        :param pulumi.Input[str] compute_type: The type of compute
               Expected value is 'HDInsight'.
        :param pulumi.Input[str] compute_location: Location for the underlying compute
        :param pulumi.Input[str] description: The description of the Machine Learning compute.
        :param pulumi.Input[bool] disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        :param pulumi.Input['HDInsightPropertiesArgs'] properties: HDInsight compute properties
        :param pulumi.Input[str] resource_id: ARM resource id of the underlying compute
        """
        pulumi.set(__self__, "compute_type", 'HDInsight')
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_local_auth is not None:
            pulumi.set(__self__, "disable_local_auth", disable_local_auth)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> pulumi.Input[str]:
        """
        The type of compute
        Expected value is 'HDInsight'.
        """
        return pulumi.get(self, "compute_type")

    @compute_type.setter
    def compute_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "compute_type", value)

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[pulumi.Input[str]]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @compute_location.setter
    def compute_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compute_location", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="disableLocalAuth")
    def disable_local_auth(self) -> Optional[pulumi.Input[bool]]:
        """
        Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        """
        return pulumi.get(self, "disable_local_auth")

    @disable_local_auth.setter
    def disable_local_auth(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_local_auth", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['HDInsightPropertiesArgs']]:
        """
        HDInsight compute properties
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['HDInsightPropertiesArgs']]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource id of the underlying compute
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)


@pulumi.input_type
class IdentityForCmkArgs:
    def __init__(__self__, *,
                 user_assigned_identity: Optional[pulumi.Input[str]] = None):
        """
        Identity that will be used to access key vault for encryption at rest
        :param pulumi.Input[str] user_assigned_identity: The ArmId of the user assigned identity that will be used to access the customer managed key vault
        """
        if user_assigned_identity is not None:
            pulumi.set(__self__, "user_assigned_identity", user_assigned_identity)

    @property
    @pulumi.getter(name="userAssignedIdentity")
    def user_assigned_identity(self) -> Optional[pulumi.Input[str]]:
        """
        The ArmId of the user assigned identity that will be used to access the customer managed key vault
        """
        return pulumi.get(self, "user_assigned_identity")

    @user_assigned_identity.setter
    def user_assigned_identity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_assigned_identity", value)


@pulumi.input_type
class IdentityArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input['ResourceIdentityType']] = None,
                 user_assigned_identities: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        Identity for the resource.
        :param pulumi.Input['ResourceIdentityType'] type: The identity type.
        :param pulumi.Input[Mapping[str, Any]] user_assigned_identities: The user assigned identities associated with the resource.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['ResourceIdentityType']]:
        """
        The identity type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['ResourceIdentityType']]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        The user assigned identities associated with the resource.
        """
        return pulumi.get(self, "user_assigned_identities")

    @user_assigned_identities.setter
    def user_assigned_identities(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "user_assigned_identities", value)


@pulumi.input_type
class InstanceTypeSchemaResourcesArgs:
    def __init__(__self__, *,
                 limits: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 requests: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Resource requests/limits for this instance type
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] limits: Resource limits for this instance type
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] requests: Resource requests for this instance type
        """
        if limits is not None:
            pulumi.set(__self__, "limits", limits)
        if requests is not None:
            pulumi.set(__self__, "requests", requests)

    @property
    @pulumi.getter
    def limits(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Resource limits for this instance type
        """
        return pulumi.get(self, "limits")

    @limits.setter
    def limits(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "limits", value)

    @property
    @pulumi.getter
    def requests(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Resource requests for this instance type
        """
        return pulumi.get(self, "requests")

    @requests.setter
    def requests(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "requests", value)


@pulumi.input_type
class InstanceTypeSchemaArgs:
    def __init__(__self__, *,
                 node_selector: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 resources: Optional[pulumi.Input['InstanceTypeSchemaResourcesArgs']] = None):
        """
        Instance type schema.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] node_selector: Node Selector
        :param pulumi.Input['InstanceTypeSchemaResourcesArgs'] resources: Resource requests/limits for this instance type
        """
        if node_selector is not None:
            pulumi.set(__self__, "node_selector", node_selector)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)

    @property
    @pulumi.getter(name="nodeSelector")
    def node_selector(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Node Selector
        """
        return pulumi.get(self, "node_selector")

    @node_selector.setter
    def node_selector(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "node_selector", value)

    @property
    @pulumi.getter
    def resources(self) -> Optional[pulumi.Input['InstanceTypeSchemaResourcesArgs']]:
        """
        Resource requests/limits for this instance type
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: Optional[pulumi.Input['InstanceTypeSchemaResourcesArgs']]):
        pulumi.set(self, "resources", value)


@pulumi.input_type
class KeyVaultPropertiesArgs:
    def __init__(__self__, *,
                 key_identifier: pulumi.Input[str],
                 key_vault_arm_id: pulumi.Input[str],
                 identity_client_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] key_identifier: Key vault uri to access the encryption key.
        :param pulumi.Input[str] key_vault_arm_id: The ArmId of the keyVault where the customer owned encryption key is present.
        :param pulumi.Input[str] identity_client_id: For future use - The client id of the identity which will be used to access key vault.
        """
        pulumi.set(__self__, "key_identifier", key_identifier)
        pulumi.set(__self__, "key_vault_arm_id", key_vault_arm_id)
        if identity_client_id is not None:
            pulumi.set(__self__, "identity_client_id", identity_client_id)

    @property
    @pulumi.getter(name="keyIdentifier")
    def key_identifier(self) -> pulumi.Input[str]:
        """
        Key vault uri to access the encryption key.
        """
        return pulumi.get(self, "key_identifier")

    @key_identifier.setter
    def key_identifier(self, value: pulumi.Input[str]):
        pulumi.set(self, "key_identifier", value)

    @property
    @pulumi.getter(name="keyVaultArmId")
    def key_vault_arm_id(self) -> pulumi.Input[str]:
        """
        The ArmId of the keyVault where the customer owned encryption key is present.
        """
        return pulumi.get(self, "key_vault_arm_id")

    @key_vault_arm_id.setter
    def key_vault_arm_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "key_vault_arm_id", value)

    @property
    @pulumi.getter(name="identityClientId")
    def identity_client_id(self) -> Optional[pulumi.Input[str]]:
        """
        For future use - The client id of the identity which will be used to access key vault.
        """
        return pulumi.get(self, "identity_client_id")

    @identity_client_id.setter
    def identity_client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identity_client_id", value)


@pulumi.input_type
class KubernetesPropertiesArgs:
    def __init__(__self__, *,
                 default_instance_type: Optional[pulumi.Input[str]] = None,
                 extension_instance_release_train: Optional[pulumi.Input[str]] = None,
                 extension_principal_id: Optional[pulumi.Input[str]] = None,
                 instance_types: Optional[pulumi.Input[Mapping[str, pulumi.Input['InstanceTypeSchemaArgs']]]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 relay_connection_string: Optional[pulumi.Input[str]] = None,
                 service_bus_connection_string: Optional[pulumi.Input[str]] = None,
                 vc_name: Optional[pulumi.Input[str]] = None):
        """
        Kubernetes properties
        :param pulumi.Input[str] default_instance_type: Default instance type
        :param pulumi.Input[str] extension_instance_release_train: Extension instance release train.
        :param pulumi.Input[str] extension_principal_id: Extension principal-id.
        :param pulumi.Input[Mapping[str, pulumi.Input['InstanceTypeSchemaArgs']]] instance_types: Instance Type Schema
        :param pulumi.Input[str] namespace: Compute namespace
        :param pulumi.Input[str] relay_connection_string: Relay connection string.
        :param pulumi.Input[str] service_bus_connection_string: ServiceBus connection string.
        :param pulumi.Input[str] vc_name: VC name.
        """
        if default_instance_type is not None:
            pulumi.set(__self__, "default_instance_type", default_instance_type)
        if extension_instance_release_train is not None:
            pulumi.set(__self__, "extension_instance_release_train", extension_instance_release_train)
        if extension_principal_id is not None:
            pulumi.set(__self__, "extension_principal_id", extension_principal_id)
        if instance_types is not None:
            pulumi.set(__self__, "instance_types", instance_types)
        if namespace is None:
            namespace = 'default'
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if relay_connection_string is not None:
            pulumi.set(__self__, "relay_connection_string", relay_connection_string)
        if service_bus_connection_string is not None:
            pulumi.set(__self__, "service_bus_connection_string", service_bus_connection_string)
        if vc_name is not None:
            pulumi.set(__self__, "vc_name", vc_name)

    @property
    @pulumi.getter(name="defaultInstanceType")
    def default_instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        Default instance type
        """
        return pulumi.get(self, "default_instance_type")

    @default_instance_type.setter
    def default_instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_instance_type", value)

    @property
    @pulumi.getter(name="extensionInstanceReleaseTrain")
    def extension_instance_release_train(self) -> Optional[pulumi.Input[str]]:
        """
        Extension instance release train.
        """
        return pulumi.get(self, "extension_instance_release_train")

    @extension_instance_release_train.setter
    def extension_instance_release_train(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "extension_instance_release_train", value)

    @property
    @pulumi.getter(name="extensionPrincipalId")
    def extension_principal_id(self) -> Optional[pulumi.Input[str]]:
        """
        Extension principal-id.
        """
        return pulumi.get(self, "extension_principal_id")

    @extension_principal_id.setter
    def extension_principal_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "extension_principal_id", value)

    @property
    @pulumi.getter(name="instanceTypes")
    def instance_types(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['InstanceTypeSchemaArgs']]]]:
        """
        Instance Type Schema
        """
        return pulumi.get(self, "instance_types")

    @instance_types.setter
    def instance_types(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['InstanceTypeSchemaArgs']]]]):
        pulumi.set(self, "instance_types", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        Compute namespace
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="relayConnectionString")
    def relay_connection_string(self) -> Optional[pulumi.Input[str]]:
        """
        Relay connection string.
        """
        return pulumi.get(self, "relay_connection_string")

    @relay_connection_string.setter
    def relay_connection_string(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "relay_connection_string", value)

    @property
    @pulumi.getter(name="serviceBusConnectionString")
    def service_bus_connection_string(self) -> Optional[pulumi.Input[str]]:
        """
        ServiceBus connection string.
        """
        return pulumi.get(self, "service_bus_connection_string")

    @service_bus_connection_string.setter
    def service_bus_connection_string(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_bus_connection_string", value)

    @property
    @pulumi.getter(name="vcName")
    def vc_name(self) -> Optional[pulumi.Input[str]]:
        """
        VC name.
        """
        return pulumi.get(self, "vc_name")

    @vc_name.setter
    def vc_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vc_name", value)


@pulumi.input_type
class KubernetesArgs:
    def __init__(__self__, *,
                 compute_type: pulumi.Input[str],
                 compute_location: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disable_local_auth: Optional[pulumi.Input[bool]] = None,
                 properties: Optional[pulumi.Input['KubernetesPropertiesArgs']] = None,
                 resource_id: Optional[pulumi.Input[str]] = None):
        """
        A Machine Learning compute based on Kubernetes Compute.
        :param pulumi.Input[str] compute_type: The type of compute
               Expected value is 'Kubernetes'.
        :param pulumi.Input[str] compute_location: Location for the underlying compute
        :param pulumi.Input[str] description: The description of the Machine Learning compute.
        :param pulumi.Input[bool] disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        :param pulumi.Input['KubernetesPropertiesArgs'] properties: Properties of Kubernetes
        :param pulumi.Input[str] resource_id: ARM resource id of the underlying compute
        """
        pulumi.set(__self__, "compute_type", 'Kubernetes')
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_local_auth is not None:
            pulumi.set(__self__, "disable_local_auth", disable_local_auth)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> pulumi.Input[str]:
        """
        The type of compute
        Expected value is 'Kubernetes'.
        """
        return pulumi.get(self, "compute_type")

    @compute_type.setter
    def compute_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "compute_type", value)

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[pulumi.Input[str]]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @compute_location.setter
    def compute_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compute_location", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="disableLocalAuth")
    def disable_local_auth(self) -> Optional[pulumi.Input[bool]]:
        """
        Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        """
        return pulumi.get(self, "disable_local_auth")

    @disable_local_auth.setter
    def disable_local_auth(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_local_auth", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['KubernetesPropertiesArgs']]:
        """
        Properties of Kubernetes
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['KubernetesPropertiesArgs']]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource id of the underlying compute
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)


@pulumi.input_type
class PersonalComputeInstanceSettingsArgs:
    def __init__(__self__, *,
                 assigned_user: Optional[pulumi.Input['AssignedUserArgs']] = None):
        """
        Settings for a personal compute instance.
        :param pulumi.Input['AssignedUserArgs'] assigned_user: A user explicitly assigned to a personal compute instance.
        """
        if assigned_user is not None:
            pulumi.set(__self__, "assigned_user", assigned_user)

    @property
    @pulumi.getter(name="assignedUser")
    def assigned_user(self) -> Optional[pulumi.Input['AssignedUserArgs']]:
        """
        A user explicitly assigned to a personal compute instance.
        """
        return pulumi.get(self, "assigned_user")

    @assigned_user.setter
    def assigned_user(self, value: Optional[pulumi.Input['AssignedUserArgs']]):
        pulumi.set(self, "assigned_user", value)


@pulumi.input_type
class PrivateLinkServiceConnectionStateArgs:
    def __init__(__self__, *,
                 actions_required: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[Union[str, 'PrivateEndpointServiceConnectionStatus']]] = None):
        """
        A collection of information about the state of the connection between service consumer and provider.
        :param pulumi.Input[str] actions_required: A message indicating if changes on the service provider require any updates on the consumer.
        :param pulumi.Input[str] description: The reason for approval/rejection of the connection.
        :param pulumi.Input[Union[str, 'PrivateEndpointServiceConnectionStatus']] status: Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
        """
        if actions_required is not None:
            pulumi.set(__self__, "actions_required", actions_required)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="actionsRequired")
    def actions_required(self) -> Optional[pulumi.Input[str]]:
        """
        A message indicating if changes on the service provider require any updates on the consumer.
        """
        return pulumi.get(self, "actions_required")

    @actions_required.setter
    def actions_required(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "actions_required", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The reason for approval/rejection of the connection.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[Union[str, 'PrivateEndpointServiceConnectionStatus']]]:
        """
        Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[Union[str, 'PrivateEndpointServiceConnectionStatus']]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class ResourceIdArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str]):
        """
        Represents a resource ID. For example, for a subnet, it is the resource URL for the subnet.
        :param pulumi.Input[str] id: The ID of the resource
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        The ID of the resource
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class ScaleSettingsArgs:
    def __init__(__self__, *,
                 max_node_count: pulumi.Input[int],
                 min_node_count: Optional[pulumi.Input[int]] = None,
                 node_idle_time_before_scale_down: Optional[pulumi.Input[str]] = None):
        """
        scale settings for AML Compute
        :param pulumi.Input[int] max_node_count: Max number of nodes to use
        :param pulumi.Input[int] min_node_count: Min number of nodes to use
        :param pulumi.Input[str] node_idle_time_before_scale_down: Node Idle Time before scaling down amlCompute. This string needs to be in the RFC Format.
        """
        pulumi.set(__self__, "max_node_count", max_node_count)
        if min_node_count is None:
            min_node_count = 0
        if min_node_count is not None:
            pulumi.set(__self__, "min_node_count", min_node_count)
        if node_idle_time_before_scale_down is not None:
            pulumi.set(__self__, "node_idle_time_before_scale_down", node_idle_time_before_scale_down)

    @property
    @pulumi.getter(name="maxNodeCount")
    def max_node_count(self) -> pulumi.Input[int]:
        """
        Max number of nodes to use
        """
        return pulumi.get(self, "max_node_count")

    @max_node_count.setter
    def max_node_count(self, value: pulumi.Input[int]):
        pulumi.set(self, "max_node_count", value)

    @property
    @pulumi.getter(name="minNodeCount")
    def min_node_count(self) -> Optional[pulumi.Input[int]]:
        """
        Min number of nodes to use
        """
        return pulumi.get(self, "min_node_count")

    @min_node_count.setter
    def min_node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_node_count", value)

    @property
    @pulumi.getter(name="nodeIdleTimeBeforeScaleDown")
    def node_idle_time_before_scale_down(self) -> Optional[pulumi.Input[str]]:
        """
        Node Idle Time before scaling down amlCompute. This string needs to be in the RFC Format.
        """
        return pulumi.get(self, "node_idle_time_before_scale_down")

    @node_idle_time_before_scale_down.setter
    def node_idle_time_before_scale_down(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_idle_time_before_scale_down", value)


@pulumi.input_type
class ScriptReferenceArgs:
    def __init__(__self__, *,
                 script_arguments: Optional[pulumi.Input[str]] = None,
                 script_data: Optional[pulumi.Input[str]] = None,
                 script_source: Optional[pulumi.Input[str]] = None,
                 timeout: Optional[pulumi.Input[str]] = None):
        """
        Script reference
        :param pulumi.Input[str] script_arguments: Optional command line arguments passed to the script to run.
        :param pulumi.Input[str] script_data: The location of scripts in the mounted volume.
        :param pulumi.Input[str] script_source: The storage source of the script: inline, workspace.
        :param pulumi.Input[str] timeout: Optional time period passed to timeout command.
        """
        if script_arguments is not None:
            pulumi.set(__self__, "script_arguments", script_arguments)
        if script_data is not None:
            pulumi.set(__self__, "script_data", script_data)
        if script_source is not None:
            pulumi.set(__self__, "script_source", script_source)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter(name="scriptArguments")
    def script_arguments(self) -> Optional[pulumi.Input[str]]:
        """
        Optional command line arguments passed to the script to run.
        """
        return pulumi.get(self, "script_arguments")

    @script_arguments.setter
    def script_arguments(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "script_arguments", value)

    @property
    @pulumi.getter(name="scriptData")
    def script_data(self) -> Optional[pulumi.Input[str]]:
        """
        The location of scripts in the mounted volume.
        """
        return pulumi.get(self, "script_data")

    @script_data.setter
    def script_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "script_data", value)

    @property
    @pulumi.getter(name="scriptSource")
    def script_source(self) -> Optional[pulumi.Input[str]]:
        """
        The storage source of the script: inline, workspace.
        """
        return pulumi.get(self, "script_source")

    @script_source.setter
    def script_source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "script_source", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[str]]:
        """
        Optional time period passed to timeout command.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timeout", value)


@pulumi.input_type
class ScriptsToExecuteArgs:
    def __init__(__self__, *,
                 creation_script: Optional[pulumi.Input['ScriptReferenceArgs']] = None,
                 startup_script: Optional[pulumi.Input['ScriptReferenceArgs']] = None):
        """
        Customized setup scripts
        :param pulumi.Input['ScriptReferenceArgs'] creation_script: Script that's run only once during provision of the compute.
        :param pulumi.Input['ScriptReferenceArgs'] startup_script: Script that's run every time the machine starts.
        """
        if creation_script is not None:
            pulumi.set(__self__, "creation_script", creation_script)
        if startup_script is not None:
            pulumi.set(__self__, "startup_script", startup_script)

    @property
    @pulumi.getter(name="creationScript")
    def creation_script(self) -> Optional[pulumi.Input['ScriptReferenceArgs']]:
        """
        Script that's run only once during provision of the compute.
        """
        return pulumi.get(self, "creation_script")

    @creation_script.setter
    def creation_script(self, value: Optional[pulumi.Input['ScriptReferenceArgs']]):
        pulumi.set(self, "creation_script", value)

    @property
    @pulumi.getter(name="startupScript")
    def startup_script(self) -> Optional[pulumi.Input['ScriptReferenceArgs']]:
        """
        Script that's run every time the machine starts.
        """
        return pulumi.get(self, "startup_script")

    @startup_script.setter
    def startup_script(self, value: Optional[pulumi.Input['ScriptReferenceArgs']]):
        pulumi.set(self, "startup_script", value)


@pulumi.input_type
class ServiceManagedResourcesSettingsArgs:
    def __init__(__self__, *,
                 cosmos_db: Optional[pulumi.Input['CosmosDbSettingsArgs']] = None):
        """
        :param pulumi.Input['CosmosDbSettingsArgs'] cosmos_db: The settings for the service managed cosmosdb account.
        """
        if cosmos_db is not None:
            pulumi.set(__self__, "cosmos_db", cosmos_db)

    @property
    @pulumi.getter(name="cosmosDb")
    def cosmos_db(self) -> Optional[pulumi.Input['CosmosDbSettingsArgs']]:
        """
        The settings for the service managed cosmosdb account.
        """
        return pulumi.get(self, "cosmos_db")

    @cosmos_db.setter
    def cosmos_db(self, value: Optional[pulumi.Input['CosmosDbSettingsArgs']]):
        pulumi.set(self, "cosmos_db", value)


@pulumi.input_type
class SetupScriptsArgs:
    def __init__(__self__, *,
                 scripts: Optional[pulumi.Input['ScriptsToExecuteArgs']] = None):
        """
        Details of customized scripts to execute for setting up the cluster.
        :param pulumi.Input['ScriptsToExecuteArgs'] scripts: Customized setup scripts
        """
        if scripts is not None:
            pulumi.set(__self__, "scripts", scripts)

    @property
    @pulumi.getter
    def scripts(self) -> Optional[pulumi.Input['ScriptsToExecuteArgs']]:
        """
        Customized setup scripts
        """
        return pulumi.get(self, "scripts")

    @scripts.setter
    def scripts(self, value: Optional[pulumi.Input['ScriptsToExecuteArgs']]):
        pulumi.set(self, "scripts", value)


@pulumi.input_type
class SharedPrivateLinkResourceArgs:
    def __init__(__self__, *,
                 group_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 private_link_resource_id: Optional[pulumi.Input[str]] = None,
                 request_message: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[Union[str, 'PrivateEndpointServiceConnectionStatus']]] = None):
        """
        :param pulumi.Input[str] group_id: The private link resource group id.
        :param pulumi.Input[str] name: Unique name of the private link.
        :param pulumi.Input[str] private_link_resource_id: The resource id that private link links to.
        :param pulumi.Input[str] request_message: Request message.
        :param pulumi.Input[Union[str, 'PrivateEndpointServiceConnectionStatus']] status: Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
        """
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_link_resource_id is not None:
            pulumi.set(__self__, "private_link_resource_id", private_link_resource_id)
        if request_message is not None:
            pulumi.set(__self__, "request_message", request_message)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The private link resource group id.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Unique name of the private link.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="privateLinkResourceId")
    def private_link_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The resource id that private link links to.
        """
        return pulumi.get(self, "private_link_resource_id")

    @private_link_resource_id.setter
    def private_link_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_link_resource_id", value)

    @property
    @pulumi.getter(name="requestMessage")
    def request_message(self) -> Optional[pulumi.Input[str]]:
        """
        Request message.
        """
        return pulumi.get(self, "request_message")

    @request_message.setter
    def request_message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_message", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[Union[str, 'PrivateEndpointServiceConnectionStatus']]]:
        """
        Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[Union[str, 'PrivateEndpointServiceConnectionStatus']]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class SkuArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 tier: Optional[pulumi.Input[str]] = None):
        """
        Sku of the resource
        :param pulumi.Input[str] name: Name of the sku
        :param pulumi.Input[str] tier: Tier of the sku like Basic or Enterprise
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the sku
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tier(self) -> Optional[pulumi.Input[str]]:
        """
        Tier of the sku like Basic or Enterprise
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tier", value)


@pulumi.input_type
class SslConfigurationArgs:
    def __init__(__self__, *,
                 cert: Optional[pulumi.Input[str]] = None,
                 cname: Optional[pulumi.Input[str]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 leaf_domain_label: Optional[pulumi.Input[str]] = None,
                 overwrite_existing_domain: Optional[pulumi.Input[bool]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        The ssl configuration for scoring
        :param pulumi.Input[str] cert: Cert data
        :param pulumi.Input[str] cname: CNAME of the cert
        :param pulumi.Input[str] key: Key data
        :param pulumi.Input[str] leaf_domain_label: Leaf domain label of public endpoint
        :param pulumi.Input[bool] overwrite_existing_domain: Indicates whether to overwrite existing domain label.
        :param pulumi.Input[str] status: Enable or disable ssl for scoring
        """
        if cert is not None:
            pulumi.set(__self__, "cert", cert)
        if cname is not None:
            pulumi.set(__self__, "cname", cname)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if leaf_domain_label is not None:
            pulumi.set(__self__, "leaf_domain_label", leaf_domain_label)
        if overwrite_existing_domain is not None:
            pulumi.set(__self__, "overwrite_existing_domain", overwrite_existing_domain)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def cert(self) -> Optional[pulumi.Input[str]]:
        """
        Cert data
        """
        return pulumi.get(self, "cert")

    @cert.setter
    def cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cert", value)

    @property
    @pulumi.getter
    def cname(self) -> Optional[pulumi.Input[str]]:
        """
        CNAME of the cert
        """
        return pulumi.get(self, "cname")

    @cname.setter
    def cname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cname", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        Key data
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="leafDomainLabel")
    def leaf_domain_label(self) -> Optional[pulumi.Input[str]]:
        """
        Leaf domain label of public endpoint
        """
        return pulumi.get(self, "leaf_domain_label")

    @leaf_domain_label.setter
    def leaf_domain_label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "leaf_domain_label", value)

    @property
    @pulumi.getter(name="overwriteExistingDomain")
    def overwrite_existing_domain(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether to overwrite existing domain label.
        """
        return pulumi.get(self, "overwrite_existing_domain")

    @overwrite_existing_domain.setter
    def overwrite_existing_domain(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "overwrite_existing_domain", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Enable or disable ssl for scoring
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class SynapseSparkPropertiesArgs:
    def __init__(__self__, *,
                 auto_pause_properties: Optional[pulumi.Input['AutoPausePropertiesArgs']] = None,
                 auto_scale_properties: Optional[pulumi.Input['AutoScalePropertiesArgs']] = None,
                 node_count: Optional[pulumi.Input[int]] = None,
                 node_size: Optional[pulumi.Input[str]] = None,
                 node_size_family: Optional[pulumi.Input[str]] = None,
                 pool_name: Optional[pulumi.Input[str]] = None,
                 resource_group: Optional[pulumi.Input[str]] = None,
                 spark_version: Optional[pulumi.Input[str]] = None,
                 subscription_id: Optional[pulumi.Input[str]] = None,
                 workspace_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input['AutoPausePropertiesArgs'] auto_pause_properties: Auto pause properties.
        :param pulumi.Input['AutoScalePropertiesArgs'] auto_scale_properties: Auto scale properties.
        :param pulumi.Input[int] node_count: The number of compute nodes currently assigned to the compute.
        :param pulumi.Input[str] node_size: Node size.
        :param pulumi.Input[str] node_size_family: Node size family.
        :param pulumi.Input[str] pool_name: Pool name.
        :param pulumi.Input[str] resource_group: Name of the resource group in which workspace is located.
        :param pulumi.Input[str] spark_version: Spark version.
        :param pulumi.Input[str] subscription_id: Azure subscription identifier.
        :param pulumi.Input[str] workspace_name: Name of Azure Machine Learning workspace.
        """
        if auto_pause_properties is not None:
            pulumi.set(__self__, "auto_pause_properties", auto_pause_properties)
        if auto_scale_properties is not None:
            pulumi.set(__self__, "auto_scale_properties", auto_scale_properties)
        if node_count is not None:
            pulumi.set(__self__, "node_count", node_count)
        if node_size is not None:
            pulumi.set(__self__, "node_size", node_size)
        if node_size_family is not None:
            pulumi.set(__self__, "node_size_family", node_size_family)
        if pool_name is not None:
            pulumi.set(__self__, "pool_name", pool_name)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if spark_version is not None:
            pulumi.set(__self__, "spark_version", spark_version)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)
        if workspace_name is not None:
            pulumi.set(__self__, "workspace_name", workspace_name)

    @property
    @pulumi.getter(name="autoPauseProperties")
    def auto_pause_properties(self) -> Optional[pulumi.Input['AutoPausePropertiesArgs']]:
        """
        Auto pause properties.
        """
        return pulumi.get(self, "auto_pause_properties")

    @auto_pause_properties.setter
    def auto_pause_properties(self, value: Optional[pulumi.Input['AutoPausePropertiesArgs']]):
        pulumi.set(self, "auto_pause_properties", value)

    @property
    @pulumi.getter(name="autoScaleProperties")
    def auto_scale_properties(self) -> Optional[pulumi.Input['AutoScalePropertiesArgs']]:
        """
        Auto scale properties.
        """
        return pulumi.get(self, "auto_scale_properties")

    @auto_scale_properties.setter
    def auto_scale_properties(self, value: Optional[pulumi.Input['AutoScalePropertiesArgs']]):
        pulumi.set(self, "auto_scale_properties", value)

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of compute nodes currently assigned to the compute.
        """
        return pulumi.get(self, "node_count")

    @node_count.setter
    def node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "node_count", value)

    @property
    @pulumi.getter(name="nodeSize")
    def node_size(self) -> Optional[pulumi.Input[str]]:
        """
        Node size.
        """
        return pulumi.get(self, "node_size")

    @node_size.setter
    def node_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_size", value)

    @property
    @pulumi.getter(name="nodeSizeFamily")
    def node_size_family(self) -> Optional[pulumi.Input[str]]:
        """
        Node size family.
        """
        return pulumi.get(self, "node_size_family")

    @node_size_family.setter
    def node_size_family(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_size_family", value)

    @property
    @pulumi.getter(name="poolName")
    def pool_name(self) -> Optional[pulumi.Input[str]]:
        """
        Pool name.
        """
        return pulumi.get(self, "pool_name")

    @pool_name.setter
    def pool_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pool_name", value)

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the resource group in which workspace is located.
        """
        return pulumi.get(self, "resource_group")

    @resource_group.setter
    def resource_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group", value)

    @property
    @pulumi.getter(name="sparkVersion")
    def spark_version(self) -> Optional[pulumi.Input[str]]:
        """
        Spark version.
        """
        return pulumi.get(self, "spark_version")

    @spark_version.setter
    def spark_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "spark_version", value)

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[pulumi.Input[str]]:
        """
        Azure subscription identifier.
        """
        return pulumi.get(self, "subscription_id")

    @subscription_id.setter
    def subscription_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subscription_id", value)

    @property
    @pulumi.getter(name="workspaceName")
    def workspace_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of Azure Machine Learning workspace.
        """
        return pulumi.get(self, "workspace_name")

    @workspace_name.setter
    def workspace_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "workspace_name", value)


@pulumi.input_type
class SynapseSparkArgs:
    def __init__(__self__, *,
                 compute_type: pulumi.Input[str],
                 compute_location: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disable_local_auth: Optional[pulumi.Input[bool]] = None,
                 properties: Optional[pulumi.Input['SynapseSparkPropertiesArgs']] = None,
                 resource_id: Optional[pulumi.Input[str]] = None):
        """
        A SynapseSpark compute.
        :param pulumi.Input[str] compute_type: The type of compute
               Expected value is 'SynapseSpark'.
        :param pulumi.Input[str] compute_location: Location for the underlying compute
        :param pulumi.Input[str] description: The description of the Machine Learning compute.
        :param pulumi.Input[bool] disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        :param pulumi.Input[str] resource_id: ARM resource id of the underlying compute
        """
        pulumi.set(__self__, "compute_type", 'SynapseSpark')
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_local_auth is not None:
            pulumi.set(__self__, "disable_local_auth", disable_local_auth)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> pulumi.Input[str]:
        """
        The type of compute
        Expected value is 'SynapseSpark'.
        """
        return pulumi.get(self, "compute_type")

    @compute_type.setter
    def compute_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "compute_type", value)

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[pulumi.Input[str]]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @compute_location.setter
    def compute_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compute_location", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="disableLocalAuth")
    def disable_local_auth(self) -> Optional[pulumi.Input[bool]]:
        """
        Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        """
        return pulumi.get(self, "disable_local_auth")

    @disable_local_auth.setter
    def disable_local_auth(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_local_auth", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['SynapseSparkPropertiesArgs']]:
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['SynapseSparkPropertiesArgs']]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource id of the underlying compute
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)


@pulumi.input_type
class UserAccountCredentialsArgs:
    def __init__(__self__, *,
                 admin_user_name: pulumi.Input[str],
                 admin_user_password: Optional[pulumi.Input[str]] = None,
                 admin_user_ssh_public_key: Optional[pulumi.Input[str]] = None):
        """
        Settings for user account that gets created on each on the nodes of a compute.
        :param pulumi.Input[str] admin_user_name: Name of the administrator user account which can be used to SSH to nodes.
        :param pulumi.Input[str] admin_user_password: Password of the administrator user account.
        :param pulumi.Input[str] admin_user_ssh_public_key: SSH public key of the administrator user account.
        """
        pulumi.set(__self__, "admin_user_name", admin_user_name)
        if admin_user_password is not None:
            pulumi.set(__self__, "admin_user_password", admin_user_password)
        if admin_user_ssh_public_key is not None:
            pulumi.set(__self__, "admin_user_ssh_public_key", admin_user_ssh_public_key)

    @property
    @pulumi.getter(name="adminUserName")
    def admin_user_name(self) -> pulumi.Input[str]:
        """
        Name of the administrator user account which can be used to SSH to nodes.
        """
        return pulumi.get(self, "admin_user_name")

    @admin_user_name.setter
    def admin_user_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "admin_user_name", value)

    @property
    @pulumi.getter(name="adminUserPassword")
    def admin_user_password(self) -> Optional[pulumi.Input[str]]:
        """
        Password of the administrator user account.
        """
        return pulumi.get(self, "admin_user_password")

    @admin_user_password.setter
    def admin_user_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_user_password", value)

    @property
    @pulumi.getter(name="adminUserSshPublicKey")
    def admin_user_ssh_public_key(self) -> Optional[pulumi.Input[str]]:
        """
        SSH public key of the administrator user account.
        """
        return pulumi.get(self, "admin_user_ssh_public_key")

    @admin_user_ssh_public_key.setter
    def admin_user_ssh_public_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_user_ssh_public_key", value)


@pulumi.input_type
class VirtualMachineImageArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str]):
        """
        Virtual Machine image for Windows AML Compute
        :param pulumi.Input[str] id: Virtual Machine image path
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        Virtual Machine image path
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class VirtualMachinePropertiesArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[str]] = None,
                 administrator_account: Optional[pulumi.Input['VirtualMachineSshCredentialsArgs']] = None,
                 is_notebook_instance_compute: Optional[pulumi.Input[bool]] = None,
                 ssh_port: Optional[pulumi.Input[int]] = None,
                 virtual_machine_size: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] address: Public IP address of the virtual machine.
        :param pulumi.Input['VirtualMachineSshCredentialsArgs'] administrator_account: Admin credentials for virtual machine
        :param pulumi.Input[bool] is_notebook_instance_compute: Indicates whether this compute will be used for running notebooks.
        :param pulumi.Input[int] ssh_port: Port open for ssh connections.
        :param pulumi.Input[str] virtual_machine_size: Virtual Machine size
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if administrator_account is not None:
            pulumi.set(__self__, "administrator_account", administrator_account)
        if is_notebook_instance_compute is not None:
            pulumi.set(__self__, "is_notebook_instance_compute", is_notebook_instance_compute)
        if ssh_port is not None:
            pulumi.set(__self__, "ssh_port", ssh_port)
        if virtual_machine_size is not None:
            pulumi.set(__self__, "virtual_machine_size", virtual_machine_size)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[str]]:
        """
        Public IP address of the virtual machine.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter(name="administratorAccount")
    def administrator_account(self) -> Optional[pulumi.Input['VirtualMachineSshCredentialsArgs']]:
        """
        Admin credentials for virtual machine
        """
        return pulumi.get(self, "administrator_account")

    @administrator_account.setter
    def administrator_account(self, value: Optional[pulumi.Input['VirtualMachineSshCredentialsArgs']]):
        pulumi.set(self, "administrator_account", value)

    @property
    @pulumi.getter(name="isNotebookInstanceCompute")
    def is_notebook_instance_compute(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether this compute will be used for running notebooks.
        """
        return pulumi.get(self, "is_notebook_instance_compute")

    @is_notebook_instance_compute.setter
    def is_notebook_instance_compute(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_notebook_instance_compute", value)

    @property
    @pulumi.getter(name="sshPort")
    def ssh_port(self) -> Optional[pulumi.Input[int]]:
        """
        Port open for ssh connections.
        """
        return pulumi.get(self, "ssh_port")

    @ssh_port.setter
    def ssh_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ssh_port", value)

    @property
    @pulumi.getter(name="virtualMachineSize")
    def virtual_machine_size(self) -> Optional[pulumi.Input[str]]:
        """
        Virtual Machine size
        """
        return pulumi.get(self, "virtual_machine_size")

    @virtual_machine_size.setter
    def virtual_machine_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "virtual_machine_size", value)


@pulumi.input_type
class VirtualMachineSshCredentialsArgs:
    def __init__(__self__, *,
                 password: Optional[pulumi.Input[str]] = None,
                 private_key_data: Optional[pulumi.Input[str]] = None,
                 public_key_data: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        Admin credentials for virtual machine
        :param pulumi.Input[str] password: Password of admin account
        :param pulumi.Input[str] private_key_data: Private key data
        :param pulumi.Input[str] public_key_data: Public key data
        :param pulumi.Input[str] username: Username of admin account
        """
        if password is not None:
            pulumi.set(__self__, "password", password)
        if private_key_data is not None:
            pulumi.set(__self__, "private_key_data", private_key_data)
        if public_key_data is not None:
            pulumi.set(__self__, "public_key_data", public_key_data)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Password of admin account
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="privateKeyData")
    def private_key_data(self) -> Optional[pulumi.Input[str]]:
        """
        Private key data
        """
        return pulumi.get(self, "private_key_data")

    @private_key_data.setter
    def private_key_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_key_data", value)

    @property
    @pulumi.getter(name="publicKeyData")
    def public_key_data(self) -> Optional[pulumi.Input[str]]:
        """
        Public key data
        """
        return pulumi.get(self, "public_key_data")

    @public_key_data.setter
    def public_key_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_key_data", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        Username of admin account
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class VirtualMachineArgs:
    def __init__(__self__, *,
                 compute_type: pulumi.Input[str],
                 compute_location: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disable_local_auth: Optional[pulumi.Input[bool]] = None,
                 properties: Optional[pulumi.Input['VirtualMachinePropertiesArgs']] = None,
                 resource_id: Optional[pulumi.Input[str]] = None):
        """
        A Machine Learning compute based on Azure Virtual Machines.
        :param pulumi.Input[str] compute_type: The type of compute
               Expected value is 'VirtualMachine'.
        :param pulumi.Input[str] compute_location: Location for the underlying compute
        :param pulumi.Input[str] description: The description of the Machine Learning compute.
        :param pulumi.Input[bool] disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        :param pulumi.Input[str] resource_id: ARM resource id of the underlying compute
        """
        pulumi.set(__self__, "compute_type", 'VirtualMachine')
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_local_auth is not None:
            pulumi.set(__self__, "disable_local_auth", disable_local_auth)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> pulumi.Input[str]:
        """
        The type of compute
        Expected value is 'VirtualMachine'.
        """
        return pulumi.get(self, "compute_type")

    @compute_type.setter
    def compute_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "compute_type", value)

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[pulumi.Input[str]]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @compute_location.setter
    def compute_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compute_location", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="disableLocalAuth")
    def disable_local_auth(self) -> Optional[pulumi.Input[bool]]:
        """
        Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        """
        return pulumi.get(self, "disable_local_auth")

    @disable_local_auth.setter
    def disable_local_auth(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_local_auth", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['VirtualMachinePropertiesArgs']]:
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['VirtualMachinePropertiesArgs']]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource id of the underlying compute
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)


