# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'ACIServiceCreateRequestDataCollectionArgs',
    'ACIServiceCreateRequestEncryptionPropertiesArgs',
    'ACIServiceCreateRequestVnetConfigurationArgs',
    'AKSPropertiesArgs',
    'AKSServiceCreateRequestAutoScalerArgs',
    'AKSServiceCreateRequestDataCollectionArgs',
    'AKSServiceCreateRequestLivenessProbeRequirementsArgs',
    'AKSArgs',
    'AksNetworkingConfigurationArgs',
    'AmlComputePropertiesArgs',
    'AmlComputeArgs',
    'ContainerResourceRequirementsArgs',
    'CreateServiceRequestEnvironmentImageRequestArgs',
    'CreateServiceRequestKeysArgs',
    'DataFactoryArgs',
    'DataLakeAnalyticsPropertiesArgs',
    'DataLakeAnalyticsArgs',
    'DatabricksPropertiesArgs',
    'DatabricksArgs',
    'DatasetReferenceArgs',
    'EncryptionPropertyArgs',
    'EnvironmentImageRequestEnvironmentReferenceArgs',
    'EnvironmentImageRequestEnvironmentArgs',
    'HDInsightPropertiesArgs',
    'HDInsightArgs',
    'IdentityArgs',
    'ImageAssetArgs',
    'KeyVaultPropertiesArgs',
    'LinkedWorkspacePropsArgs',
    'ModelDockerSectionBaseImageRegistryArgs',
    'ModelEnvironmentDefinitionDockerArgs',
    'ModelEnvironmentDefinitionPythonArgs',
    'ModelEnvironmentDefinitionRArgs',
    'ModelEnvironmentDefinitionSparkArgs',
    'ModelArgs',
    'PrivateLinkServiceConnectionStateArgs',
    'RCranPackageArgs',
    'RGitHubPackageArgs',
    'ResourceIdArgs',
    'ScaleSettingsArgs',
    'SharedPrivateLinkResourceArgs',
    'SkuArgs',
    'SparkMavenPackageArgs',
    'SslConfigurationArgs',
    'UserAccountCredentialsArgs',
    'VirtualMachineImageArgs',
    'VirtualMachinePropertiesArgs',
    'VirtualMachineSshCredentialsArgs',
    'VirtualMachineArgs',
]

@pulumi.input_type
class ACIServiceCreateRequestDataCollectionArgs:
    def __init__(__self__, *,
                 event_hub_enabled: Optional[pulumi.Input[bool]] = None,
                 storage_enabled: Optional[pulumi.Input[bool]] = None):
        """
        Details of the data collection options specified.
        :param pulumi.Input[bool] event_hub_enabled: Option for enabling/disabling Event Hub.
        :param pulumi.Input[bool] storage_enabled: Option for enabling/disabling storage.
        """
        if event_hub_enabled is not None:
            pulumi.set(__self__, "event_hub_enabled", event_hub_enabled)
        if storage_enabled is not None:
            pulumi.set(__self__, "storage_enabled", storage_enabled)

    @property
    @pulumi.getter(name="eventHubEnabled")
    def event_hub_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Option for enabling/disabling Event Hub.
        """
        return pulumi.get(self, "event_hub_enabled")

    @event_hub_enabled.setter
    def event_hub_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "event_hub_enabled", value)

    @property
    @pulumi.getter(name="storageEnabled")
    def storage_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Option for enabling/disabling storage.
        """
        return pulumi.get(self, "storage_enabled")

    @storage_enabled.setter
    def storage_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "storage_enabled", value)


@pulumi.input_type
class ACIServiceCreateRequestEncryptionPropertiesArgs:
    def __init__(__self__, *,
                 key_name: pulumi.Input[str],
                 key_version: pulumi.Input[str],
                 vault_base_url: pulumi.Input[str]):
        """
        The encryption properties.
        :param pulumi.Input[str] key_name: Encryption Key name
        :param pulumi.Input[str] key_version: Encryption Key Version
        :param pulumi.Input[str] vault_base_url: vault base Url
        """
        pulumi.set(__self__, "key_name", key_name)
        pulumi.set(__self__, "key_version", key_version)
        pulumi.set(__self__, "vault_base_url", vault_base_url)

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> pulumi.Input[str]:
        """
        Encryption Key name
        """
        return pulumi.get(self, "key_name")

    @key_name.setter
    def key_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "key_name", value)

    @property
    @pulumi.getter(name="keyVersion")
    def key_version(self) -> pulumi.Input[str]:
        """
        Encryption Key Version
        """
        return pulumi.get(self, "key_version")

    @key_version.setter
    def key_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "key_version", value)

    @property
    @pulumi.getter(name="vaultBaseUrl")
    def vault_base_url(self) -> pulumi.Input[str]:
        """
        vault base Url
        """
        return pulumi.get(self, "vault_base_url")

    @vault_base_url.setter
    def vault_base_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "vault_base_url", value)


@pulumi.input_type
class ACIServiceCreateRequestVnetConfigurationArgs:
    def __init__(__self__, *,
                 subnet_name: Optional[pulumi.Input[str]] = None,
                 vnet_name: Optional[pulumi.Input[str]] = None):
        """
        The virtual network configuration.
        :param pulumi.Input[str] subnet_name: The name of the virtual network subnet.
        :param pulumi.Input[str] vnet_name: The name of the virtual network.
        """
        if subnet_name is not None:
            pulumi.set(__self__, "subnet_name", subnet_name)
        if vnet_name is not None:
            pulumi.set(__self__, "vnet_name", vnet_name)

    @property
    @pulumi.getter(name="subnetName")
    def subnet_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the virtual network subnet.
        """
        return pulumi.get(self, "subnet_name")

    @subnet_name.setter
    def subnet_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_name", value)

    @property
    @pulumi.getter(name="vnetName")
    def vnet_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the virtual network.
        """
        return pulumi.get(self, "vnet_name")

    @vnet_name.setter
    def vnet_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vnet_name", value)


@pulumi.input_type
class AKSPropertiesArgs:
    def __init__(__self__, *,
                 agent_count: Optional[pulumi.Input[int]] = None,
                 agent_vm_size: Optional[pulumi.Input[str]] = None,
                 aks_networking_configuration: Optional[pulumi.Input['AksNetworkingConfigurationArgs']] = None,
                 cluster_fqdn: Optional[pulumi.Input[str]] = None,
                 ssl_configuration: Optional[pulumi.Input['SslConfigurationArgs']] = None):
        """
        AKS properties
        :param pulumi.Input[int] agent_count: Number of agents
        :param pulumi.Input[str] agent_vm_size: Agent virtual machine size
        :param pulumi.Input['AksNetworkingConfigurationArgs'] aks_networking_configuration: AKS networking configuration for vnet
        :param pulumi.Input[str] cluster_fqdn: Cluster full qualified domain name
        :param pulumi.Input['SslConfigurationArgs'] ssl_configuration: SSL configuration
        """
        if agent_count is not None:
            pulumi.set(__self__, "agent_count", agent_count)
        if agent_vm_size is not None:
            pulumi.set(__self__, "agent_vm_size", agent_vm_size)
        if aks_networking_configuration is not None:
            pulumi.set(__self__, "aks_networking_configuration", aks_networking_configuration)
        if cluster_fqdn is not None:
            pulumi.set(__self__, "cluster_fqdn", cluster_fqdn)
        if ssl_configuration is not None:
            pulumi.set(__self__, "ssl_configuration", ssl_configuration)

    @property
    @pulumi.getter(name="agentCount")
    def agent_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of agents
        """
        return pulumi.get(self, "agent_count")

    @agent_count.setter
    def agent_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "agent_count", value)

    @property
    @pulumi.getter(name="agentVMSize")
    def agent_vm_size(self) -> Optional[pulumi.Input[str]]:
        """
        Agent virtual machine size
        """
        return pulumi.get(self, "agent_vm_size")

    @agent_vm_size.setter
    def agent_vm_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "agent_vm_size", value)

    @property
    @pulumi.getter(name="aksNetworkingConfiguration")
    def aks_networking_configuration(self) -> Optional[pulumi.Input['AksNetworkingConfigurationArgs']]:
        """
        AKS networking configuration for vnet
        """
        return pulumi.get(self, "aks_networking_configuration")

    @aks_networking_configuration.setter
    def aks_networking_configuration(self, value: Optional[pulumi.Input['AksNetworkingConfigurationArgs']]):
        pulumi.set(self, "aks_networking_configuration", value)

    @property
    @pulumi.getter(name="clusterFqdn")
    def cluster_fqdn(self) -> Optional[pulumi.Input[str]]:
        """
        Cluster full qualified domain name
        """
        return pulumi.get(self, "cluster_fqdn")

    @cluster_fqdn.setter
    def cluster_fqdn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_fqdn", value)

    @property
    @pulumi.getter(name="sslConfiguration")
    def ssl_configuration(self) -> Optional[pulumi.Input['SslConfigurationArgs']]:
        """
        SSL configuration
        """
        return pulumi.get(self, "ssl_configuration")

    @ssl_configuration.setter
    def ssl_configuration(self, value: Optional[pulumi.Input['SslConfigurationArgs']]):
        pulumi.set(self, "ssl_configuration", value)


@pulumi.input_type
class AKSServiceCreateRequestAutoScalerArgs:
    def __init__(__self__, *,
                 autoscale_enabled: Optional[pulumi.Input[bool]] = None,
                 max_replicas: Optional[pulumi.Input[int]] = None,
                 min_replicas: Optional[pulumi.Input[int]] = None,
                 refresh_period_in_seconds: Optional[pulumi.Input[int]] = None,
                 target_utilization: Optional[pulumi.Input[int]] = None):
        """
        The auto scaler properties.
        :param pulumi.Input[bool] autoscale_enabled: Option to enable/disable auto scaling.
        :param pulumi.Input[int] max_replicas: The maximum number of replicas in the cluster.
        :param pulumi.Input[int] min_replicas: The minimum number of replicas to scale down to.
        :param pulumi.Input[int] refresh_period_in_seconds: The amount of seconds to wait between auto scale updates.
        :param pulumi.Input[int] target_utilization: The target utilization percentage to use for determining whether to scale the cluster.
        """
        if autoscale_enabled is not None:
            pulumi.set(__self__, "autoscale_enabled", autoscale_enabled)
        if max_replicas is not None:
            pulumi.set(__self__, "max_replicas", max_replicas)
        if min_replicas is not None:
            pulumi.set(__self__, "min_replicas", min_replicas)
        if refresh_period_in_seconds is not None:
            pulumi.set(__self__, "refresh_period_in_seconds", refresh_period_in_seconds)
        if target_utilization is not None:
            pulumi.set(__self__, "target_utilization", target_utilization)

    @property
    @pulumi.getter(name="autoscaleEnabled")
    def autoscale_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Option to enable/disable auto scaling.
        """
        return pulumi.get(self, "autoscale_enabled")

    @autoscale_enabled.setter
    def autoscale_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "autoscale_enabled", value)

    @property
    @pulumi.getter(name="maxReplicas")
    def max_replicas(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of replicas in the cluster.
        """
        return pulumi.get(self, "max_replicas")

    @max_replicas.setter
    def max_replicas(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_replicas", value)

    @property
    @pulumi.getter(name="minReplicas")
    def min_replicas(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum number of replicas to scale down to.
        """
        return pulumi.get(self, "min_replicas")

    @min_replicas.setter
    def min_replicas(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_replicas", value)

    @property
    @pulumi.getter(name="refreshPeriodInSeconds")
    def refresh_period_in_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The amount of seconds to wait between auto scale updates.
        """
        return pulumi.get(self, "refresh_period_in_seconds")

    @refresh_period_in_seconds.setter
    def refresh_period_in_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "refresh_period_in_seconds", value)

    @property
    @pulumi.getter(name="targetUtilization")
    def target_utilization(self) -> Optional[pulumi.Input[int]]:
        """
        The target utilization percentage to use for determining whether to scale the cluster.
        """
        return pulumi.get(self, "target_utilization")

    @target_utilization.setter
    def target_utilization(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "target_utilization", value)


@pulumi.input_type
class AKSServiceCreateRequestDataCollectionArgs:
    def __init__(__self__, *,
                 event_hub_enabled: Optional[pulumi.Input[bool]] = None,
                 storage_enabled: Optional[pulumi.Input[bool]] = None):
        """
        Details of the data collection options specified.
        :param pulumi.Input[bool] event_hub_enabled: Option for enabling/disabling Event Hub.
        :param pulumi.Input[bool] storage_enabled: Option for enabling/disabling storage.
        """
        if event_hub_enabled is not None:
            pulumi.set(__self__, "event_hub_enabled", event_hub_enabled)
        if storage_enabled is not None:
            pulumi.set(__self__, "storage_enabled", storage_enabled)

    @property
    @pulumi.getter(name="eventHubEnabled")
    def event_hub_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Option for enabling/disabling Event Hub.
        """
        return pulumi.get(self, "event_hub_enabled")

    @event_hub_enabled.setter
    def event_hub_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "event_hub_enabled", value)

    @property
    @pulumi.getter(name="storageEnabled")
    def storage_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Option for enabling/disabling storage.
        """
        return pulumi.get(self, "storage_enabled")

    @storage_enabled.setter
    def storage_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "storage_enabled", value)


@pulumi.input_type
class AKSServiceCreateRequestLivenessProbeRequirementsArgs:
    def __init__(__self__, *,
                 failure_threshold: Optional[pulumi.Input[int]] = None,
                 initial_delay_seconds: Optional[pulumi.Input[int]] = None,
                 period_seconds: Optional[pulumi.Input[int]] = None,
                 success_threshold: Optional[pulumi.Input[int]] = None,
                 timeout_seconds: Optional[pulumi.Input[int]] = None):
        """
        The liveness probe requirements.
        :param pulumi.Input[int] failure_threshold: The number of failures to allow before returning an unhealthy status.
        :param pulumi.Input[int] initial_delay_seconds: The delay before the first probe in seconds.
        :param pulumi.Input[int] period_seconds: The length of time between probes in seconds.
        :param pulumi.Input[int] success_threshold: The number of successful probes before returning a healthy status.
        :param pulumi.Input[int] timeout_seconds: The probe timeout in seconds.
        """
        if failure_threshold is not None:
            pulumi.set(__self__, "failure_threshold", failure_threshold)
        if initial_delay_seconds is not None:
            pulumi.set(__self__, "initial_delay_seconds", initial_delay_seconds)
        if period_seconds is not None:
            pulumi.set(__self__, "period_seconds", period_seconds)
        if success_threshold is not None:
            pulumi.set(__self__, "success_threshold", success_threshold)
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)

    @property
    @pulumi.getter(name="failureThreshold")
    def failure_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        The number of failures to allow before returning an unhealthy status.
        """
        return pulumi.get(self, "failure_threshold")

    @failure_threshold.setter
    def failure_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "failure_threshold", value)

    @property
    @pulumi.getter(name="initialDelaySeconds")
    def initial_delay_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The delay before the first probe in seconds.
        """
        return pulumi.get(self, "initial_delay_seconds")

    @initial_delay_seconds.setter
    def initial_delay_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "initial_delay_seconds", value)

    @property
    @pulumi.getter(name="periodSeconds")
    def period_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The length of time between probes in seconds.
        """
        return pulumi.get(self, "period_seconds")

    @period_seconds.setter
    def period_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period_seconds", value)

    @property
    @pulumi.getter(name="successThreshold")
    def success_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        The number of successful probes before returning a healthy status.
        """
        return pulumi.get(self, "success_threshold")

    @success_threshold.setter
    def success_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "success_threshold", value)

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The probe timeout in seconds.
        """
        return pulumi.get(self, "timeout_seconds")

    @timeout_seconds.setter
    def timeout_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout_seconds", value)


@pulumi.input_type
class AKSArgs:
    def __init__(__self__, *,
                 compute_type: pulumi.Input[str],
                 compute_location: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input['AKSPropertiesArgs']] = None,
                 resource_id: Optional[pulumi.Input[str]] = None):
        """
        A Machine Learning compute based on AKS.
        :param pulumi.Input[str] compute_type: The type of compute
               Expected value is 'AKS'.
        :param pulumi.Input[str] compute_location: Location for the underlying compute
        :param pulumi.Input[str] description: The description of the Machine Learning compute.
        :param pulumi.Input['AKSPropertiesArgs'] properties: AKS properties
        :param pulumi.Input[str] resource_id: ARM resource id of the underlying compute
        """
        pulumi.set(__self__, "compute_type", 'AKS')
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> pulumi.Input[str]:
        """
        The type of compute
        Expected value is 'AKS'.
        """
        return pulumi.get(self, "compute_type")

    @compute_type.setter
    def compute_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "compute_type", value)

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[pulumi.Input[str]]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @compute_location.setter
    def compute_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compute_location", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['AKSPropertiesArgs']]:
        """
        AKS properties
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['AKSPropertiesArgs']]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource id of the underlying compute
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)


@pulumi.input_type
class AksNetworkingConfigurationArgs:
    def __init__(__self__, *,
                 dns_service_ip: Optional[pulumi.Input[str]] = None,
                 docker_bridge_cidr: Optional[pulumi.Input[str]] = None,
                 service_cidr: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None):
        """
        Advance configuration for AKS networking
        :param pulumi.Input[str] dns_service_ip: An IP address assigned to the Kubernetes DNS service. It must be within the Kubernetes service address range specified in serviceCidr.
        :param pulumi.Input[str] docker_bridge_cidr: A CIDR notation IP range assigned to the Docker bridge network. It must not overlap with any Subnet IP ranges or the Kubernetes service address range.
        :param pulumi.Input[str] service_cidr: A CIDR notation IP range from which to assign service cluster IPs. It must not overlap with any Subnet IP ranges.
        :param pulumi.Input[str] subnet_id: Virtual network subnet resource ID the compute nodes belong to
        """
        if dns_service_ip is not None:
            pulumi.set(__self__, "dns_service_ip", dns_service_ip)
        if docker_bridge_cidr is not None:
            pulumi.set(__self__, "docker_bridge_cidr", docker_bridge_cidr)
        if service_cidr is not None:
            pulumi.set(__self__, "service_cidr", service_cidr)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="dnsServiceIP")
    def dns_service_ip(self) -> Optional[pulumi.Input[str]]:
        """
        An IP address assigned to the Kubernetes DNS service. It must be within the Kubernetes service address range specified in serviceCidr.
        """
        return pulumi.get(self, "dns_service_ip")

    @dns_service_ip.setter
    def dns_service_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_service_ip", value)

    @property
    @pulumi.getter(name="dockerBridgeCidr")
    def docker_bridge_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        A CIDR notation IP range assigned to the Docker bridge network. It must not overlap with any Subnet IP ranges or the Kubernetes service address range.
        """
        return pulumi.get(self, "docker_bridge_cidr")

    @docker_bridge_cidr.setter
    def docker_bridge_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "docker_bridge_cidr", value)

    @property
    @pulumi.getter(name="serviceCidr")
    def service_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        A CIDR notation IP range from which to assign service cluster IPs. It must not overlap with any Subnet IP ranges.
        """
        return pulumi.get(self, "service_cidr")

    @service_cidr.setter
    def service_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_cidr", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        Virtual network subnet resource ID the compute nodes belong to
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)


@pulumi.input_type
class AmlComputePropertiesArgs:
    def __init__(__self__, *,
                 enable_node_public_ip: Optional[pulumi.Input[bool]] = None,
                 isolated_network: Optional[pulumi.Input[bool]] = None,
                 os_type: Optional[pulumi.Input[Union[str, 'OsType']]] = None,
                 remote_login_port_public_access: Optional[pulumi.Input[Union[str, 'RemoteLoginPortPublicAccess']]] = None,
                 scale_settings: Optional[pulumi.Input['ScaleSettingsArgs']] = None,
                 subnet: Optional[pulumi.Input['ResourceIdArgs']] = None,
                 user_account_credentials: Optional[pulumi.Input['UserAccountCredentialsArgs']] = None,
                 virtual_machine_image: Optional[pulumi.Input['VirtualMachineImageArgs']] = None,
                 vm_priority: Optional[pulumi.Input[Union[str, 'VmPriority']]] = None,
                 vm_size: Optional[pulumi.Input[str]] = None):
        """
        AML Compute properties
        :param pulumi.Input[bool] enable_node_public_ip: Enable or disable node public IP address provisioning. Possible values are: Possible values are: true - Indicates that the compute nodes will have public IPs provisioned. false - Indicates that the compute nodes will have a private endpoint and no public IPs.
        :param pulumi.Input[bool] isolated_network: Network is isolated or not
        :param pulumi.Input[Union[str, 'OsType']] os_type: Compute OS Type
        :param pulumi.Input[Union[str, 'RemoteLoginPortPublicAccess']] remote_login_port_public_access: State of the public SSH port. Possible values are: Disabled - Indicates that the public ssh port is closed on all nodes of the cluster. Enabled - Indicates that the public ssh port is open on all nodes of the cluster. NotSpecified - Indicates that the public ssh port is closed on all nodes of the cluster if VNet is defined, else is open all public nodes. It can be default only during cluster creation time, after creation it will be either enabled or disabled.
        :param pulumi.Input['ScaleSettingsArgs'] scale_settings: Scale settings for AML Compute
        :param pulumi.Input['ResourceIdArgs'] subnet: Virtual network subnet resource ID the compute nodes belong to.
        :param pulumi.Input['UserAccountCredentialsArgs'] user_account_credentials: Credentials for an administrator user account that will be created on each compute node.
        :param pulumi.Input['VirtualMachineImageArgs'] virtual_machine_image: Virtual Machine image for AML Compute - windows only
        :param pulumi.Input[Union[str, 'VmPriority']] vm_priority: Virtual Machine priority
        :param pulumi.Input[str] vm_size: Virtual Machine Size
        """
        if enable_node_public_ip is None:
            enable_node_public_ip = True
        if enable_node_public_ip is not None:
            pulumi.set(__self__, "enable_node_public_ip", enable_node_public_ip)
        if isolated_network is not None:
            pulumi.set(__self__, "isolated_network", isolated_network)
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if remote_login_port_public_access is None:
            remote_login_port_public_access = 'NotSpecified'
        if remote_login_port_public_access is not None:
            pulumi.set(__self__, "remote_login_port_public_access", remote_login_port_public_access)
        if scale_settings is not None:
            pulumi.set(__self__, "scale_settings", scale_settings)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)
        if user_account_credentials is not None:
            pulumi.set(__self__, "user_account_credentials", user_account_credentials)
        if virtual_machine_image is not None:
            pulumi.set(__self__, "virtual_machine_image", virtual_machine_image)
        if vm_priority is not None:
            pulumi.set(__self__, "vm_priority", vm_priority)
        if vm_size is not None:
            pulumi.set(__self__, "vm_size", vm_size)

    @property
    @pulumi.getter(name="enableNodePublicIp")
    def enable_node_public_ip(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable or disable node public IP address provisioning. Possible values are: Possible values are: true - Indicates that the compute nodes will have public IPs provisioned. false - Indicates that the compute nodes will have a private endpoint and no public IPs.
        """
        return pulumi.get(self, "enable_node_public_ip")

    @enable_node_public_ip.setter
    def enable_node_public_ip(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_node_public_ip", value)

    @property
    @pulumi.getter(name="isolatedNetwork")
    def isolated_network(self) -> Optional[pulumi.Input[bool]]:
        """
        Network is isolated or not
        """
        return pulumi.get(self, "isolated_network")

    @isolated_network.setter
    def isolated_network(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "isolated_network", value)

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[pulumi.Input[Union[str, 'OsType']]]:
        """
        Compute OS Type
        """
        return pulumi.get(self, "os_type")

    @os_type.setter
    def os_type(self, value: Optional[pulumi.Input[Union[str, 'OsType']]]):
        pulumi.set(self, "os_type", value)

    @property
    @pulumi.getter(name="remoteLoginPortPublicAccess")
    def remote_login_port_public_access(self) -> Optional[pulumi.Input[Union[str, 'RemoteLoginPortPublicAccess']]]:
        """
        State of the public SSH port. Possible values are: Disabled - Indicates that the public ssh port is closed on all nodes of the cluster. Enabled - Indicates that the public ssh port is open on all nodes of the cluster. NotSpecified - Indicates that the public ssh port is closed on all nodes of the cluster if VNet is defined, else is open all public nodes. It can be default only during cluster creation time, after creation it will be either enabled or disabled.
        """
        return pulumi.get(self, "remote_login_port_public_access")

    @remote_login_port_public_access.setter
    def remote_login_port_public_access(self, value: Optional[pulumi.Input[Union[str, 'RemoteLoginPortPublicAccess']]]):
        pulumi.set(self, "remote_login_port_public_access", value)

    @property
    @pulumi.getter(name="scaleSettings")
    def scale_settings(self) -> Optional[pulumi.Input['ScaleSettingsArgs']]:
        """
        Scale settings for AML Compute
        """
        return pulumi.get(self, "scale_settings")

    @scale_settings.setter
    def scale_settings(self, value: Optional[pulumi.Input['ScaleSettingsArgs']]):
        pulumi.set(self, "scale_settings", value)

    @property
    @pulumi.getter
    def subnet(self) -> Optional[pulumi.Input['ResourceIdArgs']]:
        """
        Virtual network subnet resource ID the compute nodes belong to.
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: Optional[pulumi.Input['ResourceIdArgs']]):
        pulumi.set(self, "subnet", value)

    @property
    @pulumi.getter(name="userAccountCredentials")
    def user_account_credentials(self) -> Optional[pulumi.Input['UserAccountCredentialsArgs']]:
        """
        Credentials for an administrator user account that will be created on each compute node.
        """
        return pulumi.get(self, "user_account_credentials")

    @user_account_credentials.setter
    def user_account_credentials(self, value: Optional[pulumi.Input['UserAccountCredentialsArgs']]):
        pulumi.set(self, "user_account_credentials", value)

    @property
    @pulumi.getter(name="virtualMachineImage")
    def virtual_machine_image(self) -> Optional[pulumi.Input['VirtualMachineImageArgs']]:
        """
        Virtual Machine image for AML Compute - windows only
        """
        return pulumi.get(self, "virtual_machine_image")

    @virtual_machine_image.setter
    def virtual_machine_image(self, value: Optional[pulumi.Input['VirtualMachineImageArgs']]):
        pulumi.set(self, "virtual_machine_image", value)

    @property
    @pulumi.getter(name="vmPriority")
    def vm_priority(self) -> Optional[pulumi.Input[Union[str, 'VmPriority']]]:
        """
        Virtual Machine priority
        """
        return pulumi.get(self, "vm_priority")

    @vm_priority.setter
    def vm_priority(self, value: Optional[pulumi.Input[Union[str, 'VmPriority']]]):
        pulumi.set(self, "vm_priority", value)

    @property
    @pulumi.getter(name="vmSize")
    def vm_size(self) -> Optional[pulumi.Input[str]]:
        """
        Virtual Machine Size
        """
        return pulumi.get(self, "vm_size")

    @vm_size.setter
    def vm_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vm_size", value)


@pulumi.input_type
class AmlComputeArgs:
    def __init__(__self__, *,
                 compute_type: pulumi.Input[str],
                 compute_location: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input['AmlComputePropertiesArgs']] = None,
                 resource_id: Optional[pulumi.Input[str]] = None):
        """
        An Azure Machine Learning compute.
        :param pulumi.Input[str] compute_type: The type of compute
               Expected value is 'AmlCompute'.
        :param pulumi.Input[str] compute_location: Location for the underlying compute
        :param pulumi.Input[str] description: The description of the Machine Learning compute.
        :param pulumi.Input['AmlComputePropertiesArgs'] properties: AML Compute properties
        :param pulumi.Input[str] resource_id: ARM resource id of the underlying compute
        """
        pulumi.set(__self__, "compute_type", 'AmlCompute')
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> pulumi.Input[str]:
        """
        The type of compute
        Expected value is 'AmlCompute'.
        """
        return pulumi.get(self, "compute_type")

    @compute_type.setter
    def compute_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "compute_type", value)

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[pulumi.Input[str]]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @compute_location.setter
    def compute_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compute_location", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['AmlComputePropertiesArgs']]:
        """
        AML Compute properties
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['AmlComputePropertiesArgs']]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource id of the underlying compute
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)


@pulumi.input_type
class ContainerResourceRequirementsArgs:
    def __init__(__self__, *,
                 cpu: Optional[pulumi.Input[float]] = None,
                 fpga: Optional[pulumi.Input[int]] = None,
                 gpu: Optional[pulumi.Input[int]] = None,
                 memory_in_gb: Optional[pulumi.Input[float]] = None):
        """
        The resource requirements for the container (cpu and memory).
        :param pulumi.Input[float] cpu: The number of CPU cores on the container.
        :param pulumi.Input[int] fpga: The number of FPGA PCIE devices exposed to the container. Must be multiple of 2.
        :param pulumi.Input[int] gpu: The number of GPU cores in the container.
        :param pulumi.Input[float] memory_in_gb: The amount of memory on the container in GB.
        """
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if fpga is not None:
            pulumi.set(__self__, "fpga", fpga)
        if gpu is not None:
            pulumi.set(__self__, "gpu", gpu)
        if memory_in_gb is not None:
            pulumi.set(__self__, "memory_in_gb", memory_in_gb)

    @property
    @pulumi.getter
    def cpu(self) -> Optional[pulumi.Input[float]]:
        """
        The number of CPU cores on the container.
        """
        return pulumi.get(self, "cpu")

    @cpu.setter
    def cpu(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "cpu", value)

    @property
    @pulumi.getter
    def fpga(self) -> Optional[pulumi.Input[int]]:
        """
        The number of FPGA PCIE devices exposed to the container. Must be multiple of 2.
        """
        return pulumi.get(self, "fpga")

    @fpga.setter
    def fpga(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "fpga", value)

    @property
    @pulumi.getter
    def gpu(self) -> Optional[pulumi.Input[int]]:
        """
        The number of GPU cores in the container.
        """
        return pulumi.get(self, "gpu")

    @gpu.setter
    def gpu(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "gpu", value)

    @property
    @pulumi.getter(name="memoryInGB")
    def memory_in_gb(self) -> Optional[pulumi.Input[float]]:
        """
        The amount of memory on the container in GB.
        """
        return pulumi.get(self, "memory_in_gb")

    @memory_in_gb.setter
    def memory_in_gb(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "memory_in_gb", value)


@pulumi.input_type
class CreateServiceRequestEnvironmentImageRequestArgs:
    def __init__(__self__, *,
                 assets: Optional[pulumi.Input[Sequence[pulumi.Input['ImageAssetArgs']]]] = None,
                 driver_program: Optional[pulumi.Input[str]] = None,
                 environment: Optional[pulumi.Input['EnvironmentImageRequestEnvironmentArgs']] = None,
                 environment_reference: Optional[pulumi.Input['EnvironmentImageRequestEnvironmentReferenceArgs']] = None,
                 model_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 models: Optional[pulumi.Input[Sequence[pulumi.Input['ModelArgs']]]] = None):
        """
        The Environment, models and assets needed for inferencing.
        :param pulumi.Input[Sequence[pulumi.Input['ImageAssetArgs']]] assets: The list of assets.
        :param pulumi.Input[str] driver_program: The name of the driver file.
        :param pulumi.Input['EnvironmentImageRequestEnvironmentArgs'] environment: The details of the AZURE ML environment.
        :param pulumi.Input['EnvironmentImageRequestEnvironmentReferenceArgs'] environment_reference: The unique identifying details of the AZURE ML environment.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] model_ids: The list of model Ids.
        :param pulumi.Input[Sequence[pulumi.Input['ModelArgs']]] models: The list of models.
        """
        if assets is not None:
            pulumi.set(__self__, "assets", assets)
        if driver_program is not None:
            pulumi.set(__self__, "driver_program", driver_program)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if environment_reference is not None:
            pulumi.set(__self__, "environment_reference", environment_reference)
        if model_ids is not None:
            pulumi.set(__self__, "model_ids", model_ids)
        if models is not None:
            pulumi.set(__self__, "models", models)

    @property
    @pulumi.getter
    def assets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ImageAssetArgs']]]]:
        """
        The list of assets.
        """
        return pulumi.get(self, "assets")

    @assets.setter
    def assets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ImageAssetArgs']]]]):
        pulumi.set(self, "assets", value)

    @property
    @pulumi.getter(name="driverProgram")
    def driver_program(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the driver file.
        """
        return pulumi.get(self, "driver_program")

    @driver_program.setter
    def driver_program(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "driver_program", value)

    @property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input['EnvironmentImageRequestEnvironmentArgs']]:
        """
        The details of the AZURE ML environment.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input['EnvironmentImageRequestEnvironmentArgs']]):
        pulumi.set(self, "environment", value)

    @property
    @pulumi.getter(name="environmentReference")
    def environment_reference(self) -> Optional[pulumi.Input['EnvironmentImageRequestEnvironmentReferenceArgs']]:
        """
        The unique identifying details of the AZURE ML environment.
        """
        return pulumi.get(self, "environment_reference")

    @environment_reference.setter
    def environment_reference(self, value: Optional[pulumi.Input['EnvironmentImageRequestEnvironmentReferenceArgs']]):
        pulumi.set(self, "environment_reference", value)

    @property
    @pulumi.getter(name="modelIds")
    def model_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of model Ids.
        """
        return pulumi.get(self, "model_ids")

    @model_ids.setter
    def model_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "model_ids", value)

    @property
    @pulumi.getter
    def models(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ModelArgs']]]]:
        """
        The list of models.
        """
        return pulumi.get(self, "models")

    @models.setter
    def models(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ModelArgs']]]]):
        pulumi.set(self, "models", value)


@pulumi.input_type
class CreateServiceRequestKeysArgs:
    def __init__(__self__, *,
                 primary_key: Optional[pulumi.Input[str]] = None,
                 secondary_key: Optional[pulumi.Input[str]] = None):
        """
        The authentication keys.
        :param pulumi.Input[str] primary_key: The primary key.
        :param pulumi.Input[str] secondary_key: The secondary key.
        """
        if primary_key is not None:
            pulumi.set(__self__, "primary_key", primary_key)
        if secondary_key is not None:
            pulumi.set(__self__, "secondary_key", secondary_key)

    @property
    @pulumi.getter(name="primaryKey")
    def primary_key(self) -> Optional[pulumi.Input[str]]:
        """
        The primary key.
        """
        return pulumi.get(self, "primary_key")

    @primary_key.setter
    def primary_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_key", value)

    @property
    @pulumi.getter(name="secondaryKey")
    def secondary_key(self) -> Optional[pulumi.Input[str]]:
        """
        The secondary key.
        """
        return pulumi.get(self, "secondary_key")

    @secondary_key.setter
    def secondary_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secondary_key", value)


@pulumi.input_type
class DataFactoryArgs:
    def __init__(__self__, *,
                 compute_type: pulumi.Input[str],
                 compute_location: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None):
        """
        A DataFactory compute.
        :param pulumi.Input[str] compute_type: The type of compute
               Expected value is 'DataFactory'.
        :param pulumi.Input[str] compute_location: Location for the underlying compute
        :param pulumi.Input[str] description: The description of the Machine Learning compute.
        :param pulumi.Input[str] resource_id: ARM resource id of the underlying compute
        """
        pulumi.set(__self__, "compute_type", 'DataFactory')
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> pulumi.Input[str]:
        """
        The type of compute
        Expected value is 'DataFactory'.
        """
        return pulumi.get(self, "compute_type")

    @compute_type.setter
    def compute_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "compute_type", value)

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[pulumi.Input[str]]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @compute_location.setter
    def compute_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compute_location", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource id of the underlying compute
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)


@pulumi.input_type
class DataLakeAnalyticsPropertiesArgs:
    def __init__(__self__, *,
                 data_lake_store_account_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] data_lake_store_account_name: DataLake Store Account Name
        """
        if data_lake_store_account_name is not None:
            pulumi.set(__self__, "data_lake_store_account_name", data_lake_store_account_name)

    @property
    @pulumi.getter(name="dataLakeStoreAccountName")
    def data_lake_store_account_name(self) -> Optional[pulumi.Input[str]]:
        """
        DataLake Store Account Name
        """
        return pulumi.get(self, "data_lake_store_account_name")

    @data_lake_store_account_name.setter
    def data_lake_store_account_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_lake_store_account_name", value)


@pulumi.input_type
class DataLakeAnalyticsArgs:
    def __init__(__self__, *,
                 compute_type: pulumi.Input[str],
                 compute_location: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input['DataLakeAnalyticsPropertiesArgs']] = None,
                 resource_id: Optional[pulumi.Input[str]] = None):
        """
        A DataLakeAnalytics compute.
        :param pulumi.Input[str] compute_type: The type of compute
               Expected value is 'DataLakeAnalytics'.
        :param pulumi.Input[str] compute_location: Location for the underlying compute
        :param pulumi.Input[str] description: The description of the Machine Learning compute.
        :param pulumi.Input[str] resource_id: ARM resource id of the underlying compute
        """
        pulumi.set(__self__, "compute_type", 'DataLakeAnalytics')
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> pulumi.Input[str]:
        """
        The type of compute
        Expected value is 'DataLakeAnalytics'.
        """
        return pulumi.get(self, "compute_type")

    @compute_type.setter
    def compute_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "compute_type", value)

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[pulumi.Input[str]]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @compute_location.setter
    def compute_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compute_location", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['DataLakeAnalyticsPropertiesArgs']]:
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['DataLakeAnalyticsPropertiesArgs']]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource id of the underlying compute
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)


@pulumi.input_type
class DatabricksPropertiesArgs:
    def __init__(__self__, *,
                 databricks_access_token: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] databricks_access_token: Databricks access token
        """
        if databricks_access_token is not None:
            pulumi.set(__self__, "databricks_access_token", databricks_access_token)

    @property
    @pulumi.getter(name="databricksAccessToken")
    def databricks_access_token(self) -> Optional[pulumi.Input[str]]:
        """
        Databricks access token
        """
        return pulumi.get(self, "databricks_access_token")

    @databricks_access_token.setter
    def databricks_access_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "databricks_access_token", value)


@pulumi.input_type
class DatabricksArgs:
    def __init__(__self__, *,
                 compute_type: pulumi.Input[str],
                 compute_location: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input['DatabricksPropertiesArgs']] = None,
                 resource_id: Optional[pulumi.Input[str]] = None):
        """
        A DataFactory compute.
        :param pulumi.Input[str] compute_type: The type of compute
               Expected value is 'Databricks'.
        :param pulumi.Input[str] compute_location: Location for the underlying compute
        :param pulumi.Input[str] description: The description of the Machine Learning compute.
        :param pulumi.Input[str] resource_id: ARM resource id of the underlying compute
        """
        pulumi.set(__self__, "compute_type", 'Databricks')
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> pulumi.Input[str]:
        """
        The type of compute
        Expected value is 'Databricks'.
        """
        return pulumi.get(self, "compute_type")

    @compute_type.setter
    def compute_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "compute_type", value)

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[pulumi.Input[str]]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @compute_location.setter
    def compute_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compute_location", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['DatabricksPropertiesArgs']]:
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['DatabricksPropertiesArgs']]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource id of the underlying compute
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)


@pulumi.input_type
class DatasetReferenceArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The dataset reference object.
        :param pulumi.Input[str] id: The id of the dataset reference.
        :param pulumi.Input[str] name: The name of the dataset reference.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the dataset reference.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the dataset reference.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class EncryptionPropertyArgs:
    def __init__(__self__, *,
                 key_vault_properties: pulumi.Input['KeyVaultPropertiesArgs'],
                 status: pulumi.Input[Union[str, 'EncryptionStatus']]):
        """
        :param pulumi.Input['KeyVaultPropertiesArgs'] key_vault_properties: Customer Key vault properties.
        :param pulumi.Input[Union[str, 'EncryptionStatus']] status: Indicates whether or not the encryption is enabled for the workspace.
        """
        pulumi.set(__self__, "key_vault_properties", key_vault_properties)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="keyVaultProperties")
    def key_vault_properties(self) -> pulumi.Input['KeyVaultPropertiesArgs']:
        """
        Customer Key vault properties.
        """
        return pulumi.get(self, "key_vault_properties")

    @key_vault_properties.setter
    def key_vault_properties(self, value: pulumi.Input['KeyVaultPropertiesArgs']):
        pulumi.set(self, "key_vault_properties", value)

    @property
    @pulumi.getter
    def status(self) -> pulumi.Input[Union[str, 'EncryptionStatus']]:
        """
        Indicates whether or not the encryption is enabled for the workspace.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: pulumi.Input[Union[str, 'EncryptionStatus']]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class EnvironmentImageRequestEnvironmentReferenceArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        The unique identifying details of the AZURE ML environment.
        :param pulumi.Input[str] name: Name of the environment.
        :param pulumi.Input[str] version: Version of the environment.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the environment.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Version of the environment.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class EnvironmentImageRequestEnvironmentArgs:
    def __init__(__self__, *,
                 docker: Optional[pulumi.Input['ModelEnvironmentDefinitionDockerArgs']] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 inferencing_stack_version: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 python: Optional[pulumi.Input['ModelEnvironmentDefinitionPythonArgs']] = None,
                 r: Optional[pulumi.Input['ModelEnvironmentDefinitionRArgs']] = None,
                 spark: Optional[pulumi.Input['ModelEnvironmentDefinitionSparkArgs']] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        The details of the AZURE ML environment.
        :param pulumi.Input['ModelEnvironmentDefinitionDockerArgs'] docker: The definition of a Docker container.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] environment_variables: Definition of environment variables to be defined in the environment.
        :param pulumi.Input[str] inferencing_stack_version: The inferencing stack version added to the image. To avoid adding an inferencing stack, do not set this value. Valid values: "latest".
        :param pulumi.Input[str] name: The name of the environment.
        :param pulumi.Input['ModelEnvironmentDefinitionPythonArgs'] python: Settings for a Python environment.
        :param pulumi.Input['ModelEnvironmentDefinitionRArgs'] r: Settings for a R environment.
        :param pulumi.Input['ModelEnvironmentDefinitionSparkArgs'] spark: The configuration for a Spark environment.
        :param pulumi.Input[str] version: The environment version.
        """
        if docker is not None:
            pulumi.set(__self__, "docker", docker)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if inferencing_stack_version is not None:
            pulumi.set(__self__, "inferencing_stack_version", inferencing_stack_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if python is not None:
            pulumi.set(__self__, "python", python)
        if r is not None:
            pulumi.set(__self__, "r", r)
        if spark is not None:
            pulumi.set(__self__, "spark", spark)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def docker(self) -> Optional[pulumi.Input['ModelEnvironmentDefinitionDockerArgs']]:
        """
        The definition of a Docker container.
        """
        return pulumi.get(self, "docker")

    @docker.setter
    def docker(self, value: Optional[pulumi.Input['ModelEnvironmentDefinitionDockerArgs']]):
        pulumi.set(self, "docker", value)

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Definition of environment variables to be defined in the environment.
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "environment_variables", value)

    @property
    @pulumi.getter(name="inferencingStackVersion")
    def inferencing_stack_version(self) -> Optional[pulumi.Input[str]]:
        """
        The inferencing stack version added to the image. To avoid adding an inferencing stack, do not set this value. Valid values: "latest".
        """
        return pulumi.get(self, "inferencing_stack_version")

    @inferencing_stack_version.setter
    def inferencing_stack_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "inferencing_stack_version", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the environment.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def python(self) -> Optional[pulumi.Input['ModelEnvironmentDefinitionPythonArgs']]:
        """
        Settings for a Python environment.
        """
        return pulumi.get(self, "python")

    @python.setter
    def python(self, value: Optional[pulumi.Input['ModelEnvironmentDefinitionPythonArgs']]):
        pulumi.set(self, "python", value)

    @property
    @pulumi.getter
    def r(self) -> Optional[pulumi.Input['ModelEnvironmentDefinitionRArgs']]:
        """
        Settings for a R environment.
        """
        return pulumi.get(self, "r")

    @r.setter
    def r(self, value: Optional[pulumi.Input['ModelEnvironmentDefinitionRArgs']]):
        pulumi.set(self, "r", value)

    @property
    @pulumi.getter
    def spark(self) -> Optional[pulumi.Input['ModelEnvironmentDefinitionSparkArgs']]:
        """
        The configuration for a Spark environment.
        """
        return pulumi.get(self, "spark")

    @spark.setter
    def spark(self, value: Optional[pulumi.Input['ModelEnvironmentDefinitionSparkArgs']]):
        pulumi.set(self, "spark", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        The environment version.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class HDInsightPropertiesArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[str]] = None,
                 administrator_account: Optional[pulumi.Input['VirtualMachineSshCredentialsArgs']] = None,
                 ssh_port: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] address: Public IP address of the master node of the cluster.
        :param pulumi.Input['VirtualMachineSshCredentialsArgs'] administrator_account: Admin credentials for master node of the cluster
        :param pulumi.Input[int] ssh_port: Port open for ssh connections on the master node of the cluster.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if administrator_account is not None:
            pulumi.set(__self__, "administrator_account", administrator_account)
        if ssh_port is not None:
            pulumi.set(__self__, "ssh_port", ssh_port)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[str]]:
        """
        Public IP address of the master node of the cluster.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter(name="administratorAccount")
    def administrator_account(self) -> Optional[pulumi.Input['VirtualMachineSshCredentialsArgs']]:
        """
        Admin credentials for master node of the cluster
        """
        return pulumi.get(self, "administrator_account")

    @administrator_account.setter
    def administrator_account(self, value: Optional[pulumi.Input['VirtualMachineSshCredentialsArgs']]):
        pulumi.set(self, "administrator_account", value)

    @property
    @pulumi.getter(name="sshPort")
    def ssh_port(self) -> Optional[pulumi.Input[int]]:
        """
        Port open for ssh connections on the master node of the cluster.
        """
        return pulumi.get(self, "ssh_port")

    @ssh_port.setter
    def ssh_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ssh_port", value)


@pulumi.input_type
class HDInsightArgs:
    def __init__(__self__, *,
                 compute_type: pulumi.Input[str],
                 compute_location: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input['HDInsightPropertiesArgs']] = None,
                 resource_id: Optional[pulumi.Input[str]] = None):
        """
        A HDInsight compute.
        :param pulumi.Input[str] compute_type: The type of compute
               Expected value is 'HDInsight'.
        :param pulumi.Input[str] compute_location: Location for the underlying compute
        :param pulumi.Input[str] description: The description of the Machine Learning compute.
        :param pulumi.Input[str] resource_id: ARM resource id of the underlying compute
        """
        pulumi.set(__self__, "compute_type", 'HDInsight')
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> pulumi.Input[str]:
        """
        The type of compute
        Expected value is 'HDInsight'.
        """
        return pulumi.get(self, "compute_type")

    @compute_type.setter
    def compute_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "compute_type", value)

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[pulumi.Input[str]]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @compute_location.setter
    def compute_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compute_location", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['HDInsightPropertiesArgs']]:
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['HDInsightPropertiesArgs']]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource id of the underlying compute
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)


@pulumi.input_type
class IdentityArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input['ResourceIdentityType']] = None,
                 user_assigned_identities: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        Identity for the resource.
        :param pulumi.Input['ResourceIdentityType'] type: The identity type.
        :param pulumi.Input[Mapping[str, Any]] user_assigned_identities: The user assigned identities associated with the resource.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['ResourceIdentityType']]:
        """
        The identity type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['ResourceIdentityType']]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        The user assigned identities associated with the resource.
        """
        return pulumi.get(self, "user_assigned_identities")

    @user_assigned_identities.setter
    def user_assigned_identities(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "user_assigned_identities", value)


@pulumi.input_type
class ImageAssetArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None,
                 mime_type: Optional[pulumi.Input[str]] = None,
                 unpack: Optional[pulumi.Input[bool]] = None,
                 url: Optional[pulumi.Input[str]] = None):
        """
        An Image asset.
        :param pulumi.Input[str] id: The Asset Id.
        :param pulumi.Input[str] mime_type: The mime type.
        :param pulumi.Input[bool] unpack: Whether the Asset is unpacked.
        :param pulumi.Input[str] url: The Url of the Asset.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if mime_type is not None:
            pulumi.set(__self__, "mime_type", mime_type)
        if unpack is not None:
            pulumi.set(__self__, "unpack", unpack)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The Asset Id.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="mimeType")
    def mime_type(self) -> Optional[pulumi.Input[str]]:
        """
        The mime type.
        """
        return pulumi.get(self, "mime_type")

    @mime_type.setter
    def mime_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mime_type", value)

    @property
    @pulumi.getter
    def unpack(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the Asset is unpacked.
        """
        return pulumi.get(self, "unpack")

    @unpack.setter
    def unpack(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "unpack", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        The Url of the Asset.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class KeyVaultPropertiesArgs:
    def __init__(__self__, *,
                 key_identifier: pulumi.Input[str],
                 key_vault_arm_id: pulumi.Input[str],
                 identity_client_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] key_identifier: Key vault uri to access the encryption key.
        :param pulumi.Input[str] key_vault_arm_id: The ArmId of the keyVault where the customer owned encryption key is present.
        :param pulumi.Input[str] identity_client_id: For future use - The client id of the identity which will be used to access key vault.
        """
        pulumi.set(__self__, "key_identifier", key_identifier)
        pulumi.set(__self__, "key_vault_arm_id", key_vault_arm_id)
        if identity_client_id is not None:
            pulumi.set(__self__, "identity_client_id", identity_client_id)

    @property
    @pulumi.getter(name="keyIdentifier")
    def key_identifier(self) -> pulumi.Input[str]:
        """
        Key vault uri to access the encryption key.
        """
        return pulumi.get(self, "key_identifier")

    @key_identifier.setter
    def key_identifier(self, value: pulumi.Input[str]):
        pulumi.set(self, "key_identifier", value)

    @property
    @pulumi.getter(name="keyVaultArmId")
    def key_vault_arm_id(self) -> pulumi.Input[str]:
        """
        The ArmId of the keyVault where the customer owned encryption key is present.
        """
        return pulumi.get(self, "key_vault_arm_id")

    @key_vault_arm_id.setter
    def key_vault_arm_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "key_vault_arm_id", value)

    @property
    @pulumi.getter(name="identityClientId")
    def identity_client_id(self) -> Optional[pulumi.Input[str]]:
        """
        For future use - The client id of the identity which will be used to access key vault.
        """
        return pulumi.get(self, "identity_client_id")

    @identity_client_id.setter
    def identity_client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identity_client_id", value)


@pulumi.input_type
class LinkedWorkspacePropsArgs:
    def __init__(__self__, *,
                 linked_workspace_resource_id: Optional[pulumi.Input[str]] = None,
                 user_assigned_identity_resource_id: Optional[pulumi.Input[str]] = None):
        """
        LinkedWorkspace specific properties.
        :param pulumi.Input[str] linked_workspace_resource_id: ResourceId of the link target of the linked workspace.
        :param pulumi.Input[str] user_assigned_identity_resource_id: ResourceId of the user assigned identity for the linked workspace.
        """
        if linked_workspace_resource_id is not None:
            pulumi.set(__self__, "linked_workspace_resource_id", linked_workspace_resource_id)
        if user_assigned_identity_resource_id is not None:
            pulumi.set(__self__, "user_assigned_identity_resource_id", user_assigned_identity_resource_id)

    @property
    @pulumi.getter(name="linkedWorkspaceResourceId")
    def linked_workspace_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        ResourceId of the link target of the linked workspace.
        """
        return pulumi.get(self, "linked_workspace_resource_id")

    @linked_workspace_resource_id.setter
    def linked_workspace_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "linked_workspace_resource_id", value)

    @property
    @pulumi.getter(name="userAssignedIdentityResourceId")
    def user_assigned_identity_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        ResourceId of the user assigned identity for the linked workspace.
        """
        return pulumi.get(self, "user_assigned_identity_resource_id")

    @user_assigned_identity_resource_id.setter
    def user_assigned_identity_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_assigned_identity_resource_id", value)


@pulumi.input_type
class ModelDockerSectionBaseImageRegistryArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        Image registry that contains the base image.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class ModelEnvironmentDefinitionDockerArgs:
    def __init__(__self__, *,
                 base_dockerfile: Optional[pulumi.Input[str]] = None,
                 base_image: Optional[pulumi.Input[str]] = None,
                 base_image_registry: Optional[pulumi.Input['ModelDockerSectionBaseImageRegistryArgs']] = None):
        """
        The definition of a Docker container.
        :param pulumi.Input[str] base_dockerfile: Base Dockerfile used for Docker-based runs. Mutually exclusive with BaseImage.
        :param pulumi.Input[str] base_image: Base image used for Docker-based runs. Mutually exclusive with BaseDockerfile.
        :param pulumi.Input['ModelDockerSectionBaseImageRegistryArgs'] base_image_registry: Image registry that contains the base image.
        """
        if base_dockerfile is not None:
            pulumi.set(__self__, "base_dockerfile", base_dockerfile)
        if base_image is not None:
            pulumi.set(__self__, "base_image", base_image)
        if base_image_registry is not None:
            pulumi.set(__self__, "base_image_registry", base_image_registry)

    @property
    @pulumi.getter(name="baseDockerfile")
    def base_dockerfile(self) -> Optional[pulumi.Input[str]]:
        """
        Base Dockerfile used for Docker-based runs. Mutually exclusive with BaseImage.
        """
        return pulumi.get(self, "base_dockerfile")

    @base_dockerfile.setter
    def base_dockerfile(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "base_dockerfile", value)

    @property
    @pulumi.getter(name="baseImage")
    def base_image(self) -> Optional[pulumi.Input[str]]:
        """
        Base image used for Docker-based runs. Mutually exclusive with BaseDockerfile.
        """
        return pulumi.get(self, "base_image")

    @base_image.setter
    def base_image(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "base_image", value)

    @property
    @pulumi.getter(name="baseImageRegistry")
    def base_image_registry(self) -> Optional[pulumi.Input['ModelDockerSectionBaseImageRegistryArgs']]:
        """
        Image registry that contains the base image.
        """
        return pulumi.get(self, "base_image_registry")

    @base_image_registry.setter
    def base_image_registry(self, value: Optional[pulumi.Input['ModelDockerSectionBaseImageRegistryArgs']]):
        pulumi.set(self, "base_image_registry", value)


@pulumi.input_type
class ModelEnvironmentDefinitionPythonArgs:
    def __init__(__self__, *,
                 base_conda_environment: Optional[pulumi.Input[str]] = None,
                 conda_dependencies: Optional[Any] = None,
                 interpreter_path: Optional[pulumi.Input[str]] = None,
                 user_managed_dependencies: Optional[pulumi.Input[bool]] = None):
        """
        Settings for a Python environment.
        :param Any conda_dependencies: A JObject containing Conda dependencies.
        :param pulumi.Input[str] interpreter_path: The python interpreter path to use if an environment build is not required. The path specified gets used to call the user script.
        :param pulumi.Input[bool] user_managed_dependencies: True means that AzureML reuses an existing python environment; False means that AzureML will create a python environment based on the Conda dependencies specification.
        """
        if base_conda_environment is not None:
            pulumi.set(__self__, "base_conda_environment", base_conda_environment)
        if conda_dependencies is not None:
            pulumi.set(__self__, "conda_dependencies", conda_dependencies)
        if interpreter_path is not None:
            pulumi.set(__self__, "interpreter_path", interpreter_path)
        if user_managed_dependencies is not None:
            pulumi.set(__self__, "user_managed_dependencies", user_managed_dependencies)

    @property
    @pulumi.getter(name="baseCondaEnvironment")
    def base_conda_environment(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "base_conda_environment")

    @base_conda_environment.setter
    def base_conda_environment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "base_conda_environment", value)

    @property
    @pulumi.getter(name="condaDependencies")
    def conda_dependencies(self) -> Optional[Any]:
        """
        A JObject containing Conda dependencies.
        """
        return pulumi.get(self, "conda_dependencies")

    @conda_dependencies.setter
    def conda_dependencies(self, value: Optional[Any]):
        pulumi.set(self, "conda_dependencies", value)

    @property
    @pulumi.getter(name="interpreterPath")
    def interpreter_path(self) -> Optional[pulumi.Input[str]]:
        """
        The python interpreter path to use if an environment build is not required. The path specified gets used to call the user script.
        """
        return pulumi.get(self, "interpreter_path")

    @interpreter_path.setter
    def interpreter_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "interpreter_path", value)

    @property
    @pulumi.getter(name="userManagedDependencies")
    def user_managed_dependencies(self) -> Optional[pulumi.Input[bool]]:
        """
        True means that AzureML reuses an existing python environment; False means that AzureML will create a python environment based on the Conda dependencies specification.
        """
        return pulumi.get(self, "user_managed_dependencies")

    @user_managed_dependencies.setter
    def user_managed_dependencies(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "user_managed_dependencies", value)


@pulumi.input_type
class ModelEnvironmentDefinitionRArgs:
    def __init__(__self__, *,
                 bio_conductor_packages: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 cran_packages: Optional[pulumi.Input[Sequence[pulumi.Input['RCranPackageArgs']]]] = None,
                 custom_url_packages: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 git_hub_packages: Optional[pulumi.Input[Sequence[pulumi.Input['RGitHubPackageArgs']]]] = None,
                 r_version: Optional[pulumi.Input[str]] = None,
                 rscript_path: Optional[pulumi.Input[str]] = None,
                 snapshot_date: Optional[pulumi.Input[str]] = None,
                 user_managed: Optional[pulumi.Input[bool]] = None):
        """
        Settings for a R environment.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] bio_conductor_packages: The packages from Bioconductor.
        :param pulumi.Input[Sequence[pulumi.Input['RCranPackageArgs']]] cran_packages: The CRAN packages to use.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] custom_url_packages: The packages from custom urls.
        :param pulumi.Input[Sequence[pulumi.Input['RGitHubPackageArgs']]] git_hub_packages: The packages directly from GitHub.
        :param pulumi.Input[str] r_version: The version of R to be installed
        :param pulumi.Input[str] rscript_path: The Rscript path to use if an environment build is not required.
               The path specified gets used to call the user script.
        :param pulumi.Input[str] snapshot_date: Date of MRAN snapshot to use in YYYY-MM-DD format, e.g. "2019-04-17"
        :param pulumi.Input[bool] user_managed: Indicates whether the environment is managed by user or by AzureML.
        """
        if bio_conductor_packages is not None:
            pulumi.set(__self__, "bio_conductor_packages", bio_conductor_packages)
        if cran_packages is not None:
            pulumi.set(__self__, "cran_packages", cran_packages)
        if custom_url_packages is not None:
            pulumi.set(__self__, "custom_url_packages", custom_url_packages)
        if git_hub_packages is not None:
            pulumi.set(__self__, "git_hub_packages", git_hub_packages)
        if r_version is not None:
            pulumi.set(__self__, "r_version", r_version)
        if rscript_path is not None:
            pulumi.set(__self__, "rscript_path", rscript_path)
        if snapshot_date is not None:
            pulumi.set(__self__, "snapshot_date", snapshot_date)
        if user_managed is not None:
            pulumi.set(__self__, "user_managed", user_managed)

    @property
    @pulumi.getter(name="bioConductorPackages")
    def bio_conductor_packages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The packages from Bioconductor.
        """
        return pulumi.get(self, "bio_conductor_packages")

    @bio_conductor_packages.setter
    def bio_conductor_packages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "bio_conductor_packages", value)

    @property
    @pulumi.getter(name="cranPackages")
    def cran_packages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RCranPackageArgs']]]]:
        """
        The CRAN packages to use.
        """
        return pulumi.get(self, "cran_packages")

    @cran_packages.setter
    def cran_packages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RCranPackageArgs']]]]):
        pulumi.set(self, "cran_packages", value)

    @property
    @pulumi.getter(name="customUrlPackages")
    def custom_url_packages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The packages from custom urls.
        """
        return pulumi.get(self, "custom_url_packages")

    @custom_url_packages.setter
    def custom_url_packages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "custom_url_packages", value)

    @property
    @pulumi.getter(name="gitHubPackages")
    def git_hub_packages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RGitHubPackageArgs']]]]:
        """
        The packages directly from GitHub.
        """
        return pulumi.get(self, "git_hub_packages")

    @git_hub_packages.setter
    def git_hub_packages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RGitHubPackageArgs']]]]):
        pulumi.set(self, "git_hub_packages", value)

    @property
    @pulumi.getter(name="rVersion")
    def r_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of R to be installed
        """
        return pulumi.get(self, "r_version")

    @r_version.setter
    def r_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "r_version", value)

    @property
    @pulumi.getter(name="rscriptPath")
    def rscript_path(self) -> Optional[pulumi.Input[str]]:
        """
        The Rscript path to use if an environment build is not required.
        The path specified gets used to call the user script.
        """
        return pulumi.get(self, "rscript_path")

    @rscript_path.setter
    def rscript_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rscript_path", value)

    @property
    @pulumi.getter(name="snapshotDate")
    def snapshot_date(self) -> Optional[pulumi.Input[str]]:
        """
        Date of MRAN snapshot to use in YYYY-MM-DD format, e.g. "2019-04-17"
        """
        return pulumi.get(self, "snapshot_date")

    @snapshot_date.setter
    def snapshot_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snapshot_date", value)

    @property
    @pulumi.getter(name="userManaged")
    def user_managed(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the environment is managed by user or by AzureML.
        """
        return pulumi.get(self, "user_managed")

    @user_managed.setter
    def user_managed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "user_managed", value)


@pulumi.input_type
class ModelEnvironmentDefinitionSparkArgs:
    def __init__(__self__, *,
                 packages: Optional[pulumi.Input[Sequence[pulumi.Input['SparkMavenPackageArgs']]]] = None,
                 precache_packages: Optional[pulumi.Input[bool]] = None,
                 repositories: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The configuration for a Spark environment.
        :param pulumi.Input[Sequence[pulumi.Input['SparkMavenPackageArgs']]] packages: The Spark packages to use.
        :param pulumi.Input[bool] precache_packages: Whether to precache the packages.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] repositories: The list of spark repositories.
        """
        if packages is not None:
            pulumi.set(__self__, "packages", packages)
        if precache_packages is not None:
            pulumi.set(__self__, "precache_packages", precache_packages)
        if repositories is not None:
            pulumi.set(__self__, "repositories", repositories)

    @property
    @pulumi.getter
    def packages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SparkMavenPackageArgs']]]]:
        """
        The Spark packages to use.
        """
        return pulumi.get(self, "packages")

    @packages.setter
    def packages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SparkMavenPackageArgs']]]]):
        pulumi.set(self, "packages", value)

    @property
    @pulumi.getter(name="precachePackages")
    def precache_packages(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to precache the packages.
        """
        return pulumi.get(self, "precache_packages")

    @precache_packages.setter
    def precache_packages(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "precache_packages", value)

    @property
    @pulumi.getter
    def repositories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of spark repositories.
        """
        return pulumi.get(self, "repositories")

    @repositories.setter
    def repositories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "repositories", value)


@pulumi.input_type
class ModelArgs:
    def __init__(__self__, *,
                 mime_type: pulumi.Input[str],
                 name: pulumi.Input[str],
                 url: pulumi.Input[str],
                 created_time: Optional[pulumi.Input[str]] = None,
                 datasets: Optional[pulumi.Input[Sequence[pulumi.Input['DatasetReferenceArgs']]]] = None,
                 derived_model_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 experiment_name: Optional[pulumi.Input[str]] = None,
                 framework: Optional[pulumi.Input[str]] = None,
                 framework_version: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 kv_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 modified_time: Optional[pulumi.Input[str]] = None,
                 parent_model_id: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 resource_requirements: Optional[pulumi.Input['ContainerResourceRequirementsArgs']] = None,
                 run_id: Optional[pulumi.Input[str]] = None,
                 sample_input_data: Optional[pulumi.Input[str]] = None,
                 sample_output_data: Optional[pulumi.Input[str]] = None,
                 unpack: Optional[pulumi.Input[bool]] = None,
                 version: Optional[pulumi.Input[float]] = None):
        """
        An Azure Machine Learning Model.
        :param pulumi.Input[str] mime_type: The MIME type of Model content. For more details about MIME type, please open https://www.iana.org/assignments/media-types/media-types.xhtml
        :param pulumi.Input[str] name: The Model name.
        :param pulumi.Input[str] url: The URL of the Model. Usually a SAS URL.
        :param pulumi.Input[str] created_time: The Model creation time (UTC).
        :param pulumi.Input[Sequence[pulumi.Input['DatasetReferenceArgs']]] datasets: The list of datasets associated with the model.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] derived_model_ids: Models derived from this model
        :param pulumi.Input[str] description: The Model description text.
        :param pulumi.Input[str] experiment_name: The name of the experiment where this model was created.
        :param pulumi.Input[str] framework: The Model framework.
        :param pulumi.Input[str] framework_version: The Model framework version.
        :param pulumi.Input[str] id: The Model Id.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] kv_tags: The Model tag dictionary. Items are mutable.
        :param pulumi.Input[str] modified_time: The Model last modified time (UTC).
        :param pulumi.Input[str] parent_model_id: The Parent Model Id.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: The Model property dictionary. Properties are immutable.
        :param pulumi.Input['ContainerResourceRequirementsArgs'] resource_requirements: Resource requirements for the model
        :param pulumi.Input[str] run_id: The RunId that created this model.
        :param pulumi.Input[str] sample_input_data: Sample Input Data for the Model. A reference to a dataset in the workspace in the format aml://dataset/{datasetId}
        :param pulumi.Input[str] sample_output_data: Sample Output Data for the Model. A reference to a dataset in the workspace in the format aml://dataset/{datasetId}
        :param pulumi.Input[bool] unpack: Indicates whether we need to unpack the Model during docker Image creation.
        :param pulumi.Input[float] version: The Model version assigned by Model Management Service.
        """
        pulumi.set(__self__, "mime_type", mime_type)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "url", url)
        if created_time is not None:
            pulumi.set(__self__, "created_time", created_time)
        if datasets is not None:
            pulumi.set(__self__, "datasets", datasets)
        if derived_model_ids is not None:
            pulumi.set(__self__, "derived_model_ids", derived_model_ids)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if experiment_name is not None:
            pulumi.set(__self__, "experiment_name", experiment_name)
        if framework is not None:
            pulumi.set(__self__, "framework", framework)
        if framework_version is not None:
            pulumi.set(__self__, "framework_version", framework_version)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if kv_tags is not None:
            pulumi.set(__self__, "kv_tags", kv_tags)
        if modified_time is not None:
            pulumi.set(__self__, "modified_time", modified_time)
        if parent_model_id is not None:
            pulumi.set(__self__, "parent_model_id", parent_model_id)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_requirements is not None:
            pulumi.set(__self__, "resource_requirements", resource_requirements)
        if run_id is not None:
            pulumi.set(__self__, "run_id", run_id)
        if sample_input_data is not None:
            pulumi.set(__self__, "sample_input_data", sample_input_data)
        if sample_output_data is not None:
            pulumi.set(__self__, "sample_output_data", sample_output_data)
        if unpack is not None:
            pulumi.set(__self__, "unpack", unpack)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="mimeType")
    def mime_type(self) -> pulumi.Input[str]:
        """
        The MIME type of Model content. For more details about MIME type, please open https://www.iana.org/assignments/media-types/media-types.xhtml
        """
        return pulumi.get(self, "mime_type")

    @mime_type.setter
    def mime_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "mime_type", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The Model name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def url(self) -> pulumi.Input[str]:
        """
        The URL of the Model. Usually a SAS URL.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[str]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> Optional[pulumi.Input[str]]:
        """
        The Model creation time (UTC).
        """
        return pulumi.get(self, "created_time")

    @created_time.setter
    def created_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_time", value)

    @property
    @pulumi.getter
    def datasets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatasetReferenceArgs']]]]:
        """
        The list of datasets associated with the model.
        """
        return pulumi.get(self, "datasets")

    @datasets.setter
    def datasets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatasetReferenceArgs']]]]):
        pulumi.set(self, "datasets", value)

    @property
    @pulumi.getter(name="derivedModelIds")
    def derived_model_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Models derived from this model
        """
        return pulumi.get(self, "derived_model_ids")

    @derived_model_ids.setter
    def derived_model_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "derived_model_ids", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The Model description text.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="experimentName")
    def experiment_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the experiment where this model was created.
        """
        return pulumi.get(self, "experiment_name")

    @experiment_name.setter
    def experiment_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "experiment_name", value)

    @property
    @pulumi.getter
    def framework(self) -> Optional[pulumi.Input[str]]:
        """
        The Model framework.
        """
        return pulumi.get(self, "framework")

    @framework.setter
    def framework(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "framework", value)

    @property
    @pulumi.getter(name="frameworkVersion")
    def framework_version(self) -> Optional[pulumi.Input[str]]:
        """
        The Model framework version.
        """
        return pulumi.get(self, "framework_version")

    @framework_version.setter
    def framework_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "framework_version", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The Model Id.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="kvTags")
    def kv_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The Model tag dictionary. Items are mutable.
        """
        return pulumi.get(self, "kv_tags")

    @kv_tags.setter
    def kv_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "kv_tags", value)

    @property
    @pulumi.getter(name="modifiedTime")
    def modified_time(self) -> Optional[pulumi.Input[str]]:
        """
        The Model last modified time (UTC).
        """
        return pulumi.get(self, "modified_time")

    @modified_time.setter
    def modified_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "modified_time", value)

    @property
    @pulumi.getter(name="parentModelId")
    def parent_model_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Parent Model Id.
        """
        return pulumi.get(self, "parent_model_id")

    @parent_model_id.setter
    def parent_model_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent_model_id", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The Model property dictionary. Properties are immutable.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="resourceRequirements")
    def resource_requirements(self) -> Optional[pulumi.Input['ContainerResourceRequirementsArgs']]:
        """
        Resource requirements for the model
        """
        return pulumi.get(self, "resource_requirements")

    @resource_requirements.setter
    def resource_requirements(self, value: Optional[pulumi.Input['ContainerResourceRequirementsArgs']]):
        pulumi.set(self, "resource_requirements", value)

    @property
    @pulumi.getter(name="runId")
    def run_id(self) -> Optional[pulumi.Input[str]]:
        """
        The RunId that created this model.
        """
        return pulumi.get(self, "run_id")

    @run_id.setter
    def run_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "run_id", value)

    @property
    @pulumi.getter(name="sampleInputData")
    def sample_input_data(self) -> Optional[pulumi.Input[str]]:
        """
        Sample Input Data for the Model. A reference to a dataset in the workspace in the format aml://dataset/{datasetId}
        """
        return pulumi.get(self, "sample_input_data")

    @sample_input_data.setter
    def sample_input_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sample_input_data", value)

    @property
    @pulumi.getter(name="sampleOutputData")
    def sample_output_data(self) -> Optional[pulumi.Input[str]]:
        """
        Sample Output Data for the Model. A reference to a dataset in the workspace in the format aml://dataset/{datasetId}
        """
        return pulumi.get(self, "sample_output_data")

    @sample_output_data.setter
    def sample_output_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sample_output_data", value)

    @property
    @pulumi.getter
    def unpack(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether we need to unpack the Model during docker Image creation.
        """
        return pulumi.get(self, "unpack")

    @unpack.setter
    def unpack(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "unpack", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[float]]:
        """
        The Model version assigned by Model Management Service.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class PrivateLinkServiceConnectionStateArgs:
    def __init__(__self__, *,
                 actions_required: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[Union[str, 'PrivateEndpointServiceConnectionStatus']]] = None):
        """
        A collection of information about the state of the connection between service consumer and provider.
        :param pulumi.Input[str] actions_required: A message indicating if changes on the service provider require any updates on the consumer.
        :param pulumi.Input[str] description: The reason for approval/rejection of the connection.
        :param pulumi.Input[Union[str, 'PrivateEndpointServiceConnectionStatus']] status: Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
        """
        if actions_required is not None:
            pulumi.set(__self__, "actions_required", actions_required)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="actionsRequired")
    def actions_required(self) -> Optional[pulumi.Input[str]]:
        """
        A message indicating if changes on the service provider require any updates on the consumer.
        """
        return pulumi.get(self, "actions_required")

    @actions_required.setter
    def actions_required(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "actions_required", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The reason for approval/rejection of the connection.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[Union[str, 'PrivateEndpointServiceConnectionStatus']]]:
        """
        Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[Union[str, 'PrivateEndpointServiceConnectionStatus']]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class RCranPackageArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 repository: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: The package name.
        :param pulumi.Input[str] repository: The repository name.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if repository is not None:
            pulumi.set(__self__, "repository", repository)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The package name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def repository(self) -> Optional[pulumi.Input[str]]:
        """
        The repository name.
        """
        return pulumi.get(self, "repository")

    @repository.setter
    def repository(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repository", value)


@pulumi.input_type
class RGitHubPackageArgs:
    def __init__(__self__, *,
                 auth_token: Optional[pulumi.Input[str]] = None,
                 repository: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] auth_token: Personal access token to install from a private repo
        :param pulumi.Input[str] repository: Repository address in the format username/repo[/subdir][@ref|#pull].
        """
        if auth_token is not None:
            pulumi.set(__self__, "auth_token", auth_token)
        if repository is not None:
            pulumi.set(__self__, "repository", repository)

    @property
    @pulumi.getter(name="authToken")
    def auth_token(self) -> Optional[pulumi.Input[str]]:
        """
        Personal access token to install from a private repo
        """
        return pulumi.get(self, "auth_token")

    @auth_token.setter
    def auth_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auth_token", value)

    @property
    @pulumi.getter
    def repository(self) -> Optional[pulumi.Input[str]]:
        """
        Repository address in the format username/repo[/subdir][@ref|#pull].
        """
        return pulumi.get(self, "repository")

    @repository.setter
    def repository(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repository", value)


@pulumi.input_type
class ResourceIdArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str]):
        """
        Represents a resource ID. For example, for a subnet, it is the resource URL for the subnet.
        :param pulumi.Input[str] id: The ID of the resource
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        The ID of the resource
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class ScaleSettingsArgs:
    def __init__(__self__, *,
                 max_node_count: pulumi.Input[int],
                 min_node_count: Optional[pulumi.Input[int]] = None,
                 node_idle_time_before_scale_down: Optional[pulumi.Input[str]] = None):
        """
        scale settings for AML Compute
        :param pulumi.Input[int] max_node_count: Max number of nodes to use
        :param pulumi.Input[int] min_node_count: Min number of nodes to use
        :param pulumi.Input[str] node_idle_time_before_scale_down: Node Idle Time before scaling down amlCompute. This string needs to be in the RFC Format.
        """
        pulumi.set(__self__, "max_node_count", max_node_count)
        if min_node_count is None:
            min_node_count = 0
        if min_node_count is not None:
            pulumi.set(__self__, "min_node_count", min_node_count)
        if node_idle_time_before_scale_down is not None:
            pulumi.set(__self__, "node_idle_time_before_scale_down", node_idle_time_before_scale_down)

    @property
    @pulumi.getter(name="maxNodeCount")
    def max_node_count(self) -> pulumi.Input[int]:
        """
        Max number of nodes to use
        """
        return pulumi.get(self, "max_node_count")

    @max_node_count.setter
    def max_node_count(self, value: pulumi.Input[int]):
        pulumi.set(self, "max_node_count", value)

    @property
    @pulumi.getter(name="minNodeCount")
    def min_node_count(self) -> Optional[pulumi.Input[int]]:
        """
        Min number of nodes to use
        """
        return pulumi.get(self, "min_node_count")

    @min_node_count.setter
    def min_node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_node_count", value)

    @property
    @pulumi.getter(name="nodeIdleTimeBeforeScaleDown")
    def node_idle_time_before_scale_down(self) -> Optional[pulumi.Input[str]]:
        """
        Node Idle Time before scaling down amlCompute. This string needs to be in the RFC Format.
        """
        return pulumi.get(self, "node_idle_time_before_scale_down")

    @node_idle_time_before_scale_down.setter
    def node_idle_time_before_scale_down(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_idle_time_before_scale_down", value)


@pulumi.input_type
class SharedPrivateLinkResourceArgs:
    def __init__(__self__, *,
                 group_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 private_link_resource_id: Optional[pulumi.Input[str]] = None,
                 request_message: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[Union[str, 'PrivateEndpointServiceConnectionStatus']]] = None):
        """
        :param pulumi.Input[str] group_id: The private link resource group id.
        :param pulumi.Input[str] name: Unique name of the private link.
        :param pulumi.Input[str] private_link_resource_id: The resource id that private link links to.
        :param pulumi.Input[str] request_message: Request message.
        :param pulumi.Input[Union[str, 'PrivateEndpointServiceConnectionStatus']] status: Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
        """
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_link_resource_id is not None:
            pulumi.set(__self__, "private_link_resource_id", private_link_resource_id)
        if request_message is not None:
            pulumi.set(__self__, "request_message", request_message)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The private link resource group id.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Unique name of the private link.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="privateLinkResourceId")
    def private_link_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The resource id that private link links to.
        """
        return pulumi.get(self, "private_link_resource_id")

    @private_link_resource_id.setter
    def private_link_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_link_resource_id", value)

    @property
    @pulumi.getter(name="requestMessage")
    def request_message(self) -> Optional[pulumi.Input[str]]:
        """
        Request message.
        """
        return pulumi.get(self, "request_message")

    @request_message.setter
    def request_message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_message", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[Union[str, 'PrivateEndpointServiceConnectionStatus']]]:
        """
        Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[Union[str, 'PrivateEndpointServiceConnectionStatus']]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class SkuArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 tier: Optional[pulumi.Input[str]] = None):
        """
        Sku of the resource
        :param pulumi.Input[str] name: Name of the sku
        :param pulumi.Input[str] tier: Tier of the sku like Basic or Enterprise
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the sku
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tier(self) -> Optional[pulumi.Input[str]]:
        """
        Tier of the sku like Basic or Enterprise
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tier", value)


@pulumi.input_type
class SparkMavenPackageArgs:
    def __init__(__self__, *,
                 artifact: Optional[pulumi.Input[str]] = None,
                 group: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        if artifact is not None:
            pulumi.set(__self__, "artifact", artifact)
        if group is not None:
            pulumi.set(__self__, "group", group)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def artifact(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "artifact")

    @artifact.setter
    def artifact(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "artifact", value)

    @property
    @pulumi.getter
    def group(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "group")

    @group.setter
    def group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class SslConfigurationArgs:
    def __init__(__self__, *,
                 cert: Optional[pulumi.Input[str]] = None,
                 cname: Optional[pulumi.Input[str]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        The ssl configuration for scoring
        :param pulumi.Input[str] cert: Cert data
        :param pulumi.Input[str] cname: CNAME of the cert
        :param pulumi.Input[str] key: Key data
        :param pulumi.Input[str] status: Enable or disable ssl for scoring
        """
        if cert is not None:
            pulumi.set(__self__, "cert", cert)
        if cname is not None:
            pulumi.set(__self__, "cname", cname)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def cert(self) -> Optional[pulumi.Input[str]]:
        """
        Cert data
        """
        return pulumi.get(self, "cert")

    @cert.setter
    def cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cert", value)

    @property
    @pulumi.getter
    def cname(self) -> Optional[pulumi.Input[str]]:
        """
        CNAME of the cert
        """
        return pulumi.get(self, "cname")

    @cname.setter
    def cname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cname", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        Key data
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Enable or disable ssl for scoring
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class UserAccountCredentialsArgs:
    def __init__(__self__, *,
                 admin_user_name: pulumi.Input[str],
                 admin_user_password: Optional[pulumi.Input[str]] = None,
                 admin_user_ssh_public_key: Optional[pulumi.Input[str]] = None):
        """
        Settings for user account that gets created on each on the nodes of a compute.
        :param pulumi.Input[str] admin_user_name: Name of the administrator user account which can be used to SSH to nodes.
        :param pulumi.Input[str] admin_user_password: Password of the administrator user account.
        :param pulumi.Input[str] admin_user_ssh_public_key: SSH public key of the administrator user account.
        """
        pulumi.set(__self__, "admin_user_name", admin_user_name)
        if admin_user_password is not None:
            pulumi.set(__self__, "admin_user_password", admin_user_password)
        if admin_user_ssh_public_key is not None:
            pulumi.set(__self__, "admin_user_ssh_public_key", admin_user_ssh_public_key)

    @property
    @pulumi.getter(name="adminUserName")
    def admin_user_name(self) -> pulumi.Input[str]:
        """
        Name of the administrator user account which can be used to SSH to nodes.
        """
        return pulumi.get(self, "admin_user_name")

    @admin_user_name.setter
    def admin_user_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "admin_user_name", value)

    @property
    @pulumi.getter(name="adminUserPassword")
    def admin_user_password(self) -> Optional[pulumi.Input[str]]:
        """
        Password of the administrator user account.
        """
        return pulumi.get(self, "admin_user_password")

    @admin_user_password.setter
    def admin_user_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_user_password", value)

    @property
    @pulumi.getter(name="adminUserSshPublicKey")
    def admin_user_ssh_public_key(self) -> Optional[pulumi.Input[str]]:
        """
        SSH public key of the administrator user account.
        """
        return pulumi.get(self, "admin_user_ssh_public_key")

    @admin_user_ssh_public_key.setter
    def admin_user_ssh_public_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_user_ssh_public_key", value)


@pulumi.input_type
class VirtualMachineImageArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str]):
        """
        Virtual Machine image for Windows AML Compute
        :param pulumi.Input[str] id: Virtual Machine image path
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        Virtual Machine image path
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class VirtualMachinePropertiesArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[str]] = None,
                 administrator_account: Optional[pulumi.Input['VirtualMachineSshCredentialsArgs']] = None,
                 ssh_port: Optional[pulumi.Input[int]] = None,
                 virtual_machine_size: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] address: Public IP address of the virtual machine.
        :param pulumi.Input['VirtualMachineSshCredentialsArgs'] administrator_account: Admin credentials for virtual machine
        :param pulumi.Input[int] ssh_port: Port open for ssh connections.
        :param pulumi.Input[str] virtual_machine_size: Virtual Machine size
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if administrator_account is not None:
            pulumi.set(__self__, "administrator_account", administrator_account)
        if ssh_port is not None:
            pulumi.set(__self__, "ssh_port", ssh_port)
        if virtual_machine_size is not None:
            pulumi.set(__self__, "virtual_machine_size", virtual_machine_size)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[str]]:
        """
        Public IP address of the virtual machine.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter(name="administratorAccount")
    def administrator_account(self) -> Optional[pulumi.Input['VirtualMachineSshCredentialsArgs']]:
        """
        Admin credentials for virtual machine
        """
        return pulumi.get(self, "administrator_account")

    @administrator_account.setter
    def administrator_account(self, value: Optional[pulumi.Input['VirtualMachineSshCredentialsArgs']]):
        pulumi.set(self, "administrator_account", value)

    @property
    @pulumi.getter(name="sshPort")
    def ssh_port(self) -> Optional[pulumi.Input[int]]:
        """
        Port open for ssh connections.
        """
        return pulumi.get(self, "ssh_port")

    @ssh_port.setter
    def ssh_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ssh_port", value)

    @property
    @pulumi.getter(name="virtualMachineSize")
    def virtual_machine_size(self) -> Optional[pulumi.Input[str]]:
        """
        Virtual Machine size
        """
        return pulumi.get(self, "virtual_machine_size")

    @virtual_machine_size.setter
    def virtual_machine_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "virtual_machine_size", value)


@pulumi.input_type
class VirtualMachineSshCredentialsArgs:
    def __init__(__self__, *,
                 password: Optional[pulumi.Input[str]] = None,
                 private_key_data: Optional[pulumi.Input[str]] = None,
                 public_key_data: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        Admin credentials for virtual machine
        :param pulumi.Input[str] password: Password of admin account
        :param pulumi.Input[str] private_key_data: Private key data
        :param pulumi.Input[str] public_key_data: Public key data
        :param pulumi.Input[str] username: Username of admin account
        """
        if password is not None:
            pulumi.set(__self__, "password", password)
        if private_key_data is not None:
            pulumi.set(__self__, "private_key_data", private_key_data)
        if public_key_data is not None:
            pulumi.set(__self__, "public_key_data", public_key_data)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Password of admin account
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="privateKeyData")
    def private_key_data(self) -> Optional[pulumi.Input[str]]:
        """
        Private key data
        """
        return pulumi.get(self, "private_key_data")

    @private_key_data.setter
    def private_key_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_key_data", value)

    @property
    @pulumi.getter(name="publicKeyData")
    def public_key_data(self) -> Optional[pulumi.Input[str]]:
        """
        Public key data
        """
        return pulumi.get(self, "public_key_data")

    @public_key_data.setter
    def public_key_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_key_data", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        Username of admin account
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class VirtualMachineArgs:
    def __init__(__self__, *,
                 compute_type: pulumi.Input[str],
                 compute_location: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input['VirtualMachinePropertiesArgs']] = None,
                 resource_id: Optional[pulumi.Input[str]] = None):
        """
        A Machine Learning compute based on Azure Virtual Machines.
        :param pulumi.Input[str] compute_type: The type of compute
               Expected value is 'VirtualMachine'.
        :param pulumi.Input[str] compute_location: Location for the underlying compute
        :param pulumi.Input[str] description: The description of the Machine Learning compute.
        :param pulumi.Input[str] resource_id: ARM resource id of the underlying compute
        """
        pulumi.set(__self__, "compute_type", 'VirtualMachine')
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> pulumi.Input[str]:
        """
        The type of compute
        Expected value is 'VirtualMachine'.
        """
        return pulumi.get(self, "compute_type")

    @compute_type.setter
    def compute_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "compute_type", value)

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[pulumi.Input[str]]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @compute_location.setter
    def compute_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compute_location", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['VirtualMachinePropertiesArgs']]:
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['VirtualMachinePropertiesArgs']]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource id of the underlying compute
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)


