# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ACIServiceResponseResponse',
    'ACIServiceResponseResponseDataCollection',
    'ACIServiceResponseResponseEncryptionProperties',
    'ACIServiceResponseResponseEnvironmentImageRequest',
    'ACIServiceResponseResponseVnetConfiguration',
    'AKSReplicaStatusResponseError',
    'AKSResponse',
    'AKSResponseProperties',
    'AKSServiceResponseResponse',
    'AKSServiceResponseResponseAutoScaler',
    'AKSServiceResponseResponseDataCollection',
    'AKSServiceResponseResponseDeploymentStatus',
    'AKSServiceResponseResponseEnvironmentImageRequest',
    'AKSServiceResponseResponseLivenessProbeRequirements',
    'AKSVariantResponseResponse',
    'AksNetworkingConfigurationResponse',
    'AmlComputeNodeInformationResponse',
    'AmlComputeResponse',
    'AmlComputeResponseProperties',
    'AmlTokenResponse',
    'AssignedUserResponse',
    'AutoScaleSettingsResponse',
    'AzureDataLakeSectionResponse',
    'AzureMySqlSectionResponse',
    'AzurePostgreSqlSectionResponse',
    'AzureSqlDatabaseSectionResponse',
    'AzureStorageSectionResponse',
    'BanditPolicyResponse',
    'BatchDeploymentResponse',
    'BatchEndpointResponse',
    'BatchOutputConfigurationResponse',
    'BatchRetrySettingsResponse',
    'ClientCredentialsResponse',
    'CodeConfigurationResponse',
    'CodeContainerResponse',
    'CodeVersionResponse',
    'CommandJobResponse',
    'ComputeBindingResponse',
    'ComputeConfigurationResponse',
    'ComputeInstanceApplicationResponse',
    'ComputeInstanceConnectivityEndpointsResponse',
    'ComputeInstanceCreatedByResponse',
    'ComputeInstanceLastOperationResponse',
    'ComputeInstanceResponse',
    'ComputeInstanceResponseProperties',
    'ComputeInstanceSshSettingsResponse',
    'ContainerResourceRequirementsResponse',
    'CosmosDbSettingsResponse',
    'DataContainerResponse',
    'DataFactoryResponse',
    'DataLakeAnalyticsResponse',
    'DataLakeAnalyticsResponseProperties',
    'DataPathAssetReferenceResponse',
    'DataVersionResponse',
    'DatabricksResponse',
    'DatabricksResponseProperties',
    'DatasetReferenceResponse',
    'DatasetResponse',
    'DatasetResponseDataPath',
    'DatasetResponseLatest',
    'DatasetResponseSqlDataPath',
    'DatasetStateResponse',
    'DatasetStateResponseDeprecatedBy',
    'DatastoreResponse',
    'DockerBuildResponse',
    'DockerImagePlatformResponse',
    'DockerImageResponse',
    'EncryptionPropertyResponse',
    'EnvironmentContainerResponse',
    'EnvironmentImageResponseResponseEnvironment',
    'EnvironmentImageResponseResponseEnvironmentReference',
    'EnvironmentSpecificationVersionResponse',
    'ErrorDetailResponse',
    'ErrorResponseResponse',
    'FlavorDataResponse',
    'GlusterFsSectionResponse',
    'HDInsightResponse',
    'HDInsightResponseProperties',
    'IdAssetReferenceResponse',
    'IdentityForCmkResponse',
    'IdentityResponse',
    'ImageAssetResponse',
    'InferenceContainerPropertiesResponse',
    'InputDataBindingResponse',
    'JobEndpointResponse',
    'JobOutputResponse',
    'K8sOnlineDeploymentResponse',
    'KeyVaultPropertiesResponse',
    'LabelCategoryResponse',
    'LabelClassResponse',
    'LabelingDatasetConfigurationResponse',
    'LabelingJobImagePropertiesResponse',
    'LabelingJobInstructionsResponse',
    'LabelingJobPropertiesResponse',
    'LinkedInfoResponse',
    'LinkedServicePropsResponse',
    'LinkedWorkspacePropsResponse',
    'ListNotebookKeysResultResponse',
    'MLAssistConfigurationResponse',
    'MachineLearningServiceErrorResponse',
    'ManagedIdentityResponse',
    'ManagedOnlineDeploymentResponse',
    'ManualScaleSettingsResponse',
    'MedianStoppingPolicyResponse',
    'ModelContainerResponse',
    'ModelDockerSectionResponseResponseBaseImageRegistry',
    'ModelEnvironmentDefinitionResponseResponseDocker',
    'ModelEnvironmentDefinitionResponseResponsePython',
    'ModelEnvironmentDefinitionResponseResponseR',
    'ModelEnvironmentDefinitionResponseResponseSpark',
    'ModelResponse',
    'ModelVersionResponse',
    'MpiResponse',
    'NodeStateCountsResponse',
    'NotebookPreparationErrorResponse',
    'NotebookResourceInfoResponse',
    'ObjectiveResponse',
    'OnlineEndpointResponse',
    'OnlineRequestSettingsResponse',
    'OutputDataBindingResponse',
    'OutputPathAssetReferenceResponse',
    'PasswordResponse',
    'PersonalComputeInstanceSettingsResponse',
    'PrivateEndpointConnectionResponse',
    'PrivateEndpointResponse',
    'PrivateLinkServiceConnectionStateResponse',
    'ProbeSettingsResponse',
    'ProgressMetricsResponse',
    'PyTorchResponse',
    'RCranPackageResponse',
    'RGitHubPackageResponseResponse',
    'RegistryListCredentialsResultResponse',
    'ResourceIdResponse',
    'ResourceIdentityResponse',
    'RouteResponse',
    'ScaleSettingsResponse',
    'ScriptReferenceResponse',
    'ScriptsToExecuteResponse',
    'ServiceManagedResourcesSettingsResponse',
    'ServiceResponseBaseResponseError',
    'SetupScriptsResponse',
    'SharedPrivateLinkResourceResponse',
    'SkuResponse',
    'SparkMavenPackageResponse',
    'SslConfigurationResponse',
    'StatusMessageResponse',
    'SweepJobResponse',
    'SystemDataResponse',
    'SystemServiceResponse',
    'TensorFlowResponse',
    'TrialComponentResponse',
    'TruncationSelectionPolicyResponse',
    'UserAccountCredentialsResponse',
    'UserAssignedIdentityMetaResponse',
    'UserAssignedIdentityResponse',
    'UserInfoResponse',
    'VirtualMachineImageResponse',
    'VirtualMachineResponse',
    'VirtualMachineResponseProperties',
    'VirtualMachineSshCredentialsResponse',
]

@pulumi.output_type
class ACIServiceResponseResponse(dict):
    """
    The response for an ACI service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computeType":
            suggest = "compute_type"
        elif key == "modelConfigMap":
            suggest = "model_config_map"
        elif key == "scoringUri":
            suggest = "scoring_uri"
        elif key == "swaggerUri":
            suggest = "swagger_uri"
        elif key == "appInsightsEnabled":
            suggest = "app_insights_enabled"
        elif key == "authEnabled":
            suggest = "auth_enabled"
        elif key == "containerResourceRequirements":
            suggest = "container_resource_requirements"
        elif key == "dataCollection":
            suggest = "data_collection"
        elif key == "deploymentType":
            suggest = "deployment_type"
        elif key == "encryptionProperties":
            suggest = "encryption_properties"
        elif key == "environmentImageRequest":
            suggest = "environment_image_request"
        elif key == "kvTags":
            suggest = "kv_tags"
        elif key == "publicFqdn":
            suggest = "public_fqdn"
        elif key == "publicIp":
            suggest = "public_ip"
        elif key == "sslCertificate":
            suggest = "ssl_certificate"
        elif key == "sslEnabled":
            suggest = "ssl_enabled"
        elif key == "sslKey":
            suggest = "ssl_key"
        elif key == "vnetConfiguration":
            suggest = "vnet_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ACIServiceResponseResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ACIServiceResponseResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ACIServiceResponseResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compute_type: str,
                 error: 'outputs.ServiceResponseBaseResponseError',
                 model_config_map: Mapping[str, Any],
                 scoring_uri: str,
                 state: str,
                 swagger_uri: str,
                 app_insights_enabled: Optional[bool] = None,
                 auth_enabled: Optional[bool] = None,
                 cname: Optional[str] = None,
                 container_resource_requirements: Optional['outputs.ContainerResourceRequirementsResponse'] = None,
                 data_collection: Optional['outputs.ACIServiceResponseResponseDataCollection'] = None,
                 deployment_type: Optional[str] = None,
                 description: Optional[str] = None,
                 encryption_properties: Optional['outputs.ACIServiceResponseResponseEncryptionProperties'] = None,
                 environment_image_request: Optional['outputs.ACIServiceResponseResponseEnvironmentImageRequest'] = None,
                 kv_tags: Optional[Mapping[str, str]] = None,
                 location: Optional[str] = None,
                 models: Optional[Sequence['outputs.ModelResponse']] = None,
                 properties: Optional[Mapping[str, str]] = None,
                 public_fqdn: Optional[str] = None,
                 public_ip: Optional[str] = None,
                 ssl_certificate: Optional[str] = None,
                 ssl_enabled: Optional[bool] = None,
                 ssl_key: Optional[str] = None,
                 vnet_configuration: Optional['outputs.ACIServiceResponseResponseVnetConfiguration'] = None):
        """
        The response for an ACI service.
        :param str compute_type: The compute environment type for the service.
               Expected value is 'ACI'.
        :param 'ServiceResponseBaseResponseError' error: The error details.
        :param Mapping[str, Any] model_config_map: Details on the models and configurations.
        :param str scoring_uri: The Uri for sending scoring requests.
        :param str state: The current state of the service.
        :param str swagger_uri: The Uri for sending swagger requests.
        :param bool app_insights_enabled: Whether or not Application Insights is enabled.
        :param bool auth_enabled: Whether or not authentication is enabled on the service.
        :param str cname: The CName for the service.
        :param 'ContainerResourceRequirementsResponse' container_resource_requirements: The container resource requirements.
        :param 'ACIServiceResponseResponseDataCollection' data_collection: Details of the data collection options specified.
        :param str deployment_type: The deployment type for the service.
        :param str description: The service description.
        :param 'ACIServiceResponseResponseEncryptionProperties' encryption_properties: The encryption properties.
        :param 'ACIServiceResponseResponseEnvironmentImageRequest' environment_image_request: The Environment, models and assets used for inferencing.
        :param Mapping[str, str] kv_tags: The service tag dictionary. Tags are mutable.
        :param str location: The name of the Azure location/region.
        :param Sequence['ModelResponse'] models: The list of models.
        :param Mapping[str, str] properties: The service property dictionary. Properties are immutable.
        :param str public_fqdn: The public Fqdn for the service.
        :param str public_ip: The public IP address for the service.
        :param str ssl_certificate: The public SSL certificate in PEM format to use if SSL is enabled.
        :param bool ssl_enabled: Whether or not SSL is enabled.
        :param str ssl_key: The public SSL key in PEM format for the certificate.
        :param 'ACIServiceResponseResponseVnetConfiguration' vnet_configuration: The virtual network configuration.
        """
        pulumi.set(__self__, "compute_type", 'ACI')
        pulumi.set(__self__, "error", error)
        pulumi.set(__self__, "model_config_map", model_config_map)
        pulumi.set(__self__, "scoring_uri", scoring_uri)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "swagger_uri", swagger_uri)
        if app_insights_enabled is not None:
            pulumi.set(__self__, "app_insights_enabled", app_insights_enabled)
        if auth_enabled is not None:
            pulumi.set(__self__, "auth_enabled", auth_enabled)
        if cname is not None:
            pulumi.set(__self__, "cname", cname)
        if container_resource_requirements is not None:
            pulumi.set(__self__, "container_resource_requirements", container_resource_requirements)
        if data_collection is not None:
            pulumi.set(__self__, "data_collection", data_collection)
        if deployment_type is not None:
            pulumi.set(__self__, "deployment_type", deployment_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encryption_properties is not None:
            pulumi.set(__self__, "encryption_properties", encryption_properties)
        if environment_image_request is not None:
            pulumi.set(__self__, "environment_image_request", environment_image_request)
        if kv_tags is not None:
            pulumi.set(__self__, "kv_tags", kv_tags)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if models is not None:
            pulumi.set(__self__, "models", models)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if public_fqdn is not None:
            pulumi.set(__self__, "public_fqdn", public_fqdn)
        if public_ip is not None:
            pulumi.set(__self__, "public_ip", public_ip)
        if ssl_certificate is not None:
            pulumi.set(__self__, "ssl_certificate", ssl_certificate)
        if ssl_enabled is not None:
            pulumi.set(__self__, "ssl_enabled", ssl_enabled)
        if ssl_key is not None:
            pulumi.set(__self__, "ssl_key", ssl_key)
        if vnet_configuration is not None:
            pulumi.set(__self__, "vnet_configuration", vnet_configuration)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> str:
        """
        The compute environment type for the service.
        Expected value is 'ACI'.
        """
        return pulumi.get(self, "compute_type")

    @property
    @pulumi.getter
    def error(self) -> 'outputs.ServiceResponseBaseResponseError':
        """
        The error details.
        """
        return pulumi.get(self, "error")

    @property
    @pulumi.getter(name="modelConfigMap")
    def model_config_map(self) -> Mapping[str, Any]:
        """
        Details on the models and configurations.
        """
        return pulumi.get(self, "model_config_map")

    @property
    @pulumi.getter(name="scoringUri")
    def scoring_uri(self) -> str:
        """
        The Uri for sending scoring requests.
        """
        return pulumi.get(self, "scoring_uri")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the service.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="swaggerUri")
    def swagger_uri(self) -> str:
        """
        The Uri for sending swagger requests.
        """
        return pulumi.get(self, "swagger_uri")

    @property
    @pulumi.getter(name="appInsightsEnabled")
    def app_insights_enabled(self) -> Optional[bool]:
        """
        Whether or not Application Insights is enabled.
        """
        return pulumi.get(self, "app_insights_enabled")

    @property
    @pulumi.getter(name="authEnabled")
    def auth_enabled(self) -> Optional[bool]:
        """
        Whether or not authentication is enabled on the service.
        """
        return pulumi.get(self, "auth_enabled")

    @property
    @pulumi.getter
    def cname(self) -> Optional[str]:
        """
        The CName for the service.
        """
        return pulumi.get(self, "cname")

    @property
    @pulumi.getter(name="containerResourceRequirements")
    def container_resource_requirements(self) -> Optional['outputs.ContainerResourceRequirementsResponse']:
        """
        The container resource requirements.
        """
        return pulumi.get(self, "container_resource_requirements")

    @property
    @pulumi.getter(name="dataCollection")
    def data_collection(self) -> Optional['outputs.ACIServiceResponseResponseDataCollection']:
        """
        Details of the data collection options specified.
        """
        return pulumi.get(self, "data_collection")

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> Optional[str]:
        """
        The deployment type for the service.
        """
        return pulumi.get(self, "deployment_type")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The service description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="encryptionProperties")
    def encryption_properties(self) -> Optional['outputs.ACIServiceResponseResponseEncryptionProperties']:
        """
        The encryption properties.
        """
        return pulumi.get(self, "encryption_properties")

    @property
    @pulumi.getter(name="environmentImageRequest")
    def environment_image_request(self) -> Optional['outputs.ACIServiceResponseResponseEnvironmentImageRequest']:
        """
        The Environment, models and assets used for inferencing.
        """
        return pulumi.get(self, "environment_image_request")

    @property
    @pulumi.getter(name="kvTags")
    def kv_tags(self) -> Optional[Mapping[str, str]]:
        """
        The service tag dictionary. Tags are mutable.
        """
        return pulumi.get(self, "kv_tags")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        The name of the Azure location/region.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def models(self) -> Optional[Sequence['outputs.ModelResponse']]:
        """
        The list of models.
        """
        return pulumi.get(self, "models")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        The service property dictionary. Properties are immutable.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="publicFqdn")
    def public_fqdn(self) -> Optional[str]:
        """
        The public Fqdn for the service.
        """
        return pulumi.get(self, "public_fqdn")

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> Optional[str]:
        """
        The public IP address for the service.
        """
        return pulumi.get(self, "public_ip")

    @property
    @pulumi.getter(name="sslCertificate")
    def ssl_certificate(self) -> Optional[str]:
        """
        The public SSL certificate in PEM format to use if SSL is enabled.
        """
        return pulumi.get(self, "ssl_certificate")

    @property
    @pulumi.getter(name="sslEnabled")
    def ssl_enabled(self) -> Optional[bool]:
        """
        Whether or not SSL is enabled.
        """
        return pulumi.get(self, "ssl_enabled")

    @property
    @pulumi.getter(name="sslKey")
    def ssl_key(self) -> Optional[str]:
        """
        The public SSL key in PEM format for the certificate.
        """
        return pulumi.get(self, "ssl_key")

    @property
    @pulumi.getter(name="vnetConfiguration")
    def vnet_configuration(self) -> Optional['outputs.ACIServiceResponseResponseVnetConfiguration']:
        """
        The virtual network configuration.
        """
        return pulumi.get(self, "vnet_configuration")


@pulumi.output_type
class ACIServiceResponseResponseDataCollection(dict):
    """
    Details of the data collection options specified.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eventHubEnabled":
            suggest = "event_hub_enabled"
        elif key == "storageEnabled":
            suggest = "storage_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ACIServiceResponseResponseDataCollection. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ACIServiceResponseResponseDataCollection.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ACIServiceResponseResponseDataCollection.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 event_hub_enabled: Optional[bool] = None,
                 storage_enabled: Optional[bool] = None):
        """
        Details of the data collection options specified.
        :param bool event_hub_enabled: Option for enabling/disabling Event Hub.
        :param bool storage_enabled: Option for enabling/disabling storage.
        """
        if event_hub_enabled is not None:
            pulumi.set(__self__, "event_hub_enabled", event_hub_enabled)
        if storage_enabled is not None:
            pulumi.set(__self__, "storage_enabled", storage_enabled)

    @property
    @pulumi.getter(name="eventHubEnabled")
    def event_hub_enabled(self) -> Optional[bool]:
        """
        Option for enabling/disabling Event Hub.
        """
        return pulumi.get(self, "event_hub_enabled")

    @property
    @pulumi.getter(name="storageEnabled")
    def storage_enabled(self) -> Optional[bool]:
        """
        Option for enabling/disabling storage.
        """
        return pulumi.get(self, "storage_enabled")


@pulumi.output_type
class ACIServiceResponseResponseEncryptionProperties(dict):
    """
    The encryption properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyName":
            suggest = "key_name"
        elif key == "keyVersion":
            suggest = "key_version"
        elif key == "vaultBaseUrl":
            suggest = "vault_base_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ACIServiceResponseResponseEncryptionProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ACIServiceResponseResponseEncryptionProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ACIServiceResponseResponseEncryptionProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_name: str,
                 key_version: str,
                 vault_base_url: str):
        """
        The encryption properties.
        :param str key_name: Encryption Key name
        :param str key_version: Encryption Key Version
        :param str vault_base_url: vault base Url
        """
        pulumi.set(__self__, "key_name", key_name)
        pulumi.set(__self__, "key_version", key_version)
        pulumi.set(__self__, "vault_base_url", vault_base_url)

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> str:
        """
        Encryption Key name
        """
        return pulumi.get(self, "key_name")

    @property
    @pulumi.getter(name="keyVersion")
    def key_version(self) -> str:
        """
        Encryption Key Version
        """
        return pulumi.get(self, "key_version")

    @property
    @pulumi.getter(name="vaultBaseUrl")
    def vault_base_url(self) -> str:
        """
        vault base Url
        """
        return pulumi.get(self, "vault_base_url")


@pulumi.output_type
class ACIServiceResponseResponseEnvironmentImageRequest(dict):
    """
    The Environment, models and assets used for inferencing.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "driverProgram":
            suggest = "driver_program"
        elif key == "environmentReference":
            suggest = "environment_reference"
        elif key == "modelIds":
            suggest = "model_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ACIServiceResponseResponseEnvironmentImageRequest. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ACIServiceResponseResponseEnvironmentImageRequest.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ACIServiceResponseResponseEnvironmentImageRequest.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 assets: Optional[Sequence['outputs.ImageAssetResponse']] = None,
                 driver_program: Optional[str] = None,
                 environment: Optional['outputs.EnvironmentImageResponseResponseEnvironment'] = None,
                 environment_reference: Optional['outputs.EnvironmentImageResponseResponseEnvironmentReference'] = None,
                 model_ids: Optional[Sequence[str]] = None,
                 models: Optional[Sequence['outputs.ModelResponse']] = None):
        """
        The Environment, models and assets used for inferencing.
        :param Sequence['ImageAssetResponse'] assets: The list of assets.
        :param str driver_program: The name of the driver file.
        :param 'EnvironmentImageResponseResponseEnvironment' environment: The details of the AZURE ML environment.
        :param 'EnvironmentImageResponseResponseEnvironmentReference' environment_reference: The unique identifying details of the AZURE ML environment.
        :param Sequence[str] model_ids: The list of model Ids.
        :param Sequence['ModelResponse'] models: The list of models.
        """
        if assets is not None:
            pulumi.set(__self__, "assets", assets)
        if driver_program is not None:
            pulumi.set(__self__, "driver_program", driver_program)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if environment_reference is not None:
            pulumi.set(__self__, "environment_reference", environment_reference)
        if model_ids is not None:
            pulumi.set(__self__, "model_ids", model_ids)
        if models is not None:
            pulumi.set(__self__, "models", models)

    @property
    @pulumi.getter
    def assets(self) -> Optional[Sequence['outputs.ImageAssetResponse']]:
        """
        The list of assets.
        """
        return pulumi.get(self, "assets")

    @property
    @pulumi.getter(name="driverProgram")
    def driver_program(self) -> Optional[str]:
        """
        The name of the driver file.
        """
        return pulumi.get(self, "driver_program")

    @property
    @pulumi.getter
    def environment(self) -> Optional['outputs.EnvironmentImageResponseResponseEnvironment']:
        """
        The details of the AZURE ML environment.
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter(name="environmentReference")
    def environment_reference(self) -> Optional['outputs.EnvironmentImageResponseResponseEnvironmentReference']:
        """
        The unique identifying details of the AZURE ML environment.
        """
        return pulumi.get(self, "environment_reference")

    @property
    @pulumi.getter(name="modelIds")
    def model_ids(self) -> Optional[Sequence[str]]:
        """
        The list of model Ids.
        """
        return pulumi.get(self, "model_ids")

    @property
    @pulumi.getter
    def models(self) -> Optional[Sequence['outputs.ModelResponse']]:
        """
        The list of models.
        """
        return pulumi.get(self, "models")


@pulumi.output_type
class ACIServiceResponseResponseVnetConfiguration(dict):
    """
    The virtual network configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subnetName":
            suggest = "subnet_name"
        elif key == "vnetName":
            suggest = "vnet_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ACIServiceResponseResponseVnetConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ACIServiceResponseResponseVnetConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ACIServiceResponseResponseVnetConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subnet_name: Optional[str] = None,
                 vnet_name: Optional[str] = None):
        """
        The virtual network configuration.
        :param str subnet_name: The name of the virtual network subnet.
        :param str vnet_name: The name of the virtual network.
        """
        if subnet_name is not None:
            pulumi.set(__self__, "subnet_name", subnet_name)
        if vnet_name is not None:
            pulumi.set(__self__, "vnet_name", vnet_name)

    @property
    @pulumi.getter(name="subnetName")
    def subnet_name(self) -> Optional[str]:
        """
        The name of the virtual network subnet.
        """
        return pulumi.get(self, "subnet_name")

    @property
    @pulumi.getter(name="vnetName")
    def vnet_name(self) -> Optional[str]:
        """
        The name of the virtual network.
        """
        return pulumi.get(self, "vnet_name")


@pulumi.output_type
class AKSReplicaStatusResponseError(dict):
    """
    The error details.
    """
    def __init__(__self__, *,
                 error: 'outputs.ErrorResponseResponse'):
        """
        The error details.
        :param 'ErrorResponseResponse' error: The error response.
        """
        pulumi.set(__self__, "error", error)

    @property
    @pulumi.getter
    def error(self) -> 'outputs.ErrorResponseResponse':
        """
        The error response.
        """
        return pulumi.get(self, "error")


@pulumi.output_type
class AKSResponse(dict):
    """
    A Machine Learning compute based on AKS.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computeType":
            suggest = "compute_type"
        elif key == "isAttachedCompute":
            suggest = "is_attached_compute"
        elif key == "provisioningErrors":
            suggest = "provisioning_errors"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "computeLocation":
            suggest = "compute_location"
        elif key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AKSResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AKSResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AKSResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compute_type: str,
                 is_attached_compute: bool,
                 provisioning_errors: Sequence['outputs.MachineLearningServiceErrorResponse'],
                 provisioning_state: str,
                 compute_location: Optional[str] = None,
                 description: Optional[str] = None,
                 properties: Optional['outputs.AKSResponseProperties'] = None,
                 resource_id: Optional[str] = None):
        """
        A Machine Learning compute based on AKS.
        :param str compute_type: The type of compute
               Expected value is 'AKS'.
        :param bool is_attached_compute: Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
        :param Sequence['MachineLearningServiceErrorResponse'] provisioning_errors: Errors during provisioning
        :param str provisioning_state: The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        :param str compute_location: Location for the underlying compute
        :param str description: The description of the Machine Learning compute.
        :param 'AKSResponseProperties' properties: AKS properties
        :param str resource_id: ARM resource id of the underlying compute
        """
        pulumi.set(__self__, "compute_type", 'AKS')
        pulumi.set(__self__, "is_attached_compute", is_attached_compute)
        pulumi.set(__self__, "provisioning_errors", provisioning_errors)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> str:
        """
        The type of compute
        Expected value is 'AKS'.
        """
        return pulumi.get(self, "compute_type")

    @property
    @pulumi.getter(name="isAttachedCompute")
    def is_attached_compute(self) -> bool:
        """
        Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
        """
        return pulumi.get(self, "is_attached_compute")

    @property
    @pulumi.getter(name="provisioningErrors")
    def provisioning_errors(self) -> Sequence['outputs.MachineLearningServiceErrorResponse']:
        """
        Errors during provisioning
        """
        return pulumi.get(self, "provisioning_errors")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[str]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.AKSResponseProperties']:
        """
        AKS properties
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        ARM resource id of the underlying compute
        """
        return pulumi.get(self, "resource_id")


@pulumi.output_type
class AKSResponseProperties(dict):
    """
    AKS properties
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "systemServices":
            suggest = "system_services"
        elif key == "agentCount":
            suggest = "agent_count"
        elif key == "agentVmSize":
            suggest = "agent_vm_size"
        elif key == "aksNetworkingConfiguration":
            suggest = "aks_networking_configuration"
        elif key == "clusterFqdn":
            suggest = "cluster_fqdn"
        elif key == "clusterPurpose":
            suggest = "cluster_purpose"
        elif key == "sslConfiguration":
            suggest = "ssl_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AKSResponseProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AKSResponseProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AKSResponseProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 system_services: Sequence['outputs.SystemServiceResponse'],
                 agent_count: Optional[int] = None,
                 agent_vm_size: Optional[str] = None,
                 aks_networking_configuration: Optional['outputs.AksNetworkingConfigurationResponse'] = None,
                 cluster_fqdn: Optional[str] = None,
                 cluster_purpose: Optional[str] = None,
                 ssl_configuration: Optional['outputs.SslConfigurationResponse'] = None):
        """
        AKS properties
        :param Sequence['SystemServiceResponse'] system_services: System services
        :param int agent_count: Number of agents
        :param str agent_vm_size: Agent virtual machine size
        :param 'AksNetworkingConfigurationResponse' aks_networking_configuration: AKS networking configuration for vnet
        :param str cluster_fqdn: Cluster full qualified domain name
        :param str cluster_purpose: Intended usage of the cluster
        :param 'SslConfigurationResponse' ssl_configuration: SSL configuration
        """
        pulumi.set(__self__, "system_services", system_services)
        if agent_count is not None:
            pulumi.set(__self__, "agent_count", agent_count)
        if agent_vm_size is not None:
            pulumi.set(__self__, "agent_vm_size", agent_vm_size)
        if aks_networking_configuration is not None:
            pulumi.set(__self__, "aks_networking_configuration", aks_networking_configuration)
        if cluster_fqdn is not None:
            pulumi.set(__self__, "cluster_fqdn", cluster_fqdn)
        if cluster_purpose is None:
            cluster_purpose = 'FastProd'
        if cluster_purpose is not None:
            pulumi.set(__self__, "cluster_purpose", cluster_purpose)
        if ssl_configuration is not None:
            pulumi.set(__self__, "ssl_configuration", ssl_configuration)

    @property
    @pulumi.getter(name="systemServices")
    def system_services(self) -> Sequence['outputs.SystemServiceResponse']:
        """
        System services
        """
        return pulumi.get(self, "system_services")

    @property
    @pulumi.getter(name="agentCount")
    def agent_count(self) -> Optional[int]:
        """
        Number of agents
        """
        return pulumi.get(self, "agent_count")

    @property
    @pulumi.getter(name="agentVmSize")
    def agent_vm_size(self) -> Optional[str]:
        """
        Agent virtual machine size
        """
        return pulumi.get(self, "agent_vm_size")

    @property
    @pulumi.getter(name="aksNetworkingConfiguration")
    def aks_networking_configuration(self) -> Optional['outputs.AksNetworkingConfigurationResponse']:
        """
        AKS networking configuration for vnet
        """
        return pulumi.get(self, "aks_networking_configuration")

    @property
    @pulumi.getter(name="clusterFqdn")
    def cluster_fqdn(self) -> Optional[str]:
        """
        Cluster full qualified domain name
        """
        return pulumi.get(self, "cluster_fqdn")

    @property
    @pulumi.getter(name="clusterPurpose")
    def cluster_purpose(self) -> Optional[str]:
        """
        Intended usage of the cluster
        """
        return pulumi.get(self, "cluster_purpose")

    @property
    @pulumi.getter(name="sslConfiguration")
    def ssl_configuration(self) -> Optional['outputs.SslConfigurationResponse']:
        """
        SSL configuration
        """
        return pulumi.get(self, "ssl_configuration")


@pulumi.output_type
class AKSServiceResponseResponse(dict):
    """
    The response for an AKS service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computeType":
            suggest = "compute_type"
        elif key == "deploymentStatus":
            suggest = "deployment_status"
        elif key == "modelConfigMap":
            suggest = "model_config_map"
        elif key == "scoringUri":
            suggest = "scoring_uri"
        elif key == "swaggerUri":
            suggest = "swagger_uri"
        elif key == "aadAuthEnabled":
            suggest = "aad_auth_enabled"
        elif key == "appInsightsEnabled":
            suggest = "app_insights_enabled"
        elif key == "authEnabled":
            suggest = "auth_enabled"
        elif key == "autoScaler":
            suggest = "auto_scaler"
        elif key == "computeName":
            suggest = "compute_name"
        elif key == "containerResourceRequirements":
            suggest = "container_resource_requirements"
        elif key == "dataCollection":
            suggest = "data_collection"
        elif key == "deploymentType":
            suggest = "deployment_type"
        elif key == "environmentImageRequest":
            suggest = "environment_image_request"
        elif key == "isDefault":
            suggest = "is_default"
        elif key == "kvTags":
            suggest = "kv_tags"
        elif key == "livenessProbeRequirements":
            suggest = "liveness_probe_requirements"
        elif key == "maxConcurrentRequestsPerContainer":
            suggest = "max_concurrent_requests_per_container"
        elif key == "maxQueueWaitMs":
            suggest = "max_queue_wait_ms"
        elif key == "numReplicas":
            suggest = "num_replicas"
        elif key == "scoringTimeoutMs":
            suggest = "scoring_timeout_ms"
        elif key == "trafficPercentile":
            suggest = "traffic_percentile"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AKSServiceResponseResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AKSServiceResponseResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AKSServiceResponseResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compute_type: str,
                 deployment_status: 'outputs.AKSServiceResponseResponseDeploymentStatus',
                 error: 'outputs.ServiceResponseBaseResponseError',
                 model_config_map: Mapping[str, Any],
                 scoring_uri: str,
                 state: str,
                 swagger_uri: str,
                 aad_auth_enabled: Optional[bool] = None,
                 app_insights_enabled: Optional[bool] = None,
                 auth_enabled: Optional[bool] = None,
                 auto_scaler: Optional['outputs.AKSServiceResponseResponseAutoScaler'] = None,
                 compute_name: Optional[str] = None,
                 container_resource_requirements: Optional['outputs.ContainerResourceRequirementsResponse'] = None,
                 data_collection: Optional['outputs.AKSServiceResponseResponseDataCollection'] = None,
                 deployment_type: Optional[str] = None,
                 description: Optional[str] = None,
                 environment_image_request: Optional['outputs.AKSServiceResponseResponseEnvironmentImageRequest'] = None,
                 is_default: Optional[bool] = None,
                 kv_tags: Optional[Mapping[str, str]] = None,
                 liveness_probe_requirements: Optional['outputs.AKSServiceResponseResponseLivenessProbeRequirements'] = None,
                 max_concurrent_requests_per_container: Optional[int] = None,
                 max_queue_wait_ms: Optional[int] = None,
                 models: Optional[Sequence['outputs.ModelResponse']] = None,
                 namespace: Optional[str] = None,
                 num_replicas: Optional[int] = None,
                 properties: Optional[Mapping[str, str]] = None,
                 scoring_timeout_ms: Optional[int] = None,
                 traffic_percentile: Optional[float] = None,
                 type: Optional[str] = None):
        """
        The response for an AKS service.
        :param str compute_type: The compute environment type for the service.
               Expected value is 'AKS'.
        :param 'AKSServiceResponseResponseDeploymentStatus' deployment_status: The deployment status.
        :param 'ServiceResponseBaseResponseError' error: The error details.
        :param Mapping[str, Any] model_config_map: Details on the models and configurations.
        :param str scoring_uri: The Uri for sending scoring requests.
        :param str state: The current state of the service.
        :param str swagger_uri: The Uri for sending swagger requests.
        :param bool aad_auth_enabled: Whether or not AAD authentication is enabled.
        :param bool app_insights_enabled: Whether or not Application Insights is enabled.
        :param bool auth_enabled: Whether or not authentication is enabled.
        :param 'AKSServiceResponseResponseAutoScaler' auto_scaler: The auto scaler properties.
        :param str compute_name: The name of the compute resource.
        :param 'ContainerResourceRequirementsResponse' container_resource_requirements: The container resource requirements.
        :param 'AKSServiceResponseResponseDataCollection' data_collection: Details of the data collection options specified.
        :param str deployment_type: The deployment type for the service.
        :param str description: The service description.
        :param 'AKSServiceResponseResponseEnvironmentImageRequest' environment_image_request: The Environment, models and assets used for inferencing.
        :param bool is_default: Is this the default variant.
        :param Mapping[str, str] kv_tags: The service tag dictionary. Tags are mutable.
        :param 'AKSServiceResponseResponseLivenessProbeRequirements' liveness_probe_requirements: The liveness probe requirements.
        :param int max_concurrent_requests_per_container: The maximum number of concurrent requests per container.
        :param int max_queue_wait_ms: Maximum time a request will wait in the queue (in milliseconds). After this time, the service will return 503 (Service Unavailable)
        :param Sequence['ModelResponse'] models: The list of models.
        :param str namespace: The Kubernetes namespace of the deployment.
        :param int num_replicas: The number of replicas on the cluster.
        :param Mapping[str, str] properties: The service property dictionary. Properties are immutable.
        :param int scoring_timeout_ms: The scoring timeout in milliseconds.
        :param float traffic_percentile: The amount of traffic variant receives.
        :param str type: The type of the variant.
        """
        pulumi.set(__self__, "compute_type", 'AKS')
        pulumi.set(__self__, "deployment_status", deployment_status)
        pulumi.set(__self__, "error", error)
        pulumi.set(__self__, "model_config_map", model_config_map)
        pulumi.set(__self__, "scoring_uri", scoring_uri)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "swagger_uri", swagger_uri)
        if aad_auth_enabled is not None:
            pulumi.set(__self__, "aad_auth_enabled", aad_auth_enabled)
        if app_insights_enabled is not None:
            pulumi.set(__self__, "app_insights_enabled", app_insights_enabled)
        if auth_enabled is not None:
            pulumi.set(__self__, "auth_enabled", auth_enabled)
        if auto_scaler is not None:
            pulumi.set(__self__, "auto_scaler", auto_scaler)
        if compute_name is not None:
            pulumi.set(__self__, "compute_name", compute_name)
        if container_resource_requirements is not None:
            pulumi.set(__self__, "container_resource_requirements", container_resource_requirements)
        if data_collection is not None:
            pulumi.set(__self__, "data_collection", data_collection)
        if deployment_type is not None:
            pulumi.set(__self__, "deployment_type", deployment_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if environment_image_request is not None:
            pulumi.set(__self__, "environment_image_request", environment_image_request)
        if is_default is not None:
            pulumi.set(__self__, "is_default", is_default)
        if kv_tags is not None:
            pulumi.set(__self__, "kv_tags", kv_tags)
        if liveness_probe_requirements is not None:
            pulumi.set(__self__, "liveness_probe_requirements", liveness_probe_requirements)
        if max_concurrent_requests_per_container is not None:
            pulumi.set(__self__, "max_concurrent_requests_per_container", max_concurrent_requests_per_container)
        if max_queue_wait_ms is not None:
            pulumi.set(__self__, "max_queue_wait_ms", max_queue_wait_ms)
        if models is not None:
            pulumi.set(__self__, "models", models)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if num_replicas is not None:
            pulumi.set(__self__, "num_replicas", num_replicas)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if scoring_timeout_ms is not None:
            pulumi.set(__self__, "scoring_timeout_ms", scoring_timeout_ms)
        if traffic_percentile is not None:
            pulumi.set(__self__, "traffic_percentile", traffic_percentile)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> str:
        """
        The compute environment type for the service.
        Expected value is 'AKS'.
        """
        return pulumi.get(self, "compute_type")

    @property
    @pulumi.getter(name="deploymentStatus")
    def deployment_status(self) -> 'outputs.AKSServiceResponseResponseDeploymentStatus':
        """
        The deployment status.
        """
        return pulumi.get(self, "deployment_status")

    @property
    @pulumi.getter
    def error(self) -> 'outputs.ServiceResponseBaseResponseError':
        """
        The error details.
        """
        return pulumi.get(self, "error")

    @property
    @pulumi.getter(name="modelConfigMap")
    def model_config_map(self) -> Mapping[str, Any]:
        """
        Details on the models and configurations.
        """
        return pulumi.get(self, "model_config_map")

    @property
    @pulumi.getter(name="scoringUri")
    def scoring_uri(self) -> str:
        """
        The Uri for sending scoring requests.
        """
        return pulumi.get(self, "scoring_uri")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the service.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="swaggerUri")
    def swagger_uri(self) -> str:
        """
        The Uri for sending swagger requests.
        """
        return pulumi.get(self, "swagger_uri")

    @property
    @pulumi.getter(name="aadAuthEnabled")
    def aad_auth_enabled(self) -> Optional[bool]:
        """
        Whether or not AAD authentication is enabled.
        """
        return pulumi.get(self, "aad_auth_enabled")

    @property
    @pulumi.getter(name="appInsightsEnabled")
    def app_insights_enabled(self) -> Optional[bool]:
        """
        Whether or not Application Insights is enabled.
        """
        return pulumi.get(self, "app_insights_enabled")

    @property
    @pulumi.getter(name="authEnabled")
    def auth_enabled(self) -> Optional[bool]:
        """
        Whether or not authentication is enabled.
        """
        return pulumi.get(self, "auth_enabled")

    @property
    @pulumi.getter(name="autoScaler")
    def auto_scaler(self) -> Optional['outputs.AKSServiceResponseResponseAutoScaler']:
        """
        The auto scaler properties.
        """
        return pulumi.get(self, "auto_scaler")

    @property
    @pulumi.getter(name="computeName")
    def compute_name(self) -> Optional[str]:
        """
        The name of the compute resource.
        """
        return pulumi.get(self, "compute_name")

    @property
    @pulumi.getter(name="containerResourceRequirements")
    def container_resource_requirements(self) -> Optional['outputs.ContainerResourceRequirementsResponse']:
        """
        The container resource requirements.
        """
        return pulumi.get(self, "container_resource_requirements")

    @property
    @pulumi.getter(name="dataCollection")
    def data_collection(self) -> Optional['outputs.AKSServiceResponseResponseDataCollection']:
        """
        Details of the data collection options specified.
        """
        return pulumi.get(self, "data_collection")

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> Optional[str]:
        """
        The deployment type for the service.
        """
        return pulumi.get(self, "deployment_type")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The service description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="environmentImageRequest")
    def environment_image_request(self) -> Optional['outputs.AKSServiceResponseResponseEnvironmentImageRequest']:
        """
        The Environment, models and assets used for inferencing.
        """
        return pulumi.get(self, "environment_image_request")

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> Optional[bool]:
        """
        Is this the default variant.
        """
        return pulumi.get(self, "is_default")

    @property
    @pulumi.getter(name="kvTags")
    def kv_tags(self) -> Optional[Mapping[str, str]]:
        """
        The service tag dictionary. Tags are mutable.
        """
        return pulumi.get(self, "kv_tags")

    @property
    @pulumi.getter(name="livenessProbeRequirements")
    def liveness_probe_requirements(self) -> Optional['outputs.AKSServiceResponseResponseLivenessProbeRequirements']:
        """
        The liveness probe requirements.
        """
        return pulumi.get(self, "liveness_probe_requirements")

    @property
    @pulumi.getter(name="maxConcurrentRequestsPerContainer")
    def max_concurrent_requests_per_container(self) -> Optional[int]:
        """
        The maximum number of concurrent requests per container.
        """
        return pulumi.get(self, "max_concurrent_requests_per_container")

    @property
    @pulumi.getter(name="maxQueueWaitMs")
    def max_queue_wait_ms(self) -> Optional[int]:
        """
        Maximum time a request will wait in the queue (in milliseconds). After this time, the service will return 503 (Service Unavailable)
        """
        return pulumi.get(self, "max_queue_wait_ms")

    @property
    @pulumi.getter
    def models(self) -> Optional[Sequence['outputs.ModelResponse']]:
        """
        The list of models.
        """
        return pulumi.get(self, "models")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[str]:
        """
        The Kubernetes namespace of the deployment.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="numReplicas")
    def num_replicas(self) -> Optional[int]:
        """
        The number of replicas on the cluster.
        """
        return pulumi.get(self, "num_replicas")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        The service property dictionary. Properties are immutable.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="scoringTimeoutMs")
    def scoring_timeout_ms(self) -> Optional[int]:
        """
        The scoring timeout in milliseconds.
        """
        return pulumi.get(self, "scoring_timeout_ms")

    @property
    @pulumi.getter(name="trafficPercentile")
    def traffic_percentile(self) -> Optional[float]:
        """
        The amount of traffic variant receives.
        """
        return pulumi.get(self, "traffic_percentile")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of the variant.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class AKSServiceResponseResponseAutoScaler(dict):
    """
    The auto scaler properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoscaleEnabled":
            suggest = "autoscale_enabled"
        elif key == "maxReplicas":
            suggest = "max_replicas"
        elif key == "minReplicas":
            suggest = "min_replicas"
        elif key == "refreshPeriodInSeconds":
            suggest = "refresh_period_in_seconds"
        elif key == "targetUtilization":
            suggest = "target_utilization"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AKSServiceResponseResponseAutoScaler. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AKSServiceResponseResponseAutoScaler.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AKSServiceResponseResponseAutoScaler.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 autoscale_enabled: Optional[bool] = None,
                 max_replicas: Optional[int] = None,
                 min_replicas: Optional[int] = None,
                 refresh_period_in_seconds: Optional[int] = None,
                 target_utilization: Optional[int] = None):
        """
        The auto scaler properties.
        :param bool autoscale_enabled: Option to enable/disable auto scaling.
        :param int max_replicas: The maximum number of replicas in the cluster.
        :param int min_replicas: The minimum number of replicas to scale down to.
        :param int refresh_period_in_seconds: The amount of seconds to wait between auto scale updates.
        :param int target_utilization: The target utilization percentage to use for determining whether to scale the cluster.
        """
        if autoscale_enabled is not None:
            pulumi.set(__self__, "autoscale_enabled", autoscale_enabled)
        if max_replicas is not None:
            pulumi.set(__self__, "max_replicas", max_replicas)
        if min_replicas is not None:
            pulumi.set(__self__, "min_replicas", min_replicas)
        if refresh_period_in_seconds is not None:
            pulumi.set(__self__, "refresh_period_in_seconds", refresh_period_in_seconds)
        if target_utilization is not None:
            pulumi.set(__self__, "target_utilization", target_utilization)

    @property
    @pulumi.getter(name="autoscaleEnabled")
    def autoscale_enabled(self) -> Optional[bool]:
        """
        Option to enable/disable auto scaling.
        """
        return pulumi.get(self, "autoscale_enabled")

    @property
    @pulumi.getter(name="maxReplicas")
    def max_replicas(self) -> Optional[int]:
        """
        The maximum number of replicas in the cluster.
        """
        return pulumi.get(self, "max_replicas")

    @property
    @pulumi.getter(name="minReplicas")
    def min_replicas(self) -> Optional[int]:
        """
        The minimum number of replicas to scale down to.
        """
        return pulumi.get(self, "min_replicas")

    @property
    @pulumi.getter(name="refreshPeriodInSeconds")
    def refresh_period_in_seconds(self) -> Optional[int]:
        """
        The amount of seconds to wait between auto scale updates.
        """
        return pulumi.get(self, "refresh_period_in_seconds")

    @property
    @pulumi.getter(name="targetUtilization")
    def target_utilization(self) -> Optional[int]:
        """
        The target utilization percentage to use for determining whether to scale the cluster.
        """
        return pulumi.get(self, "target_utilization")


@pulumi.output_type
class AKSServiceResponseResponseDataCollection(dict):
    """
    Details of the data collection options specified.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eventHubEnabled":
            suggest = "event_hub_enabled"
        elif key == "storageEnabled":
            suggest = "storage_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AKSServiceResponseResponseDataCollection. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AKSServiceResponseResponseDataCollection.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AKSServiceResponseResponseDataCollection.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 event_hub_enabled: Optional[bool] = None,
                 storage_enabled: Optional[bool] = None):
        """
        Details of the data collection options specified.
        :param bool event_hub_enabled: Option for enabling/disabling Event Hub.
        :param bool storage_enabled: Option for enabling/disabling storage.
        """
        if event_hub_enabled is not None:
            pulumi.set(__self__, "event_hub_enabled", event_hub_enabled)
        if storage_enabled is not None:
            pulumi.set(__self__, "storage_enabled", storage_enabled)

    @property
    @pulumi.getter(name="eventHubEnabled")
    def event_hub_enabled(self) -> Optional[bool]:
        """
        Option for enabling/disabling Event Hub.
        """
        return pulumi.get(self, "event_hub_enabled")

    @property
    @pulumi.getter(name="storageEnabled")
    def storage_enabled(self) -> Optional[bool]:
        """
        Option for enabling/disabling storage.
        """
        return pulumi.get(self, "storage_enabled")


@pulumi.output_type
class AKSServiceResponseResponseDeploymentStatus(dict):
    """
    The deployment status.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availableReplicas":
            suggest = "available_replicas"
        elif key == "desiredReplicas":
            suggest = "desired_replicas"
        elif key == "updatedReplicas":
            suggest = "updated_replicas"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AKSServiceResponseResponseDeploymentStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AKSServiceResponseResponseDeploymentStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AKSServiceResponseResponseDeploymentStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 available_replicas: Optional[int] = None,
                 desired_replicas: Optional[int] = None,
                 error: Optional['outputs.AKSReplicaStatusResponseError'] = None,
                 updated_replicas: Optional[int] = None):
        """
        The deployment status.
        :param int available_replicas: The number of available replicas.
        :param int desired_replicas: The desired number of replicas.
        :param 'AKSReplicaStatusResponseError' error: The error details.
        :param int updated_replicas: The number of updated replicas.
        """
        if available_replicas is not None:
            pulumi.set(__self__, "available_replicas", available_replicas)
        if desired_replicas is not None:
            pulumi.set(__self__, "desired_replicas", desired_replicas)
        if error is not None:
            pulumi.set(__self__, "error", error)
        if updated_replicas is not None:
            pulumi.set(__self__, "updated_replicas", updated_replicas)

    @property
    @pulumi.getter(name="availableReplicas")
    def available_replicas(self) -> Optional[int]:
        """
        The number of available replicas.
        """
        return pulumi.get(self, "available_replicas")

    @property
    @pulumi.getter(name="desiredReplicas")
    def desired_replicas(self) -> Optional[int]:
        """
        The desired number of replicas.
        """
        return pulumi.get(self, "desired_replicas")

    @property
    @pulumi.getter
    def error(self) -> Optional['outputs.AKSReplicaStatusResponseError']:
        """
        The error details.
        """
        return pulumi.get(self, "error")

    @property
    @pulumi.getter(name="updatedReplicas")
    def updated_replicas(self) -> Optional[int]:
        """
        The number of updated replicas.
        """
        return pulumi.get(self, "updated_replicas")


@pulumi.output_type
class AKSServiceResponseResponseEnvironmentImageRequest(dict):
    """
    The Environment, models and assets used for inferencing.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "driverProgram":
            suggest = "driver_program"
        elif key == "environmentReference":
            suggest = "environment_reference"
        elif key == "modelIds":
            suggest = "model_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AKSServiceResponseResponseEnvironmentImageRequest. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AKSServiceResponseResponseEnvironmentImageRequest.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AKSServiceResponseResponseEnvironmentImageRequest.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 assets: Optional[Sequence['outputs.ImageAssetResponse']] = None,
                 driver_program: Optional[str] = None,
                 environment: Optional['outputs.EnvironmentImageResponseResponseEnvironment'] = None,
                 environment_reference: Optional['outputs.EnvironmentImageResponseResponseEnvironmentReference'] = None,
                 model_ids: Optional[Sequence[str]] = None,
                 models: Optional[Sequence['outputs.ModelResponse']] = None):
        """
        The Environment, models and assets used for inferencing.
        :param Sequence['ImageAssetResponse'] assets: The list of assets.
        :param str driver_program: The name of the driver file.
        :param 'EnvironmentImageResponseResponseEnvironment' environment: The details of the AZURE ML environment.
        :param 'EnvironmentImageResponseResponseEnvironmentReference' environment_reference: The unique identifying details of the AZURE ML environment.
        :param Sequence[str] model_ids: The list of model Ids.
        :param Sequence['ModelResponse'] models: The list of models.
        """
        if assets is not None:
            pulumi.set(__self__, "assets", assets)
        if driver_program is not None:
            pulumi.set(__self__, "driver_program", driver_program)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if environment_reference is not None:
            pulumi.set(__self__, "environment_reference", environment_reference)
        if model_ids is not None:
            pulumi.set(__self__, "model_ids", model_ids)
        if models is not None:
            pulumi.set(__self__, "models", models)

    @property
    @pulumi.getter
    def assets(self) -> Optional[Sequence['outputs.ImageAssetResponse']]:
        """
        The list of assets.
        """
        return pulumi.get(self, "assets")

    @property
    @pulumi.getter(name="driverProgram")
    def driver_program(self) -> Optional[str]:
        """
        The name of the driver file.
        """
        return pulumi.get(self, "driver_program")

    @property
    @pulumi.getter
    def environment(self) -> Optional['outputs.EnvironmentImageResponseResponseEnvironment']:
        """
        The details of the AZURE ML environment.
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter(name="environmentReference")
    def environment_reference(self) -> Optional['outputs.EnvironmentImageResponseResponseEnvironmentReference']:
        """
        The unique identifying details of the AZURE ML environment.
        """
        return pulumi.get(self, "environment_reference")

    @property
    @pulumi.getter(name="modelIds")
    def model_ids(self) -> Optional[Sequence[str]]:
        """
        The list of model Ids.
        """
        return pulumi.get(self, "model_ids")

    @property
    @pulumi.getter
    def models(self) -> Optional[Sequence['outputs.ModelResponse']]:
        """
        The list of models.
        """
        return pulumi.get(self, "models")


@pulumi.output_type
class AKSServiceResponseResponseLivenessProbeRequirements(dict):
    """
    The liveness probe requirements.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failureThreshold":
            suggest = "failure_threshold"
        elif key == "initialDelaySeconds":
            suggest = "initial_delay_seconds"
        elif key == "periodSeconds":
            suggest = "period_seconds"
        elif key == "successThreshold":
            suggest = "success_threshold"
        elif key == "timeoutSeconds":
            suggest = "timeout_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AKSServiceResponseResponseLivenessProbeRequirements. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AKSServiceResponseResponseLivenessProbeRequirements.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AKSServiceResponseResponseLivenessProbeRequirements.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 failure_threshold: Optional[int] = None,
                 initial_delay_seconds: Optional[int] = None,
                 period_seconds: Optional[int] = None,
                 success_threshold: Optional[int] = None,
                 timeout_seconds: Optional[int] = None):
        """
        The liveness probe requirements.
        :param int failure_threshold: The number of failures to allow before returning an unhealthy status.
        :param int initial_delay_seconds: The delay before the first probe in seconds.
        :param int period_seconds: The length of time between probes in seconds.
        :param int success_threshold: The number of successful probes before returning a healthy status.
        :param int timeout_seconds: The probe timeout in seconds.
        """
        if failure_threshold is not None:
            pulumi.set(__self__, "failure_threshold", failure_threshold)
        if initial_delay_seconds is not None:
            pulumi.set(__self__, "initial_delay_seconds", initial_delay_seconds)
        if period_seconds is not None:
            pulumi.set(__self__, "period_seconds", period_seconds)
        if success_threshold is not None:
            pulumi.set(__self__, "success_threshold", success_threshold)
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)

    @property
    @pulumi.getter(name="failureThreshold")
    def failure_threshold(self) -> Optional[int]:
        """
        The number of failures to allow before returning an unhealthy status.
        """
        return pulumi.get(self, "failure_threshold")

    @property
    @pulumi.getter(name="initialDelaySeconds")
    def initial_delay_seconds(self) -> Optional[int]:
        """
        The delay before the first probe in seconds.
        """
        return pulumi.get(self, "initial_delay_seconds")

    @property
    @pulumi.getter(name="periodSeconds")
    def period_seconds(self) -> Optional[int]:
        """
        The length of time between probes in seconds.
        """
        return pulumi.get(self, "period_seconds")

    @property
    @pulumi.getter(name="successThreshold")
    def success_threshold(self) -> Optional[int]:
        """
        The number of successful probes before returning a healthy status.
        """
        return pulumi.get(self, "success_threshold")

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[int]:
        """
        The probe timeout in seconds.
        """
        return pulumi.get(self, "timeout_seconds")


@pulumi.output_type
class AKSVariantResponseResponse(dict):
    """
    The response for an AKS variant.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computeType":
            suggest = "compute_type"
        elif key == "deploymentType":
            suggest = "deployment_type"
        elif key == "isDefault":
            suggest = "is_default"
        elif key == "kvTags":
            suggest = "kv_tags"
        elif key == "trafficPercentile":
            suggest = "traffic_percentile"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AKSVariantResponseResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AKSVariantResponseResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AKSVariantResponseResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compute_type: str,
                 error: 'outputs.ServiceResponseBaseResponseError',
                 state: str,
                 deployment_type: Optional[str] = None,
                 description: Optional[str] = None,
                 is_default: Optional[bool] = None,
                 kv_tags: Optional[Mapping[str, str]] = None,
                 properties: Optional[Mapping[str, str]] = None,
                 traffic_percentile: Optional[float] = None,
                 type: Optional[str] = None):
        """
        The response for an AKS variant.
        :param str compute_type: The compute environment type for the service.
               Expected value is 'Custom'.
        :param 'ServiceResponseBaseResponseError' error: The error details.
        :param str state: The current state of the service.
        :param str deployment_type: The deployment type for the service.
        :param str description: The service description.
        :param bool is_default: Is this the default variant.
        :param Mapping[str, str] kv_tags: The service tag dictionary. Tags are mutable.
        :param Mapping[str, str] properties: The service property dictionary. Properties are immutable.
        :param float traffic_percentile: The amount of traffic variant receives.
        :param str type: The type of the variant.
        """
        pulumi.set(__self__, "compute_type", 'Custom')
        pulumi.set(__self__, "error", error)
        pulumi.set(__self__, "state", state)
        if deployment_type is not None:
            pulumi.set(__self__, "deployment_type", deployment_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if is_default is not None:
            pulumi.set(__self__, "is_default", is_default)
        if kv_tags is not None:
            pulumi.set(__self__, "kv_tags", kv_tags)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if traffic_percentile is not None:
            pulumi.set(__self__, "traffic_percentile", traffic_percentile)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> str:
        """
        The compute environment type for the service.
        Expected value is 'Custom'.
        """
        return pulumi.get(self, "compute_type")

    @property
    @pulumi.getter
    def error(self) -> 'outputs.ServiceResponseBaseResponseError':
        """
        The error details.
        """
        return pulumi.get(self, "error")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the service.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> Optional[str]:
        """
        The deployment type for the service.
        """
        return pulumi.get(self, "deployment_type")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The service description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> Optional[bool]:
        """
        Is this the default variant.
        """
        return pulumi.get(self, "is_default")

    @property
    @pulumi.getter(name="kvTags")
    def kv_tags(self) -> Optional[Mapping[str, str]]:
        """
        The service tag dictionary. Tags are mutable.
        """
        return pulumi.get(self, "kv_tags")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        The service property dictionary. Properties are immutable.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="trafficPercentile")
    def traffic_percentile(self) -> Optional[float]:
        """
        The amount of traffic variant receives.
        """
        return pulumi.get(self, "traffic_percentile")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of the variant.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class AksNetworkingConfigurationResponse(dict):
    """
    Advance configuration for AKS networking
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsServiceIP":
            suggest = "dns_service_ip"
        elif key == "dockerBridgeCidr":
            suggest = "docker_bridge_cidr"
        elif key == "serviceCidr":
            suggest = "service_cidr"
        elif key == "subnetId":
            suggest = "subnet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AksNetworkingConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AksNetworkingConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AksNetworkingConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dns_service_ip: Optional[str] = None,
                 docker_bridge_cidr: Optional[str] = None,
                 service_cidr: Optional[str] = None,
                 subnet_id: Optional[str] = None):
        """
        Advance configuration for AKS networking
        :param str dns_service_ip: An IP address assigned to the Kubernetes DNS service. It must be within the Kubernetes service address range specified in serviceCidr.
        :param str docker_bridge_cidr: A CIDR notation IP range assigned to the Docker bridge network. It must not overlap with any Subnet IP ranges or the Kubernetes service address range.
        :param str service_cidr: A CIDR notation IP range from which to assign service cluster IPs. It must not overlap with any Subnet IP ranges.
        :param str subnet_id: Virtual network subnet resource ID the compute nodes belong to
        """
        if dns_service_ip is not None:
            pulumi.set(__self__, "dns_service_ip", dns_service_ip)
        if docker_bridge_cidr is not None:
            pulumi.set(__self__, "docker_bridge_cidr", docker_bridge_cidr)
        if service_cidr is not None:
            pulumi.set(__self__, "service_cidr", service_cidr)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="dnsServiceIP")
    def dns_service_ip(self) -> Optional[str]:
        """
        An IP address assigned to the Kubernetes DNS service. It must be within the Kubernetes service address range specified in serviceCidr.
        """
        return pulumi.get(self, "dns_service_ip")

    @property
    @pulumi.getter(name="dockerBridgeCidr")
    def docker_bridge_cidr(self) -> Optional[str]:
        """
        A CIDR notation IP range assigned to the Docker bridge network. It must not overlap with any Subnet IP ranges or the Kubernetes service address range.
        """
        return pulumi.get(self, "docker_bridge_cidr")

    @property
    @pulumi.getter(name="serviceCidr")
    def service_cidr(self) -> Optional[str]:
        """
        A CIDR notation IP range from which to assign service cluster IPs. It must not overlap with any Subnet IP ranges.
        """
        return pulumi.get(self, "service_cidr")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[str]:
        """
        Virtual network subnet resource ID the compute nodes belong to
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class AmlComputeNodeInformationResponse(dict):
    """
    Compute node information related to a AmlCompute.
    """
    def __init__(__self__, *,
                 node_id: str,
                 node_state: str,
                 port: float,
                 private_ip_address: str,
                 public_ip_address: str,
                 run_id: str):
        """
        Compute node information related to a AmlCompute.
        :param str node_id: ID of the compute node.
        :param str node_state: State of the compute node. Values are idle, running, preparing, unusable, leaving and preempted.
        :param float port: SSH port number of the node.
        :param str private_ip_address: Private IP address of the compute node.
        :param str public_ip_address: Public IP address of the compute node.
        :param str run_id: ID of the Experiment running on the node, if any else null.
        """
        pulumi.set(__self__, "node_id", node_id)
        pulumi.set(__self__, "node_state", node_state)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "private_ip_address", private_ip_address)
        pulumi.set(__self__, "public_ip_address", public_ip_address)
        pulumi.set(__self__, "run_id", run_id)

    @property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> str:
        """
        ID of the compute node.
        """
        return pulumi.get(self, "node_id")

    @property
    @pulumi.getter(name="nodeState")
    def node_state(self) -> str:
        """
        State of the compute node. Values are idle, running, preparing, unusable, leaving and preempted.
        """
        return pulumi.get(self, "node_state")

    @property
    @pulumi.getter
    def port(self) -> float:
        """
        SSH port number of the node.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> str:
        """
        Private IP address of the compute node.
        """
        return pulumi.get(self, "private_ip_address")

    @property
    @pulumi.getter(name="publicIpAddress")
    def public_ip_address(self) -> str:
        """
        Public IP address of the compute node.
        """
        return pulumi.get(self, "public_ip_address")

    @property
    @pulumi.getter(name="runId")
    def run_id(self) -> str:
        """
        ID of the Experiment running on the node, if any else null.
        """
        return pulumi.get(self, "run_id")


@pulumi.output_type
class AmlComputeResponse(dict):
    """
    An Azure Machine Learning compute.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computeType":
            suggest = "compute_type"
        elif key == "isAttachedCompute":
            suggest = "is_attached_compute"
        elif key == "provisioningErrors":
            suggest = "provisioning_errors"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "computeLocation":
            suggest = "compute_location"
        elif key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AmlComputeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AmlComputeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AmlComputeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compute_type: str,
                 is_attached_compute: bool,
                 provisioning_errors: Sequence['outputs.MachineLearningServiceErrorResponse'],
                 provisioning_state: str,
                 compute_location: Optional[str] = None,
                 description: Optional[str] = None,
                 properties: Optional['outputs.AmlComputeResponseProperties'] = None,
                 resource_id: Optional[str] = None):
        """
        An Azure Machine Learning compute.
        :param str compute_type: The type of compute
               Expected value is 'AmlCompute'.
        :param bool is_attached_compute: Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
        :param Sequence['MachineLearningServiceErrorResponse'] provisioning_errors: Errors during provisioning
        :param str provisioning_state: The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        :param str compute_location: Location for the underlying compute
        :param str description: The description of the Machine Learning compute.
        :param 'AmlComputeResponseProperties' properties: AML Compute properties
        :param str resource_id: ARM resource id of the underlying compute
        """
        pulumi.set(__self__, "compute_type", 'AmlCompute')
        pulumi.set(__self__, "is_attached_compute", is_attached_compute)
        pulumi.set(__self__, "provisioning_errors", provisioning_errors)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> str:
        """
        The type of compute
        Expected value is 'AmlCompute'.
        """
        return pulumi.get(self, "compute_type")

    @property
    @pulumi.getter(name="isAttachedCompute")
    def is_attached_compute(self) -> bool:
        """
        Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
        """
        return pulumi.get(self, "is_attached_compute")

    @property
    @pulumi.getter(name="provisioningErrors")
    def provisioning_errors(self) -> Sequence['outputs.MachineLearningServiceErrorResponse']:
        """
        Errors during provisioning
        """
        return pulumi.get(self, "provisioning_errors")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[str]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.AmlComputeResponseProperties']:
        """
        AML Compute properties
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        ARM resource id of the underlying compute
        """
        return pulumi.get(self, "resource_id")


@pulumi.output_type
class AmlComputeResponseProperties(dict):
    """
    AML Compute properties
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allocationState":
            suggest = "allocation_state"
        elif key == "allocationStateTransitionTime":
            suggest = "allocation_state_transition_time"
        elif key == "currentNodeCount":
            suggest = "current_node_count"
        elif key == "nodeStateCounts":
            suggest = "node_state_counts"
        elif key == "targetNodeCount":
            suggest = "target_node_count"
        elif key == "enableNodePublicIp":
            suggest = "enable_node_public_ip"
        elif key == "isolatedNetwork":
            suggest = "isolated_network"
        elif key == "osType":
            suggest = "os_type"
        elif key == "remoteLoginPortPublicAccess":
            suggest = "remote_login_port_public_access"
        elif key == "scaleSettings":
            suggest = "scale_settings"
        elif key == "userAccountCredentials":
            suggest = "user_account_credentials"
        elif key == "virtualMachineImage":
            suggest = "virtual_machine_image"
        elif key == "vmPriority":
            suggest = "vm_priority"
        elif key == "vmSize":
            suggest = "vm_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AmlComputeResponseProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AmlComputeResponseProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AmlComputeResponseProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allocation_state: str,
                 allocation_state_transition_time: str,
                 current_node_count: int,
                 errors: Sequence['outputs.MachineLearningServiceErrorResponse'],
                 node_state_counts: 'outputs.NodeStateCountsResponse',
                 target_node_count: int,
                 enable_node_public_ip: Optional[bool] = None,
                 isolated_network: Optional[bool] = None,
                 os_type: Optional[str] = None,
                 remote_login_port_public_access: Optional[str] = None,
                 scale_settings: Optional['outputs.ScaleSettingsResponse'] = None,
                 subnet: Optional['outputs.ResourceIdResponse'] = None,
                 user_account_credentials: Optional['outputs.UserAccountCredentialsResponse'] = None,
                 virtual_machine_image: Optional['outputs.VirtualMachineImageResponse'] = None,
                 vm_priority: Optional[str] = None,
                 vm_size: Optional[str] = None):
        """
        AML Compute properties
        :param str allocation_state: Allocation state of the compute. Possible values are: steady - Indicates that the compute is not resizing. There are no changes to the number of compute nodes in the compute in progress. A compute enters this state when it is created and when no operations are being performed on the compute to change the number of compute nodes. resizing - Indicates that the compute is resizing; that is, compute nodes are being added to or removed from the compute.
        :param str allocation_state_transition_time: The time at which the compute entered its current allocation state.
        :param int current_node_count: The number of compute nodes currently assigned to the compute.
        :param Sequence['MachineLearningServiceErrorResponse'] errors: Collection of errors encountered by various compute nodes during node setup.
        :param 'NodeStateCountsResponse' node_state_counts: Counts of various node states on the compute.
        :param int target_node_count: The target number of compute nodes for the compute. If the allocationState is resizing, this property denotes the target node count for the ongoing resize operation. If the allocationState is steady, this property denotes the target node count for the previous resize operation.
        :param bool enable_node_public_ip: Enable or disable node public IP address provisioning. Possible values are: Possible values are: true - Indicates that the compute nodes will have public IPs provisioned. false - Indicates that the compute nodes will have a private endpoint and no public IPs.
        :param bool isolated_network: Network is isolated or not
        :param str os_type: Compute OS Type
        :param str remote_login_port_public_access: State of the public SSH port. Possible values are: Disabled - Indicates that the public ssh port is closed on all nodes of the cluster. Enabled - Indicates that the public ssh port is open on all nodes of the cluster. NotSpecified - Indicates that the public ssh port is closed on all nodes of the cluster if VNet is defined, else is open all public nodes. It can be default only during cluster creation time, after creation it will be either enabled or disabled.
        :param 'ScaleSettingsResponse' scale_settings: Scale settings for AML Compute
        :param 'ResourceIdResponse' subnet: Virtual network subnet resource ID the compute nodes belong to.
        :param 'UserAccountCredentialsResponse' user_account_credentials: Credentials for an administrator user account that will be created on each compute node.
        :param 'VirtualMachineImageResponse' virtual_machine_image: Virtual Machine image for AML Compute - windows only
        :param str vm_priority: Virtual Machine priority
        :param str vm_size: Virtual Machine Size
        """
        pulumi.set(__self__, "allocation_state", allocation_state)
        pulumi.set(__self__, "allocation_state_transition_time", allocation_state_transition_time)
        pulumi.set(__self__, "current_node_count", current_node_count)
        pulumi.set(__self__, "errors", errors)
        pulumi.set(__self__, "node_state_counts", node_state_counts)
        pulumi.set(__self__, "target_node_count", target_node_count)
        if enable_node_public_ip is None:
            enable_node_public_ip = True
        if enable_node_public_ip is not None:
            pulumi.set(__self__, "enable_node_public_ip", enable_node_public_ip)
        if isolated_network is not None:
            pulumi.set(__self__, "isolated_network", isolated_network)
        if os_type is None:
            os_type = 'Linux'
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if remote_login_port_public_access is None:
            remote_login_port_public_access = 'NotSpecified'
        if remote_login_port_public_access is not None:
            pulumi.set(__self__, "remote_login_port_public_access", remote_login_port_public_access)
        if scale_settings is not None:
            pulumi.set(__self__, "scale_settings", scale_settings)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)
        if user_account_credentials is not None:
            pulumi.set(__self__, "user_account_credentials", user_account_credentials)
        if virtual_machine_image is not None:
            pulumi.set(__self__, "virtual_machine_image", virtual_machine_image)
        if vm_priority is not None:
            pulumi.set(__self__, "vm_priority", vm_priority)
        if vm_size is not None:
            pulumi.set(__self__, "vm_size", vm_size)

    @property
    @pulumi.getter(name="allocationState")
    def allocation_state(self) -> str:
        """
        Allocation state of the compute. Possible values are: steady - Indicates that the compute is not resizing. There are no changes to the number of compute nodes in the compute in progress. A compute enters this state when it is created and when no operations are being performed on the compute to change the number of compute nodes. resizing - Indicates that the compute is resizing; that is, compute nodes are being added to or removed from the compute.
        """
        return pulumi.get(self, "allocation_state")

    @property
    @pulumi.getter(name="allocationStateTransitionTime")
    def allocation_state_transition_time(self) -> str:
        """
        The time at which the compute entered its current allocation state.
        """
        return pulumi.get(self, "allocation_state_transition_time")

    @property
    @pulumi.getter(name="currentNodeCount")
    def current_node_count(self) -> int:
        """
        The number of compute nodes currently assigned to the compute.
        """
        return pulumi.get(self, "current_node_count")

    @property
    @pulumi.getter
    def errors(self) -> Sequence['outputs.MachineLearningServiceErrorResponse']:
        """
        Collection of errors encountered by various compute nodes during node setup.
        """
        return pulumi.get(self, "errors")

    @property
    @pulumi.getter(name="nodeStateCounts")
    def node_state_counts(self) -> 'outputs.NodeStateCountsResponse':
        """
        Counts of various node states on the compute.
        """
        return pulumi.get(self, "node_state_counts")

    @property
    @pulumi.getter(name="targetNodeCount")
    def target_node_count(self) -> int:
        """
        The target number of compute nodes for the compute. If the allocationState is resizing, this property denotes the target node count for the ongoing resize operation. If the allocationState is steady, this property denotes the target node count for the previous resize operation.
        """
        return pulumi.get(self, "target_node_count")

    @property
    @pulumi.getter(name="enableNodePublicIp")
    def enable_node_public_ip(self) -> Optional[bool]:
        """
        Enable or disable node public IP address provisioning. Possible values are: Possible values are: true - Indicates that the compute nodes will have public IPs provisioned. false - Indicates that the compute nodes will have a private endpoint and no public IPs.
        """
        return pulumi.get(self, "enable_node_public_ip")

    @property
    @pulumi.getter(name="isolatedNetwork")
    def isolated_network(self) -> Optional[bool]:
        """
        Network is isolated or not
        """
        return pulumi.get(self, "isolated_network")

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[str]:
        """
        Compute OS Type
        """
        return pulumi.get(self, "os_type")

    @property
    @pulumi.getter(name="remoteLoginPortPublicAccess")
    def remote_login_port_public_access(self) -> Optional[str]:
        """
        State of the public SSH port. Possible values are: Disabled - Indicates that the public ssh port is closed on all nodes of the cluster. Enabled - Indicates that the public ssh port is open on all nodes of the cluster. NotSpecified - Indicates that the public ssh port is closed on all nodes of the cluster if VNet is defined, else is open all public nodes. It can be default only during cluster creation time, after creation it will be either enabled or disabled.
        """
        return pulumi.get(self, "remote_login_port_public_access")

    @property
    @pulumi.getter(name="scaleSettings")
    def scale_settings(self) -> Optional['outputs.ScaleSettingsResponse']:
        """
        Scale settings for AML Compute
        """
        return pulumi.get(self, "scale_settings")

    @property
    @pulumi.getter
    def subnet(self) -> Optional['outputs.ResourceIdResponse']:
        """
        Virtual network subnet resource ID the compute nodes belong to.
        """
        return pulumi.get(self, "subnet")

    @property
    @pulumi.getter(name="userAccountCredentials")
    def user_account_credentials(self) -> Optional['outputs.UserAccountCredentialsResponse']:
        """
        Credentials for an administrator user account that will be created on each compute node.
        """
        return pulumi.get(self, "user_account_credentials")

    @property
    @pulumi.getter(name="virtualMachineImage")
    def virtual_machine_image(self) -> Optional['outputs.VirtualMachineImageResponse']:
        """
        Virtual Machine image for AML Compute - windows only
        """
        return pulumi.get(self, "virtual_machine_image")

    @property
    @pulumi.getter(name="vmPriority")
    def vm_priority(self) -> Optional[str]:
        """
        Virtual Machine priority
        """
        return pulumi.get(self, "vm_priority")

    @property
    @pulumi.getter(name="vmSize")
    def vm_size(self) -> Optional[str]:
        """
        Virtual Machine Size
        """
        return pulumi.get(self, "vm_size")


@pulumi.output_type
class AmlTokenResponse(dict):
    """
    AML Token identity configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityType":
            suggest = "identity_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AmlTokenResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AmlTokenResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AmlTokenResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 identity_type: str):
        """
        AML Token identity configuration.
        :param str identity_type: Enum to determine identity framework.
               Expected value is 'AMLToken'.
        """
        pulumi.set(__self__, "identity_type", 'AMLToken')

    @property
    @pulumi.getter(name="identityType")
    def identity_type(self) -> str:
        """
        Enum to determine identity framework.
        Expected value is 'AMLToken'.
        """
        return pulumi.get(self, "identity_type")


@pulumi.output_type
class AssignedUserResponse(dict):
    """
    A user that can be assigned to a compute instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectId":
            suggest = "object_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AssignedUserResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AssignedUserResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AssignedUserResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 object_id: str,
                 tenant_id: str):
        """
        A user that can be assigned to a compute instance.
        :param str object_id: User’s AAD Object Id.
        :param str tenant_id: User’s AAD Tenant Id.
        """
        pulumi.set(__self__, "object_id", object_id)
        pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> str:
        """
        User’s AAD Object Id.
        """
        return pulumi.get(self, "object_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        User’s AAD Tenant Id.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class AutoScaleSettingsResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scaleType":
            suggest = "scale_type"
        elif key == "maxInstances":
            suggest = "max_instances"
        elif key == "minInstances":
            suggest = "min_instances"
        elif key == "pollingInterval":
            suggest = "polling_interval"
        elif key == "targetUtilizationPercentage":
            suggest = "target_utilization_percentage"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoScaleSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoScaleSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoScaleSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 scale_type: str,
                 max_instances: Optional[int] = None,
                 min_instances: Optional[int] = None,
                 polling_interval: Optional[str] = None,
                 target_utilization_percentage: Optional[int] = None):
        """
        :param str scale_type: 
               Expected value is 'Auto'.
        :param int max_instances: Maximum number of instances for this deployment.
        :param int min_instances: Minimum number of instances for this deployment.
        :param str polling_interval: The polling interval in ISO 8691 format. Only supports duration with precision as low as Seconds.
        :param int target_utilization_percentage: Target CPU usage for the autoscaler.
        """
        pulumi.set(__self__, "scale_type", 'Auto')
        if max_instances is not None:
            pulumi.set(__self__, "max_instances", max_instances)
        if min_instances is not None:
            pulumi.set(__self__, "min_instances", min_instances)
        if polling_interval is not None:
            pulumi.set(__self__, "polling_interval", polling_interval)
        if target_utilization_percentage is not None:
            pulumi.set(__self__, "target_utilization_percentage", target_utilization_percentage)

    @property
    @pulumi.getter(name="scaleType")
    def scale_type(self) -> str:
        """

        Expected value is 'Auto'.
        """
        return pulumi.get(self, "scale_type")

    @property
    @pulumi.getter(name="maxInstances")
    def max_instances(self) -> Optional[int]:
        """
        Maximum number of instances for this deployment.
        """
        return pulumi.get(self, "max_instances")

    @property
    @pulumi.getter(name="minInstances")
    def min_instances(self) -> Optional[int]:
        """
        Minimum number of instances for this deployment.
        """
        return pulumi.get(self, "min_instances")

    @property
    @pulumi.getter(name="pollingInterval")
    def polling_interval(self) -> Optional[str]:
        """
        The polling interval in ISO 8691 format. Only supports duration with precision as low as Seconds.
        """
        return pulumi.get(self, "polling_interval")

    @property
    @pulumi.getter(name="targetUtilizationPercentage")
    def target_utilization_percentage(self) -> Optional[int]:
        """
        Target CPU usage for the autoscaler.
        """
        return pulumi.get(self, "target_utilization_percentage")


@pulumi.output_type
class AzureDataLakeSectionResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorityUrl":
            suggest = "authority_url"
        elif key == "clientId":
            suggest = "client_id"
        elif key == "clientSecret":
            suggest = "client_secret"
        elif key == "credentialType":
            suggest = "credential_type"
        elif key == "isCertAuth":
            suggest = "is_cert_auth"
        elif key == "resourceGroup":
            suggest = "resource_group"
        elif key == "resourceUri":
            suggest = "resource_uri"
        elif key == "serviceDataAccessAuthIdentity":
            suggest = "service_data_access_auth_identity"
        elif key == "storeName":
            suggest = "store_name"
        elif key == "subscriptionId":
            suggest = "subscription_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureDataLakeSectionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureDataLakeSectionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureDataLakeSectionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authority_url: Optional[str] = None,
                 certificate: Optional[str] = None,
                 client_id: Optional[str] = None,
                 client_secret: Optional[str] = None,
                 credential_type: Optional[str] = None,
                 is_cert_auth: Optional[bool] = None,
                 resource_group: Optional[str] = None,
                 resource_uri: Optional[str] = None,
                 service_data_access_auth_identity: Optional[str] = None,
                 store_name: Optional[str] = None,
                 subscription_id: Optional[str] = None,
                 tenant_id: Optional[str] = None,
                 thumbprint: Optional[str] = None):
        """
        :param str authority_url: The authority URL used for authentication.
        :param str certificate: The content of the certificate used for authentication.
        :param str client_id: The Client ID/Application ID
        :param str client_secret: The client secret.
        :param str credential_type: The Azure Data Lake credential type.
        :param bool is_cert_auth:  Is it using certificate to authenticate. If false then use client secret.
        :param str resource_group: Resource Group.
        :param str resource_uri: The resource the service principal/app has access to.
        :param str service_data_access_auth_identity: Indicates which identity to use to authenticate service data access to customer's storage.
        :param str store_name: The Azure Data Lake store name.
        :param str subscription_id: Subscription ID.
        :param str tenant_id: The ID of the tenant the service principal/app belongs to.
        :param str thumbprint: The thumbprint of the certificate above.
        """
        if authority_url is not None:
            pulumi.set(__self__, "authority_url", authority_url)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if credential_type is not None:
            pulumi.set(__self__, "credential_type", credential_type)
        if is_cert_auth is not None:
            pulumi.set(__self__, "is_cert_auth", is_cert_auth)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if resource_uri is not None:
            pulumi.set(__self__, "resource_uri", resource_uri)
        if service_data_access_auth_identity is not None:
            pulumi.set(__self__, "service_data_access_auth_identity", service_data_access_auth_identity)
        if store_name is not None:
            pulumi.set(__self__, "store_name", store_name)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if thumbprint is not None:
            pulumi.set(__self__, "thumbprint", thumbprint)

    @property
    @pulumi.getter(name="authorityUrl")
    def authority_url(self) -> Optional[str]:
        """
        The authority URL used for authentication.
        """
        return pulumi.get(self, "authority_url")

    @property
    @pulumi.getter
    def certificate(self) -> Optional[str]:
        """
        The content of the certificate used for authentication.
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[str]:
        """
        The Client ID/Application ID
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[str]:
        """
        The client secret.
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter(name="credentialType")
    def credential_type(self) -> Optional[str]:
        """
        The Azure Data Lake credential type.
        """
        return pulumi.get(self, "credential_type")

    @property
    @pulumi.getter(name="isCertAuth")
    def is_cert_auth(self) -> Optional[bool]:
        """
         Is it using certificate to authenticate. If false then use client secret.
        """
        return pulumi.get(self, "is_cert_auth")

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[str]:
        """
        Resource Group.
        """
        return pulumi.get(self, "resource_group")

    @property
    @pulumi.getter(name="resourceUri")
    def resource_uri(self) -> Optional[str]:
        """
        The resource the service principal/app has access to.
        """
        return pulumi.get(self, "resource_uri")

    @property
    @pulumi.getter(name="serviceDataAccessAuthIdentity")
    def service_data_access_auth_identity(self) -> Optional[str]:
        """
        Indicates which identity to use to authenticate service data access to customer's storage.
        """
        return pulumi.get(self, "service_data_access_auth_identity")

    @property
    @pulumi.getter(name="storeName")
    def store_name(self) -> Optional[str]:
        """
        The Azure Data Lake store name.
        """
        return pulumi.get(self, "store_name")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[str]:
        """
        Subscription ID.
        """
        return pulumi.get(self, "subscription_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[str]:
        """
        The ID of the tenant the service principal/app belongs to.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def thumbprint(self) -> Optional[str]:
        """
        The thumbprint of the certificate above.
        """
        return pulumi.get(self, "thumbprint")


@pulumi.output_type
class AzureMySqlSectionResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorityUrl":
            suggest = "authority_url"
        elif key == "clientId":
            suggest = "client_id"
        elif key == "clientSecret":
            suggest = "client_secret"
        elif key == "credentialType":
            suggest = "credential_type"
        elif key == "databaseName":
            suggest = "database_name"
        elif key == "isCertAuth":
            suggest = "is_cert_auth"
        elif key == "portNumber":
            suggest = "port_number"
        elif key == "resourceGroup":
            suggest = "resource_group"
        elif key == "resourceUri":
            suggest = "resource_uri"
        elif key == "serverName":
            suggest = "server_name"
        elif key == "serviceDataAccessAuthIdentity":
            suggest = "service_data_access_auth_identity"
        elif key == "subscriptionId":
            suggest = "subscription_id"
        elif key == "tenantId":
            suggest = "tenant_id"
        elif key == "userId":
            suggest = "user_id"
        elif key == "userPassword":
            suggest = "user_password"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureMySqlSectionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureMySqlSectionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureMySqlSectionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authority_url: Optional[str] = None,
                 certificate: Optional[str] = None,
                 client_id: Optional[str] = None,
                 client_secret: Optional[str] = None,
                 credential_type: Optional[str] = None,
                 database_name: Optional[str] = None,
                 endpoint: Optional[str] = None,
                 is_cert_auth: Optional[bool] = None,
                 port_number: Optional[str] = None,
                 resource_group: Optional[str] = None,
                 resource_uri: Optional[str] = None,
                 server_name: Optional[str] = None,
                 service_data_access_auth_identity: Optional[str] = None,
                 subscription_id: Optional[str] = None,
                 tenant_id: Optional[str] = None,
                 thumbprint: Optional[str] = None,
                 user_id: Optional[str] = None,
                 user_password: Optional[str] = None):
        """
        :param str authority_url: The authority URL used for authentication.
        :param str certificate: The content of the certificate used for authentication.
        :param str client_id: The Client ID/Application ID
        :param str client_secret: The client secret.
        :param str credential_type: Sql Authentication type.
        :param str database_name: The Azure SQL database name.
        :param str endpoint: The server host endpoint.
        :param bool is_cert_auth:  Is it using certificate to authenticate. If false then use client secret.
        :param str port_number: / The Azure SQL port number.
        :param str resource_group: Resource Group.
        :param str resource_uri: The resource the service principal/app has access to.
        :param str server_name: The Azure SQL server name.
        :param str service_data_access_auth_identity: Indicates which identity to use to authenticate service data access to customer's storage.
        :param str subscription_id: Subscription ID.
        :param str tenant_id: The ID of the tenant the service principal/app belongs to.
        :param str thumbprint: The thumbprint of the certificate above.
        :param str user_id: The Azure SQL user id.
        :param str user_password: The Azure SQL user password.
        """
        if authority_url is not None:
            pulumi.set(__self__, "authority_url", authority_url)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if credential_type is not None:
            pulumi.set(__self__, "credential_type", credential_type)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if is_cert_auth is not None:
            pulumi.set(__self__, "is_cert_auth", is_cert_auth)
        if port_number is not None:
            pulumi.set(__self__, "port_number", port_number)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if resource_uri is not None:
            pulumi.set(__self__, "resource_uri", resource_uri)
        if server_name is not None:
            pulumi.set(__self__, "server_name", server_name)
        if service_data_access_auth_identity is not None:
            pulumi.set(__self__, "service_data_access_auth_identity", service_data_access_auth_identity)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if thumbprint is not None:
            pulumi.set(__self__, "thumbprint", thumbprint)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)
        if user_password is not None:
            pulumi.set(__self__, "user_password", user_password)

    @property
    @pulumi.getter(name="authorityUrl")
    def authority_url(self) -> Optional[str]:
        """
        The authority URL used for authentication.
        """
        return pulumi.get(self, "authority_url")

    @property
    @pulumi.getter
    def certificate(self) -> Optional[str]:
        """
        The content of the certificate used for authentication.
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[str]:
        """
        The Client ID/Application ID
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[str]:
        """
        The client secret.
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter(name="credentialType")
    def credential_type(self) -> Optional[str]:
        """
        Sql Authentication type.
        """
        return pulumi.get(self, "credential_type")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[str]:
        """
        The Azure SQL database name.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[str]:
        """
        The server host endpoint.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="isCertAuth")
    def is_cert_auth(self) -> Optional[bool]:
        """
         Is it using certificate to authenticate. If false then use client secret.
        """
        return pulumi.get(self, "is_cert_auth")

    @property
    @pulumi.getter(name="portNumber")
    def port_number(self) -> Optional[str]:
        """
        / The Azure SQL port number.
        """
        return pulumi.get(self, "port_number")

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[str]:
        """
        Resource Group.
        """
        return pulumi.get(self, "resource_group")

    @property
    @pulumi.getter(name="resourceUri")
    def resource_uri(self) -> Optional[str]:
        """
        The resource the service principal/app has access to.
        """
        return pulumi.get(self, "resource_uri")

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> Optional[str]:
        """
        The Azure SQL server name.
        """
        return pulumi.get(self, "server_name")

    @property
    @pulumi.getter(name="serviceDataAccessAuthIdentity")
    def service_data_access_auth_identity(self) -> Optional[str]:
        """
        Indicates which identity to use to authenticate service data access to customer's storage.
        """
        return pulumi.get(self, "service_data_access_auth_identity")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[str]:
        """
        Subscription ID.
        """
        return pulumi.get(self, "subscription_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[str]:
        """
        The ID of the tenant the service principal/app belongs to.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def thumbprint(self) -> Optional[str]:
        """
        The thumbprint of the certificate above.
        """
        return pulumi.get(self, "thumbprint")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[str]:
        """
        The Azure SQL user id.
        """
        return pulumi.get(self, "user_id")

    @property
    @pulumi.getter(name="userPassword")
    def user_password(self) -> Optional[str]:
        """
        The Azure SQL user password.
        """
        return pulumi.get(self, "user_password")


@pulumi.output_type
class AzurePostgreSqlSectionResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorityUrl":
            suggest = "authority_url"
        elif key == "clientId":
            suggest = "client_id"
        elif key == "clientSecret":
            suggest = "client_secret"
        elif key == "credentialType":
            suggest = "credential_type"
        elif key == "databaseName":
            suggest = "database_name"
        elif key == "enableSsl":
            suggest = "enable_ssl"
        elif key == "isCertAuth":
            suggest = "is_cert_auth"
        elif key == "portNumber":
            suggest = "port_number"
        elif key == "resourceGroup":
            suggest = "resource_group"
        elif key == "resourceUri":
            suggest = "resource_uri"
        elif key == "serverName":
            suggest = "server_name"
        elif key == "serviceDataAccessAuthIdentity":
            suggest = "service_data_access_auth_identity"
        elif key == "subscriptionId":
            suggest = "subscription_id"
        elif key == "tenantId":
            suggest = "tenant_id"
        elif key == "userId":
            suggest = "user_id"
        elif key == "userPassword":
            suggest = "user_password"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzurePostgreSqlSectionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzurePostgreSqlSectionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzurePostgreSqlSectionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authority_url: Optional[str] = None,
                 certificate: Optional[str] = None,
                 client_id: Optional[str] = None,
                 client_secret: Optional[str] = None,
                 credential_type: Optional[str] = None,
                 database_name: Optional[str] = None,
                 enable_ssl: Optional[bool] = None,
                 endpoint: Optional[str] = None,
                 is_cert_auth: Optional[bool] = None,
                 port_number: Optional[str] = None,
                 resource_group: Optional[str] = None,
                 resource_uri: Optional[str] = None,
                 server_name: Optional[str] = None,
                 service_data_access_auth_identity: Optional[str] = None,
                 subscription_id: Optional[str] = None,
                 tenant_id: Optional[str] = None,
                 thumbprint: Optional[str] = None,
                 user_id: Optional[str] = None,
                 user_password: Optional[str] = None):
        """
        :param str authority_url: The authority URL used for authentication.
        :param str certificate: The content of the certificate used for authentication.
        :param str client_id: The Client ID/Application ID
        :param str client_secret: The client secret.
        :param str credential_type: Sql Authentication type.
        :param str database_name: The Azure SQL database name.
        :param bool enable_ssl: Indicates SSL requirement of Azure Postgresql server.
        :param str endpoint: The server host endpoint.
        :param bool is_cert_auth:  Is it using certificate to authenticate. If false then use client secret.
        :param str port_number: / The Azure SQL port number.
        :param str resource_group: Resource Group.
        :param str resource_uri: The resource the service principal/app has access to.
        :param str server_name: The Azure SQL server name.
        :param str service_data_access_auth_identity: Indicates which identity to use to authenticate service data access to customer's storage.
        :param str subscription_id: Subscription ID.
        :param str tenant_id: The ID of the tenant the service principal/app belongs to.
        :param str thumbprint: The thumbprint of the certificate above.
        :param str user_id: The Azure SQL user id.
        :param str user_password: The Azure SQL user password.
        """
        if authority_url is not None:
            pulumi.set(__self__, "authority_url", authority_url)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if credential_type is not None:
            pulumi.set(__self__, "credential_type", credential_type)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if enable_ssl is not None:
            pulumi.set(__self__, "enable_ssl", enable_ssl)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if is_cert_auth is not None:
            pulumi.set(__self__, "is_cert_auth", is_cert_auth)
        if port_number is not None:
            pulumi.set(__self__, "port_number", port_number)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if resource_uri is not None:
            pulumi.set(__self__, "resource_uri", resource_uri)
        if server_name is not None:
            pulumi.set(__self__, "server_name", server_name)
        if service_data_access_auth_identity is not None:
            pulumi.set(__self__, "service_data_access_auth_identity", service_data_access_auth_identity)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if thumbprint is not None:
            pulumi.set(__self__, "thumbprint", thumbprint)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)
        if user_password is not None:
            pulumi.set(__self__, "user_password", user_password)

    @property
    @pulumi.getter(name="authorityUrl")
    def authority_url(self) -> Optional[str]:
        """
        The authority URL used for authentication.
        """
        return pulumi.get(self, "authority_url")

    @property
    @pulumi.getter
    def certificate(self) -> Optional[str]:
        """
        The content of the certificate used for authentication.
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[str]:
        """
        The Client ID/Application ID
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[str]:
        """
        The client secret.
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter(name="credentialType")
    def credential_type(self) -> Optional[str]:
        """
        Sql Authentication type.
        """
        return pulumi.get(self, "credential_type")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[str]:
        """
        The Azure SQL database name.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="enableSsl")
    def enable_ssl(self) -> Optional[bool]:
        """
        Indicates SSL requirement of Azure Postgresql server.
        """
        return pulumi.get(self, "enable_ssl")

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[str]:
        """
        The server host endpoint.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="isCertAuth")
    def is_cert_auth(self) -> Optional[bool]:
        """
         Is it using certificate to authenticate. If false then use client secret.
        """
        return pulumi.get(self, "is_cert_auth")

    @property
    @pulumi.getter(name="portNumber")
    def port_number(self) -> Optional[str]:
        """
        / The Azure SQL port number.
        """
        return pulumi.get(self, "port_number")

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[str]:
        """
        Resource Group.
        """
        return pulumi.get(self, "resource_group")

    @property
    @pulumi.getter(name="resourceUri")
    def resource_uri(self) -> Optional[str]:
        """
        The resource the service principal/app has access to.
        """
        return pulumi.get(self, "resource_uri")

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> Optional[str]:
        """
        The Azure SQL server name.
        """
        return pulumi.get(self, "server_name")

    @property
    @pulumi.getter(name="serviceDataAccessAuthIdentity")
    def service_data_access_auth_identity(self) -> Optional[str]:
        """
        Indicates which identity to use to authenticate service data access to customer's storage.
        """
        return pulumi.get(self, "service_data_access_auth_identity")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[str]:
        """
        Subscription ID.
        """
        return pulumi.get(self, "subscription_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[str]:
        """
        The ID of the tenant the service principal/app belongs to.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def thumbprint(self) -> Optional[str]:
        """
        The thumbprint of the certificate above.
        """
        return pulumi.get(self, "thumbprint")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[str]:
        """
        The Azure SQL user id.
        """
        return pulumi.get(self, "user_id")

    @property
    @pulumi.getter(name="userPassword")
    def user_password(self) -> Optional[str]:
        """
        The Azure SQL user password.
        """
        return pulumi.get(self, "user_password")


@pulumi.output_type
class AzureSqlDatabaseSectionResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorityUrl":
            suggest = "authority_url"
        elif key == "clientId":
            suggest = "client_id"
        elif key == "clientSecret":
            suggest = "client_secret"
        elif key == "credentialType":
            suggest = "credential_type"
        elif key == "databaseName":
            suggest = "database_name"
        elif key == "isCertAuth":
            suggest = "is_cert_auth"
        elif key == "portNumber":
            suggest = "port_number"
        elif key == "resourceGroup":
            suggest = "resource_group"
        elif key == "resourceUri":
            suggest = "resource_uri"
        elif key == "serverName":
            suggest = "server_name"
        elif key == "serviceDataAccessAuthIdentity":
            suggest = "service_data_access_auth_identity"
        elif key == "subscriptionId":
            suggest = "subscription_id"
        elif key == "tenantId":
            suggest = "tenant_id"
        elif key == "userId":
            suggest = "user_id"
        elif key == "userPassword":
            suggest = "user_password"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureSqlDatabaseSectionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureSqlDatabaseSectionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureSqlDatabaseSectionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authority_url: Optional[str] = None,
                 certificate: Optional[str] = None,
                 client_id: Optional[str] = None,
                 client_secret: Optional[str] = None,
                 credential_type: Optional[str] = None,
                 database_name: Optional[str] = None,
                 endpoint: Optional[str] = None,
                 is_cert_auth: Optional[bool] = None,
                 port_number: Optional[str] = None,
                 resource_group: Optional[str] = None,
                 resource_uri: Optional[str] = None,
                 server_name: Optional[str] = None,
                 service_data_access_auth_identity: Optional[str] = None,
                 subscription_id: Optional[str] = None,
                 tenant_id: Optional[str] = None,
                 thumbprint: Optional[str] = None,
                 user_id: Optional[str] = None,
                 user_password: Optional[str] = None):
        """
        :param str authority_url: The authority URL used for authentication.
        :param str certificate: The content of the certificate used for authentication.
        :param str client_id: The Client ID/Application ID
        :param str client_secret: The client secret.
        :param str credential_type: Sql Authentication type.
        :param str database_name: The Azure SQL database name.
        :param str endpoint: The server host endpoint.
        :param bool is_cert_auth:  Is it using certificate to authenticate. If false then use client secret.
        :param str port_number: / The Azure SQL port number.
        :param str resource_group: Resource Group.
        :param str resource_uri: The resource the service principal/app has access to.
        :param str server_name: The Azure SQL server name.
        :param str service_data_access_auth_identity: Indicates which identity to use to authenticate service data access to customer's storage.
        :param str subscription_id: Subscription ID.
        :param str tenant_id: The ID of the tenant the service principal/app belongs to.
        :param str thumbprint: The thumbprint of the certificate above.
        :param str user_id: The Azure SQL user id.
        :param str user_password: The Azure SQL user password.
        """
        if authority_url is not None:
            pulumi.set(__self__, "authority_url", authority_url)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if credential_type is not None:
            pulumi.set(__self__, "credential_type", credential_type)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if is_cert_auth is not None:
            pulumi.set(__self__, "is_cert_auth", is_cert_auth)
        if port_number is not None:
            pulumi.set(__self__, "port_number", port_number)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if resource_uri is not None:
            pulumi.set(__self__, "resource_uri", resource_uri)
        if server_name is not None:
            pulumi.set(__self__, "server_name", server_name)
        if service_data_access_auth_identity is not None:
            pulumi.set(__self__, "service_data_access_auth_identity", service_data_access_auth_identity)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if thumbprint is not None:
            pulumi.set(__self__, "thumbprint", thumbprint)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)
        if user_password is not None:
            pulumi.set(__self__, "user_password", user_password)

    @property
    @pulumi.getter(name="authorityUrl")
    def authority_url(self) -> Optional[str]:
        """
        The authority URL used for authentication.
        """
        return pulumi.get(self, "authority_url")

    @property
    @pulumi.getter
    def certificate(self) -> Optional[str]:
        """
        The content of the certificate used for authentication.
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[str]:
        """
        The Client ID/Application ID
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[str]:
        """
        The client secret.
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter(name="credentialType")
    def credential_type(self) -> Optional[str]:
        """
        Sql Authentication type.
        """
        return pulumi.get(self, "credential_type")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[str]:
        """
        The Azure SQL database name.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[str]:
        """
        The server host endpoint.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="isCertAuth")
    def is_cert_auth(self) -> Optional[bool]:
        """
         Is it using certificate to authenticate. If false then use client secret.
        """
        return pulumi.get(self, "is_cert_auth")

    @property
    @pulumi.getter(name="portNumber")
    def port_number(self) -> Optional[str]:
        """
        / The Azure SQL port number.
        """
        return pulumi.get(self, "port_number")

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[str]:
        """
        Resource Group.
        """
        return pulumi.get(self, "resource_group")

    @property
    @pulumi.getter(name="resourceUri")
    def resource_uri(self) -> Optional[str]:
        """
        The resource the service principal/app has access to.
        """
        return pulumi.get(self, "resource_uri")

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> Optional[str]:
        """
        The Azure SQL server name.
        """
        return pulumi.get(self, "server_name")

    @property
    @pulumi.getter(name="serviceDataAccessAuthIdentity")
    def service_data_access_auth_identity(self) -> Optional[str]:
        """
        Indicates which identity to use to authenticate service data access to customer's storage.
        """
        return pulumi.get(self, "service_data_access_auth_identity")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[str]:
        """
        Subscription ID.
        """
        return pulumi.get(self, "subscription_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[str]:
        """
        The ID of the tenant the service principal/app belongs to.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def thumbprint(self) -> Optional[str]:
        """
        The thumbprint of the certificate above.
        """
        return pulumi.get(self, "thumbprint")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[str]:
        """
        The Azure SQL user id.
        """
        return pulumi.get(self, "user_id")

    @property
    @pulumi.getter(name="userPassword")
    def user_password(self) -> Optional[str]:
        """
        The Azure SQL user password.
        """
        return pulumi.get(self, "user_password")


@pulumi.output_type
class AzureStorageSectionResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountKey":
            suggest = "account_key"
        elif key == "accountName":
            suggest = "account_name"
        elif key == "areWorkspaceManagedIdentitiesAllowed":
            suggest = "are_workspace_managed_identities_allowed"
        elif key == "blobCacheTimeout":
            suggest = "blob_cache_timeout"
        elif key == "clientCredentials":
            suggest = "client_credentials"
        elif key == "containerName":
            suggest = "container_name"
        elif key == "credentialType":
            suggest = "credential_type"
        elif key == "isSas":
            suggest = "is_sas"
        elif key == "resourceGroup":
            suggest = "resource_group"
        elif key == "sasToken":
            suggest = "sas_token"
        elif key == "serviceDataAccessAuthIdentity":
            suggest = "service_data_access_auth_identity"
        elif key == "subscriptionId":
            suggest = "subscription_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureStorageSectionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureStorageSectionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureStorageSectionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_key: Optional[str] = None,
                 account_name: Optional[str] = None,
                 are_workspace_managed_identities_allowed: Optional[bool] = None,
                 blob_cache_timeout: Optional[int] = None,
                 client_credentials: Optional['outputs.ClientCredentialsResponse'] = None,
                 container_name: Optional[str] = None,
                 credential: Optional[str] = None,
                 credential_type: Optional[str] = None,
                 endpoint: Optional[str] = None,
                 is_sas: Optional[bool] = None,
                 protocol: Optional[str] = None,
                 resource_group: Optional[str] = None,
                 sas_token: Optional[str] = None,
                 service_data_access_auth_identity: Optional[str] = None,
                 subscription_id: Optional[str] = None):
        """
        :param str account_key:  Storage Account Key (Deprecated).
        :param str account_name: Storage Account Name.
        :param bool are_workspace_managed_identities_allowed: Indicate if we are using Workspace ManagedIdentities/MSI token (Deprecated).
        :param int blob_cache_timeout:  If this is an "DataStoreType.AzureBlob", the length of time (in seconds) to cache files locally after they are accessed (downloaded).
        :param str container_name: The storage container name.
        :param str credential: The credential.
        :param str credential_type:  The credential type.
        :param str endpoint: The host of the container.
        :param bool is_sas: Indicate if we are using SAS token or Account Key (Deprecated).
        :param str protocol: The protocol to use. Defaults to https.
        :param str resource_group: Resource Group.
        :param str sas_token:  SAS Token for the container (Deprecated).
        :param str service_data_access_auth_identity: Indicates which identity to use to authenticate service data access to customer's storage.
        :param str subscription_id: Subscription ID.
        """
        if account_key is not None:
            pulumi.set(__self__, "account_key", account_key)
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if are_workspace_managed_identities_allowed is not None:
            pulumi.set(__self__, "are_workspace_managed_identities_allowed", are_workspace_managed_identities_allowed)
        if blob_cache_timeout is not None:
            pulumi.set(__self__, "blob_cache_timeout", blob_cache_timeout)
        if client_credentials is not None:
            pulumi.set(__self__, "client_credentials", client_credentials)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if credential is not None:
            pulumi.set(__self__, "credential", credential)
        if credential_type is not None:
            pulumi.set(__self__, "credential_type", credential_type)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if is_sas is not None:
            pulumi.set(__self__, "is_sas", is_sas)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if sas_token is not None:
            pulumi.set(__self__, "sas_token", sas_token)
        if service_data_access_auth_identity is not None:
            pulumi.set(__self__, "service_data_access_auth_identity", service_data_access_auth_identity)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)

    @property
    @pulumi.getter(name="accountKey")
    def account_key(self) -> Optional[str]:
        """
         Storage Account Key (Deprecated).
        """
        return pulumi.get(self, "account_key")

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[str]:
        """
        Storage Account Name.
        """
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter(name="areWorkspaceManagedIdentitiesAllowed")
    def are_workspace_managed_identities_allowed(self) -> Optional[bool]:
        """
        Indicate if we are using Workspace ManagedIdentities/MSI token (Deprecated).
        """
        return pulumi.get(self, "are_workspace_managed_identities_allowed")

    @property
    @pulumi.getter(name="blobCacheTimeout")
    def blob_cache_timeout(self) -> Optional[int]:
        """
         If this is an "DataStoreType.AzureBlob", the length of time (in seconds) to cache files locally after they are accessed (downloaded).
        """
        return pulumi.get(self, "blob_cache_timeout")

    @property
    @pulumi.getter(name="clientCredentials")
    def client_credentials(self) -> Optional['outputs.ClientCredentialsResponse']:
        return pulumi.get(self, "client_credentials")

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[str]:
        """
        The storage container name.
        """
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter
    def credential(self) -> Optional[str]:
        """
        The credential.
        """
        return pulumi.get(self, "credential")

    @property
    @pulumi.getter(name="credentialType")
    def credential_type(self) -> Optional[str]:
        """
         The credential type.
        """
        return pulumi.get(self, "credential_type")

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[str]:
        """
        The host of the container.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="isSas")
    def is_sas(self) -> Optional[bool]:
        """
        Indicate if we are using SAS token or Account Key (Deprecated).
        """
        return pulumi.get(self, "is_sas")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        """
        The protocol to use. Defaults to https.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[str]:
        """
        Resource Group.
        """
        return pulumi.get(self, "resource_group")

    @property
    @pulumi.getter(name="sasToken")
    def sas_token(self) -> Optional[str]:
        """
         SAS Token for the container (Deprecated).
        """
        return pulumi.get(self, "sas_token")

    @property
    @pulumi.getter(name="serviceDataAccessAuthIdentity")
    def service_data_access_auth_identity(self) -> Optional[str]:
        """
        Indicates which identity to use to authenticate service data access to customer's storage.
        """
        return pulumi.get(self, "service_data_access_auth_identity")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[str]:
        """
        Subscription ID.
        """
        return pulumi.get(self, "subscription_id")


@pulumi.output_type
class BanditPolicyResponse(dict):
    """
    Defines an early termination policy based on slack criteria, and a frequency and delay interval for evaluation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "policyType":
            suggest = "policy_type"
        elif key == "delayEvaluation":
            suggest = "delay_evaluation"
        elif key == "evaluationInterval":
            suggest = "evaluation_interval"
        elif key == "slackAmount":
            suggest = "slack_amount"
        elif key == "slackFactor":
            suggest = "slack_factor"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BanditPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BanditPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BanditPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 policy_type: str,
                 delay_evaluation: Optional[int] = None,
                 evaluation_interval: Optional[int] = None,
                 slack_amount: Optional[float] = None,
                 slack_factor: Optional[float] = None):
        """
        Defines an early termination policy based on slack criteria, and a frequency and delay interval for evaluation.
        :param str policy_type: 
               Expected value is 'Bandit'.
        :param int delay_evaluation: Number of intervals by which to delay the first evaluation.
        :param int evaluation_interval: Interval (number of runs) between policy evaluations.
        :param float slack_amount: Absolute distance allowed from the best performing run.
        :param float slack_factor: Ratio of the allowed distance from the best performing run.
        """
        pulumi.set(__self__, "policy_type", 'Bandit')
        if delay_evaluation is not None:
            pulumi.set(__self__, "delay_evaluation", delay_evaluation)
        if evaluation_interval is not None:
            pulumi.set(__self__, "evaluation_interval", evaluation_interval)
        if slack_amount is not None:
            pulumi.set(__self__, "slack_amount", slack_amount)
        if slack_factor is not None:
            pulumi.set(__self__, "slack_factor", slack_factor)

    @property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> str:
        """

        Expected value is 'Bandit'.
        """
        return pulumi.get(self, "policy_type")

    @property
    @pulumi.getter(name="delayEvaluation")
    def delay_evaluation(self) -> Optional[int]:
        """
        Number of intervals by which to delay the first evaluation.
        """
        return pulumi.get(self, "delay_evaluation")

    @property
    @pulumi.getter(name="evaluationInterval")
    def evaluation_interval(self) -> Optional[int]:
        """
        Interval (number of runs) between policy evaluations.
        """
        return pulumi.get(self, "evaluation_interval")

    @property
    @pulumi.getter(name="slackAmount")
    def slack_amount(self) -> Optional[float]:
        """
        Absolute distance allowed from the best performing run.
        """
        return pulumi.get(self, "slack_amount")

    @property
    @pulumi.getter(name="slackFactor")
    def slack_factor(self) -> Optional[float]:
        """
        Ratio of the allowed distance from the best performing run.
        """
        return pulumi.get(self, "slack_factor")


@pulumi.output_type
class BatchDeploymentResponse(dict):
    """
    Batch inference settings per deployment.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "codeConfiguration":
            suggest = "code_configuration"
        elif key == "environmentId":
            suggest = "environment_id"
        elif key == "environmentVariables":
            suggest = "environment_variables"
        elif key == "errorThreshold":
            suggest = "error_threshold"
        elif key == "loggingLevel":
            suggest = "logging_level"
        elif key == "miniBatchSize":
            suggest = "mini_batch_size"
        elif key == "outputConfiguration":
            suggest = "output_configuration"
        elif key == "partitionKeys":
            suggest = "partition_keys"
        elif key == "retrySettings":
            suggest = "retry_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BatchDeploymentResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BatchDeploymentResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BatchDeploymentResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 code_configuration: Optional['outputs.CodeConfigurationResponse'] = None,
                 compute: Optional['outputs.ComputeConfigurationResponse'] = None,
                 description: Optional[str] = None,
                 environment_id: Optional[str] = None,
                 environment_variables: Optional[Mapping[str, str]] = None,
                 error_threshold: Optional[int] = None,
                 logging_level: Optional[str] = None,
                 mini_batch_size: Optional[float] = None,
                 model: Optional[Any] = None,
                 output_configuration: Optional['outputs.BatchOutputConfigurationResponse'] = None,
                 partition_keys: Optional[Sequence[str]] = None,
                 properties: Optional[Mapping[str, str]] = None,
                 retry_settings: Optional['outputs.BatchRetrySettingsResponse'] = None):
        """
        Batch inference settings per deployment.
        :param 'CodeConfigurationResponse' code_configuration: Code configuration for the endpoint deployment.
        :param 'ComputeConfigurationResponse' compute: Configuration for compute binding.
        :param str description: Description of the endpoint deployment.
        :param str environment_id: ARM resource ID of the environment specification for the endpoint deployment.
        :param Mapping[str, str] environment_variables: Environment variables configuration for the deployment.
        :param int error_threshold: Error threshold, if the error count for the entire input goes above this value,
               the batch inference will be aborted. Range is [-1, int.MaxValue].
               For FileDataset, this value is the count of file failures.
               For TabularDataset, this value is the count of record failures.
               If set to -1 (the lower bound), all failures during batch inference will be ignored.
        :param str logging_level: Logging level for batch inference operation.
        :param float mini_batch_size: Size of the mini-batch passed to each batch invocation.
               For FileDataset, this is the number of files per mini-batch.
               For TabularDataset, this is the size of the records in bytes, per mini-batch.
        :param Union['DataPathAssetReferenceResponse', 'IdAssetReferenceResponse', 'OutputPathAssetReferenceResponse'] model: Reference to the model asset for the endpoint deployment.
        :param 'BatchOutputConfigurationResponse' output_configuration: Output configuration for the batch inference operation.
        :param Sequence[str] partition_keys: Partition keys list used for Named partitioning.
        :param Mapping[str, str] properties: Property dictionary. Properties can be added, but not removed or altered.
        :param 'BatchRetrySettingsResponse' retry_settings: Retry Settings for the batch inference operation.
        """
        if code_configuration is not None:
            pulumi.set(__self__, "code_configuration", code_configuration)
        if compute is not None:
            pulumi.set(__self__, "compute", compute)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if environment_id is not None:
            pulumi.set(__self__, "environment_id", environment_id)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if error_threshold is not None:
            pulumi.set(__self__, "error_threshold", error_threshold)
        if logging_level is not None:
            pulumi.set(__self__, "logging_level", logging_level)
        if mini_batch_size is not None:
            pulumi.set(__self__, "mini_batch_size", mini_batch_size)
        if model is not None:
            pulumi.set(__self__, "model", model)
        if output_configuration is not None:
            pulumi.set(__self__, "output_configuration", output_configuration)
        if partition_keys is not None:
            pulumi.set(__self__, "partition_keys", partition_keys)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if retry_settings is not None:
            pulumi.set(__self__, "retry_settings", retry_settings)

    @property
    @pulumi.getter(name="codeConfiguration")
    def code_configuration(self) -> Optional['outputs.CodeConfigurationResponse']:
        """
        Code configuration for the endpoint deployment.
        """
        return pulumi.get(self, "code_configuration")

    @property
    @pulumi.getter
    def compute(self) -> Optional['outputs.ComputeConfigurationResponse']:
        """
        Configuration for compute binding.
        """
        return pulumi.get(self, "compute")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of the endpoint deployment.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> Optional[str]:
        """
        ARM resource ID of the environment specification for the endpoint deployment.
        """
        return pulumi.get(self, "environment_id")

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[Mapping[str, str]]:
        """
        Environment variables configuration for the deployment.
        """
        return pulumi.get(self, "environment_variables")

    @property
    @pulumi.getter(name="errorThreshold")
    def error_threshold(self) -> Optional[int]:
        """
        Error threshold, if the error count for the entire input goes above this value,
        the batch inference will be aborted. Range is [-1, int.MaxValue].
        For FileDataset, this value is the count of file failures.
        For TabularDataset, this value is the count of record failures.
        If set to -1 (the lower bound), all failures during batch inference will be ignored.
        """
        return pulumi.get(self, "error_threshold")

    @property
    @pulumi.getter(name="loggingLevel")
    def logging_level(self) -> Optional[str]:
        """
        Logging level for batch inference operation.
        """
        return pulumi.get(self, "logging_level")

    @property
    @pulumi.getter(name="miniBatchSize")
    def mini_batch_size(self) -> Optional[float]:
        """
        Size of the mini-batch passed to each batch invocation.
        For FileDataset, this is the number of files per mini-batch.
        For TabularDataset, this is the size of the records in bytes, per mini-batch.
        """
        return pulumi.get(self, "mini_batch_size")

    @property
    @pulumi.getter
    def model(self) -> Optional[Any]:
        """
        Reference to the model asset for the endpoint deployment.
        """
        return pulumi.get(self, "model")

    @property
    @pulumi.getter(name="outputConfiguration")
    def output_configuration(self) -> Optional['outputs.BatchOutputConfigurationResponse']:
        """
        Output configuration for the batch inference operation.
        """
        return pulumi.get(self, "output_configuration")

    @property
    @pulumi.getter(name="partitionKeys")
    def partition_keys(self) -> Optional[Sequence[str]]:
        """
        Partition keys list used for Named partitioning.
        """
        return pulumi.get(self, "partition_keys")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        Property dictionary. Properties can be added, but not removed or altered.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="retrySettings")
    def retry_settings(self) -> Optional['outputs.BatchRetrySettingsResponse']:
        """
        Retry Settings for the batch inference operation.
        """
        return pulumi.get(self, "retry_settings")


@pulumi.output_type
class BatchEndpointResponse(dict):
    """
    Batch endpoint configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scoringUri":
            suggest = "scoring_uri"
        elif key == "swaggerUri":
            suggest = "swagger_uri"
        elif key == "authMode":
            suggest = "auth_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BatchEndpointResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BatchEndpointResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BatchEndpointResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 scoring_uri: str,
                 swagger_uri: str,
                 auth_mode: Optional[str] = None,
                 description: Optional[str] = None,
                 properties: Optional[Mapping[str, str]] = None,
                 traffic: Optional[Mapping[str, int]] = None):
        """
        Batch endpoint configuration.
        :param str scoring_uri: Endpoint URI.
        :param str swagger_uri: Endpoint Swagger URI.
        :param str auth_mode: [Required] Inference endpoint authentication mode type
        :param str description: Description of the inference endpoint.
        :param Mapping[str, str] properties: Property dictionary. Properties can be added, but not removed or altered.
        :param Mapping[str, int] traffic: Traffic rules on how the traffic will be routed across deployments.
        """
        pulumi.set(__self__, "scoring_uri", scoring_uri)
        pulumi.set(__self__, "swagger_uri", swagger_uri)
        if auth_mode is not None:
            pulumi.set(__self__, "auth_mode", auth_mode)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if traffic is not None:
            pulumi.set(__self__, "traffic", traffic)

    @property
    @pulumi.getter(name="scoringUri")
    def scoring_uri(self) -> str:
        """
        Endpoint URI.
        """
        return pulumi.get(self, "scoring_uri")

    @property
    @pulumi.getter(name="swaggerUri")
    def swagger_uri(self) -> str:
        """
        Endpoint Swagger URI.
        """
        return pulumi.get(self, "swagger_uri")

    @property
    @pulumi.getter(name="authMode")
    def auth_mode(self) -> Optional[str]:
        """
        [Required] Inference endpoint authentication mode type
        """
        return pulumi.get(self, "auth_mode")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of the inference endpoint.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        Property dictionary. Properties can be added, but not removed or altered.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def traffic(self) -> Optional[Mapping[str, int]]:
        """
        Traffic rules on how the traffic will be routed across deployments.
        """
        return pulumi.get(self, "traffic")


@pulumi.output_type
class BatchOutputConfigurationResponse(dict):
    """
    Batch inference output configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appendRowFileName":
            suggest = "append_row_file_name"
        elif key == "outputAction":
            suggest = "output_action"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BatchOutputConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BatchOutputConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BatchOutputConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 append_row_file_name: Optional[str] = None,
                 output_action: Optional[str] = None):
        """
        Batch inference output configuration.
        :param str append_row_file_name: Customized output file name for append_row output action.
        :param str output_action: Indicates how the output will be organized.
        """
        if append_row_file_name is not None:
            pulumi.set(__self__, "append_row_file_name", append_row_file_name)
        if output_action is not None:
            pulumi.set(__self__, "output_action", output_action)

    @property
    @pulumi.getter(name="appendRowFileName")
    def append_row_file_name(self) -> Optional[str]:
        """
        Customized output file name for append_row output action.
        """
        return pulumi.get(self, "append_row_file_name")

    @property
    @pulumi.getter(name="outputAction")
    def output_action(self) -> Optional[str]:
        """
        Indicates how the output will be organized.
        """
        return pulumi.get(self, "output_action")


@pulumi.output_type
class BatchRetrySettingsResponse(dict):
    """
    Retry settings for a batch inference operation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxRetries":
            suggest = "max_retries"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BatchRetrySettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BatchRetrySettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BatchRetrySettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_retries: Optional[int] = None,
                 timeout: Optional[str] = None):
        """
        Retry settings for a batch inference operation.
        :param int max_retries: Maximum retry count for a mini-batch
        :param str timeout: Invocation timeout for a mini-batch, in ISO 8601 format.
        """
        if max_retries is not None:
            pulumi.set(__self__, "max_retries", max_retries)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter(name="maxRetries")
    def max_retries(self) -> Optional[int]:
        """
        Maximum retry count for a mini-batch
        """
        return pulumi.get(self, "max_retries")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[str]:
        """
        Invocation timeout for a mini-batch, in ISO 8601 format.
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class ClientCredentialsResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorityUrl":
            suggest = "authority_url"
        elif key == "clientId":
            suggest = "client_id"
        elif key == "clientSecret":
            suggest = "client_secret"
        elif key == "isCertAuth":
            suggest = "is_cert_auth"
        elif key == "resourceGroup":
            suggest = "resource_group"
        elif key == "resourceUri":
            suggest = "resource_uri"
        elif key == "serviceDataAccessAuthIdentity":
            suggest = "service_data_access_auth_identity"
        elif key == "subscriptionId":
            suggest = "subscription_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClientCredentialsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClientCredentialsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClientCredentialsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authority_url: Optional[str] = None,
                 certificate: Optional[str] = None,
                 client_id: Optional[str] = None,
                 client_secret: Optional[str] = None,
                 is_cert_auth: Optional[bool] = None,
                 resource_group: Optional[str] = None,
                 resource_uri: Optional[str] = None,
                 service_data_access_auth_identity: Optional[str] = None,
                 subscription_id: Optional[str] = None,
                 tenant_id: Optional[str] = None,
                 thumbprint: Optional[str] = None):
        """
        :param str authority_url: The authority URL used for authentication.
        :param str certificate: The content of the certificate used for authentication.
        :param str client_id: The Client ID/Application ID
        :param str client_secret: The client secret.
        :param bool is_cert_auth:  Is it using certificate to authenticate. If false then use client secret.
        :param str resource_group: Resource Group.
        :param str resource_uri: The resource the service principal/app has access to.
        :param str service_data_access_auth_identity: Indicates which identity to use to authenticate service data access to customer's storage.
        :param str subscription_id: Subscription ID.
        :param str tenant_id: The ID of the tenant the service principal/app belongs to.
        :param str thumbprint: The thumbprint of the certificate above.
        """
        if authority_url is not None:
            pulumi.set(__self__, "authority_url", authority_url)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if is_cert_auth is not None:
            pulumi.set(__self__, "is_cert_auth", is_cert_auth)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if resource_uri is not None:
            pulumi.set(__self__, "resource_uri", resource_uri)
        if service_data_access_auth_identity is not None:
            pulumi.set(__self__, "service_data_access_auth_identity", service_data_access_auth_identity)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if thumbprint is not None:
            pulumi.set(__self__, "thumbprint", thumbprint)

    @property
    @pulumi.getter(name="authorityUrl")
    def authority_url(self) -> Optional[str]:
        """
        The authority URL used for authentication.
        """
        return pulumi.get(self, "authority_url")

    @property
    @pulumi.getter
    def certificate(self) -> Optional[str]:
        """
        The content of the certificate used for authentication.
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[str]:
        """
        The Client ID/Application ID
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[str]:
        """
        The client secret.
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter(name="isCertAuth")
    def is_cert_auth(self) -> Optional[bool]:
        """
         Is it using certificate to authenticate. If false then use client secret.
        """
        return pulumi.get(self, "is_cert_auth")

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[str]:
        """
        Resource Group.
        """
        return pulumi.get(self, "resource_group")

    @property
    @pulumi.getter(name="resourceUri")
    def resource_uri(self) -> Optional[str]:
        """
        The resource the service principal/app has access to.
        """
        return pulumi.get(self, "resource_uri")

    @property
    @pulumi.getter(name="serviceDataAccessAuthIdentity")
    def service_data_access_auth_identity(self) -> Optional[str]:
        """
        Indicates which identity to use to authenticate service data access to customer's storage.
        """
        return pulumi.get(self, "service_data_access_auth_identity")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[str]:
        """
        Subscription ID.
        """
        return pulumi.get(self, "subscription_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[str]:
        """
        The ID of the tenant the service principal/app belongs to.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def thumbprint(self) -> Optional[str]:
        """
        The thumbprint of the certificate above.
        """
        return pulumi.get(self, "thumbprint")


@pulumi.output_type
class CodeConfigurationResponse(dict):
    """
    Configuration for a scoring code asset.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scoringScript":
            suggest = "scoring_script"
        elif key == "codeId":
            suggest = "code_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CodeConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CodeConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CodeConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 scoring_script: str,
                 code_id: Optional[str] = None):
        """
        Configuration for a scoring code asset.
        :param str scoring_script: [Required] The script to execute on startup. eg. "score.py"
        :param str code_id: ARM resource ID of the code asset.
        """
        pulumi.set(__self__, "scoring_script", scoring_script)
        if code_id is not None:
            pulumi.set(__self__, "code_id", code_id)

    @property
    @pulumi.getter(name="scoringScript")
    def scoring_script(self) -> str:
        """
        [Required] The script to execute on startup. eg. "score.py"
        """
        return pulumi.get(self, "scoring_script")

    @property
    @pulumi.getter(name="codeId")
    def code_id(self) -> Optional[str]:
        """
        ARM resource ID of the code asset.
        """
        return pulumi.get(self, "code_id")


@pulumi.output_type
class CodeContainerResponse(dict):
    """
    Container for code asset versions.
    """
    def __init__(__self__, *,
                 description: Optional[str] = None,
                 properties: Optional[Mapping[str, str]] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        Container for code asset versions.
        :param str description: The asset description text.
        :param Mapping[str, str] properties: The asset property dictionary.
        :param Mapping[str, str] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class CodeVersionResponse(dict):
    """
    Code asset version details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datastoreId":
            suggest = "datastore_id"
        elif key == "isAnonymous":
            suggest = "is_anonymous"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CodeVersionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CodeVersionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CodeVersionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 path: str,
                 datastore_id: Optional[str] = None,
                 description: Optional[str] = None,
                 is_anonymous: Optional[bool] = None,
                 properties: Optional[Mapping[str, str]] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        Code asset version details.
        :param str path: [Required] The path of the file/directory in the datastore.
        :param str datastore_id: ARM resource ID of the datastore where the asset is located.
        :param str description: The asset description text.
        :param bool is_anonymous: If the name version are system generated (anonymous registration).
        :param Mapping[str, str] properties: The asset property dictionary.
        :param Mapping[str, str] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        pulumi.set(__self__, "path", path)
        if datastore_id is not None:
            pulumi.set(__self__, "datastore_id", datastore_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if is_anonymous is not None:
            pulumi.set(__self__, "is_anonymous", is_anonymous)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        [Required] The path of the file/directory in the datastore.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="datastoreId")
    def datastore_id(self) -> Optional[str]:
        """
        ARM resource ID of the datastore where the asset is located.
        """
        return pulumi.get(self, "datastore_id")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="isAnonymous")
    def is_anonymous(self) -> Optional[bool]:
        """
        If the name version are system generated (anonymous registration).
        """
        return pulumi.get(self, "is_anonymous")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class CommandJobResponse(dict):
    """
    Command job definition.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "interactionEndpoints":
            suggest = "interaction_endpoints"
        elif key == "jobType":
            suggest = "job_type"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "codeId":
            suggest = "code_id"
        elif key == "environmentId":
            suggest = "environment_id"
        elif key == "environmentVariables":
            suggest = "environment_variables"
        elif key == "experimentName":
            suggest = "experiment_name"
        elif key == "inputDataBindings":
            suggest = "input_data_bindings"
        elif key == "outputDataBindings":
            suggest = "output_data_bindings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CommandJobResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CommandJobResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CommandJobResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 command: str,
                 compute: 'outputs.ComputeConfigurationResponse',
                 interaction_endpoints: Mapping[str, 'outputs.JobEndpointResponse'],
                 job_type: str,
                 output: 'outputs.JobOutputResponse',
                 parameters: Any,
                 provisioning_state: str,
                 status: str,
                 code_id: Optional[str] = None,
                 description: Optional[str] = None,
                 distribution: Optional[Any] = None,
                 environment_id: Optional[str] = None,
                 environment_variables: Optional[Mapping[str, str]] = None,
                 experiment_name: Optional[str] = None,
                 identity: Optional[Any] = None,
                 input_data_bindings: Optional[Mapping[str, 'outputs.InputDataBindingResponse']] = None,
                 output_data_bindings: Optional[Mapping[str, 'outputs.OutputDataBindingResponse']] = None,
                 priority: Optional[int] = None,
                 properties: Optional[Mapping[str, str]] = None,
                 tags: Optional[Mapping[str, str]] = None,
                 timeout: Optional[str] = None):
        """
        Command job definition.
        :param str command: [Required] The command to execute on startup of the job. eg. "python train.py"
        :param 'ComputeConfigurationResponse' compute: [Required] Compute binding for the job.
        :param Mapping[str, 'JobEndpointResponse'] interaction_endpoints: List of JobEndpoints.
               For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
        :param str job_type: Enum to determine the type of job.
               Expected value is 'Command'.
        :param 'JobOutputResponse' output: Location of the job output logs and artifacts.
        :param Any parameters: Input parameters.
        :param str provisioning_state: Specifies the job provisioning state.
        :param str status: Status of the job.
        :param str code_id: ARM resource ID of the code asset.
        :param str description: The asset description text.
        :param Union['MpiResponse', 'PyTorchResponse', 'TensorFlowResponse'] distribution: Distribution configuration of the job. If set, this should be one of Mpi, Tensorflow, PyTorch, or null.
        :param str environment_id: The ARM resource ID of the Environment specification for the job.
        :param Mapping[str, str] environment_variables: Environment variables included in the job.
        :param str experiment_name: The name of the experiment the job belongs to. If not set, the job is placed in the "Default" experiment.
        :param Union['AmlTokenResponse', 'ManagedIdentityResponse'] identity: Identity configuration. If set, this should be one of AmlToken, ManagedIdentity, or null.
               Defaults to AmlToken if null.
        :param Mapping[str, 'InputDataBindingResponse'] input_data_bindings: Mapping of input data bindings used in the job.
        :param Mapping[str, 'OutputDataBindingResponse'] output_data_bindings: Mapping of output data bindings used in the job.
        :param int priority: Job priority for scheduling policy. Only applies to AMLCompute.
               Private preview feature and only available to users on the allow list.
        :param Mapping[str, str] properties: The asset property dictionary.
        :param Mapping[str, str] tags: Tag dictionary. Tags can be added, removed, and updated.
        :param str timeout: The max run duration in ISO 8601 format, after which the job will be cancelled. Only supports duration with precision as low as Seconds.
        """
        pulumi.set(__self__, "command", command)
        pulumi.set(__self__, "compute", compute)
        pulumi.set(__self__, "interaction_endpoints", interaction_endpoints)
        pulumi.set(__self__, "job_type", 'Command')
        pulumi.set(__self__, "output", output)
        pulumi.set(__self__, "parameters", parameters)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "status", status)
        if code_id is not None:
            pulumi.set(__self__, "code_id", code_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if distribution is not None:
            pulumi.set(__self__, "distribution", distribution)
        if environment_id is not None:
            pulumi.set(__self__, "environment_id", environment_id)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if experiment_name is not None:
            pulumi.set(__self__, "experiment_name", experiment_name)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if input_data_bindings is not None:
            pulumi.set(__self__, "input_data_bindings", input_data_bindings)
        if output_data_bindings is not None:
            pulumi.set(__self__, "output_data_bindings", output_data_bindings)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter
    def command(self) -> str:
        """
        [Required] The command to execute on startup of the job. eg. "python train.py"
        """
        return pulumi.get(self, "command")

    @property
    @pulumi.getter
    def compute(self) -> 'outputs.ComputeConfigurationResponse':
        """
        [Required] Compute binding for the job.
        """
        return pulumi.get(self, "compute")

    @property
    @pulumi.getter(name="interactionEndpoints")
    def interaction_endpoints(self) -> Mapping[str, 'outputs.JobEndpointResponse']:
        """
        List of JobEndpoints.
        For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
        """
        return pulumi.get(self, "interaction_endpoints")

    @property
    @pulumi.getter(name="jobType")
    def job_type(self) -> str:
        """
        Enum to determine the type of job.
        Expected value is 'Command'.
        """
        return pulumi.get(self, "job_type")

    @property
    @pulumi.getter
    def output(self) -> 'outputs.JobOutputResponse':
        """
        Location of the job output logs and artifacts.
        """
        return pulumi.get(self, "output")

    @property
    @pulumi.getter
    def parameters(self) -> Any:
        """
        Input parameters.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Specifies the job provisioning state.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of the job.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="codeId")
    def code_id(self) -> Optional[str]:
        """
        ARM resource ID of the code asset.
        """
        return pulumi.get(self, "code_id")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def distribution(self) -> Optional[Any]:
        """
        Distribution configuration of the job. If set, this should be one of Mpi, Tensorflow, PyTorch, or null.
        """
        return pulumi.get(self, "distribution")

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> Optional[str]:
        """
        The ARM resource ID of the Environment specification for the job.
        """
        return pulumi.get(self, "environment_id")

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[Mapping[str, str]]:
        """
        Environment variables included in the job.
        """
        return pulumi.get(self, "environment_variables")

    @property
    @pulumi.getter(name="experimentName")
    def experiment_name(self) -> Optional[str]:
        """
        The name of the experiment the job belongs to. If not set, the job is placed in the "Default" experiment.
        """
        return pulumi.get(self, "experiment_name")

    @property
    @pulumi.getter
    def identity(self) -> Optional[Any]:
        """
        Identity configuration. If set, this should be one of AmlToken, ManagedIdentity, or null.
        Defaults to AmlToken if null.
        """
        return pulumi.get(self, "identity")

    @property
    @pulumi.getter(name="inputDataBindings")
    def input_data_bindings(self) -> Optional[Mapping[str, 'outputs.InputDataBindingResponse']]:
        """
        Mapping of input data bindings used in the job.
        """
        return pulumi.get(self, "input_data_bindings")

    @property
    @pulumi.getter(name="outputDataBindings")
    def output_data_bindings(self) -> Optional[Mapping[str, 'outputs.OutputDataBindingResponse']]:
        """
        Mapping of output data bindings used in the job.
        """
        return pulumi.get(self, "output_data_bindings")

    @property
    @pulumi.getter
    def priority(self) -> Optional[int]:
        """
        Job priority for scheduling policy. Only applies to AMLCompute.
        Private preview feature and only available to users on the allow list.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[str]:
        """
        The max run duration in ISO 8601 format, after which the job will be cancelled. Only supports duration with precision as low as Seconds.
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class ComputeBindingResponse(dict):
    """
    Compute binding definition.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computeId":
            suggest = "compute_id"
        elif key == "nodeCount":
            suggest = "node_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComputeBindingResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComputeBindingResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComputeBindingResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compute_id: Optional[str] = None,
                 node_count: Optional[int] = None):
        """
        Compute binding definition.
        :param str compute_id: ID of the compute resource.
        :param int node_count: Number of nodes.
        """
        if compute_id is not None:
            pulumi.set(__self__, "compute_id", compute_id)
        if node_count is not None:
            pulumi.set(__self__, "node_count", node_count)

    @property
    @pulumi.getter(name="computeId")
    def compute_id(self) -> Optional[str]:
        """
        ID of the compute resource.
        """
        return pulumi.get(self, "compute_id")

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> Optional[int]:
        """
        Number of nodes.
        """
        return pulumi.get(self, "node_count")


@pulumi.output_type
class ComputeConfigurationResponse(dict):
    """
    Configuration for compute binding.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceCount":
            suggest = "instance_count"
        elif key == "instanceType":
            suggest = "instance_type"
        elif key == "isLocal":
            suggest = "is_local"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComputeConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComputeConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComputeConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_count: Optional[int] = None,
                 instance_type: Optional[str] = None,
                 is_local: Optional[bool] = None,
                 location: Optional[str] = None,
                 properties: Optional[Mapping[str, str]] = None,
                 target: Optional[str] = None):
        """
        Configuration for compute binding.
        :param int instance_count: Number of instances or nodes.
        :param str instance_type: SKU type to run on.
        :param bool is_local: Set to true for jobs running on local compute.
        :param str location: Location for virtual cluster run.
        :param Mapping[str, str] properties: Additional properties.
        :param str target: ARM resource ID of the Compute you are targeting. If not provided the resource will be deployed as Managed.
        """
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if is_local is not None:
            pulumi.set(__self__, "is_local", is_local)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[int]:
        """
        Number of instances or nodes.
        """
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[str]:
        """
        SKU type to run on.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="isLocal")
    def is_local(self) -> Optional[bool]:
        """
        Set to true for jobs running on local compute.
        """
        return pulumi.get(self, "is_local")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Location for virtual cluster run.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        Additional properties.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def target(self) -> Optional[str]:
        """
        ARM resource ID of the Compute you are targeting. If not provided the resource will be deployed as Managed.
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class ComputeInstanceApplicationResponse(dict):
    """
    Defines an Aml Instance application and its connectivity endpoint URI.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"
        elif key == "endpointUri":
            suggest = "endpoint_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComputeInstanceApplicationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComputeInstanceApplicationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComputeInstanceApplicationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 display_name: Optional[str] = None,
                 endpoint_uri: Optional[str] = None):
        """
        Defines an Aml Instance application and its connectivity endpoint URI.
        :param str display_name: Name of the ComputeInstance application.
        :param str endpoint_uri: Application' endpoint URI.
        """
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if endpoint_uri is not None:
            pulumi.set(__self__, "endpoint_uri", endpoint_uri)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        Name of the ComputeInstance application.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="endpointUri")
    def endpoint_uri(self) -> Optional[str]:
        """
        Application' endpoint URI.
        """
        return pulumi.get(self, "endpoint_uri")


@pulumi.output_type
class ComputeInstanceConnectivityEndpointsResponse(dict):
    """
    Defines all connectivity endpoints and properties for an ComputeInstance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateIpAddress":
            suggest = "private_ip_address"
        elif key == "publicIpAddress":
            suggest = "public_ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComputeInstanceConnectivityEndpointsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComputeInstanceConnectivityEndpointsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComputeInstanceConnectivityEndpointsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 private_ip_address: str,
                 public_ip_address: str):
        """
        Defines all connectivity endpoints and properties for an ComputeInstance.
        :param str private_ip_address: Private IP Address of this ComputeInstance (local to the VNET in which the compute instance is deployed).
        :param str public_ip_address: Public IP Address of this ComputeInstance.
        """
        pulumi.set(__self__, "private_ip_address", private_ip_address)
        pulumi.set(__self__, "public_ip_address", public_ip_address)

    @property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> str:
        """
        Private IP Address of this ComputeInstance (local to the VNET in which the compute instance is deployed).
        """
        return pulumi.get(self, "private_ip_address")

    @property
    @pulumi.getter(name="publicIpAddress")
    def public_ip_address(self) -> str:
        """
        Public IP Address of this ComputeInstance.
        """
        return pulumi.get(self, "public_ip_address")


@pulumi.output_type
class ComputeInstanceCreatedByResponse(dict):
    """
    Describes information on user who created this ComputeInstance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userId":
            suggest = "user_id"
        elif key == "userName":
            suggest = "user_name"
        elif key == "userOrgId":
            suggest = "user_org_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComputeInstanceCreatedByResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComputeInstanceCreatedByResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComputeInstanceCreatedByResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 user_id: str,
                 user_name: str,
                 user_org_id: str):
        """
        Describes information on user who created this ComputeInstance.
        :param str user_id: Uniquely identifies the user within his/her organization.
        :param str user_name: Name of the user.
        :param str user_org_id: Uniquely identifies user' Azure Active Directory organization.
        """
        pulumi.set(__self__, "user_id", user_id)
        pulumi.set(__self__, "user_name", user_name)
        pulumi.set(__self__, "user_org_id", user_org_id)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> str:
        """
        Uniquely identifies the user within his/her organization.
        """
        return pulumi.get(self, "user_id")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> str:
        """
        Name of the user.
        """
        return pulumi.get(self, "user_name")

    @property
    @pulumi.getter(name="userOrgId")
    def user_org_id(self) -> str:
        """
        Uniquely identifies user' Azure Active Directory organization.
        """
        return pulumi.get(self, "user_org_id")


@pulumi.output_type
class ComputeInstanceLastOperationResponse(dict):
    """
    The last operation on ComputeInstance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "operationName":
            suggest = "operation_name"
        elif key == "operationStatus":
            suggest = "operation_status"
        elif key == "operationTime":
            suggest = "operation_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComputeInstanceLastOperationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComputeInstanceLastOperationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComputeInstanceLastOperationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operation_name: Optional[str] = None,
                 operation_status: Optional[str] = None,
                 operation_time: Optional[str] = None):
        """
        The last operation on ComputeInstance.
        :param str operation_name: Name of the last operation.
        :param str operation_status: Operation status.
        :param str operation_time: Time of the last operation.
        """
        if operation_name is not None:
            pulumi.set(__self__, "operation_name", operation_name)
        if operation_status is not None:
            pulumi.set(__self__, "operation_status", operation_status)
        if operation_time is not None:
            pulumi.set(__self__, "operation_time", operation_time)

    @property
    @pulumi.getter(name="operationName")
    def operation_name(self) -> Optional[str]:
        """
        Name of the last operation.
        """
        return pulumi.get(self, "operation_name")

    @property
    @pulumi.getter(name="operationStatus")
    def operation_status(self) -> Optional[str]:
        """
        Operation status.
        """
        return pulumi.get(self, "operation_status")

    @property
    @pulumi.getter(name="operationTime")
    def operation_time(self) -> Optional[str]:
        """
        Time of the last operation.
        """
        return pulumi.get(self, "operation_time")


@pulumi.output_type
class ComputeInstanceResponse(dict):
    """
    An Azure Machine Learning compute instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computeType":
            suggest = "compute_type"
        elif key == "isAttachedCompute":
            suggest = "is_attached_compute"
        elif key == "provisioningErrors":
            suggest = "provisioning_errors"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "computeLocation":
            suggest = "compute_location"
        elif key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComputeInstanceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComputeInstanceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComputeInstanceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compute_type: str,
                 is_attached_compute: bool,
                 provisioning_errors: Sequence['outputs.MachineLearningServiceErrorResponse'],
                 provisioning_state: str,
                 compute_location: Optional[str] = None,
                 description: Optional[str] = None,
                 properties: Optional['outputs.ComputeInstanceResponseProperties'] = None,
                 resource_id: Optional[str] = None):
        """
        An Azure Machine Learning compute instance.
        :param str compute_type: The type of compute
               Expected value is 'ComputeInstance'.
        :param bool is_attached_compute: Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
        :param Sequence['MachineLearningServiceErrorResponse'] provisioning_errors: Errors during provisioning
        :param str provisioning_state: The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        :param str compute_location: Location for the underlying compute
        :param str description: The description of the Machine Learning compute.
        :param 'ComputeInstanceResponseProperties' properties: Compute Instance properties
        :param str resource_id: ARM resource id of the underlying compute
        """
        pulumi.set(__self__, "compute_type", 'ComputeInstance')
        pulumi.set(__self__, "is_attached_compute", is_attached_compute)
        pulumi.set(__self__, "provisioning_errors", provisioning_errors)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> str:
        """
        The type of compute
        Expected value is 'ComputeInstance'.
        """
        return pulumi.get(self, "compute_type")

    @property
    @pulumi.getter(name="isAttachedCompute")
    def is_attached_compute(self) -> bool:
        """
        Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
        """
        return pulumi.get(self, "is_attached_compute")

    @property
    @pulumi.getter(name="provisioningErrors")
    def provisioning_errors(self) -> Sequence['outputs.MachineLearningServiceErrorResponse']:
        """
        Errors during provisioning
        """
        return pulumi.get(self, "provisioning_errors")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[str]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.ComputeInstanceResponseProperties']:
        """
        Compute Instance properties
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        ARM resource id of the underlying compute
        """
        return pulumi.get(self, "resource_id")


@pulumi.output_type
class ComputeInstanceResponseProperties(dict):
    """
    Compute Instance properties
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectivityEndpoints":
            suggest = "connectivity_endpoints"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "lastOperation":
            suggest = "last_operation"
        elif key == "applicationSharingPolicy":
            suggest = "application_sharing_policy"
        elif key == "computeInstanceAuthorizationType":
            suggest = "compute_instance_authorization_type"
        elif key == "personalComputeInstanceSettings":
            suggest = "personal_compute_instance_settings"
        elif key == "setupScripts":
            suggest = "setup_scripts"
        elif key == "sshSettings":
            suggest = "ssh_settings"
        elif key == "vmSize":
            suggest = "vm_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComputeInstanceResponseProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComputeInstanceResponseProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComputeInstanceResponseProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 applications: Sequence['outputs.ComputeInstanceApplicationResponse'],
                 connectivity_endpoints: 'outputs.ComputeInstanceConnectivityEndpointsResponse',
                 created_by: 'outputs.ComputeInstanceCreatedByResponse',
                 errors: Sequence['outputs.MachineLearningServiceErrorResponse'],
                 last_operation: 'outputs.ComputeInstanceLastOperationResponse',
                 state: str,
                 application_sharing_policy: Optional[str] = None,
                 compute_instance_authorization_type: Optional[str] = None,
                 personal_compute_instance_settings: Optional['outputs.PersonalComputeInstanceSettingsResponse'] = None,
                 setup_scripts: Optional['outputs.SetupScriptsResponse'] = None,
                 ssh_settings: Optional['outputs.ComputeInstanceSshSettingsResponse'] = None,
                 subnet: Optional['outputs.ResourceIdResponse'] = None,
                 vm_size: Optional[str] = None):
        """
        Compute Instance properties
        :param Sequence['ComputeInstanceApplicationResponse'] applications: Describes available applications and their endpoints on this ComputeInstance.
        :param 'ComputeInstanceConnectivityEndpointsResponse' connectivity_endpoints: Describes all connectivity endpoints available for this ComputeInstance.
        :param 'ComputeInstanceCreatedByResponse' created_by: Describes information on user who created this ComputeInstance.
        :param Sequence['MachineLearningServiceErrorResponse'] errors: Collection of errors encountered on this ComputeInstance.
        :param 'ComputeInstanceLastOperationResponse' last_operation: The last operation on ComputeInstance.
        :param str state: The current state of this ComputeInstance.
        :param str application_sharing_policy: Policy for sharing applications on this compute instance among users of parent workspace. If Personal, only the creator can access applications on this compute instance. When Shared, any workspace user can access applications on this instance depending on his/her assigned role.
        :param str compute_instance_authorization_type: The Compute Instance Authorization type. Available values are personal (default).
        :param 'PersonalComputeInstanceSettingsResponse' personal_compute_instance_settings: Settings for a personal compute instance.
        :param 'SetupScriptsResponse' setup_scripts: Details of customized scripts to execute for setting up the cluster.
        :param 'ComputeInstanceSshSettingsResponse' ssh_settings: Specifies policy and settings for SSH access.
        :param 'ResourceIdResponse' subnet: Virtual network subnet resource ID the compute nodes belong to.
        :param str vm_size: Virtual Machine Size
        """
        pulumi.set(__self__, "applications", applications)
        pulumi.set(__self__, "connectivity_endpoints", connectivity_endpoints)
        pulumi.set(__self__, "created_by", created_by)
        pulumi.set(__self__, "errors", errors)
        pulumi.set(__self__, "last_operation", last_operation)
        pulumi.set(__self__, "state", state)
        if application_sharing_policy is None:
            application_sharing_policy = 'Shared'
        if application_sharing_policy is not None:
            pulumi.set(__self__, "application_sharing_policy", application_sharing_policy)
        if compute_instance_authorization_type is None:
            compute_instance_authorization_type = 'personal'
        if compute_instance_authorization_type is not None:
            pulumi.set(__self__, "compute_instance_authorization_type", compute_instance_authorization_type)
        if personal_compute_instance_settings is not None:
            pulumi.set(__self__, "personal_compute_instance_settings", personal_compute_instance_settings)
        if setup_scripts is not None:
            pulumi.set(__self__, "setup_scripts", setup_scripts)
        if ssh_settings is not None:
            pulumi.set(__self__, "ssh_settings", ssh_settings)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)
        if vm_size is not None:
            pulumi.set(__self__, "vm_size", vm_size)

    @property
    @pulumi.getter
    def applications(self) -> Sequence['outputs.ComputeInstanceApplicationResponse']:
        """
        Describes available applications and their endpoints on this ComputeInstance.
        """
        return pulumi.get(self, "applications")

    @property
    @pulumi.getter(name="connectivityEndpoints")
    def connectivity_endpoints(self) -> 'outputs.ComputeInstanceConnectivityEndpointsResponse':
        """
        Describes all connectivity endpoints available for this ComputeInstance.
        """
        return pulumi.get(self, "connectivity_endpoints")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> 'outputs.ComputeInstanceCreatedByResponse':
        """
        Describes information on user who created this ComputeInstance.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter
    def errors(self) -> Sequence['outputs.MachineLearningServiceErrorResponse']:
        """
        Collection of errors encountered on this ComputeInstance.
        """
        return pulumi.get(self, "errors")

    @property
    @pulumi.getter(name="lastOperation")
    def last_operation(self) -> 'outputs.ComputeInstanceLastOperationResponse':
        """
        The last operation on ComputeInstance.
        """
        return pulumi.get(self, "last_operation")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of this ComputeInstance.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="applicationSharingPolicy")
    def application_sharing_policy(self) -> Optional[str]:
        """
        Policy for sharing applications on this compute instance among users of parent workspace. If Personal, only the creator can access applications on this compute instance. When Shared, any workspace user can access applications on this instance depending on his/her assigned role.
        """
        return pulumi.get(self, "application_sharing_policy")

    @property
    @pulumi.getter(name="computeInstanceAuthorizationType")
    def compute_instance_authorization_type(self) -> Optional[str]:
        """
        The Compute Instance Authorization type. Available values are personal (default).
        """
        return pulumi.get(self, "compute_instance_authorization_type")

    @property
    @pulumi.getter(name="personalComputeInstanceSettings")
    def personal_compute_instance_settings(self) -> Optional['outputs.PersonalComputeInstanceSettingsResponse']:
        """
        Settings for a personal compute instance.
        """
        return pulumi.get(self, "personal_compute_instance_settings")

    @property
    @pulumi.getter(name="setupScripts")
    def setup_scripts(self) -> Optional['outputs.SetupScriptsResponse']:
        """
        Details of customized scripts to execute for setting up the cluster.
        """
        return pulumi.get(self, "setup_scripts")

    @property
    @pulumi.getter(name="sshSettings")
    def ssh_settings(self) -> Optional['outputs.ComputeInstanceSshSettingsResponse']:
        """
        Specifies policy and settings for SSH access.
        """
        return pulumi.get(self, "ssh_settings")

    @property
    @pulumi.getter
    def subnet(self) -> Optional['outputs.ResourceIdResponse']:
        """
        Virtual network subnet resource ID the compute nodes belong to.
        """
        return pulumi.get(self, "subnet")

    @property
    @pulumi.getter(name="vmSize")
    def vm_size(self) -> Optional[str]:
        """
        Virtual Machine Size
        """
        return pulumi.get(self, "vm_size")


@pulumi.output_type
class ComputeInstanceSshSettingsResponse(dict):
    """
    Specifies policy and settings for SSH access.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adminUserName":
            suggest = "admin_user_name"
        elif key == "sshPort":
            suggest = "ssh_port"
        elif key == "adminPublicKey":
            suggest = "admin_public_key"
        elif key == "sshPublicAccess":
            suggest = "ssh_public_access"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComputeInstanceSshSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComputeInstanceSshSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComputeInstanceSshSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 admin_user_name: str,
                 ssh_port: int,
                 admin_public_key: Optional[str] = None,
                 ssh_public_access: Optional[str] = None):
        """
        Specifies policy and settings for SSH access.
        :param str admin_user_name: Describes the admin user name.
        :param int ssh_port: Describes the port for connecting through SSH.
        :param str admin_public_key: Specifies the SSH rsa public key file as a string. Use "ssh-keygen -t rsa -b 2048" to generate your SSH key pairs.
        :param str ssh_public_access: State of the public SSH port. Possible values are: Disabled - Indicates that the public ssh port is closed on this instance. Enabled - Indicates that the public ssh port is open and accessible according to the VNet/subnet policy if applicable.
        """
        pulumi.set(__self__, "admin_user_name", admin_user_name)
        pulumi.set(__self__, "ssh_port", ssh_port)
        if admin_public_key is not None:
            pulumi.set(__self__, "admin_public_key", admin_public_key)
        if ssh_public_access is None:
            ssh_public_access = 'Disabled'
        if ssh_public_access is not None:
            pulumi.set(__self__, "ssh_public_access", ssh_public_access)

    @property
    @pulumi.getter(name="adminUserName")
    def admin_user_name(self) -> str:
        """
        Describes the admin user name.
        """
        return pulumi.get(self, "admin_user_name")

    @property
    @pulumi.getter(name="sshPort")
    def ssh_port(self) -> int:
        """
        Describes the port for connecting through SSH.
        """
        return pulumi.get(self, "ssh_port")

    @property
    @pulumi.getter(name="adminPublicKey")
    def admin_public_key(self) -> Optional[str]:
        """
        Specifies the SSH rsa public key file as a string. Use "ssh-keygen -t rsa -b 2048" to generate your SSH key pairs.
        """
        return pulumi.get(self, "admin_public_key")

    @property
    @pulumi.getter(name="sshPublicAccess")
    def ssh_public_access(self) -> Optional[str]:
        """
        State of the public SSH port. Possible values are: Disabled - Indicates that the public ssh port is closed on this instance. Enabled - Indicates that the public ssh port is open and accessible according to the VNet/subnet policy if applicable.
        """
        return pulumi.get(self, "ssh_public_access")


@pulumi.output_type
class ContainerResourceRequirementsResponse(dict):
    """
    The resource requirements for the container (cpu and memory).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpuLimit":
            suggest = "cpu_limit"
        elif key == "memoryInGB":
            suggest = "memory_in_gb"
        elif key == "memoryInGBLimit":
            suggest = "memory_in_gb_limit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerResourceRequirementsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerResourceRequirementsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerResourceRequirementsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cpu: Optional[float] = None,
                 cpu_limit: Optional[float] = None,
                 fpga: Optional[int] = None,
                 gpu: Optional[int] = None,
                 memory_in_gb: Optional[float] = None,
                 memory_in_gb_limit: Optional[float] = None):
        """
        The resource requirements for the container (cpu and memory).
        :param float cpu: The minimum amount of CPU cores to be used by the container. More info:
               https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
        :param float cpu_limit: The maximum amount of CPU cores allowed to be used by the container. More info:
               https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
        :param int fpga: The number of FPGA PCIE devices exposed to the container. Must be multiple of 2.
        :param int gpu: The number of GPU cores in the container.
        :param float memory_in_gb: The minimum amount of memory (in GB) to be used by the container. More info:
               https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
        :param float memory_in_gb_limit: The maximum amount of memory (in GB) allowed to be used by the container. More info:
               https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
        """
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if cpu_limit is not None:
            pulumi.set(__self__, "cpu_limit", cpu_limit)
        if fpga is not None:
            pulumi.set(__self__, "fpga", fpga)
        if gpu is not None:
            pulumi.set(__self__, "gpu", gpu)
        if memory_in_gb is not None:
            pulumi.set(__self__, "memory_in_gb", memory_in_gb)
        if memory_in_gb_limit is not None:
            pulumi.set(__self__, "memory_in_gb_limit", memory_in_gb_limit)

    @property
    @pulumi.getter
    def cpu(self) -> Optional[float]:
        """
        The minimum amount of CPU cores to be used by the container. More info:
        https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
        """
        return pulumi.get(self, "cpu")

    @property
    @pulumi.getter(name="cpuLimit")
    def cpu_limit(self) -> Optional[float]:
        """
        The maximum amount of CPU cores allowed to be used by the container. More info:
        https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
        """
        return pulumi.get(self, "cpu_limit")

    @property
    @pulumi.getter
    def fpga(self) -> Optional[int]:
        """
        The number of FPGA PCIE devices exposed to the container. Must be multiple of 2.
        """
        return pulumi.get(self, "fpga")

    @property
    @pulumi.getter
    def gpu(self) -> Optional[int]:
        """
        The number of GPU cores in the container.
        """
        return pulumi.get(self, "gpu")

    @property
    @pulumi.getter(name="memoryInGB")
    def memory_in_gb(self) -> Optional[float]:
        """
        The minimum amount of memory (in GB) to be used by the container. More info:
        https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
        """
        return pulumi.get(self, "memory_in_gb")

    @property
    @pulumi.getter(name="memoryInGBLimit")
    def memory_in_gb_limit(self) -> Optional[float]:
        """
        The maximum amount of memory (in GB) allowed to be used by the container. More info:
        https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
        """
        return pulumi.get(self, "memory_in_gb_limit")


@pulumi.output_type
class CosmosDbSettingsResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "collectionsThroughput":
            suggest = "collections_throughput"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CosmosDbSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CosmosDbSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CosmosDbSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 collections_throughput: Optional[int] = None):
        """
        :param int collections_throughput: The throughput of the collections in cosmosdb database
        """
        if collections_throughput is not None:
            pulumi.set(__self__, "collections_throughput", collections_throughput)

    @property
    @pulumi.getter(name="collectionsThroughput")
    def collections_throughput(self) -> Optional[int]:
        """
        The throughput of the collections in cosmosdb database
        """
        return pulumi.get(self, "collections_throughput")


@pulumi.output_type
class DataContainerResponse(dict):
    """
    Container for data asset versions.
    """
    def __init__(__self__, *,
                 description: Optional[str] = None,
                 properties: Optional[Mapping[str, str]] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        Container for data asset versions.
        :param str description: The asset description text.
        :param Mapping[str, str] properties: The asset property dictionary.
        :param Mapping[str, str] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class DataFactoryResponse(dict):
    """
    A DataFactory compute.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computeType":
            suggest = "compute_type"
        elif key == "isAttachedCompute":
            suggest = "is_attached_compute"
        elif key == "provisioningErrors":
            suggest = "provisioning_errors"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "computeLocation":
            suggest = "compute_location"
        elif key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataFactoryResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataFactoryResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataFactoryResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compute_type: str,
                 is_attached_compute: bool,
                 provisioning_errors: Sequence['outputs.MachineLearningServiceErrorResponse'],
                 provisioning_state: str,
                 compute_location: Optional[str] = None,
                 description: Optional[str] = None,
                 resource_id: Optional[str] = None):
        """
        A DataFactory compute.
        :param str compute_type: The type of compute
               Expected value is 'DataFactory'.
        :param bool is_attached_compute: Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
        :param Sequence['MachineLearningServiceErrorResponse'] provisioning_errors: Errors during provisioning
        :param str provisioning_state: The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        :param str compute_location: Location for the underlying compute
        :param str description: The description of the Machine Learning compute.
        :param str resource_id: ARM resource id of the underlying compute
        """
        pulumi.set(__self__, "compute_type", 'DataFactory')
        pulumi.set(__self__, "is_attached_compute", is_attached_compute)
        pulumi.set(__self__, "provisioning_errors", provisioning_errors)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> str:
        """
        The type of compute
        Expected value is 'DataFactory'.
        """
        return pulumi.get(self, "compute_type")

    @property
    @pulumi.getter(name="isAttachedCompute")
    def is_attached_compute(self) -> bool:
        """
        Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
        """
        return pulumi.get(self, "is_attached_compute")

    @property
    @pulumi.getter(name="provisioningErrors")
    def provisioning_errors(self) -> Sequence['outputs.MachineLearningServiceErrorResponse']:
        """
        Errors during provisioning
        """
        return pulumi.get(self, "provisioning_errors")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[str]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        ARM resource id of the underlying compute
        """
        return pulumi.get(self, "resource_id")


@pulumi.output_type
class DataLakeAnalyticsResponse(dict):
    """
    A DataLakeAnalytics compute.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computeType":
            suggest = "compute_type"
        elif key == "isAttachedCompute":
            suggest = "is_attached_compute"
        elif key == "provisioningErrors":
            suggest = "provisioning_errors"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "computeLocation":
            suggest = "compute_location"
        elif key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataLakeAnalyticsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataLakeAnalyticsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataLakeAnalyticsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compute_type: str,
                 is_attached_compute: bool,
                 provisioning_errors: Sequence['outputs.MachineLearningServiceErrorResponse'],
                 provisioning_state: str,
                 compute_location: Optional[str] = None,
                 description: Optional[str] = None,
                 properties: Optional['outputs.DataLakeAnalyticsResponseProperties'] = None,
                 resource_id: Optional[str] = None):
        """
        A DataLakeAnalytics compute.
        :param str compute_type: The type of compute
               Expected value is 'DataLakeAnalytics'.
        :param bool is_attached_compute: Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
        :param Sequence['MachineLearningServiceErrorResponse'] provisioning_errors: Errors during provisioning
        :param str provisioning_state: The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        :param str compute_location: Location for the underlying compute
        :param str description: The description of the Machine Learning compute.
        :param str resource_id: ARM resource id of the underlying compute
        """
        pulumi.set(__self__, "compute_type", 'DataLakeAnalytics')
        pulumi.set(__self__, "is_attached_compute", is_attached_compute)
        pulumi.set(__self__, "provisioning_errors", provisioning_errors)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> str:
        """
        The type of compute
        Expected value is 'DataLakeAnalytics'.
        """
        return pulumi.get(self, "compute_type")

    @property
    @pulumi.getter(name="isAttachedCompute")
    def is_attached_compute(self) -> bool:
        """
        Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
        """
        return pulumi.get(self, "is_attached_compute")

    @property
    @pulumi.getter(name="provisioningErrors")
    def provisioning_errors(self) -> Sequence['outputs.MachineLearningServiceErrorResponse']:
        """
        Errors during provisioning
        """
        return pulumi.get(self, "provisioning_errors")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[str]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.DataLakeAnalyticsResponseProperties']:
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        ARM resource id of the underlying compute
        """
        return pulumi.get(self, "resource_id")


@pulumi.output_type
class DataLakeAnalyticsResponseProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataLakeStoreAccountName":
            suggest = "data_lake_store_account_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataLakeAnalyticsResponseProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataLakeAnalyticsResponseProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataLakeAnalyticsResponseProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_lake_store_account_name: Optional[str] = None):
        """
        :param str data_lake_store_account_name: DataLake Store Account Name
        """
        if data_lake_store_account_name is not None:
            pulumi.set(__self__, "data_lake_store_account_name", data_lake_store_account_name)

    @property
    @pulumi.getter(name="dataLakeStoreAccountName")
    def data_lake_store_account_name(self) -> Optional[str]:
        """
        DataLake Store Account Name
        """
        return pulumi.get(self, "data_lake_store_account_name")


@pulumi.output_type
class DataPathAssetReferenceResponse(dict):
    """
    Reference to an asset via its path in a datastore.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "referenceType":
            suggest = "reference_type"
        elif key == "datastoreId":
            suggest = "datastore_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataPathAssetReferenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataPathAssetReferenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataPathAssetReferenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 reference_type: str,
                 datastore_id: Optional[str] = None,
                 path: Optional[str] = None):
        """
        Reference to an asset via its path in a datastore.
        :param str reference_type: Enum to determine which reference method to use for an asset.
               Expected value is 'DataPath'.
        :param str datastore_id: ARM resource ID of the datastore where the asset is located.
        :param str path: The path of the file/directory in the datastore.
        """
        pulumi.set(__self__, "reference_type", 'DataPath')
        if datastore_id is not None:
            pulumi.set(__self__, "datastore_id", datastore_id)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="referenceType")
    def reference_type(self) -> str:
        """
        Enum to determine which reference method to use for an asset.
        Expected value is 'DataPath'.
        """
        return pulumi.get(self, "reference_type")

    @property
    @pulumi.getter(name="datastoreId")
    def datastore_id(self) -> Optional[str]:
        """
        ARM resource ID of the datastore where the asset is located.
        """
        return pulumi.get(self, "datastore_id")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The path of the file/directory in the datastore.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class DataVersionResponse(dict):
    """
    Data asset version details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datasetType":
            suggest = "dataset_type"
        elif key == "datastoreId":
            suggest = "datastore_id"
        elif key == "isAnonymous":
            suggest = "is_anonymous"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataVersionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataVersionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataVersionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 path: str,
                 dataset_type: Optional[str] = None,
                 datastore_id: Optional[str] = None,
                 description: Optional[str] = None,
                 is_anonymous: Optional[bool] = None,
                 properties: Optional[Mapping[str, str]] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        Data asset version details.
        :param str path: [Required] The path of the file/directory in the datastore.
        :param str dataset_type: The Format of dataset.
        :param str datastore_id: ARM resource ID of the datastore where the asset is located.
        :param str description: The asset description text.
        :param bool is_anonymous: If the name version are system generated (anonymous registration).
        :param Mapping[str, str] properties: The asset property dictionary.
        :param Mapping[str, str] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        pulumi.set(__self__, "path", path)
        if dataset_type is not None:
            pulumi.set(__self__, "dataset_type", dataset_type)
        if datastore_id is not None:
            pulumi.set(__self__, "datastore_id", datastore_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if is_anonymous is not None:
            pulumi.set(__self__, "is_anonymous", is_anonymous)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        [Required] The path of the file/directory in the datastore.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="datasetType")
    def dataset_type(self) -> Optional[str]:
        """
        The Format of dataset.
        """
        return pulumi.get(self, "dataset_type")

    @property
    @pulumi.getter(name="datastoreId")
    def datastore_id(self) -> Optional[str]:
        """
        ARM resource ID of the datastore where the asset is located.
        """
        return pulumi.get(self, "datastore_id")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="isAnonymous")
    def is_anonymous(self) -> Optional[bool]:
        """
        If the name version are system generated (anonymous registration).
        """
        return pulumi.get(self, "is_anonymous")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class DatabricksResponse(dict):
    """
    A DataFactory compute.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computeType":
            suggest = "compute_type"
        elif key == "isAttachedCompute":
            suggest = "is_attached_compute"
        elif key == "provisioningErrors":
            suggest = "provisioning_errors"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "computeLocation":
            suggest = "compute_location"
        elif key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabricksResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabricksResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabricksResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compute_type: str,
                 is_attached_compute: bool,
                 provisioning_errors: Sequence['outputs.MachineLearningServiceErrorResponse'],
                 provisioning_state: str,
                 compute_location: Optional[str] = None,
                 description: Optional[str] = None,
                 properties: Optional['outputs.DatabricksResponseProperties'] = None,
                 resource_id: Optional[str] = None):
        """
        A DataFactory compute.
        :param str compute_type: The type of compute
               Expected value is 'Databricks'.
        :param bool is_attached_compute: Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
        :param Sequence['MachineLearningServiceErrorResponse'] provisioning_errors: Errors during provisioning
        :param str provisioning_state: The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        :param str compute_location: Location for the underlying compute
        :param str description: The description of the Machine Learning compute.
        :param str resource_id: ARM resource id of the underlying compute
        """
        pulumi.set(__self__, "compute_type", 'Databricks')
        pulumi.set(__self__, "is_attached_compute", is_attached_compute)
        pulumi.set(__self__, "provisioning_errors", provisioning_errors)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> str:
        """
        The type of compute
        Expected value is 'Databricks'.
        """
        return pulumi.get(self, "compute_type")

    @property
    @pulumi.getter(name="isAttachedCompute")
    def is_attached_compute(self) -> bool:
        """
        Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
        """
        return pulumi.get(self, "is_attached_compute")

    @property
    @pulumi.getter(name="provisioningErrors")
    def provisioning_errors(self) -> Sequence['outputs.MachineLearningServiceErrorResponse']:
        """
        Errors during provisioning
        """
        return pulumi.get(self, "provisioning_errors")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[str]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.DatabricksResponseProperties']:
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        ARM resource id of the underlying compute
        """
        return pulumi.get(self, "resource_id")


@pulumi.output_type
class DatabricksResponseProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "databricksAccessToken":
            suggest = "databricks_access_token"
        elif key == "workspaceUrl":
            suggest = "workspace_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabricksResponseProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabricksResponseProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabricksResponseProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 databricks_access_token: Optional[str] = None,
                 workspace_url: Optional[str] = None):
        """
        :param str databricks_access_token: Databricks access token
        :param str workspace_url: Workspace Url
        """
        if databricks_access_token is not None:
            pulumi.set(__self__, "databricks_access_token", databricks_access_token)
        if workspace_url is not None:
            pulumi.set(__self__, "workspace_url", workspace_url)

    @property
    @pulumi.getter(name="databricksAccessToken")
    def databricks_access_token(self) -> Optional[str]:
        """
        Databricks access token
        """
        return pulumi.get(self, "databricks_access_token")

    @property
    @pulumi.getter(name="workspaceUrl")
    def workspace_url(self) -> Optional[str]:
        """
        Workspace Url
        """
        return pulumi.get(self, "workspace_url")


@pulumi.output_type
class DatasetReferenceResponse(dict):
    """
    The dataset reference object.
    """
    def __init__(__self__, *,
                 id: Optional[str] = None,
                 name: Optional[str] = None):
        """
        The dataset reference object.
        :param str id: The id of the dataset reference.
        :param str name: The name of the dataset reference.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The id of the dataset reference.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the dataset reference.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class DatasetResponse(dict):
    """
    Machine Learning dataset object.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdTime":
            suggest = "created_time"
        elif key == "datasetId":
            suggest = "dataset_id"
        elif key == "datasetType":
            suggest = "dataset_type"
        elif key == "defaultCompute":
            suggest = "default_compute"
        elif key == "isVisible":
            suggest = "is_visible"
        elif key == "modifiedTime":
            suggest = "modified_time"
        elif key == "datasetState":
            suggest = "dataset_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatasetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatasetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatasetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_time: str,
                 dataset_id: str,
                 dataset_type: str,
                 default_compute: str,
                 description: str,
                 etag: str,
                 is_visible: bool,
                 modified_time: str,
                 name: str,
                 tags: Mapping[str, str],
                 dataset_state: Optional['outputs.DatasetStateResponse'] = None,
                 latest: Optional['outputs.DatasetResponseLatest'] = None):
        """
        Machine Learning dataset object.
        :param str created_time: The dataset creation time (UTC).
        :param str dataset_id: Unique Dataset identifier.
        :param str dataset_type: Dataset Type.
        :param str default_compute: Name of the default compute to be used for any Dataset actions (such as Profile, Write).
        :param str description: Description about this dataset version.
        :param str etag: eTag description
        :param bool is_visible: Flag to hide Dataset in UI
        :param str modified_time: The dataset last modified time (UTC).
        :param str name: Unique dataset name
        :param Mapping[str, str] tags: Tags for this dataset version.
        :param 'DatasetStateResponse' dataset_state: Dataset state
        :param 'DatasetResponseLatest' latest: Last created Dataset definition.
        """
        pulumi.set(__self__, "created_time", created_time)
        pulumi.set(__self__, "dataset_id", dataset_id)
        pulumi.set(__self__, "dataset_type", dataset_type)
        pulumi.set(__self__, "default_compute", default_compute)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "is_visible", is_visible)
        pulumi.set(__self__, "modified_time", modified_time)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "tags", tags)
        if dataset_state is not None:
            pulumi.set(__self__, "dataset_state", dataset_state)
        if latest is not None:
            pulumi.set(__self__, "latest", latest)

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> str:
        """
        The dataset creation time (UTC).
        """
        return pulumi.get(self, "created_time")

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> str:
        """
        Unique Dataset identifier.
        """
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter(name="datasetType")
    def dataset_type(self) -> str:
        """
        Dataset Type.
        """
        return pulumi.get(self, "dataset_type")

    @property
    @pulumi.getter(name="defaultCompute")
    def default_compute(self) -> str:
        """
        Name of the default compute to be used for any Dataset actions (such as Profile, Write).
        """
        return pulumi.get(self, "default_compute")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description about this dataset version.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        eTag description
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="isVisible")
    def is_visible(self) -> bool:
        """
        Flag to hide Dataset in UI
        """
        return pulumi.get(self, "is_visible")

    @property
    @pulumi.getter(name="modifiedTime")
    def modified_time(self) -> str:
        """
        The dataset last modified time (UTC).
        """
        return pulumi.get(self, "modified_time")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Unique dataset name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, str]:
        """
        Tags for this dataset version.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="datasetState")
    def dataset_state(self) -> Optional['outputs.DatasetStateResponse']:
        """
        Dataset state
        """
        return pulumi.get(self, "dataset_state")

    @property
    @pulumi.getter
    def latest(self) -> Optional['outputs.DatasetResponseLatest']:
        """
        Last created Dataset definition.
        """
        return pulumi.get(self, "latest")


@pulumi.output_type
class DatasetResponseDataPath(dict):
    """
     Datastore and reference to location of data such as relativePath, Sql Query and etc.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "azureFilePath":
            suggest = "azure_file_path"
        elif key == "datastoreName":
            suggest = "datastore_name"
        elif key == "httpUrl":
            suggest = "http_url"
        elif key == "partitionFormat":
            suggest = "partition_format"
        elif key == "partitionFormatIgnoreError":
            suggest = "partition_format_ignore_error"
        elif key == "relativePath":
            suggest = "relative_path"
        elif key == "additionalProperties":
            suggest = "additional_properties"
        elif key == "sqlDataPath":
            suggest = "sql_data_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatasetResponseDataPath. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatasetResponseDataPath.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatasetResponseDataPath.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 azure_file_path: str,
                 datastore_name: str,
                 http_url: str,
                 partition_format: str,
                 partition_format_ignore_error: bool,
                 paths: Sequence[str],
                 relative_path: str,
                 additional_properties: Optional[Mapping[str, Any]] = None,
                 sql_data_path: Optional['outputs.DatasetResponseSqlDataPath'] = None):
        """
         Datastore and reference to location of data such as relativePath, Sql Query and etc.
        :param str azure_file_path: Azure path for Azure Blob or File
        :param str datastore_name: Data store Name
        :param str http_url: HTTP URL.
        :param str partition_format: Specify the partition format of path. Defaults to None.
        :param bool partition_format_ignore_error: Whether or not to ignore unmatched path.
        :param Sequence[str] paths: List of files expanded from a file GLOB specified
        :param str relative_path: Relative path in the data store
        :param Mapping[str, Any] additional_properties: Additional Properties.
        :param 'DatasetResponseSqlDataPath' sql_data_path: Sql Query/Table/Stored Procedure details.
        """
        pulumi.set(__self__, "azure_file_path", azure_file_path)
        pulumi.set(__self__, "datastore_name", datastore_name)
        pulumi.set(__self__, "http_url", http_url)
        pulumi.set(__self__, "partition_format", partition_format)
        pulumi.set(__self__, "partition_format_ignore_error", partition_format_ignore_error)
        pulumi.set(__self__, "paths", paths)
        pulumi.set(__self__, "relative_path", relative_path)
        if additional_properties is not None:
            pulumi.set(__self__, "additional_properties", additional_properties)
        if sql_data_path is not None:
            pulumi.set(__self__, "sql_data_path", sql_data_path)

    @property
    @pulumi.getter(name="azureFilePath")
    def azure_file_path(self) -> str:
        """
        Azure path for Azure Blob or File
        """
        return pulumi.get(self, "azure_file_path")

    @property
    @pulumi.getter(name="datastoreName")
    def datastore_name(self) -> str:
        """
        Data store Name
        """
        return pulumi.get(self, "datastore_name")

    @property
    @pulumi.getter(name="httpUrl")
    def http_url(self) -> str:
        """
        HTTP URL.
        """
        return pulumi.get(self, "http_url")

    @property
    @pulumi.getter(name="partitionFormat")
    def partition_format(self) -> str:
        """
        Specify the partition format of path. Defaults to None.
        """
        return pulumi.get(self, "partition_format")

    @property
    @pulumi.getter(name="partitionFormatIgnoreError")
    def partition_format_ignore_error(self) -> bool:
        """
        Whether or not to ignore unmatched path.
        """
        return pulumi.get(self, "partition_format_ignore_error")

    @property
    @pulumi.getter
    def paths(self) -> Sequence[str]:
        """
        List of files expanded from a file GLOB specified
        """
        return pulumi.get(self, "paths")

    @property
    @pulumi.getter(name="relativePath")
    def relative_path(self) -> str:
        """
        Relative path in the data store
        """
        return pulumi.get(self, "relative_path")

    @property
    @pulumi.getter(name="additionalProperties")
    def additional_properties(self) -> Optional[Mapping[str, Any]]:
        """
        Additional Properties.
        """
        return pulumi.get(self, "additional_properties")

    @property
    @pulumi.getter(name="sqlDataPath")
    def sql_data_path(self) -> Optional['outputs.DatasetResponseSqlDataPath']:
        """
        Sql Query/Table/Stored Procedure details.
        """
        return pulumi.get(self, "sql_data_path")


@pulumi.output_type
class DatasetResponseLatest(dict):
    """
    Last created Dataset definition.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdTime":
            suggest = "created_time"
        elif key == "datasetId":
            suggest = "dataset_id"
        elif key == "fileType":
            suggest = "file_type"
        elif key == "modifiedTime":
            suggest = "modified_time"
        elif key == "partitionFormatInPath":
            suggest = "partition_format_in_path"
        elif key == "savedDatasetId":
            suggest = "saved_dataset_id"
        elif key == "telemetryInfo":
            suggest = "telemetry_info"
        elif key == "useDescriptionTagsFromDefinition":
            suggest = "use_description_tags_from_definition"
        elif key == "versionId":
            suggest = "version_id"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "dataPath":
            suggest = "data_path"
        elif key == "datasetDefinitionState":
            suggest = "dataset_definition_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatasetResponseLatest. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatasetResponseLatest.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatasetResponseLatest.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_time: str,
                 dataflow: str,
                 dataset_id: str,
                 description: str,
                 etag: str,
                 file_type: str,
                 modified_time: str,
                 notes: str,
                 partition_format_in_path: bool,
                 saved_dataset_id: str,
                 tags: Mapping[str, str],
                 telemetry_info: Mapping[str, str],
                 use_description_tags_from_definition: bool,
                 version_id: str,
                 created_by: Optional['outputs.UserInfoResponse'] = None,
                 data_path: Optional['outputs.DatasetResponseDataPath'] = None,
                 dataset_definition_state: Optional['outputs.DatasetStateResponse'] = None,
                 properties: Optional[Mapping[str, Any]] = None):
        """
        Last created Dataset definition.
        :param str created_time: The dataset creation time (UTC).
        :param str dataflow: Dataflow Json
        :param str dataset_id: Unique Dataset identifier.
        :param str description: Description about the dataset.
        :param str etag: eTag description
        :param str file_type: Dataset FileType, specified by user.
        :param str modified_time: The dataset last modified time (UTC).
        :param str notes: Summary of Definition changes.
        :param bool partition_format_in_path: Indicates how the source data is partitioned. This is defined to filter on a range of partitioned data before performing actions or materialization.
        :param str saved_dataset_id: Indicates the saved dataset this definition is mapping to, populated on Get.
        :param Mapping[str, str] tags: Tags associated with the dataset.
        :param Mapping[str, str] telemetry_info:  Telemetry information about the dataset including information like which service the dataset was created from.
        :param bool use_description_tags_from_definition:  Whether to use description and tags from the definition level as opposed to dataset level (old behavior).
        :param str version_id: An identifier uniquely identifies a definition change.
        :param 'UserInfoResponse' created_by: User who created.
        :param 'DatasetResponseDataPath' data_path:  Datastore and reference to location of data such as relativePath, Sql Query and etc.
        :param 'DatasetStateResponse' dataset_definition_state: Dataset state
        :param Mapping[str, Any] properties: Properties stores information like name of time series column for time series dataset.
        """
        pulumi.set(__self__, "created_time", created_time)
        pulumi.set(__self__, "dataflow", dataflow)
        pulumi.set(__self__, "dataset_id", dataset_id)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "file_type", file_type)
        pulumi.set(__self__, "modified_time", modified_time)
        pulumi.set(__self__, "notes", notes)
        pulumi.set(__self__, "partition_format_in_path", partition_format_in_path)
        pulumi.set(__self__, "saved_dataset_id", saved_dataset_id)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "telemetry_info", telemetry_info)
        pulumi.set(__self__, "use_description_tags_from_definition", use_description_tags_from_definition)
        pulumi.set(__self__, "version_id", version_id)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if data_path is not None:
            pulumi.set(__self__, "data_path", data_path)
        if dataset_definition_state is not None:
            pulumi.set(__self__, "dataset_definition_state", dataset_definition_state)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> str:
        """
        The dataset creation time (UTC).
        """
        return pulumi.get(self, "created_time")

    @property
    @pulumi.getter
    def dataflow(self) -> str:
        """
        Dataflow Json
        """
        return pulumi.get(self, "dataflow")

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> str:
        """
        Unique Dataset identifier.
        """
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description about the dataset.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        eTag description
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="fileType")
    def file_type(self) -> str:
        """
        Dataset FileType, specified by user.
        """
        return pulumi.get(self, "file_type")

    @property
    @pulumi.getter(name="modifiedTime")
    def modified_time(self) -> str:
        """
        The dataset last modified time (UTC).
        """
        return pulumi.get(self, "modified_time")

    @property
    @pulumi.getter
    def notes(self) -> str:
        """
        Summary of Definition changes.
        """
        return pulumi.get(self, "notes")

    @property
    @pulumi.getter(name="partitionFormatInPath")
    def partition_format_in_path(self) -> bool:
        """
        Indicates how the source data is partitioned. This is defined to filter on a range of partitioned data before performing actions or materialization.
        """
        return pulumi.get(self, "partition_format_in_path")

    @property
    @pulumi.getter(name="savedDatasetId")
    def saved_dataset_id(self) -> str:
        """
        Indicates the saved dataset this definition is mapping to, populated on Get.
        """
        return pulumi.get(self, "saved_dataset_id")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, str]:
        """
        Tags associated with the dataset.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="telemetryInfo")
    def telemetry_info(self) -> Mapping[str, str]:
        """
         Telemetry information about the dataset including information like which service the dataset was created from.
        """
        return pulumi.get(self, "telemetry_info")

    @property
    @pulumi.getter(name="useDescriptionTagsFromDefinition")
    def use_description_tags_from_definition(self) -> bool:
        """
         Whether to use description and tags from the definition level as opposed to dataset level (old behavior).
        """
        return pulumi.get(self, "use_description_tags_from_definition")

    @property
    @pulumi.getter(name="versionId")
    def version_id(self) -> str:
        """
        An identifier uniquely identifies a definition change.
        """
        return pulumi.get(self, "version_id")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional['outputs.UserInfoResponse']:
        """
        User who created.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="dataPath")
    def data_path(self) -> Optional['outputs.DatasetResponseDataPath']:
        """
         Datastore and reference to location of data such as relativePath, Sql Query and etc.
        """
        return pulumi.get(self, "data_path")

    @property
    @pulumi.getter(name="datasetDefinitionState")
    def dataset_definition_state(self) -> Optional['outputs.DatasetStateResponse']:
        """
        Dataset state
        """
        return pulumi.get(self, "dataset_definition_state")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, Any]]:
        """
        Properties stores information like name of time series column for time series dataset.
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class DatasetResponseSqlDataPath(dict):
    """
    Sql Query/Table/Stored Procedure details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queryTimeout":
            suggest = "query_timeout"
        elif key == "sqlQuery":
            suggest = "sql_query"
        elif key == "sqlStoredProcedureName":
            suggest = "sql_stored_procedure_name"
        elif key == "sqlTableName":
            suggest = "sql_table_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatasetResponseSqlDataPath. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatasetResponseSqlDataPath.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatasetResponseSqlDataPath.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 query_timeout: float,
                 sql_query: str,
                 sql_stored_procedure_name: str,
                 sql_table_name: str):
        """
        Sql Query/Table/Stored Procedure details.
        :param float query_timeout: SQL query timeout. Unit in seconds.
        :param str sql_query: SQL query
        :param str sql_stored_procedure_name: SQL storedProcedure name
        :param str sql_table_name: SQL table name
        """
        pulumi.set(__self__, "query_timeout", query_timeout)
        pulumi.set(__self__, "sql_query", sql_query)
        pulumi.set(__self__, "sql_stored_procedure_name", sql_stored_procedure_name)
        pulumi.set(__self__, "sql_table_name", sql_table_name)

    @property
    @pulumi.getter(name="queryTimeout")
    def query_timeout(self) -> float:
        """
        SQL query timeout. Unit in seconds.
        """
        return pulumi.get(self, "query_timeout")

    @property
    @pulumi.getter(name="sqlQuery")
    def sql_query(self) -> str:
        """
        SQL query
        """
        return pulumi.get(self, "sql_query")

    @property
    @pulumi.getter(name="sqlStoredProcedureName")
    def sql_stored_procedure_name(self) -> str:
        """
        SQL storedProcedure name
        """
        return pulumi.get(self, "sql_stored_procedure_name")

    @property
    @pulumi.getter(name="sqlTableName")
    def sql_table_name(self) -> str:
        """
        SQL table name
        """
        return pulumi.get(self, "sql_table_name")


@pulumi.output_type
class DatasetStateResponse(dict):
    """
    Dataset state
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deprecatedBy":
            suggest = "deprecated_by"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatasetStateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatasetStateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatasetStateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 deprecated_by: Optional['outputs.DatasetStateResponseDeprecatedBy'] = None,
                 state: Optional[str] = None):
        """
        Dataset state
        :param str etag: eTag description
        :param 'DatasetStateResponseDeprecatedBy' deprecated_by: Reference to better Dataset or a Definition
        :param str state: Dataset state
        """
        pulumi.set(__self__, "etag", etag)
        if deprecated_by is not None:
            pulumi.set(__self__, "deprecated_by", deprecated_by)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        eTag description
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="deprecatedBy")
    def deprecated_by(self) -> Optional['outputs.DatasetStateResponseDeprecatedBy']:
        """
        Reference to better Dataset or a Definition
        """
        return pulumi.get(self, "deprecated_by")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        Dataset state
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class DatasetStateResponseDeprecatedBy(dict):
    """
    Reference to better Dataset or a Definition
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datasetId":
            suggest = "dataset_id"
        elif key == "definitionVersion":
            suggest = "definition_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatasetStateResponseDeprecatedBy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatasetStateResponseDeprecatedBy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatasetStateResponseDeprecatedBy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataset_id: str,
                 definition_version: Optional[str] = None):
        """
        Reference to better Dataset or a Definition
        :param str dataset_id: Unique Dataset identifier.
        :param str definition_version: Definition Version
        """
        pulumi.set(__self__, "dataset_id", dataset_id)
        if definition_version is not None:
            pulumi.set(__self__, "definition_version", definition_version)

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> str:
        """
        Unique Dataset identifier.
        """
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter(name="definitionVersion")
    def definition_version(self) -> Optional[str]:
        """
        Definition Version
        """
        return pulumi.get(self, "definition_version")


@pulumi.output_type
class DatastoreResponse(dict):
    """
    Machine Learning datastore object.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdBy":
            suggest = "created_by"
        elif key == "createdTime":
            suggest = "created_time"
        elif key == "modifiedBy":
            suggest = "modified_by"
        elif key == "modifiedTime":
            suggest = "modified_time"
        elif key == "azureDataLakeSection":
            suggest = "azure_data_lake_section"
        elif key == "azureMySqlSection":
            suggest = "azure_my_sql_section"
        elif key == "azurePostgreSqlSection":
            suggest = "azure_postgre_sql_section"
        elif key == "azureSqlDatabaseSection":
            suggest = "azure_sql_database_section"
        elif key == "azureStorageSection":
            suggest = "azure_storage_section"
        elif key == "dataStoreType":
            suggest = "data_store_type"
        elif key == "glusterFsSection":
            suggest = "gluster_fs_section"
        elif key == "hasBeenValidated":
            suggest = "has_been_validated"
        elif key == "linkedInfo":
            suggest = "linked_info"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatastoreResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatastoreResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatastoreResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_by: 'outputs.UserInfoResponse',
                 created_time: str,
                 modified_by: 'outputs.UserInfoResponse',
                 modified_time: str,
                 tags: Mapping[str, str],
                 azure_data_lake_section: Optional['outputs.AzureDataLakeSectionResponse'] = None,
                 azure_my_sql_section: Optional['outputs.AzureMySqlSectionResponse'] = None,
                 azure_postgre_sql_section: Optional['outputs.AzurePostgreSqlSectionResponse'] = None,
                 azure_sql_database_section: Optional['outputs.AzureSqlDatabaseSectionResponse'] = None,
                 azure_storage_section: Optional['outputs.AzureStorageSectionResponse'] = None,
                 data_store_type: Optional[str] = None,
                 description: Optional[str] = None,
                 gluster_fs_section: Optional['outputs.GlusterFsSectionResponse'] = None,
                 has_been_validated: Optional[bool] = None,
                 linked_info: Optional['outputs.LinkedInfoResponse'] = None,
                 name: Optional[str] = None):
        """
        Machine Learning datastore object.
        :param 'UserInfoResponse' created_by: The User who created the datastore.
        :param str created_time: The date and time when the datastore was created.
        :param 'UserInfoResponse' modified_by: The User who modified the datastore.
        :param str modified_time: The date and time when the datastore was last modified.
        :param Mapping[str, str] tags: Tags for this datastore.
        :param str data_store_type: The datastore type.
        :param str description: Description of the datastore.
        :param 'GlusterFsSectionResponse' gluster_fs_section: Data specific to GlusterFS.
        :param bool has_been_validated: A read only property that denotes whether the service datastore has been validated with credentials.
        :param 'LinkedInfoResponse' linked_info: Info about origin if it is linked.
        :param str name: Name of the datastore.
        """
        pulumi.set(__self__, "created_by", created_by)
        pulumi.set(__self__, "created_time", created_time)
        pulumi.set(__self__, "modified_by", modified_by)
        pulumi.set(__self__, "modified_time", modified_time)
        pulumi.set(__self__, "tags", tags)
        if azure_data_lake_section is not None:
            pulumi.set(__self__, "azure_data_lake_section", azure_data_lake_section)
        if azure_my_sql_section is not None:
            pulumi.set(__self__, "azure_my_sql_section", azure_my_sql_section)
        if azure_postgre_sql_section is not None:
            pulumi.set(__self__, "azure_postgre_sql_section", azure_postgre_sql_section)
        if azure_sql_database_section is not None:
            pulumi.set(__self__, "azure_sql_database_section", azure_sql_database_section)
        if azure_storage_section is not None:
            pulumi.set(__self__, "azure_storage_section", azure_storage_section)
        if data_store_type is not None:
            pulumi.set(__self__, "data_store_type", data_store_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if gluster_fs_section is not None:
            pulumi.set(__self__, "gluster_fs_section", gluster_fs_section)
        if has_been_validated is None:
            has_been_validated = False
        if has_been_validated is not None:
            pulumi.set(__self__, "has_been_validated", has_been_validated)
        if linked_info is not None:
            pulumi.set(__self__, "linked_info", linked_info)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> 'outputs.UserInfoResponse':
        """
        The User who created the datastore.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> str:
        """
        The date and time when the datastore was created.
        """
        return pulumi.get(self, "created_time")

    @property
    @pulumi.getter(name="modifiedBy")
    def modified_by(self) -> 'outputs.UserInfoResponse':
        """
        The User who modified the datastore.
        """
        return pulumi.get(self, "modified_by")

    @property
    @pulumi.getter(name="modifiedTime")
    def modified_time(self) -> str:
        """
        The date and time when the datastore was last modified.
        """
        return pulumi.get(self, "modified_time")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, str]:
        """
        Tags for this datastore.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="azureDataLakeSection")
    def azure_data_lake_section(self) -> Optional['outputs.AzureDataLakeSectionResponse']:
        return pulumi.get(self, "azure_data_lake_section")

    @property
    @pulumi.getter(name="azureMySqlSection")
    def azure_my_sql_section(self) -> Optional['outputs.AzureMySqlSectionResponse']:
        return pulumi.get(self, "azure_my_sql_section")

    @property
    @pulumi.getter(name="azurePostgreSqlSection")
    def azure_postgre_sql_section(self) -> Optional['outputs.AzurePostgreSqlSectionResponse']:
        return pulumi.get(self, "azure_postgre_sql_section")

    @property
    @pulumi.getter(name="azureSqlDatabaseSection")
    def azure_sql_database_section(self) -> Optional['outputs.AzureSqlDatabaseSectionResponse']:
        return pulumi.get(self, "azure_sql_database_section")

    @property
    @pulumi.getter(name="azureStorageSection")
    def azure_storage_section(self) -> Optional['outputs.AzureStorageSectionResponse']:
        return pulumi.get(self, "azure_storage_section")

    @property
    @pulumi.getter(name="dataStoreType")
    def data_store_type(self) -> Optional[str]:
        """
        The datastore type.
        """
        return pulumi.get(self, "data_store_type")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of the datastore.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="glusterFsSection")
    def gluster_fs_section(self) -> Optional['outputs.GlusterFsSectionResponse']:
        """
        Data specific to GlusterFS.
        """
        return pulumi.get(self, "gluster_fs_section")

    @property
    @pulumi.getter(name="hasBeenValidated")
    def has_been_validated(self) -> Optional[bool]:
        """
        A read only property that denotes whether the service datastore has been validated with credentials.
        """
        return pulumi.get(self, "has_been_validated")

    @property
    @pulumi.getter(name="linkedInfo")
    def linked_info(self) -> Optional['outputs.LinkedInfoResponse']:
        """
        Info about origin if it is linked.
        """
        return pulumi.get(self, "linked_info")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the datastore.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class DockerBuildResponse(dict):
    """
    Class to represent configuration settings for Docker Build
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dockerSpecificationType":
            suggest = "docker_specification_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DockerBuildResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DockerBuildResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DockerBuildResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 docker_specification_type: str,
                 dockerfile: str,
                 context: Optional[str] = None,
                 platform: Optional['outputs.DockerImagePlatformResponse'] = None):
        """
        Class to represent configuration settings for Docker Build
        :param str docker_specification_type: Enum to determine docker specification type. Must be either Build or Image.
               Expected value is 'Build'.
        :param str dockerfile: [Required] Docker command line instructions to assemble an image.
               <seealso href="https://repo2docker.readthedocs.io/en/latest/config_files.html#dockerfile-advanced-environments" />
        :param str context: Path to a snapshot of the Docker Context. This property is only valid if Dockerfile is specified.
               The path is relative to the asset path which must contain a single Blob URI value.
               <seealso href="https://docs.docker.com/engine/context/working-with-contexts/" />
        :param 'DockerImagePlatformResponse' platform: The platform information of the docker image.
        """
        pulumi.set(__self__, "docker_specification_type", 'Build')
        pulumi.set(__self__, "dockerfile", dockerfile)
        if context is not None:
            pulumi.set(__self__, "context", context)
        if platform is not None:
            pulumi.set(__self__, "platform", platform)

    @property
    @pulumi.getter(name="dockerSpecificationType")
    def docker_specification_type(self) -> str:
        """
        Enum to determine docker specification type. Must be either Build or Image.
        Expected value is 'Build'.
        """
        return pulumi.get(self, "docker_specification_type")

    @property
    @pulumi.getter
    def dockerfile(self) -> str:
        """
        [Required] Docker command line instructions to assemble an image.
        <seealso href="https://repo2docker.readthedocs.io/en/latest/config_files.html#dockerfile-advanced-environments" />
        """
        return pulumi.get(self, "dockerfile")

    @property
    @pulumi.getter
    def context(self) -> Optional[str]:
        """
        Path to a snapshot of the Docker Context. This property is only valid if Dockerfile is specified.
        The path is relative to the asset path which must contain a single Blob URI value.
        <seealso href="https://docs.docker.com/engine/context/working-with-contexts/" />
        """
        return pulumi.get(self, "context")

    @property
    @pulumi.getter
    def platform(self) -> Optional['outputs.DockerImagePlatformResponse']:
        """
        The platform information of the docker image.
        """
        return pulumi.get(self, "platform")


@pulumi.output_type
class DockerImagePlatformResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "operatingSystemType":
            suggest = "operating_system_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DockerImagePlatformResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DockerImagePlatformResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DockerImagePlatformResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operating_system_type: Optional[str] = None):
        """
        :param str operating_system_type: The OS type the Environment.
        """
        if operating_system_type is not None:
            pulumi.set(__self__, "operating_system_type", operating_system_type)

    @property
    @pulumi.getter(name="operatingSystemType")
    def operating_system_type(self) -> Optional[str]:
        """
        The OS type the Environment.
        """
        return pulumi.get(self, "operating_system_type")


@pulumi.output_type
class DockerImageResponse(dict):
    """
    Class to represent configuration settings for Docker Build
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dockerImageUri":
            suggest = "docker_image_uri"
        elif key == "dockerSpecificationType":
            suggest = "docker_specification_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DockerImageResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DockerImageResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DockerImageResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 docker_image_uri: str,
                 docker_specification_type: str,
                 platform: Optional['outputs.DockerImagePlatformResponse'] = None):
        """
        Class to represent configuration settings for Docker Build
        :param str docker_image_uri: [Required] Image name of a custom base image.
               <seealso href="https://docs.microsoft.com/en-us/azure/machine-learning/how-to-deploy-custom-docker-image#use-a-custom-base-image" />
        :param str docker_specification_type: Enum to determine docker specification type. Must be either Build or Image.
               Expected value is 'Image'.
        :param 'DockerImagePlatformResponse' platform: The platform information of the docker image.
        """
        pulumi.set(__self__, "docker_image_uri", docker_image_uri)
        pulumi.set(__self__, "docker_specification_type", 'Image')
        if platform is not None:
            pulumi.set(__self__, "platform", platform)

    @property
    @pulumi.getter(name="dockerImageUri")
    def docker_image_uri(self) -> str:
        """
        [Required] Image name of a custom base image.
        <seealso href="https://docs.microsoft.com/en-us/azure/machine-learning/how-to-deploy-custom-docker-image#use-a-custom-base-image" />
        """
        return pulumi.get(self, "docker_image_uri")

    @property
    @pulumi.getter(name="dockerSpecificationType")
    def docker_specification_type(self) -> str:
        """
        Enum to determine docker specification type. Must be either Build or Image.
        Expected value is 'Image'.
        """
        return pulumi.get(self, "docker_specification_type")

    @property
    @pulumi.getter
    def platform(self) -> Optional['outputs.DockerImagePlatformResponse']:
        """
        The platform information of the docker image.
        """
        return pulumi.get(self, "platform")


@pulumi.output_type
class EncryptionPropertyResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyVaultProperties":
            suggest = "key_vault_properties"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EncryptionPropertyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EncryptionPropertyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EncryptionPropertyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_vault_properties: 'outputs.KeyVaultPropertiesResponse',
                 status: str,
                 identity: Optional['outputs.IdentityForCmkResponse'] = None):
        """
        :param 'KeyVaultPropertiesResponse' key_vault_properties: Customer Key vault properties.
        :param str status: Indicates whether or not the encryption is enabled for the workspace.
        :param 'IdentityForCmkResponse' identity: The identity that will be used to access the key vault for encryption at rest.
        """
        pulumi.set(__self__, "key_vault_properties", key_vault_properties)
        pulumi.set(__self__, "status", status)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)

    @property
    @pulumi.getter(name="keyVaultProperties")
    def key_vault_properties(self) -> 'outputs.KeyVaultPropertiesResponse':
        """
        Customer Key vault properties.
        """
        return pulumi.get(self, "key_vault_properties")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Indicates whether or not the encryption is enabled for the workspace.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def identity(self) -> Optional['outputs.IdentityForCmkResponse']:
        """
        The identity that will be used to access the key vault for encryption at rest.
        """
        return pulumi.get(self, "identity")


@pulumi.output_type
class EnvironmentContainerResponse(dict):
    """
    Container for environment specification versions.
    """
    def __init__(__self__, *,
                 description: Optional[str] = None,
                 properties: Optional[Mapping[str, str]] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        Container for environment specification versions.
        :param str description: The asset description text.
        :param Mapping[str, str] properties: The asset property dictionary.
        :param Mapping[str, str] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class EnvironmentImageResponseResponseEnvironment(dict):
    """
    The details of the AZURE ML environment.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "environmentVariables":
            suggest = "environment_variables"
        elif key == "inferencingStackVersion":
            suggest = "inferencing_stack_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvironmentImageResponseResponseEnvironment. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvironmentImageResponseResponseEnvironment.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvironmentImageResponseResponseEnvironment.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 docker: Optional['outputs.ModelEnvironmentDefinitionResponseResponseDocker'] = None,
                 environment_variables: Optional[Mapping[str, str]] = None,
                 inferencing_stack_version: Optional[str] = None,
                 name: Optional[str] = None,
                 python: Optional['outputs.ModelEnvironmentDefinitionResponseResponsePython'] = None,
                 r: Optional['outputs.ModelEnvironmentDefinitionResponseResponseR'] = None,
                 spark: Optional['outputs.ModelEnvironmentDefinitionResponseResponseSpark'] = None,
                 version: Optional[str] = None):
        """
        The details of the AZURE ML environment.
        :param 'ModelEnvironmentDefinitionResponseResponseDocker' docker: The definition of a Docker container.
        :param Mapping[str, str] environment_variables: Definition of environment variables to be defined in the environment.
        :param str inferencing_stack_version: The inferencing stack version added to the image. To avoid adding an inferencing stack, do not set this value. Valid values: "latest".
        :param str name: The name of the environment.
        :param 'ModelEnvironmentDefinitionResponseResponsePython' python: Settings for a Python environment.
        :param 'ModelEnvironmentDefinitionResponseResponseR' r: Settings for a R environment.
        :param 'ModelEnvironmentDefinitionResponseResponseSpark' spark: The configuration for a Spark environment.
        :param str version: The environment version.
        """
        if docker is not None:
            pulumi.set(__self__, "docker", docker)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if inferencing_stack_version is not None:
            pulumi.set(__self__, "inferencing_stack_version", inferencing_stack_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if python is not None:
            pulumi.set(__self__, "python", python)
        if r is not None:
            pulumi.set(__self__, "r", r)
        if spark is not None:
            pulumi.set(__self__, "spark", spark)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def docker(self) -> Optional['outputs.ModelEnvironmentDefinitionResponseResponseDocker']:
        """
        The definition of a Docker container.
        """
        return pulumi.get(self, "docker")

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[Mapping[str, str]]:
        """
        Definition of environment variables to be defined in the environment.
        """
        return pulumi.get(self, "environment_variables")

    @property
    @pulumi.getter(name="inferencingStackVersion")
    def inferencing_stack_version(self) -> Optional[str]:
        """
        The inferencing stack version added to the image. To avoid adding an inferencing stack, do not set this value. Valid values: "latest".
        """
        return pulumi.get(self, "inferencing_stack_version")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the environment.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def python(self) -> Optional['outputs.ModelEnvironmentDefinitionResponseResponsePython']:
        """
        Settings for a Python environment.
        """
        return pulumi.get(self, "python")

    @property
    @pulumi.getter
    def r(self) -> Optional['outputs.ModelEnvironmentDefinitionResponseResponseR']:
        """
        Settings for a R environment.
        """
        return pulumi.get(self, "r")

    @property
    @pulumi.getter
    def spark(self) -> Optional['outputs.ModelEnvironmentDefinitionResponseResponseSpark']:
        """
        The configuration for a Spark environment.
        """
        return pulumi.get(self, "spark")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        The environment version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class EnvironmentImageResponseResponseEnvironmentReference(dict):
    """
    The unique identifying details of the AZURE ML environment.
    """
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 version: Optional[str] = None):
        """
        The unique identifying details of the AZURE ML environment.
        :param str name: Name of the environment.
        :param str version: Version of the environment.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the environment.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        Version of the environment.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class EnvironmentSpecificationVersionResponse(dict):
    """
    Environment specification version details.
    <see href="https://repo2docker.readthedocs.io/en/latest/specification.html" />
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "environmentSpecificationType":
            suggest = "environment_specification_type"
        elif key == "condaFile":
            suggest = "conda_file"
        elif key == "inferenceContainerProperties":
            suggest = "inference_container_properties"
        elif key == "isAnonymous":
            suggest = "is_anonymous"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvironmentSpecificationVersionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvironmentSpecificationVersionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvironmentSpecificationVersionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 environment_specification_type: str,
                 conda_file: Optional[str] = None,
                 description: Optional[str] = None,
                 docker: Optional[Any] = None,
                 inference_container_properties: Optional['outputs.InferenceContainerPropertiesResponse'] = None,
                 is_anonymous: Optional[bool] = None,
                 properties: Optional[Mapping[str, str]] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        Environment specification version details.
        <see href="https://repo2docker.readthedocs.io/en/latest/specification.html" />
        :param str environment_specification_type: Environment specification is either user managed or curated by the Azure ML service
               <see href="https://docs.microsoft.com/en-us/azure/machine-learning/resource-curated-environments" />
        :param str conda_file: Standard configuration file used by Conda that lets you install any kind of package, including Python, R, and C/C++ packages.
               <see href="https://repo2docker.readthedocs.io/en/latest/config_files.html#environment-yml-install-a-conda-environment" />
        :param str description: The asset description text.
        :param Union['DockerBuildResponse', 'DockerImageResponse'] docker: Configuration settings for Docker.
        :param 'InferenceContainerPropertiesResponse' inference_container_properties: Defines configuration specific to inference.
        :param bool is_anonymous: If the name version are system generated (anonymous registration).
        :param Mapping[str, str] properties: The asset property dictionary.
        :param Mapping[str, str] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        pulumi.set(__self__, "environment_specification_type", environment_specification_type)
        if conda_file is not None:
            pulumi.set(__self__, "conda_file", conda_file)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if docker is not None:
            pulumi.set(__self__, "docker", docker)
        if inference_container_properties is not None:
            pulumi.set(__self__, "inference_container_properties", inference_container_properties)
        if is_anonymous is not None:
            pulumi.set(__self__, "is_anonymous", is_anonymous)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="environmentSpecificationType")
    def environment_specification_type(self) -> str:
        """
        Environment specification is either user managed or curated by the Azure ML service
        <see href="https://docs.microsoft.com/en-us/azure/machine-learning/resource-curated-environments" />
        """
        return pulumi.get(self, "environment_specification_type")

    @property
    @pulumi.getter(name="condaFile")
    def conda_file(self) -> Optional[str]:
        """
        Standard configuration file used by Conda that lets you install any kind of package, including Python, R, and C/C++ packages.
        <see href="https://repo2docker.readthedocs.io/en/latest/config_files.html#environment-yml-install-a-conda-environment" />
        """
        return pulumi.get(self, "conda_file")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def docker(self) -> Optional[Any]:
        """
        Configuration settings for Docker.
        """
        return pulumi.get(self, "docker")

    @property
    @pulumi.getter(name="inferenceContainerProperties")
    def inference_container_properties(self) -> Optional['outputs.InferenceContainerPropertiesResponse']:
        """
        Defines configuration specific to inference.
        """
        return pulumi.get(self, "inference_container_properties")

    @property
    @pulumi.getter(name="isAnonymous")
    def is_anonymous(self) -> Optional[bool]:
        """
        If the name version are system generated (anonymous registration).
        """
        return pulumi.get(self, "is_anonymous")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class ErrorDetailResponse(dict):
    """
    Error detail information.
    """
    def __init__(__self__, *,
                 code: str,
                 message: str):
        """
        Error detail information.
        :param str code: Error code.
        :param str message: Error message.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        Error code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Error message.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class ErrorResponseResponse(dict):
    """
    Error response information.
    """
    def __init__(__self__, *,
                 code: str,
                 details: Sequence['outputs.ErrorDetailResponse'],
                 message: str):
        """
        Error response information.
        :param str code: Error code.
        :param Sequence['ErrorDetailResponse'] details: An array of error detail objects.
        :param str message: Error message.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "details", details)
        pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        Error code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def details(self) -> Sequence['outputs.ErrorDetailResponse']:
        """
        An array of error detail objects.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Error message.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class FlavorDataResponse(dict):
    def __init__(__self__, *,
                 data: Optional[Mapping[str, str]] = None):
        """
        :param Mapping[str, str] data: Model flavor-specific data.
        """
        if data is not None:
            pulumi.set(__self__, "data", data)

    @property
    @pulumi.getter
    def data(self) -> Optional[Mapping[str, str]]:
        """
        Model flavor-specific data.
        """
        return pulumi.get(self, "data")


@pulumi.output_type
class GlusterFsSectionResponse(dict):
    """
    Data specific to GlusterFS.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serverAddress":
            suggest = "server_address"
        elif key == "volumeName":
            suggest = "volume_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GlusterFsSectionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GlusterFsSectionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GlusterFsSectionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 server_address: str,
                 volume_name: str):
        """
        Data specific to GlusterFS.
        :param str server_address: The server address of one of the servers that hosts the GlusterFS. Can be either the IP address or server name.
        :param str volume_name: The name of the created GlusterFS volume.
        """
        pulumi.set(__self__, "server_address", server_address)
        pulumi.set(__self__, "volume_name", volume_name)

    @property
    @pulumi.getter(name="serverAddress")
    def server_address(self) -> str:
        """
        The server address of one of the servers that hosts the GlusterFS. Can be either the IP address or server name.
        """
        return pulumi.get(self, "server_address")

    @property
    @pulumi.getter(name="volumeName")
    def volume_name(self) -> str:
        """
        The name of the created GlusterFS volume.
        """
        return pulumi.get(self, "volume_name")


@pulumi.output_type
class HDInsightResponse(dict):
    """
    A HDInsight compute.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computeType":
            suggest = "compute_type"
        elif key == "isAttachedCompute":
            suggest = "is_attached_compute"
        elif key == "provisioningErrors":
            suggest = "provisioning_errors"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "computeLocation":
            suggest = "compute_location"
        elif key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HDInsightResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HDInsightResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HDInsightResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compute_type: str,
                 is_attached_compute: bool,
                 provisioning_errors: Sequence['outputs.MachineLearningServiceErrorResponse'],
                 provisioning_state: str,
                 compute_location: Optional[str] = None,
                 description: Optional[str] = None,
                 properties: Optional['outputs.HDInsightResponseProperties'] = None,
                 resource_id: Optional[str] = None):
        """
        A HDInsight compute.
        :param str compute_type: The type of compute
               Expected value is 'HDInsight'.
        :param bool is_attached_compute: Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
        :param Sequence['MachineLearningServiceErrorResponse'] provisioning_errors: Errors during provisioning
        :param str provisioning_state: The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        :param str compute_location: Location for the underlying compute
        :param str description: The description of the Machine Learning compute.
        :param str resource_id: ARM resource id of the underlying compute
        """
        pulumi.set(__self__, "compute_type", 'HDInsight')
        pulumi.set(__self__, "is_attached_compute", is_attached_compute)
        pulumi.set(__self__, "provisioning_errors", provisioning_errors)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> str:
        """
        The type of compute
        Expected value is 'HDInsight'.
        """
        return pulumi.get(self, "compute_type")

    @property
    @pulumi.getter(name="isAttachedCompute")
    def is_attached_compute(self) -> bool:
        """
        Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
        """
        return pulumi.get(self, "is_attached_compute")

    @property
    @pulumi.getter(name="provisioningErrors")
    def provisioning_errors(self) -> Sequence['outputs.MachineLearningServiceErrorResponse']:
        """
        Errors during provisioning
        """
        return pulumi.get(self, "provisioning_errors")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[str]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.HDInsightResponseProperties']:
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        ARM resource id of the underlying compute
        """
        return pulumi.get(self, "resource_id")


@pulumi.output_type
class HDInsightResponseProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "administratorAccount":
            suggest = "administrator_account"
        elif key == "sshPort":
            suggest = "ssh_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HDInsightResponseProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HDInsightResponseProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HDInsightResponseProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: Optional[str] = None,
                 administrator_account: Optional['outputs.VirtualMachineSshCredentialsResponse'] = None,
                 ssh_port: Optional[int] = None):
        """
        :param str address: Public IP address of the master node of the cluster.
        :param 'VirtualMachineSshCredentialsResponse' administrator_account: Admin credentials for master node of the cluster
        :param int ssh_port: Port open for ssh connections on the master node of the cluster.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if administrator_account is not None:
            pulumi.set(__self__, "administrator_account", administrator_account)
        if ssh_port is not None:
            pulumi.set(__self__, "ssh_port", ssh_port)

    @property
    @pulumi.getter
    def address(self) -> Optional[str]:
        """
        Public IP address of the master node of the cluster.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="administratorAccount")
    def administrator_account(self) -> Optional['outputs.VirtualMachineSshCredentialsResponse']:
        """
        Admin credentials for master node of the cluster
        """
        return pulumi.get(self, "administrator_account")

    @property
    @pulumi.getter(name="sshPort")
    def ssh_port(self) -> Optional[int]:
        """
        Port open for ssh connections on the master node of the cluster.
        """
        return pulumi.get(self, "ssh_port")


@pulumi.output_type
class IdAssetReferenceResponse(dict):
    """
    Reference to an asset via its ARM resource ID.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "assetId":
            suggest = "asset_id"
        elif key == "referenceType":
            suggest = "reference_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdAssetReferenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdAssetReferenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdAssetReferenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 asset_id: str,
                 reference_type: str):
        """
        Reference to an asset via its ARM resource ID.
        :param str asset_id: [Required] ARM resource ID of the asset.
        :param str reference_type: Enum to determine which reference method to use for an asset.
               Expected value is 'Id'.
        """
        pulumi.set(__self__, "asset_id", asset_id)
        pulumi.set(__self__, "reference_type", 'Id')

    @property
    @pulumi.getter(name="assetId")
    def asset_id(self) -> str:
        """
        [Required] ARM resource ID of the asset.
        """
        return pulumi.get(self, "asset_id")

    @property
    @pulumi.getter(name="referenceType")
    def reference_type(self) -> str:
        """
        Enum to determine which reference method to use for an asset.
        Expected value is 'Id'.
        """
        return pulumi.get(self, "reference_type")


@pulumi.output_type
class IdentityForCmkResponse(dict):
    """
    Identity that will be used to access key vault for encryption at rest
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userAssignedIdentity":
            suggest = "user_assigned_identity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdentityForCmkResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdentityForCmkResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdentityForCmkResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 user_assigned_identity: str):
        """
        Identity that will be used to access key vault for encryption at rest
        :param str user_assigned_identity: The ArmId of the user assigned identity that will be used to access the customer managed key vault
        """
        pulumi.set(__self__, "user_assigned_identity", user_assigned_identity)

    @property
    @pulumi.getter(name="userAssignedIdentity")
    def user_assigned_identity(self) -> str:
        """
        The ArmId of the user assigned identity that will be used to access the customer managed key vault
        """
        return pulumi.get(self, "user_assigned_identity")


@pulumi.output_type
class IdentityResponse(dict):
    """
    Identity for the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"
        elif key == "userAssignedIdentities":
            suggest = "user_assigned_identities"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: str,
                 tenant_id: str,
                 type: Optional[str] = None,
                 user_assigned_identities: Optional[Mapping[str, 'outputs.UserAssignedIdentityResponse']] = None):
        """
        Identity for the resource.
        :param str principal_id: The principal ID of resource identity.
        :param str tenant_id: The tenant ID of resource.
        :param str type: The identity type.
        :param Mapping[str, 'UserAssignedIdentityResponse'] user_assigned_identities: The user assigned identities associated with the resource.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal ID of resource identity.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The tenant ID of resource.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The identity type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[Mapping[str, 'outputs.UserAssignedIdentityResponse']]:
        """
        The user assigned identities associated with the resource.
        """
        return pulumi.get(self, "user_assigned_identities")


@pulumi.output_type
class ImageAssetResponse(dict):
    """
    An Image asset.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mimeType":
            suggest = "mime_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageAssetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageAssetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageAssetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: Optional[str] = None,
                 mime_type: Optional[str] = None,
                 unpack: Optional[bool] = None,
                 url: Optional[str] = None):
        """
        An Image asset.
        :param str id: The Asset Id.
        :param str mime_type: The mime type.
        :param bool unpack: Whether the Asset is unpacked.
        :param str url: The Url of the Asset.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if mime_type is not None:
            pulumi.set(__self__, "mime_type", mime_type)
        if unpack is not None:
            pulumi.set(__self__, "unpack", unpack)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The Asset Id.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="mimeType")
    def mime_type(self) -> Optional[str]:
        """
        The mime type.
        """
        return pulumi.get(self, "mime_type")

    @property
    @pulumi.getter
    def unpack(self) -> Optional[bool]:
        """
        Whether the Asset is unpacked.
        """
        return pulumi.get(self, "unpack")

    @property
    @pulumi.getter
    def url(self) -> Optional[str]:
        """
        The Url of the Asset.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class InferenceContainerPropertiesResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "livenessRoute":
            suggest = "liveness_route"
        elif key == "readinessRoute":
            suggest = "readiness_route"
        elif key == "scoringRoute":
            suggest = "scoring_route"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InferenceContainerPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InferenceContainerPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InferenceContainerPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 liveness_route: Optional['outputs.RouteResponse'] = None,
                 readiness_route: Optional['outputs.RouteResponse'] = None,
                 scoring_route: Optional['outputs.RouteResponse'] = None):
        """
        :param 'RouteResponse' liveness_route: The route to check the liveness of the inference server container.
        :param 'RouteResponse' readiness_route: The route to check the readiness of the inference server container.
        :param 'RouteResponse' scoring_route: The port to send the scoring requests to, within the inference server container.
        """
        if liveness_route is not None:
            pulumi.set(__self__, "liveness_route", liveness_route)
        if readiness_route is not None:
            pulumi.set(__self__, "readiness_route", readiness_route)
        if scoring_route is not None:
            pulumi.set(__self__, "scoring_route", scoring_route)

    @property
    @pulumi.getter(name="livenessRoute")
    def liveness_route(self) -> Optional['outputs.RouteResponse']:
        """
        The route to check the liveness of the inference server container.
        """
        return pulumi.get(self, "liveness_route")

    @property
    @pulumi.getter(name="readinessRoute")
    def readiness_route(self) -> Optional['outputs.RouteResponse']:
        """
        The route to check the readiness of the inference server container.
        """
        return pulumi.get(self, "readiness_route")

    @property
    @pulumi.getter(name="scoringRoute")
    def scoring_route(self) -> Optional['outputs.RouteResponse']:
        """
        The port to send the scoring requests to, within the inference server container.
        """
        return pulumi.get(self, "scoring_route")


@pulumi.output_type
class InputDataBindingResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataId":
            suggest = "data_id"
        elif key == "pathOnCompute":
            suggest = "path_on_compute"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InputDataBindingResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InputDataBindingResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InputDataBindingResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_id: Optional[str] = None,
                 mode: Optional[str] = None,
                 path_on_compute: Optional[str] = None):
        """
        :param str data_id: ARM resource ID of the registered dataVersion.
        :param str mode: Mechanism for accessing the data artifact.
        :param str path_on_compute: Location of data inside the container process.
        """
        if data_id is not None:
            pulumi.set(__self__, "data_id", data_id)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if path_on_compute is not None:
            pulumi.set(__self__, "path_on_compute", path_on_compute)

    @property
    @pulumi.getter(name="dataId")
    def data_id(self) -> Optional[str]:
        """
        ARM resource ID of the registered dataVersion.
        """
        return pulumi.get(self, "data_id")

    @property
    @pulumi.getter
    def mode(self) -> Optional[str]:
        """
        Mechanism for accessing the data artifact.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter(name="pathOnCompute")
    def path_on_compute(self) -> Optional[str]:
        """
        Location of data inside the container process.
        """
        return pulumi.get(self, "path_on_compute")


@pulumi.output_type
class JobEndpointResponse(dict):
    """
    Job endpoint definition
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jobEndpointType":
            suggest = "job_endpoint_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobEndpointResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobEndpointResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobEndpointResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint: Optional[str] = None,
                 job_endpoint_type: Optional[str] = None,
                 port: Optional[int] = None,
                 properties: Optional[Mapping[str, str]] = None):
        """
        Job endpoint definition
        :param str endpoint: Url for endpoint.
        :param str job_endpoint_type: Endpoint type.
        :param int port: Port for endpoint.
        :param Mapping[str, str] properties: Additional properties to set on the endpoint.
        """
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if job_endpoint_type is not None:
            pulumi.set(__self__, "job_endpoint_type", job_endpoint_type)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[str]:
        """
        Url for endpoint.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="jobEndpointType")
    def job_endpoint_type(self) -> Optional[str]:
        """
        Endpoint type.
        """
        return pulumi.get(self, "job_endpoint_type")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        Port for endpoint.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        Additional properties to set on the endpoint.
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class JobOutputResponse(dict):
    """
    Job output definition container information on where to find job output/logs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datastoreId":
            suggest = "datastore_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobOutputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobOutputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobOutputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 datastore_id: str,
                 path: str):
        """
        Job output definition container information on where to find job output/logs.
        :param str datastore_id: ARM ID of the datastore where the job logs and artifacts are stored, or null for the default container ("azureml") in the workspace's storage account.
        :param str path: Path within the datastore to the job logs and artifacts.
        """
        pulumi.set(__self__, "datastore_id", datastore_id)
        pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="datastoreId")
    def datastore_id(self) -> str:
        """
        ARM ID of the datastore where the job logs and artifacts are stored, or null for the default container ("azureml") in the workspace's storage account.
        """
        return pulumi.get(self, "datastore_id")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        Path within the datastore to the job logs and artifacts.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class K8sOnlineDeploymentResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointComputeType":
            suggest = "endpoint_compute_type"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "appInsightsEnabled":
            suggest = "app_insights_enabled"
        elif key == "codeConfiguration":
            suggest = "code_configuration"
        elif key == "containerResourceRequirements":
            suggest = "container_resource_requirements"
        elif key == "environmentId":
            suggest = "environment_id"
        elif key == "environmentVariables":
            suggest = "environment_variables"
        elif key == "livenessProbe":
            suggest = "liveness_probe"
        elif key == "requestSettings":
            suggest = "request_settings"
        elif key == "scaleSettings":
            suggest = "scale_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in K8sOnlineDeploymentResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        K8sOnlineDeploymentResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        K8sOnlineDeploymentResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_compute_type: str,
                 provisioning_state: str,
                 app_insights_enabled: Optional[bool] = None,
                 code_configuration: Optional['outputs.CodeConfigurationResponse'] = None,
                 container_resource_requirements: Optional['outputs.ContainerResourceRequirementsResponse'] = None,
                 description: Optional[str] = None,
                 environment_id: Optional[str] = None,
                 environment_variables: Optional[Mapping[str, str]] = None,
                 liveness_probe: Optional['outputs.ProbeSettingsResponse'] = None,
                 model: Optional[Any] = None,
                 properties: Optional[Mapping[str, str]] = None,
                 request_settings: Optional['outputs.OnlineRequestSettingsResponse'] = None,
                 scale_settings: Optional[Any] = None):
        """
        :param str endpoint_compute_type: Enum to determine endpoint compute type.
               Expected value is 'K8S'.
        :param str provisioning_state: Provisioning state for the endpoint deployment.
        :param bool app_insights_enabled: If true, enables Application Insights logging.
        :param 'CodeConfigurationResponse' code_configuration: Code configuration for the endpoint deployment.
        :param 'ContainerResourceRequirementsResponse' container_resource_requirements: Resource requirements for each container instance within an online deployment.
        :param str description: Description of the endpoint deployment.
        :param str environment_id: ARM resource ID of the environment specification for the endpoint deployment.
        :param Mapping[str, str] environment_variables: Environment variables configuration for the deployment.
        :param 'ProbeSettingsResponse' liveness_probe: Deployment container liveness/readiness probe configuration.
        :param Union['DataPathAssetReferenceResponse', 'IdAssetReferenceResponse', 'OutputPathAssetReferenceResponse'] model: Reference to the model asset for the endpoint deployment.
        :param Mapping[str, str] properties: Property dictionary. Properties can be added, but not removed or altered.
        :param 'OnlineRequestSettingsResponse' request_settings: Online deployment scoring requests configuration.
        :param Union['AutoScaleSettingsResponse', 'ManualScaleSettingsResponse'] scale_settings: Online deployment scaling configuration.
        """
        pulumi.set(__self__, "endpoint_compute_type", 'K8S')
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if app_insights_enabled is not None:
            pulumi.set(__self__, "app_insights_enabled", app_insights_enabled)
        if code_configuration is not None:
            pulumi.set(__self__, "code_configuration", code_configuration)
        if container_resource_requirements is not None:
            pulumi.set(__self__, "container_resource_requirements", container_resource_requirements)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if environment_id is not None:
            pulumi.set(__self__, "environment_id", environment_id)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if liveness_probe is not None:
            pulumi.set(__self__, "liveness_probe", liveness_probe)
        if model is not None:
            pulumi.set(__self__, "model", model)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if request_settings is not None:
            pulumi.set(__self__, "request_settings", request_settings)
        if scale_settings is not None:
            pulumi.set(__self__, "scale_settings", scale_settings)

    @property
    @pulumi.getter(name="endpointComputeType")
    def endpoint_compute_type(self) -> str:
        """
        Enum to determine endpoint compute type.
        Expected value is 'K8S'.
        """
        return pulumi.get(self, "endpoint_compute_type")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Provisioning state for the endpoint deployment.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="appInsightsEnabled")
    def app_insights_enabled(self) -> Optional[bool]:
        """
        If true, enables Application Insights logging.
        """
        return pulumi.get(self, "app_insights_enabled")

    @property
    @pulumi.getter(name="codeConfiguration")
    def code_configuration(self) -> Optional['outputs.CodeConfigurationResponse']:
        """
        Code configuration for the endpoint deployment.
        """
        return pulumi.get(self, "code_configuration")

    @property
    @pulumi.getter(name="containerResourceRequirements")
    def container_resource_requirements(self) -> Optional['outputs.ContainerResourceRequirementsResponse']:
        """
        Resource requirements for each container instance within an online deployment.
        """
        return pulumi.get(self, "container_resource_requirements")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of the endpoint deployment.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> Optional[str]:
        """
        ARM resource ID of the environment specification for the endpoint deployment.
        """
        return pulumi.get(self, "environment_id")

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[Mapping[str, str]]:
        """
        Environment variables configuration for the deployment.
        """
        return pulumi.get(self, "environment_variables")

    @property
    @pulumi.getter(name="livenessProbe")
    def liveness_probe(self) -> Optional['outputs.ProbeSettingsResponse']:
        """
        Deployment container liveness/readiness probe configuration.
        """
        return pulumi.get(self, "liveness_probe")

    @property
    @pulumi.getter
    def model(self) -> Optional[Any]:
        """
        Reference to the model asset for the endpoint deployment.
        """
        return pulumi.get(self, "model")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        Property dictionary. Properties can be added, but not removed or altered.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="requestSettings")
    def request_settings(self) -> Optional['outputs.OnlineRequestSettingsResponse']:
        """
        Online deployment scoring requests configuration.
        """
        return pulumi.get(self, "request_settings")

    @property
    @pulumi.getter(name="scaleSettings")
    def scale_settings(self) -> Optional[Any]:
        """
        Online deployment scaling configuration.
        """
        return pulumi.get(self, "scale_settings")


@pulumi.output_type
class KeyVaultPropertiesResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyIdentifier":
            suggest = "key_identifier"
        elif key == "keyVaultArmId":
            suggest = "key_vault_arm_id"
        elif key == "identityClientId":
            suggest = "identity_client_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeyVaultPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeyVaultPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeyVaultPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_identifier: str,
                 key_vault_arm_id: str,
                 identity_client_id: Optional[str] = None):
        """
        :param str key_identifier: Key vault uri to access the encryption key.
        :param str key_vault_arm_id: The ArmId of the keyVault where the customer owned encryption key is present.
        :param str identity_client_id: For future use - The client id of the identity which will be used to access key vault.
        """
        pulumi.set(__self__, "key_identifier", key_identifier)
        pulumi.set(__self__, "key_vault_arm_id", key_vault_arm_id)
        if identity_client_id is not None:
            pulumi.set(__self__, "identity_client_id", identity_client_id)

    @property
    @pulumi.getter(name="keyIdentifier")
    def key_identifier(self) -> str:
        """
        Key vault uri to access the encryption key.
        """
        return pulumi.get(self, "key_identifier")

    @property
    @pulumi.getter(name="keyVaultArmId")
    def key_vault_arm_id(self) -> str:
        """
        The ArmId of the keyVault where the customer owned encryption key is present.
        """
        return pulumi.get(self, "key_vault_arm_id")

    @property
    @pulumi.getter(name="identityClientId")
    def identity_client_id(self) -> Optional[str]:
        """
        For future use - The client id of the identity which will be used to access key vault.
        """
        return pulumi.get(self, "identity_client_id")


@pulumi.output_type
class LabelCategoryResponse(dict):
    """
    Represents a category of labels in a labeling job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowMultiSelect":
            suggest = "allow_multi_select"
        elif key == "displayName":
            suggest = "display_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LabelCategoryResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LabelCategoryResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LabelCategoryResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 classes: Mapping[str, 'outputs.LabelClassResponse'],
                 allow_multi_select: Optional[bool] = None,
                 display_name: Optional[str] = None):
        """
        Represents a category of labels in a labeling job.
        :param Mapping[str, 'LabelClassResponse'] classes: Dictionary of label classes in this category.
        :param bool allow_multi_select: Indicates whether it is allowed to select multiple classes in this category.
        :param str display_name: Display name of the label category.
        """
        pulumi.set(__self__, "classes", classes)
        if allow_multi_select is not None:
            pulumi.set(__self__, "allow_multi_select", allow_multi_select)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)

    @property
    @pulumi.getter
    def classes(self) -> Mapping[str, 'outputs.LabelClassResponse']:
        """
        Dictionary of label classes in this category.
        """
        return pulumi.get(self, "classes")

    @property
    @pulumi.getter(name="allowMultiSelect")
    def allow_multi_select(self) -> Optional[bool]:
        """
        Indicates whether it is allowed to select multiple classes in this category.
        """
        return pulumi.get(self, "allow_multi_select")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        Display name of the label category.
        """
        return pulumi.get(self, "display_name")


@pulumi.output_type
class LabelClassResponse(dict):
    """
    Represents a label or a category of labels in a labeling job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LabelClassResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LabelClassResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LabelClassResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 display_name: Optional[str] = None,
                 subclasses: Optional[Mapping[str, 'outputs.LabelClassResponse']] = None):
        """
        Represents a label or a category of labels in a labeling job.
        :param str display_name: Display name of the label class.
        :param Mapping[str, 'LabelClassResponse'] subclasses: Dictionary of subclasses of the label class.
        """
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if subclasses is not None:
            pulumi.set(__self__, "subclasses", subclasses)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        Display name of the label class.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def subclasses(self) -> Optional[Mapping[str, 'outputs.LabelClassResponse']]:
        """
        Dictionary of subclasses of the label class.
        """
        return pulumi.get(self, "subclasses")


@pulumi.output_type
class LabelingDatasetConfigurationResponse(dict):
    """
    Represents configuration of dataset used in a labeling job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "assetName":
            suggest = "asset_name"
        elif key == "datasetVersion":
            suggest = "dataset_version"
        elif key == "enableIncrementalDatasetRefresh":
            suggest = "enable_incremental_dataset_refresh"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LabelingDatasetConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LabelingDatasetConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LabelingDatasetConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 asset_name: str,
                 dataset_version: str,
                 enable_incremental_dataset_refresh: Optional[bool] = None):
        """
        Represents configuration of dataset used in a labeling job.
        :param str asset_name: Name of the data asset to perform labeling.
        :param str dataset_version: AML dataset version.
        :param bool enable_incremental_dataset_refresh: Indicates whether to enable incremental dataset refresh.
        """
        pulumi.set(__self__, "asset_name", asset_name)
        pulumi.set(__self__, "dataset_version", dataset_version)
        if enable_incremental_dataset_refresh is not None:
            pulumi.set(__self__, "enable_incremental_dataset_refresh", enable_incremental_dataset_refresh)

    @property
    @pulumi.getter(name="assetName")
    def asset_name(self) -> str:
        """
        Name of the data asset to perform labeling.
        """
        return pulumi.get(self, "asset_name")

    @property
    @pulumi.getter(name="datasetVersion")
    def dataset_version(self) -> str:
        """
        AML dataset version.
        """
        return pulumi.get(self, "dataset_version")

    @property
    @pulumi.getter(name="enableIncrementalDatasetRefresh")
    def enable_incremental_dataset_refresh(self) -> Optional[bool]:
        """
        Indicates whether to enable incremental dataset refresh.
        """
        return pulumi.get(self, "enable_incremental_dataset_refresh")


@pulumi.output_type
class LabelingJobImagePropertiesResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mediaType":
            suggest = "media_type"
        elif key == "annotationType":
            suggest = "annotation_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LabelingJobImagePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LabelingJobImagePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LabelingJobImagePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 media_type: str,
                 annotation_type: Optional[str] = None):
        """
        :param str media_type: Media type of data asset.
        :param str annotation_type: Annotation type of image labeling tasks.
        """
        pulumi.set(__self__, "media_type", media_type)
        if annotation_type is not None:
            pulumi.set(__self__, "annotation_type", annotation_type)

    @property
    @pulumi.getter(name="mediaType")
    def media_type(self) -> str:
        """
        Media type of data asset.
        """
        return pulumi.get(self, "media_type")

    @property
    @pulumi.getter(name="annotationType")
    def annotation_type(self) -> Optional[str]:
        """
        Annotation type of image labeling tasks.
        """
        return pulumi.get(self, "annotation_type")


@pulumi.output_type
class LabelingJobInstructionsResponse(dict):
    """
    Instructions for a labeling job.
    """
    def __init__(__self__, *,
                 uri: Optional[str] = None):
        """
        Instructions for a labeling job.
        :param str uri: The link to a page with detailed labeling instructions for labelers.
        """
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def uri(self) -> Optional[str]:
        """
        The link to a page with detailed labeling instructions for labelers.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class LabelingJobPropertiesResponse(dict):
    """
    Definition of a labeling job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdTimeUtc":
            suggest = "created_time_utc"
        elif key == "datasetConfiguration":
            suggest = "dataset_configuration"
        elif key == "jobInstructions":
            suggest = "job_instructions"
        elif key == "labelCategories":
            suggest = "label_categories"
        elif key == "labelingJobMediaProperties":
            suggest = "labeling_job_media_properties"
        elif key == "progressMetrics":
            suggest = "progress_metrics"
        elif key == "projectId":
            suggest = "project_id"
        elif key == "statusMessages":
            suggest = "status_messages"
        elif key == "mlAssistConfiguration":
            suggest = "ml_assist_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LabelingJobPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LabelingJobPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LabelingJobPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_time_utc: str,
                 dataset_configuration: 'outputs.LabelingDatasetConfigurationResponse',
                 job_instructions: 'outputs.LabelingJobInstructionsResponse',
                 label_categories: Mapping[str, 'outputs.LabelCategoryResponse'],
                 labeling_job_media_properties: 'outputs.LabelingJobImagePropertiesResponse',
                 progress_metrics: 'outputs.ProgressMetricsResponse',
                 project_id: str,
                 status: str,
                 status_messages: Sequence['outputs.StatusMessageResponse'],
                 ml_assist_configuration: Optional['outputs.MLAssistConfigurationResponse'] = None,
                 properties: Optional[Mapping[str, str]] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        Definition of a labeling job.
        :param str created_time_utc: Created time of the job in UTC timezone.
        :param 'LabelingDatasetConfigurationResponse' dataset_configuration: Dataset configuration for the job.
        :param 'LabelingJobInstructionsResponse' job_instructions: Instructions for the job.
        :param Mapping[str, 'LabelCategoryResponse'] label_categories: Label categories of the job.
        :param 'LabelingJobImagePropertiesResponse' labeling_job_media_properties: Media specific properties in a labeling job.
        :param 'ProgressMetricsResponse' progress_metrics: Progress metrics of the job.
        :param str project_id: Internal id of the job(Previously called project).
        :param str status: Status of the job.
        :param Sequence['StatusMessageResponse'] status_messages: Status messages of the job.
        :param 'MLAssistConfigurationResponse' ml_assist_configuration: Machine learning assisted configuration for the job.
        :param Mapping[str, str] properties: The job property dictionary. Properties can be added, but not removed or altered.
        :param Mapping[str, str] tags: The job tag dictionary. Tags can be added, removed, and updated.
        """
        pulumi.set(__self__, "created_time_utc", created_time_utc)
        pulumi.set(__self__, "dataset_configuration", dataset_configuration)
        pulumi.set(__self__, "job_instructions", job_instructions)
        pulumi.set(__self__, "label_categories", label_categories)
        pulumi.set(__self__, "labeling_job_media_properties", labeling_job_media_properties)
        pulumi.set(__self__, "progress_metrics", progress_metrics)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "status_messages", status_messages)
        if ml_assist_configuration is not None:
            pulumi.set(__self__, "ml_assist_configuration", ml_assist_configuration)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="createdTimeUtc")
    def created_time_utc(self) -> str:
        """
        Created time of the job in UTC timezone.
        """
        return pulumi.get(self, "created_time_utc")

    @property
    @pulumi.getter(name="datasetConfiguration")
    def dataset_configuration(self) -> 'outputs.LabelingDatasetConfigurationResponse':
        """
        Dataset configuration for the job.
        """
        return pulumi.get(self, "dataset_configuration")

    @property
    @pulumi.getter(name="jobInstructions")
    def job_instructions(self) -> 'outputs.LabelingJobInstructionsResponse':
        """
        Instructions for the job.
        """
        return pulumi.get(self, "job_instructions")

    @property
    @pulumi.getter(name="labelCategories")
    def label_categories(self) -> Mapping[str, 'outputs.LabelCategoryResponse']:
        """
        Label categories of the job.
        """
        return pulumi.get(self, "label_categories")

    @property
    @pulumi.getter(name="labelingJobMediaProperties")
    def labeling_job_media_properties(self) -> 'outputs.LabelingJobImagePropertiesResponse':
        """
        Media specific properties in a labeling job.
        """
        return pulumi.get(self, "labeling_job_media_properties")

    @property
    @pulumi.getter(name="progressMetrics")
    def progress_metrics(self) -> 'outputs.ProgressMetricsResponse':
        """
        Progress metrics of the job.
        """
        return pulumi.get(self, "progress_metrics")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        Internal id of the job(Previously called project).
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of the job.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="statusMessages")
    def status_messages(self) -> Sequence['outputs.StatusMessageResponse']:
        """
        Status messages of the job.
        """
        return pulumi.get(self, "status_messages")

    @property
    @pulumi.getter(name="mlAssistConfiguration")
    def ml_assist_configuration(self) -> Optional['outputs.MLAssistConfigurationResponse']:
        """
        Machine learning assisted configuration for the job.
        """
        return pulumi.get(self, "ml_assist_configuration")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        The job property dictionary. Properties can be added, but not removed or altered.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        The job tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class LinkedInfoResponse(dict):
    """
    Info about origin if it is linked.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "linkedId":
            suggest = "linked_id"
        elif key == "linkedResourceName":
            suggest = "linked_resource_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LinkedInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LinkedInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LinkedInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 linked_id: Optional[str] = None,
                 linked_resource_name: Optional[str] = None,
                 origin: Optional[str] = None):
        """
        Info about origin if it is linked.
        :param str linked_id: LinkedId id.
        :param str linked_resource_name: Linked resource name.
        :param str origin: Datastore origin
        """
        if linked_id is not None:
            pulumi.set(__self__, "linked_id", linked_id)
        if linked_resource_name is not None:
            pulumi.set(__self__, "linked_resource_name", linked_resource_name)
        if origin is not None:
            pulumi.set(__self__, "origin", origin)

    @property
    @pulumi.getter(name="linkedId")
    def linked_id(self) -> Optional[str]:
        """
        LinkedId id.
        """
        return pulumi.get(self, "linked_id")

    @property
    @pulumi.getter(name="linkedResourceName")
    def linked_resource_name(self) -> Optional[str]:
        """
        Linked resource name.
        """
        return pulumi.get(self, "linked_resource_name")

    @property
    @pulumi.getter
    def origin(self) -> Optional[str]:
        """
        Datastore origin
        """
        return pulumi.get(self, "origin")


@pulumi.output_type
class LinkedServicePropsResponse(dict):
    """
    LinkedService specific properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "linkedServiceResourceId":
            suggest = "linked_service_resource_id"
        elif key == "createdTime":
            suggest = "created_time"
        elif key == "linkType":
            suggest = "link_type"
        elif key == "modifiedTime":
            suggest = "modified_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LinkedServicePropsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LinkedServicePropsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LinkedServicePropsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 linked_service_resource_id: str,
                 created_time: Optional[str] = None,
                 link_type: Optional[str] = None,
                 modified_time: Optional[str] = None):
        """
        LinkedService specific properties.
        :param str linked_service_resource_id: ResourceId of the link target of the linked service.
        :param str created_time: The creation time of the linked service.
        :param str link_type: Type of the link target.
        :param str modified_time: The last modified time of the linked service.
        """
        pulumi.set(__self__, "linked_service_resource_id", linked_service_resource_id)
        if created_time is not None:
            pulumi.set(__self__, "created_time", created_time)
        if link_type is not None:
            pulumi.set(__self__, "link_type", link_type)
        if modified_time is not None:
            pulumi.set(__self__, "modified_time", modified_time)

    @property
    @pulumi.getter(name="linkedServiceResourceId")
    def linked_service_resource_id(self) -> str:
        """
        ResourceId of the link target of the linked service.
        """
        return pulumi.get(self, "linked_service_resource_id")

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> Optional[str]:
        """
        The creation time of the linked service.
        """
        return pulumi.get(self, "created_time")

    @property
    @pulumi.getter(name="linkType")
    def link_type(self) -> Optional[str]:
        """
        Type of the link target.
        """
        return pulumi.get(self, "link_type")

    @property
    @pulumi.getter(name="modifiedTime")
    def modified_time(self) -> Optional[str]:
        """
        The last modified time of the linked service.
        """
        return pulumi.get(self, "modified_time")


@pulumi.output_type
class LinkedWorkspacePropsResponse(dict):
    """
    LinkedWorkspace specific properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "linkedWorkspaceResourceId":
            suggest = "linked_workspace_resource_id"
        elif key == "userAssignedIdentityResourceId":
            suggest = "user_assigned_identity_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LinkedWorkspacePropsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LinkedWorkspacePropsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LinkedWorkspacePropsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 linked_workspace_resource_id: Optional[str] = None,
                 user_assigned_identity_resource_id: Optional[str] = None):
        """
        LinkedWorkspace specific properties.
        :param str linked_workspace_resource_id: ResourceId of the link target of the linked workspace.
        :param str user_assigned_identity_resource_id: ResourceId of the user assigned identity for the linked workspace.
        """
        if linked_workspace_resource_id is not None:
            pulumi.set(__self__, "linked_workspace_resource_id", linked_workspace_resource_id)
        if user_assigned_identity_resource_id is not None:
            pulumi.set(__self__, "user_assigned_identity_resource_id", user_assigned_identity_resource_id)

    @property
    @pulumi.getter(name="linkedWorkspaceResourceId")
    def linked_workspace_resource_id(self) -> Optional[str]:
        """
        ResourceId of the link target of the linked workspace.
        """
        return pulumi.get(self, "linked_workspace_resource_id")

    @property
    @pulumi.getter(name="userAssignedIdentityResourceId")
    def user_assigned_identity_resource_id(self) -> Optional[str]:
        """
        ResourceId of the user assigned identity for the linked workspace.
        """
        return pulumi.get(self, "user_assigned_identity_resource_id")


@pulumi.output_type
class ListNotebookKeysResultResponse(dict):
    def __init__(__self__, *,
                 primary_access_key: str,
                 secondary_access_key: str):
        pulumi.set(__self__, "primary_access_key", primary_access_key)
        pulumi.set(__self__, "secondary_access_key", secondary_access_key)

    @property
    @pulumi.getter(name="primaryAccessKey")
    def primary_access_key(self) -> str:
        return pulumi.get(self, "primary_access_key")

    @property
    @pulumi.getter(name="secondaryAccessKey")
    def secondary_access_key(self) -> str:
        return pulumi.get(self, "secondary_access_key")


@pulumi.output_type
class MLAssistConfigurationResponse(dict):
    """
    Represents configuration for machine learning assisted features in a labeling job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inferencingComputeBinding":
            suggest = "inferencing_compute_binding"
        elif key == "modelNamePrefix":
            suggest = "model_name_prefix"
        elif key == "trainingComputeBinding":
            suggest = "training_compute_binding"
        elif key == "mlAssistEnabled":
            suggest = "ml_assist_enabled"
        elif key == "prelabelAccuracyThreshold":
            suggest = "prelabel_accuracy_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MLAssistConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MLAssistConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MLAssistConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 inferencing_compute_binding: 'outputs.ComputeBindingResponse',
                 model_name_prefix: str,
                 training_compute_binding: 'outputs.ComputeBindingResponse',
                 ml_assist_enabled: Optional[bool] = None,
                 prelabel_accuracy_threshold: Optional[float] = None):
        """
        Represents configuration for machine learning assisted features in a labeling job.
        :param 'ComputeBindingResponse' inferencing_compute_binding: The compute designated for inferencing.
        :param str model_name_prefix: Name prefix to use for machine learning model. For each iteration modelName will be appended with iteration e.g.{modelName}_{i}.
        :param 'ComputeBindingResponse' training_compute_binding: The compute designated for training.
        :param bool ml_assist_enabled: Indicates whether MLAssist feature is enabled.
        :param float prelabel_accuracy_threshold: Prelabel accuracy threshold used in MLAssist feature.
        """
        pulumi.set(__self__, "inferencing_compute_binding", inferencing_compute_binding)
        pulumi.set(__self__, "model_name_prefix", model_name_prefix)
        pulumi.set(__self__, "training_compute_binding", training_compute_binding)
        if ml_assist_enabled is not None:
            pulumi.set(__self__, "ml_assist_enabled", ml_assist_enabled)
        if prelabel_accuracy_threshold is not None:
            pulumi.set(__self__, "prelabel_accuracy_threshold", prelabel_accuracy_threshold)

    @property
    @pulumi.getter(name="inferencingComputeBinding")
    def inferencing_compute_binding(self) -> 'outputs.ComputeBindingResponse':
        """
        The compute designated for inferencing.
        """
        return pulumi.get(self, "inferencing_compute_binding")

    @property
    @pulumi.getter(name="modelNamePrefix")
    def model_name_prefix(self) -> str:
        """
        Name prefix to use for machine learning model. For each iteration modelName will be appended with iteration e.g.{modelName}_{i}.
        """
        return pulumi.get(self, "model_name_prefix")

    @property
    @pulumi.getter(name="trainingComputeBinding")
    def training_compute_binding(self) -> 'outputs.ComputeBindingResponse':
        """
        The compute designated for training.
        """
        return pulumi.get(self, "training_compute_binding")

    @property
    @pulumi.getter(name="mlAssistEnabled")
    def ml_assist_enabled(self) -> Optional[bool]:
        """
        Indicates whether MLAssist feature is enabled.
        """
        return pulumi.get(self, "ml_assist_enabled")

    @property
    @pulumi.getter(name="prelabelAccuracyThreshold")
    def prelabel_accuracy_threshold(self) -> Optional[float]:
        """
        Prelabel accuracy threshold used in MLAssist feature.
        """
        return pulumi.get(self, "prelabel_accuracy_threshold")


@pulumi.output_type
class MachineLearningServiceErrorResponse(dict):
    """
    Wrapper for error response to follow ARM guidelines.
    """
    def __init__(__self__, *,
                 error: 'outputs.ErrorResponseResponse'):
        """
        Wrapper for error response to follow ARM guidelines.
        :param 'ErrorResponseResponse' error: The error response.
        """
        pulumi.set(__self__, "error", error)

    @property
    @pulumi.getter
    def error(self) -> 'outputs.ErrorResponseResponse':
        """
        The error response.
        """
        return pulumi.get(self, "error")


@pulumi.output_type
class ManagedIdentityResponse(dict):
    """
    Managed identity configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityType":
            suggest = "identity_type"
        elif key == "clientId":
            suggest = "client_id"
        elif key == "objectId":
            suggest = "object_id"
        elif key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 identity_type: str,
                 client_id: Optional[str] = None,
                 object_id: Optional[str] = None,
                 resource_id: Optional[str] = None):
        """
        Managed identity configuration.
        :param str identity_type: Enum to determine identity framework.
               Expected value is 'Managed'.
        :param str client_id: Specifies a user-assigned identity by client ID. For system-assigned, do not set this field.
        :param str object_id: Specifies a user-assigned identity by object ID. For system-assigned, do not set this field.
        :param str resource_id: Specifies a user-assigned identity by ARM resource ID. For system-assigned, do not set this field.
        """
        pulumi.set(__self__, "identity_type", 'Managed')
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="identityType")
    def identity_type(self) -> str:
        """
        Enum to determine identity framework.
        Expected value is 'Managed'.
        """
        return pulumi.get(self, "identity_type")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[str]:
        """
        Specifies a user-assigned identity by client ID. For system-assigned, do not set this field.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[str]:
        """
        Specifies a user-assigned identity by object ID. For system-assigned, do not set this field.
        """
        return pulumi.get(self, "object_id")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        Specifies a user-assigned identity by ARM resource ID. For system-assigned, do not set this field.
        """
        return pulumi.get(self, "resource_id")


@pulumi.output_type
class ManagedOnlineDeploymentResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointComputeType":
            suggest = "endpoint_compute_type"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "appInsightsEnabled":
            suggest = "app_insights_enabled"
        elif key == "codeConfiguration":
            suggest = "code_configuration"
        elif key == "environmentId":
            suggest = "environment_id"
        elif key == "environmentVariables":
            suggest = "environment_variables"
        elif key == "instanceType":
            suggest = "instance_type"
        elif key == "livenessProbe":
            suggest = "liveness_probe"
        elif key == "readinessProbe":
            suggest = "readiness_probe"
        elif key == "requestSettings":
            suggest = "request_settings"
        elif key == "scaleSettings":
            suggest = "scale_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedOnlineDeploymentResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedOnlineDeploymentResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedOnlineDeploymentResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_compute_type: str,
                 provisioning_state: str,
                 app_insights_enabled: Optional[bool] = None,
                 code_configuration: Optional['outputs.CodeConfigurationResponse'] = None,
                 description: Optional[str] = None,
                 environment_id: Optional[str] = None,
                 environment_variables: Optional[Mapping[str, str]] = None,
                 instance_type: Optional[str] = None,
                 liveness_probe: Optional['outputs.ProbeSettingsResponse'] = None,
                 model: Optional[Any] = None,
                 properties: Optional[Mapping[str, str]] = None,
                 readiness_probe: Optional['outputs.ProbeSettingsResponse'] = None,
                 request_settings: Optional['outputs.OnlineRequestSettingsResponse'] = None,
                 scale_settings: Optional[Any] = None):
        """
        :param str endpoint_compute_type: Enum to determine endpoint compute type.
               Expected value is 'Managed'.
        :param str provisioning_state: Provisioning state for the endpoint deployment.
        :param bool app_insights_enabled: If true, enables Application Insights logging.
        :param 'CodeConfigurationResponse' code_configuration: Code configuration for the endpoint deployment.
        :param str description: Description of the endpoint deployment.
        :param str environment_id: ARM resource ID of the environment specification for the endpoint deployment.
        :param Mapping[str, str] environment_variables: Environment variables configuration for the deployment.
        :param str instance_type: Compute instance type.
        :param 'ProbeSettingsResponse' liveness_probe: Deployment container liveness/readiness probe configuration.
        :param Union['DataPathAssetReferenceResponse', 'IdAssetReferenceResponse', 'OutputPathAssetReferenceResponse'] model: Reference to the model asset for the endpoint deployment.
        :param Mapping[str, str] properties: Property dictionary. Properties can be added, but not removed or altered.
        :param 'ProbeSettingsResponse' readiness_probe: Deployment container liveness/readiness probe configuration.
        :param 'OnlineRequestSettingsResponse' request_settings: Online deployment scoring requests configuration.
        :param Union['AutoScaleSettingsResponse', 'ManualScaleSettingsResponse'] scale_settings: Online deployment scaling configuration.
        """
        pulumi.set(__self__, "endpoint_compute_type", 'Managed')
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if app_insights_enabled is not None:
            pulumi.set(__self__, "app_insights_enabled", app_insights_enabled)
        if code_configuration is not None:
            pulumi.set(__self__, "code_configuration", code_configuration)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if environment_id is not None:
            pulumi.set(__self__, "environment_id", environment_id)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if liveness_probe is not None:
            pulumi.set(__self__, "liveness_probe", liveness_probe)
        if model is not None:
            pulumi.set(__self__, "model", model)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if readiness_probe is not None:
            pulumi.set(__self__, "readiness_probe", readiness_probe)
        if request_settings is not None:
            pulumi.set(__self__, "request_settings", request_settings)
        if scale_settings is not None:
            pulumi.set(__self__, "scale_settings", scale_settings)

    @property
    @pulumi.getter(name="endpointComputeType")
    def endpoint_compute_type(self) -> str:
        """
        Enum to determine endpoint compute type.
        Expected value is 'Managed'.
        """
        return pulumi.get(self, "endpoint_compute_type")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Provisioning state for the endpoint deployment.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="appInsightsEnabled")
    def app_insights_enabled(self) -> Optional[bool]:
        """
        If true, enables Application Insights logging.
        """
        return pulumi.get(self, "app_insights_enabled")

    @property
    @pulumi.getter(name="codeConfiguration")
    def code_configuration(self) -> Optional['outputs.CodeConfigurationResponse']:
        """
        Code configuration for the endpoint deployment.
        """
        return pulumi.get(self, "code_configuration")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of the endpoint deployment.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> Optional[str]:
        """
        ARM resource ID of the environment specification for the endpoint deployment.
        """
        return pulumi.get(self, "environment_id")

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[Mapping[str, str]]:
        """
        Environment variables configuration for the deployment.
        """
        return pulumi.get(self, "environment_variables")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[str]:
        """
        Compute instance type.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="livenessProbe")
    def liveness_probe(self) -> Optional['outputs.ProbeSettingsResponse']:
        """
        Deployment container liveness/readiness probe configuration.
        """
        return pulumi.get(self, "liveness_probe")

    @property
    @pulumi.getter
    def model(self) -> Optional[Any]:
        """
        Reference to the model asset for the endpoint deployment.
        """
        return pulumi.get(self, "model")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        Property dictionary. Properties can be added, but not removed or altered.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="readinessProbe")
    def readiness_probe(self) -> Optional['outputs.ProbeSettingsResponse']:
        """
        Deployment container liveness/readiness probe configuration.
        """
        return pulumi.get(self, "readiness_probe")

    @property
    @pulumi.getter(name="requestSettings")
    def request_settings(self) -> Optional['outputs.OnlineRequestSettingsResponse']:
        """
        Online deployment scoring requests configuration.
        """
        return pulumi.get(self, "request_settings")

    @property
    @pulumi.getter(name="scaleSettings")
    def scale_settings(self) -> Optional[Any]:
        """
        Online deployment scaling configuration.
        """
        return pulumi.get(self, "scale_settings")


@pulumi.output_type
class ManualScaleSettingsResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scaleType":
            suggest = "scale_type"
        elif key == "instanceCount":
            suggest = "instance_count"
        elif key == "maxInstances":
            suggest = "max_instances"
        elif key == "minInstances":
            suggest = "min_instances"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManualScaleSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManualScaleSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManualScaleSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 scale_type: str,
                 instance_count: Optional[int] = None,
                 max_instances: Optional[int] = None,
                 min_instances: Optional[int] = None):
        """
        :param str scale_type: 
               Expected value is 'Manual'.
        :param int instance_count: Fixed number of instances for this deployment.
        :param int max_instances: Maximum number of instances for this deployment.
        :param int min_instances: Minimum number of instances for this deployment.
        """
        pulumi.set(__self__, "scale_type", 'Manual')
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if max_instances is not None:
            pulumi.set(__self__, "max_instances", max_instances)
        if min_instances is not None:
            pulumi.set(__self__, "min_instances", min_instances)

    @property
    @pulumi.getter(name="scaleType")
    def scale_type(self) -> str:
        """

        Expected value is 'Manual'.
        """
        return pulumi.get(self, "scale_type")

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[int]:
        """
        Fixed number of instances for this deployment.
        """
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="maxInstances")
    def max_instances(self) -> Optional[int]:
        """
        Maximum number of instances for this deployment.
        """
        return pulumi.get(self, "max_instances")

    @property
    @pulumi.getter(name="minInstances")
    def min_instances(self) -> Optional[int]:
        """
        Minimum number of instances for this deployment.
        """
        return pulumi.get(self, "min_instances")


@pulumi.output_type
class MedianStoppingPolicyResponse(dict):
    """
    Defines an early termination policy based on running averages of the primary metric of all runs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "policyType":
            suggest = "policy_type"
        elif key == "delayEvaluation":
            suggest = "delay_evaluation"
        elif key == "evaluationInterval":
            suggest = "evaluation_interval"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MedianStoppingPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MedianStoppingPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MedianStoppingPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 policy_type: str,
                 delay_evaluation: Optional[int] = None,
                 evaluation_interval: Optional[int] = None):
        """
        Defines an early termination policy based on running averages of the primary metric of all runs.
        :param str policy_type: 
               Expected value is 'MedianStopping'.
        :param int delay_evaluation: Number of intervals by which to delay the first evaluation.
        :param int evaluation_interval: Interval (number of runs) between policy evaluations.
        """
        pulumi.set(__self__, "policy_type", 'MedianStopping')
        if delay_evaluation is not None:
            pulumi.set(__self__, "delay_evaluation", delay_evaluation)
        if evaluation_interval is not None:
            pulumi.set(__self__, "evaluation_interval", evaluation_interval)

    @property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> str:
        """

        Expected value is 'MedianStopping'.
        """
        return pulumi.get(self, "policy_type")

    @property
    @pulumi.getter(name="delayEvaluation")
    def delay_evaluation(self) -> Optional[int]:
        """
        Number of intervals by which to delay the first evaluation.
        """
        return pulumi.get(self, "delay_evaluation")

    @property
    @pulumi.getter(name="evaluationInterval")
    def evaluation_interval(self) -> Optional[int]:
        """
        Interval (number of runs) between policy evaluations.
        """
        return pulumi.get(self, "evaluation_interval")


@pulumi.output_type
class ModelContainerResponse(dict):
    def __init__(__self__, *,
                 description: Optional[str] = None,
                 properties: Optional[Mapping[str, str]] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        :param str description: The asset description text.
        :param Mapping[str, str] properties: The asset property dictionary.
        :param Mapping[str, str] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class ModelDockerSectionResponseResponseBaseImageRegistry(dict):
    """
    Image registry that contains the base image.
    """
    def __init__(__self__, *,
                 address: Optional[str] = None):
        """
        Image registry that contains the base image.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)

    @property
    @pulumi.getter
    def address(self) -> Optional[str]:
        return pulumi.get(self, "address")


@pulumi.output_type
class ModelEnvironmentDefinitionResponseResponseDocker(dict):
    """
    The definition of a Docker container.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseDockerfile":
            suggest = "base_dockerfile"
        elif key == "baseImage":
            suggest = "base_image"
        elif key == "baseImageRegistry":
            suggest = "base_image_registry"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelEnvironmentDefinitionResponseResponseDocker. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelEnvironmentDefinitionResponseResponseDocker.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelEnvironmentDefinitionResponseResponseDocker.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 base_dockerfile: Optional[str] = None,
                 base_image: Optional[str] = None,
                 base_image_registry: Optional['outputs.ModelDockerSectionResponseResponseBaseImageRegistry'] = None):
        """
        The definition of a Docker container.
        :param str base_dockerfile: Base Dockerfile used for Docker-based runs. Mutually exclusive with BaseImage.
        :param str base_image: Base image used for Docker-based runs. Mutually exclusive with BaseDockerfile.
        :param 'ModelDockerSectionResponseResponseBaseImageRegistry' base_image_registry: Image registry that contains the base image.
        """
        if base_dockerfile is not None:
            pulumi.set(__self__, "base_dockerfile", base_dockerfile)
        if base_image is not None:
            pulumi.set(__self__, "base_image", base_image)
        if base_image_registry is not None:
            pulumi.set(__self__, "base_image_registry", base_image_registry)

    @property
    @pulumi.getter(name="baseDockerfile")
    def base_dockerfile(self) -> Optional[str]:
        """
        Base Dockerfile used for Docker-based runs. Mutually exclusive with BaseImage.
        """
        return pulumi.get(self, "base_dockerfile")

    @property
    @pulumi.getter(name="baseImage")
    def base_image(self) -> Optional[str]:
        """
        Base image used for Docker-based runs. Mutually exclusive with BaseDockerfile.
        """
        return pulumi.get(self, "base_image")

    @property
    @pulumi.getter(name="baseImageRegistry")
    def base_image_registry(self) -> Optional['outputs.ModelDockerSectionResponseResponseBaseImageRegistry']:
        """
        Image registry that contains the base image.
        """
        return pulumi.get(self, "base_image_registry")


@pulumi.output_type
class ModelEnvironmentDefinitionResponseResponsePython(dict):
    """
    Settings for a Python environment.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseCondaEnvironment":
            suggest = "base_conda_environment"
        elif key == "condaDependencies":
            suggest = "conda_dependencies"
        elif key == "interpreterPath":
            suggest = "interpreter_path"
        elif key == "userManagedDependencies":
            suggest = "user_managed_dependencies"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelEnvironmentDefinitionResponseResponsePython. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelEnvironmentDefinitionResponseResponsePython.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelEnvironmentDefinitionResponseResponsePython.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 base_conda_environment: Optional[str] = None,
                 conda_dependencies: Optional[Any] = None,
                 interpreter_path: Optional[str] = None,
                 user_managed_dependencies: Optional[bool] = None):
        """
        Settings for a Python environment.
        :param Any conda_dependencies: A JObject containing Conda dependencies.
        :param str interpreter_path: The python interpreter path to use if an environment build is not required. The path specified gets used to call the user script.
        :param bool user_managed_dependencies: True means that AzureML reuses an existing python environment; False means that AzureML will create a python environment based on the Conda dependencies specification.
        """
        if base_conda_environment is not None:
            pulumi.set(__self__, "base_conda_environment", base_conda_environment)
        if conda_dependencies is not None:
            pulumi.set(__self__, "conda_dependencies", conda_dependencies)
        if interpreter_path is not None:
            pulumi.set(__self__, "interpreter_path", interpreter_path)
        if user_managed_dependencies is not None:
            pulumi.set(__self__, "user_managed_dependencies", user_managed_dependencies)

    @property
    @pulumi.getter(name="baseCondaEnvironment")
    def base_conda_environment(self) -> Optional[str]:
        return pulumi.get(self, "base_conda_environment")

    @property
    @pulumi.getter(name="condaDependencies")
    def conda_dependencies(self) -> Optional[Any]:
        """
        A JObject containing Conda dependencies.
        """
        return pulumi.get(self, "conda_dependencies")

    @property
    @pulumi.getter(name="interpreterPath")
    def interpreter_path(self) -> Optional[str]:
        """
        The python interpreter path to use if an environment build is not required. The path specified gets used to call the user script.
        """
        return pulumi.get(self, "interpreter_path")

    @property
    @pulumi.getter(name="userManagedDependencies")
    def user_managed_dependencies(self) -> Optional[bool]:
        """
        True means that AzureML reuses an existing python environment; False means that AzureML will create a python environment based on the Conda dependencies specification.
        """
        return pulumi.get(self, "user_managed_dependencies")


@pulumi.output_type
class ModelEnvironmentDefinitionResponseResponseR(dict):
    """
    Settings for a R environment.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bioConductorPackages":
            suggest = "bio_conductor_packages"
        elif key == "cranPackages":
            suggest = "cran_packages"
        elif key == "customUrlPackages":
            suggest = "custom_url_packages"
        elif key == "gitHubPackages":
            suggest = "git_hub_packages"
        elif key == "rVersion":
            suggest = "r_version"
        elif key == "rscriptPath":
            suggest = "rscript_path"
        elif key == "snapshotDate":
            suggest = "snapshot_date"
        elif key == "userManaged":
            suggest = "user_managed"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelEnvironmentDefinitionResponseResponseR. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelEnvironmentDefinitionResponseResponseR.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelEnvironmentDefinitionResponseResponseR.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bio_conductor_packages: Optional[Sequence[str]] = None,
                 cran_packages: Optional[Sequence['outputs.RCranPackageResponse']] = None,
                 custom_url_packages: Optional[Sequence[str]] = None,
                 git_hub_packages: Optional[Sequence['outputs.RGitHubPackageResponseResponse']] = None,
                 r_version: Optional[str] = None,
                 rscript_path: Optional[str] = None,
                 snapshot_date: Optional[str] = None,
                 user_managed: Optional[bool] = None):
        """
        Settings for a R environment.
        :param Sequence[str] bio_conductor_packages: The packages from Bioconductor.
        :param Sequence['RCranPackageResponse'] cran_packages: The CRAN packages to use.
        :param Sequence[str] custom_url_packages: The packages from custom urls.
        :param Sequence['RGitHubPackageResponseResponse'] git_hub_packages: The packages directly from GitHub.
        :param str r_version: The version of R to be installed
        :param str rscript_path: The Rscript path to use if an environment build is not required.
               The path specified gets used to call the user script.
        :param str snapshot_date: Date of MRAN snapshot to use in YYYY-MM-DD format, e.g. "2019-04-17"
        :param bool user_managed: Indicates whether the environment is managed by user or by AzureML.
        """
        if bio_conductor_packages is not None:
            pulumi.set(__self__, "bio_conductor_packages", bio_conductor_packages)
        if cran_packages is not None:
            pulumi.set(__self__, "cran_packages", cran_packages)
        if custom_url_packages is not None:
            pulumi.set(__self__, "custom_url_packages", custom_url_packages)
        if git_hub_packages is not None:
            pulumi.set(__self__, "git_hub_packages", git_hub_packages)
        if r_version is not None:
            pulumi.set(__self__, "r_version", r_version)
        if rscript_path is not None:
            pulumi.set(__self__, "rscript_path", rscript_path)
        if snapshot_date is not None:
            pulumi.set(__self__, "snapshot_date", snapshot_date)
        if user_managed is not None:
            pulumi.set(__self__, "user_managed", user_managed)

    @property
    @pulumi.getter(name="bioConductorPackages")
    def bio_conductor_packages(self) -> Optional[Sequence[str]]:
        """
        The packages from Bioconductor.
        """
        return pulumi.get(self, "bio_conductor_packages")

    @property
    @pulumi.getter(name="cranPackages")
    def cran_packages(self) -> Optional[Sequence['outputs.RCranPackageResponse']]:
        """
        The CRAN packages to use.
        """
        return pulumi.get(self, "cran_packages")

    @property
    @pulumi.getter(name="customUrlPackages")
    def custom_url_packages(self) -> Optional[Sequence[str]]:
        """
        The packages from custom urls.
        """
        return pulumi.get(self, "custom_url_packages")

    @property
    @pulumi.getter(name="gitHubPackages")
    def git_hub_packages(self) -> Optional[Sequence['outputs.RGitHubPackageResponseResponse']]:
        """
        The packages directly from GitHub.
        """
        return pulumi.get(self, "git_hub_packages")

    @property
    @pulumi.getter(name="rVersion")
    def r_version(self) -> Optional[str]:
        """
        The version of R to be installed
        """
        return pulumi.get(self, "r_version")

    @property
    @pulumi.getter(name="rscriptPath")
    def rscript_path(self) -> Optional[str]:
        """
        The Rscript path to use if an environment build is not required.
        The path specified gets used to call the user script.
        """
        return pulumi.get(self, "rscript_path")

    @property
    @pulumi.getter(name="snapshotDate")
    def snapshot_date(self) -> Optional[str]:
        """
        Date of MRAN snapshot to use in YYYY-MM-DD format, e.g. "2019-04-17"
        """
        return pulumi.get(self, "snapshot_date")

    @property
    @pulumi.getter(name="userManaged")
    def user_managed(self) -> Optional[bool]:
        """
        Indicates whether the environment is managed by user or by AzureML.
        """
        return pulumi.get(self, "user_managed")


@pulumi.output_type
class ModelEnvironmentDefinitionResponseResponseSpark(dict):
    """
    The configuration for a Spark environment.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "precachePackages":
            suggest = "precache_packages"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelEnvironmentDefinitionResponseResponseSpark. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelEnvironmentDefinitionResponseResponseSpark.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelEnvironmentDefinitionResponseResponseSpark.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 packages: Optional[Sequence['outputs.SparkMavenPackageResponse']] = None,
                 precache_packages: Optional[bool] = None,
                 repositories: Optional[Sequence[str]] = None):
        """
        The configuration for a Spark environment.
        :param Sequence['SparkMavenPackageResponse'] packages: The Spark packages to use.
        :param bool precache_packages: Whether to precache the packages.
        :param Sequence[str] repositories: The list of spark repositories.
        """
        if packages is not None:
            pulumi.set(__self__, "packages", packages)
        if precache_packages is not None:
            pulumi.set(__self__, "precache_packages", precache_packages)
        if repositories is not None:
            pulumi.set(__self__, "repositories", repositories)

    @property
    @pulumi.getter
    def packages(self) -> Optional[Sequence['outputs.SparkMavenPackageResponse']]:
        """
        The Spark packages to use.
        """
        return pulumi.get(self, "packages")

    @property
    @pulumi.getter(name="precachePackages")
    def precache_packages(self) -> Optional[bool]:
        """
        Whether to precache the packages.
        """
        return pulumi.get(self, "precache_packages")

    @property
    @pulumi.getter
    def repositories(self) -> Optional[Sequence[str]]:
        """
        The list of spark repositories.
        """
        return pulumi.get(self, "repositories")


@pulumi.output_type
class ModelResponse(dict):
    """
    An Azure Machine Learning Model.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mimeType":
            suggest = "mime_type"
        elif key == "createdTime":
            suggest = "created_time"
        elif key == "derivedModelIds":
            suggest = "derived_model_ids"
        elif key == "experimentName":
            suggest = "experiment_name"
        elif key == "frameworkVersion":
            suggest = "framework_version"
        elif key == "kvTags":
            suggest = "kv_tags"
        elif key == "modifiedTime":
            suggest = "modified_time"
        elif key == "parentModelId":
            suggest = "parent_model_id"
        elif key == "resourceRequirements":
            suggest = "resource_requirements"
        elif key == "runId":
            suggest = "run_id"
        elif key == "sampleInputData":
            suggest = "sample_input_data"
        elif key == "sampleOutputData":
            suggest = "sample_output_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mime_type: str,
                 name: str,
                 url: str,
                 created_time: Optional[str] = None,
                 datasets: Optional[Sequence['outputs.DatasetReferenceResponse']] = None,
                 derived_model_ids: Optional[Sequence[str]] = None,
                 description: Optional[str] = None,
                 experiment_name: Optional[str] = None,
                 framework: Optional[str] = None,
                 framework_version: Optional[str] = None,
                 id: Optional[str] = None,
                 kv_tags: Optional[Mapping[str, str]] = None,
                 modified_time: Optional[str] = None,
                 parent_model_id: Optional[str] = None,
                 properties: Optional[Mapping[str, str]] = None,
                 resource_requirements: Optional['outputs.ContainerResourceRequirementsResponse'] = None,
                 run_id: Optional[str] = None,
                 sample_input_data: Optional[str] = None,
                 sample_output_data: Optional[str] = None,
                 unpack: Optional[bool] = None,
                 version: Optional[float] = None):
        """
        An Azure Machine Learning Model.
        :param str mime_type: The MIME type of Model content. For more details about MIME type, please open https://www.iana.org/assignments/media-types/media-types.xhtml
        :param str name: The Model name.
        :param str url: The URL of the Model. Usually a SAS URL.
        :param str created_time: The Model creation time (UTC).
        :param Sequence['DatasetReferenceResponse'] datasets: The list of datasets associated with the model.
        :param Sequence[str] derived_model_ids: Models derived from this model
        :param str description: The Model description text.
        :param str experiment_name: The name of the experiment where this model was created.
        :param str framework: The Model framework.
        :param str framework_version: The Model framework version.
        :param str id: The Model Id.
        :param Mapping[str, str] kv_tags: The Model tag dictionary. Items are mutable.
        :param str modified_time: The Model last modified time (UTC).
        :param str parent_model_id: The Parent Model Id.
        :param Mapping[str, str] properties: The Model property dictionary. Properties are immutable.
        :param 'ContainerResourceRequirementsResponse' resource_requirements: Resource requirements for the model
        :param str run_id: The RunId that created this model.
        :param str sample_input_data: Sample Input Data for the Model. A reference to a dataset in the workspace in the format aml://dataset/{datasetId}
        :param str sample_output_data: Sample Output Data for the Model. A reference to a dataset in the workspace in the format aml://dataset/{datasetId}
        :param bool unpack: Indicates whether we need to unpack the Model during docker Image creation.
        :param float version: The Model version assigned by Model Management Service.
        """
        pulumi.set(__self__, "mime_type", mime_type)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "url", url)
        if created_time is not None:
            pulumi.set(__self__, "created_time", created_time)
        if datasets is not None:
            pulumi.set(__self__, "datasets", datasets)
        if derived_model_ids is not None:
            pulumi.set(__self__, "derived_model_ids", derived_model_ids)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if experiment_name is not None:
            pulumi.set(__self__, "experiment_name", experiment_name)
        if framework is not None:
            pulumi.set(__self__, "framework", framework)
        if framework_version is not None:
            pulumi.set(__self__, "framework_version", framework_version)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if kv_tags is not None:
            pulumi.set(__self__, "kv_tags", kv_tags)
        if modified_time is not None:
            pulumi.set(__self__, "modified_time", modified_time)
        if parent_model_id is not None:
            pulumi.set(__self__, "parent_model_id", parent_model_id)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_requirements is not None:
            pulumi.set(__self__, "resource_requirements", resource_requirements)
        if run_id is not None:
            pulumi.set(__self__, "run_id", run_id)
        if sample_input_data is not None:
            pulumi.set(__self__, "sample_input_data", sample_input_data)
        if sample_output_data is not None:
            pulumi.set(__self__, "sample_output_data", sample_output_data)
        if unpack is not None:
            pulumi.set(__self__, "unpack", unpack)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="mimeType")
    def mime_type(self) -> str:
        """
        The MIME type of Model content. For more details about MIME type, please open https://www.iana.org/assignments/media-types/media-types.xhtml
        """
        return pulumi.get(self, "mime_type")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The Model name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        The URL of the Model. Usually a SAS URL.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> Optional[str]:
        """
        The Model creation time (UTC).
        """
        return pulumi.get(self, "created_time")

    @property
    @pulumi.getter
    def datasets(self) -> Optional[Sequence['outputs.DatasetReferenceResponse']]:
        """
        The list of datasets associated with the model.
        """
        return pulumi.get(self, "datasets")

    @property
    @pulumi.getter(name="derivedModelIds")
    def derived_model_ids(self) -> Optional[Sequence[str]]:
        """
        Models derived from this model
        """
        return pulumi.get(self, "derived_model_ids")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The Model description text.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="experimentName")
    def experiment_name(self) -> Optional[str]:
        """
        The name of the experiment where this model was created.
        """
        return pulumi.get(self, "experiment_name")

    @property
    @pulumi.getter
    def framework(self) -> Optional[str]:
        """
        The Model framework.
        """
        return pulumi.get(self, "framework")

    @property
    @pulumi.getter(name="frameworkVersion")
    def framework_version(self) -> Optional[str]:
        """
        The Model framework version.
        """
        return pulumi.get(self, "framework_version")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The Model Id.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="kvTags")
    def kv_tags(self) -> Optional[Mapping[str, str]]:
        """
        The Model tag dictionary. Items are mutable.
        """
        return pulumi.get(self, "kv_tags")

    @property
    @pulumi.getter(name="modifiedTime")
    def modified_time(self) -> Optional[str]:
        """
        The Model last modified time (UTC).
        """
        return pulumi.get(self, "modified_time")

    @property
    @pulumi.getter(name="parentModelId")
    def parent_model_id(self) -> Optional[str]:
        """
        The Parent Model Id.
        """
        return pulumi.get(self, "parent_model_id")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        The Model property dictionary. Properties are immutable.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="resourceRequirements")
    def resource_requirements(self) -> Optional['outputs.ContainerResourceRequirementsResponse']:
        """
        Resource requirements for the model
        """
        return pulumi.get(self, "resource_requirements")

    @property
    @pulumi.getter(name="runId")
    def run_id(self) -> Optional[str]:
        """
        The RunId that created this model.
        """
        return pulumi.get(self, "run_id")

    @property
    @pulumi.getter(name="sampleInputData")
    def sample_input_data(self) -> Optional[str]:
        """
        Sample Input Data for the Model. A reference to a dataset in the workspace in the format aml://dataset/{datasetId}
        """
        return pulumi.get(self, "sample_input_data")

    @property
    @pulumi.getter(name="sampleOutputData")
    def sample_output_data(self) -> Optional[str]:
        """
        Sample Output Data for the Model. A reference to a dataset in the workspace in the format aml://dataset/{datasetId}
        """
        return pulumi.get(self, "sample_output_data")

    @property
    @pulumi.getter
    def unpack(self) -> Optional[bool]:
        """
        Indicates whether we need to unpack the Model during docker Image creation.
        """
        return pulumi.get(self, "unpack")

    @property
    @pulumi.getter
    def version(self) -> Optional[float]:
        """
        The Model version assigned by Model Management Service.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class ModelVersionResponse(dict):
    """
    Model asset version details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datastoreId":
            suggest = "datastore_id"
        elif key == "isAnonymous":
            suggest = "is_anonymous"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelVersionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelVersionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelVersionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 path: str,
                 datastore_id: Optional[str] = None,
                 description: Optional[str] = None,
                 flavors: Optional[Mapping[str, 'outputs.FlavorDataResponse']] = None,
                 is_anonymous: Optional[bool] = None,
                 properties: Optional[Mapping[str, str]] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        Model asset version details.
        :param str path: [Required] The path of the file/directory in the datastore.
        :param str datastore_id: ARM resource ID of the datastore where the asset is located.
        :param str description: The asset description text.
        :param Mapping[str, 'FlavorDataResponse'] flavors: Mapping of model flavors to their properties.
        :param bool is_anonymous: If the name version are system generated (anonymous registration).
        :param Mapping[str, str] properties: The asset property dictionary.
        :param Mapping[str, str] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        pulumi.set(__self__, "path", path)
        if datastore_id is not None:
            pulumi.set(__self__, "datastore_id", datastore_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if flavors is not None:
            pulumi.set(__self__, "flavors", flavors)
        if is_anonymous is not None:
            pulumi.set(__self__, "is_anonymous", is_anonymous)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        [Required] The path of the file/directory in the datastore.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="datastoreId")
    def datastore_id(self) -> Optional[str]:
        """
        ARM resource ID of the datastore where the asset is located.
        """
        return pulumi.get(self, "datastore_id")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def flavors(self) -> Optional[Mapping[str, 'outputs.FlavorDataResponse']]:
        """
        Mapping of model flavors to their properties.
        """
        return pulumi.get(self, "flavors")

    @property
    @pulumi.getter(name="isAnonymous")
    def is_anonymous(self) -> Optional[bool]:
        """
        If the name version are system generated (anonymous registration).
        """
        return pulumi.get(self, "is_anonymous")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class MpiResponse(dict):
    """
    MPI distribution configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "distributionType":
            suggest = "distribution_type"
        elif key == "processCountPerInstance":
            suggest = "process_count_per_instance"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MpiResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MpiResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MpiResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 distribution_type: str,
                 process_count_per_instance: Optional[int] = None):
        """
        MPI distribution configuration.
        :param str distribution_type: Enum to determine the job distribution type.
               Expected value is 'Mpi'.
        :param int process_count_per_instance: Number of processes per MPI node.
        """
        pulumi.set(__self__, "distribution_type", 'Mpi')
        if process_count_per_instance is not None:
            pulumi.set(__self__, "process_count_per_instance", process_count_per_instance)

    @property
    @pulumi.getter(name="distributionType")
    def distribution_type(self) -> str:
        """
        Enum to determine the job distribution type.
        Expected value is 'Mpi'.
        """
        return pulumi.get(self, "distribution_type")

    @property
    @pulumi.getter(name="processCountPerInstance")
    def process_count_per_instance(self) -> Optional[int]:
        """
        Number of processes per MPI node.
        """
        return pulumi.get(self, "process_count_per_instance")


@pulumi.output_type
class NodeStateCountsResponse(dict):
    """
    Counts of various compute node states on the amlCompute.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "idleNodeCount":
            suggest = "idle_node_count"
        elif key == "leavingNodeCount":
            suggest = "leaving_node_count"
        elif key == "preemptedNodeCount":
            suggest = "preempted_node_count"
        elif key == "preparingNodeCount":
            suggest = "preparing_node_count"
        elif key == "runningNodeCount":
            suggest = "running_node_count"
        elif key == "unusableNodeCount":
            suggest = "unusable_node_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeStateCountsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeStateCountsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeStateCountsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 idle_node_count: int,
                 leaving_node_count: int,
                 preempted_node_count: int,
                 preparing_node_count: int,
                 running_node_count: int,
                 unusable_node_count: int):
        """
        Counts of various compute node states on the amlCompute.
        :param int idle_node_count: Number of compute nodes in idle state.
        :param int leaving_node_count: Number of compute nodes which are leaving the amlCompute.
        :param int preempted_node_count: Number of compute nodes which are in preempted state.
        :param int preparing_node_count: Number of compute nodes which are being prepared.
        :param int running_node_count: Number of compute nodes which are running jobs.
        :param int unusable_node_count: Number of compute nodes which are in unusable state.
        """
        pulumi.set(__self__, "idle_node_count", idle_node_count)
        pulumi.set(__self__, "leaving_node_count", leaving_node_count)
        pulumi.set(__self__, "preempted_node_count", preempted_node_count)
        pulumi.set(__self__, "preparing_node_count", preparing_node_count)
        pulumi.set(__self__, "running_node_count", running_node_count)
        pulumi.set(__self__, "unusable_node_count", unusable_node_count)

    @property
    @pulumi.getter(name="idleNodeCount")
    def idle_node_count(self) -> int:
        """
        Number of compute nodes in idle state.
        """
        return pulumi.get(self, "idle_node_count")

    @property
    @pulumi.getter(name="leavingNodeCount")
    def leaving_node_count(self) -> int:
        """
        Number of compute nodes which are leaving the amlCompute.
        """
        return pulumi.get(self, "leaving_node_count")

    @property
    @pulumi.getter(name="preemptedNodeCount")
    def preempted_node_count(self) -> int:
        """
        Number of compute nodes which are in preempted state.
        """
        return pulumi.get(self, "preempted_node_count")

    @property
    @pulumi.getter(name="preparingNodeCount")
    def preparing_node_count(self) -> int:
        """
        Number of compute nodes which are being prepared.
        """
        return pulumi.get(self, "preparing_node_count")

    @property
    @pulumi.getter(name="runningNodeCount")
    def running_node_count(self) -> int:
        """
        Number of compute nodes which are running jobs.
        """
        return pulumi.get(self, "running_node_count")

    @property
    @pulumi.getter(name="unusableNodeCount")
    def unusable_node_count(self) -> int:
        """
        Number of compute nodes which are in unusable state.
        """
        return pulumi.get(self, "unusable_node_count")


@pulumi.output_type
class NotebookPreparationErrorResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "errorMessage":
            suggest = "error_message"
        elif key == "statusCode":
            suggest = "status_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NotebookPreparationErrorResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NotebookPreparationErrorResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NotebookPreparationErrorResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 error_message: Optional[str] = None,
                 status_code: Optional[int] = None):
        if error_message is not None:
            pulumi.set(__self__, "error_message", error_message)
        if status_code is not None:
            pulumi.set(__self__, "status_code", status_code)

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> Optional[str]:
        return pulumi.get(self, "error_message")

    @property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> Optional[int]:
        return pulumi.get(self, "status_code")


@pulumi.output_type
class NotebookResourceInfoResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "notebookPreparationError":
            suggest = "notebook_preparation_error"
        elif key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NotebookResourceInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NotebookResourceInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NotebookResourceInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fqdn: Optional[str] = None,
                 notebook_preparation_error: Optional['outputs.NotebookPreparationErrorResponse'] = None,
                 resource_id: Optional[str] = None):
        """
        :param 'NotebookPreparationErrorResponse' notebook_preparation_error: The error that occurs when preparing notebook.
        :param str resource_id: the data plane resourceId that used to initialize notebook component
        """
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if notebook_preparation_error is not None:
            pulumi.set(__self__, "notebook_preparation_error", notebook_preparation_error)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter
    def fqdn(self) -> Optional[str]:
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter(name="notebookPreparationError")
    def notebook_preparation_error(self) -> Optional['outputs.NotebookPreparationErrorResponse']:
        """
        The error that occurs when preparing notebook.
        """
        return pulumi.get(self, "notebook_preparation_error")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        the data plane resourceId that used to initialize notebook component
        """
        return pulumi.get(self, "resource_id")


@pulumi.output_type
class ObjectiveResponse(dict):
    """
    Optimization objective.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "primaryMetric":
            suggest = "primary_metric"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ObjectiveResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ObjectiveResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ObjectiveResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 goal: str,
                 primary_metric: str):
        """
        Optimization objective.
        :param str goal: [Required] Defines supported metric goals for hyperparameter tuning
        :param str primary_metric: [Required] Name of the metric to optimize.
        """
        pulumi.set(__self__, "goal", goal)
        pulumi.set(__self__, "primary_metric", primary_metric)

    @property
    @pulumi.getter
    def goal(self) -> str:
        """
        [Required] Defines supported metric goals for hyperparameter tuning
        """
        return pulumi.get(self, "goal")

    @property
    @pulumi.getter(name="primaryMetric")
    def primary_metric(self) -> str:
        """
        [Required] Name of the metric to optimize.
        """
        return pulumi.get(self, "primary_metric")


@pulumi.output_type
class OnlineEndpointResponse(dict):
    """
    Online endpoint configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authMode":
            suggest = "auth_mode"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "scoringUri":
            suggest = "scoring_uri"
        elif key == "swaggerUri":
            suggest = "swagger_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OnlineEndpointResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OnlineEndpointResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OnlineEndpointResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auth_mode: str,
                 provisioning_state: str,
                 scoring_uri: str,
                 swagger_uri: str,
                 description: Optional[str] = None,
                 properties: Optional[Mapping[str, str]] = None,
                 target: Optional[str] = None,
                 traffic: Optional[Mapping[str, int]] = None):
        """
        Online endpoint configuration
        :param str auth_mode: [Required] Inference endpoint authentication mode type
        :param str provisioning_state: State of endpoint provisioning.
        :param str scoring_uri: Endpoint URI.
        :param str swagger_uri: Endpoint Swagger URI.
        :param str description: Description of the inference endpoint.
        :param Mapping[str, str] properties: Property dictionary. Properties can be added, but not removed or altered.
        :param str target: ARM resource ID of the compute if it exists.
               optional
        :param Mapping[str, int] traffic: Traffic rules on how the traffic will be routed across deployments.
        """
        pulumi.set(__self__, "auth_mode", auth_mode)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "scoring_uri", scoring_uri)
        pulumi.set(__self__, "swagger_uri", swagger_uri)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if traffic is not None:
            pulumi.set(__self__, "traffic", traffic)

    @property
    @pulumi.getter(name="authMode")
    def auth_mode(self) -> str:
        """
        [Required] Inference endpoint authentication mode type
        """
        return pulumi.get(self, "auth_mode")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        State of endpoint provisioning.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="scoringUri")
    def scoring_uri(self) -> str:
        """
        Endpoint URI.
        """
        return pulumi.get(self, "scoring_uri")

    @property
    @pulumi.getter(name="swaggerUri")
    def swagger_uri(self) -> str:
        """
        Endpoint Swagger URI.
        """
        return pulumi.get(self, "swagger_uri")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of the inference endpoint.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        Property dictionary. Properties can be added, but not removed or altered.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def target(self) -> Optional[str]:
        """
        ARM resource ID of the compute if it exists.
        optional
        """
        return pulumi.get(self, "target")

    @property
    @pulumi.getter
    def traffic(self) -> Optional[Mapping[str, int]]:
        """
        Traffic rules on how the traffic will be routed across deployments.
        """
        return pulumi.get(self, "traffic")


@pulumi.output_type
class OnlineRequestSettingsResponse(dict):
    """
    Online deployment scoring requests configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxConcurrentRequestsPerInstance":
            suggest = "max_concurrent_requests_per_instance"
        elif key == "maxQueueWait":
            suggest = "max_queue_wait"
        elif key == "requestTimeout":
            suggest = "request_timeout"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OnlineRequestSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OnlineRequestSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OnlineRequestSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_concurrent_requests_per_instance: Optional[int] = None,
                 max_queue_wait: Optional[str] = None,
                 request_timeout: Optional[str] = None):
        """
        Online deployment scoring requests configuration.
        :param int max_concurrent_requests_per_instance: The number of requests allowed to queue at once for this deployment.
        :param str max_queue_wait: The maximum queue wait time in ISO 8601 format. Supports millisecond precision.
        :param str request_timeout: The request timeout in ISO 8601 format. Supports millisecond precision.
        """
        if max_concurrent_requests_per_instance is not None:
            pulumi.set(__self__, "max_concurrent_requests_per_instance", max_concurrent_requests_per_instance)
        if max_queue_wait is not None:
            pulumi.set(__self__, "max_queue_wait", max_queue_wait)
        if request_timeout is not None:
            pulumi.set(__self__, "request_timeout", request_timeout)

    @property
    @pulumi.getter(name="maxConcurrentRequestsPerInstance")
    def max_concurrent_requests_per_instance(self) -> Optional[int]:
        """
        The number of requests allowed to queue at once for this deployment.
        """
        return pulumi.get(self, "max_concurrent_requests_per_instance")

    @property
    @pulumi.getter(name="maxQueueWait")
    def max_queue_wait(self) -> Optional[str]:
        """
        The maximum queue wait time in ISO 8601 format. Supports millisecond precision.
        """
        return pulumi.get(self, "max_queue_wait")

    @property
    @pulumi.getter(name="requestTimeout")
    def request_timeout(self) -> Optional[str]:
        """
        The request timeout in ISO 8601 format. Supports millisecond precision.
        """
        return pulumi.get(self, "request_timeout")


@pulumi.output_type
class OutputDataBindingResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datastoreId":
            suggest = "datastore_id"
        elif key == "pathOnCompute":
            suggest = "path_on_compute"
        elif key == "pathOnDatastore":
            suggest = "path_on_datastore"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OutputDataBindingResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OutputDataBindingResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OutputDataBindingResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 datastore_id: Optional[str] = None,
                 mode: Optional[str] = None,
                 path_on_compute: Optional[str] = None,
                 path_on_datastore: Optional[str] = None):
        """
        :param str datastore_id: ARM resource ID of the datastore where the data output will be stored.
        :param str mode: Mechanism for data movement to datastore.
        :param str path_on_compute: Location of data inside the container process.
        :param str path_on_datastore: Path within the datastore to the data.
        """
        if datastore_id is not None:
            pulumi.set(__self__, "datastore_id", datastore_id)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if path_on_compute is not None:
            pulumi.set(__self__, "path_on_compute", path_on_compute)
        if path_on_datastore is not None:
            pulumi.set(__self__, "path_on_datastore", path_on_datastore)

    @property
    @pulumi.getter(name="datastoreId")
    def datastore_id(self) -> Optional[str]:
        """
        ARM resource ID of the datastore where the data output will be stored.
        """
        return pulumi.get(self, "datastore_id")

    @property
    @pulumi.getter
    def mode(self) -> Optional[str]:
        """
        Mechanism for data movement to datastore.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter(name="pathOnCompute")
    def path_on_compute(self) -> Optional[str]:
        """
        Location of data inside the container process.
        """
        return pulumi.get(self, "path_on_compute")

    @property
    @pulumi.getter(name="pathOnDatastore")
    def path_on_datastore(self) -> Optional[str]:
        """
        Path within the datastore to the data.
        """
        return pulumi.get(self, "path_on_datastore")


@pulumi.output_type
class OutputPathAssetReferenceResponse(dict):
    """
    Reference to an asset via its path in a job output.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "referenceType":
            suggest = "reference_type"
        elif key == "jobId":
            suggest = "job_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OutputPathAssetReferenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OutputPathAssetReferenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OutputPathAssetReferenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 reference_type: str,
                 job_id: Optional[str] = None,
                 path: Optional[str] = None):
        """
        Reference to an asset via its path in a job output.
        :param str reference_type: Enum to determine which reference method to use for an asset.
               Expected value is 'OutputPath'.
        :param str job_id: ARM resource ID of the job.
        :param str path: The path of the file/directory in the job output.
        """
        pulumi.set(__self__, "reference_type", 'OutputPath')
        if job_id is not None:
            pulumi.set(__self__, "job_id", job_id)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="referenceType")
    def reference_type(self) -> str:
        """
        Enum to determine which reference method to use for an asset.
        Expected value is 'OutputPath'.
        """
        return pulumi.get(self, "reference_type")

    @property
    @pulumi.getter(name="jobId")
    def job_id(self) -> Optional[str]:
        """
        ARM resource ID of the job.
        """
        return pulumi.get(self, "job_id")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The path of the file/directory in the job output.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class PasswordResponse(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class PersonalComputeInstanceSettingsResponse(dict):
    """
    Settings for a personal compute instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "assignedUser":
            suggest = "assigned_user"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PersonalComputeInstanceSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PersonalComputeInstanceSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PersonalComputeInstanceSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 assigned_user: Optional['outputs.AssignedUserResponse'] = None):
        """
        Settings for a personal compute instance.
        :param 'AssignedUserResponse' assigned_user: A user explicitly assigned to a personal compute instance.
        """
        if assigned_user is not None:
            pulumi.set(__self__, "assigned_user", assigned_user)

    @property
    @pulumi.getter(name="assignedUser")
    def assigned_user(self) -> Optional['outputs.AssignedUserResponse']:
        """
        A user explicitly assigned to a personal compute instance.
        """
        return pulumi.get(self, "assigned_user")


@pulumi.output_type
class PrivateEndpointConnectionResponse(dict):
    """
    The Private Endpoint Connection resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateLinkServiceConnectionState":
            suggest = "private_link_service_connection_state"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "systemData":
            suggest = "system_data"
        elif key == "privateEndpoint":
            suggest = "private_endpoint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateEndpointConnectionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateEndpointConnectionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateEndpointConnectionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 name: str,
                 private_link_service_connection_state: 'outputs.PrivateLinkServiceConnectionStateResponse',
                 provisioning_state: str,
                 system_data: 'outputs.SystemDataResponse',
                 type: str,
                 identity: Optional['outputs.IdentityResponse'] = None,
                 location: Optional[str] = None,
                 private_endpoint: Optional['outputs.PrivateEndpointResponse'] = None,
                 sku: Optional['outputs.SkuResponse'] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        The Private Endpoint Connection resource.
        :param str id: Specifies the resource ID.
        :param str name: Specifies the name of the resource.
        :param 'PrivateLinkServiceConnectionStateResponse' private_link_service_connection_state: A collection of information about the state of the connection between service consumer and provider.
        :param str provisioning_state: The provisioning state of the private endpoint connection resource.
        :param 'SystemDataResponse' system_data: Read only system data
        :param str type: Specifies the type of the resource.
        :param 'IdentityResponse' identity: The identity of the resource.
        :param str location: Specifies the location of the resource.
        :param 'PrivateEndpointResponse' private_endpoint: The resource of private end point.
        :param 'SkuResponse' sku: The sku of the workspace.
        :param Mapping[str, str] tags: Contains resource tags defined as key/value pairs.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "private_link_service_connection_state", private_link_service_connection_state)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "system_data", system_data)
        pulumi.set(__self__, "type", type)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if private_endpoint is not None:
            pulumi.set(__self__, "private_endpoint", private_endpoint)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Specifies the resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Specifies the name of the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateLinkServiceConnectionState")
    def private_link_service_connection_state(self) -> 'outputs.PrivateLinkServiceConnectionStateResponse':
        """
        A collection of information about the state of the connection between service consumer and provider.
        """
        return pulumi.get(self, "private_link_service_connection_state")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the private endpoint connection resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> 'outputs.SystemDataResponse':
        """
        Read only system data
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Specifies the type of the resource.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def identity(self) -> Optional['outputs.IdentityResponse']:
        """
        The identity of the resource.
        """
        return pulumi.get(self, "identity")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Specifies the location of the resource.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="privateEndpoint")
    def private_endpoint(self) -> Optional['outputs.PrivateEndpointResponse']:
        """
        The resource of private end point.
        """
        return pulumi.get(self, "private_endpoint")

    @property
    @pulumi.getter
    def sku(self) -> Optional['outputs.SkuResponse']:
        """
        The sku of the workspace.
        """
        return pulumi.get(self, "sku")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Contains resource tags defined as key/value pairs.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class PrivateEndpointResponse(dict):
    """
    The Private Endpoint resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subnetArmId":
            suggest = "subnet_arm_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateEndpointResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateEndpointResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateEndpointResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 subnet_arm_id: str):
        """
        The Private Endpoint resource.
        :param str id: The ARM identifier for Private Endpoint
        :param str subnet_arm_id: The ARM identifier for Subnet resource that private endpoint links to
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "subnet_arm_id", subnet_arm_id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ARM identifier for Private Endpoint
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="subnetArmId")
    def subnet_arm_id(self) -> str:
        """
        The ARM identifier for Subnet resource that private endpoint links to
        """
        return pulumi.get(self, "subnet_arm_id")


@pulumi.output_type
class PrivateLinkServiceConnectionStateResponse(dict):
    """
    A collection of information about the state of the connection between service consumer and provider.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionsRequired":
            suggest = "actions_required"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateLinkServiceConnectionStateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateLinkServiceConnectionStateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateLinkServiceConnectionStateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 actions_required: Optional[str] = None,
                 description: Optional[str] = None,
                 status: Optional[str] = None):
        """
        A collection of information about the state of the connection between service consumer and provider.
        :param str actions_required: A message indicating if changes on the service provider require any updates on the consumer.
        :param str description: The reason for approval/rejection of the connection.
        :param str status: Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
        """
        if actions_required is not None:
            pulumi.set(__self__, "actions_required", actions_required)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="actionsRequired")
    def actions_required(self) -> Optional[str]:
        """
        A message indicating if changes on the service provider require any updates on the consumer.
        """
        return pulumi.get(self, "actions_required")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The reason for approval/rejection of the connection.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class ProbeSettingsResponse(dict):
    """
    Deployment container liveness/readiness probe configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failureThreshold":
            suggest = "failure_threshold"
        elif key == "initialDelay":
            suggest = "initial_delay"
        elif key == "successThreshold":
            suggest = "success_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProbeSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProbeSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProbeSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 failure_threshold: Optional[int] = None,
                 initial_delay: Optional[str] = None,
                 period: Optional[str] = None,
                 success_threshold: Optional[int] = None,
                 timeout: Optional[str] = None):
        """
        Deployment container liveness/readiness probe configuration.
        :param int failure_threshold: The number of failures to allow before returning an unhealthy status.
        :param str initial_delay: The delay before the first probe in ISO 8601 format.
        :param str period: The length of time between probes in ISO 8601 format.
        :param int success_threshold: The number of successful probes before returning a healthy status.
        :param str timeout: The probe timeout in ISO 8601 format.
        """
        if failure_threshold is not None:
            pulumi.set(__self__, "failure_threshold", failure_threshold)
        if initial_delay is not None:
            pulumi.set(__self__, "initial_delay", initial_delay)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if success_threshold is not None:
            pulumi.set(__self__, "success_threshold", success_threshold)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter(name="failureThreshold")
    def failure_threshold(self) -> Optional[int]:
        """
        The number of failures to allow before returning an unhealthy status.
        """
        return pulumi.get(self, "failure_threshold")

    @property
    @pulumi.getter(name="initialDelay")
    def initial_delay(self) -> Optional[str]:
        """
        The delay before the first probe in ISO 8601 format.
        """
        return pulumi.get(self, "initial_delay")

    @property
    @pulumi.getter
    def period(self) -> Optional[str]:
        """
        The length of time between probes in ISO 8601 format.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="successThreshold")
    def success_threshold(self) -> Optional[int]:
        """
        The number of successful probes before returning a healthy status.
        """
        return pulumi.get(self, "success_threshold")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[str]:
        """
        The probe timeout in ISO 8601 format.
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class ProgressMetricsResponse(dict):
    """
    Progress metrics for a labeling job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "completedDatapointCount":
            suggest = "completed_datapoint_count"
        elif key == "incrementalDatasetLastRefreshTime":
            suggest = "incremental_dataset_last_refresh_time"
        elif key == "skippedDatapointCount":
            suggest = "skipped_datapoint_count"
        elif key == "totalDatapointCount":
            suggest = "total_datapoint_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProgressMetricsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProgressMetricsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProgressMetricsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 completed_datapoint_count: float,
                 incremental_dataset_last_refresh_time: str,
                 skipped_datapoint_count: float,
                 total_datapoint_count: float):
        """
        Progress metrics for a labeling job.
        :param float completed_datapoint_count: The completed datapoint count.
        :param str incremental_dataset_last_refresh_time: The time of last successful incremental dataset refresh in UTC.
        :param float skipped_datapoint_count: The skipped datapoint count.
        :param float total_datapoint_count: The total datapoint count.
        """
        pulumi.set(__self__, "completed_datapoint_count", completed_datapoint_count)
        pulumi.set(__self__, "incremental_dataset_last_refresh_time", incremental_dataset_last_refresh_time)
        pulumi.set(__self__, "skipped_datapoint_count", skipped_datapoint_count)
        pulumi.set(__self__, "total_datapoint_count", total_datapoint_count)

    @property
    @pulumi.getter(name="completedDatapointCount")
    def completed_datapoint_count(self) -> float:
        """
        The completed datapoint count.
        """
        return pulumi.get(self, "completed_datapoint_count")

    @property
    @pulumi.getter(name="incrementalDatasetLastRefreshTime")
    def incremental_dataset_last_refresh_time(self) -> str:
        """
        The time of last successful incremental dataset refresh in UTC.
        """
        return pulumi.get(self, "incremental_dataset_last_refresh_time")

    @property
    @pulumi.getter(name="skippedDatapointCount")
    def skipped_datapoint_count(self) -> float:
        """
        The skipped datapoint count.
        """
        return pulumi.get(self, "skipped_datapoint_count")

    @property
    @pulumi.getter(name="totalDatapointCount")
    def total_datapoint_count(self) -> float:
        """
        The total datapoint count.
        """
        return pulumi.get(self, "total_datapoint_count")


@pulumi.output_type
class PyTorchResponse(dict):
    """
    PyTorch distribution configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "distributionType":
            suggest = "distribution_type"
        elif key == "processCount":
            suggest = "process_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PyTorchResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PyTorchResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PyTorchResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 distribution_type: str,
                 process_count: Optional[int] = None):
        """
        PyTorch distribution configuration.
        :param str distribution_type: Enum to determine the job distribution type.
               Expected value is 'PyTorch'.
        :param int process_count: Total process count for the distributed job.
        """
        pulumi.set(__self__, "distribution_type", 'PyTorch')
        if process_count is not None:
            pulumi.set(__self__, "process_count", process_count)

    @property
    @pulumi.getter(name="distributionType")
    def distribution_type(self) -> str:
        """
        Enum to determine the job distribution type.
        Expected value is 'PyTorch'.
        """
        return pulumi.get(self, "distribution_type")

    @property
    @pulumi.getter(name="processCount")
    def process_count(self) -> Optional[int]:
        """
        Total process count for the distributed job.
        """
        return pulumi.get(self, "process_count")


@pulumi.output_type
class RCranPackageResponse(dict):
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 repository: Optional[str] = None):
        """
        :param str name: The package name.
        :param str repository: The repository name.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if repository is not None:
            pulumi.set(__self__, "repository", repository)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The package name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def repository(self) -> Optional[str]:
        """
        The repository name.
        """
        return pulumi.get(self, "repository")


@pulumi.output_type
class RGitHubPackageResponseResponse(dict):
    def __init__(__self__, *,
                 repository: Optional[str] = None):
        """
        :param str repository: Repository address in the format username/repo[/subdir][@ref|#pull].
        """
        if repository is not None:
            pulumi.set(__self__, "repository", repository)

    @property
    @pulumi.getter
    def repository(self) -> Optional[str]:
        """
        Repository address in the format username/repo[/subdir][@ref|#pull].
        """
        return pulumi.get(self, "repository")


@pulumi.output_type
class RegistryListCredentialsResultResponse(dict):
    def __init__(__self__, *,
                 location: str,
                 username: str,
                 passwords: Optional[Sequence['outputs.PasswordResponse']] = None):
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "username", username)
        if passwords is not None:
            pulumi.set(__self__, "passwords", passwords)

    @property
    @pulumi.getter
    def location(self) -> str:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def username(self) -> str:
        return pulumi.get(self, "username")

    @property
    @pulumi.getter
    def passwords(self) -> Optional[Sequence['outputs.PasswordResponse']]:
        return pulumi.get(self, "passwords")


@pulumi.output_type
class ResourceIdResponse(dict):
    """
    Represents a resource ID. For example, for a subnet, it is the resource URL for the subnet.
    """
    def __init__(__self__, *,
                 id: str):
        """
        Represents a resource ID. For example, for a subnet, it is the resource URL for the subnet.
        :param str id: The ID of the resource
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the resource
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class ResourceIdentityResponse(dict):
    """
    Service identity associated with a resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"
        elif key == "userAssignedIdentities":
            suggest = "user_assigned_identities"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: str,
                 tenant_id: str,
                 type: Optional[str] = None,
                 user_assigned_identities: Optional[Mapping[str, 'outputs.UserAssignedIdentityMetaResponse']] = None):
        """
        Service identity associated with a resource.
        :param str principal_id: Client ID that is used when authenticating.
        :param str tenant_id: AAD Tenant where this identity lives.
        :param str type: Defines values for a ResourceIdentity's type.
        :param Mapping[str, 'UserAssignedIdentityMetaResponse'] user_assigned_identities: Dictionary of the user assigned identities, key is ARM resource ID of the UAI.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        Client ID that is used when authenticating.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        AAD Tenant where this identity lives.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Defines values for a ResourceIdentity's type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[Mapping[str, 'outputs.UserAssignedIdentityMetaResponse']]:
        """
        Dictionary of the user assigned identities, key is ARM resource ID of the UAI.
        """
        return pulumi.get(self, "user_assigned_identities")


@pulumi.output_type
class RouteResponse(dict):
    def __init__(__self__, *,
                 path: str,
                 port: int):
        """
        :param str path: [Required] The path for the route.
        :param int port: [Required] The port for the route.
        """
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        [Required] The path for the route.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        [Required] The port for the route.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class ScaleSettingsResponse(dict):
    """
    scale settings for AML Compute
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxNodeCount":
            suggest = "max_node_count"
        elif key == "minNodeCount":
            suggest = "min_node_count"
        elif key == "nodeIdleTimeBeforeScaleDown":
            suggest = "node_idle_time_before_scale_down"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScaleSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScaleSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScaleSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_node_count: int,
                 min_node_count: Optional[int] = None,
                 node_idle_time_before_scale_down: Optional[str] = None):
        """
        scale settings for AML Compute
        :param int max_node_count: Max number of nodes to use
        :param int min_node_count: Min number of nodes to use
        :param str node_idle_time_before_scale_down: Node Idle Time before scaling down amlCompute. This string needs to be in the RFC Format.
        """
        pulumi.set(__self__, "max_node_count", max_node_count)
        if min_node_count is None:
            min_node_count = 0
        if min_node_count is not None:
            pulumi.set(__self__, "min_node_count", min_node_count)
        if node_idle_time_before_scale_down is not None:
            pulumi.set(__self__, "node_idle_time_before_scale_down", node_idle_time_before_scale_down)

    @property
    @pulumi.getter(name="maxNodeCount")
    def max_node_count(self) -> int:
        """
        Max number of nodes to use
        """
        return pulumi.get(self, "max_node_count")

    @property
    @pulumi.getter(name="minNodeCount")
    def min_node_count(self) -> Optional[int]:
        """
        Min number of nodes to use
        """
        return pulumi.get(self, "min_node_count")

    @property
    @pulumi.getter(name="nodeIdleTimeBeforeScaleDown")
    def node_idle_time_before_scale_down(self) -> Optional[str]:
        """
        Node Idle Time before scaling down amlCompute. This string needs to be in the RFC Format.
        """
        return pulumi.get(self, "node_idle_time_before_scale_down")


@pulumi.output_type
class ScriptReferenceResponse(dict):
    """
    Script reference
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scriptArguments":
            suggest = "script_arguments"
        elif key == "scriptData":
            suggest = "script_data"
        elif key == "scriptSource":
            suggest = "script_source"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScriptReferenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScriptReferenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScriptReferenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 script_arguments: Optional[str] = None,
                 script_data: Optional[str] = None,
                 script_source: Optional[str] = None,
                 timeout: Optional[str] = None):
        """
        Script reference
        :param str script_arguments: Optional command line arguments passed to the script to run.
        :param str script_data: The location of scripts in the mounted volume.
        :param str script_source: The storage source of the script: inline, workspace.
        :param str timeout: Optional time period passed to timeout command.
        """
        if script_arguments is not None:
            pulumi.set(__self__, "script_arguments", script_arguments)
        if script_data is not None:
            pulumi.set(__self__, "script_data", script_data)
        if script_source is not None:
            pulumi.set(__self__, "script_source", script_source)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter(name="scriptArguments")
    def script_arguments(self) -> Optional[str]:
        """
        Optional command line arguments passed to the script to run.
        """
        return pulumi.get(self, "script_arguments")

    @property
    @pulumi.getter(name="scriptData")
    def script_data(self) -> Optional[str]:
        """
        The location of scripts in the mounted volume.
        """
        return pulumi.get(self, "script_data")

    @property
    @pulumi.getter(name="scriptSource")
    def script_source(self) -> Optional[str]:
        """
        The storage source of the script: inline, workspace.
        """
        return pulumi.get(self, "script_source")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[str]:
        """
        Optional time period passed to timeout command.
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class ScriptsToExecuteResponse(dict):
    """
    Customized setup scripts
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "creationScript":
            suggest = "creation_script"
        elif key == "startupScript":
            suggest = "startup_script"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScriptsToExecuteResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScriptsToExecuteResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScriptsToExecuteResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 creation_script: Optional['outputs.ScriptReferenceResponse'] = None,
                 startup_script: Optional['outputs.ScriptReferenceResponse'] = None):
        """
        Customized setup scripts
        :param 'ScriptReferenceResponse' creation_script: Script that's run only once during provision of the compute.
        :param 'ScriptReferenceResponse' startup_script: Script that's run every time the machine starts.
        """
        if creation_script is not None:
            pulumi.set(__self__, "creation_script", creation_script)
        if startup_script is not None:
            pulumi.set(__self__, "startup_script", startup_script)

    @property
    @pulumi.getter(name="creationScript")
    def creation_script(self) -> Optional['outputs.ScriptReferenceResponse']:
        """
        Script that's run only once during provision of the compute.
        """
        return pulumi.get(self, "creation_script")

    @property
    @pulumi.getter(name="startupScript")
    def startup_script(self) -> Optional['outputs.ScriptReferenceResponse']:
        """
        Script that's run every time the machine starts.
        """
        return pulumi.get(self, "startup_script")


@pulumi.output_type
class ServiceManagedResourcesSettingsResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cosmosDb":
            suggest = "cosmos_db"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceManagedResourcesSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceManagedResourcesSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceManagedResourcesSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cosmos_db: Optional['outputs.CosmosDbSettingsResponse'] = None):
        """
        :param 'CosmosDbSettingsResponse' cosmos_db: The settings for the service managed cosmosdb account.
        """
        if cosmos_db is not None:
            pulumi.set(__self__, "cosmos_db", cosmos_db)

    @property
    @pulumi.getter(name="cosmosDb")
    def cosmos_db(self) -> Optional['outputs.CosmosDbSettingsResponse']:
        """
        The settings for the service managed cosmosdb account.
        """
        return pulumi.get(self, "cosmos_db")


@pulumi.output_type
class ServiceResponseBaseResponseError(dict):
    """
    The error details.
    """
    def __init__(__self__, *,
                 error: 'outputs.ErrorResponseResponse'):
        """
        The error details.
        :param 'ErrorResponseResponse' error: The error response.
        """
        pulumi.set(__self__, "error", error)

    @property
    @pulumi.getter
    def error(self) -> 'outputs.ErrorResponseResponse':
        """
        The error response.
        """
        return pulumi.get(self, "error")


@pulumi.output_type
class SetupScriptsResponse(dict):
    """
    Details of customized scripts to execute for setting up the cluster.
    """
    def __init__(__self__, *,
                 scripts: Optional['outputs.ScriptsToExecuteResponse'] = None):
        """
        Details of customized scripts to execute for setting up the cluster.
        :param 'ScriptsToExecuteResponse' scripts: Customized setup scripts
        """
        if scripts is not None:
            pulumi.set(__self__, "scripts", scripts)

    @property
    @pulumi.getter
    def scripts(self) -> Optional['outputs.ScriptsToExecuteResponse']:
        """
        Customized setup scripts
        """
        return pulumi.get(self, "scripts")


@pulumi.output_type
class SharedPrivateLinkResourceResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groupId":
            suggest = "group_id"
        elif key == "privateLinkResourceId":
            suggest = "private_link_resource_id"
        elif key == "requestMessage":
            suggest = "request_message"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SharedPrivateLinkResourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SharedPrivateLinkResourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SharedPrivateLinkResourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 group_id: Optional[str] = None,
                 name: Optional[str] = None,
                 private_link_resource_id: Optional[str] = None,
                 request_message: Optional[str] = None,
                 status: Optional[str] = None):
        """
        :param str group_id: The private link resource group id.
        :param str name: Unique name of the private link.
        :param str private_link_resource_id: The resource id that private link links to.
        :param str request_message: Request message.
        :param str status: Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
        """
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_link_resource_id is not None:
            pulumi.set(__self__, "private_link_resource_id", private_link_resource_id)
        if request_message is not None:
            pulumi.set(__self__, "request_message", request_message)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[str]:
        """
        The private link resource group id.
        """
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Unique name of the private link.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateLinkResourceId")
    def private_link_resource_id(self) -> Optional[str]:
        """
        The resource id that private link links to.
        """
        return pulumi.get(self, "private_link_resource_id")

    @property
    @pulumi.getter(name="requestMessage")
    def request_message(self) -> Optional[str]:
        """
        Request message.
        """
        return pulumi.get(self, "request_message")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class SkuResponse(dict):
    """
    Sku of the resource
    """
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 tier: Optional[str] = None):
        """
        Sku of the resource
        :param str name: Name of the sku
        :param str tier: Tier of the sku like Basic or Enterprise
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the sku
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tier(self) -> Optional[str]:
        """
        Tier of the sku like Basic or Enterprise
        """
        return pulumi.get(self, "tier")


@pulumi.output_type
class SparkMavenPackageResponse(dict):
    def __init__(__self__, *,
                 artifact: Optional[str] = None,
                 group: Optional[str] = None,
                 version: Optional[str] = None):
        if artifact is not None:
            pulumi.set(__self__, "artifact", artifact)
        if group is not None:
            pulumi.set(__self__, "group", group)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def artifact(self) -> Optional[str]:
        return pulumi.get(self, "artifact")

    @property
    @pulumi.getter
    def group(self) -> Optional[str]:
        return pulumi.get(self, "group")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        return pulumi.get(self, "version")


@pulumi.output_type
class SslConfigurationResponse(dict):
    """
    The ssl configuration for scoring
    """
    def __init__(__self__, *,
                 cert: Optional[str] = None,
                 cname: Optional[str] = None,
                 key: Optional[str] = None,
                 status: Optional[str] = None):
        """
        The ssl configuration for scoring
        :param str cert: Cert data
        :param str cname: CNAME of the cert
        :param str key: Key data
        :param str status: Enable or disable ssl for scoring
        """
        if cert is not None:
            pulumi.set(__self__, "cert", cert)
        if cname is not None:
            pulumi.set(__self__, "cname", cname)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def cert(self) -> Optional[str]:
        """
        Cert data
        """
        return pulumi.get(self, "cert")

    @property
    @pulumi.getter
    def cname(self) -> Optional[str]:
        """
        CNAME of the cert
        """
        return pulumi.get(self, "cname")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        Key data
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Enable or disable ssl for scoring
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class StatusMessageResponse(dict):
    """
    Active message associated with project.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdTimeUtc":
            suggest = "created_time_utc"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StatusMessageResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StatusMessageResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StatusMessageResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 code: str,
                 created_time_utc: str,
                 level: str,
                 message: str):
        """
        Active message associated with project.
        :param str code: Service-defined message code.
        :param str created_time_utc: Time in UTC at which the message was created.
        :param str level: Severity level of the status message.
        :param str message: A human-readable representation of the message code.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "created_time_utc", created_time_utc)
        pulumi.set(__self__, "level", level)
        pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        Service-defined message code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter(name="createdTimeUtc")
    def created_time_utc(self) -> str:
        """
        Time in UTC at which the message was created.
        """
        return pulumi.get(self, "created_time_utc")

    @property
    @pulumi.getter
    def level(self) -> str:
        """
        Severity level of the status message.
        """
        return pulumi.get(self, "level")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        A human-readable representation of the message code.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class SweepJobResponse(dict):
    """
    Sweep job definition.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "interactionEndpoints":
            suggest = "interaction_endpoints"
        elif key == "jobType":
            suggest = "job_type"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "searchSpace":
            suggest = "search_space"
        elif key == "earlyTermination":
            suggest = "early_termination"
        elif key == "experimentName":
            suggest = "experiment_name"
        elif key == "maxConcurrentTrials":
            suggest = "max_concurrent_trials"
        elif key == "maxTotalTrials":
            suggest = "max_total_trials"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SweepJobResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SweepJobResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SweepJobResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 algorithm: str,
                 compute: 'outputs.ComputeConfigurationResponse',
                 interaction_endpoints: Mapping[str, 'outputs.JobEndpointResponse'],
                 job_type: str,
                 objective: 'outputs.ObjectiveResponse',
                 output: 'outputs.JobOutputResponse',
                 provisioning_state: str,
                 search_space: Mapping[str, Any],
                 status: str,
                 description: Optional[str] = None,
                 early_termination: Optional[Any] = None,
                 experiment_name: Optional[str] = None,
                 identity: Optional[Any] = None,
                 max_concurrent_trials: Optional[int] = None,
                 max_total_trials: Optional[int] = None,
                 priority: Optional[int] = None,
                 properties: Optional[Mapping[str, str]] = None,
                 tags: Optional[Mapping[str, str]] = None,
                 timeout: Optional[str] = None,
                 trial: Optional['outputs.TrialComponentResponse'] = None):
        """
        Sweep job definition.
        :param str algorithm: [Required] Type of the hyperparameter sampling algorithms
        :param 'ComputeConfigurationResponse' compute: [Required] Compute binding for the job.
        :param Mapping[str, 'JobEndpointResponse'] interaction_endpoints: List of JobEndpoints.
               For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
        :param str job_type: Enum to determine the type of job.
               Expected value is 'Sweep'.
        :param 'ObjectiveResponse' objective: [Required] Optimization objective.
        :param 'JobOutputResponse' output: Location of the job output logs and artifacts.
        :param str provisioning_state: Specifies the job provisioning state.
        :param Mapping[str, Any] search_space: [Required] A dictionary containing each parameter and its distribution. The dictionary key is the name of the parameter
        :param str status: The status of a job.
        :param str description: The asset description text.
        :param Union['BanditPolicyResponse', 'MedianStoppingPolicyResponse', 'TruncationSelectionPolicyResponse'] early_termination: Early termination policies enable canceling poor-performing runs before they complete.
        :param str experiment_name: The name of the experiment the job belongs to. If not set, the job is placed in the "Default" experiment.
        :param Union['AmlTokenResponse', 'ManagedIdentityResponse'] identity: Identity configuration. If set, this should be one of AmlToken, ManagedIdentity or null.
               Defaults to AmlToken if null.
        :param int max_concurrent_trials: An upper bound on the number of trials performed in parallel.
        :param int max_total_trials: An upper bound on the number of trials to perform.
        :param int priority: Job priority for scheduling policy. Only applies to AMLCompute.
               Private preview feature and only available to users on the allow list.
        :param Mapping[str, str] properties: The asset property dictionary.
        :param Mapping[str, str] tags: Tag dictionary. Tags can be added, removed, and updated.
        :param str timeout: The total timeout in ISO 8601 format. Only supports duration with precision as low as Minutes.
        :param 'TrialComponentResponse' trial: Trial component definition.
        """
        pulumi.set(__self__, "algorithm", algorithm)
        pulumi.set(__self__, "compute", compute)
        pulumi.set(__self__, "interaction_endpoints", interaction_endpoints)
        pulumi.set(__self__, "job_type", 'Sweep')
        pulumi.set(__self__, "objective", objective)
        pulumi.set(__self__, "output", output)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "search_space", search_space)
        pulumi.set(__self__, "status", status)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if early_termination is not None:
            pulumi.set(__self__, "early_termination", early_termination)
        if experiment_name is not None:
            pulumi.set(__self__, "experiment_name", experiment_name)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if max_concurrent_trials is not None:
            pulumi.set(__self__, "max_concurrent_trials", max_concurrent_trials)
        if max_total_trials is not None:
            pulumi.set(__self__, "max_total_trials", max_total_trials)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if trial is not None:
            pulumi.set(__self__, "trial", trial)

    @property
    @pulumi.getter
    def algorithm(self) -> str:
        """
        [Required] Type of the hyperparameter sampling algorithms
        """
        return pulumi.get(self, "algorithm")

    @property
    @pulumi.getter
    def compute(self) -> 'outputs.ComputeConfigurationResponse':
        """
        [Required] Compute binding for the job.
        """
        return pulumi.get(self, "compute")

    @property
    @pulumi.getter(name="interactionEndpoints")
    def interaction_endpoints(self) -> Mapping[str, 'outputs.JobEndpointResponse']:
        """
        List of JobEndpoints.
        For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
        """
        return pulumi.get(self, "interaction_endpoints")

    @property
    @pulumi.getter(name="jobType")
    def job_type(self) -> str:
        """
        Enum to determine the type of job.
        Expected value is 'Sweep'.
        """
        return pulumi.get(self, "job_type")

    @property
    @pulumi.getter
    def objective(self) -> 'outputs.ObjectiveResponse':
        """
        [Required] Optimization objective.
        """
        return pulumi.get(self, "objective")

    @property
    @pulumi.getter
    def output(self) -> 'outputs.JobOutputResponse':
        """
        Location of the job output logs and artifacts.
        """
        return pulumi.get(self, "output")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Specifies the job provisioning state.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="searchSpace")
    def search_space(self) -> Mapping[str, Any]:
        """
        [Required] A dictionary containing each parameter and its distribution. The dictionary key is the name of the parameter
        """
        return pulumi.get(self, "search_space")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of a job.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="earlyTermination")
    def early_termination(self) -> Optional[Any]:
        """
        Early termination policies enable canceling poor-performing runs before they complete.
        """
        return pulumi.get(self, "early_termination")

    @property
    @pulumi.getter(name="experimentName")
    def experiment_name(self) -> Optional[str]:
        """
        The name of the experiment the job belongs to. If not set, the job is placed in the "Default" experiment.
        """
        return pulumi.get(self, "experiment_name")

    @property
    @pulumi.getter
    def identity(self) -> Optional[Any]:
        """
        Identity configuration. If set, this should be one of AmlToken, ManagedIdentity or null.
        Defaults to AmlToken if null.
        """
        return pulumi.get(self, "identity")

    @property
    @pulumi.getter(name="maxConcurrentTrials")
    def max_concurrent_trials(self) -> Optional[int]:
        """
        An upper bound on the number of trials performed in parallel.
        """
        return pulumi.get(self, "max_concurrent_trials")

    @property
    @pulumi.getter(name="maxTotalTrials")
    def max_total_trials(self) -> Optional[int]:
        """
        An upper bound on the number of trials to perform.
        """
        return pulumi.get(self, "max_total_trials")

    @property
    @pulumi.getter
    def priority(self) -> Optional[int]:
        """
        Job priority for scheduling policy. Only applies to AMLCompute.
        Private preview feature and only available to users on the allow list.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[str]:
        """
        The total timeout in ISO 8601 format. Only supports duration with precision as low as Minutes.
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter
    def trial(self) -> Optional['outputs.TrialComponentResponse']:
        """
        Trial component definition.
        """
        return pulumi.get(self, "trial")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Read only system data
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Read only system data
        :param str created_at: The timestamp of resource creation (UTC)
        :param str created_by: An identifier for the identity that created the resource
        :param str created_by_type: The type of identity that created the resource
        :param str last_modified_at: The timestamp of resource last modification (UTC)
        :param str last_modified_by: An identifier for the identity that last modified the resource
        :param str last_modified_by_type: The type of identity that last modified the resource
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC)
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        An identifier for the identity that created the resource
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The timestamp of resource last modification (UTC)
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        An identifier for the identity that last modified the resource
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource
        """
        return pulumi.get(self, "last_modified_by_type")


@pulumi.output_type
class SystemServiceResponse(dict):
    """
    A system service running on a compute.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicIpAddress":
            suggest = "public_ip_address"
        elif key == "systemServiceType":
            suggest = "system_service_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemServiceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemServiceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemServiceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 public_ip_address: str,
                 system_service_type: str,
                 version: str):
        """
        A system service running on a compute.
        :param str public_ip_address: Public IP address
        :param str system_service_type: The type of this system service.
        :param str version: The version for this type.
        """
        pulumi.set(__self__, "public_ip_address", public_ip_address)
        pulumi.set(__self__, "system_service_type", system_service_type)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="publicIpAddress")
    def public_ip_address(self) -> str:
        """
        Public IP address
        """
        return pulumi.get(self, "public_ip_address")

    @property
    @pulumi.getter(name="systemServiceType")
    def system_service_type(self) -> str:
        """
        The type of this system service.
        """
        return pulumi.get(self, "system_service_type")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        The version for this type.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class TensorFlowResponse(dict):
    """
    TensorFlow distribution configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "distributionType":
            suggest = "distribution_type"
        elif key == "parameterServerCount":
            suggest = "parameter_server_count"
        elif key == "workerCount":
            suggest = "worker_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TensorFlowResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TensorFlowResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TensorFlowResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 distribution_type: str,
                 parameter_server_count: Optional[int] = None,
                 worker_count: Optional[int] = None):
        """
        TensorFlow distribution configuration.
        :param str distribution_type: Enum to determine the job distribution type.
               Expected value is 'TensorFlow'.
        :param int parameter_server_count: Number of parameter server tasks.
        :param int worker_count: Number of workers. Overwrites the node count in compute binding.
        """
        pulumi.set(__self__, "distribution_type", 'TensorFlow')
        if parameter_server_count is not None:
            pulumi.set(__self__, "parameter_server_count", parameter_server_count)
        if worker_count is not None:
            pulumi.set(__self__, "worker_count", worker_count)

    @property
    @pulumi.getter(name="distributionType")
    def distribution_type(self) -> str:
        """
        Enum to determine the job distribution type.
        Expected value is 'TensorFlow'.
        """
        return pulumi.get(self, "distribution_type")

    @property
    @pulumi.getter(name="parameterServerCount")
    def parameter_server_count(self) -> Optional[int]:
        """
        Number of parameter server tasks.
        """
        return pulumi.get(self, "parameter_server_count")

    @property
    @pulumi.getter(name="workerCount")
    def worker_count(self) -> Optional[int]:
        """
        Number of workers. Overwrites the node count in compute binding.
        """
        return pulumi.get(self, "worker_count")


@pulumi.output_type
class TrialComponentResponse(dict):
    """
    Trial component definition.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "codeId":
            suggest = "code_id"
        elif key == "environmentId":
            suggest = "environment_id"
        elif key == "environmentVariables":
            suggest = "environment_variables"
        elif key == "inputDataBindings":
            suggest = "input_data_bindings"
        elif key == "outputDataBindings":
            suggest = "output_data_bindings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TrialComponentResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TrialComponentResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TrialComponentResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 command: str,
                 code_id: Optional[str] = None,
                 distribution: Optional[Any] = None,
                 environment_id: Optional[str] = None,
                 environment_variables: Optional[Mapping[str, str]] = None,
                 input_data_bindings: Optional[Mapping[str, 'outputs.InputDataBindingResponse']] = None,
                 output_data_bindings: Optional[Mapping[str, 'outputs.OutputDataBindingResponse']] = None,
                 timeout: Optional[str] = None):
        """
        Trial component definition.
        :param str command: [Required] The command to execute on startup of the job. eg. "python train.py"
        :param str code_id: ARM resource ID of the code asset.
        :param Union['MpiResponse', 'PyTorchResponse', 'TensorFlowResponse'] distribution: Distribution configuration of the job. If set, this should be one of Mpi, Tensorflow, PyTorch, or null.
        :param str environment_id: The ARM resource ID of the Environment specification for the job.
        :param Mapping[str, str] environment_variables: Environment variables included in the job.
        :param Mapping[str, 'InputDataBindingResponse'] input_data_bindings: Mapping of input data bindings used in the job.
        :param Mapping[str, 'OutputDataBindingResponse'] output_data_bindings: Mapping of output data bindings used in the job.
        :param str timeout: The max run duration in ISO 8601 format, after which the trial component will be cancelled.
               Only supports duration with precision as low as Seconds.
        """
        pulumi.set(__self__, "command", command)
        if code_id is not None:
            pulumi.set(__self__, "code_id", code_id)
        if distribution is not None:
            pulumi.set(__self__, "distribution", distribution)
        if environment_id is not None:
            pulumi.set(__self__, "environment_id", environment_id)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if input_data_bindings is not None:
            pulumi.set(__self__, "input_data_bindings", input_data_bindings)
        if output_data_bindings is not None:
            pulumi.set(__self__, "output_data_bindings", output_data_bindings)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter
    def command(self) -> str:
        """
        [Required] The command to execute on startup of the job. eg. "python train.py"
        """
        return pulumi.get(self, "command")

    @property
    @pulumi.getter(name="codeId")
    def code_id(self) -> Optional[str]:
        """
        ARM resource ID of the code asset.
        """
        return pulumi.get(self, "code_id")

    @property
    @pulumi.getter
    def distribution(self) -> Optional[Any]:
        """
        Distribution configuration of the job. If set, this should be one of Mpi, Tensorflow, PyTorch, or null.
        """
        return pulumi.get(self, "distribution")

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> Optional[str]:
        """
        The ARM resource ID of the Environment specification for the job.
        """
        return pulumi.get(self, "environment_id")

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[Mapping[str, str]]:
        """
        Environment variables included in the job.
        """
        return pulumi.get(self, "environment_variables")

    @property
    @pulumi.getter(name="inputDataBindings")
    def input_data_bindings(self) -> Optional[Mapping[str, 'outputs.InputDataBindingResponse']]:
        """
        Mapping of input data bindings used in the job.
        """
        return pulumi.get(self, "input_data_bindings")

    @property
    @pulumi.getter(name="outputDataBindings")
    def output_data_bindings(self) -> Optional[Mapping[str, 'outputs.OutputDataBindingResponse']]:
        """
        Mapping of output data bindings used in the job.
        """
        return pulumi.get(self, "output_data_bindings")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[str]:
        """
        The max run duration in ISO 8601 format, after which the trial component will be cancelled.
        Only supports duration with precision as low as Seconds.
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class TruncationSelectionPolicyResponse(dict):
    """
    Defines an early termination policy that cancels a given percentage of runs at each evaluation interval.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "policyType":
            suggest = "policy_type"
        elif key == "delayEvaluation":
            suggest = "delay_evaluation"
        elif key == "evaluationInterval":
            suggest = "evaluation_interval"
        elif key == "truncationPercentage":
            suggest = "truncation_percentage"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TruncationSelectionPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TruncationSelectionPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TruncationSelectionPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 policy_type: str,
                 delay_evaluation: Optional[int] = None,
                 evaluation_interval: Optional[int] = None,
                 truncation_percentage: Optional[int] = None):
        """
        Defines an early termination policy that cancels a given percentage of runs at each evaluation interval.
        :param str policy_type: 
               Expected value is 'TruncationSelection'.
        :param int delay_evaluation: Number of intervals by which to delay the first evaluation.
        :param int evaluation_interval: Interval (number of runs) between policy evaluations.
        :param int truncation_percentage: The percentage of runs to cancel at each evaluation interval.
        """
        pulumi.set(__self__, "policy_type", 'TruncationSelection')
        if delay_evaluation is not None:
            pulumi.set(__self__, "delay_evaluation", delay_evaluation)
        if evaluation_interval is not None:
            pulumi.set(__self__, "evaluation_interval", evaluation_interval)
        if truncation_percentage is not None:
            pulumi.set(__self__, "truncation_percentage", truncation_percentage)

    @property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> str:
        """

        Expected value is 'TruncationSelection'.
        """
        return pulumi.get(self, "policy_type")

    @property
    @pulumi.getter(name="delayEvaluation")
    def delay_evaluation(self) -> Optional[int]:
        """
        Number of intervals by which to delay the first evaluation.
        """
        return pulumi.get(self, "delay_evaluation")

    @property
    @pulumi.getter(name="evaluationInterval")
    def evaluation_interval(self) -> Optional[int]:
        """
        Interval (number of runs) between policy evaluations.
        """
        return pulumi.get(self, "evaluation_interval")

    @property
    @pulumi.getter(name="truncationPercentage")
    def truncation_percentage(self) -> Optional[int]:
        """
        The percentage of runs to cancel at each evaluation interval.
        """
        return pulumi.get(self, "truncation_percentage")


@pulumi.output_type
class UserAccountCredentialsResponse(dict):
    """
    Settings for user account that gets created on each on the nodes of a compute.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adminUserName":
            suggest = "admin_user_name"
        elif key == "adminUserPassword":
            suggest = "admin_user_password"
        elif key == "adminUserSshPublicKey":
            suggest = "admin_user_ssh_public_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserAccountCredentialsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserAccountCredentialsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserAccountCredentialsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 admin_user_name: str,
                 admin_user_password: Optional[str] = None,
                 admin_user_ssh_public_key: Optional[str] = None):
        """
        Settings for user account that gets created on each on the nodes of a compute.
        :param str admin_user_name: Name of the administrator user account which can be used to SSH to nodes.
        :param str admin_user_password: Password of the administrator user account.
        :param str admin_user_ssh_public_key: SSH public key of the administrator user account.
        """
        pulumi.set(__self__, "admin_user_name", admin_user_name)
        if admin_user_password is not None:
            pulumi.set(__self__, "admin_user_password", admin_user_password)
        if admin_user_ssh_public_key is not None:
            pulumi.set(__self__, "admin_user_ssh_public_key", admin_user_ssh_public_key)

    @property
    @pulumi.getter(name="adminUserName")
    def admin_user_name(self) -> str:
        """
        Name of the administrator user account which can be used to SSH to nodes.
        """
        return pulumi.get(self, "admin_user_name")

    @property
    @pulumi.getter(name="adminUserPassword")
    def admin_user_password(self) -> Optional[str]:
        """
        Password of the administrator user account.
        """
        return pulumi.get(self, "admin_user_password")

    @property
    @pulumi.getter(name="adminUserSshPublicKey")
    def admin_user_ssh_public_key(self) -> Optional[str]:
        """
        SSH public key of the administrator user account.
        """
        return pulumi.get(self, "admin_user_ssh_public_key")


@pulumi.output_type
class UserAssignedIdentityMetaResponse(dict):
    """
    User assigned identities associated with a resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "principalId":
            suggest = "principal_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserAssignedIdentityMetaResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserAssignedIdentityMetaResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserAssignedIdentityMetaResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: Optional[str] = None,
                 principal_id: Optional[str] = None):
        """
        User assigned identities associated with a resource.
        :param str client_id: Aka application ID, a unique identifier generated by Azure AD that is tied to an application and service principal during its initial provisioning.
        :param str principal_id: The object ID of the service principal object for your managed identity that is used to grant role-based access to an Azure resource.
        """
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[str]:
        """
        Aka application ID, a unique identifier generated by Azure AD that is tied to an application and service principal during its initial provisioning.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[str]:
        """
        The object ID of the service principal object for your managed identity that is used to grant role-based access to an Azure resource.
        """
        return pulumi.get(self, "principal_id")


@pulumi.output_type
class UserAssignedIdentityResponse(dict):
    """
    User Assigned Identity
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserAssignedIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserAssignedIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserAssignedIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: str,
                 principal_id: str,
                 tenant_id: str):
        """
        User Assigned Identity
        :param str client_id: The clientId(aka appId) of the user assigned identity.
        :param str principal_id: The principal ID of the user assigned identity.
        :param str tenant_id: The tenant ID of the user assigned identity.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        """
        The clientId(aka appId) of the user assigned identity.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal ID of the user assigned identity.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The tenant ID of the user assigned identity.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class UserInfoResponse(dict):
    """
    User who created.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userAltSecId":
            suggest = "user_alt_sec_id"
        elif key == "userIdp":
            suggest = "user_idp"
        elif key == "userIss":
            suggest = "user_iss"
        elif key == "userName":
            suggest = "user_name"
        elif key == "userObjectId":
            suggest = "user_object_id"
        elif key == "userPuId":
            suggest = "user_pu_id"
        elif key == "userTenantId":
            suggest = "user_tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 user_alt_sec_id: Optional[str] = None,
                 user_idp: Optional[str] = None,
                 user_iss: Optional[str] = None,
                 user_name: Optional[str] = None,
                 user_object_id: Optional[str] = None,
                 user_pu_id: Optional[str] = None,
                 user_tenant_id: Optional[str] = None):
        """
        User who created.
        :param str user_alt_sec_id: A user alternate sec id. This represents the user in a different identity provider system Eg.1:live.com:puid
        :param str user_idp: A user identity provider. Eg live.com
        :param str user_iss: The issuer which issued the token for this user.
        :param str user_name:  A user's full name or a service principal's app ID.
        :param str user_object_id: A user or service principal's object ID..
        :param str user_pu_id: A user or service principal's PuID.
        :param str user_tenant_id: A user or service principal's tenant ID.
        """
        if user_alt_sec_id is not None:
            pulumi.set(__self__, "user_alt_sec_id", user_alt_sec_id)
        if user_idp is not None:
            pulumi.set(__self__, "user_idp", user_idp)
        if user_iss is not None:
            pulumi.set(__self__, "user_iss", user_iss)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)
        if user_object_id is not None:
            pulumi.set(__self__, "user_object_id", user_object_id)
        if user_pu_id is not None:
            pulumi.set(__self__, "user_pu_id", user_pu_id)
        if user_tenant_id is not None:
            pulumi.set(__self__, "user_tenant_id", user_tenant_id)

    @property
    @pulumi.getter(name="userAltSecId")
    def user_alt_sec_id(self) -> Optional[str]:
        """
        A user alternate sec id. This represents the user in a different identity provider system Eg.1:live.com:puid
        """
        return pulumi.get(self, "user_alt_sec_id")

    @property
    @pulumi.getter(name="userIdp")
    def user_idp(self) -> Optional[str]:
        """
        A user identity provider. Eg live.com
        """
        return pulumi.get(self, "user_idp")

    @property
    @pulumi.getter(name="userIss")
    def user_iss(self) -> Optional[str]:
        """
        The issuer which issued the token for this user.
        """
        return pulumi.get(self, "user_iss")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[str]:
        """
         A user's full name or a service principal's app ID.
        """
        return pulumi.get(self, "user_name")

    @property
    @pulumi.getter(name="userObjectId")
    def user_object_id(self) -> Optional[str]:
        """
        A user or service principal's object ID..
        """
        return pulumi.get(self, "user_object_id")

    @property
    @pulumi.getter(name="userPuId")
    def user_pu_id(self) -> Optional[str]:
        """
        A user or service principal's PuID.
        """
        return pulumi.get(self, "user_pu_id")

    @property
    @pulumi.getter(name="userTenantId")
    def user_tenant_id(self) -> Optional[str]:
        """
        A user or service principal's tenant ID.
        """
        return pulumi.get(self, "user_tenant_id")


@pulumi.output_type
class VirtualMachineImageResponse(dict):
    """
    Virtual Machine image for Windows AML Compute
    """
    def __init__(__self__, *,
                 id: str):
        """
        Virtual Machine image for Windows AML Compute
        :param str id: Virtual Machine image path
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Virtual Machine image path
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class VirtualMachineResponse(dict):
    """
    A Machine Learning compute based on Azure Virtual Machines.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computeType":
            suggest = "compute_type"
        elif key == "isAttachedCompute":
            suggest = "is_attached_compute"
        elif key == "provisioningErrors":
            suggest = "provisioning_errors"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "computeLocation":
            suggest = "compute_location"
        elif key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compute_type: str,
                 is_attached_compute: bool,
                 provisioning_errors: Sequence['outputs.MachineLearningServiceErrorResponse'],
                 provisioning_state: str,
                 compute_location: Optional[str] = None,
                 description: Optional[str] = None,
                 properties: Optional['outputs.VirtualMachineResponseProperties'] = None,
                 resource_id: Optional[str] = None):
        """
        A Machine Learning compute based on Azure Virtual Machines.
        :param str compute_type: The type of compute
               Expected value is 'VirtualMachine'.
        :param bool is_attached_compute: Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
        :param Sequence['MachineLearningServiceErrorResponse'] provisioning_errors: Errors during provisioning
        :param str provisioning_state: The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        :param str compute_location: Location for the underlying compute
        :param str description: The description of the Machine Learning compute.
        :param str resource_id: ARM resource id of the underlying compute
        """
        pulumi.set(__self__, "compute_type", 'VirtualMachine')
        pulumi.set(__self__, "is_attached_compute", is_attached_compute)
        pulumi.set(__self__, "provisioning_errors", provisioning_errors)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> str:
        """
        The type of compute
        Expected value is 'VirtualMachine'.
        """
        return pulumi.get(self, "compute_type")

    @property
    @pulumi.getter(name="isAttachedCompute")
    def is_attached_compute(self) -> bool:
        """
        Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
        """
        return pulumi.get(self, "is_attached_compute")

    @property
    @pulumi.getter(name="provisioningErrors")
    def provisioning_errors(self) -> Sequence['outputs.MachineLearningServiceErrorResponse']:
        """
        Errors during provisioning
        """
        return pulumi.get(self, "provisioning_errors")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[str]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.VirtualMachineResponseProperties']:
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        ARM resource id of the underlying compute
        """
        return pulumi.get(self, "resource_id")


@pulumi.output_type
class VirtualMachineResponseProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "administratorAccount":
            suggest = "administrator_account"
        elif key == "sshPort":
            suggest = "ssh_port"
        elif key == "virtualMachineSize":
            suggest = "virtual_machine_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineResponseProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineResponseProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineResponseProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: Optional[str] = None,
                 administrator_account: Optional['outputs.VirtualMachineSshCredentialsResponse'] = None,
                 ssh_port: Optional[int] = None,
                 virtual_machine_size: Optional[str] = None):
        """
        :param str address: Public IP address of the virtual machine.
        :param 'VirtualMachineSshCredentialsResponse' administrator_account: Admin credentials for virtual machine
        :param int ssh_port: Port open for ssh connections.
        :param str virtual_machine_size: Virtual Machine size
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if administrator_account is not None:
            pulumi.set(__self__, "administrator_account", administrator_account)
        if ssh_port is not None:
            pulumi.set(__self__, "ssh_port", ssh_port)
        if virtual_machine_size is not None:
            pulumi.set(__self__, "virtual_machine_size", virtual_machine_size)

    @property
    @pulumi.getter
    def address(self) -> Optional[str]:
        """
        Public IP address of the virtual machine.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="administratorAccount")
    def administrator_account(self) -> Optional['outputs.VirtualMachineSshCredentialsResponse']:
        """
        Admin credentials for virtual machine
        """
        return pulumi.get(self, "administrator_account")

    @property
    @pulumi.getter(name="sshPort")
    def ssh_port(self) -> Optional[int]:
        """
        Port open for ssh connections.
        """
        return pulumi.get(self, "ssh_port")

    @property
    @pulumi.getter(name="virtualMachineSize")
    def virtual_machine_size(self) -> Optional[str]:
        """
        Virtual Machine size
        """
        return pulumi.get(self, "virtual_machine_size")


@pulumi.output_type
class VirtualMachineSshCredentialsResponse(dict):
    """
    Admin credentials for virtual machine
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateKeyData":
            suggest = "private_key_data"
        elif key == "publicKeyData":
            suggest = "public_key_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineSshCredentialsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineSshCredentialsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineSshCredentialsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 password: Optional[str] = None,
                 private_key_data: Optional[str] = None,
                 public_key_data: Optional[str] = None,
                 username: Optional[str] = None):
        """
        Admin credentials for virtual machine
        :param str password: Password of admin account
        :param str private_key_data: Private key data
        :param str public_key_data: Public key data
        :param str username: Username of admin account
        """
        if password is not None:
            pulumi.set(__self__, "password", password)
        if private_key_data is not None:
            pulumi.set(__self__, "private_key_data", private_key_data)
        if public_key_data is not None:
            pulumi.set(__self__, "public_key_data", public_key_data)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        Password of admin account
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="privateKeyData")
    def private_key_data(self) -> Optional[str]:
        """
        Private key data
        """
        return pulumi.get(self, "private_key_data")

    @property
    @pulumi.getter(name="publicKeyData")
    def public_key_data(self) -> Optional[str]:
        """
        Public key data
        """
        return pulumi.get(self, "public_key_data")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        Username of admin account
        """
        return pulumi.get(self, "username")


