# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from ._enums import *

__all__ = [
    'AutoShutdownProfileArgs',
    'ConnectionProfileArgs',
    'LabPlanNetworkProfileArgs',
    'RecurrencePatternArgs',
    'ReferenceVmArgs',
    'ResourceSettingsArgs',
    'ResourceSetArgs',
    'SupportInfoArgs',
]

@pulumi.input_type
class AutoShutdownProfileArgs:
    def __init__(__self__, *,
                 disconnect_delay: Optional[pulumi.Input[str]] = None,
                 idle_delay: Optional[pulumi.Input[str]] = None,
                 no_connect_delay: Optional[pulumi.Input[str]] = None,
                 shutdown_on_disconnect: Optional[pulumi.Input['EnableState']] = None,
                 shutdown_on_idle: Optional[pulumi.Input['ShutdownOnIdleMode']] = None,
                 shutdown_when_not_connected: Optional[pulumi.Input['EnableState']] = None):
        """
        Profile for how to handle shutting down virtual machines.
        :param pulumi.Input[str] disconnect_delay: The amount of time a VM will stay running after a user disconnects if this behavior is enabled.
        :param pulumi.Input[str] idle_delay: The amount of time a VM will idle before it is shutdown if this behavior is enabled.
        :param pulumi.Input[str] no_connect_delay: The amount of time a VM will stay running before it is shutdown if no connection is made and this behavior is enabled.
        :param pulumi.Input['EnableState'] shutdown_on_disconnect: Whether shutdown on disconnect is enabled
        :param pulumi.Input['ShutdownOnIdleMode'] shutdown_on_idle: Whether a VM will get shutdown when it has idled for a period of time.
        :param pulumi.Input['EnableState'] shutdown_when_not_connected: Whether a VM will get shutdown when it hasn't been connected to after a period of time.
        """
        if disconnect_delay is not None:
            pulumi.set(__self__, "disconnect_delay", disconnect_delay)
        if idle_delay is not None:
            pulumi.set(__self__, "idle_delay", idle_delay)
        if no_connect_delay is not None:
            pulumi.set(__self__, "no_connect_delay", no_connect_delay)
        if shutdown_on_disconnect is None:
            shutdown_on_disconnect = 'Disabled'
        if shutdown_on_disconnect is not None:
            pulumi.set(__self__, "shutdown_on_disconnect", shutdown_on_disconnect)
        if shutdown_on_idle is None:
            shutdown_on_idle = 'None'
        if shutdown_on_idle is not None:
            pulumi.set(__self__, "shutdown_on_idle", shutdown_on_idle)
        if shutdown_when_not_connected is None:
            shutdown_when_not_connected = 'Disabled'
        if shutdown_when_not_connected is not None:
            pulumi.set(__self__, "shutdown_when_not_connected", shutdown_when_not_connected)

    @property
    @pulumi.getter(name="disconnectDelay")
    def disconnect_delay(self) -> Optional[pulumi.Input[str]]:
        """
        The amount of time a VM will stay running after a user disconnects if this behavior is enabled.
        """
        return pulumi.get(self, "disconnect_delay")

    @disconnect_delay.setter
    def disconnect_delay(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disconnect_delay", value)

    @property
    @pulumi.getter(name="idleDelay")
    def idle_delay(self) -> Optional[pulumi.Input[str]]:
        """
        The amount of time a VM will idle before it is shutdown if this behavior is enabled.
        """
        return pulumi.get(self, "idle_delay")

    @idle_delay.setter
    def idle_delay(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "idle_delay", value)

    @property
    @pulumi.getter(name="noConnectDelay")
    def no_connect_delay(self) -> Optional[pulumi.Input[str]]:
        """
        The amount of time a VM will stay running before it is shutdown if no connection is made and this behavior is enabled.
        """
        return pulumi.get(self, "no_connect_delay")

    @no_connect_delay.setter
    def no_connect_delay(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "no_connect_delay", value)

    @property
    @pulumi.getter(name="shutdownOnDisconnect")
    def shutdown_on_disconnect(self) -> Optional[pulumi.Input['EnableState']]:
        """
        Whether shutdown on disconnect is enabled
        """
        return pulumi.get(self, "shutdown_on_disconnect")

    @shutdown_on_disconnect.setter
    def shutdown_on_disconnect(self, value: Optional[pulumi.Input['EnableState']]):
        pulumi.set(self, "shutdown_on_disconnect", value)

    @property
    @pulumi.getter(name="shutdownOnIdle")
    def shutdown_on_idle(self) -> Optional[pulumi.Input['ShutdownOnIdleMode']]:
        """
        Whether a VM will get shutdown when it has idled for a period of time.
        """
        return pulumi.get(self, "shutdown_on_idle")

    @shutdown_on_idle.setter
    def shutdown_on_idle(self, value: Optional[pulumi.Input['ShutdownOnIdleMode']]):
        pulumi.set(self, "shutdown_on_idle", value)

    @property
    @pulumi.getter(name="shutdownWhenNotConnected")
    def shutdown_when_not_connected(self) -> Optional[pulumi.Input['EnableState']]:
        """
        Whether a VM will get shutdown when it hasn't been connected to after a period of time.
        """
        return pulumi.get(self, "shutdown_when_not_connected")

    @shutdown_when_not_connected.setter
    def shutdown_when_not_connected(self, value: Optional[pulumi.Input['EnableState']]):
        pulumi.set(self, "shutdown_when_not_connected", value)


@pulumi.input_type
class ConnectionProfileArgs:
    def __init__(__self__, *,
                 client_rdp_access: Optional[pulumi.Input['ConnectionType']] = None,
                 client_ssh_access: Optional[pulumi.Input['ConnectionType']] = None,
                 web_rdp_access: Optional[pulumi.Input['ConnectionType']] = None,
                 web_ssh_access: Optional[pulumi.Input['ConnectionType']] = None):
        """
        Connection profile for how users connect to lab virtual machines.
        :param pulumi.Input['ConnectionType'] client_rdp_access: The enabled access level for Client Access over RDP.
        :param pulumi.Input['ConnectionType'] client_ssh_access: The enabled access level for Client Access over SSH.
        :param pulumi.Input['ConnectionType'] web_rdp_access: The enabled access level for Web Access over RDP.
        :param pulumi.Input['ConnectionType'] web_ssh_access: The enabled access level for Web Access over SSH.
        """
        if client_rdp_access is None:
            client_rdp_access = 'None'
        if client_rdp_access is not None:
            pulumi.set(__self__, "client_rdp_access", client_rdp_access)
        if client_ssh_access is None:
            client_ssh_access = 'None'
        if client_ssh_access is not None:
            pulumi.set(__self__, "client_ssh_access", client_ssh_access)
        if web_rdp_access is None:
            web_rdp_access = 'None'
        if web_rdp_access is not None:
            pulumi.set(__self__, "web_rdp_access", web_rdp_access)
        if web_ssh_access is None:
            web_ssh_access = 'None'
        if web_ssh_access is not None:
            pulumi.set(__self__, "web_ssh_access", web_ssh_access)

    @property
    @pulumi.getter(name="clientRdpAccess")
    def client_rdp_access(self) -> Optional[pulumi.Input['ConnectionType']]:
        """
        The enabled access level for Client Access over RDP.
        """
        return pulumi.get(self, "client_rdp_access")

    @client_rdp_access.setter
    def client_rdp_access(self, value: Optional[pulumi.Input['ConnectionType']]):
        pulumi.set(self, "client_rdp_access", value)

    @property
    @pulumi.getter(name="clientSshAccess")
    def client_ssh_access(self) -> Optional[pulumi.Input['ConnectionType']]:
        """
        The enabled access level for Client Access over SSH.
        """
        return pulumi.get(self, "client_ssh_access")

    @client_ssh_access.setter
    def client_ssh_access(self, value: Optional[pulumi.Input['ConnectionType']]):
        pulumi.set(self, "client_ssh_access", value)

    @property
    @pulumi.getter(name="webRdpAccess")
    def web_rdp_access(self) -> Optional[pulumi.Input['ConnectionType']]:
        """
        The enabled access level for Web Access over RDP.
        """
        return pulumi.get(self, "web_rdp_access")

    @web_rdp_access.setter
    def web_rdp_access(self, value: Optional[pulumi.Input['ConnectionType']]):
        pulumi.set(self, "web_rdp_access", value)

    @property
    @pulumi.getter(name="webSshAccess")
    def web_ssh_access(self) -> Optional[pulumi.Input['ConnectionType']]:
        """
        The enabled access level for Web Access over SSH.
        """
        return pulumi.get(self, "web_ssh_access")

    @web_ssh_access.setter
    def web_ssh_access(self, value: Optional[pulumi.Input['ConnectionType']]):
        pulumi.set(self, "web_ssh_access", value)


@pulumi.input_type
class LabPlanNetworkProfileArgs:
    def __init__(__self__, *,
                 subnet_id: Optional[pulumi.Input[str]] = None):
        """
        Profile for how to handle networking for Lab Plans.
        :param pulumi.Input[str] subnet_id: The external subnet resource id
        """
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        The external subnet resource id
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)


@pulumi.input_type
class RecurrencePatternArgs:
    def __init__(__self__, *,
                 expiration_date: pulumi.Input[str],
                 frequency: pulumi.Input['RecurrenceFrequency'],
                 interval: Optional[pulumi.Input[int]] = None,
                 week_days: Optional[pulumi.Input[Sequence[pulumi.Input['WeekDay']]]] = None):
        """
        Recurrence pattern of a lab schedule.
        :param pulumi.Input[str] expiration_date: When the recurrence will expire. This date is inclusive.
        :param pulumi.Input['RecurrenceFrequency'] frequency: The frequency of the recurrence.
        :param pulumi.Input[int] interval: The interval to invoke the schedule on. For example, interval = 2 and RecurrenceFrequency.Daily will run every 2 days. When no interval is supplied, an interval of 1 is used.
        :param pulumi.Input[Sequence[pulumi.Input['WeekDay']]] week_days: The week days the schedule runs. Used for when the Frequency is set to Weekly.
        """
        pulumi.set(__self__, "expiration_date", expiration_date)
        pulumi.set(__self__, "frequency", frequency)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if week_days is not None:
            pulumi.set(__self__, "week_days", week_days)

    @property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> pulumi.Input[str]:
        """
        When the recurrence will expire. This date is inclusive.
        """
        return pulumi.get(self, "expiration_date")

    @expiration_date.setter
    def expiration_date(self, value: pulumi.Input[str]):
        pulumi.set(self, "expiration_date", value)

    @property
    @pulumi.getter
    def frequency(self) -> pulumi.Input['RecurrenceFrequency']:
        """
        The frequency of the recurrence.
        """
        return pulumi.get(self, "frequency")

    @frequency.setter
    def frequency(self, value: pulumi.Input['RecurrenceFrequency']):
        pulumi.set(self, "frequency", value)

    @property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[int]]:
        """
        The interval to invoke the schedule on. For example, interval = 2 and RecurrenceFrequency.Daily will run every 2 days. When no interval is supplied, an interval of 1 is used.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "interval", value)

    @property
    @pulumi.getter(name="weekDays")
    def week_days(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WeekDay']]]]:
        """
        The week days the schedule runs. Used for when the Frequency is set to Weekly.
        """
        return pulumi.get(self, "week_days")

    @week_days.setter
    def week_days(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WeekDay']]]]):
        pulumi.set(self, "week_days", value)


@pulumi.input_type
class ReferenceVmArgs:
    def __init__(__self__, *,
                 user_name: pulumi.Input[str],
                 password: Optional[pulumi.Input[str]] = None):
        """
        Details of a Reference Vm
        :param pulumi.Input[str] user_name: The username of the virtual machine
        :param pulumi.Input[str] password: The password of the virtual machine. This will be set to null in GET resource API
        """
        pulumi.set(__self__, "user_name", user_name)
        if password is not None:
            pulumi.set(__self__, "password", password)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Input[str]:
        """
        The username of the virtual machine
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "user_name", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The password of the virtual machine. This will be set to null in GET resource API
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)


@pulumi.input_type
class ResourceSettingsArgs:
    def __init__(__self__, *,
                 reference_vm: pulumi.Input['ReferenceVmArgs'],
                 gallery_image_resource_id: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[Union[str, 'ManagedLabVmSize']]] = None):
        """
        Represents resource specific settings
        :param pulumi.Input['ReferenceVmArgs'] reference_vm: Details specific to Reference Vm
        :param pulumi.Input[str] gallery_image_resource_id: The resource id of the gallery image used for creating the virtual machine
        :param pulumi.Input[Union[str, 'ManagedLabVmSize']] size: The size of the virtual machine
        """
        pulumi.set(__self__, "reference_vm", reference_vm)
        if gallery_image_resource_id is not None:
            pulumi.set(__self__, "gallery_image_resource_id", gallery_image_resource_id)
        if size is not None:
            pulumi.set(__self__, "size", size)

    @property
    @pulumi.getter(name="referenceVm")
    def reference_vm(self) -> pulumi.Input['ReferenceVmArgs']:
        """
        Details specific to Reference Vm
        """
        return pulumi.get(self, "reference_vm")

    @reference_vm.setter
    def reference_vm(self, value: pulumi.Input['ReferenceVmArgs']):
        pulumi.set(self, "reference_vm", value)

    @property
    @pulumi.getter(name="galleryImageResourceId")
    def gallery_image_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The resource id of the gallery image used for creating the virtual machine
        """
        return pulumi.get(self, "gallery_image_resource_id")

    @gallery_image_resource_id.setter
    def gallery_image_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gallery_image_resource_id", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[Union[str, 'ManagedLabVmSize']]]:
        """
        The size of the virtual machine
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[Union[str, 'ManagedLabVmSize']]]):
        pulumi.set(self, "size", value)


@pulumi.input_type
class ResourceSetArgs:
    def __init__(__self__, *,
                 resource_setting_id: Optional[pulumi.Input[str]] = None,
                 vm_resource_id: Optional[pulumi.Input[str]] = None):
        """
        Represents a VM and the setting Id it was created for.
        :param pulumi.Input[str] resource_setting_id: resourceSettingId for the environment
        :param pulumi.Input[str] vm_resource_id: VM resource Id for the environment
        """
        if resource_setting_id is not None:
            pulumi.set(__self__, "resource_setting_id", resource_setting_id)
        if vm_resource_id is not None:
            pulumi.set(__self__, "vm_resource_id", vm_resource_id)

    @property
    @pulumi.getter(name="resourceSettingId")
    def resource_setting_id(self) -> Optional[pulumi.Input[str]]:
        """
        resourceSettingId for the environment
        """
        return pulumi.get(self, "resource_setting_id")

    @resource_setting_id.setter
    def resource_setting_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_setting_id", value)

    @property
    @pulumi.getter(name="vmResourceId")
    def vm_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        VM resource Id for the environment
        """
        return pulumi.get(self, "vm_resource_id")

    @vm_resource_id.setter
    def vm_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vm_resource_id", value)


@pulumi.input_type
class SupportInfoArgs:
    def __init__(__self__, *,
                 email: Optional[pulumi.Input[str]] = None,
                 instructions: Optional[pulumi.Input[str]] = None,
                 phone: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None):
        """
        Support contact information and instructions.
        :param pulumi.Input[str] email: Support contact email address.
        :param pulumi.Input[str] instructions: Support instructions.
        :param pulumi.Input[str] phone: Support contact phone number.
        :param pulumi.Input[str] url: Support web address.
        """
        if email is not None:
            pulumi.set(__self__, "email", email)
        if instructions is not None:
            pulumi.set(__self__, "instructions", instructions)
        if phone is not None:
            pulumi.set(__self__, "phone", phone)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[str]]:
        """
        Support contact email address.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter
    def instructions(self) -> Optional[pulumi.Input[str]]:
        """
        Support instructions.
        """
        return pulumi.get(self, "instructions")

    @instructions.setter
    def instructions(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instructions", value)

    @property
    @pulumi.getter
    def phone(self) -> Optional[pulumi.Input[str]]:
        """
        Support contact phone number.
        """
        return pulumi.get(self, "phone")

    @phone.setter
    def phone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "phone", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        Support web address.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)


