# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ComplianceStatusResponse',
    'DependsOnDefinitionResponse',
    'ErrorAdditionalInfoResponse',
    'ErrorDetailResponse',
    'ExtensionResponseAksAssignedIdentity',
    'ExtensionStatusResponse',
    'GitRepositoryDefinitionResponse',
    'HelmOperatorPropertiesResponse',
    'HelmReleasePropertiesDefinitionResponse',
    'IdentityResponse',
    'KustomizationDefinitionResponse',
    'ObjectReferenceDefinitionResponse',
    'ObjectStatusConditionDefinitionResponse',
    'ObjectStatusDefinitionResponse',
    'RepositoryRefDefinitionResponse',
    'ScopeClusterResponse',
    'ScopeNamespaceResponse',
    'ScopeResponse',
    'SystemDataResponse',
]

@pulumi.output_type
class ComplianceStatusResponse(dict):
    """
    Compliance Status details
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "complianceState":
            suggest = "compliance_state"
        elif key == "lastConfigApplied":
            suggest = "last_config_applied"
        elif key == "messageLevel":
            suggest = "message_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComplianceStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComplianceStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComplianceStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compliance_state: str,
                 last_config_applied: Optional[str] = None,
                 message: Optional[str] = None,
                 message_level: Optional[str] = None):
        """
        Compliance Status details
        :param str compliance_state: The compliance state of the configuration.
        :param str last_config_applied: Datetime the configuration was last applied.
        :param str message: Message from when the configuration was applied.
        :param str message_level: Level of the message.
        """
        pulumi.set(__self__, "compliance_state", compliance_state)
        if last_config_applied is not None:
            pulumi.set(__self__, "last_config_applied", last_config_applied)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if message_level is not None:
            pulumi.set(__self__, "message_level", message_level)

    @property
    @pulumi.getter(name="complianceState")
    def compliance_state(self) -> str:
        """
        The compliance state of the configuration.
        """
        return pulumi.get(self, "compliance_state")

    @property
    @pulumi.getter(name="lastConfigApplied")
    def last_config_applied(self) -> Optional[str]:
        """
        Datetime the configuration was last applied.
        """
        return pulumi.get(self, "last_config_applied")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        Message from when the configuration was applied.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="messageLevel")
    def message_level(self) -> Optional[str]:
        """
        Level of the message.
        """
        return pulumi.get(self, "message_level")


@pulumi.output_type
class DependsOnDefinitionResponse(dict):
    """
    Specify which kustomizations must succeed reconciliation on the cluster prior to reconciling this kustomization
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kustomizationName":
            suggest = "kustomization_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DependsOnDefinitionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DependsOnDefinitionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DependsOnDefinitionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kustomization_name: Optional[str] = None):
        """
        Specify which kustomizations must succeed reconciliation on the cluster prior to reconciling this kustomization
        :param str kustomization_name: Name of the kustomization to claim dependency on
        """
        if kustomization_name is not None:
            pulumi.set(__self__, "kustomization_name", kustomization_name)

    @property
    @pulumi.getter(name="kustomizationName")
    def kustomization_name(self) -> Optional[str]:
        """
        Name of the kustomization to claim dependency on
        """
        return pulumi.get(self, "kustomization_name")


@pulumi.output_type
class ErrorAdditionalInfoResponse(dict):
    """
    The resource management error additional info.
    """
    def __init__(__self__, *,
                 info: Any,
                 type: str):
        """
        The resource management error additional info.
        :param Any info: The additional info.
        :param str type: The additional info type.
        """
        pulumi.set(__self__, "info", info)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def info(self) -> Any:
        """
        The additional info.
        """
        return pulumi.get(self, "info")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The additional info type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ErrorDetailResponse(dict):
    """
    The error detail.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalInfo":
            suggest = "additional_info"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ErrorDetailResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ErrorDetailResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ErrorDetailResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 additional_info: Sequence['outputs.ErrorAdditionalInfoResponse'],
                 code: str,
                 details: Sequence['outputs.ErrorDetailResponse'],
                 message: str,
                 target: str):
        """
        The error detail.
        :param Sequence['ErrorAdditionalInfoResponse'] additional_info: The error additional info.
        :param str code: The error code.
        :param Sequence['ErrorDetailResponse'] details: The error details.
        :param str message: The error message.
        :param str target: The error target.
        """
        pulumi.set(__self__, "additional_info", additional_info)
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "details", details)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter(name="additionalInfo")
    def additional_info(self) -> Sequence['outputs.ErrorAdditionalInfoResponse']:
        """
        The error additional info.
        """
        return pulumi.get(self, "additional_info")

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        The error code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def details(self) -> Sequence['outputs.ErrorDetailResponse']:
        """
        The error details.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        The error message.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def target(self) -> str:
        """
        The error target.
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class ExtensionResponseAksAssignedIdentity(dict):
    """
    Identity of the Extension resource in an AKS cluster
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExtensionResponseAksAssignedIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExtensionResponseAksAssignedIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExtensionResponseAksAssignedIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: str,
                 tenant_id: str,
                 type: Optional[str] = None):
        """
        Identity of the Extension resource in an AKS cluster
        :param str principal_id: The principal ID of resource identity.
        :param str tenant_id: The tenant ID of resource.
        :param str type: The identity type.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal ID of resource identity.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The tenant ID of resource.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The identity type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ExtensionStatusResponse(dict):
    """
    Status from the extension.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayStatus":
            suggest = "display_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExtensionStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExtensionStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExtensionStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 code: Optional[str] = None,
                 display_status: Optional[str] = None,
                 level: Optional[str] = None,
                 message: Optional[str] = None,
                 time: Optional[str] = None):
        """
        Status from the extension.
        :param str code: Status code provided by the Extension
        :param str display_status: Short description of status of the extension.
        :param str level: Level of the status.
        :param str message: Detailed message of the status from the Extension.
        :param str time: DateLiteral (per ISO8601) noting the time of installation status.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if display_status is not None:
            pulumi.set(__self__, "display_status", display_status)
        if level is None:
            level = 'Information'
        if level is not None:
            pulumi.set(__self__, "level", level)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if time is not None:
            pulumi.set(__self__, "time", time)

    @property
    @pulumi.getter
    def code(self) -> Optional[str]:
        """
        Status code provided by the Extension
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter(name="displayStatus")
    def display_status(self) -> Optional[str]:
        """
        Short description of status of the extension.
        """
        return pulumi.get(self, "display_status")

    @property
    @pulumi.getter
    def level(self) -> Optional[str]:
        """
        Level of the status.
        """
        return pulumi.get(self, "level")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        Detailed message of the status from the Extension.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def time(self) -> Optional[str]:
        """
        DateLiteral (per ISO8601) noting the time of installation status.
        """
        return pulumi.get(self, "time")


@pulumi.output_type
class GitRepositoryDefinitionResponse(dict):
    """
    Parameters to reconcile to the GitRepository source kind type.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpsCAFile":
            suggest = "https_ca_file"
        elif key == "httpsUser":
            suggest = "https_user"
        elif key == "localAuthRef":
            suggest = "local_auth_ref"
        elif key == "repositoryRef":
            suggest = "repository_ref"
        elif key == "sshKnownHosts":
            suggest = "ssh_known_hosts"
        elif key == "syncIntervalInSeconds":
            suggest = "sync_interval_in_seconds"
        elif key == "timeoutInSeconds":
            suggest = "timeout_in_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GitRepositoryDefinitionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GitRepositoryDefinitionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GitRepositoryDefinitionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 https_ca_file: Optional[str] = None,
                 https_user: Optional[str] = None,
                 local_auth_ref: Optional[str] = None,
                 repository_ref: Optional['outputs.RepositoryRefDefinitionResponse'] = None,
                 ssh_known_hosts: Optional[str] = None,
                 sync_interval_in_seconds: Optional[float] = None,
                 timeout_in_seconds: Optional[float] = None,
                 url: Optional[str] = None):
        """
        Parameters to reconcile to the GitRepository source kind type.
        :param str https_ca_file: Base64-encoded HTTPS certificate authority contents used to access git private git repositories over HTTPS
        :param str https_user: Base64-encoded HTTPS username used to access private git repositories over HTTPS
        :param str local_auth_ref: Name of a local secret on the Kubernetes cluster to use as the authentication secret rather than the managed or user-provided configuration secrets.
        :param 'RepositoryRefDefinitionResponse' repository_ref: The source reference for the GitRepository object.
        :param str ssh_known_hosts: Base64-encoded known_hosts value containing public SSH keys required to access private git repositories over SSH
        :param float sync_interval_in_seconds: The interval at which to re-reconcile the cluster git repository source with the remote.
        :param float timeout_in_seconds: The maximum time to attempt to reconcile the cluster git repository source with the remote.
        :param str url: The URL to sync for the flux configuration git repository.
        """
        if https_ca_file is not None:
            pulumi.set(__self__, "https_ca_file", https_ca_file)
        if https_user is not None:
            pulumi.set(__self__, "https_user", https_user)
        if local_auth_ref is not None:
            pulumi.set(__self__, "local_auth_ref", local_auth_ref)
        if repository_ref is not None:
            pulumi.set(__self__, "repository_ref", repository_ref)
        if ssh_known_hosts is not None:
            pulumi.set(__self__, "ssh_known_hosts", ssh_known_hosts)
        if sync_interval_in_seconds is None:
            sync_interval_in_seconds = 600
        if sync_interval_in_seconds is not None:
            pulumi.set(__self__, "sync_interval_in_seconds", sync_interval_in_seconds)
        if timeout_in_seconds is None:
            timeout_in_seconds = 600
        if timeout_in_seconds is not None:
            pulumi.set(__self__, "timeout_in_seconds", timeout_in_seconds)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="httpsCAFile")
    def https_ca_file(self) -> Optional[str]:
        """
        Base64-encoded HTTPS certificate authority contents used to access git private git repositories over HTTPS
        """
        return pulumi.get(self, "https_ca_file")

    @property
    @pulumi.getter(name="httpsUser")
    def https_user(self) -> Optional[str]:
        """
        Base64-encoded HTTPS username used to access private git repositories over HTTPS
        """
        return pulumi.get(self, "https_user")

    @property
    @pulumi.getter(name="localAuthRef")
    def local_auth_ref(self) -> Optional[str]:
        """
        Name of a local secret on the Kubernetes cluster to use as the authentication secret rather than the managed or user-provided configuration secrets.
        """
        return pulumi.get(self, "local_auth_ref")

    @property
    @pulumi.getter(name="repositoryRef")
    def repository_ref(self) -> Optional['outputs.RepositoryRefDefinitionResponse']:
        """
        The source reference for the GitRepository object.
        """
        return pulumi.get(self, "repository_ref")

    @property
    @pulumi.getter(name="sshKnownHosts")
    def ssh_known_hosts(self) -> Optional[str]:
        """
        Base64-encoded known_hosts value containing public SSH keys required to access private git repositories over SSH
        """
        return pulumi.get(self, "ssh_known_hosts")

    @property
    @pulumi.getter(name="syncIntervalInSeconds")
    def sync_interval_in_seconds(self) -> Optional[float]:
        """
        The interval at which to re-reconcile the cluster git repository source with the remote.
        """
        return pulumi.get(self, "sync_interval_in_seconds")

    @property
    @pulumi.getter(name="timeoutInSeconds")
    def timeout_in_seconds(self) -> Optional[float]:
        """
        The maximum time to attempt to reconcile the cluster git repository source with the remote.
        """
        return pulumi.get(self, "timeout_in_seconds")

    @property
    @pulumi.getter
    def url(self) -> Optional[str]:
        """
        The URL to sync for the flux configuration git repository.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class HelmOperatorPropertiesResponse(dict):
    """
    Properties for Helm operator.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "chartValues":
            suggest = "chart_values"
        elif key == "chartVersion":
            suggest = "chart_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HelmOperatorPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HelmOperatorPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HelmOperatorPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 chart_values: Optional[str] = None,
                 chart_version: Optional[str] = None):
        """
        Properties for Helm operator.
        :param str chart_values: Values override for the operator Helm chart.
        :param str chart_version: Version of the operator Helm chart.
        """
        if chart_values is not None:
            pulumi.set(__self__, "chart_values", chart_values)
        if chart_version is not None:
            pulumi.set(__self__, "chart_version", chart_version)

    @property
    @pulumi.getter(name="chartValues")
    def chart_values(self) -> Optional[str]:
        """
        Values override for the operator Helm chart.
        """
        return pulumi.get(self, "chart_values")

    @property
    @pulumi.getter(name="chartVersion")
    def chart_version(self) -> Optional[str]:
        """
        Version of the operator Helm chart.
        """
        return pulumi.get(self, "chart_version")


@pulumi.output_type
class HelmReleasePropertiesDefinitionResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failureCount":
            suggest = "failure_count"
        elif key == "helmChartRef":
            suggest = "helm_chart_ref"
        elif key == "installFailureCount":
            suggest = "install_failure_count"
        elif key == "lastRevisionApplied":
            suggest = "last_revision_applied"
        elif key == "upgradeFailureCount":
            suggest = "upgrade_failure_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HelmReleasePropertiesDefinitionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HelmReleasePropertiesDefinitionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HelmReleasePropertiesDefinitionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 failure_count: Optional[float] = None,
                 helm_chart_ref: Optional['outputs.ObjectReferenceDefinitionResponse'] = None,
                 install_failure_count: Optional[float] = None,
                 last_revision_applied: Optional[float] = None,
                 upgrade_failure_count: Optional[float] = None):
        """
        :param float failure_count: Total number of times that the HelmRelease failed to install or upgrade
        :param 'ObjectReferenceDefinitionResponse' helm_chart_ref: The reference to the HelmChart object used as the source to this HelmRelease
        :param float install_failure_count: Number of times that the HelmRelease failed to install
        :param float last_revision_applied: The revision number of the last released object change
        :param float upgrade_failure_count: Number of times that the HelmRelease failed to upgrade
        """
        if failure_count is not None:
            pulumi.set(__self__, "failure_count", failure_count)
        if helm_chart_ref is not None:
            pulumi.set(__self__, "helm_chart_ref", helm_chart_ref)
        if install_failure_count is not None:
            pulumi.set(__self__, "install_failure_count", install_failure_count)
        if last_revision_applied is not None:
            pulumi.set(__self__, "last_revision_applied", last_revision_applied)
        if upgrade_failure_count is not None:
            pulumi.set(__self__, "upgrade_failure_count", upgrade_failure_count)

    @property
    @pulumi.getter(name="failureCount")
    def failure_count(self) -> Optional[float]:
        """
        Total number of times that the HelmRelease failed to install or upgrade
        """
        return pulumi.get(self, "failure_count")

    @property
    @pulumi.getter(name="helmChartRef")
    def helm_chart_ref(self) -> Optional['outputs.ObjectReferenceDefinitionResponse']:
        """
        The reference to the HelmChart object used as the source to this HelmRelease
        """
        return pulumi.get(self, "helm_chart_ref")

    @property
    @pulumi.getter(name="installFailureCount")
    def install_failure_count(self) -> Optional[float]:
        """
        Number of times that the HelmRelease failed to install
        """
        return pulumi.get(self, "install_failure_count")

    @property
    @pulumi.getter(name="lastRevisionApplied")
    def last_revision_applied(self) -> Optional[float]:
        """
        The revision number of the last released object change
        """
        return pulumi.get(self, "last_revision_applied")

    @property
    @pulumi.getter(name="upgradeFailureCount")
    def upgrade_failure_count(self) -> Optional[float]:
        """
        Number of times that the HelmRelease failed to upgrade
        """
        return pulumi.get(self, "upgrade_failure_count")


@pulumi.output_type
class IdentityResponse(dict):
    """
    Identity for the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: str,
                 tenant_id: str,
                 type: Optional[str] = None):
        """
        Identity for the resource.
        :param str principal_id: The principal ID of resource identity.
        :param str tenant_id: The tenant ID of resource.
        :param str type: The identity type.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal ID of resource identity.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The tenant ID of resource.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The identity type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class KustomizationDefinitionResponse(dict):
    """
    The Kustomization defining how to reconcile the artifact pulled by the source type on the cluster.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dependsOn":
            suggest = "depends_on"
        elif key == "retryIntervalInSeconds":
            suggest = "retry_interval_in_seconds"
        elif key == "syncIntervalInSeconds":
            suggest = "sync_interval_in_seconds"
        elif key == "timeoutInSeconds":
            suggest = "timeout_in_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KustomizationDefinitionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KustomizationDefinitionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KustomizationDefinitionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 depends_on: Optional[Sequence['outputs.DependsOnDefinitionResponse']] = None,
                 force: Optional[bool] = None,
                 path: Optional[str] = None,
                 prune: Optional[bool] = None,
                 retry_interval_in_seconds: Optional[float] = None,
                 sync_interval_in_seconds: Optional[float] = None,
                 timeout_in_seconds: Optional[float] = None,
                 validation: Optional[str] = None):
        """
        The Kustomization defining how to reconcile the artifact pulled by the source type on the cluster.
        :param Sequence['DependsOnDefinitionResponse'] depends_on: Specifies other Kustomizations that this Kustomization depends on. This Kustomization will not reconcile until all dependencies have completed their reconciliation.
        :param bool force: Enable/disable re-creating Kubernetes resources on the cluster when patching fails due to an immutable field change.
        :param str path: The path in the source reference to reconcile on the cluster.
        :param bool prune: Enable/disable garbage collections of Kubernetes objects created by this Kustomization.
        :param float retry_interval_in_seconds: The interval at which to re-reconcile the Kustomization on the cluster in the event of failure on reconciliation.
        :param float sync_interval_in_seconds: The interval at which to re-reconcile the Kustomization on the cluster.
        :param float timeout_in_seconds: The maximum time to attempt to reconcile the Kustomization on the cluster.
        :param str validation: Specify whether to validate the Kubernetes objects referenced in the Kustomization before applying them to the cluster.
        """
        if depends_on is not None:
            pulumi.set(__self__, "depends_on", depends_on)
        if force is None:
            force = False
        if force is not None:
            pulumi.set(__self__, "force", force)
        if path is None:
            path = ''
        if path is not None:
            pulumi.set(__self__, "path", path)
        if prune is None:
            prune = False
        if prune is not None:
            pulumi.set(__self__, "prune", prune)
        if retry_interval_in_seconds is not None:
            pulumi.set(__self__, "retry_interval_in_seconds", retry_interval_in_seconds)
        if sync_interval_in_seconds is None:
            sync_interval_in_seconds = 600
        if sync_interval_in_seconds is not None:
            pulumi.set(__self__, "sync_interval_in_seconds", sync_interval_in_seconds)
        if timeout_in_seconds is None:
            timeout_in_seconds = 600
        if timeout_in_seconds is not None:
            pulumi.set(__self__, "timeout_in_seconds", timeout_in_seconds)
        if validation is not None:
            pulumi.set(__self__, "validation", validation)

    @property
    @pulumi.getter(name="dependsOn")
    def depends_on(self) -> Optional[Sequence['outputs.DependsOnDefinitionResponse']]:
        """
        Specifies other Kustomizations that this Kustomization depends on. This Kustomization will not reconcile until all dependencies have completed their reconciliation.
        """
        return pulumi.get(self, "depends_on")

    @property
    @pulumi.getter
    def force(self) -> Optional[bool]:
        """
        Enable/disable re-creating Kubernetes resources on the cluster when patching fails due to an immutable field change.
        """
        return pulumi.get(self, "force")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The path in the source reference to reconcile on the cluster.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def prune(self) -> Optional[bool]:
        """
        Enable/disable garbage collections of Kubernetes objects created by this Kustomization.
        """
        return pulumi.get(self, "prune")

    @property
    @pulumi.getter(name="retryIntervalInSeconds")
    def retry_interval_in_seconds(self) -> Optional[float]:
        """
        The interval at which to re-reconcile the Kustomization on the cluster in the event of failure on reconciliation.
        """
        return pulumi.get(self, "retry_interval_in_seconds")

    @property
    @pulumi.getter(name="syncIntervalInSeconds")
    def sync_interval_in_seconds(self) -> Optional[float]:
        """
        The interval at which to re-reconcile the Kustomization on the cluster.
        """
        return pulumi.get(self, "sync_interval_in_seconds")

    @property
    @pulumi.getter(name="timeoutInSeconds")
    def timeout_in_seconds(self) -> Optional[float]:
        """
        The maximum time to attempt to reconcile the Kustomization on the cluster.
        """
        return pulumi.get(self, "timeout_in_seconds")

    @property
    @pulumi.getter
    def validation(self) -> Optional[str]:
        """
        Specify whether to validate the Kubernetes objects referenced in the Kustomization before applying them to the cluster.
        """
        return pulumi.get(self, "validation")


@pulumi.output_type
class ObjectReferenceDefinitionResponse(dict):
    """
    Object reference to a Kubernetes object on a cluster
    """
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 namespace: Optional[str] = None):
        """
        Object reference to a Kubernetes object on a cluster
        :param str name: Name of the object
        :param str namespace: Namespace of the object
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the object
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[str]:
        """
        Namespace of the object
        """
        return pulumi.get(self, "namespace")


@pulumi.output_type
class ObjectStatusConditionDefinitionResponse(dict):
    """
    Status condition of Kubernetes object
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastTransitionTime":
            suggest = "last_transition_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ObjectStatusConditionDefinitionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ObjectStatusConditionDefinitionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ObjectStatusConditionDefinitionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 last_transition_time: Optional[str] = None,
                 message: Optional[str] = None,
                 reason: Optional[str] = None,
                 status: Optional[str] = None,
                 type: Optional[str] = None):
        """
        Status condition of Kubernetes object
        :param str last_transition_time: Last time this status condition has changed
        :param str message: A more verbose description of the object status condition
        :param str reason: Reason for the specified status condition type status
        :param str status: Status of the Kubernetes object condition type
        :param str type: Object status condition type for this object
        """
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[str]:
        """
        Last time this status condition has changed
        """
        return pulumi.get(self, "last_transition_time")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        A more verbose description of the object status condition
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def reason(self) -> Optional[str]:
        """
        Reason for the specified status condition type status
        """
        return pulumi.get(self, "reason")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Status of the Kubernetes object condition type
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Object status condition type for this object
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ObjectStatusDefinitionResponse(dict):
    """
    Statuses of objects deployed by the user-specified kustomizations from the git repository.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appliedBy":
            suggest = "applied_by"
        elif key == "complianceState":
            suggest = "compliance_state"
        elif key == "helmReleaseProperties":
            suggest = "helm_release_properties"
        elif key == "statusConditions":
            suggest = "status_conditions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ObjectStatusDefinitionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ObjectStatusDefinitionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ObjectStatusDefinitionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 applied_by: Optional['outputs.ObjectReferenceDefinitionResponse'] = None,
                 compliance_state: Optional[str] = None,
                 helm_release_properties: Optional['outputs.HelmReleasePropertiesDefinitionResponse'] = None,
                 kind: Optional[str] = None,
                 name: Optional[str] = None,
                 namespace: Optional[str] = None,
                 status_conditions: Optional[Sequence['outputs.ObjectStatusConditionDefinitionResponse']] = None):
        """
        Statuses of objects deployed by the user-specified kustomizations from the git repository.
        :param 'ObjectReferenceDefinitionResponse' applied_by: Object reference to the Kustomization that applied this object
        :param str compliance_state: Compliance state of the applied object showing whether the applied object has come into a ready state on the cluster.
        :param 'HelmReleasePropertiesDefinitionResponse' helm_release_properties: Additional properties that are provided from objects of the HelmRelease kind
        :param str kind: Kind of the applied object
        :param str name: Name of the applied object
        :param str namespace: Namespace of the applied object
        :param Sequence['ObjectStatusConditionDefinitionResponse'] status_conditions: List of Kubernetes object status conditions present on the cluster
        """
        if applied_by is not None:
            pulumi.set(__self__, "applied_by", applied_by)
        if compliance_state is not None:
            pulumi.set(__self__, "compliance_state", compliance_state)
        if helm_release_properties is not None:
            pulumi.set(__self__, "helm_release_properties", helm_release_properties)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if status_conditions is not None:
            pulumi.set(__self__, "status_conditions", status_conditions)

    @property
    @pulumi.getter(name="appliedBy")
    def applied_by(self) -> Optional['outputs.ObjectReferenceDefinitionResponse']:
        """
        Object reference to the Kustomization that applied this object
        """
        return pulumi.get(self, "applied_by")

    @property
    @pulumi.getter(name="complianceState")
    def compliance_state(self) -> Optional[str]:
        """
        Compliance state of the applied object showing whether the applied object has come into a ready state on the cluster.
        """
        return pulumi.get(self, "compliance_state")

    @property
    @pulumi.getter(name="helmReleaseProperties")
    def helm_release_properties(self) -> Optional['outputs.HelmReleasePropertiesDefinitionResponse']:
        """
        Additional properties that are provided from objects of the HelmRelease kind
        """
        return pulumi.get(self, "helm_release_properties")

    @property
    @pulumi.getter
    def kind(self) -> Optional[str]:
        """
        Kind of the applied object
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the applied object
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[str]:
        """
        Namespace of the applied object
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="statusConditions")
    def status_conditions(self) -> Optional[Sequence['outputs.ObjectStatusConditionDefinitionResponse']]:
        """
        List of Kubernetes object status conditions present on the cluster
        """
        return pulumi.get(self, "status_conditions")


@pulumi.output_type
class RepositoryRefDefinitionResponse(dict):
    """
    The source reference for the GitRepository object.
    """
    def __init__(__self__, *,
                 branch: Optional[str] = None,
                 commit: Optional[str] = None,
                 semver: Optional[str] = None,
                 tag: Optional[str] = None):
        """
        The source reference for the GitRepository object.
        :param str branch: The git repository branch name to checkout.
        :param str commit: The commit SHA to checkout. This value must be combined with the branch name to be valid. This takes precedence over semver.
        :param str semver: The semver range used to match against git repository tags. This takes precedence over tag.
        :param str tag: The git repository tag name to checkout. This takes precedence over branch.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if commit is not None:
            pulumi.set(__self__, "commit", commit)
        if semver is not None:
            pulumi.set(__self__, "semver", semver)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)

    @property
    @pulumi.getter
    def branch(self) -> Optional[str]:
        """
        The git repository branch name to checkout.
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter
    def commit(self) -> Optional[str]:
        """
        The commit SHA to checkout. This value must be combined with the branch name to be valid. This takes precedence over semver.
        """
        return pulumi.get(self, "commit")

    @property
    @pulumi.getter
    def semver(self) -> Optional[str]:
        """
        The semver range used to match against git repository tags. This takes precedence over tag.
        """
        return pulumi.get(self, "semver")

    @property
    @pulumi.getter
    def tag(self) -> Optional[str]:
        """
        The git repository tag name to checkout. This takes precedence over branch.
        """
        return pulumi.get(self, "tag")


@pulumi.output_type
class ScopeClusterResponse(dict):
    """
    Specifies that the scope of the extension is Cluster
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "releaseNamespace":
            suggest = "release_namespace"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScopeClusterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScopeClusterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScopeClusterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 release_namespace: Optional[str] = None):
        """
        Specifies that the scope of the extension is Cluster
        :param str release_namespace: Namespace where the extension Release must be placed, for a Cluster scoped extension.  If this namespace does not exist, it will be created
        """
        if release_namespace is not None:
            pulumi.set(__self__, "release_namespace", release_namespace)

    @property
    @pulumi.getter(name="releaseNamespace")
    def release_namespace(self) -> Optional[str]:
        """
        Namespace where the extension Release must be placed, for a Cluster scoped extension.  If this namespace does not exist, it will be created
        """
        return pulumi.get(self, "release_namespace")


@pulumi.output_type
class ScopeNamespaceResponse(dict):
    """
    Specifies that the scope of the extension is Namespace
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetNamespace":
            suggest = "target_namespace"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScopeNamespaceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScopeNamespaceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScopeNamespaceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_namespace: Optional[str] = None):
        """
        Specifies that the scope of the extension is Namespace
        :param str target_namespace: Namespace where the extension will be created for an Namespace scoped extension.  If this namespace does not exist, it will be created
        """
        if target_namespace is not None:
            pulumi.set(__self__, "target_namespace", target_namespace)

    @property
    @pulumi.getter(name="targetNamespace")
    def target_namespace(self) -> Optional[str]:
        """
        Namespace where the extension will be created for an Namespace scoped extension.  If this namespace does not exist, it will be created
        """
        return pulumi.get(self, "target_namespace")


@pulumi.output_type
class ScopeResponse(dict):
    """
    Scope of the extension. It can be either Cluster or Namespace; but not both.
    """
    def __init__(__self__, *,
                 cluster: Optional['outputs.ScopeClusterResponse'] = None,
                 namespace: Optional['outputs.ScopeNamespaceResponse'] = None):
        """
        Scope of the extension. It can be either Cluster or Namespace; but not both.
        :param 'ScopeClusterResponse' cluster: Specifies that the scope of the extension is Cluster
        :param 'ScopeNamespaceResponse' namespace: Specifies that the scope of the extension is Namespace
        """
        if cluster is not None:
            pulumi.set(__self__, "cluster", cluster)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter
    def cluster(self) -> Optional['outputs.ScopeClusterResponse']:
        """
        Specifies that the scope of the extension is Cluster
        """
        return pulumi.get(self, "cluster")

    @property
    @pulumi.getter
    def namespace(self) -> Optional['outputs.ScopeNamespaceResponse']:
        """
        Specifies that the scope of the extension is Namespace
        """
        return pulumi.get(self, "namespace")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The timestamp of resource last modification (UTC)
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The timestamp of resource last modification (UTC)
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


