# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'ColumnDefinitionArgs',
    'DataCollectionEndpointNetworkAclsArgs',
    'DataCollectionRuleDataSourcesArgs',
    'DataCollectionRuleDestinationsArgs',
    'DataFlowArgs',
    'DestinationsSpecAzureMonitorMetricsArgs',
    'ExtensionDataSourceArgs',
    'IisLogsDataSourceArgs',
    'LogAnalyticsDestinationArgs',
    'LogFileSettingsTextArgs',
    'LogFilesDataSourceSettingsArgs',
    'LogFilesDataSourceArgs',
    'PerfCounterDataSourceArgs',
    'StreamDeclarationArgs',
    'SyslogDataSourceArgs',
    'WindowsEventLogDataSourceArgs',
]

@pulumi.input_type
class ColumnDefinitionArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[Union[str, 'KnownColumnDefinitionType']]] = None):
        """
        Definition of custom data column.
        :param pulumi.Input[str] name: The name of the column.
        :param pulumi.Input[Union[str, 'KnownColumnDefinitionType']] type: The type of the column data.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the column.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Union[str, 'KnownColumnDefinitionType']]]:
        """
        The type of the column data.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Union[str, 'KnownColumnDefinitionType']]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class DataCollectionEndpointNetworkAclsArgs:
    def __init__(__self__, *,
                 public_network_access: Optional[pulumi.Input[Union[str, 'KnownPublicNetworkAccessOptions']]] = None):
        """
        Network access control rules for the endpoints.
        :param pulumi.Input[Union[str, 'KnownPublicNetworkAccessOptions']] public_network_access: The configuration to set whether network access from public internet to the endpoints are allowed.
        """
        if public_network_access is not None:
            pulumi.set(__self__, "public_network_access", public_network_access)

    @property
    @pulumi.getter(name="publicNetworkAccess")
    def public_network_access(self) -> Optional[pulumi.Input[Union[str, 'KnownPublicNetworkAccessOptions']]]:
        """
        The configuration to set whether network access from public internet to the endpoints are allowed.
        """
        return pulumi.get(self, "public_network_access")

    @public_network_access.setter
    def public_network_access(self, value: Optional[pulumi.Input[Union[str, 'KnownPublicNetworkAccessOptions']]]):
        pulumi.set(self, "public_network_access", value)


@pulumi.input_type
class DataCollectionRuleDataSourcesArgs:
    def __init__(__self__, *,
                 extensions: Optional[pulumi.Input[Sequence[pulumi.Input['ExtensionDataSourceArgs']]]] = None,
                 iis_logs: Optional[pulumi.Input[Sequence[pulumi.Input['IisLogsDataSourceArgs']]]] = None,
                 log_files: Optional[pulumi.Input[Sequence[pulumi.Input['LogFilesDataSourceArgs']]]] = None,
                 performance_counters: Optional[pulumi.Input[Sequence[pulumi.Input['PerfCounterDataSourceArgs']]]] = None,
                 syslog: Optional[pulumi.Input[Sequence[pulumi.Input['SyslogDataSourceArgs']]]] = None,
                 windows_event_logs: Optional[pulumi.Input[Sequence[pulumi.Input['WindowsEventLogDataSourceArgs']]]] = None):
        """
        The specification of data sources. 
        This property is optional and can be omitted if the rule is meant to be used via direct calls to the provisioned endpoint.
        :param pulumi.Input[Sequence[pulumi.Input['ExtensionDataSourceArgs']]] extensions: The list of Azure VM extension data source configurations.
        :param pulumi.Input[Sequence[pulumi.Input['IisLogsDataSourceArgs']]] iis_logs: The list of IIS logs source configurations.
        :param pulumi.Input[Sequence[pulumi.Input['LogFilesDataSourceArgs']]] log_files: The list of Log files source configurations.
        :param pulumi.Input[Sequence[pulumi.Input['PerfCounterDataSourceArgs']]] performance_counters: The list of performance counter data source configurations.
        :param pulumi.Input[Sequence[pulumi.Input['SyslogDataSourceArgs']]] syslog: The list of Syslog data source configurations.
        :param pulumi.Input[Sequence[pulumi.Input['WindowsEventLogDataSourceArgs']]] windows_event_logs: The list of Windows Event Log data source configurations.
        """
        if extensions is not None:
            pulumi.set(__self__, "extensions", extensions)
        if iis_logs is not None:
            pulumi.set(__self__, "iis_logs", iis_logs)
        if log_files is not None:
            pulumi.set(__self__, "log_files", log_files)
        if performance_counters is not None:
            pulumi.set(__self__, "performance_counters", performance_counters)
        if syslog is not None:
            pulumi.set(__self__, "syslog", syslog)
        if windows_event_logs is not None:
            pulumi.set(__self__, "windows_event_logs", windows_event_logs)

    @property
    @pulumi.getter
    def extensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExtensionDataSourceArgs']]]]:
        """
        The list of Azure VM extension data source configurations.
        """
        return pulumi.get(self, "extensions")

    @extensions.setter
    def extensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExtensionDataSourceArgs']]]]):
        pulumi.set(self, "extensions", value)

    @property
    @pulumi.getter(name="iisLogs")
    def iis_logs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IisLogsDataSourceArgs']]]]:
        """
        The list of IIS logs source configurations.
        """
        return pulumi.get(self, "iis_logs")

    @iis_logs.setter
    def iis_logs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IisLogsDataSourceArgs']]]]):
        pulumi.set(self, "iis_logs", value)

    @property
    @pulumi.getter(name="logFiles")
    def log_files(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LogFilesDataSourceArgs']]]]:
        """
        The list of Log files source configurations.
        """
        return pulumi.get(self, "log_files")

    @log_files.setter
    def log_files(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LogFilesDataSourceArgs']]]]):
        pulumi.set(self, "log_files", value)

    @property
    @pulumi.getter(name="performanceCounters")
    def performance_counters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PerfCounterDataSourceArgs']]]]:
        """
        The list of performance counter data source configurations.
        """
        return pulumi.get(self, "performance_counters")

    @performance_counters.setter
    def performance_counters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PerfCounterDataSourceArgs']]]]):
        pulumi.set(self, "performance_counters", value)

    @property
    @pulumi.getter
    def syslog(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SyslogDataSourceArgs']]]]:
        """
        The list of Syslog data source configurations.
        """
        return pulumi.get(self, "syslog")

    @syslog.setter
    def syslog(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SyslogDataSourceArgs']]]]):
        pulumi.set(self, "syslog", value)

    @property
    @pulumi.getter(name="windowsEventLogs")
    def windows_event_logs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WindowsEventLogDataSourceArgs']]]]:
        """
        The list of Windows Event Log data source configurations.
        """
        return pulumi.get(self, "windows_event_logs")

    @windows_event_logs.setter
    def windows_event_logs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WindowsEventLogDataSourceArgs']]]]):
        pulumi.set(self, "windows_event_logs", value)


@pulumi.input_type
class DataCollectionRuleDestinationsArgs:
    def __init__(__self__, *,
                 azure_monitor_metrics: Optional[pulumi.Input['DestinationsSpecAzureMonitorMetricsArgs']] = None,
                 log_analytics: Optional[pulumi.Input[Sequence[pulumi.Input['LogAnalyticsDestinationArgs']]]] = None):
        """
        The specification of destinations.
        :param pulumi.Input['DestinationsSpecAzureMonitorMetricsArgs'] azure_monitor_metrics: Azure Monitor Metrics destination.
        :param pulumi.Input[Sequence[pulumi.Input['LogAnalyticsDestinationArgs']]] log_analytics: List of Log Analytics destinations.
        """
        if azure_monitor_metrics is not None:
            pulumi.set(__self__, "azure_monitor_metrics", azure_monitor_metrics)
        if log_analytics is not None:
            pulumi.set(__self__, "log_analytics", log_analytics)

    @property
    @pulumi.getter(name="azureMonitorMetrics")
    def azure_monitor_metrics(self) -> Optional[pulumi.Input['DestinationsSpecAzureMonitorMetricsArgs']]:
        """
        Azure Monitor Metrics destination.
        """
        return pulumi.get(self, "azure_monitor_metrics")

    @azure_monitor_metrics.setter
    def azure_monitor_metrics(self, value: Optional[pulumi.Input['DestinationsSpecAzureMonitorMetricsArgs']]):
        pulumi.set(self, "azure_monitor_metrics", value)

    @property
    @pulumi.getter(name="logAnalytics")
    def log_analytics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LogAnalyticsDestinationArgs']]]]:
        """
        List of Log Analytics destinations.
        """
        return pulumi.get(self, "log_analytics")

    @log_analytics.setter
    def log_analytics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LogAnalyticsDestinationArgs']]]]):
        pulumi.set(self, "log_analytics", value)


@pulumi.input_type
class DataFlowArgs:
    def __init__(__self__, *,
                 destinations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 output_stream: Optional[pulumi.Input[str]] = None,
                 streams: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownDataFlowStreams']]]]] = None,
                 transform_kql: Optional[pulumi.Input[str]] = None):
        """
        Definition of which streams are sent to which destinations.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] destinations: List of destinations for this data flow.
        :param pulumi.Input[str] output_stream: The output stream of the transform. Only required if the transform changes data to a different stream.
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownDataFlowStreams']]]] streams: List of streams for this data flow.
        :param pulumi.Input[str] transform_kql: The KQL query to transform stream data.
        """
        if destinations is not None:
            pulumi.set(__self__, "destinations", destinations)
        if output_stream is not None:
            pulumi.set(__self__, "output_stream", output_stream)
        if streams is not None:
            pulumi.set(__self__, "streams", streams)
        if transform_kql is not None:
            pulumi.set(__self__, "transform_kql", transform_kql)

    @property
    @pulumi.getter
    def destinations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of destinations for this data flow.
        """
        return pulumi.get(self, "destinations")

    @destinations.setter
    def destinations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "destinations", value)

    @property
    @pulumi.getter(name="outputStream")
    def output_stream(self) -> Optional[pulumi.Input[str]]:
        """
        The output stream of the transform. Only required if the transform changes data to a different stream.
        """
        return pulumi.get(self, "output_stream")

    @output_stream.setter
    def output_stream(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "output_stream", value)

    @property
    @pulumi.getter
    def streams(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownDataFlowStreams']]]]]:
        """
        List of streams for this data flow.
        """
        return pulumi.get(self, "streams")

    @streams.setter
    def streams(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownDataFlowStreams']]]]]):
        pulumi.set(self, "streams", value)

    @property
    @pulumi.getter(name="transformKql")
    def transform_kql(self) -> Optional[pulumi.Input[str]]:
        """
        The KQL query to transform stream data.
        """
        return pulumi.get(self, "transform_kql")

    @transform_kql.setter
    def transform_kql(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transform_kql", value)


@pulumi.input_type
class DestinationsSpecAzureMonitorMetricsArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Azure Monitor Metrics destination.
        :param pulumi.Input[str] name: A friendly name for the destination. 
               This name should be unique across all destinations (regardless of type) within the data collection rule.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A friendly name for the destination. 
        This name should be unique across all destinations (regardless of type) within the data collection rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class ExtensionDataSourceArgs:
    def __init__(__self__, *,
                 extension_name: pulumi.Input[str],
                 extension_settings: Optional[Any] = None,
                 input_data_sources: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 streams: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownExtensionDataSourceStreams']]]]] = None):
        """
        Definition of which data will be collected from a separate VM extension that integrates with the Azure Monitor Agent.
        Collected from either Windows and Linux machines, depending on which extension is defined.
        :param pulumi.Input[str] extension_name: The name of the VM extension.
        :param Any extension_settings: The extension settings. The format is specific for particular extension.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] input_data_sources: The list of data sources this extension needs data from.
        :param pulumi.Input[str] name: A friendly name for the data source. 
               This name should be unique across all data sources (regardless of type) within the data collection rule.
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownExtensionDataSourceStreams']]]] streams: List of streams that this data source will be sent to.
               A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
        """
        pulumi.set(__self__, "extension_name", extension_name)
        if extension_settings is not None:
            pulumi.set(__self__, "extension_settings", extension_settings)
        if input_data_sources is not None:
            pulumi.set(__self__, "input_data_sources", input_data_sources)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if streams is not None:
            pulumi.set(__self__, "streams", streams)

    @property
    @pulumi.getter(name="extensionName")
    def extension_name(self) -> pulumi.Input[str]:
        """
        The name of the VM extension.
        """
        return pulumi.get(self, "extension_name")

    @extension_name.setter
    def extension_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "extension_name", value)

    @property
    @pulumi.getter(name="extensionSettings")
    def extension_settings(self) -> Optional[Any]:
        """
        The extension settings. The format is specific for particular extension.
        """
        return pulumi.get(self, "extension_settings")

    @extension_settings.setter
    def extension_settings(self, value: Optional[Any]):
        pulumi.set(self, "extension_settings", value)

    @property
    @pulumi.getter(name="inputDataSources")
    def input_data_sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of data sources this extension needs data from.
        """
        return pulumi.get(self, "input_data_sources")

    @input_data_sources.setter
    def input_data_sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "input_data_sources", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A friendly name for the data source. 
        This name should be unique across all data sources (regardless of type) within the data collection rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def streams(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownExtensionDataSourceStreams']]]]]:
        """
        List of streams that this data source will be sent to.
        A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
        """
        return pulumi.get(self, "streams")

    @streams.setter
    def streams(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownExtensionDataSourceStreams']]]]]):
        pulumi.set(self, "streams", value)


@pulumi.input_type
class IisLogsDataSourceArgs:
    def __init__(__self__, *,
                 streams: pulumi.Input[Sequence[pulumi.Input[str]]],
                 log_directories: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Enables IIS logs to be collected by this data collection rule.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] streams: IIS streams
        :param pulumi.Input[Sequence[pulumi.Input[str]]] log_directories: Absolute paths file location
        :param pulumi.Input[str] name: A friendly name for the data source. 
               This name should be unique across all data sources (regardless of type) within the data collection rule.
        """
        pulumi.set(__self__, "streams", streams)
        if log_directories is not None:
            pulumi.set(__self__, "log_directories", log_directories)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def streams(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        IIS streams
        """
        return pulumi.get(self, "streams")

    @streams.setter
    def streams(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "streams", value)

    @property
    @pulumi.getter(name="logDirectories")
    def log_directories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Absolute paths file location
        """
        return pulumi.get(self, "log_directories")

    @log_directories.setter
    def log_directories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "log_directories", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A friendly name for the data source. 
        This name should be unique across all data sources (regardless of type) within the data collection rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class LogAnalyticsDestinationArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 workspace_resource_id: Optional[pulumi.Input[str]] = None):
        """
        Log Analytics destination.
        :param pulumi.Input[str] name: A friendly name for the destination. 
               This name should be unique across all destinations (regardless of type) within the data collection rule.
        :param pulumi.Input[str] workspace_resource_id: The resource ID of the Log Analytics workspace.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if workspace_resource_id is not None:
            pulumi.set(__self__, "workspace_resource_id", workspace_resource_id)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A friendly name for the destination. 
        This name should be unique across all destinations (regardless of type) within the data collection rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="workspaceResourceId")
    def workspace_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The resource ID of the Log Analytics workspace.
        """
        return pulumi.get(self, "workspace_resource_id")

    @workspace_resource_id.setter
    def workspace_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "workspace_resource_id", value)


@pulumi.input_type
class LogFileSettingsTextArgs:
    def __init__(__self__, *,
                 record_start_timestamp_format: pulumi.Input[Union[str, 'KnownLogFileTextSettingsRecordStartTimestampFormat']]):
        """
        Text settings
        :param pulumi.Input[Union[str, 'KnownLogFileTextSettingsRecordStartTimestampFormat']] record_start_timestamp_format: One of the supported timestamp formats
        """
        pulumi.set(__self__, "record_start_timestamp_format", record_start_timestamp_format)

    @property
    @pulumi.getter(name="recordStartTimestampFormat")
    def record_start_timestamp_format(self) -> pulumi.Input[Union[str, 'KnownLogFileTextSettingsRecordStartTimestampFormat']]:
        """
        One of the supported timestamp formats
        """
        return pulumi.get(self, "record_start_timestamp_format")

    @record_start_timestamp_format.setter
    def record_start_timestamp_format(self, value: pulumi.Input[Union[str, 'KnownLogFileTextSettingsRecordStartTimestampFormat']]):
        pulumi.set(self, "record_start_timestamp_format", value)


@pulumi.input_type
class LogFilesDataSourceSettingsArgs:
    def __init__(__self__, *,
                 text: Optional[pulumi.Input['LogFileSettingsTextArgs']] = None):
        """
        The log files specific settings.
        :param pulumi.Input['LogFileSettingsTextArgs'] text: Text settings
        """
        if text is not None:
            pulumi.set(__self__, "text", text)

    @property
    @pulumi.getter
    def text(self) -> Optional[pulumi.Input['LogFileSettingsTextArgs']]:
        """
        Text settings
        """
        return pulumi.get(self, "text")

    @text.setter
    def text(self, value: Optional[pulumi.Input['LogFileSettingsTextArgs']]):
        pulumi.set(self, "text", value)


@pulumi.input_type
class LogFilesDataSourceArgs:
    def __init__(__self__, *,
                 file_patterns: pulumi.Input[Sequence[pulumi.Input[str]]],
                 format: pulumi.Input[Union[str, 'KnownLogFilesDataSourceFormat']],
                 streams: pulumi.Input[Sequence[pulumi.Input[str]]],
                 name: Optional[pulumi.Input[str]] = None,
                 settings: Optional[pulumi.Input['LogFilesDataSourceSettingsArgs']] = None):
        """
        Definition of which custom log files will be collected by this data collection rule
        :param pulumi.Input[Sequence[pulumi.Input[str]]] file_patterns: File Patterns where the log files are located
        :param pulumi.Input[Union[str, 'KnownLogFilesDataSourceFormat']] format: The data format of the log files
        :param pulumi.Input[Sequence[pulumi.Input[str]]] streams: List of streams that this data source will be sent to.
               A stream indicates what schema will be used for this data source
        :param pulumi.Input[str] name: A friendly name for the data source. 
               This name should be unique across all data sources (regardless of type) within the data collection rule.
        :param pulumi.Input['LogFilesDataSourceSettingsArgs'] settings: The log files specific settings.
        """
        pulumi.set(__self__, "file_patterns", file_patterns)
        pulumi.set(__self__, "format", format)
        pulumi.set(__self__, "streams", streams)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)

    @property
    @pulumi.getter(name="filePatterns")
    def file_patterns(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        File Patterns where the log files are located
        """
        return pulumi.get(self, "file_patterns")

    @file_patterns.setter
    def file_patterns(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "file_patterns", value)

    @property
    @pulumi.getter
    def format(self) -> pulumi.Input[Union[str, 'KnownLogFilesDataSourceFormat']]:
        """
        The data format of the log files
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: pulumi.Input[Union[str, 'KnownLogFilesDataSourceFormat']]):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter
    def streams(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of streams that this data source will be sent to.
        A stream indicates what schema will be used for this data source
        """
        return pulumi.get(self, "streams")

    @streams.setter
    def streams(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "streams", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A friendly name for the data source. 
        This name should be unique across all data sources (regardless of type) within the data collection rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input['LogFilesDataSourceSettingsArgs']]:
        """
        The log files specific settings.
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input['LogFilesDataSourceSettingsArgs']]):
        pulumi.set(self, "settings", value)


@pulumi.input_type
class PerfCounterDataSourceArgs:
    def __init__(__self__, *,
                 counter_specifiers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 sampling_frequency_in_seconds: Optional[pulumi.Input[int]] = None,
                 streams: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownPerfCounterDataSourceStreams']]]]] = None):
        """
        Definition of which performance counters will be collected and how they will be collected by this data collection rule.
        Collected from both Windows and Linux machines where the counter is present.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] counter_specifiers: A list of specifier names of the performance counters you want to collect.
               Use a wildcard (*) to collect a counter for all instances.
               To get a list of performance counters on Windows, run the command 'typeperf'.
        :param pulumi.Input[str] name: A friendly name for the data source. 
               This name should be unique across all data sources (regardless of type) within the data collection rule.
        :param pulumi.Input[int] sampling_frequency_in_seconds: The number of seconds between consecutive counter measurements (samples).
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownPerfCounterDataSourceStreams']]]] streams: List of streams that this data source will be sent to.
               A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
        """
        if counter_specifiers is not None:
            pulumi.set(__self__, "counter_specifiers", counter_specifiers)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if sampling_frequency_in_seconds is not None:
            pulumi.set(__self__, "sampling_frequency_in_seconds", sampling_frequency_in_seconds)
        if streams is not None:
            pulumi.set(__self__, "streams", streams)

    @property
    @pulumi.getter(name="counterSpecifiers")
    def counter_specifiers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of specifier names of the performance counters you want to collect.
        Use a wildcard (*) to collect a counter for all instances.
        To get a list of performance counters on Windows, run the command 'typeperf'.
        """
        return pulumi.get(self, "counter_specifiers")

    @counter_specifiers.setter
    def counter_specifiers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "counter_specifiers", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A friendly name for the data source. 
        This name should be unique across all data sources (regardless of type) within the data collection rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="samplingFrequencyInSeconds")
    def sampling_frequency_in_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The number of seconds between consecutive counter measurements (samples).
        """
        return pulumi.get(self, "sampling_frequency_in_seconds")

    @sampling_frequency_in_seconds.setter
    def sampling_frequency_in_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "sampling_frequency_in_seconds", value)

    @property
    @pulumi.getter
    def streams(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownPerfCounterDataSourceStreams']]]]]:
        """
        List of streams that this data source will be sent to.
        A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
        """
        return pulumi.get(self, "streams")

    @streams.setter
    def streams(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownPerfCounterDataSourceStreams']]]]]):
        pulumi.set(self, "streams", value)


@pulumi.input_type
class StreamDeclarationArgs:
    def __init__(__self__, *,
                 columns: Optional[pulumi.Input[Sequence[pulumi.Input['ColumnDefinitionArgs']]]] = None):
        """
        Declaration of a custom stream.
        :param pulumi.Input[Sequence[pulumi.Input['ColumnDefinitionArgs']]] columns: List of columns used by data in this stream.
        """
        if columns is not None:
            pulumi.set(__self__, "columns", columns)

    @property
    @pulumi.getter
    def columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ColumnDefinitionArgs']]]]:
        """
        List of columns used by data in this stream.
        """
        return pulumi.get(self, "columns")

    @columns.setter
    def columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ColumnDefinitionArgs']]]]):
        pulumi.set(self, "columns", value)


@pulumi.input_type
class SyslogDataSourceArgs:
    def __init__(__self__, *,
                 facility_names: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownSyslogDataSourceFacilityNames']]]]] = None,
                 log_levels: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownSyslogDataSourceLogLevels']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 streams: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownSyslogDataSourceStreams']]]]] = None):
        """
        Definition of which syslog data will be collected and how it will be collected.
        Only collected from Linux machines.
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownSyslogDataSourceFacilityNames']]]] facility_names: The list of facility names.
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownSyslogDataSourceLogLevels']]]] log_levels: The log levels to collect.
        :param pulumi.Input[str] name: A friendly name for the data source. 
               This name should be unique across all data sources (regardless of type) within the data collection rule.
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownSyslogDataSourceStreams']]]] streams: List of streams that this data source will be sent to.
               A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
        """
        if facility_names is not None:
            pulumi.set(__self__, "facility_names", facility_names)
        if log_levels is not None:
            pulumi.set(__self__, "log_levels", log_levels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if streams is not None:
            pulumi.set(__self__, "streams", streams)

    @property
    @pulumi.getter(name="facilityNames")
    def facility_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownSyslogDataSourceFacilityNames']]]]]:
        """
        The list of facility names.
        """
        return pulumi.get(self, "facility_names")

    @facility_names.setter
    def facility_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownSyslogDataSourceFacilityNames']]]]]):
        pulumi.set(self, "facility_names", value)

    @property
    @pulumi.getter(name="logLevels")
    def log_levels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownSyslogDataSourceLogLevels']]]]]:
        """
        The log levels to collect.
        """
        return pulumi.get(self, "log_levels")

    @log_levels.setter
    def log_levels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownSyslogDataSourceLogLevels']]]]]):
        pulumi.set(self, "log_levels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A friendly name for the data source. 
        This name should be unique across all data sources (regardless of type) within the data collection rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def streams(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownSyslogDataSourceStreams']]]]]:
        """
        List of streams that this data source will be sent to.
        A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
        """
        return pulumi.get(self, "streams")

    @streams.setter
    def streams(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownSyslogDataSourceStreams']]]]]):
        pulumi.set(self, "streams", value)


@pulumi.input_type
class WindowsEventLogDataSourceArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 streams: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownWindowsEventLogDataSourceStreams']]]]] = None,
                 x_path_queries: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Definition of which Windows Event Log events will be collected and how they will be collected.
        Only collected from Windows machines.
        :param pulumi.Input[str] name: A friendly name for the data source. 
               This name should be unique across all data sources (regardless of type) within the data collection rule.
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownWindowsEventLogDataSourceStreams']]]] streams: List of streams that this data source will be sent to.
               A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] x_path_queries: A list of Windows Event Log queries in XPATH format.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if streams is not None:
            pulumi.set(__self__, "streams", streams)
        if x_path_queries is not None:
            pulumi.set(__self__, "x_path_queries", x_path_queries)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A friendly name for the data source. 
        This name should be unique across all data sources (regardless of type) within the data collection rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def streams(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownWindowsEventLogDataSourceStreams']]]]]:
        """
        List of streams that this data source will be sent to.
        A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
        """
        return pulumi.get(self, "streams")

    @streams.setter
    def streams(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownWindowsEventLogDataSourceStreams']]]]]):
        pulumi.set(self, "streams", value)

    @property
    @pulumi.getter(name="xPathQueries")
    def x_path_queries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of Windows Event Log queries in XPATH format.
        """
        return pulumi.get(self, "x_path_queries")

    @x_path_queries.setter
    def x_path_queries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "x_path_queries", value)


