# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'LogSettingsResponse',
    'MetricSettingsResponse',
    'RetentionPolicyResponse',
    'SubscriptionLogSettingsResponse',
]

@pulumi.output_type
class LogSettingsResponse(dict):
    """
    Part of MultiTenantDiagnosticSettings. Specifies the settings for a particular log.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "retentionPolicy":
            suggest = "retention_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LogSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LogSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LogSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: bool,
                 category: Optional[str] = None,
                 retention_policy: Optional['outputs.RetentionPolicyResponse'] = None):
        """
        Part of MultiTenantDiagnosticSettings. Specifies the settings for a particular log.
        :param bool enabled: a value indicating whether this log is enabled.
        :param str category: Name of a Diagnostic Log category for a resource type this setting is applied to. To obtain the list of Diagnostic Log categories for a resource, first perform a GET diagnostic settings operation.
        :param 'RetentionPolicyResponse' retention_policy: the retention policy for this log.
        """
        pulumi.set(__self__, "enabled", enabled)
        if category is not None:
            pulumi.set(__self__, "category", category)
        if retention_policy is not None:
            pulumi.set(__self__, "retention_policy", retention_policy)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        a value indicating whether this log is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def category(self) -> Optional[str]:
        """
        Name of a Diagnostic Log category for a resource type this setting is applied to. To obtain the list of Diagnostic Log categories for a resource, first perform a GET diagnostic settings operation.
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter(name="retentionPolicy")
    def retention_policy(self) -> Optional['outputs.RetentionPolicyResponse']:
        """
        the retention policy for this log.
        """
        return pulumi.get(self, "retention_policy")


@pulumi.output_type
class MetricSettingsResponse(dict):
    """
    Part of MultiTenantDiagnosticSettings. Specifies the settings for a particular metric.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "retentionPolicy":
            suggest = "retention_policy"
        elif key == "timeGrain":
            suggest = "time_grain"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetricSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetricSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetricSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: bool,
                 category: Optional[str] = None,
                 retention_policy: Optional['outputs.RetentionPolicyResponse'] = None,
                 time_grain: Optional[str] = None):
        """
        Part of MultiTenantDiagnosticSettings. Specifies the settings for a particular metric.
        :param bool enabled: a value indicating whether this category is enabled.
        :param str category: Name of a Diagnostic Metric category for a resource type this setting is applied to. To obtain the list of Diagnostic metric categories for a resource, first perform a GET diagnostic settings operation.
        :param 'RetentionPolicyResponse' retention_policy: the retention policy for this category.
        :param str time_grain: the timegrain of the metric in ISO8601 format.
        """
        pulumi.set(__self__, "enabled", enabled)
        if category is not None:
            pulumi.set(__self__, "category", category)
        if retention_policy is not None:
            pulumi.set(__self__, "retention_policy", retention_policy)
        if time_grain is not None:
            pulumi.set(__self__, "time_grain", time_grain)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        a value indicating whether this category is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def category(self) -> Optional[str]:
        """
        Name of a Diagnostic Metric category for a resource type this setting is applied to. To obtain the list of Diagnostic metric categories for a resource, first perform a GET diagnostic settings operation.
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter(name="retentionPolicy")
    def retention_policy(self) -> Optional['outputs.RetentionPolicyResponse']:
        """
        the retention policy for this category.
        """
        return pulumi.get(self, "retention_policy")

    @property
    @pulumi.getter(name="timeGrain")
    def time_grain(self) -> Optional[str]:
        """
        the timegrain of the metric in ISO8601 format.
        """
        return pulumi.get(self, "time_grain")


@pulumi.output_type
class RetentionPolicyResponse(dict):
    """
    Specifies the retention policy for the log.
    """
    def __init__(__self__, *,
                 days: int,
                 enabled: bool):
        """
        Specifies the retention policy for the log.
        :param int days: the number of days for the retention in days. A value of 0 will retain the events indefinitely.
        :param bool enabled: a value indicating whether the retention policy is enabled.
        """
        pulumi.set(__self__, "days", days)
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def days(self) -> int:
        """
        the number of days for the retention in days. A value of 0 will retain the events indefinitely.
        """
        return pulumi.get(self, "days")

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        a value indicating whether the retention policy is enabled.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class SubscriptionLogSettingsResponse(dict):
    """
    Part of Subscription diagnostic setting. Specifies the settings for a particular log.
    """
    def __init__(__self__, *,
                 enabled: bool,
                 category: Optional[str] = None):
        """
        Part of Subscription diagnostic setting. Specifies the settings for a particular log.
        :param bool enabled: a value indicating whether this log is enabled.
        :param str category: Name of a Subscription Diagnostic Log category for a resource type this setting is applied to.
        """
        pulumi.set(__self__, "enabled", enabled)
        if category is not None:
            pulumi.set(__self__, "category", category)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        a value indicating whether this log is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def category(self) -> Optional[str]:
        """
        Name of a Subscription Diagnostic Log category for a resource type this setting is applied to.
        """
        return pulumi.get(self, "category")


