# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ActionGroupResponse',
    'ActionListResponse',
    'AlertRuleAllOfConditionResponse',
    'AlertRuleAnyOfOrLeafConditionResponse',
    'AlertRuleLeafConditionResponse',
    'AlertingActionResponse',
    'ApplicationInsightsComponentAnalyticsItemPropertiesResponse',
    'ApplicationInsightsComponentDataVolumeCapResponse',
    'ApplicationInsightsComponentProactiveDetectionConfigurationResponseRuleDefinitions',
    'ArmRoleReceiverResponse',
    'AutomationRunbookReceiverResponse',
    'AutoscaleNotificationResponse',
    'AutoscaleProfileResponse',
    'AzNsActionGroupResponse',
    'AzureAppPushReceiverResponse',
    'AzureFunctionReceiverResponse',
    'CriteriaResponse',
    'DataCollectionEndpointResourceResponseSystemData',
    'DataCollectionEndpointResponseConfigurationAccess',
    'DataCollectionEndpointResponseLogsIngestion',
    'DataCollectionEndpointResponseNetworkAcls',
    'DataCollectionRuleResponseDataSources',
    'DataCollectionRuleResponseDestinations',
    'DataFlowResponse',
    'DataSourceConfigurationResponse',
    'DataSourceResponse',
    'DestinationsSpecResponseAzureMonitorMetrics',
    'DimensionResponse',
    'DynamicMetricCriteriaResponse',
    'DynamicThresholdFailingPeriodsResponse',
    'EmailNotificationResponse',
    'EmailReceiverResponse',
    'EtwEventConfigurationResponse',
    'EtwProviderConfigurationResponse',
    'EventLogConfigurationResponse',
    'ExtensionDataSourceResponse',
    'ItsmReceiverResponse',
    'LocationThresholdRuleConditionResponse',
    'LogAnalyticsDestinationResponse',
    'LogMetricTriggerResponse',
    'LogSettingsResponse',
    'LogToMetricActionResponse',
    'LogicAppReceiverResponse',
    'ManagementEventAggregationConditionResponse',
    'ManagementEventRuleConditionResponse',
    'ManagementGroupLogSettingsResponse',
    'MetricAlertActionResponse',
    'MetricAlertMultipleResourceMultipleMetricCriteriaResponse',
    'MetricAlertSingleResourceMultipleMetricCriteriaResponse',
    'MetricCriteriaResponse',
    'MetricDimensionResponse',
    'MetricSettingsResponse',
    'MetricTriggerResponse',
    'MyWorkbookManagedIdentityResponse',
    'MyWorkbookUserAssignedIdentitiesResponse',
    'PerfCounterDataSourceResponse',
    'PerformanceCounterConfigurationResponse',
    'PrivateEndpointConnectionResponse',
    'PrivateEndpointPropertyResponse',
    'PrivateLinkScopedResourceResponse',
    'PrivateLinkServiceConnectionStatePropertyResponse',
    'RecurrenceResponse',
    'RecurrentScheduleResponse',
    'RetentionPolicyResponse',
    'RuleEmailActionResponse',
    'RuleManagementEventClaimsDataSourceResponse',
    'RuleManagementEventDataSourceResponse',
    'RuleMetricDataSourceResponse',
    'RuleWebhookActionResponse',
    'ScaleActionResponse',
    'ScaleCapacityResponse',
    'ScaleRuleMetricDimensionResponse',
    'ScaleRuleResponse',
    'ScheduleResponse',
    'SinkConfigurationResponse',
    'SmsReceiverResponse',
    'SourceResponse',
    'SubscriptionLogSettingsResponse',
    'SyslogDataSourceResponse',
    'ThresholdRuleConditionResponse',
    'TimeWindowResponse',
    'TriggerConditionResponse',
    'VoiceReceiverResponse',
    'WebTestGeolocationResponse',
    'WebTestPropertiesResponseConfiguration',
    'WebhookNotificationResponse',
    'WebhookReceiverResponse',
    'WebtestLocationAvailabilityCriteriaResponse',
    'WindowsEventLogDataSourceResponse',
    'WorkbookManagedIdentityResponse',
    'WorkbookTemplateGalleryResponse',
    'WorkbookTemplateLocalizedGalleryResponse',
    'WorkbookUserAssignedIdentitiesResponse',
]

@pulumi.output_type
class ActionGroupResponse(dict):
    """
    A pointer to an Azure Action Group.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionGroupId":
            suggest = "action_group_id"
        elif key == "webhookProperties":
            suggest = "webhook_properties"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ActionGroupResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ActionGroupResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ActionGroupResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action_group_id: str,
                 webhook_properties: Optional[Mapping[str, str]] = None):
        """
        A pointer to an Azure Action Group.
        :param str action_group_id: The resource ID of the Action Group. This cannot be null or empty.
        :param Mapping[str, str] webhook_properties: the dictionary of custom properties to include with the post operation. These data are appended to the webhook payload.
        """
        pulumi.set(__self__, "action_group_id", action_group_id)
        if webhook_properties is not None:
            pulumi.set(__self__, "webhook_properties", webhook_properties)

    @property
    @pulumi.getter(name="actionGroupId")
    def action_group_id(self) -> str:
        """
        The resource ID of the Action Group. This cannot be null or empty.
        """
        return pulumi.get(self, "action_group_id")

    @property
    @pulumi.getter(name="webhookProperties")
    def webhook_properties(self) -> Optional[Mapping[str, str]]:
        """
        the dictionary of custom properties to include with the post operation. These data are appended to the webhook payload.
        """
        return pulumi.get(self, "webhook_properties")


@pulumi.output_type
class ActionListResponse(dict):
    """
    A list of Activity Log Alert rule actions.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionGroups":
            suggest = "action_groups"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ActionListResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ActionListResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ActionListResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action_groups: Optional[Sequence['outputs.ActionGroupResponse']] = None):
        """
        A list of Activity Log Alert rule actions.
        :param Sequence['ActionGroupResponse'] action_groups: The list of the Action Groups.
        """
        if action_groups is not None:
            pulumi.set(__self__, "action_groups", action_groups)

    @property
    @pulumi.getter(name="actionGroups")
    def action_groups(self) -> Optional[Sequence['outputs.ActionGroupResponse']]:
        """
        The list of the Action Groups.
        """
        return pulumi.get(self, "action_groups")


@pulumi.output_type
class AlertRuleAllOfConditionResponse(dict):
    """
    An Activity Log Alert rule condition that is met when all its member conditions are met.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allOf":
            suggest = "all_of"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlertRuleAllOfConditionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlertRuleAllOfConditionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlertRuleAllOfConditionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 all_of: Sequence['outputs.AlertRuleAnyOfOrLeafConditionResponse']):
        """
        An Activity Log Alert rule condition that is met when all its member conditions are met.
        :param Sequence['AlertRuleAnyOfOrLeafConditionResponse'] all_of: The list of Activity Log Alert rule conditions.
        """
        pulumi.set(__self__, "all_of", all_of)

    @property
    @pulumi.getter(name="allOf")
    def all_of(self) -> Sequence['outputs.AlertRuleAnyOfOrLeafConditionResponse']:
        """
        The list of Activity Log Alert rule conditions.
        """
        return pulumi.get(self, "all_of")


@pulumi.output_type
class AlertRuleAnyOfOrLeafConditionResponse(dict):
    """
    An Activity Log Alert rule condition that is met when all its member conditions are met.
    Each condition can be of one of the following types:
    __Important__: Each type has its unique subset of properties. Properties from different types CANNOT exist in one condition.
       * __Leaf Condition -__ must contain 'field' and either 'equals' or 'containsAny'.
      _Please note, 'anyOf' should __not__ be set in a Leaf Condition._
      * __AnyOf Condition -__ must contain __only__ 'anyOf' (which is an array of Leaf Conditions).
      _Please note, 'field', 'equals' and 'containsAny' should __not__ be set in an AnyOf Condition._
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "anyOf":
            suggest = "any_of"
        elif key == "containsAny":
            suggest = "contains_any"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlertRuleAnyOfOrLeafConditionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlertRuleAnyOfOrLeafConditionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlertRuleAnyOfOrLeafConditionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 any_of: Optional[Sequence['outputs.AlertRuleLeafConditionResponse']] = None,
                 contains_any: Optional[Sequence[str]] = None,
                 equals: Optional[str] = None,
                 field: Optional[str] = None):
        """
        An Activity Log Alert rule condition that is met when all its member conditions are met.
        Each condition can be of one of the following types:
        __Important__: Each type has its unique subset of properties. Properties from different types CANNOT exist in one condition.
           * __Leaf Condition -__ must contain 'field' and either 'equals' or 'containsAny'.
          _Please note, 'anyOf' should __not__ be set in a Leaf Condition._
          * __AnyOf Condition -__ must contain __only__ 'anyOf' (which is an array of Leaf Conditions).
          _Please note, 'field', 'equals' and 'containsAny' should __not__ be set in an AnyOf Condition._

        :param Sequence['AlertRuleLeafConditionResponse'] any_of: An Activity Log Alert rule condition that is met when at least one of its member leaf conditions are met.
        :param Sequence[str] contains_any: The value of the event's field will be compared to the values in this array (case-insensitive) to determine if the condition is met.
        :param str equals: The value of the event's field will be compared to this value (case-insensitive) to determine if the condition is met.
        :param str field: The name of the Activity Log event's field that this condition will examine.
               The possible values for this field are (case-insensitive): 'resourceId', 'category', 'caller', 'level', 'operationName', 'resourceGroup', 'resourceProvider', 'status', 'subStatus', 'resourceType', or anything beginning with 'properties'.
        """
        if any_of is not None:
            pulumi.set(__self__, "any_of", any_of)
        if contains_any is not None:
            pulumi.set(__self__, "contains_any", contains_any)
        if equals is not None:
            pulumi.set(__self__, "equals", equals)
        if field is not None:
            pulumi.set(__self__, "field", field)

    @property
    @pulumi.getter(name="anyOf")
    def any_of(self) -> Optional[Sequence['outputs.AlertRuleLeafConditionResponse']]:
        """
        An Activity Log Alert rule condition that is met when at least one of its member leaf conditions are met.
        """
        return pulumi.get(self, "any_of")

    @property
    @pulumi.getter(name="containsAny")
    def contains_any(self) -> Optional[Sequence[str]]:
        """
        The value of the event's field will be compared to the values in this array (case-insensitive) to determine if the condition is met.
        """
        return pulumi.get(self, "contains_any")

    @property
    @pulumi.getter
    def equals(self) -> Optional[str]:
        """
        The value of the event's field will be compared to this value (case-insensitive) to determine if the condition is met.
        """
        return pulumi.get(self, "equals")

    @property
    @pulumi.getter
    def field(self) -> Optional[str]:
        """
        The name of the Activity Log event's field that this condition will examine.
        The possible values for this field are (case-insensitive): 'resourceId', 'category', 'caller', 'level', 'operationName', 'resourceGroup', 'resourceProvider', 'status', 'subStatus', 'resourceType', or anything beginning with 'properties'.
        """
        return pulumi.get(self, "field")


@pulumi.output_type
class AlertRuleLeafConditionResponse(dict):
    """
    An Activity Log Alert rule condition that is met by comparing the field and value of an Activity Log event.
    This condition must contain 'field' and either 'equals' or 'containsAny'.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containsAny":
            suggest = "contains_any"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlertRuleLeafConditionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlertRuleLeafConditionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlertRuleLeafConditionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 contains_any: Optional[Sequence[str]] = None,
                 equals: Optional[str] = None,
                 field: Optional[str] = None):
        """
        An Activity Log Alert rule condition that is met by comparing the field and value of an Activity Log event.
        This condition must contain 'field' and either 'equals' or 'containsAny'.
        :param Sequence[str] contains_any: The value of the event's field will be compared to the values in this array (case-insensitive) to determine if the condition is met.
        :param str equals: The value of the event's field will be compared to this value (case-insensitive) to determine if the condition is met.
        :param str field: The name of the Activity Log event's field that this condition will examine.
               The possible values for this field are (case-insensitive): 'resourceId', 'category', 'caller', 'level', 'operationName', 'resourceGroup', 'resourceProvider', 'status', 'subStatus', 'resourceType', or anything beginning with 'properties'.
        """
        if contains_any is not None:
            pulumi.set(__self__, "contains_any", contains_any)
        if equals is not None:
            pulumi.set(__self__, "equals", equals)
        if field is not None:
            pulumi.set(__self__, "field", field)

    @property
    @pulumi.getter(name="containsAny")
    def contains_any(self) -> Optional[Sequence[str]]:
        """
        The value of the event's field will be compared to the values in this array (case-insensitive) to determine if the condition is met.
        """
        return pulumi.get(self, "contains_any")

    @property
    @pulumi.getter
    def equals(self) -> Optional[str]:
        """
        The value of the event's field will be compared to this value (case-insensitive) to determine if the condition is met.
        """
        return pulumi.get(self, "equals")

    @property
    @pulumi.getter
    def field(self) -> Optional[str]:
        """
        The name of the Activity Log event's field that this condition will examine.
        The possible values for this field are (case-insensitive): 'resourceId', 'category', 'caller', 'level', 'operationName', 'resourceGroup', 'resourceProvider', 'status', 'subStatus', 'resourceType', or anything beginning with 'properties'.
        """
        return pulumi.get(self, "field")


@pulumi.output_type
class AlertingActionResponse(dict):
    """
    Specify action need to be taken when rule type is Alert
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "aznsAction":
            suggest = "azns_action"
        elif key == "throttlingInMin":
            suggest = "throttling_in_min"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlertingActionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlertingActionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlertingActionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 severity: str,
                 trigger: 'outputs.TriggerConditionResponse',
                 azns_action: Optional['outputs.AzNsActionGroupResponse'] = None,
                 throttling_in_min: Optional[int] = None):
        """
        Specify action need to be taken when rule type is Alert
        :param str odata_type: Specifies the action. Supported values - AlertingAction, LogToMetricAction
               Expected value is 'Microsoft.WindowsAzure.Management.Monitoring.Alerts.Models.Microsoft.AppInsights.Nexus.DataContracts.Resources.ScheduledQueryRules.AlertingAction'.
        :param str severity: Severity of the alert
        :param 'TriggerConditionResponse' trigger: The trigger condition that results in the alert rule being.
        :param 'AzNsActionGroupResponse' azns_action: Azure action group reference.
        :param int throttling_in_min: time (in minutes) for which Alerts should be throttled or suppressed.
        """
        pulumi.set(__self__, "odata_type", 'Microsoft.WindowsAzure.Management.Monitoring.Alerts.Models.Microsoft.AppInsights.Nexus.DataContracts.Resources.ScheduledQueryRules.AlertingAction')
        pulumi.set(__self__, "severity", severity)
        pulumi.set(__self__, "trigger", trigger)
        if azns_action is not None:
            pulumi.set(__self__, "azns_action", azns_action)
        if throttling_in_min is not None:
            pulumi.set(__self__, "throttling_in_min", throttling_in_min)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        Specifies the action. Supported values - AlertingAction, LogToMetricAction
        Expected value is 'Microsoft.WindowsAzure.Management.Monitoring.Alerts.Models.Microsoft.AppInsights.Nexus.DataContracts.Resources.ScheduledQueryRules.AlertingAction'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter
    def severity(self) -> str:
        """
        Severity of the alert
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter
    def trigger(self) -> 'outputs.TriggerConditionResponse':
        """
        The trigger condition that results in the alert rule being.
        """
        return pulumi.get(self, "trigger")

    @property
    @pulumi.getter(name="aznsAction")
    def azns_action(self) -> Optional['outputs.AzNsActionGroupResponse']:
        """
        Azure action group reference.
        """
        return pulumi.get(self, "azns_action")

    @property
    @pulumi.getter(name="throttlingInMin")
    def throttling_in_min(self) -> Optional[int]:
        """
        time (in minutes) for which Alerts should be throttled or suppressed.
        """
        return pulumi.get(self, "throttling_in_min")


@pulumi.output_type
class ApplicationInsightsComponentAnalyticsItemPropertiesResponse(dict):
    """
    A set of properties that can be defined in the context of a specific item type. Each type may have its own properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "functionAlias":
            suggest = "function_alias"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationInsightsComponentAnalyticsItemPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationInsightsComponentAnalyticsItemPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationInsightsComponentAnalyticsItemPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 function_alias: Optional[str] = None):
        """
        A set of properties that can be defined in the context of a specific item type. Each type may have its own properties.
        :param str function_alias: A function alias, used when the type of the item is Function
        """
        if function_alias is not None:
            pulumi.set(__self__, "function_alias", function_alias)

    @property
    @pulumi.getter(name="functionAlias")
    def function_alias(self) -> Optional[str]:
        """
        A function alias, used when the type of the item is Function
        """
        return pulumi.get(self, "function_alias")


@pulumi.output_type
class ApplicationInsightsComponentDataVolumeCapResponse(dict):
    """
    An Application Insights component daily data volume cap
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxHistoryCap":
            suggest = "max_history_cap"
        elif key == "resetTime":
            suggest = "reset_time"
        elif key == "stopSendNotificationWhenHitCap":
            suggest = "stop_send_notification_when_hit_cap"
        elif key == "stopSendNotificationWhenHitThreshold":
            suggest = "stop_send_notification_when_hit_threshold"
        elif key == "warningThreshold":
            suggest = "warning_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationInsightsComponentDataVolumeCapResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationInsightsComponentDataVolumeCapResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationInsightsComponentDataVolumeCapResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_history_cap: float,
                 reset_time: int,
                 cap: Optional[float] = None,
                 stop_send_notification_when_hit_cap: Optional[bool] = None,
                 stop_send_notification_when_hit_threshold: Optional[bool] = None,
                 warning_threshold: Optional[int] = None):
        """
        An Application Insights component daily data volume cap
        :param float max_history_cap: Maximum daily data volume cap that the user can set for this component.
        :param int reset_time: Daily data volume cap UTC reset hour.
        :param float cap: Daily data volume cap in GB.
        :param bool stop_send_notification_when_hit_cap: Do not send a notification email when the daily data volume cap is met.
        :param bool stop_send_notification_when_hit_threshold: Reserved, not used for now.
        :param int warning_threshold: Reserved, not used for now.
        """
        pulumi.set(__self__, "max_history_cap", max_history_cap)
        pulumi.set(__self__, "reset_time", reset_time)
        if cap is not None:
            pulumi.set(__self__, "cap", cap)
        if stop_send_notification_when_hit_cap is not None:
            pulumi.set(__self__, "stop_send_notification_when_hit_cap", stop_send_notification_when_hit_cap)
        if stop_send_notification_when_hit_threshold is not None:
            pulumi.set(__self__, "stop_send_notification_when_hit_threshold", stop_send_notification_when_hit_threshold)
        if warning_threshold is not None:
            pulumi.set(__self__, "warning_threshold", warning_threshold)

    @property
    @pulumi.getter(name="maxHistoryCap")
    def max_history_cap(self) -> float:
        """
        Maximum daily data volume cap that the user can set for this component.
        """
        return pulumi.get(self, "max_history_cap")

    @property
    @pulumi.getter(name="resetTime")
    def reset_time(self) -> int:
        """
        Daily data volume cap UTC reset hour.
        """
        return pulumi.get(self, "reset_time")

    @property
    @pulumi.getter
    def cap(self) -> Optional[float]:
        """
        Daily data volume cap in GB.
        """
        return pulumi.get(self, "cap")

    @property
    @pulumi.getter(name="stopSendNotificationWhenHitCap")
    def stop_send_notification_when_hit_cap(self) -> Optional[bool]:
        """
        Do not send a notification email when the daily data volume cap is met.
        """
        return pulumi.get(self, "stop_send_notification_when_hit_cap")

    @property
    @pulumi.getter(name="stopSendNotificationWhenHitThreshold")
    def stop_send_notification_when_hit_threshold(self) -> Optional[bool]:
        """
        Reserved, not used for now.
        """
        return pulumi.get(self, "stop_send_notification_when_hit_threshold")

    @property
    @pulumi.getter(name="warningThreshold")
    def warning_threshold(self) -> Optional[int]:
        """
        Reserved, not used for now.
        """
        return pulumi.get(self, "warning_threshold")


@pulumi.output_type
class ApplicationInsightsComponentProactiveDetectionConfigurationResponseRuleDefinitions(dict):
    """
    Static definitions of the ProactiveDetection configuration rule (same values for all components).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"
        elif key == "helpUrl":
            suggest = "help_url"
        elif key == "isEnabledByDefault":
            suggest = "is_enabled_by_default"
        elif key == "isHidden":
            suggest = "is_hidden"
        elif key == "isInPreview":
            suggest = "is_in_preview"
        elif key == "supportsEmailNotifications":
            suggest = "supports_email_notifications"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationInsightsComponentProactiveDetectionConfigurationResponseRuleDefinitions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationInsightsComponentProactiveDetectionConfigurationResponseRuleDefinitions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationInsightsComponentProactiveDetectionConfigurationResponseRuleDefinitions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: Optional[str] = None,
                 display_name: Optional[str] = None,
                 help_url: Optional[str] = None,
                 is_enabled_by_default: Optional[bool] = None,
                 is_hidden: Optional[bool] = None,
                 is_in_preview: Optional[bool] = None,
                 name: Optional[str] = None,
                 supports_email_notifications: Optional[bool] = None):
        """
        Static definitions of the ProactiveDetection configuration rule (same values for all components).
        :param str description: The rule description
        :param str display_name: The rule name as it is displayed in UI
        :param str help_url: URL which displays additional info about the proactive detection rule
        :param bool is_enabled_by_default: A flag indicating whether the rule is enabled by default
        :param bool is_hidden: A flag indicating whether the rule is hidden (from the UI)
        :param bool is_in_preview: A flag indicating whether the rule is in preview
        :param str name: The rule name
        :param bool supports_email_notifications: A flag indicating whether email notifications are supported for detections for this rule
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if help_url is not None:
            pulumi.set(__self__, "help_url", help_url)
        if is_enabled_by_default is not None:
            pulumi.set(__self__, "is_enabled_by_default", is_enabled_by_default)
        if is_hidden is not None:
            pulumi.set(__self__, "is_hidden", is_hidden)
        if is_in_preview is not None:
            pulumi.set(__self__, "is_in_preview", is_in_preview)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if supports_email_notifications is not None:
            pulumi.set(__self__, "supports_email_notifications", supports_email_notifications)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The rule description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The rule name as it is displayed in UI
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="helpUrl")
    def help_url(self) -> Optional[str]:
        """
        URL which displays additional info about the proactive detection rule
        """
        return pulumi.get(self, "help_url")

    @property
    @pulumi.getter(name="isEnabledByDefault")
    def is_enabled_by_default(self) -> Optional[bool]:
        """
        A flag indicating whether the rule is enabled by default
        """
        return pulumi.get(self, "is_enabled_by_default")

    @property
    @pulumi.getter(name="isHidden")
    def is_hidden(self) -> Optional[bool]:
        """
        A flag indicating whether the rule is hidden (from the UI)
        """
        return pulumi.get(self, "is_hidden")

    @property
    @pulumi.getter(name="isInPreview")
    def is_in_preview(self) -> Optional[bool]:
        """
        A flag indicating whether the rule is in preview
        """
        return pulumi.get(self, "is_in_preview")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The rule name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="supportsEmailNotifications")
    def supports_email_notifications(self) -> Optional[bool]:
        """
        A flag indicating whether email notifications are supported for detections for this rule
        """
        return pulumi.get(self, "supports_email_notifications")


@pulumi.output_type
class ArmRoleReceiverResponse(dict):
    """
    An arm role receiver.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleId":
            suggest = "role_id"
        elif key == "useCommonAlertSchema":
            suggest = "use_common_alert_schema"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ArmRoleReceiverResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ArmRoleReceiverResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ArmRoleReceiverResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 role_id: str,
                 use_common_alert_schema: Optional[bool] = None):
        """
        An arm role receiver.
        :param str name: The name of the arm role receiver. Names must be unique across all receivers within an action group.
        :param str role_id: The arm role id.
        :param bool use_common_alert_schema: Indicates whether to use common alert schema.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "role_id", role_id)
        if use_common_alert_schema is None:
            use_common_alert_schema = False
        if use_common_alert_schema is not None:
            pulumi.set(__self__, "use_common_alert_schema", use_common_alert_schema)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the arm role receiver. Names must be unique across all receivers within an action group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="roleId")
    def role_id(self) -> str:
        """
        The arm role id.
        """
        return pulumi.get(self, "role_id")

    @property
    @pulumi.getter(name="useCommonAlertSchema")
    def use_common_alert_schema(self) -> Optional[bool]:
        """
        Indicates whether to use common alert schema.
        """
        return pulumi.get(self, "use_common_alert_schema")


@pulumi.output_type
class AutomationRunbookReceiverResponse(dict):
    """
    The Azure Automation Runbook notification receiver.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "automationAccountId":
            suggest = "automation_account_id"
        elif key == "isGlobalRunbook":
            suggest = "is_global_runbook"
        elif key == "runbookName":
            suggest = "runbook_name"
        elif key == "webhookResourceId":
            suggest = "webhook_resource_id"
        elif key == "serviceUri":
            suggest = "service_uri"
        elif key == "useCommonAlertSchema":
            suggest = "use_common_alert_schema"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutomationRunbookReceiverResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutomationRunbookReceiverResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutomationRunbookReceiverResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 automation_account_id: str,
                 is_global_runbook: bool,
                 runbook_name: str,
                 webhook_resource_id: str,
                 name: Optional[str] = None,
                 service_uri: Optional[str] = None,
                 use_common_alert_schema: Optional[bool] = None):
        """
        The Azure Automation Runbook notification receiver.
        :param str automation_account_id: The Azure automation account Id which holds this runbook and authenticate to Azure resource.
        :param bool is_global_runbook: Indicates whether this instance is global runbook.
        :param str runbook_name: The name for this runbook.
        :param str webhook_resource_id: The resource id for webhook linked to this runbook.
        :param str name: Indicates name of the webhook.
        :param str service_uri: The URI where webhooks should be sent.
        :param bool use_common_alert_schema: Indicates whether to use common alert schema.
        """
        pulumi.set(__self__, "automation_account_id", automation_account_id)
        pulumi.set(__self__, "is_global_runbook", is_global_runbook)
        pulumi.set(__self__, "runbook_name", runbook_name)
        pulumi.set(__self__, "webhook_resource_id", webhook_resource_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if service_uri is not None:
            pulumi.set(__self__, "service_uri", service_uri)
        if use_common_alert_schema is None:
            use_common_alert_schema = False
        if use_common_alert_schema is not None:
            pulumi.set(__self__, "use_common_alert_schema", use_common_alert_schema)

    @property
    @pulumi.getter(name="automationAccountId")
    def automation_account_id(self) -> str:
        """
        The Azure automation account Id which holds this runbook and authenticate to Azure resource.
        """
        return pulumi.get(self, "automation_account_id")

    @property
    @pulumi.getter(name="isGlobalRunbook")
    def is_global_runbook(self) -> bool:
        """
        Indicates whether this instance is global runbook.
        """
        return pulumi.get(self, "is_global_runbook")

    @property
    @pulumi.getter(name="runbookName")
    def runbook_name(self) -> str:
        """
        The name for this runbook.
        """
        return pulumi.get(self, "runbook_name")

    @property
    @pulumi.getter(name="webhookResourceId")
    def webhook_resource_id(self) -> str:
        """
        The resource id for webhook linked to this runbook.
        """
        return pulumi.get(self, "webhook_resource_id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Indicates name of the webhook.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="serviceUri")
    def service_uri(self) -> Optional[str]:
        """
        The URI where webhooks should be sent.
        """
        return pulumi.get(self, "service_uri")

    @property
    @pulumi.getter(name="useCommonAlertSchema")
    def use_common_alert_schema(self) -> Optional[bool]:
        """
        Indicates whether to use common alert schema.
        """
        return pulumi.get(self, "use_common_alert_schema")


@pulumi.output_type
class AutoscaleNotificationResponse(dict):
    """
    Autoscale notification.
    """
    def __init__(__self__, *,
                 operation: str,
                 email: Optional['outputs.EmailNotificationResponse'] = None,
                 webhooks: Optional[Sequence['outputs.WebhookNotificationResponse']] = None):
        """
        Autoscale notification.
        :param str operation: the operation associated with the notification and its value must be "scale"
        :param 'EmailNotificationResponse' email: the email notification.
        :param Sequence['WebhookNotificationResponse'] webhooks: the collection of webhook notifications.
        """
        pulumi.set(__self__, "operation", operation)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if webhooks is not None:
            pulumi.set(__self__, "webhooks", webhooks)

    @property
    @pulumi.getter
    def operation(self) -> str:
        """
        the operation associated with the notification and its value must be "scale"
        """
        return pulumi.get(self, "operation")

    @property
    @pulumi.getter
    def email(self) -> Optional['outputs.EmailNotificationResponse']:
        """
        the email notification.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def webhooks(self) -> Optional[Sequence['outputs.WebhookNotificationResponse']]:
        """
        the collection of webhook notifications.
        """
        return pulumi.get(self, "webhooks")


@pulumi.output_type
class AutoscaleProfileResponse(dict):
    """
    Autoscale profile.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fixedDate":
            suggest = "fixed_date"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoscaleProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoscaleProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoscaleProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 capacity: 'outputs.ScaleCapacityResponse',
                 name: str,
                 rules: Sequence['outputs.ScaleRuleResponse'],
                 fixed_date: Optional['outputs.TimeWindowResponse'] = None,
                 recurrence: Optional['outputs.RecurrenceResponse'] = None):
        """
        Autoscale profile.
        :param 'ScaleCapacityResponse' capacity: the number of instances that can be used during this profile.
        :param str name: the name of the profile.
        :param Sequence['ScaleRuleResponse'] rules: the collection of rules that provide the triggers and parameters for the scaling action. A maximum of 10 rules can be specified.
        :param 'TimeWindowResponse' fixed_date: the specific date-time for the profile. This element is not used if the Recurrence element is used.
        :param 'RecurrenceResponse' recurrence: the repeating times at which this profile begins. This element is not used if the FixedDate element is used.
        """
        pulumi.set(__self__, "capacity", capacity)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "rules", rules)
        if fixed_date is not None:
            pulumi.set(__self__, "fixed_date", fixed_date)
        if recurrence is not None:
            pulumi.set(__self__, "recurrence", recurrence)

    @property
    @pulumi.getter
    def capacity(self) -> 'outputs.ScaleCapacityResponse':
        """
        the number of instances that can be used during this profile.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        the name of the profile.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.ScaleRuleResponse']:
        """
        the collection of rules that provide the triggers and parameters for the scaling action. A maximum of 10 rules can be specified.
        """
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter(name="fixedDate")
    def fixed_date(self) -> Optional['outputs.TimeWindowResponse']:
        """
        the specific date-time for the profile. This element is not used if the Recurrence element is used.
        """
        return pulumi.get(self, "fixed_date")

    @property
    @pulumi.getter
    def recurrence(self) -> Optional['outputs.RecurrenceResponse']:
        """
        the repeating times at which this profile begins. This element is not used if the FixedDate element is used.
        """
        return pulumi.get(self, "recurrence")


@pulumi.output_type
class AzNsActionGroupResponse(dict):
    """
    Azure action group
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionGroup":
            suggest = "action_group"
        elif key == "customWebhookPayload":
            suggest = "custom_webhook_payload"
        elif key == "emailSubject":
            suggest = "email_subject"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzNsActionGroupResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzNsActionGroupResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzNsActionGroupResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action_group: Optional[Sequence[str]] = None,
                 custom_webhook_payload: Optional[str] = None,
                 email_subject: Optional[str] = None):
        """
        Azure action group
        :param Sequence[str] action_group: Azure Action Group reference.
        :param str custom_webhook_payload: Custom payload to be sent for all webhook URI in Azure action group
        :param str email_subject: Custom subject override for all email ids in Azure action group
        """
        if action_group is not None:
            pulumi.set(__self__, "action_group", action_group)
        if custom_webhook_payload is not None:
            pulumi.set(__self__, "custom_webhook_payload", custom_webhook_payload)
        if email_subject is not None:
            pulumi.set(__self__, "email_subject", email_subject)

    @property
    @pulumi.getter(name="actionGroup")
    def action_group(self) -> Optional[Sequence[str]]:
        """
        Azure Action Group reference.
        """
        return pulumi.get(self, "action_group")

    @property
    @pulumi.getter(name="customWebhookPayload")
    def custom_webhook_payload(self) -> Optional[str]:
        """
        Custom payload to be sent for all webhook URI in Azure action group
        """
        return pulumi.get(self, "custom_webhook_payload")

    @property
    @pulumi.getter(name="emailSubject")
    def email_subject(self) -> Optional[str]:
        """
        Custom subject override for all email ids in Azure action group
        """
        return pulumi.get(self, "email_subject")


@pulumi.output_type
class AzureAppPushReceiverResponse(dict):
    """
    The Azure mobile App push notification receiver.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "emailAddress":
            suggest = "email_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureAppPushReceiverResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureAppPushReceiverResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureAppPushReceiverResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 email_address: str,
                 name: str):
        """
        The Azure mobile App push notification receiver.
        :param str email_address: The email address registered for the Azure mobile app.
        :param str name: The name of the Azure mobile app push receiver. Names must be unique across all receivers within an action group.
        """
        pulumi.set(__self__, "email_address", email_address)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="emailAddress")
    def email_address(self) -> str:
        """
        The email address registered for the Azure mobile app.
        """
        return pulumi.get(self, "email_address")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the Azure mobile app push receiver. Names must be unique across all receivers within an action group.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class AzureFunctionReceiverResponse(dict):
    """
    An azure function receiver.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "functionAppResourceId":
            suggest = "function_app_resource_id"
        elif key == "functionName":
            suggest = "function_name"
        elif key == "httpTriggerUrl":
            suggest = "http_trigger_url"
        elif key == "useCommonAlertSchema":
            suggest = "use_common_alert_schema"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureFunctionReceiverResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureFunctionReceiverResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureFunctionReceiverResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 function_app_resource_id: str,
                 function_name: str,
                 http_trigger_url: str,
                 name: str,
                 use_common_alert_schema: Optional[bool] = None):
        """
        An azure function receiver.
        :param str function_app_resource_id: The azure resource id of the function app.
        :param str function_name: The function name in the function app.
        :param str http_trigger_url: The http trigger url where http request sent to.
        :param str name: The name of the azure function receiver. Names must be unique across all receivers within an action group.
        :param bool use_common_alert_schema: Indicates whether to use common alert schema.
        """
        pulumi.set(__self__, "function_app_resource_id", function_app_resource_id)
        pulumi.set(__self__, "function_name", function_name)
        pulumi.set(__self__, "http_trigger_url", http_trigger_url)
        pulumi.set(__self__, "name", name)
        if use_common_alert_schema is None:
            use_common_alert_schema = False
        if use_common_alert_schema is not None:
            pulumi.set(__self__, "use_common_alert_schema", use_common_alert_schema)

    @property
    @pulumi.getter(name="functionAppResourceId")
    def function_app_resource_id(self) -> str:
        """
        The azure resource id of the function app.
        """
        return pulumi.get(self, "function_app_resource_id")

    @property
    @pulumi.getter(name="functionName")
    def function_name(self) -> str:
        """
        The function name in the function app.
        """
        return pulumi.get(self, "function_name")

    @property
    @pulumi.getter(name="httpTriggerUrl")
    def http_trigger_url(self) -> str:
        """
        The http trigger url where http request sent to.
        """
        return pulumi.get(self, "http_trigger_url")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the azure function receiver. Names must be unique across all receivers within an action group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="useCommonAlertSchema")
    def use_common_alert_schema(self) -> Optional[bool]:
        """
        Indicates whether to use common alert schema.
        """
        return pulumi.get(self, "use_common_alert_schema")


@pulumi.output_type
class CriteriaResponse(dict):
    """
    Specifies the criteria for converting log to metric.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricName":
            suggest = "metric_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CriteriaResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CriteriaResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CriteriaResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metric_name: str,
                 dimensions: Optional[Sequence['outputs.DimensionResponse']] = None):
        """
        Specifies the criteria for converting log to metric.
        :param str metric_name: Name of the metric
        :param Sequence['DimensionResponse'] dimensions: List of Dimensions for creating metric
        """
        pulumi.set(__self__, "metric_name", metric_name)
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> str:
        """
        Name of the metric
        """
        return pulumi.get(self, "metric_name")

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[Sequence['outputs.DimensionResponse']]:
        """
        List of Dimensions for creating metric
        """
        return pulumi.get(self, "dimensions")


@pulumi.output_type
class DataCollectionEndpointResourceResponseSystemData(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataCollectionEndpointResourceResponseSystemData. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataCollectionEndpointResourceResponseSystemData.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataCollectionEndpointResourceResponseSystemData.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The timestamp of resource last modification (UTC)
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The timestamp of resource last modification (UTC)
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


@pulumi.output_type
class DataCollectionEndpointResponseConfigurationAccess(dict):
    """
    The endpoint used by clients to access their configuration.
    """
    def __init__(__self__, *,
                 endpoint: str):
        """
        The endpoint used by clients to access their configuration.
        :param str endpoint: The endpoint. This property is READ-ONLY.
        """
        pulumi.set(__self__, "endpoint", endpoint)

    @property
    @pulumi.getter
    def endpoint(self) -> str:
        """
        The endpoint. This property is READ-ONLY.
        """
        return pulumi.get(self, "endpoint")


@pulumi.output_type
class DataCollectionEndpointResponseLogsIngestion(dict):
    """
    The endpoint used by clients to ingest logs.
    """
    def __init__(__self__, *,
                 endpoint: str):
        """
        The endpoint used by clients to ingest logs.
        :param str endpoint: The endpoint. This property is READ-ONLY.
        """
        pulumi.set(__self__, "endpoint", endpoint)

    @property
    @pulumi.getter
    def endpoint(self) -> str:
        """
        The endpoint. This property is READ-ONLY.
        """
        return pulumi.get(self, "endpoint")


@pulumi.output_type
class DataCollectionEndpointResponseNetworkAcls(dict):
    """
    Network access control rules for the endpoints.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicNetworkAccess":
            suggest = "public_network_access"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataCollectionEndpointResponseNetworkAcls. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataCollectionEndpointResponseNetworkAcls.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataCollectionEndpointResponseNetworkAcls.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 public_network_access: Optional[str] = None):
        """
        Network access control rules for the endpoints.
        :param str public_network_access: The configuration to set whether network access from public internet to the endpoints are allowed.
        """
        if public_network_access is not None:
            pulumi.set(__self__, "public_network_access", public_network_access)

    @property
    @pulumi.getter(name="publicNetworkAccess")
    def public_network_access(self) -> Optional[str]:
        """
        The configuration to set whether network access from public internet to the endpoints are allowed.
        """
        return pulumi.get(self, "public_network_access")


@pulumi.output_type
class DataCollectionRuleResponseDataSources(dict):
    """
    The specification of data sources. 
    This property is optional and can be omitted if the rule is meant to be used via direct calls to the provisioned endpoint.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "performanceCounters":
            suggest = "performance_counters"
        elif key == "windowsEventLogs":
            suggest = "windows_event_logs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataCollectionRuleResponseDataSources. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataCollectionRuleResponseDataSources.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataCollectionRuleResponseDataSources.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 extensions: Optional[Sequence['outputs.ExtensionDataSourceResponse']] = None,
                 performance_counters: Optional[Sequence['outputs.PerfCounterDataSourceResponse']] = None,
                 syslog: Optional[Sequence['outputs.SyslogDataSourceResponse']] = None,
                 windows_event_logs: Optional[Sequence['outputs.WindowsEventLogDataSourceResponse']] = None):
        """
        The specification of data sources. 
        This property is optional and can be omitted if the rule is meant to be used via direct calls to the provisioned endpoint.
        :param Sequence['ExtensionDataSourceResponse'] extensions: The list of Azure VM extension data source configurations.
        :param Sequence['PerfCounterDataSourceResponse'] performance_counters: The list of performance counter data source configurations.
        :param Sequence['SyslogDataSourceResponse'] syslog: The list of Syslog data source configurations.
        :param Sequence['WindowsEventLogDataSourceResponse'] windows_event_logs: The list of Windows Event Log data source configurations.
        """
        if extensions is not None:
            pulumi.set(__self__, "extensions", extensions)
        if performance_counters is not None:
            pulumi.set(__self__, "performance_counters", performance_counters)
        if syslog is not None:
            pulumi.set(__self__, "syslog", syslog)
        if windows_event_logs is not None:
            pulumi.set(__self__, "windows_event_logs", windows_event_logs)

    @property
    @pulumi.getter
    def extensions(self) -> Optional[Sequence['outputs.ExtensionDataSourceResponse']]:
        """
        The list of Azure VM extension data source configurations.
        """
        return pulumi.get(self, "extensions")

    @property
    @pulumi.getter(name="performanceCounters")
    def performance_counters(self) -> Optional[Sequence['outputs.PerfCounterDataSourceResponse']]:
        """
        The list of performance counter data source configurations.
        """
        return pulumi.get(self, "performance_counters")

    @property
    @pulumi.getter
    def syslog(self) -> Optional[Sequence['outputs.SyslogDataSourceResponse']]:
        """
        The list of Syslog data source configurations.
        """
        return pulumi.get(self, "syslog")

    @property
    @pulumi.getter(name="windowsEventLogs")
    def windows_event_logs(self) -> Optional[Sequence['outputs.WindowsEventLogDataSourceResponse']]:
        """
        The list of Windows Event Log data source configurations.
        """
        return pulumi.get(self, "windows_event_logs")


@pulumi.output_type
class DataCollectionRuleResponseDestinations(dict):
    """
    The specification of destinations.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "azureMonitorMetrics":
            suggest = "azure_monitor_metrics"
        elif key == "logAnalytics":
            suggest = "log_analytics"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataCollectionRuleResponseDestinations. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataCollectionRuleResponseDestinations.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataCollectionRuleResponseDestinations.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 azure_monitor_metrics: Optional['outputs.DestinationsSpecResponseAzureMonitorMetrics'] = None,
                 log_analytics: Optional[Sequence['outputs.LogAnalyticsDestinationResponse']] = None):
        """
        The specification of destinations.
        :param 'DestinationsSpecResponseAzureMonitorMetrics' azure_monitor_metrics: Azure Monitor Metrics destination.
        :param Sequence['LogAnalyticsDestinationResponse'] log_analytics: List of Log Analytics destinations.
        """
        if azure_monitor_metrics is not None:
            pulumi.set(__self__, "azure_monitor_metrics", azure_monitor_metrics)
        if log_analytics is not None:
            pulumi.set(__self__, "log_analytics", log_analytics)

    @property
    @pulumi.getter(name="azureMonitorMetrics")
    def azure_monitor_metrics(self) -> Optional['outputs.DestinationsSpecResponseAzureMonitorMetrics']:
        """
        Azure Monitor Metrics destination.
        """
        return pulumi.get(self, "azure_monitor_metrics")

    @property
    @pulumi.getter(name="logAnalytics")
    def log_analytics(self) -> Optional[Sequence['outputs.LogAnalyticsDestinationResponse']]:
        """
        List of Log Analytics destinations.
        """
        return pulumi.get(self, "log_analytics")


@pulumi.output_type
class DataFlowResponse(dict):
    """
    Definition of which streams are sent to which destinations.
    """
    def __init__(__self__, *,
                 destinations: Optional[Sequence[str]] = None,
                 streams: Optional[Sequence[str]] = None):
        """
        Definition of which streams are sent to which destinations.
        :param Sequence[str] destinations: List of destinations for this data flow.
        :param Sequence[str] streams: List of streams for this data flow.
        """
        if destinations is not None:
            pulumi.set(__self__, "destinations", destinations)
        if streams is not None:
            pulumi.set(__self__, "streams", streams)

    @property
    @pulumi.getter
    def destinations(self) -> Optional[Sequence[str]]:
        """
        List of destinations for this data flow.
        """
        return pulumi.get(self, "destinations")

    @property
    @pulumi.getter
    def streams(self) -> Optional[Sequence[str]]:
        """
        List of streams for this data flow.
        """
        return pulumi.get(self, "streams")


@pulumi.output_type
class DataSourceConfigurationResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eventLogs":
            suggest = "event_logs"
        elif key == "perfCounters":
            suggest = "perf_counters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 event_logs: Optional[Sequence['outputs.EventLogConfigurationResponse']] = None,
                 perf_counters: Optional[Sequence['outputs.PerformanceCounterConfigurationResponse']] = None,
                 providers: Optional[Sequence['outputs.EtwProviderConfigurationResponse']] = None):
        """
        :param Sequence['EventLogConfigurationResponse'] event_logs: Windows event logs configuration.
        :param Sequence['PerformanceCounterConfigurationResponse'] perf_counters: Performance counter configuration
        :param Sequence['EtwProviderConfigurationResponse'] providers: ETW providers configuration
        """
        if event_logs is not None:
            pulumi.set(__self__, "event_logs", event_logs)
        if perf_counters is not None:
            pulumi.set(__self__, "perf_counters", perf_counters)
        if providers is not None:
            pulumi.set(__self__, "providers", providers)

    @property
    @pulumi.getter(name="eventLogs")
    def event_logs(self) -> Optional[Sequence['outputs.EventLogConfigurationResponse']]:
        """
        Windows event logs configuration.
        """
        return pulumi.get(self, "event_logs")

    @property
    @pulumi.getter(name="perfCounters")
    def perf_counters(self) -> Optional[Sequence['outputs.PerformanceCounterConfigurationResponse']]:
        """
        Performance counter configuration
        """
        return pulumi.get(self, "perf_counters")

    @property
    @pulumi.getter
    def providers(self) -> Optional[Sequence['outputs.EtwProviderConfigurationResponse']]:
        """
        ETW providers configuration
        """
        return pulumi.get(self, "providers")


@pulumi.output_type
class DataSourceResponse(dict):
    """
    Data source object contains configuration to collect telemetry and one or more sinks to send that telemetry data to
    """
    def __init__(__self__, *,
                 configuration: 'outputs.DataSourceConfigurationResponse',
                 kind: str,
                 sinks: Sequence['outputs.SinkConfigurationResponse']):
        """
        Data source object contains configuration to collect telemetry and one or more sinks to send that telemetry data to
        :param str kind: Datasource kind
        """
        pulumi.set(__self__, "configuration", configuration)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "sinks", sinks)

    @property
    @pulumi.getter
    def configuration(self) -> 'outputs.DataSourceConfigurationResponse':
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        Datasource kind
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def sinks(self) -> Sequence['outputs.SinkConfigurationResponse']:
        return pulumi.get(self, "sinks")


@pulumi.output_type
class DestinationsSpecResponseAzureMonitorMetrics(dict):
    """
    Azure Monitor Metrics destination.
    """
    def __init__(__self__, *,
                 name: Optional[str] = None):
        """
        Azure Monitor Metrics destination.
        :param str name: A friendly name for the destination. 
               This name should be unique across all destinations (regardless of type) within the data collection rule.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        A friendly name for the destination. 
        This name should be unique across all destinations (regardless of type) within the data collection rule.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class DimensionResponse(dict):
    """
    Specifies the criteria for converting log to metric.
    """
    def __init__(__self__, *,
                 name: str,
                 operator: str,
                 values: Sequence[str]):
        """
        Specifies the criteria for converting log to metric.
        :param str name: Name of the dimension
        :param str operator: Operator for dimension values
        :param Sequence[str] values: List of dimension values
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the dimension
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def operator(self) -> str:
        """
        Operator for dimension values
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        List of dimension values
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class DynamicMetricCriteriaResponse(dict):
    """
    Criterion for dynamic threshold.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "alertSensitivity":
            suggest = "alert_sensitivity"
        elif key == "criterionType":
            suggest = "criterion_type"
        elif key == "failingPeriods":
            suggest = "failing_periods"
        elif key == "metricName":
            suggest = "metric_name"
        elif key == "timeAggregation":
            suggest = "time_aggregation"
        elif key == "ignoreDataBefore":
            suggest = "ignore_data_before"
        elif key == "metricNamespace":
            suggest = "metric_namespace"
        elif key == "skipMetricValidation":
            suggest = "skip_metric_validation"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DynamicMetricCriteriaResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DynamicMetricCriteriaResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DynamicMetricCriteriaResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alert_sensitivity: str,
                 criterion_type: str,
                 failing_periods: 'outputs.DynamicThresholdFailingPeriodsResponse',
                 metric_name: str,
                 name: str,
                 operator: str,
                 time_aggregation: str,
                 dimensions: Optional[Sequence['outputs.MetricDimensionResponse']] = None,
                 ignore_data_before: Optional[str] = None,
                 metric_namespace: Optional[str] = None,
                 skip_metric_validation: Optional[bool] = None):
        """
        Criterion for dynamic threshold.
        :param str alert_sensitivity: The extent of deviation required to trigger an alert. This will affect how tight the threshold is to the metric series pattern.
        :param str criterion_type: Specifies the type of threshold criteria
               Expected value is 'DynamicThresholdCriterion'.
        :param 'DynamicThresholdFailingPeriodsResponse' failing_periods: The minimum number of violations required within the selected lookback time window required to raise an alert.
        :param str metric_name: Name of the metric.
        :param str name: Name of the criteria.
        :param str operator: The operator used to compare the metric value against the threshold.
        :param str time_aggregation: the criteria time aggregation types.
        :param Sequence['MetricDimensionResponse'] dimensions: List of dimension conditions.
        :param str ignore_data_before: Use this option to set the date from which to start learning the metric historical data and calculate the dynamic thresholds (in ISO8601 format)
        :param str metric_namespace: Namespace of the metric.
        :param bool skip_metric_validation: Allows creating an alert rule on a custom metric that isn't yet emitted, by causing the metric validation to be skipped.
        """
        pulumi.set(__self__, "alert_sensitivity", alert_sensitivity)
        pulumi.set(__self__, "criterion_type", 'DynamicThresholdCriterion')
        pulumi.set(__self__, "failing_periods", failing_periods)
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "time_aggregation", time_aggregation)
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if ignore_data_before is not None:
            pulumi.set(__self__, "ignore_data_before", ignore_data_before)
        if metric_namespace is not None:
            pulumi.set(__self__, "metric_namespace", metric_namespace)
        if skip_metric_validation is not None:
            pulumi.set(__self__, "skip_metric_validation", skip_metric_validation)

    @property
    @pulumi.getter(name="alertSensitivity")
    def alert_sensitivity(self) -> str:
        """
        The extent of deviation required to trigger an alert. This will affect how tight the threshold is to the metric series pattern.
        """
        return pulumi.get(self, "alert_sensitivity")

    @property
    @pulumi.getter(name="criterionType")
    def criterion_type(self) -> str:
        """
        Specifies the type of threshold criteria
        Expected value is 'DynamicThresholdCriterion'.
        """
        return pulumi.get(self, "criterion_type")

    @property
    @pulumi.getter(name="failingPeriods")
    def failing_periods(self) -> 'outputs.DynamicThresholdFailingPeriodsResponse':
        """
        The minimum number of violations required within the selected lookback time window required to raise an alert.
        """
        return pulumi.get(self, "failing_periods")

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> str:
        """
        Name of the metric.
        """
        return pulumi.get(self, "metric_name")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the criteria.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def operator(self) -> str:
        """
        The operator used to compare the metric value against the threshold.
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter(name="timeAggregation")
    def time_aggregation(self) -> str:
        """
        the criteria time aggregation types.
        """
        return pulumi.get(self, "time_aggregation")

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[Sequence['outputs.MetricDimensionResponse']]:
        """
        List of dimension conditions.
        """
        return pulumi.get(self, "dimensions")

    @property
    @pulumi.getter(name="ignoreDataBefore")
    def ignore_data_before(self) -> Optional[str]:
        """
        Use this option to set the date from which to start learning the metric historical data and calculate the dynamic thresholds (in ISO8601 format)
        """
        return pulumi.get(self, "ignore_data_before")

    @property
    @pulumi.getter(name="metricNamespace")
    def metric_namespace(self) -> Optional[str]:
        """
        Namespace of the metric.
        """
        return pulumi.get(self, "metric_namespace")

    @property
    @pulumi.getter(name="skipMetricValidation")
    def skip_metric_validation(self) -> Optional[bool]:
        """
        Allows creating an alert rule on a custom metric that isn't yet emitted, by causing the metric validation to be skipped.
        """
        return pulumi.get(self, "skip_metric_validation")


@pulumi.output_type
class DynamicThresholdFailingPeriodsResponse(dict):
    """
    The minimum number of violations required within the selected lookback time window required to raise an alert.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "minFailingPeriodsToAlert":
            suggest = "min_failing_periods_to_alert"
        elif key == "numberOfEvaluationPeriods":
            suggest = "number_of_evaluation_periods"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DynamicThresholdFailingPeriodsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DynamicThresholdFailingPeriodsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DynamicThresholdFailingPeriodsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 min_failing_periods_to_alert: float,
                 number_of_evaluation_periods: float):
        """
        The minimum number of violations required within the selected lookback time window required to raise an alert.
        :param float min_failing_periods_to_alert: The number of violations to trigger an alert. Should be smaller or equal to numberOfEvaluationPeriods.
        :param float number_of_evaluation_periods: The number of aggregated lookback points. The lookback time window is calculated based on the aggregation granularity (windowSize) and the selected number of aggregated points.
        """
        pulumi.set(__self__, "min_failing_periods_to_alert", min_failing_periods_to_alert)
        pulumi.set(__self__, "number_of_evaluation_periods", number_of_evaluation_periods)

    @property
    @pulumi.getter(name="minFailingPeriodsToAlert")
    def min_failing_periods_to_alert(self) -> float:
        """
        The number of violations to trigger an alert. Should be smaller or equal to numberOfEvaluationPeriods.
        """
        return pulumi.get(self, "min_failing_periods_to_alert")

    @property
    @pulumi.getter(name="numberOfEvaluationPeriods")
    def number_of_evaluation_periods(self) -> float:
        """
        The number of aggregated lookback points. The lookback time window is calculated based on the aggregation granularity (windowSize) and the selected number of aggregated points.
        """
        return pulumi.get(self, "number_of_evaluation_periods")


@pulumi.output_type
class EmailNotificationResponse(dict):
    """
    Email notification of an autoscale event.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customEmails":
            suggest = "custom_emails"
        elif key == "sendToSubscriptionAdministrator":
            suggest = "send_to_subscription_administrator"
        elif key == "sendToSubscriptionCoAdministrators":
            suggest = "send_to_subscription_co_administrators"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EmailNotificationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EmailNotificationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EmailNotificationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_emails: Optional[Sequence[str]] = None,
                 send_to_subscription_administrator: Optional[bool] = None,
                 send_to_subscription_co_administrators: Optional[bool] = None):
        """
        Email notification of an autoscale event.
        :param Sequence[str] custom_emails: the custom e-mails list. This value can be null or empty, in which case this attribute will be ignored.
        :param bool send_to_subscription_administrator: a value indicating whether to send email to subscription administrator.
        :param bool send_to_subscription_co_administrators: a value indicating whether to send email to subscription co-administrators.
        """
        if custom_emails is not None:
            pulumi.set(__self__, "custom_emails", custom_emails)
        if send_to_subscription_administrator is None:
            send_to_subscription_administrator = False
        if send_to_subscription_administrator is not None:
            pulumi.set(__self__, "send_to_subscription_administrator", send_to_subscription_administrator)
        if send_to_subscription_co_administrators is None:
            send_to_subscription_co_administrators = False
        if send_to_subscription_co_administrators is not None:
            pulumi.set(__self__, "send_to_subscription_co_administrators", send_to_subscription_co_administrators)

    @property
    @pulumi.getter(name="customEmails")
    def custom_emails(self) -> Optional[Sequence[str]]:
        """
        the custom e-mails list. This value can be null or empty, in which case this attribute will be ignored.
        """
        return pulumi.get(self, "custom_emails")

    @property
    @pulumi.getter(name="sendToSubscriptionAdministrator")
    def send_to_subscription_administrator(self) -> Optional[bool]:
        """
        a value indicating whether to send email to subscription administrator.
        """
        return pulumi.get(self, "send_to_subscription_administrator")

    @property
    @pulumi.getter(name="sendToSubscriptionCoAdministrators")
    def send_to_subscription_co_administrators(self) -> Optional[bool]:
        """
        a value indicating whether to send email to subscription co-administrators.
        """
        return pulumi.get(self, "send_to_subscription_co_administrators")


@pulumi.output_type
class EmailReceiverResponse(dict):
    """
    An email receiver.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "emailAddress":
            suggest = "email_address"
        elif key == "useCommonAlertSchema":
            suggest = "use_common_alert_schema"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EmailReceiverResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EmailReceiverResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EmailReceiverResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 email_address: str,
                 name: str,
                 status: str,
                 use_common_alert_schema: Optional[bool] = None):
        """
        An email receiver.
        :param str email_address: The email address of this receiver.
        :param str name: The name of the email receiver. Names must be unique across all receivers within an action group.
        :param str status: The receiver status of the e-mail.
        :param bool use_common_alert_schema: Indicates whether to use common alert schema.
        """
        pulumi.set(__self__, "email_address", email_address)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "status", status)
        if use_common_alert_schema is None:
            use_common_alert_schema = False
        if use_common_alert_schema is not None:
            pulumi.set(__self__, "use_common_alert_schema", use_common_alert_schema)

    @property
    @pulumi.getter(name="emailAddress")
    def email_address(self) -> str:
        """
        The email address of this receiver.
        """
        return pulumi.get(self, "email_address")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the email receiver. Names must be unique across all receivers within an action group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The receiver status of the e-mail.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="useCommonAlertSchema")
    def use_common_alert_schema(self) -> Optional[bool]:
        """
        Indicates whether to use common alert schema.
        """
        return pulumi.get(self, "use_common_alert_schema")


@pulumi.output_type
class EtwEventConfigurationResponse(dict):
    def __init__(__self__, *,
                 id: int,
                 name: str,
                 filter: Optional[str] = None):
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)

    @property
    @pulumi.getter
    def id(self) -> int:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def filter(self) -> Optional[str]:
        return pulumi.get(self, "filter")


@pulumi.output_type
class EtwProviderConfigurationResponse(dict):
    def __init__(__self__, *,
                 events: Sequence['outputs.EtwEventConfigurationResponse'],
                 id: str):
        pulumi.set(__self__, "events", events)
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def events(self) -> Sequence['outputs.EtwEventConfigurationResponse']:
        return pulumi.get(self, "events")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")


@pulumi.output_type
class EventLogConfigurationResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logName":
            suggest = "log_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventLogConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventLogConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventLogConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 log_name: str,
                 filter: Optional[str] = None):
        pulumi.set(__self__, "log_name", log_name)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)

    @property
    @pulumi.getter(name="logName")
    def log_name(self) -> str:
        return pulumi.get(self, "log_name")

    @property
    @pulumi.getter
    def filter(self) -> Optional[str]:
        return pulumi.get(self, "filter")


@pulumi.output_type
class ExtensionDataSourceResponse(dict):
    """
    Definition of which data will be collected from a separate VM extension that integrates with the Azure Monitor Agent.
    Collected from either Windows and Linux machines, depending on which extension is defined.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "extensionName":
            suggest = "extension_name"
        elif key == "extensionSettings":
            suggest = "extension_settings"
        elif key == "inputDataSources":
            suggest = "input_data_sources"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExtensionDataSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExtensionDataSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExtensionDataSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 extension_name: str,
                 extension_settings: Optional[Any] = None,
                 input_data_sources: Optional[Sequence[str]] = None,
                 name: Optional[str] = None,
                 streams: Optional[Sequence[str]] = None):
        """
        Definition of which data will be collected from a separate VM extension that integrates with the Azure Monitor Agent.
        Collected from either Windows and Linux machines, depending on which extension is defined.
        :param str extension_name: The name of the VM extension.
        :param Any extension_settings: The extension settings. The format is specific for particular extension.
        :param Sequence[str] input_data_sources: The list of data sources this extension needs data from.
        :param str name: A friendly name for the data source. 
               This name should be unique across all data sources (regardless of type) within the data collection rule.
        :param Sequence[str] streams: List of streams that this data source will be sent to.
               A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
        """
        pulumi.set(__self__, "extension_name", extension_name)
        if extension_settings is not None:
            pulumi.set(__self__, "extension_settings", extension_settings)
        if input_data_sources is not None:
            pulumi.set(__self__, "input_data_sources", input_data_sources)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if streams is not None:
            pulumi.set(__self__, "streams", streams)

    @property
    @pulumi.getter(name="extensionName")
    def extension_name(self) -> str:
        """
        The name of the VM extension.
        """
        return pulumi.get(self, "extension_name")

    @property
    @pulumi.getter(name="extensionSettings")
    def extension_settings(self) -> Optional[Any]:
        """
        The extension settings. The format is specific for particular extension.
        """
        return pulumi.get(self, "extension_settings")

    @property
    @pulumi.getter(name="inputDataSources")
    def input_data_sources(self) -> Optional[Sequence[str]]:
        """
        The list of data sources this extension needs data from.
        """
        return pulumi.get(self, "input_data_sources")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        A friendly name for the data source. 
        This name should be unique across all data sources (regardless of type) within the data collection rule.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def streams(self) -> Optional[Sequence[str]]:
        """
        List of streams that this data source will be sent to.
        A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
        """
        return pulumi.get(self, "streams")


@pulumi.output_type
class ItsmReceiverResponse(dict):
    """
    An Itsm receiver.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionId":
            suggest = "connection_id"
        elif key == "ticketConfiguration":
            suggest = "ticket_configuration"
        elif key == "workspaceId":
            suggest = "workspace_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ItsmReceiverResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ItsmReceiverResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ItsmReceiverResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_id: str,
                 name: str,
                 region: str,
                 ticket_configuration: str,
                 workspace_id: str):
        """
        An Itsm receiver.
        :param str connection_id: Unique identification of ITSM connection among multiple defined in above workspace.
        :param str name: The name of the Itsm receiver. Names must be unique across all receivers within an action group.
        :param str region: Region in which workspace resides. Supported values:'centralindia','japaneast','southeastasia','australiasoutheast','uksouth','westcentralus','canadacentral','eastus','westeurope'
        :param str ticket_configuration: JSON blob for the configurations of the ITSM action. CreateMultipleWorkItems option will be part of this blob as well.
        :param str workspace_id: OMS LA instance identifier.
        """
        pulumi.set(__self__, "connection_id", connection_id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "ticket_configuration", ticket_configuration)
        pulumi.set(__self__, "workspace_id", workspace_id)

    @property
    @pulumi.getter(name="connectionId")
    def connection_id(self) -> str:
        """
        Unique identification of ITSM connection among multiple defined in above workspace.
        """
        return pulumi.get(self, "connection_id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the Itsm receiver. Names must be unique across all receivers within an action group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        Region in which workspace resides. Supported values:'centralindia','japaneast','southeastasia','australiasoutheast','uksouth','westcentralus','canadacentral','eastus','westeurope'
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="ticketConfiguration")
    def ticket_configuration(self) -> str:
        """
        JSON blob for the configurations of the ITSM action. CreateMultipleWorkItems option will be part of this blob as well.
        """
        return pulumi.get(self, "ticket_configuration")

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> str:
        """
        OMS LA instance identifier.
        """
        return pulumi.get(self, "workspace_id")


@pulumi.output_type
class LocationThresholdRuleConditionResponse(dict):
    """
    A rule condition based on a certain number of locations failing.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failedLocationCount":
            suggest = "failed_location_count"
        elif key == "odataType":
            suggest = "odata_type"
        elif key == "dataSource":
            suggest = "data_source"
        elif key == "windowSize":
            suggest = "window_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LocationThresholdRuleConditionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LocationThresholdRuleConditionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LocationThresholdRuleConditionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 failed_location_count: int,
                 odata_type: str,
                 data_source: Optional[Any] = None,
                 window_size: Optional[str] = None):
        """
        A rule condition based on a certain number of locations failing.
        :param int failed_location_count: the number of locations that must fail to activate the alert.
        :param str odata_type: specifies the type of condition. This can be one of three types: ManagementEventRuleCondition (occurrences of management events), LocationThresholdRuleCondition (based on the number of failures of a web test), and ThresholdRuleCondition (based on the threshold of a metric).
               Expected value is 'Microsoft.Azure.Management.Insights.Models.LocationThresholdRuleCondition'.
        :param Union['RuleManagementEventDataSourceResponse', 'RuleMetricDataSourceResponse'] data_source: the resource from which the rule collects its data. For this type dataSource will always be of type RuleMetricDataSource.
        :param str window_size: the period of time (in ISO 8601 duration format) that is used to monitor alert activity based on the threshold. If specified then it must be between 5 minutes and 1 day.
        """
        pulumi.set(__self__, "failed_location_count", failed_location_count)
        pulumi.set(__self__, "odata_type", 'Microsoft.Azure.Management.Insights.Models.LocationThresholdRuleCondition')
        if data_source is not None:
            pulumi.set(__self__, "data_source", data_source)
        if window_size is not None:
            pulumi.set(__self__, "window_size", window_size)

    @property
    @pulumi.getter(name="failedLocationCount")
    def failed_location_count(self) -> int:
        """
        the number of locations that must fail to activate the alert.
        """
        return pulumi.get(self, "failed_location_count")

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        specifies the type of condition. This can be one of three types: ManagementEventRuleCondition (occurrences of management events), LocationThresholdRuleCondition (based on the number of failures of a web test), and ThresholdRuleCondition (based on the threshold of a metric).
        Expected value is 'Microsoft.Azure.Management.Insights.Models.LocationThresholdRuleCondition'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="dataSource")
    def data_source(self) -> Optional[Any]:
        """
        the resource from which the rule collects its data. For this type dataSource will always be of type RuleMetricDataSource.
        """
        return pulumi.get(self, "data_source")

    @property
    @pulumi.getter(name="windowSize")
    def window_size(self) -> Optional[str]:
        """
        the period of time (in ISO 8601 duration format) that is used to monitor alert activity based on the threshold. If specified then it must be between 5 minutes and 1 day.
        """
        return pulumi.get(self, "window_size")


@pulumi.output_type
class LogAnalyticsDestinationResponse(dict):
    """
    Log Analytics destination.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "workspaceId":
            suggest = "workspace_id"
        elif key == "workspaceResourceId":
            suggest = "workspace_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LogAnalyticsDestinationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LogAnalyticsDestinationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LogAnalyticsDestinationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 workspace_id: str,
                 name: Optional[str] = None,
                 workspace_resource_id: Optional[str] = None):
        """
        Log Analytics destination.
        :param str workspace_id: The Customer ID of the Log Analytics workspace.
        :param str name: A friendly name for the destination. 
               This name should be unique across all destinations (regardless of type) within the data collection rule.
        :param str workspace_resource_id: The resource ID of the Log Analytics workspace.
        """
        pulumi.set(__self__, "workspace_id", workspace_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if workspace_resource_id is not None:
            pulumi.set(__self__, "workspace_resource_id", workspace_resource_id)

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> str:
        """
        The Customer ID of the Log Analytics workspace.
        """
        return pulumi.get(self, "workspace_id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        A friendly name for the destination. 
        This name should be unique across all destinations (regardless of type) within the data collection rule.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="workspaceResourceId")
    def workspace_resource_id(self) -> Optional[str]:
        """
        The resource ID of the Log Analytics workspace.
        """
        return pulumi.get(self, "workspace_resource_id")


@pulumi.output_type
class LogMetricTriggerResponse(dict):
    """
    A log metrics trigger descriptor.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricColumn":
            suggest = "metric_column"
        elif key == "metricTriggerType":
            suggest = "metric_trigger_type"
        elif key == "thresholdOperator":
            suggest = "threshold_operator"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LogMetricTriggerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LogMetricTriggerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LogMetricTriggerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metric_column: Optional[str] = None,
                 metric_trigger_type: Optional[str] = None,
                 threshold: Optional[float] = None,
                 threshold_operator: Optional[str] = None):
        """
        A log metrics trigger descriptor.
        :param str metric_column: Evaluation of metric on a particular column
        :param str metric_trigger_type: Metric Trigger Type - 'Consecutive' or 'Total'
        :param float threshold: The threshold of the metric trigger.
        :param str threshold_operator: Evaluation operation for Metric -'GreaterThan' or 'LessThan' or 'Equal'.
        """
        if metric_column is not None:
            pulumi.set(__self__, "metric_column", metric_column)
        if metric_trigger_type is not None:
            pulumi.set(__self__, "metric_trigger_type", metric_trigger_type)
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)
        if threshold_operator is not None:
            pulumi.set(__self__, "threshold_operator", threshold_operator)

    @property
    @pulumi.getter(name="metricColumn")
    def metric_column(self) -> Optional[str]:
        """
        Evaluation of metric on a particular column
        """
        return pulumi.get(self, "metric_column")

    @property
    @pulumi.getter(name="metricTriggerType")
    def metric_trigger_type(self) -> Optional[str]:
        """
        Metric Trigger Type - 'Consecutive' or 'Total'
        """
        return pulumi.get(self, "metric_trigger_type")

    @property
    @pulumi.getter
    def threshold(self) -> Optional[float]:
        """
        The threshold of the metric trigger.
        """
        return pulumi.get(self, "threshold")

    @property
    @pulumi.getter(name="thresholdOperator")
    def threshold_operator(self) -> Optional[str]:
        """
        Evaluation operation for Metric -'GreaterThan' or 'LessThan' or 'Equal'.
        """
        return pulumi.get(self, "threshold_operator")


@pulumi.output_type
class LogSettingsResponse(dict):
    """
    Part of MultiTenantDiagnosticSettings. Specifies the settings for a particular log.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "retentionPolicy":
            suggest = "retention_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LogSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LogSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LogSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: bool,
                 category: Optional[str] = None,
                 retention_policy: Optional['outputs.RetentionPolicyResponse'] = None):
        """
        Part of MultiTenantDiagnosticSettings. Specifies the settings for a particular log.
        :param bool enabled: a value indicating whether this log is enabled.
        :param str category: Name of a Diagnostic Log category for a resource type this setting is applied to. To obtain the list of Diagnostic Log categories for a resource, first perform a GET diagnostic settings operation.
        :param 'RetentionPolicyResponse' retention_policy: the retention policy for this log.
        """
        pulumi.set(__self__, "enabled", enabled)
        if category is not None:
            pulumi.set(__self__, "category", category)
        if retention_policy is not None:
            pulumi.set(__self__, "retention_policy", retention_policy)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        a value indicating whether this log is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def category(self) -> Optional[str]:
        """
        Name of a Diagnostic Log category for a resource type this setting is applied to. To obtain the list of Diagnostic Log categories for a resource, first perform a GET diagnostic settings operation.
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter(name="retentionPolicy")
    def retention_policy(self) -> Optional['outputs.RetentionPolicyResponse']:
        """
        the retention policy for this log.
        """
        return pulumi.get(self, "retention_policy")


@pulumi.output_type
class LogToMetricActionResponse(dict):
    """
    Specify action need to be taken when rule type is converting log to metric
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LogToMetricActionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LogToMetricActionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LogToMetricActionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 criteria: Sequence['outputs.CriteriaResponse'],
                 odata_type: str):
        """
        Specify action need to be taken when rule type is converting log to metric
        :param Sequence['CriteriaResponse'] criteria: Criteria of Metric
        :param str odata_type: Specifies the action. Supported values - AlertingAction, LogToMetricAction
               Expected value is 'Microsoft.WindowsAzure.Management.Monitoring.Alerts.Models.Microsoft.AppInsights.Nexus.DataContracts.Resources.ScheduledQueryRules.LogToMetricAction'.
        """
        pulumi.set(__self__, "criteria", criteria)
        pulumi.set(__self__, "odata_type", 'Microsoft.WindowsAzure.Management.Monitoring.Alerts.Models.Microsoft.AppInsights.Nexus.DataContracts.Resources.ScheduledQueryRules.LogToMetricAction')

    @property
    @pulumi.getter
    def criteria(self) -> Sequence['outputs.CriteriaResponse']:
        """
        Criteria of Metric
        """
        return pulumi.get(self, "criteria")

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        Specifies the action. Supported values - AlertingAction, LogToMetricAction
        Expected value is 'Microsoft.WindowsAzure.Management.Monitoring.Alerts.Models.Microsoft.AppInsights.Nexus.DataContracts.Resources.ScheduledQueryRules.LogToMetricAction'.
        """
        return pulumi.get(self, "odata_type")


@pulumi.output_type
class LogicAppReceiverResponse(dict):
    """
    A logic app receiver.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "callbackUrl":
            suggest = "callback_url"
        elif key == "resourceId":
            suggest = "resource_id"
        elif key == "useCommonAlertSchema":
            suggest = "use_common_alert_schema"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LogicAppReceiverResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LogicAppReceiverResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LogicAppReceiverResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 callback_url: str,
                 name: str,
                 resource_id: str,
                 use_common_alert_schema: Optional[bool] = None):
        """
        A logic app receiver.
        :param str callback_url: The callback url where http request sent to.
        :param str name: The name of the logic app receiver. Names must be unique across all receivers within an action group.
        :param str resource_id: The azure resource id of the logic app receiver.
        :param bool use_common_alert_schema: Indicates whether to use common alert schema.
        """
        pulumi.set(__self__, "callback_url", callback_url)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "resource_id", resource_id)
        if use_common_alert_schema is None:
            use_common_alert_schema = False
        if use_common_alert_schema is not None:
            pulumi.set(__self__, "use_common_alert_schema", use_common_alert_schema)

    @property
    @pulumi.getter(name="callbackUrl")
    def callback_url(self) -> str:
        """
        The callback url where http request sent to.
        """
        return pulumi.get(self, "callback_url")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the logic app receiver. Names must be unique across all receivers within an action group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> str:
        """
        The azure resource id of the logic app receiver.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="useCommonAlertSchema")
    def use_common_alert_schema(self) -> Optional[bool]:
        """
        Indicates whether to use common alert schema.
        """
        return pulumi.get(self, "use_common_alert_schema")


@pulumi.output_type
class ManagementEventAggregationConditionResponse(dict):
    """
    How the data that is collected should be combined over time.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "windowSize":
            suggest = "window_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagementEventAggregationConditionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagementEventAggregationConditionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagementEventAggregationConditionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operator: Optional[str] = None,
                 threshold: Optional[float] = None,
                 window_size: Optional[str] = None):
        """
        How the data that is collected should be combined over time.
        :param str operator: the condition operator.
        :param float threshold: The threshold value that activates the alert.
        :param str window_size: the period of time (in ISO 8601 duration format) that is used to monitor alert activity based on the threshold. If specified then it must be between 5 minutes and 1 day.
        """
        if operator is not None:
            pulumi.set(__self__, "operator", operator)
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)
        if window_size is not None:
            pulumi.set(__self__, "window_size", window_size)

    @property
    @pulumi.getter
    def operator(self) -> Optional[str]:
        """
        the condition operator.
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter
    def threshold(self) -> Optional[float]:
        """
        The threshold value that activates the alert.
        """
        return pulumi.get(self, "threshold")

    @property
    @pulumi.getter(name="windowSize")
    def window_size(self) -> Optional[str]:
        """
        the period of time (in ISO 8601 duration format) that is used to monitor alert activity based on the threshold. If specified then it must be between 5 minutes and 1 day.
        """
        return pulumi.get(self, "window_size")


@pulumi.output_type
class ManagementEventRuleConditionResponse(dict):
    """
    A management event rule condition.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "dataSource":
            suggest = "data_source"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagementEventRuleConditionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagementEventRuleConditionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagementEventRuleConditionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 aggregation: Optional['outputs.ManagementEventAggregationConditionResponse'] = None,
                 data_source: Optional[Any] = None):
        """
        A management event rule condition.
        :param str odata_type: specifies the type of condition. This can be one of three types: ManagementEventRuleCondition (occurrences of management events), LocationThresholdRuleCondition (based on the number of failures of a web test), and ThresholdRuleCondition (based on the threshold of a metric).
               Expected value is 'Microsoft.Azure.Management.Insights.Models.ManagementEventRuleCondition'.
        :param 'ManagementEventAggregationConditionResponse' aggregation: How the data that is collected should be combined over time and when the alert is activated. Note that for management event alerts aggregation is optional – if it is not provided then any event will cause the alert to activate.
        :param Union['RuleManagementEventDataSourceResponse', 'RuleMetricDataSourceResponse'] data_source: the resource from which the rule collects its data. For this type dataSource will always be of type RuleMetricDataSource.
        """
        pulumi.set(__self__, "odata_type", 'Microsoft.Azure.Management.Insights.Models.ManagementEventRuleCondition')
        if aggregation is not None:
            pulumi.set(__self__, "aggregation", aggregation)
        if data_source is not None:
            pulumi.set(__self__, "data_source", data_source)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        specifies the type of condition. This can be one of three types: ManagementEventRuleCondition (occurrences of management events), LocationThresholdRuleCondition (based on the number of failures of a web test), and ThresholdRuleCondition (based on the threshold of a metric).
        Expected value is 'Microsoft.Azure.Management.Insights.Models.ManagementEventRuleCondition'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter
    def aggregation(self) -> Optional['outputs.ManagementEventAggregationConditionResponse']:
        """
        How the data that is collected should be combined over time and when the alert is activated. Note that for management event alerts aggregation is optional – if it is not provided then any event will cause the alert to activate.
        """
        return pulumi.get(self, "aggregation")

    @property
    @pulumi.getter(name="dataSource")
    def data_source(self) -> Optional[Any]:
        """
        the resource from which the rule collects its data. For this type dataSource will always be of type RuleMetricDataSource.
        """
        return pulumi.get(self, "data_source")


@pulumi.output_type
class ManagementGroupLogSettingsResponse(dict):
    """
    Part of Management Group diagnostic setting. Specifies the settings for a particular log.
    """
    def __init__(__self__, *,
                 category: str,
                 enabled: bool):
        """
        Part of Management Group diagnostic setting. Specifies the settings for a particular log.
        :param str category: Name of a Management Group Diagnostic Log category for a resource type this setting is applied to.
        :param bool enabled: a value indicating whether this log is enabled.
        """
        pulumi.set(__self__, "category", category)
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def category(self) -> str:
        """
        Name of a Management Group Diagnostic Log category for a resource type this setting is applied to.
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        a value indicating whether this log is enabled.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class MetricAlertActionResponse(dict):
    """
    An alert action.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionGroupId":
            suggest = "action_group_id"
        elif key == "webHookProperties":
            suggest = "web_hook_properties"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetricAlertActionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetricAlertActionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetricAlertActionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action_group_id: Optional[str] = None,
                 web_hook_properties: Optional[Mapping[str, str]] = None):
        """
        An alert action.
        :param str action_group_id: the id of the action group to use.
        :param Mapping[str, str] web_hook_properties: This field allows specifying custom properties, which would be appended to the alert payload sent as input to the webhook.
        """
        if action_group_id is not None:
            pulumi.set(__self__, "action_group_id", action_group_id)
        if web_hook_properties is not None:
            pulumi.set(__self__, "web_hook_properties", web_hook_properties)

    @property
    @pulumi.getter(name="actionGroupId")
    def action_group_id(self) -> Optional[str]:
        """
        the id of the action group to use.
        """
        return pulumi.get(self, "action_group_id")

    @property
    @pulumi.getter(name="webHookProperties")
    def web_hook_properties(self) -> Optional[Mapping[str, str]]:
        """
        This field allows specifying custom properties, which would be appended to the alert payload sent as input to the webhook.
        """
        return pulumi.get(self, "web_hook_properties")


@pulumi.output_type
class MetricAlertMultipleResourceMultipleMetricCriteriaResponse(dict):
    """
    Specifies the metric alert criteria for multiple resource that has multiple metric criteria.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "allOf":
            suggest = "all_of"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetricAlertMultipleResourceMultipleMetricCriteriaResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetricAlertMultipleResourceMultipleMetricCriteriaResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetricAlertMultipleResourceMultipleMetricCriteriaResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 all_of: Optional[Sequence[Any]] = None):
        """
        Specifies the metric alert criteria for multiple resource that has multiple metric criteria.
        :param str odata_type: specifies the type of the alert criteria.
               Expected value is 'Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria'.
        :param Sequence[Union['DynamicMetricCriteriaResponse', 'MetricCriteriaResponse']] all_of: the list of multiple metric criteria for this 'all of' operation. 
        """
        pulumi.set(__self__, "odata_type", 'Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria')
        if all_of is not None:
            pulumi.set(__self__, "all_of", all_of)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        specifies the type of the alert criteria.
        Expected value is 'Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="allOf")
    def all_of(self) -> Optional[Sequence[Any]]:
        """
        the list of multiple metric criteria for this 'all of' operation. 
        """
        return pulumi.get(self, "all_of")


@pulumi.output_type
class MetricAlertSingleResourceMultipleMetricCriteriaResponse(dict):
    """
    Specifies the metric alert criteria for a single resource that has multiple metric criteria.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "allOf":
            suggest = "all_of"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetricAlertSingleResourceMultipleMetricCriteriaResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetricAlertSingleResourceMultipleMetricCriteriaResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetricAlertSingleResourceMultipleMetricCriteriaResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 all_of: Optional[Sequence['outputs.MetricCriteriaResponse']] = None):
        """
        Specifies the metric alert criteria for a single resource that has multiple metric criteria.
        :param str odata_type: specifies the type of the alert criteria.
               Expected value is 'Microsoft.Azure.Monitor.SingleResourceMultipleMetricCriteria'.
        :param Sequence['MetricCriteriaResponse'] all_of: The list of metric criteria for this 'all of' operation. 
        """
        pulumi.set(__self__, "odata_type", 'Microsoft.Azure.Monitor.SingleResourceMultipleMetricCriteria')
        if all_of is not None:
            pulumi.set(__self__, "all_of", all_of)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        specifies the type of the alert criteria.
        Expected value is 'Microsoft.Azure.Monitor.SingleResourceMultipleMetricCriteria'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="allOf")
    def all_of(self) -> Optional[Sequence['outputs.MetricCriteriaResponse']]:
        """
        The list of metric criteria for this 'all of' operation. 
        """
        return pulumi.get(self, "all_of")


@pulumi.output_type
class MetricCriteriaResponse(dict):
    """
    Criterion to filter metrics.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "criterionType":
            suggest = "criterion_type"
        elif key == "metricName":
            suggest = "metric_name"
        elif key == "timeAggregation":
            suggest = "time_aggregation"
        elif key == "metricNamespace":
            suggest = "metric_namespace"
        elif key == "skipMetricValidation":
            suggest = "skip_metric_validation"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetricCriteriaResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetricCriteriaResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetricCriteriaResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 criterion_type: str,
                 metric_name: str,
                 name: str,
                 operator: str,
                 threshold: float,
                 time_aggregation: str,
                 dimensions: Optional[Sequence['outputs.MetricDimensionResponse']] = None,
                 metric_namespace: Optional[str] = None,
                 skip_metric_validation: Optional[bool] = None):
        """
        Criterion to filter metrics.
        :param str criterion_type: Specifies the type of threshold criteria
               Expected value is 'StaticThresholdCriterion'.
        :param str metric_name: Name of the metric.
        :param str name: Name of the criteria.
        :param str operator: the criteria operator.
        :param float threshold: the criteria threshold value that activates the alert.
        :param str time_aggregation: the criteria time aggregation types.
        :param Sequence['MetricDimensionResponse'] dimensions: List of dimension conditions.
        :param str metric_namespace: Namespace of the metric.
        :param bool skip_metric_validation: Allows creating an alert rule on a custom metric that isn't yet emitted, by causing the metric validation to be skipped.
        """
        pulumi.set(__self__, "criterion_type", 'StaticThresholdCriterion')
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "threshold", threshold)
        pulumi.set(__self__, "time_aggregation", time_aggregation)
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if metric_namespace is not None:
            pulumi.set(__self__, "metric_namespace", metric_namespace)
        if skip_metric_validation is not None:
            pulumi.set(__self__, "skip_metric_validation", skip_metric_validation)

    @property
    @pulumi.getter(name="criterionType")
    def criterion_type(self) -> str:
        """
        Specifies the type of threshold criteria
        Expected value is 'StaticThresholdCriterion'.
        """
        return pulumi.get(self, "criterion_type")

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> str:
        """
        Name of the metric.
        """
        return pulumi.get(self, "metric_name")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the criteria.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def operator(self) -> str:
        """
        the criteria operator.
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter
    def threshold(self) -> float:
        """
        the criteria threshold value that activates the alert.
        """
        return pulumi.get(self, "threshold")

    @property
    @pulumi.getter(name="timeAggregation")
    def time_aggregation(self) -> str:
        """
        the criteria time aggregation types.
        """
        return pulumi.get(self, "time_aggregation")

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[Sequence['outputs.MetricDimensionResponse']]:
        """
        List of dimension conditions.
        """
        return pulumi.get(self, "dimensions")

    @property
    @pulumi.getter(name="metricNamespace")
    def metric_namespace(self) -> Optional[str]:
        """
        Namespace of the metric.
        """
        return pulumi.get(self, "metric_namespace")

    @property
    @pulumi.getter(name="skipMetricValidation")
    def skip_metric_validation(self) -> Optional[bool]:
        """
        Allows creating an alert rule on a custom metric that isn't yet emitted, by causing the metric validation to be skipped.
        """
        return pulumi.get(self, "skip_metric_validation")


@pulumi.output_type
class MetricDimensionResponse(dict):
    """
    Specifies a metric dimension.
    """
    def __init__(__self__, *,
                 name: str,
                 operator: str,
                 values: Sequence[str]):
        """
        Specifies a metric dimension.
        :param str name: Name of the dimension.
        :param str operator: the dimension operator. Only 'Include' and 'Exclude' are supported
        :param Sequence[str] values: list of dimension values.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the dimension.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def operator(self) -> str:
        """
        the dimension operator. Only 'Include' and 'Exclude' are supported
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        list of dimension values.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class MetricSettingsResponse(dict):
    """
    Part of MultiTenantDiagnosticSettings. Specifies the settings for a particular metric.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "retentionPolicy":
            suggest = "retention_policy"
        elif key == "timeGrain":
            suggest = "time_grain"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetricSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetricSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetricSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: bool,
                 category: Optional[str] = None,
                 retention_policy: Optional['outputs.RetentionPolicyResponse'] = None,
                 time_grain: Optional[str] = None):
        """
        Part of MultiTenantDiagnosticSettings. Specifies the settings for a particular metric.
        :param bool enabled: a value indicating whether this category is enabled.
        :param str category: Name of a Diagnostic Metric category for a resource type this setting is applied to. To obtain the list of Diagnostic metric categories for a resource, first perform a GET diagnostic settings operation.
        :param 'RetentionPolicyResponse' retention_policy: the retention policy for this category.
        :param str time_grain: the timegrain of the metric in ISO8601 format.
        """
        pulumi.set(__self__, "enabled", enabled)
        if category is not None:
            pulumi.set(__self__, "category", category)
        if retention_policy is not None:
            pulumi.set(__self__, "retention_policy", retention_policy)
        if time_grain is not None:
            pulumi.set(__self__, "time_grain", time_grain)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        a value indicating whether this category is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def category(self) -> Optional[str]:
        """
        Name of a Diagnostic Metric category for a resource type this setting is applied to. To obtain the list of Diagnostic metric categories for a resource, first perform a GET diagnostic settings operation.
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter(name="retentionPolicy")
    def retention_policy(self) -> Optional['outputs.RetentionPolicyResponse']:
        """
        the retention policy for this category.
        """
        return pulumi.get(self, "retention_policy")

    @property
    @pulumi.getter(name="timeGrain")
    def time_grain(self) -> Optional[str]:
        """
        the timegrain of the metric in ISO8601 format.
        """
        return pulumi.get(self, "time_grain")


@pulumi.output_type
class MetricTriggerResponse(dict):
    """
    The trigger that results in a scaling action.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricName":
            suggest = "metric_name"
        elif key == "metricResourceUri":
            suggest = "metric_resource_uri"
        elif key == "timeAggregation":
            suggest = "time_aggregation"
        elif key == "timeGrain":
            suggest = "time_grain"
        elif key == "timeWindow":
            suggest = "time_window"
        elif key == "dividePerInstance":
            suggest = "divide_per_instance"
        elif key == "metricNamespace":
            suggest = "metric_namespace"
        elif key == "metricResourceLocation":
            suggest = "metric_resource_location"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetricTriggerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetricTriggerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetricTriggerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metric_name: str,
                 metric_resource_uri: str,
                 operator: str,
                 statistic: str,
                 threshold: float,
                 time_aggregation: str,
                 time_grain: str,
                 time_window: str,
                 dimensions: Optional[Sequence['outputs.ScaleRuleMetricDimensionResponse']] = None,
                 divide_per_instance: Optional[bool] = None,
                 metric_namespace: Optional[str] = None,
                 metric_resource_location: Optional[str] = None):
        """
        The trigger that results in a scaling action.
        :param str metric_name: the name of the metric that defines what the rule monitors.
        :param str metric_resource_uri: the resource identifier of the resource the rule monitors.
        :param str operator: the operator that is used to compare the metric data and the threshold.
        :param str statistic: the metric statistic type. How the metrics from multiple instances are combined.
        :param float threshold: the threshold of the metric that triggers the scale action.
        :param str time_aggregation: time aggregation type. How the data that is collected should be combined over time. The default value is Average.
        :param str time_grain: the granularity of metrics the rule monitors. Must be one of the predefined values returned from metric definitions for the metric. Must be between 12 hours and 1 minute.
        :param str time_window: the range of time in which instance data is collected. This value must be greater than the delay in metric collection, which can vary from resource-to-resource. Must be between 12 hours and 5 minutes.
        :param Sequence['ScaleRuleMetricDimensionResponse'] dimensions: List of dimension conditions. For example: [{"DimensionName":"AppName","Operator":"Equals","Values":["App1"]},{"DimensionName":"Deployment","Operator":"Equals","Values":["default"]}].
        :param bool divide_per_instance: a value indicating whether metric should divide per instance.
        :param str metric_namespace: the namespace of the metric that defines what the rule monitors.
        :param str metric_resource_location: the location of the resource the rule monitors.
        """
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "metric_resource_uri", metric_resource_uri)
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "statistic", statistic)
        pulumi.set(__self__, "threshold", threshold)
        pulumi.set(__self__, "time_aggregation", time_aggregation)
        pulumi.set(__self__, "time_grain", time_grain)
        pulumi.set(__self__, "time_window", time_window)
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if divide_per_instance is not None:
            pulumi.set(__self__, "divide_per_instance", divide_per_instance)
        if metric_namespace is not None:
            pulumi.set(__self__, "metric_namespace", metric_namespace)
        if metric_resource_location is not None:
            pulumi.set(__self__, "metric_resource_location", metric_resource_location)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> str:
        """
        the name of the metric that defines what the rule monitors.
        """
        return pulumi.get(self, "metric_name")

    @property
    @pulumi.getter(name="metricResourceUri")
    def metric_resource_uri(self) -> str:
        """
        the resource identifier of the resource the rule monitors.
        """
        return pulumi.get(self, "metric_resource_uri")

    @property
    @pulumi.getter
    def operator(self) -> str:
        """
        the operator that is used to compare the metric data and the threshold.
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter
    def statistic(self) -> str:
        """
        the metric statistic type. How the metrics from multiple instances are combined.
        """
        return pulumi.get(self, "statistic")

    @property
    @pulumi.getter
    def threshold(self) -> float:
        """
        the threshold of the metric that triggers the scale action.
        """
        return pulumi.get(self, "threshold")

    @property
    @pulumi.getter(name="timeAggregation")
    def time_aggregation(self) -> str:
        """
        time aggregation type. How the data that is collected should be combined over time. The default value is Average.
        """
        return pulumi.get(self, "time_aggregation")

    @property
    @pulumi.getter(name="timeGrain")
    def time_grain(self) -> str:
        """
        the granularity of metrics the rule monitors. Must be one of the predefined values returned from metric definitions for the metric. Must be between 12 hours and 1 minute.
        """
        return pulumi.get(self, "time_grain")

    @property
    @pulumi.getter(name="timeWindow")
    def time_window(self) -> str:
        """
        the range of time in which instance data is collected. This value must be greater than the delay in metric collection, which can vary from resource-to-resource. Must be between 12 hours and 5 minutes.
        """
        return pulumi.get(self, "time_window")

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[Sequence['outputs.ScaleRuleMetricDimensionResponse']]:
        """
        List of dimension conditions. For example: [{"DimensionName":"AppName","Operator":"Equals","Values":["App1"]},{"DimensionName":"Deployment","Operator":"Equals","Values":["default"]}].
        """
        return pulumi.get(self, "dimensions")

    @property
    @pulumi.getter(name="dividePerInstance")
    def divide_per_instance(self) -> Optional[bool]:
        """
        a value indicating whether metric should divide per instance.
        """
        return pulumi.get(self, "divide_per_instance")

    @property
    @pulumi.getter(name="metricNamespace")
    def metric_namespace(self) -> Optional[str]:
        """
        the namespace of the metric that defines what the rule monitors.
        """
        return pulumi.get(self, "metric_namespace")

    @property
    @pulumi.getter(name="metricResourceLocation")
    def metric_resource_location(self) -> Optional[str]:
        """
        the location of the resource the rule monitors.
        """
        return pulumi.get(self, "metric_resource_location")


@pulumi.output_type
class MyWorkbookManagedIdentityResponse(dict):
    """
    Customer Managed Identity
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userAssignedIdentities":
            suggest = "user_assigned_identities"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MyWorkbookManagedIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MyWorkbookManagedIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MyWorkbookManagedIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: Optional[str] = None,
                 user_assigned_identities: Optional['outputs.MyWorkbookUserAssignedIdentitiesResponse'] = None):
        """
        Customer Managed Identity
        :param str type: The identity type.
        :param 'MyWorkbookUserAssignedIdentitiesResponse' user_assigned_identities: Customer Managed Identity
        """
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The identity type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional['outputs.MyWorkbookUserAssignedIdentitiesResponse']:
        """
        Customer Managed Identity
        """
        return pulumi.get(self, "user_assigned_identities")


@pulumi.output_type
class MyWorkbookUserAssignedIdentitiesResponse(dict):
    """
    Customer Managed Identity
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MyWorkbookUserAssignedIdentitiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MyWorkbookUserAssignedIdentitiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MyWorkbookUserAssignedIdentitiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: str,
                 tenant_id: str):
        """
        Customer Managed Identity
        :param str principal_id: The principal ID of resource identity.
        :param str tenant_id: The tenant ID of resource.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal ID of resource identity.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The tenant ID of resource.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class PerfCounterDataSourceResponse(dict):
    """
    Definition of which performance counters will be collected and how they will be collected by this data collection rule.
    Collected from both Windows and Linux machines where the counter is present.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "counterSpecifiers":
            suggest = "counter_specifiers"
        elif key == "samplingFrequencyInSeconds":
            suggest = "sampling_frequency_in_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PerfCounterDataSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PerfCounterDataSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PerfCounterDataSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 counter_specifiers: Optional[Sequence[str]] = None,
                 name: Optional[str] = None,
                 sampling_frequency_in_seconds: Optional[int] = None,
                 streams: Optional[Sequence[str]] = None):
        """
        Definition of which performance counters will be collected and how they will be collected by this data collection rule.
        Collected from both Windows and Linux machines where the counter is present.
        :param Sequence[str] counter_specifiers: A list of specifier names of the performance counters you want to collect.
               Use a wildcard (*) to collect a counter for all instances.
               To get a list of performance counters on Windows, run the command 'typeperf'.
        :param str name: A friendly name for the data source. 
               This name should be unique across all data sources (regardless of type) within the data collection rule.
        :param int sampling_frequency_in_seconds: The number of seconds between consecutive counter measurements (samples).
        :param Sequence[str] streams: List of streams that this data source will be sent to.
               A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
        """
        if counter_specifiers is not None:
            pulumi.set(__self__, "counter_specifiers", counter_specifiers)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if sampling_frequency_in_seconds is not None:
            pulumi.set(__self__, "sampling_frequency_in_seconds", sampling_frequency_in_seconds)
        if streams is not None:
            pulumi.set(__self__, "streams", streams)

    @property
    @pulumi.getter(name="counterSpecifiers")
    def counter_specifiers(self) -> Optional[Sequence[str]]:
        """
        A list of specifier names of the performance counters you want to collect.
        Use a wildcard (*) to collect a counter for all instances.
        To get a list of performance counters on Windows, run the command 'typeperf'.
        """
        return pulumi.get(self, "counter_specifiers")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        A friendly name for the data source. 
        This name should be unique across all data sources (regardless of type) within the data collection rule.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="samplingFrequencyInSeconds")
    def sampling_frequency_in_seconds(self) -> Optional[int]:
        """
        The number of seconds between consecutive counter measurements (samples).
        """
        return pulumi.get(self, "sampling_frequency_in_seconds")

    @property
    @pulumi.getter
    def streams(self) -> Optional[Sequence[str]]:
        """
        List of streams that this data source will be sent to.
        A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
        """
        return pulumi.get(self, "streams")


@pulumi.output_type
class PerformanceCounterConfigurationResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "samplingPeriod":
            suggest = "sampling_period"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PerformanceCounterConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PerformanceCounterConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PerformanceCounterConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 sampling_period: str,
                 instance: Optional[str] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "sampling_period", sampling_period)
        if instance is not None:
            pulumi.set(__self__, "instance", instance)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="samplingPeriod")
    def sampling_period(self) -> str:
        return pulumi.get(self, "sampling_period")

    @property
    @pulumi.getter
    def instance(self) -> Optional[str]:
        return pulumi.get(self, "instance")


@pulumi.output_type
class PrivateEndpointConnectionResponse(dict):
    """
    A private endpoint connection
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "privateEndpoint":
            suggest = "private_endpoint"
        elif key == "privateLinkServiceConnectionState":
            suggest = "private_link_service_connection_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateEndpointConnectionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateEndpointConnectionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateEndpointConnectionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 name: str,
                 provisioning_state: str,
                 type: str,
                 private_endpoint: Optional['outputs.PrivateEndpointPropertyResponse'] = None,
                 private_link_service_connection_state: Optional['outputs.PrivateLinkServiceConnectionStatePropertyResponse'] = None):
        """
        A private endpoint connection
        :param str id: Azure resource Id
        :param str name: Azure resource name
        :param str provisioning_state: State of the private endpoint connection.
        :param str type: Azure resource type
        :param 'PrivateEndpointPropertyResponse' private_endpoint: Private endpoint which the connection belongs to.
        :param 'PrivateLinkServiceConnectionStatePropertyResponse' private_link_service_connection_state: Connection state of the private endpoint connection.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "type", type)
        if private_endpoint is not None:
            pulumi.set(__self__, "private_endpoint", private_endpoint)
        if private_link_service_connection_state is not None:
            pulumi.set(__self__, "private_link_service_connection_state", private_link_service_connection_state)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Azure resource Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Azure resource name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        State of the private endpoint connection.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Azure resource type
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="privateEndpoint")
    def private_endpoint(self) -> Optional['outputs.PrivateEndpointPropertyResponse']:
        """
        Private endpoint which the connection belongs to.
        """
        return pulumi.get(self, "private_endpoint")

    @property
    @pulumi.getter(name="privateLinkServiceConnectionState")
    def private_link_service_connection_state(self) -> Optional['outputs.PrivateLinkServiceConnectionStatePropertyResponse']:
        """
        Connection state of the private endpoint connection.
        """
        return pulumi.get(self, "private_link_service_connection_state")


@pulumi.output_type
class PrivateEndpointPropertyResponse(dict):
    """
    Private endpoint which the connection belongs to.
    """
    def __init__(__self__, *,
                 id: Optional[str] = None):
        """
        Private endpoint which the connection belongs to.
        :param str id: Resource id of the private endpoint.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource id of the private endpoint.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class PrivateLinkScopedResourceResponse(dict):
    """
    The private link scope resource reference.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceId":
            suggest = "resource_id"
        elif key == "scopeId":
            suggest = "scope_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateLinkScopedResourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateLinkScopedResourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateLinkScopedResourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_id: Optional[str] = None,
                 scope_id: Optional[str] = None):
        """
        The private link scope resource reference.
        :param str resource_id: The full resource Id of the private link scope resource.
        :param str scope_id: The private link scope unique Identifier.
        """
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if scope_id is not None:
            pulumi.set(__self__, "scope_id", scope_id)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        The full resource Id of the private link scope resource.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="scopeId")
    def scope_id(self) -> Optional[str]:
        """
        The private link scope unique Identifier.
        """
        return pulumi.get(self, "scope_id")


@pulumi.output_type
class PrivateLinkServiceConnectionStatePropertyResponse(dict):
    """
    State of the private endpoint connection.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionsRequired":
            suggest = "actions_required"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateLinkServiceConnectionStatePropertyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateLinkServiceConnectionStatePropertyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateLinkServiceConnectionStatePropertyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 actions_required: str,
                 description: str,
                 status: str):
        """
        State of the private endpoint connection.
        :param str actions_required: The actions required for private link service connection.
        :param str description: The private link service connection description.
        :param str status: The private link service connection status.
        """
        pulumi.set(__self__, "actions_required", actions_required)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="actionsRequired")
    def actions_required(self) -> str:
        """
        The actions required for private link service connection.
        """
        return pulumi.get(self, "actions_required")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The private link service connection description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The private link service connection status.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class RecurrenceResponse(dict):
    """
    The repeating times at which this profile begins. This element is not used if the FixedDate element is used.
    """
    def __init__(__self__, *,
                 frequency: str,
                 schedule: 'outputs.RecurrentScheduleResponse'):
        """
        The repeating times at which this profile begins. This element is not used if the FixedDate element is used.
        :param str frequency: the recurrence frequency. How often the schedule profile should take effect. This value must be Week, meaning each week will have the same set of profiles. For example, to set a daily schedule, set **schedule** to every day of the week. The frequency property specifies that the schedule is repeated weekly.
        :param 'RecurrentScheduleResponse' schedule: the scheduling constraints for when the profile begins.
        """
        pulumi.set(__self__, "frequency", frequency)
        pulumi.set(__self__, "schedule", schedule)

    @property
    @pulumi.getter
    def frequency(self) -> str:
        """
        the recurrence frequency. How often the schedule profile should take effect. This value must be Week, meaning each week will have the same set of profiles. For example, to set a daily schedule, set **schedule** to every day of the week. The frequency property specifies that the schedule is repeated weekly.
        """
        return pulumi.get(self, "frequency")

    @property
    @pulumi.getter
    def schedule(self) -> 'outputs.RecurrentScheduleResponse':
        """
        the scheduling constraints for when the profile begins.
        """
        return pulumi.get(self, "schedule")


@pulumi.output_type
class RecurrentScheduleResponse(dict):
    """
    The scheduling constraints for when the profile begins.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timeZone":
            suggest = "time_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RecurrentScheduleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RecurrentScheduleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RecurrentScheduleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 days: Sequence[str],
                 hours: Sequence[int],
                 minutes: Sequence[int],
                 time_zone: str):
        """
        The scheduling constraints for when the profile begins.
        :param Sequence[str] days: the collection of days that the profile takes effect on. Possible values are Sunday through Saturday.
        :param Sequence[int] hours: A collection of hours that the profile takes effect on. Values supported are 0 to 23 on the 24-hour clock (AM/PM times are not supported).
        :param Sequence[int] minutes: A collection of minutes at which the profile takes effect at.
        :param str time_zone: the timezone for the hours of the profile. Some examples of valid time zones are: Dateline Standard Time, UTC-11, Hawaiian Standard Time, Alaskan Standard Time, Pacific Standard Time (Mexico), Pacific Standard Time, US Mountain Standard Time, Mountain Standard Time (Mexico), Mountain Standard Time, Central America Standard Time, Central Standard Time, Central Standard Time (Mexico), Canada Central Standard Time, SA Pacific Standard Time, Eastern Standard Time, US Eastern Standard Time, Venezuela Standard Time, Paraguay Standard Time, Atlantic Standard Time, Central Brazilian Standard Time, SA Western Standard Time, Pacific SA Standard Time, Newfoundland Standard Time, E. South America Standard Time, Argentina Standard Time, SA Eastern Standard Time, Greenland Standard Time, Montevideo Standard Time, Bahia Standard Time, UTC-02, Mid-Atlantic Standard Time, Azores Standard Time, Cape Verde Standard Time, Morocco Standard Time, UTC, GMT Standard Time, Greenwich Standard Time, W. Europe Standard Time, Central Europe Standard Time, Romance Standard Time, Central European Standard Time, W. Central Africa Standard Time, Namibia Standard Time, Jordan Standard Time, GTB Standard Time, Middle East Standard Time, Egypt Standard Time, Syria Standard Time, E. Europe Standard Time, South Africa Standard Time, FLE Standard Time, Turkey Standard Time, Israel Standard Time, Kaliningrad Standard Time, Libya Standard Time, Arabic Standard Time, Arab Standard Time, Belarus Standard Time, Russian Standard Time, E. Africa Standard Time, Iran Standard Time, Arabian Standard Time, Azerbaijan Standard Time, Russia Time Zone 3, Mauritius Standard Time, Georgian Standard Time, Caucasus Standard Time, Afghanistan Standard Time, West Asia Standard Time, Ekaterinburg Standard Time, Pakistan Standard Time, India Standard Time, Sri Lanka Standard Time, Nepal Standard Time, Central Asia Standard Time, Bangladesh Standard Time, N. Central Asia Standard Time, Myanmar Standard Time, SE Asia Standard Time, North Asia Standard Time, China Standard Time, North Asia East Standard Time, Singapore Standard Time, W. Australia Standard Time, Taipei Standard Time, Ulaanbaatar Standard Time, Tokyo Standard Time, Korea Standard Time, Yakutsk Standard Time, Cen. Australia Standard Time, AUS Central Standard Time, E. Australia Standard Time, AUS Eastern Standard Time, West Pacific Standard Time, Tasmania Standard Time, Magadan Standard Time, Vladivostok Standard Time, Russia Time Zone 10, Central Pacific Standard Time, Russia Time Zone 11, New Zealand Standard Time, UTC+12, Fiji Standard Time, Kamchatka Standard Time, Tonga Standard Time, Samoa Standard Time, Line Islands Standard Time
        """
        pulumi.set(__self__, "days", days)
        pulumi.set(__self__, "hours", hours)
        pulumi.set(__self__, "minutes", minutes)
        pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter
    def days(self) -> Sequence[str]:
        """
        the collection of days that the profile takes effect on. Possible values are Sunday through Saturday.
        """
        return pulumi.get(self, "days")

    @property
    @pulumi.getter
    def hours(self) -> Sequence[int]:
        """
        A collection of hours that the profile takes effect on. Values supported are 0 to 23 on the 24-hour clock (AM/PM times are not supported).
        """
        return pulumi.get(self, "hours")

    @property
    @pulumi.getter
    def minutes(self) -> Sequence[int]:
        """
        A collection of minutes at which the profile takes effect at.
        """
        return pulumi.get(self, "minutes")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> str:
        """
        the timezone for the hours of the profile. Some examples of valid time zones are: Dateline Standard Time, UTC-11, Hawaiian Standard Time, Alaskan Standard Time, Pacific Standard Time (Mexico), Pacific Standard Time, US Mountain Standard Time, Mountain Standard Time (Mexico), Mountain Standard Time, Central America Standard Time, Central Standard Time, Central Standard Time (Mexico), Canada Central Standard Time, SA Pacific Standard Time, Eastern Standard Time, US Eastern Standard Time, Venezuela Standard Time, Paraguay Standard Time, Atlantic Standard Time, Central Brazilian Standard Time, SA Western Standard Time, Pacific SA Standard Time, Newfoundland Standard Time, E. South America Standard Time, Argentina Standard Time, SA Eastern Standard Time, Greenland Standard Time, Montevideo Standard Time, Bahia Standard Time, UTC-02, Mid-Atlantic Standard Time, Azores Standard Time, Cape Verde Standard Time, Morocco Standard Time, UTC, GMT Standard Time, Greenwich Standard Time, W. Europe Standard Time, Central Europe Standard Time, Romance Standard Time, Central European Standard Time, W. Central Africa Standard Time, Namibia Standard Time, Jordan Standard Time, GTB Standard Time, Middle East Standard Time, Egypt Standard Time, Syria Standard Time, E. Europe Standard Time, South Africa Standard Time, FLE Standard Time, Turkey Standard Time, Israel Standard Time, Kaliningrad Standard Time, Libya Standard Time, Arabic Standard Time, Arab Standard Time, Belarus Standard Time, Russian Standard Time, E. Africa Standard Time, Iran Standard Time, Arabian Standard Time, Azerbaijan Standard Time, Russia Time Zone 3, Mauritius Standard Time, Georgian Standard Time, Caucasus Standard Time, Afghanistan Standard Time, West Asia Standard Time, Ekaterinburg Standard Time, Pakistan Standard Time, India Standard Time, Sri Lanka Standard Time, Nepal Standard Time, Central Asia Standard Time, Bangladesh Standard Time, N. Central Asia Standard Time, Myanmar Standard Time, SE Asia Standard Time, North Asia Standard Time, China Standard Time, North Asia East Standard Time, Singapore Standard Time, W. Australia Standard Time, Taipei Standard Time, Ulaanbaatar Standard Time, Tokyo Standard Time, Korea Standard Time, Yakutsk Standard Time, Cen. Australia Standard Time, AUS Central Standard Time, E. Australia Standard Time, AUS Eastern Standard Time, West Pacific Standard Time, Tasmania Standard Time, Magadan Standard Time, Vladivostok Standard Time, Russia Time Zone 10, Central Pacific Standard Time, Russia Time Zone 11, New Zealand Standard Time, UTC+12, Fiji Standard Time, Kamchatka Standard Time, Tonga Standard Time, Samoa Standard Time, Line Islands Standard Time
        """
        return pulumi.get(self, "time_zone")


@pulumi.output_type
class RetentionPolicyResponse(dict):
    """
    Specifies the retention policy for the log.
    """
    def __init__(__self__, *,
                 days: int,
                 enabled: bool):
        """
        Specifies the retention policy for the log.
        :param int days: the number of days for the retention in days. A value of 0 will retain the events indefinitely.
        :param bool enabled: a value indicating whether the retention policy is enabled.
        """
        pulumi.set(__self__, "days", days)
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def days(self) -> int:
        """
        the number of days for the retention in days. A value of 0 will retain the events indefinitely.
        """
        return pulumi.get(self, "days")

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        a value indicating whether the retention policy is enabled.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class RuleEmailActionResponse(dict):
    """
    Specifies the action to send email when the rule condition is evaluated. The discriminator is always RuleEmailAction in this case.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "customEmails":
            suggest = "custom_emails"
        elif key == "sendToServiceOwners":
            suggest = "send_to_service_owners"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleEmailActionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleEmailActionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleEmailActionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 custom_emails: Optional[Sequence[str]] = None,
                 send_to_service_owners: Optional[bool] = None):
        """
        Specifies the action to send email when the rule condition is evaluated. The discriminator is always RuleEmailAction in this case.
        :param str odata_type: specifies the type of the action. There are two types of actions: RuleEmailAction and RuleWebhookAction.
               Expected value is 'Microsoft.Azure.Management.Insights.Models.RuleEmailAction'.
        :param Sequence[str] custom_emails: the list of administrator's custom email addresses to notify of the activation of the alert.
        :param bool send_to_service_owners: Whether the administrators (service and co-administrators) of the service should be notified when the alert is activated.
        """
        pulumi.set(__self__, "odata_type", 'Microsoft.Azure.Management.Insights.Models.RuleEmailAction')
        if custom_emails is not None:
            pulumi.set(__self__, "custom_emails", custom_emails)
        if send_to_service_owners is not None:
            pulumi.set(__self__, "send_to_service_owners", send_to_service_owners)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        specifies the type of the action. There are two types of actions: RuleEmailAction and RuleWebhookAction.
        Expected value is 'Microsoft.Azure.Management.Insights.Models.RuleEmailAction'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="customEmails")
    def custom_emails(self) -> Optional[Sequence[str]]:
        """
        the list of administrator's custom email addresses to notify of the activation of the alert.
        """
        return pulumi.get(self, "custom_emails")

    @property
    @pulumi.getter(name="sendToServiceOwners")
    def send_to_service_owners(self) -> Optional[bool]:
        """
        Whether the administrators (service and co-administrators) of the service should be notified when the alert is activated.
        """
        return pulumi.get(self, "send_to_service_owners")


@pulumi.output_type
class RuleManagementEventClaimsDataSourceResponse(dict):
    """
    The claims for a rule management event data source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "emailAddress":
            suggest = "email_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleManagementEventClaimsDataSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleManagementEventClaimsDataSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleManagementEventClaimsDataSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 email_address: Optional[str] = None):
        """
        The claims for a rule management event data source.
        :param str email_address: the email address.
        """
        if email_address is not None:
            pulumi.set(__self__, "email_address", email_address)

    @property
    @pulumi.getter(name="emailAddress")
    def email_address(self) -> Optional[str]:
        """
        the email address.
        """
        return pulumi.get(self, "email_address")


@pulumi.output_type
class RuleManagementEventDataSourceResponse(dict):
    """
    A rule management event data source. The discriminator fields is always RuleManagementEventDataSource in this case.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "eventName":
            suggest = "event_name"
        elif key == "eventSource":
            suggest = "event_source"
        elif key == "legacyResourceId":
            suggest = "legacy_resource_id"
        elif key == "metricNamespace":
            suggest = "metric_namespace"
        elif key == "operationName":
            suggest = "operation_name"
        elif key == "resourceGroupName":
            suggest = "resource_group_name"
        elif key == "resourceLocation":
            suggest = "resource_location"
        elif key == "resourceProviderName":
            suggest = "resource_provider_name"
        elif key == "resourceUri":
            suggest = "resource_uri"
        elif key == "subStatus":
            suggest = "sub_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleManagementEventDataSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleManagementEventDataSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleManagementEventDataSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 claims: Optional['outputs.RuleManagementEventClaimsDataSourceResponse'] = None,
                 event_name: Optional[str] = None,
                 event_source: Optional[str] = None,
                 legacy_resource_id: Optional[str] = None,
                 level: Optional[str] = None,
                 metric_namespace: Optional[str] = None,
                 operation_name: Optional[str] = None,
                 resource_group_name: Optional[str] = None,
                 resource_location: Optional[str] = None,
                 resource_provider_name: Optional[str] = None,
                 resource_uri: Optional[str] = None,
                 status: Optional[str] = None,
                 sub_status: Optional[str] = None):
        """
        A rule management event data source. The discriminator fields is always RuleManagementEventDataSource in this case.
        :param str odata_type: specifies the type of data source. There are two types of rule data sources: RuleMetricDataSource and RuleManagementEventDataSource
               Expected value is 'Microsoft.Azure.Management.Insights.Models.RuleManagementEventDataSource'.
        :param 'RuleManagementEventClaimsDataSourceResponse' claims: the claims.
        :param str event_name: the event name.
        :param str event_source: the event source.
        :param str legacy_resource_id: the legacy resource identifier of the resource the rule monitors. **NOTE**: this property cannot be updated for an existing rule.
        :param str level: the level.
        :param str metric_namespace: the namespace of the metric.
        :param str operation_name: The name of the operation that should be checked for. If no name is provided, any operation will match.
        :param str resource_group_name: the resource group name.
        :param str resource_location: the location of the resource.
        :param str resource_provider_name: the resource provider name.
        :param str resource_uri: the resource identifier of the resource the rule monitors. **NOTE**: this property cannot be updated for an existing rule.
        :param str status: The status of the operation that should be checked for. If no status is provided, any status will match.
        :param str sub_status: the substatus.
        """
        pulumi.set(__self__, "odata_type", 'Microsoft.Azure.Management.Insights.Models.RuleManagementEventDataSource')
        if claims is not None:
            pulumi.set(__self__, "claims", claims)
        if event_name is not None:
            pulumi.set(__self__, "event_name", event_name)
        if event_source is not None:
            pulumi.set(__self__, "event_source", event_source)
        if legacy_resource_id is not None:
            pulumi.set(__self__, "legacy_resource_id", legacy_resource_id)
        if level is not None:
            pulumi.set(__self__, "level", level)
        if metric_namespace is not None:
            pulumi.set(__self__, "metric_namespace", metric_namespace)
        if operation_name is not None:
            pulumi.set(__self__, "operation_name", operation_name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if resource_location is not None:
            pulumi.set(__self__, "resource_location", resource_location)
        if resource_provider_name is not None:
            pulumi.set(__self__, "resource_provider_name", resource_provider_name)
        if resource_uri is not None:
            pulumi.set(__self__, "resource_uri", resource_uri)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if sub_status is not None:
            pulumi.set(__self__, "sub_status", sub_status)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        specifies the type of data source. There are two types of rule data sources: RuleMetricDataSource and RuleManagementEventDataSource
        Expected value is 'Microsoft.Azure.Management.Insights.Models.RuleManagementEventDataSource'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter
    def claims(self) -> Optional['outputs.RuleManagementEventClaimsDataSourceResponse']:
        """
        the claims.
        """
        return pulumi.get(self, "claims")

    @property
    @pulumi.getter(name="eventName")
    def event_name(self) -> Optional[str]:
        """
        the event name.
        """
        return pulumi.get(self, "event_name")

    @property
    @pulumi.getter(name="eventSource")
    def event_source(self) -> Optional[str]:
        """
        the event source.
        """
        return pulumi.get(self, "event_source")

    @property
    @pulumi.getter(name="legacyResourceId")
    def legacy_resource_id(self) -> Optional[str]:
        """
        the legacy resource identifier of the resource the rule monitors. **NOTE**: this property cannot be updated for an existing rule.
        """
        return pulumi.get(self, "legacy_resource_id")

    @property
    @pulumi.getter
    def level(self) -> Optional[str]:
        """
        the level.
        """
        return pulumi.get(self, "level")

    @property
    @pulumi.getter(name="metricNamespace")
    def metric_namespace(self) -> Optional[str]:
        """
        the namespace of the metric.
        """
        return pulumi.get(self, "metric_namespace")

    @property
    @pulumi.getter(name="operationName")
    def operation_name(self) -> Optional[str]:
        """
        The name of the operation that should be checked for. If no name is provided, any operation will match.
        """
        return pulumi.get(self, "operation_name")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[str]:
        """
        the resource group name.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter(name="resourceLocation")
    def resource_location(self) -> Optional[str]:
        """
        the location of the resource.
        """
        return pulumi.get(self, "resource_location")

    @property
    @pulumi.getter(name="resourceProviderName")
    def resource_provider_name(self) -> Optional[str]:
        """
        the resource provider name.
        """
        return pulumi.get(self, "resource_provider_name")

    @property
    @pulumi.getter(name="resourceUri")
    def resource_uri(self) -> Optional[str]:
        """
        the resource identifier of the resource the rule monitors. **NOTE**: this property cannot be updated for an existing rule.
        """
        return pulumi.get(self, "resource_uri")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The status of the operation that should be checked for. If no status is provided, any status will match.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subStatus")
    def sub_status(self) -> Optional[str]:
        """
        the substatus.
        """
        return pulumi.get(self, "sub_status")


@pulumi.output_type
class RuleMetricDataSourceResponse(dict):
    """
    A rule metric data source. The discriminator value is always RuleMetricDataSource in this case.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "legacyResourceId":
            suggest = "legacy_resource_id"
        elif key == "metricName":
            suggest = "metric_name"
        elif key == "metricNamespace":
            suggest = "metric_namespace"
        elif key == "resourceLocation":
            suggest = "resource_location"
        elif key == "resourceUri":
            suggest = "resource_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleMetricDataSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleMetricDataSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleMetricDataSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 legacy_resource_id: Optional[str] = None,
                 metric_name: Optional[str] = None,
                 metric_namespace: Optional[str] = None,
                 resource_location: Optional[str] = None,
                 resource_uri: Optional[str] = None):
        """
        A rule metric data source. The discriminator value is always RuleMetricDataSource in this case.
        :param str odata_type: specifies the type of data source. There are two types of rule data sources: RuleMetricDataSource and RuleManagementEventDataSource
               Expected value is 'Microsoft.Azure.Management.Insights.Models.RuleMetricDataSource'.
        :param str legacy_resource_id: the legacy resource identifier of the resource the rule monitors. **NOTE**: this property cannot be updated for an existing rule.
        :param str metric_name: the name of the metric that defines what the rule monitors.
        :param str metric_namespace: the namespace of the metric.
        :param str resource_location: the location of the resource.
        :param str resource_uri: the resource identifier of the resource the rule monitors. **NOTE**: this property cannot be updated for an existing rule.
        """
        pulumi.set(__self__, "odata_type", 'Microsoft.Azure.Management.Insights.Models.RuleMetricDataSource')
        if legacy_resource_id is not None:
            pulumi.set(__self__, "legacy_resource_id", legacy_resource_id)
        if metric_name is not None:
            pulumi.set(__self__, "metric_name", metric_name)
        if metric_namespace is not None:
            pulumi.set(__self__, "metric_namespace", metric_namespace)
        if resource_location is not None:
            pulumi.set(__self__, "resource_location", resource_location)
        if resource_uri is not None:
            pulumi.set(__self__, "resource_uri", resource_uri)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        specifies the type of data source. There are two types of rule data sources: RuleMetricDataSource and RuleManagementEventDataSource
        Expected value is 'Microsoft.Azure.Management.Insights.Models.RuleMetricDataSource'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="legacyResourceId")
    def legacy_resource_id(self) -> Optional[str]:
        """
        the legacy resource identifier of the resource the rule monitors. **NOTE**: this property cannot be updated for an existing rule.
        """
        return pulumi.get(self, "legacy_resource_id")

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> Optional[str]:
        """
        the name of the metric that defines what the rule monitors.
        """
        return pulumi.get(self, "metric_name")

    @property
    @pulumi.getter(name="metricNamespace")
    def metric_namespace(self) -> Optional[str]:
        """
        the namespace of the metric.
        """
        return pulumi.get(self, "metric_namespace")

    @property
    @pulumi.getter(name="resourceLocation")
    def resource_location(self) -> Optional[str]:
        """
        the location of the resource.
        """
        return pulumi.get(self, "resource_location")

    @property
    @pulumi.getter(name="resourceUri")
    def resource_uri(self) -> Optional[str]:
        """
        the resource identifier of the resource the rule monitors. **NOTE**: this property cannot be updated for an existing rule.
        """
        return pulumi.get(self, "resource_uri")


@pulumi.output_type
class RuleWebhookActionResponse(dict):
    """
    Specifies the action to post to service when the rule condition is evaluated. The discriminator is always RuleWebhookAction in this case.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "serviceUri":
            suggest = "service_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleWebhookActionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleWebhookActionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleWebhookActionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 properties: Optional[Mapping[str, str]] = None,
                 service_uri: Optional[str] = None):
        """
        Specifies the action to post to service when the rule condition is evaluated. The discriminator is always RuleWebhookAction in this case.
        :param str odata_type: specifies the type of the action. There are two types of actions: RuleEmailAction and RuleWebhookAction.
               Expected value is 'Microsoft.Azure.Management.Insights.Models.RuleWebhookAction'.
        :param Mapping[str, str] properties: the dictionary of custom properties to include with the post operation. These data are appended to the webhook payload.
        :param str service_uri: the service uri to Post the notification when the alert activates or resolves.
        """
        pulumi.set(__self__, "odata_type", 'Microsoft.Azure.Management.Insights.Models.RuleWebhookAction')
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if service_uri is not None:
            pulumi.set(__self__, "service_uri", service_uri)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        specifies the type of the action. There are two types of actions: RuleEmailAction and RuleWebhookAction.
        Expected value is 'Microsoft.Azure.Management.Insights.Models.RuleWebhookAction'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        the dictionary of custom properties to include with the post operation. These data are appended to the webhook payload.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="serviceUri")
    def service_uri(self) -> Optional[str]:
        """
        the service uri to Post the notification when the alert activates or resolves.
        """
        return pulumi.get(self, "service_uri")


@pulumi.output_type
class ScaleActionResponse(dict):
    """
    The parameters for the scaling action.
    """
    def __init__(__self__, *,
                 cooldown: str,
                 direction: str,
                 type: str,
                 value: Optional[str] = None):
        """
        The parameters for the scaling action.
        :param str cooldown: the amount of time to wait since the last scaling action before this action occurs. It must be between 1 week and 1 minute in ISO 8601 format.
        :param str direction: the scale direction. Whether the scaling action increases or decreases the number of instances.
        :param str type: the type of action that should occur when the scale rule fires.
        :param str value: the number of instances that are involved in the scaling action. This value must be 1 or greater. The default value is 1.
        """
        pulumi.set(__self__, "cooldown", cooldown)
        pulumi.set(__self__, "direction", direction)
        pulumi.set(__self__, "type", type)
        if value is None:
            value = '1'
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def cooldown(self) -> str:
        """
        the amount of time to wait since the last scaling action before this action occurs. It must be between 1 week and 1 minute in ISO 8601 format.
        """
        return pulumi.get(self, "cooldown")

    @property
    @pulumi.getter
    def direction(self) -> str:
        """
        the scale direction. Whether the scaling action increases or decreases the number of instances.
        """
        return pulumi.get(self, "direction")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        the type of action that should occur when the scale rule fires.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        the number of instances that are involved in the scaling action. This value must be 1 or greater. The default value is 1.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ScaleCapacityResponse(dict):
    """
    The number of instances that can be used during this profile.
    """
    def __init__(__self__, *,
                 default: str,
                 maximum: str,
                 minimum: str):
        """
        The number of instances that can be used during this profile.
        :param str default: the number of instances that will be set if metrics are not available for evaluation. The default is only used if the current instance count is lower than the default.
        :param str maximum: the maximum number of instances for the resource. The actual maximum number of instances is limited by the cores that are available in the subscription.
        :param str minimum: the minimum number of instances for the resource.
        """
        pulumi.set(__self__, "default", default)
        pulumi.set(__self__, "maximum", maximum)
        pulumi.set(__self__, "minimum", minimum)

    @property
    @pulumi.getter
    def default(self) -> str:
        """
        the number of instances that will be set if metrics are not available for evaluation. The default is only used if the current instance count is lower than the default.
        """
        return pulumi.get(self, "default")

    @property
    @pulumi.getter
    def maximum(self) -> str:
        """
        the maximum number of instances for the resource. The actual maximum number of instances is limited by the cores that are available in the subscription.
        """
        return pulumi.get(self, "maximum")

    @property
    @pulumi.getter
    def minimum(self) -> str:
        """
        the minimum number of instances for the resource.
        """
        return pulumi.get(self, "minimum")


@pulumi.output_type
class ScaleRuleMetricDimensionResponse(dict):
    """
    Specifies an auto scale rule metric dimension.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dimensionName":
            suggest = "dimension_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScaleRuleMetricDimensionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScaleRuleMetricDimensionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScaleRuleMetricDimensionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dimension_name: str,
                 operator: str,
                 values: Sequence[str]):
        """
        Specifies an auto scale rule metric dimension.
        :param str dimension_name: Name of the dimension.
        :param str operator: the dimension operator. Only 'Equals' and 'NotEquals' are supported. 'Equals' being equal to any of the values. 'NotEquals' being not equal to all of the values
        :param Sequence[str] values: list of dimension values. For example: ["App1","App2"].
        """
        pulumi.set(__self__, "dimension_name", dimension_name)
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="dimensionName")
    def dimension_name(self) -> str:
        """
        Name of the dimension.
        """
        return pulumi.get(self, "dimension_name")

    @property
    @pulumi.getter
    def operator(self) -> str:
        """
        the dimension operator. Only 'Equals' and 'NotEquals' are supported. 'Equals' being equal to any of the values. 'NotEquals' being not equal to all of the values
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        list of dimension values. For example: ["App1","App2"].
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class ScaleRuleResponse(dict):
    """
    A rule that provide the triggers and parameters for the scaling action.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricTrigger":
            suggest = "metric_trigger"
        elif key == "scaleAction":
            suggest = "scale_action"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScaleRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScaleRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScaleRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metric_trigger: 'outputs.MetricTriggerResponse',
                 scale_action: 'outputs.ScaleActionResponse'):
        """
        A rule that provide the triggers and parameters for the scaling action.
        :param 'MetricTriggerResponse' metric_trigger: the trigger that results in a scaling action.
        :param 'ScaleActionResponse' scale_action: the parameters for the scaling action.
        """
        pulumi.set(__self__, "metric_trigger", metric_trigger)
        pulumi.set(__self__, "scale_action", scale_action)

    @property
    @pulumi.getter(name="metricTrigger")
    def metric_trigger(self) -> 'outputs.MetricTriggerResponse':
        """
        the trigger that results in a scaling action.
        """
        return pulumi.get(self, "metric_trigger")

    @property
    @pulumi.getter(name="scaleAction")
    def scale_action(self) -> 'outputs.ScaleActionResponse':
        """
        the parameters for the scaling action.
        """
        return pulumi.get(self, "scale_action")


@pulumi.output_type
class ScheduleResponse(dict):
    """
    Defines how often to run the search and the time interval.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "frequencyInMinutes":
            suggest = "frequency_in_minutes"
        elif key == "timeWindowInMinutes":
            suggest = "time_window_in_minutes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 frequency_in_minutes: int,
                 time_window_in_minutes: int):
        """
        Defines how often to run the search and the time interval.
        :param int frequency_in_minutes: frequency (in minutes) at which rule condition should be evaluated.
        :param int time_window_in_minutes: Time window for which data needs to be fetched for query (should be greater than or equal to frequencyInMinutes).
        """
        pulumi.set(__self__, "frequency_in_minutes", frequency_in_minutes)
        pulumi.set(__self__, "time_window_in_minutes", time_window_in_minutes)

    @property
    @pulumi.getter(name="frequencyInMinutes")
    def frequency_in_minutes(self) -> int:
        """
        frequency (in minutes) at which rule condition should be evaluated.
        """
        return pulumi.get(self, "frequency_in_minutes")

    @property
    @pulumi.getter(name="timeWindowInMinutes")
    def time_window_in_minutes(self) -> int:
        """
        Time window for which data needs to be fetched for query (should be greater than or equal to frequencyInMinutes).
        """
        return pulumi.get(self, "time_window_in_minutes")


@pulumi.output_type
class SinkConfigurationResponse(dict):
    def __init__(__self__, *,
                 kind: str):
        pulumi.set(__self__, "kind", kind)

    @property
    @pulumi.getter
    def kind(self) -> str:
        return pulumi.get(self, "kind")


@pulumi.output_type
class SmsReceiverResponse(dict):
    """
    An SMS receiver.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "countryCode":
            suggest = "country_code"
        elif key == "phoneNumber":
            suggest = "phone_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SmsReceiverResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SmsReceiverResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SmsReceiverResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 country_code: str,
                 name: str,
                 phone_number: str,
                 status: str):
        """
        An SMS receiver.
        :param str country_code: The country code of the SMS receiver.
        :param str name: The name of the SMS receiver. Names must be unique across all receivers within an action group.
        :param str phone_number: The phone number of the SMS receiver.
        :param str status: The status of the receiver.
        """
        pulumi.set(__self__, "country_code", country_code)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "phone_number", phone_number)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> str:
        """
        The country code of the SMS receiver.
        """
        return pulumi.get(self, "country_code")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the SMS receiver. Names must be unique across all receivers within an action group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> str:
        """
        The phone number of the SMS receiver.
        """
        return pulumi.get(self, "phone_number")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the receiver.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class SourceResponse(dict):
    """
    Specifies the log search query.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataSourceId":
            suggest = "data_source_id"
        elif key == "authorizedResources":
            suggest = "authorized_resources"
        elif key == "queryType":
            suggest = "query_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_source_id: str,
                 authorized_resources: Optional[Sequence[str]] = None,
                 query: Optional[str] = None,
                 query_type: Optional[str] = None):
        """
        Specifies the log search query.
        :param str data_source_id: The resource uri over which log search query is to be run.
        :param Sequence[str] authorized_resources: List of  Resource referred into query
        :param str query: Log search query. Required for action type - AlertingAction
        :param str query_type: Set value to 'ResultCount' .
        """
        pulumi.set(__self__, "data_source_id", data_source_id)
        if authorized_resources is not None:
            pulumi.set(__self__, "authorized_resources", authorized_resources)
        if query is not None:
            pulumi.set(__self__, "query", query)
        if query_type is not None:
            pulumi.set(__self__, "query_type", query_type)

    @property
    @pulumi.getter(name="dataSourceId")
    def data_source_id(self) -> str:
        """
        The resource uri over which log search query is to be run.
        """
        return pulumi.get(self, "data_source_id")

    @property
    @pulumi.getter(name="authorizedResources")
    def authorized_resources(self) -> Optional[Sequence[str]]:
        """
        List of  Resource referred into query
        """
        return pulumi.get(self, "authorized_resources")

    @property
    @pulumi.getter
    def query(self) -> Optional[str]:
        """
        Log search query. Required for action type - AlertingAction
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter(name="queryType")
    def query_type(self) -> Optional[str]:
        """
        Set value to 'ResultCount' .
        """
        return pulumi.get(self, "query_type")


@pulumi.output_type
class SubscriptionLogSettingsResponse(dict):
    """
    Part of Subscription diagnostic setting. Specifies the settings for a particular log.
    """
    def __init__(__self__, *,
                 enabled: bool,
                 category: Optional[str] = None):
        """
        Part of Subscription diagnostic setting. Specifies the settings for a particular log.
        :param bool enabled: a value indicating whether this log is enabled.
        :param str category: Name of a Subscription Diagnostic Log category for a resource type this setting is applied to.
        """
        pulumi.set(__self__, "enabled", enabled)
        if category is not None:
            pulumi.set(__self__, "category", category)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        a value indicating whether this log is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def category(self) -> Optional[str]:
        """
        Name of a Subscription Diagnostic Log category for a resource type this setting is applied to.
        """
        return pulumi.get(self, "category")


@pulumi.output_type
class SyslogDataSourceResponse(dict):
    """
    Definition of which syslog data will be collected and how it will be collected.
    Only collected from Linux machines.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "facilityNames":
            suggest = "facility_names"
        elif key == "logLevels":
            suggest = "log_levels"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SyslogDataSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SyslogDataSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SyslogDataSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 facility_names: Optional[Sequence[str]] = None,
                 log_levels: Optional[Sequence[str]] = None,
                 name: Optional[str] = None,
                 streams: Optional[Sequence[str]] = None):
        """
        Definition of which syslog data will be collected and how it will be collected.
        Only collected from Linux machines.
        :param Sequence[str] facility_names: The list of facility names.
        :param Sequence[str] log_levels: The log levels to collect.
        :param str name: A friendly name for the data source. 
               This name should be unique across all data sources (regardless of type) within the data collection rule.
        :param Sequence[str] streams: List of streams that this data source will be sent to.
               A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
        """
        if facility_names is not None:
            pulumi.set(__self__, "facility_names", facility_names)
        if log_levels is not None:
            pulumi.set(__self__, "log_levels", log_levels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if streams is not None:
            pulumi.set(__self__, "streams", streams)

    @property
    @pulumi.getter(name="facilityNames")
    def facility_names(self) -> Optional[Sequence[str]]:
        """
        The list of facility names.
        """
        return pulumi.get(self, "facility_names")

    @property
    @pulumi.getter(name="logLevels")
    def log_levels(self) -> Optional[Sequence[str]]:
        """
        The log levels to collect.
        """
        return pulumi.get(self, "log_levels")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        A friendly name for the data source. 
        This name should be unique across all data sources (regardless of type) within the data collection rule.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def streams(self) -> Optional[Sequence[str]]:
        """
        List of streams that this data source will be sent to.
        A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
        """
        return pulumi.get(self, "streams")


@pulumi.output_type
class ThresholdRuleConditionResponse(dict):
    """
    A rule condition based on a metric crossing a threshold.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "dataSource":
            suggest = "data_source"
        elif key == "timeAggregation":
            suggest = "time_aggregation"
        elif key == "windowSize":
            suggest = "window_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ThresholdRuleConditionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ThresholdRuleConditionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ThresholdRuleConditionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 operator: str,
                 threshold: float,
                 data_source: Optional[Any] = None,
                 time_aggregation: Optional[str] = None,
                 window_size: Optional[str] = None):
        """
        A rule condition based on a metric crossing a threshold.
        :param str odata_type: specifies the type of condition. This can be one of three types: ManagementEventRuleCondition (occurrences of management events), LocationThresholdRuleCondition (based on the number of failures of a web test), and ThresholdRuleCondition (based on the threshold of a metric).
               Expected value is 'Microsoft.Azure.Management.Insights.Models.ThresholdRuleCondition'.
        :param str operator: the operator used to compare the data and the threshold.
        :param float threshold: the threshold value that activates the alert.
        :param Union['RuleManagementEventDataSourceResponse', 'RuleMetricDataSourceResponse'] data_source: the resource from which the rule collects its data. For this type dataSource will always be of type RuleMetricDataSource.
        :param str time_aggregation: the time aggregation operator. How the data that are collected should be combined over time. The default value is the PrimaryAggregationType of the Metric.
        :param str window_size: the period of time (in ISO 8601 duration format) that is used to monitor alert activity based on the threshold. If specified then it must be between 5 minutes and 1 day.
        """
        pulumi.set(__self__, "odata_type", 'Microsoft.Azure.Management.Insights.Models.ThresholdRuleCondition')
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "threshold", threshold)
        if data_source is not None:
            pulumi.set(__self__, "data_source", data_source)
        if time_aggregation is not None:
            pulumi.set(__self__, "time_aggregation", time_aggregation)
        if window_size is not None:
            pulumi.set(__self__, "window_size", window_size)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        specifies the type of condition. This can be one of three types: ManagementEventRuleCondition (occurrences of management events), LocationThresholdRuleCondition (based on the number of failures of a web test), and ThresholdRuleCondition (based on the threshold of a metric).
        Expected value is 'Microsoft.Azure.Management.Insights.Models.ThresholdRuleCondition'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter
    def operator(self) -> str:
        """
        the operator used to compare the data and the threshold.
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter
    def threshold(self) -> float:
        """
        the threshold value that activates the alert.
        """
        return pulumi.get(self, "threshold")

    @property
    @pulumi.getter(name="dataSource")
    def data_source(self) -> Optional[Any]:
        """
        the resource from which the rule collects its data. For this type dataSource will always be of type RuleMetricDataSource.
        """
        return pulumi.get(self, "data_source")

    @property
    @pulumi.getter(name="timeAggregation")
    def time_aggregation(self) -> Optional[str]:
        """
        the time aggregation operator. How the data that are collected should be combined over time. The default value is the PrimaryAggregationType of the Metric.
        """
        return pulumi.get(self, "time_aggregation")

    @property
    @pulumi.getter(name="windowSize")
    def window_size(self) -> Optional[str]:
        """
        the period of time (in ISO 8601 duration format) that is used to monitor alert activity based on the threshold. If specified then it must be between 5 minutes and 1 day.
        """
        return pulumi.get(self, "window_size")


@pulumi.output_type
class TimeWindowResponse(dict):
    """
    A specific date-time for the profile.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timeZone":
            suggest = "time_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TimeWindowResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TimeWindowResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TimeWindowResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end: str,
                 start: str,
                 time_zone: Optional[str] = None):
        """
        A specific date-time for the profile.
        :param str end: the end time for the profile in ISO 8601 format.
        :param str start: the start time for the profile in ISO 8601 format.
        :param str time_zone: the timezone of the start and end times for the profile. Some examples of valid time zones are: Dateline Standard Time, UTC-11, Hawaiian Standard Time, Alaskan Standard Time, Pacific Standard Time (Mexico), Pacific Standard Time, US Mountain Standard Time, Mountain Standard Time (Mexico), Mountain Standard Time, Central America Standard Time, Central Standard Time, Central Standard Time (Mexico), Canada Central Standard Time, SA Pacific Standard Time, Eastern Standard Time, US Eastern Standard Time, Venezuela Standard Time, Paraguay Standard Time, Atlantic Standard Time, Central Brazilian Standard Time, SA Western Standard Time, Pacific SA Standard Time, Newfoundland Standard Time, E. South America Standard Time, Argentina Standard Time, SA Eastern Standard Time, Greenland Standard Time, Montevideo Standard Time, Bahia Standard Time, UTC-02, Mid-Atlantic Standard Time, Azores Standard Time, Cape Verde Standard Time, Morocco Standard Time, UTC, GMT Standard Time, Greenwich Standard Time, W. Europe Standard Time, Central Europe Standard Time, Romance Standard Time, Central European Standard Time, W. Central Africa Standard Time, Namibia Standard Time, Jordan Standard Time, GTB Standard Time, Middle East Standard Time, Egypt Standard Time, Syria Standard Time, E. Europe Standard Time, South Africa Standard Time, FLE Standard Time, Turkey Standard Time, Israel Standard Time, Kaliningrad Standard Time, Libya Standard Time, Arabic Standard Time, Arab Standard Time, Belarus Standard Time, Russian Standard Time, E. Africa Standard Time, Iran Standard Time, Arabian Standard Time, Azerbaijan Standard Time, Russia Time Zone 3, Mauritius Standard Time, Georgian Standard Time, Caucasus Standard Time, Afghanistan Standard Time, West Asia Standard Time, Ekaterinburg Standard Time, Pakistan Standard Time, India Standard Time, Sri Lanka Standard Time, Nepal Standard Time, Central Asia Standard Time, Bangladesh Standard Time, N. Central Asia Standard Time, Myanmar Standard Time, SE Asia Standard Time, North Asia Standard Time, China Standard Time, North Asia East Standard Time, Singapore Standard Time, W. Australia Standard Time, Taipei Standard Time, Ulaanbaatar Standard Time, Tokyo Standard Time, Korea Standard Time, Yakutsk Standard Time, Cen. Australia Standard Time, AUS Central Standard Time, E. Australia Standard Time, AUS Eastern Standard Time, West Pacific Standard Time, Tasmania Standard Time, Magadan Standard Time, Vladivostok Standard Time, Russia Time Zone 10, Central Pacific Standard Time, Russia Time Zone 11, New Zealand Standard Time, UTC+12, Fiji Standard Time, Kamchatka Standard Time, Tonga Standard Time, Samoa Standard Time, Line Islands Standard Time
        """
        pulumi.set(__self__, "end", end)
        pulumi.set(__self__, "start", start)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter
    def end(self) -> str:
        """
        the end time for the profile in ISO 8601 format.
        """
        return pulumi.get(self, "end")

    @property
    @pulumi.getter
    def start(self) -> str:
        """
        the start time for the profile in ISO 8601 format.
        """
        return pulumi.get(self, "start")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[str]:
        """
        the timezone of the start and end times for the profile. Some examples of valid time zones are: Dateline Standard Time, UTC-11, Hawaiian Standard Time, Alaskan Standard Time, Pacific Standard Time (Mexico), Pacific Standard Time, US Mountain Standard Time, Mountain Standard Time (Mexico), Mountain Standard Time, Central America Standard Time, Central Standard Time, Central Standard Time (Mexico), Canada Central Standard Time, SA Pacific Standard Time, Eastern Standard Time, US Eastern Standard Time, Venezuela Standard Time, Paraguay Standard Time, Atlantic Standard Time, Central Brazilian Standard Time, SA Western Standard Time, Pacific SA Standard Time, Newfoundland Standard Time, E. South America Standard Time, Argentina Standard Time, SA Eastern Standard Time, Greenland Standard Time, Montevideo Standard Time, Bahia Standard Time, UTC-02, Mid-Atlantic Standard Time, Azores Standard Time, Cape Verde Standard Time, Morocco Standard Time, UTC, GMT Standard Time, Greenwich Standard Time, W. Europe Standard Time, Central Europe Standard Time, Romance Standard Time, Central European Standard Time, W. Central Africa Standard Time, Namibia Standard Time, Jordan Standard Time, GTB Standard Time, Middle East Standard Time, Egypt Standard Time, Syria Standard Time, E. Europe Standard Time, South Africa Standard Time, FLE Standard Time, Turkey Standard Time, Israel Standard Time, Kaliningrad Standard Time, Libya Standard Time, Arabic Standard Time, Arab Standard Time, Belarus Standard Time, Russian Standard Time, E. Africa Standard Time, Iran Standard Time, Arabian Standard Time, Azerbaijan Standard Time, Russia Time Zone 3, Mauritius Standard Time, Georgian Standard Time, Caucasus Standard Time, Afghanistan Standard Time, West Asia Standard Time, Ekaterinburg Standard Time, Pakistan Standard Time, India Standard Time, Sri Lanka Standard Time, Nepal Standard Time, Central Asia Standard Time, Bangladesh Standard Time, N. Central Asia Standard Time, Myanmar Standard Time, SE Asia Standard Time, North Asia Standard Time, China Standard Time, North Asia East Standard Time, Singapore Standard Time, W. Australia Standard Time, Taipei Standard Time, Ulaanbaatar Standard Time, Tokyo Standard Time, Korea Standard Time, Yakutsk Standard Time, Cen. Australia Standard Time, AUS Central Standard Time, E. Australia Standard Time, AUS Eastern Standard Time, West Pacific Standard Time, Tasmania Standard Time, Magadan Standard Time, Vladivostok Standard Time, Russia Time Zone 10, Central Pacific Standard Time, Russia Time Zone 11, New Zealand Standard Time, UTC+12, Fiji Standard Time, Kamchatka Standard Time, Tonga Standard Time, Samoa Standard Time, Line Islands Standard Time
        """
        return pulumi.get(self, "time_zone")


@pulumi.output_type
class TriggerConditionResponse(dict):
    """
    The condition that results in the Log Search rule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "thresholdOperator":
            suggest = "threshold_operator"
        elif key == "metricTrigger":
            suggest = "metric_trigger"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TriggerConditionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TriggerConditionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TriggerConditionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 threshold: float,
                 threshold_operator: str,
                 metric_trigger: Optional['outputs.LogMetricTriggerResponse'] = None):
        """
        The condition that results in the Log Search rule.
        :param float threshold: Result or count threshold based on which rule should be triggered.
        :param str threshold_operator: Evaluation operation for rule - 'GreaterThan' or 'LessThan.
        :param 'LogMetricTriggerResponse' metric_trigger: Trigger condition for metric query rule
        """
        pulumi.set(__self__, "threshold", threshold)
        pulumi.set(__self__, "threshold_operator", threshold_operator)
        if metric_trigger is not None:
            pulumi.set(__self__, "metric_trigger", metric_trigger)

    @property
    @pulumi.getter
    def threshold(self) -> float:
        """
        Result or count threshold based on which rule should be triggered.
        """
        return pulumi.get(self, "threshold")

    @property
    @pulumi.getter(name="thresholdOperator")
    def threshold_operator(self) -> str:
        """
        Evaluation operation for rule - 'GreaterThan' or 'LessThan.
        """
        return pulumi.get(self, "threshold_operator")

    @property
    @pulumi.getter(name="metricTrigger")
    def metric_trigger(self) -> Optional['outputs.LogMetricTriggerResponse']:
        """
        Trigger condition for metric query rule
        """
        return pulumi.get(self, "metric_trigger")


@pulumi.output_type
class VoiceReceiverResponse(dict):
    """
    A voice receiver.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "countryCode":
            suggest = "country_code"
        elif key == "phoneNumber":
            suggest = "phone_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VoiceReceiverResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VoiceReceiverResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VoiceReceiverResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 country_code: str,
                 name: str,
                 phone_number: str):
        """
        A voice receiver.
        :param str country_code: The country code of the voice receiver.
        :param str name: The name of the voice receiver. Names must be unique across all receivers within an action group.
        :param str phone_number: The phone number of the voice receiver.
        """
        pulumi.set(__self__, "country_code", country_code)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "phone_number", phone_number)

    @property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> str:
        """
        The country code of the voice receiver.
        """
        return pulumi.get(self, "country_code")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the voice receiver. Names must be unique across all receivers within an action group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> str:
        """
        The phone number of the voice receiver.
        """
        return pulumi.get(self, "phone_number")


@pulumi.output_type
class WebTestGeolocationResponse(dict):
    """
    Geo-physical location to run a web test from. You must specify one or more locations for the test to run from.
    """
    def __init__(__self__, *,
                 location: Optional[str] = None):
        """
        Geo-physical location to run a web test from. You must specify one or more locations for the test to run from.
        :param str location: Location ID for the webtest to run from.
        """
        if location is not None:
            pulumi.set(__self__, "location", location)

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Location ID for the webtest to run from.
        """
        return pulumi.get(self, "location")


@pulumi.output_type
class WebTestPropertiesResponseConfiguration(dict):
    """
    An XML configuration specification for a WebTest.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "webTest":
            suggest = "web_test"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebTestPropertiesResponseConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebTestPropertiesResponseConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebTestPropertiesResponseConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 web_test: Optional[str] = None):
        """
        An XML configuration specification for a WebTest.
        :param str web_test: The XML specification of a WebTest to run against an application.
        """
        if web_test is not None:
            pulumi.set(__self__, "web_test", web_test)

    @property
    @pulumi.getter(name="webTest")
    def web_test(self) -> Optional[str]:
        """
        The XML specification of a WebTest to run against an application.
        """
        return pulumi.get(self, "web_test")


@pulumi.output_type
class WebhookNotificationResponse(dict):
    """
    Webhook notification of an autoscale event.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serviceUri":
            suggest = "service_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebhookNotificationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebhookNotificationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebhookNotificationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 properties: Optional[Mapping[str, str]] = None,
                 service_uri: Optional[str] = None):
        """
        Webhook notification of an autoscale event.
        :param Mapping[str, str] properties: a property bag of settings. This value can be empty.
        :param str service_uri: the service address to receive the notification.
        """
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if service_uri is not None:
            pulumi.set(__self__, "service_uri", service_uri)

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        a property bag of settings. This value can be empty.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="serviceUri")
    def service_uri(self) -> Optional[str]:
        """
        the service address to receive the notification.
        """
        return pulumi.get(self, "service_uri")


@pulumi.output_type
class WebhookReceiverResponse(dict):
    """
    A webhook receiver.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serviceUri":
            suggest = "service_uri"
        elif key == "identifierUri":
            suggest = "identifier_uri"
        elif key == "objectId":
            suggest = "object_id"
        elif key == "tenantId":
            suggest = "tenant_id"
        elif key == "useAadAuth":
            suggest = "use_aad_auth"
        elif key == "useCommonAlertSchema":
            suggest = "use_common_alert_schema"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebhookReceiverResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebhookReceiverResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebhookReceiverResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 service_uri: str,
                 identifier_uri: Optional[str] = None,
                 object_id: Optional[str] = None,
                 tenant_id: Optional[str] = None,
                 use_aad_auth: Optional[bool] = None,
                 use_common_alert_schema: Optional[bool] = None):
        """
        A webhook receiver.
        :param str name: The name of the webhook receiver. Names must be unique across all receivers within an action group.
        :param str service_uri: The URI where webhooks should be sent.
        :param str identifier_uri: Indicates the identifier uri for aad auth.
        :param str object_id: Indicates the webhook app object Id for aad auth.
        :param str tenant_id: Indicates the tenant id for aad auth.
        :param bool use_aad_auth: Indicates whether or not use AAD authentication.
        :param bool use_common_alert_schema: Indicates whether to use common alert schema.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "service_uri", service_uri)
        if identifier_uri is not None:
            pulumi.set(__self__, "identifier_uri", identifier_uri)
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if use_aad_auth is None:
            use_aad_auth = False
        if use_aad_auth is not None:
            pulumi.set(__self__, "use_aad_auth", use_aad_auth)
        if use_common_alert_schema is None:
            use_common_alert_schema = False
        if use_common_alert_schema is not None:
            pulumi.set(__self__, "use_common_alert_schema", use_common_alert_schema)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the webhook receiver. Names must be unique across all receivers within an action group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="serviceUri")
    def service_uri(self) -> str:
        """
        The URI where webhooks should be sent.
        """
        return pulumi.get(self, "service_uri")

    @property
    @pulumi.getter(name="identifierUri")
    def identifier_uri(self) -> Optional[str]:
        """
        Indicates the identifier uri for aad auth.
        """
        return pulumi.get(self, "identifier_uri")

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[str]:
        """
        Indicates the webhook app object Id for aad auth.
        """
        return pulumi.get(self, "object_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[str]:
        """
        Indicates the tenant id for aad auth.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="useAadAuth")
    def use_aad_auth(self) -> Optional[bool]:
        """
        Indicates whether or not use AAD authentication.
        """
        return pulumi.get(self, "use_aad_auth")

    @property
    @pulumi.getter(name="useCommonAlertSchema")
    def use_common_alert_schema(self) -> Optional[bool]:
        """
        Indicates whether to use common alert schema.
        """
        return pulumi.get(self, "use_common_alert_schema")


@pulumi.output_type
class WebtestLocationAvailabilityCriteriaResponse(dict):
    """
    Specifies the metric alert rule criteria for a web test resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "componentId":
            suggest = "component_id"
        elif key == "failedLocationCount":
            suggest = "failed_location_count"
        elif key == "odataType":
            suggest = "odata_type"
        elif key == "webTestId":
            suggest = "web_test_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebtestLocationAvailabilityCriteriaResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebtestLocationAvailabilityCriteriaResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebtestLocationAvailabilityCriteriaResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 component_id: str,
                 failed_location_count: float,
                 odata_type: str,
                 web_test_id: str):
        """
        Specifies the metric alert rule criteria for a web test resource.
        :param str component_id: The Application Insights resource Id.
        :param float failed_location_count: The number of failed locations.
        :param str odata_type: specifies the type of the alert criteria.
               Expected value is 'Microsoft.Azure.Monitor.WebtestLocationAvailabilityCriteria'.
        :param str web_test_id: The Application Insights web test Id.
        """
        pulumi.set(__self__, "component_id", component_id)
        pulumi.set(__self__, "failed_location_count", failed_location_count)
        pulumi.set(__self__, "odata_type", 'Microsoft.Azure.Monitor.WebtestLocationAvailabilityCriteria')
        pulumi.set(__self__, "web_test_id", web_test_id)

    @property
    @pulumi.getter(name="componentId")
    def component_id(self) -> str:
        """
        The Application Insights resource Id.
        """
        return pulumi.get(self, "component_id")

    @property
    @pulumi.getter(name="failedLocationCount")
    def failed_location_count(self) -> float:
        """
        The number of failed locations.
        """
        return pulumi.get(self, "failed_location_count")

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        specifies the type of the alert criteria.
        Expected value is 'Microsoft.Azure.Monitor.WebtestLocationAvailabilityCriteria'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="webTestId")
    def web_test_id(self) -> str:
        """
        The Application Insights web test Id.
        """
        return pulumi.get(self, "web_test_id")


@pulumi.output_type
class WindowsEventLogDataSourceResponse(dict):
    """
    Definition of which Windows Event Log events will be collected and how they will be collected.
    Only collected from Windows machines.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "xPathQueries":
            suggest = "x_path_queries"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WindowsEventLogDataSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WindowsEventLogDataSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WindowsEventLogDataSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[str] = None,
                 streams: Optional[Sequence[str]] = None,
                 x_path_queries: Optional[Sequence[str]] = None):
        """
        Definition of which Windows Event Log events will be collected and how they will be collected.
        Only collected from Windows machines.
        :param str name: A friendly name for the data source. 
               This name should be unique across all data sources (regardless of type) within the data collection rule.
        :param Sequence[str] streams: List of streams that this data source will be sent to.
               A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
        :param Sequence[str] x_path_queries: A list of Windows Event Log queries in XPATH format.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if streams is not None:
            pulumi.set(__self__, "streams", streams)
        if x_path_queries is not None:
            pulumi.set(__self__, "x_path_queries", x_path_queries)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        A friendly name for the data source. 
        This name should be unique across all data sources (regardless of type) within the data collection rule.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def streams(self) -> Optional[Sequence[str]]:
        """
        List of streams that this data source will be sent to.
        A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
        """
        return pulumi.get(self, "streams")

    @property
    @pulumi.getter(name="xPathQueries")
    def x_path_queries(self) -> Optional[Sequence[str]]:
        """
        A list of Windows Event Log queries in XPATH format.
        """
        return pulumi.get(self, "x_path_queries")


@pulumi.output_type
class WorkbookManagedIdentityResponse(dict):
    """
    Customer Managed Identity
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userAssignedIdentities":
            suggest = "user_assigned_identities"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkbookManagedIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkbookManagedIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkbookManagedIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: Optional[str] = None,
                 user_assigned_identities: Optional['outputs.WorkbookUserAssignedIdentitiesResponse'] = None):
        """
        Customer Managed Identity
        :param str type: The identity type.
        :param 'WorkbookUserAssignedIdentitiesResponse' user_assigned_identities: Customer Managed Identity
        """
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The identity type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional['outputs.WorkbookUserAssignedIdentitiesResponse']:
        """
        Customer Managed Identity
        """
        return pulumi.get(self, "user_assigned_identities")


@pulumi.output_type
class WorkbookTemplateGalleryResponse(dict):
    """
    Gallery information for a workbook template.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceType":
            suggest = "resource_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkbookTemplateGalleryResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkbookTemplateGalleryResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkbookTemplateGalleryResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 category: Optional[str] = None,
                 name: Optional[str] = None,
                 order: Optional[int] = None,
                 resource_type: Optional[str] = None,
                 type: Optional[str] = None):
        """
        Gallery information for a workbook template.
        :param str category: Category for the gallery.
        :param str name: Name of the workbook template in the gallery.
        :param int order: Order of the template within the gallery.
        :param str resource_type: Azure resource type supported by the gallery.
        :param str type: Type of workbook supported by the workbook template.
        """
        if category is not None:
            pulumi.set(__self__, "category", category)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if order is not None:
            pulumi.set(__self__, "order", order)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def category(self) -> Optional[str]:
        """
        Category for the gallery.
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the workbook template in the gallery.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def order(self) -> Optional[int]:
        """
        Order of the template within the gallery.
        """
        return pulumi.get(self, "order")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[str]:
        """
        Azure resource type supported by the gallery.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Type of workbook supported by the workbook template.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class WorkbookTemplateLocalizedGalleryResponse(dict):
    """
    Localized template data and gallery information.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "templateData":
            suggest = "template_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkbookTemplateLocalizedGalleryResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkbookTemplateLocalizedGalleryResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkbookTemplateLocalizedGalleryResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 galleries: Optional[Sequence['outputs.WorkbookTemplateGalleryResponse']] = None,
                 template_data: Optional[Any] = None):
        """
        Localized template data and gallery information.
        :param Sequence['WorkbookTemplateGalleryResponse'] galleries: Workbook galleries supported by the template.
        :param Any template_data: Valid JSON object containing workbook template payload.
        """
        if galleries is not None:
            pulumi.set(__self__, "galleries", galleries)
        if template_data is not None:
            pulumi.set(__self__, "template_data", template_data)

    @property
    @pulumi.getter
    def galleries(self) -> Optional[Sequence['outputs.WorkbookTemplateGalleryResponse']]:
        """
        Workbook galleries supported by the template.
        """
        return pulumi.get(self, "galleries")

    @property
    @pulumi.getter(name="templateData")
    def template_data(self) -> Optional[Any]:
        """
        Valid JSON object containing workbook template payload.
        """
        return pulumi.get(self, "template_data")


@pulumi.output_type
class WorkbookUserAssignedIdentitiesResponse(dict):
    """
    Customer Managed Identity
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkbookUserAssignedIdentitiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkbookUserAssignedIdentitiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkbookUserAssignedIdentitiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: str,
                 principal_id: str,
                 tenant_id: str):
        """
        Customer Managed Identity
        :param str client_id: The client ID of resource.
        :param str principal_id: The principal ID of resource identity.
        :param str tenant_id: The tenant ID of resource.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        """
        The client ID of resource.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal ID of resource identity.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The tenant ID of resource.
        """
        return pulumi.get(self, "tenant_id")


