# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = ['ProviderInstanceArgs', 'ProviderInstance']

@pulumi.input_type
class ProviderInstanceArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[str],
                 sap_monitor_name: pulumi.Input[str],
                 metadata: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[str]] = None,
                 provider_instance_name: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ProviderInstance resource.
        :param pulumi.Input[str] resource_group_name: Name of the resource group.
        :param pulumi.Input[str] sap_monitor_name: Name of the SAP monitor resource.
        :param pulumi.Input[str] metadata: A JSON string containing metadata of the provider instance.
        :param pulumi.Input[str] properties: A JSON string containing the properties of the provider instance.
        :param pulumi.Input[str] provider_instance_name: Name of the provider instance.
        :param pulumi.Input[str] type: The type of provider instance.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "sap_monitor_name", sap_monitor_name)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if provider_instance_name is not None:
            pulumi.set(__self__, "provider_instance_name", provider_instance_name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[str]:
        """
        Name of the resource group.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="sapMonitorName")
    def sap_monitor_name(self) -> pulumi.Input[str]:
        """
        Name of the SAP monitor resource.
        """
        return pulumi.get(self, "sap_monitor_name")

    @sap_monitor_name.setter
    def sap_monitor_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "sap_monitor_name", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[str]]:
        """
        A JSON string containing metadata of the provider instance.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[str]]:
        """
        A JSON string containing the properties of the provider instance.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="providerInstanceName")
    def provider_instance_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the provider instance.
        """
        return pulumi.get(self, "provider_instance_name")

    @provider_instance_name.setter
    def provider_instance_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "provider_instance_name", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of provider instance.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


class ProviderInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 metadata: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[str]] = None,
                 provider_instance_name: Optional[pulumi.Input[str]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 sap_monitor_name: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        A provider instance associated with a SAP monitor.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] metadata: A JSON string containing metadata of the provider instance.
        :param pulumi.Input[str] properties: A JSON string containing the properties of the provider instance.
        :param pulumi.Input[str] provider_instance_name: Name of the provider instance.
        :param pulumi.Input[str] resource_group_name: Name of the resource group.
        :param pulumi.Input[str] sap_monitor_name: Name of the SAP monitor resource.
        :param pulumi.Input[str] type: The type of provider instance.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProviderInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A provider instance associated with a SAP monitor.

        :param str resource_name: The name of the resource.
        :param ProviderInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProviderInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 metadata: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[str]] = None,
                 provider_instance_name: Optional[pulumi.Input[str]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 sap_monitor_name: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProviderInstanceArgs.__new__(ProviderInstanceArgs)

            __props__.__dict__["metadata"] = metadata
            __props__.__dict__["properties"] = properties
            __props__.__dict__["provider_instance_name"] = provider_instance_name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if sap_monitor_name is None and not opts.urn:
                raise TypeError("Missing required property 'sap_monitor_name'")
            __props__.__dict__["sap_monitor_name"] = sap_monitor_name
            __props__.__dict__["type"] = type
            __props__.__dict__["name"] = None
            __props__.__dict__["provisioning_state"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="azure-native:hanaonazure:ProviderInstance")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(ProviderInstance, __self__).__init__(
            'azure-native:hanaonazure/v20200207preview:ProviderInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'ProviderInstance':
        """
        Get an existing ProviderInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ProviderInstanceArgs.__new__(ProviderInstanceArgs)

        __props__.__dict__["metadata"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["properties"] = None
        __props__.__dict__["provisioning_state"] = None
        __props__.__dict__["type"] = None
        return ProviderInstance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Optional[str]]:
        """
        A JSON string containing metadata of the provider instance.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def properties(self) -> pulumi.Output[str]:
        """
        A JSON string containing the properties of the provider instance.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> pulumi.Output[str]:
        """
        State of provisioning of the provider instance
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")

