# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ArmIdentityResponse',
    'ArmUserIdentityResponse',
    'CertificatePropertiesResponse',
    'EncryptionKeyIdentityResponse',
    'EncryptionPropertiesDescriptionResponse',
    'IotDpsPropertiesDescriptionResponse',
    'IotDpsSkuInfoResponse',
    'IotHubDefinitionDescriptionResponse',
    'KeyVaultKeyPropertiesResponse',
    'PrivateEndpointConnectionPropertiesResponse',
    'PrivateEndpointConnectionResponse',
    'PrivateEndpointResponse',
    'PrivateLinkServiceConnectionStateResponse',
    'SharedAccessSignatureAuthorizationRuleAccessRightsDescriptionResponse',
    'TargetIpFilterRuleResponse',
]

@pulumi.output_type
class ArmIdentityResponse(dict):
    """
    The set of ARM identities associated with the IoT DPS resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"
        elif key == "identityType":
            suggest = "identity_type"
        elif key == "userAssignedIdentities":
            suggest = "user_assigned_identities"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ArmIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ArmIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ArmIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: str,
                 tenant_id: str,
                 identity_type: Optional[str] = None,
                 user_assigned_identities: Optional[Mapping[str, 'outputs.ArmUserIdentityResponse']] = None):
        """
        The set of ARM identities associated with the IoT DPS resource.
        :param str principal_id: Principal Id
        :param str tenant_id: Tenant Id
        :param str identity_type: Identity type. Only allowed values are SystemAssigned and UserAssigned. Comma separated if both for ex: SystemAssigned,UserAssigned.
        :param Mapping[str, 'ArmUserIdentityResponse'] user_assigned_identities: The set of UserAssigned identities associated with the IoT DPS resource.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if identity_type is not None:
            pulumi.set(__self__, "identity_type", identity_type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        Principal Id
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        Tenant Id
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="identityType")
    def identity_type(self) -> Optional[str]:
        """
        Identity type. Only allowed values are SystemAssigned and UserAssigned. Comma separated if both for ex: SystemAssigned,UserAssigned.
        """
        return pulumi.get(self, "identity_type")

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[Mapping[str, 'outputs.ArmUserIdentityResponse']]:
        """
        The set of UserAssigned identities associated with the IoT DPS resource.
        """
        return pulumi.get(self, "user_assigned_identities")


@pulumi.output_type
class ArmUserIdentityResponse(dict):
    """
    The ARM UserAssigned identity information
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "principalId":
            suggest = "principal_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ArmUserIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ArmUserIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ArmUserIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: str,
                 principal_id: str):
        """
        The ARM UserAssigned identity information
        :param str client_id: Client Id
        :param str principal_id: Principal Id
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "principal_id", principal_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        """
        Client Id
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        Principal Id
        """
        return pulumi.get(self, "principal_id")


@pulumi.output_type
class CertificatePropertiesResponse(dict):
    """
    The description of an X509 CA Certificate.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isVerified":
            suggest = "is_verified"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificatePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificatePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificatePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created: str,
                 expiry: str,
                 is_verified: bool,
                 subject: str,
                 thumbprint: str,
                 updated: str):
        """
        The description of an X509 CA Certificate.
        :param str created: The certificate's creation date and time.
        :param str expiry: The certificate's expiration date and time.
        :param bool is_verified: Determines whether certificate has been verified.
        :param str subject: The certificate's subject name.
        :param str thumbprint: The certificate's thumbprint.
        :param str updated: The certificate's last update date and time.
        """
        pulumi.set(__self__, "created", created)
        pulumi.set(__self__, "expiry", expiry)
        pulumi.set(__self__, "is_verified", is_verified)
        pulumi.set(__self__, "subject", subject)
        pulumi.set(__self__, "thumbprint", thumbprint)
        pulumi.set(__self__, "updated", updated)

    @property
    @pulumi.getter
    def created(self) -> str:
        """
        The certificate's creation date and time.
        """
        return pulumi.get(self, "created")

    @property
    @pulumi.getter
    def expiry(self) -> str:
        """
        The certificate's expiration date and time.
        """
        return pulumi.get(self, "expiry")

    @property
    @pulumi.getter(name="isVerified")
    def is_verified(self) -> bool:
        """
        Determines whether certificate has been verified.
        """
        return pulumi.get(self, "is_verified")

    @property
    @pulumi.getter
    def subject(self) -> str:
        """
        The certificate's subject name.
        """
        return pulumi.get(self, "subject")

    @property
    @pulumi.getter
    def thumbprint(self) -> str:
        """
        The certificate's thumbprint.
        """
        return pulumi.get(self, "thumbprint")

    @property
    @pulumi.getter
    def updated(self) -> str:
        """
        The certificate's last update date and time.
        """
        return pulumi.get(self, "updated")


@pulumi.output_type
class EncryptionKeyIdentityResponse(dict):
    """
    The properties of the identity used to access the key encryption key in KeyVault.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userAssignedIdentity":
            suggest = "user_assigned_identity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EncryptionKeyIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EncryptionKeyIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EncryptionKeyIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 user_assigned_identity: Optional[str] = None):
        """
        The properties of the identity used to access the key encryption key in KeyVault.
        :param str user_assigned_identity: The user assigned identity.
        """
        if user_assigned_identity is not None:
            pulumi.set(__self__, "user_assigned_identity", user_assigned_identity)

    @property
    @pulumi.getter(name="userAssignedIdentity")
    def user_assigned_identity(self) -> Optional[str]:
        """
        The user assigned identity.
        """
        return pulumi.get(self, "user_assigned_identity")


@pulumi.output_type
class EncryptionPropertiesDescriptionResponse(dict):
    """
    The customer-managed encryption key (CMK) properties for the IoT DPS instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keySource":
            suggest = "key_source"
        elif key == "keyVaultProperties":
            suggest = "key_vault_properties"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EncryptionPropertiesDescriptionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EncryptionPropertiesDescriptionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EncryptionPropertiesDescriptionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 identity: Optional['outputs.EncryptionKeyIdentityResponse'] = None,
                 key_source: Optional[str] = None,
                 key_vault_properties: Optional[Sequence['outputs.KeyVaultKeyPropertiesResponse']] = None):
        """
        The customer-managed encryption key (CMK) properties for the IoT DPS instance.
        :param 'EncryptionKeyIdentityResponse' identity: The identity used to access the encryption key in KeyVault.
        :param str key_source: The source of the encryption key. Typically, Microsoft.KeyVault
        :param Sequence['KeyVaultKeyPropertiesResponse'] key_vault_properties: The properties of the encryption key configured in KeyVault.
        """
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if key_source is not None:
            pulumi.set(__self__, "key_source", key_source)
        if key_vault_properties is not None:
            pulumi.set(__self__, "key_vault_properties", key_vault_properties)

    @property
    @pulumi.getter
    def identity(self) -> Optional['outputs.EncryptionKeyIdentityResponse']:
        """
        The identity used to access the encryption key in KeyVault.
        """
        return pulumi.get(self, "identity")

    @property
    @pulumi.getter(name="keySource")
    def key_source(self) -> Optional[str]:
        """
        The source of the encryption key. Typically, Microsoft.KeyVault
        """
        return pulumi.get(self, "key_source")

    @property
    @pulumi.getter(name="keyVaultProperties")
    def key_vault_properties(self) -> Optional[Sequence['outputs.KeyVaultKeyPropertiesResponse']]:
        """
        The properties of the encryption key configured in KeyVault.
        """
        return pulumi.get(self, "key_vault_properties")


@pulumi.output_type
class IotDpsPropertiesDescriptionResponse(dict):
    """
    the service specific properties of a provisioning service, including keys, linked iot hubs, current state, and system generated properties such as hostname and idScope
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deviceProvisioningHostName":
            suggest = "device_provisioning_host_name"
        elif key == "idScope":
            suggest = "id_scope"
        elif key == "serviceOperationsHostName":
            suggest = "service_operations_host_name"
        elif key == "allocationPolicy":
            suggest = "allocation_policy"
        elif key == "authorizationPolicies":
            suggest = "authorization_policies"
        elif key == "iotHubs":
            suggest = "iot_hubs"
        elif key == "ipFilterRules":
            suggest = "ip_filter_rules"
        elif key == "privateEndpointConnections":
            suggest = "private_endpoint_connections"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "publicNetworkAccess":
            suggest = "public_network_access"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IotDpsPropertiesDescriptionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IotDpsPropertiesDescriptionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IotDpsPropertiesDescriptionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 device_provisioning_host_name: str,
                 id_scope: str,
                 service_operations_host_name: str,
                 allocation_policy: Optional[str] = None,
                 authorization_policies: Optional[Sequence['outputs.SharedAccessSignatureAuthorizationRuleAccessRightsDescriptionResponse']] = None,
                 encryption: Optional['outputs.EncryptionPropertiesDescriptionResponse'] = None,
                 iot_hubs: Optional[Sequence['outputs.IotHubDefinitionDescriptionResponse']] = None,
                 ip_filter_rules: Optional[Sequence['outputs.TargetIpFilterRuleResponse']] = None,
                 private_endpoint_connections: Optional[Sequence['outputs.PrivateEndpointConnectionResponse']] = None,
                 provisioning_state: Optional[str] = None,
                 public_network_access: Optional[str] = None,
                 state: Optional[str] = None):
        """
        the service specific properties of a provisioning service, including keys, linked iot hubs, current state, and system generated properties such as hostname and idScope
        :param str device_provisioning_host_name: Device endpoint for this provisioning service.
        :param str id_scope: Unique identifier of this provisioning service.
        :param str service_operations_host_name: Service endpoint for provisioning service.
        :param str allocation_policy: Allocation policy to be used by this provisioning service.
        :param Sequence['SharedAccessSignatureAuthorizationRuleAccessRightsDescriptionResponse'] authorization_policies: List of authorization keys for a provisioning service.
        :param 'EncryptionPropertiesDescriptionResponse' encryption: The encryption properties for the IoT DPS instance.
        :param Sequence['IotHubDefinitionDescriptionResponse'] iot_hubs: List of IoT hubs associated with this provisioning service.
        :param Sequence['TargetIpFilterRuleResponse'] ip_filter_rules: The IP filter rules.
        :param Sequence['PrivateEndpointConnectionResponse'] private_endpoint_connections: Private endpoint connections created on this IotHub
        :param str provisioning_state: The ARM provisioning state of the provisioning service.
        :param str public_network_access: Whether requests from Public Network are allowed
        :param str state: Current state of the provisioning service.
        """
        pulumi.set(__self__, "device_provisioning_host_name", device_provisioning_host_name)
        pulumi.set(__self__, "id_scope", id_scope)
        pulumi.set(__self__, "service_operations_host_name", service_operations_host_name)
        if allocation_policy is not None:
            pulumi.set(__self__, "allocation_policy", allocation_policy)
        if authorization_policies is not None:
            pulumi.set(__self__, "authorization_policies", authorization_policies)
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if iot_hubs is not None:
            pulumi.set(__self__, "iot_hubs", iot_hubs)
        if ip_filter_rules is not None:
            pulumi.set(__self__, "ip_filter_rules", ip_filter_rules)
        if private_endpoint_connections is not None:
            pulumi.set(__self__, "private_endpoint_connections", private_endpoint_connections)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if public_network_access is not None:
            pulumi.set(__self__, "public_network_access", public_network_access)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="deviceProvisioningHostName")
    def device_provisioning_host_name(self) -> str:
        """
        Device endpoint for this provisioning service.
        """
        return pulumi.get(self, "device_provisioning_host_name")

    @property
    @pulumi.getter(name="idScope")
    def id_scope(self) -> str:
        """
        Unique identifier of this provisioning service.
        """
        return pulumi.get(self, "id_scope")

    @property
    @pulumi.getter(name="serviceOperationsHostName")
    def service_operations_host_name(self) -> str:
        """
        Service endpoint for provisioning service.
        """
        return pulumi.get(self, "service_operations_host_name")

    @property
    @pulumi.getter(name="allocationPolicy")
    def allocation_policy(self) -> Optional[str]:
        """
        Allocation policy to be used by this provisioning service.
        """
        return pulumi.get(self, "allocation_policy")

    @property
    @pulumi.getter(name="authorizationPolicies")
    def authorization_policies(self) -> Optional[Sequence['outputs.SharedAccessSignatureAuthorizationRuleAccessRightsDescriptionResponse']]:
        """
        List of authorization keys for a provisioning service.
        """
        return pulumi.get(self, "authorization_policies")

    @property
    @pulumi.getter
    def encryption(self) -> Optional['outputs.EncryptionPropertiesDescriptionResponse']:
        """
        The encryption properties for the IoT DPS instance.
        """
        return pulumi.get(self, "encryption")

    @property
    @pulumi.getter(name="iotHubs")
    def iot_hubs(self) -> Optional[Sequence['outputs.IotHubDefinitionDescriptionResponse']]:
        """
        List of IoT hubs associated with this provisioning service.
        """
        return pulumi.get(self, "iot_hubs")

    @property
    @pulumi.getter(name="ipFilterRules")
    def ip_filter_rules(self) -> Optional[Sequence['outputs.TargetIpFilterRuleResponse']]:
        """
        The IP filter rules.
        """
        return pulumi.get(self, "ip_filter_rules")

    @property
    @pulumi.getter(name="privateEndpointConnections")
    def private_endpoint_connections(self) -> Optional[Sequence['outputs.PrivateEndpointConnectionResponse']]:
        """
        Private endpoint connections created on this IotHub
        """
        return pulumi.get(self, "private_endpoint_connections")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        The ARM provisioning state of the provisioning service.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="publicNetworkAccess")
    def public_network_access(self) -> Optional[str]:
        """
        Whether requests from Public Network are allowed
        """
        return pulumi.get(self, "public_network_access")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        Current state of the provisioning service.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class IotDpsSkuInfoResponse(dict):
    """
    List of possible provisioning service SKUs.
    """
    def __init__(__self__, *,
                 tier: str,
                 capacity: Optional[float] = None,
                 name: Optional[str] = None):
        """
        List of possible provisioning service SKUs.
        :param str tier: Pricing tier name of the provisioning service.
        :param float capacity: The number of units to provision
        :param str name: Sku name.
        """
        pulumi.set(__self__, "tier", tier)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def tier(self) -> str:
        """
        Pricing tier name of the provisioning service.
        """
        return pulumi.get(self, "tier")

    @property
    @pulumi.getter
    def capacity(self) -> Optional[float]:
        """
        The number of units to provision
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Sku name.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class IotHubDefinitionDescriptionResponse(dict):
    """
    Description of the IoT hub.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionString":
            suggest = "connection_string"
        elif key == "allocationWeight":
            suggest = "allocation_weight"
        elif key == "applyAllocationPolicy":
            suggest = "apply_allocation_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IotHubDefinitionDescriptionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IotHubDefinitionDescriptionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IotHubDefinitionDescriptionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_string: str,
                 location: str,
                 name: str,
                 allocation_weight: Optional[int] = None,
                 apply_allocation_policy: Optional[bool] = None):
        """
        Description of the IoT hub.
        :param str connection_string: Connection string of the IoT hub.
        :param str location: ARM region of the IoT hub.
        :param str name: Host name of the IoT hub.
        :param int allocation_weight: weight to apply for a given iot h.
        :param bool apply_allocation_policy: flag for applying allocationPolicy or not for a given iot hub.
        """
        pulumi.set(__self__, "connection_string", connection_string)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "name", name)
        if allocation_weight is not None:
            pulumi.set(__self__, "allocation_weight", allocation_weight)
        if apply_allocation_policy is not None:
            pulumi.set(__self__, "apply_allocation_policy", apply_allocation_policy)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> str:
        """
        Connection string of the IoT hub.
        """
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        ARM region of the IoT hub.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Host name of the IoT hub.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="allocationWeight")
    def allocation_weight(self) -> Optional[int]:
        """
        weight to apply for a given iot h.
        """
        return pulumi.get(self, "allocation_weight")

    @property
    @pulumi.getter(name="applyAllocationPolicy")
    def apply_allocation_policy(self) -> Optional[bool]:
        """
        flag for applying allocationPolicy or not for a given iot hub.
        """
        return pulumi.get(self, "apply_allocation_policy")


@pulumi.output_type
class KeyVaultKeyPropertiesResponse(dict):
    """
    The properties of the KeyVault key.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyIdentifier":
            suggest = "key_identifier"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeyVaultKeyPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeyVaultKeyPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeyVaultKeyPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_identifier: Optional[str] = None):
        """
        The properties of the KeyVault key.
        :param str key_identifier: The identifier of the key.
        """
        if key_identifier is not None:
            pulumi.set(__self__, "key_identifier", key_identifier)

    @property
    @pulumi.getter(name="keyIdentifier")
    def key_identifier(self) -> Optional[str]:
        """
        The identifier of the key.
        """
        return pulumi.get(self, "key_identifier")


@pulumi.output_type
class PrivateEndpointConnectionPropertiesResponse(dict):
    """
    The properties of a private endpoint connection
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateLinkServiceConnectionState":
            suggest = "private_link_service_connection_state"
        elif key == "privateEndpoint":
            suggest = "private_endpoint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateEndpointConnectionPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateEndpointConnectionPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateEndpointConnectionPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 private_link_service_connection_state: 'outputs.PrivateLinkServiceConnectionStateResponse',
                 private_endpoint: Optional['outputs.PrivateEndpointResponse'] = None):
        """
        The properties of a private endpoint connection
        :param 'PrivateLinkServiceConnectionStateResponse' private_link_service_connection_state: The current state of a private endpoint connection
        :param 'PrivateEndpointResponse' private_endpoint: The private endpoint property of a private endpoint connection
        """
        pulumi.set(__self__, "private_link_service_connection_state", private_link_service_connection_state)
        if private_endpoint is not None:
            pulumi.set(__self__, "private_endpoint", private_endpoint)

    @property
    @pulumi.getter(name="privateLinkServiceConnectionState")
    def private_link_service_connection_state(self) -> 'outputs.PrivateLinkServiceConnectionStateResponse':
        """
        The current state of a private endpoint connection
        """
        return pulumi.get(self, "private_link_service_connection_state")

    @property
    @pulumi.getter(name="privateEndpoint")
    def private_endpoint(self) -> Optional['outputs.PrivateEndpointResponse']:
        """
        The private endpoint property of a private endpoint connection
        """
        return pulumi.get(self, "private_endpoint")


@pulumi.output_type
class PrivateEndpointConnectionResponse(dict):
    """
    The private endpoint connection of a provisioning service
    """
    def __init__(__self__, *,
                 id: str,
                 name: str,
                 properties: 'outputs.PrivateEndpointConnectionPropertiesResponse',
                 type: str):
        """
        The private endpoint connection of a provisioning service
        :param str id: The resource identifier.
        :param str name: The resource name.
        :param 'PrivateEndpointConnectionPropertiesResponse' properties: The properties of a private endpoint connection
        :param str type: The resource type.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "properties", properties)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The resource identifier.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def properties(self) -> 'outputs.PrivateEndpointConnectionPropertiesResponse':
        """
        The properties of a private endpoint connection
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The resource type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class PrivateEndpointResponse(dict):
    """
    The private endpoint property of a private endpoint connection
    """
    def __init__(__self__, *,
                 id: str):
        """
        The private endpoint property of a private endpoint connection
        :param str id: The resource identifier.
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The resource identifier.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class PrivateLinkServiceConnectionStateResponse(dict):
    """
    The current state of a private endpoint connection
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionsRequired":
            suggest = "actions_required"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateLinkServiceConnectionStateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateLinkServiceConnectionStateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateLinkServiceConnectionStateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: str,
                 status: str,
                 actions_required: Optional[str] = None):
        """
        The current state of a private endpoint connection
        :param str description: The description for the current state of a private endpoint connection
        :param str status: The status of a private endpoint connection
        :param str actions_required: Actions required for a private endpoint connection
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "status", status)
        if actions_required is not None:
            pulumi.set(__self__, "actions_required", actions_required)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description for the current state of a private endpoint connection
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of a private endpoint connection
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="actionsRequired")
    def actions_required(self) -> Optional[str]:
        """
        Actions required for a private endpoint connection
        """
        return pulumi.get(self, "actions_required")


@pulumi.output_type
class SharedAccessSignatureAuthorizationRuleAccessRightsDescriptionResponse(dict):
    """
    Description of the shared access key.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyName":
            suggest = "key_name"
        elif key == "primaryKey":
            suggest = "primary_key"
        elif key == "secondaryKey":
            suggest = "secondary_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SharedAccessSignatureAuthorizationRuleAccessRightsDescriptionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SharedAccessSignatureAuthorizationRuleAccessRightsDescriptionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SharedAccessSignatureAuthorizationRuleAccessRightsDescriptionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_name: str,
                 rights: str,
                 primary_key: Optional[str] = None,
                 secondary_key: Optional[str] = None):
        """
        Description of the shared access key.
        :param str key_name: Name of the key.
        :param str rights: Rights that this key has.
        :param str primary_key: Primary SAS key value.
        :param str secondary_key: Secondary SAS key value.
        """
        pulumi.set(__self__, "key_name", key_name)
        pulumi.set(__self__, "rights", rights)
        if primary_key is not None:
            pulumi.set(__self__, "primary_key", primary_key)
        if secondary_key is not None:
            pulumi.set(__self__, "secondary_key", secondary_key)

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> str:
        """
        Name of the key.
        """
        return pulumi.get(self, "key_name")

    @property
    @pulumi.getter
    def rights(self) -> str:
        """
        Rights that this key has.
        """
        return pulumi.get(self, "rights")

    @property
    @pulumi.getter(name="primaryKey")
    def primary_key(self) -> Optional[str]:
        """
        Primary SAS key value.
        """
        return pulumi.get(self, "primary_key")

    @property
    @pulumi.getter(name="secondaryKey")
    def secondary_key(self) -> Optional[str]:
        """
        Secondary SAS key value.
        """
        return pulumi.get(self, "secondary_key")


@pulumi.output_type
class TargetIpFilterRuleResponse(dict):
    """
    The IP filter rules for a provisioning Service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "filterName":
            suggest = "filter_name"
        elif key == "ipMask":
            suggest = "ip_mask"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TargetIpFilterRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TargetIpFilterRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TargetIpFilterRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: str,
                 filter_name: str,
                 ip_mask: str,
                 target: Optional[str] = None):
        """
        The IP filter rules for a provisioning Service.
        :param str action: The desired action for requests captured by this rule.
        :param str filter_name: The name of the IP filter rule.
        :param str ip_mask: A string that contains the IP address range in CIDR notation for the rule.
        :param str target: Target for requests captured by this rule.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "filter_name", filter_name)
        pulumi.set(__self__, "ip_mask", ip_mask)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter
    def action(self) -> str:
        """
        The desired action for requests captured by this rule.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="filterName")
    def filter_name(self) -> str:
        """
        The name of the IP filter rule.
        """
        return pulumi.get(self, "filter_name")

    @property
    @pulumi.getter(name="ipMask")
    def ip_mask(self) -> str:
        """
        A string that contains the IP address range in CIDR notation for the rule.
        """
        return pulumi.get(self, "ip_mask")

    @property
    @pulumi.getter
    def target(self) -> Optional[str]:
        """
        Target for requests captured by this rule.
        """
        return pulumi.get(self, "target")


