# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

from enum import Enum

__all__ = [
    'AuthenticationType',
    'BackupMode',
    'MongoDbReplication',
    'MongoDbShardKeyOrder',
    'MySqlTargetPlatformType',
    'ProjectSourcePlatform',
    'ProjectTargetPlatform',
    'ServerLevelPermissionsGroup',
    'SqlSourcePlatform',
    'SsisMigrationOverwriteOption',
    'SsisStoreType',
    'TaskType',
]


class AuthenticationType(str, Enum):
    """
    Authentication type to use for connection
    """
    NONE = "None"
    WINDOWS_AUTHENTICATION = "WindowsAuthentication"
    SQL_AUTHENTICATION = "SqlAuthentication"
    ACTIVE_DIRECTORY_INTEGRATED = "ActiveDirectoryIntegrated"
    ACTIVE_DIRECTORY_PASSWORD = "ActiveDirectoryPassword"


class BackupMode(str, Enum):
    """
    Backup Mode to specify whether to use existing backup or create new backup.
    """
    CREATE_BACKUP = "CreateBackup"
    EXISTING_BACKUP = "ExistingBackup"


class MongoDbReplication(str, Enum):
    """
    Describes how changes will be replicated from the source to the target. The default is OneTime.
    """
    DISABLED = "Disabled"
    ONE_TIME = "OneTime"
    CONTINUOUS = "Continuous"


class MongoDbShardKeyOrder(str, Enum):
    """
    The field ordering
    """
    FORWARD = "Forward"
    REVERSE = "Reverse"
    HASHED = "Hashed"


class MySqlTargetPlatformType(str, Enum):
    """
    Target Platform for the migration
    """
    SQL_SERVER = "SqlServer"
    AZURE_DB_FOR_MY_SQL = "AzureDbForMySQL"


class ProjectSourcePlatform(str, Enum):
    """
    Source platform for the project
    """
    SQL = "SQL"
    MY_SQL = "MySQL"
    POSTGRE_SQL = "PostgreSql"
    MONGO_DB = "MongoDb"
    UNKNOWN = "Unknown"


class ProjectTargetPlatform(str, Enum):
    """
    Target platform for the project
    """
    SQLDB = "SQLDB"
    SQLMI = "SQLMI"
    AZURE_DB_FOR_MY_SQL = "AzureDbForMySql"
    AZURE_DB_FOR_POSTGRE_SQL = "AzureDbForPostgreSql"
    MONGO_DB = "MongoDb"
    UNKNOWN = "Unknown"


class ServerLevelPermissionsGroup(str, Enum):
    """
    Permission group for validations
    """
    DEFAULT = "Default"
    MIGRATION_FROM_SQL_SERVER_TO_AZURE_DB = "MigrationFromSqlServerToAzureDB"
    MIGRATION_FROM_SQL_SERVER_TO_AZURE_MI = "MigrationFromSqlServerToAzureMI"
    MIGRATION_FROM_MY_SQL_TO_AZURE_DB_FOR_MY_SQL = "MigrationFromMySQLToAzureDBForMySQL"


class SqlSourcePlatform(str, Enum):
    """
    Server platform type for connection
    """
    SQL_ON_PREM = "SqlOnPrem"


class SsisMigrationOverwriteOption(str, Enum):
    """
    The overwrite option for the SSIS project migration
    """
    IGNORE = "Ignore"
    OVERWRITE = "Overwrite"


class SsisStoreType(str, Enum):
    """
    The SSIS store type of source, only SSIS catalog is supported now in DMS
    """
    SSIS_CATALOG = "SsisCatalog"


class TaskType(str, Enum):
    """
    Task type.
    """
    CONNECT_MONGO_DB = "Connect.MongoDb"
    CONNECT_TO_SOURCE_SQL_SERVER = "ConnectToSource.SqlServer"
    CONNECT_TO_SOURCE_SQL_SERVER_SYNC = "ConnectToSource.SqlServer.Sync"
    CONNECT_TO_SOURCE_POSTGRE_SQL_SYNC = "ConnectToSource.PostgreSql.Sync"
    CONNECT_TO_SOURCE_MY_SQL = "ConnectToSource.MySql"
    CONNECT_TO_SOURCE_ORACLE_SYNC = "ConnectToSource.Oracle.Sync"
    CONNECT_TO_TARGET_SQL_DB = "ConnectToTarget.SqlDb"
    CONNECT_TO_TARGET_SQL_DB_SYNC = "ConnectToTarget.SqlDb.Sync"
    CONNECT_TO_TARGET_AZURE_DB_FOR_POSTGRE_SQL_SYNC = "ConnectToTarget.AzureDbForPostgreSql.Sync"
    CONNECT_TO_TARGET_ORACLE_AZURE_DB_FOR_POSTGRE_SQL_SYNC = "ConnectToTarget.Oracle.AzureDbForPostgreSql.Sync"
    CONNECT_TO_TARGET_AZURE_SQL_DB_MI = "ConnectToTarget.AzureSqlDbMI"
    CONNECT_TO_TARGET_AZURE_SQL_DB_M_I_SYNC_LRS = "ConnectToTarget.AzureSqlDbMI.Sync.LRS"
    CONNECT_TO_TARGET_AZURE_DB_FOR_MY_SQL = "ConnectToTarget.AzureDbForMySql"
    GET_USER_TABLES_SQL = "GetUserTables.Sql"
    GET_USER_TABLES_AZURE_SQL_DB_SYNC = "GetUserTables.AzureSqlDb.Sync"
    GET_USER_TABLES_ORACLE = "GetUserTablesOracle"
    GET_USER_TABLES_POSTGRE_SQL = "GetUserTablesPostgreSql"
    GET_USER_TABLES_MY_SQL = "GetUserTablesMySql"
    MIGRATE_MONGO_DB = "Migrate.MongoDb"
    MIGRATE_SQL_SERVER_AZURE_SQL_DB_MI = "Migrate.SqlServer.AzureSqlDbMI"
    MIGRATE_SQL_SERVER_AZURE_SQL_DB_M_I_SYNC_LRS = "Migrate.SqlServer.AzureSqlDbMI.Sync.LRS"
    MIGRATE_SQL_SERVER_SQL_DB = "Migrate.SqlServer.SqlDb"
    MIGRATE_SQL_SERVER_AZURE_SQL_DB_SYNC = "Migrate.SqlServer.AzureSqlDb.Sync"
    MIGRATE_MY_SQL_AZURE_DB_FOR_MY_SQL_SYNC = "Migrate.MySql.AzureDbForMySql.Sync"
    MIGRATE_MY_SQL_AZURE_DB_FOR_MY_SQL = "Migrate.MySql.AzureDbForMySql"
    MIGRATE_POSTGRE_SQL_AZURE_DB_FOR_POSTGRE_SQL_SYNC_V2 = "Migrate.PostgreSql.AzureDbForPostgreSql.SyncV2"
    MIGRATE_ORACLE_AZURE_DB_FOR_POSTGRE_SQL_SYNC = "Migrate.Oracle.AzureDbForPostgreSql.Sync"
    VALIDATE_MIGRATION_INPUT_SQL_SERVER_SQL_DB_SYNC = "ValidateMigrationInput.SqlServer.SqlDb.Sync"
    VALIDATE_MIGRATION_INPUT_SQL_SERVER_AZURE_SQL_DB_MI = "ValidateMigrationInput.SqlServer.AzureSqlDbMI"
    VALIDATE_MIGRATION_INPUT_SQL_SERVER_AZURE_SQL_DB_M_I_SYNC_LRS = "ValidateMigrationInput.SqlServer.AzureSqlDbMI.Sync.LRS"
    VALIDATE_MONGO_DB = "Validate.MongoDb"
    VALIDATE_ORACLE_AZURE_DB_POSTGRE_SQL_SYNC = "Validate.Oracle.AzureDbPostgreSql.Sync"
    GET_TDE_CERTIFICATES_SQL = "GetTDECertificates.Sql"
    MIGRATE_SSIS = "Migrate.Ssis"
    SERVICE_CHECK_OCI = "Service.Check.OCI"
    SERVICE_UPLOAD_OCI = "Service.Upload.OCI"
    SERVICE_INSTALL_OCI = "Service.Install.OCI"
    MIGRATE_SCHEMA_SQL_SERVER_SQL_DB = "MigrateSchemaSqlServerSqlDb"
