# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'CommonExportPropertiesResponse',
    'ErrorDetailsResponse',
    'ExportDatasetConfigurationResponse',
    'ExportDatasetResponse',
    'ExportDefinitionResponse',
    'ExportDeliveryDestinationResponse',
    'ExportDeliveryInfoResponse',
    'ExportExecutionListResultResponse',
    'ExportExecutionResponse',
    'ExportRecurrencePeriodResponse',
    'ExportScheduleResponse',
    'ExportTimePeriodResponse',
    'KpiPropertiesResponse',
    'PivotPropertiesResponse',
    'ReportConfigAggregationResponse',
    'ReportConfigComparisonExpressionResponse',
    'ReportConfigDatasetConfigurationResponse',
    'ReportConfigDatasetResponse',
    'ReportConfigFilterResponse',
    'ReportConfigGroupingResponse',
    'ReportConfigSortingResponse',
    'ReportConfigTimePeriodResponse',
]

@pulumi.output_type
class CommonExportPropertiesResponse(dict):
    """
    The common properties of the export.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deliveryInfo":
            suggest = "delivery_info"
        elif key == "nextRunTimeEstimate":
            suggest = "next_run_time_estimate"
        elif key == "partitionData":
            suggest = "partition_data"
        elif key == "runHistory":
            suggest = "run_history"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CommonExportPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CommonExportPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CommonExportPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 definition: 'outputs.ExportDefinitionResponse',
                 delivery_info: 'outputs.ExportDeliveryInfoResponse',
                 next_run_time_estimate: str,
                 format: Optional[str] = None,
                 partition_data: Optional[bool] = None,
                 run_history: Optional['outputs.ExportExecutionListResultResponse'] = None):
        """
        The common properties of the export.
        :param 'ExportDefinitionResponse' definition: Has the definition for the export.
        :param 'ExportDeliveryInfoResponse' delivery_info: Has delivery information for the export.
        :param str next_run_time_estimate: If the export has an active schedule, provides an estimate of the next execution time.
        :param str format: The format of the export being delivered. Currently only 'Csv' is supported.
        :param bool partition_data: If set to true, exported data will be partitioned by size and placed in a blob directory together with a manifest file. Note: this option is currently available only for modern commerce scopes.
        :param 'ExportExecutionListResultResponse' run_history: If requested, has the most recent execution history for the export.
        """
        pulumi.set(__self__, "definition", definition)
        pulumi.set(__self__, "delivery_info", delivery_info)
        pulumi.set(__self__, "next_run_time_estimate", next_run_time_estimate)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if partition_data is not None:
            pulumi.set(__self__, "partition_data", partition_data)
        if run_history is not None:
            pulumi.set(__self__, "run_history", run_history)

    @property
    @pulumi.getter
    def definition(self) -> 'outputs.ExportDefinitionResponse':
        """
        Has the definition for the export.
        """
        return pulumi.get(self, "definition")

    @property
    @pulumi.getter(name="deliveryInfo")
    def delivery_info(self) -> 'outputs.ExportDeliveryInfoResponse':
        """
        Has delivery information for the export.
        """
        return pulumi.get(self, "delivery_info")

    @property
    @pulumi.getter(name="nextRunTimeEstimate")
    def next_run_time_estimate(self) -> str:
        """
        If the export has an active schedule, provides an estimate of the next execution time.
        """
        return pulumi.get(self, "next_run_time_estimate")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        The format of the export being delivered. Currently only 'Csv' is supported.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="partitionData")
    def partition_data(self) -> Optional[bool]:
        """
        If set to true, exported data will be partitioned by size and placed in a blob directory together with a manifest file. Note: this option is currently available only for modern commerce scopes.
        """
        return pulumi.get(self, "partition_data")

    @property
    @pulumi.getter(name="runHistory")
    def run_history(self) -> Optional['outputs.ExportExecutionListResultResponse']:
        """
        If requested, has the most recent execution history for the export.
        """
        return pulumi.get(self, "run_history")


@pulumi.output_type
class ErrorDetailsResponse(dict):
    """
    The details of the error.
    """
    def __init__(__self__, *,
                 code: str,
                 message: str):
        """
        The details of the error.
        :param str code: Error code.
        :param str message: Error message indicating why the operation failed.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        Error code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Error message indicating why the operation failed.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class ExportDatasetConfigurationResponse(dict):
    """
    The export dataset configuration. Allows columns to be selected for the export. If not provided then the export will include all available columns.
    """
    def __init__(__self__, *,
                 columns: Optional[Sequence[str]] = None):
        """
        The export dataset configuration. Allows columns to be selected for the export. If not provided then the export will include all available columns.
        :param Sequence[str] columns: Array of column names to be included in the export. If not provided then the export will include all available columns. The available columns can vary by customer channel (see examples).
        """
        if columns is not None:
            pulumi.set(__self__, "columns", columns)

    @property
    @pulumi.getter
    def columns(self) -> Optional[Sequence[str]]:
        """
        Array of column names to be included in the export. If not provided then the export will include all available columns. The available columns can vary by customer channel (see examples).
        """
        return pulumi.get(self, "columns")


@pulumi.output_type
class ExportDatasetResponse(dict):
    """
    The definition for data in the export.
    """
    def __init__(__self__, *,
                 configuration: Optional['outputs.ExportDatasetConfigurationResponse'] = None,
                 granularity: Optional[str] = None):
        """
        The definition for data in the export.
        :param 'ExportDatasetConfigurationResponse' configuration: The export dataset configuration.
        :param str granularity: The granularity of rows in the export. Currently only 'Daily' is supported.
        """
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if granularity is not None:
            pulumi.set(__self__, "granularity", granularity)

    @property
    @pulumi.getter
    def configuration(self) -> Optional['outputs.ExportDatasetConfigurationResponse']:
        """
        The export dataset configuration.
        """
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter
    def granularity(self) -> Optional[str]:
        """
        The granularity of rows in the export. Currently only 'Daily' is supported.
        """
        return pulumi.get(self, "granularity")


@pulumi.output_type
class ExportDefinitionResponse(dict):
    """
    The definition of an export.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataSet":
            suggest = "data_set"
        elif key == "timePeriod":
            suggest = "time_period"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExportDefinitionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExportDefinitionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExportDefinitionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 timeframe: str,
                 type: str,
                 data_set: Optional['outputs.ExportDatasetResponse'] = None,
                 time_period: Optional['outputs.ExportTimePeriodResponse'] = None):
        """
        The definition of an export.
        :param str timeframe: The time frame for pulling data for the export. If custom, then a specific time period must be provided.
        :param str type: The type of the export. Note that 'Usage' is equivalent to 'ActualCost' and is applicable to exports that do not yet provide data for charges or amortization for service reservations.
        :param 'ExportDatasetResponse' data_set: The definition for data in the export.
        :param 'ExportTimePeriodResponse' time_period: Has time period for pulling data for the export.
        """
        pulumi.set(__self__, "timeframe", timeframe)
        pulumi.set(__self__, "type", type)
        if data_set is not None:
            pulumi.set(__self__, "data_set", data_set)
        if time_period is not None:
            pulumi.set(__self__, "time_period", time_period)

    @property
    @pulumi.getter
    def timeframe(self) -> str:
        """
        The time frame for pulling data for the export. If custom, then a specific time period must be provided.
        """
        return pulumi.get(self, "timeframe")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the export. Note that 'Usage' is equivalent to 'ActualCost' and is applicable to exports that do not yet provide data for charges or amortization for service reservations.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="dataSet")
    def data_set(self) -> Optional['outputs.ExportDatasetResponse']:
        """
        The definition for data in the export.
        """
        return pulumi.get(self, "data_set")

    @property
    @pulumi.getter(name="timePeriod")
    def time_period(self) -> Optional['outputs.ExportTimePeriodResponse']:
        """
        Has time period for pulling data for the export.
        """
        return pulumi.get(self, "time_period")


@pulumi.output_type
class ExportDeliveryDestinationResponse(dict):
    """
    This represents the blob storage account location where exports of costs will be delivered. There are two ways to configure the destination. The approach recommended for most customers is to specify the resourceId of the storage account. This requires a one-time registration of the account's subscription with the Microsoft.CostManagementExports resource provider in order to give Azure Cost Management services access to the storage. When creating an export in the Azure portal this registration is performed automatically but API users may need to register the subscription explicitly (for more information see https://docs.microsoft.com/en-us/azure/azure-resource-manager/resource-manager-supported-services ). Another way to configure the destination is available ONLY to Partners with a Microsoft Partner Agreement plan who are global admins of their billing account. These Partners, instead of specifying the resourceId of a storage account, can specify the storage account name along with a SAS token for the account. This allows exports of costs to a storage account in any tenant. The SAS token should be created for the blob service with Service/Container/Object resource types and with Read/Write/Delete/List/Add/Create permissions (for more information see https://docs.microsoft.com/en-us/azure/cost-management-billing/costs/export-cost-data-storage-account-sas-key ).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceId":
            suggest = "resource_id"
        elif key == "rootFolderPath":
            suggest = "root_folder_path"
        elif key == "sasToken":
            suggest = "sas_token"
        elif key == "storageAccount":
            suggest = "storage_account"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExportDeliveryDestinationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExportDeliveryDestinationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExportDeliveryDestinationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container: str,
                 resource_id: Optional[str] = None,
                 root_folder_path: Optional[str] = None,
                 sas_token: Optional[str] = None,
                 storage_account: Optional[str] = None):
        """
        This represents the blob storage account location where exports of costs will be delivered. There are two ways to configure the destination. The approach recommended for most customers is to specify the resourceId of the storage account. This requires a one-time registration of the account's subscription with the Microsoft.CostManagementExports resource provider in order to give Azure Cost Management services access to the storage. When creating an export in the Azure portal this registration is performed automatically but API users may need to register the subscription explicitly (for more information see https://docs.microsoft.com/en-us/azure/azure-resource-manager/resource-manager-supported-services ). Another way to configure the destination is available ONLY to Partners with a Microsoft Partner Agreement plan who are global admins of their billing account. These Partners, instead of specifying the resourceId of a storage account, can specify the storage account name along with a SAS token for the account. This allows exports of costs to a storage account in any tenant. The SAS token should be created for the blob service with Service/Container/Object resource types and with Read/Write/Delete/List/Add/Create permissions (for more information see https://docs.microsoft.com/en-us/azure/cost-management-billing/costs/export-cost-data-storage-account-sas-key ).
        :param str container: The name of the container where exports will be uploaded. If the container does not exist it will be created.
        :param str resource_id: The resource id of the storage account where exports will be delivered. This is not required if a sasToken and storageAccount are specified.
        :param str root_folder_path: The name of the directory where exports will be uploaded.
        :param str sas_token: A SAS token for the storage account. For a restricted set of Azure customers this together with storageAccount can be specified instead of resourceId. Note: the value returned by the API for this property will always be obfuscated. Returning this same obfuscated value will not result in the SAS token being updated. To update this value a new SAS token must be specified.
        :param str storage_account: The storage account where exports will be uploaded. For a restricted set of Azure customers this together with sasToken can be specified instead of resourceId.
        """
        pulumi.set(__self__, "container", container)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if root_folder_path is not None:
            pulumi.set(__self__, "root_folder_path", root_folder_path)
        if sas_token is not None:
            pulumi.set(__self__, "sas_token", sas_token)
        if storage_account is not None:
            pulumi.set(__self__, "storage_account", storage_account)

    @property
    @pulumi.getter
    def container(self) -> str:
        """
        The name of the container where exports will be uploaded. If the container does not exist it will be created.
        """
        return pulumi.get(self, "container")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        The resource id of the storage account where exports will be delivered. This is not required if a sasToken and storageAccount are specified.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="rootFolderPath")
    def root_folder_path(self) -> Optional[str]:
        """
        The name of the directory where exports will be uploaded.
        """
        return pulumi.get(self, "root_folder_path")

    @property
    @pulumi.getter(name="sasToken")
    def sas_token(self) -> Optional[str]:
        """
        A SAS token for the storage account. For a restricted set of Azure customers this together with storageAccount can be specified instead of resourceId. Note: the value returned by the API for this property will always be obfuscated. Returning this same obfuscated value will not result in the SAS token being updated. To update this value a new SAS token must be specified.
        """
        return pulumi.get(self, "sas_token")

    @property
    @pulumi.getter(name="storageAccount")
    def storage_account(self) -> Optional[str]:
        """
        The storage account where exports will be uploaded. For a restricted set of Azure customers this together with sasToken can be specified instead of resourceId.
        """
        return pulumi.get(self, "storage_account")


@pulumi.output_type
class ExportDeliveryInfoResponse(dict):
    """
    The delivery information associated with a export.
    """
    def __init__(__self__, *,
                 destination: 'outputs.ExportDeliveryDestinationResponse'):
        """
        The delivery information associated with a export.
        :param 'ExportDeliveryDestinationResponse' destination: Has destination for the export being delivered.
        """
        pulumi.set(__self__, "destination", destination)

    @property
    @pulumi.getter
    def destination(self) -> 'outputs.ExportDeliveryDestinationResponse':
        """
        Has destination for the export being delivered.
        """
        return pulumi.get(self, "destination")


@pulumi.output_type
class ExportExecutionListResultResponse(dict):
    """
    Result of listing the execution history of an export.
    """
    def __init__(__self__, *,
                 value: Sequence['outputs.ExportExecutionResponse']):
        """
        Result of listing the execution history of an export.
        :param Sequence['ExportExecutionResponse'] value: A list of export executions.
        """
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def value(self) -> Sequence['outputs.ExportExecutionResponse']:
        """
        A list of export executions.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ExportExecutionResponse(dict):
    """
    An export execution.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eTag":
            suggest = "e_tag"
        elif key == "executionType":
            suggest = "execution_type"
        elif key == "fileName":
            suggest = "file_name"
        elif key == "processingEndTime":
            suggest = "processing_end_time"
        elif key == "processingStartTime":
            suggest = "processing_start_time"
        elif key == "runSettings":
            suggest = "run_settings"
        elif key == "submittedBy":
            suggest = "submitted_by"
        elif key == "submittedTime":
            suggest = "submitted_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExportExecutionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExportExecutionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExportExecutionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 name: str,
                 type: str,
                 e_tag: Optional[str] = None,
                 error: Optional['outputs.ErrorDetailsResponse'] = None,
                 execution_type: Optional[str] = None,
                 file_name: Optional[str] = None,
                 processing_end_time: Optional[str] = None,
                 processing_start_time: Optional[str] = None,
                 run_settings: Optional['outputs.CommonExportPropertiesResponse'] = None,
                 status: Optional[str] = None,
                 submitted_by: Optional[str] = None,
                 submitted_time: Optional[str] = None):
        """
        An export execution.
        :param str id: Resource Id.
        :param str name: Resource name.
        :param str type: Resource type.
        :param str e_tag: eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating the latest version or not.
        :param 'ErrorDetailsResponse' error: The details of any error.
        :param str execution_type: The type of the export execution.
        :param str file_name: The name of the exported file.
        :param str processing_end_time: The time when the export execution finished.
        :param str processing_start_time: The time when export was picked up to be executed.
        :param 'CommonExportPropertiesResponse' run_settings: The export settings that were in effect for this execution.
        :param str status: The last known status of the export execution.
        :param str submitted_by: The identifier for the entity that executed the export. For OnDemand executions it is the user email. For scheduled executions it is 'System'.
        :param str submitted_time: The time when export was queued to be executed.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if e_tag is not None:
            pulumi.set(__self__, "e_tag", e_tag)
        if error is not None:
            pulumi.set(__self__, "error", error)
        if execution_type is not None:
            pulumi.set(__self__, "execution_type", execution_type)
        if file_name is not None:
            pulumi.set(__self__, "file_name", file_name)
        if processing_end_time is not None:
            pulumi.set(__self__, "processing_end_time", processing_end_time)
        if processing_start_time is not None:
            pulumi.set(__self__, "processing_start_time", processing_start_time)
        if run_settings is not None:
            pulumi.set(__self__, "run_settings", run_settings)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if submitted_by is not None:
            pulumi.set(__self__, "submitted_by", submitted_by)
        if submitted_time is not None:
            pulumi.set(__self__, "submitted_time", submitted_time)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Resource Id.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="eTag")
    def e_tag(self) -> Optional[str]:
        """
        eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating the latest version or not.
        """
        return pulumi.get(self, "e_tag")

    @property
    @pulumi.getter
    def error(self) -> Optional['outputs.ErrorDetailsResponse']:
        """
        The details of any error.
        """
        return pulumi.get(self, "error")

    @property
    @pulumi.getter(name="executionType")
    def execution_type(self) -> Optional[str]:
        """
        The type of the export execution.
        """
        return pulumi.get(self, "execution_type")

    @property
    @pulumi.getter(name="fileName")
    def file_name(self) -> Optional[str]:
        """
        The name of the exported file.
        """
        return pulumi.get(self, "file_name")

    @property
    @pulumi.getter(name="processingEndTime")
    def processing_end_time(self) -> Optional[str]:
        """
        The time when the export execution finished.
        """
        return pulumi.get(self, "processing_end_time")

    @property
    @pulumi.getter(name="processingStartTime")
    def processing_start_time(self) -> Optional[str]:
        """
        The time when export was picked up to be executed.
        """
        return pulumi.get(self, "processing_start_time")

    @property
    @pulumi.getter(name="runSettings")
    def run_settings(self) -> Optional['outputs.CommonExportPropertiesResponse']:
        """
        The export settings that were in effect for this execution.
        """
        return pulumi.get(self, "run_settings")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The last known status of the export execution.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="submittedBy")
    def submitted_by(self) -> Optional[str]:
        """
        The identifier for the entity that executed the export. For OnDemand executions it is the user email. For scheduled executions it is 'System'.
        """
        return pulumi.get(self, "submitted_by")

    @property
    @pulumi.getter(name="submittedTime")
    def submitted_time(self) -> Optional[str]:
        """
        The time when export was queued to be executed.
        """
        return pulumi.get(self, "submitted_time")


@pulumi.output_type
class ExportRecurrencePeriodResponse(dict):
    """
    The start and end date for recurrence schedule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "from":
            suggest = "from_"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExportRecurrencePeriodResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExportRecurrencePeriodResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExportRecurrencePeriodResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 from_: str,
                 to: Optional[str] = None):
        """
        The start and end date for recurrence schedule.
        :param str from_: The start date of recurrence.
        :param str to: The end date of recurrence.
        """
        pulumi.set(__self__, "from_", from_)
        if to is not None:
            pulumi.set(__self__, "to", to)

    @property
    @pulumi.getter(name="from")
    def from_(self) -> str:
        """
        The start date of recurrence.
        """
        return pulumi.get(self, "from_")

    @property
    @pulumi.getter
    def to(self) -> Optional[str]:
        """
        The end date of recurrence.
        """
        return pulumi.get(self, "to")


@pulumi.output_type
class ExportScheduleResponse(dict):
    """
    The schedule associated with the export.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "recurrencePeriod":
            suggest = "recurrence_period"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExportScheduleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExportScheduleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExportScheduleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 recurrence: Optional[str] = None,
                 recurrence_period: Optional['outputs.ExportRecurrencePeriodResponse'] = None,
                 status: Optional[str] = None):
        """
        The schedule associated with the export.
        :param str recurrence: The schedule recurrence.
        :param 'ExportRecurrencePeriodResponse' recurrence_period: Has start and end date of the recurrence. The start date must be in future. If present, the end date must be greater than start date.
        :param str status: The status of the export's schedule. If 'Inactive', the export's schedule is paused.
        """
        if recurrence is not None:
            pulumi.set(__self__, "recurrence", recurrence)
        if recurrence_period is not None:
            pulumi.set(__self__, "recurrence_period", recurrence_period)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def recurrence(self) -> Optional[str]:
        """
        The schedule recurrence.
        """
        return pulumi.get(self, "recurrence")

    @property
    @pulumi.getter(name="recurrencePeriod")
    def recurrence_period(self) -> Optional['outputs.ExportRecurrencePeriodResponse']:
        """
        Has start and end date of the recurrence. The start date must be in future. If present, the end date must be greater than start date.
        """
        return pulumi.get(self, "recurrence_period")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The status of the export's schedule. If 'Inactive', the export's schedule is paused.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class ExportTimePeriodResponse(dict):
    """
    The date range for data in the export. This should only be specified with timeFrame set to 'Custom'. The maximum date range is 3 months.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "from":
            suggest = "from_"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExportTimePeriodResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExportTimePeriodResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExportTimePeriodResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 from_: str,
                 to: str):
        """
        The date range for data in the export. This should only be specified with timeFrame set to 'Custom'. The maximum date range is 3 months.
        :param str from_: The start date for export data.
        :param str to: The end date for export data.
        """
        pulumi.set(__self__, "from_", from_)
        pulumi.set(__self__, "to", to)

    @property
    @pulumi.getter(name="from")
    def from_(self) -> str:
        """
        The start date for export data.
        """
        return pulumi.get(self, "from_")

    @property
    @pulumi.getter
    def to(self) -> str:
        """
        The end date for export data.
        """
        return pulumi.get(self, "to")


@pulumi.output_type
class KpiPropertiesResponse(dict):
    """
    Each KPI must contain a 'type' and 'enabled' key.
    """
    def __init__(__self__, *,
                 enabled: Optional[bool] = None,
                 id: Optional[str] = None,
                 type: Optional[str] = None):
        """
        Each KPI must contain a 'type' and 'enabled' key.
        :param bool enabled: show the KPI in the UI?
        :param str id: ID of resource related to metric (budget).
        :param str type: KPI type (Forecast, Budget).
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        show the KPI in the UI?
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        ID of resource related to metric (budget).
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        KPI type (Forecast, Budget).
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class PivotPropertiesResponse(dict):
    """
    Each pivot must contain a 'type' and 'name'.
    """
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 type: Optional[str] = None):
        """
        Each pivot must contain a 'type' and 'name'.
        :param str name: Data field to show in view.
        :param str type: Data type to show in view.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Data field to show in view.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Data type to show in view.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ReportConfigAggregationResponse(dict):
    """
    The aggregation expression to be used in the report.
    """
    def __init__(__self__, *,
                 function: str,
                 name: str):
        """
        The aggregation expression to be used in the report.
        :param str function: The name of the aggregation function to use.
        :param str name: The name of the column to aggregate.
        """
        pulumi.set(__self__, "function", function)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def function(self) -> str:
        """
        The name of the aggregation function to use.
        """
        return pulumi.get(self, "function")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the column to aggregate.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ReportConfigComparisonExpressionResponse(dict):
    """
    The comparison expression to be used in the report.
    """
    def __init__(__self__, *,
                 name: str,
                 operator: str,
                 values: Sequence[str]):
        """
        The comparison expression to be used in the report.
        :param str name: The name of the column to use in comparison.
        :param str operator: The operator to use for comparison.
        :param Sequence[str] values: Array of values to use for comparison
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the column to use in comparison.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def operator(self) -> str:
        """
        The operator to use for comparison.
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        Array of values to use for comparison
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class ReportConfigDatasetConfigurationResponse(dict):
    """
    The configuration of dataset in the report.
    """
    def __init__(__self__, *,
                 columns: Optional[Sequence[str]] = None):
        """
        The configuration of dataset in the report.
        :param Sequence[str] columns: Array of column names to be included in the report. Any valid report column name is allowed. If not provided, then report includes all columns.
        """
        if columns is not None:
            pulumi.set(__self__, "columns", columns)

    @property
    @pulumi.getter
    def columns(self) -> Optional[Sequence[str]]:
        """
        Array of column names to be included in the report. Any valid report column name is allowed. If not provided, then report includes all columns.
        """
        return pulumi.get(self, "columns")


@pulumi.output_type
class ReportConfigDatasetResponse(dict):
    """
    The definition of data present in the report.
    """
    def __init__(__self__, *,
                 aggregation: Optional[Mapping[str, 'outputs.ReportConfigAggregationResponse']] = None,
                 configuration: Optional['outputs.ReportConfigDatasetConfigurationResponse'] = None,
                 filter: Optional['outputs.ReportConfigFilterResponse'] = None,
                 granularity: Optional[str] = None,
                 grouping: Optional[Sequence['outputs.ReportConfigGroupingResponse']] = None,
                 sorting: Optional[Sequence['outputs.ReportConfigSortingResponse']] = None):
        """
        The definition of data present in the report.
        :param Mapping[str, 'ReportConfigAggregationResponse'] aggregation: Dictionary of aggregation expression to use in the report. The key of each item in the dictionary is the alias for the aggregated column. Report can have up to 2 aggregation clauses.
        :param 'ReportConfigDatasetConfigurationResponse' configuration: Has configuration information for the data in the report. The configuration will be ignored if aggregation and grouping are provided.
        :param 'ReportConfigFilterResponse' filter: Has filter expression to use in the report.
        :param str granularity: The granularity of rows in the report.
        :param Sequence['ReportConfigGroupingResponse'] grouping: Array of group by expression to use in the report. Report can have up to 2 group by clauses.
        :param Sequence['ReportConfigSortingResponse'] sorting: Array of order by expression to use in the report.
        """
        if aggregation is not None:
            pulumi.set(__self__, "aggregation", aggregation)
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if granularity is not None:
            pulumi.set(__self__, "granularity", granularity)
        if grouping is not None:
            pulumi.set(__self__, "grouping", grouping)
        if sorting is not None:
            pulumi.set(__self__, "sorting", sorting)

    @property
    @pulumi.getter
    def aggregation(self) -> Optional[Mapping[str, 'outputs.ReportConfigAggregationResponse']]:
        """
        Dictionary of aggregation expression to use in the report. The key of each item in the dictionary is the alias for the aggregated column. Report can have up to 2 aggregation clauses.
        """
        return pulumi.get(self, "aggregation")

    @property
    @pulumi.getter
    def configuration(self) -> Optional['outputs.ReportConfigDatasetConfigurationResponse']:
        """
        Has configuration information for the data in the report. The configuration will be ignored if aggregation and grouping are provided.
        """
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter
    def filter(self) -> Optional['outputs.ReportConfigFilterResponse']:
        """
        Has filter expression to use in the report.
        """
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter
    def granularity(self) -> Optional[str]:
        """
        The granularity of rows in the report.
        """
        return pulumi.get(self, "granularity")

    @property
    @pulumi.getter
    def grouping(self) -> Optional[Sequence['outputs.ReportConfigGroupingResponse']]:
        """
        Array of group by expression to use in the report. Report can have up to 2 group by clauses.
        """
        return pulumi.get(self, "grouping")

    @property
    @pulumi.getter
    def sorting(self) -> Optional[Sequence['outputs.ReportConfigSortingResponse']]:
        """
        Array of order by expression to use in the report.
        """
        return pulumi.get(self, "sorting")


@pulumi.output_type
class ReportConfigFilterResponse(dict):
    """
    The filter expression to be used in the report.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "and":
            suggest = "and_"
        elif key == "or":
            suggest = "or_"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReportConfigFilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReportConfigFilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReportConfigFilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 and_: Optional[Sequence['outputs.ReportConfigFilterResponse']] = None,
                 dimensions: Optional['outputs.ReportConfigComparisonExpressionResponse'] = None,
                 or_: Optional[Sequence['outputs.ReportConfigFilterResponse']] = None,
                 tags: Optional['outputs.ReportConfigComparisonExpressionResponse'] = None):
        """
        The filter expression to be used in the report.
        :param Sequence['ReportConfigFilterResponse'] and_: The logical "AND" expression. Must have at least 2 items.
        :param 'ReportConfigComparisonExpressionResponse' dimensions: Has comparison expression for a dimension
        :param Sequence['ReportConfigFilterResponse'] or_: The logical "OR" expression. Must have at least 2 items.
        :param 'ReportConfigComparisonExpressionResponse' tags: Has comparison expression for a tag
        """
        if and_ is not None:
            pulumi.set(__self__, "and_", and_)
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if or_ is not None:
            pulumi.set(__self__, "or_", or_)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="and")
    def and_(self) -> Optional[Sequence['outputs.ReportConfigFilterResponse']]:
        """
        The logical "AND" expression. Must have at least 2 items.
        """
        return pulumi.get(self, "and_")

    @property
    @pulumi.getter
    def dimensions(self) -> Optional['outputs.ReportConfigComparisonExpressionResponse']:
        """
        Has comparison expression for a dimension
        """
        return pulumi.get(self, "dimensions")

    @property
    @pulumi.getter(name="or")
    def or_(self) -> Optional[Sequence['outputs.ReportConfigFilterResponse']]:
        """
        The logical "OR" expression. Must have at least 2 items.
        """
        return pulumi.get(self, "or_")

    @property
    @pulumi.getter
    def tags(self) -> Optional['outputs.ReportConfigComparisonExpressionResponse']:
        """
        Has comparison expression for a tag
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class ReportConfigGroupingResponse(dict):
    """
    The group by expression to be used in the report.
    """
    def __init__(__self__, *,
                 name: str,
                 type: str):
        """
        The group by expression to be used in the report.
        :param str name: The name of the column to group. This version supports subscription lowest possible grain.
        :param str type: Has type of the column to group.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the column to group. This version supports subscription lowest possible grain.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Has type of the column to group.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ReportConfigSortingResponse(dict):
    """
    The order by expression to be used in the report.
    """
    def __init__(__self__, *,
                 name: str,
                 direction: Optional[str] = None):
        """
        The order by expression to be used in the report.
        :param str name: The name of the column to sort.
        :param str direction: Direction of sort.
        """
        pulumi.set(__self__, "name", name)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the column to sort.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def direction(self) -> Optional[str]:
        """
        Direction of sort.
        """
        return pulumi.get(self, "direction")


@pulumi.output_type
class ReportConfigTimePeriodResponse(dict):
    """
    The start and end date for pulling data for the report.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "from":
            suggest = "from_"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReportConfigTimePeriodResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReportConfigTimePeriodResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReportConfigTimePeriodResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 from_: str,
                 to: str):
        """
        The start and end date for pulling data for the report.
        :param str from_: The start date to pull data from.
        :param str to: The end date to pull data to.
        """
        pulumi.set(__self__, "from_", from_)
        pulumi.set(__self__, "to", to)

    @property
    @pulumi.getter(name="from")
    def from_(self) -> str:
        """
        The start date to pull data from.
        """
        return pulumi.get(self, "from_")

    @property
    @pulumi.getter
    def to(self) -> str:
        """
        The end date to pull data to.
        """
        return pulumi.get(self, "to")


