# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AdditionalLocationResponse',
    'ApiManagementServiceIdentityResponse',
    'ApiManagementServiceSkuPropertiesResponse',
    'ApiVersionSetContractResponse',
    'AuthenticationSettingsContractResponse',
    'BackendAuthorizationHeaderCredentialsResponse',
    'BackendCredentialsContractResponse',
    'BackendPropertiesResponse',
    'BackendProxyContractResponse',
    'BackendServiceFabricClusterPropertiesResponse',
    'BackendTlsPropertiesResponse',
    'CertificateConfigurationResponse',
    'CertificateInformationResponse',
    'EmailTemplateParametersContractPropertiesResponse',
    'GroupContractResponse',
    'HostnameConfigurationResponse',
    'LoggerSamplingContractResponse',
    'OAuth2AuthenticationSettingsContractResponse',
    'ParameterContractResponse',
    'RepresentationContractResponse',
    'RequestContractResponse',
    'ResponseContractResponse',
    'SubscriptionKeyParameterNamesContractResponse',
    'TokenBodyParameterContractResponse',
    'UserIdentityContractResponse',
    'VirtualNetworkConfigurationResponse',
    'X509CertificateNameResponse',
]

@pulumi.output_type
class AdditionalLocationResponse(dict):
    """
    Description of an additional API Management resource location.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gatewayRegionalUrl":
            suggest = "gateway_regional_url"
        elif key == "staticIps":
            suggest = "static_ips"
        elif key == "virtualNetworkConfiguration":
            suggest = "virtual_network_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AdditionalLocationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AdditionalLocationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AdditionalLocationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 gateway_regional_url: str,
                 location: str,
                 sku: 'outputs.ApiManagementServiceSkuPropertiesResponse',
                 static_ips: Sequence[str],
                 virtual_network_configuration: Optional['outputs.VirtualNetworkConfigurationResponse'] = None):
        """
        Description of an additional API Management resource location.
        :param str gateway_regional_url: Gateway URL of the API Management service in the Region.
        :param str location: The location name of the additional region among Azure Data center regions.
        :param 'ApiManagementServiceSkuPropertiesResponse' sku: SKU properties of the API Management service.
        :param Sequence[str] static_ips: Static IP addresses of the location's virtual machines.
        :param 'VirtualNetworkConfigurationResponse' virtual_network_configuration: Virtual network configuration for the location.
        """
        pulumi.set(__self__, "gateway_regional_url", gateway_regional_url)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "sku", sku)
        pulumi.set(__self__, "static_ips", static_ips)
        if virtual_network_configuration is not None:
            pulumi.set(__self__, "virtual_network_configuration", virtual_network_configuration)

    @property
    @pulumi.getter(name="gatewayRegionalUrl")
    def gateway_regional_url(self) -> str:
        """
        Gateway URL of the API Management service in the Region.
        """
        return pulumi.get(self, "gateway_regional_url")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        The location name of the additional region among Azure Data center regions.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def sku(self) -> 'outputs.ApiManagementServiceSkuPropertiesResponse':
        """
        SKU properties of the API Management service.
        """
        return pulumi.get(self, "sku")

    @property
    @pulumi.getter(name="staticIps")
    def static_ips(self) -> Sequence[str]:
        """
        Static IP addresses of the location's virtual machines.
        """
        return pulumi.get(self, "static_ips")

    @property
    @pulumi.getter(name="virtualNetworkConfiguration")
    def virtual_network_configuration(self) -> Optional['outputs.VirtualNetworkConfigurationResponse']:
        """
        Virtual network configuration for the location.
        """
        return pulumi.get(self, "virtual_network_configuration")


@pulumi.output_type
class ApiManagementServiceIdentityResponse(dict):
    """
    Identity properties of the Api Management service resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiManagementServiceIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiManagementServiceIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiManagementServiceIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: str,
                 tenant_id: str,
                 type: str):
        """
        Identity properties of the Api Management service resource.
        :param str principal_id: The principal id of the identity.
        :param str tenant_id: The client tenant id of the identity.
        :param str type: The identity type. Currently the only supported type is 'SystemAssigned'.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal id of the identity.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The client tenant id of the identity.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The identity type. Currently the only supported type is 'SystemAssigned'.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ApiManagementServiceSkuPropertiesResponse(dict):
    """
    API Management service resource SKU properties.
    """
    def __init__(__self__, *,
                 name: str,
                 capacity: Optional[int] = None):
        """
        API Management service resource SKU properties.
        :param str name: Name of the Sku.
        :param int capacity: Capacity of the SKU (number of deployed units of the SKU). The default value is 1.
        """
        pulumi.set(__self__, "name", name)
        if capacity is None:
            capacity = 1
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the Sku.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def capacity(self) -> Optional[int]:
        """
        Capacity of the SKU (number of deployed units of the SKU). The default value is 1.
        """
        return pulumi.get(self, "capacity")


@pulumi.output_type
class ApiVersionSetContractResponse(dict):
    """
    Api Version Set Contract details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"
        elif key == "versioningScheme":
            suggest = "versioning_scheme"
        elif key == "versionHeaderName":
            suggest = "version_header_name"
        elif key == "versionQueryName":
            suggest = "version_query_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiVersionSetContractResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiVersionSetContractResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiVersionSetContractResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 display_name: str,
                 id: str,
                 name: str,
                 type: str,
                 versioning_scheme: str,
                 description: Optional[str] = None,
                 version_header_name: Optional[str] = None,
                 version_query_name: Optional[str] = None):
        """
        Api Version Set Contract details.
        :param str display_name: Name of API Version Set
        :param str id: Resource ID.
        :param str name: Resource name.
        :param str type: Resource type for API Management resource.
        :param str versioning_scheme: An value that determines where the API Version identifier will be located in a HTTP request.
        :param str description: Description of API Version Set.
        :param str version_header_name: Name of HTTP header parameter that indicates the API Version if versioningScheme is set to `header`.
        :param str version_query_name: Name of query parameter that indicates the API Version if versioningScheme is set to `query`.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "versioning_scheme", versioning_scheme)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if version_header_name is not None:
            pulumi.set(__self__, "version_header_name", version_header_name)
        if version_query_name is not None:
            pulumi.set(__self__, "version_query_name", version_query_name)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Name of API Version Set
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type for API Management resource.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="versioningScheme")
    def versioning_scheme(self) -> str:
        """
        An value that determines where the API Version identifier will be located in a HTTP request.
        """
        return pulumi.get(self, "versioning_scheme")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of API Version Set.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="versionHeaderName")
    def version_header_name(self) -> Optional[str]:
        """
        Name of HTTP header parameter that indicates the API Version if versioningScheme is set to `header`.
        """
        return pulumi.get(self, "version_header_name")

    @property
    @pulumi.getter(name="versionQueryName")
    def version_query_name(self) -> Optional[str]:
        """
        Name of query parameter that indicates the API Version if versioningScheme is set to `query`.
        """
        return pulumi.get(self, "version_query_name")


@pulumi.output_type
class AuthenticationSettingsContractResponse(dict):
    """
    API Authentication Settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "oAuth2":
            suggest = "o_auth2"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthenticationSettingsContractResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthenticationSettingsContractResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthenticationSettingsContractResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 o_auth2: Optional['outputs.OAuth2AuthenticationSettingsContractResponse'] = None):
        """
        API Authentication Settings.
        :param 'OAuth2AuthenticationSettingsContractResponse' o_auth2: OAuth2 Authentication settings
        """
        if o_auth2 is not None:
            pulumi.set(__self__, "o_auth2", o_auth2)

    @property
    @pulumi.getter(name="oAuth2")
    def o_auth2(self) -> Optional['outputs.OAuth2AuthenticationSettingsContractResponse']:
        """
        OAuth2 Authentication settings
        """
        return pulumi.get(self, "o_auth2")


@pulumi.output_type
class BackendAuthorizationHeaderCredentialsResponse(dict):
    """
    Authorization header information.
    """
    def __init__(__self__, *,
                 parameter: str,
                 scheme: str):
        """
        Authorization header information.
        :param str parameter: Authentication Parameter value.
        :param str scheme: Authentication Scheme name.
        """
        pulumi.set(__self__, "parameter", parameter)
        pulumi.set(__self__, "scheme", scheme)

    @property
    @pulumi.getter
    def parameter(self) -> str:
        """
        Authentication Parameter value.
        """
        return pulumi.get(self, "parameter")

    @property
    @pulumi.getter
    def scheme(self) -> str:
        """
        Authentication Scheme name.
        """
        return pulumi.get(self, "scheme")


@pulumi.output_type
class BackendCredentialsContractResponse(dict):
    """
    Details of the Credentials used to connect to Backend.
    """
    def __init__(__self__, *,
                 authorization: Optional['outputs.BackendAuthorizationHeaderCredentialsResponse'] = None,
                 certificate: Optional[Sequence[str]] = None,
                 header: Optional[Mapping[str, Sequence[str]]] = None,
                 query: Optional[Mapping[str, Sequence[str]]] = None):
        """
        Details of the Credentials used to connect to Backend.
        :param 'BackendAuthorizationHeaderCredentialsResponse' authorization: Authorization header authentication
        :param Sequence[str] certificate: List of Client Certificate Thumbprint.
        :param Mapping[str, Sequence[str]] header: Header Parameter description.
        :param Mapping[str, Sequence[str]] query: Query Parameter description.
        """
        if authorization is not None:
            pulumi.set(__self__, "authorization", authorization)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if header is not None:
            pulumi.set(__self__, "header", header)
        if query is not None:
            pulumi.set(__self__, "query", query)

    @property
    @pulumi.getter
    def authorization(self) -> Optional['outputs.BackendAuthorizationHeaderCredentialsResponse']:
        """
        Authorization header authentication
        """
        return pulumi.get(self, "authorization")

    @property
    @pulumi.getter
    def certificate(self) -> Optional[Sequence[str]]:
        """
        List of Client Certificate Thumbprint.
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter
    def header(self) -> Optional[Mapping[str, Sequence[str]]]:
        """
        Header Parameter description.
        """
        return pulumi.get(self, "header")

    @property
    @pulumi.getter
    def query(self) -> Optional[Mapping[str, Sequence[str]]]:
        """
        Query Parameter description.
        """
        return pulumi.get(self, "query")


@pulumi.output_type
class BackendPropertiesResponse(dict):
    """
    Properties specific to the Backend Type.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serviceFabricCluster":
            suggest = "service_fabric_cluster"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackendPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackendPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackendPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 service_fabric_cluster: Optional['outputs.BackendServiceFabricClusterPropertiesResponse'] = None):
        """
        Properties specific to the Backend Type.
        :param 'BackendServiceFabricClusterPropertiesResponse' service_fabric_cluster: Backend Service Fabric Cluster Properties
        """
        if service_fabric_cluster is not None:
            pulumi.set(__self__, "service_fabric_cluster", service_fabric_cluster)

    @property
    @pulumi.getter(name="serviceFabricCluster")
    def service_fabric_cluster(self) -> Optional['outputs.BackendServiceFabricClusterPropertiesResponse']:
        """
        Backend Service Fabric Cluster Properties
        """
        return pulumi.get(self, "service_fabric_cluster")


@pulumi.output_type
class BackendProxyContractResponse(dict):
    """
    Details of the Backend WebProxy Server to use in the Request to Backend.
    """
    def __init__(__self__, *,
                 url: str,
                 password: Optional[str] = None,
                 username: Optional[str] = None):
        """
        Details of the Backend WebProxy Server to use in the Request to Backend.
        :param str url: WebProxy Server AbsoluteUri property which includes the entire URI stored in the Uri instance, including all fragments and query strings.
        :param str password: Password to connect to the WebProxy Server
        :param str username: Username to connect to the WebProxy server
        """
        pulumi.set(__self__, "url", url)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        WebProxy Server AbsoluteUri property which includes the entire URI stored in the Uri instance, including all fragments and query strings.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        Password to connect to the WebProxy Server
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        Username to connect to the WebProxy server
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class BackendServiceFabricClusterPropertiesResponse(dict):
    """
    Properties of the Service Fabric Type Backend.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientCertificatethumbprint":
            suggest = "client_certificatethumbprint"
        elif key == "managementEndpoints":
            suggest = "management_endpoints"
        elif key == "maxPartitionResolutionRetries":
            suggest = "max_partition_resolution_retries"
        elif key == "serverCertificateThumbprints":
            suggest = "server_certificate_thumbprints"
        elif key == "serverX509Names":
            suggest = "server_x509_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackendServiceFabricClusterPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackendServiceFabricClusterPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackendServiceFabricClusterPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_certificatethumbprint: str,
                 management_endpoints: Sequence[str],
                 max_partition_resolution_retries: Optional[int] = None,
                 server_certificate_thumbprints: Optional[Sequence[str]] = None,
                 server_x509_names: Optional[Sequence['outputs.X509CertificateNameResponse']] = None):
        """
        Properties of the Service Fabric Type Backend.
        :param str client_certificatethumbprint: The client certificate thumbprint for the management endpoint.
        :param Sequence[str] management_endpoints: The cluster management endpoint.
        :param int max_partition_resolution_retries: Maximum number of retries while attempting resolve the partition.
        :param Sequence[str] server_certificate_thumbprints: Thumbprints of certificates cluster management service uses for tls communication
        :param Sequence['X509CertificateNameResponse'] server_x509_names: Server X509 Certificate Names Collection
        """
        pulumi.set(__self__, "client_certificatethumbprint", client_certificatethumbprint)
        pulumi.set(__self__, "management_endpoints", management_endpoints)
        if max_partition_resolution_retries is not None:
            pulumi.set(__self__, "max_partition_resolution_retries", max_partition_resolution_retries)
        if server_certificate_thumbprints is not None:
            pulumi.set(__self__, "server_certificate_thumbprints", server_certificate_thumbprints)
        if server_x509_names is not None:
            pulumi.set(__self__, "server_x509_names", server_x509_names)

    @property
    @pulumi.getter(name="clientCertificatethumbprint")
    def client_certificatethumbprint(self) -> str:
        """
        The client certificate thumbprint for the management endpoint.
        """
        return pulumi.get(self, "client_certificatethumbprint")

    @property
    @pulumi.getter(name="managementEndpoints")
    def management_endpoints(self) -> Sequence[str]:
        """
        The cluster management endpoint.
        """
        return pulumi.get(self, "management_endpoints")

    @property
    @pulumi.getter(name="maxPartitionResolutionRetries")
    def max_partition_resolution_retries(self) -> Optional[int]:
        """
        Maximum number of retries while attempting resolve the partition.
        """
        return pulumi.get(self, "max_partition_resolution_retries")

    @property
    @pulumi.getter(name="serverCertificateThumbprints")
    def server_certificate_thumbprints(self) -> Optional[Sequence[str]]:
        """
        Thumbprints of certificates cluster management service uses for tls communication
        """
        return pulumi.get(self, "server_certificate_thumbprints")

    @property
    @pulumi.getter(name="serverX509Names")
    def server_x509_names(self) -> Optional[Sequence['outputs.X509CertificateNameResponse']]:
        """
        Server X509 Certificate Names Collection
        """
        return pulumi.get(self, "server_x509_names")


@pulumi.output_type
class BackendTlsPropertiesResponse(dict):
    """
    Properties controlling TLS Certificate Validation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "validateCertificateChain":
            suggest = "validate_certificate_chain"
        elif key == "validateCertificateName":
            suggest = "validate_certificate_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackendTlsPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackendTlsPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackendTlsPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 validate_certificate_chain: Optional[bool] = None,
                 validate_certificate_name: Optional[bool] = None):
        """
        Properties controlling TLS Certificate Validation.
        :param bool validate_certificate_chain: Flag indicating whether SSL certificate chain validation should be done when using self-signed certificates for this backend host.
        :param bool validate_certificate_name: Flag indicating whether SSL certificate name validation should be done when using self-signed certificates for this backend host.
        """
        if validate_certificate_chain is None:
            validate_certificate_chain = True
        if validate_certificate_chain is not None:
            pulumi.set(__self__, "validate_certificate_chain", validate_certificate_chain)
        if validate_certificate_name is None:
            validate_certificate_name = True
        if validate_certificate_name is not None:
            pulumi.set(__self__, "validate_certificate_name", validate_certificate_name)

    @property
    @pulumi.getter(name="validateCertificateChain")
    def validate_certificate_chain(self) -> Optional[bool]:
        """
        Flag indicating whether SSL certificate chain validation should be done when using self-signed certificates for this backend host.
        """
        return pulumi.get(self, "validate_certificate_chain")

    @property
    @pulumi.getter(name="validateCertificateName")
    def validate_certificate_name(self) -> Optional[bool]:
        """
        Flag indicating whether SSL certificate name validation should be done when using self-signed certificates for this backend host.
        """
        return pulumi.get(self, "validate_certificate_name")


@pulumi.output_type
class CertificateConfigurationResponse(dict):
    """
    Certificate configuration which consist of non-trusted intermediates and root certificates.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storeName":
            suggest = "store_name"
        elif key == "certificatePassword":
            suggest = "certificate_password"
        elif key == "encodedCertificate":
            suggest = "encoded_certificate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate: 'outputs.CertificateInformationResponse',
                 store_name: str,
                 certificate_password: Optional[str] = None,
                 encoded_certificate: Optional[str] = None):
        """
        Certificate configuration which consist of non-trusted intermediates and root certificates.
        :param 'CertificateInformationResponse' certificate: Certificate information.
        :param str store_name: The local certificate store location. Only Root and CertificateAuthority are valid locations.
        :param str certificate_password: Certificate Password.
        :param str encoded_certificate: Base64 Encoded certificate.
        """
        pulumi.set(__self__, "certificate", certificate)
        pulumi.set(__self__, "store_name", store_name)
        if certificate_password is not None:
            pulumi.set(__self__, "certificate_password", certificate_password)
        if encoded_certificate is not None:
            pulumi.set(__self__, "encoded_certificate", encoded_certificate)

    @property
    @pulumi.getter
    def certificate(self) -> 'outputs.CertificateInformationResponse':
        """
        Certificate information.
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter(name="storeName")
    def store_name(self) -> str:
        """
        The local certificate store location. Only Root and CertificateAuthority are valid locations.
        """
        return pulumi.get(self, "store_name")

    @property
    @pulumi.getter(name="certificatePassword")
    def certificate_password(self) -> Optional[str]:
        """
        Certificate Password.
        """
        return pulumi.get(self, "certificate_password")

    @property
    @pulumi.getter(name="encodedCertificate")
    def encoded_certificate(self) -> Optional[str]:
        """
        Base64 Encoded certificate.
        """
        return pulumi.get(self, "encoded_certificate")


@pulumi.output_type
class CertificateInformationResponse(dict):
    """
    SSL certificate information.
    """
    def __init__(__self__, *,
                 expiry: str,
                 subject: str,
                 thumbprint: str):
        """
        SSL certificate information.
        :param str expiry: Expiration date of the certificate. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
        :param str subject: Subject of the certificate.
        :param str thumbprint: Thumbprint of the certificate.
        """
        pulumi.set(__self__, "expiry", expiry)
        pulumi.set(__self__, "subject", subject)
        pulumi.set(__self__, "thumbprint", thumbprint)

    @property
    @pulumi.getter
    def expiry(self) -> str:
        """
        Expiration date of the certificate. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
        """
        return pulumi.get(self, "expiry")

    @property
    @pulumi.getter
    def subject(self) -> str:
        """
        Subject of the certificate.
        """
        return pulumi.get(self, "subject")

    @property
    @pulumi.getter
    def thumbprint(self) -> str:
        """
        Thumbprint of the certificate.
        """
        return pulumi.get(self, "thumbprint")


@pulumi.output_type
class EmailTemplateParametersContractPropertiesResponse(dict):
    """
    Email Template Parameter contract.
    """
    def __init__(__self__, *,
                 description: Optional[str] = None,
                 name: Optional[str] = None,
                 title: Optional[str] = None):
        """
        Email Template Parameter contract.
        :param str description: Template parameter description.
        :param str name: Template parameter name.
        :param str title: Template parameter title.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Template parameter description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Template parameter name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def title(self) -> Optional[str]:
        """
        Template parameter title.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class GroupContractResponse(dict):
    """
    Contract details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "builtIn":
            suggest = "built_in"
        elif key == "displayName":
            suggest = "display_name"
        elif key == "externalId":
            suggest = "external_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GroupContractResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GroupContractResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GroupContractResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 built_in: bool,
                 display_name: str,
                 id: str,
                 name: str,
                 type: str,
                 description: Optional[str] = None,
                 external_id: Optional[str] = None):
        """
        Contract details.
        :param bool built_in: true if the group is one of the three system groups (Administrators, Developers, or Guests); otherwise false.
        :param str display_name: Group name.
        :param str id: Resource ID.
        :param str name: Resource name.
        :param str type: Resource type for API Management resource.
        :param str description: Group description. Can contain HTML formatting tags.
        :param str external_id: For external groups, this property contains the id of the group from the external identity provider, e.g. for Azure Active Directory aad://<tenant>.onmicrosoft.com/groups/<group object id>; otherwise the value is null.
        """
        pulumi.set(__self__, "built_in", built_in)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)

    @property
    @pulumi.getter(name="builtIn")
    def built_in(self) -> bool:
        """
        true if the group is one of the three system groups (Administrators, Developers, or Guests); otherwise false.
        """
        return pulumi.get(self, "built_in")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Group name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type for API Management resource.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Group description. Can contain HTML formatting tags.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[str]:
        """
        For external groups, this property contains the id of the group from the external identity provider, e.g. for Azure Active Directory aad://<tenant>.onmicrosoft.com/groups/<group object id>; otherwise the value is null.
        """
        return pulumi.get(self, "external_id")


@pulumi.output_type
class HostnameConfigurationResponse(dict):
    """
    Custom hostname configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostName":
            suggest = "host_name"
        elif key == "certificatePassword":
            suggest = "certificate_password"
        elif key == "defaultSslBinding":
            suggest = "default_ssl_binding"
        elif key == "encodedCertificate":
            suggest = "encoded_certificate"
        elif key == "keyVaultId":
            suggest = "key_vault_id"
        elif key == "negotiateClientCertificate":
            suggest = "negotiate_client_certificate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HostnameConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HostnameConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HostnameConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate: 'outputs.CertificateInformationResponse',
                 host_name: str,
                 type: str,
                 certificate_password: Optional[str] = None,
                 default_ssl_binding: Optional[bool] = None,
                 encoded_certificate: Optional[str] = None,
                 key_vault_id: Optional[str] = None,
                 negotiate_client_certificate: Optional[bool] = None):
        """
        Custom hostname configuration.
        :param 'CertificateInformationResponse' certificate: Certificate information.
        :param str host_name: Hostname to configure on the Api Management service.
        :param str type: Hostname type.
        :param str certificate_password: Certificate Password.
        :param bool default_ssl_binding: Specify true to setup the certificate associated with this Hostname as the Default SSL Certificate. If a client does not send the SNI header, then this will be the certificate that will be challenged. The property is useful if a service has multiple custom hostname enabled and it needs to decide on the default ssl certificate. The setting only applied to Proxy Hostname Type.
        :param str encoded_certificate: Base64 Encoded certificate.
        :param str key_vault_id: Url to the KeyVault Secret containing the Ssl Certificate. If absolute Url containing version is provided, auto-update of ssl certificate will not work. This requires Api Management service to be configured with MSI. The secret should be of type *application/x-pkcs12*
        :param bool negotiate_client_certificate: Specify true to always negotiate client certificate on the hostname. Default Value is false.
        """
        pulumi.set(__self__, "certificate", certificate)
        pulumi.set(__self__, "host_name", host_name)
        pulumi.set(__self__, "type", type)
        if certificate_password is not None:
            pulumi.set(__self__, "certificate_password", certificate_password)
        if default_ssl_binding is None:
            default_ssl_binding = False
        if default_ssl_binding is not None:
            pulumi.set(__self__, "default_ssl_binding", default_ssl_binding)
        if encoded_certificate is not None:
            pulumi.set(__self__, "encoded_certificate", encoded_certificate)
        if key_vault_id is not None:
            pulumi.set(__self__, "key_vault_id", key_vault_id)
        if negotiate_client_certificate is None:
            negotiate_client_certificate = False
        if negotiate_client_certificate is not None:
            pulumi.set(__self__, "negotiate_client_certificate", negotiate_client_certificate)

    @property
    @pulumi.getter
    def certificate(self) -> 'outputs.CertificateInformationResponse':
        """
        Certificate information.
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> str:
        """
        Hostname to configure on the Api Management service.
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Hostname type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="certificatePassword")
    def certificate_password(self) -> Optional[str]:
        """
        Certificate Password.
        """
        return pulumi.get(self, "certificate_password")

    @property
    @pulumi.getter(name="defaultSslBinding")
    def default_ssl_binding(self) -> Optional[bool]:
        """
        Specify true to setup the certificate associated with this Hostname as the Default SSL Certificate. If a client does not send the SNI header, then this will be the certificate that will be challenged. The property is useful if a service has multiple custom hostname enabled and it needs to decide on the default ssl certificate. The setting only applied to Proxy Hostname Type.
        """
        return pulumi.get(self, "default_ssl_binding")

    @property
    @pulumi.getter(name="encodedCertificate")
    def encoded_certificate(self) -> Optional[str]:
        """
        Base64 Encoded certificate.
        """
        return pulumi.get(self, "encoded_certificate")

    @property
    @pulumi.getter(name="keyVaultId")
    def key_vault_id(self) -> Optional[str]:
        """
        Url to the KeyVault Secret containing the Ssl Certificate. If absolute Url containing version is provided, auto-update of ssl certificate will not work. This requires Api Management service to be configured with MSI. The secret should be of type *application/x-pkcs12*
        """
        return pulumi.get(self, "key_vault_id")

    @property
    @pulumi.getter(name="negotiateClientCertificate")
    def negotiate_client_certificate(self) -> Optional[bool]:
        """
        Specify true to always negotiate client certificate on the hostname. Default Value is false.
        """
        return pulumi.get(self, "negotiate_client_certificate")


@pulumi.output_type
class LoggerSamplingContractResponse(dict):
    """
    Sampling settings contract.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "evaluationInterval":
            suggest = "evaluation_interval"
        elif key == "initialPercentage":
            suggest = "initial_percentage"
        elif key == "maxPercentage":
            suggest = "max_percentage"
        elif key == "maxTelemetryItemsPerSecond":
            suggest = "max_telemetry_items_per_second"
        elif key == "minPercentage":
            suggest = "min_percentage"
        elif key == "movingAverageRatio":
            suggest = "moving_average_ratio"
        elif key == "percentageDecreaseTimeout":
            suggest = "percentage_decrease_timeout"
        elif key == "percentageIncreaseTimeout":
            suggest = "percentage_increase_timeout"
        elif key == "samplingType":
            suggest = "sampling_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoggerSamplingContractResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoggerSamplingContractResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoggerSamplingContractResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 evaluation_interval: Optional[str] = None,
                 initial_percentage: Optional[float] = None,
                 max_percentage: Optional[float] = None,
                 max_telemetry_items_per_second: Optional[int] = None,
                 min_percentage: Optional[float] = None,
                 moving_average_ratio: Optional[float] = None,
                 percentage: Optional[float] = None,
                 percentage_decrease_timeout: Optional[str] = None,
                 percentage_increase_timeout: Optional[str] = None,
                 sampling_type: Optional[str] = None):
        """
        Sampling settings contract.
        :param str evaluation_interval: Rate re-evaluation interval in ISO8601 format.
        :param float initial_percentage: Initial sampling rate.
        :param float max_percentage: Maximum allowed rate of sampling.
        :param int max_telemetry_items_per_second: Target rate of telemetry items per second.
        :param float min_percentage: Minimum allowed rate of sampling.
        :param float moving_average_ratio: Moving average ration assigned to most recent value.
        :param float percentage: Rate of sampling for fixed-rate sampling.
        :param str percentage_decrease_timeout: Duration in ISO8601 format after which it's allowed to lower the sampling rate.
        :param str percentage_increase_timeout: Duration in ISO8601 format after which it's allowed to increase the sampling rate.
        :param str sampling_type: Sampling type.
        """
        if evaluation_interval is not None:
            pulumi.set(__self__, "evaluation_interval", evaluation_interval)
        if initial_percentage is not None:
            pulumi.set(__self__, "initial_percentage", initial_percentage)
        if max_percentage is not None:
            pulumi.set(__self__, "max_percentage", max_percentage)
        if max_telemetry_items_per_second is not None:
            pulumi.set(__self__, "max_telemetry_items_per_second", max_telemetry_items_per_second)
        if min_percentage is not None:
            pulumi.set(__self__, "min_percentage", min_percentage)
        if moving_average_ratio is not None:
            pulumi.set(__self__, "moving_average_ratio", moving_average_ratio)
        if percentage is not None:
            pulumi.set(__self__, "percentage", percentage)
        if percentage_decrease_timeout is not None:
            pulumi.set(__self__, "percentage_decrease_timeout", percentage_decrease_timeout)
        if percentage_increase_timeout is not None:
            pulumi.set(__self__, "percentage_increase_timeout", percentage_increase_timeout)
        if sampling_type is not None:
            pulumi.set(__self__, "sampling_type", sampling_type)

    @property
    @pulumi.getter(name="evaluationInterval")
    def evaluation_interval(self) -> Optional[str]:
        """
        Rate re-evaluation interval in ISO8601 format.
        """
        return pulumi.get(self, "evaluation_interval")

    @property
    @pulumi.getter(name="initialPercentage")
    def initial_percentage(self) -> Optional[float]:
        """
        Initial sampling rate.
        """
        return pulumi.get(self, "initial_percentage")

    @property
    @pulumi.getter(name="maxPercentage")
    def max_percentage(self) -> Optional[float]:
        """
        Maximum allowed rate of sampling.
        """
        return pulumi.get(self, "max_percentage")

    @property
    @pulumi.getter(name="maxTelemetryItemsPerSecond")
    def max_telemetry_items_per_second(self) -> Optional[int]:
        """
        Target rate of telemetry items per second.
        """
        return pulumi.get(self, "max_telemetry_items_per_second")

    @property
    @pulumi.getter(name="minPercentage")
    def min_percentage(self) -> Optional[float]:
        """
        Minimum allowed rate of sampling.
        """
        return pulumi.get(self, "min_percentage")

    @property
    @pulumi.getter(name="movingAverageRatio")
    def moving_average_ratio(self) -> Optional[float]:
        """
        Moving average ration assigned to most recent value.
        """
        return pulumi.get(self, "moving_average_ratio")

    @property
    @pulumi.getter
    def percentage(self) -> Optional[float]:
        """
        Rate of sampling for fixed-rate sampling.
        """
        return pulumi.get(self, "percentage")

    @property
    @pulumi.getter(name="percentageDecreaseTimeout")
    def percentage_decrease_timeout(self) -> Optional[str]:
        """
        Duration in ISO8601 format after which it's allowed to lower the sampling rate.
        """
        return pulumi.get(self, "percentage_decrease_timeout")

    @property
    @pulumi.getter(name="percentageIncreaseTimeout")
    def percentage_increase_timeout(self) -> Optional[str]:
        """
        Duration in ISO8601 format after which it's allowed to increase the sampling rate.
        """
        return pulumi.get(self, "percentage_increase_timeout")

    @property
    @pulumi.getter(name="samplingType")
    def sampling_type(self) -> Optional[str]:
        """
        Sampling type.
        """
        return pulumi.get(self, "sampling_type")


@pulumi.output_type
class OAuth2AuthenticationSettingsContractResponse(dict):
    """
    API OAuth2 Authentication settings details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorizationServerId":
            suggest = "authorization_server_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OAuth2AuthenticationSettingsContractResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OAuth2AuthenticationSettingsContractResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OAuth2AuthenticationSettingsContractResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authorization_server_id: Optional[str] = None,
                 scope: Optional[str] = None):
        """
        API OAuth2 Authentication settings details.
        :param str authorization_server_id: OAuth authorization server identifier.
        :param str scope: operations scope.
        """
        if authorization_server_id is not None:
            pulumi.set(__self__, "authorization_server_id", authorization_server_id)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter(name="authorizationServerId")
    def authorization_server_id(self) -> Optional[str]:
        """
        OAuth authorization server identifier.
        """
        return pulumi.get(self, "authorization_server_id")

    @property
    @pulumi.getter
    def scope(self) -> Optional[str]:
        """
        operations scope.
        """
        return pulumi.get(self, "scope")


@pulumi.output_type
class ParameterContractResponse(dict):
    """
    Operation parameters details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultValue":
            suggest = "default_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ParameterContractResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ParameterContractResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ParameterContractResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 type: str,
                 default_value: Optional[str] = None,
                 description: Optional[str] = None,
                 required: Optional[bool] = None,
                 values: Optional[Sequence[str]] = None):
        """
        Operation parameters details.
        :param str name: Parameter name.
        :param str type: Parameter type.
        :param str default_value: Default parameter value.
        :param str description: Parameter description.
        :param bool required: whether parameter is required or not.
        :param Sequence[str] values: Parameter values.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if default_value is not None:
            pulumi.set(__self__, "default_value", default_value)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if required is not None:
            pulumi.set(__self__, "required", required)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Parameter name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Parameter type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> Optional[str]:
        """
        Default parameter value.
        """
        return pulumi.get(self, "default_value")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Parameter description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def required(self) -> Optional[bool]:
        """
        whether parameter is required or not.
        """
        return pulumi.get(self, "required")

    @property
    @pulumi.getter
    def values(self) -> Optional[Sequence[str]]:
        """
        Parameter values.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class RepresentationContractResponse(dict):
    """
    Operation request/response representation details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentType":
            suggest = "content_type"
        elif key == "formParameters":
            suggest = "form_parameters"
        elif key == "schemaId":
            suggest = "schema_id"
        elif key == "typeName":
            suggest = "type_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepresentationContractResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepresentationContractResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepresentationContractResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content_type: str,
                 form_parameters: Optional[Sequence['outputs.ParameterContractResponse']] = None,
                 sample: Optional[str] = None,
                 schema_id: Optional[str] = None,
                 type_name: Optional[str] = None):
        """
        Operation request/response representation details.
        :param str content_type: Specifies a registered or custom content type for this representation, e.g. application/xml.
        :param Sequence['ParameterContractResponse'] form_parameters: Collection of form parameters. Required if 'contentType' value is either 'application/x-www-form-urlencoded' or 'multipart/form-data'..
        :param str sample: An example of the representation.
        :param str schema_id: Schema identifier. Applicable only if 'contentType' value is neither 'application/x-www-form-urlencoded' nor 'multipart/form-data'.
        :param str type_name: Type name defined by the schema. Applicable only if 'contentType' value is neither 'application/x-www-form-urlencoded' nor 'multipart/form-data'.
        """
        pulumi.set(__self__, "content_type", content_type)
        if form_parameters is not None:
            pulumi.set(__self__, "form_parameters", form_parameters)
        if sample is not None:
            pulumi.set(__self__, "sample", sample)
        if schema_id is not None:
            pulumi.set(__self__, "schema_id", schema_id)
        if type_name is not None:
            pulumi.set(__self__, "type_name", type_name)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> str:
        """
        Specifies a registered or custom content type for this representation, e.g. application/xml.
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter(name="formParameters")
    def form_parameters(self) -> Optional[Sequence['outputs.ParameterContractResponse']]:
        """
        Collection of form parameters. Required if 'contentType' value is either 'application/x-www-form-urlencoded' or 'multipart/form-data'..
        """
        return pulumi.get(self, "form_parameters")

    @property
    @pulumi.getter
    def sample(self) -> Optional[str]:
        """
        An example of the representation.
        """
        return pulumi.get(self, "sample")

    @property
    @pulumi.getter(name="schemaId")
    def schema_id(self) -> Optional[str]:
        """
        Schema identifier. Applicable only if 'contentType' value is neither 'application/x-www-form-urlencoded' nor 'multipart/form-data'.
        """
        return pulumi.get(self, "schema_id")

    @property
    @pulumi.getter(name="typeName")
    def type_name(self) -> Optional[str]:
        """
        Type name defined by the schema. Applicable only if 'contentType' value is neither 'application/x-www-form-urlencoded' nor 'multipart/form-data'.
        """
        return pulumi.get(self, "type_name")


@pulumi.output_type
class RequestContractResponse(dict):
    """
    Operation request details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queryParameters":
            suggest = "query_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RequestContractResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RequestContractResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RequestContractResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: Optional[str] = None,
                 headers: Optional[Sequence['outputs.ParameterContractResponse']] = None,
                 query_parameters: Optional[Sequence['outputs.ParameterContractResponse']] = None,
                 representations: Optional[Sequence['outputs.RepresentationContractResponse']] = None):
        """
        Operation request details.
        :param str description: Operation request description.
        :param Sequence['ParameterContractResponse'] headers: Collection of operation request headers.
        :param Sequence['ParameterContractResponse'] query_parameters: Collection of operation request query parameters.
        :param Sequence['RepresentationContractResponse'] representations: Collection of operation request representations.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if query_parameters is not None:
            pulumi.set(__self__, "query_parameters", query_parameters)
        if representations is not None:
            pulumi.set(__self__, "representations", representations)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Operation request description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def headers(self) -> Optional[Sequence['outputs.ParameterContractResponse']]:
        """
        Collection of operation request headers.
        """
        return pulumi.get(self, "headers")

    @property
    @pulumi.getter(name="queryParameters")
    def query_parameters(self) -> Optional[Sequence['outputs.ParameterContractResponse']]:
        """
        Collection of operation request query parameters.
        """
        return pulumi.get(self, "query_parameters")

    @property
    @pulumi.getter
    def representations(self) -> Optional[Sequence['outputs.RepresentationContractResponse']]:
        """
        Collection of operation request representations.
        """
        return pulumi.get(self, "representations")


@pulumi.output_type
class ResponseContractResponse(dict):
    """
    Operation response details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "statusCode":
            suggest = "status_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResponseContractResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResponseContractResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResponseContractResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 status_code: int,
                 description: Optional[str] = None,
                 headers: Optional[Sequence['outputs.ParameterContractResponse']] = None,
                 representations: Optional[Sequence['outputs.RepresentationContractResponse']] = None):
        """
        Operation response details.
        :param int status_code: Operation response HTTP status code.
        :param str description: Operation response description.
        :param Sequence['ParameterContractResponse'] headers: Collection of operation response headers.
        :param Sequence['RepresentationContractResponse'] representations: Collection of operation response representations.
        """
        pulumi.set(__self__, "status_code", status_code)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if representations is not None:
            pulumi.set(__self__, "representations", representations)

    @property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> int:
        """
        Operation response HTTP status code.
        """
        return pulumi.get(self, "status_code")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Operation response description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def headers(self) -> Optional[Sequence['outputs.ParameterContractResponse']]:
        """
        Collection of operation response headers.
        """
        return pulumi.get(self, "headers")

    @property
    @pulumi.getter
    def representations(self) -> Optional[Sequence['outputs.RepresentationContractResponse']]:
        """
        Collection of operation response representations.
        """
        return pulumi.get(self, "representations")


@pulumi.output_type
class SubscriptionKeyParameterNamesContractResponse(dict):
    """
    Subscription key parameter names details.
    """
    def __init__(__self__, *,
                 header: Optional[str] = None,
                 query: Optional[str] = None):
        """
        Subscription key parameter names details.
        :param str header: Subscription key header name.
        :param str query: Subscription key query string parameter name.
        """
        if header is not None:
            pulumi.set(__self__, "header", header)
        if query is not None:
            pulumi.set(__self__, "query", query)

    @property
    @pulumi.getter
    def header(self) -> Optional[str]:
        """
        Subscription key header name.
        """
        return pulumi.get(self, "header")

    @property
    @pulumi.getter
    def query(self) -> Optional[str]:
        """
        Subscription key query string parameter name.
        """
        return pulumi.get(self, "query")


@pulumi.output_type
class TokenBodyParameterContractResponse(dict):
    """
    OAuth acquire token request body parameter (www-url-form-encoded).
    """
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        OAuth acquire token request body parameter (www-url-form-encoded).
        :param str name: body parameter name.
        :param str value: body parameter value.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        body parameter name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        body parameter value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class UserIdentityContractResponse(dict):
    """
    User identity details.
    """
    def __init__(__self__, *,
                 id: Optional[str] = None,
                 provider: Optional[str] = None):
        """
        User identity details.
        :param str id: Identifier value within provider.
        :param str provider: Identity provider name.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if provider is not None:
            pulumi.set(__self__, "provider", provider)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Identifier value within provider.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def provider(self) -> Optional[str]:
        """
        Identity provider name.
        """
        return pulumi.get(self, "provider")


@pulumi.output_type
class VirtualNetworkConfigurationResponse(dict):
    """
    Configuration of a virtual network to which API Management service is deployed.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subnetResourceId":
            suggest = "subnet_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualNetworkConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualNetworkConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualNetworkConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subnetname: str,
                 vnetid: str,
                 subnet_resource_id: Optional[str] = None):
        """
        Configuration of a virtual network to which API Management service is deployed.
        :param str subnetname: The name of the subnet.
        :param str vnetid: The virtual network ID. This is typically a GUID. Expect a null GUID by default.
        :param str subnet_resource_id: The full resource ID of a subnet in a virtual network to deploy the API Management service in.
        """
        pulumi.set(__self__, "subnetname", subnetname)
        pulumi.set(__self__, "vnetid", vnetid)
        if subnet_resource_id is not None:
            pulumi.set(__self__, "subnet_resource_id", subnet_resource_id)

    @property
    @pulumi.getter
    def subnetname(self) -> str:
        """
        The name of the subnet.
        """
        return pulumi.get(self, "subnetname")

    @property
    @pulumi.getter
    def vnetid(self) -> str:
        """
        The virtual network ID. This is typically a GUID. Expect a null GUID by default.
        """
        return pulumi.get(self, "vnetid")

    @property
    @pulumi.getter(name="subnetResourceId")
    def subnet_resource_id(self) -> Optional[str]:
        """
        The full resource ID of a subnet in a virtual network to deploy the API Management service in.
        """
        return pulumi.get(self, "subnet_resource_id")


@pulumi.output_type
class X509CertificateNameResponse(dict):
    """
    Properties of server X509Names.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "issuerCertificateThumbprint":
            suggest = "issuer_certificate_thumbprint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in X509CertificateNameResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        X509CertificateNameResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        X509CertificateNameResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 issuer_certificate_thumbprint: Optional[str] = None,
                 name: Optional[str] = None):
        """
        Properties of server X509Names.
        :param str issuer_certificate_thumbprint: Thumbprint for the Issuer of the Certificate.
        :param str name: Common Name of the Certificate.
        """
        if issuer_certificate_thumbprint is not None:
            pulumi.set(__self__, "issuer_certificate_thumbprint", issuer_certificate_thumbprint)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="issuerCertificateThumbprint")
    def issuer_certificate_thumbprint(self) -> Optional[str]:
        """
        Thumbprint for the Issuer of the Certificate.
        """
        return pulumi.get(self, "issuer_certificate_thumbprint")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Common Name of the Certificate.
        """
        return pulumi.get(self, "name")


