# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AppResourcePropertiesArgs',
    'AzureFileVolumeArgs',
    'BindingResourcePropertiesArgs',
    'ClusterResourcePropertiesArgs',
    'ContentCertificatePropertiesArgs',
    'CustomContainerArgs',
    'CustomDomainPropertiesArgs',
    'CustomPersistentDiskResourceArgs',
    'DeploymentResourcePropertiesArgs',
    'DeploymentSettingsContainerProbeSettingsArgs',
    'DeploymentSettingsArgs',
    'ImageRegistryCredentialArgs',
    'KeyVaultCertificatePropertiesArgs',
    'LoadedCertificateArgs',
    'ManagedIdentityPropertiesArgs',
    'NetworkProfileArgs',
    'PersistentDiskArgs',
    'ResourceRequestsArgs',
    'SkuArgs',
    'StorageAccountArgs',
    'TemporaryDiskArgs',
    'UserSourceInfoArgs',
]

@pulumi.input_type
class AppResourcePropertiesArgs:
    def __init__(__self__, *,
                 active_deployment_name: Optional[pulumi.Input[str]] = None,
                 custom_persistent_disks: Optional[pulumi.Input[Sequence[pulumi.Input['CustomPersistentDiskResourceArgs']]]] = None,
                 enable_end_to_end_tls: Optional[pulumi.Input[bool]] = None,
                 fqdn: Optional[pulumi.Input[str]] = None,
                 https_only: Optional[pulumi.Input[bool]] = None,
                 loaded_certificates: Optional[pulumi.Input[Sequence[pulumi.Input['LoadedCertificateArgs']]]] = None,
                 persistent_disk: Optional[pulumi.Input['PersistentDiskArgs']] = None,
                 public: Optional[pulumi.Input[bool]] = None,
                 temporary_disk: Optional[pulumi.Input['TemporaryDiskArgs']] = None):
        """
        App resource properties payload
        :param pulumi.Input[str] active_deployment_name: Name of the active deployment of the App
        :param pulumi.Input[Sequence[pulumi.Input['CustomPersistentDiskResourceArgs']]] custom_persistent_disks: List of custom persistent disks
        :param pulumi.Input[bool] enable_end_to_end_tls: Indicate if end to end TLS is enabled.
        :param pulumi.Input[str] fqdn: Fully qualified dns Name.
        :param pulumi.Input[bool] https_only: Indicate if only https is allowed.
        :param pulumi.Input[Sequence[pulumi.Input['LoadedCertificateArgs']]] loaded_certificates: Collection of loaded certificates
        :param pulumi.Input['PersistentDiskArgs'] persistent_disk: Persistent disk settings
        :param pulumi.Input[bool] public: Indicates whether the App exposes public endpoint
        :param pulumi.Input['TemporaryDiskArgs'] temporary_disk: Temporary disk settings
        """
        if active_deployment_name is not None:
            pulumi.set(__self__, "active_deployment_name", active_deployment_name)
        if custom_persistent_disks is not None:
            pulumi.set(__self__, "custom_persistent_disks", custom_persistent_disks)
        if enable_end_to_end_tls is None:
            enable_end_to_end_tls = False
        if enable_end_to_end_tls is not None:
            pulumi.set(__self__, "enable_end_to_end_tls", enable_end_to_end_tls)
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if https_only is None:
            https_only = False
        if https_only is not None:
            pulumi.set(__self__, "https_only", https_only)
        if loaded_certificates is not None:
            pulumi.set(__self__, "loaded_certificates", loaded_certificates)
        if persistent_disk is not None:
            pulumi.set(__self__, "persistent_disk", persistent_disk)
        if public is not None:
            pulumi.set(__self__, "public", public)
        if temporary_disk is not None:
            pulumi.set(__self__, "temporary_disk", temporary_disk)

    @property
    @pulumi.getter(name="activeDeploymentName")
    def active_deployment_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the active deployment of the App
        """
        return pulumi.get(self, "active_deployment_name")

    @active_deployment_name.setter
    def active_deployment_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "active_deployment_name", value)

    @property
    @pulumi.getter(name="customPersistentDisks")
    def custom_persistent_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CustomPersistentDiskResourceArgs']]]]:
        """
        List of custom persistent disks
        """
        return pulumi.get(self, "custom_persistent_disks")

    @custom_persistent_disks.setter
    def custom_persistent_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CustomPersistentDiskResourceArgs']]]]):
        pulumi.set(self, "custom_persistent_disks", value)

    @property
    @pulumi.getter(name="enableEndToEndTLS")
    def enable_end_to_end_tls(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicate if end to end TLS is enabled.
        """
        return pulumi.get(self, "enable_end_to_end_tls")

    @enable_end_to_end_tls.setter
    def enable_end_to_end_tls(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_end_to_end_tls", value)

    @property
    @pulumi.getter
    def fqdn(self) -> Optional[pulumi.Input[str]]:
        """
        Fully qualified dns Name.
        """
        return pulumi.get(self, "fqdn")

    @fqdn.setter
    def fqdn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fqdn", value)

    @property
    @pulumi.getter(name="httpsOnly")
    def https_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicate if only https is allowed.
        """
        return pulumi.get(self, "https_only")

    @https_only.setter
    def https_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "https_only", value)

    @property
    @pulumi.getter(name="loadedCertificates")
    def loaded_certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadedCertificateArgs']]]]:
        """
        Collection of loaded certificates
        """
        return pulumi.get(self, "loaded_certificates")

    @loaded_certificates.setter
    def loaded_certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadedCertificateArgs']]]]):
        pulumi.set(self, "loaded_certificates", value)

    @property
    @pulumi.getter(name="persistentDisk")
    def persistent_disk(self) -> Optional[pulumi.Input['PersistentDiskArgs']]:
        """
        Persistent disk settings
        """
        return pulumi.get(self, "persistent_disk")

    @persistent_disk.setter
    def persistent_disk(self, value: Optional[pulumi.Input['PersistentDiskArgs']]):
        pulumi.set(self, "persistent_disk", value)

    @property
    @pulumi.getter
    def public(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the App exposes public endpoint
        """
        return pulumi.get(self, "public")

    @public.setter
    def public(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "public", value)

    @property
    @pulumi.getter(name="temporaryDisk")
    def temporary_disk(self) -> Optional[pulumi.Input['TemporaryDiskArgs']]:
        """
        Temporary disk settings
        """
        return pulumi.get(self, "temporary_disk")

    @temporary_disk.setter
    def temporary_disk(self, value: Optional[pulumi.Input['TemporaryDiskArgs']]):
        pulumi.set(self, "temporary_disk", value)


@pulumi.input_type
class AzureFileVolumeArgs:
    def __init__(__self__, *,
                 mount_path: pulumi.Input[str],
                 share_name: pulumi.Input[str],
                 type: pulumi.Input[str],
                 mount_options: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 read_only: Optional[pulumi.Input[bool]] = None):
        """
        The properties of the Azure File volume. Azure File shares are mounted as volumes.
        :param pulumi.Input[str] mount_path: The mount path of the persistent disk.
        :param pulumi.Input[str] share_name: The share name of the Azure File share.
        :param pulumi.Input[str] type: The type of the underlying resource to mount as a persistent disk.
               Expected value is 'AzureFileVolume'.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] mount_options: These are the mount options for a persistent disk.
        :param pulumi.Input[bool] read_only: Indicates whether the persistent disk is a readOnly one.
        """
        pulumi.set(__self__, "mount_path", mount_path)
        pulumi.set(__self__, "share_name", share_name)
        pulumi.set(__self__, "type", 'AzureFileVolume')
        if mount_options is not None:
            pulumi.set(__self__, "mount_options", mount_options)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)

    @property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> pulumi.Input[str]:
        """
        The mount path of the persistent disk.
        """
        return pulumi.get(self, "mount_path")

    @mount_path.setter
    def mount_path(self, value: pulumi.Input[str]):
        pulumi.set(self, "mount_path", value)

    @property
    @pulumi.getter(name="shareName")
    def share_name(self) -> pulumi.Input[str]:
        """
        The share name of the Azure File share.
        """
        return pulumi.get(self, "share_name")

    @share_name.setter
    def share_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "share_name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of the underlying resource to mount as a persistent disk.
        Expected value is 'AzureFileVolume'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        These are the mount options for a persistent disk.
        """
        return pulumi.get(self, "mount_options")

    @mount_options.setter
    def mount_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "mount_options", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the persistent disk is a readOnly one.
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read_only", value)


@pulumi.input_type
class BindingResourcePropertiesArgs:
    def __init__(__self__, *,
                 binding_parameters: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None):
        """
        Binding resource properties payload
        :param pulumi.Input[Mapping[str, Any]] binding_parameters: Binding parameters of the Binding resource
        :param pulumi.Input[str] key: The key of the bound resource
        :param pulumi.Input[str] resource_id: The Azure resource id of the bound resource
        """
        if binding_parameters is not None:
            pulumi.set(__self__, "binding_parameters", binding_parameters)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="bindingParameters")
    def binding_parameters(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Binding parameters of the Binding resource
        """
        return pulumi.get(self, "binding_parameters")

    @binding_parameters.setter
    def binding_parameters(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "binding_parameters", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        The key of the bound resource
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Azure resource id of the bound resource
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)


@pulumi.input_type
class ClusterResourcePropertiesArgs:
    def __init__(__self__, *,
                 network_profile: Optional[pulumi.Input['NetworkProfileArgs']] = None):
        """
        Service properties payload
        :param pulumi.Input['NetworkProfileArgs'] network_profile: Network profile of the Service
        """
        if network_profile is not None:
            pulumi.set(__self__, "network_profile", network_profile)

    @property
    @pulumi.getter(name="networkProfile")
    def network_profile(self) -> Optional[pulumi.Input['NetworkProfileArgs']]:
        """
        Network profile of the Service
        """
        return pulumi.get(self, "network_profile")

    @network_profile.setter
    def network_profile(self, value: Optional[pulumi.Input['NetworkProfileArgs']]):
        pulumi.set(self, "network_profile", value)


@pulumi.input_type
class ContentCertificatePropertiesArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 content: Optional[pulumi.Input[str]] = None):
        """
        Properties of certificate imported from key vault.
        :param pulumi.Input[str] type: The type of the certificate source.
               Expected value is 'ContentCertificate'.
        :param pulumi.Input[str] content: The content of uploaded certificate.
        """
        pulumi.set(__self__, "type", 'ContentCertificate')
        if content is not None:
            pulumi.set(__self__, "content", content)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of the certificate source.
        Expected value is 'ContentCertificate'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[str]]:
        """
        The content of uploaded certificate.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content", value)


@pulumi.input_type
class CustomContainerArgs:
    def __init__(__self__, *,
                 args: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 command: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 container_image: Optional[pulumi.Input[str]] = None,
                 image_registry_credential: Optional[pulumi.Input['ImageRegistryCredentialArgs']] = None,
                 server: Optional[pulumi.Input[str]] = None):
        """
        Custom container payload
        :param pulumi.Input[Sequence[pulumi.Input[str]]] args: Arguments to the entrypoint. The docker image's CMD is used if this is not provided.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] command: Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided.
        :param pulumi.Input[str] container_image: Container image of the custom container. This should be in the form of <repository>:<tag> without the server name of the registry
        :param pulumi.Input['ImageRegistryCredentialArgs'] image_registry_credential: Credential of the image registry
        :param pulumi.Input[str] server: The name of the registry that contains the container image
        """
        if args is not None:
            pulumi.set(__self__, "args", args)
        if command is not None:
            pulumi.set(__self__, "command", command)
        if container_image is not None:
            pulumi.set(__self__, "container_image", container_image)
        if image_registry_credential is not None:
            pulumi.set(__self__, "image_registry_credential", image_registry_credential)
        if server is not None:
            pulumi.set(__self__, "server", server)

    @property
    @pulumi.getter
    def args(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Arguments to the entrypoint. The docker image's CMD is used if this is not provided.
        """
        return pulumi.get(self, "args")

    @args.setter
    def args(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "args", value)

    @property
    @pulumi.getter
    def command(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided.
        """
        return pulumi.get(self, "command")

    @command.setter
    def command(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "command", value)

    @property
    @pulumi.getter(name="containerImage")
    def container_image(self) -> Optional[pulumi.Input[str]]:
        """
        Container image of the custom container. This should be in the form of <repository>:<tag> without the server name of the registry
        """
        return pulumi.get(self, "container_image")

    @container_image.setter
    def container_image(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_image", value)

    @property
    @pulumi.getter(name="imageRegistryCredential")
    def image_registry_credential(self) -> Optional[pulumi.Input['ImageRegistryCredentialArgs']]:
        """
        Credential of the image registry
        """
        return pulumi.get(self, "image_registry_credential")

    @image_registry_credential.setter
    def image_registry_credential(self, value: Optional[pulumi.Input['ImageRegistryCredentialArgs']]):
        pulumi.set(self, "image_registry_credential", value)

    @property
    @pulumi.getter
    def server(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the registry that contains the container image
        """
        return pulumi.get(self, "server")

    @server.setter
    def server(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server", value)


@pulumi.input_type
class CustomDomainPropertiesArgs:
    def __init__(__self__, *,
                 cert_name: Optional[pulumi.Input[str]] = None,
                 thumbprint: Optional[pulumi.Input[str]] = None):
        """
        Custom domain of app resource payload.
        :param pulumi.Input[str] cert_name: The bound certificate name of domain.
        :param pulumi.Input[str] thumbprint: The thumbprint of bound certificate.
        """
        if cert_name is not None:
            pulumi.set(__self__, "cert_name", cert_name)
        if thumbprint is not None:
            pulumi.set(__self__, "thumbprint", thumbprint)

    @property
    @pulumi.getter(name="certName")
    def cert_name(self) -> Optional[pulumi.Input[str]]:
        """
        The bound certificate name of domain.
        """
        return pulumi.get(self, "cert_name")

    @cert_name.setter
    def cert_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cert_name", value)

    @property
    @pulumi.getter
    def thumbprint(self) -> Optional[pulumi.Input[str]]:
        """
        The thumbprint of bound certificate.
        """
        return pulumi.get(self, "thumbprint")

    @thumbprint.setter
    def thumbprint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "thumbprint", value)


@pulumi.input_type
class CustomPersistentDiskResourceArgs:
    def __init__(__self__, *,
                 storage_id: pulumi.Input[str],
                 custom_persistent_disk_properties: Optional[pulumi.Input['AzureFileVolumeArgs']] = None):
        """
        Custom persistent disk resource payload.
        :param pulumi.Input[str] storage_id: The resource id of Azure Spring Cloud Storage resource.
        :param pulumi.Input['AzureFileVolumeArgs'] custom_persistent_disk_properties: Properties of the custom persistent disk resource payload.
        """
        pulumi.set(__self__, "storage_id", storage_id)
        if custom_persistent_disk_properties is not None:
            pulumi.set(__self__, "custom_persistent_disk_properties", custom_persistent_disk_properties)

    @property
    @pulumi.getter(name="storageId")
    def storage_id(self) -> pulumi.Input[str]:
        """
        The resource id of Azure Spring Cloud Storage resource.
        """
        return pulumi.get(self, "storage_id")

    @storage_id.setter
    def storage_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "storage_id", value)

    @property
    @pulumi.getter(name="customPersistentDiskProperties")
    def custom_persistent_disk_properties(self) -> Optional[pulumi.Input['AzureFileVolumeArgs']]:
        """
        Properties of the custom persistent disk resource payload.
        """
        return pulumi.get(self, "custom_persistent_disk_properties")

    @custom_persistent_disk_properties.setter
    def custom_persistent_disk_properties(self, value: Optional[pulumi.Input['AzureFileVolumeArgs']]):
        pulumi.set(self, "custom_persistent_disk_properties", value)


@pulumi.input_type
class DeploymentResourcePropertiesArgs:
    def __init__(__self__, *,
                 deployment_settings: Optional[pulumi.Input['DeploymentSettingsArgs']] = None,
                 source: Optional[pulumi.Input['UserSourceInfoArgs']] = None):
        """
        Deployment resource properties payload
        :param pulumi.Input['DeploymentSettingsArgs'] deployment_settings: Deployment settings of the Deployment
        :param pulumi.Input['UserSourceInfoArgs'] source: Uploaded source information of the deployment.
        """
        if deployment_settings is not None:
            pulumi.set(__self__, "deployment_settings", deployment_settings)
        if source is not None:
            pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter(name="deploymentSettings")
    def deployment_settings(self) -> Optional[pulumi.Input['DeploymentSettingsArgs']]:
        """
        Deployment settings of the Deployment
        """
        return pulumi.get(self, "deployment_settings")

    @deployment_settings.setter
    def deployment_settings(self, value: Optional[pulumi.Input['DeploymentSettingsArgs']]):
        pulumi.set(self, "deployment_settings", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input['UserSourceInfoArgs']]:
        """
        Uploaded source information of the deployment.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input['UserSourceInfoArgs']]):
        pulumi.set(self, "source", value)


@pulumi.input_type
class DeploymentSettingsContainerProbeSettingsArgs:
    def __init__(__self__, *,
                 disable_probe: Optional[pulumi.Input[bool]] = None):
        """
        Container liveness and readiness probe settings
        :param pulumi.Input[bool] disable_probe: Indicates whether disable the liveness and readiness probe
        """
        if disable_probe is not None:
            pulumi.set(__self__, "disable_probe", disable_probe)

    @property
    @pulumi.getter(name="disableProbe")
    def disable_probe(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether disable the liveness and readiness probe
        """
        return pulumi.get(self, "disable_probe")

    @disable_probe.setter
    def disable_probe(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_probe", value)


@pulumi.input_type
class DeploymentSettingsArgs:
    def __init__(__self__, *,
                 container_probe_settings: Optional[pulumi.Input['DeploymentSettingsContainerProbeSettingsArgs']] = None,
                 cpu: Optional[pulumi.Input[int]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 jvm_options: Optional[pulumi.Input[str]] = None,
                 memory_in_gb: Optional[pulumi.Input[int]] = None,
                 net_core_main_entry_path: Optional[pulumi.Input[str]] = None,
                 resource_requests: Optional[pulumi.Input['ResourceRequestsArgs']] = None,
                 runtime_version: Optional[pulumi.Input[Union[str, 'RuntimeVersion']]] = None):
        """
        Deployment settings payload
        :param pulumi.Input['DeploymentSettingsContainerProbeSettingsArgs'] container_probe_settings: Container liveness and readiness probe settings
        :param pulumi.Input[int] cpu: Required CPU. This should be 1 for Basic tier, and in range [1, 4] for Standard tier. This is deprecated starting from API version 2021-09-01-preview. Please use the resourceRequests field to set the CPU size.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] environment_variables: Collection of environment variables
        :param pulumi.Input[str] jvm_options: JVM parameter
        :param pulumi.Input[int] memory_in_gb: Required Memory size in GB. This should be in range [1, 2] for Basic tier, and in range [1, 8] for Standard tier. This is deprecated starting from API version 2021-09-01-preview. Please use the resourceRequests field to set the the memory size.
        :param pulumi.Input[str] net_core_main_entry_path: The path to the .NET executable relative to zip root
        :param pulumi.Input['ResourceRequestsArgs'] resource_requests: The requested resource quantity for required CPU and Memory. It is recommended that using this field to represent the required CPU and Memory, the old field cpu and memoryInGB will be deprecated later.
        :param pulumi.Input[Union[str, 'RuntimeVersion']] runtime_version: Runtime version
        """
        if container_probe_settings is not None:
            pulumi.set(__self__, "container_probe_settings", container_probe_settings)
        if cpu is None:
            cpu = 1
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if jvm_options is not None:
            pulumi.set(__self__, "jvm_options", jvm_options)
        if memory_in_gb is None:
            memory_in_gb = 1
        if memory_in_gb is not None:
            pulumi.set(__self__, "memory_in_gb", memory_in_gb)
        if net_core_main_entry_path is not None:
            pulumi.set(__self__, "net_core_main_entry_path", net_core_main_entry_path)
        if resource_requests is not None:
            pulumi.set(__self__, "resource_requests", resource_requests)
        if runtime_version is None:
            runtime_version = 'Java_8'
        if runtime_version is not None:
            pulumi.set(__self__, "runtime_version", runtime_version)

    @property
    @pulumi.getter(name="containerProbeSettings")
    def container_probe_settings(self) -> Optional[pulumi.Input['DeploymentSettingsContainerProbeSettingsArgs']]:
        """
        Container liveness and readiness probe settings
        """
        return pulumi.get(self, "container_probe_settings")

    @container_probe_settings.setter
    def container_probe_settings(self, value: Optional[pulumi.Input['DeploymentSettingsContainerProbeSettingsArgs']]):
        pulumi.set(self, "container_probe_settings", value)

    @property
    @pulumi.getter
    def cpu(self) -> Optional[pulumi.Input[int]]:
        """
        Required CPU. This should be 1 for Basic tier, and in range [1, 4] for Standard tier. This is deprecated starting from API version 2021-09-01-preview. Please use the resourceRequests field to set the CPU size.
        """
        return pulumi.get(self, "cpu")

    @cpu.setter
    def cpu(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cpu", value)

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Collection of environment variables
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "environment_variables", value)

    @property
    @pulumi.getter(name="jvmOptions")
    def jvm_options(self) -> Optional[pulumi.Input[str]]:
        """
        JVM parameter
        """
        return pulumi.get(self, "jvm_options")

    @jvm_options.setter
    def jvm_options(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "jvm_options", value)

    @property
    @pulumi.getter(name="memoryInGB")
    def memory_in_gb(self) -> Optional[pulumi.Input[int]]:
        """
        Required Memory size in GB. This should be in range [1, 2] for Basic tier, and in range [1, 8] for Standard tier. This is deprecated starting from API version 2021-09-01-preview. Please use the resourceRequests field to set the the memory size.
        """
        return pulumi.get(self, "memory_in_gb")

    @memory_in_gb.setter
    def memory_in_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "memory_in_gb", value)

    @property
    @pulumi.getter(name="netCoreMainEntryPath")
    def net_core_main_entry_path(self) -> Optional[pulumi.Input[str]]:
        """
        The path to the .NET executable relative to zip root
        """
        return pulumi.get(self, "net_core_main_entry_path")

    @net_core_main_entry_path.setter
    def net_core_main_entry_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "net_core_main_entry_path", value)

    @property
    @pulumi.getter(name="resourceRequests")
    def resource_requests(self) -> Optional[pulumi.Input['ResourceRequestsArgs']]:
        """
        The requested resource quantity for required CPU and Memory. It is recommended that using this field to represent the required CPU and Memory, the old field cpu and memoryInGB will be deprecated later.
        """
        return pulumi.get(self, "resource_requests")

    @resource_requests.setter
    def resource_requests(self, value: Optional[pulumi.Input['ResourceRequestsArgs']]):
        pulumi.set(self, "resource_requests", value)

    @property
    @pulumi.getter(name="runtimeVersion")
    def runtime_version(self) -> Optional[pulumi.Input[Union[str, 'RuntimeVersion']]]:
        """
        Runtime version
        """
        return pulumi.get(self, "runtime_version")

    @runtime_version.setter
    def runtime_version(self, value: Optional[pulumi.Input[Union[str, 'RuntimeVersion']]]):
        pulumi.set(self, "runtime_version", value)


@pulumi.input_type
class ImageRegistryCredentialArgs:
    def __init__(__self__, *,
                 password: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        Credential of the image registry
        :param pulumi.Input[str] password: The password of the image registry credential
        :param pulumi.Input[str] username: The username of the image registry credential
        """
        if password is not None:
            pulumi.set(__self__, "password", password)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The password of the image registry credential
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        The username of the image registry credential
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class KeyVaultCertificatePropertiesArgs:
    def __init__(__self__, *,
                 key_vault_cert_name: pulumi.Input[str],
                 type: pulumi.Input[str],
                 vault_uri: pulumi.Input[str],
                 cert_version: Optional[pulumi.Input[str]] = None,
                 exclude_private_key: Optional[pulumi.Input[bool]] = None):
        """
        Properties of certificate imported from key vault.
        :param pulumi.Input[str] key_vault_cert_name: The certificate name of key vault.
        :param pulumi.Input[str] type: The type of the certificate source.
               Expected value is 'KeyVaultCertificate'.
        :param pulumi.Input[str] vault_uri: The vault uri of user key vault.
        :param pulumi.Input[str] cert_version: The certificate version of key vault.
        :param pulumi.Input[bool] exclude_private_key: Optional. If set to true, it will not import private key from key vault.
        """
        pulumi.set(__self__, "key_vault_cert_name", key_vault_cert_name)
        pulumi.set(__self__, "type", 'KeyVaultCertificate')
        pulumi.set(__self__, "vault_uri", vault_uri)
        if cert_version is not None:
            pulumi.set(__self__, "cert_version", cert_version)
        if exclude_private_key is None:
            exclude_private_key = False
        if exclude_private_key is not None:
            pulumi.set(__self__, "exclude_private_key", exclude_private_key)

    @property
    @pulumi.getter(name="keyVaultCertName")
    def key_vault_cert_name(self) -> pulumi.Input[str]:
        """
        The certificate name of key vault.
        """
        return pulumi.get(self, "key_vault_cert_name")

    @key_vault_cert_name.setter
    def key_vault_cert_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "key_vault_cert_name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of the certificate source.
        Expected value is 'KeyVaultCertificate'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="vaultUri")
    def vault_uri(self) -> pulumi.Input[str]:
        """
        The vault uri of user key vault.
        """
        return pulumi.get(self, "vault_uri")

    @vault_uri.setter
    def vault_uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "vault_uri", value)

    @property
    @pulumi.getter(name="certVersion")
    def cert_version(self) -> Optional[pulumi.Input[str]]:
        """
        The certificate version of key vault.
        """
        return pulumi.get(self, "cert_version")

    @cert_version.setter
    def cert_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cert_version", value)

    @property
    @pulumi.getter(name="excludePrivateKey")
    def exclude_private_key(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. If set to true, it will not import private key from key vault.
        """
        return pulumi.get(self, "exclude_private_key")

    @exclude_private_key.setter
    def exclude_private_key(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "exclude_private_key", value)


@pulumi.input_type
class LoadedCertificateArgs:
    def __init__(__self__, *,
                 resource_id: pulumi.Input[str],
                 load_trust_store: Optional[pulumi.Input[bool]] = None):
        """
        Loaded certificate payload
        :param pulumi.Input[str] resource_id: Resource Id of loaded certificate
        :param pulumi.Input[bool] load_trust_store: Indicate whether the certificate will be loaded into default trust store, only work for Java runtime.
        """
        pulumi.set(__self__, "resource_id", resource_id)
        if load_trust_store is None:
            load_trust_store = False
        if load_trust_store is not None:
            pulumi.set(__self__, "load_trust_store", load_trust_store)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Input[str]:
        """
        Resource Id of loaded certificate
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_id", value)

    @property
    @pulumi.getter(name="loadTrustStore")
    def load_trust_store(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicate whether the certificate will be loaded into default trust store, only work for Java runtime.
        """
        return pulumi.get(self, "load_trust_store")

    @load_trust_store.setter
    def load_trust_store(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "load_trust_store", value)


@pulumi.input_type
class ManagedIdentityPropertiesArgs:
    def __init__(__self__, *,
                 principal_id: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[Union[str, 'ManagedIdentityType']]] = None):
        """
        Managed identity properties retrieved from ARM request headers.
        :param pulumi.Input[str] principal_id: Principal Id
        :param pulumi.Input[str] tenant_id: Tenant Id
        :param pulumi.Input[Union[str, 'ManagedIdentityType']] type: Type of the managed identity
        """
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[str]]:
        """
        Principal Id
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "principal_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        Tenant Id
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Union[str, 'ManagedIdentityType']]]:
        """
        Type of the managed identity
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Union[str, 'ManagedIdentityType']]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class NetworkProfileArgs:
    def __init__(__self__, *,
                 app_network_resource_group: Optional[pulumi.Input[str]] = None,
                 app_subnet_id: Optional[pulumi.Input[str]] = None,
                 service_cidr: Optional[pulumi.Input[str]] = None,
                 service_runtime_network_resource_group: Optional[pulumi.Input[str]] = None,
                 service_runtime_subnet_id: Optional[pulumi.Input[str]] = None):
        """
        Service network profile payload
        :param pulumi.Input[str] app_network_resource_group: Name of the resource group containing network resources of Azure Spring Cloud Apps
        :param pulumi.Input[str] app_subnet_id: Fully qualified resource Id of the subnet to host Azure Spring Cloud Apps
        :param pulumi.Input[str] service_cidr: Azure Spring Cloud service reserved CIDR
        :param pulumi.Input[str] service_runtime_network_resource_group: Name of the resource group containing network resources of Azure Spring Cloud Service Runtime
        :param pulumi.Input[str] service_runtime_subnet_id: Fully qualified resource Id of the subnet to host Azure Spring Cloud Service Runtime
        """
        if app_network_resource_group is not None:
            pulumi.set(__self__, "app_network_resource_group", app_network_resource_group)
        if app_subnet_id is not None:
            pulumi.set(__self__, "app_subnet_id", app_subnet_id)
        if service_cidr is not None:
            pulumi.set(__self__, "service_cidr", service_cidr)
        if service_runtime_network_resource_group is not None:
            pulumi.set(__self__, "service_runtime_network_resource_group", service_runtime_network_resource_group)
        if service_runtime_subnet_id is not None:
            pulumi.set(__self__, "service_runtime_subnet_id", service_runtime_subnet_id)

    @property
    @pulumi.getter(name="appNetworkResourceGroup")
    def app_network_resource_group(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the resource group containing network resources of Azure Spring Cloud Apps
        """
        return pulumi.get(self, "app_network_resource_group")

    @app_network_resource_group.setter
    def app_network_resource_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_network_resource_group", value)

    @property
    @pulumi.getter(name="appSubnetId")
    def app_subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        Fully qualified resource Id of the subnet to host Azure Spring Cloud Apps
        """
        return pulumi.get(self, "app_subnet_id")

    @app_subnet_id.setter
    def app_subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_subnet_id", value)

    @property
    @pulumi.getter(name="serviceCidr")
    def service_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        Azure Spring Cloud service reserved CIDR
        """
        return pulumi.get(self, "service_cidr")

    @service_cidr.setter
    def service_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_cidr", value)

    @property
    @pulumi.getter(name="serviceRuntimeNetworkResourceGroup")
    def service_runtime_network_resource_group(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the resource group containing network resources of Azure Spring Cloud Service Runtime
        """
        return pulumi.get(self, "service_runtime_network_resource_group")

    @service_runtime_network_resource_group.setter
    def service_runtime_network_resource_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_runtime_network_resource_group", value)

    @property
    @pulumi.getter(name="serviceRuntimeSubnetId")
    def service_runtime_subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        Fully qualified resource Id of the subnet to host Azure Spring Cloud Service Runtime
        """
        return pulumi.get(self, "service_runtime_subnet_id")

    @service_runtime_subnet_id.setter
    def service_runtime_subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_runtime_subnet_id", value)


@pulumi.input_type
class PersistentDiskArgs:
    def __init__(__self__, *,
                 mount_path: Optional[pulumi.Input[str]] = None,
                 size_in_gb: Optional[pulumi.Input[int]] = None):
        """
        Persistent disk payload
        :param pulumi.Input[str] mount_path: Mount path of the persistent disk
        :param pulumi.Input[int] size_in_gb: Size of the persistent disk in GB
        """
        if mount_path is not None:
            pulumi.set(__self__, "mount_path", mount_path)
        if size_in_gb is not None:
            pulumi.set(__self__, "size_in_gb", size_in_gb)

    @property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> Optional[pulumi.Input[str]]:
        """
        Mount path of the persistent disk
        """
        return pulumi.get(self, "mount_path")

    @mount_path.setter
    def mount_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mount_path", value)

    @property
    @pulumi.getter(name="sizeInGB")
    def size_in_gb(self) -> Optional[pulumi.Input[int]]:
        """
        Size of the persistent disk in GB
        """
        return pulumi.get(self, "size_in_gb")

    @size_in_gb.setter
    def size_in_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "size_in_gb", value)


@pulumi.input_type
class ResourceRequestsArgs:
    def __init__(__self__, *,
                 cpu: Optional[pulumi.Input[str]] = None,
                 memory: Optional[pulumi.Input[str]] = None):
        """
        Deployment resource request payload
        :param pulumi.Input[str] cpu: Required CPU. 1 core can be represented by 1 or 1000m. This should be 500m or 1 for Basic tier, and {500m, 1, 2, 3, 4} for Standard tier.
        :param pulumi.Input[str] memory: Required memory. 1 GB can be represented by 1Gi or 1024Mi. This should be {512Mi, 1Gi, 2Gi} for Basic tier, and {512Mi, 1Gi, 2Gi, ..., 8Gi} for Standard tier.
        """
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)

    @property
    @pulumi.getter
    def cpu(self) -> Optional[pulumi.Input[str]]:
        """
        Required CPU. 1 core can be represented by 1 or 1000m. This should be 500m or 1 for Basic tier, and {500m, 1, 2, 3, 4} for Standard tier.
        """
        return pulumi.get(self, "cpu")

    @cpu.setter
    def cpu(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cpu", value)

    @property
    @pulumi.getter
    def memory(self) -> Optional[pulumi.Input[str]]:
        """
        Required memory. 1 GB can be represented by 1Gi or 1024Mi. This should be {512Mi, 1Gi, 2Gi} for Basic tier, and {512Mi, 1Gi, 2Gi, ..., 8Gi} for Standard tier.
        """
        return pulumi.get(self, "memory")

    @memory.setter
    def memory(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "memory", value)


@pulumi.input_type
class SkuArgs:
    def __init__(__self__, *,
                 capacity: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tier: Optional[pulumi.Input[str]] = None):
        """
        Sku of Azure Spring Cloud
        :param pulumi.Input[int] capacity: Current capacity of the target resource
        :param pulumi.Input[str] name: Name of the Sku
        :param pulumi.Input[str] tier: Tier of the Sku
        """
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if name is None:
            name = 'S0'
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tier is None:
            tier = 'Standard'
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[int]]:
        """
        Current capacity of the target resource
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "capacity", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Sku
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tier(self) -> Optional[pulumi.Input[str]]:
        """
        Tier of the Sku
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tier", value)


@pulumi.input_type
class StorageAccountArgs:
    def __init__(__self__, *,
                 account_key: pulumi.Input[str],
                 account_name: pulumi.Input[str],
                 storage_type: pulumi.Input[str]):
        """
        storage resource of type Azure Storage Account.
        :param pulumi.Input[str] account_key: The account key of the Azure Storage Account.
        :param pulumi.Input[str] account_name: The account name of the Azure Storage Account.
        :param pulumi.Input[str] storage_type: The type of the storage.
               Expected value is 'StorageAccount'.
        """
        pulumi.set(__self__, "account_key", account_key)
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "storage_type", 'StorageAccount')

    @property
    @pulumi.getter(name="accountKey")
    def account_key(self) -> pulumi.Input[str]:
        """
        The account key of the Azure Storage Account.
        """
        return pulumi.get(self, "account_key")

    @account_key.setter
    def account_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "account_key", value)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Input[str]:
        """
        The account name of the Azure Storage Account.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "account_name", value)

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> pulumi.Input[str]:
        """
        The type of the storage.
        Expected value is 'StorageAccount'.
        """
        return pulumi.get(self, "storage_type")

    @storage_type.setter
    def storage_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "storage_type", value)


@pulumi.input_type
class TemporaryDiskArgs:
    def __init__(__self__, *,
                 mount_path: Optional[pulumi.Input[str]] = None,
                 size_in_gb: Optional[pulumi.Input[int]] = None):
        """
        Temporary disk payload
        :param pulumi.Input[str] mount_path: Mount path of the temporary disk
        :param pulumi.Input[int] size_in_gb: Size of the temporary disk in GB
        """
        if mount_path is None:
            mount_path = '/tmp'
        if mount_path is not None:
            pulumi.set(__self__, "mount_path", mount_path)
        if size_in_gb is not None:
            pulumi.set(__self__, "size_in_gb", size_in_gb)

    @property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> Optional[pulumi.Input[str]]:
        """
        Mount path of the temporary disk
        """
        return pulumi.get(self, "mount_path")

    @mount_path.setter
    def mount_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mount_path", value)

    @property
    @pulumi.getter(name="sizeInGB")
    def size_in_gb(self) -> Optional[pulumi.Input[int]]:
        """
        Size of the temporary disk in GB
        """
        return pulumi.get(self, "size_in_gb")

    @size_in_gb.setter
    def size_in_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "size_in_gb", value)


@pulumi.input_type
class UserSourceInfoArgs:
    def __init__(__self__, *,
                 artifact_selector: Optional[pulumi.Input[str]] = None,
                 custom_container: Optional[pulumi.Input['CustomContainerArgs']] = None,
                 relative_path: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[Union[str, 'UserSourceType']]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        Source information for a deployment
        :param pulumi.Input[str] artifact_selector: Selector for the artifact to be used for the deployment for multi-module projects. This should be
               the relative path to the target module/project.
        :param pulumi.Input['CustomContainerArgs'] custom_container: Custom container payload
        :param pulumi.Input[str] relative_path: Relative path of the storage which stores the source
        :param pulumi.Input[Union[str, 'UserSourceType']] type: Type of the source uploaded
        :param pulumi.Input[str] version: Version of the source
        """
        if artifact_selector is not None:
            pulumi.set(__self__, "artifact_selector", artifact_selector)
        if custom_container is not None:
            pulumi.set(__self__, "custom_container", custom_container)
        if relative_path is not None:
            pulumi.set(__self__, "relative_path", relative_path)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="artifactSelector")
    def artifact_selector(self) -> Optional[pulumi.Input[str]]:
        """
        Selector for the artifact to be used for the deployment for multi-module projects. This should be
        the relative path to the target module/project.
        """
        return pulumi.get(self, "artifact_selector")

    @artifact_selector.setter
    def artifact_selector(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "artifact_selector", value)

    @property
    @pulumi.getter(name="customContainer")
    def custom_container(self) -> Optional[pulumi.Input['CustomContainerArgs']]:
        """
        Custom container payload
        """
        return pulumi.get(self, "custom_container")

    @custom_container.setter
    def custom_container(self, value: Optional[pulumi.Input['CustomContainerArgs']]):
        pulumi.set(self, "custom_container", value)

    @property
    @pulumi.getter(name="relativePath")
    def relative_path(self) -> Optional[pulumi.Input[str]]:
        """
        Relative path of the storage which stores the source
        """
        return pulumi.get(self, "relative_path")

    @relative_path.setter
    def relative_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "relative_path", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Union[str, 'UserSourceType']]]:
        """
        Type of the source uploaded
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Union[str, 'UserSourceType']]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Version of the source
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


