# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AutoPausePropertiesResponse',
    'AutoScalePropertiesResponse',
    'AzureSkuResponse',
    'CmdkeySetupResponse',
    'ComponentSetupResponse',
    'CustomerManagedKeyDetailsResponse',
    'DataLakeStorageAccountDetailsResponse',
    'DatabaseStatisticsResponse',
    'DynamicExecutorAllocationResponse',
    'EncryptionDetailsResponse',
    'EntityReferenceResponse',
    'EnvironmentVariableSetupResponse',
    'IntegrationRuntimeComputePropertiesResponse',
    'IntegrationRuntimeCustomSetupScriptPropertiesResponse',
    'IntegrationRuntimeDataFlowPropertiesResponse',
    'IntegrationRuntimeDataProxyPropertiesResponse',
    'IntegrationRuntimeSsisCatalogInfoResponse',
    'IntegrationRuntimeSsisPropertiesResponse',
    'IntegrationRuntimeVNetPropertiesResponse',
    'LibraryInfoResponse',
    'LibraryRequirementsResponse',
    'LinkedIntegrationRuntimeKeyAuthorizationResponse',
    'LinkedIntegrationRuntimeRbacAuthorizationResponse',
    'LinkedIntegrationRuntimeResponse',
    'ManagedIdentityResponse',
    'ManagedIntegrationRuntimeErrorResponse',
    'ManagedIntegrationRuntimeNodeResponse',
    'ManagedIntegrationRuntimeOperationResultResponse',
    'ManagedIntegrationRuntimeResponse',
    'ManagedIntegrationRuntimeStatusResponse',
    'ManagedVirtualNetworkSettingsResponse',
    'PrivateEndpointConnectionForPrivateLinkHubBasicResponse',
    'PrivateEndpointConnectionResponse',
    'PrivateEndpointResponse',
    'PrivateLinkServiceConnectionStateResponse',
    'PurviewConfigurationResponse',
    'SecureStringResponse',
    'SelfHostedIntegrationRuntimeNodeResponse',
    'SelfHostedIntegrationRuntimeResponse',
    'SelfHostedIntegrationRuntimeStatusResponse',
    'SkuResponse',
    'SqlPoolVulnerabilityAssessmentRuleBaselineItemResponse',
    'SsisEnvironmentReferenceResponse',
    'SsisEnvironmentResponse',
    'SsisFolderResponse',
    'SsisPackageResponse',
    'SsisParameterResponse',
    'SsisProjectResponse',
    'SsisVariableResponse',
    'SystemDataResponse',
    'VirtualNetworkProfileResponse',
    'VulnerabilityAssessmentRecurringScansPropertiesResponse',
    'WorkspaceKeyDetailsResponse',
    'WorkspaceRepositoryConfigurationResponse',
]

@pulumi.output_type
class AutoPausePropertiesResponse(dict):
    """
    Auto-pausing properties of a Big Data pool powered by Apache Spark
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "delayInMinutes":
            suggest = "delay_in_minutes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoPausePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoPausePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoPausePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delay_in_minutes: Optional[int] = None,
                 enabled: Optional[bool] = None):
        """
        Auto-pausing properties of a Big Data pool powered by Apache Spark
        :param int delay_in_minutes: Number of minutes of idle time before the Big Data pool is automatically paused.
        :param bool enabled: Whether auto-pausing is enabled for the Big Data pool.
        """
        if delay_in_minutes is not None:
            pulumi.set(__self__, "delay_in_minutes", delay_in_minutes)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter(name="delayInMinutes")
    def delay_in_minutes(self) -> Optional[int]:
        """
        Number of minutes of idle time before the Big Data pool is automatically paused.
        """
        return pulumi.get(self, "delay_in_minutes")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Whether auto-pausing is enabled for the Big Data pool.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class AutoScalePropertiesResponse(dict):
    """
    Auto-scaling properties of a Big Data pool powered by Apache Spark
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxNodeCount":
            suggest = "max_node_count"
        elif key == "minNodeCount":
            suggest = "min_node_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoScalePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoScalePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoScalePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[bool] = None,
                 max_node_count: Optional[int] = None,
                 min_node_count: Optional[int] = None):
        """
        Auto-scaling properties of a Big Data pool powered by Apache Spark
        :param bool enabled: Whether automatic scaling is enabled for the Big Data pool.
        :param int max_node_count: The maximum number of nodes the Big Data pool can support.
        :param int min_node_count: The minimum number of nodes the Big Data pool can support.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if max_node_count is not None:
            pulumi.set(__self__, "max_node_count", max_node_count)
        if min_node_count is not None:
            pulumi.set(__self__, "min_node_count", min_node_count)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Whether automatic scaling is enabled for the Big Data pool.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="maxNodeCount")
    def max_node_count(self) -> Optional[int]:
        """
        The maximum number of nodes the Big Data pool can support.
        """
        return pulumi.get(self, "max_node_count")

    @property
    @pulumi.getter(name="minNodeCount")
    def min_node_count(self) -> Optional[int]:
        """
        The minimum number of nodes the Big Data pool can support.
        """
        return pulumi.get(self, "min_node_count")


@pulumi.output_type
class AzureSkuResponse(dict):
    """
    Azure SKU definition.
    """
    def __init__(__self__, *,
                 name: str,
                 tier: str,
                 capacity: Optional[int] = None):
        """
        Azure SKU definition.
        :param str name: SKU name.
        :param str tier: SKU tier.
        :param int capacity: The number of instances of the cluster.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "tier", tier)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        SKU name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tier(self) -> str:
        """
        SKU tier.
        """
        return pulumi.get(self, "tier")

    @property
    @pulumi.getter
    def capacity(self) -> Optional[int]:
        """
        The number of instances of the cluster.
        """
        return pulumi.get(self, "capacity")


@pulumi.output_type
class CmdkeySetupResponse(dict):
    """
    The custom setup of running cmdkey commands.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetName":
            suggest = "target_name"
        elif key == "userName":
            suggest = "user_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CmdkeySetupResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CmdkeySetupResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CmdkeySetupResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 password: 'outputs.SecureStringResponse',
                 target_name: Any,
                 type: str,
                 user_name: Any):
        """
        The custom setup of running cmdkey commands.
        :param 'SecureStringResponse' password: The password of data source access.
        :param Any target_name: The server name of data source access.
        :param str type: The type of custom setup.
               Expected value is 'CmdkeySetup'.
        :param Any user_name: The user name of data source access.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "target_name", target_name)
        pulumi.set(__self__, "type", 'CmdkeySetup')
        pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter
    def password(self) -> 'outputs.SecureStringResponse':
        """
        The password of data source access.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="targetName")
    def target_name(self) -> Any:
        """
        The server name of data source access.
        """
        return pulumi.get(self, "target_name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of custom setup.
        Expected value is 'CmdkeySetup'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Any:
        """
        The user name of data source access.
        """
        return pulumi.get(self, "user_name")


@pulumi.output_type
class ComponentSetupResponse(dict):
    """
    The custom setup of installing 3rd party components.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "componentName":
            suggest = "component_name"
        elif key == "licenseKey":
            suggest = "license_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComponentSetupResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComponentSetupResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComponentSetupResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 component_name: str,
                 type: str,
                 license_key: Optional['outputs.SecureStringResponse'] = None):
        """
        The custom setup of installing 3rd party components.
        :param str component_name: The name of the 3rd party component.
        :param str type: The type of custom setup.
               Expected value is 'ComponentSetup'.
        :param 'SecureStringResponse' license_key: The license key to activate the component.
        """
        pulumi.set(__self__, "component_name", component_name)
        pulumi.set(__self__, "type", 'ComponentSetup')
        if license_key is not None:
            pulumi.set(__self__, "license_key", license_key)

    @property
    @pulumi.getter(name="componentName")
    def component_name(self) -> str:
        """
        The name of the 3rd party component.
        """
        return pulumi.get(self, "component_name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of custom setup.
        Expected value is 'ComponentSetup'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="licenseKey")
    def license_key(self) -> Optional['outputs.SecureStringResponse']:
        """
        The license key to activate the component.
        """
        return pulumi.get(self, "license_key")


@pulumi.output_type
class CustomerManagedKeyDetailsResponse(dict):
    """
    Details of the customer managed key associated with the workspace
    """
    def __init__(__self__, *,
                 status: str,
                 key: Optional['outputs.WorkspaceKeyDetailsResponse'] = None):
        """
        Details of the customer managed key associated with the workspace
        :param str status: The customer managed key status on the workspace
        :param 'WorkspaceKeyDetailsResponse' key: The key object of the workspace
        """
        pulumi.set(__self__, "status", status)
        if key is not None:
            pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The customer managed key status on the workspace
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def key(self) -> Optional['outputs.WorkspaceKeyDetailsResponse']:
        """
        The key object of the workspace
        """
        return pulumi.get(self, "key")


@pulumi.output_type
class DataLakeStorageAccountDetailsResponse(dict):
    """
    Details of the data lake storage account associated with the workspace
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountUrl":
            suggest = "account_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataLakeStorageAccountDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataLakeStorageAccountDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataLakeStorageAccountDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_url: Optional[str] = None,
                 filesystem: Optional[str] = None):
        """
        Details of the data lake storage account associated with the workspace
        :param str account_url: Account URL
        :param str filesystem: Filesystem name
        """
        if account_url is not None:
            pulumi.set(__self__, "account_url", account_url)
        if filesystem is not None:
            pulumi.set(__self__, "filesystem", filesystem)

    @property
    @pulumi.getter(name="accountUrl")
    def account_url(self) -> Optional[str]:
        """
        Account URL
        """
        return pulumi.get(self, "account_url")

    @property
    @pulumi.getter
    def filesystem(self) -> Optional[str]:
        """
        Filesystem name
        """
        return pulumi.get(self, "filesystem")


@pulumi.output_type
class DatabaseStatisticsResponse(dict):
    """
    A class that contains database statistics information.
    """
    def __init__(__self__, *,
                 size: Optional[float] = None):
        """
        A class that contains database statistics information.
        :param float size: The database size - the total size of compressed data and index in bytes.
        """
        if size is not None:
            pulumi.set(__self__, "size", size)

    @property
    @pulumi.getter
    def size(self) -> Optional[float]:
        """
        The database size - the total size of compressed data and index in bytes.
        """
        return pulumi.get(self, "size")


@pulumi.output_type
class DynamicExecutorAllocationResponse(dict):
    """
    Dynamic Executor Allocation Properties
    """
    def __init__(__self__, *,
                 enabled: Optional[bool] = None):
        """
        Dynamic Executor Allocation Properties
        :param bool enabled: Indicates whether Dynamic Executor Allocation is enabled or not.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Indicates whether Dynamic Executor Allocation is enabled or not.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class EncryptionDetailsResponse(dict):
    """
    Details of the encryption associated with the workspace
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "doubleEncryptionEnabled":
            suggest = "double_encryption_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EncryptionDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EncryptionDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EncryptionDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 double_encryption_enabled: bool,
                 cmk: Optional['outputs.CustomerManagedKeyDetailsResponse'] = None):
        """
        Details of the encryption associated with the workspace
        :param bool double_encryption_enabled: Double Encryption enabled
        :param 'CustomerManagedKeyDetailsResponse' cmk: Customer Managed Key Details
        """
        pulumi.set(__self__, "double_encryption_enabled", double_encryption_enabled)
        if cmk is not None:
            pulumi.set(__self__, "cmk", cmk)

    @property
    @pulumi.getter(name="doubleEncryptionEnabled")
    def double_encryption_enabled(self) -> bool:
        """
        Double Encryption enabled
        """
        return pulumi.get(self, "double_encryption_enabled")

    @property
    @pulumi.getter
    def cmk(self) -> Optional['outputs.CustomerManagedKeyDetailsResponse']:
        """
        Customer Managed Key Details
        """
        return pulumi.get(self, "cmk")


@pulumi.output_type
class EntityReferenceResponse(dict):
    """
    The entity reference.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "referenceName":
            suggest = "reference_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EntityReferenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EntityReferenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EntityReferenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 reference_name: Optional[str] = None,
                 type: Optional[str] = None):
        """
        The entity reference.
        :param str reference_name: The name of this referenced entity.
        :param str type: The type of this referenced entity.
        """
        if reference_name is not None:
            pulumi.set(__self__, "reference_name", reference_name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="referenceName")
    def reference_name(self) -> Optional[str]:
        """
        The name of this referenced entity.
        """
        return pulumi.get(self, "reference_name")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of this referenced entity.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class EnvironmentVariableSetupResponse(dict):
    """
    The custom setup of setting environment variable.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "variableName":
            suggest = "variable_name"
        elif key == "variableValue":
            suggest = "variable_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvironmentVariableSetupResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvironmentVariableSetupResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvironmentVariableSetupResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 variable_name: str,
                 variable_value: str):
        """
        The custom setup of setting environment variable.
        :param str type: The type of custom setup.
               Expected value is 'EnvironmentVariableSetup'.
        :param str variable_name: The name of the environment variable.
        :param str variable_value: The value of the environment variable.
        """
        pulumi.set(__self__, "type", 'EnvironmentVariableSetup')
        pulumi.set(__self__, "variable_name", variable_name)
        pulumi.set(__self__, "variable_value", variable_value)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of custom setup.
        Expected value is 'EnvironmentVariableSetup'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="variableName")
    def variable_name(self) -> str:
        """
        The name of the environment variable.
        """
        return pulumi.get(self, "variable_name")

    @property
    @pulumi.getter(name="variableValue")
    def variable_value(self) -> str:
        """
        The value of the environment variable.
        """
        return pulumi.get(self, "variable_value")


@pulumi.output_type
class IntegrationRuntimeComputePropertiesResponse(dict):
    """
    The compute resource properties for managed integration runtime.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataFlowProperties":
            suggest = "data_flow_properties"
        elif key == "maxParallelExecutionsPerNode":
            suggest = "max_parallel_executions_per_node"
        elif key == "nodeSize":
            suggest = "node_size"
        elif key == "numberOfNodes":
            suggest = "number_of_nodes"
        elif key == "vNetProperties":
            suggest = "v_net_properties"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationRuntimeComputePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationRuntimeComputePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationRuntimeComputePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_flow_properties: Optional['outputs.IntegrationRuntimeDataFlowPropertiesResponse'] = None,
                 location: Optional[str] = None,
                 max_parallel_executions_per_node: Optional[int] = None,
                 node_size: Optional[str] = None,
                 number_of_nodes: Optional[int] = None,
                 v_net_properties: Optional['outputs.IntegrationRuntimeVNetPropertiesResponse'] = None):
        """
        The compute resource properties for managed integration runtime.
        :param 'IntegrationRuntimeDataFlowPropertiesResponse' data_flow_properties: Data flow properties for managed integration runtime.
        :param str location: The location for managed integration runtime. The supported regions could be found on https://docs.microsoft.com/en-us/azure/data-factory/data-factory-data-movement-activities
        :param int max_parallel_executions_per_node: Maximum parallel executions count per node for managed integration runtime.
        :param str node_size: The node size requirement to managed integration runtime.
        :param int number_of_nodes: The required number of nodes for managed integration runtime.
        :param 'IntegrationRuntimeVNetPropertiesResponse' v_net_properties: VNet properties for managed integration runtime.
        """
        if data_flow_properties is not None:
            pulumi.set(__self__, "data_flow_properties", data_flow_properties)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if max_parallel_executions_per_node is not None:
            pulumi.set(__self__, "max_parallel_executions_per_node", max_parallel_executions_per_node)
        if node_size is not None:
            pulumi.set(__self__, "node_size", node_size)
        if number_of_nodes is not None:
            pulumi.set(__self__, "number_of_nodes", number_of_nodes)
        if v_net_properties is not None:
            pulumi.set(__self__, "v_net_properties", v_net_properties)

    @property
    @pulumi.getter(name="dataFlowProperties")
    def data_flow_properties(self) -> Optional['outputs.IntegrationRuntimeDataFlowPropertiesResponse']:
        """
        Data flow properties for managed integration runtime.
        """
        return pulumi.get(self, "data_flow_properties")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        The location for managed integration runtime. The supported regions could be found on https://docs.microsoft.com/en-us/azure/data-factory/data-factory-data-movement-activities
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="maxParallelExecutionsPerNode")
    def max_parallel_executions_per_node(self) -> Optional[int]:
        """
        Maximum parallel executions count per node for managed integration runtime.
        """
        return pulumi.get(self, "max_parallel_executions_per_node")

    @property
    @pulumi.getter(name="nodeSize")
    def node_size(self) -> Optional[str]:
        """
        The node size requirement to managed integration runtime.
        """
        return pulumi.get(self, "node_size")

    @property
    @pulumi.getter(name="numberOfNodes")
    def number_of_nodes(self) -> Optional[int]:
        """
        The required number of nodes for managed integration runtime.
        """
        return pulumi.get(self, "number_of_nodes")

    @property
    @pulumi.getter(name="vNetProperties")
    def v_net_properties(self) -> Optional['outputs.IntegrationRuntimeVNetPropertiesResponse']:
        """
        VNet properties for managed integration runtime.
        """
        return pulumi.get(self, "v_net_properties")


@pulumi.output_type
class IntegrationRuntimeCustomSetupScriptPropertiesResponse(dict):
    """
    Custom setup script properties for a managed dedicated integration runtime.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "blobContainerUri":
            suggest = "blob_container_uri"
        elif key == "sasToken":
            suggest = "sas_token"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationRuntimeCustomSetupScriptPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationRuntimeCustomSetupScriptPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationRuntimeCustomSetupScriptPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 blob_container_uri: Optional[str] = None,
                 sas_token: Optional['outputs.SecureStringResponse'] = None):
        """
        Custom setup script properties for a managed dedicated integration runtime.
        :param str blob_container_uri: The URI of the Azure blob container that contains the custom setup script.
        :param 'SecureStringResponse' sas_token: The SAS token of the Azure blob container.
        """
        if blob_container_uri is not None:
            pulumi.set(__self__, "blob_container_uri", blob_container_uri)
        if sas_token is not None:
            pulumi.set(__self__, "sas_token", sas_token)

    @property
    @pulumi.getter(name="blobContainerUri")
    def blob_container_uri(self) -> Optional[str]:
        """
        The URI of the Azure blob container that contains the custom setup script.
        """
        return pulumi.get(self, "blob_container_uri")

    @property
    @pulumi.getter(name="sasToken")
    def sas_token(self) -> Optional['outputs.SecureStringResponse']:
        """
        The SAS token of the Azure blob container.
        """
        return pulumi.get(self, "sas_token")


@pulumi.output_type
class IntegrationRuntimeDataFlowPropertiesResponse(dict):
    """
    Data flow properties for managed integration runtime.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computeType":
            suggest = "compute_type"
        elif key == "coreCount":
            suggest = "core_count"
        elif key == "timeToLive":
            suggest = "time_to_live"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationRuntimeDataFlowPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationRuntimeDataFlowPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationRuntimeDataFlowPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compute_type: Optional[str] = None,
                 core_count: Optional[int] = None,
                 time_to_live: Optional[int] = None):
        """
        Data flow properties for managed integration runtime.
        :param str compute_type: Compute type of the cluster which will execute data flow job.
        :param int core_count: Core count of the cluster which will execute data flow job. Supported values are: 8, 16, 32, 48, 80, 144 and 272.
        :param int time_to_live: Time to live (in minutes) setting of the cluster which will execute data flow job.
        """
        if compute_type is not None:
            pulumi.set(__self__, "compute_type", compute_type)
        if core_count is not None:
            pulumi.set(__self__, "core_count", core_count)
        if time_to_live is not None:
            pulumi.set(__self__, "time_to_live", time_to_live)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> Optional[str]:
        """
        Compute type of the cluster which will execute data flow job.
        """
        return pulumi.get(self, "compute_type")

    @property
    @pulumi.getter(name="coreCount")
    def core_count(self) -> Optional[int]:
        """
        Core count of the cluster which will execute data flow job. Supported values are: 8, 16, 32, 48, 80, 144 and 272.
        """
        return pulumi.get(self, "core_count")

    @property
    @pulumi.getter(name="timeToLive")
    def time_to_live(self) -> Optional[int]:
        """
        Time to live (in minutes) setting of the cluster which will execute data flow job.
        """
        return pulumi.get(self, "time_to_live")


@pulumi.output_type
class IntegrationRuntimeDataProxyPropertiesResponse(dict):
    """
    Data proxy properties for a managed dedicated integration runtime.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectVia":
            suggest = "connect_via"
        elif key == "stagingLinkedService":
            suggest = "staging_linked_service"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationRuntimeDataProxyPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationRuntimeDataProxyPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationRuntimeDataProxyPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connect_via: Optional['outputs.EntityReferenceResponse'] = None,
                 path: Optional[str] = None,
                 staging_linked_service: Optional['outputs.EntityReferenceResponse'] = None):
        """
        Data proxy properties for a managed dedicated integration runtime.
        :param 'EntityReferenceResponse' connect_via: The self-hosted integration runtime reference.
        :param str path: The path to contain the staged data in the Blob storage.
        :param 'EntityReferenceResponse' staging_linked_service: The staging linked service reference.
        """
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if staging_linked_service is not None:
            pulumi.set(__self__, "staging_linked_service", staging_linked_service)

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional['outputs.EntityReferenceResponse']:
        """
        The self-hosted integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The path to contain the staged data in the Blob storage.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="stagingLinkedService")
    def staging_linked_service(self) -> Optional['outputs.EntityReferenceResponse']:
        """
        The staging linked service reference.
        """
        return pulumi.get(self, "staging_linked_service")


@pulumi.output_type
class IntegrationRuntimeSsisCatalogInfoResponse(dict):
    """
    Catalog information for managed dedicated integration runtime.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "catalogAdminPassword":
            suggest = "catalog_admin_password"
        elif key == "catalogAdminUserName":
            suggest = "catalog_admin_user_name"
        elif key == "catalogPricingTier":
            suggest = "catalog_pricing_tier"
        elif key == "catalogServerEndpoint":
            suggest = "catalog_server_endpoint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationRuntimeSsisCatalogInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationRuntimeSsisCatalogInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationRuntimeSsisCatalogInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 catalog_admin_password: Optional['outputs.SecureStringResponse'] = None,
                 catalog_admin_user_name: Optional[str] = None,
                 catalog_pricing_tier: Optional[str] = None,
                 catalog_server_endpoint: Optional[str] = None):
        """
        Catalog information for managed dedicated integration runtime.
        :param 'SecureStringResponse' catalog_admin_password: The password of the administrator user account of the catalog database.
        :param str catalog_admin_user_name: The administrator user name of catalog database.
        :param str catalog_pricing_tier: The pricing tier for the catalog database. The valid values could be found in https://azure.microsoft.com/en-us/pricing/details/sql-database/
        :param str catalog_server_endpoint: The catalog database server URL.
        """
        if catalog_admin_password is not None:
            pulumi.set(__self__, "catalog_admin_password", catalog_admin_password)
        if catalog_admin_user_name is not None:
            pulumi.set(__self__, "catalog_admin_user_name", catalog_admin_user_name)
        if catalog_pricing_tier is not None:
            pulumi.set(__self__, "catalog_pricing_tier", catalog_pricing_tier)
        if catalog_server_endpoint is not None:
            pulumi.set(__self__, "catalog_server_endpoint", catalog_server_endpoint)

    @property
    @pulumi.getter(name="catalogAdminPassword")
    def catalog_admin_password(self) -> Optional['outputs.SecureStringResponse']:
        """
        The password of the administrator user account of the catalog database.
        """
        return pulumi.get(self, "catalog_admin_password")

    @property
    @pulumi.getter(name="catalogAdminUserName")
    def catalog_admin_user_name(self) -> Optional[str]:
        """
        The administrator user name of catalog database.
        """
        return pulumi.get(self, "catalog_admin_user_name")

    @property
    @pulumi.getter(name="catalogPricingTier")
    def catalog_pricing_tier(self) -> Optional[str]:
        """
        The pricing tier for the catalog database. The valid values could be found in https://azure.microsoft.com/en-us/pricing/details/sql-database/
        """
        return pulumi.get(self, "catalog_pricing_tier")

    @property
    @pulumi.getter(name="catalogServerEndpoint")
    def catalog_server_endpoint(self) -> Optional[str]:
        """
        The catalog database server URL.
        """
        return pulumi.get(self, "catalog_server_endpoint")


@pulumi.output_type
class IntegrationRuntimeSsisPropertiesResponse(dict):
    """
    SSIS properties for managed integration runtime.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "catalogInfo":
            suggest = "catalog_info"
        elif key == "customSetupScriptProperties":
            suggest = "custom_setup_script_properties"
        elif key == "dataProxyProperties":
            suggest = "data_proxy_properties"
        elif key == "expressCustomSetupProperties":
            suggest = "express_custom_setup_properties"
        elif key == "licenseType":
            suggest = "license_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationRuntimeSsisPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationRuntimeSsisPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationRuntimeSsisPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 catalog_info: Optional['outputs.IntegrationRuntimeSsisCatalogInfoResponse'] = None,
                 custom_setup_script_properties: Optional['outputs.IntegrationRuntimeCustomSetupScriptPropertiesResponse'] = None,
                 data_proxy_properties: Optional['outputs.IntegrationRuntimeDataProxyPropertiesResponse'] = None,
                 edition: Optional[str] = None,
                 express_custom_setup_properties: Optional[Sequence[Any]] = None,
                 license_type: Optional[str] = None):
        """
        SSIS properties for managed integration runtime.
        :param 'IntegrationRuntimeSsisCatalogInfoResponse' catalog_info: Catalog information for managed dedicated integration runtime.
        :param 'IntegrationRuntimeCustomSetupScriptPropertiesResponse' custom_setup_script_properties: Custom setup script properties for a managed dedicated integration runtime.
        :param 'IntegrationRuntimeDataProxyPropertiesResponse' data_proxy_properties: Data proxy properties for a managed dedicated integration runtime.
        :param str edition: The edition for the SSIS Integration Runtime
        :param Sequence[Union['CmdkeySetupResponse', 'ComponentSetupResponse', 'EnvironmentVariableSetupResponse']] express_custom_setup_properties: Custom setup without script properties for a SSIS integration runtime.
        :param str license_type: License type for bringing your own license scenario.
        """
        if catalog_info is not None:
            pulumi.set(__self__, "catalog_info", catalog_info)
        if custom_setup_script_properties is not None:
            pulumi.set(__self__, "custom_setup_script_properties", custom_setup_script_properties)
        if data_proxy_properties is not None:
            pulumi.set(__self__, "data_proxy_properties", data_proxy_properties)
        if edition is not None:
            pulumi.set(__self__, "edition", edition)
        if express_custom_setup_properties is not None:
            pulumi.set(__self__, "express_custom_setup_properties", express_custom_setup_properties)
        if license_type is not None:
            pulumi.set(__self__, "license_type", license_type)

    @property
    @pulumi.getter(name="catalogInfo")
    def catalog_info(self) -> Optional['outputs.IntegrationRuntimeSsisCatalogInfoResponse']:
        """
        Catalog information for managed dedicated integration runtime.
        """
        return pulumi.get(self, "catalog_info")

    @property
    @pulumi.getter(name="customSetupScriptProperties")
    def custom_setup_script_properties(self) -> Optional['outputs.IntegrationRuntimeCustomSetupScriptPropertiesResponse']:
        """
        Custom setup script properties for a managed dedicated integration runtime.
        """
        return pulumi.get(self, "custom_setup_script_properties")

    @property
    @pulumi.getter(name="dataProxyProperties")
    def data_proxy_properties(self) -> Optional['outputs.IntegrationRuntimeDataProxyPropertiesResponse']:
        """
        Data proxy properties for a managed dedicated integration runtime.
        """
        return pulumi.get(self, "data_proxy_properties")

    @property
    @pulumi.getter
    def edition(self) -> Optional[str]:
        """
        The edition for the SSIS Integration Runtime
        """
        return pulumi.get(self, "edition")

    @property
    @pulumi.getter(name="expressCustomSetupProperties")
    def express_custom_setup_properties(self) -> Optional[Sequence[Any]]:
        """
        Custom setup without script properties for a SSIS integration runtime.
        """
        return pulumi.get(self, "express_custom_setup_properties")

    @property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> Optional[str]:
        """
        License type for bringing your own license scenario.
        """
        return pulumi.get(self, "license_type")


@pulumi.output_type
class IntegrationRuntimeVNetPropertiesResponse(dict):
    """
    VNet properties for managed integration runtime.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicIPs":
            suggest = "public_ips"
        elif key == "vNetId":
            suggest = "v_net_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationRuntimeVNetPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationRuntimeVNetPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationRuntimeVNetPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 public_ips: Optional[Sequence[str]] = None,
                 subnet: Optional[str] = None,
                 v_net_id: Optional[str] = None):
        """
        VNet properties for managed integration runtime.
        :param Sequence[str] public_ips: Resource IDs of the public IP addresses that this integration runtime will use.
        :param str subnet: The name of the subnet this integration runtime will join.
        :param str v_net_id: The ID of the VNet that this integration runtime will join.
        """
        if public_ips is not None:
            pulumi.set(__self__, "public_ips", public_ips)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)
        if v_net_id is not None:
            pulumi.set(__self__, "v_net_id", v_net_id)

    @property
    @pulumi.getter(name="publicIPs")
    def public_ips(self) -> Optional[Sequence[str]]:
        """
        Resource IDs of the public IP addresses that this integration runtime will use.
        """
        return pulumi.get(self, "public_ips")

    @property
    @pulumi.getter
    def subnet(self) -> Optional[str]:
        """
        The name of the subnet this integration runtime will join.
        """
        return pulumi.get(self, "subnet")

    @property
    @pulumi.getter(name="vNetId")
    def v_net_id(self) -> Optional[str]:
        """
        The ID of the VNet that this integration runtime will join.
        """
        return pulumi.get(self, "v_net_id")


@pulumi.output_type
class LibraryInfoResponse(dict):
    """
    Library/package information of a Big Data pool powered by Apache Spark
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "creatorId":
            suggest = "creator_id"
        elif key == "provisioningStatus":
            suggest = "provisioning_status"
        elif key == "uploadedTimestamp":
            suggest = "uploaded_timestamp"
        elif key == "containerName":
            suggest = "container_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LibraryInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LibraryInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LibraryInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 creator_id: str,
                 provisioning_status: str,
                 uploaded_timestamp: str,
                 container_name: Optional[str] = None,
                 name: Optional[str] = None,
                 path: Optional[str] = None,
                 type: Optional[str] = None):
        """
        Library/package information of a Big Data pool powered by Apache Spark
        :param str creator_id: Creator Id of the library/package.
        :param str provisioning_status: Provisioning status of the library/package.
        :param str uploaded_timestamp: The last update time of the library.
        :param str container_name: Storage blob container name.
        :param str name: Name of the library.
        :param str path: Storage blob path of library.
        :param str type: Type of the library.
        """
        pulumi.set(__self__, "creator_id", creator_id)
        pulumi.set(__self__, "provisioning_status", provisioning_status)
        pulumi.set(__self__, "uploaded_timestamp", uploaded_timestamp)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="creatorId")
    def creator_id(self) -> str:
        """
        Creator Id of the library/package.
        """
        return pulumi.get(self, "creator_id")

    @property
    @pulumi.getter(name="provisioningStatus")
    def provisioning_status(self) -> str:
        """
        Provisioning status of the library/package.
        """
        return pulumi.get(self, "provisioning_status")

    @property
    @pulumi.getter(name="uploadedTimestamp")
    def uploaded_timestamp(self) -> str:
        """
        The last update time of the library.
        """
        return pulumi.get(self, "uploaded_timestamp")

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[str]:
        """
        Storage blob container name.
        """
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the library.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        Storage blob path of library.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Type of the library.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class LibraryRequirementsResponse(dict):
    """
    Library requirements for a Big Data pool powered by Apache Spark
    """
    def __init__(__self__, *,
                 time: str,
                 content: Optional[str] = None,
                 filename: Optional[str] = None):
        """
        Library requirements for a Big Data pool powered by Apache Spark
        :param str time: The last update time of the library requirements file.
        :param str content: The library requirements.
        :param str filename: The filename of the library requirements file.
        """
        pulumi.set(__self__, "time", time)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if filename is not None:
            pulumi.set(__self__, "filename", filename)

    @property
    @pulumi.getter
    def time(self) -> str:
        """
        The last update time of the library requirements file.
        """
        return pulumi.get(self, "time")

    @property
    @pulumi.getter
    def content(self) -> Optional[str]:
        """
        The library requirements.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter
    def filename(self) -> Optional[str]:
        """
        The filename of the library requirements file.
        """
        return pulumi.get(self, "filename")


@pulumi.output_type
class LinkedIntegrationRuntimeKeyAuthorizationResponse(dict):
    """
    The key authorization type integration runtime.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorizationType":
            suggest = "authorization_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LinkedIntegrationRuntimeKeyAuthorizationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LinkedIntegrationRuntimeKeyAuthorizationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LinkedIntegrationRuntimeKeyAuthorizationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authorization_type: str,
                 key: 'outputs.SecureStringResponse'):
        """
        The key authorization type integration runtime.
        :param str authorization_type: The authorization type for integration runtime sharing.
               Expected value is 'Key'.
        :param 'SecureStringResponse' key: The key used for authorization.
        """
        pulumi.set(__self__, "authorization_type", 'Key')
        pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter(name="authorizationType")
    def authorization_type(self) -> str:
        """
        The authorization type for integration runtime sharing.
        Expected value is 'Key'.
        """
        return pulumi.get(self, "authorization_type")

    @property
    @pulumi.getter
    def key(self) -> 'outputs.SecureStringResponse':
        """
        The key used for authorization.
        """
        return pulumi.get(self, "key")


@pulumi.output_type
class LinkedIntegrationRuntimeRbacAuthorizationResponse(dict):
    """
    The role based access control (RBAC) authorization type integration runtime.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorizationType":
            suggest = "authorization_type"
        elif key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LinkedIntegrationRuntimeRbacAuthorizationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LinkedIntegrationRuntimeRbacAuthorizationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LinkedIntegrationRuntimeRbacAuthorizationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authorization_type: str,
                 resource_id: str):
        """
        The role based access control (RBAC) authorization type integration runtime.
        :param str authorization_type: The authorization type for integration runtime sharing.
               Expected value is 'RBAC'.
        :param str resource_id: The resource identifier of the integration runtime to be shared.
        """
        pulumi.set(__self__, "authorization_type", 'RBAC')
        pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="authorizationType")
    def authorization_type(self) -> str:
        """
        The authorization type for integration runtime sharing.
        Expected value is 'RBAC'.
        """
        return pulumi.get(self, "authorization_type")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> str:
        """
        The resource identifier of the integration runtime to be shared.
        """
        return pulumi.get(self, "resource_id")


@pulumi.output_type
class LinkedIntegrationRuntimeResponse(dict):
    """
    The linked integration runtime information.
    """
    def __init__(__self__, *,
                 create_time: str,
                 data_factory_location: str,
                 data_factory_name: str,
                 name: str,
                 subscription_id: str):
        """
        The linked integration runtime information.
        :param str create_time: The creating time of the linked integration runtime.
        :param str data_factory_location: The location of the workspace for which the linked integration runtime belong to.
        :param str data_factory_name: The name of the workspace for which the linked integration runtime belong to.
        :param str name: The name of the linked integration runtime.
        :param str subscription_id: The subscription ID for which the linked integration runtime belong to.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "data_factory_location", data_factory_location)
        pulumi.set(__self__, "data_factory_name", data_factory_name)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "subscription_id", subscription_id)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The creating time of the linked integration runtime.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="dataFactoryLocation")
    def data_factory_location(self) -> str:
        """
        The location of the workspace for which the linked integration runtime belong to.
        """
        return pulumi.get(self, "data_factory_location")

    @property
    @pulumi.getter(name="dataFactoryName")
    def data_factory_name(self) -> str:
        """
        The name of the workspace for which the linked integration runtime belong to.
        """
        return pulumi.get(self, "data_factory_name")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the linked integration runtime.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> str:
        """
        The subscription ID for which the linked integration runtime belong to.
        """
        return pulumi.get(self, "subscription_id")


@pulumi.output_type
class ManagedIdentityResponse(dict):
    """
    The workspace managed identity
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: str,
                 tenant_id: str,
                 type: Optional[str] = None):
        """
        The workspace managed identity
        :param str principal_id: The principal ID of the workspace managed identity
        :param str tenant_id: The tenant ID of the workspace managed identity
        :param str type: The type of managed identity for the workspace
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal ID of the workspace managed identity
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The tenant ID of the workspace managed identity
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of managed identity for the workspace
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ManagedIntegrationRuntimeErrorResponse(dict):
    """
    Error definition for managed integration runtime.
    """
    def __init__(__self__, *,
                 code: str,
                 message: str,
                 parameters: Sequence[str],
                 time: str):
        """
        Error definition for managed integration runtime.
        :param str code: Error code.
        :param str message: Error message.
        :param Sequence[str] parameters: Managed integration runtime error parameters.
        :param str time: The time when the error occurred.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "parameters", parameters)
        pulumi.set(__self__, "time", time)

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        Error code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Error message.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def parameters(self) -> Sequence[str]:
        """
        Managed integration runtime error parameters.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def time(self) -> str:
        """
        The time when the error occurred.
        """
        return pulumi.get(self, "time")


@pulumi.output_type
class ManagedIntegrationRuntimeNodeResponse(dict):
    """
    Properties of integration runtime node.
    """
    def __init__(__self__, *,
                 node_id: str,
                 status: str,
                 errors: Optional[Sequence['outputs.ManagedIntegrationRuntimeErrorResponse']] = None):
        """
        Properties of integration runtime node.
        :param str node_id: The managed integration runtime node id.
        :param str status: The managed integration runtime node status.
        :param Sequence['ManagedIntegrationRuntimeErrorResponse'] errors: The errors that occurred on this integration runtime node.
        """
        pulumi.set(__self__, "node_id", node_id)
        pulumi.set(__self__, "status", status)
        if errors is not None:
            pulumi.set(__self__, "errors", errors)

    @property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> str:
        """
        The managed integration runtime node id.
        """
        return pulumi.get(self, "node_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The managed integration runtime node status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def errors(self) -> Optional[Sequence['outputs.ManagedIntegrationRuntimeErrorResponse']]:
        """
        The errors that occurred on this integration runtime node.
        """
        return pulumi.get(self, "errors")


@pulumi.output_type
class ManagedIntegrationRuntimeOperationResultResponse(dict):
    """
    Properties of managed integration runtime operation result.
    """
    def __init__(__self__, *,
                 activity_id: str,
                 error_code: str,
                 parameters: Sequence[str],
                 result: str,
                 start_time: str,
                 type: str):
        """
        Properties of managed integration runtime operation result.
        :param str activity_id: The activity id for the operation request.
        :param str error_code: The error code.
        :param Sequence[str] parameters: Managed integration runtime error parameters.
        :param str result: The operation result.
        :param str start_time: The start time of the operation.
        :param str type: The operation type. Could be start or stop.
        """
        pulumi.set(__self__, "activity_id", activity_id)
        pulumi.set(__self__, "error_code", error_code)
        pulumi.set(__self__, "parameters", parameters)
        pulumi.set(__self__, "result", result)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="activityId")
    def activity_id(self) -> str:
        """
        The activity id for the operation request.
        """
        return pulumi.get(self, "activity_id")

    @property
    @pulumi.getter(name="errorCode")
    def error_code(self) -> str:
        """
        The error code.
        """
        return pulumi.get(self, "error_code")

    @property
    @pulumi.getter
    def parameters(self) -> Sequence[str]:
        """
        Managed integration runtime error parameters.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def result(self) -> str:
        """
        The operation result.
        """
        return pulumi.get(self, "result")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        The start time of the operation.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The operation type. Could be start or stop.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ManagedIntegrationRuntimeResponse(dict):
    """
    Managed integration runtime, including managed elastic and managed dedicated integration runtimes.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computeProperties":
            suggest = "compute_properties"
        elif key == "ssisProperties":
            suggest = "ssis_properties"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedIntegrationRuntimeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedIntegrationRuntimeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedIntegrationRuntimeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 state: str,
                 type: str,
                 compute_properties: Optional['outputs.IntegrationRuntimeComputePropertiesResponse'] = None,
                 description: Optional[str] = None,
                 ssis_properties: Optional['outputs.IntegrationRuntimeSsisPropertiesResponse'] = None):
        """
        Managed integration runtime, including managed elastic and managed dedicated integration runtimes.
        :param str state: Integration runtime state, only valid for managed dedicated integration runtime.
        :param str type: The type of integration runtime.
               Expected value is 'Managed'.
        :param 'IntegrationRuntimeComputePropertiesResponse' compute_properties: The compute resource for managed integration runtime.
        :param str description: Integration runtime description.
        :param 'IntegrationRuntimeSsisPropertiesResponse' ssis_properties: SSIS properties for managed integration runtime.
        """
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "type", 'Managed')
        if compute_properties is not None:
            pulumi.set(__self__, "compute_properties", compute_properties)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ssis_properties is not None:
            pulumi.set(__self__, "ssis_properties", ssis_properties)

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Integration runtime state, only valid for managed dedicated integration runtime.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of integration runtime.
        Expected value is 'Managed'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="computeProperties")
    def compute_properties(self) -> Optional['outputs.IntegrationRuntimeComputePropertiesResponse']:
        """
        The compute resource for managed integration runtime.
        """
        return pulumi.get(self, "compute_properties")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Integration runtime description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="ssisProperties")
    def ssis_properties(self) -> Optional['outputs.IntegrationRuntimeSsisPropertiesResponse']:
        """
        SSIS properties for managed integration runtime.
        """
        return pulumi.get(self, "ssis_properties")


@pulumi.output_type
class ManagedIntegrationRuntimeStatusResponse(dict):
    """
    Managed integration runtime status.
    """
    def __init__(__self__, *,
                 create_time: str,
                 data_factory_name: str,
                 last_operation: 'outputs.ManagedIntegrationRuntimeOperationResultResponse',
                 nodes: Sequence['outputs.ManagedIntegrationRuntimeNodeResponse'],
                 other_errors: Sequence['outputs.ManagedIntegrationRuntimeErrorResponse'],
                 state: str,
                 type: str):
        """
        Managed integration runtime status.
        :param str create_time: The time at which the integration runtime was created, in ISO8601 format.
        :param str data_factory_name: The workspace name which the integration runtime belong to.
        :param 'ManagedIntegrationRuntimeOperationResultResponse' last_operation: The last operation result that occurred on this integration runtime.
        :param Sequence['ManagedIntegrationRuntimeNodeResponse'] nodes: The list of nodes for managed integration runtime.
        :param Sequence['ManagedIntegrationRuntimeErrorResponse'] other_errors: The errors that occurred on this integration runtime.
        :param str state: The state of integration runtime.
        :param str type: The type of integration runtime.
               Expected value is 'Managed'.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "data_factory_name", data_factory_name)
        pulumi.set(__self__, "last_operation", last_operation)
        pulumi.set(__self__, "nodes", nodes)
        pulumi.set(__self__, "other_errors", other_errors)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "type", 'Managed')

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The time at which the integration runtime was created, in ISO8601 format.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="dataFactoryName")
    def data_factory_name(self) -> str:
        """
        The workspace name which the integration runtime belong to.
        """
        return pulumi.get(self, "data_factory_name")

    @property
    @pulumi.getter(name="lastOperation")
    def last_operation(self) -> 'outputs.ManagedIntegrationRuntimeOperationResultResponse':
        """
        The last operation result that occurred on this integration runtime.
        """
        return pulumi.get(self, "last_operation")

    @property
    @pulumi.getter
    def nodes(self) -> Sequence['outputs.ManagedIntegrationRuntimeNodeResponse']:
        """
        The list of nodes for managed integration runtime.
        """
        return pulumi.get(self, "nodes")

    @property
    @pulumi.getter(name="otherErrors")
    def other_errors(self) -> Sequence['outputs.ManagedIntegrationRuntimeErrorResponse']:
        """
        The errors that occurred on this integration runtime.
        """
        return pulumi.get(self, "other_errors")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of integration runtime.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of integration runtime.
        Expected value is 'Managed'.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ManagedVirtualNetworkSettingsResponse(dict):
    """
    Managed Virtual Network Settings
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedAadTenantIdsForLinking":
            suggest = "allowed_aad_tenant_ids_for_linking"
        elif key == "linkedAccessCheckOnTargetResource":
            suggest = "linked_access_check_on_target_resource"
        elif key == "preventDataExfiltration":
            suggest = "prevent_data_exfiltration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedVirtualNetworkSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedVirtualNetworkSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedVirtualNetworkSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_aad_tenant_ids_for_linking: Optional[Sequence[str]] = None,
                 linked_access_check_on_target_resource: Optional[bool] = None,
                 prevent_data_exfiltration: Optional[bool] = None):
        """
        Managed Virtual Network Settings
        :param Sequence[str] allowed_aad_tenant_ids_for_linking: Allowed Aad Tenant Ids For Linking
        :param bool linked_access_check_on_target_resource: Linked Access Check On Target Resource
        :param bool prevent_data_exfiltration: Prevent Data Exfiltration
        """
        if allowed_aad_tenant_ids_for_linking is not None:
            pulumi.set(__self__, "allowed_aad_tenant_ids_for_linking", allowed_aad_tenant_ids_for_linking)
        if linked_access_check_on_target_resource is not None:
            pulumi.set(__self__, "linked_access_check_on_target_resource", linked_access_check_on_target_resource)
        if prevent_data_exfiltration is not None:
            pulumi.set(__self__, "prevent_data_exfiltration", prevent_data_exfiltration)

    @property
    @pulumi.getter(name="allowedAadTenantIdsForLinking")
    def allowed_aad_tenant_ids_for_linking(self) -> Optional[Sequence[str]]:
        """
        Allowed Aad Tenant Ids For Linking
        """
        return pulumi.get(self, "allowed_aad_tenant_ids_for_linking")

    @property
    @pulumi.getter(name="linkedAccessCheckOnTargetResource")
    def linked_access_check_on_target_resource(self) -> Optional[bool]:
        """
        Linked Access Check On Target Resource
        """
        return pulumi.get(self, "linked_access_check_on_target_resource")

    @property
    @pulumi.getter(name="preventDataExfiltration")
    def prevent_data_exfiltration(self) -> Optional[bool]:
        """
        Prevent Data Exfiltration
        """
        return pulumi.get(self, "prevent_data_exfiltration")


@pulumi.output_type
class PrivateEndpointConnectionForPrivateLinkHubBasicResponse(dict):
    """
    Private Endpoint Connection For Private Link Hub - Basic
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "privateEndpoint":
            suggest = "private_endpoint"
        elif key == "privateLinkServiceConnectionState":
            suggest = "private_link_service_connection_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateEndpointConnectionForPrivateLinkHubBasicResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateEndpointConnectionForPrivateLinkHubBasicResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateEndpointConnectionForPrivateLinkHubBasicResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 provisioning_state: str,
                 private_endpoint: Optional['outputs.PrivateEndpointResponse'] = None,
                 private_link_service_connection_state: Optional['outputs.PrivateLinkServiceConnectionStateResponse'] = None):
        """
        Private Endpoint Connection For Private Link Hub - Basic
        :param str id: identifier
        :param str provisioning_state: Provisioning state of the private endpoint connection.
        :param 'PrivateEndpointResponse' private_endpoint: The private endpoint which the connection belongs to.
        :param 'PrivateLinkServiceConnectionStateResponse' private_link_service_connection_state: Connection state of the private endpoint connection.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if private_endpoint is not None:
            pulumi.set(__self__, "private_endpoint", private_endpoint)
        if private_link_service_connection_state is not None:
            pulumi.set(__self__, "private_link_service_connection_state", private_link_service_connection_state)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        identifier
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Provisioning state of the private endpoint connection.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="privateEndpoint")
    def private_endpoint(self) -> Optional['outputs.PrivateEndpointResponse']:
        """
        The private endpoint which the connection belongs to.
        """
        return pulumi.get(self, "private_endpoint")

    @property
    @pulumi.getter(name="privateLinkServiceConnectionState")
    def private_link_service_connection_state(self) -> Optional['outputs.PrivateLinkServiceConnectionStateResponse']:
        """
        Connection state of the private endpoint connection.
        """
        return pulumi.get(self, "private_link_service_connection_state")


@pulumi.output_type
class PrivateEndpointConnectionResponse(dict):
    """
    A private endpoint connection
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "privateEndpoint":
            suggest = "private_endpoint"
        elif key == "privateLinkServiceConnectionState":
            suggest = "private_link_service_connection_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateEndpointConnectionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateEndpointConnectionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateEndpointConnectionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 name: str,
                 provisioning_state: str,
                 type: str,
                 private_endpoint: Optional['outputs.PrivateEndpointResponse'] = None,
                 private_link_service_connection_state: Optional['outputs.PrivateLinkServiceConnectionStateResponse'] = None):
        """
        A private endpoint connection
        :param str id: Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
        :param str name: The name of the resource
        :param str provisioning_state: Provisioning state of the private endpoint connection.
        :param str type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        :param 'PrivateEndpointResponse' private_endpoint: The private endpoint which the connection belongs to.
        :param 'PrivateLinkServiceConnectionStateResponse' private_link_service_connection_state: Connection state of the private endpoint connection.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "type", type)
        if private_endpoint is not None:
            pulumi.set(__self__, "private_endpoint", private_endpoint)
        if private_link_service_connection_state is not None:
            pulumi.set(__self__, "private_link_service_connection_state", private_link_service_connection_state)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Provisioning state of the private endpoint connection.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="privateEndpoint")
    def private_endpoint(self) -> Optional['outputs.PrivateEndpointResponse']:
        """
        The private endpoint which the connection belongs to.
        """
        return pulumi.get(self, "private_endpoint")

    @property
    @pulumi.getter(name="privateLinkServiceConnectionState")
    def private_link_service_connection_state(self) -> Optional['outputs.PrivateLinkServiceConnectionStateResponse']:
        """
        Connection state of the private endpoint connection.
        """
        return pulumi.get(self, "private_link_service_connection_state")


@pulumi.output_type
class PrivateEndpointResponse(dict):
    """
    Private endpoint details
    """
    def __init__(__self__, *,
                 id: str):
        """
        Private endpoint details
        :param str id: Resource id of the private endpoint.
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Resource id of the private endpoint.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class PrivateLinkServiceConnectionStateResponse(dict):
    """
    Connection state details of the private endpoint
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionsRequired":
            suggest = "actions_required"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateLinkServiceConnectionStateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateLinkServiceConnectionStateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateLinkServiceConnectionStateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 actions_required: str,
                 description: Optional[str] = None,
                 status: Optional[str] = None):
        """
        Connection state details of the private endpoint
        :param str actions_required: The actions required for private link service connection.
        :param str description: The private link service connection description.
        :param str status: The private link service connection status.
        """
        pulumi.set(__self__, "actions_required", actions_required)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="actionsRequired")
    def actions_required(self) -> str:
        """
        The actions required for private link service connection.
        """
        return pulumi.get(self, "actions_required")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The private link service connection description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The private link service connection status.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class PurviewConfigurationResponse(dict):
    """
    Purview Configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "purviewResourceId":
            suggest = "purview_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PurviewConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PurviewConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PurviewConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 purview_resource_id: Optional[str] = None):
        """
        Purview Configuration
        :param str purview_resource_id: Purview Resource ID
        """
        if purview_resource_id is not None:
            pulumi.set(__self__, "purview_resource_id", purview_resource_id)

    @property
    @pulumi.getter(name="purviewResourceId")
    def purview_resource_id(self) -> Optional[str]:
        """
        Purview Resource ID
        """
        return pulumi.get(self, "purview_resource_id")


@pulumi.output_type
class SecureStringResponse(dict):
    """
    Azure Synapse secure string definition. The string value will be masked with asterisks '*' during Get or List API calls.
    """
    def __init__(__self__, *,
                 type: str,
                 value: str):
        """
        Azure Synapse secure string definition. The string value will be masked with asterisks '*' during Get or List API calls.
        :param str type: Type of the secret.
               Expected value is 'SecureString'.
        :param str value: Value of secure string.
        """
        pulumi.set(__self__, "type", 'SecureString')
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the secret.
        Expected value is 'SecureString'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Value of secure string.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class SelfHostedIntegrationRuntimeNodeResponse(dict):
    """
    Properties of Self-hosted integration runtime node.
    """
    def __init__(__self__, *,
                 capabilities: Mapping[str, str],
                 concurrent_jobs_limit: int,
                 expiry_time: str,
                 host_service_uri: str,
                 is_active_dispatcher: bool,
                 last_connect_time: str,
                 last_end_update_time: str,
                 last_start_time: str,
                 last_start_update_time: str,
                 last_stop_time: str,
                 last_update_result: str,
                 machine_name: str,
                 max_concurrent_jobs: int,
                 node_name: str,
                 register_time: str,
                 status: str,
                 version: str,
                 version_status: str):
        """
        Properties of Self-hosted integration runtime node.
        :param Mapping[str, str] capabilities: The integration runtime capabilities dictionary
        :param int concurrent_jobs_limit: Maximum concurrent jobs on the integration runtime node.
        :param str expiry_time: The time at which the integration runtime will expire in ISO8601 format.
        :param str host_service_uri: URI for the host machine of the integration runtime.
        :param bool is_active_dispatcher: Indicates whether this node is the active dispatcher for integration runtime requests.
        :param str last_connect_time: The most recent time at which the integration runtime was connected in ISO8601 format.
        :param str last_end_update_time: The last time for the integration runtime node update end.
        :param str last_start_time: The time the node last started up.
        :param str last_start_update_time: The last time for the integration runtime node update start.
        :param str last_stop_time: The integration runtime node last stop time.
        :param str last_update_result: The result of the last integration runtime node update.
        :param str machine_name: Machine name of the integration runtime node.
        :param int max_concurrent_jobs: The maximum concurrent jobs in this integration runtime.
        :param str node_name: Name of the integration runtime node.
        :param str register_time: The time at which the integration runtime node was registered in ISO8601 format.
        :param str status: Status of the integration runtime node.
        :param str version: Version of the integration runtime node.
        :param str version_status: Status of the integration runtime node version.
        """
        pulumi.set(__self__, "capabilities", capabilities)
        pulumi.set(__self__, "concurrent_jobs_limit", concurrent_jobs_limit)
        pulumi.set(__self__, "expiry_time", expiry_time)
        pulumi.set(__self__, "host_service_uri", host_service_uri)
        pulumi.set(__self__, "is_active_dispatcher", is_active_dispatcher)
        pulumi.set(__self__, "last_connect_time", last_connect_time)
        pulumi.set(__self__, "last_end_update_time", last_end_update_time)
        pulumi.set(__self__, "last_start_time", last_start_time)
        pulumi.set(__self__, "last_start_update_time", last_start_update_time)
        pulumi.set(__self__, "last_stop_time", last_stop_time)
        pulumi.set(__self__, "last_update_result", last_update_result)
        pulumi.set(__self__, "machine_name", machine_name)
        pulumi.set(__self__, "max_concurrent_jobs", max_concurrent_jobs)
        pulumi.set(__self__, "node_name", node_name)
        pulumi.set(__self__, "register_time", register_time)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "version", version)
        pulumi.set(__self__, "version_status", version_status)

    @property
    @pulumi.getter
    def capabilities(self) -> Mapping[str, str]:
        """
        The integration runtime capabilities dictionary
        """
        return pulumi.get(self, "capabilities")

    @property
    @pulumi.getter(name="concurrentJobsLimit")
    def concurrent_jobs_limit(self) -> int:
        """
        Maximum concurrent jobs on the integration runtime node.
        """
        return pulumi.get(self, "concurrent_jobs_limit")

    @property
    @pulumi.getter(name="expiryTime")
    def expiry_time(self) -> str:
        """
        The time at which the integration runtime will expire in ISO8601 format.
        """
        return pulumi.get(self, "expiry_time")

    @property
    @pulumi.getter(name="hostServiceUri")
    def host_service_uri(self) -> str:
        """
        URI for the host machine of the integration runtime.
        """
        return pulumi.get(self, "host_service_uri")

    @property
    @pulumi.getter(name="isActiveDispatcher")
    def is_active_dispatcher(self) -> bool:
        """
        Indicates whether this node is the active dispatcher for integration runtime requests.
        """
        return pulumi.get(self, "is_active_dispatcher")

    @property
    @pulumi.getter(name="lastConnectTime")
    def last_connect_time(self) -> str:
        """
        The most recent time at which the integration runtime was connected in ISO8601 format.
        """
        return pulumi.get(self, "last_connect_time")

    @property
    @pulumi.getter(name="lastEndUpdateTime")
    def last_end_update_time(self) -> str:
        """
        The last time for the integration runtime node update end.
        """
        return pulumi.get(self, "last_end_update_time")

    @property
    @pulumi.getter(name="lastStartTime")
    def last_start_time(self) -> str:
        """
        The time the node last started up.
        """
        return pulumi.get(self, "last_start_time")

    @property
    @pulumi.getter(name="lastStartUpdateTime")
    def last_start_update_time(self) -> str:
        """
        The last time for the integration runtime node update start.
        """
        return pulumi.get(self, "last_start_update_time")

    @property
    @pulumi.getter(name="lastStopTime")
    def last_stop_time(self) -> str:
        """
        The integration runtime node last stop time.
        """
        return pulumi.get(self, "last_stop_time")

    @property
    @pulumi.getter(name="lastUpdateResult")
    def last_update_result(self) -> str:
        """
        The result of the last integration runtime node update.
        """
        return pulumi.get(self, "last_update_result")

    @property
    @pulumi.getter(name="machineName")
    def machine_name(self) -> str:
        """
        Machine name of the integration runtime node.
        """
        return pulumi.get(self, "machine_name")

    @property
    @pulumi.getter(name="maxConcurrentJobs")
    def max_concurrent_jobs(self) -> int:
        """
        The maximum concurrent jobs in this integration runtime.
        """
        return pulumi.get(self, "max_concurrent_jobs")

    @property
    @pulumi.getter(name="nodeName")
    def node_name(self) -> str:
        """
        Name of the integration runtime node.
        """
        return pulumi.get(self, "node_name")

    @property
    @pulumi.getter(name="registerTime")
    def register_time(self) -> str:
        """
        The time at which the integration runtime node was registered in ISO8601 format.
        """
        return pulumi.get(self, "register_time")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of the integration runtime node.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        Version of the integration runtime node.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter(name="versionStatus")
    def version_status(self) -> str:
        """
        Status of the integration runtime node version.
        """
        return pulumi.get(self, "version_status")


@pulumi.output_type
class SelfHostedIntegrationRuntimeResponse(dict):
    """
    Self-hosted integration runtime.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "linkedInfo":
            suggest = "linked_info"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SelfHostedIntegrationRuntimeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SelfHostedIntegrationRuntimeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SelfHostedIntegrationRuntimeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 description: Optional[str] = None,
                 linked_info: Optional[Any] = None):
        """
        Self-hosted integration runtime.
        :param str type: The type of integration runtime.
               Expected value is 'SelfHosted'.
        :param str description: Integration runtime description.
        :param Union['LinkedIntegrationRuntimeKeyAuthorizationResponse', 'LinkedIntegrationRuntimeRbacAuthorizationResponse'] linked_info: Linked integration runtime type from data factory
        """
        pulumi.set(__self__, "type", 'SelfHosted')
        if description is not None:
            pulumi.set(__self__, "description", description)
        if linked_info is not None:
            pulumi.set(__self__, "linked_info", linked_info)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of integration runtime.
        Expected value is 'SelfHosted'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Integration runtime description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="linkedInfo")
    def linked_info(self) -> Optional[Any]:
        """
        Linked integration runtime type from data factory
        """
        return pulumi.get(self, "linked_info")


@pulumi.output_type
class SelfHostedIntegrationRuntimeStatusResponse(dict):
    """
    Self-hosted integration runtime status.
    """
    def __init__(__self__, *,
                 auto_update: str,
                 auto_update_eta: str,
                 capabilities: Mapping[str, str],
                 create_time: str,
                 data_factory_name: str,
                 internal_channel_encryption: str,
                 latest_version: str,
                 local_time_zone_offset: str,
                 node_communication_channel_encryption_mode: str,
                 pushed_version: str,
                 scheduled_update_date: str,
                 service_urls: Sequence[str],
                 state: str,
                 task_queue_id: str,
                 type: str,
                 update_delay_offset: str,
                 version: str,
                 version_status: str,
                 links: Optional[Sequence['outputs.LinkedIntegrationRuntimeResponse']] = None,
                 nodes: Optional[Sequence['outputs.SelfHostedIntegrationRuntimeNodeResponse']] = None):
        """
        Self-hosted integration runtime status.
        :param str auto_update: Whether Self-hosted integration runtime auto update has been turned on.
        :param str auto_update_eta: The estimated time when the self-hosted integration runtime will be updated.
        :param Mapping[str, str] capabilities: Object with additional information about integration runtime capabilities.
        :param str create_time: The time at which the integration runtime was created, in ISO8601 format.
        :param str data_factory_name: The workspace name which the integration runtime belong to.
        :param str internal_channel_encryption: It is used to set the encryption mode for node-node communication channel (when more than 2 self-hosted integration runtime nodes exist).
        :param str latest_version: The latest version on download center.
        :param str local_time_zone_offset: The local time zone offset in hours.
        :param str node_communication_channel_encryption_mode: The node communication Channel encryption mode
        :param str pushed_version: The version that the integration runtime is going to update to.
        :param str scheduled_update_date: The date at which the integration runtime will be scheduled to update, in ISO8601 format.
        :param Sequence[str] service_urls: The URLs for the services used in integration runtime backend service.
        :param str state: The state of integration runtime.
        :param str task_queue_id: The task queue id of the integration runtime.
        :param str type: The type of integration runtime.
               Expected value is 'SelfHosted'.
        :param str update_delay_offset: The time in the date scheduled by service to update the integration runtime, e.g., PT03H is 3 hours
        :param str version: Version of the integration runtime.
        :param str version_status: Status of the integration runtime version.
        :param Sequence['LinkedIntegrationRuntimeResponse'] links: The list of linked integration runtimes that are created to share with this integration runtime.
        :param Sequence['SelfHostedIntegrationRuntimeNodeResponse'] nodes: The list of nodes for this integration runtime.
        """
        pulumi.set(__self__, "auto_update", auto_update)
        pulumi.set(__self__, "auto_update_eta", auto_update_eta)
        pulumi.set(__self__, "capabilities", capabilities)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "data_factory_name", data_factory_name)
        pulumi.set(__self__, "internal_channel_encryption", internal_channel_encryption)
        pulumi.set(__self__, "latest_version", latest_version)
        pulumi.set(__self__, "local_time_zone_offset", local_time_zone_offset)
        pulumi.set(__self__, "node_communication_channel_encryption_mode", node_communication_channel_encryption_mode)
        pulumi.set(__self__, "pushed_version", pushed_version)
        pulumi.set(__self__, "scheduled_update_date", scheduled_update_date)
        pulumi.set(__self__, "service_urls", service_urls)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "task_queue_id", task_queue_id)
        pulumi.set(__self__, "type", 'SelfHosted')
        pulumi.set(__self__, "update_delay_offset", update_delay_offset)
        pulumi.set(__self__, "version", version)
        pulumi.set(__self__, "version_status", version_status)
        if links is not None:
            pulumi.set(__self__, "links", links)
        if nodes is not None:
            pulumi.set(__self__, "nodes", nodes)

    @property
    @pulumi.getter(name="autoUpdate")
    def auto_update(self) -> str:
        """
        Whether Self-hosted integration runtime auto update has been turned on.
        """
        return pulumi.get(self, "auto_update")

    @property
    @pulumi.getter(name="autoUpdateETA")
    def auto_update_eta(self) -> str:
        """
        The estimated time when the self-hosted integration runtime will be updated.
        """
        return pulumi.get(self, "auto_update_eta")

    @property
    @pulumi.getter
    def capabilities(self) -> Mapping[str, str]:
        """
        Object with additional information about integration runtime capabilities.
        """
        return pulumi.get(self, "capabilities")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The time at which the integration runtime was created, in ISO8601 format.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="dataFactoryName")
    def data_factory_name(self) -> str:
        """
        The workspace name which the integration runtime belong to.
        """
        return pulumi.get(self, "data_factory_name")

    @property
    @pulumi.getter(name="internalChannelEncryption")
    def internal_channel_encryption(self) -> str:
        """
        It is used to set the encryption mode for node-node communication channel (when more than 2 self-hosted integration runtime nodes exist).
        """
        return pulumi.get(self, "internal_channel_encryption")

    @property
    @pulumi.getter(name="latestVersion")
    def latest_version(self) -> str:
        """
        The latest version on download center.
        """
        return pulumi.get(self, "latest_version")

    @property
    @pulumi.getter(name="localTimeZoneOffset")
    def local_time_zone_offset(self) -> str:
        """
        The local time zone offset in hours.
        """
        return pulumi.get(self, "local_time_zone_offset")

    @property
    @pulumi.getter(name="nodeCommunicationChannelEncryptionMode")
    def node_communication_channel_encryption_mode(self) -> str:
        """
        The node communication Channel encryption mode
        """
        return pulumi.get(self, "node_communication_channel_encryption_mode")

    @property
    @pulumi.getter(name="pushedVersion")
    def pushed_version(self) -> str:
        """
        The version that the integration runtime is going to update to.
        """
        return pulumi.get(self, "pushed_version")

    @property
    @pulumi.getter(name="scheduledUpdateDate")
    def scheduled_update_date(self) -> str:
        """
        The date at which the integration runtime will be scheduled to update, in ISO8601 format.
        """
        return pulumi.get(self, "scheduled_update_date")

    @property
    @pulumi.getter(name="serviceUrls")
    def service_urls(self) -> Sequence[str]:
        """
        The URLs for the services used in integration runtime backend service.
        """
        return pulumi.get(self, "service_urls")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of integration runtime.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="taskQueueId")
    def task_queue_id(self) -> str:
        """
        The task queue id of the integration runtime.
        """
        return pulumi.get(self, "task_queue_id")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of integration runtime.
        Expected value is 'SelfHosted'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="updateDelayOffset")
    def update_delay_offset(self) -> str:
        """
        The time in the date scheduled by service to update the integration runtime, e.g., PT03H is 3 hours
        """
        return pulumi.get(self, "update_delay_offset")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        Version of the integration runtime.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter(name="versionStatus")
    def version_status(self) -> str:
        """
        Status of the integration runtime version.
        """
        return pulumi.get(self, "version_status")

    @property
    @pulumi.getter
    def links(self) -> Optional[Sequence['outputs.LinkedIntegrationRuntimeResponse']]:
        """
        The list of linked integration runtimes that are created to share with this integration runtime.
        """
        return pulumi.get(self, "links")

    @property
    @pulumi.getter
    def nodes(self) -> Optional[Sequence['outputs.SelfHostedIntegrationRuntimeNodeResponse']]:
        """
        The list of nodes for this integration runtime.
        """
        return pulumi.get(self, "nodes")


@pulumi.output_type
class SkuResponse(dict):
    """
    SQL pool SKU
    """
    def __init__(__self__, *,
                 capacity: Optional[int] = None,
                 name: Optional[str] = None,
                 tier: Optional[str] = None):
        """
        SQL pool SKU
        :param int capacity: If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the resource this may be omitted.
        :param str name: The SKU name
        :param str tier: The service tier
        """
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[int]:
        """
        If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the resource this may be omitted.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The SKU name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tier(self) -> Optional[str]:
        """
        The service tier
        """
        return pulumi.get(self, "tier")


@pulumi.output_type
class SqlPoolVulnerabilityAssessmentRuleBaselineItemResponse(dict):
    """
    Properties for an Sql pool vulnerability assessment rule baseline's result.
    """
    def __init__(__self__, *,
                 result: Sequence[str]):
        """
        Properties for an Sql pool vulnerability assessment rule baseline's result.
        :param Sequence[str] result: The rule baseline result
        """
        pulumi.set(__self__, "result", result)

    @property
    @pulumi.getter
    def result(self) -> Sequence[str]:
        """
        The rule baseline result
        """
        return pulumi.get(self, "result")


@pulumi.output_type
class SsisEnvironmentReferenceResponse(dict):
    """
    Ssis environment reference.
    """
    def __init__(__self__, *,
                 environment_folder_name: Optional[str] = None,
                 environment_name: Optional[str] = None,
                 id: Optional[float] = None,
                 reference_type: Optional[str] = None):
        """
        Ssis environment reference.
        :param str environment_folder_name: Environment folder name.
        :param str environment_name: Environment name.
        :param float id: Environment reference id.
        :param str reference_type: Reference type
        """
        if environment_folder_name is not None:
            pulumi.set(__self__, "environment_folder_name", environment_folder_name)
        if environment_name is not None:
            pulumi.set(__self__, "environment_name", environment_name)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if reference_type is not None:
            pulumi.set(__self__, "reference_type", reference_type)

    @property
    @pulumi.getter(name="environmentFolderName")
    def environment_folder_name(self) -> Optional[str]:
        """
        Environment folder name.
        """
        return pulumi.get(self, "environment_folder_name")

    @property
    @pulumi.getter(name="environmentName")
    def environment_name(self) -> Optional[str]:
        """
        Environment name.
        """
        return pulumi.get(self, "environment_name")

    @property
    @pulumi.getter
    def id(self) -> Optional[float]:
        """
        Environment reference id.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="referenceType")
    def reference_type(self) -> Optional[str]:
        """
        Reference type
        """
        return pulumi.get(self, "reference_type")


@pulumi.output_type
class SsisEnvironmentResponse(dict):
    """
    Ssis environment.
    """
    def __init__(__self__, *,
                 type: str,
                 description: Optional[str] = None,
                 folder_id: Optional[float] = None,
                 id: Optional[float] = None,
                 name: Optional[str] = None,
                 variables: Optional[Sequence['outputs.SsisVariableResponse']] = None):
        """
        Ssis environment.
        :param str type: The type of SSIS object metadata.
               Expected value is 'Environment'.
        :param str description: Metadata description.
        :param float folder_id: Folder id which contains environment.
        :param float id: Metadata id.
        :param str name: Metadata name.
        :param Sequence['SsisVariableResponse'] variables: Variable in environment
        """
        pulumi.set(__self__, "type", 'Environment')
        if description is not None:
            pulumi.set(__self__, "description", description)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if variables is not None:
            pulumi.set(__self__, "variables", variables)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of SSIS object metadata.
        Expected value is 'Environment'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Metadata description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[float]:
        """
        Folder id which contains environment.
        """
        return pulumi.get(self, "folder_id")

    @property
    @pulumi.getter
    def id(self) -> Optional[float]:
        """
        Metadata id.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Metadata name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def variables(self) -> Optional[Sequence['outputs.SsisVariableResponse']]:
        """
        Variable in environment
        """
        return pulumi.get(self, "variables")


@pulumi.output_type
class SsisFolderResponse(dict):
    """
    Ssis folder.
    """
    def __init__(__self__, *,
                 type: str,
                 description: Optional[str] = None,
                 id: Optional[float] = None,
                 name: Optional[str] = None):
        """
        Ssis folder.
        :param str type: The type of SSIS object metadata.
               Expected value is 'Folder'.
        :param str description: Metadata description.
        :param float id: Metadata id.
        :param str name: Metadata name.
        """
        pulumi.set(__self__, "type", 'Folder')
        if description is not None:
            pulumi.set(__self__, "description", description)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of SSIS object metadata.
        Expected value is 'Folder'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Metadata description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> Optional[float]:
        """
        Metadata id.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Metadata name.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class SsisPackageResponse(dict):
    """
    Ssis Package.
    """
    def __init__(__self__, *,
                 type: str,
                 description: Optional[str] = None,
                 folder_id: Optional[float] = None,
                 id: Optional[float] = None,
                 name: Optional[str] = None,
                 parameters: Optional[Sequence['outputs.SsisParameterResponse']] = None,
                 project_id: Optional[float] = None,
                 project_version: Optional[float] = None):
        """
        Ssis Package.
        :param str type: The type of SSIS object metadata.
               Expected value is 'Package'.
        :param str description: Metadata description.
        :param float folder_id: Folder id which contains package.
        :param float id: Metadata id.
        :param str name: Metadata name.
        :param Sequence['SsisParameterResponse'] parameters: Parameters in package
        :param float project_id: Project id which contains package.
        :param float project_version: Project version which contains package.
        """
        pulumi.set(__self__, "type", 'Package')
        if description is not None:
            pulumi.set(__self__, "description", description)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if project_version is not None:
            pulumi.set(__self__, "project_version", project_version)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of SSIS object metadata.
        Expected value is 'Package'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Metadata description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[float]:
        """
        Folder id which contains package.
        """
        return pulumi.get(self, "folder_id")

    @property
    @pulumi.getter
    def id(self) -> Optional[float]:
        """
        Metadata id.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Metadata name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Sequence['outputs.SsisParameterResponse']]:
        """
        Parameters in package
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[float]:
        """
        Project id which contains package.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="projectVersion")
    def project_version(self) -> Optional[float]:
        """
        Project version which contains package.
        """
        return pulumi.get(self, "project_version")


@pulumi.output_type
class SsisParameterResponse(dict):
    """
    Ssis parameter.
    """
    def __init__(__self__, *,
                 data_type: Optional[str] = None,
                 default_value: Optional[str] = None,
                 description: Optional[str] = None,
                 design_default_value: Optional[str] = None,
                 id: Optional[float] = None,
                 name: Optional[str] = None,
                 required: Optional[bool] = None,
                 sensitive: Optional[bool] = None,
                 sensitive_default_value: Optional[str] = None,
                 value_set: Optional[bool] = None,
                 value_type: Optional[str] = None,
                 variable: Optional[str] = None):
        """
        Ssis parameter.
        :param str data_type: Parameter type.
        :param str default_value: Default value of parameter.
        :param str description: Parameter description.
        :param str design_default_value: Design default value of parameter.
        :param float id: Parameter id.
        :param str name: Parameter name.
        :param bool required: Whether parameter is required.
        :param bool sensitive: Whether parameter is sensitive.
        :param str sensitive_default_value: Default sensitive value of parameter.
        :param bool value_set: Parameter value set.
        :param str value_type: Parameter value type.
        :param str variable: Parameter reference variable.
        """
        if data_type is not None:
            pulumi.set(__self__, "data_type", data_type)
        if default_value is not None:
            pulumi.set(__self__, "default_value", default_value)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if design_default_value is not None:
            pulumi.set(__self__, "design_default_value", design_default_value)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if required is not None:
            pulumi.set(__self__, "required", required)
        if sensitive is not None:
            pulumi.set(__self__, "sensitive", sensitive)
        if sensitive_default_value is not None:
            pulumi.set(__self__, "sensitive_default_value", sensitive_default_value)
        if value_set is not None:
            pulumi.set(__self__, "value_set", value_set)
        if value_type is not None:
            pulumi.set(__self__, "value_type", value_type)
        if variable is not None:
            pulumi.set(__self__, "variable", variable)

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> Optional[str]:
        """
        Parameter type.
        """
        return pulumi.get(self, "data_type")

    @property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> Optional[str]:
        """
        Default value of parameter.
        """
        return pulumi.get(self, "default_value")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Parameter description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="designDefaultValue")
    def design_default_value(self) -> Optional[str]:
        """
        Design default value of parameter.
        """
        return pulumi.get(self, "design_default_value")

    @property
    @pulumi.getter
    def id(self) -> Optional[float]:
        """
        Parameter id.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Parameter name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def required(self) -> Optional[bool]:
        """
        Whether parameter is required.
        """
        return pulumi.get(self, "required")

    @property
    @pulumi.getter
    def sensitive(self) -> Optional[bool]:
        """
        Whether parameter is sensitive.
        """
        return pulumi.get(self, "sensitive")

    @property
    @pulumi.getter(name="sensitiveDefaultValue")
    def sensitive_default_value(self) -> Optional[str]:
        """
        Default sensitive value of parameter.
        """
        return pulumi.get(self, "sensitive_default_value")

    @property
    @pulumi.getter(name="valueSet")
    def value_set(self) -> Optional[bool]:
        """
        Parameter value set.
        """
        return pulumi.get(self, "value_set")

    @property
    @pulumi.getter(name="valueType")
    def value_type(self) -> Optional[str]:
        """
        Parameter value type.
        """
        return pulumi.get(self, "value_type")

    @property
    @pulumi.getter
    def variable(self) -> Optional[str]:
        """
        Parameter reference variable.
        """
        return pulumi.get(self, "variable")


@pulumi.output_type
class SsisProjectResponse(dict):
    """
    Ssis project.
    """
    def __init__(__self__, *,
                 type: str,
                 description: Optional[str] = None,
                 environment_refs: Optional[Sequence['outputs.SsisEnvironmentReferenceResponse']] = None,
                 folder_id: Optional[float] = None,
                 id: Optional[float] = None,
                 name: Optional[str] = None,
                 parameters: Optional[Sequence['outputs.SsisParameterResponse']] = None,
                 version: Optional[float] = None):
        """
        Ssis project.
        :param str type: The type of SSIS object metadata.
               Expected value is 'Project'.
        :param str description: Metadata description.
        :param Sequence['SsisEnvironmentReferenceResponse'] environment_refs: Environment reference in project
        :param float folder_id: Folder id which contains project.
        :param float id: Metadata id.
        :param str name: Metadata name.
        :param Sequence['SsisParameterResponse'] parameters: Parameters in project
        :param float version: Project version.
        """
        pulumi.set(__self__, "type", 'Project')
        if description is not None:
            pulumi.set(__self__, "description", description)
        if environment_refs is not None:
            pulumi.set(__self__, "environment_refs", environment_refs)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of SSIS object metadata.
        Expected value is 'Project'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Metadata description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="environmentRefs")
    def environment_refs(self) -> Optional[Sequence['outputs.SsisEnvironmentReferenceResponse']]:
        """
        Environment reference in project
        """
        return pulumi.get(self, "environment_refs")

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[float]:
        """
        Folder id which contains project.
        """
        return pulumi.get(self, "folder_id")

    @property
    @pulumi.getter
    def id(self) -> Optional[float]:
        """
        Metadata id.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Metadata name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Sequence['outputs.SsisParameterResponse']]:
        """
        Parameters in project
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def version(self) -> Optional[float]:
        """
        Project version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class SsisVariableResponse(dict):
    """
    Ssis variable.
    """
    def __init__(__self__, *,
                 data_type: Optional[str] = None,
                 description: Optional[str] = None,
                 id: Optional[float] = None,
                 name: Optional[str] = None,
                 sensitive: Optional[bool] = None,
                 sensitive_value: Optional[str] = None,
                 value: Optional[str] = None):
        """
        Ssis variable.
        :param str data_type: Variable type.
        :param str description: Variable description.
        :param float id: Variable id.
        :param str name: Variable name.
        :param bool sensitive: Whether variable is sensitive.
        :param str sensitive_value: Variable sensitive value.
        :param str value: Variable value.
        """
        if data_type is not None:
            pulumi.set(__self__, "data_type", data_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if sensitive is not None:
            pulumi.set(__self__, "sensitive", sensitive)
        if sensitive_value is not None:
            pulumi.set(__self__, "sensitive_value", sensitive_value)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> Optional[str]:
        """
        Variable type.
        """
        return pulumi.get(self, "data_type")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Variable description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> Optional[float]:
        """
        Variable id.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Variable name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def sensitive(self) -> Optional[bool]:
        """
        Whether variable is sensitive.
        """
        return pulumi.get(self, "sensitive")

    @property
    @pulumi.getter(name="sensitiveValue")
    def sensitive_value(self) -> Optional[str]:
        """
        Variable sensitive value.
        """
        return pulumi.get(self, "sensitive_value")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        Variable value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The timestamp of resource last modification (UTC)
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The timestamp of resource last modification (UTC)
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


@pulumi.output_type
class VirtualNetworkProfileResponse(dict):
    """
    Virtual Network Profile
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computeSubnetId":
            suggest = "compute_subnet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualNetworkProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualNetworkProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualNetworkProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compute_subnet_id: Optional[str] = None):
        """
        Virtual Network Profile
        :param str compute_subnet_id: Subnet ID used for computes in workspace
        """
        if compute_subnet_id is not None:
            pulumi.set(__self__, "compute_subnet_id", compute_subnet_id)

    @property
    @pulumi.getter(name="computeSubnetId")
    def compute_subnet_id(self) -> Optional[str]:
        """
        Subnet ID used for computes in workspace
        """
        return pulumi.get(self, "compute_subnet_id")


@pulumi.output_type
class VulnerabilityAssessmentRecurringScansPropertiesResponse(dict):
    """
    Properties of a Vulnerability Assessment recurring scans.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "emailSubscriptionAdmins":
            suggest = "email_subscription_admins"
        elif key == "isEnabled":
            suggest = "is_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VulnerabilityAssessmentRecurringScansPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VulnerabilityAssessmentRecurringScansPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VulnerabilityAssessmentRecurringScansPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 email_subscription_admins: Optional[bool] = None,
                 emails: Optional[Sequence[str]] = None,
                 is_enabled: Optional[bool] = None):
        """
        Properties of a Vulnerability Assessment recurring scans.
        :param bool email_subscription_admins: Specifies that the schedule scan notification will be is sent to the subscription administrators.
        :param Sequence[str] emails: Specifies an array of e-mail addresses to which the scan notification is sent.
        :param bool is_enabled: Recurring scans state.
        """
        if email_subscription_admins is None:
            email_subscription_admins = True
        if email_subscription_admins is not None:
            pulumi.set(__self__, "email_subscription_admins", email_subscription_admins)
        if emails is not None:
            pulumi.set(__self__, "emails", emails)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)

    @property
    @pulumi.getter(name="emailSubscriptionAdmins")
    def email_subscription_admins(self) -> Optional[bool]:
        """
        Specifies that the schedule scan notification will be is sent to the subscription administrators.
        """
        return pulumi.get(self, "email_subscription_admins")

    @property
    @pulumi.getter
    def emails(self) -> Optional[Sequence[str]]:
        """
        Specifies an array of e-mail addresses to which the scan notification is sent.
        """
        return pulumi.get(self, "emails")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[bool]:
        """
        Recurring scans state.
        """
        return pulumi.get(self, "is_enabled")


@pulumi.output_type
class WorkspaceKeyDetailsResponse(dict):
    """
    Details of the customer managed key associated with the workspace
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyVaultUrl":
            suggest = "key_vault_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkspaceKeyDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkspaceKeyDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkspaceKeyDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_vault_url: Optional[str] = None,
                 name: Optional[str] = None):
        """
        Details of the customer managed key associated with the workspace
        :param str key_vault_url: Workspace Key sub-resource key vault url
        :param str name: Workspace Key sub-resource name
        """
        if key_vault_url is not None:
            pulumi.set(__self__, "key_vault_url", key_vault_url)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="keyVaultUrl")
    def key_vault_url(self) -> Optional[str]:
        """
        Workspace Key sub-resource key vault url
        """
        return pulumi.get(self, "key_vault_url")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Workspace Key sub-resource name
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class WorkspaceRepositoryConfigurationResponse(dict):
    """
    Git integration settings
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountName":
            suggest = "account_name"
        elif key == "collaborationBranch":
            suggest = "collaboration_branch"
        elif key == "hostName":
            suggest = "host_name"
        elif key == "lastCommitId":
            suggest = "last_commit_id"
        elif key == "projectName":
            suggest = "project_name"
        elif key == "repositoryName":
            suggest = "repository_name"
        elif key == "rootFolder":
            suggest = "root_folder"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkspaceRepositoryConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkspaceRepositoryConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkspaceRepositoryConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_name: Optional[str] = None,
                 collaboration_branch: Optional[str] = None,
                 host_name: Optional[str] = None,
                 last_commit_id: Optional[str] = None,
                 project_name: Optional[str] = None,
                 repository_name: Optional[str] = None,
                 root_folder: Optional[str] = None,
                 tenant_id: Optional[str] = None,
                 type: Optional[str] = None):
        """
        Git integration settings
        :param str account_name: Account name
        :param str collaboration_branch: Collaboration branch
        :param str host_name: GitHub Enterprise host name. For example: https://github.mydomain.com
        :param str last_commit_id: The last commit ID
        :param str project_name: VSTS project name
        :param str repository_name: Repository name
        :param str root_folder: Root folder to use in the repository
        :param str tenant_id: The VSTS tenant ID
        :param str type: Type of workspace repositoryID configuration. Example WorkspaceVSTSConfiguration, WorkspaceGitHubConfiguration
        """
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if collaboration_branch is not None:
            pulumi.set(__self__, "collaboration_branch", collaboration_branch)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if last_commit_id is not None:
            pulumi.set(__self__, "last_commit_id", last_commit_id)
        if project_name is not None:
            pulumi.set(__self__, "project_name", project_name)
        if repository_name is not None:
            pulumi.set(__self__, "repository_name", repository_name)
        if root_folder is not None:
            pulumi.set(__self__, "root_folder", root_folder)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[str]:
        """
        Account name
        """
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter(name="collaborationBranch")
    def collaboration_branch(self) -> Optional[str]:
        """
        Collaboration branch
        """
        return pulumi.get(self, "collaboration_branch")

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[str]:
        """
        GitHub Enterprise host name. For example: https://github.mydomain.com
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter(name="lastCommitId")
    def last_commit_id(self) -> Optional[str]:
        """
        The last commit ID
        """
        return pulumi.get(self, "last_commit_id")

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[str]:
        """
        VSTS project name
        """
        return pulumi.get(self, "project_name")

    @property
    @pulumi.getter(name="repositoryName")
    def repository_name(self) -> Optional[str]:
        """
        Repository name
        """
        return pulumi.get(self, "repository_name")

    @property
    @pulumi.getter(name="rootFolder")
    def root_folder(self) -> Optional[str]:
        """
        Root folder to use in the repository
        """
        return pulumi.get(self, "root_folder")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[str]:
        """
        The VSTS tenant ID
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Type of workspace repositoryID configuration. Example WorkspaceVSTSConfiguration, WorkspaceGitHubConfiguration
        """
        return pulumi.get(self, "type")


