# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'ImageTemplateFileCustomizerArgs',
    'ImageTemplateIdentityArgs',
    'ImageTemplateManagedImageDistributorArgs',
    'ImageTemplateManagedImageSourceArgs',
    'ImageTemplatePlatformImageSourceArgs',
    'ImageTemplatePowerShellCustomizerArgs',
    'ImageTemplateRestartCustomizerArgs',
    'ImageTemplateSharedImageDistributorArgs',
    'ImageTemplateSharedImageVersionSourceArgs',
    'ImageTemplateShellCustomizerArgs',
    'ImageTemplateVhdDistributorArgs',
    'ImageTemplateVmProfileArgs',
    'ImageTemplateWindowsUpdateCustomizerArgs',
    'PlatformImagePurchasePlanArgs',
    'VirtualNetworkConfigArgs',
]

@pulumi.input_type
class ImageTemplateFileCustomizerArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 destination: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 sha256_checksum: Optional[pulumi.Input[str]] = None,
                 source_uri: Optional[pulumi.Input[str]] = None):
        """
        Uploads files to VMs (Linux, Windows). Corresponds to Packer file provisioner
        :param pulumi.Input[str] type: The type of customization tool you want to use on the Image. For example, "Shell" can be shell customizer
               Expected value is 'File'.
        :param pulumi.Input[str] destination: The absolute path to a file (with nested directory structures already created) where the file (from sourceUri) will be uploaded to in the VM
        :param pulumi.Input[str] name: Friendly Name to provide context on what this customization step does
        :param pulumi.Input[str] sha256_checksum: SHA256 checksum of the file provided in the sourceUri field above
        :param pulumi.Input[str] source_uri: The URI of the file to be uploaded for customizing the VM. It can be a github link, SAS URI for Azure Storage, etc
        """
        pulumi.set(__self__, "type", 'File')
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if sha256_checksum is None:
            sha256_checksum = ''
        if sha256_checksum is not None:
            pulumi.set(__self__, "sha256_checksum", sha256_checksum)
        if source_uri is not None:
            pulumi.set(__self__, "source_uri", source_uri)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of customization tool you want to use on the Image. For example, "Shell" can be shell customizer
        Expected value is 'File'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def destination(self) -> Optional[pulumi.Input[str]]:
        """
        The absolute path to a file (with nested directory structures already created) where the file (from sourceUri) will be uploaded to in the VM
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Friendly Name to provide context on what this customization step does
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="sha256Checksum")
    def sha256_checksum(self) -> Optional[pulumi.Input[str]]:
        """
        SHA256 checksum of the file provided in the sourceUri field above
        """
        return pulumi.get(self, "sha256_checksum")

    @sha256_checksum.setter
    def sha256_checksum(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sha256_checksum", value)

    @property
    @pulumi.getter(name="sourceUri")
    def source_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The URI of the file to be uploaded for customizing the VM. It can be a github link, SAS URI for Azure Storage, etc
        """
        return pulumi.get(self, "source_uri")

    @source_uri.setter
    def source_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_uri", value)


@pulumi.input_type
class ImageTemplateIdentityArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input['ResourceIdentityType']] = None,
                 user_assigned_identities: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        Identity for the image template.
        :param pulumi.Input['ResourceIdentityType'] type: The type of identity used for the image template. The type 'None' will remove any identities from the image template.
        :param pulumi.Input[Mapping[str, Any]] user_assigned_identities: The list of user identities associated with the image template. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['ResourceIdentityType']]:
        """
        The type of identity used for the image template. The type 'None' will remove any identities from the image template.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['ResourceIdentityType']]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        The list of user identities associated with the image template. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        """
        return pulumi.get(self, "user_assigned_identities")

    @user_assigned_identities.setter
    def user_assigned_identities(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "user_assigned_identities", value)


@pulumi.input_type
class ImageTemplateManagedImageDistributorArgs:
    def __init__(__self__, *,
                 image_id: pulumi.Input[str],
                 location: pulumi.Input[str],
                 run_output_name: pulumi.Input[str],
                 type: pulumi.Input[str],
                 artifact_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Distribute as a Managed Disk Image.
        :param pulumi.Input[str] image_id: Resource Id of the Managed Disk Image
        :param pulumi.Input[str] location: Azure location for the image, should match if image already exists
        :param pulumi.Input[str] run_output_name: The name to be used for the associated RunOutput.
        :param pulumi.Input[str] type: Type of distribution.
               Expected value is 'ManagedImage'.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] artifact_tags: Tags that will be applied to the artifact once it has been created/updated by the distributor.
        """
        pulumi.set(__self__, "image_id", image_id)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "run_output_name", run_output_name)
        pulumi.set(__self__, "type", 'ManagedImage')
        if artifact_tags is not None:
            pulumi.set(__self__, "artifact_tags", artifact_tags)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Input[str]:
        """
        Resource Id of the Managed Disk Image
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[str]:
        """
        Azure location for the image, should match if image already exists
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="runOutputName")
    def run_output_name(self) -> pulumi.Input[str]:
        """
        The name to be used for the associated RunOutput.
        """
        return pulumi.get(self, "run_output_name")

    @run_output_name.setter
    def run_output_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "run_output_name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of distribution.
        Expected value is 'ManagedImage'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="artifactTags")
    def artifact_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Tags that will be applied to the artifact once it has been created/updated by the distributor.
        """
        return pulumi.get(self, "artifact_tags")

    @artifact_tags.setter
    def artifact_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "artifact_tags", value)


@pulumi.input_type
class ImageTemplateManagedImageSourceArgs:
    def __init__(__self__, *,
                 image_id: pulumi.Input[str],
                 type: pulumi.Input[str]):
        """
        Describes an image source that is a managed image in customer subscription.
        :param pulumi.Input[str] image_id: ARM resource id of the managed image in customer subscription
        :param pulumi.Input[str] type: Specifies the type of source image you want to start with.
               Expected value is 'ManagedImage'.
        """
        pulumi.set(__self__, "image_id", image_id)
        pulumi.set(__self__, "type", 'ManagedImage')

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Input[str]:
        """
        ARM resource id of the managed image in customer subscription
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Specifies the type of source image you want to start with.
        Expected value is 'ManagedImage'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class ImageTemplatePlatformImageSourceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 offer: Optional[pulumi.Input[str]] = None,
                 plan_info: Optional[pulumi.Input['PlatformImagePurchasePlanArgs']] = None,
                 publisher: Optional[pulumi.Input[str]] = None,
                 sku: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        Describes an image source from [Azure Gallery Images](https://docs.microsoft.com/en-us/rest/api/compute/virtualmachineimages).
        :param pulumi.Input[str] type: Specifies the type of source image you want to start with.
               Expected value is 'PlatformImage'.
        :param pulumi.Input[str] offer: Image offer from the [Azure Gallery Images](https://docs.microsoft.com/en-us/rest/api/compute/virtualmachineimages).
        :param pulumi.Input['PlatformImagePurchasePlanArgs'] plan_info: Optional configuration of purchase plan for platform image.
        :param pulumi.Input[str] publisher: Image Publisher in [Azure Gallery Images](https://docs.microsoft.com/en-us/rest/api/compute/virtualmachineimages).
        :param pulumi.Input[str] sku: Image sku from the [Azure Gallery Images](https://docs.microsoft.com/en-us/rest/api/compute/virtualmachineimages).
        :param pulumi.Input[str] version: Image version from the [Azure Gallery Images](https://docs.microsoft.com/en-us/rest/api/compute/virtualmachineimages). If 'latest' is specified here, the version is evaluated when the image build takes place, not when the template is submitted. Specifying 'latest' could cause ROUNDTRIP_INCONSISTENT_PROPERTY issue which will be fixed.
        """
        pulumi.set(__self__, "type", 'PlatformImage')
        if offer is not None:
            pulumi.set(__self__, "offer", offer)
        if plan_info is not None:
            pulumi.set(__self__, "plan_info", plan_info)
        if publisher is not None:
            pulumi.set(__self__, "publisher", publisher)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Specifies the type of source image you want to start with.
        Expected value is 'PlatformImage'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def offer(self) -> Optional[pulumi.Input[str]]:
        """
        Image offer from the [Azure Gallery Images](https://docs.microsoft.com/en-us/rest/api/compute/virtualmachineimages).
        """
        return pulumi.get(self, "offer")

    @offer.setter
    def offer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "offer", value)

    @property
    @pulumi.getter(name="planInfo")
    def plan_info(self) -> Optional[pulumi.Input['PlatformImagePurchasePlanArgs']]:
        """
        Optional configuration of purchase plan for platform image.
        """
        return pulumi.get(self, "plan_info")

    @plan_info.setter
    def plan_info(self, value: Optional[pulumi.Input['PlatformImagePurchasePlanArgs']]):
        pulumi.set(self, "plan_info", value)

    @property
    @pulumi.getter
    def publisher(self) -> Optional[pulumi.Input[str]]:
        """
        Image Publisher in [Azure Gallery Images](https://docs.microsoft.com/en-us/rest/api/compute/virtualmachineimages).
        """
        return pulumi.get(self, "publisher")

    @publisher.setter
    def publisher(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "publisher", value)

    @property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input[str]]:
        """
        Image sku from the [Azure Gallery Images](https://docs.microsoft.com/en-us/rest/api/compute/virtualmachineimages).
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sku", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Image version from the [Azure Gallery Images](https://docs.microsoft.com/en-us/rest/api/compute/virtualmachineimages). If 'latest' is specified here, the version is evaluated when the image build takes place, not when the template is submitted. Specifying 'latest' could cause ROUNDTRIP_INCONSISTENT_PROPERTY issue which will be fixed.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class ImageTemplatePowerShellCustomizerArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 inline: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 run_as_system: Optional[pulumi.Input[bool]] = None,
                 run_elevated: Optional[pulumi.Input[bool]] = None,
                 script_uri: Optional[pulumi.Input[str]] = None,
                 sha256_checksum: Optional[pulumi.Input[str]] = None,
                 valid_exit_codes: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None):
        """
        Runs the specified PowerShell on the VM (Windows). Corresponds to Packer powershell provisioner. Exactly one of 'scriptUri' or 'inline' can be specified.
        :param pulumi.Input[str] type: The type of customization tool you want to use on the Image. For example, "Shell" can be shell customizer
               Expected value is 'PowerShell'.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] inline: Array of PowerShell commands to execute
        :param pulumi.Input[str] name: Friendly Name to provide context on what this customization step does
        :param pulumi.Input[bool] run_as_system: If specified, the PowerShell script will be run with elevated privileges using the Local System user. Can only be true when the runElevated field above is set to true.
        :param pulumi.Input[bool] run_elevated: If specified, the PowerShell script will be run with elevated privileges
        :param pulumi.Input[str] script_uri: URI of the PowerShell script to be run for customizing. It can be a github link, SAS URI for Azure Storage, etc
        :param pulumi.Input[str] sha256_checksum: SHA256 checksum of the power shell script provided in the scriptUri field above
        :param pulumi.Input[Sequence[pulumi.Input[int]]] valid_exit_codes: Valid exit codes for the PowerShell script. [Default: 0]
        """
        pulumi.set(__self__, "type", 'PowerShell')
        if inline is not None:
            pulumi.set(__self__, "inline", inline)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if run_as_system is None:
            run_as_system = False
        if run_as_system is not None:
            pulumi.set(__self__, "run_as_system", run_as_system)
        if run_elevated is None:
            run_elevated = False
        if run_elevated is not None:
            pulumi.set(__self__, "run_elevated", run_elevated)
        if script_uri is not None:
            pulumi.set(__self__, "script_uri", script_uri)
        if sha256_checksum is None:
            sha256_checksum = ''
        if sha256_checksum is not None:
            pulumi.set(__self__, "sha256_checksum", sha256_checksum)
        if valid_exit_codes is not None:
            pulumi.set(__self__, "valid_exit_codes", valid_exit_codes)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of customization tool you want to use on the Image. For example, "Shell" can be shell customizer
        Expected value is 'PowerShell'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def inline(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Array of PowerShell commands to execute
        """
        return pulumi.get(self, "inline")

    @inline.setter
    def inline(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "inline", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Friendly Name to provide context on what this customization step does
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="runAsSystem")
    def run_as_system(self) -> Optional[pulumi.Input[bool]]:
        """
        If specified, the PowerShell script will be run with elevated privileges using the Local System user. Can only be true when the runElevated field above is set to true.
        """
        return pulumi.get(self, "run_as_system")

    @run_as_system.setter
    def run_as_system(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "run_as_system", value)

    @property
    @pulumi.getter(name="runElevated")
    def run_elevated(self) -> Optional[pulumi.Input[bool]]:
        """
        If specified, the PowerShell script will be run with elevated privileges
        """
        return pulumi.get(self, "run_elevated")

    @run_elevated.setter
    def run_elevated(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "run_elevated", value)

    @property
    @pulumi.getter(name="scriptUri")
    def script_uri(self) -> Optional[pulumi.Input[str]]:
        """
        URI of the PowerShell script to be run for customizing. It can be a github link, SAS URI for Azure Storage, etc
        """
        return pulumi.get(self, "script_uri")

    @script_uri.setter
    def script_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "script_uri", value)

    @property
    @pulumi.getter(name="sha256Checksum")
    def sha256_checksum(self) -> Optional[pulumi.Input[str]]:
        """
        SHA256 checksum of the power shell script provided in the scriptUri field above
        """
        return pulumi.get(self, "sha256_checksum")

    @sha256_checksum.setter
    def sha256_checksum(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sha256_checksum", value)

    @property
    @pulumi.getter(name="validExitCodes")
    def valid_exit_codes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        Valid exit codes for the PowerShell script. [Default: 0]
        """
        return pulumi.get(self, "valid_exit_codes")

    @valid_exit_codes.setter
    def valid_exit_codes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "valid_exit_codes", value)


@pulumi.input_type
class ImageTemplateRestartCustomizerArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None,
                 restart_check_command: Optional[pulumi.Input[str]] = None,
                 restart_command: Optional[pulumi.Input[str]] = None,
                 restart_timeout: Optional[pulumi.Input[str]] = None):
        """
        Reboots a VM and waits for it to come back online (Windows). Corresponds to Packer windows-restart provisioner
        :param pulumi.Input[str] type: The type of customization tool you want to use on the Image. For example, "Shell" can be shell customizer
               Expected value is 'WindowsRestart'.
        :param pulumi.Input[str] name: Friendly Name to provide context on what this customization step does
        :param pulumi.Input[str] restart_check_command: Command to check if restart succeeded [Default: '']
        :param pulumi.Input[str] restart_command: Command to execute the restart [Default: 'shutdown /r /f /t 0 /c "packer restart"']
        :param pulumi.Input[str] restart_timeout: Restart timeout specified as a string of magnitude and unit, e.g. '5m' (5 minutes) or '2h' (2 hours) [Default: '5m']
        """
        pulumi.set(__self__, "type", 'WindowsRestart')
        if name is not None:
            pulumi.set(__self__, "name", name)
        if restart_check_command is not None:
            pulumi.set(__self__, "restart_check_command", restart_check_command)
        if restart_command is not None:
            pulumi.set(__self__, "restart_command", restart_command)
        if restart_timeout is not None:
            pulumi.set(__self__, "restart_timeout", restart_timeout)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of customization tool you want to use on the Image. For example, "Shell" can be shell customizer
        Expected value is 'WindowsRestart'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Friendly Name to provide context on what this customization step does
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="restartCheckCommand")
    def restart_check_command(self) -> Optional[pulumi.Input[str]]:
        """
        Command to check if restart succeeded [Default: '']
        """
        return pulumi.get(self, "restart_check_command")

    @restart_check_command.setter
    def restart_check_command(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "restart_check_command", value)

    @property
    @pulumi.getter(name="restartCommand")
    def restart_command(self) -> Optional[pulumi.Input[str]]:
        """
        Command to execute the restart [Default: 'shutdown /r /f /t 0 /c "packer restart"']
        """
        return pulumi.get(self, "restart_command")

    @restart_command.setter
    def restart_command(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "restart_command", value)

    @property
    @pulumi.getter(name="restartTimeout")
    def restart_timeout(self) -> Optional[pulumi.Input[str]]:
        """
        Restart timeout specified as a string of magnitude and unit, e.g. '5m' (5 minutes) or '2h' (2 hours) [Default: '5m']
        """
        return pulumi.get(self, "restart_timeout")

    @restart_timeout.setter
    def restart_timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "restart_timeout", value)


@pulumi.input_type
class ImageTemplateSharedImageDistributorArgs:
    def __init__(__self__, *,
                 gallery_image_id: pulumi.Input[str],
                 replication_regions: pulumi.Input[Sequence[pulumi.Input[str]]],
                 run_output_name: pulumi.Input[str],
                 type: pulumi.Input[str],
                 artifact_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 exclude_from_latest: Optional[pulumi.Input[bool]] = None,
                 storage_account_type: Optional[pulumi.Input[Union[str, 'SharedImageStorageAccountType']]] = None):
        """
        Distribute via Shared Image Gallery.
        :param pulumi.Input[str] gallery_image_id: Resource Id of the Shared Image Gallery image
        :param pulumi.Input[Sequence[pulumi.Input[str]]] replication_regions: A list of regions that the image will be replicated to
        :param pulumi.Input[str] run_output_name: The name to be used for the associated RunOutput.
        :param pulumi.Input[str] type: Type of distribution.
               Expected value is 'SharedImage'.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] artifact_tags: Tags that will be applied to the artifact once it has been created/updated by the distributor.
        :param pulumi.Input[bool] exclude_from_latest: Flag that indicates whether created image version should be excluded from latest. Omit to use the default (false).
        :param pulumi.Input[Union[str, 'SharedImageStorageAccountType']] storage_account_type: Storage account type to be used to store the shared image. Omit to use the default (Standard_LRS).
        """
        pulumi.set(__self__, "gallery_image_id", gallery_image_id)
        pulumi.set(__self__, "replication_regions", replication_regions)
        pulumi.set(__self__, "run_output_name", run_output_name)
        pulumi.set(__self__, "type", 'SharedImage')
        if artifact_tags is not None:
            pulumi.set(__self__, "artifact_tags", artifact_tags)
        if exclude_from_latest is None:
            exclude_from_latest = False
        if exclude_from_latest is not None:
            pulumi.set(__self__, "exclude_from_latest", exclude_from_latest)
        if storage_account_type is not None:
            pulumi.set(__self__, "storage_account_type", storage_account_type)

    @property
    @pulumi.getter(name="galleryImageId")
    def gallery_image_id(self) -> pulumi.Input[str]:
        """
        Resource Id of the Shared Image Gallery image
        """
        return pulumi.get(self, "gallery_image_id")

    @gallery_image_id.setter
    def gallery_image_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "gallery_image_id", value)

    @property
    @pulumi.getter(name="replicationRegions")
    def replication_regions(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A list of regions that the image will be replicated to
        """
        return pulumi.get(self, "replication_regions")

    @replication_regions.setter
    def replication_regions(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "replication_regions", value)

    @property
    @pulumi.getter(name="runOutputName")
    def run_output_name(self) -> pulumi.Input[str]:
        """
        The name to be used for the associated RunOutput.
        """
        return pulumi.get(self, "run_output_name")

    @run_output_name.setter
    def run_output_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "run_output_name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of distribution.
        Expected value is 'SharedImage'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="artifactTags")
    def artifact_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Tags that will be applied to the artifact once it has been created/updated by the distributor.
        """
        return pulumi.get(self, "artifact_tags")

    @artifact_tags.setter
    def artifact_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "artifact_tags", value)

    @property
    @pulumi.getter(name="excludeFromLatest")
    def exclude_from_latest(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag that indicates whether created image version should be excluded from latest. Omit to use the default (false).
        """
        return pulumi.get(self, "exclude_from_latest")

    @exclude_from_latest.setter
    def exclude_from_latest(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "exclude_from_latest", value)

    @property
    @pulumi.getter(name="storageAccountType")
    def storage_account_type(self) -> Optional[pulumi.Input[Union[str, 'SharedImageStorageAccountType']]]:
        """
        Storage account type to be used to store the shared image. Omit to use the default (Standard_LRS).
        """
        return pulumi.get(self, "storage_account_type")

    @storage_account_type.setter
    def storage_account_type(self, value: Optional[pulumi.Input[Union[str, 'SharedImageStorageAccountType']]]):
        pulumi.set(self, "storage_account_type", value)


@pulumi.input_type
class ImageTemplateSharedImageVersionSourceArgs:
    def __init__(__self__, *,
                 image_version_id: pulumi.Input[str],
                 type: pulumi.Input[str]):
        """
        Describes an image source that is an image version in a shared image gallery.
        :param pulumi.Input[str] image_version_id: ARM resource id of the image version in the shared image gallery
        :param pulumi.Input[str] type: Specifies the type of source image you want to start with.
               Expected value is 'SharedImageVersion'.
        """
        pulumi.set(__self__, "image_version_id", image_version_id)
        pulumi.set(__self__, "type", 'SharedImageVersion')

    @property
    @pulumi.getter(name="imageVersionId")
    def image_version_id(self) -> pulumi.Input[str]:
        """
        ARM resource id of the image version in the shared image gallery
        """
        return pulumi.get(self, "image_version_id")

    @image_version_id.setter
    def image_version_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "image_version_id", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Specifies the type of source image you want to start with.
        Expected value is 'SharedImageVersion'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class ImageTemplateShellCustomizerArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 inline: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 script_uri: Optional[pulumi.Input[str]] = None,
                 sha256_checksum: Optional[pulumi.Input[str]] = None):
        """
        Runs a shell script during the customization phase (Linux). Corresponds to Packer shell provisioner. Exactly one of 'scriptUri' or 'inline' can be specified.
        :param pulumi.Input[str] type: The type of customization tool you want to use on the Image. For example, "Shell" can be shell customizer
               Expected value is 'Shell'.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] inline: Array of shell commands to execute
        :param pulumi.Input[str] name: Friendly Name to provide context on what this customization step does
        :param pulumi.Input[str] script_uri: URI of the shell script to be run for customizing. It can be a github link, SAS URI for Azure Storage, etc
        :param pulumi.Input[str] sha256_checksum: SHA256 checksum of the shell script provided in the scriptUri field
        """
        pulumi.set(__self__, "type", 'Shell')
        if inline is not None:
            pulumi.set(__self__, "inline", inline)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if script_uri is not None:
            pulumi.set(__self__, "script_uri", script_uri)
        if sha256_checksum is None:
            sha256_checksum = ''
        if sha256_checksum is not None:
            pulumi.set(__self__, "sha256_checksum", sha256_checksum)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of customization tool you want to use on the Image. For example, "Shell" can be shell customizer
        Expected value is 'Shell'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def inline(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Array of shell commands to execute
        """
        return pulumi.get(self, "inline")

    @inline.setter
    def inline(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "inline", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Friendly Name to provide context on what this customization step does
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="scriptUri")
    def script_uri(self) -> Optional[pulumi.Input[str]]:
        """
        URI of the shell script to be run for customizing. It can be a github link, SAS URI for Azure Storage, etc
        """
        return pulumi.get(self, "script_uri")

    @script_uri.setter
    def script_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "script_uri", value)

    @property
    @pulumi.getter(name="sha256Checksum")
    def sha256_checksum(self) -> Optional[pulumi.Input[str]]:
        """
        SHA256 checksum of the shell script provided in the scriptUri field
        """
        return pulumi.get(self, "sha256_checksum")

    @sha256_checksum.setter
    def sha256_checksum(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sha256_checksum", value)


@pulumi.input_type
class ImageTemplateVhdDistributorArgs:
    def __init__(__self__, *,
                 run_output_name: pulumi.Input[str],
                 type: pulumi.Input[str],
                 artifact_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Distribute via VHD in a storage account.
        :param pulumi.Input[str] run_output_name: The name to be used for the associated RunOutput.
        :param pulumi.Input[str] type: Type of distribution.
               Expected value is 'VHD'.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] artifact_tags: Tags that will be applied to the artifact once it has been created/updated by the distributor.
        """
        pulumi.set(__self__, "run_output_name", run_output_name)
        pulumi.set(__self__, "type", 'VHD')
        if artifact_tags is not None:
            pulumi.set(__self__, "artifact_tags", artifact_tags)

    @property
    @pulumi.getter(name="runOutputName")
    def run_output_name(self) -> pulumi.Input[str]:
        """
        The name to be used for the associated RunOutput.
        """
        return pulumi.get(self, "run_output_name")

    @run_output_name.setter
    def run_output_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "run_output_name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of distribution.
        Expected value is 'VHD'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="artifactTags")
    def artifact_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Tags that will be applied to the artifact once it has been created/updated by the distributor.
        """
        return pulumi.get(self, "artifact_tags")

    @artifact_tags.setter
    def artifact_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "artifact_tags", value)


@pulumi.input_type
class ImageTemplateVmProfileArgs:
    def __init__(__self__, *,
                 os_disk_size_gb: Optional[pulumi.Input[int]] = None,
                 vm_size: Optional[pulumi.Input[str]] = None,
                 vnet_config: Optional[pulumi.Input['VirtualNetworkConfigArgs']] = None):
        """
        Describes the virtual machine used to build, customize and capture images
        :param pulumi.Input[int] os_disk_size_gb: Size of the OS disk in GB. Omit or specify 0 to use Azure's default OS disk size.
        :param pulumi.Input[str] vm_size: Size of the virtual machine used to build, customize and capture images. Omit or specify empty string to use the default (Standard_D1_v2 for Gen1 images and Standard_D2ds_v4 for Gen2 images).
        :param pulumi.Input['VirtualNetworkConfigArgs'] vnet_config: Optional configuration of the virtual network to use to deploy the build virtual machine in. Omit if no specific virtual network needs to be used.
        """
        if os_disk_size_gb is None:
            os_disk_size_gb = 0
        if os_disk_size_gb is not None:
            pulumi.set(__self__, "os_disk_size_gb", os_disk_size_gb)
        if vm_size is None:
            vm_size = ''
        if vm_size is not None:
            pulumi.set(__self__, "vm_size", vm_size)
        if vnet_config is not None:
            pulumi.set(__self__, "vnet_config", vnet_config)

    @property
    @pulumi.getter(name="osDiskSizeGB")
    def os_disk_size_gb(self) -> Optional[pulumi.Input[int]]:
        """
        Size of the OS disk in GB. Omit or specify 0 to use Azure's default OS disk size.
        """
        return pulumi.get(self, "os_disk_size_gb")

    @os_disk_size_gb.setter
    def os_disk_size_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "os_disk_size_gb", value)

    @property
    @pulumi.getter(name="vmSize")
    def vm_size(self) -> Optional[pulumi.Input[str]]:
        """
        Size of the virtual machine used to build, customize and capture images. Omit or specify empty string to use the default (Standard_D1_v2 for Gen1 images and Standard_D2ds_v4 for Gen2 images).
        """
        return pulumi.get(self, "vm_size")

    @vm_size.setter
    def vm_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vm_size", value)

    @property
    @pulumi.getter(name="vnetConfig")
    def vnet_config(self) -> Optional[pulumi.Input['VirtualNetworkConfigArgs']]:
        """
        Optional configuration of the virtual network to use to deploy the build virtual machine in. Omit if no specific virtual network needs to be used.
        """
        return pulumi.get(self, "vnet_config")

    @vnet_config.setter
    def vnet_config(self, value: Optional[pulumi.Input['VirtualNetworkConfigArgs']]):
        pulumi.set(self, "vnet_config", value)


@pulumi.input_type
class ImageTemplateWindowsUpdateCustomizerArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 filters: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 search_criteria: Optional[pulumi.Input[str]] = None,
                 update_limit: Optional[pulumi.Input[int]] = None):
        """
        Installs Windows Updates. Corresponds to Packer Windows Update Provisioner (https://github.com/rgl/packer-provisioner-windows-update)
        :param pulumi.Input[str] type: The type of customization tool you want to use on the Image. For example, "Shell" can be shell customizer
               Expected value is 'WindowsUpdate'.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] filters: Array of filters to select updates to apply. Omit or specify empty array to use the default (no filter). Refer to above link for examples and detailed description of this field.
        :param pulumi.Input[str] name: Friendly Name to provide context on what this customization step does
        :param pulumi.Input[str] search_criteria: Criteria to search updates. Omit or specify empty string to use the default (search all). Refer to above link for examples and detailed description of this field.
        :param pulumi.Input[int] update_limit: Maximum number of updates to apply at a time. Omit or specify 0 to use the default (1000)
        """
        pulumi.set(__self__, "type", 'WindowsUpdate')
        if filters is not None:
            pulumi.set(__self__, "filters", filters)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if search_criteria is not None:
            pulumi.set(__self__, "search_criteria", search_criteria)
        if update_limit is not None:
            pulumi.set(__self__, "update_limit", update_limit)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of customization tool you want to use on the Image. For example, "Shell" can be shell customizer
        Expected value is 'WindowsUpdate'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Array of filters to select updates to apply. Omit or specify empty array to use the default (no filter). Refer to above link for examples and detailed description of this field.
        """
        return pulumi.get(self, "filters")

    @filters.setter
    def filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "filters", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Friendly Name to provide context on what this customization step does
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="searchCriteria")
    def search_criteria(self) -> Optional[pulumi.Input[str]]:
        """
        Criteria to search updates. Omit or specify empty string to use the default (search all). Refer to above link for examples and detailed description of this field.
        """
        return pulumi.get(self, "search_criteria")

    @search_criteria.setter
    def search_criteria(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "search_criteria", value)

    @property
    @pulumi.getter(name="updateLimit")
    def update_limit(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of updates to apply at a time. Omit or specify 0 to use the default (1000)
        """
        return pulumi.get(self, "update_limit")

    @update_limit.setter
    def update_limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "update_limit", value)


@pulumi.input_type
class PlatformImagePurchasePlanArgs:
    def __init__(__self__, *,
                 plan_name: pulumi.Input[str],
                 plan_product: pulumi.Input[str],
                 plan_publisher: pulumi.Input[str]):
        """
        Purchase plan configuration for platform image.
        :param pulumi.Input[str] plan_name: Name of the purchase plan.
        :param pulumi.Input[str] plan_product: Product of the purchase plan.
        :param pulumi.Input[str] plan_publisher: Publisher of the purchase plan.
        """
        pulumi.set(__self__, "plan_name", plan_name)
        pulumi.set(__self__, "plan_product", plan_product)
        pulumi.set(__self__, "plan_publisher", plan_publisher)

    @property
    @pulumi.getter(name="planName")
    def plan_name(self) -> pulumi.Input[str]:
        """
        Name of the purchase plan.
        """
        return pulumi.get(self, "plan_name")

    @plan_name.setter
    def plan_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "plan_name", value)

    @property
    @pulumi.getter(name="planProduct")
    def plan_product(self) -> pulumi.Input[str]:
        """
        Product of the purchase plan.
        """
        return pulumi.get(self, "plan_product")

    @plan_product.setter
    def plan_product(self, value: pulumi.Input[str]):
        pulumi.set(self, "plan_product", value)

    @property
    @pulumi.getter(name="planPublisher")
    def plan_publisher(self) -> pulumi.Input[str]:
        """
        Publisher of the purchase plan.
        """
        return pulumi.get(self, "plan_publisher")

    @plan_publisher.setter
    def plan_publisher(self, value: pulumi.Input[str]):
        pulumi.set(self, "plan_publisher", value)


@pulumi.input_type
class VirtualNetworkConfigArgs:
    def __init__(__self__, *,
                 subnet_id: Optional[pulumi.Input[str]] = None):
        """
        Virtual Network configuration.
        :param pulumi.Input[str] subnet_id: Resource id of a pre-existing subnet.
        """
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource id of a pre-existing subnet.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)


