# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['SkusNestedResourceTypeSecondArgs', 'SkusNestedResourceTypeSecond']

@pulumi.input_type
class SkusNestedResourceTypeSecondArgs:
    def __init__(__self__, *,
                 nested_resource_type_first: pulumi.Input[str],
                 nested_resource_type_second: pulumi.Input[str],
                 provider_namespace: pulumi.Input[str],
                 resource_type: pulumi.Input[str],
                 properties: Optional[pulumi.Input['SkuResourcePropertiesArgs']] = None,
                 sku: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a SkusNestedResourceTypeSecond resource.
        :param pulumi.Input[str] nested_resource_type_first: The first child resource type.
        :param pulumi.Input[str] nested_resource_type_second: The second child resource type.
        :param pulumi.Input[str] provider_namespace: The name of the resource provider hosted within ProviderHub.
        :param pulumi.Input[str] resource_type: The resource type.
        :param pulumi.Input[str] sku: The SKU.
        """
        pulumi.set(__self__, "nested_resource_type_first", nested_resource_type_first)
        pulumi.set(__self__, "nested_resource_type_second", nested_resource_type_second)
        pulumi.set(__self__, "provider_namespace", provider_namespace)
        pulumi.set(__self__, "resource_type", resource_type)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)

    @property
    @pulumi.getter(name="nestedResourceTypeFirst")
    def nested_resource_type_first(self) -> pulumi.Input[str]:
        """
        The first child resource type.
        """
        return pulumi.get(self, "nested_resource_type_first")

    @nested_resource_type_first.setter
    def nested_resource_type_first(self, value: pulumi.Input[str]):
        pulumi.set(self, "nested_resource_type_first", value)

    @property
    @pulumi.getter(name="nestedResourceTypeSecond")
    def nested_resource_type_second(self) -> pulumi.Input[str]:
        """
        The second child resource type.
        """
        return pulumi.get(self, "nested_resource_type_second")

    @nested_resource_type_second.setter
    def nested_resource_type_second(self, value: pulumi.Input[str]):
        pulumi.set(self, "nested_resource_type_second", value)

    @property
    @pulumi.getter(name="providerNamespace")
    def provider_namespace(self) -> pulumi.Input[str]:
        """
        The name of the resource provider hosted within ProviderHub.
        """
        return pulumi.get(self, "provider_namespace")

    @provider_namespace.setter
    def provider_namespace(self, value: pulumi.Input[str]):
        pulumi.set(self, "provider_namespace", value)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Input[str]:
        """
        The resource type.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['SkuResourcePropertiesArgs']]:
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['SkuResourcePropertiesArgs']]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input[str]]:
        """
        The SKU.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sku", value)


class SkusNestedResourceTypeSecond(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 nested_resource_type_first: Optional[pulumi.Input[str]] = None,
                 nested_resource_type_second: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[pulumi.InputType['SkuResourcePropertiesArgs']]] = None,
                 provider_namespace: Optional[pulumi.Input[str]] = None,
                 resource_type: Optional[pulumi.Input[str]] = None,
                 sku: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a SkusNestedResourceTypeSecond resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] nested_resource_type_first: The first child resource type.
        :param pulumi.Input[str] nested_resource_type_second: The second child resource type.
        :param pulumi.Input[str] provider_namespace: The name of the resource provider hosted within ProviderHub.
        :param pulumi.Input[str] resource_type: The resource type.
        :param pulumi.Input[str] sku: The SKU.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SkusNestedResourceTypeSecondArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a SkusNestedResourceTypeSecond resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param SkusNestedResourceTypeSecondArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SkusNestedResourceTypeSecondArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 nested_resource_type_first: Optional[pulumi.Input[str]] = None,
                 nested_resource_type_second: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[pulumi.InputType['SkuResourcePropertiesArgs']]] = None,
                 provider_namespace: Optional[pulumi.Input[str]] = None,
                 resource_type: Optional[pulumi.Input[str]] = None,
                 sku: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SkusNestedResourceTypeSecondArgs.__new__(SkusNestedResourceTypeSecondArgs)

            if nested_resource_type_first is None and not opts.urn:
                raise TypeError("Missing required property 'nested_resource_type_first'")
            __props__.__dict__["nested_resource_type_first"] = nested_resource_type_first
            if nested_resource_type_second is None and not opts.urn:
                raise TypeError("Missing required property 'nested_resource_type_second'")
            __props__.__dict__["nested_resource_type_second"] = nested_resource_type_second
            __props__.__dict__["properties"] = properties
            if provider_namespace is None and not opts.urn:
                raise TypeError("Missing required property 'provider_namespace'")
            __props__.__dict__["provider_namespace"] = provider_namespace
            if resource_type is None and not opts.urn:
                raise TypeError("Missing required property 'resource_type'")
            __props__.__dict__["resource_type"] = resource_type
            __props__.__dict__["sku"] = sku
            __props__.__dict__["name"] = None
            __props__.__dict__["system_data"] = None
            __props__.__dict__["type"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="azure-native:providerhub:SkusNestedResourceTypeSecond"), pulumi.Alias(type_="azure-native:providerhub/v20201120:SkusNestedResourceTypeSecond"), pulumi.Alias(type_="azure-native:providerhub/v20210501preview:SkusNestedResourceTypeSecond"), pulumi.Alias(type_="azure-native:providerhub/v20210601preview:SkusNestedResourceTypeSecond")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(SkusNestedResourceTypeSecond, __self__).__init__(
            'azure-native:providerhub/v20210901preview:SkusNestedResourceTypeSecond',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'SkusNestedResourceTypeSecond':
        """
        Get an existing SkusNestedResourceTypeSecond resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = SkusNestedResourceTypeSecondArgs.__new__(SkusNestedResourceTypeSecondArgs)

        __props__.__dict__["name"] = None
        __props__.__dict__["properties"] = None
        __props__.__dict__["system_data"] = None
        __props__.__dict__["type"] = None
        return SkusNestedResourceTypeSecond(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def properties(self) -> pulumi.Output['outputs.SkuResourceResponseProperties']:
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> pulumi.Output['outputs.SystemDataResponse']:
        """
        Metadata pertaining to creation and last modification of the resource.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")

