# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = [
    'ListVendorSkusCredentialResult',
    'AwaitableListVendorSkusCredentialResult',
    'list_vendor_skus_credential',
    'list_vendor_skus_credential_output',
]

@pulumi.output_type
class ListVendorSkusCredentialResult:
    """
    The Sku credential definition.
    """
    def __init__(__self__, acr_server_url=None, acr_token=None, expiry=None, repositories=None, username=None):
        if acr_server_url and not isinstance(acr_server_url, str):
            raise TypeError("Expected argument 'acr_server_url' to be a str")
        pulumi.set(__self__, "acr_server_url", acr_server_url)
        if acr_token and not isinstance(acr_token, str):
            raise TypeError("Expected argument 'acr_token' to be a str")
        pulumi.set(__self__, "acr_token", acr_token)
        if expiry and not isinstance(expiry, str):
            raise TypeError("Expected argument 'expiry' to be a str")
        pulumi.set(__self__, "expiry", expiry)
        if repositories and not isinstance(repositories, list):
            raise TypeError("Expected argument 'repositories' to be a list")
        pulumi.set(__self__, "repositories", repositories)
        if username and not isinstance(username, str):
            raise TypeError("Expected argument 'username' to be a str")
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="acrServerUrl")
    def acr_server_url(self) -> Optional[str]:
        """
        The Acr server url
        """
        return pulumi.get(self, "acr_server_url")

    @property
    @pulumi.getter(name="acrToken")
    def acr_token(self) -> Optional[str]:
        """
        The credential value.
        """
        return pulumi.get(self, "acr_token")

    @property
    @pulumi.getter
    def expiry(self) -> Optional[str]:
        """
        The UTC time when credential will expire.
        """
        return pulumi.get(self, "expiry")

    @property
    @pulumi.getter
    def repositories(self) -> Optional[Sequence[str]]:
        """
        The repositories that could be accessed using the current credential.
        """
        return pulumi.get(self, "repositories")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        The username of the sku credential.
        """
        return pulumi.get(self, "username")


class AwaitableListVendorSkusCredentialResult(ListVendorSkusCredentialResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return ListVendorSkusCredentialResult(
            acr_server_url=self.acr_server_url,
            acr_token=self.acr_token,
            expiry=self.expiry,
            repositories=self.repositories,
            username=self.username)


def list_vendor_skus_credential(sku_name: Optional[str] = None,
                                vendor_name: Optional[str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableListVendorSkusCredentialResult:
    """
    The Sku credential definition.


    :param str sku_name: The name of the sku.
    :param str vendor_name: The name of the vendor.
    """
    __args__ = dict()
    __args__['skuName'] = sku_name
    __args__['vendorName'] = vendor_name
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('azure-native:hybridnetwork/v20220101preview:listVendorSkusCredential', __args__, opts=opts, typ=ListVendorSkusCredentialResult).value

    return AwaitableListVendorSkusCredentialResult(
        acr_server_url=__ret__.acr_server_url,
        acr_token=__ret__.acr_token,
        expiry=__ret__.expiry,
        repositories=__ret__.repositories,
        username=__ret__.username)


@_utilities.lift_output_func(list_vendor_skus_credential)
def list_vendor_skus_credential_output(sku_name: Optional[pulumi.Input[str]] = None,
                                       vendor_name: Optional[pulumi.Input[str]] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[ListVendorSkusCredentialResult]:
    """
    The Sku credential definition.


    :param str sku_name: The name of the sku.
    :param str vendor_name: The name of the vendor.
    """
    ...
