# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'EncryptionPropertyArgs',
    'ExportPipelineTargetPropertiesArgs',
    'ExportPolicyArgs',
    'IPRuleArgs',
    'IdentityPropertiesArgs',
    'ImportPipelineSourcePropertiesArgs',
    'KeyVaultPropertiesArgs',
    'LoggingPropertiesArgs',
    'NetworkRuleSetArgs',
    'ParentPropertiesArgs',
    'PipelineRunRequestArgs',
    'PipelineRunSourcePropertiesArgs',
    'PipelineRunTargetPropertiesArgs',
    'PipelineSourceTriggerPropertiesArgs',
    'PipelineTriggerPropertiesArgs',
    'PoliciesArgs',
    'PrivateEndpointArgs',
    'PrivateLinkServiceConnectionStateArgs',
    'QuarantinePolicyArgs',
    'RetentionPolicyArgs',
    'SkuArgs',
    'SyncPropertiesArgs',
    'TokenCertificateArgs',
    'TokenCredentialsPropertiesArgs',
    'TokenPasswordArgs',
    'TrustPolicyArgs',
    'UserIdentityPropertiesArgs',
    'VirtualNetworkRuleArgs',
]

@pulumi.input_type
class EncryptionPropertyArgs:
    def __init__(__self__, *,
                 key_vault_properties: Optional[pulumi.Input['KeyVaultPropertiesArgs']] = None,
                 status: Optional[pulumi.Input[Union[str, 'EncryptionStatus']]] = None):
        """
        :param pulumi.Input['KeyVaultPropertiesArgs'] key_vault_properties: Key vault properties.
        :param pulumi.Input[Union[str, 'EncryptionStatus']] status: Indicates whether or not the encryption is enabled for container registry.
        """
        if key_vault_properties is not None:
            pulumi.set(__self__, "key_vault_properties", key_vault_properties)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="keyVaultProperties")
    def key_vault_properties(self) -> Optional[pulumi.Input['KeyVaultPropertiesArgs']]:
        """
        Key vault properties.
        """
        return pulumi.get(self, "key_vault_properties")

    @key_vault_properties.setter
    def key_vault_properties(self, value: Optional[pulumi.Input['KeyVaultPropertiesArgs']]):
        pulumi.set(self, "key_vault_properties", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[Union[str, 'EncryptionStatus']]]:
        """
        Indicates whether or not the encryption is enabled for container registry.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[Union[str, 'EncryptionStatus']]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class ExportPipelineTargetPropertiesArgs:
    def __init__(__self__, *,
                 key_vault_uri: pulumi.Input[str],
                 type: Optional[pulumi.Input[str]] = None,
                 uri: Optional[pulumi.Input[str]] = None):
        """
        The properties of the export pipeline target.
        :param pulumi.Input[str] key_vault_uri: They key vault secret uri to obtain the target storage SAS token.
        :param pulumi.Input[str] type: The type of target for the export pipeline.
        :param pulumi.Input[str] uri: The target uri of the export pipeline.
               When 'AzureStorageBlob': "https://accountName.blob.core.windows.net/containerName/blobName"
               When 'AzureStorageBlobContainer':  "https://accountName.blob.core.windows.net/containerName"
        """
        pulumi.set(__self__, "key_vault_uri", key_vault_uri)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter(name="keyVaultUri")
    def key_vault_uri(self) -> pulumi.Input[str]:
        """
        They key vault secret uri to obtain the target storage SAS token.
        """
        return pulumi.get(self, "key_vault_uri")

    @key_vault_uri.setter
    def key_vault_uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "key_vault_uri", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of target for the export pipeline.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[str]]:
        """
        The target uri of the export pipeline.
        When 'AzureStorageBlob': "https://accountName.blob.core.windows.net/containerName/blobName"
        When 'AzureStorageBlobContainer':  "https://accountName.blob.core.windows.net/containerName"
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uri", value)


@pulumi.input_type
class ExportPolicyArgs:
    def __init__(__self__, *,
                 status: Optional[pulumi.Input[Union[str, 'ExportPolicyStatus']]] = None):
        """
        The export policy for a container registry.
        :param pulumi.Input[Union[str, 'ExportPolicyStatus']] status: The value that indicates whether the policy is enabled or not.
        """
        if status is None:
            status = 'enabled'
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[Union[str, 'ExportPolicyStatus']]]:
        """
        The value that indicates whether the policy is enabled or not.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[Union[str, 'ExportPolicyStatus']]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class IPRuleArgs:
    def __init__(__self__, *,
                 i_p_address_or_range: pulumi.Input[str],
                 action: Optional[pulumi.Input[Union[str, 'Action']]] = None):
        """
        IP rule with specific IP or IP range in CIDR format.
        :param pulumi.Input[str] i_p_address_or_range: Specifies the IP or IP range in CIDR format. Only IPV4 address is allowed.
        :param pulumi.Input[Union[str, 'Action']] action: The action of IP ACL rule.
        """
        pulumi.set(__self__, "i_p_address_or_range", i_p_address_or_range)
        if action is None:
            action = 'Allow'
        if action is not None:
            pulumi.set(__self__, "action", action)

    @property
    @pulumi.getter(name="iPAddressOrRange")
    def i_p_address_or_range(self) -> pulumi.Input[str]:
        """
        Specifies the IP or IP range in CIDR format. Only IPV4 address is allowed.
        """
        return pulumi.get(self, "i_p_address_or_range")

    @i_p_address_or_range.setter
    def i_p_address_or_range(self, value: pulumi.Input[str]):
        pulumi.set(self, "i_p_address_or_range", value)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[Union[str, 'Action']]]:
        """
        The action of IP ACL rule.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[Union[str, 'Action']]]):
        pulumi.set(self, "action", value)


@pulumi.input_type
class IdentityPropertiesArgs:
    def __init__(__self__, *,
                 principal_id: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input['ResourceIdentityType']] = None,
                 user_assigned_identities: Optional[pulumi.Input[Mapping[str, pulumi.Input['UserIdentityPropertiesArgs']]]] = None):
        """
        Managed identity for the resource.
        :param pulumi.Input[str] principal_id: The principal ID of resource identity.
        :param pulumi.Input[str] tenant_id: The tenant ID of resource.
        :param pulumi.Input['ResourceIdentityType'] type: The identity type.
        :param pulumi.Input[Mapping[str, pulumi.Input['UserIdentityPropertiesArgs']]] user_assigned_identities: The list of user identities associated with the resource. The user identity 
               dictionary key references will be ARM resource ids in the form: 
               '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/
                   providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        """
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[str]]:
        """
        The principal ID of resource identity.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "principal_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The tenant ID of resource.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['ResourceIdentityType']]:
        """
        The identity type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['ResourceIdentityType']]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['UserIdentityPropertiesArgs']]]]:
        """
        The list of user identities associated with the resource. The user identity 
        dictionary key references will be ARM resource ids in the form: 
        '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/
            providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        """
        return pulumi.get(self, "user_assigned_identities")

    @user_assigned_identities.setter
    def user_assigned_identities(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['UserIdentityPropertiesArgs']]]]):
        pulumi.set(self, "user_assigned_identities", value)


@pulumi.input_type
class ImportPipelineSourcePropertiesArgs:
    def __init__(__self__, *,
                 key_vault_uri: pulumi.Input[str],
                 type: Optional[pulumi.Input[Union[str, 'PipelineSourceType']]] = None,
                 uri: Optional[pulumi.Input[str]] = None):
        """
        The properties of the import pipeline source.
        :param pulumi.Input[str] key_vault_uri: They key vault secret uri to obtain the source storage SAS token.
        :param pulumi.Input[Union[str, 'PipelineSourceType']] type: The type of source for the import pipeline.
        :param pulumi.Input[str] uri: The source uri of the import pipeline.
               When 'AzureStorageBlob': "https://accountName.blob.core.windows.net/containerName/blobName"
               When 'AzureStorageBlobContainer': "https://accountName.blob.core.windows.net/containerName"
        """
        pulumi.set(__self__, "key_vault_uri", key_vault_uri)
        if type is None:
            type = 'AzureStorageBlobContainer'
        if type is not None:
            pulumi.set(__self__, "type", type)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter(name="keyVaultUri")
    def key_vault_uri(self) -> pulumi.Input[str]:
        """
        They key vault secret uri to obtain the source storage SAS token.
        """
        return pulumi.get(self, "key_vault_uri")

    @key_vault_uri.setter
    def key_vault_uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "key_vault_uri", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Union[str, 'PipelineSourceType']]]:
        """
        The type of source for the import pipeline.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Union[str, 'PipelineSourceType']]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[str]]:
        """
        The source uri of the import pipeline.
        When 'AzureStorageBlob': "https://accountName.blob.core.windows.net/containerName/blobName"
        When 'AzureStorageBlobContainer': "https://accountName.blob.core.windows.net/containerName"
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uri", value)


@pulumi.input_type
class KeyVaultPropertiesArgs:
    def __init__(__self__, *,
                 identity: Optional[pulumi.Input[str]] = None,
                 key_identifier: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] identity: The client id of the identity which will be used to access key vault.
        :param pulumi.Input[str] key_identifier: Key vault uri to access the encryption key.
        """
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if key_identifier is not None:
            pulumi.set(__self__, "key_identifier", key_identifier)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input[str]]:
        """
        The client id of the identity which will be used to access key vault.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter(name="keyIdentifier")
    def key_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        Key vault uri to access the encryption key.
        """
        return pulumi.get(self, "key_identifier")

    @key_identifier.setter
    def key_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_identifier", value)


@pulumi.input_type
class LoggingPropertiesArgs:
    def __init__(__self__, *,
                 audit_log_status: Optional[pulumi.Input[Union[str, 'AuditLogStatus']]] = None,
                 log_level: Optional[pulumi.Input[Union[str, 'LogLevel']]] = None):
        """
        The logging properties of the connected registry.
        :param pulumi.Input[Union[str, 'AuditLogStatus']] audit_log_status: Indicates whether audit logs are enabled on the connected registry.
        :param pulumi.Input[Union[str, 'LogLevel']] log_level: The verbosity of logs persisted on the connected registry.
        """
        if audit_log_status is None:
            audit_log_status = 'Disabled'
        if audit_log_status is not None:
            pulumi.set(__self__, "audit_log_status", audit_log_status)
        if log_level is None:
            log_level = 'Information'
        if log_level is not None:
            pulumi.set(__self__, "log_level", log_level)

    @property
    @pulumi.getter(name="auditLogStatus")
    def audit_log_status(self) -> Optional[pulumi.Input[Union[str, 'AuditLogStatus']]]:
        """
        Indicates whether audit logs are enabled on the connected registry.
        """
        return pulumi.get(self, "audit_log_status")

    @audit_log_status.setter
    def audit_log_status(self, value: Optional[pulumi.Input[Union[str, 'AuditLogStatus']]]):
        pulumi.set(self, "audit_log_status", value)

    @property
    @pulumi.getter(name="logLevel")
    def log_level(self) -> Optional[pulumi.Input[Union[str, 'LogLevel']]]:
        """
        The verbosity of logs persisted on the connected registry.
        """
        return pulumi.get(self, "log_level")

    @log_level.setter
    def log_level(self, value: Optional[pulumi.Input[Union[str, 'LogLevel']]]):
        pulumi.set(self, "log_level", value)


@pulumi.input_type
class NetworkRuleSetArgs:
    def __init__(__self__, *,
                 default_action: pulumi.Input[Union[str, 'DefaultAction']],
                 ip_rules: Optional[pulumi.Input[Sequence[pulumi.Input['IPRuleArgs']]]] = None,
                 virtual_network_rules: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNetworkRuleArgs']]]] = None):
        """
        The network rule set for a container registry.
        :param pulumi.Input[Union[str, 'DefaultAction']] default_action: The default action of allow or deny when no other rules match.
        :param pulumi.Input[Sequence[pulumi.Input['IPRuleArgs']]] ip_rules: The IP ACL rules.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualNetworkRuleArgs']]] virtual_network_rules: The virtual network rules.
        """
        if default_action is None:
            default_action = 'Allow'
        pulumi.set(__self__, "default_action", default_action)
        if ip_rules is not None:
            pulumi.set(__self__, "ip_rules", ip_rules)
        if virtual_network_rules is not None:
            pulumi.set(__self__, "virtual_network_rules", virtual_network_rules)

    @property
    @pulumi.getter(name="defaultAction")
    def default_action(self) -> pulumi.Input[Union[str, 'DefaultAction']]:
        """
        The default action of allow or deny when no other rules match.
        """
        return pulumi.get(self, "default_action")

    @default_action.setter
    def default_action(self, value: pulumi.Input[Union[str, 'DefaultAction']]):
        pulumi.set(self, "default_action", value)

    @property
    @pulumi.getter(name="ipRules")
    def ip_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IPRuleArgs']]]]:
        """
        The IP ACL rules.
        """
        return pulumi.get(self, "ip_rules")

    @ip_rules.setter
    def ip_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IPRuleArgs']]]]):
        pulumi.set(self, "ip_rules", value)

    @property
    @pulumi.getter(name="virtualNetworkRules")
    def virtual_network_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNetworkRuleArgs']]]]:
        """
        The virtual network rules.
        """
        return pulumi.get(self, "virtual_network_rules")

    @virtual_network_rules.setter
    def virtual_network_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNetworkRuleArgs']]]]):
        pulumi.set(self, "virtual_network_rules", value)


@pulumi.input_type
class ParentPropertiesArgs:
    def __init__(__self__, *,
                 sync_properties: pulumi.Input['SyncPropertiesArgs'],
                 id: Optional[pulumi.Input[str]] = None):
        """
        The properties of the connected registry parent.
        :param pulumi.Input['SyncPropertiesArgs'] sync_properties: The sync properties of the connected registry with its parent.
        :param pulumi.Input[str] id: The resource ID of the parent to which the connected registry will be associated.
        """
        pulumi.set(__self__, "sync_properties", sync_properties)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="syncProperties")
    def sync_properties(self) -> pulumi.Input['SyncPropertiesArgs']:
        """
        The sync properties of the connected registry with its parent.
        """
        return pulumi.get(self, "sync_properties")

    @sync_properties.setter
    def sync_properties(self, value: pulumi.Input['SyncPropertiesArgs']):
        pulumi.set(self, "sync_properties", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The resource ID of the parent to which the connected registry will be associated.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class PipelineRunRequestArgs:
    def __init__(__self__, *,
                 artifacts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 catalog_digest: Optional[pulumi.Input[str]] = None,
                 pipeline_resource_id: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input['PipelineRunSourcePropertiesArgs']] = None,
                 target: Optional[pulumi.Input['PipelineRunTargetPropertiesArgs']] = None):
        """
        The request properties provided for a pipeline run.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] artifacts: List of source artifacts to be transferred by the pipeline. 
               Specify an image by repository ('hello-world'). This will use the 'latest' tag.
               Specify an image by tag ('hello-world:latest').
               Specify an image by sha256-based manifest digest ('hello-world@sha256:abc123').
        :param pulumi.Input[str] catalog_digest: The digest of the tar used to transfer the artifacts.
        :param pulumi.Input[str] pipeline_resource_id: The resource ID of the pipeline to run.
        :param pulumi.Input['PipelineRunSourcePropertiesArgs'] source: The source properties of the pipeline run.
        :param pulumi.Input['PipelineRunTargetPropertiesArgs'] target: The target properties of the pipeline run.
        """
        if artifacts is not None:
            pulumi.set(__self__, "artifacts", artifacts)
        if catalog_digest is not None:
            pulumi.set(__self__, "catalog_digest", catalog_digest)
        if pipeline_resource_id is not None:
            pulumi.set(__self__, "pipeline_resource_id", pipeline_resource_id)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter
    def artifacts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of source artifacts to be transferred by the pipeline. 
        Specify an image by repository ('hello-world'). This will use the 'latest' tag.
        Specify an image by tag ('hello-world:latest').
        Specify an image by sha256-based manifest digest ('hello-world@sha256:abc123').
        """
        return pulumi.get(self, "artifacts")

    @artifacts.setter
    def artifacts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "artifacts", value)

    @property
    @pulumi.getter(name="catalogDigest")
    def catalog_digest(self) -> Optional[pulumi.Input[str]]:
        """
        The digest of the tar used to transfer the artifacts.
        """
        return pulumi.get(self, "catalog_digest")

    @catalog_digest.setter
    def catalog_digest(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "catalog_digest", value)

    @property
    @pulumi.getter(name="pipelineResourceId")
    def pipeline_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The resource ID of the pipeline to run.
        """
        return pulumi.get(self, "pipeline_resource_id")

    @pipeline_resource_id.setter
    def pipeline_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pipeline_resource_id", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input['PipelineRunSourcePropertiesArgs']]:
        """
        The source properties of the pipeline run.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input['PipelineRunSourcePropertiesArgs']]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input['PipelineRunTargetPropertiesArgs']]:
        """
        The target properties of the pipeline run.
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input['PipelineRunTargetPropertiesArgs']]):
        pulumi.set(self, "target", value)


@pulumi.input_type
class PipelineRunSourcePropertiesArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[Union[str, 'PipelineRunSourceType']]] = None):
        """
        :param pulumi.Input[str] name: The name of the source.
        :param pulumi.Input[Union[str, 'PipelineRunSourceType']] type: The type of the source.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is None:
            type = 'AzureStorageBlob'
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the source.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Union[str, 'PipelineRunSourceType']]]:
        """
        The type of the source.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Union[str, 'PipelineRunSourceType']]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class PipelineRunTargetPropertiesArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[Union[str, 'PipelineRunTargetType']]] = None):
        """
        :param pulumi.Input[str] name: The name of the target.
        :param pulumi.Input[Union[str, 'PipelineRunTargetType']] type: The type of the target.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is None:
            type = 'AzureStorageBlob'
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the target.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Union[str, 'PipelineRunTargetType']]]:
        """
        The type of the target.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Union[str, 'PipelineRunTargetType']]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class PipelineSourceTriggerPropertiesArgs:
    def __init__(__self__, *,
                 status: pulumi.Input[Union[str, 'TriggerStatus']]):
        """
        :param pulumi.Input[Union[str, 'TriggerStatus']] status: The current status of the source trigger.
        """
        if status is None:
            status = 'Enabled'
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def status(self) -> pulumi.Input[Union[str, 'TriggerStatus']]:
        """
        The current status of the source trigger.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: pulumi.Input[Union[str, 'TriggerStatus']]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class PipelineTriggerPropertiesArgs:
    def __init__(__self__, *,
                 source_trigger: Optional[pulumi.Input['PipelineSourceTriggerPropertiesArgs']] = None):
        """
        :param pulumi.Input['PipelineSourceTriggerPropertiesArgs'] source_trigger: The source trigger properties of the pipeline.
        """
        if source_trigger is not None:
            pulumi.set(__self__, "source_trigger", source_trigger)

    @property
    @pulumi.getter(name="sourceTrigger")
    def source_trigger(self) -> Optional[pulumi.Input['PipelineSourceTriggerPropertiesArgs']]:
        """
        The source trigger properties of the pipeline.
        """
        return pulumi.get(self, "source_trigger")

    @source_trigger.setter
    def source_trigger(self, value: Optional[pulumi.Input['PipelineSourceTriggerPropertiesArgs']]):
        pulumi.set(self, "source_trigger", value)


@pulumi.input_type
class PoliciesArgs:
    def __init__(__self__, *,
                 export_policy: Optional[pulumi.Input['ExportPolicyArgs']] = None,
                 quarantine_policy: Optional[pulumi.Input['QuarantinePolicyArgs']] = None,
                 retention_policy: Optional[pulumi.Input['RetentionPolicyArgs']] = None,
                 trust_policy: Optional[pulumi.Input['TrustPolicyArgs']] = None):
        """
        The policies for a container registry.
        :param pulumi.Input['ExportPolicyArgs'] export_policy: The export policy for a container registry.
        :param pulumi.Input['QuarantinePolicyArgs'] quarantine_policy: The quarantine policy for a container registry.
        :param pulumi.Input['RetentionPolicyArgs'] retention_policy: The retention policy for a container registry.
        :param pulumi.Input['TrustPolicyArgs'] trust_policy: The content trust policy for a container registry.
        """
        if export_policy is not None:
            pulumi.set(__self__, "export_policy", export_policy)
        if quarantine_policy is not None:
            pulumi.set(__self__, "quarantine_policy", quarantine_policy)
        if retention_policy is not None:
            pulumi.set(__self__, "retention_policy", retention_policy)
        if trust_policy is not None:
            pulumi.set(__self__, "trust_policy", trust_policy)

    @property
    @pulumi.getter(name="exportPolicy")
    def export_policy(self) -> Optional[pulumi.Input['ExportPolicyArgs']]:
        """
        The export policy for a container registry.
        """
        return pulumi.get(self, "export_policy")

    @export_policy.setter
    def export_policy(self, value: Optional[pulumi.Input['ExportPolicyArgs']]):
        pulumi.set(self, "export_policy", value)

    @property
    @pulumi.getter(name="quarantinePolicy")
    def quarantine_policy(self) -> Optional[pulumi.Input['QuarantinePolicyArgs']]:
        """
        The quarantine policy for a container registry.
        """
        return pulumi.get(self, "quarantine_policy")

    @quarantine_policy.setter
    def quarantine_policy(self, value: Optional[pulumi.Input['QuarantinePolicyArgs']]):
        pulumi.set(self, "quarantine_policy", value)

    @property
    @pulumi.getter(name="retentionPolicy")
    def retention_policy(self) -> Optional[pulumi.Input['RetentionPolicyArgs']]:
        """
        The retention policy for a container registry.
        """
        return pulumi.get(self, "retention_policy")

    @retention_policy.setter
    def retention_policy(self, value: Optional[pulumi.Input['RetentionPolicyArgs']]):
        pulumi.set(self, "retention_policy", value)

    @property
    @pulumi.getter(name="trustPolicy")
    def trust_policy(self) -> Optional[pulumi.Input['TrustPolicyArgs']]:
        """
        The content trust policy for a container registry.
        """
        return pulumi.get(self, "trust_policy")

    @trust_policy.setter
    def trust_policy(self, value: Optional[pulumi.Input['TrustPolicyArgs']]):
        pulumi.set(self, "trust_policy", value)


@pulumi.input_type
class PrivateEndpointArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None):
        """
        The Private Endpoint resource.
        :param pulumi.Input[str] id: This is private endpoint resource created with Microsoft.Network resource provider.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        This is private endpoint resource created with Microsoft.Network resource provider.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class PrivateLinkServiceConnectionStateArgs:
    def __init__(__self__, *,
                 actions_required: Optional[pulumi.Input[Union[str, 'ActionsRequired']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[Union[str, 'ConnectionStatus']]] = None):
        """
        The state of a private link service connection.
        :param pulumi.Input[Union[str, 'ActionsRequired']] actions_required: A message indicating if changes on the service provider require any updates on the consumer.
        :param pulumi.Input[str] description: The description for connection status. For example if connection is rejected it can indicate reason for rejection.
        :param pulumi.Input[Union[str, 'ConnectionStatus']] status: The private link service connection status.
        """
        if actions_required is not None:
            pulumi.set(__self__, "actions_required", actions_required)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="actionsRequired")
    def actions_required(self) -> Optional[pulumi.Input[Union[str, 'ActionsRequired']]]:
        """
        A message indicating if changes on the service provider require any updates on the consumer.
        """
        return pulumi.get(self, "actions_required")

    @actions_required.setter
    def actions_required(self, value: Optional[pulumi.Input[Union[str, 'ActionsRequired']]]):
        pulumi.set(self, "actions_required", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description for connection status. For example if connection is rejected it can indicate reason for rejection.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[Union[str, 'ConnectionStatus']]]:
        """
        The private link service connection status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[Union[str, 'ConnectionStatus']]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class QuarantinePolicyArgs:
    def __init__(__self__, *,
                 status: Optional[pulumi.Input[Union[str, 'PolicyStatus']]] = None):
        """
        The quarantine policy for a container registry.
        :param pulumi.Input[Union[str, 'PolicyStatus']] status: The value that indicates whether the policy is enabled or not.
        """
        if status is None:
            status = 'disabled'
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[Union[str, 'PolicyStatus']]]:
        """
        The value that indicates whether the policy is enabled or not.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[Union[str, 'PolicyStatus']]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class RetentionPolicyArgs:
    def __init__(__self__, *,
                 days: Optional[pulumi.Input[int]] = None,
                 status: Optional[pulumi.Input[Union[str, 'PolicyStatus']]] = None):
        """
        The retention policy for a container registry.
        :param pulumi.Input[int] days: The number of days to retain an untagged manifest after which it gets purged.
        :param pulumi.Input[Union[str, 'PolicyStatus']] status: The value that indicates whether the policy is enabled or not.
        """
        if days is None:
            days = 7
        if days is not None:
            pulumi.set(__self__, "days", days)
        if status is None:
            status = 'disabled'
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def days(self) -> Optional[pulumi.Input[int]]:
        """
        The number of days to retain an untagged manifest after which it gets purged.
        """
        return pulumi.get(self, "days")

    @days.setter
    def days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "days", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[Union[str, 'PolicyStatus']]]:
        """
        The value that indicates whether the policy is enabled or not.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[Union[str, 'PolicyStatus']]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class SkuArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[Union[str, 'SkuName']]):
        """
        The SKU of a container registry.
        :param pulumi.Input[Union[str, 'SkuName']] name: The SKU name of the container registry. Required for registry creation.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[Union[str, 'SkuName']]:
        """
        The SKU name of the container registry. Required for registry creation.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[Union[str, 'SkuName']]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class SyncPropertiesArgs:
    def __init__(__self__, *,
                 message_ttl: pulumi.Input[str],
                 token_id: pulumi.Input[str],
                 schedule: Optional[pulumi.Input[str]] = None,
                 sync_window: Optional[pulumi.Input[str]] = None):
        """
        The sync properties of the connected registry with its parent.
        :param pulumi.Input[str] message_ttl: The period of time for which a message is available to sync before it is expired. Specify the duration using the format P[n]Y[n]M[n]DT[n]H[n]M[n]S as per ISO8601.
        :param pulumi.Input[str] token_id: The resource ID of the ACR token used to authenticate the connected registry to its parent during sync.
        :param pulumi.Input[str] schedule: The cron expression indicating the schedule that the connected registry will sync with its parent.
        :param pulumi.Input[str] sync_window: The time window during which sync is enabled for each schedule occurrence. Specify the duration using the format P[n]Y[n]M[n]DT[n]H[n]M[n]S as per ISO8601.
        """
        pulumi.set(__self__, "message_ttl", message_ttl)
        pulumi.set(__self__, "token_id", token_id)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if sync_window is not None:
            pulumi.set(__self__, "sync_window", sync_window)

    @property
    @pulumi.getter(name="messageTtl")
    def message_ttl(self) -> pulumi.Input[str]:
        """
        The period of time for which a message is available to sync before it is expired. Specify the duration using the format P[n]Y[n]M[n]DT[n]H[n]M[n]S as per ISO8601.
        """
        return pulumi.get(self, "message_ttl")

    @message_ttl.setter
    def message_ttl(self, value: pulumi.Input[str]):
        pulumi.set(self, "message_ttl", value)

    @property
    @pulumi.getter(name="tokenId")
    def token_id(self) -> pulumi.Input[str]:
        """
        The resource ID of the ACR token used to authenticate the connected registry to its parent during sync.
        """
        return pulumi.get(self, "token_id")

    @token_id.setter
    def token_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "token_id", value)

    @property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input[str]]:
        """
        The cron expression indicating the schedule that the connected registry will sync with its parent.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schedule", value)

    @property
    @pulumi.getter(name="syncWindow")
    def sync_window(self) -> Optional[pulumi.Input[str]]:
        """
        The time window during which sync is enabled for each schedule occurrence. Specify the duration using the format P[n]Y[n]M[n]DT[n]H[n]M[n]S as per ISO8601.
        """
        return pulumi.get(self, "sync_window")

    @sync_window.setter
    def sync_window(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sync_window", value)


@pulumi.input_type
class TokenCertificateArgs:
    def __init__(__self__, *,
                 encoded_pem_certificate: Optional[pulumi.Input[str]] = None,
                 expiry: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[Union[str, 'TokenCertificateName']]] = None,
                 thumbprint: Optional[pulumi.Input[str]] = None):
        """
        The properties of a certificate used for authenticating a token.
        :param pulumi.Input[str] encoded_pem_certificate: Base 64 encoded string of the public certificate1 in PEM format that will be used for authenticating the token.
        :param pulumi.Input[str] expiry: The expiry datetime of the certificate.
        :param pulumi.Input[str] thumbprint: The thumbprint of the certificate.
        """
        if encoded_pem_certificate is not None:
            pulumi.set(__self__, "encoded_pem_certificate", encoded_pem_certificate)
        if expiry is not None:
            pulumi.set(__self__, "expiry", expiry)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if thumbprint is not None:
            pulumi.set(__self__, "thumbprint", thumbprint)

    @property
    @pulumi.getter(name="encodedPemCertificate")
    def encoded_pem_certificate(self) -> Optional[pulumi.Input[str]]:
        """
        Base 64 encoded string of the public certificate1 in PEM format that will be used for authenticating the token.
        """
        return pulumi.get(self, "encoded_pem_certificate")

    @encoded_pem_certificate.setter
    def encoded_pem_certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encoded_pem_certificate", value)

    @property
    @pulumi.getter
    def expiry(self) -> Optional[pulumi.Input[str]]:
        """
        The expiry datetime of the certificate.
        """
        return pulumi.get(self, "expiry")

    @expiry.setter
    def expiry(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expiry", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[Union[str, 'TokenCertificateName']]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[Union[str, 'TokenCertificateName']]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def thumbprint(self) -> Optional[pulumi.Input[str]]:
        """
        The thumbprint of the certificate.
        """
        return pulumi.get(self, "thumbprint")

    @thumbprint.setter
    def thumbprint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "thumbprint", value)


@pulumi.input_type
class TokenCredentialsPropertiesArgs:
    def __init__(__self__, *,
                 certificates: Optional[pulumi.Input[Sequence[pulumi.Input['TokenCertificateArgs']]]] = None,
                 passwords: Optional[pulumi.Input[Sequence[pulumi.Input['TokenPasswordArgs']]]] = None):
        """
        The properties of the credentials that can be used for authenticating the token.
        """
        if certificates is not None:
            pulumi.set(__self__, "certificates", certificates)
        if passwords is not None:
            pulumi.set(__self__, "passwords", passwords)

    @property
    @pulumi.getter
    def certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TokenCertificateArgs']]]]:
        return pulumi.get(self, "certificates")

    @certificates.setter
    def certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TokenCertificateArgs']]]]):
        pulumi.set(self, "certificates", value)

    @property
    @pulumi.getter
    def passwords(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TokenPasswordArgs']]]]:
        return pulumi.get(self, "passwords")

    @passwords.setter
    def passwords(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TokenPasswordArgs']]]]):
        pulumi.set(self, "passwords", value)


@pulumi.input_type
class TokenPasswordArgs:
    def __init__(__self__, *,
                 creation_time: Optional[pulumi.Input[str]] = None,
                 expiry: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[Union[str, 'TokenPasswordName']]] = None):
        """
        The password that will be used for authenticating the token of a container registry.
        :param pulumi.Input[str] creation_time: The creation datetime of the password.
        :param pulumi.Input[str] expiry: The expiry datetime of the password.
        :param pulumi.Input[Union[str, 'TokenPasswordName']] name: The password name "password1" or "password2"
        """
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if expiry is not None:
            pulumi.set(__self__, "expiry", expiry)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[pulumi.Input[str]]:
        """
        The creation datetime of the password.
        """
        return pulumi.get(self, "creation_time")

    @creation_time.setter
    def creation_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "creation_time", value)

    @property
    @pulumi.getter
    def expiry(self) -> Optional[pulumi.Input[str]]:
        """
        The expiry datetime of the password.
        """
        return pulumi.get(self, "expiry")

    @expiry.setter
    def expiry(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expiry", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[Union[str, 'TokenPasswordName']]]:
        """
        The password name "password1" or "password2"
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[Union[str, 'TokenPasswordName']]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class TrustPolicyArgs:
    def __init__(__self__, *,
                 status: Optional[pulumi.Input[Union[str, 'PolicyStatus']]] = None,
                 type: Optional[pulumi.Input[Union[str, 'TrustPolicyType']]] = None):
        """
        The content trust policy for a container registry.
        :param pulumi.Input[Union[str, 'PolicyStatus']] status: The value that indicates whether the policy is enabled or not.
        :param pulumi.Input[Union[str, 'TrustPolicyType']] type: The type of trust policy.
        """
        if status is None:
            status = 'disabled'
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is None:
            type = 'Notary'
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[Union[str, 'PolicyStatus']]]:
        """
        The value that indicates whether the policy is enabled or not.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[Union[str, 'PolicyStatus']]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Union[str, 'TrustPolicyType']]]:
        """
        The type of trust policy.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Union[str, 'TrustPolicyType']]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class UserIdentityPropertiesArgs:
    def __init__(__self__, *,
                 client_id: Optional[pulumi.Input[str]] = None,
                 principal_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] client_id: The client id of user assigned identity.
        :param pulumi.Input[str] principal_id: The principal id of user assigned identity.
        """
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        """
        The client id of user assigned identity.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[str]]:
        """
        The principal id of user assigned identity.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "principal_id", value)


@pulumi.input_type
class VirtualNetworkRuleArgs:
    def __init__(__self__, *,
                 virtual_network_resource_id: pulumi.Input[str],
                 action: Optional[pulumi.Input[Union[str, 'Action']]] = None):
        """
        Virtual network rule.
        :param pulumi.Input[str] virtual_network_resource_id: Resource ID of a subnet, for example: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.
        :param pulumi.Input[Union[str, 'Action']] action: The action of virtual network rule.
        """
        pulumi.set(__self__, "virtual_network_resource_id", virtual_network_resource_id)
        if action is None:
            action = 'Allow'
        if action is not None:
            pulumi.set(__self__, "action", action)

    @property
    @pulumi.getter(name="virtualNetworkResourceId")
    def virtual_network_resource_id(self) -> pulumi.Input[str]:
        """
        Resource ID of a subnet, for example: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.
        """
        return pulumi.get(self, "virtual_network_resource_id")

    @virtual_network_resource_id.setter
    def virtual_network_resource_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "virtual_network_resource_id", value)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[Union[str, 'Action']]]:
        """
        The action of virtual network rule.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[Union[str, 'Action']]]):
        pulumi.set(self, "action", value)


