# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'ListEdgeModuleProvisioningTokenResult',
    'AwaitableListEdgeModuleProvisioningTokenResult',
    'list_edge_module_provisioning_token',
    'list_edge_module_provisioning_token_output',
]

@pulumi.output_type
class ListEdgeModuleProvisioningTokenResult:
    """
    Provisioning token properties. A provisioning token allows for a single instance of Azure Video analyzer IoT edge module to be initialized and authorized to the cloud account. The provisioning token itself is short lived and it is only used for the initial handshake between IoT edge module and the cloud. After the initial handshake, the IoT edge module will agree on a set of authentication keys which will be auto-rotated as long as the module is able to periodically connect to the cloud. A new provisioning token can be generated for the same IoT edge module in case the module state lost or reset.
    """
    def __init__(__self__, expiration_date=None, token=None):
        if expiration_date and not isinstance(expiration_date, str):
            raise TypeError("Expected argument 'expiration_date' to be a str")
        pulumi.set(__self__, "expiration_date", expiration_date)
        if token and not isinstance(token, str):
            raise TypeError("Expected argument 'token' to be a str")
        pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> str:
        """
        The expiration date of the registration token. The Azure Video Analyzer IoT edge module must be initialized and connected to the Internet prior to the token expiration date.
        """
        return pulumi.get(self, "expiration_date")

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        The token blob to be provided to the Azure Video Analyzer IoT edge module through the Azure IoT Edge module twin properties.
        """
        return pulumi.get(self, "token")


class AwaitableListEdgeModuleProvisioningTokenResult(ListEdgeModuleProvisioningTokenResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return ListEdgeModuleProvisioningTokenResult(
            expiration_date=self.expiration_date,
            token=self.token)


def list_edge_module_provisioning_token(account_name: Optional[str] = None,
                                        edge_module_name: Optional[str] = None,
                                        expiration_date: Optional[str] = None,
                                        resource_group_name: Optional[str] = None,
                                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableListEdgeModuleProvisioningTokenResult:
    """
    Provisioning token properties. A provisioning token allows for a single instance of Azure Video analyzer IoT edge module to be initialized and authorized to the cloud account. The provisioning token itself is short lived and it is only used for the initial handshake between IoT edge module and the cloud. After the initial handshake, the IoT edge module will agree on a set of authentication keys which will be auto-rotated as long as the module is able to periodically connect to the cloud. A new provisioning token can be generated for the same IoT edge module in case the module state lost or reset.
    API Version: 2021-05-01-preview.


    :param str account_name: The Azure Video Analyzer account name.
    :param str edge_module_name: The name of the edge module used to create a new provisioning token.
    :param str expiration_date: The desired expiration date of the registration token. The Azure Video Analyzer IoT edge module must be initialized and connected to the Internet prior to the token expiration date.
    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    """
    __args__ = dict()
    __args__['accountName'] = account_name
    __args__['edgeModuleName'] = edge_module_name
    __args__['expirationDate'] = expiration_date
    __args__['resourceGroupName'] = resource_group_name
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('azure-native:videoanalyzer:listEdgeModuleProvisioningToken', __args__, opts=opts, typ=ListEdgeModuleProvisioningTokenResult).value

    return AwaitableListEdgeModuleProvisioningTokenResult(
        expiration_date=__ret__.expiration_date,
        token=__ret__.token)


@_utilities.lift_output_func(list_edge_module_provisioning_token)
def list_edge_module_provisioning_token_output(account_name: Optional[pulumi.Input[str]] = None,
                                               edge_module_name: Optional[pulumi.Input[str]] = None,
                                               expiration_date: Optional[pulumi.Input[str]] = None,
                                               resource_group_name: Optional[pulumi.Input[str]] = None,
                                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[ListEdgeModuleProvisioningTokenResult]:
    """
    Provisioning token properties. A provisioning token allows for a single instance of Azure Video analyzer IoT edge module to be initialized and authorized to the cloud account. The provisioning token itself is short lived and it is only used for the initial handshake between IoT edge module and the cloud. After the initial handshake, the IoT edge module will agree on a set of authentication keys which will be auto-rotated as long as the module is able to periodically connect to the cloud. A new provisioning token can be generated for the same IoT edge module in case the module state lost or reset.
    API Version: 2021-05-01-preview.


    :param str account_name: The Azure Video Analyzer account name.
    :param str edge_module_name: The name of the edge module used to create a new provisioning token.
    :param str expiration_date: The desired expiration date of the registration token. The Azure Video Analyzer IoT edge module must be initialized and connected to the Internet prior to the token expiration date.
    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    """
    ...
