# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ExportDeliveryDestinationResponse',
    'ExportDeliveryInfoResponse',
    'ExportRecurrencePeriodResponse',
    'ExportScheduleResponse',
    'QueryAggregationResponse',
    'QueryComparisonExpressionResponse',
    'QueryDatasetConfigurationResponse',
    'QueryDatasetResponse',
    'QueryDefinitionResponse',
    'QueryFilterResponse',
    'QueryGroupingResponse',
    'QuerySortingConfigurationResponse',
    'QueryTimePeriodResponse',
]

@pulumi.output_type
class ExportDeliveryDestinationResponse(dict):
    """
    The destination information for the delivery of the export. To allow access to a storage account, you must register the account's subscription with the Microsoft.CostManagementExports resource provider. This is required once per subscription. When creating an export in the Azure portal, it is done automatically. However, API users need to register the subscription. For more information see https://docs.microsoft.com/en-us/azure/azure-resource-manager/resource-manager-supported-services .
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceId":
            suggest = "resource_id"
        elif key == "rootFolderPath":
            suggest = "root_folder_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExportDeliveryDestinationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExportDeliveryDestinationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExportDeliveryDestinationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container: str,
                 resource_id: str,
                 root_folder_path: Optional[str] = None):
        """
        The destination information for the delivery of the export. To allow access to a storage account, you must register the account's subscription with the Microsoft.CostManagementExports resource provider. This is required once per subscription. When creating an export in the Azure portal, it is done automatically. However, API users need to register the subscription. For more information see https://docs.microsoft.com/en-us/azure/azure-resource-manager/resource-manager-supported-services .
        :param str container: The name of the container where exports will be uploaded.
        :param str resource_id: The resource id of the storage account where exports will be delivered.
        :param str root_folder_path: The name of the directory where exports will be uploaded.
        """
        pulumi.set(__self__, "container", container)
        pulumi.set(__self__, "resource_id", resource_id)
        if root_folder_path is not None:
            pulumi.set(__self__, "root_folder_path", root_folder_path)

    @property
    @pulumi.getter
    def container(self) -> str:
        """
        The name of the container where exports will be uploaded.
        """
        return pulumi.get(self, "container")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> str:
        """
        The resource id of the storage account where exports will be delivered.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="rootFolderPath")
    def root_folder_path(self) -> Optional[str]:
        """
        The name of the directory where exports will be uploaded.
        """
        return pulumi.get(self, "root_folder_path")


@pulumi.output_type
class ExportDeliveryInfoResponse(dict):
    """
    The delivery information associated with a export.
    """
    def __init__(__self__, *,
                 destination: 'outputs.ExportDeliveryDestinationResponse'):
        """
        The delivery information associated with a export.
        :param 'ExportDeliveryDestinationResponse' destination: Has destination for the export being delivered.
        """
        pulumi.set(__self__, "destination", destination)

    @property
    @pulumi.getter
    def destination(self) -> 'outputs.ExportDeliveryDestinationResponse':
        """
        Has destination for the export being delivered.
        """
        return pulumi.get(self, "destination")


@pulumi.output_type
class ExportRecurrencePeriodResponse(dict):
    """
    The start and end date for recurrence schedule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "from":
            suggest = "from_"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExportRecurrencePeriodResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExportRecurrencePeriodResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExportRecurrencePeriodResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 from_: str,
                 to: Optional[str] = None):
        """
        The start and end date for recurrence schedule.
        :param str from_: The start date of recurrence.
        :param str to: The end date of recurrence.
        """
        pulumi.set(__self__, "from_", from_)
        if to is not None:
            pulumi.set(__self__, "to", to)

    @property
    @pulumi.getter(name="from")
    def from_(self) -> str:
        """
        The start date of recurrence.
        """
        return pulumi.get(self, "from_")

    @property
    @pulumi.getter
    def to(self) -> Optional[str]:
        """
        The end date of recurrence.
        """
        return pulumi.get(self, "to")


@pulumi.output_type
class ExportScheduleResponse(dict):
    """
    The schedule associated with a export.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "recurrencePeriod":
            suggest = "recurrence_period"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExportScheduleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExportScheduleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExportScheduleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 recurrence: str,
                 recurrence_period: Optional['outputs.ExportRecurrencePeriodResponse'] = None,
                 status: Optional[str] = None):
        """
        The schedule associated with a export.
        :param str recurrence: The schedule recurrence.
        :param 'ExportRecurrencePeriodResponse' recurrence_period: Has start and end date of the recurrence. The start date must be in future. If present, the end date must be greater than start date.
        :param str status: The status of the schedule. Whether active or not. If inactive, the export's scheduled execution is paused.
        """
        pulumi.set(__self__, "recurrence", recurrence)
        if recurrence_period is not None:
            pulumi.set(__self__, "recurrence_period", recurrence_period)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def recurrence(self) -> str:
        """
        The schedule recurrence.
        """
        return pulumi.get(self, "recurrence")

    @property
    @pulumi.getter(name="recurrencePeriod")
    def recurrence_period(self) -> Optional['outputs.ExportRecurrencePeriodResponse']:
        """
        Has start and end date of the recurrence. The start date must be in future. If present, the end date must be greater than start date.
        """
        return pulumi.get(self, "recurrence_period")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The status of the schedule. Whether active or not. If inactive, the export's scheduled execution is paused.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class QueryAggregationResponse(dict):
    """
    The aggregation expression to be used in the query.
    """
    def __init__(__self__, *,
                 function: str,
                 name: str):
        """
        The aggregation expression to be used in the query.
        :param str function: The name of the aggregation function to use.
        :param str name: The name of the column to aggregate.
        """
        pulumi.set(__self__, "function", function)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def function(self) -> str:
        """
        The name of the aggregation function to use.
        """
        return pulumi.get(self, "function")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the column to aggregate.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class QueryComparisonExpressionResponse(dict):
    """
    The comparison expression to be used in the query.
    """
    def __init__(__self__, *,
                 name: str,
                 operator: str,
                 values: Sequence[str]):
        """
        The comparison expression to be used in the query.
        :param str name: The name of the column to use in comparison.
        :param str operator: The operator to use for comparison.
        :param Sequence[str] values: Array of values to use for comparison
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the column to use in comparison.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def operator(self) -> str:
        """
        The operator to use for comparison.
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        Array of values to use for comparison
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class QueryDatasetConfigurationResponse(dict):
    """
    The configuration of dataset in the query.
    """
    def __init__(__self__, *,
                 columns: Optional[Sequence[str]] = None):
        """
        The configuration of dataset in the query.
        :param Sequence[str] columns: Array of column names to be included in the query. Any valid query column name is allowed. If not provided, then query includes all columns.
        """
        if columns is not None:
            pulumi.set(__self__, "columns", columns)

    @property
    @pulumi.getter
    def columns(self) -> Optional[Sequence[str]]:
        """
        Array of column names to be included in the query. Any valid query column name is allowed. If not provided, then query includes all columns.
        """
        return pulumi.get(self, "columns")


@pulumi.output_type
class QueryDatasetResponse(dict):
    """
    The definition of data present in the query.
    """
    def __init__(__self__, *,
                 aggregation: Optional[Mapping[str, 'outputs.QueryAggregationResponse']] = None,
                 configuration: Optional['outputs.QueryDatasetConfigurationResponse'] = None,
                 filter: Optional['outputs.QueryFilterResponse'] = None,
                 granularity: Optional[str] = None,
                 grouping: Optional[Sequence['outputs.QueryGroupingResponse']] = None,
                 sorting: Optional[Sequence['outputs.QuerySortingConfigurationResponse']] = None):
        """
        The definition of data present in the query.
        :param Mapping[str, 'QueryAggregationResponse'] aggregation: Dictionary of aggregation expression to use in the query. The key of each item in the dictionary is the alias for the aggregated column. Query can have up to 2 aggregation clauses.
        :param 'QueryDatasetConfigurationResponse' configuration: Has configuration information for the data in the export. The configuration will be ignored if aggregation and grouping are provided.
        :param 'QueryFilterResponse' filter: The filter expression to use in the query. Please reference our Query API REST documentation for how to properly format the filter.
        :param str granularity: The granularity of rows in the query.
        :param Sequence['QueryGroupingResponse'] grouping: Array of group by expression to use in the query. Query can have up to 2 group by clauses.
        :param Sequence['QuerySortingConfigurationResponse'] sorting: Array of sorting by columns in query.
        """
        if aggregation is not None:
            pulumi.set(__self__, "aggregation", aggregation)
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if granularity is not None:
            pulumi.set(__self__, "granularity", granularity)
        if grouping is not None:
            pulumi.set(__self__, "grouping", grouping)
        if sorting is not None:
            pulumi.set(__self__, "sorting", sorting)

    @property
    @pulumi.getter
    def aggregation(self) -> Optional[Mapping[str, 'outputs.QueryAggregationResponse']]:
        """
        Dictionary of aggregation expression to use in the query. The key of each item in the dictionary is the alias for the aggregated column. Query can have up to 2 aggregation clauses.
        """
        return pulumi.get(self, "aggregation")

    @property
    @pulumi.getter
    def configuration(self) -> Optional['outputs.QueryDatasetConfigurationResponse']:
        """
        Has configuration information for the data in the export. The configuration will be ignored if aggregation and grouping are provided.
        """
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter
    def filter(self) -> Optional['outputs.QueryFilterResponse']:
        """
        The filter expression to use in the query. Please reference our Query API REST documentation for how to properly format the filter.
        """
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter
    def granularity(self) -> Optional[str]:
        """
        The granularity of rows in the query.
        """
        return pulumi.get(self, "granularity")

    @property
    @pulumi.getter
    def grouping(self) -> Optional[Sequence['outputs.QueryGroupingResponse']]:
        """
        Array of group by expression to use in the query. Query can have up to 2 group by clauses.
        """
        return pulumi.get(self, "grouping")

    @property
    @pulumi.getter
    def sorting(self) -> Optional[Sequence['outputs.QuerySortingConfigurationResponse']]:
        """
        Array of sorting by columns in query.
        """
        return pulumi.get(self, "sorting")


@pulumi.output_type
class QueryDefinitionResponse(dict):
    """
    The definition of a query.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timePeriod":
            suggest = "time_period"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in QueryDefinitionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        QueryDefinitionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        QueryDefinitionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 timeframe: str,
                 type: str,
                 dataset: Optional['outputs.QueryDatasetResponse'] = None,
                 time_period: Optional['outputs.QueryTimePeriodResponse'] = None):
        """
        The definition of a query.
        :param str timeframe: The time frame for pulling data for the query. If custom, then a specific time period must be provided.
        :param str type: The type of the query.
        :param 'QueryDatasetResponse' dataset: Has definition for data in this query.
        :param 'QueryTimePeriodResponse' time_period: Has time period for pulling data for the query.
        """
        pulumi.set(__self__, "timeframe", timeframe)
        pulumi.set(__self__, "type", type)
        if dataset is not None:
            pulumi.set(__self__, "dataset", dataset)
        if time_period is not None:
            pulumi.set(__self__, "time_period", time_period)

    @property
    @pulumi.getter
    def timeframe(self) -> str:
        """
        The time frame for pulling data for the query. If custom, then a specific time period must be provided.
        """
        return pulumi.get(self, "timeframe")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the query.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def dataset(self) -> Optional['outputs.QueryDatasetResponse']:
        """
        Has definition for data in this query.
        """
        return pulumi.get(self, "dataset")

    @property
    @pulumi.getter(name="timePeriod")
    def time_period(self) -> Optional['outputs.QueryTimePeriodResponse']:
        """
        Has time period for pulling data for the query.
        """
        return pulumi.get(self, "time_period")


@pulumi.output_type
class QueryFilterResponse(dict):
    """
    The filter expression to be used in the export.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "and":
            suggest = "and_"
        elif key == "not":
            suggest = "not_"
        elif key == "or":
            suggest = "or_"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in QueryFilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        QueryFilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        QueryFilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 and_: Optional[Sequence['outputs.QueryFilterResponse']] = None,
                 dimension: Optional['outputs.QueryComparisonExpressionResponse'] = None,
                 not_: Optional['outputs.QueryFilterResponse'] = None,
                 or_: Optional[Sequence['outputs.QueryFilterResponse']] = None,
                 tag: Optional['outputs.QueryComparisonExpressionResponse'] = None):
        """
        The filter expression to be used in the export.
        :param Sequence['QueryFilterResponse'] and_: The logical "AND" expression. Must have at least 2 items.
        :param 'QueryComparisonExpressionResponse' dimension: Has comparison expression for a dimension
        :param 'QueryFilterResponse' not_: The logical "NOT" expression.
        :param Sequence['QueryFilterResponse'] or_: The logical "OR" expression. Must have at least 2 items.
        :param 'QueryComparisonExpressionResponse' tag: Has comparison expression for a tag
        """
        if and_ is not None:
            pulumi.set(__self__, "and_", and_)
        if dimension is not None:
            pulumi.set(__self__, "dimension", dimension)
        if not_ is not None:
            pulumi.set(__self__, "not_", not_)
        if or_ is not None:
            pulumi.set(__self__, "or_", or_)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)

    @property
    @pulumi.getter(name="and")
    def and_(self) -> Optional[Sequence['outputs.QueryFilterResponse']]:
        """
        The logical "AND" expression. Must have at least 2 items.
        """
        return pulumi.get(self, "and_")

    @property
    @pulumi.getter
    def dimension(self) -> Optional['outputs.QueryComparisonExpressionResponse']:
        """
        Has comparison expression for a dimension
        """
        return pulumi.get(self, "dimension")

    @property
    @pulumi.getter(name="not")
    def not_(self) -> Optional['outputs.QueryFilterResponse']:
        """
        The logical "NOT" expression.
        """
        return pulumi.get(self, "not_")

    @property
    @pulumi.getter(name="or")
    def or_(self) -> Optional[Sequence['outputs.QueryFilterResponse']]:
        """
        The logical "OR" expression. Must have at least 2 items.
        """
        return pulumi.get(self, "or_")

    @property
    @pulumi.getter
    def tag(self) -> Optional['outputs.QueryComparisonExpressionResponse']:
        """
        Has comparison expression for a tag
        """
        return pulumi.get(self, "tag")


@pulumi.output_type
class QueryGroupingResponse(dict):
    """
    The group by expression to be used in the query.
    """
    def __init__(__self__, *,
                 name: str,
                 type: str):
        """
        The group by expression to be used in the query.
        :param str name: The name of the column to group.
        :param str type: Has type of the column to group.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the column to group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Has type of the column to group.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class QuerySortingConfigurationResponse(dict):
    """
    The configuration for sorting in the query.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "querySortingDirection":
            suggest = "query_sorting_direction"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in QuerySortingConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        QuerySortingConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        QuerySortingConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[str] = None,
                 query_sorting_direction: Optional[str] = None):
        """
        The configuration for sorting in the query.
        :param str name: The name of the column to use in sorting.
        :param str query_sorting_direction: The sorting direction
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if query_sorting_direction is not None:
            pulumi.set(__self__, "query_sorting_direction", query_sorting_direction)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the column to use in sorting.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="querySortingDirection")
    def query_sorting_direction(self) -> Optional[str]:
        """
        The sorting direction
        """
        return pulumi.get(self, "query_sorting_direction")


@pulumi.output_type
class QueryTimePeriodResponse(dict):
    """
    The start and end date for pulling data for the query.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "from":
            suggest = "from_"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in QueryTimePeriodResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        QueryTimePeriodResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        QueryTimePeriodResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 from_: str,
                 to: str):
        """
        The start and end date for pulling data for the query.
        :param str from_: The start date to pull data from.
        :param str to: The end date to pull data to.
        """
        pulumi.set(__self__, "from_", from_)
        pulumi.set(__self__, "to", to)

    @property
    @pulumi.getter(name="from")
    def from_(self) -> str:
        """
        The start date to pull data from.
        """
        return pulumi.get(self, "from_")

    @property
    @pulumi.getter
    def to(self) -> str:
        """
        The end date to pull data to.
        """
        return pulumi.get(self, "to")


