# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['SiteArgs', 'Site']

@pulumi.input_type
class SiteArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[str],
                 client_affinity_enabled: Optional[pulumi.Input[bool]] = None,
                 client_cert_enabled: Optional[pulumi.Input[bool]] = None,
                 cloning_info: Optional[pulumi.Input['CloningInfoArgs']] = None,
                 container_size: Optional[pulumi.Input[int]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 force_dns_registration: Optional[pulumi.Input[str]] = None,
                 gateway_site_name: Optional[pulumi.Input[str]] = None,
                 host_name_ssl_states: Optional[pulumi.Input[Sequence[pulumi.Input['HostNameSslStateArgs']]]] = None,
                 host_names_disabled: Optional[pulumi.Input[bool]] = None,
                 hosting_environment_profile: Optional[pulumi.Input['HostingEnvironmentProfileArgs']] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 max_number_of_workers: Optional[pulumi.Input[int]] = None,
                 micro_service: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 scm_site_also_stopped: Optional[pulumi.Input[bool]] = None,
                 server_farm_id: Optional[pulumi.Input[str]] = None,
                 site_config: Optional[pulumi.Input['SiteConfigArgs']] = None,
                 skip_custom_domain_verification: Optional[pulumi.Input[str]] = None,
                 skip_dns_registration: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 ttl_in_seconds: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Site resource.
        :param pulumi.Input[str] resource_group_name: Name of the resource group
        :param pulumi.Input[bool] client_affinity_enabled: Specifies if the client affinity is enabled when load balancing http request for multiple instances of the web app
        :param pulumi.Input[bool] client_cert_enabled: Specifies if the client certificate is enabled for the web app
        :param pulumi.Input['CloningInfoArgs'] cloning_info: This is only valid for web app creation. If specified, web app is cloned from 
                           a source web app
        :param pulumi.Input[int] container_size: Size of a function container
        :param pulumi.Input[bool] enabled: True if the site is enabled; otherwise, false. Setting this  value to false disables the site (takes the site off line).
        :param pulumi.Input[str] force_dns_registration: If true, web app hostname is force registered with DNS
        :param pulumi.Input[str] gateway_site_name: Name of gateway app associated with web app
        :param pulumi.Input[Sequence[pulumi.Input['HostNameSslStateArgs']]] host_name_ssl_states: Hostname SSL states are  used to manage the SSL bindings for site's hostnames.
        :param pulumi.Input[bool] host_names_disabled: Specifies if the public hostnames are disabled the web app.
                           If set to true the app is only accessible via API Management process
        :param pulumi.Input['HostingEnvironmentProfileArgs'] hosting_environment_profile: Specification for the hosting environment (App Service Environment) to use for the web app
        :param pulumi.Input[str] id: Resource Id
        :param pulumi.Input[str] kind: Kind of resource
        :param pulumi.Input[str] location: Resource Location
        :param pulumi.Input[int] max_number_of_workers: Maximum number of workers
                           This only applies to function container
        :param pulumi.Input[str] name: Resource Name
        :param pulumi.Input[bool] scm_site_also_stopped: If set indicates whether to stop SCM (KUDU) site when the web app is stopped. Default is false.
        :param pulumi.Input['SiteConfigArgs'] site_config: Configuration of web app
        :param pulumi.Input[str] skip_custom_domain_verification: If true, custom (non *.azurewebsites.net) domains associated with web app are not verified.
        :param pulumi.Input[str] skip_dns_registration: If true web app hostname is not registered with DNS on creation. This parameter is
                           only used for app creation
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Resource tags
        :param pulumi.Input[str] ttl_in_seconds: Time to live in seconds for web app's default domain name
        :param pulumi.Input[str] type: Resource type
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if client_affinity_enabled is not None:
            pulumi.set(__self__, "client_affinity_enabled", client_affinity_enabled)
        if client_cert_enabled is not None:
            pulumi.set(__self__, "client_cert_enabled", client_cert_enabled)
        if cloning_info is not None:
            pulumi.set(__self__, "cloning_info", cloning_info)
        if container_size is not None:
            pulumi.set(__self__, "container_size", container_size)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if force_dns_registration is not None:
            pulumi.set(__self__, "force_dns_registration", force_dns_registration)
        if gateway_site_name is not None:
            pulumi.set(__self__, "gateway_site_name", gateway_site_name)
        if host_name_ssl_states is not None:
            pulumi.set(__self__, "host_name_ssl_states", host_name_ssl_states)
        if host_names_disabled is not None:
            pulumi.set(__self__, "host_names_disabled", host_names_disabled)
        if hosting_environment_profile is not None:
            pulumi.set(__self__, "hosting_environment_profile", hosting_environment_profile)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if max_number_of_workers is not None:
            pulumi.set(__self__, "max_number_of_workers", max_number_of_workers)
        if micro_service is not None:
            pulumi.set(__self__, "micro_service", micro_service)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if scm_site_also_stopped is not None:
            pulumi.set(__self__, "scm_site_also_stopped", scm_site_also_stopped)
        if server_farm_id is not None:
            pulumi.set(__self__, "server_farm_id", server_farm_id)
        if site_config is not None:
            pulumi.set(__self__, "site_config", site_config)
        if skip_custom_domain_verification is not None:
            pulumi.set(__self__, "skip_custom_domain_verification", skip_custom_domain_verification)
        if skip_dns_registration is not None:
            pulumi.set(__self__, "skip_dns_registration", skip_dns_registration)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if ttl_in_seconds is not None:
            pulumi.set(__self__, "ttl_in_seconds", ttl_in_seconds)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[str]:
        """
        Name of the resource group
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="clientAffinityEnabled")
    def client_affinity_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies if the client affinity is enabled when load balancing http request for multiple instances of the web app
        """
        return pulumi.get(self, "client_affinity_enabled")

    @client_affinity_enabled.setter
    def client_affinity_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "client_affinity_enabled", value)

    @property
    @pulumi.getter(name="clientCertEnabled")
    def client_cert_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies if the client certificate is enabled for the web app
        """
        return pulumi.get(self, "client_cert_enabled")

    @client_cert_enabled.setter
    def client_cert_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "client_cert_enabled", value)

    @property
    @pulumi.getter(name="cloningInfo")
    def cloning_info(self) -> Optional[pulumi.Input['CloningInfoArgs']]:
        """
        This is only valid for web app creation. If specified, web app is cloned from 
                    a source web app
        """
        return pulumi.get(self, "cloning_info")

    @cloning_info.setter
    def cloning_info(self, value: Optional[pulumi.Input['CloningInfoArgs']]):
        pulumi.set(self, "cloning_info", value)

    @property
    @pulumi.getter(name="containerSize")
    def container_size(self) -> Optional[pulumi.Input[int]]:
        """
        Size of a function container
        """
        return pulumi.get(self, "container_size")

    @container_size.setter
    def container_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "container_size", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        True if the site is enabled; otherwise, false. Setting this  value to false disables the site (takes the site off line).
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="forceDnsRegistration")
    def force_dns_registration(self) -> Optional[pulumi.Input[str]]:
        """
        If true, web app hostname is force registered with DNS
        """
        return pulumi.get(self, "force_dns_registration")

    @force_dns_registration.setter
    def force_dns_registration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "force_dns_registration", value)

    @property
    @pulumi.getter(name="gatewaySiteName")
    def gateway_site_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of gateway app associated with web app
        """
        return pulumi.get(self, "gateway_site_name")

    @gateway_site_name.setter
    def gateway_site_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gateway_site_name", value)

    @property
    @pulumi.getter(name="hostNameSslStates")
    def host_name_ssl_states(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HostNameSslStateArgs']]]]:
        """
        Hostname SSL states are  used to manage the SSL bindings for site's hostnames.
        """
        return pulumi.get(self, "host_name_ssl_states")

    @host_name_ssl_states.setter
    def host_name_ssl_states(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HostNameSslStateArgs']]]]):
        pulumi.set(self, "host_name_ssl_states", value)

    @property
    @pulumi.getter(name="hostNamesDisabled")
    def host_names_disabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies if the public hostnames are disabled the web app.
                    If set to true the app is only accessible via API Management process
        """
        return pulumi.get(self, "host_names_disabled")

    @host_names_disabled.setter
    def host_names_disabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "host_names_disabled", value)

    @property
    @pulumi.getter(name="hostingEnvironmentProfile")
    def hosting_environment_profile(self) -> Optional[pulumi.Input['HostingEnvironmentProfileArgs']]:
        """
        Specification for the hosting environment (App Service Environment) to use for the web app
        """
        return pulumi.get(self, "hosting_environment_profile")

    @hosting_environment_profile.setter
    def hosting_environment_profile(self, value: Optional[pulumi.Input['HostingEnvironmentProfileArgs']]):
        pulumi.set(self, "hosting_environment_profile", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        Kind of resource
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Resource Location
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="maxNumberOfWorkers")
    def max_number_of_workers(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of workers
                    This only applies to function container
        """
        return pulumi.get(self, "max_number_of_workers")

    @max_number_of_workers.setter
    def max_number_of_workers(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_number_of_workers", value)

    @property
    @pulumi.getter(name="microService")
    def micro_service(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "micro_service")

    @micro_service.setter
    def micro_service(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "micro_service", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Resource Name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="scmSiteAlsoStopped")
    def scm_site_also_stopped(self) -> Optional[pulumi.Input[bool]]:
        """
        If set indicates whether to stop SCM (KUDU) site when the web app is stopped. Default is false.
        """
        return pulumi.get(self, "scm_site_also_stopped")

    @scm_site_also_stopped.setter
    def scm_site_also_stopped(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "scm_site_also_stopped", value)

    @property
    @pulumi.getter(name="serverFarmId")
    def server_farm_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "server_farm_id")

    @server_farm_id.setter
    def server_farm_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_farm_id", value)

    @property
    @pulumi.getter(name="siteConfig")
    def site_config(self) -> Optional[pulumi.Input['SiteConfigArgs']]:
        """
        Configuration of web app
        """
        return pulumi.get(self, "site_config")

    @site_config.setter
    def site_config(self, value: Optional[pulumi.Input['SiteConfigArgs']]):
        pulumi.set(self, "site_config", value)

    @property
    @pulumi.getter(name="skipCustomDomainVerification")
    def skip_custom_domain_verification(self) -> Optional[pulumi.Input[str]]:
        """
        If true, custom (non *.azurewebsites.net) domains associated with web app are not verified.
        """
        return pulumi.get(self, "skip_custom_domain_verification")

    @skip_custom_domain_verification.setter
    def skip_custom_domain_verification(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "skip_custom_domain_verification", value)

    @property
    @pulumi.getter(name="skipDnsRegistration")
    def skip_dns_registration(self) -> Optional[pulumi.Input[str]]:
        """
        If true web app hostname is not registered with DNS on creation. This parameter is
                    only used for app creation
        """
        return pulumi.get(self, "skip_dns_registration")

    @skip_dns_registration.setter
    def skip_dns_registration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "skip_dns_registration", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Resource tags
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="ttlInSeconds")
    def ttl_in_seconds(self) -> Optional[pulumi.Input[str]]:
        """
        Time to live in seconds for web app's default domain name
        """
        return pulumi.get(self, "ttl_in_seconds")

    @ttl_in_seconds.setter
    def ttl_in_seconds(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ttl_in_seconds", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Resource type
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


class Site(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 client_affinity_enabled: Optional[pulumi.Input[bool]] = None,
                 client_cert_enabled: Optional[pulumi.Input[bool]] = None,
                 cloning_info: Optional[pulumi.Input[pulumi.InputType['CloningInfoArgs']]] = None,
                 container_size: Optional[pulumi.Input[int]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 force_dns_registration: Optional[pulumi.Input[str]] = None,
                 gateway_site_name: Optional[pulumi.Input[str]] = None,
                 host_name_ssl_states: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['HostNameSslStateArgs']]]]] = None,
                 host_names_disabled: Optional[pulumi.Input[bool]] = None,
                 hosting_environment_profile: Optional[pulumi.Input[pulumi.InputType['HostingEnvironmentProfileArgs']]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 max_number_of_workers: Optional[pulumi.Input[int]] = None,
                 micro_service: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 scm_site_also_stopped: Optional[pulumi.Input[bool]] = None,
                 server_farm_id: Optional[pulumi.Input[str]] = None,
                 site_config: Optional[pulumi.Input[pulumi.InputType['SiteConfigArgs']]] = None,
                 skip_custom_domain_verification: Optional[pulumi.Input[str]] = None,
                 skip_dns_registration: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 ttl_in_seconds: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Represents a web app

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] client_affinity_enabled: Specifies if the client affinity is enabled when load balancing http request for multiple instances of the web app
        :param pulumi.Input[bool] client_cert_enabled: Specifies if the client certificate is enabled for the web app
        :param pulumi.Input[pulumi.InputType['CloningInfoArgs']] cloning_info: This is only valid for web app creation. If specified, web app is cloned from 
                           a source web app
        :param pulumi.Input[int] container_size: Size of a function container
        :param pulumi.Input[bool] enabled: True if the site is enabled; otherwise, false. Setting this  value to false disables the site (takes the site off line).
        :param pulumi.Input[str] force_dns_registration: If true, web app hostname is force registered with DNS
        :param pulumi.Input[str] gateway_site_name: Name of gateway app associated with web app
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['HostNameSslStateArgs']]]] host_name_ssl_states: Hostname SSL states are  used to manage the SSL bindings for site's hostnames.
        :param pulumi.Input[bool] host_names_disabled: Specifies if the public hostnames are disabled the web app.
                           If set to true the app is only accessible via API Management process
        :param pulumi.Input[pulumi.InputType['HostingEnvironmentProfileArgs']] hosting_environment_profile: Specification for the hosting environment (App Service Environment) to use for the web app
        :param pulumi.Input[str] id: Resource Id
        :param pulumi.Input[str] kind: Kind of resource
        :param pulumi.Input[str] location: Resource Location
        :param pulumi.Input[int] max_number_of_workers: Maximum number of workers
                           This only applies to function container
        :param pulumi.Input[str] name: Resource Name
        :param pulumi.Input[str] resource_group_name: Name of the resource group
        :param pulumi.Input[bool] scm_site_also_stopped: If set indicates whether to stop SCM (KUDU) site when the web app is stopped. Default is false.
        :param pulumi.Input[pulumi.InputType['SiteConfigArgs']] site_config: Configuration of web app
        :param pulumi.Input[str] skip_custom_domain_verification: If true, custom (non *.azurewebsites.net) domains associated with web app are not verified.
        :param pulumi.Input[str] skip_dns_registration: If true web app hostname is not registered with DNS on creation. This parameter is
                           only used for app creation
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Resource tags
        :param pulumi.Input[str] ttl_in_seconds: Time to live in seconds for web app's default domain name
        :param pulumi.Input[str] type: Resource type
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SiteArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Represents a web app

        :param str resource_name: The name of the resource.
        :param SiteArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SiteArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 client_affinity_enabled: Optional[pulumi.Input[bool]] = None,
                 client_cert_enabled: Optional[pulumi.Input[bool]] = None,
                 cloning_info: Optional[pulumi.Input[pulumi.InputType['CloningInfoArgs']]] = None,
                 container_size: Optional[pulumi.Input[int]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 force_dns_registration: Optional[pulumi.Input[str]] = None,
                 gateway_site_name: Optional[pulumi.Input[str]] = None,
                 host_name_ssl_states: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['HostNameSslStateArgs']]]]] = None,
                 host_names_disabled: Optional[pulumi.Input[bool]] = None,
                 hosting_environment_profile: Optional[pulumi.Input[pulumi.InputType['HostingEnvironmentProfileArgs']]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 max_number_of_workers: Optional[pulumi.Input[int]] = None,
                 micro_service: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 scm_site_also_stopped: Optional[pulumi.Input[bool]] = None,
                 server_farm_id: Optional[pulumi.Input[str]] = None,
                 site_config: Optional[pulumi.Input[pulumi.InputType['SiteConfigArgs']]] = None,
                 skip_custom_domain_verification: Optional[pulumi.Input[str]] = None,
                 skip_dns_registration: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 ttl_in_seconds: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SiteArgs.__new__(SiteArgs)

            __props__.__dict__["client_affinity_enabled"] = client_affinity_enabled
            __props__.__dict__["client_cert_enabled"] = client_cert_enabled
            __props__.__dict__["cloning_info"] = cloning_info
            __props__.__dict__["container_size"] = container_size
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["force_dns_registration"] = force_dns_registration
            __props__.__dict__["gateway_site_name"] = gateway_site_name
            __props__.__dict__["host_name_ssl_states"] = host_name_ssl_states
            __props__.__dict__["host_names_disabled"] = host_names_disabled
            __props__.__dict__["hosting_environment_profile"] = hosting_environment_profile
            __props__.__dict__["id"] = id
            __props__.__dict__["kind"] = kind
            __props__.__dict__["location"] = location
            __props__.__dict__["max_number_of_workers"] = max_number_of_workers
            __props__.__dict__["micro_service"] = micro_service
            __props__.__dict__["name"] = name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["scm_site_also_stopped"] = scm_site_also_stopped
            __props__.__dict__["server_farm_id"] = server_farm_id
            __props__.__dict__["site_config"] = site_config
            __props__.__dict__["skip_custom_domain_verification"] = skip_custom_domain_verification
            __props__.__dict__["skip_dns_registration"] = skip_dns_registration
            __props__.__dict__["tags"] = tags
            __props__.__dict__["ttl_in_seconds"] = ttl_in_seconds
            __props__.__dict__["type"] = type
            __props__.__dict__["availability_state"] = None
            __props__.__dict__["default_host_name"] = None
            __props__.__dict__["enabled_host_names"] = None
            __props__.__dict__["host_names"] = None
            __props__.__dict__["is_default_container"] = None
            __props__.__dict__["last_modified_time_utc"] = None
            __props__.__dict__["outbound_ip_addresses"] = None
            __props__.__dict__["premium_app_deployed"] = None
            __props__.__dict__["repository_site_name"] = None
            __props__.__dict__["resource_group"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["target_swap_slot"] = None
            __props__.__dict__["traffic_manager_host_names"] = None
            __props__.__dict__["usage_state"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="azure-native:web:Site"), pulumi.Alias(type_="azure-native:web/v20160801:Site"), pulumi.Alias(type_="azure-native:web/v20180201:Site"), pulumi.Alias(type_="azure-native:web/v20181101:Site"), pulumi.Alias(type_="azure-native:web/v20190801:Site"), pulumi.Alias(type_="azure-native:web/v20200601:Site"), pulumi.Alias(type_="azure-native:web/v20200901:Site"), pulumi.Alias(type_="azure-native:web/v20201001:Site"), pulumi.Alias(type_="azure-native:web/v20201201:Site"), pulumi.Alias(type_="azure-native:web/v20210101:Site"), pulumi.Alias(type_="azure-native:web/v20210115:Site"), pulumi.Alias(type_="azure-native:web/v20210201:Site"), pulumi.Alias(type_="azure-native:web/v20210301:Site")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(Site, __self__).__init__(
            'azure-native:web/v20150801:Site',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Site':
        """
        Get an existing Site resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = SiteArgs.__new__(SiteArgs)

        __props__.__dict__["availability_state"] = None
        __props__.__dict__["client_affinity_enabled"] = None
        __props__.__dict__["client_cert_enabled"] = None
        __props__.__dict__["cloning_info"] = None
        __props__.__dict__["container_size"] = None
        __props__.__dict__["default_host_name"] = None
        __props__.__dict__["enabled"] = None
        __props__.__dict__["enabled_host_names"] = None
        __props__.__dict__["gateway_site_name"] = None
        __props__.__dict__["host_name_ssl_states"] = None
        __props__.__dict__["host_names"] = None
        __props__.__dict__["host_names_disabled"] = None
        __props__.__dict__["hosting_environment_profile"] = None
        __props__.__dict__["is_default_container"] = None
        __props__.__dict__["kind"] = None
        __props__.__dict__["last_modified_time_utc"] = None
        __props__.__dict__["location"] = None
        __props__.__dict__["max_number_of_workers"] = None
        __props__.__dict__["micro_service"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["outbound_ip_addresses"] = None
        __props__.__dict__["premium_app_deployed"] = None
        __props__.__dict__["repository_site_name"] = None
        __props__.__dict__["resource_group"] = None
        __props__.__dict__["scm_site_also_stopped"] = None
        __props__.__dict__["server_farm_id"] = None
        __props__.__dict__["site_config"] = None
        __props__.__dict__["state"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["target_swap_slot"] = None
        __props__.__dict__["traffic_manager_host_names"] = None
        __props__.__dict__["type"] = None
        __props__.__dict__["usage_state"] = None
        return Site(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="availabilityState")
    def availability_state(self) -> pulumi.Output[str]:
        """
        Management information availability state for the web app. Possible values are Normal or Limited. 
                    Normal means that the site is running correctly and that management information for the site is available. 
                    Limited means that only partial management information for the site is available and that detailed site information is unavailable.
        """
        return pulumi.get(self, "availability_state")

    @property
    @pulumi.getter(name="clientAffinityEnabled")
    def client_affinity_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies if the client affinity is enabled when load balancing http request for multiple instances of the web app
        """
        return pulumi.get(self, "client_affinity_enabled")

    @property
    @pulumi.getter(name="clientCertEnabled")
    def client_cert_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies if the client certificate is enabled for the web app
        """
        return pulumi.get(self, "client_cert_enabled")

    @property
    @pulumi.getter(name="cloningInfo")
    def cloning_info(self) -> pulumi.Output[Optional['outputs.CloningInfoResponse']]:
        """
        This is only valid for web app creation. If specified, web app is cloned from 
                    a source web app
        """
        return pulumi.get(self, "cloning_info")

    @property
    @pulumi.getter(name="containerSize")
    def container_size(self) -> pulumi.Output[Optional[int]]:
        """
        Size of a function container
        """
        return pulumi.get(self, "container_size")

    @property
    @pulumi.getter(name="defaultHostName")
    def default_host_name(self) -> pulumi.Output[str]:
        """
        Default hostname of the web app
        """
        return pulumi.get(self, "default_host_name")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        True if the site is enabled; otherwise, false. Setting this  value to false disables the site (takes the site off line).
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="enabledHostNames")
    def enabled_host_names(self) -> pulumi.Output[Sequence[str]]:
        """
        Hostnames for the web app that are enabled. Hostnames need to be assigned and enabled. If some hostnames are assigned but not enabled
                    the app is not served on those hostnames
        """
        return pulumi.get(self, "enabled_host_names")

    @property
    @pulumi.getter(name="gatewaySiteName")
    def gateway_site_name(self) -> pulumi.Output[Optional[str]]:
        """
        Name of gateway app associated with web app
        """
        return pulumi.get(self, "gateway_site_name")

    @property
    @pulumi.getter(name="hostNameSslStates")
    def host_name_ssl_states(self) -> pulumi.Output[Optional[Sequence['outputs.HostNameSslStateResponse']]]:
        """
        Hostname SSL states are  used to manage the SSL bindings for site's hostnames.
        """
        return pulumi.get(self, "host_name_ssl_states")

    @property
    @pulumi.getter(name="hostNames")
    def host_names(self) -> pulumi.Output[Sequence[str]]:
        """
        Hostnames associated with web app
        """
        return pulumi.get(self, "host_names")

    @property
    @pulumi.getter(name="hostNamesDisabled")
    def host_names_disabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies if the public hostnames are disabled the web app.
                    If set to true the app is only accessible via API Management process
        """
        return pulumi.get(self, "host_names_disabled")

    @property
    @pulumi.getter(name="hostingEnvironmentProfile")
    def hosting_environment_profile(self) -> pulumi.Output[Optional['outputs.HostingEnvironmentProfileResponse']]:
        """
        Specification for the hosting environment (App Service Environment) to use for the web app
        """
        return pulumi.get(self, "hosting_environment_profile")

    @property
    @pulumi.getter(name="isDefaultContainer")
    def is_default_container(self) -> pulumi.Output[bool]:
        """
        Site is a default container
        """
        return pulumi.get(self, "is_default_container")

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Output[Optional[str]]:
        """
        Kind of resource
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="lastModifiedTimeUtc")
    def last_modified_time_utc(self) -> pulumi.Output[str]:
        """
        Last time web app was modified in UTC
        """
        return pulumi.get(self, "last_modified_time_utc")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        """
        Resource Location
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="maxNumberOfWorkers")
    def max_number_of_workers(self) -> pulumi.Output[Optional[int]]:
        """
        Maximum number of workers
                    This only applies to function container
        """
        return pulumi.get(self, "max_number_of_workers")

    @property
    @pulumi.getter(name="microService")
    def micro_service(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "micro_service")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[Optional[str]]:
        """
        Resource Name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="outboundIpAddresses")
    def outbound_ip_addresses(self) -> pulumi.Output[str]:
        """
        List of comma separated IP addresses that this web app uses for outbound connections. Those can be used when configuring firewall rules for databases accessed by this web app.
        """
        return pulumi.get(self, "outbound_ip_addresses")

    @property
    @pulumi.getter(name="premiumAppDeployed")
    def premium_app_deployed(self) -> pulumi.Output[bool]:
        """
        If set indicates whether web app is deployed as a premium app
        """
        return pulumi.get(self, "premium_app_deployed")

    @property
    @pulumi.getter(name="repositorySiteName")
    def repository_site_name(self) -> pulumi.Output[str]:
        """
        Name of repository site
        """
        return pulumi.get(self, "repository_site_name")

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> pulumi.Output[str]:
        """
        Resource group web app belongs to
        """
        return pulumi.get(self, "resource_group")

    @property
    @pulumi.getter(name="scmSiteAlsoStopped")
    def scm_site_also_stopped(self) -> pulumi.Output[Optional[bool]]:
        """
        If set indicates whether to stop SCM (KUDU) site when the web app is stopped. Default is false.
        """
        return pulumi.get(self, "scm_site_also_stopped")

    @property
    @pulumi.getter(name="serverFarmId")
    def server_farm_id(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "server_farm_id")

    @property
    @pulumi.getter(name="siteConfig")
    def site_config(self) -> pulumi.Output[Optional['outputs.SiteConfigResponse']]:
        """
        Configuration of web app
        """
        return pulumi.get(self, "site_config")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        State of the web app
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Resource tags
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="targetSwapSlot")
    def target_swap_slot(self) -> pulumi.Output[str]:
        """
        Read-only property that specifies which slot this app will swap into
        """
        return pulumi.get(self, "target_swap_slot")

    @property
    @pulumi.getter(name="trafficManagerHostNames")
    def traffic_manager_host_names(self) -> pulumi.Output[Sequence[str]]:
        """
        Read-only list of Azure Traffic manager hostnames associated with web app
        """
        return pulumi.get(self, "traffic_manager_host_names")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[str]]:
        """
        Resource type
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="usageState")
    def usage_state(self) -> pulumi.Output[str]:
        """
        State indicating whether web app has exceeded its quota usage
        """
        return pulumi.get(self, "usage_state")

