# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AutoscaleNotificationResponse',
    'AutoscaleProfileResponse',
    'EmailNotificationResponse',
    'LocationThresholdRuleConditionResponse',
    'ManagementEventAggregationConditionResponse',
    'ManagementEventRuleConditionResponse',
    'MetricTriggerResponse',
    'RecurrenceResponse',
    'RecurrentScheduleResponse',
    'RuleEmailActionResponse',
    'RuleManagementEventClaimsDataSourceResponse',
    'RuleManagementEventDataSourceResponse',
    'RuleMetricDataSourceResponse',
    'RuleWebhookActionResponse',
    'ScaleActionResponse',
    'ScaleCapacityResponse',
    'ScaleRuleMetricDimensionResponse',
    'ScaleRuleResponse',
    'ThresholdRuleConditionResponse',
    'TimeWindowResponse',
    'WebhookNotificationResponse',
]

@pulumi.output_type
class AutoscaleNotificationResponse(dict):
    """
    Autoscale notification.
    """
    def __init__(__self__, *,
                 operation: str,
                 email: Optional['outputs.EmailNotificationResponse'] = None,
                 webhooks: Optional[Sequence['outputs.WebhookNotificationResponse']] = None):
        """
        Autoscale notification.
        :param str operation: the operation associated with the notification and its value must be "scale"
        :param 'EmailNotificationResponse' email: the email notification.
        :param Sequence['WebhookNotificationResponse'] webhooks: the collection of webhook notifications.
        """
        pulumi.set(__self__, "operation", operation)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if webhooks is not None:
            pulumi.set(__self__, "webhooks", webhooks)

    @property
    @pulumi.getter
    def operation(self) -> str:
        """
        the operation associated with the notification and its value must be "scale"
        """
        return pulumi.get(self, "operation")

    @property
    @pulumi.getter
    def email(self) -> Optional['outputs.EmailNotificationResponse']:
        """
        the email notification.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def webhooks(self) -> Optional[Sequence['outputs.WebhookNotificationResponse']]:
        """
        the collection of webhook notifications.
        """
        return pulumi.get(self, "webhooks")


@pulumi.output_type
class AutoscaleProfileResponse(dict):
    """
    Autoscale profile.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fixedDate":
            suggest = "fixed_date"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoscaleProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoscaleProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoscaleProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 capacity: 'outputs.ScaleCapacityResponse',
                 name: str,
                 rules: Sequence['outputs.ScaleRuleResponse'],
                 fixed_date: Optional['outputs.TimeWindowResponse'] = None,
                 recurrence: Optional['outputs.RecurrenceResponse'] = None):
        """
        Autoscale profile.
        :param 'ScaleCapacityResponse' capacity: the number of instances that can be used during this profile.
        :param str name: the name of the profile.
        :param Sequence['ScaleRuleResponse'] rules: the collection of rules that provide the triggers and parameters for the scaling action. A maximum of 10 rules can be specified.
        :param 'TimeWindowResponse' fixed_date: the specific date-time for the profile. This element is not used if the Recurrence element is used.
        :param 'RecurrenceResponse' recurrence: the repeating times at which this profile begins. This element is not used if the FixedDate element is used.
        """
        pulumi.set(__self__, "capacity", capacity)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "rules", rules)
        if fixed_date is not None:
            pulumi.set(__self__, "fixed_date", fixed_date)
        if recurrence is not None:
            pulumi.set(__self__, "recurrence", recurrence)

    @property
    @pulumi.getter
    def capacity(self) -> 'outputs.ScaleCapacityResponse':
        """
        the number of instances that can be used during this profile.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        the name of the profile.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.ScaleRuleResponse']:
        """
        the collection of rules that provide the triggers and parameters for the scaling action. A maximum of 10 rules can be specified.
        """
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter(name="fixedDate")
    def fixed_date(self) -> Optional['outputs.TimeWindowResponse']:
        """
        the specific date-time for the profile. This element is not used if the Recurrence element is used.
        """
        return pulumi.get(self, "fixed_date")

    @property
    @pulumi.getter
    def recurrence(self) -> Optional['outputs.RecurrenceResponse']:
        """
        the repeating times at which this profile begins. This element is not used if the FixedDate element is used.
        """
        return pulumi.get(self, "recurrence")


@pulumi.output_type
class EmailNotificationResponse(dict):
    """
    Email notification of an autoscale event.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customEmails":
            suggest = "custom_emails"
        elif key == "sendToSubscriptionAdministrator":
            suggest = "send_to_subscription_administrator"
        elif key == "sendToSubscriptionCoAdministrators":
            suggest = "send_to_subscription_co_administrators"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EmailNotificationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EmailNotificationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EmailNotificationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_emails: Optional[Sequence[str]] = None,
                 send_to_subscription_administrator: Optional[bool] = None,
                 send_to_subscription_co_administrators: Optional[bool] = None):
        """
        Email notification of an autoscale event.
        :param Sequence[str] custom_emails: the custom e-mails list. This value can be null or empty, in which case this attribute will be ignored.
        :param bool send_to_subscription_administrator: a value indicating whether to send email to subscription administrator.
        :param bool send_to_subscription_co_administrators: a value indicating whether to send email to subscription co-administrators.
        """
        if custom_emails is not None:
            pulumi.set(__self__, "custom_emails", custom_emails)
        if send_to_subscription_administrator is None:
            send_to_subscription_administrator = False
        if send_to_subscription_administrator is not None:
            pulumi.set(__self__, "send_to_subscription_administrator", send_to_subscription_administrator)
        if send_to_subscription_co_administrators is None:
            send_to_subscription_co_administrators = False
        if send_to_subscription_co_administrators is not None:
            pulumi.set(__self__, "send_to_subscription_co_administrators", send_to_subscription_co_administrators)

    @property
    @pulumi.getter(name="customEmails")
    def custom_emails(self) -> Optional[Sequence[str]]:
        """
        the custom e-mails list. This value can be null or empty, in which case this attribute will be ignored.
        """
        return pulumi.get(self, "custom_emails")

    @property
    @pulumi.getter(name="sendToSubscriptionAdministrator")
    def send_to_subscription_administrator(self) -> Optional[bool]:
        """
        a value indicating whether to send email to subscription administrator.
        """
        return pulumi.get(self, "send_to_subscription_administrator")

    @property
    @pulumi.getter(name="sendToSubscriptionCoAdministrators")
    def send_to_subscription_co_administrators(self) -> Optional[bool]:
        """
        a value indicating whether to send email to subscription co-administrators.
        """
        return pulumi.get(self, "send_to_subscription_co_administrators")


@pulumi.output_type
class LocationThresholdRuleConditionResponse(dict):
    """
    A rule condition based on a certain number of locations failing.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failedLocationCount":
            suggest = "failed_location_count"
        elif key == "odataType":
            suggest = "odata_type"
        elif key == "dataSource":
            suggest = "data_source"
        elif key == "windowSize":
            suggest = "window_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LocationThresholdRuleConditionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LocationThresholdRuleConditionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LocationThresholdRuleConditionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 failed_location_count: int,
                 odata_type: str,
                 data_source: Optional[Any] = None,
                 window_size: Optional[str] = None):
        """
        A rule condition based on a certain number of locations failing.
        :param int failed_location_count: the number of locations that must fail to activate the alert.
        :param str odata_type: specifies the type of condition. This can be one of three types: ManagementEventRuleCondition (occurrences of management events), LocationThresholdRuleCondition (based on the number of failures of a web test), and ThresholdRuleCondition (based on the threshold of a metric).
               Expected value is 'Microsoft.Azure.Management.Insights.Models.LocationThresholdRuleCondition'.
        :param Union['RuleManagementEventDataSourceResponse', 'RuleMetricDataSourceResponse'] data_source: the resource from which the rule collects its data. For this type dataSource will always be of type RuleMetricDataSource.
        :param str window_size: the period of time (in ISO 8601 duration format) that is used to monitor alert activity based on the threshold. If specified then it must be between 5 minutes and 1 day.
        """
        pulumi.set(__self__, "failed_location_count", failed_location_count)
        pulumi.set(__self__, "odata_type", 'Microsoft.Azure.Management.Insights.Models.LocationThresholdRuleCondition')
        if data_source is not None:
            pulumi.set(__self__, "data_source", data_source)
        if window_size is not None:
            pulumi.set(__self__, "window_size", window_size)

    @property
    @pulumi.getter(name="failedLocationCount")
    def failed_location_count(self) -> int:
        """
        the number of locations that must fail to activate the alert.
        """
        return pulumi.get(self, "failed_location_count")

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        specifies the type of condition. This can be one of three types: ManagementEventRuleCondition (occurrences of management events), LocationThresholdRuleCondition (based on the number of failures of a web test), and ThresholdRuleCondition (based on the threshold of a metric).
        Expected value is 'Microsoft.Azure.Management.Insights.Models.LocationThresholdRuleCondition'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="dataSource")
    def data_source(self) -> Optional[Any]:
        """
        the resource from which the rule collects its data. For this type dataSource will always be of type RuleMetricDataSource.
        """
        return pulumi.get(self, "data_source")

    @property
    @pulumi.getter(name="windowSize")
    def window_size(self) -> Optional[str]:
        """
        the period of time (in ISO 8601 duration format) that is used to monitor alert activity based on the threshold. If specified then it must be between 5 minutes and 1 day.
        """
        return pulumi.get(self, "window_size")


@pulumi.output_type
class ManagementEventAggregationConditionResponse(dict):
    """
    How the data that is collected should be combined over time.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "windowSize":
            suggest = "window_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagementEventAggregationConditionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagementEventAggregationConditionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagementEventAggregationConditionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operator: Optional[str] = None,
                 threshold: Optional[float] = None,
                 window_size: Optional[str] = None):
        """
        How the data that is collected should be combined over time.
        :param str operator: the condition operator.
        :param float threshold: The threshold value that activates the alert.
        :param str window_size: the period of time (in ISO 8601 duration format) that is used to monitor alert activity based on the threshold. If specified then it must be between 5 minutes and 1 day.
        """
        if operator is not None:
            pulumi.set(__self__, "operator", operator)
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)
        if window_size is not None:
            pulumi.set(__self__, "window_size", window_size)

    @property
    @pulumi.getter
    def operator(self) -> Optional[str]:
        """
        the condition operator.
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter
    def threshold(self) -> Optional[float]:
        """
        The threshold value that activates the alert.
        """
        return pulumi.get(self, "threshold")

    @property
    @pulumi.getter(name="windowSize")
    def window_size(self) -> Optional[str]:
        """
        the period of time (in ISO 8601 duration format) that is used to monitor alert activity based on the threshold. If specified then it must be between 5 minutes and 1 day.
        """
        return pulumi.get(self, "window_size")


@pulumi.output_type
class ManagementEventRuleConditionResponse(dict):
    """
    A management event rule condition.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "dataSource":
            suggest = "data_source"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagementEventRuleConditionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagementEventRuleConditionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagementEventRuleConditionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 aggregation: Optional['outputs.ManagementEventAggregationConditionResponse'] = None,
                 data_source: Optional[Any] = None):
        """
        A management event rule condition.
        :param str odata_type: specifies the type of condition. This can be one of three types: ManagementEventRuleCondition (occurrences of management events), LocationThresholdRuleCondition (based on the number of failures of a web test), and ThresholdRuleCondition (based on the threshold of a metric).
               Expected value is 'Microsoft.Azure.Management.Insights.Models.ManagementEventRuleCondition'.
        :param 'ManagementEventAggregationConditionResponse' aggregation: How the data that is collected should be combined over time and when the alert is activated. Note that for management event alerts aggregation is optional – if it is not provided then any event will cause the alert to activate.
        :param Union['RuleManagementEventDataSourceResponse', 'RuleMetricDataSourceResponse'] data_source: the resource from which the rule collects its data. For this type dataSource will always be of type RuleMetricDataSource.
        """
        pulumi.set(__self__, "odata_type", 'Microsoft.Azure.Management.Insights.Models.ManagementEventRuleCondition')
        if aggregation is not None:
            pulumi.set(__self__, "aggregation", aggregation)
        if data_source is not None:
            pulumi.set(__self__, "data_source", data_source)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        specifies the type of condition. This can be one of three types: ManagementEventRuleCondition (occurrences of management events), LocationThresholdRuleCondition (based on the number of failures of a web test), and ThresholdRuleCondition (based on the threshold of a metric).
        Expected value is 'Microsoft.Azure.Management.Insights.Models.ManagementEventRuleCondition'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter
    def aggregation(self) -> Optional['outputs.ManagementEventAggregationConditionResponse']:
        """
        How the data that is collected should be combined over time and when the alert is activated. Note that for management event alerts aggregation is optional – if it is not provided then any event will cause the alert to activate.
        """
        return pulumi.get(self, "aggregation")

    @property
    @pulumi.getter(name="dataSource")
    def data_source(self) -> Optional[Any]:
        """
        the resource from which the rule collects its data. For this type dataSource will always be of type RuleMetricDataSource.
        """
        return pulumi.get(self, "data_source")


@pulumi.output_type
class MetricTriggerResponse(dict):
    """
    The trigger that results in a scaling action.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricName":
            suggest = "metric_name"
        elif key == "metricResourceUri":
            suggest = "metric_resource_uri"
        elif key == "timeAggregation":
            suggest = "time_aggregation"
        elif key == "timeGrain":
            suggest = "time_grain"
        elif key == "timeWindow":
            suggest = "time_window"
        elif key == "dividePerInstance":
            suggest = "divide_per_instance"
        elif key == "metricNamespace":
            suggest = "metric_namespace"
        elif key == "metricResourceLocation":
            suggest = "metric_resource_location"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetricTriggerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetricTriggerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetricTriggerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metric_name: str,
                 metric_resource_uri: str,
                 operator: str,
                 statistic: str,
                 threshold: float,
                 time_aggregation: str,
                 time_grain: str,
                 time_window: str,
                 dimensions: Optional[Sequence['outputs.ScaleRuleMetricDimensionResponse']] = None,
                 divide_per_instance: Optional[bool] = None,
                 metric_namespace: Optional[str] = None,
                 metric_resource_location: Optional[str] = None):
        """
        The trigger that results in a scaling action.
        :param str metric_name: the name of the metric that defines what the rule monitors.
        :param str metric_resource_uri: the resource identifier of the resource the rule monitors.
        :param str operator: the operator that is used to compare the metric data and the threshold.
        :param str statistic: the metric statistic type. How the metrics from multiple instances are combined.
        :param float threshold: the threshold of the metric that triggers the scale action.
        :param str time_aggregation: time aggregation type. How the data that is collected should be combined over time. The default value is Average.
        :param str time_grain: the granularity of metrics the rule monitors. Must be one of the predefined values returned from metric definitions for the metric. Must be between 12 hours and 1 minute.
        :param str time_window: the range of time in which instance data is collected. This value must be greater than the delay in metric collection, which can vary from resource-to-resource. Must be between 12 hours and 5 minutes.
        :param Sequence['ScaleRuleMetricDimensionResponse'] dimensions: List of dimension conditions. For example: [{"DimensionName":"AppName","Operator":"Equals","Values":["App1"]},{"DimensionName":"Deployment","Operator":"Equals","Values":["default"]}].
        :param bool divide_per_instance: a value indicating whether metric should divide per instance.
        :param str metric_namespace: the namespace of the metric that defines what the rule monitors.
        :param str metric_resource_location: the location of the resource the rule monitors.
        """
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "metric_resource_uri", metric_resource_uri)
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "statistic", statistic)
        pulumi.set(__self__, "threshold", threshold)
        pulumi.set(__self__, "time_aggregation", time_aggregation)
        pulumi.set(__self__, "time_grain", time_grain)
        pulumi.set(__self__, "time_window", time_window)
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if divide_per_instance is not None:
            pulumi.set(__self__, "divide_per_instance", divide_per_instance)
        if metric_namespace is not None:
            pulumi.set(__self__, "metric_namespace", metric_namespace)
        if metric_resource_location is not None:
            pulumi.set(__self__, "metric_resource_location", metric_resource_location)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> str:
        """
        the name of the metric that defines what the rule monitors.
        """
        return pulumi.get(self, "metric_name")

    @property
    @pulumi.getter(name="metricResourceUri")
    def metric_resource_uri(self) -> str:
        """
        the resource identifier of the resource the rule monitors.
        """
        return pulumi.get(self, "metric_resource_uri")

    @property
    @pulumi.getter
    def operator(self) -> str:
        """
        the operator that is used to compare the metric data and the threshold.
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter
    def statistic(self) -> str:
        """
        the metric statistic type. How the metrics from multiple instances are combined.
        """
        return pulumi.get(self, "statistic")

    @property
    @pulumi.getter
    def threshold(self) -> float:
        """
        the threshold of the metric that triggers the scale action.
        """
        return pulumi.get(self, "threshold")

    @property
    @pulumi.getter(name="timeAggregation")
    def time_aggregation(self) -> str:
        """
        time aggregation type. How the data that is collected should be combined over time. The default value is Average.
        """
        return pulumi.get(self, "time_aggregation")

    @property
    @pulumi.getter(name="timeGrain")
    def time_grain(self) -> str:
        """
        the granularity of metrics the rule monitors. Must be one of the predefined values returned from metric definitions for the metric. Must be between 12 hours and 1 minute.
        """
        return pulumi.get(self, "time_grain")

    @property
    @pulumi.getter(name="timeWindow")
    def time_window(self) -> str:
        """
        the range of time in which instance data is collected. This value must be greater than the delay in metric collection, which can vary from resource-to-resource. Must be between 12 hours and 5 minutes.
        """
        return pulumi.get(self, "time_window")

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[Sequence['outputs.ScaleRuleMetricDimensionResponse']]:
        """
        List of dimension conditions. For example: [{"DimensionName":"AppName","Operator":"Equals","Values":["App1"]},{"DimensionName":"Deployment","Operator":"Equals","Values":["default"]}].
        """
        return pulumi.get(self, "dimensions")

    @property
    @pulumi.getter(name="dividePerInstance")
    def divide_per_instance(self) -> Optional[bool]:
        """
        a value indicating whether metric should divide per instance.
        """
        return pulumi.get(self, "divide_per_instance")

    @property
    @pulumi.getter(name="metricNamespace")
    def metric_namespace(self) -> Optional[str]:
        """
        the namespace of the metric that defines what the rule monitors.
        """
        return pulumi.get(self, "metric_namespace")

    @property
    @pulumi.getter(name="metricResourceLocation")
    def metric_resource_location(self) -> Optional[str]:
        """
        the location of the resource the rule monitors.
        """
        return pulumi.get(self, "metric_resource_location")


@pulumi.output_type
class RecurrenceResponse(dict):
    """
    The repeating times at which this profile begins. This element is not used if the FixedDate element is used.
    """
    def __init__(__self__, *,
                 frequency: str,
                 schedule: 'outputs.RecurrentScheduleResponse'):
        """
        The repeating times at which this profile begins. This element is not used if the FixedDate element is used.
        :param str frequency: the recurrence frequency. How often the schedule profile should take effect. This value must be Week, meaning each week will have the same set of profiles. For example, to set a daily schedule, set **schedule** to every day of the week. The frequency property specifies that the schedule is repeated weekly.
        :param 'RecurrentScheduleResponse' schedule: the scheduling constraints for when the profile begins.
        """
        pulumi.set(__self__, "frequency", frequency)
        pulumi.set(__self__, "schedule", schedule)

    @property
    @pulumi.getter
    def frequency(self) -> str:
        """
        the recurrence frequency. How often the schedule profile should take effect. This value must be Week, meaning each week will have the same set of profiles. For example, to set a daily schedule, set **schedule** to every day of the week. The frequency property specifies that the schedule is repeated weekly.
        """
        return pulumi.get(self, "frequency")

    @property
    @pulumi.getter
    def schedule(self) -> 'outputs.RecurrentScheduleResponse':
        """
        the scheduling constraints for when the profile begins.
        """
        return pulumi.get(self, "schedule")


@pulumi.output_type
class RecurrentScheduleResponse(dict):
    """
    The scheduling constraints for when the profile begins.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timeZone":
            suggest = "time_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RecurrentScheduleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RecurrentScheduleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RecurrentScheduleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 days: Sequence[str],
                 hours: Sequence[int],
                 minutes: Sequence[int],
                 time_zone: str):
        """
        The scheduling constraints for when the profile begins.
        :param Sequence[str] days: the collection of days that the profile takes effect on. Possible values are Sunday through Saturday.
        :param Sequence[int] hours: A collection of hours that the profile takes effect on. Values supported are 0 to 23 on the 24-hour clock (AM/PM times are not supported).
        :param Sequence[int] minutes: A collection of minutes at which the profile takes effect at.
        :param str time_zone: the timezone for the hours of the profile. Some examples of valid time zones are: Dateline Standard Time, UTC-11, Hawaiian Standard Time, Alaskan Standard Time, Pacific Standard Time (Mexico), Pacific Standard Time, US Mountain Standard Time, Mountain Standard Time (Mexico), Mountain Standard Time, Central America Standard Time, Central Standard Time, Central Standard Time (Mexico), Canada Central Standard Time, SA Pacific Standard Time, Eastern Standard Time, US Eastern Standard Time, Venezuela Standard Time, Paraguay Standard Time, Atlantic Standard Time, Central Brazilian Standard Time, SA Western Standard Time, Pacific SA Standard Time, Newfoundland Standard Time, E. South America Standard Time, Argentina Standard Time, SA Eastern Standard Time, Greenland Standard Time, Montevideo Standard Time, Bahia Standard Time, UTC-02, Mid-Atlantic Standard Time, Azores Standard Time, Cape Verde Standard Time, Morocco Standard Time, UTC, GMT Standard Time, Greenwich Standard Time, W. Europe Standard Time, Central Europe Standard Time, Romance Standard Time, Central European Standard Time, W. Central Africa Standard Time, Namibia Standard Time, Jordan Standard Time, GTB Standard Time, Middle East Standard Time, Egypt Standard Time, Syria Standard Time, E. Europe Standard Time, South Africa Standard Time, FLE Standard Time, Turkey Standard Time, Israel Standard Time, Kaliningrad Standard Time, Libya Standard Time, Arabic Standard Time, Arab Standard Time, Belarus Standard Time, Russian Standard Time, E. Africa Standard Time, Iran Standard Time, Arabian Standard Time, Azerbaijan Standard Time, Russia Time Zone 3, Mauritius Standard Time, Georgian Standard Time, Caucasus Standard Time, Afghanistan Standard Time, West Asia Standard Time, Ekaterinburg Standard Time, Pakistan Standard Time, India Standard Time, Sri Lanka Standard Time, Nepal Standard Time, Central Asia Standard Time, Bangladesh Standard Time, N. Central Asia Standard Time, Myanmar Standard Time, SE Asia Standard Time, North Asia Standard Time, China Standard Time, North Asia East Standard Time, Singapore Standard Time, W. Australia Standard Time, Taipei Standard Time, Ulaanbaatar Standard Time, Tokyo Standard Time, Korea Standard Time, Yakutsk Standard Time, Cen. Australia Standard Time, AUS Central Standard Time, E. Australia Standard Time, AUS Eastern Standard Time, West Pacific Standard Time, Tasmania Standard Time, Magadan Standard Time, Vladivostok Standard Time, Russia Time Zone 10, Central Pacific Standard Time, Russia Time Zone 11, New Zealand Standard Time, UTC+12, Fiji Standard Time, Kamchatka Standard Time, Tonga Standard Time, Samoa Standard Time, Line Islands Standard Time
        """
        pulumi.set(__self__, "days", days)
        pulumi.set(__self__, "hours", hours)
        pulumi.set(__self__, "minutes", minutes)
        pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter
    def days(self) -> Sequence[str]:
        """
        the collection of days that the profile takes effect on. Possible values are Sunday through Saturday.
        """
        return pulumi.get(self, "days")

    @property
    @pulumi.getter
    def hours(self) -> Sequence[int]:
        """
        A collection of hours that the profile takes effect on. Values supported are 0 to 23 on the 24-hour clock (AM/PM times are not supported).
        """
        return pulumi.get(self, "hours")

    @property
    @pulumi.getter
    def minutes(self) -> Sequence[int]:
        """
        A collection of minutes at which the profile takes effect at.
        """
        return pulumi.get(self, "minutes")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> str:
        """
        the timezone for the hours of the profile. Some examples of valid time zones are: Dateline Standard Time, UTC-11, Hawaiian Standard Time, Alaskan Standard Time, Pacific Standard Time (Mexico), Pacific Standard Time, US Mountain Standard Time, Mountain Standard Time (Mexico), Mountain Standard Time, Central America Standard Time, Central Standard Time, Central Standard Time (Mexico), Canada Central Standard Time, SA Pacific Standard Time, Eastern Standard Time, US Eastern Standard Time, Venezuela Standard Time, Paraguay Standard Time, Atlantic Standard Time, Central Brazilian Standard Time, SA Western Standard Time, Pacific SA Standard Time, Newfoundland Standard Time, E. South America Standard Time, Argentina Standard Time, SA Eastern Standard Time, Greenland Standard Time, Montevideo Standard Time, Bahia Standard Time, UTC-02, Mid-Atlantic Standard Time, Azores Standard Time, Cape Verde Standard Time, Morocco Standard Time, UTC, GMT Standard Time, Greenwich Standard Time, W. Europe Standard Time, Central Europe Standard Time, Romance Standard Time, Central European Standard Time, W. Central Africa Standard Time, Namibia Standard Time, Jordan Standard Time, GTB Standard Time, Middle East Standard Time, Egypt Standard Time, Syria Standard Time, E. Europe Standard Time, South Africa Standard Time, FLE Standard Time, Turkey Standard Time, Israel Standard Time, Kaliningrad Standard Time, Libya Standard Time, Arabic Standard Time, Arab Standard Time, Belarus Standard Time, Russian Standard Time, E. Africa Standard Time, Iran Standard Time, Arabian Standard Time, Azerbaijan Standard Time, Russia Time Zone 3, Mauritius Standard Time, Georgian Standard Time, Caucasus Standard Time, Afghanistan Standard Time, West Asia Standard Time, Ekaterinburg Standard Time, Pakistan Standard Time, India Standard Time, Sri Lanka Standard Time, Nepal Standard Time, Central Asia Standard Time, Bangladesh Standard Time, N. Central Asia Standard Time, Myanmar Standard Time, SE Asia Standard Time, North Asia Standard Time, China Standard Time, North Asia East Standard Time, Singapore Standard Time, W. Australia Standard Time, Taipei Standard Time, Ulaanbaatar Standard Time, Tokyo Standard Time, Korea Standard Time, Yakutsk Standard Time, Cen. Australia Standard Time, AUS Central Standard Time, E. Australia Standard Time, AUS Eastern Standard Time, West Pacific Standard Time, Tasmania Standard Time, Magadan Standard Time, Vladivostok Standard Time, Russia Time Zone 10, Central Pacific Standard Time, Russia Time Zone 11, New Zealand Standard Time, UTC+12, Fiji Standard Time, Kamchatka Standard Time, Tonga Standard Time, Samoa Standard Time, Line Islands Standard Time
        """
        return pulumi.get(self, "time_zone")


@pulumi.output_type
class RuleEmailActionResponse(dict):
    """
    Specifies the action to send email when the rule condition is evaluated. The discriminator is always RuleEmailAction in this case.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "customEmails":
            suggest = "custom_emails"
        elif key == "sendToServiceOwners":
            suggest = "send_to_service_owners"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleEmailActionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleEmailActionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleEmailActionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 custom_emails: Optional[Sequence[str]] = None,
                 send_to_service_owners: Optional[bool] = None):
        """
        Specifies the action to send email when the rule condition is evaluated. The discriminator is always RuleEmailAction in this case.
        :param str odata_type: specifies the type of the action. There are two types of actions: RuleEmailAction and RuleWebhookAction.
               Expected value is 'Microsoft.Azure.Management.Insights.Models.RuleEmailAction'.
        :param Sequence[str] custom_emails: the list of administrator's custom email addresses to notify of the activation of the alert.
        :param bool send_to_service_owners: Whether the administrators (service and co-administrators) of the service should be notified when the alert is activated.
        """
        pulumi.set(__self__, "odata_type", 'Microsoft.Azure.Management.Insights.Models.RuleEmailAction')
        if custom_emails is not None:
            pulumi.set(__self__, "custom_emails", custom_emails)
        if send_to_service_owners is not None:
            pulumi.set(__self__, "send_to_service_owners", send_to_service_owners)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        specifies the type of the action. There are two types of actions: RuleEmailAction and RuleWebhookAction.
        Expected value is 'Microsoft.Azure.Management.Insights.Models.RuleEmailAction'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="customEmails")
    def custom_emails(self) -> Optional[Sequence[str]]:
        """
        the list of administrator's custom email addresses to notify of the activation of the alert.
        """
        return pulumi.get(self, "custom_emails")

    @property
    @pulumi.getter(name="sendToServiceOwners")
    def send_to_service_owners(self) -> Optional[bool]:
        """
        Whether the administrators (service and co-administrators) of the service should be notified when the alert is activated.
        """
        return pulumi.get(self, "send_to_service_owners")


@pulumi.output_type
class RuleManagementEventClaimsDataSourceResponse(dict):
    """
    The claims for a rule management event data source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "emailAddress":
            suggest = "email_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleManagementEventClaimsDataSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleManagementEventClaimsDataSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleManagementEventClaimsDataSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 email_address: Optional[str] = None):
        """
        The claims for a rule management event data source.
        :param str email_address: the email address.
        """
        if email_address is not None:
            pulumi.set(__self__, "email_address", email_address)

    @property
    @pulumi.getter(name="emailAddress")
    def email_address(self) -> Optional[str]:
        """
        the email address.
        """
        return pulumi.get(self, "email_address")


@pulumi.output_type
class RuleManagementEventDataSourceResponse(dict):
    """
    A rule management event data source. The discriminator fields is always RuleManagementEventDataSource in this case.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "eventName":
            suggest = "event_name"
        elif key == "eventSource":
            suggest = "event_source"
        elif key == "legacyResourceId":
            suggest = "legacy_resource_id"
        elif key == "metricNamespace":
            suggest = "metric_namespace"
        elif key == "operationName":
            suggest = "operation_name"
        elif key == "resourceGroupName":
            suggest = "resource_group_name"
        elif key == "resourceLocation":
            suggest = "resource_location"
        elif key == "resourceProviderName":
            suggest = "resource_provider_name"
        elif key == "resourceUri":
            suggest = "resource_uri"
        elif key == "subStatus":
            suggest = "sub_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleManagementEventDataSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleManagementEventDataSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleManagementEventDataSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 claims: Optional['outputs.RuleManagementEventClaimsDataSourceResponse'] = None,
                 event_name: Optional[str] = None,
                 event_source: Optional[str] = None,
                 legacy_resource_id: Optional[str] = None,
                 level: Optional[str] = None,
                 metric_namespace: Optional[str] = None,
                 operation_name: Optional[str] = None,
                 resource_group_name: Optional[str] = None,
                 resource_location: Optional[str] = None,
                 resource_provider_name: Optional[str] = None,
                 resource_uri: Optional[str] = None,
                 status: Optional[str] = None,
                 sub_status: Optional[str] = None):
        """
        A rule management event data source. The discriminator fields is always RuleManagementEventDataSource in this case.
        :param str odata_type: specifies the type of data source. There are two types of rule data sources: RuleMetricDataSource and RuleManagementEventDataSource
               Expected value is 'Microsoft.Azure.Management.Insights.Models.RuleManagementEventDataSource'.
        :param 'RuleManagementEventClaimsDataSourceResponse' claims: the claims.
        :param str event_name: the event name.
        :param str event_source: the event source.
        :param str legacy_resource_id: the legacy resource identifier of the resource the rule monitors. **NOTE**: this property cannot be updated for an existing rule.
        :param str level: the level.
        :param str metric_namespace: the namespace of the metric.
        :param str operation_name: The name of the operation that should be checked for. If no name is provided, any operation will match.
        :param str resource_group_name: the resource group name.
        :param str resource_location: the location of the resource.
        :param str resource_provider_name: the resource provider name.
        :param str resource_uri: the resource identifier of the resource the rule monitors. **NOTE**: this property cannot be updated for an existing rule.
        :param str status: The status of the operation that should be checked for. If no status is provided, any status will match.
        :param str sub_status: the substatus.
        """
        pulumi.set(__self__, "odata_type", 'Microsoft.Azure.Management.Insights.Models.RuleManagementEventDataSource')
        if claims is not None:
            pulumi.set(__self__, "claims", claims)
        if event_name is not None:
            pulumi.set(__self__, "event_name", event_name)
        if event_source is not None:
            pulumi.set(__self__, "event_source", event_source)
        if legacy_resource_id is not None:
            pulumi.set(__self__, "legacy_resource_id", legacy_resource_id)
        if level is not None:
            pulumi.set(__self__, "level", level)
        if metric_namespace is not None:
            pulumi.set(__self__, "metric_namespace", metric_namespace)
        if operation_name is not None:
            pulumi.set(__self__, "operation_name", operation_name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if resource_location is not None:
            pulumi.set(__self__, "resource_location", resource_location)
        if resource_provider_name is not None:
            pulumi.set(__self__, "resource_provider_name", resource_provider_name)
        if resource_uri is not None:
            pulumi.set(__self__, "resource_uri", resource_uri)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if sub_status is not None:
            pulumi.set(__self__, "sub_status", sub_status)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        specifies the type of data source. There are two types of rule data sources: RuleMetricDataSource and RuleManagementEventDataSource
        Expected value is 'Microsoft.Azure.Management.Insights.Models.RuleManagementEventDataSource'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter
    def claims(self) -> Optional['outputs.RuleManagementEventClaimsDataSourceResponse']:
        """
        the claims.
        """
        return pulumi.get(self, "claims")

    @property
    @pulumi.getter(name="eventName")
    def event_name(self) -> Optional[str]:
        """
        the event name.
        """
        return pulumi.get(self, "event_name")

    @property
    @pulumi.getter(name="eventSource")
    def event_source(self) -> Optional[str]:
        """
        the event source.
        """
        return pulumi.get(self, "event_source")

    @property
    @pulumi.getter(name="legacyResourceId")
    def legacy_resource_id(self) -> Optional[str]:
        """
        the legacy resource identifier of the resource the rule monitors. **NOTE**: this property cannot be updated for an existing rule.
        """
        return pulumi.get(self, "legacy_resource_id")

    @property
    @pulumi.getter
    def level(self) -> Optional[str]:
        """
        the level.
        """
        return pulumi.get(self, "level")

    @property
    @pulumi.getter(name="metricNamespace")
    def metric_namespace(self) -> Optional[str]:
        """
        the namespace of the metric.
        """
        return pulumi.get(self, "metric_namespace")

    @property
    @pulumi.getter(name="operationName")
    def operation_name(self) -> Optional[str]:
        """
        The name of the operation that should be checked for. If no name is provided, any operation will match.
        """
        return pulumi.get(self, "operation_name")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[str]:
        """
        the resource group name.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter(name="resourceLocation")
    def resource_location(self) -> Optional[str]:
        """
        the location of the resource.
        """
        return pulumi.get(self, "resource_location")

    @property
    @pulumi.getter(name="resourceProviderName")
    def resource_provider_name(self) -> Optional[str]:
        """
        the resource provider name.
        """
        return pulumi.get(self, "resource_provider_name")

    @property
    @pulumi.getter(name="resourceUri")
    def resource_uri(self) -> Optional[str]:
        """
        the resource identifier of the resource the rule monitors. **NOTE**: this property cannot be updated for an existing rule.
        """
        return pulumi.get(self, "resource_uri")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The status of the operation that should be checked for. If no status is provided, any status will match.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subStatus")
    def sub_status(self) -> Optional[str]:
        """
        the substatus.
        """
        return pulumi.get(self, "sub_status")


@pulumi.output_type
class RuleMetricDataSourceResponse(dict):
    """
    A rule metric data source. The discriminator value is always RuleMetricDataSource in this case.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "legacyResourceId":
            suggest = "legacy_resource_id"
        elif key == "metricName":
            suggest = "metric_name"
        elif key == "metricNamespace":
            suggest = "metric_namespace"
        elif key == "resourceLocation":
            suggest = "resource_location"
        elif key == "resourceUri":
            suggest = "resource_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleMetricDataSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleMetricDataSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleMetricDataSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 legacy_resource_id: Optional[str] = None,
                 metric_name: Optional[str] = None,
                 metric_namespace: Optional[str] = None,
                 resource_location: Optional[str] = None,
                 resource_uri: Optional[str] = None):
        """
        A rule metric data source. The discriminator value is always RuleMetricDataSource in this case.
        :param str odata_type: specifies the type of data source. There are two types of rule data sources: RuleMetricDataSource and RuleManagementEventDataSource
               Expected value is 'Microsoft.Azure.Management.Insights.Models.RuleMetricDataSource'.
        :param str legacy_resource_id: the legacy resource identifier of the resource the rule monitors. **NOTE**: this property cannot be updated for an existing rule.
        :param str metric_name: the name of the metric that defines what the rule monitors.
        :param str metric_namespace: the namespace of the metric.
        :param str resource_location: the location of the resource.
        :param str resource_uri: the resource identifier of the resource the rule monitors. **NOTE**: this property cannot be updated for an existing rule.
        """
        pulumi.set(__self__, "odata_type", 'Microsoft.Azure.Management.Insights.Models.RuleMetricDataSource')
        if legacy_resource_id is not None:
            pulumi.set(__self__, "legacy_resource_id", legacy_resource_id)
        if metric_name is not None:
            pulumi.set(__self__, "metric_name", metric_name)
        if metric_namespace is not None:
            pulumi.set(__self__, "metric_namespace", metric_namespace)
        if resource_location is not None:
            pulumi.set(__self__, "resource_location", resource_location)
        if resource_uri is not None:
            pulumi.set(__self__, "resource_uri", resource_uri)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        specifies the type of data source. There are two types of rule data sources: RuleMetricDataSource and RuleManagementEventDataSource
        Expected value is 'Microsoft.Azure.Management.Insights.Models.RuleMetricDataSource'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="legacyResourceId")
    def legacy_resource_id(self) -> Optional[str]:
        """
        the legacy resource identifier of the resource the rule monitors. **NOTE**: this property cannot be updated for an existing rule.
        """
        return pulumi.get(self, "legacy_resource_id")

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> Optional[str]:
        """
        the name of the metric that defines what the rule monitors.
        """
        return pulumi.get(self, "metric_name")

    @property
    @pulumi.getter(name="metricNamespace")
    def metric_namespace(self) -> Optional[str]:
        """
        the namespace of the metric.
        """
        return pulumi.get(self, "metric_namespace")

    @property
    @pulumi.getter(name="resourceLocation")
    def resource_location(self) -> Optional[str]:
        """
        the location of the resource.
        """
        return pulumi.get(self, "resource_location")

    @property
    @pulumi.getter(name="resourceUri")
    def resource_uri(self) -> Optional[str]:
        """
        the resource identifier of the resource the rule monitors. **NOTE**: this property cannot be updated for an existing rule.
        """
        return pulumi.get(self, "resource_uri")


@pulumi.output_type
class RuleWebhookActionResponse(dict):
    """
    Specifies the action to post to service when the rule condition is evaluated. The discriminator is always RuleWebhookAction in this case.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "serviceUri":
            suggest = "service_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleWebhookActionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleWebhookActionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleWebhookActionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 properties: Optional[Mapping[str, str]] = None,
                 service_uri: Optional[str] = None):
        """
        Specifies the action to post to service when the rule condition is evaluated. The discriminator is always RuleWebhookAction in this case.
        :param str odata_type: specifies the type of the action. There are two types of actions: RuleEmailAction and RuleWebhookAction.
               Expected value is 'Microsoft.Azure.Management.Insights.Models.RuleWebhookAction'.
        :param Mapping[str, str] properties: the dictionary of custom properties to include with the post operation. These data are appended to the webhook payload.
        :param str service_uri: the service uri to Post the notification when the alert activates or resolves.
        """
        pulumi.set(__self__, "odata_type", 'Microsoft.Azure.Management.Insights.Models.RuleWebhookAction')
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if service_uri is not None:
            pulumi.set(__self__, "service_uri", service_uri)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        specifies the type of the action. There are two types of actions: RuleEmailAction and RuleWebhookAction.
        Expected value is 'Microsoft.Azure.Management.Insights.Models.RuleWebhookAction'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        the dictionary of custom properties to include with the post operation. These data are appended to the webhook payload.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="serviceUri")
    def service_uri(self) -> Optional[str]:
        """
        the service uri to Post the notification when the alert activates or resolves.
        """
        return pulumi.get(self, "service_uri")


@pulumi.output_type
class ScaleActionResponse(dict):
    """
    The parameters for the scaling action.
    """
    def __init__(__self__, *,
                 cooldown: str,
                 direction: str,
                 type: str,
                 value: Optional[str] = None):
        """
        The parameters for the scaling action.
        :param str cooldown: the amount of time to wait since the last scaling action before this action occurs. It must be between 1 week and 1 minute in ISO 8601 format.
        :param str direction: the scale direction. Whether the scaling action increases or decreases the number of instances.
        :param str type: the type of action that should occur when the scale rule fires.
        :param str value: the number of instances that are involved in the scaling action. This value must be 1 or greater. The default value is 1.
        """
        pulumi.set(__self__, "cooldown", cooldown)
        pulumi.set(__self__, "direction", direction)
        pulumi.set(__self__, "type", type)
        if value is None:
            value = '1'
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def cooldown(self) -> str:
        """
        the amount of time to wait since the last scaling action before this action occurs. It must be between 1 week and 1 minute in ISO 8601 format.
        """
        return pulumi.get(self, "cooldown")

    @property
    @pulumi.getter
    def direction(self) -> str:
        """
        the scale direction. Whether the scaling action increases or decreases the number of instances.
        """
        return pulumi.get(self, "direction")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        the type of action that should occur when the scale rule fires.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        the number of instances that are involved in the scaling action. This value must be 1 or greater. The default value is 1.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ScaleCapacityResponse(dict):
    """
    The number of instances that can be used during this profile.
    """
    def __init__(__self__, *,
                 default: str,
                 maximum: str,
                 minimum: str):
        """
        The number of instances that can be used during this profile.
        :param str default: the number of instances that will be set if metrics are not available for evaluation. The default is only used if the current instance count is lower than the default.
        :param str maximum: the maximum number of instances for the resource. The actual maximum number of instances is limited by the cores that are available in the subscription.
        :param str minimum: the minimum number of instances for the resource.
        """
        pulumi.set(__self__, "default", default)
        pulumi.set(__self__, "maximum", maximum)
        pulumi.set(__self__, "minimum", minimum)

    @property
    @pulumi.getter
    def default(self) -> str:
        """
        the number of instances that will be set if metrics are not available for evaluation. The default is only used if the current instance count is lower than the default.
        """
        return pulumi.get(self, "default")

    @property
    @pulumi.getter
    def maximum(self) -> str:
        """
        the maximum number of instances for the resource. The actual maximum number of instances is limited by the cores that are available in the subscription.
        """
        return pulumi.get(self, "maximum")

    @property
    @pulumi.getter
    def minimum(self) -> str:
        """
        the minimum number of instances for the resource.
        """
        return pulumi.get(self, "minimum")


@pulumi.output_type
class ScaleRuleMetricDimensionResponse(dict):
    """
    Specifies an auto scale rule metric dimension.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dimensionName":
            suggest = "dimension_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScaleRuleMetricDimensionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScaleRuleMetricDimensionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScaleRuleMetricDimensionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dimension_name: str,
                 operator: str,
                 values: Sequence[str]):
        """
        Specifies an auto scale rule metric dimension.
        :param str dimension_name: Name of the dimension.
        :param str operator: the dimension operator. Only 'Equals' and 'NotEquals' are supported. 'Equals' being equal to any of the values. 'NotEquals' being not equal to all of the values
        :param Sequence[str] values: list of dimension values. For example: ["App1","App2"].
        """
        pulumi.set(__self__, "dimension_name", dimension_name)
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="dimensionName")
    def dimension_name(self) -> str:
        """
        Name of the dimension.
        """
        return pulumi.get(self, "dimension_name")

    @property
    @pulumi.getter
    def operator(self) -> str:
        """
        the dimension operator. Only 'Equals' and 'NotEquals' are supported. 'Equals' being equal to any of the values. 'NotEquals' being not equal to all of the values
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        list of dimension values. For example: ["App1","App2"].
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class ScaleRuleResponse(dict):
    """
    A rule that provide the triggers and parameters for the scaling action.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricTrigger":
            suggest = "metric_trigger"
        elif key == "scaleAction":
            suggest = "scale_action"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScaleRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScaleRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScaleRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metric_trigger: 'outputs.MetricTriggerResponse',
                 scale_action: 'outputs.ScaleActionResponse'):
        """
        A rule that provide the triggers and parameters for the scaling action.
        :param 'MetricTriggerResponse' metric_trigger: the trigger that results in a scaling action.
        :param 'ScaleActionResponse' scale_action: the parameters for the scaling action.
        """
        pulumi.set(__self__, "metric_trigger", metric_trigger)
        pulumi.set(__self__, "scale_action", scale_action)

    @property
    @pulumi.getter(name="metricTrigger")
    def metric_trigger(self) -> 'outputs.MetricTriggerResponse':
        """
        the trigger that results in a scaling action.
        """
        return pulumi.get(self, "metric_trigger")

    @property
    @pulumi.getter(name="scaleAction")
    def scale_action(self) -> 'outputs.ScaleActionResponse':
        """
        the parameters for the scaling action.
        """
        return pulumi.get(self, "scale_action")


@pulumi.output_type
class ThresholdRuleConditionResponse(dict):
    """
    A rule condition based on a metric crossing a threshold.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "dataSource":
            suggest = "data_source"
        elif key == "timeAggregation":
            suggest = "time_aggregation"
        elif key == "windowSize":
            suggest = "window_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ThresholdRuleConditionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ThresholdRuleConditionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ThresholdRuleConditionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 operator: str,
                 threshold: float,
                 data_source: Optional[Any] = None,
                 time_aggregation: Optional[str] = None,
                 window_size: Optional[str] = None):
        """
        A rule condition based on a metric crossing a threshold.
        :param str odata_type: specifies the type of condition. This can be one of three types: ManagementEventRuleCondition (occurrences of management events), LocationThresholdRuleCondition (based on the number of failures of a web test), and ThresholdRuleCondition (based on the threshold of a metric).
               Expected value is 'Microsoft.Azure.Management.Insights.Models.ThresholdRuleCondition'.
        :param str operator: the operator used to compare the data and the threshold.
        :param float threshold: the threshold value that activates the alert.
        :param Union['RuleManagementEventDataSourceResponse', 'RuleMetricDataSourceResponse'] data_source: the resource from which the rule collects its data. For this type dataSource will always be of type RuleMetricDataSource.
        :param str time_aggregation: the time aggregation operator. How the data that are collected should be combined over time. The default value is the PrimaryAggregationType of the Metric.
        :param str window_size: the period of time (in ISO 8601 duration format) that is used to monitor alert activity based on the threshold. If specified then it must be between 5 minutes and 1 day.
        """
        pulumi.set(__self__, "odata_type", 'Microsoft.Azure.Management.Insights.Models.ThresholdRuleCondition')
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "threshold", threshold)
        if data_source is not None:
            pulumi.set(__self__, "data_source", data_source)
        if time_aggregation is not None:
            pulumi.set(__self__, "time_aggregation", time_aggregation)
        if window_size is not None:
            pulumi.set(__self__, "window_size", window_size)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        specifies the type of condition. This can be one of three types: ManagementEventRuleCondition (occurrences of management events), LocationThresholdRuleCondition (based on the number of failures of a web test), and ThresholdRuleCondition (based on the threshold of a metric).
        Expected value is 'Microsoft.Azure.Management.Insights.Models.ThresholdRuleCondition'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter
    def operator(self) -> str:
        """
        the operator used to compare the data and the threshold.
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter
    def threshold(self) -> float:
        """
        the threshold value that activates the alert.
        """
        return pulumi.get(self, "threshold")

    @property
    @pulumi.getter(name="dataSource")
    def data_source(self) -> Optional[Any]:
        """
        the resource from which the rule collects its data. For this type dataSource will always be of type RuleMetricDataSource.
        """
        return pulumi.get(self, "data_source")

    @property
    @pulumi.getter(name="timeAggregation")
    def time_aggregation(self) -> Optional[str]:
        """
        the time aggregation operator. How the data that are collected should be combined over time. The default value is the PrimaryAggregationType of the Metric.
        """
        return pulumi.get(self, "time_aggregation")

    @property
    @pulumi.getter(name="windowSize")
    def window_size(self) -> Optional[str]:
        """
        the period of time (in ISO 8601 duration format) that is used to monitor alert activity based on the threshold. If specified then it must be between 5 minutes and 1 day.
        """
        return pulumi.get(self, "window_size")


@pulumi.output_type
class TimeWindowResponse(dict):
    """
    A specific date-time for the profile.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timeZone":
            suggest = "time_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TimeWindowResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TimeWindowResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TimeWindowResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end: str,
                 start: str,
                 time_zone: Optional[str] = None):
        """
        A specific date-time for the profile.
        :param str end: the end time for the profile in ISO 8601 format.
        :param str start: the start time for the profile in ISO 8601 format.
        :param str time_zone: the timezone of the start and end times for the profile. Some examples of valid time zones are: Dateline Standard Time, UTC-11, Hawaiian Standard Time, Alaskan Standard Time, Pacific Standard Time (Mexico), Pacific Standard Time, US Mountain Standard Time, Mountain Standard Time (Mexico), Mountain Standard Time, Central America Standard Time, Central Standard Time, Central Standard Time (Mexico), Canada Central Standard Time, SA Pacific Standard Time, Eastern Standard Time, US Eastern Standard Time, Venezuela Standard Time, Paraguay Standard Time, Atlantic Standard Time, Central Brazilian Standard Time, SA Western Standard Time, Pacific SA Standard Time, Newfoundland Standard Time, E. South America Standard Time, Argentina Standard Time, SA Eastern Standard Time, Greenland Standard Time, Montevideo Standard Time, Bahia Standard Time, UTC-02, Mid-Atlantic Standard Time, Azores Standard Time, Cape Verde Standard Time, Morocco Standard Time, UTC, GMT Standard Time, Greenwich Standard Time, W. Europe Standard Time, Central Europe Standard Time, Romance Standard Time, Central European Standard Time, W. Central Africa Standard Time, Namibia Standard Time, Jordan Standard Time, GTB Standard Time, Middle East Standard Time, Egypt Standard Time, Syria Standard Time, E. Europe Standard Time, South Africa Standard Time, FLE Standard Time, Turkey Standard Time, Israel Standard Time, Kaliningrad Standard Time, Libya Standard Time, Arabic Standard Time, Arab Standard Time, Belarus Standard Time, Russian Standard Time, E. Africa Standard Time, Iran Standard Time, Arabian Standard Time, Azerbaijan Standard Time, Russia Time Zone 3, Mauritius Standard Time, Georgian Standard Time, Caucasus Standard Time, Afghanistan Standard Time, West Asia Standard Time, Ekaterinburg Standard Time, Pakistan Standard Time, India Standard Time, Sri Lanka Standard Time, Nepal Standard Time, Central Asia Standard Time, Bangladesh Standard Time, N. Central Asia Standard Time, Myanmar Standard Time, SE Asia Standard Time, North Asia Standard Time, China Standard Time, North Asia East Standard Time, Singapore Standard Time, W. Australia Standard Time, Taipei Standard Time, Ulaanbaatar Standard Time, Tokyo Standard Time, Korea Standard Time, Yakutsk Standard Time, Cen. Australia Standard Time, AUS Central Standard Time, E. Australia Standard Time, AUS Eastern Standard Time, West Pacific Standard Time, Tasmania Standard Time, Magadan Standard Time, Vladivostok Standard Time, Russia Time Zone 10, Central Pacific Standard Time, Russia Time Zone 11, New Zealand Standard Time, UTC+12, Fiji Standard Time, Kamchatka Standard Time, Tonga Standard Time, Samoa Standard Time, Line Islands Standard Time
        """
        pulumi.set(__self__, "end", end)
        pulumi.set(__self__, "start", start)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter
    def end(self) -> str:
        """
        the end time for the profile in ISO 8601 format.
        """
        return pulumi.get(self, "end")

    @property
    @pulumi.getter
    def start(self) -> str:
        """
        the start time for the profile in ISO 8601 format.
        """
        return pulumi.get(self, "start")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[str]:
        """
        the timezone of the start and end times for the profile. Some examples of valid time zones are: Dateline Standard Time, UTC-11, Hawaiian Standard Time, Alaskan Standard Time, Pacific Standard Time (Mexico), Pacific Standard Time, US Mountain Standard Time, Mountain Standard Time (Mexico), Mountain Standard Time, Central America Standard Time, Central Standard Time, Central Standard Time (Mexico), Canada Central Standard Time, SA Pacific Standard Time, Eastern Standard Time, US Eastern Standard Time, Venezuela Standard Time, Paraguay Standard Time, Atlantic Standard Time, Central Brazilian Standard Time, SA Western Standard Time, Pacific SA Standard Time, Newfoundland Standard Time, E. South America Standard Time, Argentina Standard Time, SA Eastern Standard Time, Greenland Standard Time, Montevideo Standard Time, Bahia Standard Time, UTC-02, Mid-Atlantic Standard Time, Azores Standard Time, Cape Verde Standard Time, Morocco Standard Time, UTC, GMT Standard Time, Greenwich Standard Time, W. Europe Standard Time, Central Europe Standard Time, Romance Standard Time, Central European Standard Time, W. Central Africa Standard Time, Namibia Standard Time, Jordan Standard Time, GTB Standard Time, Middle East Standard Time, Egypt Standard Time, Syria Standard Time, E. Europe Standard Time, South Africa Standard Time, FLE Standard Time, Turkey Standard Time, Israel Standard Time, Kaliningrad Standard Time, Libya Standard Time, Arabic Standard Time, Arab Standard Time, Belarus Standard Time, Russian Standard Time, E. Africa Standard Time, Iran Standard Time, Arabian Standard Time, Azerbaijan Standard Time, Russia Time Zone 3, Mauritius Standard Time, Georgian Standard Time, Caucasus Standard Time, Afghanistan Standard Time, West Asia Standard Time, Ekaterinburg Standard Time, Pakistan Standard Time, India Standard Time, Sri Lanka Standard Time, Nepal Standard Time, Central Asia Standard Time, Bangladesh Standard Time, N. Central Asia Standard Time, Myanmar Standard Time, SE Asia Standard Time, North Asia Standard Time, China Standard Time, North Asia East Standard Time, Singapore Standard Time, W. Australia Standard Time, Taipei Standard Time, Ulaanbaatar Standard Time, Tokyo Standard Time, Korea Standard Time, Yakutsk Standard Time, Cen. Australia Standard Time, AUS Central Standard Time, E. Australia Standard Time, AUS Eastern Standard Time, West Pacific Standard Time, Tasmania Standard Time, Magadan Standard Time, Vladivostok Standard Time, Russia Time Zone 10, Central Pacific Standard Time, Russia Time Zone 11, New Zealand Standard Time, UTC+12, Fiji Standard Time, Kamchatka Standard Time, Tonga Standard Time, Samoa Standard Time, Line Islands Standard Time
        """
        return pulumi.get(self, "time_zone")


@pulumi.output_type
class WebhookNotificationResponse(dict):
    """
    Webhook notification of an autoscale event.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serviceUri":
            suggest = "service_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebhookNotificationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebhookNotificationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebhookNotificationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 properties: Optional[Mapping[str, str]] = None,
                 service_uri: Optional[str] = None):
        """
        Webhook notification of an autoscale event.
        :param Mapping[str, str] properties: a property bag of settings. This value can be empty.
        :param str service_uri: the service address to receive the notification.
        """
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if service_uri is not None:
            pulumi.set(__self__, "service_uri", service_uri)

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        a property bag of settings. This value can be empty.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="serviceUri")
    def service_uri(self) -> Optional[str]:
        """
        the service address to receive the notification.
        """
        return pulumi.get(self, "service_uri")


