# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = ['QueueAuthorizationRuleArgs', 'QueueAuthorizationRule']

@pulumi.input_type
class QueueAuthorizationRuleArgs:
    def __init__(__self__, *,
                 namespace_name: pulumi.Input[str],
                 queue_name: pulumi.Input[str],
                 resource_group_name: pulumi.Input[str],
                 rights: pulumi.Input[Sequence[pulumi.Input['AccessRights']]],
                 authorization_rule_name: Optional[pulumi.Input[str]] = None,
                 claim_type: Optional[pulumi.Input[str]] = None,
                 claim_value: Optional[pulumi.Input[str]] = None,
                 key_name: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 primary_key: Optional[pulumi.Input[str]] = None,
                 secondary_key: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a QueueAuthorizationRule resource.
        :param pulumi.Input[str] namespace_name: The namespace name
        :param pulumi.Input[str] queue_name: The queue name.
        :param pulumi.Input[str] resource_group_name: Name of the Resource group within the Azure subscription.
        :param pulumi.Input[Sequence[pulumi.Input['AccessRights']]] rights: The rights associated with the rule.
        :param pulumi.Input[str] authorization_rule_name: The authorization rule name.
        :param pulumi.Input[str] claim_type: A string that describes Claim Type for authorization rule.
        :param pulumi.Input[str] claim_value: A string that describes Claim Value of authorization rule.
        :param pulumi.Input[str] key_name: A string that describes the Key Name of authorization rule.
        :param pulumi.Input[str] location: data center location.
        :param pulumi.Input[str] name: Name of the authorization rule.
        :param pulumi.Input[str] primary_key: A base64-encoded 256-bit primary key for signing and validating the SAS token.
        :param pulumi.Input[str] secondary_key: A base64-encoded 256-bit primary key for signing and validating the SAS token.
        """
        pulumi.set(__self__, "namespace_name", namespace_name)
        pulumi.set(__self__, "queue_name", queue_name)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "rights", rights)
        if authorization_rule_name is not None:
            pulumi.set(__self__, "authorization_rule_name", authorization_rule_name)
        if claim_type is not None:
            pulumi.set(__self__, "claim_type", claim_type)
        if claim_value is not None:
            pulumi.set(__self__, "claim_value", claim_value)
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if primary_key is not None:
            pulumi.set(__self__, "primary_key", primary_key)
        if secondary_key is not None:
            pulumi.set(__self__, "secondary_key", secondary_key)

    @property
    @pulumi.getter(name="namespaceName")
    def namespace_name(self) -> pulumi.Input[str]:
        """
        The namespace name
        """
        return pulumi.get(self, "namespace_name")

    @namespace_name.setter
    def namespace_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "namespace_name", value)

    @property
    @pulumi.getter(name="queueName")
    def queue_name(self) -> pulumi.Input[str]:
        """
        The queue name.
        """
        return pulumi.get(self, "queue_name")

    @queue_name.setter
    def queue_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "queue_name", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[str]:
        """
        Name of the Resource group within the Azure subscription.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter
    def rights(self) -> pulumi.Input[Sequence[pulumi.Input['AccessRights']]]:
        """
        The rights associated with the rule.
        """
        return pulumi.get(self, "rights")

    @rights.setter
    def rights(self, value: pulumi.Input[Sequence[pulumi.Input['AccessRights']]]):
        pulumi.set(self, "rights", value)

    @property
    @pulumi.getter(name="authorizationRuleName")
    def authorization_rule_name(self) -> Optional[pulumi.Input[str]]:
        """
        The authorization rule name.
        """
        return pulumi.get(self, "authorization_rule_name")

    @authorization_rule_name.setter
    def authorization_rule_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorization_rule_name", value)

    @property
    @pulumi.getter(name="claimType")
    def claim_type(self) -> Optional[pulumi.Input[str]]:
        """
        A string that describes Claim Type for authorization rule.
        """
        return pulumi.get(self, "claim_type")

    @claim_type.setter
    def claim_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "claim_type", value)

    @property
    @pulumi.getter(name="claimValue")
    def claim_value(self) -> Optional[pulumi.Input[str]]:
        """
        A string that describes Claim Value of authorization rule.
        """
        return pulumi.get(self, "claim_value")

    @claim_value.setter
    def claim_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "claim_value", value)

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[pulumi.Input[str]]:
        """
        A string that describes the Key Name of authorization rule.
        """
        return pulumi.get(self, "key_name")

    @key_name.setter
    def key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_name", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        data center location.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the authorization rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="primaryKey")
    def primary_key(self) -> Optional[pulumi.Input[str]]:
        """
        A base64-encoded 256-bit primary key for signing and validating the SAS token.
        """
        return pulumi.get(self, "primary_key")

    @primary_key.setter
    def primary_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_key", value)

    @property
    @pulumi.getter(name="secondaryKey")
    def secondary_key(self) -> Optional[pulumi.Input[str]]:
        """
        A base64-encoded 256-bit primary key for signing and validating the SAS token.
        """
        return pulumi.get(self, "secondary_key")

    @secondary_key.setter
    def secondary_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secondary_key", value)


class QueueAuthorizationRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authorization_rule_name: Optional[pulumi.Input[str]] = None,
                 claim_type: Optional[pulumi.Input[str]] = None,
                 claim_value: Optional[pulumi.Input[str]] = None,
                 key_name: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace_name: Optional[pulumi.Input[str]] = None,
                 primary_key: Optional[pulumi.Input[str]] = None,
                 queue_name: Optional[pulumi.Input[str]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 rights: Optional[pulumi.Input[Sequence[pulumi.Input['AccessRights']]]] = None,
                 secondary_key: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Description of a namespace authorization rule.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] authorization_rule_name: The authorization rule name.
        :param pulumi.Input[str] claim_type: A string that describes Claim Type for authorization rule.
        :param pulumi.Input[str] claim_value: A string that describes Claim Value of authorization rule.
        :param pulumi.Input[str] key_name: A string that describes the Key Name of authorization rule.
        :param pulumi.Input[str] location: data center location.
        :param pulumi.Input[str] name: Name of the authorization rule.
        :param pulumi.Input[str] namespace_name: The namespace name
        :param pulumi.Input[str] primary_key: A base64-encoded 256-bit primary key for signing and validating the SAS token.
        :param pulumi.Input[str] queue_name: The queue name.
        :param pulumi.Input[str] resource_group_name: Name of the Resource group within the Azure subscription.
        :param pulumi.Input[Sequence[pulumi.Input['AccessRights']]] rights: The rights associated with the rule.
        :param pulumi.Input[str] secondary_key: A base64-encoded 256-bit primary key for signing and validating the SAS token.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: QueueAuthorizationRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Description of a namespace authorization rule.

        :param str resource_name: The name of the resource.
        :param QueueAuthorizationRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(QueueAuthorizationRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authorization_rule_name: Optional[pulumi.Input[str]] = None,
                 claim_type: Optional[pulumi.Input[str]] = None,
                 claim_value: Optional[pulumi.Input[str]] = None,
                 key_name: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace_name: Optional[pulumi.Input[str]] = None,
                 primary_key: Optional[pulumi.Input[str]] = None,
                 queue_name: Optional[pulumi.Input[str]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 rights: Optional[pulumi.Input[Sequence[pulumi.Input['AccessRights']]]] = None,
                 secondary_key: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = QueueAuthorizationRuleArgs.__new__(QueueAuthorizationRuleArgs)

            __props__.__dict__["authorization_rule_name"] = authorization_rule_name
            __props__.__dict__["claim_type"] = claim_type
            __props__.__dict__["claim_value"] = claim_value
            __props__.__dict__["key_name"] = key_name
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            if namespace_name is None and not opts.urn:
                raise TypeError("Missing required property 'namespace_name'")
            __props__.__dict__["namespace_name"] = namespace_name
            __props__.__dict__["primary_key"] = primary_key
            if queue_name is None and not opts.urn:
                raise TypeError("Missing required property 'queue_name'")
            __props__.__dict__["queue_name"] = queue_name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if rights is None and not opts.urn:
                raise TypeError("Missing required property 'rights'")
            __props__.__dict__["rights"] = rights
            __props__.__dict__["secondary_key"] = secondary_key
            __props__.__dict__["created_time"] = None
            __props__.__dict__["modified_time"] = None
            __props__.__dict__["type"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="azure-native:servicebus:QueueAuthorizationRule"), pulumi.Alias(type_="azure-native:servicebus/v20150801:QueueAuthorizationRule"), pulumi.Alias(type_="azure-native:servicebus/v20170401:QueueAuthorizationRule"), pulumi.Alias(type_="azure-native:servicebus/v20180101preview:QueueAuthorizationRule"), pulumi.Alias(type_="azure-native:servicebus/v20210101preview:QueueAuthorizationRule"), pulumi.Alias(type_="azure-native:servicebus/v20210601preview:QueueAuthorizationRule"), pulumi.Alias(type_="azure-native:servicebus/v20211101:QueueAuthorizationRule")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(QueueAuthorizationRule, __self__).__init__(
            'azure-native:servicebus/v20140901:QueueAuthorizationRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'QueueAuthorizationRule':
        """
        Get an existing QueueAuthorizationRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = QueueAuthorizationRuleArgs.__new__(QueueAuthorizationRuleArgs)

        __props__.__dict__["claim_type"] = None
        __props__.__dict__["claim_value"] = None
        __props__.__dict__["created_time"] = None
        __props__.__dict__["key_name"] = None
        __props__.__dict__["location"] = None
        __props__.__dict__["modified_time"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["primary_key"] = None
        __props__.__dict__["rights"] = None
        __props__.__dict__["secondary_key"] = None
        __props__.__dict__["type"] = None
        return QueueAuthorizationRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="claimType")
    def claim_type(self) -> pulumi.Output[Optional[str]]:
        """
        A string that describes Claim Type for authorization rule.
        """
        return pulumi.get(self, "claim_type")

    @property
    @pulumi.getter(name="claimValue")
    def claim_value(self) -> pulumi.Output[Optional[str]]:
        """
        A string that describes Claim Value of authorization rule.
        """
        return pulumi.get(self, "claim_value")

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> pulumi.Output[str]:
        """
        The time the namespace was created.
        """
        return pulumi.get(self, "created_time")

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> pulumi.Output[Optional[str]]:
        """
        A string that describes the Key Name of authorization rule.
        """
        return pulumi.get(self, "key_name")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[Optional[str]]:
        """
        Resource location.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="modifiedTime")
    def modified_time(self) -> pulumi.Output[str]:
        """
        The time the namespace was updated.
        """
        return pulumi.get(self, "modified_time")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Resource name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="primaryKey")
    def primary_key(self) -> pulumi.Output[Optional[str]]:
        """
        A base64-encoded 256-bit primary key for signing and validating the SAS token.
        """
        return pulumi.get(self, "primary_key")

    @property
    @pulumi.getter
    def rights(self) -> pulumi.Output[Sequence[str]]:
        """
        The rights associated with the rule.
        """
        return pulumi.get(self, "rights")

    @property
    @pulumi.getter(name="secondaryKey")
    def secondary_key(self) -> pulumi.Output[Optional[str]]:
        """
        A base64-encoded 256-bit primary key for signing and validating the SAS token.
        """
        return pulumi.get(self, "secondary_key")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Resource type
        """
        return pulumi.get(self, "type")

