# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AppLogsConfigurationResponse',
    'ArcConfigurationResponse',
    'ConfigurationResponse',
    'ContainerResourcesResponse',
    'ContainerResponse',
    'CustomScaleRuleResponse',
    'DaprComponentResponse',
    'DaprMetadataResponse',
    'DaprResponse',
    'EnvironmentVarResponse',
    'ExtendedLocationResponse',
    'FrontEndConfigurationResponse',
    'HttpScaleRuleResponse',
    'IngressResponse',
    'LogAnalyticsConfigurationResponse',
    'QueueScaleRuleResponse',
    'RegistryCredentialsResponse',
    'ScaleResponse',
    'ScaleRuleAuthResponse',
    'ScaleRuleResponse',
    'SecretResponse',
    'TemplateResponse',
    'TrafficWeightResponse',
]

@pulumi.output_type
class AppLogsConfigurationResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logAnalyticsConfiguration":
            suggest = "log_analytics_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppLogsConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppLogsConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppLogsConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination: Optional[str] = None,
                 log_analytics_configuration: Optional['outputs.LogAnalyticsConfigurationResponse'] = None):
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if log_analytics_configuration is not None:
            pulumi.set(__self__, "log_analytics_configuration", log_analytics_configuration)

    @property
    @pulumi.getter
    def destination(self) -> Optional[str]:
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter(name="logAnalyticsConfiguration")
    def log_analytics_configuration(self) -> Optional['outputs.LogAnalyticsConfigurationResponse']:
        return pulumi.get(self, "log_analytics_configuration")


@pulumi.output_type
class ArcConfigurationResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "artifactStorageAccessMode":
            suggest = "artifact_storage_access_mode"
        elif key == "artifactStorageClassName":
            suggest = "artifact_storage_class_name"
        elif key == "artifactStorageMountPath":
            suggest = "artifact_storage_mount_path"
        elif key == "artifactStorageNodeName":
            suggest = "artifact_storage_node_name"
        elif key == "artifactsStorageType":
            suggest = "artifacts_storage_type"
        elif key == "frontEndServiceConfiguration":
            suggest = "front_end_service_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ArcConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ArcConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ArcConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 artifact_storage_access_mode: Optional[str] = None,
                 artifact_storage_class_name: Optional[str] = None,
                 artifact_storage_mount_path: Optional[str] = None,
                 artifact_storage_node_name: Optional[str] = None,
                 artifacts_storage_type: Optional[str] = None,
                 front_end_service_configuration: Optional['outputs.FrontEndConfigurationResponse'] = None):
        if artifact_storage_access_mode is not None:
            pulumi.set(__self__, "artifact_storage_access_mode", artifact_storage_access_mode)
        if artifact_storage_class_name is not None:
            pulumi.set(__self__, "artifact_storage_class_name", artifact_storage_class_name)
        if artifact_storage_mount_path is not None:
            pulumi.set(__self__, "artifact_storage_mount_path", artifact_storage_mount_path)
        if artifact_storage_node_name is not None:
            pulumi.set(__self__, "artifact_storage_node_name", artifact_storage_node_name)
        if artifacts_storage_type is not None:
            pulumi.set(__self__, "artifacts_storage_type", artifacts_storage_type)
        if front_end_service_configuration is not None:
            pulumi.set(__self__, "front_end_service_configuration", front_end_service_configuration)

    @property
    @pulumi.getter(name="artifactStorageAccessMode")
    def artifact_storage_access_mode(self) -> Optional[str]:
        return pulumi.get(self, "artifact_storage_access_mode")

    @property
    @pulumi.getter(name="artifactStorageClassName")
    def artifact_storage_class_name(self) -> Optional[str]:
        return pulumi.get(self, "artifact_storage_class_name")

    @property
    @pulumi.getter(name="artifactStorageMountPath")
    def artifact_storage_mount_path(self) -> Optional[str]:
        return pulumi.get(self, "artifact_storage_mount_path")

    @property
    @pulumi.getter(name="artifactStorageNodeName")
    def artifact_storage_node_name(self) -> Optional[str]:
        return pulumi.get(self, "artifact_storage_node_name")

    @property
    @pulumi.getter(name="artifactsStorageType")
    def artifacts_storage_type(self) -> Optional[str]:
        return pulumi.get(self, "artifacts_storage_type")

    @property
    @pulumi.getter(name="frontEndServiceConfiguration")
    def front_end_service_configuration(self) -> Optional['outputs.FrontEndConfigurationResponse']:
        return pulumi.get(self, "front_end_service_configuration")


@pulumi.output_type
class ConfigurationResponse(dict):
    """
    Non versioned Container App configuration properties that define the mutable settings of a Container app
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "activeRevisionsMode":
            suggest = "active_revisions_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 active_revisions_mode: Optional[str] = None,
                 ingress: Optional['outputs.IngressResponse'] = None,
                 registries: Optional[Sequence['outputs.RegistryCredentialsResponse']] = None,
                 secrets: Optional[Sequence['outputs.SecretResponse']] = None):
        """
        Non versioned Container App configuration properties that define the mutable settings of a Container app
        :param str active_revisions_mode: ActiveRevisionsMode controls how active revisions are handled for the Container app:
               <list><item>Multiple: multiple revisions can be active. If no value if provided, this is the default</item><item>Single: Only one revision can be active at a time. Revision weights can not be used in this mode</item></list>
        :param 'IngressResponse' ingress: Ingress configurations.
        :param Sequence['RegistryCredentialsResponse'] registries: Collection of private container registry credentials for containers used by the Container app
        :param Sequence['SecretResponse'] secrets: Collection of secrets used by a Container app
        """
        if active_revisions_mode is not None:
            pulumi.set(__self__, "active_revisions_mode", active_revisions_mode)
        if ingress is not None:
            pulumi.set(__self__, "ingress", ingress)
        if registries is not None:
            pulumi.set(__self__, "registries", registries)
        if secrets is not None:
            pulumi.set(__self__, "secrets", secrets)

    @property
    @pulumi.getter(name="activeRevisionsMode")
    def active_revisions_mode(self) -> Optional[str]:
        """
        ActiveRevisionsMode controls how active revisions are handled for the Container app:
        <list><item>Multiple: multiple revisions can be active. If no value if provided, this is the default</item><item>Single: Only one revision can be active at a time. Revision weights can not be used in this mode</item></list>
        """
        return pulumi.get(self, "active_revisions_mode")

    @property
    @pulumi.getter
    def ingress(self) -> Optional['outputs.IngressResponse']:
        """
        Ingress configurations.
        """
        return pulumi.get(self, "ingress")

    @property
    @pulumi.getter
    def registries(self) -> Optional[Sequence['outputs.RegistryCredentialsResponse']]:
        """
        Collection of private container registry credentials for containers used by the Container app
        """
        return pulumi.get(self, "registries")

    @property
    @pulumi.getter
    def secrets(self) -> Optional[Sequence['outputs.SecretResponse']]:
        """
        Collection of secrets used by a Container app
        """
        return pulumi.get(self, "secrets")


@pulumi.output_type
class ContainerResourcesResponse(dict):
    """
    Container App container resource requirements.
    """
    def __init__(__self__, *,
                 cpu: Optional[float] = None,
                 memory: Optional[str] = None):
        """
        Container App container resource requirements.
        :param float cpu: Required CPU in cores, e.g. 0.5
        :param str memory: Required memory, e.g. "250Mb"
        """
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)

    @property
    @pulumi.getter
    def cpu(self) -> Optional[float]:
        """
        Required CPU in cores, e.g. 0.5
        """
        return pulumi.get(self, "cpu")

    @property
    @pulumi.getter
    def memory(self) -> Optional[str]:
        """
        Required memory, e.g. "250Mb"
        """
        return pulumi.get(self, "memory")


@pulumi.output_type
class ContainerResponse(dict):
    """
    Container App container definition.
    """
    def __init__(__self__, *,
                 args: Optional[Sequence[str]] = None,
                 command: Optional[Sequence[str]] = None,
                 env: Optional[Sequence['outputs.EnvironmentVarResponse']] = None,
                 image: Optional[str] = None,
                 name: Optional[str] = None,
                 resources: Optional['outputs.ContainerResourcesResponse'] = None):
        """
        Container App container definition.
        :param Sequence[str] args: Container start command arguments.
        :param Sequence[str] command: Container start command.
        :param Sequence['EnvironmentVarResponse'] env: Container environment variables.
        :param str image: Container image tag.
        :param str name: Custom container name.
        :param 'ContainerResourcesResponse' resources: Container resource requirements.
        """
        if args is not None:
            pulumi.set(__self__, "args", args)
        if command is not None:
            pulumi.set(__self__, "command", command)
        if env is not None:
            pulumi.set(__self__, "env", env)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)

    @property
    @pulumi.getter
    def args(self) -> Optional[Sequence[str]]:
        """
        Container start command arguments.
        """
        return pulumi.get(self, "args")

    @property
    @pulumi.getter
    def command(self) -> Optional[Sequence[str]]:
        """
        Container start command.
        """
        return pulumi.get(self, "command")

    @property
    @pulumi.getter
    def env(self) -> Optional[Sequence['outputs.EnvironmentVarResponse']]:
        """
        Container environment variables.
        """
        return pulumi.get(self, "env")

    @property
    @pulumi.getter
    def image(self) -> Optional[str]:
        """
        Container image tag.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Custom container name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def resources(self) -> Optional['outputs.ContainerResourcesResponse']:
        """
        Container resource requirements.
        """
        return pulumi.get(self, "resources")


@pulumi.output_type
class CustomScaleRuleResponse(dict):
    """
    Container App container Custom scaling rule.
    """
    def __init__(__self__, *,
                 auth: Optional[Sequence['outputs.ScaleRuleAuthResponse']] = None,
                 metadata: Optional[Mapping[str, str]] = None,
                 type: Optional[str] = None):
        """
        Container App container Custom scaling rule.
        :param Sequence['ScaleRuleAuthResponse'] auth: Authentication secrets for the custom scale rule.
        :param Mapping[str, str] metadata: Metadata properties to describe custom scale rule.
        :param str type: Type of the custom scale rule
               eg: azure-servicebus, redis etc.
        """
        if auth is not None:
            pulumi.set(__self__, "auth", auth)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def auth(self) -> Optional[Sequence['outputs.ScaleRuleAuthResponse']]:
        """
        Authentication secrets for the custom scale rule.
        """
        return pulumi.get(self, "auth")

    @property
    @pulumi.getter
    def metadata(self) -> Optional[Mapping[str, str]]:
        """
        Metadata properties to describe custom scale rule.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Type of the custom scale rule
        eg: azure-servicebus, redis etc.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class DaprComponentResponse(dict):
    """
    Dapr component configuration
    """
    def __init__(__self__, *,
                 metadata: Optional[Sequence['outputs.DaprMetadataResponse']] = None,
                 name: Optional[str] = None,
                 type: Optional[str] = None,
                 version: Optional[str] = None):
        """
        Dapr component configuration
        :param Sequence['DaprMetadataResponse'] metadata: Component metadata
        :param str name: Component name
        :param str type: Component type
        :param str version: Component version
        """
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[Sequence['outputs.DaprMetadataResponse']]:
        """
        Component metadata
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Component name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Component type
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        Component version
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class DaprMetadataResponse(dict):
    """
    Container App Dapr component metadata.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretRef":
            suggest = "secret_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DaprMetadataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DaprMetadataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DaprMetadataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[str] = None,
                 secret_ref: Optional[str] = None,
                 value: Optional[str] = None):
        """
        Container App Dapr component metadata.
        :param str name: Metadata property name.
        :param str secret_ref: Name of the Container App secret from which to pull the metadata property value.
        :param str value: Metadata property value.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if secret_ref is not None:
            pulumi.set(__self__, "secret_ref", secret_ref)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Metadata property name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="secretRef")
    def secret_ref(self) -> Optional[str]:
        """
        Name of the Container App secret from which to pull the metadata property value.
        """
        return pulumi.get(self, "secret_ref")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        Metadata property value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class DaprResponse(dict):
    """
    Container App Dapr configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appId":
            suggest = "app_id"
        elif key == "appPort":
            suggest = "app_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DaprResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DaprResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DaprResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 app_id: Optional[str] = None,
                 app_port: Optional[int] = None,
                 components: Optional[Sequence['outputs.DaprComponentResponse']] = None,
                 enabled: Optional[bool] = None):
        """
        Container App Dapr configuration.
        :param str app_id: Dapr application identifier
        :param int app_port: Port on which the Dapr side car
        :param Sequence['DaprComponentResponse'] components: Collection of Dapr components
        :param bool enabled: Boolean indicating if the Dapr side car is enabled
        """
        if app_id is not None:
            pulumi.set(__self__, "app_id", app_id)
        if app_port is not None:
            pulumi.set(__self__, "app_port", app_port)
        if components is not None:
            pulumi.set(__self__, "components", components)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> Optional[str]:
        """
        Dapr application identifier
        """
        return pulumi.get(self, "app_id")

    @property
    @pulumi.getter(name="appPort")
    def app_port(self) -> Optional[int]:
        """
        Port on which the Dapr side car
        """
        return pulumi.get(self, "app_port")

    @property
    @pulumi.getter
    def components(self) -> Optional[Sequence['outputs.DaprComponentResponse']]:
        """
        Collection of Dapr components
        """
        return pulumi.get(self, "components")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Boolean indicating if the Dapr side car is enabled
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class EnvironmentVarResponse(dict):
    """
    Container App container environment variable.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretRef":
            suggest = "secret_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvironmentVarResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvironmentVarResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvironmentVarResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[str] = None,
                 secret_ref: Optional[str] = None,
                 value: Optional[str] = None):
        """
        Container App container environment variable.
        :param str name: Environment variable name.
        :param str secret_ref: Name of the Container App secret from which to pull the environment variable value.
        :param str value: Non-secret environment variable value.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if secret_ref is not None:
            pulumi.set(__self__, "secret_ref", secret_ref)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Environment variable name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="secretRef")
    def secret_ref(self) -> Optional[str]:
        """
        Name of the Container App secret from which to pull the environment variable value.
        """
        return pulumi.get(self, "secret_ref")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        Non-secret environment variable value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ExtendedLocationResponse(dict):
    """
    Extended Location.
    """
    def __init__(__self__, *,
                 type: str,
                 name: Optional[str] = None):
        """
        Extended Location.
        :param str type: Type of extended location.
        :param str name: Name of extended location.
        """
        pulumi.set(__self__, "type", type)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of extended location.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of extended location.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class FrontEndConfigurationResponse(dict):
    def __init__(__self__, *,
                 kind: Optional[str] = None):
        if kind is not None:
            pulumi.set(__self__, "kind", kind)

    @property
    @pulumi.getter
    def kind(self) -> Optional[str]:
        return pulumi.get(self, "kind")


@pulumi.output_type
class HttpScaleRuleResponse(dict):
    """
    Container App container Custom scaling rule.
    """
    def __init__(__self__, *,
                 auth: Optional[Sequence['outputs.ScaleRuleAuthResponse']] = None,
                 metadata: Optional[Mapping[str, str]] = None):
        """
        Container App container Custom scaling rule.
        :param Sequence['ScaleRuleAuthResponse'] auth: Authentication secrets for the custom scale rule.
        :param Mapping[str, str] metadata: Metadata properties to describe http scale rule.
        """
        if auth is not None:
            pulumi.set(__self__, "auth", auth)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)

    @property
    @pulumi.getter
    def auth(self) -> Optional[Sequence['outputs.ScaleRuleAuthResponse']]:
        """
        Authentication secrets for the custom scale rule.
        """
        return pulumi.get(self, "auth")

    @property
    @pulumi.getter
    def metadata(self) -> Optional[Mapping[str, str]]:
        """
        Metadata properties to describe http scale rule.
        """
        return pulumi.get(self, "metadata")


@pulumi.output_type
class IngressResponse(dict):
    """
    Container App Ingress configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowInsecure":
            suggest = "allow_insecure"
        elif key == "targetPort":
            suggest = "target_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IngressResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IngressResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IngressResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fqdn: str,
                 allow_insecure: Optional[bool] = None,
                 external: Optional[bool] = None,
                 target_port: Optional[int] = None,
                 traffic: Optional[Sequence['outputs.TrafficWeightResponse']] = None,
                 transport: Optional[str] = None):
        """
        Container App Ingress configuration.
        :param str fqdn: Hostname.
        :param bool allow_insecure: Bool indicating if HTTP connections to is allowed. If set to false HTTP connections are automatically redirected to HTTPS connections
        :param bool external: Bool indicating if app exposes an external http endpoint
        :param int target_port: Target Port in containers for traffic from ingress
        :param str transport: Ingress transport protocol
        """
        pulumi.set(__self__, "fqdn", fqdn)
        if allow_insecure is not None:
            pulumi.set(__self__, "allow_insecure", allow_insecure)
        if external is None:
            external = False
        if external is not None:
            pulumi.set(__self__, "external", external)
        if target_port is not None:
            pulumi.set(__self__, "target_port", target_port)
        if traffic is not None:
            pulumi.set(__self__, "traffic", traffic)
        if transport is not None:
            pulumi.set(__self__, "transport", transport)

    @property
    @pulumi.getter
    def fqdn(self) -> str:
        """
        Hostname.
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter(name="allowInsecure")
    def allow_insecure(self) -> Optional[bool]:
        """
        Bool indicating if HTTP connections to is allowed. If set to false HTTP connections are automatically redirected to HTTPS connections
        """
        return pulumi.get(self, "allow_insecure")

    @property
    @pulumi.getter
    def external(self) -> Optional[bool]:
        """
        Bool indicating if app exposes an external http endpoint
        """
        return pulumi.get(self, "external")

    @property
    @pulumi.getter(name="targetPort")
    def target_port(self) -> Optional[int]:
        """
        Target Port in containers for traffic from ingress
        """
        return pulumi.get(self, "target_port")

    @property
    @pulumi.getter
    def traffic(self) -> Optional[Sequence['outputs.TrafficWeightResponse']]:
        return pulumi.get(self, "traffic")

    @property
    @pulumi.getter
    def transport(self) -> Optional[str]:
        """
        Ingress transport protocol
        """
        return pulumi.get(self, "transport")


@pulumi.output_type
class LogAnalyticsConfigurationResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customerId":
            suggest = "customer_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LogAnalyticsConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LogAnalyticsConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LogAnalyticsConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 customer_id: Optional[str] = None):
        if customer_id is not None:
            pulumi.set(__self__, "customer_id", customer_id)

    @property
    @pulumi.getter(name="customerId")
    def customer_id(self) -> Optional[str]:
        return pulumi.get(self, "customer_id")


@pulumi.output_type
class QueueScaleRuleResponse(dict):
    """
    Container App container Azure Queue based scaling rule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queueLength":
            suggest = "queue_length"
        elif key == "queueName":
            suggest = "queue_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in QueueScaleRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        QueueScaleRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        QueueScaleRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auth: Optional[Sequence['outputs.ScaleRuleAuthResponse']] = None,
                 queue_length: Optional[int] = None,
                 queue_name: Optional[str] = None):
        """
        Container App container Azure Queue based scaling rule.
        :param Sequence['ScaleRuleAuthResponse'] auth: Authentication secrets for the queue scale rule.
        :param int queue_length: Queue length.
        :param str queue_name: Queue name.
        """
        if auth is not None:
            pulumi.set(__self__, "auth", auth)
        if queue_length is not None:
            pulumi.set(__self__, "queue_length", queue_length)
        if queue_name is not None:
            pulumi.set(__self__, "queue_name", queue_name)

    @property
    @pulumi.getter
    def auth(self) -> Optional[Sequence['outputs.ScaleRuleAuthResponse']]:
        """
        Authentication secrets for the queue scale rule.
        """
        return pulumi.get(self, "auth")

    @property
    @pulumi.getter(name="queueLength")
    def queue_length(self) -> Optional[int]:
        """
        Queue length.
        """
        return pulumi.get(self, "queue_length")

    @property
    @pulumi.getter(name="queueName")
    def queue_name(self) -> Optional[str]:
        """
        Queue name.
        """
        return pulumi.get(self, "queue_name")


@pulumi.output_type
class RegistryCredentialsResponse(dict):
    """
    Container App Private Registry
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "passwordSecretRef":
            suggest = "password_secret_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistryCredentialsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistryCredentialsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistryCredentialsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 password_secret_ref: Optional[str] = None,
                 server: Optional[str] = None,
                 username: Optional[str] = None):
        """
        Container App Private Registry
        :param str password_secret_ref: The name of the Secret that contains the registry login password
        :param str server: Container Registry Server
        :param str username: Container Registry Username
        """
        if password_secret_ref is not None:
            pulumi.set(__self__, "password_secret_ref", password_secret_ref)
        if server is not None:
            pulumi.set(__self__, "server", server)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="passwordSecretRef")
    def password_secret_ref(self) -> Optional[str]:
        """
        The name of the Secret that contains the registry login password
        """
        return pulumi.get(self, "password_secret_ref")

    @property
    @pulumi.getter
    def server(self) -> Optional[str]:
        """
        Container Registry Server
        """
        return pulumi.get(self, "server")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        Container Registry Username
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class ScaleResponse(dict):
    """
    Container App scaling configurations.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxReplicas":
            suggest = "max_replicas"
        elif key == "minReplicas":
            suggest = "min_replicas"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScaleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScaleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScaleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_replicas: Optional[int] = None,
                 min_replicas: Optional[int] = None,
                 rules: Optional[Sequence['outputs.ScaleRuleResponse']] = None):
        """
        Container App scaling configurations.
        :param int max_replicas: Optional. Maximum number of container replicas. Defaults to 10 if not set.
        :param int min_replicas: Optional. Minimum number of container replicas.
        :param Sequence['ScaleRuleResponse'] rules: Scaling rules.
        """
        if max_replicas is not None:
            pulumi.set(__self__, "max_replicas", max_replicas)
        if min_replicas is not None:
            pulumi.set(__self__, "min_replicas", min_replicas)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter(name="maxReplicas")
    def max_replicas(self) -> Optional[int]:
        """
        Optional. Maximum number of container replicas. Defaults to 10 if not set.
        """
        return pulumi.get(self, "max_replicas")

    @property
    @pulumi.getter(name="minReplicas")
    def min_replicas(self) -> Optional[int]:
        """
        Optional. Minimum number of container replicas.
        """
        return pulumi.get(self, "min_replicas")

    @property
    @pulumi.getter
    def rules(self) -> Optional[Sequence['outputs.ScaleRuleResponse']]:
        """
        Scaling rules.
        """
        return pulumi.get(self, "rules")


@pulumi.output_type
class ScaleRuleAuthResponse(dict):
    """
    Auth Secrets for Container App Scale Rule
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretRef":
            suggest = "secret_ref"
        elif key == "triggerParameter":
            suggest = "trigger_parameter"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScaleRuleAuthResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScaleRuleAuthResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScaleRuleAuthResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_ref: Optional[str] = None,
                 trigger_parameter: Optional[str] = None):
        """
        Auth Secrets for Container App Scale Rule
        :param str secret_ref: Name of the Container App secret from which to pull the auth params.
        :param str trigger_parameter: Trigger Parameter that uses the secret
        """
        if secret_ref is not None:
            pulumi.set(__self__, "secret_ref", secret_ref)
        if trigger_parameter is not None:
            pulumi.set(__self__, "trigger_parameter", trigger_parameter)

    @property
    @pulumi.getter(name="secretRef")
    def secret_ref(self) -> Optional[str]:
        """
        Name of the Container App secret from which to pull the auth params.
        """
        return pulumi.get(self, "secret_ref")

    @property
    @pulumi.getter(name="triggerParameter")
    def trigger_parameter(self) -> Optional[str]:
        """
        Trigger Parameter that uses the secret
        """
        return pulumi.get(self, "trigger_parameter")


@pulumi.output_type
class ScaleRuleResponse(dict):
    """
    Container App container scaling rule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "azureQueue":
            suggest = "azure_queue"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScaleRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScaleRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScaleRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 azure_queue: Optional['outputs.QueueScaleRuleResponse'] = None,
                 custom: Optional['outputs.CustomScaleRuleResponse'] = None,
                 http: Optional['outputs.HttpScaleRuleResponse'] = None,
                 name: Optional[str] = None):
        """
        Container App container scaling rule.
        :param 'QueueScaleRuleResponse' azure_queue: Azure Queue based scaling.
        :param 'CustomScaleRuleResponse' custom: Custom scale rule.
        :param 'HttpScaleRuleResponse' http: HTTP requests based scaling.
        :param str name: Scale Rule Name
        """
        if azure_queue is not None:
            pulumi.set(__self__, "azure_queue", azure_queue)
        if custom is not None:
            pulumi.set(__self__, "custom", custom)
        if http is not None:
            pulumi.set(__self__, "http", http)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="azureQueue")
    def azure_queue(self) -> Optional['outputs.QueueScaleRuleResponse']:
        """
        Azure Queue based scaling.
        """
        return pulumi.get(self, "azure_queue")

    @property
    @pulumi.getter
    def custom(self) -> Optional['outputs.CustomScaleRuleResponse']:
        """
        Custom scale rule.
        """
        return pulumi.get(self, "custom")

    @property
    @pulumi.getter
    def http(self) -> Optional['outputs.HttpScaleRuleResponse']:
        """
        HTTP requests based scaling.
        """
        return pulumi.get(self, "http")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Scale Rule Name
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class SecretResponse(dict):
    """
    Container App Secret.
    """
    def __init__(__self__, *,
                 name: Optional[str] = None):
        """
        Container App Secret.
        :param str name: Secret Name.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Secret Name.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class TemplateResponse(dict):
    """
    Container App versioned application definition.
    Defines the desired state of an immutable revision.
    Any changes to this section Will result in a new revision being created
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "revisionSuffix":
            suggest = "revision_suffix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TemplateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TemplateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TemplateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 containers: Optional[Sequence['outputs.ContainerResponse']] = None,
                 dapr: Optional['outputs.DaprResponse'] = None,
                 revision_suffix: Optional[str] = None,
                 scale: Optional['outputs.ScaleResponse'] = None):
        """
        Container App versioned application definition.
        Defines the desired state of an immutable revision.
        Any changes to this section Will result in a new revision being created
        :param Sequence['ContainerResponse'] containers: List of container definitions for the Container App.
        :param 'DaprResponse' dapr: Dapr configuration for the Container App.
        :param str revision_suffix: User friendly suffix that is appended to the revision name
        :param 'ScaleResponse' scale: Scaling properties for the Container App.
        """
        if containers is not None:
            pulumi.set(__self__, "containers", containers)
        if dapr is not None:
            pulumi.set(__self__, "dapr", dapr)
        if revision_suffix is not None:
            pulumi.set(__self__, "revision_suffix", revision_suffix)
        if scale is not None:
            pulumi.set(__self__, "scale", scale)

    @property
    @pulumi.getter
    def containers(self) -> Optional[Sequence['outputs.ContainerResponse']]:
        """
        List of container definitions for the Container App.
        """
        return pulumi.get(self, "containers")

    @property
    @pulumi.getter
    def dapr(self) -> Optional['outputs.DaprResponse']:
        """
        Dapr configuration for the Container App.
        """
        return pulumi.get(self, "dapr")

    @property
    @pulumi.getter(name="revisionSuffix")
    def revision_suffix(self) -> Optional[str]:
        """
        User friendly suffix that is appended to the revision name
        """
        return pulumi.get(self, "revision_suffix")

    @property
    @pulumi.getter
    def scale(self) -> Optional['outputs.ScaleResponse']:
        """
        Scaling properties for the Container App.
        """
        return pulumi.get(self, "scale")


@pulumi.output_type
class TrafficWeightResponse(dict):
    """
    Traffic weight assigned to a revision
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "latestRevision":
            suggest = "latest_revision"
        elif key == "revisionName":
            suggest = "revision_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TrafficWeightResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TrafficWeightResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TrafficWeightResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 latest_revision: Optional[bool] = None,
                 revision_name: Optional[str] = None,
                 weight: Optional[int] = None):
        """
        Traffic weight assigned to a revision
        :param bool latest_revision: Indicates that the traffic weight belongs to a latest stable revision
        :param str revision_name: Name of a revision
        :param int weight: Traffic weight assigned to a revision
        """
        if latest_revision is None:
            latest_revision = False
        if latest_revision is not None:
            pulumi.set(__self__, "latest_revision", latest_revision)
        if revision_name is not None:
            pulumi.set(__self__, "revision_name", revision_name)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="latestRevision")
    def latest_revision(self) -> Optional[bool]:
        """
        Indicates that the traffic weight belongs to a latest stable revision
        """
        return pulumi.get(self, "latest_revision")

    @property
    @pulumi.getter(name="revisionName")
    def revision_name(self) -> Optional[str]:
        """
        Name of a revision
        """
        return pulumi.get(self, "revision_name")

    @property
    @pulumi.getter
    def weight(self) -> Optional[int]:
        """
        Traffic weight assigned to a revision
        """
        return pulumi.get(self, "weight")


