# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'EventGridArgs',
    'EventHubArgs',
    'ServiceBusArgs',
]

@pulumi.input_type
class EventGridArgs:
    def __init__(__self__, *,
                 access_key1: pulumi.Input[str],
                 endpoint_type: pulumi.Input[str],
                 topic_endpoint: pulumi.Input[str],
                 access_key2: Optional[pulumi.Input[str]] = None,
                 dead_letter_secret: Optional[pulumi.Input[str]] = None):
        """
        Properties related to EventGrid.
        :param pulumi.Input[str] access_key1: EventGrid secondary accesskey. Will be obfuscated during read.
        :param pulumi.Input[str] endpoint_type: The type of Digital Twins endpoint
               Expected value is 'EventGrid'.
        :param pulumi.Input[str] topic_endpoint: EventGrid Topic Endpoint
        :param pulumi.Input[str] access_key2: EventGrid secondary accesskey. Will be obfuscated during read.
        :param pulumi.Input[str] dead_letter_secret: Dead letter storage secret. Will be obfuscated during read.
        """
        pulumi.set(__self__, "access_key1", access_key1)
        pulumi.set(__self__, "endpoint_type", 'EventGrid')
        pulumi.set(__self__, "topic_endpoint", topic_endpoint)
        if access_key2 is not None:
            pulumi.set(__self__, "access_key2", access_key2)
        if dead_letter_secret is not None:
            pulumi.set(__self__, "dead_letter_secret", dead_letter_secret)

    @property
    @pulumi.getter(name="accessKey1")
    def access_key1(self) -> pulumi.Input[str]:
        """
        EventGrid secondary accesskey. Will be obfuscated during read.
        """
        return pulumi.get(self, "access_key1")

    @access_key1.setter
    def access_key1(self, value: pulumi.Input[str]):
        pulumi.set(self, "access_key1", value)

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> pulumi.Input[str]:
        """
        The type of Digital Twins endpoint
        Expected value is 'EventGrid'.
        """
        return pulumi.get(self, "endpoint_type")

    @endpoint_type.setter
    def endpoint_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "endpoint_type", value)

    @property
    @pulumi.getter(name="topicEndpoint")
    def topic_endpoint(self) -> pulumi.Input[str]:
        """
        EventGrid Topic Endpoint
        """
        return pulumi.get(self, "topic_endpoint")

    @topic_endpoint.setter
    def topic_endpoint(self, value: pulumi.Input[str]):
        pulumi.set(self, "topic_endpoint", value)

    @property
    @pulumi.getter(name="accessKey2")
    def access_key2(self) -> Optional[pulumi.Input[str]]:
        """
        EventGrid secondary accesskey. Will be obfuscated during read.
        """
        return pulumi.get(self, "access_key2")

    @access_key2.setter
    def access_key2(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_key2", value)

    @property
    @pulumi.getter(name="deadLetterSecret")
    def dead_letter_secret(self) -> Optional[pulumi.Input[str]]:
        """
        Dead letter storage secret. Will be obfuscated during read.
        """
        return pulumi.get(self, "dead_letter_secret")

    @dead_letter_secret.setter
    def dead_letter_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dead_letter_secret", value)


@pulumi.input_type
class EventHubArgs:
    def __init__(__self__, *,
                 connection_string_primary_key: pulumi.Input[str],
                 endpoint_type: pulumi.Input[str],
                 connection_string_secondary_key: Optional[pulumi.Input[str]] = None,
                 dead_letter_secret: Optional[pulumi.Input[str]] = None):
        """
        Properties related to EventHub.
        :param pulumi.Input[str] connection_string_primary_key: PrimaryConnectionString of the endpoint. Will be obfuscated during read.
        :param pulumi.Input[str] endpoint_type: The type of Digital Twins endpoint
               Expected value is 'EventHub'.
        :param pulumi.Input[str] connection_string_secondary_key: SecondaryConnectionString of the endpoint. Will be obfuscated during read.
        :param pulumi.Input[str] dead_letter_secret: Dead letter storage secret. Will be obfuscated during read.
        """
        pulumi.set(__self__, "connection_string_primary_key", connection_string_primary_key)
        pulumi.set(__self__, "endpoint_type", 'EventHub')
        if connection_string_secondary_key is not None:
            pulumi.set(__self__, "connection_string_secondary_key", connection_string_secondary_key)
        if dead_letter_secret is not None:
            pulumi.set(__self__, "dead_letter_secret", dead_letter_secret)

    @property
    @pulumi.getter(name="connectionStringPrimaryKey")
    def connection_string_primary_key(self) -> pulumi.Input[str]:
        """
        PrimaryConnectionString of the endpoint. Will be obfuscated during read.
        """
        return pulumi.get(self, "connection_string_primary_key")

    @connection_string_primary_key.setter
    def connection_string_primary_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "connection_string_primary_key", value)

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> pulumi.Input[str]:
        """
        The type of Digital Twins endpoint
        Expected value is 'EventHub'.
        """
        return pulumi.get(self, "endpoint_type")

    @endpoint_type.setter
    def endpoint_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "endpoint_type", value)

    @property
    @pulumi.getter(name="connectionStringSecondaryKey")
    def connection_string_secondary_key(self) -> Optional[pulumi.Input[str]]:
        """
        SecondaryConnectionString of the endpoint. Will be obfuscated during read.
        """
        return pulumi.get(self, "connection_string_secondary_key")

    @connection_string_secondary_key.setter
    def connection_string_secondary_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_string_secondary_key", value)

    @property
    @pulumi.getter(name="deadLetterSecret")
    def dead_letter_secret(self) -> Optional[pulumi.Input[str]]:
        """
        Dead letter storage secret. Will be obfuscated during read.
        """
        return pulumi.get(self, "dead_letter_secret")

    @dead_letter_secret.setter
    def dead_letter_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dead_letter_secret", value)


@pulumi.input_type
class ServiceBusArgs:
    def __init__(__self__, *,
                 endpoint_type: pulumi.Input[str],
                 primary_connection_string: pulumi.Input[str],
                 dead_letter_secret: Optional[pulumi.Input[str]] = None,
                 secondary_connection_string: Optional[pulumi.Input[str]] = None):
        """
        Properties related to ServiceBus.
        :param pulumi.Input[str] endpoint_type: The type of Digital Twins endpoint
               Expected value is 'ServiceBus'.
        :param pulumi.Input[str] primary_connection_string: PrimaryConnectionString of the endpoint. Will be obfuscated during read.
        :param pulumi.Input[str] dead_letter_secret: Dead letter storage secret. Will be obfuscated during read.
        :param pulumi.Input[str] secondary_connection_string: SecondaryConnectionString of the endpoint. Will be obfuscated during read.
        """
        pulumi.set(__self__, "endpoint_type", 'ServiceBus')
        pulumi.set(__self__, "primary_connection_string", primary_connection_string)
        if dead_letter_secret is not None:
            pulumi.set(__self__, "dead_letter_secret", dead_letter_secret)
        if secondary_connection_string is not None:
            pulumi.set(__self__, "secondary_connection_string", secondary_connection_string)

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> pulumi.Input[str]:
        """
        The type of Digital Twins endpoint
        Expected value is 'ServiceBus'.
        """
        return pulumi.get(self, "endpoint_type")

    @endpoint_type.setter
    def endpoint_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "endpoint_type", value)

    @property
    @pulumi.getter(name="primaryConnectionString")
    def primary_connection_string(self) -> pulumi.Input[str]:
        """
        PrimaryConnectionString of the endpoint. Will be obfuscated during read.
        """
        return pulumi.get(self, "primary_connection_string")

    @primary_connection_string.setter
    def primary_connection_string(self, value: pulumi.Input[str]):
        pulumi.set(self, "primary_connection_string", value)

    @property
    @pulumi.getter(name="deadLetterSecret")
    def dead_letter_secret(self) -> Optional[pulumi.Input[str]]:
        """
        Dead letter storage secret. Will be obfuscated during read.
        """
        return pulumi.get(self, "dead_letter_secret")

    @dead_letter_secret.setter
    def dead_letter_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dead_letter_secret", value)

    @property
    @pulumi.getter(name="secondaryConnectionString")
    def secondary_connection_string(self) -> Optional[pulumi.Input[str]]:
        """
        SecondaryConnectionString of the endpoint. Will be obfuscated during read.
        """
        return pulumi.get(self, "secondary_connection_string")

    @secondary_connection_string.setter
    def secondary_connection_string(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secondary_connection_string", value)


