# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'ApiEntityArgs',
    'ApiOAuthSettingsParameterArgs',
    'ApiOAuthSettingsArgs',
    'ApiPoliciesArgs',
    'ArmPlanArgs',
    'BackendServiceDefinitionArgs',
    'ConnectionErrorArgs',
    'ConnectionParameterArgs',
    'ConnectionStatusArgs',
    'ConsentLinkInputParameter',
    'CustomLoginSettingValueArgs',
    'ExpandedParentApiEntityArgs',
    'GeneralApiInformationArgs',
    'HostingEnvironmentServiceDescriptionsArgs',
    'ParameterCustomLoginSettingValuesArgs',
    'ResponseMessageEnvelopeApiEntityArgs',
    'SkuDescriptionArgs',
]

@pulumi.input_type
class ApiEntityArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[str],
                 api_definition_url: Optional[pulumi.Input[str]] = None,
                 backend_service: Optional[pulumi.Input['BackendServiceDefinitionArgs']] = None,
                 capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 changed_time: Optional[pulumi.Input[str]] = None,
                 connection_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ConnectionParameterArgs']]]] = None,
                 created_time: Optional[pulumi.Input[str]] = None,
                 general_information: Optional[pulumi.Input['GeneralApiInformationArgs']] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[Any] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 policies: Optional[pulumi.Input['ApiPoliciesArgs']] = None,
                 protocols: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 runtime_urls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        API Management
        :param pulumi.Input[str] location: Resource Location
        :param pulumi.Input[str] api_definition_url: API definition Url - url where the swagger can be downloaded from
        :param pulumi.Input['BackendServiceDefinitionArgs'] backend_service: Backend service definition
        :param pulumi.Input[Sequence[pulumi.Input[str]]] capabilities: Capabilities
        :param pulumi.Input[str] changed_time: Timestamp of last connection change.
        :param pulumi.Input[Mapping[str, pulumi.Input['ConnectionParameterArgs']]] connection_parameters: Connection parameters
        :param pulumi.Input[str] created_time: Timestamp of the connection creation
        :param pulumi.Input['GeneralApiInformationArgs'] general_information: the URL path of this API when exposed via APIM
        :param pulumi.Input[str] id: Resource Id
        :param pulumi.Input[str] kind: Kind of resource
        :param Any metadata: Free form object for the data caller wants to store
        :param pulumi.Input[str] name: Resource Name
        :param pulumi.Input[str] path: the URL path of this API when exposed via APIM
        :param pulumi.Input['ApiPoliciesArgs'] policies: API policies
        :param pulumi.Input[Sequence[pulumi.Input[str]]] protocols: Protocols supported by the front end - http/https
        :param pulumi.Input[Sequence[pulumi.Input[str]]] runtime_urls: Read only property returning the runtime endpoints where the API can be called
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Resource tags
        :param pulumi.Input[str] type: Resource type
        """
        pulumi.set(__self__, "location", location)
        if api_definition_url is not None:
            pulumi.set(__self__, "api_definition_url", api_definition_url)
        if backend_service is not None:
            pulumi.set(__self__, "backend_service", backend_service)
        if capabilities is not None:
            pulumi.set(__self__, "capabilities", capabilities)
        if changed_time is not None:
            pulumi.set(__self__, "changed_time", changed_time)
        if connection_parameters is not None:
            pulumi.set(__self__, "connection_parameters", connection_parameters)
        if created_time is not None:
            pulumi.set(__self__, "created_time", created_time)
        if general_information is not None:
            pulumi.set(__self__, "general_information", general_information)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if policies is not None:
            pulumi.set(__self__, "policies", policies)
        if protocols is not None:
            pulumi.set(__self__, "protocols", protocols)
        if runtime_urls is not None:
            pulumi.set(__self__, "runtime_urls", runtime_urls)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[str]:
        """
        Resource Location
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="apiDefinitionUrl")
    def api_definition_url(self) -> Optional[pulumi.Input[str]]:
        """
        API definition Url - url where the swagger can be downloaded from
        """
        return pulumi.get(self, "api_definition_url")

    @api_definition_url.setter
    def api_definition_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_definition_url", value)

    @property
    @pulumi.getter(name="backendService")
    def backend_service(self) -> Optional[pulumi.Input['BackendServiceDefinitionArgs']]:
        """
        Backend service definition
        """
        return pulumi.get(self, "backend_service")

    @backend_service.setter
    def backend_service(self, value: Optional[pulumi.Input['BackendServiceDefinitionArgs']]):
        pulumi.set(self, "backend_service", value)

    @property
    @pulumi.getter
    def capabilities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Capabilities
        """
        return pulumi.get(self, "capabilities")

    @capabilities.setter
    def capabilities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "capabilities", value)

    @property
    @pulumi.getter(name="changedTime")
    def changed_time(self) -> Optional[pulumi.Input[str]]:
        """
        Timestamp of last connection change.
        """
        return pulumi.get(self, "changed_time")

    @changed_time.setter
    def changed_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "changed_time", value)

    @property
    @pulumi.getter(name="connectionParameters")
    def connection_parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ConnectionParameterArgs']]]]:
        """
        Connection parameters
        """
        return pulumi.get(self, "connection_parameters")

    @connection_parameters.setter
    def connection_parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ConnectionParameterArgs']]]]):
        pulumi.set(self, "connection_parameters", value)

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> Optional[pulumi.Input[str]]:
        """
        Timestamp of the connection creation
        """
        return pulumi.get(self, "created_time")

    @created_time.setter
    def created_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_time", value)

    @property
    @pulumi.getter(name="generalInformation")
    def general_information(self) -> Optional[pulumi.Input['GeneralApiInformationArgs']]:
        """
        the URL path of this API when exposed via APIM
        """
        return pulumi.get(self, "general_information")

    @general_information.setter
    def general_information(self, value: Optional[pulumi.Input['GeneralApiInformationArgs']]):
        pulumi.set(self, "general_information", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        Kind of resource
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[Any]:
        """
        Free form object for the data caller wants to store
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[Any]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Resource Name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        the URL path of this API when exposed via APIM
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def policies(self) -> Optional[pulumi.Input['ApiPoliciesArgs']]:
        """
        API policies
        """
        return pulumi.get(self, "policies")

    @policies.setter
    def policies(self, value: Optional[pulumi.Input['ApiPoliciesArgs']]):
        pulumi.set(self, "policies", value)

    @property
    @pulumi.getter
    def protocols(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Protocols supported by the front end - http/https
        """
        return pulumi.get(self, "protocols")

    @protocols.setter
    def protocols(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "protocols", value)

    @property
    @pulumi.getter(name="runtimeUrls")
    def runtime_urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Read only property returning the runtime endpoints where the API can be called
        """
        return pulumi.get(self, "runtime_urls")

    @runtime_urls.setter
    def runtime_urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "runtime_urls", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Resource tags
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Resource type
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class ApiOAuthSettingsParameterArgs:
    def __init__(__self__, *,
                 options: Optional[Any] = None,
                 ui_definition: Optional[Any] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        OAuth Settings Parameter
        :param Any options: Read only: Options available to this parameter
        :param Any ui_definition: UI definitions per culture as caller can specify the culture
        :param pulumi.Input[str] value: Value
        """
        if options is not None:
            pulumi.set(__self__, "options", options)
        if ui_definition is not None:
            pulumi.set(__self__, "ui_definition", ui_definition)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def options(self) -> Optional[Any]:
        """
        Read only: Options available to this parameter
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[Any]):
        pulumi.set(self, "options", value)

    @property
    @pulumi.getter(name="uiDefinition")
    def ui_definition(self) -> Optional[Any]:
        """
        UI definitions per culture as caller can specify the culture
        """
        return pulumi.get(self, "ui_definition")

    @ui_definition.setter
    def ui_definition(self, value: Optional[Any]):
        pulumi.set(self, "ui_definition", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Value
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class ApiOAuthSettingsArgs:
    def __init__(__self__, *,
                 client_id: Optional[pulumi.Input[str]] = None,
                 client_secret: Optional[pulumi.Input[str]] = None,
                 custom_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['ApiOAuthSettingsParameterArgs']]]] = None,
                 identity_provider: Optional[pulumi.Input[str]] = None,
                 properties: Optional[Any] = None,
                 redirect_url: Optional[pulumi.Input[str]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        OAuth settings for the connection provider
        :param pulumi.Input[str] client_id: Resource provider client id
        :param pulumi.Input[str] client_secret: Client Secret needed for OAuth
        :param pulumi.Input[Mapping[str, pulumi.Input['ApiOAuthSettingsParameterArgs']]] custom_parameters: OAuth parameters key is the name of parameter
        :param pulumi.Input[str] identity_provider: Identity provider
        :param Any properties: Read only properties for this oauth setting.
        :param pulumi.Input[str] redirect_url: Url
        :param pulumi.Input[Sequence[pulumi.Input[str]]] scopes: OAuth scopes
        """
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if custom_parameters is not None:
            pulumi.set(__self__, "custom_parameters", custom_parameters)
        if identity_provider is not None:
            pulumi.set(__self__, "identity_provider", identity_provider)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if redirect_url is not None:
            pulumi.set(__self__, "redirect_url", redirect_url)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource provider client id
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[str]]:
        """
        Client Secret needed for OAuth
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_secret", value)

    @property
    @pulumi.getter(name="customParameters")
    def custom_parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ApiOAuthSettingsParameterArgs']]]]:
        """
        OAuth parameters key is the name of parameter
        """
        return pulumi.get(self, "custom_parameters")

    @custom_parameters.setter
    def custom_parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ApiOAuthSettingsParameterArgs']]]]):
        pulumi.set(self, "custom_parameters", value)

    @property
    @pulumi.getter(name="identityProvider")
    def identity_provider(self) -> Optional[pulumi.Input[str]]:
        """
        Identity provider
        """
        return pulumi.get(self, "identity_provider")

    @identity_provider.setter
    def identity_provider(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identity_provider", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[Any]:
        """
        Read only properties for this oauth setting.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[Any]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="redirectUrl")
    def redirect_url(self) -> Optional[pulumi.Input[str]]:
        """
        Url
        """
        return pulumi.get(self, "redirect_url")

    @redirect_url.setter
    def redirect_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "redirect_url", value)

    @property
    @pulumi.getter
    def scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        OAuth scopes
        """
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "scopes", value)


@pulumi.input_type
class ApiPoliciesArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[str],
                 content: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        API policies
        :param pulumi.Input[str] location: Resource Location
        :param pulumi.Input[str] content: Content of xml policy
        :param pulumi.Input[str] id: Resource Id
        :param pulumi.Input[str] kind: Kind of resource
        :param pulumi.Input[str] name: Resource Name
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Resource tags
        :param pulumi.Input[str] type: Resource type
        """
        pulumi.set(__self__, "location", location)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[str]:
        """
        Resource Location
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[str]]:
        """
        Content of xml policy
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        Kind of resource
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Resource Name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Resource tags
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Resource type
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class ArmPlanArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 product: Optional[pulumi.Input[str]] = None,
                 promotion_code: Optional[pulumi.Input[str]] = None,
                 publisher: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        The plan object in an ARM, represents a marketplace plan
        :param pulumi.Input[str] name: The name
        :param pulumi.Input[str] product: The product
        :param pulumi.Input[str] promotion_code: The promotion code
        :param pulumi.Input[str] publisher: The publisher
        :param pulumi.Input[str] version: Version of product
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if product is not None:
            pulumi.set(__self__, "product", product)
        if promotion_code is not None:
            pulumi.set(__self__, "promotion_code", promotion_code)
        if publisher is not None:
            pulumi.set(__self__, "publisher", publisher)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def product(self) -> Optional[pulumi.Input[str]]:
        """
        The product
        """
        return pulumi.get(self, "product")

    @product.setter
    def product(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "product", value)

    @property
    @pulumi.getter(name="promotionCode")
    def promotion_code(self) -> Optional[pulumi.Input[str]]:
        """
        The promotion code
        """
        return pulumi.get(self, "promotion_code")

    @promotion_code.setter
    def promotion_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "promotion_code", value)

    @property
    @pulumi.getter
    def publisher(self) -> Optional[pulumi.Input[str]]:
        """
        The publisher
        """
        return pulumi.get(self, "publisher")

    @publisher.setter
    def publisher(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "publisher", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Version of product
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class BackendServiceDefinitionArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[str],
                 hosting_environment_service_urls: Optional[pulumi.Input[Sequence[pulumi.Input['HostingEnvironmentServiceDescriptionsArgs']]]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 service_url: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        API definitions with backend urls
        :param pulumi.Input[str] location: Resource Location
        :param pulumi.Input[Sequence[pulumi.Input['HostingEnvironmentServiceDescriptionsArgs']]] hosting_environment_service_urls: Service Urls per Hosting environment
        :param pulumi.Input[str] id: Resource Id
        :param pulumi.Input[str] kind: Kind of resource
        :param pulumi.Input[str] name: Resource Name
        :param pulumi.Input[str] service_url: Url from which the swagger payload will be fetched
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Resource tags
        :param pulumi.Input[str] type: Resource type
        """
        pulumi.set(__self__, "location", location)
        if hosting_environment_service_urls is not None:
            pulumi.set(__self__, "hosting_environment_service_urls", hosting_environment_service_urls)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if service_url is not None:
            pulumi.set(__self__, "service_url", service_url)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[str]:
        """
        Resource Location
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="hostingEnvironmentServiceUrls")
    def hosting_environment_service_urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HostingEnvironmentServiceDescriptionsArgs']]]]:
        """
        Service Urls per Hosting environment
        """
        return pulumi.get(self, "hosting_environment_service_urls")

    @hosting_environment_service_urls.setter
    def hosting_environment_service_urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HostingEnvironmentServiceDescriptionsArgs']]]]):
        pulumi.set(self, "hosting_environment_service_urls", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        Kind of resource
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Resource Name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="serviceUrl")
    def service_url(self) -> Optional[pulumi.Input[str]]:
        """
        Url from which the swagger payload will be fetched
        """
        return pulumi.get(self, "service_url")

    @service_url.setter
    def service_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_url", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Resource tags
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Resource type
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class ConnectionErrorArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[str],
                 code: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 message: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Connection error
        :param pulumi.Input[str] location: Resource Location
        :param pulumi.Input[str] code: code of the status
        :param pulumi.Input[str] id: Resource Id
        :param pulumi.Input[str] kind: Kind of resource
        :param pulumi.Input[str] message: Description of the status
        :param pulumi.Input[str] name: Resource Name
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Resource tags
        :param pulumi.Input[str] type: Resource type
        """
        pulumi.set(__self__, "location", location)
        if code is not None:
            pulumi.set(__self__, "code", code)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[str]:
        """
        Resource Location
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def code(self) -> Optional[pulumi.Input[str]]:
        """
        code of the status
        """
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "code", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        Kind of resource
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the status
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Resource Name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Resource tags
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Resource type
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class ConnectionParameterArgs:
    def __init__(__self__, *,
                 default_value: Optional[Any] = None,
                 o_auth_settings: Optional[pulumi.Input['ApiOAuthSettingsArgs']] = None,
                 type: Optional[pulumi.Input['ConnectionParameterType']] = None,
                 ui_definition: Optional[Any] = None):
        """
        connection provider parameters
        :param Any default_value: Default parameter value
        :param pulumi.Input['ApiOAuthSettingsArgs'] o_auth_settings: Settings defining OAuth flow for the back end provider
        :param pulumi.Input['ConnectionParameterType'] type: Type of the parameter
        :param Any ui_definition: UI definitions
        """
        if default_value is not None:
            pulumi.set(__self__, "default_value", default_value)
        if o_auth_settings is not None:
            pulumi.set(__self__, "o_auth_settings", o_auth_settings)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if ui_definition is not None:
            pulumi.set(__self__, "ui_definition", ui_definition)

    @property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> Optional[Any]:
        """
        Default parameter value
        """
        return pulumi.get(self, "default_value")

    @default_value.setter
    def default_value(self, value: Optional[Any]):
        pulumi.set(self, "default_value", value)

    @property
    @pulumi.getter(name="oAuthSettings")
    def o_auth_settings(self) -> Optional[pulumi.Input['ApiOAuthSettingsArgs']]:
        """
        Settings defining OAuth flow for the back end provider
        """
        return pulumi.get(self, "o_auth_settings")

    @o_auth_settings.setter
    def o_auth_settings(self, value: Optional[pulumi.Input['ApiOAuthSettingsArgs']]):
        pulumi.set(self, "o_auth_settings", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['ConnectionParameterType']]:
        """
        Type of the parameter
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['ConnectionParameterType']]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="uiDefinition")
    def ui_definition(self) -> Optional[Any]:
        """
        UI definitions
        """
        return pulumi.get(self, "ui_definition")

    @ui_definition.setter
    def ui_definition(self, value: Optional[Any]):
        pulumi.set(self, "ui_definition", value)


@pulumi.input_type
class ConnectionStatusArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[str],
                 error: Optional[pulumi.Input['ConnectionErrorArgs']] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 target: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Connection status
        :param pulumi.Input[str] location: Resource Location
        :param pulumi.Input['ConnectionErrorArgs'] error: Error details
        :param pulumi.Input[str] id: Resource Id
        :param pulumi.Input[str] kind: Kind of resource
        :param pulumi.Input[str] name: Resource Name
        :param pulumi.Input[str] status: Status
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Resource tags
        :param pulumi.Input[str] target: Target of the error
        :param pulumi.Input[str] type: Resource type
        """
        pulumi.set(__self__, "location", location)
        if error is not None:
            pulumi.set(__self__, "error", error)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[str]:
        """
        Resource Location
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def error(self) -> Optional[pulumi.Input['ConnectionErrorArgs']]:
        """
        Error details
        """
        return pulumi.get(self, "error")

    @error.setter
    def error(self, value: Optional[pulumi.Input['ConnectionErrorArgs']]):
        pulumi.set(self, "error", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        Kind of resource
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Resource Name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Status
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Resource tags
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input[str]]:
        """
        Target of the error
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Resource type
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class ConsentLinkInputParameter:
    def __init__(__self__, *,
                 object_id: Optional[str] = None,
                 parameter_name: Optional[str] = None,
                 principal_type: Optional['PrincipalType'] = None,
                 redirect_url: Optional[str] = None,
                 tenant_id: Optional[str] = None):
        """
        :param str object_id: AAD OID (user or group) if the principal type is ActiveDirectory.
                           MSA PUID if the principal type is MicrosoftAccount.
        :param str parameter_name: Name of the parameter in the connection provider's oauthSettings
        :param 'PrincipalType' principal_type: Principal type
        :param str redirect_url: Name of the parameter in the connection provider's oauthSettings
        :param str tenant_id: Tenant Id
        """
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)
        if parameter_name is not None:
            pulumi.set(__self__, "parameter_name", parameter_name)
        if principal_type is not None:
            pulumi.set(__self__, "principal_type", principal_type)
        if redirect_url is not None:
            pulumi.set(__self__, "redirect_url", redirect_url)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[str]:
        """
        AAD OID (user or group) if the principal type is ActiveDirectory.
                    MSA PUID if the principal type is MicrosoftAccount.
        """
        return pulumi.get(self, "object_id")

    @object_id.setter
    def object_id(self, value: Optional[str]):
        pulumi.set(self, "object_id", value)

    @property
    @pulumi.getter(name="parameterName")
    def parameter_name(self) -> Optional[str]:
        """
        Name of the parameter in the connection provider's oauthSettings
        """
        return pulumi.get(self, "parameter_name")

    @parameter_name.setter
    def parameter_name(self, value: Optional[str]):
        pulumi.set(self, "parameter_name", value)

    @property
    @pulumi.getter(name="principalType")
    def principal_type(self) -> Optional['PrincipalType']:
        """
        Principal type
        """
        return pulumi.get(self, "principal_type")

    @principal_type.setter
    def principal_type(self, value: Optional['PrincipalType']):
        pulumi.set(self, "principal_type", value)

    @property
    @pulumi.getter(name="redirectUrl")
    def redirect_url(self) -> Optional[str]:
        """
        Name of the parameter in the connection provider's oauthSettings
        """
        return pulumi.get(self, "redirect_url")

    @redirect_url.setter
    def redirect_url(self, value: Optional[str]):
        pulumi.set(self, "redirect_url", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[str]:
        """
        Tenant Id
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[str]):
        pulumi.set(self, "tenant_id", value)


@pulumi.input_type
class CustomLoginSettingValueArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[str],
                 id: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 option: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Custom logging setting value
        :param pulumi.Input[str] location: Resource Location
        :param pulumi.Input[str] id: Resource Id
        :param pulumi.Input[str] kind: Kind of resource
        :param pulumi.Input[str] name: Resource Name
        :param pulumi.Input[str] option: Option selected for this custom login setting value
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Resource tags
        :param pulumi.Input[str] type: Resource type
        """
        pulumi.set(__self__, "location", location)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if option is not None:
            pulumi.set(__self__, "option", option)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[str]:
        """
        Resource Location
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        Kind of resource
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Resource Name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def option(self) -> Optional[pulumi.Input[str]]:
        """
        Option selected for this custom login setting value
        """
        return pulumi.get(self, "option")

    @option.setter
    def option(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "option", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Resource tags
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Resource type
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class ExpandedParentApiEntityArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[str],
                 entity: Optional[pulumi.Input['ResponseMessageEnvelopeApiEntityArgs']] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        expanded parent object for expansion
        :param pulumi.Input[str] location: Resource Location
        :param pulumi.Input['ResponseMessageEnvelopeApiEntityArgs'] entity: Id of connection provider
        :param pulumi.Input[str] id: Resource Id
        :param pulumi.Input[str] kind: Kind of resource
        :param pulumi.Input[str] name: Resource Name
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Resource tags
        :param pulumi.Input[str] type: Resource type
        """
        pulumi.set(__self__, "location", location)
        if entity is not None:
            pulumi.set(__self__, "entity", entity)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[str]:
        """
        Resource Location
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def entity(self) -> Optional[pulumi.Input['ResponseMessageEnvelopeApiEntityArgs']]:
        """
        Id of connection provider
        """
        return pulumi.get(self, "entity")

    @entity.setter
    def entity(self, value: Optional[pulumi.Input['ResponseMessageEnvelopeApiEntityArgs']]):
        pulumi.set(self, "entity", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        Kind of resource
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Resource Name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Resource tags
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Resource type
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class GeneralApiInformationArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[str],
                 connection_display_name: Optional[pulumi.Input[str]] = None,
                 connection_portal_url: Optional[Any] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 icon_url: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 terms_of_use_url: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        General API information
        :param pulumi.Input[str] location: Resource Location
        :param pulumi.Input[str] connection_display_name: DefaultConnectionNameTemplate
        :param Any connection_portal_url: ConnectionPortalUrl
        :param pulumi.Input[str] description: Description
        :param pulumi.Input[str] display_name: Display Name
        :param pulumi.Input[str] icon_url: Icon Url
        :param pulumi.Input[str] id: Resource Id
        :param pulumi.Input[str] kind: Kind of resource
        :param pulumi.Input[str] name: Resource Name
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Resource tags
        :param pulumi.Input[str] terms_of_use_url: a public accessible url of the Terms Of Use Url of this API
        :param pulumi.Input[str] type: Resource type
        """
        pulumi.set(__self__, "location", location)
        if connection_display_name is not None:
            pulumi.set(__self__, "connection_display_name", connection_display_name)
        if connection_portal_url is not None:
            pulumi.set(__self__, "connection_portal_url", connection_portal_url)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if icon_url is not None:
            pulumi.set(__self__, "icon_url", icon_url)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if terms_of_use_url is not None:
            pulumi.set(__self__, "terms_of_use_url", terms_of_use_url)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[str]:
        """
        Resource Location
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="connectionDisplayName")
    def connection_display_name(self) -> Optional[pulumi.Input[str]]:
        """
        DefaultConnectionNameTemplate
        """
        return pulumi.get(self, "connection_display_name")

    @connection_display_name.setter
    def connection_display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_display_name", value)

    @property
    @pulumi.getter(name="connectionPortalUrl")
    def connection_portal_url(self) -> Optional[Any]:
        """
        ConnectionPortalUrl
        """
        return pulumi.get(self, "connection_portal_url")

    @connection_portal_url.setter
    def connection_portal_url(self, value: Optional[Any]):
        pulumi.set(self, "connection_portal_url", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Display Name
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="iconUrl")
    def icon_url(self) -> Optional[pulumi.Input[str]]:
        """
        Icon Url
        """
        return pulumi.get(self, "icon_url")

    @icon_url.setter
    def icon_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "icon_url", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        Kind of resource
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Resource Name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Resource tags
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="termsOfUseUrl")
    def terms_of_use_url(self) -> Optional[pulumi.Input[str]]:
        """
        a public accessible url of the Terms Of Use Url of this API
        """
        return pulumi.get(self, "terms_of_use_url")

    @terms_of_use_url.setter
    def terms_of_use_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "terms_of_use_url", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Resource type
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class HostingEnvironmentServiceDescriptionsArgs:
    def __init__(__self__, *,
                 host_id: Optional[pulumi.Input[str]] = None,
                 hosting_environment_id: Optional[pulumi.Input[str]] = None,
                 service_url: Optional[pulumi.Input[str]] = None,
                 use_internal_routing: Optional[pulumi.Input[bool]] = None):
        """
        Back end service per ASE
        :param pulumi.Input[str] host_id: Host Id
        :param pulumi.Input[str] hosting_environment_id: Hosting environment Id
        :param pulumi.Input[str] service_url: service url to use
        :param pulumi.Input[bool] use_internal_routing: When the backend url is in same ASE, for performance reason this flag can be set to true
                           If WebApp.DisableHostNames is also set it improves the security by making the back end accessible only 
                           via API calls
                           Note: calls will fail if this option is used but back end is not on the same ASE
        """
        if host_id is not None:
            pulumi.set(__self__, "host_id", host_id)
        if hosting_environment_id is not None:
            pulumi.set(__self__, "hosting_environment_id", hosting_environment_id)
        if service_url is not None:
            pulumi.set(__self__, "service_url", service_url)
        if use_internal_routing is not None:
            pulumi.set(__self__, "use_internal_routing", use_internal_routing)

    @property
    @pulumi.getter(name="hostId")
    def host_id(self) -> Optional[pulumi.Input[str]]:
        """
        Host Id
        """
        return pulumi.get(self, "host_id")

    @host_id.setter
    def host_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_id", value)

    @property
    @pulumi.getter(name="hostingEnvironmentId")
    def hosting_environment_id(self) -> Optional[pulumi.Input[str]]:
        """
        Hosting environment Id
        """
        return pulumi.get(self, "hosting_environment_id")

    @hosting_environment_id.setter
    def hosting_environment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hosting_environment_id", value)

    @property
    @pulumi.getter(name="serviceUrl")
    def service_url(self) -> Optional[pulumi.Input[str]]:
        """
        service url to use
        """
        return pulumi.get(self, "service_url")

    @service_url.setter
    def service_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_url", value)

    @property
    @pulumi.getter(name="useInternalRouting")
    def use_internal_routing(self) -> Optional[pulumi.Input[bool]]:
        """
        When the backend url is in same ASE, for performance reason this flag can be set to true
                    If WebApp.DisableHostNames is also set it improves the security by making the back end accessible only 
                    via API calls
                    Note: calls will fail if this option is used but back end is not on the same ASE
        """
        return pulumi.get(self, "use_internal_routing")

    @use_internal_routing.setter
    def use_internal_routing(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_internal_routing", value)


@pulumi.input_type
class ParameterCustomLoginSettingValuesArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[str],
                 custom_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input['CustomLoginSettingValueArgs']]]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Custom logging setting values
        :param pulumi.Input[str] location: Resource Location
        :param pulumi.Input[Mapping[str, pulumi.Input['CustomLoginSettingValueArgs']]] custom_parameters: Custom parameters.
        :param pulumi.Input[str] id: Resource Id
        :param pulumi.Input[str] kind: Kind of resource
        :param pulumi.Input[str] name: Resource Name
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Resource tags
        :param pulumi.Input[str] type: Resource type
        """
        pulumi.set(__self__, "location", location)
        if custom_parameters is not None:
            pulumi.set(__self__, "custom_parameters", custom_parameters)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[str]:
        """
        Resource Location
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="customParameters")
    def custom_parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['CustomLoginSettingValueArgs']]]]:
        """
        Custom parameters.
        """
        return pulumi.get(self, "custom_parameters")

    @custom_parameters.setter
    def custom_parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['CustomLoginSettingValueArgs']]]]):
        pulumi.set(self, "custom_parameters", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        Kind of resource
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Resource Name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Resource tags
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Resource type
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class ResponseMessageEnvelopeApiEntityArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 plan: Optional[pulumi.Input['ArmPlanArgs']] = None,
                 properties: Optional[pulumi.Input['ApiEntityArgs']] = None,
                 sku: Optional[pulumi.Input['SkuDescriptionArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Message envelope that contains the common Azure resource manager properties and the resource provider specific content
        :param pulumi.Input[str] id: Resource Id. Typically id is populated only for responses to GET requests. Caller is responsible for passing in this
                           value for GET requests only.
                           For example: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupId}/providers/Microsoft.Web/sites/{sitename}
        :param pulumi.Input[str] location: Geo region resource belongs to e.g. SouthCentralUS, SouthEastAsia
        :param pulumi.Input[str] name: Name of resource
        :param pulumi.Input['ArmPlanArgs'] plan: Azure resource manager plan
        :param pulumi.Input['ApiEntityArgs'] properties: Resource specific properties
        :param pulumi.Input['SkuDescriptionArgs'] sku: Sku description of the resource
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Tags associated with resource
        :param pulumi.Input[str] type: Type of resource e.g Microsoft.Web/sites
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if plan is not None:
            pulumi.set(__self__, "plan", plan)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource Id. Typically id is populated only for responses to GET requests. Caller is responsible for passing in this
                    value for GET requests only.
                    For example: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupId}/providers/Microsoft.Web/sites/{sitename}
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Geo region resource belongs to e.g. SouthCentralUS, SouthEastAsia
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def plan(self) -> Optional[pulumi.Input['ArmPlanArgs']]:
        """
        Azure resource manager plan
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: Optional[pulumi.Input['ArmPlanArgs']]):
        pulumi.set(self, "plan", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['ApiEntityArgs']]:
        """
        Resource specific properties
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['ApiEntityArgs']]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input['SkuDescriptionArgs']]:
        """
        Sku description of the resource
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input['SkuDescriptionArgs']]):
        pulumi.set(self, "sku", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Tags associated with resource
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of resource e.g Microsoft.Web/sites
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class SkuDescriptionArgs:
    def __init__(__self__, *,
                 capacity: Optional[pulumi.Input[int]] = None,
                 family: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[str]] = None,
                 tier: Optional[pulumi.Input[str]] = None):
        """
        Describes a sku for a scalable resource
        :param pulumi.Input[int] capacity: Current number of instances assigned to the resource
        :param pulumi.Input[str] family: Family code of the resource sku
        :param pulumi.Input[str] name: Name of the resource sku
        :param pulumi.Input[str] size: Size specifier of the resource sku
        :param pulumi.Input[str] tier: Service Tier of the resource sku
        """
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if family is not None:
            pulumi.set(__self__, "family", family)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[int]]:
        """
        Current number of instances assigned to the resource
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "capacity", value)

    @property
    @pulumi.getter
    def family(self) -> Optional[pulumi.Input[str]]:
        """
        Family code of the resource sku
        """
        return pulumi.get(self, "family")

    @family.setter
    def family(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "family", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the resource sku
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[str]]:
        """
        Size specifier of the resource sku
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter
    def tier(self) -> Optional[pulumi.Input[str]]:
        """
        Service Tier of the resource sku
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tier", value)


