# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AvailabilitySetResourceSettingsArgs',
    'DiskEncryptionSetResourceSettingsArgs',
    'IdentityArgs',
    'KeyVaultResourceSettingsArgs',
    'LBBackendAddressPoolResourceSettingsArgs',
    'LBFrontendIPConfigurationResourceSettingsArgs',
    'LoadBalancerBackendAddressPoolReferenceArgs',
    'LoadBalancerNatRuleReferenceArgs',
    'LoadBalancerResourceSettingsArgs',
    'MoveCollectionPropertiesArgs',
    'MoveResourceDependencyOverrideArgs',
    'MoveResourcePropertiesArgs',
    'NetworkInterfaceResourceSettingsArgs',
    'NetworkSecurityGroupResourceSettingsArgs',
    'NicIpConfigurationResourceSettingsArgs',
    'NsgReferenceArgs',
    'NsgSecurityRuleArgs',
    'PublicIPAddressResourceSettingsArgs',
    'PublicIpReferenceArgs',
    'ResourceGroupResourceSettingsArgs',
    'SqlDatabaseResourceSettingsArgs',
    'SqlElasticPoolResourceSettingsArgs',
    'SqlServerResourceSettingsArgs',
    'SubnetReferenceArgs',
    'SubnetResourceSettingsArgs',
    'VirtualMachineResourceSettingsArgs',
    'VirtualNetworkResourceSettingsArgs',
]

@pulumi.input_type
class AvailabilitySetResourceSettingsArgs:
    def __init__(__self__, *,
                 resource_type: pulumi.Input[str],
                 target_resource_name: pulumi.Input[str],
                 fault_domain: Optional[pulumi.Input[int]] = None,
                 update_domain: Optional[pulumi.Input[int]] = None):
        """
        Gets or sets the availability set resource settings.
        :param pulumi.Input[str] resource_type: The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
               Expected value is 'Microsoft.Compute/availabilitySets'.
        :param pulumi.Input[str] target_resource_name: Gets or sets the target Resource name.
        :param pulumi.Input[int] fault_domain: Gets or sets the target fault domain.
        :param pulumi.Input[int] update_domain: Gets or sets the target update domain.
        """
        pulumi.set(__self__, "resource_type", 'Microsoft.Compute/availabilitySets')
        pulumi.set(__self__, "target_resource_name", target_resource_name)
        if fault_domain is not None:
            pulumi.set(__self__, "fault_domain", fault_domain)
        if update_domain is not None:
            pulumi.set(__self__, "update_domain", update_domain)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Input[str]:
        """
        The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
        Expected value is 'Microsoft.Compute/availabilitySets'.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter(name="targetResourceName")
    def target_resource_name(self) -> pulumi.Input[str]:
        """
        Gets or sets the target Resource name.
        """
        return pulumi.get(self, "target_resource_name")

    @target_resource_name.setter
    def target_resource_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_resource_name", value)

    @property
    @pulumi.getter(name="faultDomain")
    def fault_domain(self) -> Optional[pulumi.Input[int]]:
        """
        Gets or sets the target fault domain.
        """
        return pulumi.get(self, "fault_domain")

    @fault_domain.setter
    def fault_domain(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "fault_domain", value)

    @property
    @pulumi.getter(name="updateDomain")
    def update_domain(self) -> Optional[pulumi.Input[int]]:
        """
        Gets or sets the target update domain.
        """
        return pulumi.get(self, "update_domain")

    @update_domain.setter
    def update_domain(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "update_domain", value)


@pulumi.input_type
class DiskEncryptionSetResourceSettingsArgs:
    def __init__(__self__, *,
                 resource_type: pulumi.Input[str],
                 target_resource_name: pulumi.Input[str]):
        """
        Defines the disk encryption set resource settings.
        :param pulumi.Input[str] resource_type: The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
               Expected value is 'Microsoft.Compute/diskEncryptionSets'.
        :param pulumi.Input[str] target_resource_name: Gets or sets the target Resource name.
        """
        pulumi.set(__self__, "resource_type", 'Microsoft.Compute/diskEncryptionSets')
        pulumi.set(__self__, "target_resource_name", target_resource_name)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Input[str]:
        """
        The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
        Expected value is 'Microsoft.Compute/diskEncryptionSets'.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter(name="targetResourceName")
    def target_resource_name(self) -> pulumi.Input[str]:
        """
        Gets or sets the target Resource name.
        """
        return pulumi.get(self, "target_resource_name")

    @target_resource_name.setter
    def target_resource_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_resource_name", value)


@pulumi.input_type
class IdentityArgs:
    def __init__(__self__, *,
                 principal_id: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[Union[str, 'ResourceIdentityType']]] = None):
        """
        Defines the MSI properties of the Move Collection.
        :param pulumi.Input[str] principal_id: Gets or sets the principal id.
        :param pulumi.Input[str] tenant_id: Gets or sets the tenant id.
        :param pulumi.Input[Union[str, 'ResourceIdentityType']] type: The type of identity used for the resource mover service.
        """
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the principal id.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "principal_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the tenant id.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Union[str, 'ResourceIdentityType']]]:
        """
        The type of identity used for the resource mover service.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Union[str, 'ResourceIdentityType']]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class KeyVaultResourceSettingsArgs:
    def __init__(__self__, *,
                 resource_type: pulumi.Input[str],
                 target_resource_name: pulumi.Input[str]):
        """
        Defines the key vault resource settings.
        :param pulumi.Input[str] resource_type: The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
               Expected value is 'Microsoft.KeyVault/vaults'.
        :param pulumi.Input[str] target_resource_name: Gets or sets the target Resource name.
        """
        pulumi.set(__self__, "resource_type", 'Microsoft.KeyVault/vaults')
        pulumi.set(__self__, "target_resource_name", target_resource_name)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Input[str]:
        """
        The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
        Expected value is 'Microsoft.KeyVault/vaults'.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter(name="targetResourceName")
    def target_resource_name(self) -> pulumi.Input[str]:
        """
        Gets or sets the target Resource name.
        """
        return pulumi.get(self, "target_resource_name")

    @target_resource_name.setter
    def target_resource_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_resource_name", value)


@pulumi.input_type
class LBBackendAddressPoolResourceSettingsArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Defines load balancer backend address pool properties.
        :param pulumi.Input[str] name: Gets or sets the backend address pool name.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the backend address pool name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class LBFrontendIPConfigurationResourceSettingsArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 private_ip_address: Optional[pulumi.Input[str]] = None,
                 private_ip_allocation_method: Optional[pulumi.Input[str]] = None,
                 subnet: Optional[pulumi.Input['SubnetReferenceArgs']] = None,
                 zones: Optional[pulumi.Input[str]] = None):
        """
        Defines load balancer frontend IP configuration properties.
        :param pulumi.Input[str] name: Gets or sets the frontend IP configuration name.
        :param pulumi.Input[str] private_ip_address: Gets or sets the IP address of the Load Balancer.This is only specified if a specific
               private IP address shall be allocated from the subnet specified in subnetRef.
        :param pulumi.Input[str] private_ip_allocation_method: Gets or sets PrivateIP allocation method (Static/Dynamic).
        :param pulumi.Input['SubnetReferenceArgs'] subnet: Defines reference to subnet.
        :param pulumi.Input[str] zones: Gets or sets the csv list of zones.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if private_ip_allocation_method is not None:
            pulumi.set(__self__, "private_ip_allocation_method", private_ip_allocation_method)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the frontend IP configuration name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the IP address of the Load Balancer.This is only specified if a specific
        private IP address shall be allocated from the subnet specified in subnetRef.
        """
        return pulumi.get(self, "private_ip_address")

    @private_ip_address.setter
    def private_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_ip_address", value)

    @property
    @pulumi.getter(name="privateIpAllocationMethod")
    def private_ip_allocation_method(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets PrivateIP allocation method (Static/Dynamic).
        """
        return pulumi.get(self, "private_ip_allocation_method")

    @private_ip_allocation_method.setter
    def private_ip_allocation_method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_ip_allocation_method", value)

    @property
    @pulumi.getter
    def subnet(self) -> Optional[pulumi.Input['SubnetReferenceArgs']]:
        """
        Defines reference to subnet.
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: Optional[pulumi.Input['SubnetReferenceArgs']]):
        pulumi.set(self, "subnet", value)

    @property
    @pulumi.getter
    def zones(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the csv list of zones.
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zones", value)


@pulumi.input_type
class LoadBalancerBackendAddressPoolReferenceArgs:
    def __init__(__self__, *,
                 source_arm_resource_id: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None):
        """
        Defines reference to load balancer backend address pools.
        :param pulumi.Input[str] source_arm_resource_id: Gets the ARM resource ID of the tracked resource being referenced.
        :param pulumi.Input[str] name: Gets the name of the proxy resource on the target side.
        """
        pulumi.set(__self__, "source_arm_resource_id", source_arm_resource_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="sourceArmResourceId")
    def source_arm_resource_id(self) -> pulumi.Input[str]:
        """
        Gets the ARM resource ID of the tracked resource being referenced.
        """
        return pulumi.get(self, "source_arm_resource_id")

    @source_arm_resource_id.setter
    def source_arm_resource_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_arm_resource_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Gets the name of the proxy resource on the target side.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class LoadBalancerNatRuleReferenceArgs:
    def __init__(__self__, *,
                 source_arm_resource_id: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None):
        """
        Defines reference to load balancer NAT rules.
        :param pulumi.Input[str] source_arm_resource_id: Gets the ARM resource ID of the tracked resource being referenced.
        :param pulumi.Input[str] name: Gets the name of the proxy resource on the target side.
        """
        pulumi.set(__self__, "source_arm_resource_id", source_arm_resource_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="sourceArmResourceId")
    def source_arm_resource_id(self) -> pulumi.Input[str]:
        """
        Gets the ARM resource ID of the tracked resource being referenced.
        """
        return pulumi.get(self, "source_arm_resource_id")

    @source_arm_resource_id.setter
    def source_arm_resource_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_arm_resource_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Gets the name of the proxy resource on the target side.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class LoadBalancerResourceSettingsArgs:
    def __init__(__self__, *,
                 resource_type: pulumi.Input[str],
                 target_resource_name: pulumi.Input[str],
                 backend_address_pools: Optional[pulumi.Input[Sequence[pulumi.Input['LBBackendAddressPoolResourceSettingsArgs']]]] = None,
                 frontend_ip_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['LBFrontendIPConfigurationResourceSettingsArgs']]]] = None,
                 sku: Optional[pulumi.Input[str]] = None,
                 zones: Optional[pulumi.Input[str]] = None):
        """
        Defines the load balancer resource settings.
        :param pulumi.Input[str] resource_type: The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
               Expected value is 'Microsoft.Network/loadBalancers'.
        :param pulumi.Input[str] target_resource_name: Gets or sets the target Resource name.
        :param pulumi.Input[Sequence[pulumi.Input['LBBackendAddressPoolResourceSettingsArgs']]] backend_address_pools: Gets or sets the backend address pools of the load balancer.
        :param pulumi.Input[Sequence[pulumi.Input['LBFrontendIPConfigurationResourceSettingsArgs']]] frontend_ip_configurations: Gets or sets the frontend IP configurations of the load balancer.
        :param pulumi.Input[str] sku: Gets or sets load balancer sku (Basic/Standard).
        :param pulumi.Input[str] zones: Gets or sets the csv list of zones common for all frontend IP configurations. Note this is given
                precedence only if frontend IP configurations settings are not present.
        """
        pulumi.set(__self__, "resource_type", 'Microsoft.Network/loadBalancers')
        pulumi.set(__self__, "target_resource_name", target_resource_name)
        if backend_address_pools is not None:
            pulumi.set(__self__, "backend_address_pools", backend_address_pools)
        if frontend_ip_configurations is not None:
            pulumi.set(__self__, "frontend_ip_configurations", frontend_ip_configurations)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Input[str]:
        """
        The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
        Expected value is 'Microsoft.Network/loadBalancers'.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter(name="targetResourceName")
    def target_resource_name(self) -> pulumi.Input[str]:
        """
        Gets or sets the target Resource name.
        """
        return pulumi.get(self, "target_resource_name")

    @target_resource_name.setter
    def target_resource_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_resource_name", value)

    @property
    @pulumi.getter(name="backendAddressPools")
    def backend_address_pools(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LBBackendAddressPoolResourceSettingsArgs']]]]:
        """
        Gets or sets the backend address pools of the load balancer.
        """
        return pulumi.get(self, "backend_address_pools")

    @backend_address_pools.setter
    def backend_address_pools(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LBBackendAddressPoolResourceSettingsArgs']]]]):
        pulumi.set(self, "backend_address_pools", value)

    @property
    @pulumi.getter(name="frontendIPConfigurations")
    def frontend_ip_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LBFrontendIPConfigurationResourceSettingsArgs']]]]:
        """
        Gets or sets the frontend IP configurations of the load balancer.
        """
        return pulumi.get(self, "frontend_ip_configurations")

    @frontend_ip_configurations.setter
    def frontend_ip_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LBFrontendIPConfigurationResourceSettingsArgs']]]]):
        pulumi.set(self, "frontend_ip_configurations", value)

    @property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets load balancer sku (Basic/Standard).
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sku", value)

    @property
    @pulumi.getter
    def zones(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the csv list of zones common for all frontend IP configurations. Note this is given
         precedence only if frontend IP configurations settings are not present.
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zones", value)


@pulumi.input_type
class MoveCollectionPropertiesArgs:
    def __init__(__self__, *,
                 source_region: pulumi.Input[str],
                 target_region: pulumi.Input[str]):
        """
        Defines the move collection properties.
        :param pulumi.Input[str] source_region: Gets or sets the source region.
        :param pulumi.Input[str] target_region: Gets or sets the target region.
        """
        pulumi.set(__self__, "source_region", source_region)
        pulumi.set(__self__, "target_region", target_region)

    @property
    @pulumi.getter(name="sourceRegion")
    def source_region(self) -> pulumi.Input[str]:
        """
        Gets or sets the source region.
        """
        return pulumi.get(self, "source_region")

    @source_region.setter
    def source_region(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_region", value)

    @property
    @pulumi.getter(name="targetRegion")
    def target_region(self) -> pulumi.Input[str]:
        """
        Gets or sets the target region.
        """
        return pulumi.get(self, "target_region")

    @target_region.setter
    def target_region(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_region", value)


@pulumi.input_type
class MoveResourceDependencyOverrideArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None,
                 target_id: Optional[pulumi.Input[str]] = None):
        """
        Defines the dependency override of the move resource.
        :param pulumi.Input[str] id: Gets or sets the ARM ID of the dependent resource.
        :param pulumi.Input[str] target_id: Gets or sets the resource ARM id of either the MoveResource or the resource ARM ID of
               the dependent resource.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if target_id is not None:
            pulumi.set(__self__, "target_id", target_id)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the ARM ID of the dependent resource.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the resource ARM id of either the MoveResource or the resource ARM ID of
        the dependent resource.
        """
        return pulumi.get(self, "target_id")

    @target_id.setter
    def target_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_id", value)


@pulumi.input_type
class MoveResourcePropertiesArgs:
    def __init__(__self__, *,
                 source_id: pulumi.Input[str],
                 depends_on_overrides: Optional[pulumi.Input[Sequence[pulumi.Input['MoveResourceDependencyOverrideArgs']]]] = None,
                 existing_target_id: Optional[pulumi.Input[str]] = None,
                 resource_settings: Optional[pulumi.Input[Union['AvailabilitySetResourceSettingsArgs', 'DiskEncryptionSetResourceSettingsArgs', 'KeyVaultResourceSettingsArgs', 'LoadBalancerResourceSettingsArgs', 'NetworkInterfaceResourceSettingsArgs', 'NetworkSecurityGroupResourceSettingsArgs', 'PublicIPAddressResourceSettingsArgs', 'ResourceGroupResourceSettingsArgs', 'SqlDatabaseResourceSettingsArgs', 'SqlElasticPoolResourceSettingsArgs', 'SqlServerResourceSettingsArgs', 'VirtualMachineResourceSettingsArgs', 'VirtualNetworkResourceSettingsArgs']]] = None):
        """
        Defines the move resource properties.
        :param pulumi.Input[str] source_id: Gets or sets the Source ARM Id of the resource.
        :param pulumi.Input[Sequence[pulumi.Input['MoveResourceDependencyOverrideArgs']]] depends_on_overrides: Gets or sets the move resource dependencies overrides.
        :param pulumi.Input[str] existing_target_id: Gets or sets the existing target ARM Id of the resource.
        :param pulumi.Input[Union['AvailabilitySetResourceSettingsArgs', 'DiskEncryptionSetResourceSettingsArgs', 'KeyVaultResourceSettingsArgs', 'LoadBalancerResourceSettingsArgs', 'NetworkInterfaceResourceSettingsArgs', 'NetworkSecurityGroupResourceSettingsArgs', 'PublicIPAddressResourceSettingsArgs', 'ResourceGroupResourceSettingsArgs', 'SqlDatabaseResourceSettingsArgs', 'SqlElasticPoolResourceSettingsArgs', 'SqlServerResourceSettingsArgs', 'VirtualMachineResourceSettingsArgs', 'VirtualNetworkResourceSettingsArgs']] resource_settings: Gets or sets the resource settings.
        """
        pulumi.set(__self__, "source_id", source_id)
        if depends_on_overrides is not None:
            pulumi.set(__self__, "depends_on_overrides", depends_on_overrides)
        if existing_target_id is not None:
            pulumi.set(__self__, "existing_target_id", existing_target_id)
        if resource_settings is not None:
            pulumi.set(__self__, "resource_settings", resource_settings)

    @property
    @pulumi.getter(name="sourceId")
    def source_id(self) -> pulumi.Input[str]:
        """
        Gets or sets the Source ARM Id of the resource.
        """
        return pulumi.get(self, "source_id")

    @source_id.setter
    def source_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_id", value)

    @property
    @pulumi.getter(name="dependsOnOverrides")
    def depends_on_overrides(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MoveResourceDependencyOverrideArgs']]]]:
        """
        Gets or sets the move resource dependencies overrides.
        """
        return pulumi.get(self, "depends_on_overrides")

    @depends_on_overrides.setter
    def depends_on_overrides(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MoveResourceDependencyOverrideArgs']]]]):
        pulumi.set(self, "depends_on_overrides", value)

    @property
    @pulumi.getter(name="existingTargetId")
    def existing_target_id(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the existing target ARM Id of the resource.
        """
        return pulumi.get(self, "existing_target_id")

    @existing_target_id.setter
    def existing_target_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "existing_target_id", value)

    @property
    @pulumi.getter(name="resourceSettings")
    def resource_settings(self) -> Optional[pulumi.Input[Union['AvailabilitySetResourceSettingsArgs', 'DiskEncryptionSetResourceSettingsArgs', 'KeyVaultResourceSettingsArgs', 'LoadBalancerResourceSettingsArgs', 'NetworkInterfaceResourceSettingsArgs', 'NetworkSecurityGroupResourceSettingsArgs', 'PublicIPAddressResourceSettingsArgs', 'ResourceGroupResourceSettingsArgs', 'SqlDatabaseResourceSettingsArgs', 'SqlElasticPoolResourceSettingsArgs', 'SqlServerResourceSettingsArgs', 'VirtualMachineResourceSettingsArgs', 'VirtualNetworkResourceSettingsArgs']]]:
        """
        Gets or sets the resource settings.
        """
        return pulumi.get(self, "resource_settings")

    @resource_settings.setter
    def resource_settings(self, value: Optional[pulumi.Input[Union['AvailabilitySetResourceSettingsArgs', 'DiskEncryptionSetResourceSettingsArgs', 'KeyVaultResourceSettingsArgs', 'LoadBalancerResourceSettingsArgs', 'NetworkInterfaceResourceSettingsArgs', 'NetworkSecurityGroupResourceSettingsArgs', 'PublicIPAddressResourceSettingsArgs', 'ResourceGroupResourceSettingsArgs', 'SqlDatabaseResourceSettingsArgs', 'SqlElasticPoolResourceSettingsArgs', 'SqlServerResourceSettingsArgs', 'VirtualMachineResourceSettingsArgs', 'VirtualNetworkResourceSettingsArgs']]]):
        pulumi.set(self, "resource_settings", value)


@pulumi.input_type
class NetworkInterfaceResourceSettingsArgs:
    def __init__(__self__, *,
                 resource_type: pulumi.Input[str],
                 target_resource_name: pulumi.Input[str],
                 enable_accelerated_networking: Optional[pulumi.Input[bool]] = None,
                 ip_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['NicIpConfigurationResourceSettingsArgs']]]] = None):
        """
        Defines the network interface resource settings.
        :param pulumi.Input[str] resource_type: The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
               Expected value is 'Microsoft.Network/networkInterfaces'.
        :param pulumi.Input[str] target_resource_name: Gets or sets the target Resource name.
        :param pulumi.Input[bool] enable_accelerated_networking: Gets or sets a value indicating whether accelerated networking is enabled.
        :param pulumi.Input[Sequence[pulumi.Input['NicIpConfigurationResourceSettingsArgs']]] ip_configurations: Gets or sets the IP configurations of the NIC.
        """
        pulumi.set(__self__, "resource_type", 'Microsoft.Network/networkInterfaces')
        pulumi.set(__self__, "target_resource_name", target_resource_name)
        if enable_accelerated_networking is not None:
            pulumi.set(__self__, "enable_accelerated_networking", enable_accelerated_networking)
        if ip_configurations is not None:
            pulumi.set(__self__, "ip_configurations", ip_configurations)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Input[str]:
        """
        The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
        Expected value is 'Microsoft.Network/networkInterfaces'.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter(name="targetResourceName")
    def target_resource_name(self) -> pulumi.Input[str]:
        """
        Gets or sets the target Resource name.
        """
        return pulumi.get(self, "target_resource_name")

    @target_resource_name.setter
    def target_resource_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_resource_name", value)

    @property
    @pulumi.getter(name="enableAcceleratedNetworking")
    def enable_accelerated_networking(self) -> Optional[pulumi.Input[bool]]:
        """
        Gets or sets a value indicating whether accelerated networking is enabled.
        """
        return pulumi.get(self, "enable_accelerated_networking")

    @enable_accelerated_networking.setter
    def enable_accelerated_networking(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_accelerated_networking", value)

    @property
    @pulumi.getter(name="ipConfigurations")
    def ip_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NicIpConfigurationResourceSettingsArgs']]]]:
        """
        Gets or sets the IP configurations of the NIC.
        """
        return pulumi.get(self, "ip_configurations")

    @ip_configurations.setter
    def ip_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NicIpConfigurationResourceSettingsArgs']]]]):
        pulumi.set(self, "ip_configurations", value)


@pulumi.input_type
class NetworkSecurityGroupResourceSettingsArgs:
    def __init__(__self__, *,
                 resource_type: pulumi.Input[str],
                 target_resource_name: pulumi.Input[str],
                 security_rules: Optional[pulumi.Input[Sequence[pulumi.Input['NsgSecurityRuleArgs']]]] = None):
        """
        Defines the NSG resource settings.
        :param pulumi.Input[str] resource_type: The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
               Expected value is 'Microsoft.Network/networkSecurityGroups'.
        :param pulumi.Input[str] target_resource_name: Gets or sets the target Resource name.
        :param pulumi.Input[Sequence[pulumi.Input['NsgSecurityRuleArgs']]] security_rules: Gets or sets Security rules of network security group.
        """
        pulumi.set(__self__, "resource_type", 'Microsoft.Network/networkSecurityGroups')
        pulumi.set(__self__, "target_resource_name", target_resource_name)
        if security_rules is not None:
            pulumi.set(__self__, "security_rules", security_rules)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Input[str]:
        """
        The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
        Expected value is 'Microsoft.Network/networkSecurityGroups'.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter(name="targetResourceName")
    def target_resource_name(self) -> pulumi.Input[str]:
        """
        Gets or sets the target Resource name.
        """
        return pulumi.get(self, "target_resource_name")

    @target_resource_name.setter
    def target_resource_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_resource_name", value)

    @property
    @pulumi.getter(name="securityRules")
    def security_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NsgSecurityRuleArgs']]]]:
        """
        Gets or sets Security rules of network security group.
        """
        return pulumi.get(self, "security_rules")

    @security_rules.setter
    def security_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NsgSecurityRuleArgs']]]]):
        pulumi.set(self, "security_rules", value)


@pulumi.input_type
class NicIpConfigurationResourceSettingsArgs:
    def __init__(__self__, *,
                 load_balancer_backend_address_pools: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerBackendAddressPoolReferenceArgs']]]] = None,
                 load_balancer_nat_rules: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerNatRuleReferenceArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 primary: Optional[pulumi.Input[bool]] = None,
                 private_ip_address: Optional[pulumi.Input[str]] = None,
                 private_ip_allocation_method: Optional[pulumi.Input[str]] = None,
                 public_ip: Optional[pulumi.Input['PublicIpReferenceArgs']] = None,
                 subnet: Optional[pulumi.Input['SubnetReferenceArgs']] = None):
        """
        Defines NIC IP configuration properties.
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerBackendAddressPoolReferenceArgs']]] load_balancer_backend_address_pools: Gets or sets the references of the load balancer backend address pools.
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerNatRuleReferenceArgs']]] load_balancer_nat_rules: Gets or sets the references of the load balancer NAT rules.
        :param pulumi.Input[str] name: Gets or sets the IP configuration name.
        :param pulumi.Input[bool] primary: Gets or sets a value indicating whether this IP configuration is the primary.
        :param pulumi.Input[str] private_ip_address: Gets or sets the private IP address of the network interface IP Configuration.
        :param pulumi.Input[str] private_ip_allocation_method: Gets or sets the private IP address allocation method.
        :param pulumi.Input['PublicIpReferenceArgs'] public_ip: Defines reference to a public IP.
        :param pulumi.Input['SubnetReferenceArgs'] subnet: Defines reference to subnet.
        """
        if load_balancer_backend_address_pools is not None:
            pulumi.set(__self__, "load_balancer_backend_address_pools", load_balancer_backend_address_pools)
        if load_balancer_nat_rules is not None:
            pulumi.set(__self__, "load_balancer_nat_rules", load_balancer_nat_rules)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if primary is not None:
            pulumi.set(__self__, "primary", primary)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if private_ip_allocation_method is not None:
            pulumi.set(__self__, "private_ip_allocation_method", private_ip_allocation_method)
        if public_ip is not None:
            pulumi.set(__self__, "public_ip", public_ip)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @property
    @pulumi.getter(name="loadBalancerBackendAddressPools")
    def load_balancer_backend_address_pools(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerBackendAddressPoolReferenceArgs']]]]:
        """
        Gets or sets the references of the load balancer backend address pools.
        """
        return pulumi.get(self, "load_balancer_backend_address_pools")

    @load_balancer_backend_address_pools.setter
    def load_balancer_backend_address_pools(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerBackendAddressPoolReferenceArgs']]]]):
        pulumi.set(self, "load_balancer_backend_address_pools", value)

    @property
    @pulumi.getter(name="loadBalancerNatRules")
    def load_balancer_nat_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerNatRuleReferenceArgs']]]]:
        """
        Gets or sets the references of the load balancer NAT rules.
        """
        return pulumi.get(self, "load_balancer_nat_rules")

    @load_balancer_nat_rules.setter
    def load_balancer_nat_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerNatRuleReferenceArgs']]]]):
        pulumi.set(self, "load_balancer_nat_rules", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the IP configuration name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def primary(self) -> Optional[pulumi.Input[bool]]:
        """
        Gets or sets a value indicating whether this IP configuration is the primary.
        """
        return pulumi.get(self, "primary")

    @primary.setter
    def primary(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "primary", value)

    @property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the private IP address of the network interface IP Configuration.
        """
        return pulumi.get(self, "private_ip_address")

    @private_ip_address.setter
    def private_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_ip_address", value)

    @property
    @pulumi.getter(name="privateIpAllocationMethod")
    def private_ip_allocation_method(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the private IP address allocation method.
        """
        return pulumi.get(self, "private_ip_allocation_method")

    @private_ip_allocation_method.setter
    def private_ip_allocation_method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_ip_allocation_method", value)

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> Optional[pulumi.Input['PublicIpReferenceArgs']]:
        """
        Defines reference to a public IP.
        """
        return pulumi.get(self, "public_ip")

    @public_ip.setter
    def public_ip(self, value: Optional[pulumi.Input['PublicIpReferenceArgs']]):
        pulumi.set(self, "public_ip", value)

    @property
    @pulumi.getter
    def subnet(self) -> Optional[pulumi.Input['SubnetReferenceArgs']]:
        """
        Defines reference to subnet.
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: Optional[pulumi.Input['SubnetReferenceArgs']]):
        pulumi.set(self, "subnet", value)


@pulumi.input_type
class NsgReferenceArgs:
    def __init__(__self__, *,
                 source_arm_resource_id: pulumi.Input[str]):
        """
        Defines reference to NSG.
        :param pulumi.Input[str] source_arm_resource_id: Gets the ARM resource ID of the tracked resource being referenced.
        """
        pulumi.set(__self__, "source_arm_resource_id", source_arm_resource_id)

    @property
    @pulumi.getter(name="sourceArmResourceId")
    def source_arm_resource_id(self) -> pulumi.Input[str]:
        """
        Gets the ARM resource ID of the tracked resource being referenced.
        """
        return pulumi.get(self, "source_arm_resource_id")

    @source_arm_resource_id.setter
    def source_arm_resource_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_arm_resource_id", value)


@pulumi.input_type
class NsgSecurityRuleArgs:
    def __init__(__self__, *,
                 access: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 destination_address_prefix: Optional[pulumi.Input[str]] = None,
                 destination_port_range: Optional[pulumi.Input[str]] = None,
                 direction: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 source_address_prefix: Optional[pulumi.Input[str]] = None,
                 source_port_range: Optional[pulumi.Input[str]] = None):
        """
        Security Rule data model for Network Security Groups.
        :param pulumi.Input[str] access: Gets or sets whether network traffic is allowed or denied.
               Possible values are “Allow” and “Deny”.
        :param pulumi.Input[str] description: Gets or sets a description for this rule. Restricted to 140 chars.
        :param pulumi.Input[str] destination_address_prefix: Gets or sets destination address prefix. CIDR or source IP range.
                A “*” can also be used to match all source IPs. Default tags such
               as ‘VirtualNetwork’, ‘AzureLoadBalancer’ and ‘Internet’ can also be used.
        :param pulumi.Input[str] destination_port_range: Gets or sets Destination Port or Range. Integer or range between
               0 and 65535. A “*” can also be used to match all ports.
        :param pulumi.Input[str] direction: Gets or sets the direction of the rule.InBound or Outbound. The
               direction specifies if rule will be evaluated on incoming or outgoing traffic.
        :param pulumi.Input[str] name: Gets or sets the Security rule name.
        :param pulumi.Input[int] priority: Gets or sets the priority of the rule. The value can be between
               100 and 4096. The priority number must be unique for each rule in the collection.
               The lower the priority number, the higher the priority of the rule.
        :param pulumi.Input[str] protocol: Gets or sets Network protocol this rule applies to. Can be Tcp, Udp or All(*).
        :param pulumi.Input[str] source_address_prefix: Gets or sets source address prefix. CIDR or source IP range. A
               “*” can also be used to match all source IPs.  Default tags such as ‘VirtualNetwork’,
               ‘AzureLoadBalancer’ and ‘Internet’ can also be used. If this is an ingress
               rule, specifies where network traffic originates from.
        :param pulumi.Input[str] source_port_range: Gets or sets Source Port or Range. Integer or range between 0 and
               65535. A “*” can also be used to match all ports.
        """
        if access is not None:
            pulumi.set(__self__, "access", access)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_address_prefix is not None:
            pulumi.set(__self__, "destination_address_prefix", destination_address_prefix)
        if destination_port_range is not None:
            pulumi.set(__self__, "destination_port_range", destination_port_range)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if source_address_prefix is not None:
            pulumi.set(__self__, "source_address_prefix", source_address_prefix)
        if source_port_range is not None:
            pulumi.set(__self__, "source_port_range", source_port_range)

    @property
    @pulumi.getter
    def access(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets whether network traffic is allowed or denied.
        Possible values are “Allow” and “Deny”.
        """
        return pulumi.get(self, "access")

    @access.setter
    def access(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets a description for this rule. Restricted to 140 chars.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="destinationAddressPrefix")
    def destination_address_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets destination address prefix. CIDR or source IP range.
         A “*” can also be used to match all source IPs. Default tags such
        as ‘VirtualNetwork’, ‘AzureLoadBalancer’ and ‘Internet’ can also be used.
        """
        return pulumi.get(self, "destination_address_prefix")

    @destination_address_prefix.setter
    def destination_address_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_address_prefix", value)

    @property
    @pulumi.getter(name="destinationPortRange")
    def destination_port_range(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets Destination Port or Range. Integer or range between
        0 and 65535. A “*” can also be used to match all ports.
        """
        return pulumi.get(self, "destination_port_range")

    @destination_port_range.setter
    def destination_port_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_port_range", value)

    @property
    @pulumi.getter
    def direction(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the direction of the rule.InBound or Outbound. The
        direction specifies if rule will be evaluated on incoming or outgoing traffic.
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "direction", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the Security rule name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        Gets or sets the priority of the rule. The value can be between
        100 and 4096. The priority number must be unique for each rule in the collection.
        The lower the priority number, the higher the priority of the rule.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets Network protocol this rule applies to. Can be Tcp, Udp or All(*).
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="sourceAddressPrefix")
    def source_address_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets source address prefix. CIDR or source IP range. A
        “*” can also be used to match all source IPs.  Default tags such as ‘VirtualNetwork’,
        ‘AzureLoadBalancer’ and ‘Internet’ can also be used. If this is an ingress
        rule, specifies where network traffic originates from.
        """
        return pulumi.get(self, "source_address_prefix")

    @source_address_prefix.setter
    def source_address_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_address_prefix", value)

    @property
    @pulumi.getter(name="sourcePortRange")
    def source_port_range(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets Source Port or Range. Integer or range between 0 and
        65535. A “*” can also be used to match all ports.
        """
        return pulumi.get(self, "source_port_range")

    @source_port_range.setter
    def source_port_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_port_range", value)


@pulumi.input_type
class PublicIPAddressResourceSettingsArgs:
    def __init__(__self__, *,
                 resource_type: pulumi.Input[str],
                 target_resource_name: pulumi.Input[str],
                 domain_name_label: Optional[pulumi.Input[str]] = None,
                 fqdn: Optional[pulumi.Input[str]] = None,
                 public_ip_allocation_method: Optional[pulumi.Input[str]] = None,
                 sku: Optional[pulumi.Input[str]] = None,
                 zones: Optional[pulumi.Input[str]] = None):
        """
        Defines the public IP address resource settings.
        :param pulumi.Input[str] resource_type: The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
               Expected value is 'Microsoft.Network/publicIPAddresses'.
        :param pulumi.Input[str] target_resource_name: Gets or sets the target Resource name.
        :param pulumi.Input[str] domain_name_label: Gets or sets the domain name label.
        :param pulumi.Input[str] fqdn: Gets or sets the fully qualified domain name.
        :param pulumi.Input[str] public_ip_allocation_method: Gets or sets public IP allocation method.
        :param pulumi.Input[str] sku: Gets or sets public IP sku.
        :param pulumi.Input[str] zones: Gets or sets public IP zones.
        """
        pulumi.set(__self__, "resource_type", 'Microsoft.Network/publicIPAddresses')
        pulumi.set(__self__, "target_resource_name", target_resource_name)
        if domain_name_label is not None:
            pulumi.set(__self__, "domain_name_label", domain_name_label)
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if public_ip_allocation_method is not None:
            pulumi.set(__self__, "public_ip_allocation_method", public_ip_allocation_method)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Input[str]:
        """
        The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
        Expected value is 'Microsoft.Network/publicIPAddresses'.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter(name="targetResourceName")
    def target_resource_name(self) -> pulumi.Input[str]:
        """
        Gets or sets the target Resource name.
        """
        return pulumi.get(self, "target_resource_name")

    @target_resource_name.setter
    def target_resource_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_resource_name", value)

    @property
    @pulumi.getter(name="domainNameLabel")
    def domain_name_label(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the domain name label.
        """
        return pulumi.get(self, "domain_name_label")

    @domain_name_label.setter
    def domain_name_label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_name_label", value)

    @property
    @pulumi.getter
    def fqdn(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the fully qualified domain name.
        """
        return pulumi.get(self, "fqdn")

    @fqdn.setter
    def fqdn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fqdn", value)

    @property
    @pulumi.getter(name="publicIpAllocationMethod")
    def public_ip_allocation_method(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets public IP allocation method.
        """
        return pulumi.get(self, "public_ip_allocation_method")

    @public_ip_allocation_method.setter
    def public_ip_allocation_method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_ip_allocation_method", value)

    @property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets public IP sku.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sku", value)

    @property
    @pulumi.getter
    def zones(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets public IP zones.
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zones", value)


@pulumi.input_type
class PublicIpReferenceArgs:
    def __init__(__self__, *,
                 source_arm_resource_id: pulumi.Input[str]):
        """
        Defines reference to a public IP.
        :param pulumi.Input[str] source_arm_resource_id: Gets the ARM resource ID of the tracked resource being referenced.
        """
        pulumi.set(__self__, "source_arm_resource_id", source_arm_resource_id)

    @property
    @pulumi.getter(name="sourceArmResourceId")
    def source_arm_resource_id(self) -> pulumi.Input[str]:
        """
        Gets the ARM resource ID of the tracked resource being referenced.
        """
        return pulumi.get(self, "source_arm_resource_id")

    @source_arm_resource_id.setter
    def source_arm_resource_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_arm_resource_id", value)


@pulumi.input_type
class ResourceGroupResourceSettingsArgs:
    def __init__(__self__, *,
                 resource_type: pulumi.Input[str],
                 target_resource_name: pulumi.Input[str]):
        """
        Defines the resource group resource settings.
        :param pulumi.Input[str] resource_type: The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
               Expected value is 'resourceGroups'.
        :param pulumi.Input[str] target_resource_name: Gets or sets the target Resource name.
        """
        pulumi.set(__self__, "resource_type", 'resourceGroups')
        pulumi.set(__self__, "target_resource_name", target_resource_name)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Input[str]:
        """
        The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
        Expected value is 'resourceGroups'.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter(name="targetResourceName")
    def target_resource_name(self) -> pulumi.Input[str]:
        """
        Gets or sets the target Resource name.
        """
        return pulumi.get(self, "target_resource_name")

    @target_resource_name.setter
    def target_resource_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_resource_name", value)


@pulumi.input_type
class SqlDatabaseResourceSettingsArgs:
    def __init__(__self__, *,
                 resource_type: pulumi.Input[str],
                 target_resource_name: pulumi.Input[str],
                 zone_redundant: Optional[pulumi.Input[Union[str, 'ZoneRedundant']]] = None):
        """
        Defines the Sql Database resource settings.
        :param pulumi.Input[str] resource_type: The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
               Expected value is 'Microsoft.Sql/servers/databases'.
        :param pulumi.Input[str] target_resource_name: Gets or sets the target Resource name.
        :param pulumi.Input[Union[str, 'ZoneRedundant']] zone_redundant: Defines the zone redundant resource setting.
        """
        pulumi.set(__self__, "resource_type", 'Microsoft.Sql/servers/databases')
        pulumi.set(__self__, "target_resource_name", target_resource_name)
        if zone_redundant is not None:
            pulumi.set(__self__, "zone_redundant", zone_redundant)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Input[str]:
        """
        The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
        Expected value is 'Microsoft.Sql/servers/databases'.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter(name="targetResourceName")
    def target_resource_name(self) -> pulumi.Input[str]:
        """
        Gets or sets the target Resource name.
        """
        return pulumi.get(self, "target_resource_name")

    @target_resource_name.setter
    def target_resource_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_resource_name", value)

    @property
    @pulumi.getter(name="zoneRedundant")
    def zone_redundant(self) -> Optional[pulumi.Input[Union[str, 'ZoneRedundant']]]:
        """
        Defines the zone redundant resource setting.
        """
        return pulumi.get(self, "zone_redundant")

    @zone_redundant.setter
    def zone_redundant(self, value: Optional[pulumi.Input[Union[str, 'ZoneRedundant']]]):
        pulumi.set(self, "zone_redundant", value)


@pulumi.input_type
class SqlElasticPoolResourceSettingsArgs:
    def __init__(__self__, *,
                 resource_type: pulumi.Input[str],
                 target_resource_name: pulumi.Input[str],
                 zone_redundant: Optional[pulumi.Input[Union[str, 'ZoneRedundant']]] = None):
        """
        Defines the Sql ElasticPool resource settings.
        :param pulumi.Input[str] resource_type: The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
               Expected value is 'Microsoft.Sql/servers/elasticPools'.
        :param pulumi.Input[str] target_resource_name: Gets or sets the target Resource name.
        :param pulumi.Input[Union[str, 'ZoneRedundant']] zone_redundant: Defines the zone redundant resource setting.
        """
        pulumi.set(__self__, "resource_type", 'Microsoft.Sql/servers/elasticPools')
        pulumi.set(__self__, "target_resource_name", target_resource_name)
        if zone_redundant is not None:
            pulumi.set(__self__, "zone_redundant", zone_redundant)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Input[str]:
        """
        The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
        Expected value is 'Microsoft.Sql/servers/elasticPools'.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter(name="targetResourceName")
    def target_resource_name(self) -> pulumi.Input[str]:
        """
        Gets or sets the target Resource name.
        """
        return pulumi.get(self, "target_resource_name")

    @target_resource_name.setter
    def target_resource_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_resource_name", value)

    @property
    @pulumi.getter(name="zoneRedundant")
    def zone_redundant(self) -> Optional[pulumi.Input[Union[str, 'ZoneRedundant']]]:
        """
        Defines the zone redundant resource setting.
        """
        return pulumi.get(self, "zone_redundant")

    @zone_redundant.setter
    def zone_redundant(self, value: Optional[pulumi.Input[Union[str, 'ZoneRedundant']]]):
        pulumi.set(self, "zone_redundant", value)


@pulumi.input_type
class SqlServerResourceSettingsArgs:
    def __init__(__self__, *,
                 resource_type: pulumi.Input[str],
                 target_resource_name: pulumi.Input[str]):
        """
        Defines the SQL Server resource settings.
        :param pulumi.Input[str] resource_type: The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
               Expected value is 'Microsoft.Sql/servers'.
        :param pulumi.Input[str] target_resource_name: Gets or sets the target Resource name.
        """
        pulumi.set(__self__, "resource_type", 'Microsoft.Sql/servers')
        pulumi.set(__self__, "target_resource_name", target_resource_name)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Input[str]:
        """
        The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
        Expected value is 'Microsoft.Sql/servers'.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter(name="targetResourceName")
    def target_resource_name(self) -> pulumi.Input[str]:
        """
        Gets or sets the target Resource name.
        """
        return pulumi.get(self, "target_resource_name")

    @target_resource_name.setter
    def target_resource_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_resource_name", value)


@pulumi.input_type
class SubnetReferenceArgs:
    def __init__(__self__, *,
                 source_arm_resource_id: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None):
        """
        Defines reference to subnet.
        :param pulumi.Input[str] source_arm_resource_id: Gets the ARM resource ID of the tracked resource being referenced.
        :param pulumi.Input[str] name: Gets the name of the proxy resource on the target side.
        """
        pulumi.set(__self__, "source_arm_resource_id", source_arm_resource_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="sourceArmResourceId")
    def source_arm_resource_id(self) -> pulumi.Input[str]:
        """
        Gets the ARM resource ID of the tracked resource being referenced.
        """
        return pulumi.get(self, "source_arm_resource_id")

    @source_arm_resource_id.setter
    def source_arm_resource_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_arm_resource_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Gets the name of the proxy resource on the target side.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class SubnetResourceSettingsArgs:
    def __init__(__self__, *,
                 address_prefix: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_security_group: Optional[pulumi.Input['NsgReferenceArgs']] = None):
        """
        Defines the virtual network subnets resource settings.
        :param pulumi.Input[str] address_prefix: Gets or sets address prefix for the subnet.
        :param pulumi.Input[str] name: Gets or sets the Subnet name.
        :param pulumi.Input['NsgReferenceArgs'] network_security_group: Defines reference to NSG.
        """
        if address_prefix is not None:
            pulumi.set(__self__, "address_prefix", address_prefix)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_security_group is not None:
            pulumi.set(__self__, "network_security_group", network_security_group)

    @property
    @pulumi.getter(name="addressPrefix")
    def address_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets address prefix for the subnet.
        """
        return pulumi.get(self, "address_prefix")

    @address_prefix.setter
    def address_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address_prefix", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the Subnet name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkSecurityGroup")
    def network_security_group(self) -> Optional[pulumi.Input['NsgReferenceArgs']]:
        """
        Defines reference to NSG.
        """
        return pulumi.get(self, "network_security_group")

    @network_security_group.setter
    def network_security_group(self, value: Optional[pulumi.Input['NsgReferenceArgs']]):
        pulumi.set(self, "network_security_group", value)


@pulumi.input_type
class VirtualMachineResourceSettingsArgs:
    def __init__(__self__, *,
                 resource_type: pulumi.Input[str],
                 target_resource_name: pulumi.Input[str],
                 target_availability_set_id: Optional[pulumi.Input[str]] = None,
                 target_availability_zone: Optional[pulumi.Input[Union[str, 'TargetAvailabilityZone']]] = None,
                 target_vm_size: Optional[pulumi.Input[str]] = None):
        """
        Gets or sets the virtual machine resource settings.
        :param pulumi.Input[str] resource_type: The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
               Expected value is 'Microsoft.Compute/virtualMachines'.
        :param pulumi.Input[str] target_resource_name: Gets or sets the target Resource name.
        :param pulumi.Input[str] target_availability_set_id: Gets or sets the target availability set id for virtual machines not in an availability set at source.
        :param pulumi.Input[Union[str, 'TargetAvailabilityZone']] target_availability_zone: Gets or sets the target availability zone.
        :param pulumi.Input[str] target_vm_size: Gets or sets the target virtual machine size.
        """
        pulumi.set(__self__, "resource_type", 'Microsoft.Compute/virtualMachines')
        pulumi.set(__self__, "target_resource_name", target_resource_name)
        if target_availability_set_id is not None:
            pulumi.set(__self__, "target_availability_set_id", target_availability_set_id)
        if target_availability_zone is not None:
            pulumi.set(__self__, "target_availability_zone", target_availability_zone)
        if target_vm_size is not None:
            pulumi.set(__self__, "target_vm_size", target_vm_size)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Input[str]:
        """
        The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
        Expected value is 'Microsoft.Compute/virtualMachines'.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter(name="targetResourceName")
    def target_resource_name(self) -> pulumi.Input[str]:
        """
        Gets or sets the target Resource name.
        """
        return pulumi.get(self, "target_resource_name")

    @target_resource_name.setter
    def target_resource_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_resource_name", value)

    @property
    @pulumi.getter(name="targetAvailabilitySetId")
    def target_availability_set_id(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the target availability set id for virtual machines not in an availability set at source.
        """
        return pulumi.get(self, "target_availability_set_id")

    @target_availability_set_id.setter
    def target_availability_set_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_availability_set_id", value)

    @property
    @pulumi.getter(name="targetAvailabilityZone")
    def target_availability_zone(self) -> Optional[pulumi.Input[Union[str, 'TargetAvailabilityZone']]]:
        """
        Gets or sets the target availability zone.
        """
        return pulumi.get(self, "target_availability_zone")

    @target_availability_zone.setter
    def target_availability_zone(self, value: Optional[pulumi.Input[Union[str, 'TargetAvailabilityZone']]]):
        pulumi.set(self, "target_availability_zone", value)

    @property
    @pulumi.getter(name="targetVmSize")
    def target_vm_size(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the target virtual machine size.
        """
        return pulumi.get(self, "target_vm_size")

    @target_vm_size.setter
    def target_vm_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_vm_size", value)


@pulumi.input_type
class VirtualNetworkResourceSettingsArgs:
    def __init__(__self__, *,
                 resource_type: pulumi.Input[str],
                 target_resource_name: pulumi.Input[str],
                 address_space: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enable_ddos_protection: Optional[pulumi.Input[bool]] = None,
                 subnets: Optional[pulumi.Input[Sequence[pulumi.Input['SubnetResourceSettingsArgs']]]] = None):
        """
        Defines the virtual network resource settings.
        :param pulumi.Input[str] resource_type: The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
               Expected value is 'Microsoft.Network/virtualNetworks'.
        :param pulumi.Input[str] target_resource_name: Gets or sets the target Resource name.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] address_space: Gets or sets the address prefixes for the virtual network.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_servers: Gets or sets DHCPOptions that contains an array of DNS servers available to VMs
               deployed in the virtual network.
        :param pulumi.Input[bool] enable_ddos_protection: Gets or sets a value indicating whether gets or sets whether the
               DDOS protection should be switched on.
        :param pulumi.Input[Sequence[pulumi.Input['SubnetResourceSettingsArgs']]] subnets: Gets or sets List of subnets in a VirtualNetwork.
        """
        pulumi.set(__self__, "resource_type", 'Microsoft.Network/virtualNetworks')
        pulumi.set(__self__, "target_resource_name", target_resource_name)
        if address_space is not None:
            pulumi.set(__self__, "address_space", address_space)
        if dns_servers is not None:
            pulumi.set(__self__, "dns_servers", dns_servers)
        if enable_ddos_protection is not None:
            pulumi.set(__self__, "enable_ddos_protection", enable_ddos_protection)
        if subnets is not None:
            pulumi.set(__self__, "subnets", subnets)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Input[str]:
        """
        The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
        Expected value is 'Microsoft.Network/virtualNetworks'.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter(name="targetResourceName")
    def target_resource_name(self) -> pulumi.Input[str]:
        """
        Gets or sets the target Resource name.
        """
        return pulumi.get(self, "target_resource_name")

    @target_resource_name.setter
    def target_resource_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_resource_name", value)

    @property
    @pulumi.getter(name="addressSpace")
    def address_space(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Gets or sets the address prefixes for the virtual network.
        """
        return pulumi.get(self, "address_space")

    @address_space.setter
    def address_space(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "address_space", value)

    @property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Gets or sets DHCPOptions that contains an array of DNS servers available to VMs
        deployed in the virtual network.
        """
        return pulumi.get(self, "dns_servers")

    @dns_servers.setter
    def dns_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "dns_servers", value)

    @property
    @pulumi.getter(name="enableDdosProtection")
    def enable_ddos_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        Gets or sets a value indicating whether gets or sets whether the
        DDOS protection should be switched on.
        """
        return pulumi.get(self, "enable_ddos_protection")

    @enable_ddos_protection.setter
    def enable_ddos_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_ddos_protection", value)

    @property
    @pulumi.getter
    def subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SubnetResourceSettingsArgs']]]]:
        """
        Gets or sets List of subnets in a VirtualNetwork.
        """
        return pulumi.get(self, "subnets")

    @subnets.setter
    def subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SubnetResourceSettingsArgs']]]]):
        pulumi.set(self, "subnets", value)


